<?php

// StreamerCop c/o Stefano Riva
// StreamerCop checks that every ingested content is copied correctly after the datastore's resync and verifies it.

// Started on 28/10/2019 @ v 1.0
// Updated on 13/11/2019 @ v 1.1 { La verifica ora ignora gli asset mancanti dall'assetmap ( status = 2 aka warning ) a patto che trovi almeno una PKL. Dopodichè, la PKL viene prima passata per verificare che contenga la CPL di riferimento del record di clips altirmenti non viene presa in carico. A questo punto, trovata la PKL con la CPL, viene passata la CPL e vengono controllati che gli asset della CPL siano nell'assetmap e che siano su disco. Se non viene trovata una PKL contentente questa CPL, la funzione ritorna "pkl not found" o l'errore a riguardo qualunque sia.. }

// Updated on 25/11/2019 @ v 1.2  { La verifica ora controlla tutta la root del film (se disponibile nel campo Props di m_dcp) per cercare inanzitutto di risolvere una UUID della CPL che non è stato possibile risolvere nel suo assetmap e dopodichè, cerca il file e ne verifica le dimensioni. }
// Updated on 03/02/2020 @ v 1.2b { Il ciclo principale ora dura soltato 20 cicli, poi esce e viene automaticamente rilanciato come servizio da linux }.
// Quick Update il 15/07/2020 @ v 1.3 [ Modificata la funzione parseCPLContent, verrà utilizzata una regex per rimuovere tutti gli indici <*:indice> e </*:indice> che rendevano l'individuazione dei reel nelle cpl difficile da parte del Processo IDCP. ]
// Quick Update il 20/07/2020 @ v 1.3a [ Ridefinita la Regex contenuta in parseCPLContent rispetto alla versione precedente ]
// Quick Update il 15/10/2020 @ v 1.3b [ Aggiunto ClosedCaption nelle CPL grazie al film di Totti ]

// Aggiornato alla 1.4 includendolo ufficialmente all'interno di StreamerV2


include(__DIR__ . "/db_connection.php");


// verifico se ci sia già uno streamercop attivo, almeno per questo server, e non avvio questo ulteriormente in caso già vi sia qualcosa in funzione.
//if( VERIFY_ACTIVE_TASKS($db , 1) )
//  exit;

// versione StreamerCop;
$streamerCopVERSION = "1.4";


// LIMITE DI INGEST CONTROLLATI ALLA VOLTA
$limit = 1;
// TEMPO DI SLEEP TRA UNA PROCESSATA E L'ALTRA DEL WHILE PRIMARIO (IN SECONDI)
$timerCheck = 2;
// NUMERO DI TIME RESCHEDULE PER IL VERIFY
$hoursTimeOutCheck = 256;


//$this_running_datastore = $_SERVER['SERVER_ADDR'];


// variabili da db
/*$queryDatastore = mysqli_query($db,"SELECT STRING_VALUE FROM m_setup WHERE KEY1 = 'CINEMONITOR' AND KEY2='DATASTORE' ");
if($assocDatastore = mysqli_fetch_assoc($queryDatastore)){

  $datastore_path = $assocDatastore['STRING_VALUE'];

} else {*/

  $datastore_path = "/datastore/"; // datastore default per il nostro sistema se non venisse trovato il record di setup.

//}

// rendo ufficiale il running nel db
//mysqli_query($db,"UPDATE streamercop SET Status = 'RUNNING' WHERE ID='".$_SESSION['STREAMER_COP_ID']."'");

$arrayReelType = array( 0 => "MainPicture" , 1 => "MainSound" , 2 => "MainSubtitle" , 3 => "MainStereoscopicPicture" , 4 => "AuxData" , 5 => "ClosedCaption" );

echo "inizio.".PHP_EOL;

for($counter_cycle = 0; $counter_cycle < 1; $counter_cycle++){ // START MAIN WHILE

  /*
  // creo il timestamp
  if(!file_exists("./timestamp.cop")){

    file_put_contents("./timestamp.cop" , '');

  }

  $currentTimestamp = file_get_contents("./timestamp.cop");


  // auto riavvio alle 4 di notte
  if(date('H:i') >= "04:00" && $currentTimestamp != date('Ymd')){

    file_put_contents("./timestamp.cop" , date('Ymd'));
    //system('echo NbdkMiZBMPdxnxJo | /usr/bin/sudo -S systemctl restart StreamerVerify'); // riavvio il servizio

  }
  */

  $streamerCop_Log = "";

//  echo "INIZIO LOOP".PHP_EOL;

  $getTasks = mysqli_query($db,"SELECT a.* , b.address, b.username , b.password FROM m_streamercop_verify a LEFT JOIN m_datastores b on b.name = a.datastore_name WHERE a.datefrom < NOW() AND a.progress = 'TOVERIFY' LIMIT ".$limit);


  $currentMaxQueue = mysqli_num_rows($getTasks);
  $indexQueue = 0;

  if(mysqli_num_rows($getTasks) == 0){

    //$streamerCop_Log .= "[ ".date('Y-m-d H:i:s')." ] No new verification processes found. Waiting... ".PHP_EOL;
    sleep(1); // dormo solo se non ho task.
    continue;

  }

  while($main = mysqli_fetch_array($getTasks)){

    echo $main['folder'].PHP_EOL;

    $indexQueue++;
    $status_xml = new SimpleXMLElement('<cpl_status/>');
    $header = $status_xml -> addChild('header');
    $header_child = $header -> addChild('verified_by' , 'StreamerCop');
    $header_child = $header -> addChild('version' , $streamerCopVERSION);
    $header_child = $header -> addChild('date' , date('Y-m-d H:i:s'));

    // questa variabile, se true, salta ogni break\continue nei check files per raccogliere quante più informazioni sulla clip in errore,
    // ovviamente, sempre se e solo se il datastore dovesse risultare raggiungibile in primis.
    $ERROR_EXEPTION_REPORT = FALSE;

    if($main['error'] == $hoursTimeOutCheck){

      // ultimo ciclo del check error, setto la variabile per il debug completo.
      $ERROR_EXEPTION_REPORT = TRUE;

    }

    if( $main['queued'] == '0' ){

      // aggiorno e metto il record in "coda"
      mysqli_query($db,"UPDATE m_streamercop_verify SET queued = '1' , progress = 'VERIFYING' WHERE id = '".$main['id']."'");
      $streamerCop_Log .= "[ ".date('Y-m-d H:i:s')." ] (".$indexQueue."/".$currentMaxQueue.") New clip Queued @ Position ".$indexQueue." -> ID ".$main['id']." (table clips) , uuid CPL ".$main['uuid']." serial\label Datastore ".$main['datastore_name'].PHP_EOL;

    }

    // RESETTO IL CURRENTASSETMAP x salvare memoria.. e le altre variabili
    $currentASSETMAP = "";
    $xmlObj = "";
    $assetmap_array = array();
    $PKLContent = "";
    $XML_PKL = "";

    $streamerCop_Log .= "[ ".date('Y-m-d H:i:s')." ] (".$indexQueue."/".$currentMaxQueue.") Currently processing -> ID ".$main['id']." (table clips) , uuid CPL ".$main['uuid']." serial\label Datastore ".$main['datastore_name'].PHP_EOL;

       // mi connetto..
      if( !$connection = ssh2_connect($main['address'], 22) ){

        //verifyTimeoutTask($db , $main['id'] , $main['datefrom'] , $hoursTimeOutCheck , $main['error'] , $status_xml);
        // CONNESSIONE IN SSH2 FALLITA
        $status_xml_child = $status_xml -> addChild('datastore_ping' , '0');
        $status_xml_child = $status_xml -> addChild('ssh2_connection' , '0');
        $streamerCop_Log .= "[ ".date('Y-m-d H:i:s')." ] (".$indexQueue."/".$currentMaxQueue.") ".$main['datastore_name']." @ ".$main['address']." : Connection failed ... verification process paused for this CPL".PHP_EOL;

        verifyTimeoutTask($db , $main['id'] , $main['datefrom'] , $hoursTimeOutCheck , $main['error'] , $status_xml);
        continue;

      } else {

        $status_xml_child = $status_xml -> addChild('datastore_ping' , '1');
        $status_xml_child = $status_xml -> addChild('ssh2_connection' , '1');

      }


      if(!@ssh2_auth_password($connection, $main['username'], $main['password'])){

        $status_xml_child = $status_xml -> addChild('ssh2_auth' , '0');
        $streamerCop_Log .= "[ ".date('Y-m-d H:i:s')." ] (".$indexQueue."/".$currentMaxQueue.") ".$main['datastore_name']." @ ".$main['address']." : Login Failed using ".$main['username']."@".$main['password']." ... verification process paused for this CPL".PHP_EOL;

        verifyTimeoutTask($db , $main['id'] , $main['datefrom'] , $hoursTimeOutCheck , $main['error'] , $status_xml);
        continue;

      } else {

        $status_xml_child = $status_xml -> addChild('ssh2_auth' , '1');

      }



      $sftp = ssh2_sftp($connection);
      $sftp_fd = intval($sftp);

      echo "ssh2.sftp://$sftp_fd//".$datastore_path."/".$main['folder'].PHP_EOL;

      if( !$folderArray = scandir("ssh2.sftp://$sftp_fd//".$datastore_path."/".$main['folder']) ){

      echo "ssh2.sftp://$sftp_fd//".$datastore_path."/".$main['folder'].PHP_EOL;

      $streamerCop_Log .= "[ ".date('Y-m-d H:i:s')." ] (".$indexQueue."/".$currentMaxQueue.") ".$main['datastore_name']." @ ".$main['address']." : Could't find CPL Folder /".$datastore_path."/".$main['folder']." ... verification process paused for this CPL".PHP_EOL;
      $status_xml_child = $status_xml -> addChild('cpl_folder' , '0');

      verifyTimeoutTask($db , $main['id'] , $main['datefrom'] , $hoursTimeOutCheck , $main['error'] , $status_xml);
      continue; // LA CARTELLA NON ESISTE ANCORA SUL SERVER..... SALTO

    } else {

      $status_xml_child = $status_xml -> addChild('cpl_folder' , '1');

    }


      // la cartella esiste.
      $IS_DCP_VERIFIED = TRUE; // LA DCP ENTRA COME VALIDA, SE UN SOLO FILE NON FOSSE PRESENTE O NON VALIDO, VIENE MARKATA COME NON VERIFIED

      for($inner = 0; $inner < count($folderArray); $inner ++ ){

        if( $folderArray[$inner]=='.' || $folderArray[$inner]=='..')
          continue; // skippo i dots.

          // SICCOME LA DCP è STATA LINKATA GIà SUL PRIMARIO, SIGNIFICA CHE OGNI RELAZIONE DELLA DCP TRA ASSETMAP\CPL\PKL è STATA VERIFICATA.
          // quello che bisogna fare per gli altri datastore è quindi controllare che tutti i file dell'assetmap siano stati copiati.

          // CERCO L'ASSETMAP
          if(strpos( strtoupper($folderArray[$inner]) , 'ASSETMAP') !== false){

            if(!$currentASSETMAP = file_get_contents("ssh2.sftp://$sftp_fd//".$datastore_path."/".$main['folder']."/".$folderArray[$inner])){

              // l'assetmap non può ancora essere letto.. aspetto..
              $streamerCop_Log .= "[ ".date('Y-m-d H:i:s')." ] (".$indexQueue."/".$currentMaxQueue.") ".$main['datastore_name']." @ ".$main['address']." : Could't read content of the ASSETMAP in /".$datastore_path."/".$main['folder']."/".$folderArray[$inner]." ... verification process paused for this CPL".PHP_EOL;
              $status_xml_child = $status_xml -> addChild('assetmap' , '0');
              verifyTimeoutTask($db , $main['id'] , $main['datefrom'] , $hoursTimeOutCheck , $main['error'] , $status_xml);
              continue;

            } else {

              $streamerCop_Log .= "[ ".date('Y-m-d H:i:s')." ] (".$indexQueue."/".$currentMaxQueue.") ".$main['datastore_name']." @ ".$main['address']." : ASSETMAP found and parsed in /".$datastore_path."/".$main['folder']."/".$folderArray[$inner]." ".PHP_EOL;
              $status_xml_child = $status_xml -> addChild('assetmap' , str_replace( '//' , '/' , "/".$datastore_path."/".$main['folder']."/".$folderArray[$inner]) );

            }

          }

      }




      if(empty($currentASSETMAP)){

        // L'assetmap non è ancora stato copiato o non esiste... skippo il controllo o aggiungo un check size degli altri files per verificare se sta incrementando o meno al prossimo ciclo.
        $streamerCop_Log .= "[ ".date('Y-m-d H:i:s')." ] (".$indexQueue."/".$currentMaxQueue.") ".$main['datastore_name']." @ ".$main['address']." : Couldn't find the ASSETMAP in /".$datastore_path."/".$main['folder']." ... verification process paused for this CPL".PHP_EOL;

        $status_xml_child = $status_xml -> addChild('assetmap_readable' , '0');

        verifyTimeoutTask($db , $main['id'] , $main['datefrom'] , $hoursTimeOutCheck , $main['error'] , $status_xml);
        continue;

      } else {

        $status_xml_child = $status_xml -> addChild('assetmap_readable' , '1');

      }

      $xmlObj = simplexml_load_string($currentASSETMAP, 'SimpleXMLElement' , LIBXML_NOBLANKS);

      if(!$xmlObj->getName()=="AssetMap"){

        $status_xml_child = $status_xml -> addChild('assetmap_valid_header' , '0');

        verifyTimeoutTask($db , $main['id'] , $main['datefrom'] , $hoursTimeOutCheck , $main['error'] , $status_xml);
        // non è un assetmap... strano.. errore..
        $streamerCop_Log .= "[ ".date('Y-m-d H:i:s')." ] (".$indexQueue."/".$currentMaxQueue.") ".$main['datastore_name']." @ ".$main['address']." :Invalid ASSETMAP Header found in /".$datastore_path."/".$main['folder']." ... verification process paused for this CPL".PHP_EOL;
        continue;

      } else {

        $status_xml_child = $status_xml -> addChild('assetmap_valid_header' , '1');

      }

      $assetmap_array = rework_array_assetmap($currentASSETMAP); // ottengo il contenuto dell'assetmap in array...

      // passo gli elementi dell'assetmap (tutti gli elementi di questa DCP) e mi salvo le PKL
      $currentPKL_array=array();

      $assetmap_UUID_to_FILE = array(); // ARRAY DI CONVERSIONE UUID > FILENAME per le PKL

      $pklIndex = 0;

      $files_status = $status_xml -> addChild('ASSETMAP');

      for($asset = 0; $asset < count($assetmap_array['AssetList']['Asset']); $asset++){

        $filename_current = str_replace("file:///" , '' , $assetmap_array['AssetList']['Asset'][$asset]['ChunkList']['Chunk']['Path']);
        $filename_current = str_replace("file://" , '' , $filename_current);
        //$filename_current = str_replace("/" , '//' , $filename_current);

        // VERIFICO CHE IL FILE ESISTA
        if( !@ssh2_sftp_stat( $sftp , "//".$datastore_path."/".$main['folder']."/".$filename_current) ){

          $streamerCop_Log .= "[ ".date('Y-m-d H:i:s')." ] (".$indexQueue."/".$currentMaxQueue.") ".$main['datastore_name']." @ ".$main['address']." : [X] //".$datastore_path."/".$main['folder']."/".$filename_current." Missing File ... verification process paused for this CPL".PHP_EOL;
          //$IS_DCP_VERIFIED = FALSE;

          $current_file = $files_status -> addChild('asset');
          $inner = $current_file -> addChild('filename' , str_replace( '//' , '/' , "/".$datastore_path."/".$main['folder']."/".$filename_current ) );
          $inner = $current_file -> addChild('uuid' , $assetmap_array['AssetList']['Asset'][$asset]['Id']);
          $inner = $current_file -> addChild('status' , '2');

          verifyTimeoutTask($db , $main['id'] , $main['datefrom'] , $hoursTimeOutCheck , $main['error'] , $status_xml);

          //if( $ERROR_EXEPTION_REPORT == false)
          //  break;

          // manca un file!

        } else {

          $current_file = $files_status -> addChild('asset');
          $inner = $current_file -> addChild('filename' , str_replace( '//' , '/' , "/".$datastore_path."/".$main['folder']."/".$filename_current ) );
          $inner = $current_file -> addChild('uuid' , $assetmap_array['AssetList']['Asset'][$asset]['Id']);
          $inner = $current_file -> addChild('status' , '1');


        }

        if(isset($assetmap_array['AssetList']['Asset'][$asset]['PackingList'])){ // verifico che sia una PKL

            $currentPKL_array[$pklIndex] = $filename_current; // aggiungo la PKL nell'array delle PKL
            $pklIndex++;
            // loggo la pkl trovata
            $streamerCop_Log .= "[ ".date('Y-m-d H:i:s')." ] (".$indexQueue."/".$currentMaxQueue.") ".$main['datastore_name']." @ ".$main['address']." : [OK] //".$datastore_path."/".$main['folder']."/".$filename_current." [PKL FOUND]".PHP_EOL;

        } else {

          // loggo il file trovato (mxf,sottotiolo,cpl)
          $streamerCop_Log .= "[ ".date('Y-m-d H:i:s')." ] (".$indexQueue."/".$currentMaxQueue.") ".$main['datastore_name']." @ ".$main['address']." : [OK] //".$datastore_path."/".$main['folder']."/".$filename_current." ".PHP_EOL;

        }

        // CREO L'ARRAY DI CONVERSIONE
        $assetmap_UUID_to_FILE[ $assetmap_array['AssetList']['Asset'][$asset]['Id'] ] = $filename_current;

      }


      if($IS_DCP_VERIFIED == FALSE && $ERROR_EXEPTION_REPORT == false) // SE UN FILE MANCASSE, è INUTILE PROCEDERE AL CHECK DEL FILESIZE, SI PASSA ALLA DCP DOPO.
        continue;


      $streamerCop_Log .= "[ ".date('Y-m-d H:i:s')." ] (".$indexQueue."/".$currentMaxQueue.") ".$main['datastore_name']." @ ".$main['address']." : Process will now verify the sizes for //".$datastore_path."/".$main['folder']."// ".PHP_EOL;


      if($pklIndex == 0){

        // NON è STATA TROVATA NESSUNA PKL... ERRORE!
        $streamerCop_Log .= "[ ".date('Y-m-d H:i:s')." ] (".$indexQueue."/".$currentMaxQueue.") ".$main['datastore_name']." @ ".$main['address']." : Process couldn't find a PKL in //".$datastore_path."/".$main['folder']."// ... verification process paused for this CPL".PHP_EOL;
        $status_xml_child = $status_xml -> addChild('pkl_status' , '0');

        verifyTimeoutTask($db , $main['id'] , $main['datefrom'] , $hoursTimeOutCheck , $main['error'] , $status_xml);
        continue;

      } else {

        $status_xml_child = $status_xml -> addChild('pkl_status' , '1');

      }


      $filesize_child = $status_xml -> addChild('pkl_assetlist');


      $WAS_PKL_PARSED = FALSE;

      //print_r($currentPKL_array);

      $PKL_UUID_SIZE = array();

      // PASSO TUTTE LE PKL TROVATE NELL'ASSETMAP IN ESAME.
      for($pkl_counter = 0; $pkl_counter < count($currentPKL_array); $pkl_counter++){

        if(!@ssh2_sftp_stat($sftp , $datastore_path."/".$main['folder']."/".$currentPKL_array[$pkl_counter])){

          $streamerCop_Log .= "[ ".date('Y-m-d H:i:s')." ] (".$indexQueue."/".$currentMaxQueue.") ".$main['datastore_name']." @ ".$main['address']." : [X] ".$currentPKL_array[$pkl_counter]." PKL Not found in the CPL folder ... verification process paused for this CPL".PHP_EOL;
          continue;

        }

        $PKLContent = file_get_contents("ssh2.sftp://$sftp_fd//".$datastore_path."/".$main['folder']."/".$currentPKL_array[$pkl_counter]);
        $xmlObj = simplexml_load_string($PKLContent, 'SimpleXMLElement' , LIBXML_NOBLANKS);
        $XML_PKL = objectsIntoArray($xmlObj);

        $arrayCPL = array();
        $indexCPL = 0;

        //print_r($XML_PKL);

        $WAS_PKL_PARSED = TRUE;


        // verifico solo se ci sta l'uuid della CPL qua dentro...
        $found_cpl = false;

        for($check_p = 0; $check_p < count( $XML_PKL['AssetList']['Asset'] ); $check_p++){

          if($XML_PKL['AssetList']['Asset'][$check_p]['Id'] == $main['uuid'])
            $found_cpl = true;

        }

        // se la cpl non è in questa PKL skippo il controllo
        if($found_cpl == false)
          continue;

        // array che se contiene la UUID del file significa che fa parte di questa PKL e contiene la sua dimensione originale e quella identificata su disco
        // per quando lo andremo a confrontare con i file della singola CPL.

      for ($inner_pkl = 0; $inner_pkl < count( $XML_PKL['AssetList']['Asset'] ); $inner_pkl++){

          $filesize_asset = $filesize_child -> addChild('asset');

          $IS_CPL_IN = false;

          if(!isset( $assetmap_UUID_to_FILE[ $XML_PKL['AssetList']['Asset'][$inner_pkl]['Id'] ] )){

            $streamerCop_Log .= "[ ".date('Y-m-d H:i:s')." ] (".$indexQueue."/".$currentMaxQueue.") ".$main['datastore_name']." @ ".$main['address']." : [X] [? / ?] ".$XML_PKL['AssetList']['Asset'][$inner_pkl]['Id']." Unknown PKL uuid reference (WARNING)".PHP_EOL;

            //$IS_DCP_VERIFIED = false;

            $PKL_UUID_SIZE[$XML_PKL['AssetList']['Asset'][$inner_pkl]['Id']]['OriginalSize'] = 0;
            $PKL_UUID_SIZE[$XML_PKL['AssetList']['Asset'][$inner_pkl]['Id']]['DatastoreSize'] = 0;
            $PKL_UUID_SIZE[$XML_PKL['AssetList']['Asset'][$inner_pkl]['Id']]['Status'] = '0';

            // MISSING PKL REFERENCE...
            $elem_pkl = $filesize_asset -> addChild('filename' , '');
            $elem_pkl = $filesize_asset -> addChild('uuid' , $XML_PKL['AssetList']['Asset'][$inner_pkl]['Id'] );
            $elem_pkl = $filesize_asset -> addChild('status' , '0');
            $elem_pkl = $filesize_asset -> addChild('original_filesize' , '0');
            $elem_pkl = $filesize_asset -> addChild('datastore_filesize' , '0');
            $elem_pkl = $filesize_asset -> addChild('error' , 'UNKNOWN_ASSET_REFERENCE');

            continue;

            //if($ERROR_EXEPTION_REPORT == false)
            //  break;

          }

          // mi salvo il filename in una variabile temporanea per comodità
          $temp_filename = $assetmap_UUID_to_FILE[ $XML_PKL['AssetList']['Asset'][$inner_pkl]['Id'] ];

          $filesize_bytes = $XML_PKL['AssetList']['Asset'][$inner_pkl]['Size']; // prendo il filesize dichiarato nella PKL

          $filesizeFILE = @ssh2_sftp_stat($sftp , "//".$datastore_path."/".$main['folder']."/".$temp_filename );

          if(!isset($filesizeFILE['size'])) // se non ritornasse un filesize significa che non esiste.. strano.. ma è così.
            $filesizeFILE['size'] = 0;

          // verifico il campo original filename..
          if(isset($XML_PKL['AssetList']['Asset'][$inner_pkl]['OriginalFileName']))
            $original_file_name = $XML_PKL['AssetList']['Asset'][$inner_pkl]['OriginalFileName'];
          else
            $original_file_name = '';



          // controllo se sia una CPL
          if( strpos( strtoupper( $XML_PKL['AssetList']['Asset'][$inner_pkl]['Type'] ) , 'CPL' ) !== false || strpos( strtoupper( $XML_PKL['AssetList']['Asset'][$inner_pkl]['Type'] ) , 'TEXT/XML' ) !== false ){

            // testo che sia una CPL

            // non ha trovato questa CPL
            if(@!ssh2_sftp_stat($sftp , $datastore_path."/".$main['folder']."/".$temp_filename)){

              $PKL_UUID_SIZE[$XML_PKL['AssetList']['Asset'][$inner_pkl]['Id']]['OriginalSize'] = 0;
              $PKL_UUID_SIZE[$XML_PKL['AssetList']['Asset'][$inner_pkl]['Id']]['DatastoreSize'] = 0;
              $PKL_UUID_SIZE[$XML_PKL['AssetList']['Asset'][$inner_pkl]['Id']]['Status'] = '0';
              continue;

            }




            $CPL_TEST = file_get_contents( "ssh2.sftp://$sftp_fd//".$datastore_path."/".$main['folder']."/".$temp_filename );
            if(!empty($CPL_TEST)){

              $xmlTEST = simplexml_load_string($CPL_TEST, 'SimpleXMLElement' , LIBXML_NOBLANKS);
              if($xmlTEST->getName()=="CompositionPlaylist"){

                // è una CPL!
                $elem_pkl = $filesize_asset -> addChild('CPL' , 'true');
                $arrayCPL[$indexCPL] = $XML_PKL['AssetList']['Asset'][$inner_pkl]['Id']; // mi salvo l'uuid della CPL nell'array, mi prenderò il filename e path corretto dall'assetmap!
                $indexCPL ++;

                $IS_CPL_IN = true;

              }

            }

          } else {

            //echo strtoupper( $XML_PKL['AssetList']['Asset'][$inner_pkl]['Type'] ).PHP_EOL;

          }

          // c'è da commentare il controllo sulla dimensione della PKL e invece, mettersela in un array a UUID che ritorna il filesize OG, da verificare solo per la CPL da nascondere la PKL


          // CONFRONTO I FILESIZE, SE SONO DIVERSI, NON è ANCORA VALIDA...
          if( $filesizeFILE['size'] != $filesize_bytes ){

            $PKL_UUID_SIZE[$XML_PKL['AssetList']['Asset'][$inner_pkl]['Id']]['OriginalSize'] = $filesize_bytes;
            $PKL_UUID_SIZE[$XML_PKL['AssetList']['Asset'][$inner_pkl]['Id']]['DatastoreSize'] = $filesizeFILE['size'];
            $PKL_UUID_SIZE[$XML_PKL['AssetList']['Asset'][$inner_pkl]['Id']]['Status'] = '0';


            $elem_pkl = $filesize_asset -> addChild('filename' ,  str_replace( '//' , '/' , "/".$datastore_path."/".$main['folder']."/".$temp_filename ) );
            $elem_pkl = $filesize_asset -> addChild('status' , '0');
            $elem_pkl = $filesize_asset -> addChild('original_filesize' , $filesize_bytes);
            $elem_pkl = $filesize_asset -> addChild('datastore_filesize' , $filesizeFILE['size']);

            if($IS_CPL_IN == true){

                $IS_DCP_VERIFIED = false;

                if($ERROR_EXEPTION_REPORT == false)
                  continue;

            }

            /*
            $elem_pkl = $filesize_asset -> addChild('uuid' , $XML_PKL['AssetList']['Asset'][$inner_pkl]['Id'] );
            $elem_pkl = $filesize_asset -> addChild('status' , '0');
            $elem_pkl = $filesize_asset -> addChild('original_filesize' , $filesize_bytes);
            $elem_pkl = $filesize_asset -> addChild('datastore_filesize' , $filesizeFILE['size']);
            $elem_pkl = $filesize_asset -> addChild('error' , 'FILESIZES_NOT_MATCHING');

            $streamerCop_Log .= "[ ".date('Y-m-d H:i:s')." ] (".$indexQueue."/".$currentMaxQueue.") ".$main['datastore_name']." @ ".$main['address']." : [X] [".$filesizeFILE['size']." / ".$filesize_bytes."] /".$datastore_path."/".$main['folder']."/".$temp_filename." ... Filesizes are different! verification process paused for this CPL".PHP_EOL;
            $IS_DCP_VERIFIED = false;

            // different file_sizes....
            if($ERROR_EXEPTION_REPORT == false)
              break;
              */

          } else {

            // filesize OK

            $PKL_UUID_SIZE[$XML_PKL['AssetList']['Asset'][$inner_pkl]['Id']]['OriginalSize'] = $filesize_bytes;
            $PKL_UUID_SIZE[$XML_PKL['AssetList']['Asset'][$inner_pkl]['Id']]['DatastoreSize'] = $filesizeFILE['size'];
            $PKL_UUID_SIZE[$XML_PKL['AssetList']['Asset'][$inner_pkl]['Id']]['Status'] = '1';


            $elem_pkl = $filesize_asset -> addChild('filename' ,  str_replace( '//' , '/' , "/".$datastore_path."/".$main['folder']."/".$temp_filename ) );
            $elem_pkl = $filesize_asset -> addChild('status' , '1');
            $elem_pkl = $filesize_asset -> addChild('original_filesize' , $filesize_bytes);
            $elem_pkl = $filesize_asset -> addChild('datastore_filesize' , $filesizeFILE['size']);

            /*
            $elem_pkl = $filesize_asset -> addChild('uuid' , $XML_PKL['AssetList']['Asset'][$inner_pkl]['Id'] );
            $elem_pkl = $filesize_asset -> addChild('status' , '1');
            $elem_pkl = $filesize_asset -> addChild('original_filesize' , $filesize_bytes);
            $elem_pkl = $filesize_asset -> addChild('datastore_filesize' , $filesizeFILE['size']);
            $elem_pkl = $filesize_asset -> addChild('error' , '');

            $streamerCop_Log .= "[ ".date('Y-m-d H:i:s')." ] (".$indexQueue."/".$currentMaxQueue.") ".$main['datastore_name']." @ ".$main['address']." : [OK] [".$filesizeFILE['size']." / ".$filesize_bytes."] /".$datastore_path."/".$main['folder']."/".$temp_filename." [Filesize Matched]".PHP_EOL;
            */

          }


        }

        if($indexCPL == 0){

          // NESSUNA CPL TROVATA NELLA PKL????
          // Qualcosa non va.....
          $cpl_status = $filesize_child -> addChild('cpl_count' , 0);
          $IS_DCP_VERIFIED = false;
          verifyTimeoutTask($db , $main['id'] , $main['datefrom'] , $hoursTimeOutCheck , $main['error'] , $status_xml);


          if($ERROR_EXEPTION_REPORT == false)
            continue;

        } else {

          $cpl_status = $filesize_child -> addChild('cpl_count' , $indexCPL);

        }

        // MI SALVO LE CPL TROVATE NELLA PKL E VERIFICO I FILE ANCHE DELLE CPL!

        for($cc = 0; $cc < $indexCPL; $cc++) {

          //print_r($PKL_UUID_SIZE);

          $filenameCPL = $assetmap_UUID_to_FILE[ $arrayCPL[$cc] ]; // prendo il filename della CPL trovata...

          $streamerCop_Log .= "[ ".date('Y-m-d H:i:s')." ] (".$indexQueue."/".$currentMaxQueue.") ".$main['datastore_name']." @ ".$main['address']." : VERIFING CPL CONTENT /".$datastore_path."/".$main['folder']."/".$filenameCPL." ".PHP_EOL;

          $CPLContent = file_get_contents("ssh2.sftp://$sftp_fd//".$datastore_path."/".$main['folder']."/".$filenameCPL ); // leggo il contenuto della cpl
          $XML_CPL = parseCPLContent($CPLContent); // lo carico in un array togliendo i namespaces del 3D

          if(!isset($XML_CPL['ReelList'])){

            $IS_DCP_VERIFIED = false;
            verifyTimeoutTask($db , $main['id'] , $main['datefrom'] , $hoursTimeOutCheck , $main['error'] , $status_xml);
            continue;

          }


          // fixo la parsificazione x le cpl con 1 solo reel...
          if(!isset($XML_CPL['ReelList']['Reel'][0]))
            $XML_CPL['ReelList']['Reel'][0] = $XML_CPL['ReelList']['Reel'];


          $cpl_content = $filesize_child->addChild('cpl'.$cc);

          for($inner_cpl = 0; $inner_cpl < count( $XML_CPL['ReelList']['Reel'] ); $inner_cpl ++ ){ // passo ogni suo asset

            // se un uuid della CPL fa riferimento ad un file che non fa parte dell'assetmap, è un errore.

            $reel = $cpl_content -> addChild('reel');



            // passo tutti e 3 i tipi di reel
            for($cpl_reeler = 0; $cpl_reeler<6; $cpl_reeler++){

            $CURRENT_ASSET = $arrayReelType[$cpl_reeler];


            //print_r($assetmap_UUID_to_FILE);


            // MAINPICTURE
            if(isset($XML_CPL['ReelList']['Reel'][$inner_cpl]['AssetList'][$CURRENT_ASSET])) // verifico che vi sia un mainpicture
              if(!isset($assetmap_UUID_to_FILE[ $XML_CPL['ReelList']['Reel'][$inner_cpl]['AssetList'][$CURRENT_ASSET]['Id'] ] )) {

                // LO DEVO CERCARE NELLA PROPS.
                $searchResult = findFilePROPS( $main['uuid'] , $XML_CPL['ReelList']['Reel'][$inner_cpl]['AssetList'][$CURRENT_ASSET]['Id'] , $db);

                if( $searchResult['Status'] == '0' || $searchResult['Status'] == '2') {

                  // NON è STATO TROVATO NELLA PROPS...

                $streamerCop_Log .= "[ ".date('Y-m-d H:i:s')." ] (".$indexQueue."/".$currentMaxQueue.") ".$main['datastore_name']." @ ".$main['address']." : [X] ".$XML_CPL['ReelList']['Reel'][$inner_cpl]['AssetList'][$CURRENT_ASSET]['Id']." Unknown CPL MainPicture UUID reference ... verification process paused for this CPL".PHP_EOL;
                $IS_DCP_VERIFIED = false;

                $reel_mp = $reel -> addChild(strtolower($CURRENT_ASSET));
                $reel_content = $reel_mp -> addChild('filename' , $searchResult['Filename']);

                // metto le size lette nella pkl e su disco.
                $reel_content = $reel_mp -> addChild('original_size' , $searchResult['OriginalSize'] );
                $reel_content = $reel_mp -> addChild('datastore_size' , $searchResult['DatastoreSize'] );

                $reel_content = $reel_mp -> addChild('uuid' , $XML_CPL['ReelList']['Reel'][$inner_cpl]['AssetList'][$CURRENT_ASSET]['Id'] );
                $reel_content = $reel_mp -> addChild('status' , $searchResult['Status']);

                // esco, errore.

                verifyTimeoutTask($db , $main['id'] , $main['datefrom'] , $hoursTimeOutCheck , $main['error'] , $status_xml);

                if($ERROR_EXEPTION_REPORT == false)
                  break 2;

                } else {

                  // trovato.

                  //echo PHP_EOL."SONO IN! ".$XML_CPL['ReelList']['Reel'][$inner_cpl]['AssetList'][$CURRENT_ASSET]['Id']." ~ ".$searchResult['Filename'].PHP_EOL;

                  $streamerCop_Log .= "[ ".date('Y-m-d H:i:s')." ] (".$indexQueue."/".$currentMaxQueue.") ".$main['datastore_name']." @ ".$main['address']." : [OK OUTSIDE FOLDER] ".$XML_CPL['ReelList']['Reel'][$inner_cpl]['AssetList'][$CURRENT_ASSET]['Id']." ".PHP_EOL;

                  $reel_mp = $reel -> addChild(strtolower($CURRENT_ASSET));
                  $reel_content = $reel_mp -> addChild('filename' , $searchResult['Filename']);
                  // metto le size lette nella pkl e su disco.
                  $reel_content = $reel_mp -> addChild('original_size' , $searchResult['OriginalSize'] );
                  $reel_content = $reel_mp -> addChild('datastore_size' , $searchResult['DatastoreSize'] );

                  $reel_content = $reel_mp -> addChild('uuid' , $XML_CPL['ReelList']['Reel'][$inner_cpl]['AssetList'][$CURRENT_ASSET]['Id'] );

                  $reel_content = $reel_mp -> addChild('status' , 1);

                }

            } else {

              if( @ssh2_sftp_stat( $sftp , "//".$datastore_path."/".$main['folder']."/".$assetmap_UUID_to_FILE[ $XML_CPL['ReelList']['Reel'][$inner_cpl]['AssetList'][$CURRENT_ASSET]['Id'] ]) ){


                // il main picture esiste...
                $reel_mp = $reel -> addChild(strtolower($CURRENT_ASSET));
                $reel_content = $reel_mp -> addChild('filename' , $assetmap_UUID_to_FILE[ $XML_CPL['ReelList']['Reel'][$inner_cpl]['AssetList'][$CURRENT_ASSET]['Id'] ] );
                $reel_content = $reel_mp -> addChild('uuid' , $XML_CPL['ReelList']['Reel'][$inner_cpl]['AssetList'][$CURRENT_ASSET]['Id'] );

                // metto le size lette nella pkl e su disco.


                $reel_content = $reel_mp -> addChild('original_size' , $PKL_UUID_SIZE[$XML_CPL['ReelList']['Reel'][$inner_cpl]['AssetList'][$CURRENT_ASSET]['Id']]['OriginalSize'] );
                $reel_content = $reel_mp -> addChild('datastore_size' , $PKL_UUID_SIZE[$XML_CPL['ReelList']['Reel'][$inner_cpl]['AssetList'][$CURRENT_ASSET]['Id']]['DatastoreSize'] );

                if( $PKL_UUID_SIZE[$XML_CPL['ReelList']['Reel'][$inner_cpl]['AssetList'][$CURRENT_ASSET]['Id']]['OriginalSize'] == $PKL_UUID_SIZE[$XML_CPL['ReelList']['Reel'][$inner_cpl]['AssetList'][$CURRENT_ASSET]['Id']]['DatastoreSize'] ){

                    $streamerCop_Log .= "[ ".date('Y-m-d H:i:s')." ] (".$indexQueue."/".$currentMaxQueue.") ".$main['datastore_name']." @ ".$main['address']." : [OK] (".$CURRENT_ASSET.") ".$assetmap_UUID_to_FILE[ $XML_CPL['ReelList']['Reel'][$inner_cpl]['AssetList'][$CURRENT_ASSET]['Id'] ]." ".PHP_EOL;
                    $reel_content = $reel_mp -> addChild('status' , 1);

                  }else{

                  $streamerCop_Log .= "[ ".date('Y-m-d H:i:s')." ] (".$indexQueue."/".$currentMaxQueue.") ".$main['datastore_name']." @ ".$main['address']." : [X] (".$CURRENT_ASSET.") ".$assetmap_UUID_to_FILE[ $XML_CPL['ReelList']['Reel'][$inner_cpl]['AssetList'][$CURRENT_ASSET]['Id'] ]." FILESIZE NOT MATCHING, Verification for this CPL is paused...".PHP_EOL;
                  $reel_content = $reel_mp -> addChild('status' , 2);

                  $IS_DCP_VERIFIED = false;

                  verifyTimeoutTask($db , $main['id'] , $main['datefrom'] , $hoursTimeOutCheck , $main['error'] , $status_xml);

                  if($ERROR_EXEPTION_REPORT == false)
                    break 2;

                 }



              } else {

                // LO PROVO A CERCARE NELLA PROPS?
                $searchResult = findFilePROPS( $main['uuid'] , $XML_CPL['ReelList']['Reel'][$inner_cpl]['AssetList'][$CURRENT_ASSET]['Id'] , $db);

                if( $searchResult['Status'] == '0' || $searchResult['Status'] == '2') {
                // il main picture NON esiste...
                $reel_mp = $reel -> addChild(strtolower($CURRENT_ASSET));
                $reel_content = $reel_mp -> addChild('filename' , $assetmap_UUID_to_FILE[ $XML_CPL['ReelList']['Reel'][$inner_cpl]['AssetList'][$CURRENT_ASSET]['Id'] ] );

                // metto le size lette nella pkl e su disco.
                $reel_content = $reel_mp -> addChild('original_size' , $searchResult['OriginalSize'] );
                $reel_content = $reel_mp -> addChild('datastore_size' , $searchResult['DatastoreSize'] );

                $reel_content = $reel_mp -> addChild('uuid' , $XML_CPL['ReelList']['Reel'][$inner_cpl]['AssetList'][$CURRENT_ASSET]['Id'] );
                $reel_content = $reel_mp -> addChild('status' , $searchResult['Status']);

                $streamerCop_Log .= "[ ".date('Y-m-d H:i:s')." ] (".$indexQueue."/".$currentMaxQueue.") ".$main['datastore_name']." @ ".$main['address']." : [X] (".$CURRENT_ASSET.") ".$assetmap_UUID_to_FILE[ $XML_CPL['ReelList']['Reel'][$inner_cpl]['AssetList']['MainPicture']['Id'] ]." Missing CPL file ... verification process paused for this CPL".PHP_EOL;

                $IS_DCP_VERIFIED = false;
                verifyTimeoutTask($db , $main['id'] , $main['datefrom'] , $hoursTimeOutCheck , $main['error'] , $status_xml);

                if($ERROR_EXEPTION_REPORT == false)
                  break 2;

                } else {

                  // L'HO TROVATO NELLA PROPS.

                  $reel_mp = $reel -> addChild(strtolower($CURRENT_ASSET));
                  $reel_content = $reel_mp -> addChild('filename' , $searchResult['Filename'] );
                  $reel_content = $reel_mp -> addChild('uuid' , $XML_CPL['ReelList']['Reel'][$inner_cpl]['AssetList'][$CURRENT_ASSET]['Id'] );

                  // metto le size lette nella pkl e su disco.
                  $reel_content = $reel_mp -> addChild('original_size' , $searchResult['OriginalSize'] );
                  $reel_content = $reel_mp -> addChild('datastore_size' , $searchResult['DatastoreSize'] );

                  $reel_content = $reel_mp -> addChild('status' , 1);

                  $streamerCop_Log .= "[ ".date('Y-m-d H:i:s')." ] (".$indexQueue."/".$currentMaxQueue.") ".$main['datastore_name']." @ ".$main['address']." : [OK OUTSIDE FOLDER] (".$CURRENT_ASSET.") ".$searchResult['Filename']." ".PHP_EOL;

                }

              }

            }

            }


          }



        } // fine ciclo CPL della PKL


      }

      // SE NON è STATA PARSATA ALCUNA PKL SIGNIFICA CHE NON è STATA PARSATA NEMMENO UNA CPL.. ERRORE.
      if($WAS_PKL_PARSED == FALSE){

        $IS_DCP_VERIFIED = FALSE;

      }

      if($IS_DCP_VERIFIED == TRUE){ // SE è TRUE, VA MARKATA COME VALIDA.

        if(mysqli_query($db,"UPDATE m_streamercop_verify SET progress = 'VERIFIED' , queued='9' , modifydate = \"".date('Y-m-d H:i:s')."\" , verify_status = '".( $status_xml->asXml() )."' WHERE id = '".$main['id']."'")){

          $streamerCop_Log .= "[ ".date('Y-m-d H:i:s')." ] (".$indexQueue."/".$currentMaxQueue.") ".$main['datastore_name']." @ ".$main['address']." : [COMPLETE] /".$datastore_path."/".$main['folder']." ... verification process COMPLETED for this CPL".PHP_EOL;
          echo "[VERIFIED] /".$datastore_path."/".$main['folder'].PHP_EOL;

        } else {

          mysqli_query($db,"UPDATE m_streamercop_verify SET progress = 'VERIFIED' , queued='9' , modifydate = \"".date('Y-m-d H:i:s')."\" , verify_status = '' WHERE id = '".$main['id']."'");
          $streamerCop_Log .= "[ ".date('Y-m-d H:i:s')." ] (".$indexQueue."/".$currentMaxQueue.") ".$main['datastore_name']." @ ".$main['address']." : [WARNING COMPLETE] /".$datastore_path."/".$main['folder']." QUERY UPDATE FAILED WITH XMLSTATUS!".PHP_EOL;

        }

        // PRENDO TUTTI I TEATRI E SERIALI DEI SERVERS
        $queryChannels = mysqli_query($db, "SELECT a.* , b.type, c.name as datastore_name FROM m_theaters a LEFT JOIN m_imb b ON b.id = a.id_imb LEFT JOIN m_datastores c on c.id = b.id_datastore GROUP BY b.type, c.name");

        while($rowch = mysqli_fetch_array($queryChannels)){

          // SE IL TEATRO IN QUESTIONE è HULA (NE BASTA UNO SOLO CON QUEL SERIALE x TUTTI GLI ALTRI)
          if($rowch['type'] == 'HULA'){

              // Con la nuova versione di streamer, il seriale\nome datastore già lo abbiamo nella query iniziale...
              
              // AZZERO CLIPS PER QUESTA UUID PER QUESTO TEATRO.
              mysqli_query($db,"DELETE FROM clips WHERE uuid = \"".$main['uuid']."\" AND serial = \"".$rowch['datastore_name']."\"");

              $get_title = mysqli_query($db, "SELECT Title FROM m_dcp WHERE ID = '".$main['id_cpl']."' ");
              $assoc_title = mysqli_fetch_assoc($get_title);

              // INSERISCO LA CERTIFICAZIONE PER QUESTO DATASTORE PER GLI HULA
              mysqli_query($db,"INSERT INTO clips (uuid, filename, folder, ingested, todelete, progress, task, error, serial, datefrom, queued, dcpid, modifydate, title, description)
              VALUES ('".$main['uuid']."' , '".$main['filename']."' , '".$main['folder']."' , 0, 0, 0, 0, 0, '".$main['datastore_name']."', NOW() , 0, '".$main['id_cpl']."' , NOW() , '".$assoc_title['Title']."' , 'HULA Register by StreamerCop'");

            //}

          } else {

            // SE NON SONO HULA, SOLO QUELLI IN DIRECT STREAMING TRUE E CERTIFIED TRUE, MA NELLO STATO ATTUALE, QUALI?

          }

        }


      } else {

        // VERIFICO SE QUESTO CONTENUTO è STATO CONTROLLATO DA PIù DI TOT ORE, IN TAL CASO, QUALCOSA NON VA E SEGNALO
        verifyTimeoutTask($db , $main['id'] , $main['datefrom'] , $hoursTimeOutCheck , $main['error'] , $status_xml);
        break;

      }

      //$indexQueue++;

  }




  //echo "sleep".PHP_EOL;

  $root_folder = "";

  if(file_exists('StreamerCop') && is_dir('StreamerCop')){

    // ci troviamo nella root di Streamer
    $root_folder = "StreamerCop/";

  } else {

    if(file_exists('streamercop.php')){

      // ci troviamo nella root di streamercop


    }

  }

  // faccio uno spazio per dividere i cicli...
  $streamerCop_Log .= PHP_EOL;

  if(!file_exists($root_folder.'logs/'.date('Y')))
    mkdir( $root_folder."logs/".date('Y') , 0777, true );

    // SCRIVO IL LOG
    $log = fopen($root_folder."logs/".date('Y')."/".date('Ymd').".log" , 'a+');
    fwrite($log , $streamerCop_Log);
    fclose($log);

    //SCRIVO IL LOG "REALTIME"
    file_put_contents($root_folder."logs/".date('Y')."/".date('Ymd')."_realtime.log" , $streamerCop_Log);

  if( updateSTREAMERCOP_record($db) == 'shutdown'){

    // shutdown!
    $streamerCop_Log = "[ ".date('Y-m-d H:i:s')." ] StreamerCop is shutting down as requested!".PHP_EOL.PHP_EOL;
    $log = fopen($root_folder."logs/".date('Y')."/".date('Ymd').".log" , 'a+');
    fwrite($log , $streamerCop_Log);
    fclose($log);
    exit;


  }

  //sleep($timerCheck); // timer di sleep tra un check e l'altro..



} // END MAIN WHILE CICLE

// fine
exit;





function findFilePROPS( $UUID_CPL , $UUID_TO_FIND , $db){

  //include("check_session.php");

  global $datastore_path;
  global $sftp_fd;
  global $sftp;

  // La funzione cerca il file corrispondente a questa UUID all'interno della folder scritta in PROPS (a patto che vi sia)
  // Trovata in uno degli assetmap, verifico che il file esista su disco e che abbia le dimensioni dichiarate nella PKL, in caso contrario, status 0 ed error con descrizione.

  $query_dcp = mysqli_query($db,"SELECT Props FROM m_dcp WHERE Fileaudio = '".$UUID_CPL."'");

  // dichiaro l'array di return del risultato con 0 di default.
  $arrayReturn = array('Status' => 0 , 'Filename' => '' , 'OriginalSize' => 0 , 'DatastoreSize' => 0);

  // non trovo la m_dcp corrispondente a questo uuid.. ???? ok.
  if(!$assocProps = mysqli_fetch_assoc($query_dcp)){

    return $arrayReturn;

  }

  if(empty($assocProps['Props']))
    return $arrayReturn;


  $PROPS_COMPLETE = "ssh2.sftp://".intval($sftp_fd)."//".$datastore_path."/".$assocProps['Props'];
  $PROPS_SHORT = $datastore_path."/".$assocProps['Props'];
  echo $PROPS_COMPLETE.PHP_EOL;

  $statFolder = @ssh2_sftp_stat($sftp , $datastore_path."/".$assocProps['Props']);

  print_r($statFolder);

  if( $handle = opendir("ssh2.sftp://".intval($sftp_fd)."//".$datastore_path."/".$assocProps['Props']) ){

    // ok è una cartella

    closedir($handle);

  } else {


    return $arrayReturn;

  }


  $SCAN = getDirContents($PROPS_COMPLETE);

  //print_r($SCAN);

  $ASSETMAPS = array();

  // Passo ogni file alla ricerca di un ASSETMAP
  for($i = 0; $i < count($SCAN); $i++){

      if( strtoupper(basename($SCAN[$i])) == 'ASSETMAP' || strtoupper(basename($SCAN[$i])) == 'ASSETMAP.XML' ){

        //trovato assetmap.
        $ASSETMAPS[] = $SCAN[$i];

      }


  } // ciclo $i main

  $CORRECT_ASSETMAP_PATH = '';

  $TEMP_PKL = array();

  for($c = 0; $c < count($ASSETMAPS); $c++){

    $CURRENT_ASSETMAP = rework_array_assetmap( file_get_contents($ASSETMAPS[$c]) );



    for($inner_assetmap = 0; $inner_assetmap < count($CURRENT_ASSETMAP['AssetList']['Asset']); $inner_assetmap++ ){

        if($CURRENT_ASSETMAP['AssetList']['Asset'][$inner_assetmap]['Id'] == $UUID_TO_FIND && empty($CORRECT_ASSETMAP_PATH) ){

          $CURRENT_ASSETMAP['AssetList']['Asset'][$inner_assetmap]['ChunkList']['Chunk']['Path'] = str_replace("file:///" , "" , $CURRENT_ASSETMAP['AssetList']['Asset'][$inner_assetmap]['ChunkList']['Chunk']['Path'] );
          $CURRENT_ASSETMAP['AssetList']['Asset'][$inner_assetmap]['ChunkList']['Chunk']['Path'] = str_replace("file://" , "" , $CURRENT_ASSETMAP['AssetList']['Asset'][$inner_assetmap]['ChunkList']['Chunk']['Path'] );

          //$CORRECT_ASSETMAP_PATH = $ASSETMAPS[$c];

          $FILENAME_MISSING = str_replace( basename( $ASSETMAPS[$c] ) , '' , $ASSETMAPS[$c] ) ."/" . $CURRENT_ASSETMAP['AssetList']['Asset'][$inner_assetmap]['ChunkList']['Chunk']['Path'];
          $FILENAME_MISSING_OG = str_replace( "ssh2.sftp://$sftp_fd//" , '' ,  (str_replace( basename( $ASSETMAPS[$c] ) , '' , $ASSETMAPS[$c] ) ."/" . $CURRENT_ASSETMAP['AssetList']['Asset'][$inner_assetmap]['ChunkList']['Chunk']['Path'] ) ) ;

          // Se esiste
          if(  @ssh2_sftp_stat( $sftp , $FILENAME_MISSING_OG )  ){

            $CORRECT_ASSETMAP_PATH = $ASSETMAPS[$c];
            echo $FILENAME_MISSING.PHP_EOL." ESISTE ---> ".$FILENAME_MISSING_OG.PHP_EOL.PHP_EOL;

          } else {

            $arrayReturn['Filename'] = $FILENAME_MISSING_OG;
            $arrayReturn['Status'] = "0";
            echo "NO ".$FILENAME_MISSING." ---> ".$FILENAME_MISSING_OG.PHP_EOL.PHP_EOL;

          }
          //break 2;

        }

        // PKL!
        if( isset($CURRENT_ASSETMAP['AssetList']['Asset'][$inner_assetmap]['PackingList']) ){


          $CURRENT_ASSETMAP['AssetList']['Asset'][$inner_assetmap]['ChunkList']['Chunk']['Path'] = str_replace("file:///" , "" , $CURRENT_ASSETMAP['AssetList']['Asset'][$inner_assetmap]['ChunkList']['Chunk']['Path'] );
          $CURRENT_ASSETMAP['AssetList']['Asset'][$inner_assetmap]['ChunkList']['Chunk']['Path'] = str_replace("file://" , "" , $CURRENT_ASSETMAP['AssetList']['Asset'][$inner_assetmap]['ChunkList']['Chunk']['Path'] );

          // mi salvo il path della PKL..
          $TEMP_PKL[] = str_replace( basename( $ASSETMAPS[$c] ) , '' , $ASSETMAPS[$c] ) ."/" . $CURRENT_ASSETMAP['AssetList']['Asset'][$inner_assetmap]['ChunkList']['Chunk']['Path'];

        }


    }

    // Se la path dell'assetmap non è vuota significa che è stato trovato assieme alle potenziali PKL contenenti questo file.
    /*if(!empty($CORRECT_ASSETMAP_PATH))
      break;
      */

  }

  // Se true, significa che questa UUID non è stata trovata in questo props.. manca forse una versione in copia? o proprio una versione in questa props? booo
  if(empty($CORRECT_ASSETMAP_PATH)){

    $arrayReturn['Status'] = "0";
    echo "esco...".PHP_EOL;

    return $arrayReturn;

  }


  print_r($TEMP_PKL);


  // passo le PKL trovate per cercare l'ID del nostro file e finalmente, verificarne la dimensione!
  for($index_p = 0; $index_p < count($TEMP_PKL); $index_p++){

    $PKL_content = file_get_contents($TEMP_PKL[$index_p]);
    $xmlObj = simplexml_load_string($PKL_content, 'SimpleXMLElement' , LIBXML_NOBLANKS);
    $PKL_Array = objectsIntoArray($xmlObj);

    for($inner_pkl = 0; $inner_pkl < count($PKL_Array['AssetList']['Asset']); $inner_pkl++) {

      if( $PKL_Array['AssetList']['Asset'][$inner_pkl]['Id'] == $UUID_TO_FIND ) {

        //echo "STAT FOLDER = ".$FILENAME_MISSING_OG.PHP_EOL;

        $filesize_disk = ssh2_sftp_stat( $sftp , $FILENAME_MISSING_OG );

        print_r($filesize_disk);

        if( $filesize_disk['size'] == $PKL_Array['AssetList']['Asset'][$inner_pkl]['Size'] ){

          // Il file è stato trovato!
          //return basename($FILENAME_MISSING);
          $arrayReturn['Status'] = '1';
          $arrayReturn['Filename'] = $FILENAME_MISSING;
          $arrayReturn['OriginalSize'] = $PKL_Array['AssetList']['Asset'][$inner_pkl]['Size'];
          $arrayReturn['DatastoreSize'] = $filesize_disk['size'];

          print_r($arrayReturn);

          return $arrayReturn;

        } else {

          $arrayReturn['Status'] = '2';
          $arrayReturn['Filename'] = $FILENAME_MISSING;
          $arrayReturn['OriginalSize'] = $PKL_Array['AssetList']['Asset'][$inner_pkl]['Size'];
          $arrayReturn['DatastoreSize'] = $filesize_disk['size'];

          print_r($arrayReturn);

          return $arrayReturn;

        }

      }

    }


  }

  echo "non lo trovo nelle pkl.... :(".PHP_EOL;
  print_r($arrayReturn);

  return $arrayReturn;

}




function objectsIntoArray($arrObjData, $arrSkipIndices = array())
{
    $arrData = array();

    // if input is object, convert into array
    if (is_object($arrObjData)) {
        $arrObjData = get_object_vars($arrObjData);
    }

    if (is_array($arrObjData)) {

        foreach ($arrObjData as $index => $value) {

            if (is_object($value) || is_array($value)) {
                $value = objectsIntoArray($value, $arrSkipIndices); // recursive call
            }

            if (in_array($index, $arrSkipIndices)) {
                continue;
            }
            $arrData[$index] = $value;
        }
    }
    return $arrData;
}


function rework_array_assetmap($xml){

  $xml_parsed = str_replace('am:' , '' , $xml);
  $xmlObj = simplexml_load_string($xml_parsed, 'SimpleXMLElement' , LIBXML_NOBLANKS);
  $xmlfixed = objectsIntoArray($xmlObj);

  return $xmlfixed;

}

function parseCPLContent($xml){

  // REGEX PER TOGLIERE QUALSIASI NODO : CAMPO
  /*<\w[a-zA-Z0-9_-]*:|</\w[a-zA-Z0-9_-]*:*/

  $xml_parsed = preg_replace("/<\w[a-zA-Z0-9_-]*:/" , "<" , $xml);
  $xml_parsed = preg_replace("/<\/\w[a-zA-Z0-9_-]*:/" , "</" , $xml_parsed);


  //$xml_parsed = str_replace('sicpl:' , '' , $xml);
  //$xml_parsed = str_replace('msp-cpl:' , '' , $xml_parsed);
  //$xml_parsed = str_replace('axd-cpl:' , '' , $xml_parsed);
  //$xml_parsed = str_replace('xmlns:axd-cpl="http://www.dolby.com/schemas/2012/AD"' , '' , $xml_parsed);
  //$xml_parsed = str_replace('ns1:' , '' , $xml_parsed);

  $xmlObj = simplexml_load_string($xml_parsed, 'SimpleXMLElement' , LIBXML_NOBLANKS);
  $XML_CPL = objectsIntoArray($xmlObj);

  return $XML_CPL;

}


function PingThisIP($ip){

  if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {

      if(!exec("ping -n 1 -w 1 ".$ip." 2>NUL > NUL && (echo 0) || (echo 1)"))
        return "online";

      return "offline";

} else {

  $pingresult = shell_exec("timeout 0.2 ping -c 1 ".$ip);

  if (strpos($pingresult , '1 received') !== false ) {
      return "online";
  } else {
      return "offline";
  }


}

}


function verifyTimeoutTask($db , $idclips , $datefrom , $hoursTimeOutCheck , $error , $status_xml){


  if( $error >= $hoursTimeOutCheck ){
    mysqli_query($db,"UPDATE m_streamercop_verify SET progress = 'ERRORVERIFY' , queued='9' , ModifyDate = \"".date('Y-m-d H:i:s')."\" , verify_status = '".($status_xml->asXml())."' WHERE id = '".$idclips."'");

  } else {

    // la sposto di 5 minuti
    mysqli_query($db,"UPDATE m_streamercop_verify SET datefrom = \"".date('Y-m-d H:i:s' , strtotime('+5 minutes' , strtotime(date('Y-m-d H:i:s'))))."\" , error = (error + 1) , verify_status = '".($status_xml->asXml())."' WHERE id ='".$idclips."' ");

  }

}


function new_ID($tablename , $db){

    $check_ids=mysqli_query($db,"SELECT * FROM ".$tablename);
    if(mysqli_num_rows($check_ids)==0)
      return 1;
    $query_id=mysqli_query($db,"SELECT ID FROM ".$tablename." WHERE ID=(SELECT MAX(ID) FROM ".$tablename.")");
    while($id_p=mysqli_fetch_array($query_id)){
      $id_max=$id_p['ID'];}
    $newid=intval($id_max+1);
    return $newid;
}


function VERIFY_ACTIVE_TASKS($db , $first_start){

  return true;

  //include("check_session.php");
  /*
  $CAN_RUN = TRUE;

  // cerco i task già attivi.
  $active = mysqli_query($db,"SELECT * FROM streamercop WHERE Status = 'RUNNING' Order by Timestamp");
  while($row = mysqli_fetch_array($active)){

    $minsBy = intval( ( strtotime(date('Y-m-d H:i:s')) - strtotime($row['Timestamp']) ) /60 );
    if($minsBy > 5){

      // termino i processi rimasti indietro
      mysqli_query($db,"UPDATE streamercop SET Shutdown = '1' , STATUS = 'TIMED_OUT' WHERE ID = '".$row['ID']."'");

    } else {

      //$CAN_RUN = FALSE;

    }
    */

  //}

  /*

  // SE FIRST START è 1, ALLORA SE CAN RUN è TRUE SIGNIFICA CHE QUESTO TASK PUò PARTIRE, CON FIRST_START A 0 è SOLO UN CHECK DEI TASK RIMASTI INDIETRO (STESSO METODO DEL CRON)
  if($first_start == 1 && $CAN_RUN == TRUE){

    $_SESSION['STREAMER_COP_ID'] = new_ID('streamercop' , $db);

    // CREO IL RECORD PER QUESTO TASK.
    //mysqli_query($db,"INSERT INTO streamercop (ID, Status, StartDate, Timestamp) VALUES
    //(\"".$_SESSION['STREAMER_COP_ID']."\" , \"STARTING\" , \"".date('Y-m-d H:i:s')."\" , \"".date('Y-m-d H:i:s')."\")");

  } else {

    return true; // ritorno true perchè c'è già un task attivo e non avvio questo.

  }
  */


}


function updateSTREAMERCOP_record($db){

  // una volta veniva gestito il record di streamercop ed era possibile ucciderlo, bei tempi.
  return "";

  //include("check_session.php");
  /*

  $checkShutDown = mysqli_query($db,"SELECT Shutdown FROM streamercop WHERE ID = '".$_SESSION['STREAMER_COP_ID']."'");
  $assoc = mysqli_fetch_assoc($checkShutDown);

  if($assoc['Shutdown'] == '1'){

    // spengo lo streamercop
    mysqli_query($db,"UPDATE streamercop SET Status = 'TERMINATED' , EndDate = '".date('Y-m-d H:i:s')."' WHERE ID = '".$_SESSION['STREAMER_COP_ID']."'");
    return "shutdown";

  }

  mysqli_query($db,"UPDATE streamercop SET Timestamp = '".date('Y-m-d H:i:s')."' WHERE ID = '".$_SESSION['STREAMER_COP_ID']."'");
  */

}


function getDirContents($dir, &$results = array()){

    global $sftp;
    global $sftp_fd;

    $files = scandir($dir);

    //echo $dir;

    foreach($files as $key => $value){
        //$path = realpath($dir.DIRECTORY_SEPARATOR.$value);

        $path = $dir."/".$value;

        //$statFolder = @ssh2_sftp_stat($sftp , str_replace( "ssh2.sftp://$sftp_fd//" , '' , $path ) );

//        if($statFolder['Size'] == '4096' && $statFolder['uid'] == '0'){

        if($value != "." && $value != ".."){

          if( $handle = @opendir($path) ) {

            closedir($handle);

            getDirContents($path, $results);
            $results[] = $path;

        } else {

          $results[] = $path;

        }

      }
    }

    return $results;
}
?>
