/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 15389:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* provided dependency */ var console = __webpack_require__(25108);
/* provided dependency */ var Buffer = __webpack_require__(64293)["Buffer"];
//process.version = 'v12.40';
//process.env.NODE_NO_WARNINGS = 1;
//process.env.NODE_TLS_REJECT_UNAUTHORIZED = '0';
const dotenv = __webpack_require__(59738);
dotenv.config();

const config = __webpack_require__(54638);
var async = __webpack_require__(57664);
var convert = __webpack_require__(7888);
const express = __webpack_require__(99268);
const app = express();
const WebSocket = __webpack_require__(8777);
var cors = __webpack_require__(17846)
const NetcatClient = __webpack_require__(49221)
var http = __webpack_require__(98605);
const xml2js = __webpack_require__(5055);
const parser = __webpack_require__(10046);
var ping = __webpack_require__(62773);
var ip = __webpack_require__(60413);
var soap = __webpack_require__(6926);
const axiosHttp = __webpack_require__(9669);
//const adapter = require('axios/lib/adapters/xhr');
var https = __webpack_require__(57211);
var http = __webpack_require__(98605);
const { Certificate } = __webpack_require__(51712);
var Client = __webpack_require__(92353).Client;
let ClientSFTP = __webpack_require__(81111);
var Client_FTP = __webpack_require__(7224);
const { v4: uuidv4 } = __webpack_require__(42277);
var unzip = __webpack_require__(33267);
var mysql = __webpack_require__(4426);
const cert2json = __webpack_require__(61643);
var aes256 = __webpack_require__(64956);
var recursive = __webpack_require__(9402);
var unzipper = __webpack_require__(40984);
const fileupload = __webpack_require__(56751)
const ftp_basic = __webpack_require__(9631);
//var getUri = require('get-uri');



const os = __webpack_require__(12087);
const fs = __webpack_require__(35747);
const path = __webpack_require__(85622);
const { Console } = __webpack_require__(57082);
const { resolve, basename } = __webpack_require__(85622);
const { title } = __webpack_require__(61765);
const checkDiskSpace = __webpack_require__(31771);
const { isatty } = __webpack_require__(33867);
const limit_browser = "datastore";
const streamerVersionAPI = 'beta0.2.1';

const axios = axiosHttp.create({
  adapter: __webpack_require__(47970),
});

app.use(parser.urlencoded({
  extended: true,
  limit: '50mb', extended: true
}));

const agent = new https.Agent({
  rejectUnauthorized: false,
  keepAlive: true
});

app.use(parser.json({ limit: '50mb', extended: true }));



const cors_options = {

  origin: '*',
  methods: "GET,HEAD,PUT,PATCH,POST,DELETE",

}

app.use(cors(cors_options));
app.use(fileupload());

if (!fs.existsSync('./config')) {
  // Creo cartella config...
  fs.mkdirSync('./config');
}

if (!fs.existsSync('./config/default.json')) {

  const default_config = {
    "Customer": {
      "dbConfig": {
        "DATABASE_HOST": '127.0.0.1',
        "DATABASE_PORT": '3306',
        "DATABASE_NAME": 'cinecloud',
        "DATABASE_USER": 'root',
        "DATABASE_PWD": ''
      }
    }
  };



  fs.writeFileSync(path.join('.', 'config', 'default.json'), JSON.stringify(default_config));

}

const configFile = JSON.parse(fs.readFileSync('./config/default.json'));
const is_streamer_already_intalled = fs.existsSync('./installed.str');


const { dbConfig } = configFile.Customer;

var pool = mysql.createPool({
  host: dbConfig.DATABASE_HOST,
  user: dbConfig.DATABASE_USER,
  password: dbConfig.DATABASE_PWD,
  database: dbConfig.DATABASE_NAME,
  port: dbConfig.DATABASE_PORT,
  connectionLimit: 100,
  multipleStatements: true
});

// Lista devices.
const devices_list = ["projector", "audio", "gpi", "switch"];
const devices_types = ["7", "6", "1", "0"];
const devices_prefix = ["Projector", "AudioProcessor", "Gpi", "VideoRouter"];
const projector_type_label = ["", "BARCO", "SONY"];

const audioprocessor_type_label = {
  "0": "",
  "1": "DOLBY_CP650",
  "2": "DOLBY_CP750",
  "3": "F_760",
  "4": "F_8631",
  "5": "DOLBY_CP850",
  "6": "DOLBY_CP851",
  "7": "DOLBY_CP950",
  "8": "DOLBY_CP951"
};

const gpi_type_label = {
  "0": "PCI8255",
  "4": "ETH_8O",
  "5": "ETH_4O",
  "8": "ETH_484",
  "10": "ETH_8020"
}

const switch_type_label = {
  "0": "",
  "15": "BLACKMAGIC_VHM16",
  "17": "BLACKMAGIC_VHM12",
  "19": "BLACKMAGIC_VHM40",
  /*"33": "KRAMER_VS81H",*/
  "32": "KRAMER_VS81H_PROTOCOL2000_SERIAL",
  "33": "KRAMER_VS81H_PROTOCOL2000",
  "34": "KANEX_PROHDMX42"
}

const gpi_type_io = {

  "0": { "i": 16, "o": 16 },
  "4": { "i": 0, "o": 8 },
  "5": { "i": 0, "o": 4 },
  "8": { "i": 8, "o": 4 },
  "10": { "i": 20, "o": 20 }

}

const switch_type_io = {

  "0": { "i": 0, "o": 0 },
  "15": { "i": 16, "o": 16 },
  "17": { "i": 12, "o": 12 },
  "19": { "i": 40, "o": 40 },
  /*"33": { "i": 8, "o": 1 },*/
  "32": { "i": 8, "o": 1 },
  "33": { "i": 8, "o": 1 },
  "34": { "i": 4, "o": 2 }

}
var ip_playout = "127.0.0.1";
//getPlayoutIP();


const audioprocessors_modes = {

  0: {},
  1: [{ label: 'MODE 0', value: 0 },
  { label: 'MODE 1', value: 1 },
  { label: 'MODE 2', value: 2 },
  { label: 'MODE 3', value: 3 },
  { label: 'MODE 4', value: 4 },
  { label: 'MODE 5', value: 5 },
  { label: 'MODE 6', value: 6 },
  { label: 'MODE 7', value: 7 },
  ],
  2: [{ label: "ANALOG", value: 0 },
  { label: "DIG_1", value: 1 },
  { label: "DIG_2", value: 2 },
  { label: "DIG_3", value: 3 },
  { label: "DIG_4", value: 4 },
  { label: "LAST", value: 5 },
  { label: "MIC", value: 6 },
  { label: "NON_SYNC", value: 7 }],

  3: [{ label: 'NON SYNC', value: 1 },
  { label: 'SYNC DIGITAL', value: 2 },
  { label: 'ANALOG', value: 3 },
  { label: 'CD/DVD', value: 4 },
  ],

  4: [{ label: 'MIC', value: 0 },
  { label: 'NON SYNC', value: 1 },
  { label: 'SYNC DIGITAL', value: 2 },
  { label: 'ANALOG', value: 3 },
  { label: 'CD/DVD', value: 4 },
  ],


}


var playout_ws_ports = [];
var devicemanager_ws_ports = [];

var clientWebSockets = [];
var clientWebSocketsDVM = [];

//Apro pool di connessione al db.
pool.getConnection(function (conn_err, db) {


  if (conn_err) { // connessione db fallita

    console.log(conn_err);
    //asyncWsBroadcast({ type: 'DB_ERROR', message: 'Database is Offline' });

  }

  var status_playout_array = [];
  var timeline_playout_array = [];
  var status_playback_array = [];
  var schedule_list_theater = [];
  var status_devicemanager_array = [];



  // ==========================================================
  // FUNZIONE DI INGEST KDM
  // ==========================================================

  var timeout_kdm = undefined;

  streamer_IngestKDM_service();

  function streamer_IngestKDM_service() {

    //console.log(' + servizio ingest KDM [ON]');

    //var interval = undefined;

    const service_ = async () => {

      return new Promise((resolve_service, reject_service) => {

        if (typeof db === 'undefined') return resolve_service();

        db.query("SELECT * FROM kdm WHERE progress = 1", (qerr, to_ingest_list) => {

          if (qerr || typeof to_ingest_list === 'undefined' || to_ingest_list.length === 0) return resolve_service(); // Esco, non devo fare niente.
          var count_kdm = 0;

          async.forEachOf(to_ingest_list, (kdm, index, callback_kdm) => {

            // Verifico che la KDM esista fisicamente nel datastore          
            const kdmPath = '/' + path.join('datastore', kdm.folder, kdm.filename);

            if (!fs.existsSync(kdmPath)) { count_kdm++; if (count_kdm >= to_ingest_list.length) return resolve_service(); return; } // NON ESISTE LA KDM SU DISCO

            const kdm_content = fs.readFileSync(kdmPath).toString();

            xml2js.parseString(kdm_content, { explicitArray: false, ignoreAttrs: false, explicitChildren: false, explicitRoot: true }, function (err, kdm_json) {

              // Prendo i dati dell'IMB per questa KDM
              db.query("SELECT a.* , b.* , c.username, c.password, c.address as datastore_address, c.hula_store_docker FROM m_theaters a LEFT JOIN m_imb b ON b.id = a.id_imb LEFT JOIN m_datastores c on c.id = b.id_datastore WHERE b.serial = ? AND b.kdm_serial = ?", [kdm.serial, kdm.projectorid], (qerr, imb) => {

                if (qerr || imb.length === 0) { count_kdm++; if (count_kdm >= to_ingest_list.length) return resolve_service(); } // Non ho l'imb ecc, non posso
                imb = imb[0];



                switch (true) {

                  case imb.type === 'BARCO' || imb.type.toLowerCase().indexOf('dolby') >= 0:

                    soapLogin(imb.type, imb.address, imb.port, imb.api_username, imb.api_password, agent).then(login => {

                      new Promise((resolve_imb, reject_imb) => {

                        if (login === '') return reject_imb(); // Login fallimentare.

                        if (imb.type === 'BARCO') {

                          // Creo il comando da inviare
                          let json_cmd = {
                            'soap:Envelope': {
                              $: { 'xmlns:soap': 'http://www.w3.org/2003/05/soap-envelope', 'xmlns:sms': 'http://www.barco.com/sms/sms_1' },
                              'soap:Header': '',
                              'soap:Body': {
                                'sms:AddKdm': {
                                  'sms:data': {},
                                }
                              }
                            }
                          };

                          let builder = new xml2js.Builder();
                          let soapXML = builder.buildObject(json_cmd);
                          let kdmObject = builder.buildObject(kdm_json);
                          let jsonComponents = [JSON.parse(convert.xml2json(soapXML, { compact: true, headless: true })), JSON.parse(convert.xml2json(kdmObject, { compact: true, headless: true }))];
                          jsonComponents[0]['soap:Envelope']['soap:Body']['sms:AddKdm']['sms:data'] = jsonComponents[1];

                          // Comando XML soap con tutti gli attributi originali soap e kdm ecc...
                          let soapKDMrequestMessage = convert.json2xml(jsonComponents[0], { compact: true, headless: true });

                          // Mando SOAP per barco
                          soapAPI(imb.type, imb.address, imb.port, 'ingest_kdm', agent, '', { xml: soapKDMrequestMessage }).then(res_ => {

                            xml2js.parseString(res_, { explicitArray: false, ignoreAttrs: false, explicitChildren: false, explicitRoot: false }, function (err, kdm_response) {

                              // La response è in errore. non faccio nulla e non la conto come caricata!
                              if (err || kdm_response === null) { return reject_imb(); }

                              let progress = 'COMPLETE';

                              if (Number(kdm_response['SOAP-ENV:Body']['ns1:AddKdmResponse']['ns1:AddKdmResult']) !== 0) progress = 'ERROR';

                              db.query("UPDATE kdm SET progress = ?, ingested = 1 WHERE id = ?", [progress, kdm.id], (qerr, result) => {

                                return resolve_imb();

                              });

                            });

                          }).catch(error_api => {

                            // Fallito... riproverò???
                            console.log(error_api);
                            return reject_imb();

                          })

                        } else {

                          // INGEST DOLBY
                          // Prendo l'uuid della sessione....
                          xml2js.parseString(login, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, json_res) {

                            if (!json_res['SOAP-ENV:Body']['ns1:LoginResponse'].sessionId) {
                              return reject_imb();
                            }
                            const dolby_session = json_res['SOAP-ENV:Body']['ns1:LoginResponse'].sessionId;

                            const kdm_64 = Buffer.from(kdm_content).toString('base64');


                            soapAPI(imb.type, imb.address, imb.port, 'ingest_kdm', agent, dolby_session, { kdm64: kdm_64 }).then(res_ => {

                              // Vedo se ho errori
                              xml2js.parseString(res_, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, kdm_response) {

                                if (err || kdm_response === null) { return reject_imb(); }

                                let progress = 'COMPLETE';

                                // IMS DI DOLBY RITORNA UNA RESPONSE CON IL CAMPO FAULT se il caricamento della chiave dovesse andare in errore... non danno nessuna descrizione
                                // Ho provato a caricare una KDM del barco sul dolby per avere l'errore e l'unica cosa che ritorna è "undefined error" , meglio di niente tho.
                                if (typeof kdm_response['SOAP-ENV:Body']['SOAP-ENV:Fault'] !== 'undefined') progress = 'ERROR';

                                db.query("UPDATE kdm SET progress = ?, ingested = 1 WHERE id = ?", [progress, kdm.id], (qerr, result) => {

                                  // Il logout di dolby lo faccio qui direttamente perchè ci serve l'uuid del login a differenza del barco che usa semplicemente l'agent
                                  soapAPI(imb.type, imb.address, imb.port, 'logout', agent, dolby_session).then(res_ => {

                                    return resolve_imb();

                                  });

                                });

                              });

                            });

                          });

                        }

                      }).then(resolved_imb => {

                        if (imb.type === 'BARCO') {

                          // LOGOUT BARCO
                          soapAPI(imb.type, imb.address, imb.port, 'logout', agent).then(res_ => {

                            count_kdm++; if (count_kdm >= to_ingest_list.length) return resolve_service();

                          });

                        } else {
                          // DOLBY GIà SLOGGATO
                          count_kdm++; if (count_kdm >= to_ingest_list.length) return resolve_service();

                        }

                      }).catch(error_imb => {

                        count_kdm++; if (count_kdm >= to_ingest_list.length) return resolve_service();

                      });

                    });
                    break;

                  case imb.type === 'HULA':
                    new Promise((resolve_imb, reject_imb) => {
                      var conn = new Client();
                      var output = "";

                      conn.on('ready', function () {

                        let response = "";
                        let error_response = "";

                        conn.exec("docker -H :3000 exec " + imb.hula_store_docker + " hl-asset.py --put-kdm " + kdmPath.replace(/\\/g, '/'), function (err, stream) {

                          stream.on('data', (chunk) => { response += chunk });
                          stream.stderr.on('data', function (data) { error_response += data });
                          stream.on('close', () => {

                            error_response = error_response.split("\n");
                            // Ora, ipoteticamente, se error_response ha una seconda riga, abbiamo un errore. Il problema è, che se sta dicendo che già esiste, chissene frega,
                            // Se dovesse ritornare altro, allora è un errore.
                            let progress = 'COMPLETE';
                            let description_error = '';
                            if (typeof error_response[1] !== 'undefined' && error_response[1].toLocaleLowerCase().indexOf('kdm already exists') < 0) { progress = 'ERROR'; description_error = error_response[1] }

                            db.query("UPDATE kdm SET progress = ?, ingested = 1, description = ? WHERE id = ?", [progress, description_error, kdm.id], (qerr, result) => {

                              conn.end(); // Chiudo la sessione ssh
                              return resolve_imb();

                            });



                          });

                        });

                        conn.on('error', () => { return reject({ error: 'Connection to HULA store failed for ' + imb.address }) });
                      }).connect({
                        host: imb.datastore_address,
                        port: 22,
                        username: imb.username,
                        password: imb.password
                      });

                    }).then(resolved_imb => {

                      count_kdm++; if (count_kdm >= to_ingest_list.length) return resolve_service();

                    }).catch(error_imb => {

                      count_kdm++; if (count_kdm >= to_ingest_list.length) return resolve_service();

                    }); break;

                  case imb.type === 'GDC':

                    //  Richiamo la funzione di api gdc che ho creato per ingestare il contenuto della KDM in base64...
                    gdcAPI('ingest_kdm', imb.address, imb.port, { kdm64: Buffer.from(kdm_content).toString('base64') }).then(gdc_response => {

                      let progress = 'COMPLETE';
                      if (gdc_response['$'].status !== 'OK') progress = 'ERROR';


                      // Ingest completato...
                      db.query("UPDATE kdm SET progress = ?, ingested = 1 WHERE id = ?", [progress, kdm.id], (qerr, result) => {

                        count_kdm++; if (count_kdm >= to_ingest_list.length) return resolve_service();

                      });

                    }).catch(error_gdc => {

                      // GDC in errore, non è detto che la richiesta sia andata a buon fine.
                      count_kdm++; if (count_kdm >= to_ingest_list.length) return resolve_service();

                    });
                    break;

                  default: { count_kdm++; if (count_kdm >= to_ingest_list.length) return resolve_service(); }

                }

              });

            });

          }, () => {

            console.log('callback kdm OK')
            return resolve_service();

          });

        });

      });

    }

    // Eseguo questa funzione ricorsivamente, una volta eseguito un ciclo di servizio, si richiama dopo 10 secondi.

    service_().then(info => {

      clearTimeout(timeout_kdm)

      timeout_kdm = setTimeout(() => {

        streamer_IngestKDM_service();

      }, 10000);

    }).catch(error => {

      clearTimeout(timeout_kdm)

      timeout_kdm = setTimeout(() => {

        streamer_IngestKDM_service();

      }, 10000);

    })

  }

  // ==========================================================
  // FINE FUNZIONE DI INGEST KDM
  // ==========================================================





  // ==========================================================
  // FUNZIONE DI INGEST CPL / REGISTRAZIONE HULA
  // ==========================================================

  var timeout_ingestCPL = undefined;

  streamer_IngestCPL_service();

  function streamer_IngestCPL_service() {


    clearTimeout(timeout_ingestCPL)

    const service_ = async () => {

      return new Promise((resolve_service, reject_service) => {

        if (typeof db === 'undefined') return resolve_service();

        // Prendo la lista dei jobs di clips per gli ingest
        db.query("SELECT a.*, b.api_username, b.api_password, b.address as api_address, b.port as api_port, b.type, c.username, c.password, c.address as datastore_address, c.hula_store_docker FROM clips a LEFT JOIN m_imb b ON b.serial = a.serial or b.type = substring(a.serial, 1 ,4) LEFT JOIN m_datastores c ON c.id = b.id or a.serial like concat('%',c.name,'%') WHERE progress = 1 AND datefrom < NOW() GROUP BY a.id LIMIT 5 ", (qerr, jobs) => {

          if (qerr || typeof jobs === 'undefined' || jobs.length === 0) return reject_service(); // Mi fermo qua, non ho niente da fare.

          let count_jobs = 0;

          async.forEachOf(jobs, (job, index, callback_job) => {

            switch (true) {

              /* ================ REGISTRAZIONE HULA ===================*/
              case job.type === 'HULA':
                new Promise((resolve_imb, reject_imb) => {

                  // Devo registrare questa CPL, ma prima di lanciare la verifica per niente, controllo se è già registrata...
                  var conn = new Client();
                  var output = "";



                  conn.on('ready', function () {

                    conn.exec("docker -H :3000 exec " + job.hula_store_docker + " hl-asset.py --get-asset-list", function (err, stream) {

                      if (err || typeof stream === 'undefined') { return reject_imb(); }

                      //if (err) throw err;
                      stream.on('close', function (code, signal) {

                        // output dovrà contenere la lista di TUTTI gli asset registrati senza urn:uuid: , quindi, io per ogni CPL mia posso solamente controllare che la roba in m_dcp sia certificata per questo hula
                        const assetList = output.split('\n');

                        // Prendo la CPL che stiamo cercando di registrare...
                        db.query("SELECT ID , Fileaudio , Radiofileaudio, String20 , Filename , Title FROM m_dcp WHERE Fileaudio = ?", [job.uuid], (qerr, result) => {

                          // Errore query, query fallita, non esiste la CPL in m_dcp.... non posso fare niente.
                          if (qerr || typeof result === 'undefined' || result.length === 0) { return reject_imb(false); }

                          let dcp = result[0];

                          // Non abbiamo il filename della CPL
                          if (dcp.String20 === '') { return reject_imb(false); }

                          const cpl_path = '/' + path.join('datastore', dcp.Filename, dcp.String20).replace(/\\/g, '/');

                          //console.log(cpl_path)
                          let cpl_content = "";

                          conn.sftp((err, sftp) => { // Apro la connesssione SFTP sul server

                            try {

                              // COnnessione sftp fallita.
                              if (err) { return reject_imb(false); } else {

                                // Verifico che esista il file
                                sftp.stat(cpl_path, (error_stat, stats) => {

                                  // Il file non esiste.
                                  if (error_stat) { return reject_imb(false); }

                                  // Creo uno stream di lettura della CPL sul server remoto
                                  let stream_cpl = sftp.createReadStream(cpl_path);

                                  stream_cpl.on('data', (chunk) => {
                                    cpl_content += chunk; // Leggo i chunk della CPL.
                                  })

                                  stream_cpl.on('close', () => {

                                    // regex per pulire la cpl come sempre
                                    cpl_content = cpl_content.replace(/<\w[a-zA-Z0-9_-]*:/g, "<");
                                    cpl_content = cpl_content.replace(/<\/\w[a-zA-Z0-9_-]*:/g, '</');

                                    // abbiamo il contenuto della CPL...
                                    xml2js.parseString(cpl_content, { explicitArray: false, explicitChildren: false, explicitRoot: true }, function (err, cpl_json) {

                                      // Errore lettura CPL
                                      if (err || typeof cpl_json.CompositionPlaylist === 'undefined') { console.log('error cpl' + job.id); return resolve_imb(true); }

                                      // leggo gli asset
                                      if (typeof cpl_json.CompositionPlaylist.ReelList.Reel[0] === 'undefined')
                                        cpl_json.CompositionPlaylist.ReelList.Reel = [cpl_json.CompositionPlaylist.ReelList.Reel];

                                      // Tipi di asset del reel
                                      let asset_keys = Object.keys(cpl_json.CompositionPlaylist.ReelList.Reel[0].AssetList);
                                      let current_cpl_assets_id = [];

                                      cpl_json.CompositionPlaylist.ReelList.Reel.forEach(asset => {

                                        asset_keys.forEach(key => {

                                          if (key.indexOf('CompositionMetadataAsset') < 0) // DEVO SALTARE COMPOSITIONMETADATAASSET, NON CI INTERESSA
                                            current_cpl_assets_id.push(asset.AssetList[key].Id.substr(9, asset.AssetList[key].Id.length)); // levo urn:uuid:

                                        });

                                      });

                                      let valid = true;
                                      // Verifico se tutti i suoi asset siano certificati dall'HULA store.
                                      for (let x = 0; x < current_cpl_assets_id.length; x++) {
                                        if (!assetList.includes(current_cpl_assets_id[x])) {
                                          console.log(dcp.Title + ' missing asset -> ' + current_cpl_assets_id[x]);
                                          valid = false; break;
                                        }
                                      }

                                      // Controllo anche l'ID della CPL...
                                      if (!assetList.includes(cpl_json.CompositionPlaylist.Id.replace('urn:uuid:', ''))) {
                                        console.log(dcp.Title + ' missing asset cpl -> ' + cpl_json.CompositionPlaylist.Id.replace('urn:uuid:', ''));
                                        valid = false;
                                      }

                                      if (valid) {

                                        // Se valid fosse TRUE, la CPL è già resitrata per questo HULA IMB, quindi metto complete.
                                        console.log('la CPL ' + dcp.Title + ' è già registrata!');
                                        db.query("UPDATE clips SET progress = 'COMPLETE' , ingested = 1, error = 0, description='CPL was already Certified' WHERE ID = ? ", [job.id], (qerr, result_update) => {

                                          return resolve_imb();

                                        }); return;


                                      } else {

                                        // Altrimenti... dobbiamo registrarla noi.
                                        //db.query("UPDATE clips SET progress = '1' WHERE id = ?", [job.id], (qerr, update_progress) => {
                                        console.log(dcp.Title + ' Non è certificata!');

                                        // ORA, ho la lista degli asset che devono essere registrati, dobbiamo prenderci la PKL che contiene i filename e registrarli tutti.
                                        // Cerco l'assetmap nella cartella...
                                        const folderCPL = '/' + path.join('datastore', dcp.Filename).replace(/\\/g, '/');
                                        sftp.readdir(folderCPL, (err, list_files) => {

                                          let assetmap_filename = "";

                                          // Ora, cerchiamo l'assetmap di questa CPL folder...
                                          for (let i = 0; i < list_files.length; i++)
                                            if (list_files[i].filename.toLowerCase().indexOf('assetmap') >= 0) { assetmap_filename = list_files[i].filename; break; }

                                          if (assetmap_filename === '') { return reject_imb(); } // Non abbiamo trovato l'assetmap

                                          let stream_assetmap = sftp.createReadStream(path.join(folderCPL, assetmap_filename).replace(/\\/g, '/'));
                                          let assetmap_content = "";

                                          stream_assetmap.on('data', (chunk) => { assetmap_content += chunk }).on('error', () => { return reject_imb(); }).on('close', () => {

                                            xml2js.parseString(assetmap_content, { explicitArray: false, explicitChildren: false, explicitRoot: true }, function (err, assetmap_json) {

                                              let pkl_filename_array = [];
                                              let assetmap_conversion_array = [];

                                              try {

                                                // Cerco la PKL, rendo l'asset array se già non lo fosse...
                                                if (typeof assetmap_json.AssetMap.AssetList.Asset[0] === 'undefined') assetmap_json.AssetMap.AssetList.Asset = [assetmap_json.AssetMap.AssetList.Asset];

                                                for (let x = 0; x < assetmap_json.AssetMap.AssetList.Asset.length; x++) {
                                                  let item_ = assetmap_json.AssetMap.AssetList.Asset[x];

                                                  assetmap_conversion_array.push({ id: item_.Id, filename: item_.ChunkList.Chunk.Path });
                                                  if (typeof item_.PackingList !== 'undefined') pkl_filename_array.push(item_.ChunkList.Chunk.Path);
                                                }

                                                if (pkl_filename_array.length === 0) return reject_imb(); // Non abbiamo trovato PKL in questo assetmap.. strano.. lol

                                              } catch (error_parse) {

                                                return reject_imb();

                                              }

                                              let pkl_counterino = 0;
                                              let register_list_async = [];

                                              // Cerco la PKL di questa CPL. Che poi, nel caso reale, non serve nemmeno creare un'array di PKL perchè il mio caro StreamerIDCP ne metterà sempre una sola per assetmap\cpl però u never know..
                                              async.forEachOf(pkl_filename_array, (pkl_file, index_pkl, callback_pkl) => {

                                                let stream_pkl = sftp.createReadStream(path.join(folderCPL, pkl_file).replace(/\\/g, '/'));
                                                let pkl_content = "";

                                                stream_pkl.on('data', (chunk) => { pkl_content += chunk }).on('error', () => { return reject_imb(); }).on('close', () => {

                                                  xml2js.parseString(pkl_content, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, pkl_json) {

                                                    // Verifico se siamo nella PKL giusta...
                                                    if (err) { pkl_counterino++; if (pkl_counterino >= pkl_filename_array) return callback_pkl(register_list_async); return; }

                                                    try {

                                                      if (typeof pkl_json.AssetList.Asset[0] === 'undefined') pkl_json.AssetList.Asset = [pkl_json.AssetList.Asset];
                                                      let right_pkl = false; // Partiamo dicendo che questa NON è la sua PKL
                                                      let temp_ids = [];

                                                      pkl_json.AssetList.Asset.forEach(asset => {

                                                        // Devo scartare i fonts.
                                                        if (asset.Type !== 'application/ttf') temp_ids.push(asset.Id);
                                                        if (asset.Id === dcp.Fileaudio) { right_pkl = true; } // Trovata

                                                      });

                                                      // Non è la PKL giusta...
                                                      if (!right_pkl) { pkl_counterino++; if (pkl_counterino >= pkl_filename_array) return callback_pkl(register_list_async); return; }

                                                      let to_register = [];

                                                      // SE è la PKL giusta, allora compilo l'array e callbacko direttamente!
                                                      temp_ids.forEach(pkl_asset_id => {

                                                        // Cerco questo ID nell'array di conversione
                                                        for (let i = 0; i < assetmap_conversion_array.length; i++) {

                                                          if (assetmap_conversion_array[i].id === pkl_asset_id) {
                                                            to_register.push(path.join(folderCPL, assetmap_conversion_array[i].filename)); break;
                                                          }
                                                        }

                                                      });

                                                      // Aggiungo l'assetmap + PKL
                                                      //to_register.push(path.join(folderCPL, assetmap_filename).replace(/\\/g, '/'));
                                                      //to_register.push(path.join(folderCPL, pkl_file).replace(/\\/g, '/'));
                                                      // Callbacko per la registrazione.
                                                      return callback_pkl({ to_register: to_register, id_list: temp_ids });

                                                    } catch (err_) {

                                                      pkl_counterino++; if (pkl_counterino >= pkl_filename_array) return callback_pkl(register_list_async); return;

                                                    }

                                                  });

                                                });

                                              }, (register_list) => {

                                                if (register_list.to_register.length === 0) return reject_imb(); // nessun file da registrare? kinda sus.

                                                let register_count = 0;

                                                console.log(register_list.id_list);

                                                // Registro questi files. alla fine quando tutti avranno callbackato, la registrazione sarà completata!
                                                async.forEachOf(register_list.to_register, (file_to_register, index_register, callback_register) => {

                                                  conn.exec("docker -H :3000 exec " + job.hula_store_docker + " hl-asset.py --register " + file_to_register.replace(/\\/g, '/'), function (err, stream) {

                                                    if (err || typeof stream === 'undefined') {

                                                      console.log(file_to_register.replace(/\\/g, '/'));
                                                      // è un ERRORE DA GESTIRE
                                                      register_count++;
                                                      if (register_count >= register_list.to_register.length) return callback_register(register_list.id_list);

                                                      return;

                                                    }

                                                    let output_register = "";

                                                    stream.on('data', (chunk) => { output_register += chunk }).stderr.on('data', function (data) {

                                                      //console.log(data.toString());
                                                      // Dovrei leggere la risposta per poi controllare...
                                                      output_register += data;

                                                    }).on('error', () => { /* cosa faccio se vado in errore???? */ }).on('end', () => {

                                                      console.log(output_register.split('\n'));

                                                      register_count++;
                                                      if (register_count >= register_list.to_register.length) return callback_register(register_list.id_list);

                                                    });

                                                  });

                                                }, (assets_list) => {

                                                  // resolve finale, abbiamo appena registrato il contenuto.
                                                  db.query("UPDATE clips SET progress = 'RUNNING' , progress_perc=0 , error = 0, ingested = 0, description='HULA Certification handled by StreamerV2' , assets = ? WHERE id = ?", [JSON.stringify(assets_list), job.id], (qerr, finale) => {

                                                    //console.log(qerr);

                                                    console.log("[RUNNING] > " + dcp.Title);
                                                    return resolve_imb(true);

                                                  })

                                                })


                                              });

                                            });

                                          });


                                        });



                                      }

                                    });

                                  });

                                })

                              }

                            } catch (err) {

                              return resolve_imb();

                            }

                          });

                        });


                      }).on('data', function (data) {

                        output = output + data;

                      });


                    });
                    //conn.on('error', () => { return reject_service({ error: 'Connection to HULA store failed for ' + job.datastore_address }) });
                  }).on('error', (err) => {


                    // La connessione è fallita al datastore, sposto il job
                    db.query("UPDATE clips SET datefrom = ? WHERE id = ?", [new Date(new Date().setMinutes(new Date().getMinutes() + 1)).toMysqlFormat(), job.id]);
                    return reject_service({ error: 'Connection to HULA store failed for ' + job.datastore_address })

                  }).connect({
                    host: job.datastore_address,
                    port: 22,
                    username: job.username,
                    password: job.password
                  });

                }).then(resolved_imb => {

                  count_jobs++; if (count_jobs >= jobs.length) return resolve_service(true);

                }).catch(rejected_imb => {

                  count_jobs++; if (count_jobs >= jobs.length) return resolve_service(true);

                }); break;

              default:
                db.query("UPDATE clips SET datefrom = ? WHERE id = ?", [new Date(new Date().setMinutes(new Date().getMinutes() + 1)).toMysqlFormat(), job.id], (qerr) => {
                  count_jobs++; if (count_jobs >= jobs.length) return callback_job(true);
                }); break;
            }

          }, (callback__) => {

            return resolve_service();

          });

        });

      })

    }


    service_().then(info => {

      clearTimeout(timeout_ingestCPL)

      timeout_ingestCPL = setTimeout(() => {

        streamer_IngestCPL_service();

      }, 3000);

    }).catch(error => {

      clearTimeout(timeout_ingestCPL)

      timeout_ingestCPL = setTimeout(() => {

        streamer_IngestCPL_service();

      }, 3000);

    })

  }

  //monitorIngestCPL();
  var timeoutMonitor = null;

  // VECCHIA VERSIONE BRUTTA OBSOLETA CHE CREAVA SOLO PROBLEMI NON USARE, USARE L'ALTRA
  // Funzione di monitor degli ingest, sistema il progress percentuale nel database e mette complete quando sono complete ecc...
  function monitorIngestCPL() {


    clearTimeout(timeoutMonitor);
    return false;

    const service_ = () => {


      return new Promise((resolve, reject) => {

        db.query("SELECT * FROM m_datastores", (qerr, datastores_hula) => {

          let count_datastore = 0;

          async.forEachOf(datastores_hula, (datastore_hula, index_datastore_hula, callback_hula_datastore) => {

            //console.log(datastore_hula)

            var conn = new Client();
            conn.on('ready', function () {

              db.query("SELECT a.*, b.api_username, b.api_password, b.address as api_address, b.port as api_port, b.type, c.username, c.password, c.address as datastore_address, c.hula_store_docker, a.assets FROM clips a LEFT JOIN m_imb b ON b.serial = a.serial LEFT JOIN m_datastores c ON c.id = b.id_datastore WHERE progress = 'RUNNING' AND datefrom < NOW() and b.type = 'HULA' and c.id = ?", [datastore_hula.id], (qerr, jobs) => {

                let jobs_count = 0;

                const handleCallbackJobs = (callback) => {
                  jobs_count++;
                  if (jobs_count >= jobs.length) {
                    console.log('resolvo')
                    return resolve(true);
                  }

                  console.log('Vado al prossimo')

                  return false;

                }

                if (jobs.length === 0) { conn.end(); return reject(); }

                async.forEachOf(jobs, (job, index, callback_job) => {

                  console.log('lol?');

                  switch (true) {

                    case job.type === 'HULA':
                      new Promise((resolve_imb, reject_imb) => {

                        console.log('lancio >' + job.id)

                        //let conn = new Client();
                        let output = "";

                        //                  conn.on('ready', function () {

                        conn.exec("docker -H :3000 exec " + job.hula_store_docker + " hl-asset.py --get-asset-list", function (err, stream) {

                          console.log(err);

                          console.log('ho la lista >' + job.id)

                          //if (err) throw err;
                          stream.on('end', function (code, signal) {

                            //conn.end();

                            const assetList = output.split('\n');
                            const assetJob = JSON.parse(job.assets); // Mi prendo gli assets dal db

                            let perc_progress = 0;

                            // Verifico se abbiamo qualche asset già registrato...
                            assetJob.forEach(id => {

                              if (assetList.includes(id.replace('urn:uuid:', ''))) {
                                perc_progress += Number(((100 / assetJob.length) / 100) * 100);
                              } else {

                                console.log('MANCA UUID ' + id.replace('urn:uuid:', ''));

                              }


                            });



                            if (parseInt(perc_progress) === 100) {

                              // Abbiamo finito
                              db.query("UPDATE clips SET progress = 'COMPLETE', progress_perc = 100, ingested= 1, error = 0 WHERE id = ?", [job.id], (qerr, result) => {

                                //conn.end();
                                return resolve_imb(true);

                              }); return;

                            } else {

                              let tasksList = "";
                              var count_tasks = 0;

                              // Devo controllare i tasks a che punto sono se sono partiti o meno ecc...
                              conn.exec("docker -H :3000 exec " + job.hula_store_docker + " hl-task.py --get-active-tasks", function (err, stream_tasks) {

                                if (err || typeof stream_tasks === 'undefined') { console.log(err); return resolve_imb(true); }

                                stream_tasks.on('end', () => {

                                  console.log('ho lista active tasks ' + job.id)

                                  tasksList = tasksList.split('\n');
                                  console.log(tasksList.length);

                                  let tasks_progress = 0;

                                  const handleCallbackTasks = (callback_) => {
                                    count_tasks++;
                                    if (count_tasks >= tasksList.length) {


                                      perc_progress += tasks_progress;
                                      db.query("UPDATE clips SET progress_perc = ? WHERE id = ?", [perc_progress, job.id], (qerr, updated) => {

                                        //conn.end();
                                        //console.log(perc_progress);
                                        //conn.end();
                                        //conn.end();
                                        return resolve_imb();

                                      });

                                    }
                                    return;
                                  }

                                  //Ora, verifico i tasks
                                  async.forEachOf(tasksList, (task, index_task, callback_task) => {

                                    let status_output = "";

                                    conn.exec("docker -H :3000 exec " + job.hula_store_docker + " hl-task.py --get-task-status " + task, function (err, stream_task_status) {

                                      if (err || typeof stream_task_status === 'undefined') { console.log(err); console.log('errorino...'); return handleCallbackTasks(callback_task); }

                                      stream_task_status.on('end', () => {

                                        try {

                                          if (typeof status_output === 'undefined' || status_output === "") {
                                            console.log(job.id + ' END POINT 1 richiamo funzione attuale task count = ' + count_tasks);
                                            return handleCallbackTasks(callback_task);
                                          }

                                          console.log('tasks ' + task + ' lettura over ' + job.id)

                                          splitStatusTask = status_output.split('\n');

                                          if (typeof splitStatusTask[2] === 'undefined' || typeof splitStatusTask[1] === 'undefined') {
                                            console.log(job.id + ' END POINT 2 richiamo funzione attuale task count = ' + count_tasks);
                                            return handleCallbackTasks(callback_task);
                                          }

                                          const assetTask = splitStatusTask[1].replace('AssetID: ', '');

                                          // Verifico se questo task si sta riferendo al nostro asset...
                                          if (assetJob.includes('urn:uuid:' + assetTask)) {

                                            console.log(job.id + ' > task trovato per asset suo!');

                                            const progress_task = Number(splitStatusTask[2].replace('Progress: ', ''))
                                            tasks_progress += Number(((100 / assetJob.length) / 100) * progress_task);

                                          }

                                        } catch (err___) {

                                          console.log(err___)

                                        }

                                        console.log(job.id + ' richiamo funzione attuale task count = ' + count_tasks);

                                        return handleCallbackTasks(callback_task);

                                      }).on('data', (chunk) => { status_output += chunk });

                                    });

                                  }, (perc_tasks) => {

                                    perc_progress += perc_tasks;
                                    db.query("UPDATE clips SET progress_perc = ? WHERE id = ?", [perc_progress, job.id], (qerr, updated) => {

                                      //conn.end();
                                      //console.log(perc_progress);
                                      //conn.end();
                                      return resolve_imb();

                                    });

                                  })


                                }).on('data', (chunk) => { tasksList += chunk });

                              });

                            }

                          }).on('data', (chunk) => { output += chunk })

                        });



                      }).then(resolved_imb => {

                        //conn.end();

                        console.log(job.id + "_" + jobs_count + "_" + jobs.length)
                        return handleCallbackJobs(callback_job);

                      }).catch(error_imb => {

                        //conn.end();

                        console.log(job.id + "_" + jobs_count + "_" + jobs.length)
                        return handleCallbackJobs(callback_job);

                      }); break;


                    default: return handleCallbackJobs(callback_job);

                  }

                }, (callback_job_end) => {

                  //handler datastore e infine resolve
                  count_datastore++;
                  if (count_datastore >= datastores_hula.length) {
                    conn.end();
                    return resolve();
                  }

                });

              }) // query jobs

              conn.on('error', (err) => { console.log("xDDDDDDDDDDDDDDDDDDDDD" + err) });

            }).connect({

              host: datastore_hula.address,
              port: 22,
              username: datastore_hula.username,
              password: datastore_hula.password

            })

          }, (callback_datastore) => {


            return resolve();

          })

        })


      });

    }


    service_().then(done => {

      clearTimeout(timeoutMonitor);

      timeoutMonitor = setTimeout(() => {

        monitorIngestCPL();

      }, 1000);

    }).catch(error => {

      clearTimeout(timeoutMonitor);

      timeoutMonitor = setTimeout(() => {

        monitorIngestCPL();

      }, 1000);

    })

  }

  // CERTIFICAZIONE HULA PERFETTA
  var timeoutMonitorHULA = null;
  monitorCertificationHULA();

  // Remake monitor Certificazione HULA. Ottimizzato, più veloce, come dovrebbe essere.
  function monitorCertificationHULA() {

    clearTimeout(timeoutMonitorHULA);

    const service_ = () => {

      return new Promise((resolve, reject) => {

        if (typeof db === 'undefined') return resolve();

        db.query("SELECT a.id as id_job , c.id as id_datastore, c.username, c.password, c.hula_store_docker, c.address FROM clips a LEFT JOIN m_imb b on b.serial = a.serial or b.type = substring(a.serial, 1 ,4) LEFT JOIN m_datastores c ON c.id = b.id_datastore or a.serial like concat('%',c.name,'%') WHERE a.progress = 'RUNNING' AND b.type = 'HULA' GROUP BY c.id", (qerr, check) => {

          if (typeof check === 'undefined' || check.length === 0) return resolve(); // Non abbiamo nessun task da controllare, quindi, non apro connessioni, fine del controllo.

          // Ora, sostanzialmente, questo ciclo potrà essere uno solo oppure per ogni datastore per cui esista un task in RUNNING.
          let count_datastore = 0;
          let datastore_assets = [];

          async.forEachOf(check, (active_datastore, index_datastore, callback_datastore) => {

            // Prima cosa, mi collego in ssh e richiedo la assetlist 1 SOLA VOLTA PER DATASTORE

            datastore_assets[active_datastore.id_datastore] = { assetList: [], taskList: [] };

            let conn = new Client();
            conn.on('ready', function () {

              let output = "";

              conn.exec("docker -H :3000 exec " + active_datastore.hula_store_docker + " hl-asset.py --get-asset-list", (err, stream) => {

                stream.on('end', () => {
                  // Abbiamo l'assetlist di questo datastore, una sola volta.
                  const assetList = output.split('\n');
                  datastore_assets[active_datastore.id_datastore].assetList = assetList;

                  let output_active = "";

                  conn.exec("docker -H :3000 exec " + active_datastore.hula_store_docker + " hl-task.py --get-active-tasks", (err, stream_tasks) => {

                    stream_tasks.on('end', () => {
                      // Abbiamo la lista degli active task di questo datastore, la chiedo una volta sola.
                      const activeTasks = output_active.split('\n');

                      let count_tasks = 0;
                      let active_tasks = [];

                      async.forEachOf(activeTasks, (task, index_task, callback_tasks) => {

                        if (task === '') { count_tasks++; if (count_tasks >= activeTasks.length) return callback_tasks(datastore_assets); }

                        let output_status = "";

                        conn.exec("docker -H :3000 exec " + active_datastore.hula_store_docker + " hl-task.py --get-task-status " + task, (err, stream_status) => {

                          stream_status.on('end', () => {

                            const taskStatus = output_status.split('\n');

                            if (typeof taskStatus[1] === 'undefined' || taskStatus[2] === 'undefined') { count_tasks++; if (count_tasks >= activeTasks.length) return callback_tasks(datastore_assets); return; }

                            let status_json = {
                              asset_id: taskStatus[1].replace('AssetID: ', ''),
                              progress: taskStatus[2].replace('Progress: ', ''),
                            }

                            active_tasks.push(status_json);
                            datastore_assets[active_datastore.id_datastore].taskList = active_tasks;
                            count_tasks++; if (count_tasks >= activeTasks.length) return callback_tasks(datastore_assets);


                          }).on('data', (chunk) => { output_status += chunk });

                        });

                      }, (callback_assets) => {

                        // Abbiamo gli asset e progress dei task attivi su questo datastore
                        count_datastore++;
                        if (count_datastore >= check.length) { conn.end(); return callback_datastore(callback_assets); }

                      });

                    }).on('data', (chunk) => { output_active += chunk });

                  });

                }).on('data', (chunk) => { output += chunk });

              });

            }).on('error', (err) => {

              // Il datastore è offline.
              count_datastore++;
              if (count_datastore >= check.length) { conn.end(); return callback_datastore(datastore_assets); }

            }).connect({
              host: active_datastore.address,
              port: 22,
              username: active_datastore.username,
              password: active_datastore.password,
            });

          }, (datastore_callbacked) => {

            // Ora, dobbiamo prendere i jobs da clips
            db.query("SELECT a.*, c.id as id_datastore FROM clips a LEFT JOIN m_imb b on  b.serial = a.serial or b.type = substring(a.serial, 1 ,4) LEFT JOIN m_datastores c ON a.serial like concat('%',c.name,'%') WHERE a.progress = 'RUNNING' and b.type = 'HULA' GROUP BY a.id", (qerr, jobs) => {

              let jobs_done = 0;

              async.forEachOf(jobs, (job, index_job, callback_jobs) => {

                // PRIMA, verifico se abbiamo l'assetlist per questo datastore.
                if (typeof datastore_callbacked[job.id_datastore] === 'undefined') {
                  jobs_done++;
                  if (jobs_done >= jobs.length) return resolve();
                  return; // blocco, non posso farci niente...
                }

                job.assets = JSON.parse(job.assets);

                let assetObject = datastore_callbacked[job.id_datastore];
                let total_assets = job.assets.length; //Levo la CPL
                let running_perc = 0;

                // Verifico se questo job ha qualche asset già ready
                job.assets.forEach(asset => {
                  if (assetObject.assetList.includes(asset.replace('urn:uuid:', ''))) {
                    running_perc += (100 / total_assets); // Aggiungo questo elemento come sua % di completamento
                  }
                });

                //console.log(running_perc);

                if (parseInt(running_perc) >= 100) {

                  // Metto complete.
                  db.query("UPDATE clips SET progress = 'COMPLETE', ingested = 1, error = 0, progress_perc = 100 WHERE id = ?", [job.id], (qerr, update_job) => {

                    jobs_done++;
                    if (jobs_done >= jobs.length) return resolve();

                  })

                } else {

                  // Verifico nei tasks.
                  assetObject.taskList.forEach(task => {
                    if (job.assets.includes('urn:uuid:' + task.asset_id)) {
                      running_perc += ((100 / total_assets) / 100) * Number(task.progress);
                    }
                  });



                  //console.log(job.id + '>' + running_perc);
                  // faccio l'update solamente se il progress è cambiato da quello della select del job

                  db.query("UPDATE clips SET progress_perc = ? WHERE id = ?", [running_perc, job.id], (qerr, updated) => {

                    jobs_done++;
                    if (jobs_done >= jobs.length) return resolve();

                  });


                }

              }, (callback_job) => {

                return resolve();

              });

            });

          });

        });

      });

    }




    service_().then(done => {

      clearTimeout(timeoutMonitorHULA);
      timeoutMonitorHULA = setTimeout(() => {

        monitorCertificationHULA();

      }, 3000);

    }).catch(err => {

      clearTimeout(timeoutMonitorHULA);
      timeoutMonitorHULA = setTimeout(() => {

        monitorCertificationHULA();

      }, 3000);


    });




  }


  // ==========================================================
  // FINE FUNZIONE DI INGEST CPL / REGISTRAZIONE HULA
  // ==========================================================



  // ==========================================================
  // INIZIO ROBA SYSTEM HEALTH
  // ==========================================================

  var timeout_systemhealth = null;
  systemHealthBackground();

  function systemHealthBackground() {

    clearTimeout(timeout_systemhealth);

    // Systemhealth background checks.
    const _service = () => {

      return new Promise((resolve, reject) => {

        let health = {

          primary: [],
          secondary: [],

        }

        if (typeof db === 'undefined') return resolve();

        // Prendo solo i datastore che sono in uso in m_imb, così se ne avessi 1000 in tabella prendiamo solo quelli effettivamente usati come primario\backup u know
        db.query("SELECT a.* FROM m_datastores a LEFT JOIN m_imb b on b.id_datastore = a.id or b.id_datastore_backup = a.id WHERE b.id is not null GROUP BY a.id", (qerr, datastores) => {

          let count_datastore = 0;

          async.forEachOf(datastores, (datastore, index_d, callback_datastore) => {

            // Mi connetto ad ogni datastore.
            let conn = new Client();
            conn.on('ready', function () {

              // Prendo gli IMB che hanno il datastore primario\secondario = a quello a cui sono connesso ora.
              db.query("SELECT a.* , b.id as id_theater, b.name FROM m_imb a LEFT JOIN m_theaters b on b.id_imb = a.id WHERE (a.id_datastore = ? or a.id_datastore_backup = ?) and b.id is not null", [datastore.id, datastore.id], (qerr, theaters) => {

                if (qerr || theaters.length === 0) {
                  // Nessun teatro per questo datastore ne primario ne secondario, non faccio niente.
                  // Ipoteticamente, grazie alla query iniziale non dovrebbe mai finire qui.
                }

                let count_imb = 0;

                async.forEachOf(theaters, (imb, index_imb, callback_imb) => {

                  let current_imb = {

                    id_theater: imb.id_theater,
                    theater: imb.name,
                    imb: imb.type,
                    engine_on: false,

                  }

                  conn.exec('docker -H :3000 container inspect ' + imb.cineplayer_docker, (err, stream) => {

                    if (err || typeof stream === 'undefined') {

                      count_imb++;
                      if (count_imb >= theaters.length) return callback_imb(true);
                      return;

                    }

                    let output = '';
                    stream.on('close', () => {

                      // stato json del docker
                      try {

                        let json_docker = JSON.parse(output);

                        if (typeof json_docker[0] !== 'undefined' && typeof json_docker[0].State !== 'undefined') {
                          // POssiamo leggere lo stato del container
                          current_imb.engine_on = json_docker[0].State.Running && !json_docker[0].State.Dead && Number(json_docker[0].State.Pid) > 0 && json_docker[0].State.Error === '';
                        }



                        if (imb.id_datastore === datastore.id)
                          health.primary.push(current_imb);

                        // Può essere che il secondario sia uguale al primario quindi lo addiamo qui ezpz
                        if (imb.id_datastore_backup === datastore.id)
                          health.secondary.push(current_imb);

                        count_imb++;
                        if (count_imb >= theaters.length) return callback_imb(true);

                      } catch (error) {

                        //console.log(error)
                        count_imb++;
                        if (count_imb >= theaters.length) return callback_imb(true);

                      }

                    }).on('data', (chunk) => { output += chunk });

                  });

                }, (callbacked_imb) => {

                  count_datastore++;
                  if (count_datastore >= datastores.length) return callback_datastore(true);

                });

              })

            }).on('error', (error) => {

              // Errore connessione al datastore
              console.log(error)
              count_datastore++;
              if (count_datastore >= datastores.length) return callback_datastore(true);

            }).connect({

              host: datastore.address,
              port: 22,
              username: datastore.username,
              password: datastore.password,

            });


          }, (callbacked_status) => {

            //console.log(health)

            // Abbiamo lo stato degli engine e altro in caso andasse aggiunto 
            const json_systemhealth = { type: 'system_health_dockers', body: health, date: new Date() };
            asyncWsBroadcast(json_systemhealth);

            return resolve();

          });

        });

      })

    }


    _service().then(x_ => {

      clearTimeout(timeout_systemhealth);
      timeout_systemhealth = setTimeout(() => {
        systemHealthBackground();
      }, 1000);

    }).catch(err => {

      clearTimeout(timeout_systemhealth);
      timeout_systemhealth = setTimeout(() => {
        systemHealthBackground();
      }, 1000);

    });


  }








  // ==========================================================
  // FINE ROBA SYSTEM HEALTH
  // ==========================================================



  // WEBSOCKET.................

  const wss = new WebSocket.Server({ port: 48002, clientNoContextTakeover: true });
  wss.on('connection', function connection(ws) {

    ws.id = uuidv4().toString(); // assegno un id

    ws.on('message', function incoming(data) {

      const json_response = JSON.parse(data);

      if (json_response.type === 'CPLSTATUS') {
        sendCplStatusWS(ws, json_response.id);
      }

      if (json_response.type === 'CPLSTATUS_DETAIL_CLIP') {
        sendCplStatusWS_DETAILS(ws, json_response.id);
      }

      if (json_response.type === 'CLEAR_CPLSTATUS_DETAIL_CLIP') {

        if (typeof intervalSendCplStatus_detailed[ws.id] !== 'undefined')
          clearInterval(intervalSendCplStatus_detailed[ws.id]);

      }

      if (json_response.type === 'CLEAR_CPLSTATUS') {

        if (typeof intervalSendCplStatus[ws.id] !== 'undefined')
          clearInterval(intervalSendCplStatus[ws.id]);

      }

    });

  });

  // FINE WEBSOCKET........................................................................



  // CRONTASK x NOTIFICHE ECC:::

  globalReadBeatStreamer();
  globalSendBeatStreamer();

  const initStreamerCop = async () => {

    //return false;

    const { exec } = __webpack_require__(63129);

    const ls = exec('php ./streamercop/streamercop.php', function (error, stdout, stderr) {
      if (error) {
        console.log(error.stack);
        console.log('Error code: ' + error.code);
        console.log('Signal received: ' + error.signal);
      }
    });


    ls.on('exit', function (code) {

      initStreamerCop();

    });


  }

  var intervalIngestProgress;

  const ingestProgressList = async () => {

    intervalIngestProgress = setInterval(() => {

      if (typeof db === 'undefined') return false;

      db.query("SELECT * FROM dci_import_task WHERE TimeStamp >= DATE_ADD(NOW(), INTERVAL -180 MINUTE) ORDER BY Timestamp DESC", (qerr, result) => {

        const json_response = { type: 'DCI_IMPORT_TASK', body: result, timestamp: getTimestamp() };
        asyncWsBroadcast(json_response);

      })

    }, 1000);

  }


  //StreamerCop
  console.log('AVVIO STREAMERCOP - Api');
  initStreamerCop();
  ingestProgressList();


  var streamerCron;
  var streamerBeatStatus = { loading: true };
  var streamerScheduleStatus = {};

  function globalReadBeatStreamer() {
    clearTimeout(streamerCron);
    sendBeatStatus().then(res_ => {

      // invio il beat status di streamer
      streamerBeatStatus = { type: 'pings', body: res_, date: new Date() };

      // Prendo l'integrity schedule
      let time = new Date().toLocaleTimeString().split(":");
      let temp_ = null;
      if (time[0] >= 0 && time[0] < 6) {
        // prendo ieri.
        temp_ = new Date(new Date().setDate(new Date().getDate() - 1));
      } else {
        // prendo oggi
        temp_ = new Date();
      }

      let dayId = temp_.getFullYear() + (parseInt(Number(temp_.getMonth()) + 1) < 10 ? ('0' + parseInt(Number(temp_.getMonth()) + 1)) : temp_.getMonth() + 1)
        + (Number(temp_.getDate()) < 10 ? '0' + Number(temp_.getDate()) + 1 : temp_.getDate());

      checkIntegritySchedule(dayId).then(integrity => {

        streamerScheduleStatus = { type: 'schedule_integrity', body: integrity, date: new Date() };
        streamerCron = setTimeout(() => { globalReadBeatStreamer(); }, 15000);

      })

    }).catch(err => {
      console.log(err);
    });
  }


  // Siccome la funzione che si legge lo stato la eseguo una volta ogni 15 secondi (in più è async), mi serve una funzione che abbia
  // l'ultimo stato sempre disponibile e che possa inviarlo in broadcast a tutti i client subito dopo la connessione al ws
  // In questa maniera diminuisco la latenza tra richiesta\lettura dello stato senza influire sulla qualità dei dati.
  var streamerSendBeat;
  function globalSendBeatStreamer() {

    clearTimeout(streamerSendBeat);
    wss.clients.forEach(function each(client) {
      if (client.readyState === WebSocket.OPEN) {
        client.send(JSON.stringify(streamerBeatStatus));
        client.send(JSON.stringify(streamerScheduleStatus));
      }
    });

    streamerSendBeat = setTimeout(() => { globalSendBeatStreamer(); }, 1000);
  }


  /// ----------- CLIENT WEBSOCKET ----------------------

  var timeout_socket_client = [];
  var timeout_socket_client_dvm = [];

  var intervalStatus = [];
  var count_status = 0;

  function connectPlayoutWebsocket(index, playout_object) {

    const port_f = playout_object.port;
    clearTimeout(timeout_socket_client[index]);
    let interval_ = 250;

    db.query("SELECT int_value FROM m_generalsettings WHERE key1='test_settings' AND key2='interval'", (qerr, result_) => {

      if (result_.length > 0) interval_ = result_[0].int_value;

      try {



        clientWebSockets[index] = new WebSocket('ws://' + playout_object.address + ':' + playout_object.port + '/ws', null, 3500);
        clientWebSockets[index].on('open', function open() {

          console.log("CONNESSO AL PLAYOUT " + 'ws://' + playout_object.address + ':' + playout_object.port + '/ws');
          clientWebSockets[index].send('CONTENT-STATUS\n');
          clientWebSockets[index].send('TIMELINE-FULL\n');
          clientWebSockets[index].send('PLAYBACK-INFO\n');
          clientWebSockets[index].send('SCHEDULE-LIST\n');

          // Intervallo di send status ai client, cambiato a 250ms per evitare troppi refresh inutili da parte del client.
          intervalStatus[index] = setInterval(() => {
            sendStatusClient(index);
          }, interval_)

          status_playout_array[index] = { name: playout_ws_ports[index].name }
          timeline_playout_array[index] = { name: playout_ws_ports[index].name }

          sendStatusClient(index); // Invio e creo timeout


          //return resolve();

        })

      } catch (error) {

        console.log(error)

      }


      clientWebSockets[index].on('message', function incoming(data) {

        // Devo capire cosa sia questa response.
        let split_response = data.split("{");

        if (typeof split_response[0] === 'undefined')
          return false;

        const entry_response = split_response[0].replace(/\n/g, "");
        let response_json = data.substring((entry_response.length), data.length);
        const data_json = JSON.parse(response_json);

        if (entry_response === 'CONTENT-STATUS') {

          status_playout_array[index] = data_json;
          status_playout_array[index].name = playout_ws_ports[index].name; // Aggiungo il name

          // Mando ai client
          //sendStatusClient(index);
          if (clientWebSockets[index].readyState === WebSocket.OPEN) {
            //count_status++;
            //console.log(count_status);

            setTimeout(() => {
              clientWebSockets[index].send('CONTENT-STATUS\n');
            }, 333);
          }

        }


        if (entry_response === 'PLAYBACK-INFO') {

          status_playback_array[index] = data_json;
          status_playback_array[index].name = playout_ws_ports[index].name; // Aggiungo il name
          // Mando ai client
          //sendStatusClient(index);
          if (clientWebSockets[index].readyState === WebSocket.OPEN) {
            setTimeout(() => {
              clientWebSockets[index].send('PLAYBACK-INFO\n');
            }, 333);
          }

        }

        if (entry_response === 'TIMELINE-FULL') {

          timeline_playout_array[index] = data_json;
          timeline_playout_array[index].name = playout_ws_ports[index].name; // Aggiungo il name

          // Mando ai client
          //sendStatusClient(index);
          if (clientWebSockets[index].readyState === WebSocket.OPEN) {
            setTimeout(() => {
              clientWebSockets[index].send('TIMELINE-FULL\n');
            }, 333);
          }

        }

        if (entry_response === 'CONTENT-GETPLAYSEQUENCE') {

          let response = { type: 'getshow', body: data_json, date: new Date(), index: index };
          wss.clients.forEach(function each(client) {
            if (client.readyState === WebSocket.OPEN) {
              client.send(JSON.stringify(response));
            }
          });

        }

        if (entry_response === 'SCHEDULE-LIST') {

          schedule_list_theater[index] = data_json;
          if (clientWebSockets[index].readyState === WebSocket.OPEN) {

            setTimeout(() => {
              clientWebSockets[index].send('SCHEDULE-LIST\n');
            }, 333);
          }

        }

        if (entry_response === 'SCHEDULE-ADD') {
          //console.log(data_json);
        }

      });

      clientWebSockets[index].on('error', (err) => {
        //return reject();

        //console.log(err)

        status_playout_array[index] = { name: playout_ws_ports[index].name, content: { status: 'offline' } };
        timeline_playout_array[index] = { name: playout_ws_ports[index].name, items: [] };
        status_playback_array[index] = { name: playout_ws_ports[index].name, content: { status: 'offline' } };
        schedule_list_theater[index] = { name: playout_ws_ports[index].name, items: [] }
        clearInterval(intervalStatus[index]);
        //sendStatusClient(index);

      });

      clientWebSockets[index].on('close', () => {

        timeline_playout_array[index] = { name: playout_ws_ports[index].name, items: [] };
        status_playout_array[index] = { name: playout_ws_ports[index].name, content: { status: 'offline' } };
        status_playback_array[index] = { name: playout_ws_ports[index].name, content: { status: 'offline' } };
        schedule_list_theater[index] = { name: playout_ws_ports[index].name, items: [] }

        clearInterval(intervalStatus[index]);
        sendStatusClient(index);
        timeout_socket_client[index] = setTimeout(() => { connectPlayoutWebsocket(index, playout_ws_ports[index]) }, 5000); // Ritento la connessione al websocket in 5 secondi

      });

    });

  }

  function connectDeviceManagerWebsocket(index, dvm_object) {

    const port_f = dvm_object.port;
    clearTimeout(timeout_socket_client_dvm[index]);

    clientWebSocketsDVM[index] = new WebSocket('ws://' + dvm_object.address + ':' + dvm_object.port + '/ws', null, 2500);
    clientWebSocketsDVM[index].on('open', function open() {

      console.log("CONNESSO AL DEVICEMANAGER " + 'ws://' + dvm_object.address + ':' + dvm_object.port + '/ws');

      // VERIFICO SE SONO CONNESSO AL DEVICEMANAGER DI QUESTO TEATRO...
      if (typeof clientWebSocketsDVM[index] !== 'undefined')
        if (clientWebSocketsDVM[index].readyState === WebSocket.OPEN) {
          clientWebSocketsDVM[index].send('STATUS');

        }




    });

    clientWebSocketsDVM[index].on('message', function incoming(data) {

      const entry_response = data.split(/\n/g);
      let data_response = entry_response[1];

      if (entry_response[0] === 'STATUS');

      xml2js.parseString(data_response, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, json_res) {

        status_devicemanager_array[index] = json_res;

        // Rimando comando status
        if (clientWebSocketsDVM[index].readyState === WebSocket.OPEN) {
          setTimeout(() => {
            clientWebSocketsDVM[index].send('STATUS');
          }, 333);
        }


      });

    });

    clientWebSocketsDVM[index].on('error', (err) => {

      //console.log(err);

      status_devicemanager_array[index] = {};

    });

    clientWebSocketsDVM[index].on('close', () => {

      status_devicemanager_array[index] = {};
      timeout_socket_client_dvm[index] = setTimeout(() => { connectDeviceManagerWebsocket(index, devicemanager_ws_ports[index]) }, 5000); // Ritento la connessione al websocket in 5 secondi

    });


  }








  function sendStatusClient(index) {

    fillTimelineWithInfos(timeline_playout_array[index]).then(timeline_filled => {
      fillStatusWithInfos(status_playout_array[index]).then(status_filled => {

        wss.clients.forEach(function each(client) {

          let response = { type: 'get_status', body: status_playout_array[index], date: new Date(), index: index };
          let response_timeline = { type: 'timeline', body: timeline_filled, date: new Date(), index: index };
          let response_playback = { type: 'playback', body: status_playback_array[index], date: new Date(), index: index };
          let response_schedule = { type: 'schedule_list', body: schedule_list_theater[index], date: new Date(), index: index };
          let response_dvm = { type: 'devicemanager', body: status_devicemanager_array[index], date: new Date(), index: index };

          let status_payload = {

            type: 'status_payload',
            index: index,
            getstatus: response,
            timeline: response_timeline,
            playback: response_playback,
            schedule_list: response_schedule,
            device_manager: response_dvm,

          }

          if (client.readyState === WebSocket.OPEN) {
            client.send(JSON.stringify(status_payload))
          }

        });

      });

    }).catch(err => {

      console.log(err);

    })

  }

  function INIT_PLAYOUT_WEBSOCKET() {
    // Piglio le porte.
    return new Promise((resolve, reject) => {

      console.log('...');

      if (typeof db === 'undefined') {
        return resolve();
      }

      db.query("SELECT a.* , c.address FROM m_theaters a LEFT JOIN m_imb b ON b.id = a.id_imb LEFT JOIN m_datastores c ON c.id = b.id_datastore ORDER BY a.theater_nr", (qerr, result) => {

        //console.log(result);

        //let starting_port = 8089;
        async.forEachOf(result, (theater, key, callback) => {

          //theater.address = "192.168.14.202";

          // DEBUG
          //const port___ = key !== 1 ? Number("48" + (Number(key + 1) < 10 ? "0" + Number(key + 1) : Number(key + 1)).toString() + "5") : 8091;
          //const port___dvm = key !== 1 ? Number("48" + (Number(key + 1) < 10 ? "0" + Number(key + 1) : Number(key + 1)).toString() + "2") : 8080;

          // REALI
          const port___ = Number("48" + (Number(key + 1) < 10 ? "0" + Number(key + 1) : Number(key + 1)).toString() + "5");
          const port___dvm = Number("48" + (Number(key + 1) < 10 ? "0" + Number(key + 1) : Number(key + 1)).toString() + "3");

          playout_ws_ports.push({ theater_id: theater.id, name: theater.name, port: port___, address: theater.address });
          devicemanager_ws_ports.push({ theater_id: theater.id, name: theater.name, port: port___dvm, address: theater.address })
          //if(key === result.length)
          return callback();

        }, (callback) => {
          // Piglio l'ip playout
          console.log('--- cineplayout ports ---');
          console.log(playout_ws_ports);
          console.log('--- devicemanager ports ---');
          console.log(devicemanager_ws_ports);

          getPlayoutIP().then(res_ => {

            //console.log("resolve")
            return resolve();

          });

        });
      });



    });
  }

  INIT_PLAYOUT_WEBSOCKET().then(ok => {

    //console.log('init')

    async.forEachOf(playout_ws_ports, (port, key, callback) => {

      connectDeviceManagerWebsocket(key, devicemanager_ws_ports[key]);
      connectPlayoutWebsocket(key, playout_ws_ports[key]);

    }, (callback) => {

      return true;

    });

  });



  //


  // API STREAMER..........................................................................

  app.get('/api/get/theaters', function (req, res) {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
   
        return res.status(500).send({ error : 'database_failure' });
      }*/

    db.query("SELECT a.* , b.serial , b.type, b.address FROM m_theaters a LEFT JOIN m_imb b on b.id = a.id_imb ORDER BY a.theater_nr", function (qerr, result) {

      /*db.release();*/
      // Errore query.
      if (qerr) { return res.status(500).send({ error: '/api/get/theaters -> query_1 error' }); }

      return res.status(200).send(result);

    });

    //});

  });


  app.get('/api/get/theater/:id', function (req, res) {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
   
        return res.status(500).send({ error : 'database_failure' });
      }*/

    const id_theater = sanitizeString(req.params.id);
    var result_global = {};

    db.query("SELECT * FROM m_theaters WHERE id = ?", [id_theater], function (qerr, result) {

      // Errore query.
      if (qerr) { /*db.release();*/ return res.status(500).send({ error: '/api/get/theaters -> query_1 error' }); }
      result_global = result[0];

      db.query("SELECT b.* FROM m_theaters a LEFT JOIN m_imb b ON a.id_imb = b.id WHERE a.id = ?", [id_theater], function (qerr, result) {

        // Errore query.
        if (qerr || result.length === 0) { /*db.release();*/ return res.status(500).send({ error: '/api/get/theaters -> query_2 error' }); }
        result_global.imb = result[0];

        db.query("SELECT b.* FROM m_theaters a LEFT JOIN m_projector b ON a.id_projector = b.id WHERE a.id = ?", [id_theater], function (qerr, result) {

          if (qerr) { /*db.release();*/ return res.status(500).send({ error: '/api/get/theaters -> query_3 error' }); }
          result_global.projector = result[0];

          db.query("SELECT b.* FROM m_theaters a LEFT JOIN m_audioprocessor b ON a.id_audioprocessor = b.id WHERE a.id = ?", [id_theater], function (qerr, result) {

            if (qerr) { /*db.release();*/ return res.status(500).send({ error: '/api/get/theaters -> query_4 error' }); }
            result_global.audio = result[0];

            db.query("SELECT b.* FROM m_theaters a LEFT JOIN m_gpi b ON a.id_gpi = b.id WHERE a.id = ?", [id_theater], function (qerr, result) {

              if (qerr) { /*db.release();*/ return res.status(500).send({ error: '/api/get/theaters -> query_5 error' }); }
              result_global.gpi = result[0];

              db.query("SELECT b.* FROM m_theaters a LEFT JOIN m_switch b ON a.id_switch = b.id WHERE a.id = ?", [id_theater], function (qerr, result) {

                ///*db.release();*/

                if (qerr) { return res.status(500).send({ error: '/api/get/theaters -> query_6 error' }); }
                result_global.switch = result[0];


                const nameInstance = id_theater;

                // PRENDO IL DEVICE MANAGER DEL PROIETTORE. -> Projector_TimeoutReadStatus
                // prendo gli enabled da tutti i device.

                /*db.release();*/

                getDevicesValues(nameInstance, id_theater, devices_list, "_TimeoutReadStatus", true).then(temp_devices => {

                  // Li assegno
                  result_global.projector.timeout_read_status = temp_devices.projector.Projector_TimeoutReadStatus !== null ? temp_devices.projector.Projector_TimeoutReadStatus : 3000;
                  result_global.audio.timeout_read_status = temp_devices.audio.AudioProcessor_TimeoutReadStatus !== null ? temp_devices.audio.AudioProcessor_TimeoutReadStatus : 3000;
                  result_global.gpi.timeout_read_status = temp_devices.gpi.Gpi_TimeoutReadStatus !== null ? temp_devices.gpi.Gpi_TimeoutReadStatus : 3000;
                  result_global.switch.timeout_read_status = temp_devices.switch.VideoRouter_TimeoutReadStatus !== null ? temp_devices.switch.VideoRouter_TimeoutReadStatus : 3000;

                  getDevicesValues(nameInstance, id_theater, devices_list, "Enabled", false).then(temp_devices => {

                    result_global.projector.enabled = temp_devices.projector.Enabled !== null ? (temp_devices.projector.Enabled === "1" ? true : false) : false;
                    result_global.audio.enabled = temp_devices.audio.Enabled !== null ? (temp_devices.audio.Enabled === "1" ? true : false) : false;
                    result_global.gpi.enabled = temp_devices.gpi.Enabled !== null ? (temp_devices.gpi.Enabled === "1" ? true : false) : false;
                    result_global.switch.enabled = temp_devices.switch.Enabled !== null ? (temp_devices.switch.Enabled === "1" ? true : false) : false;

                    return res.status(200).send(result_global);

                  });

                }).catch(error_dvm => {

                  return res.status(500).send({ error: '/api/get/theaters -> getdevicevalues_1 error' });

                });

              });

            });

          });

        });

      });

    });

    //});

  });



  app.get('/api/get/datastores', function (req, res) {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
   
        return res.status(500).send({ error : 'database_failure' });
      }*/

    db.query("SELECT * FROM m_datastores ORDER BY name", function (qerr, result) {

      /*db.release();*/
      if (qerr) { return res.status(500).send({ error: '/api/get/datastores -> query_1 error' }); }
      return res.status(200).send(result);

    });


    //});

  });


  app.get('/api/get/datastore/:id', function (req, res) {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
   
        return res.status(500).send({ error : 'database_failure' });
      }*/

    const datastore_id = Number(req.params.id);

    db.query("SELECT * FROM m_datastores WHERE ID = ?", [datastore_id], function (qerr, result) {

      /*db.release();*/
      if (qerr) { return res.status(500).send({ error: '/api/get/datastore/:id -> query_1 error' }); }
      return res.status(200).send(result[0]);

    });


    //  });

  });

  // Update di un datastore
  app.post('/api/post/datastore/:id', (req, res) => {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
   
        return res.status(500).send({ error : 'database_failure' });
      }*/

    const payload = req.body.payload;
    const datastore_id = Number(req.params.id);

    db.query("UPDATE m_datastores SET name = ?, address = ?, manager_address = ?, username = ?, password = ?, filesystem_type = ?, port = ?, hula_store_docker = ? WHERE id = ?",
      [sanitizeString(payload.name), sanitizeString(payload.address), sanitizeString(payload.manager_address), sanitizeString(payload.username), payload.password, sanitizeString(payload.filesystem_type), Number(payload.port), sanitizeString(payload.hula_store_docker), datastore_id],
      (qerr, result) => {

        /*db.release();*/
        if (qerr) { return res.status(500).send({ error: '/api/post/datastore/:id -> query_1 error' }); }

        return res.status(200).send({ status: 1 });

      })

    //});

  });
  // Inserimento\creazione datastore
  app.post('/api/post/datastore', (req, res) => {

    /*  pool.getConnection(function(conn_err, db){
        if(conn_err){ // connessione db fallita
    
          return res.status(500).send({ error : 'database_failure' });
        }*/

    const payload = req.body.payload;

    db.query("INSERT INTO m_datastores (name, address, manager_address, username, password, filesystem_type, port, hula_store_docker) VALUES (?,?,?,?,?,?,?,?)",
      [sanitizeString(payload.name), sanitizeString(payload.address), sanitizeString(payload.manager_address), sanitizeString(payload.username), payload.password, sanitizeString(payload.filesystem_type), Number(payload.port), sanitizeString(payload.hula_store_docker)],
      (qerr, result) => {



        /*db.release();*/
        if (qerr) { return res.status(500).send({ error: '/api/post/datastore -> query_1 error' }); }

        return res.status(200).send({ status: 1 });

      })

    //  });

  });

  app.post('/api/post/theater/:id', function (req, res) {

    //console.log(req.body);
    const payload = req.body.payload;
    const id_theater = sanitizeString(req.params.id);

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
   
        return res.status(500).send({ error : 'database_failure' });
      }*/

    // Aggiorno m_theaters
    db.query("UPDATE m_theaters SET name = ? , theater_nr = ? , description = ? , note = ? WHERE ID = ?",
      [sanitizeString(payload.name),
      sanitizeString(payload.theater_nr),
      sanitizeString(payload.description),
      sanitizeString(payload.note),
      sanitizeString(id_theater)],
      function (qerr, result) {

        // Errore update di m_theaters
        if (qerr) { /*db.release();*/ return res.status(500).send({ error: '/api/post/theater/:id -> query_1 error' }); }

        // Gestisco le modalità
        if (payload.imb.type === 'HULA') {
          payload.imb.direct_streaming = false;
          payload.imb.certified = true;
          payload.imb.self_schedule = false;
        } else {
          payload.imb.certified = false; // Certified è deprecato, solo l'HULA lo accetta ma comunque sia non lo considero nemmeno perchè l'HULA va gestito sempre allo stesso modo...
        }

        // Aggiorno m_imb
        db.query("UPDATE m_imb SET type = ? , address = ? , port = ? , direct_streaming = ? , certified = ? , self_schedule = ? , " +
          " id_datastore = ? , id_datastore_backup = ? , api_username = ? , api_password = ?, kdm_serial = ? , serial = ? , cineplayer_docker = ? WHERE ID = ?",
          [sanitizeString(payload.imb.type),
          sanitizeString(payload.imb.address),
          sanitizeString(payload.imb.port),
          Number(payload.imb.direct_streaming),
          Number(payload.imb.certified),
          Number(payload.imb.self_schedule),
          sanitizeString(payload.imb.id_datastore),
          sanitizeString(payload.imb.id_datastore_backup),
          sanitizeString(payload.imb.api_username),
          sanitizeString(payload.imb.api_password),
          sanitizeString(payload.imb.kdm_serial),
          sanitizeString(payload.imb.serial),
          sanitizeString(payload.imb.cineplayer_docker),
          sanitizeString(payload.imb.id)],
          (qerr, result) => {

            // Errore update m_imb
            if (qerr) { /*db.release();*/ return res.status(500).send({ error: '/api/post/theater/:id -> query_2 error' }); }

            // Aggiorno m_audioprocessor
            db.query("UPDATE m_audioprocessor SET type = ? , address = ? , port = ? , serial = ? , kdm_serial = ? WHERE ID = ?",
              [sanitizeString(payload.audio.type),
              sanitizeString(payload.audio.address),
              sanitizeString(payload.audio.port),
              sanitizeString(payload.audio.serial),
              sanitizeString(payload.audio.kdm_serial),
              sanitizeString(payload.audio.id)],
              (qerr, result) => {

                // Errore update m_imb
                if (qerr) { /*db.release();*/ return res.status(500).send({ error: '/api/post/theater/:id -> query_3 error' }); }

                // Aggiorno m_projector
                db.query("UPDATE m_projector SET type = ? , address = ? , port = ? WHERE ID = ?",
                  [sanitizeString(payload.projector.type),
                  sanitizeString(payload.projector.address),
                  sanitizeString(payload.projector.port),
                  sanitizeString(payload.projector.id)],
                  (qerr, result) => {

                    // Errore update m_projector
                    if (qerr) { /*db.release();*/ return res.status(500).send({ error: '/api/post/theater/:id -> query_4 error' }); }

                    // Aggiorno m_gpi
                    db.query("UPDATE m_gpi SET type = ? , address = ? , port = ? WHERE ID = ?",
                      [sanitizeString(payload.gpi.type),
                      sanitizeString(payload.gpi.address),
                      sanitizeString(payload.gpi.port),
                      sanitizeString(payload.gpi.id)],
                      (qerr, result) => {

                        // Errore update m_gpi
                        if (qerr) { /*db.release();*/ return res.status(500).send({ error: '/api/post/theater/:id -> query_5 error' }); }

                        // Aggiorno m_switch
                        db.query("UPDATE m_switch SET type = ? , address = ? , port = ? WHERE ID = ?",
                          [sanitizeString(payload.switch.type),
                          sanitizeString(payload.switch.address),
                          sanitizeString(payload.switch.port),
                          sanitizeString(payload.switch.id)],
                          (qerr, result) => {

                            /*db.release();*/
                            // Errore update m_gpi
                            if (qerr) { return res.status(500).send({ error: '/api/post/theater/:id -> query_6 error' }); }

                            updateDeviceManager(payload, id_theater).then(update_res => {

                              return res.status(200).send({ status: 1 }); // Update completata.

                            }).catch(err => {

                              return res.sendStatus(500);

                            });

                          });

                      });

                  });

              });

          });

      });


    //  });

  });



  // CREAZIONE NUOVO TEATRO.....................
  app.post("/api/post/theater", (req, res) => {

    const payload = req.body.payload;

    createTheaterDB(payload, db).then(result => {

      return res.sendStatus(200);

    }).catch(error => {

      return res.status(500).send(error);

    })


    //  });

  });


  app.get('/api/get/init/theater', (req, res) => {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
   
        return res.status(500).send({ error : 'database_failure' });
      }*/

    db.query("SELECT (MAX(theater_nr)+1) as new_nr FROM m_theaters ", (qerr, result) => {

      /*db.release();*/
      if (qerr) { return res.status(500).send({ error: '/api/get/init/theater -> query_1 error' }); }
      return res.status(200).send({ new_nr: result[0].new_nr === null ? 1 : result[0].new_nr });

    });

    //  });

  });

  app.post('/api/post/theaternotes/:id', function (req, res) {

    /*  pool.getConnection(function(conn_err, db){
        if(conn_err){ // connessione db fallita
   
          return res.status(500).send({ error : 'database_failure' });
        }*/

    const theater_id = req.params.id;
    const notes = sanitizeString(req.body.payload);

    db.query("UPDATE m_theaters SET note = ? WHERE ID = ?", [notes, theater_id], function (qerr, result) {

      /*db.release();*/
      if (qerr) { return res.status(500).send({ error: '/api/get/theaternotes -> query_1 error' }); }
      return res.status(200).send({ status: 1 });

    });


    //  });

  })

  app.post('/api/post/test/address', (req, res) => {

    const ip_to_test = req.body.address;
    ping.sys.probe(ip_to_test, (isAlive) => {

      res.status(200).send({ is_alive: isAlive });

    });

  });


  function updateDeviceManager(payload, id_theater) {

    return new Promise((resolve, reject) => {

      /*pool.getConnection(function(conn_err, db){
        if(conn_err){ // connessione db fallita
   
          return reject(); // Db failure
        }*/

      const nameInstance = id_theater;

      // Cerco i type dei vari device e controllo se sono da cambiare.
      getAllDeviceValues(nameInstance).then(devices => {

        async.forEachOf(devices_list, (device_, key, callback) => {

          let sql_string = "";
          let sql_params = [];
          let deviceID = 0;

          switch (device_) {

            case 'projector':
              // Aggiorno type
              db.query("UPDATE m_device_settings SET VALUESTRING = ? WHERE ID = ?", [payload.projector.type, devices["7"].Projector_Type.id], (qerr, result) => {
                if (qerr) { return callback(false); }
                // Aggiorno la description
                db.query("UPDATE m_device_settings SET VALUESTRING = ? WHERE ID = ?", [projector_type_label[payload.projector.type], devices["7"].Projector_Description.id], (qerr, result) => {
                  if (qerr) { return callback(false); }
                  // Aggiorno il timeout_read_status
                  db.query("UPDATE m_device_settings SET VALUESTRING = ? WHERE ID = ?", [payload.projector.timeout_read_status, devices["7"].Projector_TimeoutReadStatus.id], (qerr, result) => {
                    if (qerr) { return callback(false); }
                    // Aggiorno la serialport
                    const serialport = sanitizeString(payload.projector.port) + ":" + sanitizeString(payload.projector.address)
                    db.query("UPDATE m_device_settings SET VALUESTRING = ? WHERE ID = ?", [serialport, devices["7"].SerialPort.id], (qerr, result) => {
                      if (qerr) { return callback(false); }
                      // Aggiorno l'enabled
                      db.query("UPDATE m_device_settings SET VALUESTRING = ? WHERE ID = ?", [Number(payload.projector.enabled), devices["7"].Enabled.id], (qerr, result) => {
                        if (qerr) { return callback(false); }
                        return callback(true);
                      });
                    });
                  });
                });
              });
              break;


            case 'audio':

              // Aggiorno type
              db.query("UPDATE m_device_settings SET VALUESTRING = ? WHERE ID = ?", [payload.audio.type, devices["6"].AudioProcessor_Type.id], (qerr, result) => {
                if (qerr) { return callback(false); }
                // Aggiorno la description
                db.query("UPDATE m_device_settings SET VALUESTRING = ? WHERE ID = ?", [audioprocessor_type_label[payload.audio.type], devices["6"].AudioProcessor_Description.id], (qerr, result) => {
                  if (qerr) { return callback(false); }
                  // Aggiorno il timeout_read_status
                  db.query("UPDATE m_device_settings SET VALUESTRING = ? WHERE ID = ?", [payload.audio.timeout_read_status, devices["6"].AudioProcessor_TimeoutReadStatus.id], (qerr, result) => {
                    if (qerr) { return callback(false); }
                    // Aggiorno la serialport
                    const serialport = sanitizeString(payload.audio.port) + ":" + sanitizeString(payload.audio.address)
                    db.query("UPDATE m_device_settings SET VALUESTRING = ? WHERE ID = ?", [serialport, devices["6"].SerialPort.id], (qerr, result) => {
                      if (qerr) { return callback(false); }
                      // Aggiorno l'enabled
                      db.query("UPDATE m_device_settings SET VALUESTRING = ? WHERE ID = ?", [Number(payload.audio.enabled), devices["6"].Enabled.id], (qerr, result) => {
                        if (qerr) { return callback(false); }
                        return callback(true);
                      });
                    });
                  });
                });
              });
              break;

            case 'gpi':

              // Aggiorno type
              db.query("UPDATE m_device_settings SET VALUESTRING = ? WHERE ID = ?", [payload.gpi.timeout_read_status, devices["1"].Gpi_TimeoutReadStatus.id], (qerr, result) => {
                if (qerr) { return callback(false); }
                // Aggiorno la serialport
                const serialport = sanitizeString(payload.gpi.port) + ":" + sanitizeString(payload.gpi.address)
                db.query("UPDATE m_device_settings SET VALUESTRING = ? WHERE ID = ?", [serialport, devices["1"].SerialPort.id], (qerr, result) => {
                  if (qerr) { return callback(false); }
                  // Aggiorno l'enabled
                  db.query("UPDATE m_device_settings SET VALUESTRING = ? WHERE ID = ?", [Number(payload.gpi.enabled), devices["1"].Enabled.id], (qerr, result) => {
                    if (qerr) { return callback(false); }

                    // Se il type è cambiato, rimuovo le label e inserisco quelle del nuovo gpi device
                    if (Number(payload.gpi.type) !== Number(devices["1"].Gpi_Type.value)) {

                      // aggiorno il type
                      db.query("UPDATE m_device_settings SET VALUESTRING = ? WHERE ID = ?", [payload.gpi.type, devices["1"].Gpi_Type.id], (qerr, result) => {
                        if (qerr) { return callback(false); }

                        // rimuovo le label sia input che output.
                        db.query("DELETE FROM m_device_settings WHERE ID_DEVICE = ? AND KEY1 LIKE '%Gpi_Label%'", [devices["1"].Gpi_Type.id_device], (qerr, result) => {

                          sql_string = "INSERT INTO m_device_settings (ID_DEVICE, KEY1, VALUESTRING) VALUES";
                          sql_params = [];
                          // Prendo il deviceID.
                          deviceID = devices["1"].Gpi_Type.id_device;

                          // Aggiungo input
                          for (let i = 1; i <= parseInt(gpi_type_io[parseInt(payload.gpi.type)].i); i++) {
                            sql_string = sql_string + " (? , ? , ?) , (? , ? , '') ,";
                            sql_params.push(
                              deviceID, ("Gpi_LabelInput" + i.toString() + "_1"), ("IN " + i.toString()),
                              deviceID, ("Gpi_LabelInput" + i.toString() + "_2")
                            );
                          }

                          // Aggiungo output
                          for (let i = 1; i <= parseInt(gpi_type_io[parseInt(payload.gpi.type)].o); i++) {
                            sql_string = sql_string + " (? , ? , ?) , (? , ? , '') ,";
                            sql_params.push(
                              deviceID, ("Gpi_LabelOutput" + i.toString() + "_1"), ("OUT " + i.toString()),
                              deviceID, ("Gpi_LabelOutput" + i.toString() + "_2")
                            );
                          }

                          sql_string = sql_string.substring(0, (sql_string.length - 2));
                          db.query(sql_string, sql_params, (qerr, result) => {

                            if (qerr) { return callback(false); }

                            db.query("UPDATE m_device_settings SET VALUESTRING = ? WHERE ID = ?", [gpi_type_label[payload.gpi.type], devices["1"].Gpi_Description.id], (qerr, result) => {

                              if (qerr) { return callback(false); }

                              // Aggiorno maxinput del device
                              db.query("UPDATE m_device_settings SET VALUESTRING = ? WHERE ID = ?", [parseInt(gpi_type_io[parseInt(payload.gpi.type)].i), devices["1"].Gpi_MaxInput.id], (qerr, result) => {
                                if (qerr) { return callback(false); }

                                // Aggiorno maxoutput del device
                                db.query("UPDATE m_device_settings SET VALUESTRING = ? WHERE ID = ?", [parseInt(gpi_type_io[parseInt(payload.gpi.type)].o), devices["1"].Gpi_MaxOutput.id], (qerr, result) => {
                                  if (qerr) { return callback(false); }

                                  return callback(true);

                                });

                              });

                            });

                          });

                        });

                      });

                    } else {

                      // Il type non è cambiato, tutto ok.
                      callback(true);

                    }

                  });
                });
              });
              break;



            case 'switch':

              // Aggiorno type
              db.query("UPDATE m_device_settings SET VALUESTRING = ? WHERE ID = ?", [payload.switch.timeout_read_status, devices["0"].VideoRouter_TimeoutReadStatus.id], (qerr, result) => {
                if (qerr) { return callback(false); }
                // Aggiorno la serialport
                const serialport = sanitizeString(payload.switch.port) + ":" + sanitizeString(payload.switch.address)
                db.query("UPDATE m_device_settings SET VALUESTRING = ? WHERE ID = ?", [serialport, devices["0"].SerialPort.id], (qerr, result) => {
                  if (qerr) { return callback(false); }
                  // Aggiorno l'enabled
                  db.query("UPDATE m_device_settings SET VALUESTRING = ? WHERE ID = ?", [Number(payload.switch.enabled), devices["0"].Enabled.id], (qerr, result) => {
                    if (qerr) { return callback(false); }

                    // Se il type è cambiato, rimuovo le label e inserisco quelle del nuovo switch device
                    if (Number(payload.switch.type) !== Number(devices["0"].VideoRouter_Type.value)) {

                      // aggiorno il type
                      db.query("UPDATE m_device_settings SET VALUESTRING = ? WHERE ID = ?", [payload.switch.type, devices["0"].VideoRouter_Type.id], (qerr, result) => {
                        if (qerr) { return callback(false); }

                        // rimuovo le label sia input che output.
                        db.query("DELETE FROM m_device_settings WHERE ID_DEVICE = ? AND KEY1 LIKE '%VideoRouter_Label%'", [devices["0"].VideoRouter_Type.id_device], (qerr, result) => {

                          sql_string = "INSERT INTO m_device_settings (ID_DEVICE, KEY1, VALUESTRING) VALUES";
                          sql_params = [];
                          // Prendo il deviceID.
                          deviceID = devices["0"].VideoRouter_Type.id_device;

                          // Aggiungo input
                          for (let i = 1; i <= parseInt(switch_type_io[parseInt(payload.switch.type)].i); i++) {
                            sql_string = sql_string + " (? , ? , ?) , (? , ? , '') ,";
                            sql_params.push(
                              deviceID, ("VideoRouter_LabelInput" + i.toString() + "_1"), ("IN " + i.toString()),
                              deviceID, ("VideoRouter_LabelInput" + i.toString() + "_2")
                            );
                          }

                          // Aggiungo output
                          for (let i = 1; i <= parseInt(switch_type_io[parseInt(payload.switch.type)].o); i++) {
                            sql_string = sql_string + " (? , ? , ?) , (? , ? , '') ,";
                            sql_params.push(
                              deviceID, ("VideoRouter_LabelOutput" + i.toString() + "_1"), ("OUT " + i.toString()),
                              deviceID, ("VideoRouter_LabelOutput" + i.toString() + "_2")
                            );
                          }

                          sql_string = sql_string.substring(0, (sql_string.length - 2));
                          db.query(sql_string, sql_params, (qerr, result) => {

                            if (qerr) { return callback(false); }

                            db.query("UPDATE m_device_settings SET VALUESTRING = ? WHERE ID = ?", [switch_type_label[payload.switch.type], devices["0"].VideoRouter_Description.id], (qerr, result) => {
                              if (qerr) { return callback(false); }

                              // Aggiorno max Input del device
                              db.query("UPDATE m_device_settings SET VALUESTRING = ? WHERE ID = ?", [parseInt(switch_type_io[parseInt(payload.switch.type)].i), devices["0"].VideoRouter_MaxInput.id], (qerr, result) => {
                                if (qerr) { return callback(false); }

                                // Aggiorno max Output del device
                                db.query("UPDATE m_device_settings SET VALUESTRING = ? WHERE ID = ?", [parseInt(switch_type_io[parseInt(payload.switch.type)].o), devices["0"].VideoRouter_MaxOutput.id], (qerr, result) => {
                                  if (qerr) { return callback(false); }

                                  return callback(true);

                                });

                              });

                            });

                          });

                        });

                      });

                    } else {

                      // Il type non è cambiato, tutto ok.
                      callback(true);

                    }

                  });
                });
              });
              break;


          }

        }, (cb_err) => {

          // Mando il reload config       
          for (let i = 0; i < devicemanager_ws_ports.length; i++) {

            if (devicemanager_ws_ports[i].theater_id === Number(nameInstance)) {

              if (typeof clientWebSocketsDVM[i] !== 'undefined' && clientWebSocketsDVM[i].readyState === WebSocket.OPEN) {
                console.log('mando cmd');
                clientWebSocketsDVM[i].send('RELOADCONFIG\n');
              }

              break;

            }

          }

          resolve();

        });


      }).catch(err => {

        return reject();

      });

      //  });

    });

  }


  function getAllDeviceValues(nameInstance) {

    return new Promise((resolve, reject) => {

      /*  pool.getConnection(function(conn_err, db){
          if(conn_err){ // connessione db fallita
   
            return reject(); // Db failure
          }*/

      db.query("SELECT a.* FROM m_devices a LEFT JOIN m_instances b on b.ID = a.ID_INSTANCE WHERE b.ID_THEATER = ?", [nameInstance], (qerr, result) => {

        if (qerr) { return reject(); }
        var toreturn = {};

        async.forEachOf(result, (device_, key, callback) => {

          let temp = [];
          let tempJson = {};
          let currentElement = device_.ID;

          // prendo i settings di questo device.
          db.query("SELECT * FROM m_device_settings WHERE ID_DEVICE = ? ", [device_.ID], (qerr, result2) => {

            if (qerr) { return callback(); }
            temp = [];
            currentElement = device_.ID;

            for (let i = 0; i < result2.length; i++) {

              if (result2[i].KEY1 === 'Type')
                currentElement = result2[i].VALUESTRING;

              let currentkey = result2[i].KEY1;
              //tempJson = {};
              tempJson[currentkey] = { "value": result2[i].VALUESTRING, "id": result2[i].ID, "id_device": result2[i].ID_DEVICE };
              //temp[temp.length] = tempJson

            }

            toreturn[currentElement] = tempJson;
            return callback();

          });

        }, (cb_err) => {

          resolve(toreturn);

        });

      })

      //  });

    });


  }


  function getDevicesValues(nameInstance, theater_id, devices_target, param_target, is_param_constructed = false) {

    return new Promise((resolve, reject) => {

      /*pool.getConnection(function(conn_err, db){
        if(conn_err){ // connessione db fallita
   
          return reject(); // Db failure
        }*/

      let to_return = {};

      async.forEachOf(devices_list, (device_, key, callback) => {

        to_return[device_] = {};

        let current_parameter = param_target; // default init del parametro.

        if (is_param_constructed) {
          current_parameter = devices_prefix[key] + param_target; // Lo costruisco per i parametri condivisi tra devices.
        }

        if (!devices_target.includes(device_)) // Scarto i device che non sono necessari alla ricerca.
          return callback();


        db.query("SELECT a.ID_DEVICE FROM m_device_settings a LEFT JOIN m_devices b ON a.ID_DEVICE = b.ID" +
          " LEFT JOIN m_instances c on c.ID = b.ID_INSTANCE " +
          " WHERE a.KEY1 = 'Type' AND a.VALUESTRING = ? AND c.ID_THEATER = ?", [devices_types[key], nameInstance], (qerr, result) => {

            // Errore Query \ non esiste il device
            if (qerr || result.length === 0) { to_return[device_][current_parameter] = null; return callback(); }

            db.query("SELECT a.VALUESTRING, a.ID FROM m_device_settings a LEFT JOIN m_devices b ON a.ID_DEVICE = b.ID" +
              " LEFT JOIN m_instances c on c.ID = b.ID_INSTANCE " +
              " WHERE a.KEY1 = ? AND a.ID_DEVICE = ? AND c.ID_THEATER = ?", [current_parameter, result[0].ID_DEVICE, nameInstance], (qerr, result) => {

                //Errore ricerca dell'elemento per questo id_device  OPPURE il parametro dato non esiste nel device.
                if (qerr || result.length === 0) { to_return[device_][current_parameter] = null; return callback(); }

                // Ok we got it n
                to_return[device_][current_parameter] = result[0].VALUESTRING;
                to_return[device_]['id'] = result[0].ID;
                to_return[device_]['device_'] = device_;
                return callback();


              });


          });


      }, (cb_err) => {

        resolve(to_return);

      })

    });

    //  });

  }


  app.post('/api/post/imb/certificates', (req, res) => {

    const payload = req.body.payload;
    const address = sanitizeString(payload.address);
    const port = Number(payload.port);
    const username = sanitizeString(payload.api_username);
    const password = payload.api_password;

    /*const agent = new https.Agent({
      rejectUnauthorized: false,
      keepAlive: true
    });*/

    if (payload.type === 'BARCO' || payload.type.toUpperCase().indexOf('DOLBY') >= 0) {

      //soap
      soapLogin(payload.type, address, port, username, password, agent).then(login => {

        if (payload.type === 'BARCO') {

          // Verifico se siamo loggati...
          xml2js.parseString(login, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, json_res) {

            if (Number(json_res['SOAP-ENV:Body']['ns1:LoginResponse']['ns1:LoginResult']) > 0)
              return res.status(500).send({ error: 'login_failed' });

            // PRENDO IL SERIALE DEL PROIETTORE.
            soapAPI(payload.type, address, port, 'get_product', agent).then(res_ => {

              xml2js.parseString(res_, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, json_res) {

                if (err) { return res.status(500).send({ error: 'response_parse_error' }); }

                // Prendo il seriale del barco.
                const serial = json_res['SOAP-ENV:Body']['ns1:GetProductInformationResponse']['ns1:productInfo']['ns1:SerialNumber'];

                // Prendo il Certificato x il seriale kdm
                soapAPI(payload.type, address, port, 'get_certificate', agent).then(res_ => {

                  xml2js.parseString(res_, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, json_res) {

                    try {

                      const certificates = json_res['SOAP-ENV:Body']['ns1:GetCertificateListResponse']['ns1:list']['ns1:CertificateInformation'];
                      var certificate_serial = "";
                      var certificate_serial_audio = "";
                      var has_immersive_sound = false;

                      for (let i = 0; i < certificates.length; i++) {

                        if (certificates[i]['ns1:Kind'] === 'icmp_id')
                          certificate_serial = certificates[i]['ns1:Id'];

                        // C'è L'IMMERSIVE SOUND RENDERER.....
                        if (certificates[i]['ns1:Kind'] === 'immersive_sound_renderer') {
                          certificate_serial_audio = certificates[i]['ns1:Id'];
                          has_immersive_sound = true;
                        }

                      }

                      if (!has_immersive_sound) {

                        soapAPI(payload.type, address, port, 'logout', agent).then(logout => {
                          return res.status(200).send({ serial: serial, certificate_serial: certificate_serial });
                        });

                      } else {

                        // Prendo il Certificato x il seriale kdm
                        soapAPI(payload.type, address, port, 'get_serial_audio', agent).then(res_ => {

                          xml2js.parseString(res_, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, json_res) {

                            const serial_audio_aplit = json_res['SOAP-ENV:Body']['ns1:GetImmersiveSoundRendererInfoResponse']['ns1:info']['ns1:CertificateInfo'].split(".");
                            const serial_audio = serial_audio_aplit[1];

                            soapAPI(payload.type, address, port, 'logout', agent).then(logout => {

                              return res.status(200).send({
                                serial: serial, certificate_serial: certificate_serial,
                                serial_audioprocessor: serial_audio, certificate_audioprocessor: certificate_serial_audio
                              });

                            });


                          });

                        }).catch(error => {

                          //console.log(error);
                          return res.status(200).send({ serial: serial, certificate_serial: certificate_serial })

                        });

                      }

                    } catch (e) {

                      // errore nel parsing...
                      return res.status(200).send({ serial: serial, certificate_serial: '' });

                    }



                  });


                }).catch(err => {

                  // Errore certificato...
                  return res.status(200).send({ serial: serial, certificate_serial: '' });

                })

                //return res.status(200).send({serial : serial , certificate_serial : ''});

              });

            }).catch(err => {

              return res.status(500).send({ error: 'error_request_api' });

            });

          });

        }

        if (payload.type.toUpperCase().indexOf('DOLBY') >= 0) {

          // Prendo l'uuid della sessione....
          xml2js.parseString(login, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, json_res) {

            if (!json_res['SOAP-ENV:Body']['ns1:LoginResponse'].sessionId) {
              return res.status(500).send({ error: 'login_failed' });
            }
            const dolby_session = json_res['SOAP-ENV:Body']['ns1:LoginResponse'].sessionId;
            //console.log(dolby_session);
            soapAPI(payload.type, address, port, 'get_product', agent, dolby_session).then(res_ => {

              // Prendo l'uuid della sessione....
              xml2js.parseString(res_, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, json_res) {

                if (err) { return res.status(500).send({ error: 'response_parse_error' }); }

                const serial = json_res['SOAP-ENV:Body']['ns1:GetProductInformationResponse']['productInformation']['sys:serialNumber'];

                soapAPI(payload.type, address, port, 'get_certificate', agent, dolby_session).then(res_ => {

                  //parso i certificati
                  xml2js.parseString(res_, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, json_res) {

                    try {
                      const certificates = json_res['SOAP-ENV:Body']['ns1:GetCertificateListResponse'].certificateList['sys:certificate'];

                      for (let i = 0; i < certificates.length; i++)
                        if (certificates[i]['sys:title'] === 'jp2k smpte') { // Cerco il certificato per le kdm

                          const cert_smpte = certificates[i]['sys:cert'];

                          const issuer = Certificate.fromPEM(cert_smpte);
                          const certificate_serial = hexToDec(issuer.serialNumber);

                          soapAPI(payload.type, address, port, 'logout', agent, dolby_session).then(logout => {

                            return res.status(200).send({ serial: serial, certificate_serial: certificate_serial });

                          });

                        }

                    } catch (e) {

                      soapAPI(payload.type, address, port, 'logout', agent, dolby_session).then(logout => {

                        return res.status(200).send({ serial: serial, certificate_serial: '' });

                      });

                    }


                  });

                });

                //return res.status(200).send({ serial: serial , certificate_serial : '' });

              });

            }).catch(err => {

              return res.status(500).send({ error: 'error_request_api' });

            });

          });

        }



      }).catch(err => {

        return res.status(500).send({ error: 'login_failed' });

      });

    }

    if (payload.type === 'HULA') {

      // docker del cineplayer.
      const theater_nr = Number(req.body.nr);
      const own_ip = ip.address();
      let serial = "HULA" + theater_nr.toString();

      if (Number(payload.id_datastore) === 0) {
        return res.status(500).send({ error: 'select_valid_datastore' });
      }

      /*pool.getConnection(function(conn_err, db){
        if(conn_err){ // connessione db fallita
   
          return reject(); // Db failure
        }*/

      db.query("SELECT * FROM m_datastores WHERE ID = ?", [Number(payload.id_datastore)], (qerr, result) => {

        /*db.release();*/
        if (qerr) { }

        var conn = new Client();
        var output = "";

        conn.on('ready', function () {

          conn.exec("docker -H :3000 exec " + sanitizeString(payload.cineplayer_docker) + " hl-play.py --get-sm-cert", function (err, stream) {
            if (err) throw err;
            stream.on('data', function (data) {

              output = output + data;

            }).stderr.on('data', function (data) {


            }).on('end', (e) => {

              try {

                const issuer = Certificate.fromPEM(output);
                const certificate_serial = hexToDec(issuer.serialNumber);

                issuer.subject.attributes.forEach(attribute => {
                  if (attribute.name === 'commonName') {
                    serial = attribute.value.split('.')[2].split('-').reverse()[0];
                  }
                });

                //serial = issuer.subject.CM.split('.')[2].split('-').reverse()[0];

                return res.status(200).send({ serial: serial, certificate_serial: certificate_serial });

              } catch (errr) {

                return res.status(500).send({ serial: serial, certificate_serial: '' });

              }

            });
          });
        }).connect({
          host: result[0].address,
          port: 22,
          username: result[0].username,
          password: result[0].password
        });




      });

      //  });

    }

    if (payload.type === 'SONY') {

      // get url - DEPRECATO
      res.status(200).send({ serial: '', certificate_serial: '' });

    }

    // SERIALE CERTIFICATI PER I GDC
    if (payload.type === 'GDC') {

      var nc2 = new NetcatClient();
      let command_buffer = [];
      const serial_request = '<?xml version="1.0" encoding="UTF-8" ?><command version="2.2" cmd="GET_SERVER_INFO" />';
      let header = getGdcHeader(serial_request);
      let cmd_buffer = Buffer.from(serial_request);
      let array_buffers = [header, cmd_buffer];
      let cmd = Buffer.concat(array_buffers);

      let xml_serial = "";
      let buffer_array_serial = [];
      let timeout_seriale = [];

      nc2.addr(address.toString()).port(Number(port)).connect().send(cmd).on('error', (err_) => {

        console.log(err_);

      }).on('data', (data) => {

        //if (data.length > 16) {

        // verifica header...          
        clearTimeout(timeout_seriale);
        buffer_array_serial.push(data);
        timeout_seriale = setTimeout(() => { nc2.close(); }, 50);

        // }

      }).on('close', () => {

        let serial_concat = Buffer.concat(buffer_array_serial);
        let xml_response = serial_concat.slice(20, serial_concat.length).toString();

        if (xml_response[0] !== '<') xml_response = xml_response.substr(1, xml_response.length);

        xml2js.parseString(xml_response, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, json_res) {

          if (err) {
            console.log(xml_response)
            console.log(err);
            return res.status(500).send({ error: 'Serial number parse failed' });
          }
          const serial_gdc = json_res.serial;

          // ottengo il certificato...
          const certificate_request = '<?xml version="1.0" encoding="UTF-8" ?><command version="2.2" cmd="GET_CERTIFICATES" />';
          let header_ = getGdcHeader(certificate_request);
          let cmd_buffer_ = Buffer.from(certificate_request);
          let array_buffers_ = [header_, cmd_buffer_];
          let cmd_ = Buffer.concat(array_buffers_);
          var nc2_ = new NetcatClient();

          let is_first_data = true;
          let buffer_array_certificate = [];
          let set_timeout = [];

          nc2_.addr(address.toString()).port(Number(port)).connect().send(cmd_).on('data', (data) => {

            // valido
            clearTimeout(set_timeout);
            buffer_array_certificate.push(data);
            set_timeout = setTimeout(() => { nc2_.close(); }, 50);

          }).on('close', () => {

            let certificate_concat = Buffer.concat(buffer_array_certificate);
            let xml_response_ = certificate_concat.slice(20, certificate_concat.length).toString();

            if (xml_response_[0] !== '<') xml_response_ = xml_response_.substr(1, xml_response_.length);

            // Parso l'xml per avere il certificato delle KDM
            xml2js.parseString(xml_response_, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, json_certificate) {

              if (err) return res.status(200).send({ serial: serial_gdc, certificate_serial: '' });

              const bufferCertificate = Buffer.from(json_certificate.certificate);
              let certificate_serial_fromcert = "";

              try {

                const issuer = cert2json.parse(bufferCertificate);
                certificate_serial_fromcert = issuer.tbs.serialNumber.int;

              } catch (e_) {

                return res.status(200).send({ serial: serial_gdc, certificate_serial: '' });

              }



              return res.status(200).send({ serial: serial_gdc, certificate_serial: certificate_serial_fromcert });


            });

          });

        });

      });
    }

    // Altri tipi.
    if (payload.type !== 'SONY' && payload.type !== 'HULA' && payload.type !== 'BARCO' && payload.type !== 'GDC' && payload.type.toUpperCase().indexOf('DOLBY') < 0) return res.status(500).send({ error: 'error_request_api' })

  });

  function soapLogin(type, address, port, username, password, agent) {

    return new Promise((resolve, reject) => {

      // URL richiesta di login.
      const url = type === 'BARCO' ? ("https://" + address + ":" + port) : "http://" + address + ":" + port + "/dc/dcp/ws/v1/SessionManagement";
      const args = type === 'BARCO' ? ('<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:sms="http://www.barco.com/sms/sms_1"><soap:Header/><soap:Body><sms:Login><sms:userName>' + username + '</sms:userName><sms:password>' + password + '</sms:password><sms:sessionInfo></sms:sessionInfo></sms:Login></soap:Body></soap:Envelope>')
        : ('<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:v1="http://www.doremilabs.com/dc/dcp/ws/v1_0"><soapenv:Header/><soapenv:Body><v1:Login><username>' + username + '</username><password>' + password + '</password></v1:Login></soapenv:Body></soapenv:Envelope>');

      const httpAgent = new http.Agent({ keepAlive: true });

      const options = {

        baseURL: url,
        method: 'post',
        timeout: 10000,
        headers: {
          "Accept-Encoding": "gzip,deflate",
          "Content-Type": "test/xml;charset=UTF-8",
          'SOAPAction': '',
        },
        auth: {},
        httpsAgent: agent,
        data: args,

      }

      //console.log(args);

      axios(options).then(res => {

        return resolve(res.data);

      }).catch(error => {

        console.log(error);
        return reject(false);

      })



    });

  }


  function soapAPI(type, address, port, api_type, agent, uuid_login = '', options = {}) {

    let options_ = options;

    return new Promise((resolve, reject) => {

      var url = "";
      var body = "";

      if (type === 'BARCO') {

        url = "https://" + address + ":" + port;

        // GetProductInformation dal wsdl di Barco Alchemny
        if (api_type === 'get_product') {
          body = '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:sms="http://www.barco.com/sms/sms_1"><soap:Header/><soap:Body><sms:GetProductInformation/></soap:Body></soap:Envelope>';
        }
        if (api_type === 'get_certificate') {
          body = '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:sms="http://www.barco.com/sms/sms_1"><soap:Header/><soap:Body><sms:GetCertificateList/></soap:Body></soap:Envelope>';
        }
        if (api_type === 'get_serial_audio') {
          body = '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:sms="http://www.barco.com/sms/sms_1"><soap:Header/><soap:Body><sms:GetImmersiveSoundRendererInfo/></soap:Body></soap:Envelope>';
        }
        if (api_type === 'get_storage') {
          body = '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:sms="http://www.barco.com/sms/sms_1"><soap:Header/><soap:Body><sms:GetStorageStatus/></soap:Body></soap:Envelope>';
        }
        if (api_type === 'logout') {
          body = '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:sms="http://www.barco.com/sms/sms_1"><soap:Header/><soap:Body><sms:Logout/></soap:Body></soap:Envelope>';
        }
        if (api_type === 'get_cpllist') {
          body = '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:sms="http://www.barco.com/sms/sms_1"><soap:Header/><soap:Body><sms:GetCplList/></soap:Body></soap:Envelope>';
        }
        if (api_type === 'get_kdmlist') {
          body = '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:sms="http://www.barco.com/sms/sms_1"><soap:Header/><soap:Body><sms:GetKdmList/></soap:Body></soap:Envelope>';
        }
        if (api_type === 'delete_kdm') {
          let id_kdm_remove = "";
          options_.kdmList.forEach(kdm => { id_kdm_remove += "<sms:string>" + kdm + "</sms:string>"; });
          body = '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:sms="http://www.barco.com/sms/sms_1"><soap:Header/><soap:Body><sms:DeleteKdmList><sms:idList>' + id_kdm_remove + '</sms:idList></sms:DeleteKdmList></soap:Body></soap:Envelope>';
        }
        if (api_type === 'ingest_kdm') {
          body = options_.xml;
        }

      }

      if (type.toUpperCase().indexOf('DOLBY') >= 0) {

        if (api_type === 'get_product') {
          url = "http://" + address + ":" + port + "/dc/dcp/ws/v1/SystemInformation";
          body = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:v1="http://www.doremilabs.com/dc/dcp/ws/v1_0"><soapenv:Header/><soapenv:Body><v1:GetProductInformation><sessionId>' + uuid_login + '</sessionId></v1:GetProductInformation></soapenv:Body></soapenv:Envelope>';
        }
        if (api_type === 'get_certificate') {
          url = "http://" + address + ":" + port + "/dc/dcp/ws/v1/SystemInformation";
          body = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:v1="http://www.doremilabs.com/dc/dcp/ws/v1_0"><soapenv:Header/><soapenv:Body><v1:GetCertificateList><sessionId>' + uuid_login + '</sessionId></v1:GetCertificateList></soapenv:Body></soapenv:Envelope>';
        }
        if (api_type === 'get_storage') {
          url = "http://" + address + ":" + port + "/dc/dcp/ws/v1/StorageManagement";
          body = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:v1="http://www.doremilabs.com/dc/dcp/ws/v1_0"><soapenv:Header/><soapenv:Body><v1:GetStorageList><sessionId>' + uuid_login + '</sessionId></v1:GetStorageList></soapenv:Body></soapenv:Envelope>';
        }
        if (api_type === 'logout') {
          url = "http://" + address + ":" + port + "/dc/dcp/ws/v1/SessionManagement";
          body = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:v1="http://www.doremilabs.com/dc/dcp/ws/v1_0"><soapenv:Header/><soapenv:Body><v1:Logout><sessionId>' + uuid_login + '</sessionId></v1:Logout></soapenv:Body></soapenv:Envelope>';
        }
        if (api_type === 'get_cpllist') {
          url = "http://" + address + ":" + port + "/dc/dcp/ws/v1/CPLManagement";
          body = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:v1="http://www.doremilabs.com/dc/dcp/ws/v1_0"><soapenv:Header/><soapenv:Body><v1:GetCPLListInfo><sessionId>' + uuid_login + '</sessionId></v1:GetCPLListInfo></soapenv:Body></soapenv:Envelope>';
        }
        if (api_type === 'get_kdmlist') {
          url = "http://" + address + ":" + port + "/dc/dcp/ws/v1/KDMManagement";
          body = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:v1="http://www.doremilabs.com/dc/dcp/ws/v1_0"><soapenv:Header/><soapenv:Body><v1:GetKDMListInfo><sessionId>' + uuid_login + '</sessionId></v1:GetKDMListInfo></soapenv:Body></soapenv:Envelope>';
        }
        if (api_type === 'delete_kdm') {
          url = "http://" + address + ":" + port + "/dc/dcp/ws/v1/KDMManagement";
          body = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:v1="http://www.doremilabs.com/dc/dcp/ws/v1_0"><soapenv:Header/><soapenv:Body><v1:DeleteKDM><sessionId>' + uuid_login + '</sessionId><kdmId>' + options_.id_kdm + '</kdmId></v1:DeleteKDM></soapenv:Body></soapenv:Envelope>';
        }
        if (api_type === 'ingest_kdm') {
          url = "http://" + address + ":" + port + "/dc/dcp/ws/v1/KDMManagement";
          body = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:v1="http://www.doremilabs.com/dc/dcp/ws/v1_0"><soapenv:Header/><soapenv:Body><v1:SetKDMContent><sessionId>' + uuid_login + '</sessionId><content>' + options_.kdm64 + '</content></v1:SetKDMContent></soapenv:Body></soapenv:Envelope>';
        }

      }

      if (url === "" || body === "") {
        reject(false);
      }

      const options = {

        baseURL: url,
        method: 'POST',
        timeout: 10000,
        headers: {
          "Accept-Encoding": "gzip,deflate",
          "Content-Type": "test/xml;charset=UTF-8",
          'SOAPAction': '',
        },
        auth: {},
        httpsAgent: agent,

        data: body,

      }

      axios(options).then(res => {

        return resolve(res.data);

      }).catch(error => {

        console.log(error);
        return reject(false);

      });


    });


  }


  app.get('/api/get/settings', (req, res) => {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
   
        return res.status(500).send({ error : 'database_failure' });
      }*/

    db.query("SELECT * FROM m_generalsettings WHERE KEY1 = 'general_settings'", (qerr, result) => {

      /*db.release();*/
      if (qerr) { return res.status(500).send({ error: '/api/get/settings -> query_1 error' }); }
      return res.status(200).send(result);

    });

    //  });

  });

  app.post('/api/post/settings', (req, res) => {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
   
        return res.status(500).send({ error : 'database_failure' });
      }*/

    async.forEachOf(req.body.payload, (setting, key, callback) => {

      let sql_string = "";
      let sql_params = [];

      if (setting.id !== 0) {
        sql_string = "INSERT INTO m_generalsettings (id , key1, key2, key3, string_value, int_value) VALUES (?, 'general_settings' , ? , ? , ?, ?) ON DUPLICATE KEY UPDATE id = ? , key1 = 'general_settings' , key2 = ?, key3 = ?, string_value = ?, int_value = ?"
        sql_params = [setting.id, setting.key2, setting.key3, setting.string_value, setting.int_value, setting.id, setting.key2, setting.key3, setting.string_value, setting.int_value];
      } else {
        sql_string = "INSERT INTO m_generalsettings (key1, key2, key3, string_value, int_value) VALUES ('general_settings' , ? , ? , ?, ?) ON DUPLICATE KEY UPDATE key1 = 'general_settings' , key2 = ?, key3 = ?, string_value = ?, int_value = ?"
        sql_params = [setting.key2, setting.key3, setting.string_value, setting.int_value, setting.key2, setting.key3, setting.string_value, setting.int_value];
      }

      db.query(sql_string, sql_params, (qerr, result) => {

        if (qerr) { console.log(qerr); return callback(false); } // Errore update setting....

        if (setting.key2 === 'ip_playout') {
          ip_playout = setting.string_value;
        }

        return callback(true);

      });

    }, (err) => {

      // cb
      /*db.release();*/
      return res.status(200).send({ status: 1 });

    });

    //});

  });


  app.get("/api/get/importdcp", (req, res) => {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
   
        return res.status(500).send({ error : 'database_failure' });
      }*/

    db.query("SELECT * FROM m_import_preset ORDER BY Name", (qerr, result) => {

      /*db.release();*/

      if (qerr) { return res.status(500).send({ error: '/api/get/importdcp -> query_1 error' }); }
      return res.status(200).send(result);

    });

    //});

  });

  app.get('/api/get/spaceinfo', (req, res) => {

    checkDiskSpace(os.platform() === 'win32' ? 'C:/' : '/datastore').then((diskSpace) => {

      // {
      //     free: 12345678,
      //     size: 98756432
      // }

      return res.status(200).send(diskSpace);

    }).catch(err => {

      console.log(err)
      return res.sendStatus(500);

    })

  });

  app.get("/api/get/importdcp/:id", (req, res) => {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
   
        return res.status(500).send({ error : 'database_failure' });
      }*/

    const id = req.params.id;

    db.query("SELECT * FROM m_import_preset WHERE ID = ?", [id], (qerr, result) => {

      /*db.release();*/

      if (qerr) { return res.status(500).send({ error: '/api/get/importdcp/:id -> query_1 error' }); }
      return res.status(200).send(result[0]);

    });

    //  });

  });


  app.post("/api/get/browser/folders", (req, res) => {

    const current_folder = req.body.path.replace(/\\/g, '/');
    const folder_to = req.body.folder_to;
    var this_path = !folder_to ? current_folder : path.join(current_folder, folder_to).replace(/\\/g, '/'); // path combinato.

    if (this_path.indexOf(limit_browser) < 0 && typeof req.body.ingest_browser === 'undefined')
      return res.status(200).send({ new_path: current_folder, content: [] })

    var folders = [];

    try {

      if (!fs.existsSync(this_path)) {
        this_path = "/datastore";
      }

      console.log(this_path);

      fs.readdir(this_path, function (err, items) {

        if (typeof items === "undefined" || err) {
          return res.status(200).send({ new_path: current_folder, content: [] });
        }

        items.forEach((item, i) => {


          let check_folder = path.join(this_path, item);
          if (fs.lstatSync(check_folder).isDirectory()) {
            folders.push(item);
          }

        });

        console.log(folders);
        res.status(200).send({ new_path: this_path, content: folders });

      });

    } catch (error) {

      res.status(200).send({ new_path: current_folder, content: [] });

    }

  });


  app.post("/api/test/ftp", (req, res) => {

    try {

      var c = new Client_FTP();
      c.on('ready', function () {
        c.list((err, list) => {
          c.end();
          if (err) { console.log(err); return res.status(500).send({ status: 0 }); }
          return res.status(200).send({ status: 1 })
        });
      });
      c.on('error', (err) => {
        console.log(err);
        c.end();
        return res.status(500).send({ status: 0 });
      })
      // connect to localhost:21 as anonymous
      c.connect({
        host: sanitizeString(req.body.address),
        port: sanitizeString(req.body.port),
        user: sanitizeString(req.body.username),
        password: sanitizeString(req.body.password),
      });

    } catch (error) {

      return res.status(500).send({ status: 0 });

    }

  });

  app.post("/api/get/browser/ftp/folders", (req, res) => {

    const current_folder = req.body.path === "" ? "/" : req.body.path;
    const folder_to = req.body.folder_to;
    var this_path = !folder_to ? current_folder : path.join(current_folder, folder_to); // path combinato.

    // Levo la / dalla radice per gli ftp
    /*
    if (current_folder[0] === '/' && this_path.substr(1, current_folder.length).indexOf("/") < 0) {
  
      console.log(this_path);
      this_path = this_path.substr(1, this_path.length);
  
    } else {
  
      if (current_folder[0] !== '/') this_path = path.join("/", this_path);
  
    }*/

    this_path = this_path.split('\\').join('/');
    console.log(this_path)


    try {

      var folders = [];

      var c = new Client_FTP();
      c.on('ready', function () {
        c.list(this_path, (err, list) => {

          c.end();
          if (err) { console.log(err); return res.status(200).send({ new_path: current_folder, content: [] }) }


          list.forEach((folder, index, callback) => {

            if (folder.type !== "d")
              return

            folders.push(folder.name);

          });
          return res.status(200).send({ new_path: this_path, content: folders })
        });
      });
      c.on('error', (err) => {
        return res.status(500).send({ error: "login_failed" });
      })
      // connect to localhost:21 as anonymous
      c.connect({
        host: sanitizeString(req.body.address),
        port: sanitizeString(req.body.port),
        user: sanitizeString(req.body.username),
        password: sanitizeString(req.body.password),
      });

    } catch (err) {

      return res.status(500).send({ error: "login_failed" });

    }

  });




  app.post("/api/post/importdcp/:id", (req, res) => {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
   
        return res.status(500).send({ error : 'database_failure' });
      }*/

    const id = req.params.id;
    const payload = req.body.payload;

    db.query("UPDATE m_import_preset SET name = ? , path = ?, enabled = ? WHERE id = ?", [sanitizeString(payload.name), payload.path, Number(payload.enabled), id], (qerr, result) => {

      /*db.release();*/

      if (qerr) { return res.status(500).send({ error: '/api/post/importdcp/:id -> query_1 error' }); }
      res.status(200).send({ status: 1 });

    });

    //  });

  });


  app.post("/api/post/importdcp", (req, res) => {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
   
        return res.status(500).send({ error : 'database_failure' });
      }*/

    const payload = req.body.payload;

    db.query("INSERT INTO m_import_preset (name, path, enabled) VALUES (? ,? ,?)", [sanitizeString(payload.name), payload.path, Number(payload.enabled)], (qerr, result) => {

      /*db.release();*/

      if (qerr) { return res.status(500).send({ error: '/api/post/importdcp -> query_1 error' }); }
      res.status(200).send({ status: 1 });

    });

    //  });

  });


  app.get("/api/get/importkdm", (req, res) => {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
   
        return res.status(500).send({ error : 'database_failure' });
      }*/

    db.query("SELECT * FROM m_import_kdm_preset ORDER BY Name", (qerr, result) => {

      /*db.release();*/

      if (qerr) { return res.status(500).send({ error: '/api/get/importkdm -> query_1 error' }); }
      return res.status(200).send(result);

    });

    //  });

  });

  app.get("/api/get/importkdm/:id", (req, res) => {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
   
        return res.status(500).send({ error : 'database_failure' });
      }*/

    const id = req.params.id;

    db.query("SELECT * FROM m_import_kdm_preset WHERE ID = ?", [id], (qerr, result) => {

      /*db.release();*/

      if (qerr) { return res.status(500).send({ error: '/api/get/importkdm/:id -> query_1 error' }); }
      return res.status(200).send(result[0]);

    });

    //  });

  });


  app.post("/api/post/importkdm/:id", (req, res) => {

    /*  pool.getConnection(function(conn_err, db){
        if(conn_err){ // connessione db fallita
   
          return res.status(500).send({ error : 'database_failure' });
        }*/

    const id = req.params.id;
    const payload = req.body.payload;

    db.query("UPDATE m_import_kdm_preset SET name = ? , path = ?, enabled = ? WHERE id = ?", [sanitizeString(payload.name), payload.path, Number(payload.enabled), id], (qerr, result) => {

      /*db.release();*/

      if (qerr) { return res.status(500).send({ error: '/api/post/importkdm/:id -> query_1 error' }); }
      res.status(200).send({ status: 1 });

    });

    //  });

  });


  app.post("/api/post/importkdm", (req, res) => {

    /*  pool.getConnection(function(conn_err, db){
        if(conn_err){ // connessione db fallita
   
          return res.status(500).send({ error : 'database_failure' });
        }*/

    const payload = req.body.payload;

    db.query("INSERT INTO m_import_kdm_preset (name, path, enabled) VALUES (? ,? ,?)", [sanitizeString(payload.name), payload.path, Number(payload.enabled)], (qerr, result) => {

      /*db.release();*/

      if (qerr) { return res.status(500).send({ error: '/api/post/importkdm -> query_1 error' }); }
      res.status(200).send({ status: 1 });

    });

    //});

  });


  app.get("/api/get/ingestsources", (req, res) => {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
   
        return res.status(500).send({ error : 'database_failure' });
      }*/

    db.query("SELECT * FROM m_ingestsources ORDER BY name", (qerr, result) => {

      /*db.release();*/

      if (qerr) { return res.status(500).send({ error: '/api/get/ingestsources -> query_1 error' }); }
      return res.status(200).send(result);

    });

    //  });

  });



  app.get("/api/get/ingestsources/:id", (req, res) => {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
   
        return res.status(500).send({ error : 'database_failure' });
      }*/

    const id = req.params.id;

    db.query("SELECT * FROM m_ingestsources WHERE id = ?", [id], (qerr, result) => {

      /*db.release();*/

      if (qerr) { return res.status(500).send({ error: '/api/get/ingestsources/:id -> query_1 error' }); }
      return res.status(200).send(result[0]);

    });

    //});

  });





  app.post("/api/post/ingestsource/:id", (req, res) => {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
   
        return res.status(500).send({ error : 'database_failure' });
      }*/

    const id = Number(req.params.id);
    const payload = req.body.payload;

    // Se è local pulisco quello che non serve perchè è dell'ftp...
    if (Number(payload.type) === 0) {
      payload.username = "";
      payload.password = "";
      payload.address = "";
      payload.port = "";
    }

    db.query("UPDATE m_ingestsources SET name = ? , type = ?, address = ?, port = ?, username = ?, password = ?, path = ?, enabled = ? WHERE id = ?",
      [sanitizeString(payload.name), Number(payload.type), sanitizeString(payload.address), Number(payload.port), sanitizeString(payload.username), payload.password, payload.path, Number(payload.enabled), id], (qerr, result) => {

        /*db.release();*/

        if (qerr) { return res.status(500).send({ error: '/api/post/ingestsource/:id -> query_1 error' }); }
        res.status(200).send({ status: 1 });

      });

    //});

  });


  app.post("/api/post/ingestsource", (req, res) => {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
   
        return res.status(500).send({ error : 'database_failure' });
      }*/

    const payload = req.body.payload;

    // Se è local pulisco quello che non serve perchè è dell'ftp...
    if (Number(payload.type) === 0) {
      payload.username = "";
      payload.password = "";
      payload.address = "";
      payload.port = "";
    }

    db.query("INSERT INTO m_ingestsources (name, type, address, port, username, password, path, enabled) VALUES (? ,? , ?, ?, ?, ?, ?, ?)",
      [sanitizeString(payload.name), Number(payload.type), sanitizeString(payload.address), Number(payload.port), sanitizeString(payload.username), payload.password, payload.path, Number(payload.enabled)]
      , (qerr, result) => {

        /*db.release();*/

        if (qerr) { return res.status(500).send({ error: '/api/post/ingestsource -> query_1 error' }); }
        res.status(200).send({ status: 1 });

      });

    //});

  });



  app.get("/api/get/userlist", (req, res) => {

    /*  pool.getConnection(function(conn_err, db){
        if(conn_err){ // connessione db fallita
   
          return res.status(500).send({ error : 'database_failure' });
        }*/

    db.query("SELECT * FROM m_streamer_users ORDER BY username", (qerr, result) => {

      /*db.release();*/

      if (qerr) { return res.status(500).send({ error: '/api/get/userlist -> query_1 error' }); }
      return res.status(200).send(result);

    });

    //  });

  });



  app.get("/api/get/user/:id", (req, res) => {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
   
        return res.status(500).send({ error : 'database_failure' });
      }*/

    const id = Number(req.params.id);

    db.query("SELECT * FROM m_streamer_users WHERE id = ?", [id], (qerr, result) => {

      /*db.release();*/

      if (qerr) { return res.status(500).send({ error: '/api/get/userlist -> query_1 error' }); }
      return res.status(200).send(result[0]);

    });

    //  });

  });


  app.post("/api/post/user/:id", (req, res) => {

    /*  pool.getConnection(function(conn_err, db){
        if(conn_err){ // connessione db fallita
   
          return res.status(500).send({ error : 'database_failure' });
        }*/

    const id = Number(req.params.id);
    const payload = req.body.payload;

    db.query("UPDATE m_streamer_users SET username = ?, password = ?, user_level = ?, active = ? WHERE id = ?", [sanitizeString(payload.username), payload.password, Number(payload.user_level), Number(payload.active), id], (qerr, result) => {

      /*db.release();*/

      if (qerr) { return res.status(500).send({ error: '/api/post/user/:id -> query_1 error' }); }
      return res.status(200).send({ status: 1 });

    });

    //  });

  });



  app.post("/api/post/user", (req, res) => {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
   
        return res.status(500).send({ error : 'database_failure' });
      }*/

    const id = Number(req.params.id);
    const payload = req.body.payload;

    db.query("INSERT INTO m_streamer_users (username, password, user_level, active) VALUES (?,?,?,?)", [sanitizeString(payload.username), payload.password, Number(payload.user_level), Number(payload.active)], (qerr, result) => {

      /*db.release();*/

      if (qerr) { return res.status(500).send({ error: '/api/post/user -> query_1 error' }); }
      return res.status(200).send({ status: 1 });

    });

    //  });

  });



  app.post("/api/post/database", (req, res) => {

    const payload = req.body.payload;

    const new_config = {
      "Customer": {
        "dbConfig": {
          "DATABASE_HOST": payload.address,
          "DATABASE_PORT": payload.port,
          "DATABASE_NAME": payload.schema,
          "DATABASE_USER": payload.username,
          "DATABASE_PWD": payload.password
        }
      }
    }

    fs.writeFile('./config/default.json', JSON.stringify(new_config), function (err) {
      if (err) return console.log(err);

      delete __webpack_require__.c[/*require.resolve*/(54638)];
      return res.status(200).send({ status: 1 })

    });

  });


  app.post("/api/post/create/folder", (req, res) => {

    const payload = req.body.payload;
    const path_to_folder = path.join(payload.current_path, payload.foldername);

    if (path_to_folder.indexOf("datastore") < 0)
      return res.status(500).send({ status: 0 });

    if (fs.existsSync(path_to_folder))
      if (fs.lstatSync(path_to_folder).isDirectory())
        return res.status(200).send({ status: 1 }); // già esiste.

    try {
      fs.mkdirSync(path_to_folder);
      return res.status(200).send({ status: 1 });
    } catch (err) {
      res.status(500).send({ status: 0 })
    }

  });

  app.post("/api/post/rename/folder", (req, res) => {

    const payload = req.body.payload;
    const path_to_folder = path.join(payload.current_path, payload.foldername);
    const current_folder = path.join(payload.current_path, payload.selected_folder);

    if (path_to_folder.indexOf("datastore") < 0 || current_folder.indexOf("datastore") < 0)
      return res.status(500).send({ status: 0 });

    // CHeck sorgente
    if (!fs.existsSync(current_folder)) {
      return res.status(500).send({ status: 0 }); // non esiste.
    }
    if (!fs.lstatSync(current_folder).isDirectory()) {
      return res.status(500).send({ status: 0 }); // non è una cartella.
    }

    // Check destinazione
    if (fs.existsSync(path_to_folder))
      if (fs.lstatSync(path_to_folder).isDirectory())
        return res.status(200).send({ status: 1 }); // già esiste.

    try {
      fs.renameSync(current_folder, path_to_folder);
      return res.status(200).send({ status: 1 });
    } catch (err) {
      res.status(500).send({ status: 0 })
    }

  });

  app.post("/api/post/delete/folder", (req, res) => {

    const payload = req.body.payload;
    const path_to_folder = path.join(payload.current_path, payload.selected_folder);

    if (fs.existsSync(path_to_folder))
      if (fs.lstatSync(path_to_folder).isDirectory()) {

        try {
          fs.rmdirSync(path_to_folder);
          return res.sendStatus(200);
        } catch (error) {
          return res.sendStatus(500);
        }

      }

    return res.sendStatus(500);

  });

  app.get("/api/get/automations/list", (req, res) => {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
        return res.status(500).send({ error : 'database_failure' });
      }*/

    db.query("SELECT * FROM m_automation ORDER BY Name", (qerr, result) => {

      /*db.release();*/
      if (qerr) { return res.status(500).send({ error: '/api/get/automations/list -> query_1 error' }); }
      return res.status(200).send(result);

    })

    //    });

  });

  app.get("/api/get/automations/:id", (req, res) => {

    /*  pool.getConnection(function(conn_err, db){
        if(conn_err){ // connessione db fallita
          return res.status(500).send({ error : 'database_failure' });
        }*/

    const id = Number(req.params.id);
    var response = {};

    db.query("SELECT * FROM m_automation WHERE ID = ?", [id], (qerr, result) => {

      if (qerr || result.length === 0) { /*db.release();*/ return res.status(500).send({ error: '/api/get/automations/:id -> query_1 error' }); }
      response.automation = result[0];

      db.query("SELECT * FROM m_events WHERE ID_Element = ? AND Table_Element = 'm_automation' ", [id], (qerr, result) => {

        /*db.release();*/

        if (qerr) { return res.status(500).send({ error: '/api/get/automations/:id -> query_2 error' }); }

        async.forEachOf(result, (element, key, callback) => {

          if (element.Item === 'DEVMGRITEM' || element.Item === "CUSTOM COMMAND") { // Parsing dei devicemanager items.
            xml2js.parseString(element.Param, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, json_res) {
              if (err) { return callback(); }

              if (element.Item === 'DEVMGRITEM') {
                const array_split = json_res.split("+");
                result[key].Param = array_split;
                return callback();
              }

              if (element.Item === "CUSTOM COMMAND") {
                result[key].Param = json_res.toString();
                return callback();
              }

            });

          } else {
            return callback();
          }


        }, (callback) => {

          response.events = result;
          return res.status(200).send(response);

        });
      });
    });
    //});
  });


  app.get("/api/get/tags/:name/list/:mode", (req, res) => {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
        return res.status(500).send({ error : 'database_failure' });
      }*/

    const name_instance = sanitizeString(req.params.name);
    db.query("SELECT a.* FROM m_device_tags a LEFT JOIN m_instances b on b.ID = a.ID_INSTANCE WHERE b.NAME = ? ORDER BY a.DESCRIPTION", [name_instance], (qerr, result) => {

      if (req.params.mode === "tagnames") { // Lista solo dei tags senza sapere il contenuto
        /*db.release();*/
        if (qerr) { return res.status(500).send({ error: '/api/get/tags/:name/list -> query_1 error' }); }
        return res.status(200).send(result);
      } else {

        var response = [];
        async.forEachOf(result, (tag, key, callback) => {

          getTagDetails(tag.ID, tag.ID_INSTANCE).then(result => {
            response.push({
              tag: tag,
              details: result,
            });

            //if ((key + 1) === result.length) return callback();

            return callback();
          }).catch(err => {
            return callback();
          });
        }, (callback_result) => {

          // ORDINO PER NOME PERCHè PRENDENDO I TAG DETAILS ASINCRONAMENTE QUELLI CON PIù ROBA FINIVANO IN FONDO....
          response.sort((a, b) => a.tag['DESCRIPTION'].localeCompare(b.tag['DESCRIPTION']));

          /*db.release();*/
          return res.status(200).send(response);

        })

      }

    });
    //  });
  });

  app.post("/api/post/automation/:id", (req, res) => {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
        return res.status(500).send({ error : 'database_failure' });
      }*/

    const payload = req.body.payload;
    const id = req.params.id;

    // Controllo che il nome sia OK.
    db.query("SELECT ID FROM m_automation WHERE Name = ? AND ID NOT LIKE ? ", [sanitizeString(payload.automation.Name), id], (qerr, result) => {

      if (result.length > 0) {
        /*db.release();*/
        return res.status(500).send({ error: 'name_already_exists' }); // Se la insert ritorna 0 e nessun errore significa che il nome dell'automazione già esiste.
      }


      db.query("UPDATE m_automation SET Name=?, Groupname=?, Category=?, Value=? WHERE ID = ?",
        [sanitizeString(payload.automation.Name), sanitizeString(payload.automation.Groupname), sanitizeString(payload.automation.Category)
          , sanitizeString(payload.automation.Value), id, sanitizeString(payload.automation.Name), id], (qerr, result) => {

            //console.log(qerr);

            if (qerr) { /*db.release();*/ return res.status(500).send({ error: '/api/post/automation/:id -> query_1 error' }); }

            // Rimuovo gli eventi e li riscrivo.
            db.query("DELETE FROM m_events WHERE ID_Element = ?", [id], (qerr, result) => {

              /*db.release();*/
              if (qerr) { return res.status(500).send({ error: '/api/post/automation/:id -> query_2 error' }); }

              generateAutomationEvents(id, payload).then(res_ => {

                return res.status(200).send({ status: 1 });

              }).catch(error => {

                return res.status(200).send({ status: 1 });

              });

            });

          });

    });

    //  });

  });



  app.post("/api/post/automation", (req, res) => {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
        return res.status(500).send({ error : 'database_failure' });
      }*/

    const payload = req.body.payload;

    db.query("INSERT INTO m_automation (Name, Groupname, Category, Value) SELECT ?,?,?,? FROM m_automation WHERE NOT EXISTS (SELECT 1 FROM m_automation WHERE Name = ?) LIMIT 1",
      [sanitizeString(payload.automation.Name), sanitizeString(payload.automation.Groupname), sanitizeString(payload.automation.Category)
        , sanitizeString(payload.automation.Value), sanitizeString(payload.automation.Name)], (qerr, result) => {

          if (qerr) { /*db.release();*/ return res.status(500).send({ error: '/api/post/automation -> query_1 error' }); }

          const id = result.insertId;

          if (id === 0) {
            return res.status(500).send({ error: 'name_already_exists' }); // Se la insert ritorna 0 e nessun errore significa che il nome dell'automazione già esiste.
          }

          /*db.release();*/

          generateAutomationEvents(id, payload).then(res_ => {

            return res.status(200).send({ status: 1 });

          }).catch(error => {

            return res.status(200).send({ status: 1 });

          });
        })

    //  });

  });


  function generateAutomationEvents(id, payload) {

    return new Promise((resolve, reject) => {

      /*pool.getConnection(function(conn_err, db){
        if(conn_err){ // connessione db fallita
          reject();
        }*/

      async.forEachOf(payload.events, (event_, key, callback) => {

        if (event_ === null) // Evento rimosso, non è da aggiungere ...
          return callback(true);


        let param = "";
        switch (event_.Item) {
          // Creo il parametro.
          case 'DEVMGRITEM':
            param = "<DevMgrItem>";
            event_.Param.forEach((param_) => { param = param_ !== null ? param + param_ + "+" : param });
            param = param.substring(0, (param.length - 1)) + "</DevMgrItem>";
            break;

          case 'CUSTOM COMMAND':
            param = "<Cmd>" + event_.Param + "</Cmd>"
            break;

          default:
            param = "";
        }

        db.query("INSERT INTO m_events (ID_Element, Table_Element, Item, Param, TimeRef, TimeStart, EventType, Enable ) VALUES " +
          "( ? , 'm_automation' , ? , ?, ? , ? , 5 , ? )", [id, event_.Item, param, event_.TimeRef, event_.TimeStart, Number(event_.Enable)], (qerr, result) => {

            if (qerr) { return callback(false); }
            // tutto ok.
            return callback(true);

          })

      }, (cb) => {

        /*db.release();*/
        resolve(true);

      });

    });

    //  });

  }

  app.post("/api/delete/automation/:id", (req, res) => {

    /*  pool.getConnection(function(conn_err, db){
        if(conn_err){ // connessione db fallita
          return res.status(500).send({ error : 'database_failure' });
        }*/
    const id = req.params.id;
    db.query("DELETE FROM m_events WHERE ID_Element = ?", [id], (qerr, result) => {
      if (qerr) { /*db.release();*/ return res.status(500).send({ error: '/api/delete/automation/:id -> query_1 error' }); }
      db.query("DELETE FROM m_automation WHERE ID = ?", [id], (qerr, result) => {
        /*db.release();*/
        if (qerr) { return res.status(500).send({ error: '/api/delete/automation/:id -> query_2 error' }); }

        return res.status(200).send({ status: 1 });
      });
    });
    //  });
  });

  app.get("/api/get/automation/datalists", (req, res) => {
    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
        return res.status(500).send({ error : 'database_failure' });
      }*/
    var toreturn = {};
    db.query("SELECT Groupname FROM m_automation GROUP BY Groupname", (qerr, result) => {
      toreturn.groupname = result;
      db.query("SELECT Category FROM m_automation GROUP BY Category", (qerr, result) => {
        toreturn.category = result;

        /*db.release();*/
        return res.status(200).send(toreturn);

      });
    });
    //  });
  });

  app.post("/api/post/duplicate/automation", (req, res) => {

    /*  pool.getConnection(function(conn_err, db){
        if(conn_err){ // connessione db fallita
          return res.status(500).send({ error : 'database_failure' });
        }*/

    const id = Number(req.body.id);

    db.query("SELECT Name FROM m_automation WHERE Name = (SELECT Name FROM m_automation WHERE ID = ?)", [id], (qerr, result) => {

      const name = result[0].Name;

      var promiseName = new Promise((resolve, reject) => {

        // cerco quelle con le parentesi.
        db.query("SELECT Count(ID) as C FROM m_automation WHERE Name LIKE CONCAT( (SELECT Name FROM m_automation WHERE ID = ?) , ' (%' ) ", [id], (qerr, result) => {

          let base_nr = 2 + Number(result[0].C);
          resolve(name + " (" + base_nr + ")");

        });


      }).then(name => {



        // Duplico l'automazione
        db.query("INSERT INTO m_automation (Channel, Name, Groupname, Category, Value) SELECT Channel, ?, Groupname, Category, Value FROM m_automation WHERE ID = ?", [name, id], (qerr, result) => {

          if (qerr) { /*db.release();*/ return res.status(500).send({ error: '/api/post/duplicate/automation -> query_1 error' }) }

          // Duplico i suoi eventi.
          db.query("INSERT INTO m_events (ID_Element, Table_Element, Item, Param, TimeRef, TimeStart, TimeEnd, Duration, TimeEnter, TimeExit, TimeShow, EventType, PosX, PosY, EventLoop, Segment, Destination, Enable, Hide) " +
            "SELECT ? , Table_Element, Item, Param, TimeRef, TimeStart, TimeEnd, Duration, TimeEnter, TimeExit, TimeShow, EventType, PosX, PosY, EventLoop, Segment, Destination, Enable, Hide FROM m_events WHERE ID_Element = ? ", [result.insertId, id], (qerr, result) => {

              /*db.release();*/
              if (qerr) { return res.status(500).send({ error: '/api/post/duplicate/automation -> query_2 error' }) }
              return res.status(200).send({ status: 1, generated_name: name });


            });

        });

      });

    });

    //  });

  });


  function getTagDetails(tag_id, id_instance) {

    return new Promise((resolve, reject) => {

      /*pool.getConnection(function(conn_err, db){
        if(conn_err){ // connessione db fallita
          return reject();
        }*/

      var temp = []

      db.query("SELECT * FROM m_device_tag_details WHERE ID_TAG = ?", [tag_id], (qerr, result) => {

        if (qerr) { /*db.release();*/ return reject(""); }

        db.query("SELECT NAME FROM m_instances WHERE ID = ?", [id_instance], (qerr, res_) => {

          if (qerr) { /*db.release();*/ return reject(""); }

          if (res_[0].NAME === 'G00') {

          }

          async.forEachOf(result, (details_row, key, callback) => {

            return new Promise((resolve1, reject1) => {

              if (res_[0].NAME !== 'G00') {

                // NON SIAMO NEL GENERIC, L'ID_DEVICE CI RITORNA CHE TIPO DI DEVICE SIAMO.
                db.query("SELECT VALUESTRING FROM m_device_tag_details where key1 = 'ID_DEVICE' and ID_TAG = ? and ID_DETAIL = ?", [details_row.ID_TAG, details_row.ID_DETAIL], (qerr, result) => {

                  if (result.length === 0 || qerr) return resolve1("");

                  db.query("SELECT b.VALUESTRING FROM m_device_settings b LEFT JOIN m_devices a on a.ID = b.ID_DEVICE WHERE a.ID = ? AND b.KEY1 = 'Type'", [Number(result[0].VALUESTRING)],
                    (qerr, result) => {
                      if (qerr || result.length === 0) { return resolve1(""); }
                      //console.log(result[0].VALUESTRING);
                      return resolve1(result[0].VALUESTRING);
                    });
                });

              } else {

                db.query("SELECT KEY1 FROM m_device_tag_details where ID_TAG = ? and ID_DETAIL = ? and (KEY1 NOT LIKE 'Enabled' and KEY1 not LIKE 'ID_DEVICE' )", [details_row.ID_TAG, details_row.ID_DETAIL], (qerr, result) => {

                  let type_device = "";

                  async.forEachOf(result, (row_tag_detail, key, callback_row) => {

                    if (type_device !== "")
                      return callback_row();

                    // SIAMO NEL GENERIC, DEVO CAPIRE DI CHE DEVICE TYPE SI TRATTA.
                    if (row_tag_detail.KEY1.indexOf("Projector_") >= 0)
                      type_device = 7;

                    if (row_tag_detail.KEY1.indexOf("AudioProcessor_") >= 0)
                      type_device = 6;

                    if (row_tag_detail.KEY1.indexOf("Gpi_") >= 0)
                      type_device = 1;

                    if (row_tag_detail.KEY1.indexOf("VideoRouter_") >= 0)
                      type_device = 0;

                    if (row_tag_detail.KEY1.indexOf("CustomCmd") >= 0)
                      type_device = 99;

                    return callback_row();

                  }, (callback_g00) => {


                    return resolve1(type_device);

                  })

                });

              }

            }).then((response) => {

              details_row['device_name'] = response;

              if (typeof temp[Number(details_row.ID_DETAIL) - 1] === "undefined") {
                temp[Number(details_row.ID_DETAIL) - 1] = [];
                temp[Number(details_row.ID_DETAIL) - 1].push(details_row);
              } else
                temp[Number(details_row.ID_DETAIL) - 1].push(details_row);

              return callback();

            });

          }, (callback) => {

            /*db.release();*/
            return resolve(temp);

          });

        });

      });

    });

    //  });

  }

  // Funzione per la lista macro del projector
  function getProjectorMarcos(theater_ids = []) {

    return new Promise((resolve, reject) => {

      /*  pool.getConnection(function(conn_err, db){
          if(conn_err){ // connessione db fallita
            return reject();
          }*/

      console.log(theater_ids);

      db.query("SELECT a.id , b.address , b.port , b.type FROM m_theaters a LEFT JOIN m_projector b on b.id = a.id_projector where b.address<>''", (qerr, result) => {

        if (qerr) { /*db.release();*/ return reject() }
        async.forEachOf(result, (row_address, key, callback) => {

          // Skippo se non è nell'array richiesto O se l'array di input non è vuoto (quindi non sono da fare tutti)
          if (!theater_ids.includes(row_address.id) && theater_ids.length > 0) {
            console.log('skippo' + row_address.id);
            return callback();;
          }

          var nc2 = new NetcatClient();
          let command_buffer = [];
          let buffer = Buffer.from([254, 0, 232, 5, 1, 200, 182, 255]);

          nc2.addr(row_address.address).port(43728).connect().send(buffer).on('data', (data) => {

            var arr = Array.prototype.slice.call(Buffer.from(data), 0);
            var tempBuff = []
            var macros = [];
            var macro_index = 0;
            arr.forEach((item, i) => {
              if (i <= 5) // Scarto i primi 5 bytes perchè non hanno significato.
                return
              if (item === 0) {
                macros.push(Buffer.from(tempBuff));
                tempBuff = [];
              } else {
                tempBuff.push(item);
              }
            });
            var macros_to_string = [];
            macros.forEach((item, i) => {
              macros_to_string.push(Buffer.from(item).toString());
            });

            console.log(macros_to_string);

            if (macros_to_string.length > 0) {

              db.query("DELETE FROM m_projector_macros WHERE id_theater = ?", [row_address.id], (qerr, result) => {
                async.forEachOf(macros_to_string, (macro_, inner_index, callback_insert) => {

                  if (macro_ === "")
                    return callback_insert();

                  db.query("INSERT INTO m_projector_macros (id_theater, macro, macro_index) VALUES (?,?,?)", [row_address.id, macro_, inner_index], (qerr, result_in) => {
                    if (qerr) { }
                    return callback_insert();
                  });
                }, (callback_ins) => {
                  return callback();
                });
              })
            }


          }).on('error', (err) => {
            console.log(err);
            return callback();
          })

        }, (callback) => {

          /*db.release();*/
          return resolve();

        });

      })

    });

    //  });

  }

  app.get("/api/get/instances/list", (req, res) => {

    /*  pool.getConnection(function(conn_err, db){
        if(conn_err){ // connessione db fallita
          return res.status(500).send({ error : 'database_failure' });
        }*/

    db.query("SELECT * FROM m_instances WHERE COMPUTER = 'STREAMER' AND NAME<>'G00' ORDER BY NAME", (qerr, result_main) => {

      ///*db.release();*/
      if (qerr) { return res.status(500).send({ error: '/api/get/instances/list -> query_1 error' }) }
      //return res.status(200).send(result);
      async.forEachOf(result_main, (instance, key, callback) => {

        if (instance.NAME === 'G00')
          return callback();

        db.query("SELECT VALUESTRING FROM m_instance_settings WHERE ID_INSTANCE = ? AND KEY1 = 'BroadcastAddress'", [instance.ID], (qerr, result1) => {

          if (qerr) { return callback(); }

          db.query("SELECT VALUESTRING FROM m_instance_settings WHERE ID_INSTANCE = ? AND KEY1 = 'Port'", [instance.ID], (qerr, result2) => {

            if (qerr) { return callback(); }

            result_main[key].settings = { address: result1[0].VALUESTRING, port: result2[0].VALUESTRING };

            return callback();

          })

        });

      }, (cb) => {

        /*db.release();*/
        return res.status(200).send(result_main);

      });

    })

    //  });

  });


  app.get("/api/get/tag/:id", (req, res) => {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
        return res.status(500).send({ error : 'database_failure' });
      }*/

    const id = req.params.id;

    db.query("SELECT * FROM m_device_tags WHERE ID = ?", [id], (qerr, result) => {

      if (qerr) { return res.status(500).send({ error: '/api/get/tag/:id -> query_1 error' }) }
      /*db.release();*/

      getTagDetails(id, result[0].ID_INSTANCE).then(details => {

        return res.status(200).send({ tag: result[0], details: details });

      }).catch(error => {

        return res.status(200).send({ tag: result[0], details: [] });

      });
    });
    //  });
  });


  app.get("/api/get/macrolist/:instancename", (req, res) => {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
        return res.status(500).send({ error : 'database_failure' });
      }*/

    const instancename = req.params.instancename;

    const query = instancename !== 'G00' ? "SELECT a.* , b.name FROM m_projector_macros a LEFT JOIN m_theaters b on b.id = a.id_theater LEFT JOIN m_instances c on c.ID_THEATER = a.id_theater WHERE c.NAME = ? ORDER BY a.macro_index" :
      "SELECT a.* , b.name FROM m_projector_macros a LEFT JOIN m_theaters b on b.id = a.id_theater ORDER BY b.name, a.macro_index";
    const array_query = instancename !== 'G00' ? [instancename] : [];

    db.query(query, array_query, (qerr, result) => {

      /*db.release();*/
      if (qerr || result.length === 0) { return res.status(200).send([]) };
      return res.status(200).send(result);

    });
    //  });
  });

  app.get('/api/get/macrosinstance/:theater_index', (req, res) => {

    const { theater_index } = req.params;

    db.query("SELECT a.ID, a.DESCRIPTION, a.ID_UNIVERSAL FROM m_device_tags a LEFT JOIN m_instances b on b.ID = a.ID_INSTANCE WHERE b.ID_THEATER = ? AND a.ENABLED = 1 ORDER BY a.DESCRIPTION", [devicemanager_ws_ports[theater_index].theater_id], (qerr, result) => {

      if (qerr || result.length === 0) { return res.status(200).send([]) };
      return res.status(200).send(result);

    });

  })

  app.post('/api/post/:index_theater/reload/macrolistfromdevice', (req, res) => {

    const { index_theater } = req.params;

    if (typeof devicemanager_ws_ports[index_theater] === 'undefined') return res.sendStatus(500);

    getProjectorMarcos([devicemanager_ws_ports[index_theater].theater_id]).then(result => {

      return res.status(200).send({ status: 1 });

    }).catch(err => {

      return res.status(500).send({ status: 0 });

    })

  });

  app.post("/api/post/:instancename/reload/macrolist", (req, res) => {


    const instancename = req.params.instancename;

    const query = instancename !== 'G00' ? "SELECT a.id FROM m_theaters a LEFT JOIN m_instances b on b.ID_THEATER = a.id WHERE b.NAME = ?" : "SELECT id FROM m_theaters ORDER BY theater_nr";
    const array_query = instancename !== 'G00' ? [instancename] : [];

    db.query(query, array_query, (qerr, result) => {

      /*db.release();*/

      if (qerr || result.length === 0) { return res.status(500).send({ error: '/api/post/:instancename/reload/macrolist -> query_1 error' }) }

      let theater_ids = [];
      result.forEach((id_theater, i) => {
        theater_ids.push(id_theater.id);
      });

      getProjectorMarcos(theater_ids).then(result => {

        return res.status(200).send({ status: 1 });

      }).catch(err => {

        return res.status(500).send({ status: 0 });

      })


    });


    //  });

  });



  app.post("/api/post/tag/:id", (req, res) => {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
        return res.status(500).send({ error : 'database_failure' });
      }*/

    //RELOADCONFIG

    const tagData = req.body.payload.tagData;
    const instancename = req.body.payload.instancename;
    const id_tag = Number(req.params.id);

    // Verifico se esiste già un tag con questo nome...
    db.query("SELECT b.ID FROM m_instances a LEFT JOIN m_device_tags b on b.ID_INSTANCE = a.ID WHERE a.NAME = ? AND b.DESCRIPTION = ? AND b.ID NOT LIKE ?", [instancename, tagData.tag.DESCRIPTION, id_tag], (qerr, check_exists) => {

      if (qerr || check_exists.length > 0) return res.status(500).send({ error: 'name' });

      // Se siamo in generic, non serve cercare per l'id_device perchè non serve, QuiNDI, faccio tutto in una promise.
      getDevicesFromInstance(instancename, db).then(res_ => {

        // tolgo tutti i tag details attuali del tag per riscrivere quelli nuovi
        db.query("DELETE FROM m_device_tag_details WHERE ID_TAG = ?", [id_tag], (qerr, result) => {

          createTagDetailsRows(tagData, res_, id_tag, instancename, db).then(ress => {

            // mi serve il nome originale per controllare se è da togliere dalla lista G00
            db.query("SELECT DESCRIPTION FROM m_device_tags WHERE ID = ?", [id_tag], (qerr, backup_name) => {

              // Qua ho finito di inserire i tag details, devo fare l'update del tag stesso.
              db.query("UPDATE m_device_tags SET DESCRIPTION = ? , ENABLED = ? WHERE ID = ?", [tagData.tag.DESCRIPTION, Number(tagData.tag.ENABLED), id_tag], (qerr, result) => {

                // Se tutto ok, abbiamo finito.
                /*db.release();*/

                if (instancename === 'G00') return res.status(200).send({ status: 1 });

                // devo aggiornare il tag...
                db.query("SELECT ID_THEATER FROM m_instances WHERE DESCRIPTION = ?", [instancename], (qerr, instance_) => {

                  for (let i = 0; i < devicemanager_ws_ports.length; i++) {

                    if (devicemanager_ws_ports[i].theater_id === instance_[0].ID_THEATER) {

                      //console.log('reload config dvm')
                      if (typeof clientWebSocketsDVM[i] !== 'undefined' && clientWebSocketsDVM[i].readyState === WebSocket.OPEN)
                        clientWebSocketsDVM[i].send('RELOADCONFIG\n');

                      break;

                    }

                  }

                  new Promise((resolve_generic, reject_generic) => {

                    // Creo il tag per il generico solo nominativo...
                    db.query("SELECT b.ID FROM m_instances a LEFT JOIN m_device_tags b on b.ID_INSTANCE = a.ID WHERE a.NAME = 'G00' AND b.DESCRIPTION = ?", [tagData.tag.DESCRIPTION], (qerr, check_exists) => {

                      if (qerr || check_exists.length > 0) return resolve_generic();

                      // se non esiste, va creato.
                      db.query("SELECT ID FROM m_instances WHERE NAME = 'G00'", (qerr, instances) => {

                        const generic_id = instances[0].ID;
                        let uuid_generic = uuidv4().toString().toUpperCase();

                        db.query("INSERT INTO m_device_tags (ID_UNIVERSAL, DESCRIPTION, ENABLED, ID_INSTANCE) VALUES (?,?,1,?)", [uuid_generic, tagData.tag.DESCRIPTION, generic_id], (qerr, tag) => {


                          //return res.status(200).send({ status: 1 });
                          return resolve_generic();

                        });

                      });

                    });

                  }).then(resolved_ => {

                    db.query("SELECT ID FROM m_instances WHERE NAME = 'G00'", (qerr, instances) => {

                      db.query("SELECT ID FROM m_device_tags WHERE DESCRIPTION = ? AND ID_INSTANCE NOT LIKE ?", [backup_name[0].DESCRIPTION, instances[0].ID], (qerr, done) => {

                        if (qerr || done.length > 0) return res.status(200).send({ status: 1 });

                        db.query("DELETE FROM m_device_tags WHERE DESCRIPTION = ? AND ID_INSTANCE = ?", [backup_name[0].DESCRIPTION, instances[0].ID], (qerr, finished) => {

                          return res.status(200).send({ status: 1 });

                        });

                      });

                    });

                  }).catch(error => {

                    return res.status(200).send({ status: 1 });

                  });

                });

              });

            })

          }).catch(err => {

            /*db.release();*/
            return res.status(500).send({ status: 0 });

          });

        })



      }).catch(err => {

        /*db.release();*/
        return res.status(500).send({ status: 0 });

      })


    });

  });





  app.post("/api/post/tag", (req, res) => {

    /*  pool.getConnection(function(conn_err, db){
        if(conn_err){ // connessione db fallita
          return res.status(500).send({ error : 'database_failure' });
        }*/

    const tagData = req.body.payload.tagData;
    const instancename = req.body.payload.instancename;
    const id_tag = Number(req.params.id);

    createDeviceTag(tagData, instancename, id_tag, db).then(result => {

      return res.sendStatus(200);

    }).catch(error => {

      return res.status(500).send(error);

    })



  });


  app.get("/api/get/instance/:instancename/devices", (req, res) => {

    const instancename = sanitizeString(req.params.instancename);

    getDevicesFromInstance(instancename, db, true).then(res_ => {

      return res.status(200).send(res_);

    }).catch(err => {

      return res.status(500).send([])

    })

  });



  app.get("/api/get/audioprocessor/:instancename/modelist", (req, res) => {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
        return res.status(500).send({ error : 'database_failure' });
      }*/

    const instancename = req.params.instancename;

    db.query("SELECT c.type FROM m_instances a LEFT JOIN m_theaters b on b.id = a.ID_THEATER LEFT JOIN m_audioprocessor c on c.id = b.id_audioprocessor WHERE a.NAME = ?", [instancename], (qerr, result) => {

      /*db.release();*/
      if (qerr || result.length === 0) { return res.status(200).send(audioprocessors_modes[2]); }

      if (Number(result[0].type) > 4)
        return res.status(200).send(audioprocessors_modes[2]); // se è maggiore del fidek e quindi sono tutti cp850 ecc ritorno il cp 750
      else
        return res.status(200).send(audioprocessors_modes[Number(result[0].type)]);

    })

    //  });

  });

  app.post("/api/delete/tag/:id", (req, res) => {

    // ipoteticamente deprecata si usa solo la multi.

    const id_tag = Number(req.params.id);
    deleteDeviceManagerTag(id_tag).then(res_ => {
      return res.status(200).send({ status: 1 })
    }).catch(error => {
      console.log(error);
      return res.status(500).send({ status: 0 });
    })

  })


  app.post("/api/delete/multi/tags", (req, res) => {

    const payload = req.body.payload;
    async.forEachOf(payload, (id_tag, key, callback) => {

      deleteDeviceManagerTag(id_tag).then(res_ => {

        return callback();

      }).catch(error => {

        return res.status(500).send({ status: 0 });

      })

    }, (callback) => {
      return res.status(200).send({ status: 1 })
    });

  })



  function deleteDeviceManagerTag(id_tag) {

    return new Promise((resolve, reject) => {

      // Prendo la description di questo tag e controllo se esiste in altre istanze oltre a questa e la generic
      db.query("SELECT DESCRIPTION, ID_INSTANCE FROM m_device_tags WHERE ID = ?", [id_tag], (qerr, desc_q) => {

        db.query("SELECT ID FROM m_instances WHERE NAME = 'G00'", (qerr, generic_) => {

          db.query("SELECT ID FROM m_device_tags WHERE DESCRIPTION = ? AND ID_INSTANCE NOT LIKE ? AND ID_INSTANCE NOT LIKE ?", [desc_q[0].DESCRIPTION, desc_q[0].ID_INSTANCE, generic_[0].ID], (qerr, check) => {

            let delete_generic = check.length === 0;

            db.query("DELETE FROM m_device_tag_details WHERE ID_TAG = ?", [id_tag], (qerr, result) => {
              if (qerr) { /*db.release();*/ return reject(); }
              db.query("DELETE FROM m_device_tags WHERE ID = ?", [id_tag], (qerr, result) => {
                /*db.release();*/

                if (qerr) { return reject(); } else {

                  if (!delete_generic) return resolve();

                  db.query("DELETE FROM m_device_tags WHERE DESCRIPTION = ? AND ID_INSTANCE = ?", [desc_q[0].DESCRIPTION, generic_[0].ID], (qerr, deletee) => {

                    return resolve();

                  });
                }
              });
            });

          })

        });
      });
    });



  }

  function getDeviceInstances() {

    return new Promise((resolve, reject) => {

      /*pool.getConnection(function(conn_err, db){
          if(conn_err){ // connessione db fallita
            return reject();
        }*/

      db.query("SELECT * FROM m_instances WHERE COMPUTER = 'STREAMER' ORDER BY NAME", (qerr, result) => {

        /*db.release();*/

        if (qerr || result.length === 0) return resolve([]);
        return resolve(result);

      });

    })
    //  });

  }


  app.post('/api/post/duplicate/tags', (req, res) => {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
        return res.status(500).send({ error : 'database_failure' });
      }*/

    var counter_copied = 0;

    const payload = req.body.payload;

    if (payload.instancename_to === payload.instancename_from && Number(payload.rule) === 1) {

      // Se stiamo copiando i tag dentro la stessa istanza, non dovrei essere in grado di sovrascrivere i tag stessi perchè 1 non cambierebbe niente e 2 non avrebbe senso
      // Quindi, do che è stato fatto e fine.
      return res.status(200).send({ status: 1, message: 'nothing changed...' });

    }


    // Prendo gli ID device dell'istanza di riferimento
    getDevicesFromInstance(payload.instancename_to, db, true).then(res_to => {

      // Prendo gli ID device dell'istanza di origine x la conversione
      getDevicesFromInstance(payload.instancename_from, db, true).then(res_from => {

        async.forEachOf(payload.ids, (id_tag, key, callback) => {

          db.query("SELECT DESCRIPTION FROM m_device_tags WHERE ID = ? ", [id_tag], (qerr_main, result_desc) => {

            // Devo verificare, seguendo la regola, se:
            // Regola 0: Controllo se già esista un tag con questo nome e uso lo stesso metodo per le automazioni, e la aggiunto
            // Regola 1: Se esiste il tag con questo nome in questa istanza, allora devo prima rimuovere il tag e poi riscriverlo normalmente.
            return new Promise((resolve, reject) => {

              db.query("SELECT b.ID FROM m_device_tags a LEFT JOIN m_device_tags b on a.DESCRIPTION = b.DESCRIPTION WHERE a.ID = ? AND a.ID_INSTANCE = (SELECT ID FROM m_instances WHERE NAME = ?) AND b.ID_INSTANCE = (SELECT ID FROM m_instances WHERE NAME = ?)",
                [Number(id_tag), payload.instancename_from, payload.instancename_to], (qerr, result) => {

                  counter_copied++;
                  // Mando lo stato della duplicazione
                  wss.clients.forEach(function each(client) {
                    let response = { type: 'device_manager_duplication', body: { done: counter_copied, total: payload.ids.length, tag: result_desc[0].DESCRIPTION }, date: new Date() };
                    if (client.readyState === WebSocket.OPEN) {
                      client.send(JSON.stringify(response));
                    }
                  });

                  if (qerr) { return reject(); }

                  switch (Number(payload.rule)) {

                    case 0:
                      if (result.length === 0) {
                        // Non esiste il nome, possiamo procedere
                        return resolve("");
                      } else {

                        // Già esiste, procedo a prendere il max
                        db.query("SELECT Count(ID) as C FROM m_device_tags WHERE DESCRIPTION LIKE CONCAT( (SELECT DESCRIPTION FROM m_device_tags WHERE ID = ?) , ' (%' )", [id_tag], (qerr, result) => {

                          if (qerr) { return reject(); }
                          let base_nr = 2 + Number(result[0].C);
                          return resolve(" (" + base_nr + ")"); // Stringa da concatenare al nome.

                        });

                      }
                      break;

                    case 1: // CANCELLO IN DESTINAZIONE SE ESISTE CON STESSO NOME.
                      if (result.length === 0) {
                        // Non esiste il nome, possiamo procedere
                        //console.log('tutto ok.');
                        return resolve("");

                      } else {

                        //console.log('elimino');

                        // devo rimuovere il tag prima
                        deleteDeviceManagerTag(result[0].ID).then(removal => {

                          return resolve(""); // Ok..

                        }).catch(error_removal => {

                          return reject();

                        })

                      }
                      break;

                    default: // di default, se non ho regole, do errore.
                      return reject();

                  }


                });

            }).then(rule_result => {

              let uuid = uuidv4().toString().toUpperCase();

              // duplicazione qui.
              db.query("INSERT INTO m_device_tags (ID_UNIVERSAL, DESCRIPTION, ENABLED, ID_INSTANCE) SELECT ? , CONCAT(DESCRIPTION , ?) , ENABLED , (SELECT ID FROM m_instances WHERE NAME = ? AND COMPUTER = 'STREAMER' LIMIT 1) FROM m_device_tags WHERE ID = ?",
                [uuid.replace('/-/g', ''), rule_result.toString(), payload.instancename_to, id_tag], (qerr, result_insert) => {

                  // Errore creazione testata tag. callbacko e skippo.
                  if (qerr) { return callback(); }

                  // Ora, ci sono 4 possibili casi.
                  // Primo caso, stiamo copiando da G00 in un istanza con devices, quindi devo identificare gli id device del to tramite il vecchio metodo del capire cosa è un tag details.
                  // Secondo caso, stiamo copiando da un istanza reale con device alla G00, quindi NON dobbiamo scrivere i record ID_Device, simple as that.
                  // Terzo caso, stiamo copiando da g00 a g00, non sappiamo che id device siano, quindi non scrivo semplicemente gli id_device come nel caso 2
                  // Quarto caso, stiamo copiando da un istanza reale ad un'altra istanza reale, quindi il metodo già esiste ed è l'ultimo caso nel nostro switch

                  // Siccome il secondo e terzo caso vengono trattati allo stesso modo, la funzione si occuperà di 3 possibili casi dove 2 vengono elaborati allo stesso modo con un diretto richiamo della callback punto fine.

                  // Inserisco i tag details MENO i loro id_device
                  db.query("INSERT INTO m_device_tag_details (ID_TAG, ID_DETAIL, KEY1, VALUESTRING) SELECT ? , ID_DETAIL , KEY1 , VALUESTRING FROM m_device_tag_details WHERE ID_TAG = ? AND KEY1 NOT LIKE 'ID_DEVICE' ",
                    [result_insert.insertId, id_tag], (qerr, result_details) => {

                      if (qerr) { return callback(); }

                      switch (true) {

                        case (payload.instancename_from === 'G00' && payload.instancename_to !== 'G00'): // caso 1

                          //console.log('caso 1');
                          db.query("SELECT * FROM m_device_tag_details WHERE ID_TAG = ? GROUP BY ID_DETAIL", [result_insert.insertId], (qerr, result_get) => {

                            if (qerr || result_get.length === 0) { console.log('0 dettagli'); return callback() } // errore...

                            async.forEachOf(result_get, (detail_, key_det, callback_detail) => {

                              db.query("SELECT * FROM m_device_tag_details WHERE ID_TAG = ? AND ID_DETAIL = ? AND (KEY1 NOT LIKE 'Enabled')", [result_insert.insertId, detail_.ID_DETAIL], (qerr, result_find) => {

                                //console.log('leggo i details del tag!');

                                if (qerr || result_find.length === 0) return callback_detail(false);
                                let type_device = "";

                                async.forEachOf(result_find, (row_tag_detail, key_x, callback_row) => {

                                  if (type_device !== "")
                                    return callback_row(type_device);

                                  // SIAMO NEL GENERIC, DEVO CAPIRE DI CHE DEVICE TYPE SI TRATTA.
                                  if (row_tag_detail.KEY1.indexOf("Projector_") >= 0)
                                    type_device = 7;

                                  if (row_tag_detail.KEY1.indexOf("AudioProcessor_") >= 0)
                                    type_device = 6;

                                  if (row_tag_detail.KEY1.indexOf("Gpi_") >= 0)
                                    type_device = 1;

                                  if (row_tag_detail.KEY1.indexOf("VideoRouter_") >= 0)
                                    type_device = 0;

                                  return callback_row(type_device);

                                }, (callback_g00) => {

                                  //console.log("type -> " + callback_g00)

                                  let converted_id_device = "";

                                  // Piglio l'id_device di questo type per il to
                                  res_to.forEach((item, i) => {
                                    if (Number(item.device_type) === Number(callback_g00))
                                      converted_id_device = item.device_id;
                                  });

                                  if (converted_id_device === '') {
                                    return callback_detail(false);
                                  }

                                  db.query("INSERT INTO m_device_tag_details (ID_TAG, ID_DETAIL, KEY1, VALUESTRING) VALUES (? , ? , 'ID_DEVICE' , ?)",
                                    [result_insert.insertId, detail_.ID_DETAIL, Number(converted_id_device)], (qerr, result_final) => {

                                      if (qerr) return callback_detail(false);
                                      return callback_detail(true);

                                    })

                                })

                              })

                            }, (callback_detail) => {

                              // db detail caso 1
                              //console.log('callback')
                              return callback(true);

                            });

                          }); break;

                        case (payload.instancename_to === 'G00'): // caso 2\3
                          //console.log('caso 2/3');
                          return callback(true);

                        case (payload.instancename_from !== 'G00' && payload.instancename_to !== 'G00'): // caso 4
                          //console.log('caso 4');

                          // SE tutto ok, ora posso inserire gli id_device
                          db.query("SELECT * FROM m_device_tag_details WHERE ID_TAG = ? AND KEY1 LIKE 'ID_DEVICE' ", [id_tag], (qerr, select_ids) => {

                            if (qerr) { return callback(); }
                            async.forEachOf(select_ids, (id_device_row, key_in, callback_in) => {

                              let current_device_type = "";
                              let converted_id_device = "";

                              //cerco che type sia questo id_device dell'istanza from
                              res_from.forEach((item, i) => {
                                if (Number(item.device_id) === Number(id_device_row.VALUESTRING))
                                  current_device_type = item.device_type;
                              });

                              // Prendo l'id device dal to per questo type
                              res_to.forEach((item, i) => {
                                if (Number(item.device_type) === Number(current_device_type))
                                  converted_id_device = item.device_id;
                              });

                              if (converted_id_device === "")
                                return callback_in(false); // Non abbiamo l'id device convertito, non posso inserire....

                              db.query("INSERT INTO m_device_tag_details (ID_TAG, ID_DETAIL, KEY1, VALUESTRING) VALUES (? , ? , 'ID_DEVICE' , ?)",
                                [result_insert.insertId, id_device_row.ID_DETAIL, Number(converted_id_device)], (qerr, result_insert_iddevice) => {

                                  if (qerr) { return callback_in(false); }
                                  return callback_in(true);

                                });

                            }, (callback_in) => {

                              // fine insert degli id_devices.
                              return callback(true);

                            });

                          }); break;// fine select id_device

                        default:
                          return callback();

                      }

                    });

                });

            }).catch(rule_error => {
              return res.status(500).send({ status: 0 });
            });

          });


        }, (callback) => {

          // callback.... finale (sempre che risponda)
          /*db.release();*/
          return res.status(200).send({ status: 1 });

        });

      }).catch(err => {

        /*db.release();*/
        return res.status(500).send({ status: 0 });

      })

    }).catch(err => {

      /*db.release();*/
      return res.status(500).send({ status: 0 });

    })

    //  });

  });


  app.get("/api/get/:instancename/gpi/ports", (req, res) => {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
        return res.status(500).send({ error : 'database_failure' });
      }*/

    const instancename = req.params.instancename;

    db.query("SELECT ID_DEVICE FROM m_device_settings a LEFT JOIN m_devices b on b.ID = a.ID_DEVICE LEFT JOIN m_instances c on c.ID = b.ID_INSTANCE WHERE c.NAME = ? AND a.KEY1 = 'Type' AND a.VALUESTRING = '1' ", [instancename],
      (qerr, result) => {

        if (qerr || result.length === 0) return res.status(200).send([]);

        db.query("SELECT * FROM m_device_settings WHERE ID_DEVICE = ? AND KEY1 LIKE 'Gpi_MaxOutput'", [result[0].ID_DEVICE], (qerr, result_max) => {


          if (qerr) { return res.status(200).send([]); }

          db.query("SELECT * FROM m_device_settings WHERE ID_DEVICE = ? AND KEY1 LIKE 'Gpi_LabelOutput%'", [result[0].ID_DEVICE], (qerr, result_labels) => {

            if (qerr) { return res.status(200).send([]); }

            /*db.release();*/

            let response = [];
            for (let i = 1; i <= Number(result_max[0].VALUESTRING); i++) {

              let label_output = "";

              // cerco se esiste una label per questo
              result_labels.forEach((label_item, x) => {
                if (label_item.KEY1 === "Gpi_LabelOutput" + i.toString() + "_1")
                  label_output = label_output + label_item.VALUESTRING;
                if (label_item.KEY1 === "Gpi_LabelOutput" + i.toString() + "_2")
                  label_output = label_output + " " + label_item.VALUESTRING;
              });

              response.push({ value: i, label: label_output !== '' ? (i.toString() + " - " + label_output) : i.toString() });

            }

            return res.status(200).send(response);
          });

        });

      });

    //  });

  });


  app.get("/api/get/:instancename/videorouter/ports", (req, res) => {

    /*  pool.getConnection(function(conn_err, db){
        if(conn_err){ // connessione db fallita
          return res.status(500).send({ error : 'database_failure' });
        }
        */

    const instancename = req.params.instancename;

    db.query("SELECT ID_DEVICE FROM m_device_settings a LEFT JOIN m_devices b on b.ID = a.ID_DEVICE LEFT JOIN m_instances c on c.ID = b.ID_INSTANCE WHERE c.NAME = ? AND a.KEY1 = 'Type' AND a.VALUESTRING = '0' ", [instancename],
      (qerr, result) => {
        if (qerr || result.length === 0) { /*db.release();*/ return res.status(200).send([]); }

        const labels = ['Input', 'Output'];

        return new Promise((resolve, reject) => {

          let response_real = { input: [], output: [] };
          let response = [];

          async.forEachOf(labels, (label_action, key, callback) => {

            response[key] = [];

            db.query("SELECT * FROM m_device_settings WHERE ID_DEVICE = ? AND KEY1 LIKE ?", [result[0].ID_DEVICE, 'VideoRouter_Max' + label_action], (qerr, result_max) => {
              if (qerr || result_max.length === 0) { return callback(response_real); }
              db.query("SELECT * FROM m_device_settings WHERE ID_DEVICE = ? AND KEY1 LIKE ?", [result[0].ID_DEVICE, 'VideoRouter_Label' + label_action + "%"], (qerr, result_labels) => {
                if (qerr || result_labels.length === 0) { return callback(response_real) }

                for (let i = 1; i <= Number(result_max[0].VALUESTRING); i++) {

                  let label_output = "";
                  // cerco se esiste una label per questo
                  result_labels.forEach((label_item, x) => {
                    if (label_item.KEY1 === "VideoRouter_Label" + label_action + i.toString() + "_1")
                      label_output = label_output + label_item.VALUESTRING;
                    if (label_item.KEY1 === "VideoRouter_Label" + label_action + i.toString() + "_2")
                      label_output = label_output + " " + label_item.VALUESTRING;
                  });

                  response[key].push({ value: i, label: label_output !== '' ? (i.toString() + " - " + label_output) : i.toString() });

                }
                response_real[label_action.toLowerCase()] = response[key];

                if (key === 1)
                  return callback(response_real);

              });
            });


          }, (response_real_cb) => {

            return resolve(response_real);

          });

        }).then(to_send => {

          //console.log(to_send)

          /*db.release();*/
          return res.status(200).send(to_send);

        }).catch(error => {

        });

      });

    //});

  });

  app.get("/api/get/title/:uuid", (req, res) => {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
        return res.status(500).send({ error : 'database_failure' });
      }*/

    const uuid = req.params.uuid;

    db.query("SELECT Title FROM m_dcp WHERE Fileaudio like concat('urn:uuid:' , ?)", [uuid], (qerr, result) => {

      if (qerr || result.length === 0) {

        db.query("SELECT title FROM m_export_spl WHERE uuid = ?", [uuid], (qerr, result) => {

          /*db.release();*/
          if (qerr || result.length === 0) return res.status(200).send({ title: uuid });
          return res.status(200).send({ title: result[0].title });

        });


      } else {
        /*db.release();*/
        return res.status(200).send({ title: result[0].Title });
      }

    });

    //});

  });

  app.get('/api/get/spl/info/:uuid/:index', (req, res) => {

    // rICHIESTA
    const uuid_spl = req.params.uuid;
    const index = req.params.index;
    clientWebSockets[index].send('CONTENT-GETPLAYSEQUENCE\n');
    return res.status(200).send({ status: 1, requested: true });

  });

  app.get('/api/get/:type/cpllist', (req, res) => {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
        return res.status(500).send({ error : 'database_failure' });
      }*/

    const export_type = Number(req.params.type);

    db.query("SELECT a.* , IF(b.Image64 is null, '' , b.Image64) as Image64 FROM m_dcp a LEFT JOIN m_cpl_images b on a.Fileaudio = b.UuidCpl ORDER BY a.RefrainMixIn DESC, a.Title ASC", (qerr, result) => {

      if (result.length === 0) return res.status(200).send({ rows: [] });

      /*db.release();*/

      if (export_type === 0) {

        let rows_composed = [];
        let rows_count = 0;

        // devo parsare result in modo che possa contenere l'ingest status getCplTheaterStatus(id_cpl)
        async.forEachOf(result, (cpl_record, index_cpl, callback) => {

          new Promise((resolve, reject) => {

            getCplTheaterStatus(cpl_record.ID).then(cpl_status => {

              return resolve(cpl_status);

            })

          }).then(resolved => {

            rows_count++;
            cpl_record.cpl_status = resolved;

            rows_composed.push(cpl_record);

            if (rows_count >= result.length) return callback(rows_composed);

          }).catch(error => {


          });


        }, (callback_) => {

          //callback_.sort((a, b) => { return a.RefrainMixIn + b.RefrainMixIn });
          //callback_.sort((a, b) => { return a.Title - b.Title });

          return res.status(200).send({ rows: callback_ });

        })


      }

    });

    //  });

  });

  function sendBeatStatus() {

    return new Promise((resolve, reject) => {

      let status = { ping_playout: true, datastores: [], database: typeof db !== 'undefined', require_installation: playout_ws_ports.length === 0 && !is_streamer_already_intalled };

      if (typeof db === 'undefined') return resolve(status);

      db.query("SELECT * FROM m_datastores ORDER BY ID", (qerr, result) => {

        if (qerr || result.length === 0) return resolve(status);

        let datastore_count = 0;
        let datastores = [];

        async.forEachOf(result, (datastore, index, callback_datastore) => {

          var conn = new Client();
          var output = "";
          let current = { online: false };

          conn.on('ready', function () {

            current['online'] = true;

            conn.exec("df -BK | grep /datastore", function (err, stream) {
              if (err) {

                datastores.push({ id: datastore.id, 'label': datastore.name.toUpperCase(), 'address': datastore.address, ping: true, space_left: 0, total_space: 0 });
                datastore_count++;

                if (datastore_count >= result.length) {

                  datastores = datastores.sort(function (a, b) {
                    return ('' + a.label).localeCompare(b.label);
                  });

                  status.datastores = datastores;
                  return resolve(status);
                }

                return;

              }
              stream.on('data', function (data) {

                output = output + data;

              }).on('end', (e) => {

                output = output.replace(/[K]/g, '');
                let split_datastore = output.split(" ");
                let re_parsed = [];

                split_datastore.forEach((item, i) => {
                  if (item !== '') re_parsed.push(item);
                });

                // ABbiamo i dati parsati del datastore
                datastores.push({ id: datastore.id, 'label': datastore.name.toUpperCase(), 'address': datastore.address, ping: true, space_left: re_parsed[3], total_space: re_parsed[1] });

                datastore_count++;
                if (datastore_count >= result.length) {

                  datastores = datastores.sort(function (a, b) {
                    return ('' + a.label).localeCompare(b.label);
                  });

                  status.datastores = datastores;
                  return resolve(status);
                }

              });

            });

          }).on('error', function (err) {


            datastores.push({ id: datastore.id, 'label': datastore.name.toUpperCase(), 'address': datastore.address, ping: false, space_left: 0, total_space: 0 });
            datastore_count++;
            if (datastore_count >= result.length) {

              datastores = datastores.sort(function (a, b) {
                return ('' + a.label).localeCompare(b.label);
              });

              status.datastores = datastores;
              return resolve(status);
            }


          }).connect({
            host: datastore.address,
            port: 22,
            username: datastore.username,
            password: datastore.password,
            readyTimeout: 2500
          });

        })

      });


    });

  }

  /*
    function sendBeatStatus() {
   
      return new Promise((resolve, reject) => {
   
   
        var status = { ping_playout: false, datastores: {} };
   
        db.query("SELECT string_value FROM m_generalsettings WHERE key2 = 'ip_playout'", (qerr, result) => {
   
          return new Promise((resolve1, reject1) => {
            if (qerr || result.length === 0) {
              return resolve1(false);
            } else {
              ping.sys.probe(result[0].string_value, (isAlive) => {
                return resolve1(isAlive);
              });
            }
   
          }).then(res_ => {
   
            status.ping_playout = res_; // assegno il ping del playout alla sua variabile
   
            return new Promise((resolve2, reject2) => {
   
              db.query("SELECT * FROM m_datastores ORDER BY ID", (qerr, result) => {
   
                let datastores = [];
   
                async.forEachOf(result, (datastore, key, callback) => {
   
                  // Checko lo spazio.
                  var conn = new Client();
                  var output = "";
                  let current = { online: false };
   
                  // PER ORA RESTA COSì...
                  //return callback();
   
                  conn.on('ready', function () {
   
                    current['online'] = true;
   
                    conn.exec("df -BK | grep /datastore", function (err, stream) {
                      if (err) {
   
                        ping.sys.probe(result[0].string_value, (isAlive) => {
                          datastores.push({ id: datastore.id, 'label': datastore.name, 'address': datastore.address, ping: isAlive, space_left: 0, total_space: 0 });
                          return callback();
                        });
   
                      }
                      stream.on('close', function (code, signal) {
                        conn.end();
                      }).on('data', function (data) {
                        output = output + data;
                      }).stderr.on('data', function (data) {
   
   
                      }).on('close', (e) => {
   
                        output = output.replace(/[K]/g, '');
                        let split_datastore = output.split(" ");
                        let re_parsed = [];
   
                        split_datastore.forEach((item, i) => {
                          if (item !== '') re_parsed.push(item);
                        });
   
                        // ABbiamo i dati parsati del datastore
                        datastores.push({ id: datastore.id, 'label': datastore.name, 'address': datastore.address, ping: true, space_left: re_parsed[3], total_space: re_parsed[1] });
                        return callback();
   
                      });
   
                    });
   
                  }).on('error', function (err) {
   
                    ping.sys.probe(result[0].string_value, (isAlive) => {
                      datastores.push({ id: datastore.id, 'label': datastore.name, 'address': datastore.address, ping: isAlive, space_left: 0, total_space: 0 });
                      return callback();
                    });
   
                  }).connect({
                    host: datastore.address,
                    port: 22,
                    username: datastore.username,
                    password: datastore.password,
                    readyTimeout: 2500
                  });
   
                }, (callback_) => {
   
                  
                  return resolve2(datastores);
   
                });
   
              });
   
            }).then(res2_ => {
   
              // Ho lo stato dei datastore
              status.datastores = res2_;
              resolve(status);
   
   
            }).catch(error_ => {
   
              resolve(status);
   
            });
   
   
   
          }).catch(err => {
   
            resolve(status);
   
          });
   
        });
      });
    
    }*/

  app.get('/api/test/pause', (req, res) => {

    // rICHIESTA
    clientWebSockets[1].send('PAUSE\n');
    return res.status(200).send({ status: 1, requested: true });

  });

  app.post('/api/post/cineplayout/:theater_index/cmd', (req, res) => {

    const theater_index = Number(req.params.theater_index);
    const command = req.body.cmd;

    try {

      switch (command) {

        case 'PAUSE':
          clientWebSockets[theater_index].send('CONTENT-PAUSE\n');
          break;

        case 'PLAY':
          clientWebSockets[theater_index].send('CONTENT-PLAY\n');
          break;

        case 'STOP':
          clientWebSockets[theater_index].send('CONTENT-STOP\n');
          break;

        case 'UNLOAD':
          clientWebSockets[theater_index].send('CONTENT-UNLOAD\n');
          break;

        case 'NEXT':
          clientWebSockets[theater_index].send('PLAYBACK-NEXT\n');
          break;

        case 'MANUAL':
          clientWebSockets[theater_index].send('PLAYBACK-SETMODE\nMANUAL\n');
          break;

        case 'AUTOMATIC':
          clientWebSockets[theater_index].send('PLAYBACK-SETMODE\nAUTOMATIC\n');
          break;

        default:
          break;

      }

      return res.status(200).send({ status: 1 });

    } catch (err) {

      return res.status(200).send({ status: 1 });

    }

  });

  app.post('/api/post/cineplayout/:theater_index/locate', (req, res) => {

    const theater_index = Number(req.params.theater_index);
    const locate_value = req.body.ms_value;
    clientWebSockets[theater_index].send('CONTENT-SEEK\n' + locate_value.toString());
    return res.status(200).send({ status: 1 });

  });

  app.get('/api/get/library/:index/:theater_index/items', (req, res) => {

    const index_library = Number(req.params.index);

    switch (index_library) {

      case 0:

        if (req.params.theater_index === 'all') {

          db.query("SELECT ID , Title, Groupname , Category , Duration from m_dcp ORDER BY Title", (qerr, result) => {

            if (qerr) return res.status(200).send([]);
            return res.status(200).send(result);

          });

        } else {

          const id_theater = playout_ws_ports[Number(req.params.theater_index)].theater_id;

          // Verifico se il teatro è direct streaming \ hula.
          db.query("SELECT a.direct_streaming, a.certified, a.type FROM m_imb a LEFT JOIN m_theaters b on b.id_imb = a.id WHERE b.id = ?", [id_theater], (qerr, result) => {

            if (result[0].type !== 'HULA' && result[0].direct_streaming === 0) {

              // Lista con contenuti che stanno in clips
              db.query("SELECT a.ID , a.Title, a.Groupname , a.Category , Duration from m_dcp a LEFT JOIN clips b ON b.uuid = a.Fileaudio LEFT JOIN m_imb c on c.serial = b.serial LEFT JOIN m_theaters d on d.id_imb = c.id WHERE b.progress = 'COMPLETE' and d.id = ? ", [id_theater], (qerr, result) => {

                if (qerr) return res.status(200).send([]);
                return res.status(200).send(result);

              })

            } else if (result[0].type === 'HULA') {

              // modalità hula...            
              db.query("SELECT b.type, c.name FROM m_theaters a LEFT JOIN m_imb b on b.id = a.id_imb LEFT JOIN m_datastores c on c.id = b.id_datastore WHERE a.id = ?", [id_theater], (qerr, the) => {

                console.log(qerr);

                const serial = the[0].type + "-" + the[0].name;
                db.query("SELECT a.ID , a.Title, a.Groupname , a.Category , Duration from m_dcp a LEFT JOIN clips b ON b.uuid = a.Fileaudio WHERE b.progress = 'COMPLETE' and b.serial = ?", [serial], (qerrr, final) => {

                  if (qerrr) return res.status(200).send([]);
                  return res.status(200).send(final);

                })

              })

            } else {

              if (result[0].direct_streaming === 1) {

                // Lista contenuti disponibili SOLO se verificati
                db.query("SELECT  a.ID , a.Title, a.Groupname , a.Category , Duration from m_dcp a LEFT JOIN m_streamercop_verify b ON b.uuid = a.Fileaudio LEFT JOIN m_datastores c ON c.name = b.datastore_name LEFT JOIN m_imb d ON d.id_datastore = c.id LEFT JOIN m_theaters e ON e.id_imb = d.id WHERE e.id = ? AND b.progress ='VERIFIED'", [id_theater], (qerr, result) => {

                  if (qerr) return res.status(200).send([]);
                  return res.status(200).send(result);

                })

              }

            }



          });

        }

        break;

      case 1:
        db.query("SELECT * FROM m_manual_playlist ORDER BY Description", (qerr, result) => {

          if (qerr) return res.status(200).send([]);
          return res.status(200).send(result);

        });
        break;

      case 2: // erano le automazioni, sostituite con i tags generici...
        /*
        db.query("SELECT * from m_automation ORDER BY Name" , (qerr, result) => {
    
          if(qerr) return res.status(200).send([]);
          return res.status(200).send(result);
          
    
        });
        break;*/

        // cerco quale sia l'istanza generica del sistema
        db.query("SELECT ID FROM m_instances WHERE DESCRIPTION = 'G00'", (qerr, result) => {

          if (qerr || result.length === 0) return res.status(200).send([]);

          // Prendo i tags dell'istanza generica...
          db.query("SELECT ID, DESCRIPTION as Name FROM m_device_tags WHERE ID_INSTANCE = ?", [result[0].ID], (qerr, result) => {

            if (qerr || result.length === 0) return res.status(200).send([]);

            return res.status(200).send(result);

          })


        });
        break;


      default:
        return res.status(200).send([]);

    }

  });


  app.post('/api/post/elementlist/management/:action', (req, res) => {

    const theater_index = Number(req.body.theater_index);
    const action = req.params.action;

    if (action === 'add') {

      const id_db = Number(req.body.id_db);
      const position = Number(req.body.position);
      const library_index = Number(req.body.library_index);
      const theater_id = Number(req.body.theater_id);

      switch (library_index) {

        case 0:
          return db.query("SELECT * FROM m_dcp WHERE ID=?", [id_db], (qerr, dcp) => {

            if (qerr || dcp.length === 0) return res.status(500).send({ status: 0, message: 'No operation was executed1' });
            return db.query("SELECT b.address, b.manager_address FROM m_theaters a LEFT JOIN m_imb c ON c.id = a.id_imb LEFT JOIN m_datastores b ON b.id = c.id_datastore WHERE a.id = ?", [theater_id], (qerr, result) => {

              if (qerr || result.length === 0) return res.status(500).send({ status: 0, message: 'No operation was executed2' });

              // Creo il path per la CPL, se props è vuoto, uso Filename, altrimenti prendo Props.
              //const cpl_path = "nfs://" + path.join(result[0].address, 'datastore', dcp[0].Props === '' ? dcp[0].Filename : dcp[0].Props);
              const cpl_path = path.join(dcp[0].Props === '' ? dcp[0].Filename : dcp[0].Props);


              //urn:uuid:c02e5d7c-9421-4a04-a361-d02ce7cb50e9
              const xml_cpl = "<Clip>" +
                "<Type>CPL</Type>" +
                "<Id>" + dcp[0].Fileaudio.substring(9, dcp[0].Fileaudio.length) + "</Id>" +
                "<Title>" + dcp[0].Title + "</Title>" +
                "<DurationInMilliseconds>" + dcp[0].Duration + "</DurationInMilliseconds>" +
                "<FPS>" + dcp[0].VideoFPS + "</FPS>" +
                "<Url>" + cpl_path.replace(/\\/g, "/") + "</Url>" +
                "<UrlReference>" + result[0].manager_address + "</UrlReference>" +
                "</Clip>";

              // DEBUG COMANDO DI LOAD CPL
              //console.log('TIMELINE-INSERT\n' + position + '\n' + xml_cpl.toString())
              try {
                clientWebSockets[theater_index].send('TIMELINE-INSERT\n' + position + '\n' + xml_cpl.toString());
              } catch (er) {

              }
              return res.status(200).send({ status: 1 });

            });


          });

        case 1: // Load SPL
          return convertPlaylistToSPL(id_db, theater_id, true).then(spl_xml => {

            //console.log('TIMELINE-INSERT\n' + position + '\n' + spl_xml.toString());

            clientWebSockets[theater_index].send('TIMELINE-INSERT\n' + position + '\n' + spl_xml.toString());
            return res.status(200).send({ status: 1 });

          })
        /*return db.query("SELECT source FROM m_spl WHERE id = ?" , [id_db] , (qerr ,result) => {
   
          if(qerr || result.length === 0) return res.status(500).send({ status : 0 , message : 'No operation was executed' });
          const spl_xml = fs.readFileSync(result[0].source, 'utf8');
          try{
          clientWebSockets[theater_index].send( 'TIMELINE-INSERT\n' + position + '\n' + spl_xml.toString() );
          } catch(er){
          }
          return res.status(200).send({status : 1});
   
        });*/

        default:
          return res.status(200).send({ status: 0, message: 'No operation was executed' });


      }

    }

    if (action === 'remove') {

      const timeline_uuid = req.body.timeline_uuid;
      clientWebSockets[theater_index].send('TIMELINE-REMOVE\n' + timeline_uuid.toString());
      return res.status(200).send({ status: 1 });

    }

    if (action === 'move') {

      const timeline_uuid = req.body.timeline_uuid;
      const position = Number(req.body.position);
      const library_index = Number(req.body.library_index);

      console.log('TIMELINE-MOVE\n' + timeline_uuid.toString() + '\n' + position + '\n')

      clientWebSockets[theater_index].send('TIMELINE-MOVE\n' + timeline_uuid.toString() + '\n' + position + '\n');
      return res.status(200).send({ status: 1 });

    }

    // Nessuna operazione è stata eseguita perchè sconosciuta.
    return res.status(500).send({ status: 0, message: 'Undefined Operation' });

  });



  app.get('/api/get/cpltools/:type', (req, res) => {

    return new Promise((resolve, reject) => {

      switch (req.params.type) {

        case 'groups':
          return db.query("SELECT Groupname FROM m_dcp WHERE Groupname<>'' GROUP BY Groupname", (qerr, result) => {

            let array_to_return = [{ value: 'ALL', label: 'All Groups' }];
            if (qerr) { return resolve(array_to_return); }
            result.forEach((item, i) => {
              array_to_return.push({ value: item.Groupname, label: item.Groupname });
            });
            return resolve(array_to_return);

          });

        case 'category':
          return db.query("SELECT Category FROM m_dcp WHERE Category<>'' GROUP BY Category", (qerr, result) => {

            let array_to_return = [{ value: 'ALL', label: 'All Categories' }];
            if (qerr) { return resolve(array_to_return); }
            result.forEach((item, i) => {
              array_to_return.push({ value: item.Category, label: item.Category });
            });
            return resolve(array_to_return);

          });

        case 'ingesttheaters':
          return db.query("SELECT id, name FROM m_theaters WHERE name<>''", (qerr, result) => {

            let array_to_return = [{ value: 'ALL', label: 'Ingest Filter disabled' }];
            if (qerr) { return resolve(array_to_return); }
            result.forEach((item, i) => {
              array_to_return.push({ value: item.id, label: 'Ingested in ' + item.name });
            });
            return resolve(array_to_return);

          });

        default:
          return resolve([]);

      }

    }).then(cb => {

      return res.status(200).send(cb);

    }).catch(err => {

      return res.status(200).send([]);

    });


  });

  function fillTimelineWithInfos(timeline) {

    return new Promise((resolve, reject) => {

      var timeline_filled = { items: [] };
      async.forEachOf(timeline.items, (item_timeline, index, callback) => {

        if (item_timeline['element-type'] === 'cpl') {

          db.query("SELECT Title, Year, Category, Duration FROM m_dcp WHERE Fileaudio like concat('urn:uuid:' , ? ) LIMIT 1", [item_timeline.cpl.id], (qerr, result) => {

            if (qerr || result.length === 0) { timeline_filled.items[index] = item_timeline; return callback(); }
            item_timeline.titleFromApi = result[0].Title;
            item_timeline.categoryFromApi = result[0].Category;
            item_timeline.yearFromApi = result[0].Year;
            item_timeline.durationFromApi = result[0].Duration;
            timeline_filled.items[index] = item_timeline;
            return callback();

          });

        } else {

          timeline_filled.items[index] = item_timeline;
          return callback();

        }

      }, (callback) => {

        if (timeline_filled.items.length === 0)
          return resolve(timeline)
        else
          return resolve(timeline_filled)

      })

    });

  }


  function fillStatusWithInfos(status) {

    return new Promise((resolve, reject) => {

      if (typeof status.content === 'undefined')
        return resolve(status);

      if (typeof status.content.contentType === 'undefined')
        return resolve(status);

      if (status.content.contentType.toLowerCase() !== 'cpl')
        return resolve(status);

      return db.query("SELECT Title FROM m_dcp WHERE Fileaudio like concat('urn:uuid:' , ?) limit 1", [status.content.CPL.uuid], (qerr, result) => {

        if (qerr || result.length === 0) { return resolve(status) }
        status.content.CPL.titleFromApi = result[0].Title;
        return resolve(status);

      });

    });

  }

  app.get('/api/get/image/:uuid', (req, res) => {

    const uuid = req.params.uuid;
    db.query("SELECT Image FROM m_dcp WHERE Fileaudio LIKE CONCAT('urn:uuid:' , ?)", [uuid.toString()], (qerr, result) => {

      if (qerr || result.length === 0) return res.status(200).send("");

      let reparse = result[0].Image;

      // Rimappo la K
      if (result[0].Image.substring(0, 2).toLowerCase() === 'k:') {
        reparse = "/datastore/K/" + result[0].Image.substring(2, result[0].Image.length).replace(/\\/g, "/");
      }

      if (!fs.existsSync(reparse))
        return res.status(200).send("");

      const file_image = "data:image/jpeg;base64," + base64_encode(reparse);
      return res.status(200).send(file_image);

    })

  });


  // Lista playlist\show
  app.get("/api/get/list/:list_type", (req, res) => {

    const list_type = req.params.list_type;
    switch (list_type) {

      case 'playlist':
        return db.query("SELECT a.* , (SELECT COUNT(b.ID) FROM m_manual_playlist_detail b WHERE b.ID_Parent = a.ID) as count_num FROM m_manual_playlist a ORDER BY a.Description", (qerr, result) => {

          if (qerr) return res.status(200).send([])
          return res.status(200).send(result);

        });

      case 'show':
        return db.query("SELECT a.*, a.Name as Description , (SELECT COUNT(b.ID) FROM m_clock_element b WHERE b.ID_Clock = a.ID) as count_num FROM m_clock_list a WHERE Duration>0 ORDER BY a.Name", (qerr, result) => {

          if (qerr) return res.status(200).send([]);
          var callback_count = 0;

          // devo trovare il begintime dell'elemento più lungo (il film vero e proprio e la sua durata...)
          async.forEachOf(result, (item, i, callback) => {

            return new Promise((resolve, reject) => {

              db.query("SELECT RunTime, Title, MarkOut, Table_Element, ID_Element FROM m_clock_element WHERE ID_Clock = ? AND MarkOut = (SELECT MAX(MarkOut) FROM m_clock_element WHERE ID_Clock = ?)", [item.ID, item.ID], (qerr, result_clock) => {

                if (result_clock.length === 0 || qerr) return resolve();

                // è una cpl nello show... fine
                if (result_clock[0].Table_Element === 'm_dcp') {

                  result[i].realShowInfo = { start_at: result_clock[0].RunTime, duration: result_clock[0].MarkOut, title: result_clock[0].Title }
                  return resolve();

                }

                if (result_clock[0].Table_Element === 'm_manual_playlist') {

                  // è in una playlist, classic gameplay, la cerco.
                  db.query("SELECT RunTime, Title, MarkOut, Table_Element, ID_Element FROM m_manual_playlist_detail WHERE ID_Parent = ? AND MarkOut = (SELECT MAX(MarkOut) FROM m_manual_playlist_detail WHERE ID_Parent = ?)", [result_clock[0].ID_Element, result_clock[0].ID_Element], (qerr, result_playlist) => {

                    result[i].realShowInfo = { start_at: result_playlist[0].RunTime, duration: result_playlist[0].Duration, title: result_playlist[0].Title };
                    return resolve();

                  })


                }

              });

            }).then(res_ => {

              callback_count++;

              if (callback_count === result.length)
                return callback(result);

            }).catch(err_ => {


            });

          }, (callback) => {

            return res.status(200).send(result);

          });

        });


      default:
        return res.status(200).send([]);

    }

  });


  app.get('/api/get/:type/:id_parent/details', (req, res) => {

    const type = req.params.type;
    const id_parent = req.params.id_parent;

    switch (type) {

      case 'playlist':
        return db.query("SELECT a.* , b.Groupname FROM m_manual_playlist_detail a LEFT JOIN  m_dcp b ON b.ID = IF(a.Table_Element ='m_dcp' , a.ID_Element , null)  WHERE a.ID_Parent = ? ORDER BY a.Position", [id_parent], (qerr, result) => {

          if (qerr) return res.status(200).send([]);
          return res.status(200).send(result);

        });

      case 'show':
        return db.query("SELECT a.* , b.Groupname FROM m_clock_element a LEFT JOIN m_dcp b ON b.ID = IF(a.Table_Element ='m_dcp' , a.ID_Element , null)  WHERE a.ID_Clock = ? ORDER BY a.Position", [id_parent], (qerr, result) => {

          if (qerr) return res.status(200).send([]);
          return res.status(200).send(result);

        });

      default:
        return res.status(200).send([]);

    }

  });

  app.post('/api/post/:save_or_create/:type/:id_parent', (req, res) => {

    const save_or_create = req.params.save_or_create;
    const type = req.params.type;
    const payload = req.body.payload;
    const title_edited = req.body.title_showspl;
    var id_parent = req.params.id_parent;

    switch (save_or_create) {

      case 'savechanges': // Caso edit salva, cancello i details attuali e riscrivo quelli nuovi editati in payload
        switch (type) {

          case 'playlist': // Playlist
            return db.query("DELETE FROM m_manual_playlist_detail WHERE ID_Parent = ?", [id_parent], (qerr, result) => {

              if (qerr) { return res.status(500).send({ status: 0, error: 'Error removing m_manual_playlist_detail' }); }
              // cancellati

              var runtime = [0];
              var runtime_total = 0;

              payload.forEach((item, i) => {

                if (i > 0)
                  runtime[i] = runtime_total;

                runtime_total = runtime_total + item.MarkOut;

              });

              return async.forEachOf(payload, (item, index, callback) => {

                // riscrivo le rows
                return db.query("INSERT INTO m_manual_playlist_detail (Title, ID_Parent, Table_Element, ID_Element, Position, MarkOut, IntermissionType, IntermissionStartAt, RunTime) VALUES " +
                  "(? ,? ,? , ? , ? , ?, ? , ? , ? )",
                  [item.Title, id_parent, item.Table_Element, item.ID_Element, index, item.MarkOut, item.IntermissionStartAt > 0 ? 1 : 0, item.IntermissionStartAt, runtime[index]], (qerr, result) => {

                    console.log(id_parent)
                    return callback();

                  });

              }, (callback) => {

                // Aggiorno la duration della playlist nel db
                return db.query("UPDATE m_manual_playlist SET Duration = ? , Description = ? WHERE ID = ?", [runtime_total, title_edited, id_parent], (qerr, result) => {

                  return res.status(200).send({ status: 1 });

                });

              });



            });


          case 'show': // Playlist
            return db.query("DELETE FROM m_clock_element WHERE ID_Clock = ?", [id_parent], (qerr, result) => {

              if (qerr) { return res.status(500).send({ status: 0, error: 'Error removing m_clock_element' }); }
              // cancellati

              var runtime = [0];
              var runtime_total = 0;

              payload.forEach((item, i) => {

                if (i > 0)
                  runtime[i] = runtime_total;

                runtime_total = runtime_total + item.MarkOut;

              });

              return async.forEachOf(payload, (item, index, callback) => {

                // riscrivo le rows
                return db.query("INSERT INTO m_clock_element (Title, Duration, MarkOut, RunTime, ID_Clock, ID_Element, Position, Table_Element, IntermissionStartAt, IntermissionType) VALUES " +
                  "(? ,? ,? , ? , ? , ?, ? , ? , ? , ? )",
                  [item.Title, item.MarkOut, item.MarkOut, runtime[index], id_parent, item.ID_Element, index, item.Table_Element, item.IntermissionStartAt, item.IntermissionStartAt > 0 ? 1 : 0], (qerr, result) => {

                    console.log(id_parent)
                    return callback();

                  });

              }, (callback) => {

                // Aggiorno la duration della playlist nel db
                return db.query("UPDATE m_clock_list SET Duration = ? , Name = ? WHERE ID = ?", [runtime_total, title_edited, id_parent], (qerr, result) => {

                  return res.status(200).send({ status: 1 });

                });

              });



            });


        } break; // fine switch type savechanges




      case 'create':
        switch (type) {

          case 'playlist':
            return db.query("INSERT INTO m_manual_playlist ( Description, Duration, CreationDate ) VALUES (?,?, NOW())",
              [title_edited, 0], (qerr, result) => {



                var runtime = [0];
                var runtime_total = 0;

                payload.forEach((item, i) => {

                  if (i > 0)
                    runtime[i] = runtime_total;

                  runtime_total = runtime_total + item.MarkOut;

                });

                id_parent = result.insertId;

                return async.forEachOf(payload, (item, index, callback) => {


                  // riscrivo le rows
                  return db.query("INSERT INTO m_manual_playlist_detail (Title, ID_Parent, Table_Element, ID_Element, Position, MarkOut, IntermissionType, IntermissionStartAt, RunTime) VALUES " +
                    "(? ,? ,? , ? , ? , ?, ? , ? , ? )",
                    [item.Title, id_parent, item.Table_Element, item.ID_Element, index, item.MarkOut, item.IntermissionStartAt > 0 ? 1 : 0, item.IntermissionStartAt, runtime[index]], (qerr, result) => {

                      return callback();

                    });

                }, (callback) => {

                  // Aggiorno la duration della playlist nel db
                  return db.query("UPDATE m_manual_playlist SET Duration = ? WHERE ID = ?", [runtime_total, id_parent], (qerr, result) => {

                    console.log(qerr);
                    return res.status(200).send({ status: 1 });

                  })

                });

              });


          case 'show':
            return db.query("INSERT INTO m_clock_list ( Name, Duration, CreationDate ) VALUES (?,?, NOW())",
              [title_edited, 0], (qerr, result) => {

                var runtime = [0];
                var runtime_total = 0;

                payload.forEach((item, i) => {

                  if (i > 0)
                    runtime[i] = runtime_total;

                  runtime_total = runtime_total + item.MarkOut;

                });

                id_parent = result.insertId;

                return async.forEachOf(payload, (item, index, callback) => {


                  // riscrivo le rows
                  return db.query("INSERT INTO m_clock_element (Title, Duration, MarkOut, RunTime, ID_Clock, ID_Element, Position, Table_Element, IntermissionStartAt, IntermissionType) VALUES " +
                    "(? ,? ,? , ? , ? , ?, ? , ? , ? , ? )",
                    [item.Title, item.MarkOut, item.MarkOut, runtime[index], id_parent, item.ID_Element, index, item.Table_Element, item.IntermissionStartAt, item.IntermissionStartAt > 0 ? 1 : 0], (qerr, result) => {

                      return callback();

                    });

                }, (callback) => {

                  // Aggiorno la duration della playlist nel db
                  return db.query("UPDATE m_clock_list SET Duration = ? WHERE ID = ?", [runtime_total, id_parent], (qerr, result) => {

                    return res.status(200).send({ status: 1 });

                  })

                });

              });


        } break; // fine switch type create



    }

  });


  app.get('/api/test/spl/:id_spl', (req, res) => {

    const id_playlist = Number(req.params.id_spl);
    const theater_id = 36;

    convertPlaylistToSPL(id_playlist, theater_id, true).then(ress => {


      return res.status(500).send(ress);

    }).catch(error => {

      console.log(error);
      return res.status(500).send(error);

    })

  });


  // FUNZIONE DI CONVERSIONE PLAYLIST -> SPL VERA PER PLAY / SCHEDULE / TEST
  function convertPlaylistToSPL(id_playlist, theater_id, return_xml) {

    return new Promise((resolve, reject) => {

      var spl_json = {};
      const uuid_spl = uuidv4().toString();

      // Prendo l'address del datastore così so a quale datastore stiamo facendo riferimento per generare questa SPL x questo Teatro.
      return db.query("SELECT b.address, b.manager_address FROM m_theaters a LEFT JOIN m_imb c ON c.id = a.id_imb LEFT JOIN m_datastores b ON b.id = c.id_datastore WHERE a.id = ?", [theater_id], (qerr, result_datastore) => {

        if (qerr || result_datastore.length === 0) return reject({ error: 'Theater id ' + theater_id + ' does not have a valid datastore.' });

        return db.query("SELECT a.* , b.Fileaudio, b.Duration, b.Filename, b.Props, b.VideoFPS FROM m_manual_playlist_detail a LEFT JOIN m_dcp b ON b.ID = IF(a.Table_Element ='m_dcp' , a.ID_Element , null) WHERE a.ID_Parent = ? ORDER BY a.Position", [id_playlist], (qerr, result) => {

          // Prendo le info riguardo la playlist
          return db.query("SELECT * FROM m_manual_playlist WHERE ID = ?", [id_playlist], (qerr, result_info) => {

            if (qerr || result_info.length === 0) return reject({ error: 'SPL id ' + id_playlist + ' could not be found in the database, therefore, SPL generation failed.' });  // Rejecto se non esiste il record per le info sulla playlist

            // Se la query da errore oppure la playlist è vuota rejecto e do errore.
            if (qerr || result.length === 0) {

              return reject({ error: 'SPL id ' + id_playlist + ' is empty and cannot be scheduled, please, verify its content.' });

            }

            // INTESTAZIONE JSON
            spl_json = {

              ShowPlaylist: {

                Id: uuid_spl,
                ContentTitleText: result_info[0].Description,
                AnnotationText: result_info[0].Description,
                Issuer: 'BitOnLive Content Management',
                IssueDate: new Date(),
                Creator: 'StreamerV2 API v.' + streamerVersionAPI,

                ClipList: { Clip: [] }

              }

            }



            var automationList_add_to_CUE = [];
            //var index_clips = 0; // Indice del ramo clips del json
            var is_cpl_in_exam = false; // Quando abbiamo una CPL con value 0 di intermission, sappiamo cosa stiamo esaminando e di conseguenza, se true, scarico tutta la cue list
            // + verifico le intermission sotto di essa.


            // NOTA: Con questo metodo di generazione, non verrà generato assolutamente nulla nel caso abbiamo una Playlist contentente SOLO automazioni perchè non verranno
            // MAI scaricate in una CueList di una CPL. Quindi, ricordarsi di considerare cosa fare in quel remoto caso.

            // Passo gli elementi della playlist
            result.forEach((item, index) => {

              var item = result[index];

              // Verifico se item sia una CPL o una Automazione.
              if ((item.Table_Element === 'm_automation' || item.Table_Element === 'm_device_tags') && item.IntermissionStartAt === 0) {

                automationList_add_to_CUE.push(item);  // Se siamo nel caso AUTOMAZIONE e nessuna CPL in esame, la aggiungo alla lista da scaricare appena possibile.
                return;

                // Abbiamo la CPL in esame.
              } else if (item.Table_Element === 'm_dcp' && item.IntermissionStartAt === 0) {

                //a1048030-9540-5e5b-aae6-8bae1074f6b6
                is_cpl_in_exam = true;

                // Se è null non esiste il record della DCP, non posso schedulare...
                if (item.Props === null) {

                  return reject({ error: 'CPL "' + item.Title + '" could not be found in m_dcp, SPL "' + result_info[0].Description + '" failed on creation.' });

                }


                // Creo Clip
                //let cpl_path = "nfs://" + path.join(result_datastore[0].address.toString(), 'datastore', item.Props === '' ? item.Filename.toString() : item.Props.toString());
                let cpl_path = path.join(item.Props === '' ? item.Filename.toString() : item.Props.toString());
                spl_json.ShowPlaylist.ClipList.Clip.push({
                  Type: 'CPL',
                  Id: item.Fileaudio.indexOf("urn:uuid:") >= 0 ? item.Fileaudio.substring(9, item.Fileaudio.length) : item.Fileaudio,
                  Title: item.Title,
                  DurationInMilliseconds: item.Duration,
                  FPS: item.VideoFPS,
                  DurationInFrames: parseInt(Number(item.Duration * item.VideoFPS) / 1000),
                  Url: cpl_path.replace(/\\/g, "/"),
                  UrlReference: result_datastore[0].manager_address.toString(),
                  ContentKind: ''
                });

                var index_clips = (spl_json.ShowPlaylist.ClipList.Clip.length - 1);

                // Verifico se ho delle automazioni da scaricare in que
                if (automationList_add_to_CUE.length > 0) {

                  automationList_add_to_CUE.forEach((cue, key_cue) => {
                    if (cue.Position <= item.Position && typeof cue.alreadyAdded === 'undefined') {

                      if (typeof spl_json.ShowPlaylist.ClipList.Clip[index_clips].CueList === 'undefined')
                        spl_json.ShowPlaylist.ClipList.Clip[index_clips].CueList = { Cue: [] };

                      automationList_add_to_CUE[key_cue].alreadyAdded = true;
                      spl_json.ShowPlaylist.ClipList.Clip[index_clips].CueList.Cue.push({ Name: cue.Title, OffsetInMilliseconds: 0, Icon: '' }); // Pusho le automazioni da scaricare
                      //automationList_add_to_CUE.splice(key_cue, 1);
                    }
                  });

                }

                // ULTIMO ELEMENTO, NON AVRà INTERMISSIONS
                if (typeof result[index + 1] === 'undefined') {
                  return;
                }

                // ORA, abbiamo messo le Automazioni precedenti a vuoto della playlist in cue, ora controlliamo se ha elementi in Intermission e soprattutto quanti sono.
                // Se il prossimo elemento NON ha intemrission, allora siamo good così. Scrivo la cuelist vuota e callbacko solo se non ha automazioni in cue already...
                if (result[index + 1].IntermissionStartAt === 0) {

                  is_cpl_in_exam = false; // RESETTO LA CPL IN ESAME, NON SO COSA CI SIA DOPO MA NON C'è NESSUNA INTERMISSION QUINDI TUTTO APOSTO

                } else {

                  // CERCO INTERMISSION CERCO INTERMISSION CERCO INTERMISSION
                  // cerchiamo le intermission
                  var spl_json_2 = spl_json;

                  let is_it_over = false;
                  result.forEach((item, x) => {

                    if (x > index && !is_it_over) { // Mi metto in pari alla lista da dove mi trovo

                      if (result[x].IntermissionStartAt === 0) { // SE LA CLIP IN ESAME NON HA PIù INTERMISSION, ALLORA SKIPPO
                        is_it_over = true;
                        return;
                      }

                      if (result[x].Table_Element === 'm_automation' || result[x].Table_Element === 'm_device_tags') {

                        if (typeof spl_json.ShowPlaylist.ClipList.Clip[index_clips].CueList === 'undefined') {
                          spl_json_2.ShowPlaylist.ClipList.Clip[index_clips].CueList = { Cue: [] };
                        }

                        // Appendo le Automazioni
                        spl_json_2.ShowPlaylist.ClipList.Clip[index_clips].CueList.Cue.push({ Name: result[x].Title, OffsetInMilliseconds: result[x].IntermissionStartAt, Icon: '' }); // Pusho le automazioni da scaricare

                      }


                      if (result[x].Table_Element === 'm_dcp') {

                        // SE NON ESISTE IL BRANCH DELL'INTERMISSION LIST, LO CREO.
                        if (typeof spl_json_2.ShowPlaylist.ClipList.Clip[index_clips].IntermissionList === 'undefined') {
                          spl_json_2.ShowPlaylist.ClipList.Clip[index_clips].IntermissionList = {
                            $: {
                              "MillisecondsOffset": result[x].IntermissionStartAt, // Da convertire in namespace del tag (già fatto. è già un attributo namespace del tag)
                            },
                            Clip: [],
                          }
                        }

                        if (result[x].Props === null) {

                          return reject({ error: 'CPL "' + result[x].Title + '" could not be found in m_dcp, SPL "' + result_info[0].Description + '" failed on generation.' });

                        }

                        // AGGIUNGO LA CLIP \ LE CLIP IN INTERMISSION.
                        //let cpl_path = "nfs://" + path.join(result_datastore[0].address, 'datastore', result[x].Props === '' ? result[x].Filename : result[x].Props);
                        let cpl_path = path.join(result[x].Props === '' ? result[x].Filename : result[x].Props);


                        spl_json.ShowPlaylist.ClipList.Clip[index_clips].IntermissionList.Clip.push({
                          Type: 'CPL',
                          Id: result[x].Fileaudio.indexOf("urn:uuid:") >= 0 ? result[x].Fileaudio.substring(9, result[x].Fileaudio.length) : result[x].Fileaudio,
                          Title: result[x].Title,
                          DurationInMilliseconds: result[x].Duration,
                          FPS: result[x].VideoFPS,
                          DurationInFrames: parseInt(Number(result[x].Duration * result[x].VideoFPS) / 1000),
                          Url: cpl_path.replace(/\\/g, "/"),
                          UrlReference: result_datastore[0].manager_address,
                          ContentKind: ''
                        });

                      }

                    }

                  });

                }

              } else {



              }

            });



            // ORA, CONTROLLO SE ABBIAMO DIMENTICATO LE AUTOMAZIONI IN FONDO, SE SI, LE APPLICO TUTTE ALL'ULTIMA CPL CHE ABBIAMO
            if (automationList_add_to_CUE.length > 0) {

              // Cerco l'ultima CPL
              for (i = spl_json.ShowPlaylist.ClipList.Clip.length; i >= 0; i--) {

                let item = spl_json.ShowPlaylist.ClipList.Clip[i];

                if (typeof item !== 'undefined') {

                  automationList_add_to_CUE.forEach((cue, key_cue) => {

                    if (typeof cue.alreadyAdded === 'undefined') {

                      if (typeof spl_json.ShowPlaylist.ClipList.Clip[i].CueList === 'undefined')
                        spl_json.ShowPlaylist.ClipList.Clip[i].CueList = { Cue: [] };

                      // LE APPENDO TUTTE ALLE FINE DELLA CPL
                      automationList_add_to_CUE[key_cue].alreadyAdded = true;
                      spl_json.ShowPlaylist.ClipList.Clip[i].CueList.Cue.push({ Name: cue.Title, OffsetInMilliseconds: item.DurationInMilliseconds - 1, Icon: '' }); // Pusho le automazioni da scaricare

                    }
                  });


                  break;

                }

              }

            }



            // Converto in XML e ritorno l'xml
            if (return_xml) {
              var builder = new xml2js.Builder();
              var xml = builder.buildObject(spl_json);
              return resolve(xml);
            } else {
              return resolve(spl_json); // Ritorno json se non è richiesto l'XML (serve per gli show)
            }

          });

        });

      });

    });

  }


  function generateClipCPL_SPL(id_element, result_datastore, spl_json, is_intermission = false, index_clips = 0) {

    return false;

    // NON VIENE MAI USATA.... DA CANCELLARE!

    return new Promise((resolve, reject) => {

      db.query("SELECT * FROM m_dcp WHERE ID = ?", [id_element], (qerr_, dcp_data) => {

        //let cpl_path = "nfs://" + path.join(result_datastore[0].address, 'datastore', dcp_data[0].Props === '' ? dcp_data[0].Filename : dcp_data[0].Props);
        let cpl_path = path.join(dcp_data[0].Props === '' ? dcp_data[0].Filename : dcp_data[0].Props);

        if (!is_intermission) {

          spl_json.ShowPlaylist.ClipList.Clip.push({

            Type: 'CPL',
            Id: dcp_data[0].Fileaudio.indexOf("urn:uuid:") >= 0 ? dcp_data[0].Fileaudio.substring(9, dcp_data[0].Fileaudio.length) : dcp_data[0].Fileaudio,
            ContentTitleText: dcp_data[0].Title,
            Title: dcp_data[0].Title,
            DurationInMilliseconds: dcp_data[0].Duration,
            FPS: dcp_data[0].VideoFPS,
            DurationInFrames: parseInt(Number(dcp_data[0].Duration * dcp_data[0].VideoFPS) / 1000),
            Url: cpl_path.replace(/\\/g, "/"),
            UrlReference: result_datastore[0].manager_address,
            ContentKind: ''

          });

          return resolve(spl_json)

        } else {

          spl_json.ShowPlaylist.ClipList.Clip[index_clips].IntermissionList.Clip.push({

            Type: 'CPL',
            Id: dcp_data[0].Fileaudio.indexOf("urn:uuid:") >= 0 ? dcp_data[0].Fileaudio.substring(9, dcp_data[0].Fileaudio.length) : dcp_data[0].Fileaudio,
            ContentTitleText: dcp_data[0].Title,
            Title: dcp_data[0].Title,
            DurationInMilliseconds: dcp_data[0].Duration,
            FPS: dcp_data[0].VideoFPS,
            DurationInFrames: parseInt(Number(dcp_data[0].Duration * dcp_data[0].VideoFPS) / 1000),
            Url: cpl_path.replace(/\\/g, "/"),
            ContentKind: ''

          });

          return resolve(spl_json)


        }
      });
    });
  }

  app.post('/api/post/remove/db/content/:type', (req, res) => {

    const type = req.params.type;
    const payload = req.body.payload;

    switch (type) {

      case 'playlist':
        return async.forEachOf(payload, (item, index, callback) => {

          db.query("DELETE FROM m_manual_playlist_detail WHERE ID_Parent = ?", [item], (qerr, result) => {

            if (qerr) { return res.status(500).send({ status: 0 }) }

            db.query("DELETE FROM m_manual_playlist WHERE ID = ?", [item], (qerr, result) => {

              console.log(qerr);
              if (qerr) { return res.status(500).send({ status: 0 }) }
              return callback();

            });

          });

        }, (callback) => {

          return res.status(200).send({ status: 1 });

        });

      case 'show':
        return async.forEachOf(payload, (item, index, callback) => {

          db.query("DELETE FROM m_clock_element WHERE ID_Clock = ?", [item], (qerr, result) => {

            if (qerr) { return res.status(500).send({ status: 0 }) }

            db.query("DELETE FROM m_clock_list WHERE ID = ?", [item], (qerr, result) => {

              if (qerr) { return res.status(500).send({ status: 0 }) }
              return callback();

            });

          });

        }, (callback) => {

          return res.status(200).send({ status: 1 });

        });





    }
  });

  app.post('/api/post/contentduplicate/:type', (req, res) => {

    const type = req.params.type;
    const payload = req.body.payload;

    switch (type) {

      case 'playlist':
        return async.forEachOf(payload, (item, index, callback) => {

          db.query("SELECT Description FROM m_manual_playlist WHERE Description = (SELECT Description FROM m_manual_playlist WHERE ID = ?)", [item], (qerr, result) => {

            const name = result[0].Description;

            var promiseName = new Promise((resolve, reject) => {

              // cerco quelle con le parentesi.
              db.query("SELECT Count(ID) as C FROM m_manual_playlist WHERE Description LIKE CONCAT( (SELECT Description FROM m_manual_playlist WHERE ID = ?) , ' (%' ) ", [item], (qerr, result) => {

                let base_nr = 2 + Number(result[0].C);
                resolve(name + " (" + base_nr + ")");

              });


            }).then(name => {

              // Duplico l'spl'
              db.query("INSERT INTO m_manual_playlist (Channel, Description, Duration, CreationDate) SELECT Channel, ?, Duration, NOW() FROM m_manual_playlist WHERE ID = ?", [name, item], (qerr, result) => {

                if (qerr) { /*db.release();*/ return res.status(500).send({ error: '/api/post/contentduplicate/:type -> query_1 error' }) }

                // Duplico i suoi elementi
                db.query("INSERT INTO m_manual_playlist_detail (Title, ID_Parent, Table_Element, ID_Element, Position, Duration, Adjustable, Chain, ModifiedByUser, MarkIn, MarkOut, RefrainIn, RefrainOut, ShortMarkIn, ShortMarkOut, Intro, Outtro, FadeInOffset, FadeOutOffset, MixIn, MixOut, Volume, Note, Category, ExecutionMode, IntermissionType, IntermissionStartAt, ShortMarkFadeInOffset, ShortMarkFadeOutOffset, ShortMarkMixIn, ShortMarkMixOut, RefrainFadeInOffset, RefrainFadeOutOffset, RefrainMixIn, RefrainMixOut, RunTime) " +
                  "SELECT Title, ?, Table_Element, ID_Element, Position, Duration, Adjustable, Chain, ModifiedByUser, MarkIn, MarkOut, RefrainIn, RefrainOut, ShortMarkIn, ShortMarkOut, Intro, Outtro, FadeInOffset, FadeOutOffset, MixIn, MixOut, Volume, Note, Category, ExecutionMode, IntermissionType, IntermissionStartAt, ShortMarkFadeInOffset, ShortMarkFadeOutOffset, ShortMarkMixIn, ShortMarkMixOut, RefrainFadeInOffset, RefrainFadeOutOffset, RefrainMixIn, RefrainMixOut, RunTime FROM m_manual_playlist_detail WHERE ID_Parent = ? ", [result.insertId, item], (qerr, result) => {

                    /*db.release();*/
                    if (qerr) { return res.status(500).send({ error: '/api/post/contentduplicate/:type -> query_2 error' }) }
                    return callback();

                  });

              });

            }).catch(err => {

              console.log(err);
              return res.status(500).send({ status: 0 })

            });

          });

        }, () => {

          return res.status(200).send({ status: 1 });

        });

      case 'show':
        return async.forEachOf(payload, (item, index, callback) => {

          db.query("SELECT Name FROM m_clock_list WHERE Name = (SELECT Name FROM m_clock_list WHERE ID = ?)", [item], (qerr, result) => {

            const name = result[0].Name;

            var promiseName = new Promise((resolve, reject) => {

              // cerco quelle con le parentesi.
              db.query("SELECT Count(ID) as C FROM m_clock_list WHERE Name LIKE CONCAT( (SELECT Name FROM m_clock_list WHERE ID = ?) , ' (%' ) ", [item], (qerr, result) => {

                let base_nr = 2 + Number(result[0].C);
                resolve(name + " (" + base_nr + ")");

              });


            }).then(name => {

              // Duplico l'spl'
              db.query("INSERT INTO m_clock_list (Channel, Name, Duration, Color, CreationDate) SELECT Channel, ?, Duration, Color, NOW() FROM m_clock_list WHERE ID = ?", [name, item], (qerr, result) => {

                if (qerr) { /*db.release();*/ return res.status(500).send({ error: '/api/post/contentduplicate/:type -> query_1 error' }) }

                // Duplico i suoi elementi
                db.query("INSERT INTO m_clock_element (Channel, Title, Category, Filename, Fileaudio, RadioFileaudio, Duration, MarkIn, MarkOut, Note, RunTime, ID_Clock, ID_Element, Position, Adjustable, Suspended, Chain, Table_Element, ID_EpisodeSchedule, Segment, BlockDays, BlockType, ModifiedByUser, RefrainIn, RefrainOut, ShortMarkIn, ShortMarkOut, Intro, Outtro, FadeInOffset, FadeOutOffset, MixIn, MixOut, Volume, ExecutionMode, ShortMarkFadeInOffset, ShortMarkFadeOutOffset, ShortMarkMixIn, ShortMarkMixOut, RefrainFadeInOffset, RefrainFadeOutOffset, RefrainMixIn, RefrainMixOut, IntermissionStartAt, IntermissionType) " +
                  "SELECT Channel, Title, Category, Filename, Fileaudio, RadioFileaudio, Duration, MarkIn, MarkOut, Note, RunTime, ? , ID_Element, Position, Adjustable, Suspended, Chain, Table_Element, ID_EpisodeSchedule, Segment, BlockDays, BlockType, ModifiedByUser, RefrainIn, RefrainOut, ShortMarkIn, ShortMarkOut, Intro, Outtro, FadeInOffset, FadeOutOffset, MixIn, MixOut, Volume, ExecutionMode, ShortMarkFadeInOffset, ShortMarkFadeOutOffset, ShortMarkMixIn, ShortMarkMixOut, RefrainFadeInOffset, RefrainFadeOutOffset, RefrainMixIn, RefrainMixOut, IntermissionStartAt, IntermissionType FROM m_clock_element WHERE ID_Clock = ? ", [result.insertId, item], (qerr, result) => {

                    /*db.release();*/
                    if (qerr) { return res.status(500).send({ error: '/api/post/contentduplicate/:type -> query_2 error' }) }
                    return callback();

                  });

              });

            }).catch(err => {

              console.log(err);
              return res.status(500).send({ status: 0 })

            });

          });

        }, () => {

          return res.status(200).send({ status: 1 });

        })


    }

  });

  app.post('/api/show/setcolor', (req, res) => {

    const payload = req.body.payload;
    const color = req.body.color;

    async.forEachOf(payload, (item, index, callback) => {

      return db.query("UPDATE m_clock_list SET Color = ? WHERE ID = ?", [color, item], (qerr, result) => {

        return callback();

      });

    }, () => {

      return res.status(200).send({ status: 1 });

    })

  });

  function removeScheduledShows(day_id) {

    // FUNZIONE CHE RIMUOVE SOLO GLI SHOW COMPRESI TRA DATA X ORE 06:00:00 E X+1 ORE 06:00:00 PERCHè SCHEDULIAMO SOLO QUELLI.
    return new Promise((resolve, reject) => {

      const date_ = new Date(day_id.toString().substring(0, 4) + "-" + day_id.toString().substring(4, 6) + "-" + day_id.toString().substring(6, 8));
      const date_tomorrow = new Date(day_id.toString().substring(0, 4) + "-" + day_id.toString().substring(4, 6) + "-" + day_id.toString().substring(6, 8));

      date_.setHours("06", "00", "00");;
      date_tomorrow.setHours("06", "00", "00");;
      date_tomorrow.setDate(date_.getDate() + 1);

      const today = dateCinePlayout(date_);
      const tomorrow = dateCinePlayout(date_tomorrow);

      schedule_list_theater.forEach((item, i) => {

        if (typeof item.items === 'undefined') return;

        // item è la lista degli show schedulati nel teatro x tutta la sua durata.
        item.items.forEach((show, i_show) => {

          if (show['start-at'] >= today && show['start-at'] <= tomorrow) {

            // Va rimosso.
            clientWebSockets[i].send('SCHEDULE-DELETE\n' + show.id);

          }

        });


      });

      return resolve(true);

    });

  }

  app.get('/api/verifyschedule/:id_day', (req, res) => {

    checkIntegritySchedule(req.params.id_day).then(ret => {

      return res.status(200).send(ret);

    }).catch(err => {

      return res.status(200).send(err);

    })

  })

  function checkIntegritySchedule(day_id) {

    return new Promise((resolve, reject) => {

      if (typeof db === 'undefined') return resolve();

      let error_list = [];

      // Cosa fa questa funzione?
      // 1: verifica che i contenuti per ogni teatro esistano sul datastore dell'IMB di riferimento e siano playabili per esso (es: che sia certificato per l'hula)
      // 2: verifica che, se encryptato e protetto da una KDM, vi sia una KDM valida nel sistema. Se non ci sono KDM valide per questo contenuto, va in errore, non potrà playare...
      // 3: verifica che, nessuno degli show abbia lo start sovrapposto ad un altro show, questo può succedere quando creata una programmazione si va a modificare lo show\spl aggiungendo roba

      db.query("SELECT a.* , b.Name FROM m_template_week a LEFT JOIN m_clock_list b on b.ID = a.ID_Clock WHERE ID_Template = ?", [day_id], (qerr, main) => {

        if (main.length === 0) {
          return resolve({ errors: [] }); // Schedule vuota...
        }

        let count_shows = 0;
        var cpl_status_array = [];

        async.forEachOf(main, (scheduled, index, callback_main) => {

          let elements_cpl = [];

          // Prendo i contenuti dello show.
          new Promise((resolve_show, reject_show) => {

            let error_list_temp = [];

            db.query("SELECT * FROM m_clock_list WHERE ID = ?", [scheduled.ID_Clock], (qerr, show_info) => {

              db.query("SELECT * FROM m_clock_element WHERE ID_Clock = ?", [scheduled.ID_Clock], (qerr, show_elements) => {

                if (qerr || show_elements.length === 0) {

                  error_list_temp.push({ error: 'Show ' + show_info[0].Name + ' is empty, therefore, it cannot be scheduled.', time: scheduled.BeginHour, theater: info_theater[0].theater_name });
                  return reject_show(error_list_temp);

                }

                let count_elements = 0;

                async.forEachOf(show_elements, (item, index_element, callback_show) => {

                  switch (item.Table_Element) {

                    case 'm_manual_playlist':

                      // Prendo i singoli elementi della SPL
                      db.query("SELECT * FROM m_manual_playlist_detail WHERE ID_Parent = ?", [item.ID_Element], (qerr, spl_content) => {

                        spl_content.forEach(cpl => {

                          if (cpl.Table_Element === 'm_dcp' && !elements_cpl.includes(cpl.ID_Element)) elements_cpl.push(cpl.ID_Element);

                        })

                        // Fine check spl
                        count_elements++;
                        if (count_elements >= show_elements.length) return callback_show(elements_cpl);

                      }); break;

                    case 'm_dcp':
                      if (!elements_cpl.includes(item.ID_Element))
                        elements_cpl.push(item.ID_Element);

                      count_elements++;
                      if (count_elements >= show_elements.length) return callback_show(elements_cpl);

                      break;

                    default:
                      count_elements++;
                      if (count_elements >= show_elements.length) return callback_show(elements_cpl);

                  }

                }, (callback_show_content) => {

                  return resolve_show(callback_show_content);

                });

              });

            });

          }).then(resovled_content => {

            let temp_errors = [];

            if (resovled_content.length === 0) {

              // Lo show non contiene alcuna CPL.. Non ho niente da controllare, posso solo avvisare?
              error_list.push({ error: 'Warning: Show ' + scheduled.Name + ' does not contain any CPL.', time: scheduled.BeginHour, theater: info_theater[0].theater_name });

              count_shows++;
              if (count_shows >= main.length) return callback_main({ errors: error_list, content: cpl_status_array });


            }

            let cpl_status_array_temp = [];

            // Abbiamo l'elenco degli ID di m_Dcp che compongono lo show scheduled.ID_Clock
            // Prendo le informazioni sul teatro
            db.query("SELECT a.*, a.name as theater_name, b.type, b.address, b.direct_streaming, b.certified, b.serial, c.name FROM m_theaters a LEFT JOIN m_imb b ON b.id = a.id_imb LEFT JOIN m_datastores c on c.id = b.id_datastore WHERE a.id = ?", [scheduled.Channel], (qerr, info_theater) => {

              let count_cpl = 0;

              async.forEachOf(resovled_content, (id_dcp, index_dcp, callback_dcp) => {

                db.query("SELECT Title, Fileaudio, ExecutionMode FROM m_dcp WHERE ID = ?", [id_dcp], (qerr, info_dcp) => {

                  if (qerr || info_dcp.length === 0) {

                    // NON ESISTE LA DCP
                    error_list.push({ error: 'ERROR: CPL id "' + id_dcp + '" from Show "' + scheduled.Name + '" scheduled on ' + info_theater[0].theater_name + ' at ' + basicHHMMSS(scheduled.BeginHour).substr(0, 5) + ' does not exist in Streamer Content anymore as record.', time: scheduled.BeginHour, theater: info_theater[0].theater_name });
                    count_cpl++;
                    if (count_cpl >= resovled_content.length) return callback_dcp(cpl_status_array_temp);

                    return;


                  }

                  // Verifichiamo che la CPL esista e sia verificata sul datastore 
                  db.query("SELECT a.* FROM m_streamercop_verify a WHERE a.uuid = ? AND datastore_name = ?", [info_dcp[0].Fileaudio, info_theater[0].name], (qerr, verify) => {

                    let temp_cpl_status = {

                      id: id_dcp,
                      title: info_dcp[0].Title,
                      requires_kdm: info_dcp[0].ExecutionMode === 1 ? true : false,
                      is_verified: false,
                      missing_kdm: true,
                      requires_certification: info_theater[0].type === 'HULA' ? true : false,
                      requires_transfer: info_theater[0].direct_streaming === 0 && info_theater[0].certified === 0 ? true : false,
                      is_certified: false,
                      is_transfered: false

                    }

                    if (qerr || verify.length === 0) {
                      // Non è verificata. 
                      error_list.push({ error: 'Warning: CPL "' + info_dcp[0].Title + '" from Show "' + scheduled.Name + '" scheduled on ' + info_theater[0].theater_name + ' at ' + basicHHMMSS(scheduled.BeginHour).substr(0, 5) + ' is not Verified for datastore ' + info_theater[0].name, time: scheduled.BeginHour, theater: info_theater[0].theater_name });

                    } else {

                      if (verify.length > 0)
                        if (verify[0].progress === 'VERIFIED') temp_cpl_status.is_verified = true;

                    }

                    // Se richiede le KDM, verifico che ci siano
                    new Promise((resolve_kdm, reject_kdm) => {

                      if (temp_cpl_status.requires_kdm) {

                        db.query("SELECT ID FROM kdm WHERE uuid = ? AND progress = 'COMPLETE' AND startdate < NOW() AND enddate > NOW()", [info_dcp[0].Fileaudio], (qerr, result_kdm) => {

                          if (qerr || result_kdm.length === 0) {
                            // Errore, contenuto protetto, imb sprovvisto di kdm valide, il contenuto non potrà essere playato!
                            error_list.push({ error: 'Warning: Encrypted CPL "' + info_dcp[0].Title + '" from Show "' + scheduled.Name + '" scheduled on ' + info_theater[0].theater_name + ' at ' + basicHHMMSS(scheduled.BeginHour).substr(0, 5) + ' does not have Valid KDM ingested for playback', time: scheduled.BeginHour, theater: info_theater[0].theater_name });
                            return resolve_kdm(false);
                          }

                          return resolve_kdm(true);

                        });

                      } else {

                        return resolve_kdm(true);

                      }

                    }).then(resolved_kdm_status => {

                      temp_cpl_status.missing_kdm = !resolved_kdm_status; // Metto la negazione perchè lo stato dice missing kdm quindi se ci sono deve essere false e viceversa.

                      // Verifico se fosse richiesta certificazione
                      new Promise((resolve_cert, reject_cert) => {

                        if (temp_cpl_status.requires_certification) {

                          const serial = info_theater[0].type + '_' + info_theater[0].name;

                          db.query("SELECT * FROM clips WHERE serial = ? AND uuid = ? AND progress like '%COMPLETE%'", [serial, info_dcp[0].Fileaudio], (qerr, certification_check) => {
                            if (qerr || certification_check.length === 0) {
                              // Errore, contenuto non certificato, non potrà playare su questa sala poichè hula non darà come valido
                              error_list.push({ error: 'Warning: CPL "' + info_dcp[0].Title + '" from Show "' + scheduled.Name + '" scheduled on ' + info_theater[0].theater_name + ' at ' + basicHHMMSS(scheduled.BeginHour).substr(0, 5) + ' is currently not Certified on ' + info_theater[0].name + ' for HULA playback', time: scheduled.BeginHour, theater: info_theater[0].theater_name });
                              return resolve_cert(false); // Non è certificato
                            }
                            return resolve_cert(true);
                          });
                        } else {
                          return resolve_cert(true);
                        }

                      }).then(resolved_cert => {

                        temp_cpl_status.is_certified = resolved_cert;

                        // Verifico se la CPL sia trasferita correttamente
                        new Promise((resolve_transfer, reject_transfer) => {

                          if (temp_cpl_status.requires_transfer) {
                            db.query("SELECT * FROM clips WHERE serial = ? and uuid = ? and progress like '%COMPLETE%'", [info_theater[0].serial, info_dcp[0].Fileaudio], (qerr, transfer_res) => {
                              if (qerr || transfer_res.length === 0) {
                                // Errore, contenuto non trasferito, non essendo direct streaming, non potrà playare.
                                error_list.push({ error: 'Warning: CPL "' + info_dcp[0].Title + '" from Show "' + scheduled.Name + '" scheduled on ' + info_theater[0].theater_name + ' at ' + basicHHMMSS(scheduled.BeginHour).substr(0, 5) + ' has not been transfered and it is currently not available on ' + info_theater[0].type + ' IMB @ ' + info_theater[0].address, time: scheduled.BeginHour, theater: info_theater[0].theater_name });
                                return resolve_transfer(false);
                              }
                              return resolve_transfer(true);
                            });
                          } else {
                            return resolve_transfer(true);
                          }

                        }).then(resolved_transfer => {

                          temp_cpl_status.is_transfered = resolved_transfer;
                          cpl_status_array.push(temp_cpl_status); // Pusho nell'array principale

                          count_cpl++;
                          if (count_cpl >= resovled_content.length) return callback_dcp(cpl_status_array_temp);

                        }).catch(err => {
                          // errore promise transfer
                        });

                      }).catch(err => {
                        // errore promise cert
                      });

                    }).catch(err => {
                      // errore promise kdm
                    });


                  });

                });

              }, (callbacked_dcp) => {

                //cpl_status_array.concat(callbacked_dcp);

                count_shows++;

                if (count_shows >= main.length) {

                  error_list = error_list.sort(propComparator('time')); // Ordino...
                  //console.log(error_list);

                  return resolve({ errors: error_list, content: cpl_status_array, day_id: day_id });
                }

              });

            });



          }).catch(error_content => {

            // ???
            error_list.concat(error_content);

          });


        }, (cb_error_list) => {

          return resolve(cb_error_list);

        })

      });

    });


  }

  // API per lo scheduling.
  app.post('/api/post/cineplayout/schedule/:day_id/submit', (req, res) => {

    const day_id = req.params.day_id;

    //SCHEDULE-DELETE.

    // Problema: Lo schedule permette di inserire gli show dalle 6 di mattina di giorno X fino alle 6 di mattina di X+1.
    // Cosa significa? Che non posso usare le API del giorno del cineplayout poichè non cancellerebbe gli show del giorno dopo e se dovessi
    // farlo per entrambi andrebbe a rimuovere la programmazione del giorno dopo interamente senza motivo....
    // Soluzione: Ho costantemente la schedule list di tutti i teatri in memoria grazie al websocket che comunica con il playout, quindi
    // Senza effettuare ulteriori richieste, so già quali siano gli show in programmazione per questa giornata ove giornata è inteso come la sua definizione descritta al primo commento...
    // Quindi, cerco quali show devo rimuovere e riprogrammo. fine.

    removeScheduledShows(day_id).then(res_removal => {

      // Prendo e converto gli show...
      db.query("SELECT a.* , b.Name FROM m_template_week a LEFT JOIN m_clock_list b on b.ID = a.ID_Clock WHERE ID_Template = ? GROUP BY ID_Clock", [day_id], (qerr, result) => {

        var cb_calc = 0;
        var shows_resolved = [];
        var errors_ = [];

        if (qerr) { }
        if (result.length === 0) { return res.status(200).send({ status: 1, errors: [] }) }

        // Devo passare tutti gli show nella funzione che mi ritorna l'xml così da poterlo mandare in schedule...
        async.forEachOf(result, (item, i, callback) => {

          return new Promise((resolve, reject) => {

            generateShowXML(item.ID_Clock, item.Channel, item.Name).then(res_ => {

              return resolve({ show: res_, id_clock: item.ID_Clock });

            }).catch(error => {

              //return res.status(500).send(error);
              console.log(error)
              return resolve({ error: error, in_error: true });

            })

          }).then(res_show => {

            if (typeof res_show.in_error === 'undefined')
              shows_resolved.push(res_show);
            else
              errors_.push(res_show.error);

            cb_calc++;

            if (cb_calc === result.length)
              return callback({ shows_resolved_cb: shows_resolved, errors_: errors_ });



          }).catch(err => {

            // Do sempre resolve, qua non ci entrerà mai.

          })

        }, (cb_response) => {

          // Prendo gli showsxml e gli errori causati dalla loro generazione (se esistono... altrimenti all good mate)
          const { shows_resolved_cb, errors_ } = cb_response;

          if (shows_resolved_cb === null) {
            return res.status(500).send({ status: 0, errors: [{ error: 'No shows were converted during the submit operation.' }] }); // Nessuno show è stato trovato, che sia vuota la programmazione?
          }

          if (shows_resolved_cb.length === 0 && errors_.length === 0) {

            return res.status(500).send({ status: 0, errors: [{ error: 'No shows were converted during the submit operation.' }] }); // Nessuno show è stato trovato, che sia vuota la programmazione?
          }

          if (errors_.length > 0) {

            console.log('xD');
            return res.status(500).send({ status: 0, errors: errors_ });

          }

          // ERRORI DI GENERAZIONE SHOW, SE SIAMO QUI, NON CI SONO!
          let errors_schedule = [];

          // Ora, rifaccio la query senza la group by
          db.query("SELECT a.* , b.Name as Title FROM m_template_week a LEFT JOIN m_clock_list b on b.ID = a.ID_Clock WHERE ID_Template = ?", [day_id], (qerr, result) => {

            if (qerr) return res.sendStatus(500);

            result.forEach((item, i) => {

              let id_theater_ws = -1;

              // Prendo l'index per i comandi ws
              for (let i_ = 0; i_ < playout_ws_ports.length; i_++) {

                if (playout_ws_ports[i_].theater_id === Number(item.Channel)) {

                  id_theater_ws = i_;
                  break;

                }

              }

              if (id_theater_ws < 0) return false; // Nessun teatro è stato trovato....

              let current_show_xml = "";

              // Cerco l'XML di questo id clock
              for (let x = 0; x < shows_resolved_cb.length; x++)
                if (Number(shows_resolved_cb[x].id_clock) === Number(item.ID_Clock)) {
                  current_show_xml = shows_resolved_cb[x].show;
                  break;
                }


              if (current_show_xml === '') return false; // Lo show è vuoto \ non esiste....

              const date_ = new Date(item.ID_Template.toString().substring(0, 4) + "-" + item.ID_Template.toString().substring(4, 6) + "-" + item.ID_Template.toString().substring(6, 8));
              let must_add_one_day = false;

              if (item.BeginHour >= 86400000) {
                // Aggiungo un giorno alla data, rimuovo questa cifra al tempo
                item.BeginHour = item.BeginHour - 86400000;
                must_add_one_day = true;
              }



              const ms_conversion = basicHHMMSS(item.BeginHour);
              date_.setHours(ms_conversion.substring(0, 2), ms_conversion.substring(3, 5), ms_conversion.substring(6, 8));

              if (must_add_one_day) date_.setDate(date_.getDate() + 1);
              console.log(dateCinePlayout(date_));

              // Invio solo se è aperto...
              if (clientWebSockets[id_theater_ws].readyState === WebSocket.OPEN)
                clientWebSockets[id_theater_ws].send('SCHEDULE-ADD\n' + dateCinePlayout(date_) + "\n" + current_show_xml);
              else
                errors_schedule.push({ error: "(" + playout_ws_ports[id_theater_ws].name + ") " + (date_.toLocaleTimeString()).substring(0, 5) + ': "' + item.Title + '" could not be scheduled, Cineplayout is not connected.' })



            });


            return res.status(200).send({ status: 1, errors: errors_schedule });


          });

        });



      });


    }).catch(err => {

      console.log(err);

      // errore nella rimozione...
      return res.sendStatus(500);

    });


  });


  // Funzione che genera l'XML di uno SHOW...
  function generateShowXML(id_clock, theater_id, show_name) {

    return new Promise((resolve, reject) => {

      // Prendo l'address del datastore così so a quale datastore stiamo facendo riferimento come per le SPL.
      return db.query("SELECT b.address, b.manager_address FROM m_theaters a LEFT JOIN m_imb c ON c.id = a.id_imb LEFT JOIN m_datastores b ON b.id = c.id_datastore WHERE a.id = ?", [theater_id], (qerr, result_datastore) => {

        if (qerr || result_datastore.length === 0) return reject();

        var show_json = { Show: [] };

        /*
        show_json.Show.push({$: {
          "name" : show_name, // Da convertire in namespace del tag (già fatto. è già un attributo namespace del tag)
        }, });*/

        var spl_resolved = [];

        return db.query("SELECT a.* , b.Fileaudio, b.Duration, b.Filename, b.Props, b.VideoFPS FROM m_clock_element a LEFT JOIN m_dcp b ON b.ID = IF(a.Table_Element ='m_dcp' , a.ID_Element , null) WHERE a.ID_Clock = ? ORDER BY a.Position", [id_clock], (qerr, result) => {

          var cb_returns = 0;

          async.forEachOf(result, (item, index, callback) => {

            new Promise((resolve2, reject2) => {

              if (item.Table_Element !== 'm_manual_playlist')
                return resolve2(false);

              return convertPlaylistToSPL(item.ID_Element, theater_id, false).then(spl_json => {

                return resolve2({ spl: spl_json, id_spl: item.ID_Element });

              }).catch(error_spl => {

                return reject(error_spl);

              });




            }).then(cb_promise => {

              if (cb_promise)
                spl_resolved.push(cb_promise);

              cb_returns++;

              if (result.length === cb_returns)
                return callback(spl_resolved);

            }).catch(cb_error => {


            });

          }, (spl_resolved_cb) => {

            let already_added_automations = [];

            //return resolve(show_json)
            result.forEach((item, i) => {

              //console.log(item.Title)

              switch (item.Table_Element) {

                case 'm_manual_playlist': // SPL
                  for (let x = 0; x < spl_resolved_cb.length; x++) {

                    let spl_item = spl_resolved_cb[x];
                    if (spl_item.id_spl === item.ID_Element) {
                      show_json.Show.push(spl_item.spl);
                      break;
                    }

                  }
                  return true;
                  break;


                case 'm_dcp': // CPL

                  if (item.Filename === null) return reject({ error: 'CPL ' + item.Title + ' could not be found in m_dcp, SHOW "' + show_name + '" failed on generation.' });

                  //let cpl_path = "nfs://" + path.join(result_datastore[0].address, 'datastore', item.Props === '' ? item.Filename : item.Props);
                  let cpl_path = path.join(item.Props === '' ? item.Filename : item.Props);

                  show_json.Show.push({
                    Clip: {
                      Type: 'CPL',
                      Id: item.Fileaudio.indexOf("urn:uuid:") >= 0 ? item.Fileaudio.substring(9, item.Fileaudio.length) : item.Fileaudio,
                      Title: item.Title,
                      DurationInMilliseconds: item.Duration,
                      FPS: item.VideoFPS,
                      DurationInFrames: parseInt(Number(item.Duration * item.VideoFPS) / 1000),
                      Url: cpl_path.replace(/\\/g, "/"),
                      UrlReference: result_datastore[0].manager_address,
                      ContentKind: ''
                    }
                  });

                  let current_cue_list = [];

                  // Controllo se gli elementi successivi\precedenti erano automazioni, se si, le metto tutte in que list, partendo dall'alto
                  for (let n = i - 1; n >= 0; n--) {

                    if (typeof result[n] === 'undefined') break;

                    let temp_item = result[n];

                    if (temp_item.Table_Element !== 'm_automation' && temp_item.Table_Element !== 'm_device_tags')
                      break;

                    if (already_added_automations.includes(temp_item.ID))
                      continue;

                    current_cue_list.push(temp_item);
                    already_added_automations.push(temp_item.ID);

                  }

                  for (let n = i + 1; n < result.length; n++) {

                    if (typeof result[n] === 'undefined') break;

                    let temp_item = result[n];

                    if (temp_item.Table_Element !== 'm_automation' && temp_item.Table_Element !== 'm_device_tags')
                      break;

                    if (already_added_automations.includes(temp_item.ID))
                      continue;

                    if (temp_item.IntermissionStartAt === 0) // Se non ha intermission e sta sotto, fa parte della prossima CPL.
                      continue;

                    current_cue_list.push(temp_item);
                    already_added_automations.push(temp_item.ID);
                  }

                  //console.log(current_cue_list.length)

                  if (current_cue_list.length > 0) {

                    show_json.Show[show_json.Show.length - 1].Clip.CueList = { Cue: [] };
                    current_cue_list.forEach((item_automation, i_auto) => {
                      show_json.Show[show_json.Show.length - 1].Clip.CueList.Cue.push({
                        Name: item_automation.Title,
                        OffsetInMilliseconds: item_automation.IntermissionStartAt,
                        Icon: ""
                      })
                    });

                    current_cue_list = [];

                  }

                  return true;
                  break;


                case 'm_automation': //Automazione, è abbastanza complessa la situazione in uno show, quindi vanno fatte alcune verifiche se singole o da scaricare in cue list
                  //return show_json.Show.push({ Automation : { Name : item.Title }})

                  if (already_added_automations.includes(item.ID)) // Salto.
                    return true;

                  // Se questa automazione non è ancora stata aggiunta, controllo se ha una CPL sotto, in caso non vi fosse, significa che siamo nel caso
                  // Automazione singola che nel caso degli show avviene quando l'automazione è inserita in uno show che contiene solamente SPL sopra e sotto.

                  let single_automations_questionmark = [];

                  for (let n = i - 1; n >= 0; n--) {

                    if (typeof result[n] === 'undefined') break;

                    let temp_item = result[n];

                    if (temp_item.Table_Element !== 'm_automation' && temp_item.Table_Element !== 'm_device_tags')
                      break;

                    if (already_added_automations.includes(temp_item.ID))
                      continue;

                    single_automations_questionmark.push(temp_item);

                  }

                  let cpl_soon = false; // Se true, avremo una CPL a breve, altrimenti se restasse false, sono tutte singole.

                  // Ora, controllo se ci sarà una CPL sotto, in caso vi fosse una spl prima, sono tutte singole
                  for (let n = i + 1; n < result.length; n++) {

                    if (typeof result[n] === 'undefined') break;

                    let temp_item = result[n];

                    if (temp_item.Table_Element === 'm_manual_playlist')
                      break;

                    if (temp_item.Table_Element === 'm_dcp') { cpl_soon = true; break; }

                  }

                  if (!cpl_soon) {

                    // Se non ci sarà una CPL, significa che questa Automazione e quelle in single_automations_questionmark vanno aggiunte come single automations.
                    // Quelle che verranno dopo passeranno questo controllo di nuovo e verranno automaticamente catalogate come singole a loro volta quindi ez
                    // Se tutto dovesse girare liscio, single_automations_questionmark sarà sempre vuoto perchè le automazioni passando una a una non verranno mai
                    // lasciate indietro incalcolate, ma meglio essere sicuri u know.

                    // Quindi, scrivo l'automazione come singola
                    single_automations_questionmark.forEach((item_q, i_q) => {
                      show_json.Show.push({ Automation: { Name: item_q.Title, OffsetInMilliseconds: item_q.IntermissionStartAt, Icon: "" } });
                      already_added_automations.push(item_q.ID);
                    });

                    // Aggiungo quella in esame
                    show_json.Show.push({ Automation: { Name: item.Title, OffsetInMilliseconds: item.IntermissionStartAt, Icon: "" } });
                    already_added_automations.push(item.ID);

                  }

                  return true;

                  break;


              }


            });

            // Non sono fiero di questo schifo di operazioni per mettere un namespace nel root dell'xml ma non trovavo altre soluzioni se non
            // rifare tutta la funzione usando l'altra liberia con il compact a false... unlucky.

            const with_namespace = {
              Show: {
                $: { 'Name': show_name }
              }
            };

            var builder = new xml2js.Builder();
            var xml = builder.buildObject(with_namespace);
            var xml_show = builder.buildObject(show_json);

            let result_parsed = JSON.parse(convert.xml2json(xml, { compact: true }));
            let result_parsed_body = JSON.parse(convert.xml2json(xml_show, { compact: true }));


            result_parsed.Show[""] = result_parsed_body.Show;
            let new_xml = convert.json2xml(result_parsed, { compact: true });

            //console.log(new_xml);



            return resolve(new_xml);

          });


        });
      });
    });
  }

  app.get('/api/test/SCHEDULE-LIST', (req, res) => {

    clientWebSockets[1].send('SCHEDULE-LIST');
    return res.status(200).send({ status: 1 });

  });

  app.get('/api/get/schedule/:day_id', (req, res) => {

    const day_id = req.params.day_id;

    db.query("SELECT * FROM m_template_week WHERE ID_Template = ?", [day_id], (qerr, result) => {

      if (qerr) return res.status(200).send([]);
      return res.status(200).send(result);

    })

  });

  function sendScheduleToAllClients(day_id) {

    db.query("SELECT * FROM m_template_week WHERE ID_Template = ?", [day_id], (qerr, result) => {

      if (qerr) return false;

      const json = { type: 'schedule', day_id: day_id, content: result, timestamp: new Date() }

      wss.clients.forEach(function each(client) {
        if (client.readyState === WebSocket.OPEN) {
          client.send(JSON.stringify(json));
        }
      });


    });

  }


  app.post("/api/schedule/editing", (req, res) => {

    const payload = req.body.payload;

    switch (payload.timeline) {

      case 'update':
        return db.query("UPDATE m_template_week SET BeginHour = ?, Channel = ? WHERE ID = ?", [payload.beginhour, payload.id_theater, payload.id_template], (qerr, result) => {

          if (payload.ws_refresh)
            sendScheduleToAllClients(payload.day_id);

          return res.status(200).send({ status: 1 });

        });

      case 'add':
        return db.query("INSERT INTO m_template_week (Channel, ID_Template, ID_Clock, DayOfWeek, BeginHour) VALUES (?,?,?,'2',?)", [payload.id_theater, payload.day_id, payload.id_template, payload.beginhour], (qerr, result) => {

          if (payload.ws_refresh)
            sendScheduleToAllClients(payload.day_id);

          return res.status(200).send({ status: 1 });

        });

      case 'remove':
        var callback_count = 0;
        return async.forEachOf(payload.id_template, (item, index, callback) => {

          new Promise((resolve, reject) => {

            db.query("DELETE FROM m_template_week WHERE ID = ?", [item], (qerr, result) => {

              return resolve();

            });

          }).then(result_ => {

            callback_count++;

            if (callback_count === payload.id_template.length)
              return callback(true);



          }).catch(err_ => {

            return res.status(500).send({ status: 0 });

          });

        }, () => {

          sendScheduleToAllClients(payload.day_id);
          return res.status(200).send({ status: 1 });

        });

      case 'paste_day':
        if (typeof payload.day_from === 'undefined' || typeof payload.day_to === 'undefined') return res.status(500).send({ status: 0 });
        return db.query("DELETE FROM m_template_week WHERE ID_Template = ?", [payload.day_to], (qerr, result) => {

          if (qerr) { return res.status(500).send({ status: 0 }); }

          db.query("INSERT INTO m_template_week (Channel, ID_Template, ID_Clock, DayOfWeek, BeginHour) SELECT Channel, ?, ID_Clock, DayOfWeek, BeginHour FROM m_template_week WHERE ID_Template = ?",
            [payload.day_to, payload.day_from], (qerr, result) => {

              if (qerr) { return res.status(500).send({ status: 0 }); }

              sendScheduleToAllClients(payload.day_to);
              return res.status(200).send({ status: 1 });

            })

        });

      case 'clear_day':
        if (typeof payload.day_to_clear === 'undefined') return res.status(500).send({ status: 0 });
        return db.query("DELETE FROM m_template_week WHERE ID_Template = ?", [payload.day_to_clear], (qerr, result) => {

          if (qerr) { return res.status(500).send({ status: 0 }); }
          sendScheduleToAllClients(payload.day_to_clear);
          return res.status(200).send({ status: 1 });

        })

      default:
        return res.sendStatus(200)

    }

  })

  app.get('/api/get/audiomode/:theater_index', (req, res) => {

    const theater_index = req.params.theater_index;
    const id_theater = playout_ws_ports[theater_index].theater_id;

    db.query("SELECT b.type FROM m_theaters a LEFT JOIN m_audioprocessor b on a.id_audioprocessor = b.id WHERE a.id = ?", [id_theater], (qerr, result) => {

      if (qerr) return res.status(200).send([]);

      if (typeof audioprocessors_modes[Number(result[0].type)] === 'undefined' && (Number(result[0].type) <= 4)) return res.status(200).send([0]);

      if (Number(result[0].type) > 4)
        return res.status(200).send(audioprocessors_modes[2]);
      else
        return res.status(200).send(audioprocessors_modes[Number(result[0].type)]);

    })

  });

  app.get('/api/get/projectormacros/:theater_index', (req, res) => {

    const { theater_index } = req.params;

    console.log(theater_index)

    db.query("SELECT * FROM m_projector_macros WHERE id_theater = ? ORDER BY macro", [devicemanager_ws_ports[Number(theater_index)].theater_id], (qerr, result) => {

      console.log(devicemanager_ws_ports[Number(theater_index)].theater_id)

      // Se non ne ho, provo a recuperarle dal proiettore.... decidere se farlo...
      if (qerr || result.length === 0) return res.status(200).send([]);
      return res.status(200).send(result);

    });

  });


  app.get('/api/get/switchio/:theater_index', (req, res) => {

    const { theater_index } = req.params;

    // Prendo id_device della switch
    db.query("SELECT a.ID FROM m_devices a LEFT JOIN m_instances b on b.ID = a.ID_INSTANCE WHERE a.DESCRIPTION = 'Device_4' AND b.ID_THEATER = ?", [devicemanager_ws_ports[theater_index].theater_id], (qerr, result) => {

      if (qerr || result.length === 0) return res.status(200).send([]);
      db.query("SELECT * FROM m_device_settings WHERE ID_DEVICE = ? ORDER BY ID", [result[0].ID], (qerr, result) => {

        // Cerco quanti input 
        if (qerr || result.length === 0) return res.status(200).send([]);

        let json_result = {};

        // Rendo il result da array a json...
        result.forEach((item, index) => {
          json_result[item.KEY1] = item.VALUESTRING;
        });

        let input_array = [];
        let output_array = [];

        let max_input = typeof json_result.VideoRouter_MaxInput === 'undefined' ? 0 : json_result.VideoRouter_MaxInput;
        let max_output = typeof json_result.VideoRouter_MaxOutput === 'undefined' ? 0 : json_result.VideoRouter_MaxOutput;

        // Compongo input array
        for (let i = 0; i < max_input; i++) {
          let label = typeof json_result['VideoRouter_LabelInput' + (i + 1) + '_1'] === 'undefined' ? 'IN 1' : json_result['VideoRouter_LabelInput' + (i + 1) + '_1'];
          label = label + (typeof json_result['VideoRouter_LabelInput' + (i + 1) + '_2'] === 'undefined' ? '' : json_result['VideoRouter_LabelInput' + (i + 1) + '_2'])
          input_array.push({ index: i, label: label });
        }

        // Compongo output array
        for (let i = 0; i < max_output; i++) {
          let label = typeof json_result['VideoRouter_LabelOutput' + (i + 1) + '_1'] === 'undefined' ? 'OUT 1' : json_result['VideoRouter_LabelOutput' + (i + 1) + '_1'];
          label = label + (typeof json_result['VideoRouter_LabelOutput' + (i + 1) + '_2'] === 'undefined' ? '' : json_result['VideoRouter_LabelOutput' + (i + 1) + '_2'])
          output_array.push({ index: i, label: label });
        }

        return res.status(200).send({ input: input_array, output: output_array });

      })

    });

  });


  app.get('/api/get/gpiio/:theater_index', (req, res) => {

    const { theater_index } = req.params;

    // Prendo id_device della switch
    db.query("SELECT a.ID FROM m_devices a LEFT JOIN m_instances b on b.ID = a.ID_INSTANCE WHERE a.DESCRIPTION = 'Device_3' AND b.ID_THEATER = ?", [devicemanager_ws_ports[theater_index].theater_id], (qerr, result) => {

      if (qerr || result.length === 0) return res.status(200).send([]);
      db.query("SELECT * FROM m_device_settings WHERE ID_DEVICE = ? ORDER BY ID", [result[0].ID], (qerr, result) => {

        // Cerco quanti input 
        if (qerr || result.length === 0) return res.status(200).send([]);

        let json_result = {};

        // Rendo il result da array a json...
        result.forEach((item, index) => {
          json_result[item.KEY1] = item.VALUESTRING;
        });

        let input_array = [];
        let output_array = [];

        let max_input = typeof json_result.Gpi_MaxInput === 'undefined' ? 0 : json_result.Gpi_MaxInput;
        let max_output = typeof json_result.Gpi_MaxOutput === 'undefined' ? 0 : json_result.Gpi_MaxOutput;

        // Compongo input array
        for (let i = 0; i < max_input; i++) {
          let label = typeof json_result['Gpi_LabelInput' + (i + 1) + '_1'] === 'undefined' ? 'IN 1' : json_result['Gpi_LabelInput' + (i + 1) + '_1'];
          label = label + (typeof json_result['Gpi_LabelInput' + (i + 1) + '_2'] === 'undefined' ? '' : json_result['Gpi_LabelInput' + (i + 1) + '_2'])
          input_array.push({ index: i, label: label });
        }

        // Compongo output array
        for (let i = 0; i < max_output; i++) {
          let label = typeof json_result['Gpi_LabelOutput' + (i + 1) + '_1'] === 'undefined' ? 'OUT 1' : json_result['Gpi_LabelOutput' + (i + 1) + '_1'];
          label = label + (typeof json_result['Gpi_LabelOutput' + (i + 1) + '_2'] === 'undefined' ? '' : json_result['Gpi_LabelOutput' + (i + 1) + '_2'])
          output_array.push({ index: i, label: label });
        }

        return res.status(200).send({ input: input_array, output: output_array });

      })

    });

  });


  function parseDvmStatus(theater_index) {

    const device_manager_status = status_devicemanager_array[theater_index];
    let parsed_dvm_status = {};


    // Parso l'audioprocessor
    if (typeof device_manager_status.AudioProcessor !== 'undefined') {
      for (let i = 1; i <= 3; i++) { // Cerco i parametri

        let item = device_manager_status.AudioProcessor['Param_' + i];

        if (typeof item === 'undefined') continue;

        if (item.indexOf("VOLUME") >= 0) { // Volume
          const split_audio = item.split("=");
          parsed_dvm_status.audio = { ...parsed_dvm_status.audio, volume: split_audio[1] };
        }
        if (item.indexOf("MUTE") >= 0) { // Volume
          const split_audio = item.split("=");
          parsed_dvm_status.audio = { ...parsed_dvm_status.audio, mute: split_audio[1] === '1' ? true : false };
        }
        if (item.indexOf("MODE") >= 0) { // Volume
          const split_audio = item.split("=");
          parsed_dvm_status.audio = { ...parsed_dvm_status.audio, mode: split_audio[1] };
        }
      }
    }
    // Parso il projector
    if (typeof device_manager_status.Projector !== 'undefined') {
      let item = device_manager_status.Projector;
      parsed_dvm_status.projector = {
        dowser: item.DOUSER === '0' ? false : true,
        lamp: item.LAMP === '0' ? false : true,
        macro: typeof item.MACRO !== 'undefined' ? item.MACRO : "UNKNOWN MACRO"
      }
    }
    // Parso gpi
    if (typeof device_manager_status.Gpi !== 'undefined') {
      parsed_dvm_status.gpi = { inputs: [], output: [] };
      for (let i = 1; i < 100; i++) {
        let item = device_manager_status.Gpi['Input_' + i];
        if (typeof item === 'undefined') break;
        parsed_dvm_status.gpi.inputs.push(item);
      }
      for (let i = 1; i < 100; i++) {
        let item = device_manager_status.Gpi['Output_' + i];
        if (typeof item === 'undefined') break;
        parsed_dvm_status.gpi.output.push(item);
      }
    }

    return parsed_dvm_status;

  }

  app.post('/api/dvm/cmd', (req, res) => {

    const { payload } = req.body;
    const theater_index = payload.theater_index;
    const status_dvm_parsed = parseDvmStatus(theater_index);

    console.log(status_dvm_parsed);

    if (clientWebSocketsDVM[theater_index].readyState !== WebSocket.OPEN) return res.sendStatus(200);

    switch (true) {

      // tutti i casi audio, così prendo il device audio. Device_2 è sempre l'audio nel nostro setup
      case payload.cmd === 'mute' || payload.cmd === 'volume' || payload.cmd === 'mode':
        return db.query("SELECT a.ID FROM m_devices a LEFT JOIN m_instances b on b.ID = a.ID_INSTANCE WHERE a.DESCRIPTION = 'Device_2' AND b.ID_THEATER = ?", [devicemanager_ws_ports[theater_index].theater_id], (qerr, result) => {

          if (qerr || result.length === 0) return res.sendStatus(200);
          const prefixCmd = '/DEVICE:' + result[0].ID + ' /COMMAND:WRITE ';

          let cmd_to_send = "";

          switch (payload.cmd) {

            case 'mute':
              cmd_to_send = prefixCmd + (status_dvm_parsed.audio.mute ? '"/PARAM:MUTE 0"' : '"/PARAM:MUTE 1"');
              clientWebSocketsDVM[theater_index].send(cmd_to_send.toString());
              return res.sendStatus(200);

            case 'volume':
              cmd_to_send = prefixCmd + ('"/PARAM:VOLUME ' + payload.volume + '"');
              clientWebSocketsDVM[theater_index].send(cmd_to_send.toString());
              return res.sendStatus(200);

            case 'mode':
              cmd_to_send = prefixCmd + ('"/PARAM:MODE ' + payload.mode + '"');
              clientWebSocketsDVM[theater_index].send(cmd_to_send.toString());
              return res.sendStatus(200);

            default:
              return res.sendStatus(200);


          }

        });

      case payload.cmd === 'macroprj' || payload.cmd === 'lamp' || payload.cmd === 'dowser':
        return db.query("SELECT a.ID FROM m_devices a LEFT JOIN m_instances b on b.ID = a.ID_INSTANCE WHERE a.DESCRIPTION = 'Device_1' AND b.ID_THEATER = ?", [devicemanager_ws_ports[theater_index].theater_id], (qerr, result) => {

          if (qerr || result.length === 0) return res.sendStatus(200);
          const prefixCmd = '/DEVICE:' + result[0].ID + ' /COMMAND:WRITE ';

          let cmd_to_send = "";

          switch (payload.cmd) {

            case 'macroprj':
              cmd_to_send = prefixCmd + ('"/PARAM:MACRO ' + payload.macroname + '"');
              clientWebSocketsDVM[theater_index].send(cmd_to_send.toString());
              return res.sendStatus(200);

            case 'lamp':
              cmd_to_send = prefixCmd + (status_dvm_parsed.projector.lamp ? '"/PARAM:LAMP 0"' : '"/PARAM:LAMP 1"');
              clientWebSocketsDVM[theater_index].send(cmd_to_send.toString());
              return res.sendStatus(200);

            case 'dowser':
              cmd_to_send = prefixCmd + (status_dvm_parsed.projector.dowser ? '"/PARAM:DOUSER 0"' : '"/PARAM:DOUSER 1"');
              clientWebSocketsDVM[theater_index].send(cmd_to_send.toString());
              return res.sendStatus(200);


            default:
              return res.sendStatus(200);

          }
        });

      case payload.cmd === 'setgpi':
        return db.query("SELECT a.ID FROM m_devices a LEFT JOIN m_instances b on b.ID = a.ID_INSTANCE WHERE a.DESCRIPTION = 'Device_3' AND b.ID_THEATER = ?", [devicemanager_ws_ports[theater_index].theater_id], (qerr, result) => {

          if (qerr || result.length === 0) return res.sendStatus(200);
          const prefixCmd = '/DEVICE:' + result[0].ID + ' /COMMAND:WRITE ';

          let cmd_to_send = "";

          switch (payload.cmd) {

            case 'setgpi':
              if (typeof status_dvm_parsed.gpi.output[payload.index - 1] === 'undefined') status_dvm_parsed.gpi.output[payload.index - 1] = 0;
              let status_gpi = status_dvm_parsed.gpi.output[payload.index - 1];
              console.log(status_gpi);
              cmd_to_send = prefixCmd + '"/PARAM:BIT ' + payload.index + " " + (Number(status_gpi) === 1 ? '0' : '1') + '"';
              console.log(cmd_to_send);
              clientWebSocketsDVM[theater_index].send(cmd_to_send.toString());
              return res.sendStatus(200);

            default:
              return res.sendStatus(200);


          }

        });

      case payload.cmd === 'avf':
        return db.query("SELECT a.ID FROM m_devices a LEFT JOIN m_instances b on b.ID = a.ID_INSTANCE WHERE a.DESCRIPTION = 'Device_4' AND b.ID_THEATER = ?", [devicemanager_ws_ports[theater_index].theater_id], (qerr, result) => {

          if (qerr || result.length === 0) return res.sendStatus(200);
          const prefixCmd = '/DEVICE:' + result[0].ID + ' /COMMAND:WRITE ';

          let cmd_to_send = "";

          switch (payload.cmd) {

            case 'avf':
              cmd_to_send = prefixCmd + ('"/PARAM:AFV ' + payload.input + " " + payload.output + '"');
              clientWebSocketsDVM[theater_index].send(cmd_to_send.toString());
              return res.sendStatus(200);

            default:
              return res.sendStatus(200);


          }

        });


      case payload.cmd === 'macrotag':
        let cmd_to_send = '"/TAGS:' + payload.tagname + '"';
        clientWebSocketsDVM[theater_index].send(cmd_to_send.toString());
        return res.sendStatus(200);

      default:
        return res.sendStatus(200);

    }

  });

  app.get('/api/get/splexplodeinfo', (req, res) => {

    db.query("SELECT Fileaudio, Groupname FROM m_dcp ORDER BY ID", (qerr, result) => {

      if (qerr || result.length === 0) return res.status(200).send([]);

      return res.status(200).send(result);


    });

  });

  app.post('/api/cplondemand/save', (req, res) => {

    const { payload } = req.body;

    if (payload.index === 'Image') {

      // Rimuovo e riscrivo il record per le immagini... tanto.
      db.query("DELETE FROM m_cpl_images WHERE UuidCpl = ? ", [payload.uuid], (qerr, result) => {
        if (payload.value === '_remove') return res.sendStatus(200); // Solo rimozione...
        db.query("INSERT INTO m_cpl_images (UuidCpl, Image64 , DatastorePath) VALUES (?,? , '') ", [payload.uuid, payload.value], (qerr, result) => {
          console.log(qerr)
          return res.sendStatus(200);
        });
      })

    } else {

      if (payload.iddb === null) return res.sendStatus(200);

      db.query("UPDATE m_dcp SET " + payload.index + " = ? WHERE ID = ? ", [payload.value, Number(payload.iddb)], (qerr, result) => {

        return res.sendStatus(200);

      });

    }

  });

  app.get('/api/get/cplstatus/:cpl_id', (req, res) => {

    const { cpl_id } = req.params;

    getCplStatus(cpl_id).then(res_ => {

      return res.status(200).send(res_);

    }).catch(err => {

      return res.status(200).send([]);

    })



  });

  function getCplStatus(cpl_id) {

    return new Promise((resolve, reject) => {

      db.query("SELECT id, name FROM m_datastores ORDER BY name", (qerr, result) => {

        if (qerr) return resolve([]);

        let response = [];

        async.forEachOf(result, (item, index, callback) => {

          db.query("SELECT a.* FROM m_streamercop_verify a LEFT JOIN m_dcp b on a.uuid = b.Fileaudio WHERE b.ID = ? AND datastore_name = ?", [Number(cpl_id), item.name], (qerr, result_) => {

            if (qerr || typeof result_ === 'undefined') return resolve({});

            let status_json = {};

            if (result_.length > 0) {
              status_json = { progress: result_[0].progress, id_clip: result_[0].id, date: result_[0].datefrom };
            }

            response[index] = { datastore: item.name, datastore_id: item.id, ...status_json };
            if (index === result.length - 1) return callback(response);



          });

        }, (response_) => {

          return resolve(response_);

        });

      })

    })

  }

  app.post('/api/post/cplstatus/verify', (req, res) => {

    const { datastore_id, cpl_id } = req.body.payload;

    db.query("SELECT name FROM m_datastores WHERE id = ?", [Number(datastore_id)], (qerr, result) => {

      if (qerr || result.length === 0) return res.sendStatus(500);

      db.query("SELECT Title, Fileaudio, String20, String19, Filename FROM m_dcp WHERE ID = ?", [cpl_id], (qerr, result_dcp) => {

        if (qerr || result.length === 0) return res.sendStatus(500);

        // rimuovo tutti i record in clips per questa CPL per questo datastore..
        db.query("DELETE FROM m_streamercop_verify WHERE uuid = ?  AND datastore_name = ?", [result_dcp[0].Fileaudio, result[0].name], (qerr, delete_) => {

          if (qerr) return res.sendStatus(500);

          // Inserisco...
          db.query("INSERT INTO m_streamercop_verify (uuid, id_cpl, progress, verify_status, folder, filename, error, datefrom, datastore_name, title) VALUES (?,?,?,?,?,?,?,?,?,?)"
            , [result_dcp[0].Fileaudio, cpl_id, 'TOVERIFY', '', result_dcp[0].Filename, result_dcp[0].String20, '0', getTimestamp(), result[0].name, result_dcp[0].Title], (qerr, result_ending) => {

              if (qerr) return res.sendStatus(500);

              return res.status(200).send({ clip_id: result_ending.insertId });

            });

        })

      })

    });

  });

  app.get('/api/get/cplstatusdetails/:clip_id', (req, res) => {

    const { clip_id } = req.params;

    getCplStatusDetailed(clip_id).then(res_ => {

      return res.status(200).send(res_);

    }).catch(err => {

      return res.status(200).send([]);

    })

  });

  function getCplStatusDetailed(clip_id) {

    return new Promise((resolve, reject) => {

      db.query("SELECT a.* , b.ID as cpl_id , c.id as datastore_id FROM m_streamercop_verify a LEFT JOIN m_dcp b ON b.Fileaudio = a.uuid LEFT JOIN m_datastores c on c.name = a.datastore_name WHERE a.id = ?", [clip_id], (qerr, result) => {

        if (qerr || result.length === 0) return reject();

        // Se description è vuoto, lo mando vuoto...
        if (result[0].description === '') { result[0].description = {}; return resolve(result[0]); }

        xml2js.parseString(result[0].verify_status, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, json_res) {

          if (result[0].verify_status === '') { result[0].verify_status = {}; return resolve(result[0]); }

          result[0].verify_status = json_res;
          return resolve(result[0]);

        });

      });


    })

  }

  var intervalSendCplStatus = []; // Array per client
  function sendCplStatusWS(ws, cpl_id) {

    if (typeof intervalSendCplStatus[ws.id] !== 'undefined')
      clearInterval(intervalSendCplStatus[ws.id]);

    intervalSendCplStatus[ws.id] = setInterval(() => {

      getCplStatus(cpl_id).then(res_ => {

        getCplTheaterStatus(cpl_id).then(status_cpl => {

          if (ws.readyState === WebSocket.OPEN) {
            ws.send(JSON.stringify({ type: 'CPLSTATUS_RESPONSE', data: { verifystatus: res_, theaterstatus: status_cpl }, id_cpl: cpl_id }));
          }

        })

      })

    }, 250);
  }

  var intervalSendCplStatus_detailed = [];
  function sendCplStatusWS_DETAILS(ws, clip_id) {

    if (typeof intervalSendCplStatus_detailed[ws.id] !== 'undefined')
      clearInterval(intervalSendCplStatus_detailed[ws.id]);

    intervalSendCplStatus_detailed[ws.id] = setInterval(() => {

      getCplStatusDetailed(clip_id).then(res_ => {

        if (ws.readyState === WebSocket.OPEN) {
          ws.send(JSON.stringify({ type: 'CPLSTATUS_DETAILED_RESPONSE', data: res_, id_clip: clip_id }));
        }

      }).catch(err => {

        ws.send(JSON.stringify({ type: 'CPLSTATUS_DETAILED_RESPONSE', data: [], id_clip: clip_id }));

      });

    }, 250);

  }


  app.get('/api/get/kdm/:cpl_id', (req, res) => {

    const { cpl_id } = req.params;

    db.query("SELECT b.* , d.name , c.serial as imb_serial FROM kdm b LEFT JOIN m_imb c on c.kdm_serial = b.projectorid LEFT JOIN m_theaters d ON d.id_imb = c.id LEFT JOIN m_dcp a ON a.Fileaudio = b.uuid WHERE a.ID = ? GROUP BY b.startdate, b.enddate, b.serial, b.filename, b.id_kdm ORDER BY c.ID, b.enddate DESC", [cpl_id], (qerr, result) => {

      if (qerr) return res.status(200).send([]);

      return res.status(200).send(result);

    });

  });

  app.get('/api/get/kdm', (req, res) => {

    db.query("SELECT a.startdate, a.enddate, a.progress, a.id_kdm as uuid , b.Title as Title, d.name FROM kdm a LEFT JOIN m_dcp b ON b.Fileaudio = a.uuid LEFT JOIN m_imb c on c.kdm_serial = a.projectorid LEFT JOIN m_theaters d ON d.id_imb = c.id WHERE d.name IS NOT NULL AND b.Title IS NOT NULL GROUP BY a.startdate, a.enddate, a.projectorid, a.filename ORDER BY b.Title, a.enddate DESC", (qerr, result) => {

      if (qerr) return res.status(200).send([]);
      return res.status(200).send(result);

    });

  });

  app.get('/api/get/transfercpl/theaters', (req, res) => {

    // DOvrei prendere la size della CPL... 

    db.query("SELECT a.* , b.type, b.address, b.serial, b.port, b.api_username, b.api_password, b.id as imb_id FROM m_theaters a LEFT JOIN m_imb b on b.id = a.id_imb ORDER BY a.theater_nr", (qerr, result) => {

      var valid_theaters = [];
      var counter = 0;

      async.forEachOf(result, (item, index, callback) => {

        let current_valid_theater = {

          name: item.name,
          address: item.address,
          type: item.type,
          theater_nr: item.theater_nr,
          imb_serial: item.serial,
          imb_id: item.imb_id


        }

        return new Promise((resolve, reject) => {


          if (item.address === '' || item.serial === '') {

            if (item.address === '')
              current_valid_theater.no_address_set = true;

            if (item.serial === '')
              current_valid_theater.no_serial_set = true;

            return resolve(current_valid_theater); // da gestire se aggiungere o no
            // Deciso che aggiungo, ma non può essere selezionato... o forse si bo..
          }

          // Ora, in base al tipo, dobbiamo gestire le richieste.
          switch (true) {

            case item.type === 'GDC':

              var nc2 = new NetcatClient();
              let command_buffer = [];
              const storage_request = '<?xml version="1.0" encoding="UTF-8" ?><command version="2.2" cmd="GET_STORAGE_INFO" />';
              let header = getGdcHeader(storage_request);
              let cmd_buffer = Buffer.from(storage_request);
              let array_buffers = [header, cmd_buffer];
              let cmd = Buffer.concat(array_buffers);

              let xml_storage = "";
              let buffer_array_storage = [];
              let timeout_storage = [];

              nc2.addr(item.address.toString()).port(Number(item.port)).connect().send(cmd).on('error', (err_) => {

                return resolve(current_valid_theater);

              }).on('data', (data) => {

                clearTimeout(timeout_storage);
                buffer_array_storage.push(data);
                timeout_storage = setTimeout(() => { nc2.close(); }, 50);

              }).on('close', () => {

                let storage_concat = Buffer.concat(buffer_array_storage);
                let xml_response = storage_concat.slice(20, storage_concat.length).toString();
                if (xml_response[0] !== '<') xml_response = xml_response.substr(1, xml_response.length);

                xml2js.parseString(xml_response, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, json_res) {

                  if (err || json_res === null) { current_valid_theater.login_failed = true; return resolve(current_valid_theater); }

                  current_valid_theater.total_space = json_res.storage['$'].total_space;
                  current_valid_theater.fullness = parseInt(100 - (100 / json_res.storage['$'].total_space) * json_res.storage['$'].free_space);
                  return resolve(current_valid_theater);

                });

              });

              break;

            case item.type === 'HULA':

              // NON FACCIO NULLA. L'HULA REGISTRA MA NON TRASFERISCE ALCUN CONTENUTO LO SPAZIO GIà OCCUPATO DAL CONTENUTO è FINALE E NON AUMENTERà.
              return resolve(current_valid_theater);



            case item.type.toUpperCase().indexOf('DOLBY') >= 0 || item.type === 'BARCO':

              /*const agent = new https.Agent({
                rejectUnauthorized: false,
                keepAlive: true
              });*/

              // LOGIN
              return soapLogin(item.type, item.address, item.port, item.api_username, item.api_password, agent).then(login => {

                //console.log('LOGGED');

                if (item.type === 'BARCO') {

                  // faccio il barco
                  // Verifico se siamo loggati...
                  xml2js.parseString(login, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, json_res) {

                    if (Number(json_res['SOAP-ENV:Body']['ns1:LoginResponse']['ns1:LoginResult']) > 0)
                      return resolve(current_valid_theater);

                    // PRENDO IL SERIALE DEL PROIETTORE.
                    soapAPI(item.type, item.address, item.port, 'get_storage', agent).then(res_ => {

                      xml2js.parseString(res_, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, json_res) {

                        current_valid_theater.total_space = Number(json_res['SOAP-ENV:Body']['ns1:GetStorageStatusResponse']['ns1:status']['ns1:TotalSizeInBytes']);
                        current_valid_theater.fullness = parseInt((json_res['SOAP-ENV:Body']['ns1:GetStorageStatusResponse']['ns1:status']['ns1:TotalSizeInBytes'] / 100) * json_res['SOAP-ENV:Body']['ns1:GetStorageStatusResponse']['ns1:status']['ns1:UsedSizeInBytes']);

                        soapAPI(item.type, item.address, item.port, 'logout', agent).then(res_ => {

                          return resolve(current_valid_theater);

                        });

                      });

                    });

                  });

                  //return resolve(current_valid_theater);

                } else {

                  // Faccio il dolby

                  // Prendo l'uuid della sessione....
                  xml2js.parseString(login, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, json_res) {

                    if (!json_res['SOAP-ENV:Body']['ns1:LoginResponse'].sessionId) {
                      //return res.status(500).send({ error: 'login_failed' });
                      return resolve(current_valid_theater)
                    }
                    const dolby_session = json_res['SOAP-ENV:Body']['ns1:LoginResponse'].sessionId;


                    soapAPI(item.type, item.address, item.port, 'get_storage', agent, dolby_session).then(res_ => {

                      xml2js.parseString(res_, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, json_res) {

                        for (let i = 0; i < json_res['SOAP-ENV:Body']['ns1:GetStorageListResponse'].storageList['str:storage'].length; i++) {

                          let storage_row = json_res['SOAP-ENV:Body']['ns1:GetStorageListResponse'].storageList['str:storage'][i];
                          if (storage_row['str:storageUnit'] === 'md0') { // per i dolby cerco l'unità md0 (principale)

                            current_valid_theater.total_space = storage_row['str:capacity'] * 1024 * 1024;
                            current_valid_theater.fullness = storage_row['str:fullness'];
                            break;
                          }

                        }

                        soapAPI(item.type, item.address, item.port, 'logout', agent, dolby_session).then(logout => {

                          // ABBIAMO QUELLO CHE CI SERVE X DOLBY
                          return resolve(current_valid_theater);

                        });

                      });

                    }).catch(error_api => {

                      //console.log(error_api)
                      return reject(index);

                    });

                  });


                }


              }).catch(err => {

                // errore nel login.. pace...
                current_valid_theater.login_failed = true;
                return resolve(current_valid_theater);

              });


          }

        }).then(resolved => {

          //console.log(resolved);
          if (typeof resolved !== 'undefined')
            valid_theaters.push(resolved);

          if (counter + 1 >= result.length) return callback(valid_theaters);
          counter++;

        }).catch(rejected => {

          //...

          //console.log(rejected);
          if (counter + 1 >= result.length) {
            //console.log(rejected);
            return callback(valid_theaters);
          }
          counter++;

        });

      }, (cb_result) => {

        cb_result.sort(propComparator('theater_nr')); // Ordino...
        return res.status(200).send(cb_result); // Mando..


      });

    });

  });



  app.get('/api/get/unloadcpl/:id_cpl', (req, res) => {

    const { id_cpl } = req.params;

    if (id_cpl === 'multi') {

      // Siamo nel caso di più ID CPL, quindi, dobbiamo dare la possibilità di fare l'unload su tutti i teatri e verrà eseguito solamente dove necessario ;) 
      db.query("SELECT a.* , b.type, b.address, b.serial, b.port, b.api_username, b.api_password, b.id as imb_id FROM m_theaters a LEFT JOIN m_imb b on b.id = a.id_imb ORDER BY a.theater_nr", (qerr, result) => {

        let imbs = [];

        result.forEach((item) => {

          if (item.serial !== '')
            imbs.push({
              id: item.id,
              name: item.name,
              address: item.address,
              type: item.type,
              theater_nr: item.theater_nr,
              imb_serial: item.serial,
              imb_id: item.imb_id
            })

        });

        return res.status(200).send(imbs);

      });

    } else {

      db.query("SELECT * FROM m_dcp WHERE ID = ?", [Number(id_cpl)], (qerr, result) => {

        if (qerr) return res.sendStauts(500);

        db.query("SELECT a.*, b.type, b.address, c.name FROM clips a LEFT JOIN m_imb b on b.serial = a.serial LEFT JOIN m_theaters c ON c.id_imb = b.id WHERE a.uuid = ? AND c.id is not null AND a.progress LIKE '%COMPLETE%' and a.ingested = 1 and a.todelete = 0 GROUP BY c.name", [result[0].Fileaudio], (qerr, result) => {

          return res.status(200).send(result);

        });

      });

    }

  });


  app.post('/api/cpltransfer/send', (req, res) => {

    const { payload } = req.body;

    // date...    
    let tonight = new Date();
    tonight.setDate(tonight.getDate() + 1);
    tonight.setHours(2);
    tonight.setMinutes(0);
    tonight.setSeconds(0);
    tonight.setTime(tonight.getTime() + Math.abs(tonight.getTimezoneOffset() * 60 * 1000));

    let custom_ = new Date(payload.custom_);
    custom_.setTime(custom_.getTime() + Math.abs(custom_.getTimezoneOffset() * 60 * 1000));
    let resolved_index = 0;

    // Ora, siccome 

    async.forEachOf(payload.imb_ids, (imb_id, index, cb) => {

      new Promise((resolve, reject) => {

        // ottengo dati IMB
        db.query("SELECT a.* , b.name, c.name as bkp_name FROM m_imb a LEFT JOIN m_datastores b on b.id = a.id_datastore LEFT JOIN m_datastores c on c.id = a.id_datastore_backup WHERE a.id = ?", [imb_id], (qerr, result_) => {

          if (qerr) return res.sendStatus(500); // ???? imb non esistente...

          let cycle_datastores = [0];

          if (result_[0].type === 'HULA') {
            cycle_datastores = [0, 1]; // faccio 2 volte l'inserimento
          }

          let count_cycle = 0;
          let result = [result_[0]];

          async.forEachOf(cycle_datastores, (item, index_item, callback_data) => {

            if (result[0].type === 'HULA') {

              if (item === 0)
                result[0].serial = 'HULA-' + result[0].name;
              else
                result[0].serial = 'HULA-' + result[0].bkp_name;

            }

            let cpl_count = 0;

            async.forEachOf(payload.cpl_ids, (cplId, index_cpl, callback_cpl) => {

              // Prendo info CPL
              db.query("SELECT * FROM m_dcp WHERE ID = ?", [cplId], (qerr, result_dcp) => {

                if (qerr || result_dcp.length === 0) return res.sendStatus(500); // Non esiste la dcp???

                if (result[0].type === 'HULA') {

                  if (item === 0)
                    result[0].serial = 'HULA-' + result[0].name;
                  else
                    result[0].serial = 'HULA-' + result[0].bkp_name;

                }

                // Cancello i record precedenti per questo imb e questa cpl
                db.query("DELETE FROM clips WHERE uuid = ? and serial = ?", [result_dcp[0].Fileaudio, result[0].serial], (qerr, result_delete) => {

                  if (qerr) return res.sendStatus(500);

                  const dateFrom = payload.transfer_mode === 0 ? getTimestamp() : payload.transfer_mode === 1 ? tonight.toMysqlFormat() : custom_.toMysqlFormat();

                  if (result[0].type === 'HULA') {

                    if (item === 0)
                      result[0].serial = 'HULA-' + result[0].name;
                    else
                      result[0].serial = 'HULA-' + result[0].bkp_name;

                  }

                  db.query("INSERT INTO clips ( uuid, filename, folder, ingested, todelete, progress, task, error, serial, datefrom, queued, dcpid, modifydate, title, description ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)",
                    [result_dcp[0].Fileaudio, result_dcp[0].String20, result_dcp[0].Filename, 0, 0, 1, 0, 0, result[0].serial, dateFrom, 0, cplId, getTimestamp(), result_dcp[0].Title, ''], (qerr, result_insert) => {

                      //console.log((index + 1) >= payload.imb_ids.length);
                      //if (Number(index + 1) >= payload.imb_ids.length) {

                      cpl_count++;
                      if (cpl_count >= payload.cpl_ids.length) return callback_cpl(true);

                    });

                });

              });

            }, (x) => {

              // ok fine inserimento di questa CPL.
              count_cycle++;
              if (count_cycle >= cycle_datastores.length) return resolve();


            });

          }, () => {

            return resolve(true);

          })

        });

      }).then(resolved => {

        resolved_index++;

        return cb();

      }).catch(rejected => {



      });

    }, (callback) => {

      return res.status(200).send({ status: '1' });

    });

  });


  app.post('/api/cplunload/send', (req, res) => {

    const { payload } = req.body;

    async.forEachOf(payload.clip_ids, (id_clip, index, callback) => {

      db.query("UPDATE clips SET todelete = 1 WHERE id = ?", [id_clip], (qerr, result) => {

        return callback();

      })

    }, () => {

      return res.sendStatus(200);

    })

  });

  app.post('/api/cplunload/multi', (req, res) => {

    const { payload } = req.body;

    async.forEachOf(payload.cpl_ids, (cplId, index, callback_cpl) => {

      db.query("SELECT Fileaudio FROM m_dcp WHERE ID = ?", [cplId], (qerr, result) => {

        async.forEachOf(payload.imbs, (imb_id, index_imb, callback_imb) => {

          db.query("SELECT serial FROM m_imb WHERE id = ?", [imb_id], (qerr, result_imb) => {

            if (qerr || result_imb.length === 0) return callback_imb();

            db.query("UPDATE clips SET todelete = 1 WHERE progress like '%Complete%' AND ingested = 1 and uuid = ? and serial = ? ", [result[0].Fileaudio, result_imb[0].serial], (qerr, result_) => {

              return callback_imb();

            });

          });

        }, () => {

          return callback_cpl();

        });

      });

    }, () => {

      return res.sendStatus(200);

    })

  });

  app.get('/api/get/cpltheaterstatus/:id_cpl', (req, res) => {

    const { id_cpl } = req.params;
    getCplTheaterStatus(id_cpl).then(result => {

      return res.status(200).send(result);

    })


  });

  function getCplTheaterStatus(id_cpl) {

    // Dobbiamo dare uno stato per ogni teatro in base alla modalità, se ha la KDM o meno ecc u know.


    return new Promise((global_resolve, global_reject) => {

      let response = [];
      let counter_cb = 0;

      db.query("SELECT Fileaudio, ExecutionMode FROM m_dcp WHERE id = ?", [id_cpl], (qerr, result) => {

        if (typeof result === 'undefined' || result.length === 0 || qerr) return global_resolve([]); // Non esiste la cpl quindi dico che non è verificata da nessuna parte, giustamente...

        db.query("SELECT a.id, a.name, a.id_imb, b.type, b.serial, b.kdm_serial, b.direct_streaming, b.certified, b.self_schedule, c.name as datastore_name FROM m_theaters a LEFT JOIN m_imb b ON b.id = a.id_imb LEFT JOIN m_datastores c on c.id = b.id_datastore ORDER BY theater_nr", (qerr, result_theaters) => {

          if (qerr || typeof result_theaters === 'undefined') return global_reject([]);

          async.forEachOf(result_theaters, (theater, index, callback) => {

            let current = {

              id_theater: theater.id,
              name: theater.name,
              is_loaded: false,
              kdm_status: result[0].ExecutionMode === 1 ? 'expired' : 'valid', // Allora, se la CPL non è encryptata la inizializzo come kdm valide altirmenti come expired.
              kdm_serial: theater.kdm_serial,
              serial: theater.serial

            }

            new Promise((resolve, reject) => {

              if (theater.direct_streaming && !theater.certified && !theater.self_schedule) {

                // Devo soltanto controllare se la CPL è verificata nel datastore di questo teatro + quello di backup????
                db.query("SELECT id FROM m_streamercop_verify WHERE uuid = ? AND progress = 'VERIFIED' AND datastore_name = ?", [result[0].Fileaudio, theater.datastore_name], (qerr, result_verify) => {

                  if (qerr || result_verify.length === 0)
                    current.is_loaded = false;
                  else
                    current.is_loaded = true;

                  return resolve(current);

                });

              } else {

                // Se siamo TYPE HULA, allora devo controllare x datastore, altrimenti all good.
                if (theater.type === 'HULA') {

                  const serial = theater.type + '-' + theater.datastore_name;
                  //console.log(serial)
                  db.query("SELECT * FROM clips WHERE serial = ? and progress like '%COMPLETE%' and uuid = ?", [serial, result[0].Fileaudio], (qerr, obj) => {

                    if (qerr || obj.length === 0)
                      current.is_loaded = false;
                    else
                      current.is_loaded = true;

                    return resolve(current);

                  })


                } else {

                  // cerco in clips per i contenuti trasferiti\certificati\registrati whatever u know we know
                  db.query("SELECT id FROM clips WHERE uuid = ? AND serial = ? AND progress like '%COMPLETE%' and ingested = 1 and todelete = 0", [result[0].Fileaudio, theater.serial], (qerr, result_clips) => {

                    if (qerr || result_clips.length === 0) return resolve(current);

                    current.is_loaded = true;
                    return resolve(current);

                  });

                }

              }

              //});

            }).then(resolved => {

              counter_cb++;

              if (resolved.is_loaded)
                response.push(resolved);

              if (counter_cb >= result_theaters.length) return callback(response);

            }).catch(error => {

              // Non do mai reject, qua non ci andrà mai ma per sicurezza ..
              counter_cb++;
              if (counter_cb >= result_theaters.length) return callback(response);

            });

          }, (callback) => {

            // DOVREI CHECKARE LE KDM ORA.
            //se non abbiamo teatri, significa che non è ready da nessuna parte quindi perchè controllare se ha le KDM...
            if (callback.length === 0) return global_resolve([]);

            // SE la cpl non è encryptata, non controllo nemmeno se abbia le KDM.. giustamente..
            if (result[0].ExecutionMode === 0) return global_resolve(callback);

            let count_theaters = 0;
            let return_array = [...callback];

            async.forEachOf(callback, (theater_loaded, th_index, callback_kdms) => {

              // projectorid CONTERRà IL SERIALE DELL'IMB MENTRE SERIAL CONTERRà IL CERTIFICATE DELLA KDM
              db.query("SELECT id, startdate, enddate FROM kdm WHERE projectorid = ? AND serial = ? and uuid = ? and progress like '%complete%'", [theater_loaded.kdm_serial, theater_loaded.serial, result[0].Fileaudio], (qerr, result_kdm) => {

                //console.log("SELECT id, startdate, enddate FROM kdm WHERE serial = '" + theater_loaded.kdm_serial + "' AND projectorid = '" + theater_loaded.serial + "' and uuid = '" + result[0].Fileaudio + "' and progress like '%complete%'")

                // Ora, abbiamo la lista delle KDM caricate per questa CPL ma non sappimo ancora se siano scadute o meno, se result_kdm è 0 significa che non ci sono a prescindere
                // KDM caricate per questo contenuto quindi resta expired.
                new Promise((resolve, reject) => {

                  if (result_kdm.length === 0 || qerr) { return resolve("expired"); }

                  // Inizializzo lo stato della KDM.. cambierà nel foreachof async big yikes.
                  let kdm_status = "expired";
                  let count_kdm = 0;

                  //async.forEachOf(result_kdm, (kdm, index_kdm, callback_single_kdm) => {

                  //new Promise((resolved_kdm, rejected_kdm) => {
                  result_kdm.forEach(kdm => {

                    if (new Date(kdm.startdate).getTime() <= new Date().getTime() && new Date(kdm.enddate).getTime() > new Date().getTime()) {

                      // abbiamo trovato una KDM valida. 
                      let tomorrow = new Date();
                      tomorrow.setDate(tomorrow.getDay() + 1);

                      // Controllo se scade domani.  
                      if (tomorrow.getTime() > new Date(kdm.enddate) && new Date().getTime() < new Date(kdm.enddate)) {

                        // SCADE DOMANI
                        if (kdm_status !== 'valid')
                          kdm_status = 'expiring_tomorrow';

                      } else {

                        // Non scade domani, è valida.
                        kdm_status = 'valid';

                      }

                    }

                    if (new Date(kdm.startdate).getTime() > new Date().getTime()) {

                      // Se la kdm è futura e non ne abbiamo ancora trovata una valida per il momento, la segno come future...
                      if (kdm_status !== 'valid') kdm_status = 'future';

                    }

                  })

                  return resolve(kdm_status);


                }).then(resolved => {


                  count_theaters++;
                  return_array[th_index].kdm_status = resolved;

                  if (count_theaters >= callback.length)
                    return callback_kdms(return_array);



                }).catch(error => {

                  //console.log(error);

                });

              });

            }, (callback_complete_kdms) => {

              //return res.status(200).send(callback_complete_kdms);
              return global_resolve(callback_complete_kdms);

            });

          });

        });

      });

    });


  }

  app.get('/api/get/streamerv2/update', (req, res) => {

    const download_path = path.join(os.tmpdir(), 'release-streamerv2-update.zip');
    const writer = fs.createWriteStream(download_path);

    wss.clients.forEach(function each(client) {
      if (client.readyState === WebSocket.OPEN) {
        client.send(JSON.stringify({ type: 'UPDATE_PROGRESS', data: { current_step: 1 } }));
      }
    });


    // Api per il download e aggiornamento di streamerv2 sia api che client.
    axios({

      url: 'http://software.bitonlive.net/cinema/streamerV2/streamerV2.zip',
      method: 'get',
      responseType: 'stream',

    }).then(res_ => {

      wss.clients.forEach(function each(client) {
        if (client.readyState === WebSocket.OPEN) {
          client.send(JSON.stringify({ type: 'UPDATE_PROGRESS', data: { current_step: 2 } }));
        }
      });

      return new Promise((resolve, reject) => {

        res_.data.pipe(writer);
        let in_error = false;

        writer.on('error', err_writer => {

          in_error = true;
          writer.close();
          return reject(err_writer);

        });

        writer.on('close', () => {

          if (!in_error) return resolve();

        })


      }).then(resolved => {

        wss.clients.forEach(function each(client) {
          if (client.readyState === WebSocket.OPEN) {
            client.send(JSON.stringify({ type: 'UPDATE_PROGRESS', data: { current_step: 3 } }));
          }
        });

        // Non esiste la cartella di installazione.... wow
        if (!fs.existsSync('/var/www/streamerv2')) return res.status(500).send({ status: 0, message: 'Realease folder does not exist.' });

        // Abbiamo scaricato l'aggiornamento, lo estraggo...

        const { exec } = __webpack_require__(63129);

        // Tento di riavviare le api.
        const ls_ = exec('rm -r /var/www/streamerv2/client', function (error, stdout, stderr) {
          if (error) {
            console.log(error.stack);
            console.log('Error code: ' + error.code);
            console.log('Signal received: ' + error.signal);
          }
        });

        ls_.on('exit', function (code) {

          let stream_update = fs.createReadStream(download_path).pipe(unzip.Extract({ path: '/var/www/streamerv2/' }));
          // Chiedo al server di riavviare il docker.

          wss.clients.forEach(function each(client) {
            if (client.readyState === WebSocket.OPEN) {
              client.send(JSON.stringify({ type: 'UPDATE_PROGRESS', data: { current_step: 4 } }));
            }
          });

          stream_update.on('close', () => {

            // Tento di riavviare le api.
            const ls = exec('pm2 restart app.dist.js', function (error, stdout, stderr) {
              if (error) {
                console.log(error.stack);
                console.log('Error code: ' + error.code);
                console.log('Signal received: ' + error.signal);
              }
            });

            ls.on('exit', function (code) {


            });

          })



          return res.sendStatus(200);

        });





      }).catch(rejected => {

        console.log(rejected);
        return res.sendStatus(500);

      });

    }).catch(err => {

      console.log(err)
      return res.sendStatus(500);

    });

  });


  app.post('/api/ingest/cpl/scanfolder', (req, res) => {

    const { payload } = req.body;

    let scan_path = path.join(payload.path, payload.folder_to).replace(/\\/g, "/");

    var cpl_information_object = [];
    var cpl_count_check = 0;

    asyncWsBroadcast({ type: 'INGEST_SCAN_PROGRESS', message: 'Scanning and Analyzing folder' });

    // Siamo in FTP
    if (typeof payload.is_ftp !== 'undefined') {

      const ftp_credentials = { username: payload.username, password: payload.password, address: payload.address, port: payload.port };

      // SCANNERIZZO LA CARTELLA PER CREARMI IL MIO OGGETTO MAPPA
      recursiveScanFolderFTP(ftp_credentials, scan_path).then(list => {

        asyncWsBroadcast({ type: 'INGEST_SCAN_PROGRESS', message: 'Folder scanned succesfully. Searching for valid Assetmaps' });

        if (list.length === 0) { return res.status(500).send({ error: 'Folder is empty. Please try to add folders which contain any CPL.' }) }

        const result_list = { source: scan_path, list: list };

        // ABBIAMO LA CARTELLA MAPPATA! ORA, RIMANENDO IN FTP, POSSO LEGGERE IL CONTENUTO DEGLI ASSETMAP CHE TROVO SPARSI SECONDO LA MAPPATURA.
        findAssetmapsFromScanFTP(ftp_credentials, result_list).then(assetmap_list => {

          if (assetmap_list.length === 0) return res.status(500).send({ error: 'Folder does not contain any valid CPL, even in subfolders.' });

          asyncWsBroadcast({ type: 'INGEST_SCAN_PROGRESS', message: 'Found ' + assetmap_list.length + ' valid Assetmaps. Analyzing' });

          async.forEachOf(assetmap_list, (assetmap_path, index_assetmap, cb) => {

            getCPLinformationFromAssetmap(assetmap_path.filename, { is_ftp: true, credentials: ftp_credentials }).then(cpl_information => {


              cpl_count_check++;
              // Scrivo le informazioni della CPL
              cpl_information_object.push(cpl_information);

              asyncWsBroadcast({ type: 'INGEST_SCAN_PROGRESS', message: 'Analyzed ' + cpl_count_check + ' / ' + assetmap_list.length + ' Assetmaps', progress: parseInt((100 / assetmap_list.length) * cpl_count_check) });

              if (cpl_count_check >= assetmap_list.length) { return cb(cpl_information_object) }


            }).catch(err => {

              // La funzione sicuramente ritornerà errori, siccome siamo in fase di ingest e non di verifica, non ci interessa, non è valida la scarto dall'ingest fine.              
              cpl_count_check++;

              asyncWsBroadcast({ type: 'INGEST_SCAN_PROGRESS', message: 'Analyzed ' + cpl_count_check + ' / ' + assetmap_list.length + ' Assetmaps', progress: parseInt((100 / assetmap_list.length) * cpl_count_check) });

              if (cpl_count_check >= assetmap_list.length) { return cb(cpl_information_object) }

            });

          }, (cpl_callback) => {

            setTimeout(() => { asyncWsBroadcast({ type: 'INGEST_SCAN_PROGRESS', message: '' }); }, 1000);

            // callback contenente lo stato delle CPL individuate.
            return res.status(200).send(cpl_callback);

          });

        }).catch(err => {

          console.log(err)
          return res.sendStatus(500);

        });



      }).catch(err => {

        console.log(err)
        return res.sendStatus(500);


      });



    } else {

      console.log(scan_path)

      // Siamo in locale...
      recursive(scan_path, function (err, files) {

        if (files.length === 0) { return res.status(500).send({ error: 'Folder is empty. Please try to add folders which contain any CPL.' }) }

        // Cerco gli assetmap e verifico che siano assetmap
        findAssetmapsFromScanLocal(files).then(assetmap_list => {

          if (assetmap_list.length === 0) return res.status(500).send({ error: 'Folder does not contain any valid CPL, even in subfolders.' });


          async.forEachOf(assetmap_list, (assetmap_path, index_assetmap, cb) => {

            getCPLinformationFromAssetmap(assetmap_path).then(cpl_information => {

              cpl_count_check++;
              // Scrivo le informazioni della CPL
              cpl_information_object.push(cpl_information);

              if (cpl_count_check >= assetmap_list.length) { return cb(cpl_information_object) }


            }).catch(err => {

              console.log(err);

              // La funzione sicuramente ritornerà errori, siccome siamo in fase di ingest e non di verifica, non ci interessa, non è valida la scarto dall'ingest fine.
              cpl_count_check++;
              if (cpl_count_check >= assetmap_list.length) { return cb(cpl_information_object) }

            });

          }, (cpl_callback) => {

            // callback contenente lo stato delle CPL individuate.
            return res.status(200).send(cpl_callback);

          });



        }).catch(error_asset_list => {



        })



      });


    }

  });


  function findAssetmapsFromScanLocal(files) {

    let assetmap_list = [];

    return new Promise((resolve_main, reject_main) => {

      let count_checked = 0;

      async.forEachOf(files, (file, index_file, callback_files) => {

        file = file.replace(/\\/g, '/'); // Sistemo il path

        if (path.basename(file).toLocaleLowerCase().indexOf('assetmap') >= 0) {

          // Lo apro e verifico se è un assetmap
          new Promise((resolve_asset, reject_asset) => {

            // leggo il file e parso il json.
            const assetmap_xml = fs.readFileSync(file).toString();

            xml2js.parseString(assetmap_xml, { explicitArray: false, explicitChildren: false, explicitRoot: true }, function (err, json_res) {

              if (err) { return reject_asset(); }

              if (typeof json_res.AssetMap !== 'undefined') {

                return resolve_asset(file);

              } else {

                return reject_asset();

              }


            });

          }).then(resolved_asset => {

            count_checked++;
            assetmap_list.push(resolved_asset);
            if (count_checked >= files.length) return callback_files(assetmap_list);


          }).catch(rejected_asset => {

            count_checked++; if (count_checked >= files.length) return callback_files(assetmap_list);

          });

        } else {

          // Non è sicuramente un assetmap...
          count_checked++; if (count_checked >= files.length) return callback_files(assetmap_list);

        }



      }, (callback_asset_list) => {

        return resolve_main(callback_asset_list);

      });

    });

  }


  const recursiveScanFolderFTP = async (ftp_credentials, scan_path) => {

    return new Promise((resolve, reject) => {

      var c = new Client_FTP();
      c.on('ready', function () {

        var folder_map = [];

        const scanDirFtp = (ftp_credentials, path_to_folder) => {

          return new Promise((resolve_list, reject_list) => {

            let current_files = [];

            try {

              c.list(path_to_folder, (err, list) => {

                if (err) { c.destroy(); return resolve_list(current_files); }

                // Dovrei controllare se ho cartelle o meno

                let index_folder_scanned = 0;

                async.forEachOf(list, (file, index_file, callback) => {

                  //console.log(file.name);

                  current_files.push({ filename: file.name });

                  if (file.type === "d") {
                    // recursive...

                    const path_to_recurse = path.join(path_to_folder, file.name).replace(/\\/g, "/");

                    scanDirFtp(ftp_credentials, path_to_recurse).then(list_recursive => {

                      current_files[index_file] = { is_folder: true, foldername: file.name, content: list_recursive };
                      index_folder_scanned++;

                      if (index_folder_scanned >= list.length) { return callback(current_files); }

                    });

                  } else {

                    index_folder_scanned++;
                    if (index_folder_scanned >= list.length) { return callback(current_files); }

                  }

                }, (list_callback) => {


                  return resolve_list(list_callback)

                });

              });

            } catch (error) {

              //c.end();

              return resolve_list(current_files);

            }

          });


        }


        scanDirFtp(ftp_credentials, scan_path.replace(/\\/g, "/")).then(list => {

          c.destroy();
          return resolve(list);

        }).catch(err => {

          c.destroy();
          console.log(err);
          return reject();

        });

      });
      c.on('error', (err) => {
        console.log(err);
        //return [];
      })
      // connect to localhost:21 as anonymous

      c.connect({
        host: ftp_credentials.address,
        port: ftp_credentials.port,
        user: ftp_credentials.username,
        password: ftp_credentials.password,
      });

    });

  }

  function findAssetmapsFromScanFTP(ftp_credentials, scanmap) {

    return new Promise((resolve, reject) => {


      var c = new Client_FTP();
      c.on('ready', function () {

        var assetmaps = [];

        const findAssetmap = (folder, radix_folder) => {

          let count_files_checked = 0;

          return new Promise((resolve_list, reject_list) => {

            async.forEachOf(folder, (item, index_item, callback_func) => {

              if (typeof item.is_folder === 'undefined') {

                if (typeof item.filename !== 'undefined' && item.filename.toLowerCase().indexOf('assetmap') >= 0) {

                  const path_to_file = path.join(radix_folder, item.filename).replace(/\\/g, "/");

                  try {

                    c.get(path_to_file, function (err, stream) {

                      if (err) throw err;
                      let assetmap_xml = '';

                      let timeout_read_stream;

                      stream.on('data', function (chunk) {
                        clearTimeout(timeout_read_stream);
                        assetmap_xml += chunk.toString();
                        timeout_read_stream = setTimeout(() => { stream.end() }, 50);
                      });
                      stream.on('end', function () {

                        //c.end();

                        // SCRIVO IL PATH COMPLETO DELL'ASSETMAP INDIVIDUATO... se è un assetmap valido!
                        xml2js.parseString(assetmap_xml, { explicitArray: false, explicitChildren: false, explicitRoot: true }, function (err, json_res) {

                          // Se è in errore, addo e controllo se devo o meno chiamare la callback come in ogni error che può ritornare questa funzione.
                          if (err || typeof json_res['AssetMap'] === 'undefined') { count_files_checked++; if (count_files_checked >= folder.length) return callback_func(assetmaps); }

                          // L'assetmap esiste ed è valido
                          assetmaps.push({ filename: path_to_file });
                          count_files_checked++; if (count_files_checked >= folder.length) return callback_func(assetmaps);

                        });


                      });

                      stream.on('error', (error_read) => {

                        count_files_checked++;
                        if (count_files_checked >= folder.length) return callback_func(assetmaps);

                      })



                    });


                  } catch (error) {

                    console.log(error)
                    count_files_checked++;
                    if (count_files_checked >= folder.length) return callback_func(assetmaps);


                  }

                } else {

                  count_files_checked++;
                  if (count_files_checked >= folder.length) return callback_func(assetmaps);

                }

              } else {

                // è una cartella, vado in recursione
                const new_radix = path.join(radix_folder, item.foldername).replace(/\\/g, "/");


                if (item.content === null || item.content.length === 0) {

                  count_files_checked++;
                  if (count_files_checked >= folder.length) return callback_func(assetmaps);

                } else {

                  findAssetmap(item.content, new_radix).then(recursed => {

                    count_files_checked++;
                    if (count_files_checked >= folder.length) return callback_func(assetmaps);

                  });

                }

              }


            }, (assetlist) => {

              return resolve_list(assetlist);

            })



          });

        }

        // QUA VIENE INIZIALIZZATA LA FUNZIONE RICORSIVA!
        findAssetmap(scanmap.list, scanmap.source).then(asset_list => {

          c.end();
          return resolve(asset_list);

        }).catch(err => {

          c.end();
          return reject();

        })

      });
      c.on('error', (err) => {
        console.log(err);

        count_files_checked++;
        if (count_files_checked >= folder.length) return callback_func(assetmaps);

      })
      c.connect({
        host: ftp_credentials.address,
        port: ftp_credentials.port,
        user: ftp_credentials.username,
        password: ftp_credentials.password,
      });

    });

  }


  function getCPLinformationFromAssetmap(assetmap_path, options = {}) {

    return new Promise((resolve_global, reject_global) => {

      var timeout_promise_cpl = typeof options.last_attemp === 'undefined' ? setTimeout(() => { return reject_global({ error: 'timed out' }) }, 30000) : null;

      // Prendo il contenuto dell'assetmap, prima promise, se è ftp in un modo, se local in un altro, più semplice
      new Promise((resolve_assetmap, reject_assetmap) => {

        // FTP
        if (typeof options.is_ftp !== 'undefined') {

          const { credentials } = options;

          // prendo il contenuto dell'assetmap sfruttando la funzioncina ez che sta qua sotto yikes.
          easyFTPfileCheck(credentials, assetmap_path, 0).then(assetmap_content => {

            console.log('> assetmap preso!' + assetmap_path);

            xml2js.parseString(assetmap_content, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, json_res) {

              console.log('> assetmap letto!' + assetmap_path);

              if (err) return reject_global({ error: 'An error occurred while reading the Assetmap content [' + assetmap_path + ']' });
              // Risolvo il contenuto dell'assetmap

              return resolve_assetmap(json_res);

            });

          }).catch(err => {

            clearTimeout(timeout_promise_cpl);
            return reject_global({ error: 'An error occurred while reading the Assetmap content [' + assetmap_path + ']' });

          });

        } else {

          // LOCALE
          const assetmap_xml = fs.readFileSync(assetmap_path).toString();

          xml2js.parseString(assetmap_xml, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, json_res) {

            if (err) { clearTimeout(timeout_promise_cpl); return reject_global({ error: 'An error occurred while reading the Assetmap content [' + assetmap_path + ']' }); }
            return resolve_assetmap(json_res);

          });


        }

      }).then(resolved_assetmap => {

        const current_assetmap = resolved_assetmap;

        // Prendo la mappatura della cartella dell'assetmap
        const folder_content = path.dirname(assetmap_path).replace(/\\/g, "/");

        new Promise((resolve_foldermap, reject_foldermap) => {

          // FTP
          if (typeof options.is_ftp !== 'undefined') {

            const { credentials } = options;
            recursiveScanFolderFTP(credentials, folder_content).then(foldermap => {

              console.log('> cartella letta!' + assetmap_path);

              if (foldermap.length === 0) return reject_global({ error: 'An error occurred while reading the CPL Folder [ ' + folder_content + ' ]' });
              return resolve_foldermap({ map: foldermap, assetmap_: current_assetmap });

            }).catch(err => {

              clearTimeout(timeout_promise_cpl);
              return reject_global({ error: 'An error occurred while reading the CPL Folder [ ' + folder_content + ' ]' });

            })

          } else {
            // LOCAL

            recursive(folder_content, (err, files) => {

              if (err || files.length === 0) return reject_global({ error: 'An error occurred while reading the CPL Folder [ ' + folder_content + ' ]' });

              // SIccome la funzione ricorsiva ci da soltanto i filename assoluti, dobbiamo creare un oggetto simile al sourcemap che genero io con la mia funzione ricorsiva
              // per gli ftp, lo chiameremo sourcemap fake e diamo i parametri json nell'array che verranno controllati qua sotto.

              let sourcemap_fake = [];
              files.forEach((file_) => {

                sourcemap_fake.push({ filename: path.basename(file_), path: file_ });

              });

              return resolve_foldermap({ map: sourcemap_fake, assetmap_: current_assetmap });

            });


          }

        }).then(resolved_sourcemap => {

          let simplified_assets = [];
          let is_assetmap_ok = true;


          // ABBIAMO I FILES CONTENUTI NELLA CARTELLA.
          resolved_sourcemap.assetmap_.AssetList.Asset.forEach((asset_, index_asset) => {

            //console.log('> asset_______ letto!' + assetmap_path);

            let file_missing = false;

            // passo ogni asset dell'assetmap
            for (let i = 0; i < resolved_sourcemap.map.length; i++) {

              let sourcemap_item = resolved_sourcemap.map[i];

              //if (typeof sourcemap_item.is_folder !== 'undefined') continue; // è una folder, non mi interessa, cerco i files rn

              let actual_filename = "";
              let is_subtitle = false;

              // CONTROLLO SE è in UNA sottoCARTELLA
              if (asset_.ChunkList.Chunk.Path.indexOf('/') >= 0) {
                actual_filename = asset_.ChunkList.Chunk.Path.split('/').reverse()[0];
                is_subtitle = true;
              } else {
                actual_filename = asset_.ChunkList.Chunk.Path; // normale
              }

              if (is_subtitle) {

                // se è un sottotitolo, cerco la foldername 
                if (typeof sourcemap_item.is_folder === 'undefined') { file_missing = true; continue; } // Skippo i files, mi interessano le cartelle...

                if (sourcemap_item.foldername !== asset_.ChunkList.Chunk.Path.split('/')[0]) { file_missing = true; continue; } // Non è la cartella giusta

                let is_inside_this_subfolder = false;

                // Controllo se nel contenuto esiste.
                for (let nes = 0; nes < sourcemap_item.content.length; nes++) {

                  let subfolder_file = sourcemap_item.content[nes];
                  if (typeof subfolder_file.is_folder !== 'undefined') continue; // Skippo ulteriori cartelle, non ci servono...

                  if (subfolder_file.filename === actual_filename) { is_inside_this_subfolder = true; break; }

                }

                if (!is_inside_this_subfolder) { file_missing = true; continue; }


              } else {

                // Controllo normale per i file SE non stiamo controllando una cartella, se il filename è diverso da quello analizzato e non è un sottotiolo, skippo.
                if (typeof sourcemap_item.is_folder !== 'undefined' && sourcemap_item.filename !== actual_filename && !is_subtitle) {
                  file_missing = true;
                  continue;
                }

              }

              let is_pkl = typeof asset_.PackingList !== 'undefined' ? { is_pkl: true } : {};
              simplified_assets.push({
                filename: asset_.ChunkList.Chunk.Path,
                uuid: asset_.Id,
                exists: true,
                path: path.join(folder_content, asset_.ChunkList.Chunk.Path).replace(/\\/g, '/'),
                ...is_pkl
              });
              file_missing = false; // Setto false, il file esiste.
              break;

              /*} else {
   
                file_missing = true;
   
              }*/
            }

            if (file_missing) {
              is_assetmap_ok = false;
              simplified_assets.push({
                filename: asset_.ChunkList.Chunk.Path,
                uuid: asset_.Id,
                exists: false,
                path: path.join(folder_content, asset_.ChunkList.Chunk.Path).replace(/\\/g, '/'),
              });
            }

          });

          // Inizializzo la response...
          var response = {
            assetmap: {
              status: is_assetmap_ok,
              uuid: resolved_sourcemap.assetmap_.Id,
              assets: simplified_assets
            },
            cpl_list: [],
          }

          var pkl_list = [];

          // console.log('> assetmap INITIED!' + assetmap_path);

          // ORA, le CPL sono indicate all'interno delle PKL, quindi per trovare le CPL cerco prima le PKL che ho trovato dall'assetmap.
          for (let i = 0; i < simplified_assets.length; i++)
            if (typeof simplified_assets[i].is_pkl !== 'undefined')
              pkl_list.push(simplified_assets[i].path);

          if (pkl_list.length === 0) {
            clearTimeout(timeout_promise_cpl);
            return reject_global({ error: "Couldn't find any PKL (Packing List) matching the Assetmap path  [ " + folder_content + " ]" })
          }

          //console.log('> lista PKL ok!' + pkl_list);

          var array_cpl_content = []; // Qua ci finiranno i JSON delle CPL trovate

          new Promise((resolve_cpls, reject_cpls) => {

            var count_pkl_index = 0;

            // FTP
            async.forEachOf(pkl_list, (pkl_filename, index_pkl, callback_cpl) => {


              // Prendo il contenuto della PKL
              const { credentials } = typeof options.is_ftp !== 'undefined' ? options : { credentials: {} };

              // prendo il contenuto dell'assetmap sfruttando la funzioncina ez che sta qua sotto yikes.
              easyFTPfileCheck(credentials, pkl_filename, 0).then(pkl_content => {

                xml2js.parseString(pkl_content, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, json_res) {

                  if (err) return reject_global({ error: 'An error occurred while reading the PKL (PakingList) content [' + pkl_filename + ']' });

                  var count_pklassets_index = 0;
                  let cpls_found_in_this_pkl = [];

                  if (typeof json_res.AssetList.Asset[0] === 'undefined') {

                    let asset_temp = json_res.AssetList.Asset;
                    json_res.AssetList.Asset = [];
                    json_res.AssetList.Asset[0].push(asset_temp);

                  }

                  // PENSO SERVA UNA PROMISE PERCHè JSON_RES VIENE SOVRASCRITTO DAL CICLO DOPO ASYNC PENSO IPOTIZZO A

                  // Ora, cerco la CPL \ le CPL di questa PKL. (per cpl, noi intendiamo tutti gli XML presenti e dovremo controllare quali di questi siano una CPL)
                  async.forEachOfLimit(json_res.AssetList.Asset, 99999, (asset_pkl, index_ass_pkl, callback_assets_pkl) => {

                    try {

                      // Può essere type text/xml oppure quello che esplicita CPL nel type, li checko entrambi tanto per esser sicuri.
                      if (asset_pkl.Type.toLowerCase().indexOf('xml') >= 0 || asset_pkl.Type.toLowerCase().indexOf('cpl') >= 0) {

                        let cpl_filename_path = "";

                        // Cerco la path della cpl dai miei asset già mappati
                        for (let x = 0; x < simplified_assets.length; x++)
                          if (simplified_assets[x].uuid === asset_pkl.Id) { cpl_filename_path = simplified_assets[x].path; break; }

                        // Se non trovo la CPL, esco
                        if (cpl_filename_path === "") { console.log('non ho la pathhh xD'); count_pklassets_index++; if (count_pklassets_index >= json_res.AssetList.Asset.length) return callback_assets_pkl(array_cpl_content); else { console.log('wow1'); return false; } }

                        // Apriamo la CPL prendiamo i dati
                        easyFTPfileCheck(credentials, cpl_filename_path, 0).then(cpl_content => {

                          cpl_content = cpl_content.replace(/<\w[a-zA-Z0-9_-]*:/g, "<");
                          cpl_content = cpl_content.replace(/<\/\w[a-zA-Z0-9_-]*:/g, '</');

                          xml2js.parseString(cpl_content, { explicitArray: false, explicitChildren: false, explicitRoot: true }, function (err_, json_res_cpl) {

                            // Stessa cosa del catch
                            // NON SAPPIAMO ANCORA SE SIA UNA CPL ACTUALLy---------------------------------------------------
                            //if (err) { console.log(err); count_pklassets_index++; if (count_pklassets_index >= json_res.AssetList.Asset.length) return callback_assets_pkl(array_cpl_content); else return false; };
                            if (!err_) {

                              if (typeof json_res_cpl.CompositionPlaylist !== 'undefined') {

                                // Se siamo qui, è una CPL... aggiungo il JSON nell'array e lo pusho così poi le operazioni per durata info ecc saranno identiche per ftp\local
                                array_cpl_content.push({ cpl_content: json_res_cpl, pkl_content: json_res, cpl_filename: cpl_filename_path });

                                // PER ORA LASCIO LA CALLBACK ALLA PRIMA CPL CHE TROVO PERCHè STA CREANDO UN CIFRO DI PROBLEMI NON SO COME FARE AAAAAAAAAAAAAAAAAAAAAAAAAAAAA
                                return callback_assets_pkl(array_cpl_content);

                              }

                            }

                            count_pklassets_index++;
                            if (count_pklassets_index >= json_res.AssetList.Asset.length) return callback_assets_pkl(array_cpl_content);

                          });

                        }).catch(err_cpl => {


                          count_pklassets_index++; if (count_pklassets_index >= json_res.AssetList.Asset.length) return callback_assets_pkl(array_cpl_content);
                          //return false;

                        });


                      } else {

                        count_pklassets_index++; if (count_pklassets_index >= json_res.AssetList.Asset.length) return callback_assets_pkl(array_cpl_content);
                        //return false;

                      }

                    } catch (idk_error) {

                      console.log(idk_error);

                      count_pklassets_index++; if (count_pklassets_index >= json_res.AssetList.Asset.length) return callback_assets_pkl(array_cpl_content);
                      //return false;

                    }



                  }, (callback_assets_cpl) => {

                    count_pkl_index++;

                    console.log(' [ ' + count_pkl_index + ' / ' + pkl_list.length + ' ] callback PKL ok!!!' + path.basename(folder_content));

                    if (count_pkl_index >= pkl_list.length) return callback_cpl(callback_assets_cpl);

                  });

                });

              }).catch(err => {

                return reject_global({ error: 'An error occurred while reading the PKL (PakingList) content [' + pkl_filename + ']' });

              });

            }, (cb_cpls) => {

              console.log(path.basename(folder_content) + '> lista CPL presa!');
              return resolve_cpls(cb_cpls);

            });


          }).then(resolved_cpls => {

            clearTimeout(timeout_promise_cpl);

            // ORA, QUA SE RESOLVED_CPLS sarà 0, non abbiamo trovato CPL quindi errore, altrimenti possiamo iniziare a leggerci le dimensioni ecc....
            if (resolved_cpls.length === 0) return reject_global({ error: "Couldn't locate any CPL in the Assets matching the folder path " + folder_content });

            try {

              var final_response = { ...response, cpl_list: [] };

              resolved_cpls.forEach((cpl_, index__) => {

                const parsed_cpl_content = JSON.parse(JSON.stringify(cpl_.cpl_content));

                let current_cpl_json = parsed_cpl_content.CompositionPlaylist;

                const title = typeof current_cpl_json.ContentTitleText !== 'undefined' ? current_cpl_json.ContentTitleText : current_cpl_json.AnnotationText;
                const split_title = title.split("_");

                if (typeof current_cpl_json.ReelList.Reel[0] === 'undefined' && typeof current_cpl_json.ReelList.Reel !== 'undefined') {
                  let temp = current_cpl_json.ReelList.Reel;
                  current_cpl_json.ReelList.Reel = [];
                  current_cpl_json.ReelList.Reel.push(temp);
                }

                let current_cpl_information = {
                  ContentTitleText: title,
                  uuid: current_cpl_json.Id,
                  reels: current_cpl_json.ReelList.Reel.length,

                  FPS: Number(typeof current_cpl_json.ReelList.Reel[0].AssetList.MainPicture !== 'undefined' ? current_cpl_json.ReelList.Reel[0].AssetList.MainPicture.EditRate.substr(0, 2) :
                    typeof current_cpl_json.ReelList.Reel[0].AssetList.MainStereoscopicPicture !== 'undefined' ? current_cpl_json.ReelList.Reel[0].AssetList.MainStereoscopicPicture.EditRate.substr(0, 2) :
                      typeof current_cpl_json.ReelList.Reel[0].AssetList.MainSound !== 'undefined' ? typeof current_cpl_json.ReelList.Reel[0].AssetList.MainSound.EditRate.substr(0, 2) : 1),

                  AspectRatio: typeof current_cpl_json.ReelList.Reel[0].AssetList.MainPicture !== 'undefined' ? current_cpl_json.ReelList.Reel[0].AssetList.MainPicture.ScreenAspectRatio :
                    typeof current_cpl_json.ReelList.Reel[0].AssetList.MainStereoscopicPicture !== 'undefined' ? current_cpl_json.ReelList.Reel[0].AssetList.MainStereoscopicPicture.ScreenAspectRatio : "",

                  ContentType: split_title[1].split("-")[0],
                  ScreenFormat: split_title[2],
                  Country: split_title[3].split("-")[0],
                  Subtitles: split_title[3].split("-")[1],
                  Version: split_title.reverse()[0],

                };

                let duration_in_frames = 0;
                let cpl_size = 0;

                let is_3d = false;
                let is_encrypted = false;

                // Operazioni sul singolo reel, tipo calcolo durata ecc...
                current_cpl_json.ReelList.Reel.forEach((reel, reel_index) => {

                  const keys_ = Object.keys(reel.AssetList);

                  if (keys_.includes('MainStereoscopicPicture')) is_3d = true;

                  if (!is_encrypted && reel_index === 0)
                    for (let n = 0; n < keys_.length; n++)
                      if (typeof reel.AssetList[keys_[n]].KeyId !== 'undefined') is_encrypted = true;

                  // Calcolo durata di questo reel e sommo.
                  for (let n = 0; n < keys_.length; n++) if (typeof reel.AssetList[keys_[n]].Duration !== 'undefined') { duration_in_frames += parseInt(reel.AssetList[keys_[n]].Duration); break; }

                  // Calcolo la dimensione della CPL per ogni elemento dei reel cercandolo nella sua PKL.
                  let temp_size = 0;
                  for (let n = 0; n < keys_.length; n++) {
                    for (let f = 0; f < cpl_.pkl_content.AssetList.Asset.length; f++) {

                      const item_asset_pkl = cpl_.pkl_content.AssetList.Asset[f];
                      if (item_asset_pkl.Id === reel.AssetList[keys_[n]].Id) { cpl_size += parseInt(item_asset_pkl.Size); break; }

                    }
                  }

                });

                current_cpl_information.pkl_uuid = cpl_.pkl_content.Id;
                current_cpl_information.IsEncrypted = is_encrypted;
                current_cpl_information.Is3D = is_3d;
                current_cpl_information.CplSize = cpl_size;
                current_cpl_information.DurationInFrames = duration_in_frames;
                current_cpl_information.Duration = parseInt(Number(duration_in_frames) / Number(current_cpl_information.FPS)) * 1000; // Moltiplico per averlo in millisecondi

                current_cpl_information.ingest_info = {
                  is_ftp: typeof options.is_ftp !== 'undefined',
                  credentials: typeof options.credentials !== 'undefined' ? options.credentials : {},
                  target: folder_content,
                  is_copy: typeof options.is_ftp === 'undefined' && folder_content.indexOf('/media/root') >= 0,
                  cpl_filename: path.basename(cpl_.cpl_filename)
                }

                final_response.cpl_list.push(current_cpl_information);

              });

              clearTimeout(timeout_promise_cpl);
              return resolve_global(final_response);

            } catch (error_cpl) {

              clearTimeout(timeout_promise_cpl);
              return reject_global({ error: 'BOOOOOOOOOOOOOOOO' })

            }



          }).catch(rejected_cpls => {

            clearTimeout(timeout_promise_cpl);
            return reject_global({});

          });

        }).catch(rejected_sourcemap => {

          clearTimeout(timeout_promise_cpl);
          return reject_global({});

        });

      }).catch(rejected_assetmap => {

        clearTimeout(timeout_promise_cpl);
        return reject_global({});

      });


    });

  }




  async function easyFTPfileCheck(ftp_credentials, filename, operation = 1) {

    // Operazioni:
    // 0 = dammi il contenuto.
    // 1 = controllami se esiste e basta.
    // 2 = controllami se esiste e dammi la size.

    // Attenzione, siccome non avevo voglia di rifare tutto il giro copia incollando e modificando il controllo pkl\cpl, se passo le ftp credentials vuote fa le operazioni
    // in locale, così non devo cambiare nulla xd

    return new Promise((resolve, reject) => {


      if (typeof ftp_credentials.username !== 'undefined') {
        /*
   
        //try {
        const clientBasic = new ftp_basic.Client();
        clientBasic.ftp.verbose = true;
   
        try {
   
          clientBasic.access({
            host: ftp_credentials.address,
            port: ftp_credentials.port,
            user: ftp_credentials.username,
            password: ftp_credentials.password,
          }).then(() => {
   
            switch (operation) {
   
              case 0:
   
                var buffer = new Buffer.from("");
                var stream = fs.createWriteStream(buffer);
                let content = "";
                clientBasic.downloadTo(stream, filename).then(() => {
   
   
                  //stream.on('data', (chunk) => { content += chunk });
                  //stream.once('close', () => { clientBasic.close(); return resolve(content) });
                }).catch(err => {
                  console.log(err);
                  return reject();
                });
                break;
   
              case 1:
                clientBasic.close();
                return resolve(true);
   
              default: client.close(); return reject();
   
            }
   
          }).catch(err => {
   
            console.log(err);
   
          });
   
        } catch (err) {
   
          console.log(err);
          return reject(err);
   
        }*/



        try {

          var c = new Client_FTP();
          c.on('ready', function () {

            switch (operation) {

              // ritorno contenuto file.
              case 0:
                c.size(filename, function (err, size) {

                  console.log(size + " > " + filename);

                  c.get(filename, function (err, stream) {

                    if (err) { c.destroy(); return reject(); }
                    let content = '';


                    new Promise((resolve_stream, reject_stream) => {

                      try {

                        //stream.pipe(process.stdout);

                        //stream.on('end', () => { console.log('chiusa'); return resolve_stream(content) })
                        stream.on('data', (chunk) => {

                          content += chunk.toString();
                          console.log(content.length + " ======== " + filename);
                          if (content.length >= size || content.length + 5 >= size) { c.destroy(); return resolve(content) }

                        });

                      } catch (err) {
                        console.log(err);
                        c.destroy()
                        return reject();
                      }

                    }).then(result_stream => {

                      return resolve(result_stream.toString());

                    }).catch(err => {

                      console.log(err);
                      return reject();

                    })

                  });
                });
                break;

              // Controllo esistenza
              case 1:
                c.get(filename, function (err, stream) {

                  c.end();

                  if (err) return resolve(false);
                  return resolve(true); // il file esiste.

                });

              // Operazione invalida.
              default:
                c.end();
                return reject();

            }

          });
          c.on('error', (err) => {

            c.end();
            return reject();

          })
          c.connect({
            host: ftp_credentials.address,
            port: ftp_credentials.port,
            user: ftp_credentials.username,
            password: ftp_credentials.password,
            keepalive: 30000,
          });

        } catch (error) {

          c.end();
          return reject();

        }

        /*try {
   
          const prefix_ftp = "ftp://" + ftp_credentials.username + ":" + ftp_credentials.password + "@" + ftp_credentials.address + ":" + ftp_credentials.port;
          const file_ = prefix_ftp + filename.replace(/\\/g, '/');
   
          let content = "";
          let buffer_ = new Buffer.from('');
   
          console.log(file_)
   
          getUri(file_, function (err, rs) {
   
            if (err) throw err;
   
   
            //let buffer_ = new Buffer.from("");
            //var stream = fs.createWriteStream(buffer_);
            rs.on('data', (data) => { content += data })
   
            //rs.on('data', (ch) => { console.log(ch) });
            rs.on('close', () => { return resolve(content) });
   
            rs.end();
   
   
            //stream.on('data', (chunk) => { content += chunk; });
            //stream.on('close', () => { return resolve(content) });
   
          });
   
   
        } catch (error) {
   
          return reject();
   
        }
   
  */




      } else {

        // le faccio in locale
        switch (operation) {

          case 0:
            return resolve(fs.readFileSync(filename).toString());

          case 1:
            return resolve(fs.existsSync(filename));

          default: return reject();



        }

      }

    })

  }

  app.post('/api/ingest/streameridcp', (req, res) => {

    const { payload } = req.body;

    let path_array = [];
    let allow_uuid = [];

    // Inizio a prendermi i percorsi
    payload.ingestList.forEach((assetmap) => {

      if (typeof assetmap.cpl_list !== 'undefined') {

        assetmap.cpl_list.forEach((cpl, index_cpl) => {

          if (index_cpl === 0) {

            if (cpl.ingest_info.is_copy)
              path_array.push(cpl.ingest_info.target);

            if (cpl.ingest_info.is_ftp) {

              // Se è ftp costruisco la url perchè php può farlo...
              const ftp_url = "ftp://" + cpl.ingest_info.credentials.username + ":" + cpl.ingest_info.credentials.password + "@" + cpl.ingest_info.credentials.address + ":" + cpl.ingest_info.credentials.port;
              path_array.push(ftp_url + cpl.ingest_info.target);

            }


          }

          allow_uuid.push(cpl.uuid);

        });

      }

    });

    let string_param = "";

    // generazione parametri uuid
    allow_uuid.forEach(uuid => {
      string_param += 'true ' + uuid + ' ';
    });

    path_array.forEach(path_ => {
      string_param += Buffer.from(path_).toString('base64') + ' ';
    });

    // Ora prendo la destinazione
    db.query("SELECT path FROM m_import_preset WHERE id = ?", [payload.destinationId], (qerr, result) => {

      string_param += result[0].path + ' ' + allow_uuid.length + ' ' + path_array.length + ' ';

      let cmd = "php ./StreamerIDCP/streamer_idcp.php " + string_param + "/dev/null 2>&1 &";

      initStreamerIDCP(cmd);
      asyncStreamerLinkCpl(payload.ingestList, result[0].path);

      return res.sendStatus(200);

    });

  });

  const initStreamerIDCP = async (string) => {

    console.log(string);

    const { exec } = __webpack_require__(63129);

    const ls = exec(string, function (error, stdout, stderr) {
      if (error) {
        console.log(error.stack);
        console.log('Error code: ' + error.code);
        console.log('Signal received: ' + error.signal);
      }
    });


    ls.on('exit', function (code) {

      // eseguo il link???
      console.log('ho finito di copiare.');

    });

  }


  async function asyncStreamerLinkCpl(ingestList, destination_path) {

    let count_assets = 0;

    async.forEachOf(ingestList, (asset, index, cb_main) => {

      new Promise((resolve, reject) => {

        let cpl_count = 0;

        async.forEachOf(asset.cpl_list, (cpl, index_cpl, cb_cpl) => {

          // verifico se già esiste
          db.query("SELECT ID FROM m_dcp WHERE FileAudio = ?", [cpl.uuid], (qerr, result) => {

            if (!qerr && result.length === 0) {

              let cpl_code = 0;

              // Nel link devo usare il nome della cartella così come è già nel datastore, in copia la posso ricreare come stabilito da codice

              const mustCopy = Number(cpl.ingest_info.is_copy || cpl.ingest_info.is_ftp); // Se è local sono entrambe false quindi sarà false e quindi 0

              const id_universal = cpl.uuid.substr(9, cpl.uuid.length).toUpperCase().replace(/-/g, '');
              const props_path = path.join(destination_path, cpl.ContentTitleText.split('_')[0].toUpperCase()).replace(/\\/g, '/').replace('/datastore/', ''); // path props
              const cplFolderName = mustCopy ? (cpl.ContentTitleText + "_" + cpl.uuid.substr(cpl.uuid.length - 5, cpl.uuid.length)) : cpl.ContentTitleText; //ultimi 5 caratteri della uuid.
              const ingest_path = mustCopy ? path.join(destination_path, cpl.ContentTitleText.split('_')[0].toUpperCase(), cplFolderName).replace(/\\/g, '/').replace('/datastore/', '') : cpl.ingest_info.target.replace('/datastore/', '').replace(/\\/g, '/') // TOLGO DATASTORE



              db.query("INSERT INTO m_dcp (Groupname, Code, Title, Year, Source, Filename, Fileaudio, RadioFileaudio, VideoFPS, VideoAspectRatio, MarkOut,Duration, Opener,String20,CreationDate,ModifyDate,  ID_Universal, Voice, SoundCode, String1,ExecutionMode , ShortMarkOut , Props, RefrainMixIn) VALUES " +
                "(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)"
                , [cpl.ContentType, cpl_code, cpl.ContentTitleText, new Date().getFullYear(), 1, ingest_path, cpl.uuid, cpl.pkl_uuid, cpl.FPS, cpl.AspectRatio, cpl.Duration, cpl.Duration, Number(cpl.Is3D), cpl.ingest_info.cpl_filename, getTimestamp(), getTimestamp(), id_universal,
                cpl.Country, cpl.Subtitles, cpl.ContentTitleText, Number(cpl.IsEncrypted), cpl.CplSize, props_path, mustCopy], (qerr, result) => {


                  if (!mustCopy) {

                    // Se è un link, devo metterla in verify da qui... per tutti i datastore
                    db.query("SELECT * FROM m_datastores ORDER BY id", (qerr, datastores) => {

                      let datastore_count = 0;

                      async.forEachOf(datastores, (datastore, index, callback_verify) => {

                        db.query("DELETE FROM m_streamercop_verify WHERE uuid = ? AND datastore_name = ?", [cpl.uuid, datastore.name], (qerr, deletee) => {

                          db.query("INSERT INTO m_streamercop_verify (uuid, id_cpl, progress, verify_status, folder, filename, error, datefrom, datastore_name, queued, modifydate, title) VALUES " +
                            "(?,?,?,?,?,?,?,?,?,?,?,?)", [cpl.uuid, result.insertId, 'TOVERIFY', '', cplFolderName, cpl.ingest_info.cpl_filename, 0, getTimestamp(), datastore.name, 0, getTimestamp(), cpl.ContentTitleText], (qerr, insert) => {

                              datastore_count++;
                              if (datastore_count >= datastores.length) return callback_verify(true);

                            });

                        });

                      }, (linkin_cb) => {

                        cpl_count++;
                        if (cpl_count >= asset.cpl_list.length) return cb_cpl();

                      })

                    });
                    //db.query("INSERT INTO m_streamercop" , (qerr, result) => {


                    //}); return;
                    return;

                  }

                  cpl_count++;
                  if (cpl_count >= asset.cpl_list.length) return cb_cpl();

                });

            } else {

              if (result.length > 0) {

                const mustCopy = Number(cpl.ingest_info.is_copy || cpl.ingest_info.is_ftp); // Se è local sono entrambe false quindi sarà false e quindi 0
                const props_path = path.join(destination_path, cpl.ContentTitleText.split('_')[0].toUpperCase()).replace(/\\/g, '/').replace('/datastore/', ''); // path props
                const cplFolderName = mustCopy ? (cpl.ContentTitleText + "_" + cpl.uuid.substr(cpl.uuid.length - 5, cpl.uuid.length)) : cpl.ContentTitleText; //ultimi 5 caratteri della uuid.
                const ingest_path = mustCopy ? path.join(destination_path, cpl.ContentTitleText.split('_')[0].toUpperCase(), cplFolderName).replace(/\\/g, '/').replace('/datastore/', '') : cpl.ingest_info.target.replace('/datastore/', '').replace(/\\/g, '/') // TOLGO DATASTORE

                // FACCIO L'UPDATE.. di cosa???? vediamo.
                db.query("UPDATE m_dcp SET RefrainMixIn = ?, Filename = ?, Props = ?, Duration = ? WHERE ID = ?", [mustCopy, ingest_path, props_path, cpl.Duration, result[0].ID], (qerr, result) => {

                  if (!mustCopy) {

                    // Se è un link, devo metterla in verify da qui... per tutti i datastore
                    db.query("SELECT * FROM m_datastores ORDER BY id", (qerr, datastores) => {

                      let datastore_count = 0;

                      async.forEachOf(datastores, (datastore, index, callback_verify) => {

                        db.query("DELETE FROM m_streamercop_verify WHERE uuid = ? AND datastore_name = ?", [cpl.uuid, datastore.name], (qerr, deletee) => {

                          db.query("INSERT INTO m_streamercop_verify (uuid, id_cpl, progress, verify_status, folder, filename, error, datefrom, datastore_name, queued, modifydate, title) VALUES " +
                            "(?,?,?,?,?,?,?,?,?,?,?,?)", [cpl.uuid, result.insertId, 'TOVERIFY', '', cplFolderName, cpl.ingest_info.cpl_filename, 0, getTimestamp(), datastore.name, 0, getTimestamp(), cpl.ContentTitleText], (qerr, insert) => {

                              datastore_count++;
                              if (datastore_count >= datastores.length) return callback_verify(true);

                            });

                        });

                      }, (linkin_cb) => {

                        cpl_count++;
                        if (cpl_count >= asset.cpl_list.length) return cb_cpl();

                      })

                    });
                    //db.query("INSERT INTO m_streamercop" , (qerr, result) => {


                    //}); return;
                    return;

                  }

                  cpl_count++;
                  if (cpl_count >= asset.cpl_list.length) return cb_cpl();

                });

              }

            }

          })

        }, (cb_cpl) => { return resolve(); });

      }).then(resolved => {

        count_assets++; if (count_assets >= ingestList.length) return cb_main();

      }, () => {

        // è async non ci frega di avere un feedback...
        return true;

      });

    });

  }


  function asyncWsBroadcast(message) {

    if (!wss) return false;

    wss.clients.forEach(function each(client) {
      if (client.readyState === WebSocket.OPEN) {
        client.send(JSON.stringify(message));
      }
    });

  }

  app.post('/api/scan/kdms', (req, res) => {

    const { payload } = req.body;

    recursive(payload.folder, function (err, files) {

      if (err) return res.sendStatus(500);
      let xmls = [];
      let zips = [];

      files.forEach(file => {
        if (path.basename(file).split('.').reverse()[0].toLowerCase() === 'xml') xmls.push({ filename: file, is_zip: false }); // Se è un XML lo aggiungo all'array.
        if (path.basename(file).split('.').reverse()[0].toLowerCase() === 'zip') zips.push(file); // Se è un XML lo aggiungo all'array.
      });


      let counter = 0;

      // Prima di entrare nel controllo, mi servono i dati dei nostri IMB
      db.query("SELECT a.id, a.name, b.type, b.serial, b.kdm_serial, c.kdm_serial as kdm_serial_audio, c.serial as audio_serial FROM m_theaters a LEFT JOIN m_imb b on b.id = a.id_imb LEFT JOIN m_audioprocessor c on c.id = a.id_audioprocessor WHERE b.kdm_serial<>'' ORDER BY a.theater_nr", (qerr, result) => {

        var kdm_result_array = [];
        // PROMISE PER GLI ZIP E AGGIUNGO TUTTO A XMLS
        new Promise((resolve_zips, reject_zips) => {

          if (zips.length === 0) return resolve_zips(xmls); // Se non ho Zips, la lista xMLS resta identica.

          // Verifico se già esiste la temp folder per le KDM
          if (!fs.existsSync(path.join(os.tmpdir(), 'kdm_extracted'))) fs.mkdirSync(path.join(os.tmpdir(), 'kdm_extracted'));

          let count_zip = 0;

          async.forEachOf(zips, (zip_, index_zip, callback_zip) => {

            // Leggo gli zip e cerco gli XML, li trovo, li leggo, se sono KDM allora 
            fs.createReadStream(zip_.replace(/\\/g, '/'))
              .pipe(unzipper.Parse())
              .on('entry', function (entry) {

                if (entry.path.split('.').reverse()[0].toLowerCase() === 'xml') {

                  const extract_path = path.join(os.tmpdir(), 'kdm_extracted', path.basename(entry.path));

                  var stream = fs.createWriteStream(extract_path);
                  entry.pipe(stream);

                  stream.on('close', () => {

                    // Estratto
                    console.log('draingang')
                    entry.autodrain();

                  })

                  xmls.push({ filename: extract_path, is_zip: true, internal_path: entry.path });

                } else {

                  entry.autodrain();

                }

              }).on('close', function () {

                count_zip++;
                if (count_zip >= zips.length) return callback_zip(xmls);

              });

          }, (cb_zip) => {

            return resolve_zips(cb_zip);

          });


        }).then(resolved_zips => {

          async.forEachOf(resolved_zips, (single_xml, index_xml, callback) => {

            //if (single_xml.is_zip) { counter++; if (counter >= xmls.length) return callback(kdm_result_array); }

            // DA METTERE UNA PROMISE PERCHè SE SINGLE_XML.IS_ZIP è DEFINED SIGNIFICA CHE DOBBIAMO PRENDERE IL CONTENUTO DELLA KDM DALLO ZIP.
            let content_xml = fs.readFileSync(single_xml.filename).toString();

            content_xml = content_xml.replace(/<\w[a-zA-Z0-9_-]*:/g, "<").replace(/<\/\w[a-zA-Z0-9_-]*:/g, '</');

            xml2js.parseString(content_xml, { explicitArray: false, explicitChildren: false, explicitRoot: true }, function (err, json_res) {

              if (!err) {

                if (json_res !== null && typeof json_res['DCinemaSecurityMessage'] !== 'undefined') {



                  // è una KDM, prendo il certificate serial e verifico se fa parte di uno dei nostri IMB
                  const certificate_serial_kdm = json_res.DCinemaSecurityMessage.AuthenticatedPublic.RequiredExtensions.KDMRequiredExtensions.Recipient.X509IssuerSerial.X509SerialNumber;
                  let index_theater_matching = -1;

                  let is_audioprocessor = false;

                  //console.log(json_res.DCinemaSecurityMessage.AuthenticatedPublic.RequiredExtensions.KDMRequiredExtensions.ContentTitleText);

                  for (let i = 0; i < result.length; i++) {

                    if (certificate_serial_kdm.toString() === result[i].kdm_serial.toString()) { index_theater_matching = i; break; }

                    // Controllo anche l'audio
                    if (certificate_serial_kdm.toString() === result[i].kdm_serial_audio.toString()) { index_theater_matching = i; is_audioprocessor = true; break; }

                  }

                  // Abbiamo un match
                  if (index_theater_matching >= 0) {

                    const valid_from = json_res.DCinemaSecurityMessage.AuthenticatedPublic.RequiredExtensions.KDMRequiredExtensions.ContentKeysNotValidBefore;
                    const valid_to = json_res.DCinemaSecurityMessage.AuthenticatedPublic.RequiredExtensions.KDMRequiredExtensions.ContentKeysNotValidAfter;
                    const uuid_cpl_from_kdm = json_res.DCinemaSecurityMessage.AuthenticatedPublic.RequiredExtensions.KDMRequiredExtensions.CompositionPlaylistId;

                    // Devo controllare se abbiamo la CPL per questa KDM in m_dcp.
                    db.query("SELECT ID FROM m_dcp WHERE Fileaudio = ?", [uuid_cpl_from_kdm], (qerr, result_dcp) => {

                      kdm_result_array.push({
                        imb_type: result[index_theater_matching].type,
                        id_kdm: json_res.DCinemaSecurityMessage.AuthenticatedPublic.MessageId,
                        id_theater: result[index_theater_matching].id,
                        imb_serial: !is_audioprocessor ? result[index_theater_matching].serial : result[index_theater_matching].audio_serial,
                        is_audioprocessor: is_audioprocessor,
                        imb_certificate: !is_audioprocessor ? result[index_theater_matching].kdm_serial : result[index_theater_matching].kdm_serial_audio,
                        kdm_path: single_xml.filename.replace(/\\/g, '/'),
                        ContentTitleText: typeof json_res.DCinemaSecurityMessage.AuthenticatedPublic.RequiredExtensions.KDMRequiredExtensions.ContentTitleText !== 'undefined' ? json_res.DCinemaSecurityMessage.AuthenticatedPublic.RequiredExtensions.KDMRequiredExtensions.ContentTitleText : 'n/a',
                        ValidFrom: valid_from,
                        ValidTo: valid_to,
                        theater: result[index_theater_matching].name,
                        uuid_cpl: uuid_cpl_from_kdm,
                        expired: new Date().getTime() >= new Date(valid_to).getTime(), // Se la KDM è scaduta, la flaggo come expired
                        exists_cpl: !qerr && result.length === 1
                      });

                      counter++; if (counter >= xmls.length) return callback(kdm_result_array);

                    });

                  } else {

                    // Non è di nessun nostro proiettore.
                    counter++; if (counter >= xmls.length) return callback(kdm_result_array);

                  }

                } else {

                  // Non è una KDM.
                  counter++; if (counter >= xmls.length) return callback(kdm_result_array);

                }

              } else {

                // Non son riuscito a parsare l'xml... in json
                counter++; if (counter >= xmls.length) return callback(kdm_result_array);

              }

            });


          }, (cb_data) => {

            if (cb_data === null || cb_data.length === 0) return res.status(200).send([]); // Nessuna KDM trovata xd

            // ORGANIZZO PER UUID CPL
            let uuid_indexes = [];
            let compiled_array = [];

            cb_data.forEach(kdm => {

              let current_index = 0;

              if (!uuid_indexes.includes(kdm.uuid_cpl)) {
                uuid_indexes.push(kdm.uuid_cpl);
                current_index = uuid_indexes.length - 1;
              } else {
                for (let x = 0; x < uuid_indexes.length; x++) { if (uuid_indexes[x] === kdm.uuid_cpl) { current_index = x; break; } }
              }

              if (typeof compiled_array[current_index] === 'undefined') compiled_array[current_index] = { uuid: kdm.uuid_cpl, ContentTitleText: kdm.ContentTitleText, kdms: [] };
              compiled_array[current_index].kdms.push(kdm);

            });

            return res.status(200).send(compiled_array);

          });


        }).catch(error_zips => {

          console.log(error_zips)
          return res.sendStatus(500);

        })

      })

    });

  });


  app.post('/api/ingest/kdms', (req, res) => {

    const { payload } = req.body;

    let kdm_done = 0;

    let websocket_progress = [];

    // Prima di scrivere la tabella KDM, devo copiare le KDM nei datastore.
    async.forEachOf(payload.kdms, (kdm, index, callback) => {

      websocket_progress[index] = { id: kdm.id, progress: 0 }; // Inizializzo
      asyncWsBroadcast({ type: 'KDM_PROGRESS', body: websocket_progress });

      new Promise((resolve, reject) => {

        const path_to_remote = path.join('/datastore/KDM', path.basename(kdm.kdm)).replace(/\\/g, '/');

        let datastore_count = 0;

        db.query("SELECT * FROM m_datastores", (qerr, result) => {

          let has_error = false;

          async.forEachOf(result, (datastore, index_datastore, callback_datastore) => {

            let sftp = new ClientSFTP();

            sftp.connect({
              host: datastore.address,
              port: '22',
              username: datastore.username,
              password: datastore.password,
              readyTimeout: 2500,
              retries: 0,
            }).then(() => {

              sftp.put(kdm.kdm, path_to_remote);

              datastore_count++;

              websocket_progress[index] = { id: kdm.id, progress: (100 / result.length) * datastore_count, error: has_error }; // Inizializzo
              asyncWsBroadcast({ type: 'KDM_PROGRESS', body: websocket_progress });

              if (datastore_count >= result.length) return resolve(has_error);

            }).catch(err => {

              if (index_datastore === 0) has_error = true;

              datastore_count++;
              websocket_progress[index] = { id: kdm.id, progress: (100 / result.length) * datastore_count, error: has_error }; // Inizializzo
              asyncWsBroadcast({ type: 'KDM_PROGRESS', body: websocket_progress });

              if (datastore_count >= result.length) { console.log('chiamo callback'); return resolve(has_error); }

            });

          }, () => {

            console.log('callback datastore');
            return resolve(); // Abbiamo copiato la KDM su tutti, chiamo il resolve della Promise

          })

        })

      }).then(resolved => {



        // Scrivo nel database
        if (resolved) {

          // Abbiamo copiato la KDM su tutti i datastore...
          kdm_done++;
          if (kdm_done >= payload.kdms.length) {

            asyncWsBroadcast({ type: 'KDM_PROGRESS', body: websocket_progress });
            return res.status(200).send({}); // OK!

            //return callback();

          }

        } else {

          // Rimuovo il record per questa KDM id
          db.query("DELETE FROM kdm WHERE id_kdm = ?", [kdm.id], (qerr, result_delete) => {

            db.query("INSERT INTO kdm (filename, folder, serial, projectorid, progress, startdate, enddate, uuid, modifydate, id_kdm) VALUES" +
              "(?,?,?,?,?,?,?,?,?, ?)", [path.basename(kdm.kdm), 'KDM/', kdm.imb_serial, kdm.imb_certificate, 1, new Date(kdm.valid_from).toMysqlFormat(), new Date(kdm.valid_to).toMysqlFormat(), kdm.cpl_id, getTimestamp(), kdm.id], (qerr, result_ins) => {

                // Abbiamo copiato la KDM su tutti i datastore...
                kdm_done++;
                if (kdm_done >= payload.kdms.length) {

                  asyncWsBroadcast({ type: 'KDM_PROGRESS', body: websocket_progress });
                  return res.status(200).send({}); // OK!

                  //return callback();

                }

              });

          })

        }


      }).catch(err => {

        console.log('catched')
        kdm_done++;
        if (kdm_done >= payload.kdms.length) {

          asyncWsBroadcast({ type: 'KDM_PROGRESS', body: websocket_progress });
          return res.status(200).send({}); // OK!
          // return callback();

        }

      });

    }, () => {

      // Callback finale
      asyncWsBroadcast({ type: 'KDM_PROGRESS', body: websocket_progress });
      return res.status(200).send({}); // OK!

    })


  });

  app.post('/api/upload/browserkdm', (req, res) => {

    //const { payload } = req.body;
    const files = req.files;

    const payload = req.body;

    const folder_ = path.join(os.tmpdir(), Buffer.from(payload.temp_folder.toString()).toString('base64'));
    if (!fs.existsSync(folder_)) fs.mkdirSync(folder_);

    let count_files = 0;

    async.forEachOf(files, (file, index, callback) => {

      const path_to = path.join(folder_, file.name);
      file.mv(path_to, (error) => {

        if (error) {

        }

        count_files++; if (count_files >= Object.keys(files).length) {


          //return callback();
          return res.status(200).send({ folder: folder_ })

        }

      })

    }, (cb) => {

      return res.status(200).send({ folder: folder_ })

    });

  });


  app.get('/api/get/verifystatus', (req, res) => {

    db.query("SELECT a.* , b.Title as TitleDcp, b.ID as id_dcp FROM m_streamercop_verify a LEFT JOIN m_dcp b on b.Fileaudio = a.uuid WHERE b.Title is NOT NULL ORDER BY b.Title", (qerr, result) => {

      if (qerr) return res.status(200).send([]);
      return res.status(200).send(result);

    })

  });

  app.post('/api/ingest/verifydatastore', (req, res) => {

    const { payload } = req.body;

    db.query("UPDATE m_streamercop_verify SET progress = 'TOVERIFY', queued = '0' , datefrom = ?, verify_status='', error = 0  WHERE datastore_name = ? ", [getTimestamp(), payload.datastore_name], (qerr, result) => {

      if (qerr) return res.sendStatus(500);

      return res.sendStatus(200);

    })

  });

  app.get('/api/get/transfered', (req, res) => {

    db.query("SELECT a.datefrom, a.progress, a.uuid, a.description , a.progress_perc , c.name , d.Title as title FROM clips a LEFT JOIN m_imb b on b.serial = a.serial LEFT JOIN m_theaters c on c.id_imb = b.id LEFT JOIN m_dcp d on d.Fileaudio = a.uuid WHERE (a.progress NOT LIKE 'VERIFIED' AND a.progress NOT LIKE 'ERRORVERIFY' AND a.progress NOT LIKE 'TOVERIFY') AND c.name IS NOT NULL AND d.Title is not null ORDER BY a.title", (qerr, result) => {

      // Ora, cerco gli imb che hanno la certificazione x datastore
      db.query("SELECT a.id, a.type, b.name, c.name as theater_name FROM m_imb a LEFT JOIN m_datastores b on b.id = a.id_datastore LEFT JOIN m_theaters c on c.id_imb = a.id WHERE a.type = 'HULA' GROUP BY a.id_datastore", (qerr, imbs) => {


        if (imbs.length === 0) {

          if (qerr) return res.status(200).send([]);
          return res.status(200).send(result);

        } else {

          let count_imbs = 0;


          // Devo piglia la listaaa
          async.forEachOf(imbs, (datastore, index, callback) => {

            db.query("SELECT a.name FROM m_theaters a LEFT JOIN m_imb b on b.id = a.id_imb LEFT JOIN m_datastores c on c.id = b.id_datastore WHERE b.type = ? and c.name = ?", [datastore.type, datastore.name], (qerr, result_mult) => {

              const serial = datastore.type + "-" + datastore.name;
              db.query("SELECT a.datefrom, a.progress, a.uuid, a.description , a.progress_perc , '' as name , d.Title as title FROM clips a LEFT JOIN m_dcp d ON d.Fileaudio = a.uuid WHERE serial = ?", [serial], (qerr, result_) => {

                let response = [];

                // Ora, questi record vanno moltiplicati per il numero di teatri con HULA
                result_.forEach((clip_record, indexx) => {
                  result_mult.forEach(multi => {
                    //result_[indexx].name = multi.name;     
                    response.push({ title: clip_record.title, datefrom: clip_record.datefrom, progress: clip_record.progress, progress_perc: clip_record.progress_perc, uuid: clip_record.uuid, name: multi.name })
                  });
                })

                result = result.concat(response);

                count_imbs++;
                if (count_imbs >= imbs.length) return callback(result);

              });

            })

          }, (final) => {

            return res.status(200).send(final);

          })

        }

      });

    });

  });

  function gdcAPI(command, address, port, options = {}) {

    return new Promise((resolve, reject) => {

      // faccio la richiesta per il gdc
      var nc2 = new NetcatClient();
      let command_buffer = [];

      let serial_request = "";

      switch (command) {

        case 'get_cpllist':
          serial_request = '<?xml version="1.0" encoding="UTF-8" ?><command version="2.2" cmd="GET_CPL_LIST" list_all="false"storage="primary"/>'; break;

        case 'get_cpl':
          serial_request = '<?xml version="1.0" encoding="UTF-8" ?><command version="2.2" cmd="GET_CPL"><cpl_uuid>' + options.uuid + '</cpl_uuid></command>'; break;

        case 'get_kdmlist':
          serial_request = '<?xml version="1.0" encoding="UTF-8" ?><command version="2.2" cmd="GET_KDM_LIST" />'; break;

        case 'get_kdm':
          serial_request = '<?xml version="1.0" encoding="UTF-8" ?><command version="2.2" cmd="GET_KDM"><asset_uuid>' + options.id + '</asset_uuid></command>'; break;

        case 'delete_kdm':
          serial_request = '<?xml version="1.0" encoding="UTF-8" ?><command version="2.2" cmd="DELETE_FILE"><asset_uuid>' + options.id + '</asset_uuid></command>'; break;

        case 'ingest_kdm':
          serial_request = '<?xml version="1.0" encoding="UTF-8" ?><command version="2.2" cmd="INGEST_FILE"><asset_type>KDM</asset_type><file_content>' + options.kdm64 + '</file_content></command>'; break;

      }

      if (serial_request === "") {
        console.log('yay'); return reject();
      }

      let header = getGdcHeader(serial_request);
      let cmd_buffer = Buffer.from(serial_request);
      let array_buffers = [header, cmd_buffer];
      let cmd = Buffer.concat(array_buffers);

      let xml_serial = "";
      let buffer_array_serial = [];
      let timeout_seriale = [];

      nc2.addr(address.toString()).port(Number(port)).connect().send(cmd).on('error', (err_) => {

        console.log(err_)
        return reject();

      }).on('data', (data) => {

        clearTimeout(timeout_seriale);
        buffer_array_serial.push(data);
        timeout_seriale = setTimeout(() => { nc2.close(); }, 1000);

      }).on('close', () => {

        let serial_concat = Buffer.concat(buffer_array_serial);
        let xml_response = serial_concat.slice(20, serial_concat.length).toString();

        if (xml_response[0] !== '<') xml_response = xml_response.substr(1, xml_response.length);

        xml2js.parseString(xml_response, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, json_res) {

          if (err || json_res === null) { return reject(); }



          return resolve(json_res);

        });

      });



    })


  }

  app.post('/api/resync/imb', (req, res) => {

    const { payload } = req.body;

    if (payload.theater === 'ALL THEATERS') {

      // async foreach per teatro\imb
      db.query("SELECT a.id, a.name, b.type, b.serial, b.address as imb_address, b.port as imb_port, b.api_username, b.api_password , c.address as datastore_address, c.username, c.password, c.hula_store_docker, c.name as datastore_name FROM m_theaters a LEFT JOIN m_imb b ON b.id = a.id_imb LEFT JOIN m_datastores c ON c.id = b.id_datastore ORDER BY a.theater_nr", [payload.theater], (qerr, result) => {

        let count_ = 0;

        async.forEachOf(result, (theater, index, callback) => {

          resyncCPLonIMB(theater).then(syncc => {

            count_++; if (count_ >= result.length) return res.sendStatus(200);

          }).catch(err => {

            console.log(theater.name + " errore!");
            count_++; if (count_ >= result.length) return res.sendStatus(200);

          })


        }, () => {

          return res.sendStatus(200);

        })

      });

    } else {

      // prendo il singolo teatro\imb
      db.query("SELECT a.id, a.name, b.type, b.serial, b.address as imb_address, b.port as imb_port, b.api_username, b.api_password , c.address as datastore_address, c.username, c.password, c.hula_store_docker, c.name as datastore_name FROM m_theaters a LEFT JOIN m_imb b ON b.id = a.id_imb LEFT JOIN m_datastores c ON c.id = b.id_datastore WHERE a.name = ?", [payload.theater], (qerr, result) => {

        resyncCPLonIMB(result[0]).then(syncc => {

          return res.sendStatus(200);

        }).catch(err => {

          return res.status(500).send({ error: err });

        })

      })

    }

  });


  function resyncCPLonIMB(info) {

    return new Promise((resolve, reject) => {

      console.log('inizio ->' + info.name);

      // Controlli vari su indirizzi ecc...
      if (info.type !== 'HULA') {

        // dati che ci servono per fare il resync: indirizzo porta imb, username password imb
        if (info.imb_address === '' || info.imb_port === '') return reject({ error: 'Cannot resync IMB for ' + info.name + ' because it does not have an Address and/or a Port configured.' });

      } else {

        // dati che ci servono per fare il resync: indirizzo datastore, username password datastore, nome docker hula store.
        if (info.datastore_address === '' || info.hula_store_docker === '') return reject({ error: 'Cannot resync IMB for ' + info.name + ' because it does not have an Address and/or a HULA docker store configured.' });

      }

      let universal_list = [];

      // PRENDO I DATI CLIPS PER QUESTO TEATRO.
      new Promise((resolve_list, reject_list) => {

        switch (true) {

          // BARCO DOLBY HANNO LE STESSE API GROSSOMODO QUINDI LE FACCIO ASSIEME.
          case info.type === 'BARCO' || info.type.toLowerCase().indexOf('dolby') >= 0:
            new Promise((resolve_imb, reject_imb) => {

              soapLogin(info.type, info.imb_address, info.imb_port, info.api_username, info.api_password, agent).then(login => {

                if (info.type === 'BARCO') {

                  // RESYNC BARCO
                  soapAPI(info.type, info.imb_address, info.imb_port, 'get_cpllist', agent).then(list => {

                    xml2js.parseString(list, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, list) {

                      if (err) return reject_imb({ error: 'IMB response failed on parse for ' + info.name });

                      // rendo la lista uniforme per tutti.
                      let parsed_list = list['SOAP-ENV:Body']['ns1:GetCplListResponse']['ns1:list']['ns1:CplInformation'];

                      parsed_list.forEach(cpl => {

                        universal_list.push({
                          id: 'urn:uuid:' + cpl['ns1:Id'], valid: cpl['ns1:Integrity'] === 'Valid' && Number(cpl['ns1:Error']) === 0,
                          filename: cpl['ns1:RemoteStorage'], title: cpl['ns1:Title']
                        });

                      });

                      soapAPI(info.type, info.imb_address, info.imb_port, 'logout', agent).then(logout => {

                        return resolve_imb(universal_list);

                      });

                    });

                  }).catch(err_api => {

                    console.log(err_api)

                    return reject({ error: 'IMB API have failed for ' + info.name });

                  });



                } else {

                  // Resync DOLBY
                  xml2js.parseString(login, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, json_res) {

                    if (!json_res['SOAP-ENV:Body']['ns1:LoginResponse'].sessionId) {
                      return reject({ error: 'login_failed' });
                    }
                    const dolby_session = json_res['SOAP-ENV:Body']['ns1:LoginResponse'].sessionId;
                    //console.log(dolby_session);
                    soapAPI(info.type, info.imb_address, info.imb_port, 'get_cpllist', agent, dolby_session).then(list => {

                      xml2js.parseString(list, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, list) {

                        let parsed_list = list['SOAP-ENV:Body']['ns1:GetCPLListInfoResponse']['cplList']['cpl:cplInfo'];
                        parsed_list.forEach(cpl => {

                          universal_list.push({
                            id: cpl['cpl:uuid'], valid: cpl['cpl:playable'] === 'true', filename: '', title: cpl['cpl:contentTitleText']
                          });

                        });

                        soapAPI(info.type, info.imb_address, info.imb_port, 'logout', agent, dolby_session).then(list => {

                          return resolve_imb(universal_list);

                        });

                      });

                    }).catch(error_api => {

                      return reject_imb({ error: 'IMB API have failed for ' + info.name });

                    });

                  });



                }

              }).catch(error_login => {

                return reject({ error: 'IMB Login has failed for ' + info.name });

              })


            }).then(resolved_imb => {

              return resolve_list(resolved_imb);

            }).catch(rejected_imb => {

              return reject();

            }); break;


          // RESYNC CON HULA STORE
          case info.type === 'HULA':
            new Promise((resolve_imb, reject_imb) => {

              // devo connettermi al datastore di questo imb e chiedere la lista al docker hula store....              
              var conn = new Client();
              var output = "";

              conn.on('ready', function () {

                conn.exec("docker -H :3000 exec " + info.hula_store_docker + " hl-asset.py --get-asset-list", function (err, stream) {

                  //if (err) throw err;
                  stream.on('close', function (code, signal) {

                    //conn.end();
                    // output dovrà contenere la lista di TUTTI gli asset registrati senza urn:uuid: , quindi, io per ogni CPL mia posso solamente controllare che la roba in m_dcp sia certificata per questo hula
                    const assetList = output.split('\n');

                    // Prendo la lista delle dcp 
                    db.query("SELECT ID , Fileaudio , Radiofileaudio, String20 , Filename , Title FROM m_dcp ORDER BY ID", (qerr, result) => {

                      let count_dcp = 0;

                      conn.sftp((err, sftp) => { // Apro la connesssione SFTP sul server

                        // devo leggere tutti gli asset della CPL sul datastore dell'IMB e, se tutti gli uuid della cpl sono presenti nel nostro array allora è complete altrimenti ne mancano.
                        async.forEachOf(result, (dcp, index, callback_dcp) => {

                          // Non abbiamo il filename della CPL
                          if (dcp.String20 === '') { count_dcp++; if (count_dcp >= result.length) return callback_dcp(universal_list); return; }

                          const cpl_path = '/' + path.join('datastore', dcp.Filename, dcp.String20).replace(/\\/g, '/');

                          let cpl_content = "";

                          try {

                            // COnnessione sftp fallita.
                            if (err) { if (dcp.Title === 'ALPHA') console.log(err); count_dcp++; if (count_dcp >= result.length) return callback_dcp(universal_list); } else {

                              // Verifico che esista il file
                              sftp.stat(cpl_path, (error_stat, stats) => {

                                // Il file non esiste.
                                if (error_stat) { count_dcp++; if (count_dcp >= result.length) return callback_dcp(universal_list); return; }

                                // Creo uno stream di lettura della CPL sul server remoto
                                let stream_cpl = sftp.createReadStream(cpl_path);

                                stream_cpl.on('data', (chunk) => {
                                  cpl_content += chunk; // Leggo i chunk della CPL.
                                })

                                stream_cpl.on('end', () => {

                                  // regex per pulire la cpl come sempre
                                  cpl_content = cpl_content.replace(/<\w[a-zA-Z0-9_-]*:/g, "<");
                                  cpl_content = cpl_content.replace(/<\/\w[a-zA-Z0-9_-]*:/g, '</');

                                  // abbiamo il contenuto della CPL...
                                  xml2js.parseString(cpl_content, { explicitArray: false, explicitChildren: false, explicitRoot: true }, function (err, cpl_json) {

                                    // Errore lettura CPL
                                    if (err || typeof cpl_json.CompositionPlaylist === 'undefined') { count_dcp++; if (count_dcp >= result.length) return callback_dcp(universal_list); return; }

                                    // leggo gli asset
                                    if (typeof cpl_json.CompositionPlaylist.ReelList.Reel[0] === 'undefined')
                                      cpl_json.CompositionPlaylist.ReelList.Reel = [cpl_json.CompositionPlaylist.ReelList.Reel];

                                    // Tipi di asset del reel
                                    let asset_keys = Object.keys(cpl_json.CompositionPlaylist.ReelList.Reel[0].AssetList);
                                    let current_cpl_assets_id = [];

                                    cpl_json.CompositionPlaylist.ReelList.Reel.forEach(asset => {

                                      asset_keys.forEach(key => {

                                        if (typeof asset.AssetList[key] === 'undefined') { count_dcp++; if (count_dcp >= result.length) return callback_dcp(universal_list); return; }

                                        if (key.indexOf('CompositionMetadataAsset') < 0) // DEVO SALTARE COMPOSITIONMETADATAASSET, NON CI INTERESSA
                                          current_cpl_assets_id.push(asset.AssetList[key].Id.substr(9, asset.AssetList[key].Id.length)); // levo urn:uuid:

                                      });

                                    });

                                    let valid = true;
                                    // Verifico se tutti i suoi asset siano certificati dall'HULA store.
                                    for (let x = 0; x < current_cpl_assets_id.length; x++) {
                                      // console.log(current_cpl_assets_id[x]);
                                      if (!assetList.includes(current_cpl_assets_id[x])) {
                                        valid = false; break;
                                      }
                                    }

                                    // CONTROLLO ANCHE L'ID DELLA CPL!
                                    if (!assetList.includes(cpl_json.CompositionPlaylist.Id.replace('urn:uuid:', ''))) valid = false;

                                    //console.log(dcp.Title + ' > ' + valid)
                                    // Pusho questa CPL come valida x Clips
                                    universal_list.push({
                                      id: dcp.Fileaudio, valid: valid, filename: cpl_path, title: dcp.Title
                                    });

                                    count_dcp++; if (count_dcp >= result.length) return callback_dcp(universal_list);

                                  });

                                });

                              })

                            }

                            //stream_.on('error', (err) => { console.log(err); count_dcp++; if (count_dcp >= result.length) return callback_dcp(universal_list); return; });

                          } catch (err) {

                            if (dcp.Title === 'ALPHA') console.log(err)

                            count_dcp++; if (count_dcp >= result.length) return callback_dcp(universal_list);

                          }



                        }, (list_) => {

                          return resolve_imb(list_)

                        });

                      });

                    });


                  }).on('data', function (data) {

                    output = output + data;

                  });


                });
                conn.on('error', () => { return reject({ error: 'Connection to HULA store failed for ' + info.name }) });
              }).connect({
                host: info.datastore_address,
                port: 22,
                username: info.username,
                password: info.password
              });


            }).then(resolved_imb => {

              return resolve_list(resolved_imb); // sparo la lista alla promise principale...

            }).catch(error_imb => {

              //console.log(error_imb);
              return reject_imb({ error: 'IMB API have failed for ' + info.name });

            }); break;

          case info.type === 'GDC':
            new Promise((resolve_imb, reject_imb) => {

              gdcAPI('get_cpllist', info.imb_address, info.imb_port).then(list => {

                // Ho la lista completa di tutte le CPL sul disco GDC
                // Ora prendo il contenuto per ottenere i dati.
                let count_cpl = 0;

                // Purtroppo le API del gdc non ci forniscono i dettagli delle CPL come Barco e Dolby.. Quindi non possiamo sapere tutto purtroppo
                // Richiedere tutte le CPL è risultato in un load di richieste a cui dopo un tot ha smesso di rispondere quindi non si può fare...

                list.cpl_uuid.forEach(uuid_cpl => {

                  universal_list.push({
                    id: uuid_cpl['_'], valid: true, filename: '', title: ''
                  });

                });

                return resolve_imb(universal_list);




              }).catch(err => {

                console.log('what')
                console.log(err);
                return reject_imb({ error: 'IMB API have failed for ' + info.name });

              });

            }).then(resolved_imb => {

              return resolve_list(resolved_imb); // sparo la lista alla promise principale...

            }).catch(error_imb => {

              console.log(error_imb);

              return reject({ error: 'IMB API have failed for ' + info.name });

            }); break;


          default: return reject(); // Nessun IMB Valido per il resync

        }

      }).then(resolved_imb => {

        // analisi universale per tutti resync unico 

        let count_insert = 0;
        let to_update_complete = [];

        // Dobbiamo scrivere il seriale del datastore HULA... se è un HULA..
        if (info.type === 'HULA') {

          info.serial = info.type + '-' + info.datastore_name;

        }


        // cancello la lista clips e riscrivo questa, tengo solamente le clips che sarebbero da ingestare\running\loaded, quelle le aggiorno solamente se sono state caricate.
        db.query("DELETE FROM clips WHERE serial = ? AND progress NOT LIKE 'RUNNING' AND progress NOT LIKE 'LOADED' AND progress NOT LIKE 0 AND progress NOT LIKE 1 ", [info.serial], (qerr, result_delete) => {

          // Prendo i record senza quelli complete\error
          db.query("SELECT * FROM clips WHERE serial = ?", [info.serial], (qerr, result_clips) => {

            async.forEachOf(resolved_imb, (item, index, callback) => {

              // cerco se abbiamo il record di questa
              let exists_in_clips = false;

              for (let i = 0; i < result_clips.length; i++) {
                if (result_clips[i].uuid === item.id) {
                  // Esiste, quindi dopo farò l'update
                  to_update_complete.push({ id_clips: result_clips[i].id, valid: item.valid }); exists_in_clips = true; break;
                }
              }

              if (exists_in_clips || !item.valid) { count_insert++; if (count_insert >= resolved_imb.length) return callback(to_update_complete); return; } // Se esiste, non faccio niente per ora.

              // Inserisco le clips caricate CHE non esistevano
              db.query("INSERT INTO clips (uuid, filename, folder, ingested, progress, serial, datefrom, modifydate, title, description) VALUES " +
                "(?,?,?,?,?,?,?,?,?,?)", [item.id, item.filename !== '' ? path.basename(item.filename) : '', item.filename, 1, 'COMPLETE', info.serial, getTimestamp(), getTimestamp(), item.title, 'Resync IMB StreamerV2'], (qerr, insert_) => {

                  count_insert++;
                  if (count_insert >= resolved_imb.length) return callback(to_update_complete);


                });

            }, (cb_to_update_complete) => {

              let count_update = 0;
              // DEVO AGGIORNARE QUELLE ESISTENTI.
              console.log('fine ->' + info.name);

              async.forEachOf(cb_to_update_complete, (item, index, callback_update) => {

                db.query("UPDATE clips SET progress = ?, datefrom = ?, ingested = 1  WHERE id = ?", [item.valid ? 'COMPLETE' : 'ERROR', getTimestamp(), item.id_clips], (qerr, result_update) => {

                  count_update++;
                  if (count_update >= to_update_complete.length) return callback_update(true);

                });

              }, (s) => {

                // Ora, faccio il controllo inverso, controllo se le uuid della lista CLIPS precedente non sono nella lista dei complete, se NON ci sono
                // E sono in tabella da più di 1 ora, le tolgo...
                let to_delete_later = [];

                result_clips.forEach(item => {

                  let exists_ = false;

                  for (let i = 0; i < resolved_imb.length; i++) {

                    if (resolved_imb[i].id === item.uuid) { exists_ = true; break; }

                  }

                  if (!exists_ && new Date().setHours(new Date().getHours() - 1) >= new Date(item.datefrom).getTime()) to_delete_later.push(item.id); // Pusho questo id clips, è da rimuovere...

                });

                let count_deletee = 0;

                async.forEachOf(to_delete_later, (id_clip, index, callback_deletee) => {

                  db.query("DELETE FROM clips WHERE id = ?", [id_clip], (qerr, result_deletee) => {

                    count_deletee++;
                    if (count_deletee >= to_delete_later.length) return callback_deletee();

                  });

                }, () => {

                  return resolve();

                });

              });

            })

          });

        });

      }).catch(rejected_list => {

        return reject();

      })

    });

  }

  app.post('/api/resync/kdm', (req, res) => {

    const { payload } = req.body;

    // DA FARE, NON HO KDM DA NESSUNA PARTE NON POSSO PROVARLE!
    //return res.sendStatus(200);

    if (payload.theater === 'ALL THEATERS') {

      // tutti i teatri
      db.query("SELECT a.id, a.name, b.type, b.serial, b.kdm_serial, b.address as imb_address, b.port as imb_port, b.api_username, b.api_password , c.address as datastore_address, c.username, c.password, c.hula_store_docker FROM m_theaters a LEFT JOIN m_imb b ON b.id = a.id_imb LEFT JOIN m_datastores c ON c.id = b.id_datastore", (qerr, result) => {

        let count_resync = 0;

        async.forEachOf(result, (info, index,) => {

          resyncKDMonIMB(info).then(ok => {

            count_resync++;

            if (count_resync >= result.length)
              return res.sendStatus(200);

          }).catch(error => {

            count_resync++;

            if (count_resync >= result.length)
              return res.sendStatus(200);

          })

        })

      });

    } else {

      // solo uno
      db.query("SELECT a.id, a.name, b.type, b.serial, b.kdm_serial, b.address as imb_address, b.port as imb_port, b.api_username, b.api_password , c.address as datastore_address, c.username, c.password, c.hula_store_docker FROM m_theaters a LEFT JOIN m_imb b ON b.id = a.id_imb LEFT JOIN m_datastores c ON c.id = b.id_datastore WHERE a.name = ?", [payload.theater], (qerr, result) => {



        resyncKDMonIMB(result[0]).then(ok => {

          return res.sendStatus(200);

        }).catch(error => {

          return res.status(500).send(error);

        })

      });

    }

  });


  function resyncKDMonIMB(info) {

    return new Promise((resolve, reject) => {

      // Controlli vari su indirizzi ecc...
      if (info.type !== 'HULA') {

        // dati che ci servono per fare il resync: indirizzo porta imb, username password imb
        if (info.imb_address === '' || info.imb_port === '') return reject({ error: 'Cannot resync IMB for ' + info.name + ' because it does not have an Address and/or a Port configured.' });

      } else {

        // dati che ci servono per fare il resync: indirizzo datastore, username password datastore, nome docker hula store.
        if (info.datastore_address === '' || info.hula_store_docker === '') return reject({ error: 'Cannot resync IMB for ' + info.name + ' because it does not have an Address and/or a HULA docker store configured.' });

      }

      let universal_list = [];

      // PRENDO I DATI CLIPS PER QUESTO TEATRO.
      new Promise((resolve_list, reject_list) => {

        switch (true) {

          // BARCO DOLBY HANNO LE STESSE API GROSSOMODO QUINDI LE FACCIO ASSIEME.
          case info.type === 'BARCO' || info.type.toLowerCase().indexOf('dolby') >= 0:
            new Promise((resolve_imb, reject_imb) => {

              soapLogin(info.type, info.imb_address, info.imb_port, info.api_username, info.api_password, agent).then(login => {

                if (info.type === 'BARCO') {

                  // RESYNC BARCO
                  soapAPI(info.type, info.imb_address, info.imb_port, 'get_kdmlist', agent).then(list => {

                    xml2js.parseString(list, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, list) {

                      if (err) return reject_imb({ error: 'IMB response failed on parse for ' + info.name });

                      try {

                        if (list['SOAP-ENV:Body']['ns1:GetKdmListResponse']['ns1:list'].length === 0) {

                          // Sloggo
                          soapAPI(info.type, info.imb_address, info.imb_port, 'logout', agent).then(list => {

                            return resolve_imb(universal_list);

                          });

                          return;

                        }

                        let parsed_list = list['SOAP-ENV:Body']['ns1:GetKdmListResponse']['ns1:list']['ns1:KdmInformation'];
                        if (typeof parsed_list[0] === 'undefined') {
                          let temp = parsed_list;
                          parsed_list = [temp];
                        }

                        let expired_list = [];

                        parsed_list.forEach(kdm => {

                          // SE, la KDM è scaduta, la rimuovo dall'IMB e non la metto nemmeno in lista, così verrà automaticamente rimossa.
                          if (new Date(kdm['ns1:TimeWindow']['ns1:NotValidAfter']).getTime() < new Date().getTime()) {

                            // Scaduta
                            expired_list.push(kdm['ns1:Id']);

                          } else {

                            universal_list.push({
                              id: 'urn:uuid:' + kdm['ns1:Id'], validfrom: kdm['ns1:TimeWindow']['ns1:NotValidBefore'],
                              validto: kdm['ns1:TimeWindow']['ns1:NotValidAfter'], error: Number(kdm['ns1:Error']) == 1,
                              cpl_id: 'urn:uuid:' + kdm['ns1:CplId']
                            });

                          }

                        });

                        if (expired_list === 0) {

                          soapAPI(info.type, info.imb_address, info.imb_port, 'logout', agent).then(list => {

                            return resolve_imb(universal_list);

                          });

                          return;

                        }

                        // Cancello KDM Scadute
                        soapAPI(info.type, info.imb_address, info.imb_port, 'delete_kdm', agent, '', { kdmList: expired_list }).then(del => {

                          // Sloggo
                          soapAPI(info.type, info.imb_address, info.imb_port, 'logout', agent).then(list => {

                            return resolve_imb(universal_list);

                          });

                        }).catch(err => {

                          return resolve_imb(universal_list); // anche se dovesse dare errore la cancellazione, non blocco il resync

                        });


                      } catch (error_parse) {

                        return reject(); // Lista vuota \ errore di parsing...

                      }


                    });

                  }).catch(error => { return reject('API failed for imb ' + info.name); });


                } else {

                  xml2js.parseString(login, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, json_res) {

                    // dolby
                    if (err || !json_res['SOAP-ENV:Body']['ns1:LoginResponse'].sessionId) {
                      return reject({ error: 'login_failed' });
                    }
                    const dolby_session = json_res['SOAP-ENV:Body']['ns1:LoginResponse'].sessionId;
                    //console.log(dolby_session);
                    soapAPI(info.type, info.imb_address, info.imb_port, 'get_kdmlist', agent, dolby_session).then(list => {

                      xml2js.parseString(list, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, list) {

                        if (err) return reject_imb({ error: 'IMB response failed on parse for ' + info.name });

                        try {

                          if (list['SOAP-ENV:Body']['ns1:GetKDMListInfoResponse']['kdmList'].length === 0) {

                            soapAPI(info.type, info.imb_address, info.imb_port, 'logout', agent, dolby_session).then(list => {

                              return resolve_imb(universal_list);

                            });

                            return;

                          }

                          let parsed_list = list['SOAP-ENV:Body']['ns1:GetKDMListInfoResponse']['kdmList']['kdm:kdmInfo'];
                          if (typeof parsed_list[0] === 'undefined') parsed_list = [parsed_list];

                          let expired_list = [];

                          parsed_list.forEach(kdm => {

                            if (new Date(kdm['ns1:TimeWindow']['ns1:NotValidAfter']).getTime() < new Date().getTime()) {

                              expired_list.push(kdm['kdm:uuid']);

                            } else {

                              universal_list.push({
                                id: kdm['kdm:uuid'], validfrom: kdm['kdm:notValidBeforeString'],
                                validto: kdm['kdm:notValidAfterString'], error: false, cpl_id: kdm['kdm:cplId']
                              });

                            }

                          });

                          let count_expired = 0;

                          // Ciclo rimozione kdm scadute dagli imb
                          async.forEachOf(expired_list, (expired_id, index_exp, callback_expired) => {

                            // Sfortunatamente, per il Dolby non esistono api per rimuovere un gruppo Di kdm come per il barco, quindi devo fare così :(
                            soapAPI(info.type, info.imb_address, info.imb_port, 'delete_kdm', agent, dolby_session, { id_kdm: expired_id }).then(list => {

                              count_expired++; if (count_expired >= expired_list.length) return callback_expired();

                            }).catch(error => {

                              count_expired++; if (count_expired >= expired_list.length) return callback_expired();

                            });

                          }, () => {

                            soapAPI(info.type, info.imb_address, info.imb_port, 'logout', agent, dolby_session).then(list => {

                              return resolve_imb(universal_list);

                            });

                          })


                        } catch (error) {

                          console.log(error)
                          return reject();

                        }

                      });

                    });

                  });


                }

              }).catch(error_login => {

                console.log(error_login)
                return reject('API Login failed for imb ' + info.name);

              })


            }).then(resolved_imb => {

              // resolved_imb è la universal_list delle KDM trovate per IMB
              return resolve_list(resolved_imb);


            }).catch(rejected_imb => {

              return reject('API failed for imb ' + info.name);

            }); break;


          case info.type === 'HULA':
            new Promise((resolve_imb, reject_imb) => {

              var conn = new Client();
              var output = "";

              conn.on('ready', function () {

                conn.exec("docker -H :3000 exec " + info.hula_store_docker + " hl-asset.py --get-kdm-list", function (err, stream) {

                  stream.on('data', (chunk) => { output += chunk });
                  stream.on('end', function (code, signal) {

                    const kdmList = output.split('\n');

                    let kdm_count = 0;
                    let expired_list = [];

                    async.forEachOf(kdmList, (kdm, index, callback_kdm) => {

                      if (kdm === '') { kdm_count++; if (kdm_count >= kdmList.length) return callback_kdm([expired_list, universal_list]); return; }

                      let kdm_content = "";
                      // Chiedo all'HULA di darmi questa KDM                    
                      conn.exec("docker -H :3000 exec " + info.hula_store_docker + " hl-asset.py --get-kdm " + kdm, function (err_kdm, stream_kdm) {

                        stream_kdm.on('data', (chunk) => { kdm_content += chunk });
                        stream_kdm.on('error', (error_stream) => { kdm_count++; if (kdm_count >= kdmList.length) return callback_kdm([expired_list, universal_list]); return; }); // Error.
                        stream_kdm.on('end', () => {

                          // Mi leggo la KDM
                          xml2js.parseString(kdm_content, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, kdm_json) {

                            if (err || kdm_json === null || typeof kdm_json.AuthenticatedPublic === 'undefined') { kdm_count++; if (kdm_count >= kdmList.length) return callback_kdm([expired_list, universal_list]); }

                            // Verifico se sia scaduta
                            if (new Date(kdm_json.AuthenticatedPublic.RequiredExtensions.KDMRequiredExtensions.ContentKeysNotValidAfter).getTime() < new Date().getTime()) {

                              expired_list.push(kdm);

                            } else {

                              universal_list.push({
                                id: "urn:uuid:" + kdm, validfrom: kdm_json.AuthenticatedPublic.RequiredExtensions.KDMRequiredExtensions.ContentKeysNotValidBefore,
                                validto: kdm_json.AuthenticatedPublic.RequiredExtensions.KDMRequiredExtensions.ContentKeysNotValidAfter, error: false,
                                cpl_id: kdm_json.AuthenticatedPublic.RequiredExtensions.KDMRequiredExtensions.CompositionPlaylistId
                              });

                            }

                            kdm_count++; if (kdm_count >= kdmList.length) return callback_kdm([expired_list, universal_list]);

                          });

                        });

                      });

                    }, (callback_list) => {



                      let count_expire = 0;

                      // PRIMA DI dare il resolve, devo rimuovere le KDM scadute
                      async.forEachOf(callback_list[0], (expired_id, index_exp, callback_expired) => {

                        console.log('delete');

                        conn.exec("docker -H :3000 exec " + info.hula_store_docker + " hl-asset.py --delete " + expired_id, function (err, stream_delete) {

                          if (err || typeof stream_delete === 'undefined') {

                            console.log(err);

                            count_expire++; if (count_expire >= expired_list) return resolve_imb(callback_list[1]); return;

                          }

                          stream_delete.on('end', () => {
                            console.log('ended,');
                            count_expire++; if (count_expire >= expired_list) return resolve_imb(callback_list[1]);
                          });

                        });

                      }, (done) => {

                        console.log(callback_list[1]);

                        return resolve_imb(callback_list[1]);

                      })

                    });


                  });

                });


                conn.on('error', () => { return reject({ error: 'Connection to HULA store failed for ' + info.name }) });
              }).connect({
                host: info.datastore_address,
                port: 22,
                username: info.username,
                password: info.password
              });

            }).then(resolved_imb => {

              return resolve_list(resolved_imb);

            }).catch(error_imb => {

              return reject();

            });


            break;

          case info.type === 'GDC':
            gdcAPI('get_kdmlist', info.imb_address, info.imb_port).then(list => {

              let parsed_list = list.asset_uuid;
              if (typeof parsed_list[0] === 'undefined') parsed_list = [parsed_list]; // lo rendo un array

              let temp_list = { universal: [], expired: [] };
              let count_kdm = 0;

              async.forEachOf(parsed_list, (id_kdm, index, callback_kdm) => {

                gdcAPI('get_kdm', info.imb_address, info.imb_port, { id: id_kdm }).then(kdm_response => {

                  if (kdm_response === '') { count_kdm++; if (count_kdm >= parsed_list.length) return callback_kdm(temp_list); return; }

                  xml2js.parseString(kdm_response.response_text, { explicitArray: false, explicitChildren: false, explicitRoot: false }, function (err, kdm_json) {

                    if (err) { count_kdm++; if (count_kdm >= parsed_list.length) return callback_kdm(temp_list); return; }


                    if (typeof kdm_json.AuthenticatedPublic.RequiredExtensions.KDMRequiredExtensions === 'undefined' || new Date(kdm_json.AuthenticatedPublic.RequiredExtensions.KDMRequiredExtensions.ContentKeysNotValidAfter).getTime() < new Date().getTime()) {

                      temp_list.expired.push(id_kdm);

                    } else {

                      temp_list.universal.push({
                        id: id_kdm, validfrom: kdm_json.AuthenticatedPublic.RequiredExtensions.KDMRequiredExtensions.ContentKeysNotValidBefore,
                        validto: kdm_json.AuthenticatedPublic.RequiredExtensions.KDMRequiredExtensions.ContentKeysNotValidAfter, error: false,
                        cpl_id: kdm_json.AuthenticatedPublic.RequiredExtensions.KDMRequiredExtensions.CompositionPlaylistId
                      });

                    }

                    count_kdm++; if (count_kdm >= parsed_list.length) return callback_kdm(temp_list);

                  });

                }).catch(error_kdm => {

                  console.log(error_kdm)
                  count_kdm++; if (count_kdm >= parsed_list.length) return callback_kdm(temp_list);

                });

              }, (cb_list) => {

                // Ora, devo cancellare le KDM expired dall'IMB
                if (cb_list.expired.length === 0) return resolve_list(cb_list.universal);

                let expire_count = 0;
                async.forEachOf(cb_list.expired, (id_expired, index_exp, callback_xp) => {

                  gdcAPI('delete_kdm', info.imb_address, info.imb_port, { id: id_expired }).then(result_delete => {

                    console.log(result_delete);

                    expire_count++;
                    if (expire_count >= cb_list.expired.length) return resolve_list(cb_list.universal);

                  }).catch(err => {

                    expire_count++;
                    if (expire_count >= cb_list.expired.length) return resolve_list(cb_list.universal);

                  });

                }, (x) => {

                  return resolve_list(cb_list.universal);

                });

              });

            }).catch(err => {

              return reject();

            })



            break;


          default: return reject();

        }

      }).then(resolved_imb => {

        // abbiamo la lista delle KDM valide sull'IMB
        //console.log(resolved_list);

        // OPERAZIONI UNIVERSALI PER DETERMINARE SE LA KDM è VALIDA O MENO SE ESISTE NEL DB O NO SE ERA OK ERROR ECC DA AGGIORNARE O QUELLE DA TOGLIERE....
        // analisi universale per tutti resync unico

        console.log(resolved_imb);

        let count_insert = 0;
        let to_update_complete = [];

        // cancello la lista clips e riscrivo questa, tengo solamente le clips che sarebbero da ingestare\running\loaded, quelle le aggiorno solamente se sono state caricate.
        db.query("DELETE FROM kdm WHERE serial = ? and projectorid=? AND progress NOT LIKE 'RUNNING' AND progress NOT LIKE 'LOADED' AND progress NOT LIKE 0 AND progress NOT LIKE 1 ", [info.serial, info.kdm_serial], (qerr, result_delete) => {

          // Prendo i record senza quelli complete\error
          console.log(info.serial + " , " + info.kdm_serial)
          db.query("SELECT * FROM kdm WHERE serial = ? and projectorid = ?", [info.serial, info.kdm_serial], (qerr, result_clips) => {

            async.forEachOf(resolved_imb, (item, index, callback) => {

              // cerco se abbiamo il record di questa
              let exists_in_clips = false;

              for (let i = 0; i < result_clips.length; i++) {
                if (result_clips[i].id_kdm === item.id) {
                  // Esiste, quindi dopo farò l'update
                  to_update_complete.push({ id_clips: result_clips[i].id, error: item.error }); exists_in_clips = true; break;

                } else {

                  console.log(result_clips[i].id_kdm + " --- " + item.id);

                }
              }

              if (exists_in_clips) { count_insert++; if (count_insert >= resolved_imb.length) return callback(to_update_complete); return; } // Se esiste, non faccio niente per ora.

              // Inserisco le clips caricate CHE non esistevano
              db.query("INSERT INTO kdm (filename, folder, serial, projectorid, startdate, enddate, ingested, progress, uuid, modifydate, description, id_kdm) VALUES " +
                "(?,?,?,?,?,?,?,?,?,?,?,?)", ['', '', info.serial, info.kdm_serial, new Date(item.validfrom).toMysqlFormat(), new Date(item.validto).toMysqlFormat(), 1, 'COMPLETE', item.cpl_id, getTimestamp(), 'Resync IMB StreamerV2', item.id], (qerr, insert_) => {

                  console.log(qerr);

                  count_insert++;
                  if (count_insert >= resolved_imb.length) return callback(to_update_complete);


                });

            }, (cb_to_update_complete) => {

              console.log(cb_to_update_complete)

              let count_update = 0;
              // DEVO AGGIORNARE QUELLE ESISTENTI.
              console.log('fine ->' + info.name);

              async.forEachOf(cb_to_update_complete, (item, index, callback_update) => {

                db.query("UPDATE kdm SET progress = ?, modifydate=?, ingested = 1  WHERE id = ?", [!item.error ? 'COMPLETE' : 'ERROR', getTimestamp(), item.id_clips], (qerr, result_update) => {

                  count_update++;
                  if (count_update >= to_update_complete.length) return callback_update();

                });

              }, () => {

                // Ora, faccio il controllo inverso, controllo se le uuid della lista CLIPS precedente non sono nella lista dei complete, se NON ci sono
                // E sono in tabella da più di 1 ora, le tolgo...
                let to_delete_later = [];

                result_clips.forEach(item => {

                  let exists_ = false;

                  for (let i = 0; i < resolved_imb.length; i++) {
                    if (resolved_imb[i].id === item.id_kdm) { exists_ = true; break; }
                  }

                  if (!exists_ && new Date().setHours(new Date().getHours() - 1) >= new Date(item.modifydate).getTime()) to_delete_later.push(item.id); // Pusho questo id clips, è da rimuovere...

                });

                let count_deletee = 0;

                async.forEachOf(to_delete_later, (id_clip, index, callback_deletee) => {

                  db.query("DELETE FROM kdm WHERE id = ?", [id_clip], (qerr, result_deletee) => {

                    count_deletee++;
                    if (count_deletee >= to_delete_later.length) return callback_deletee();

                  });

                }, () => {

                  return resolve();

                });

              });

            })

          });

        });

      }).catch(error_list => {

        return reject('API failed for imb ' + info.name);

      })

    });

  }

  app.post('/api/post/systemhealth', (req, res) => {

    const { theater_id, index_service, action, datastore } = req.body.payload;

    db.query("SELECT a.type, c.*, b.theater_nr FROM m_imb a LEFT JOIN m_datastores c on c.id = a.id_datastore LEFT JOIN m_theaters b on b.id_imb = a.id WHERE b.id = ?", [theater_id], (qerr, info) => {

      switch (true) {

        case index_service === 0: // 0 = Engine

          var conn = new Client();
          var output = "";

          conn.on('ready', function () {

            //const cmd_ = action === 0 ? 'start' : action === 1 ? 'stop' : 'restart';
            const engine_name = 'cineplayer-' + info[0].type.toLowerCase() + '-' + info[0].theater_nr;
            conn.exec('docker -H :3000 container ' + action + ' ' + engine_name, (err, stream) => { // Comando di accensione,spegnimento,riavvio del docker

              let output = '';

              stream.on('end', () => {

                conn.end();

                clearTimeout(timeout_systemhealth);
                systemHealthBackground();
                return res.sendStatus(200);

              }).on('data', (chunk) => { output += chunk; });

            });

          }).on('error', () => {

            // datastore offline...
            return res.sendStatus(500);

          }).connect({
            host: info[0].address,
            port: 22,
            username: info[0].username,
            password: info[0].password
          })

          break;

        case index_service === 1 || index_service === 2:

          db.query("SELECT name FROM m_theaters WHERE id = ?", [theater_id], (qerr, result) => {

            const file_cmd = '/' + path.join('datastore', 'K', result[0].name.toUpperCase() + '-' + (index_service === 1 ? 'PL' : 'DM') + '-' + action.toUpperCase());

            var conn = new Client();
            var output = "";

            conn.on('ready', function () {

              conn.exec('touch ' + file_cmd.replace(/\\/g, '/'), (err, stream) => { // Creo il file

                console.log(err)

                stream.on('end', () => {

                  conn.end();
                  return res.sendStatus(200);

                }).on('data', (data) => { output += data; console.log(data) });

              })

            }).on('error', (err) => {

              //console.log(err)

              // errore datastore
              return res.sendStatus(500);

            }).connect({
              host: info[0].address,
              port: 22,
              username: info[0].username,
              password: info[0].password
            })

          });
          break;

        default:
          return res.sendStatus(200);

      }

    });

  });

  // FINE API STREAMER ...................................................................




  // APP API PORTA 5000 IN ASCOLTO PER LE API
  app.listen(48001);


  function readPlayoutSocket() {

    try {

      var nc2 = new NetcatClient()
      nc2.udp().port(41075).init().send('/CMD:TLSTATUS', ip_playout).on('data', function (data) {

        //console.log(data);
        nc2.close();

      }).on('close', function () {

        readPlayoutSocket();

      }).on('error', function () {
        console.log('error');
      });

    } catch (e) {
      readPlayoutSocket();
    }

  }

  function add(x, y, base) {
    var z = [];
    var n = Math.max(x.length, y.length);
    var carry = 0;
    var i = 0;
    while (i < n || carry) {
      var xi = i < x.length ? x[i] : 0;
      var yi = i < y.length ? y[i] : 0;
      var zi = carry + xi + yi;
      z.push(zi % base);
      carry = Math.floor(zi / base);
      i++;
    }
    return z;
  }

  // Returns a*x, where x is an array of decimal digits and a is an ordinary
  // JavaScript number. base is the number base of the array x.
  function multiplyByNumber(num, x, base) {
    if (num < 0) return null;
    if (num == 0) return [];

    var result = [];
    var power = x;
    while (true) {
      if (num & 1) {
        result = add(result, power, base);
      }
      num = num >> 1;
      if (num === 0) break;
      power = add(power, power, base);
    }

    return result;
  }

  function parseToDigitsArray(str, base) {
    var digits = str.split('');
    var ary = [];
    for (var i = digits.length - 1; i >= 0; i--) {
      var n = parseInt(digits[i], base);
      if (isNaN(n)) return null;
      ary.push(n);
    }
    return ary;
  }

  function convertBase(str, fromBase, toBase) {
    var digits = parseToDigitsArray(str, fromBase);
    if (digits === null) return null;

    var outArray = [];
    var power = [1];
    for (var i = 0; i < digits.length; i++) {
      // invariant: at this point, fromBase^i = power
      if (digits[i]) {
        outArray = add(outArray, multiplyByNumber(digits[i], power, toBase), toBase);
      }
      power = multiplyByNumber(fromBase, power, toBase);
    }

    var out = '';
    for (var i = outArray.length - 1; i >= 0; i--) {
      out += outArray[i].toString(toBase);
    }
    return out;
  }

  function decToHex(decStr) {
    var hex = convertBase(decStr, 10, 16);
    return hex ? '0x' + hex : null;
  }

  function hexToDec(hexStr) {
    if (hexStr.substring(0, 2) === '0x') hexStr = hexStr.substring(2);
    hexStr = hexStr.toLowerCase();
    return convertBase(hexStr, 16, 10);
  }

  function getPlayoutIP() {

    return new Promise((resolve, reject) => {

      /*pool.getConnection(function(conn_err, db){
        if(conn_err){ // connessione db fallita
   
          reject();
   
        }*/

      db.query("SELECT string_value FROM m_generalsettings WHERE key2 = 'ip_playout'", (qerr, res_) => {

        /*db.release();*/
        if (qerr || res_.length === 0) { ip_playout = "127.0.0.1"; return resolve(); }
        ip_playout = res_[0].string_value;

        return resolve();

      });

    });

    //  });

  }

  function dateCinePlayout(date) {
    //2020-01-05T15:00:00.000Z
    return date.toISOString().substring(0, 19);
  }

  function base64_encode(file) {
    // read binary data
    var bitmap = fs.readFileSync(file);
    // convert binary data to base64 encoded string
    return new Buffer.from(bitmap).toString('base64');
  }

  function basicHHMMSS(ms) {

    var sec_num = parseInt(ms, 10) / 1000; // don't forget the second param
    var hours = Math.floor(sec_num / 3600);
    var minutes = Math.floor((sec_num - (hours * 3600)) / 60);
    var seconds = sec_num - (hours * 3600) - (minutes * 60);

    if (hours < 10) { hours = "0" + hours; }
    if (minutes < 10) { minutes = "0" + minutes; }
    if (seconds < 10) { seconds = "0" + seconds; }
    return hours + ':' + minutes + ':' + seconds;

  }

  Date.prototype.toMysqlFormat = function () {
    this.setTime(this.getTime() + Math.abs(this.getTimezoneOffset() * 60 * 1000));
    return this.getUTCFullYear() + "-" + twoDigits(1 + this.getUTCMonth()) + "-" + twoDigits(this.getUTCDate()) + " " + twoDigits(this.getUTCHours()) + ":" + twoDigits(this.getUTCMinutes()) + ":" + twoDigits(this.getUTCSeconds());
  };

  function getTimestamp() {
    var date = new Date();
    var year = date.getFullYear();
    var month = date.getMonth() < 10 ? "0" + (parseInt(date.getMonth()) + 1) : parseInt(date.getMonth() + 1);
    var day = date.getDate() < 10 ? "0" + date.getDate() : date.getDate();
    var hours = date.getHours() < 10 ? "0" + date.getHours() : date.getHours();
    var minutes = date.getMinutes() < 10 ? "0" + date.getMinutes() : date.getMinutes();
    var seconds = date.getSeconds() < 10 ? "0" + date.getSeconds() : date.getSeconds();
    return year + "-" + month + "-" + day + " " + hours + ":" + minutes + ":" + seconds;
  }

  function propComparator(prop) {
    return function (a, b) {
      return a[prop] - b[prop];
    }
  }

  function twoDigits(d) {
    if (0 <= d && d < 10) return "0" + d.toString();
    if (-10 < d && d < 0) return "-0" + (-1 * d).toString();
    return d.toString();
  }


  function getGdcHeader(cmd) {

    const conv = num => {
      let b = new ArrayBuffer(4);
      new DataView(b).setUint32(0, num);
      return Array.from(new Uint8Array(b));
    }

    const length_last_3_indexes = conv(cmd.length);
    return Buffer.from([6, 14, 43, 52, 2, 5, 1, 1, 15, 21, 1, 16, 0, 0, 0, 0, 131, length_last_3_indexes[1], length_last_3_indexes[2], length_last_3_indexes[3]]); // header

  }

});

app.post('/api/nodb/check', (req, res) => {

  const { username, password, schema, port, address } = req.body.payload;

  let pool_ = mysql.createPool({
    host: address,
    user: username,
    password: password,
    /*database: schema,*/
    port: port,
  });

  let status = { database: false, schema: false, ping: false };

  ping.sys.probe(address, (isAlive) => {

    if (!isAlive) { return res.status(200).send(status) };

    status.ping = true;

    //Apro pool di connessione al db.
    pool_.getConnection(function (conn_err, db_) {

      if (conn_err) { // connessione db fallita

        return res.status(200).send(status)

      } else {

        status.database = true;

        //db_.query("USE ?", [schema], (qerr, result) => {
        db_.changeUser({ database: schema }, (err) => {

          if (!err) status.schema = true;

          db_.release();
          return res.status(200).send(status)

        })

        // })

      }

    });

  });

});

app.post('/api/installation/checkdb', (req, res) => {

  const { username, password, schema, port, address } = req.body.payload;

  let pool_ = mysql.createPool({
    host: address,
    user: username,
    password: password,
    /*database: schema,*/
    port: port,
  });

  let status = { database: false, schema: false, ping: false };

  ping.sys.probe(address, (isAlive) => {

    if (!isAlive) { return res.status(200).send({ status: 0, error: 'Database Address is currently offline.' }) };

    status.ping = true;

    //Apro pool di connessione al db.
    pool_.getConnection(function (conn_err, db_) {

      if (conn_err) { // connessione db fallita

        return res.status(200).send({ status: 0, error: 'Database authentication failed.' });

      } else {

        status.database = true;
        return res.status(200).send({ status: 1 });

      }

    });

  });

});

app.post('/api/nodb/integrity', (req, res) => {

  const { username, password, schema, port, address } = req.body.payload;
  const string_param = Buffer.from(JSON.stringify(req.body.payload)).toString('base64');

  let cmd = "php ./integrity.php " + string_param + " /dev/null 2>&1 &";

  //console.log(cmd)

  const { exec } = __webpack_require__(63129);

  const ls = exec(cmd, function (error, stdout, stderr) {

    if (error) {
      return res.sendStatus(500);
    }

  });

  ls.on('exit', function (code) {

    // Scrivo il file config del db
    const new_config = {
      "Customer": {
        "dbConfig": {
          "DATABASE_HOST": address,
          "DATABASE_PORT": port,
          "DATABASE_NAME": schema,
          "DATABASE_USER": username,
          "DATABASE_PWD": password
        }
      }
    };

    fs.writeFileSync(path.join('.', 'config', 'default.json'), JSON.stringify(new_config));


    if (is_streamer_already_intalled)
      setTimeout(() => { // Schedulo il riavvio tra 2 secondi

        const ls_ = exec('pm2 restart app.dist.js', function (error, stdout, stderr) {

        });

        ls_.on('exit', function (code) {

        });

      }, 2500);

    return res.sendStatus(200);

  });

});

app.get("/api/get/database", (req, res) => {

  const response = {

    address: dbConfig.DATABASE_HOST,
    username: dbConfig.DATABASE_USER,
    password: dbConfig.DATABASE_PWD,
    schema: dbConfig.DATABASE_NAME,
    port: dbConfig.DATABASE_PORT,

  }

  return res.status(200).send(response);

});



app.post('/api/installation/create_user', (req, res) => {

  const { username, password, schema, port, address, usr, pwd } = req.body.payload;

  let pool_ = mysql.createPool({
    host: address,
    user: username,
    password: password,
    database: schema,
    port: port,
  });

  pool_.getConnection(function (conn_err, db_) {

    db_.query("INSERT INTO m_streamer_users (username, password, user_level, active) VALUES (?,?,0,1) ", [usr, pwd], (qerr, result) => {

      if (qerr) return res.sendStatus(500);

      db_.release();
      return res.sendStatus(200);

    });

  });

});


app.post('/api/installation/create_datastore', (req, res) => {

  const { username, password, schema, port, address, datastore } = req.body.payload;

  let pool_ = mysql.createPool({
    host: address,
    user: username,
    password: password,
    database: schema,
    port: port,
  });

  pool_.getConnection(function (conn_err, db_) {

    db_.query("INSERT INTO m_datastores (name, address, manager_address, username, password, filesystem_type, port, hula_store_docker) VALUES ('DATASTORE1' , ? , ? , 'cmcadmin', '123456' , 'NFS' , 22, 'store-hula')", [datastore, datastore], (qerr, result) => {

      if (qerr) return res.sendStatus(500);

      db_.release();
      return res.sendStatus(200);

    });

  });

});


app.post('/api/installation/create_theaters', (req, res) => {

  const { username, password, schema, port, address, theaters } = req.body.payload;

  // Devo rilanciare la connessione al db per aprire le api...
  let pool_ = mysql.createPool({
    host: address,
    user: username,
    password: password,
    database: schema,
    port: port,
  });

  pool_.getConnection(function (conn_err, db_) {

    // connessione temporanea...

    db_.query("SELECT id, address FROM m_datastores WHERE name = 'DATASTORE1'", (qerr, datastore_insert) => {

      const id_datastore = datastore_insert[0].id;
      let temp_counts = [];

      for (let i = 1; i <= theaters; i++) {
        temp_counts.push(i);
      }

      let ip_explode = datastore_insert[0].address.split(".");

      let count_ = 0;

      async.forEachOf(temp_counts, (item, index, callback) => {

        const imb_ip = ip_explode[0] + "." + ip_explode[1] + "." + ip_explode[2] + "." + (item) + "2";
        const projector_ip = ip_explode[0] + "." + ip_explode[1] + "." + ip_explode[2] + "." + (item) + "2";
        const audio_ip = ip_explode[0] + "." + ip_explode[1] + "." + ip_explode[2] + "." + (item) + "4";
        const gpi_ip = ip_explode[0] + "." + ip_explode[1] + "." + ip_explode[2] + "." + (item) + "6";
        const switch_ip = ip_explode[0] + "." + ip_explode[1] + "." + ip_explode[2] + "." + (item) + "5";
        const cineplayer = 'cinplayer-barco- ' + item;

        const theater_name = 'T' + (item < 10 ? ('0' + item) : item);

        let template = {
          "name": theater_name, "theater_nr": item, "id_imb": null, "id_projector": null, "id_audioprocessor": null, "id_gpi": null, "id_switch": null, "description": "", "note": "",
          "imb": { "id": null, "type": "BARCO", "address": imb_ip, "port": "43758", "direct_streaming": true, "certified": false, "self_schedule": false, "id_datastore": 1, "id_datastore_backup": 1, "api_username": "", "api_password": "", "kdm_serial": "", "serial": "", "cineplayer_docker": cineplayer, "is_alive": false },
          "projector": { "id": null, "address": projector_ip, "port": "43728", "type": "1", "timeout_read_status": 3000, "enabled": true },
          "audio": { "id": null, "address": audio_ip, "port": 61408, "serial": "", "kdm_serial": "", "type": 2, "timeout_read_status": 3000, "enabled": true },
          "gpi": { "id": 0, "address": gpi_ip, "port": 17494, "type": 10, "timeout_read_status": 3000, "enabled": true },
          "switch": { "id": 0, "address": switch_ip, "port": 23, "type": 34, "timeout_read_status": 3000, "enabled": true }
        };

        createTheaterDB(template, db_).then(result => {

          count_++;
          if (count_ >= temp_counts.length) {


            // CREO I TAG DI DEFAULT
            createDefaultTheaterTags(db_).then(ok => {

              fs.writeFileSync('./installed.str', new Date().toLocaleDateString());
              const { exec } = __webpack_require__(63129);

              setTimeout(() => { // Schedulo il riavvio tra 2 secondi

                const ls_ = exec('pm2 restart app.dist.js', function (error, stdout, stderr) {

                });

                ls_.on('exit', function (code) {

                });

              }, 1000);

              return res.sendStatus(200);

            });

          }

        })

      });


    });


  });

});

function createDefaultTheaterTags(db) {

  return new Promise((resolve, reject) => {

    db.query("SELECT * FROM m_instances WHERE NAME<>'G00'", (qerr, result) => {

      let count_instances = 0;

      async.forEachOf(result, (instance, index, callback_) => {

        let tags_audio_count = new Array(101);

        let count_audio = 0;

        async.forEachOf(tags_audio_count, (num, index, callback_audio) => {

          const tag_description = 'AUDIO ' + index;

          let template = {
            "tagData":
            {
              "tag": { "DESCRIPTION": tag_description, "ENABLED": 1 }, "details":
                [
                  [{ "KEY1": "Source_Mode", "VALUESTRING": "ANY", "device_name": "6" },
                  { "KEY1": "Enabled", "VALUESTRING": 1, "device_name": "6" },
                  { "KEY1": "AudioProcessor_Param", "VALUESTRING": "VOLUME", "device_name": "6" },
                  { "KEY1": "AudioProcessor_Value", "VALUESTRING": index, "device_name": "6" }]
                ]
            }, "instancename": instance.NAME
          };

          createDeviceTag(template.tagData, instance.NAME, null, db).then(tag_created => {

            count_audio++;
            if (count_audio >= 100) return callback_audio(true);

          }).catch(error => {

            count_audio++;
            if (count_audio >= 100) return callback_audio(true);

          })

        }, (c1) => {

          // callback audio, creo tag lights, scope, flat
          let template_flat = {
            "tagData":
            {
              "tag": { "DESCRIPTION": "FLAT", "ENABLED": 1 }, "details":
                [
                  [{ "KEY1": "Source_Mode", "VALUESTRING": "ANY", "device_name": 7 },
                  { "KEY1": "Enabled", "VALUESTRING": 1, "device_name": 7 },
                  { "KEY1": "Projector_Param", "VALUESTRING": "MACRO", "device_name": 7 },
                  { "KEY1": "Projector_Value", "VALUESTRING": "FLAT", "device_name": 7 }]
                ]
            },
            "instancename": instance.NAME
          };

          createDeviceTag(template_flat.tagData, instance.NAME, null, db).then(tag_created => {

            // creo scope
            let template_scope = {
              "tagData":
              {
                "tag": { "DESCRIPTION": "SCOPE", "ENABLED": 1 }, "details":
                  [
                    [{ "KEY1": "Source_Mode", "VALUESTRING": "ANY", "device_name": 7 },
                    { "KEY1": "Enabled", "VALUESTRING": 1, "device_name": 7 },
                    { "KEY1": "Projector_Param", "VALUESTRING": "MACRO", "device_name": 7 },
                    { "KEY1": "Projector_Value", "VALUESTRING": "SCOPE", "device_name": 7 }]
                  ]
              },
              "instancename": instance.NAME
            };

            createDeviceTag(template_scope.tagData, instance.NAME, null, db).then(tag_created => {

              // creo lights off
              let template_lights_off = {
                "tagData":
                {
                  "tag": { "DESCRIPTION": "LIGHT OFF", "ENABLED": 1 }, "details":
                    [[{ "KEY1": "Source_Mode", "VALUESTRING": "ANY", "device_name": "1" },
                    { "KEY1": "Enabled", "VALUESTRING": 1, "device_name": "1" },
                    { "KEY1": "Gpi_Mode", "VALUESTRING": "BIT", "device_name": "1" },
                    { "KEY1": "Gpi_Port", "VALUESTRING": 1, "device_name": "1" },
                    { "KEY1": "Gpi_Value", "VALUESTRING": 0, "device_name": "1" },
                    { "KEY1": "Gpi_HoldFor", "VALUESTRING": 0, "device_name": "1" }],
                    [{ "KEY1": "Source_Mode", "VALUESTRING": "ANY", "device_name": "1" },
                    { "KEY1": "Enabled", "VALUESTRING": 1, "device_name": "1" },
                    { "KEY1": "Gpi_Mode", "VALUESTRING": "BIT", "device_name": "1" },
                    { "KEY1": "Gpi_Port", "VALUESTRING": "2", "device_name": "1" },
                    { "KEY1": "Gpi_Value", "VALUESTRING": 0, "device_name": "1" },
                    { "KEY1": "Gpi_HoldFor", "VALUESTRING": 0, "device_name": "1" }],
                    [{ "KEY1": "Source_Mode", "VALUESTRING": "ANY", "device_name": "1" },
                    { "KEY1": "Enabled", "VALUESTRING": 1, "device_name": "1" },
                    { "KEY1": "Gpi_Mode", "VALUESTRING": "BIT", "device_name": "1" },
                    { "KEY1": "Gpi_Port", "VALUESTRING": "3", "device_name": "1" },
                    { "KEY1": "Gpi_Value", "VALUESTRING": 0, "device_name": "1" },
                    { "KEY1": "Gpi_HoldFor", "VALUESTRING": 0, "device_name": "1" }]]
                }, "instancename": instance.NAME
              };

              createDeviceTag(template_lights_off.tagData, instance.NAME, null, db).then(tag_created => {

                // creo lights 50
                let template_lights_50 = {
                  "tagData":
                  {
                    "tag": { "DESCRIPTION": "LIGHT 50", "ENABLED": 1 }, "details":
                      [

                        [{ "KEY1": "Source_Mode", "VALUESTRING": "ANY", "device_name": "1" },
                        { "KEY1": "Enabled", "VALUESTRING": 1, "device_name": "1" },
                        { "KEY1": "Gpi_Mode", "VALUESTRING": "BIT", "device_name": "1" },
                        { "KEY1": "Gpi_Port", "VALUESTRING": "2", "device_name": "1" },
                        { "KEY1": "Gpi_Value", "VALUESTRING": 1, "device_name": "1" },
                        { "KEY1": "Gpi_HoldFor", "VALUESTRING": 0, "device_name": "1" }],

                        [{ "KEY1": "Source_Mode", "VALUESTRING": "ANY", "device_name": "1" },
                        { "KEY1": "Enabled", "VALUESTRING": 1, "device_name": "1" },
                        { "KEY1": "Gpi_Mode", "VALUESTRING": "BIT", "device_name": "1" },
                        { "KEY1": "Gpi_Port", "VALUESTRING": 1, "device_name": "1" },
                        { "KEY1": "Gpi_Value", "VALUESTRING": 0, "device_name": "1" },
                        { "KEY1": "Gpi_HoldFor", "VALUESTRING": 0, "device_name": "1" }],

                        [{ "KEY1": "Source_Mode", "VALUESTRING": "ANY", "device_name": "1" },
                        { "KEY1": "Enabled", "VALUESTRING": 1, "device_name": "1" },
                        { "KEY1": "Gpi_Mode", "VALUESTRING": "BIT", "device_name": "1" },
                        { "KEY1": "Gpi_Port", "VALUESTRING": "3", "device_name": "1" },
                        { "KEY1": "Gpi_Value", "VALUESTRING": 0, "device_name": "1" },
                        { "KEY1": "Gpi_HoldFor", "VALUESTRING": 0, "device_name": "1" }]
                      ]
                  }, "instancename": instance.NAME
                };

                createDeviceTag(template_lights_50.tagData, instance.NAME, null, db).then(tag_created => {

                  // creo lights 100
                  let template_lights_100 = {
                    "tagData":
                    {
                      "tag": { "DESCRIPTION": "LIGHT 100", "ENABLED": 1 }, "details":
                        [
                          [{ "KEY1": "Source_Mode", "VALUESTRING": "ANY", "device_name": "1" },
                          { "KEY1": "Enabled", "VALUESTRING": 1, "device_name": "1" },
                          { "KEY1": "Gpi_Mode", "VALUESTRING": "BIT", "device_name": "1" },
                          { "KEY1": "Gpi_Port", "VALUESTRING": "3", "device_name": "1" },
                          { "KEY1": "Gpi_Value", "VALUESTRING": 1, "device_name": "1" },
                          { "KEY1": "Gpi_HoldFor", "VALUESTRING": 0, "device_name": "1" }],

                          [{ "KEY1": "Source_Mode", "VALUESTRING": "ANY", "device_name": "1" },
                          { "KEY1": "Enabled", "VALUESTRING": 1, "device_name": "1" },
                          { "KEY1": "Gpi_Mode", "VALUESTRING": "BIT", "device_name": "1" },
                          { "KEY1": "Gpi_Port", "VALUESTRING": "2", "device_name": "1" },
                          { "KEY1": "Gpi_Value", "VALUESTRING": 0, "device_name": "1" },
                          { "KEY1": "Gpi_HoldFor", "VALUESTRING": 0, "device_name": "1" }],

                          [{ "KEY1": "Source_Mode", "VALUESTRING": "ANY", "device_name": "1" },
                          { "KEY1": "Enabled", "VALUESTRING": 1, "device_name": "1" },
                          { "KEY1": "Gpi_Mode", "VALUESTRING": "BIT", "device_name": "1" },
                          { "KEY1": "Gpi_Port", "VALUESTRING": 1, "device_name": "1" },
                          { "KEY1": "Gpi_Value", "VALUESTRING": 0, "device_name": "1" },
                          { "KEY1": "Gpi_HoldFor", "VALUESTRING": 0, "device_name": "1" }]

                        ]
                    }, "instancename": instance.NAME
                  };

                  createDeviceTag(template_lights_100.tagData, instance.NAME, null, db).then(tag_created => {

                    // creo 3dflat
                    let template_3dflat = {
                      "tagData":
                      {
                        "tag": { "DESCRIPTION": "3D FLAT", "ENABLED": 1 }, "details":
                          [
                            [{ "KEY1": "Source_Mode", "VALUESTRING": "ANY", "device_name": 7 },
                            { "KEY1": "Enabled", "VALUESTRING": 1, "device_name": 7 },
                            { "KEY1": "Projector_Param", "VALUESTRING": "MACRO", "device_name": 7 },
                            { "KEY1": "Projector_Value", "VALUESTRING": "3D FLAT", "device_name": 7 }]
                          ]
                      },
                      "instancename": instance.NAME
                    };

                    createDeviceTag(template_3dflat.tagData, instance.NAME, null, db).then(tag_created => {

                      // creo 3dscope
                      let template_3dscope = {
                        "tagData":
                        {
                          "tag": { "DESCRIPTION": "3D SCOPE", "ENABLED": 1 }, "details":
                            [
                              [{ "KEY1": "Source_Mode", "VALUESTRING": "ANY", "device_name": 7 },
                              { "KEY1": "Enabled", "VALUESTRING": 1, "device_name": 7 },
                              { "KEY1": "Projector_Param", "VALUESTRING": "MACRO", "device_name": 7 },
                              { "KEY1": "Projector_Value", "VALUESTRING": "3D SCOPE", "device_name": 7 }]
                            ]
                        },
                        "instancename": instance.NAME
                      };

                      createDeviceTag(template_3dscope.tagData, instance.NAME, null, db).then(tag_created => {

                        // creo preshow flat
                        let template_preshowflat = {
                          "tagData":
                          {
                            "tag": { "DESCRIPTION": "PRESHOW FLAT", "ENABLED": 1 }, "details":
                              [
                                [{ "KEY1": "Source_Mode", "VALUESTRING": "ANY", "device_name": 7 },
                                { "KEY1": "Enabled", "VALUESTRING": 1, "device_name": 7 },
                                { "KEY1": "Projector_Param", "VALUESTRING": "MACRO", "device_name": 7 },
                                { "KEY1": "Projector_Value", "VALUESTRING": "PRESHOW FLAT", "device_name": 7 }]
                              ]
                          },
                          "instancename": instance.NAME
                        };

                        createDeviceTag(template_preshowflat.tagData, instance.NAME, null, db).then(tag_created => {


                          // creo preshow flat
                          let template_event = {
                            "tagData":
                            {
                              "tag": { "DESCRIPTION": "EVENT", "ENABLED": 1 }, "details":
                                [
                                  [{ "KEY1": "Source_Mode", "VALUESTRING": "ANY", "device_name": 7 },
                                  { "KEY1": "Enabled", "VALUESTRING": 1, "device_name": 7 },
                                  { "KEY1": "Projector_Param", "VALUESTRING": "MACRO", "device_name": 7 },
                                  { "KEY1": "Projector_Value", "VALUESTRING": "EVENT", "device_name": 7 }]
                                ]
                            },
                            "instancename": instance.NAME
                          };

                          createDeviceTag(template_event.tagData, instance.NAME, null, db).then(tag_created => {

                            count_instances++;
                            if (count_instances >= result.length) { // INIZIO FINALE

                              // Cancello tutti i tag 
                              db.query("DELETE FROM m_device_tags WHERE ID_INSTANCE = 1", (qerr, result) => {

                                // prendo i tags dell'1
                                db.query("SELECT * FROM m_device_tags WHERE ID_INSTANCE = 2", (qerr, tags_) => {

                                  let count_tags = 0;

                                  async.forEachOf(tags_, (tag_, index_tag, callback_tag) => {

                                    db.query("INSERT INTO m_device_tags (ID_UNIVERSAL, DESCRIPTION, ENABLED, ID_INSTANCE) VALUES (?,?,1,1)", [uuidv4().toString().toUpperCase(), tag_.DESCRIPTION], (qerr, finale) => {

                                      count_tags++;
                                      if (count_tags >= tags_.length) return resolve();

                                    });

                                  })

                                });

                              });

                              //return resolve();

                            } // FINALE

                          });

                        });

                      });

                    });

                  }).catch(error => {

                    console.log('5');
                    console.log(error);

                  });


                }).catch(error => {

                  console.log('4');
                  console.log(error);

                });

              }).catch(error => {

                console.log('3');
                console.log(error);

              });


            }).catch(error => {

              console.log('2');
              console.log(error);

            });


            //return resolve();

          }).catch(error => {

            console.log('1');
            console.log(error);

          });

        });

      });

    });

  });


}


function createTheaterDB(payload, db_ = undefined) {

  return new Promise((resolve, reject) => {

    var ids = {};

    if (typeof db_ !== 'undefined')
      db = db_;
    // Il teatro lo creo solo alla fine delle altre insert.

    // Gestisco le modalità
    if (payload.imb.type === 'HULA') {
      payload.imb.direct_streaming = false;
      payload.imb.certified = true;
      payload.imb.self_schedule = false;
    } else {
      payload.imb.certified = false; // Certified è deprecato, solo l'HULA lo accetta ma comunque sia non lo considero nemmeno perchè l'HULA va gestito sempre allo stesso modo...
    }

    // Inserisco m_imb
    db.query("INSERT INTO m_imb (type, address, port, direct_streaming, certified, self_schedule, id_datastore, id_datastore_backup, api_username, api_password, kdm_serial, serial, cineplayer_docker) VALUES " +
      "(?,?,?,?,?,?,?,?,?,?,?,? , ?)",
      [sanitizeString(payload.imb.type),
      sanitizeString(payload.imb.address),
      sanitizeString(payload.imb.port),
      sanitizeString(Number(payload.imb.direct_streaming)),
      sanitizeString(Number(payload.imb.certified)),
      sanitizeString(Number(payload.imb.self_schedule)),
      sanitizeString(payload.imb.id_datastore),
      sanitizeString(payload.imb.id_datastore_backup),
      sanitizeString(payload.imb.api_username),
      sanitizeString(payload.imb.api_password),
      sanitizeString(payload.imb.kdm_serial),
      sanitizeString(payload.imb.serial),
      sanitizeString(payload.imb.cineplayer_docker)
      ], (qerr, result) => {

        // Errore creazione m_imb
        if (qerr) {
          /*db.release();*/
          return reject({
            error: '/api/post/theater -> query_1 error'
          });
        }

        ids.id_imb = result.insertId; // Prendo l'id della insert.

        // Inserisco m_audioprocessor
        db.query("INSERT INTO m_audioprocessor (address, port, serial, kdm_serial, type) VALUES " +
          "(?,?,?,?,?)", [
          sanitizeString(payload.audio.address),
          sanitizeString(payload.audio.port),
          sanitizeString(payload.audio.serial),
          sanitizeString(payload.audio.kdm_serial),
          sanitizeString(payload.audio.type)
        ], (qerr, result) => {

          // Errore creazione m_audioprocessor
          if (qerr) {
            /*db.release();*/
            return reject({
              error: '/api/post/theater -> query_2 error'
            });
          }

          ids.id_audioprocessor = result.insertId; // Prendo l'id della insert.

          // Inserisco m_projector
          db.query("INSERT INTO m_projector (address, port, type) VALUES " +
            "(?,?,?)", [
            sanitizeString(payload.projector.address),
            sanitizeString(payload.projector.port),
            sanitizeString(payload.projector.type),
          ], (qerr, result) => {

            // Errore creazione m_audioprocessor
            if (qerr) {
              /*db.release();*/
              return reject({
                error: '/api/post/theater -> query_3 error'
              });
            }

            ids.id_projector = result.insertId; // Prendo l'id della insert.

            // Inserisco m_gpi
            db.query("INSERT INTO m_gpi (address, port, type) VALUES " +
              "(?,?,?)", [
              sanitizeString(payload.gpi.address),
              sanitizeString(payload.gpi.port),
              sanitizeString(payload.gpi.type),
            ], (qerr, result) => {

              // Errore creazione m_audioprocessor
              if (qerr) {
                /*db.release();*/
                return reject({
                  error: '/api/post/theater -> query_4 error'
                });
              }

              ids.id_gpi = result.insertId; // Prendo l'id della insert.

              // Inserisco m_switch
              db.query("INSERT INTO m_switch (address, port, type) VALUES " +
                "(?,?,?)", [
                sanitizeString(payload.switch.address),
                sanitizeString(payload.switch.port),
                sanitizeString(payload.switch.type)
              ], (qerr, result) => {

                // Errore creazione m_audioprocessor
                if (qerr) {
                  /*db.release();*/
                  return reject({
                    error: '/api/post/theater -> query_5 error'
                  });
                }

                ids.id_switch = result.insertId; // Prendo l'id della insert.

                // Inserisco m_theaters
                db.query("INSERT INTO m_theaters (name, theater_nr, id_imb, id_projector, id_audioprocessor, id_gpi, id_switch, description, note) VALUES " +
                  "(?,?,?,?,?,?,?,?,?)", [
                  sanitizeString(payload.name),
                  sanitizeString(payload.theater_nr),
                  ids.id_imb,
                  ids.id_projector,
                  ids.id_audioprocessor,
                  ids.id_gpi,
                  ids.id_switch,
                  sanitizeString(payload.description),
                  sanitizeString(payload.note)
                ], (qerr, result) => {

                  /*db.release();*/

                  if (qerr) {
                    console.log(qerr);
                    return reject({
                      error: '/api/post/theater -> query_6 error'
                    });
                  }

                  createDeviceManagerInstances(payload, result.insertId, db).then(dm_res => {

                    // OK !
                    //return res.status(200).send({ status: 1 });
                    return resolve();

                  }).catch(error => {

                    // errore creazione dvmanager
                    return reject();

                  });

                });

              });

            });

          });

        });

      });

  });

}

function createDeviceManagerInstances(payload, theater_id, db) {

  return new Promise((resolve, reject) => {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
 
        reject(); // Db failure
      }*/

    const nameInstance = theater_id;
    db.query("INSERT INTO m_instances (NAME, DESCRIPTION, COMPUTER , ID_THEATER) VALUES(?, ?, 'STREAMER' , ?)", [payload.name, sanitizeString(payload.name), theater_id], (qerr, result) => {

      if (qerr) { /*db.release();*/ return reject(); }
      const instanceID = result.insertId;

      // Instanza creata.<

      const broadCast_array = ip.address().split(".")
      const broadCastDVM = broadCast_array[0] + "." + broadCast_array[1] + "." + broadCast_array[2] + ".255";
      const dvmPort = "48" + (payload.theater_nr < 10 ? ("0" + payload.theater_nr) : payload.theater_nr) + "3";

      db.query("INSERT INTO m_instance_settings (ID_INSTANCE, KEY1, VALUESTRING) VALUES " +
        "(? , 'SelectedLanguage' , 'English') , " +
        "(? , 'BroadcastAddress' , ?) , " +
        "(? , 'Port' , ?) , " +
        "(? , 'Enable' , '0') , " +
        "(? , 'Days' , '1111111') , " +
        "(? , 'Hour' , '4') , " +
        "(? , 'Minute' , '2') ", [

        instanceID,
        instanceID, broadCastDVM,
        instanceID, dvmPort,
        instanceID,
        instanceID,
        instanceID,
        instanceID
      ], (qerr, result) => {

        // Creati i settings.
        if (qerr) { console.log(qerr); /*db.release();*/ return reject(); }

        async.forEachOf(devices_list, (device_, key, callback) => {

          let device_nr = (parseInt(key) + 1);
          // CREO Il DEVICE.
          db.query("INSERT INTO m_devices (ID_INSTANCE, DESCRIPTION) VALUES (? , ?)", [instanceID, ("Device_" + device_nr.toString())], (qerr, result) => {

            if (qerr) { return cb(); } // Errore creazione del device.

            let sql_string = "";
            let sql_params = [];
            let deviceID = result.insertId;

            // CREO I DEVICE_SETTINGS
            switch (device_) {

              // PROJECTOR
              case 'projector':
                sql_string = "INSERT INTO m_device_settings (ID_DEVICE, KEY1, VALUESTRING) VALUES" +
                  "( ? , 'Key' , ? ) , " +
                  "( ? , 'Description' , 'PROJECTOR' ) , " +
                  "( ? , 'Enabled' , ? ) , " +
                  "( ? , 'Type' , 7 ) , " + // TYPE FISSO A 7 PER PROJECTOR
                  "( ? , 'SerialPort' , ? ) , " +
                  "( ? , 'Projector_Type' , ? ) , " +
                  "( ? , 'Projector_BaudRate' , '0' ) , " +
                  "( ? , 'Projector_Description' , ? ) , " +
                  "( ? , 'Projector_WaitAfterWrite' , 0 ) , " +
                  "( ? , 'Projector_TimeoutReadStatus' , ? ) ";
                sql_params = [

                  deviceID, deviceID,
                  deviceID,
                  deviceID, Number(payload.projector.enabled),
                  deviceID,
                  deviceID, (sanitizeString(payload.projector.port) + ":" + sanitizeString(payload.projector.address)),
                  deviceID, sanitizeString(payload.projector.type),
                  deviceID,
                  deviceID, projector_type_label[parseInt(payload.projector.type)],
                  deviceID,
                  deviceID, sanitizeString(payload.projector.timeout_read_status)];
                break;


              // AUDIOPROCESSOR
              case 'audio':
                sql_string = "INSERT INTO m_device_settings (ID_DEVICE, KEY1, VALUESTRING) VALUES" +
                  "( ? , 'Key' , ? ) , " +
                  "( ? , 'Description' , 'AUDIO' ) , " +
                  "( ? , 'Enabled' , ? ) , " +
                  "( ? , 'Type' , 6 ) , " + // TYPE FISSO A 6 PER Audioprocessor
                  "( ? , 'SerialPort' , ? ) , " +
                  "( ? , 'AudioProcessor_Type' , ? ) , " +
                  "( ? , 'AudioProcessor_BaudRate' , '0' ) , " +
                  "( ? , 'AudioProcessor_Description' , ? ) , " +
                  "( ? , 'AudioProcessor_WaitAfterWrite' , 0 ) , " +
                  "( ? , 'AudioProcessor_TimeoutReadStatus' , ? ) ";
                sql_params = [

                  deviceID, deviceID,
                  deviceID,
                  deviceID, Number(payload.audio.enabled),
                  deviceID,
                  deviceID, (sanitizeString(payload.audio.port) + ":" + sanitizeString(payload.audio.address)),
                  deviceID, sanitizeString(payload.audio.type),
                  deviceID,
                  deviceID, audioprocessor_type_label[parseInt(payload.audio.type)],
                  deviceID,
                  deviceID, sanitizeString(payload.audio.timeout_read_status)];
                break;

              // GPI
              case 'gpi':
                sql_string = "INSERT INTO m_device_settings (ID_DEVICE, KEY1, VALUESTRING) VALUES" +
                  "( ? , 'Key' , ? ) , " +
                  "( ? , 'Description' , 'AUTOMATION' ) , " +
                  "( ? , 'Enabled' , ? ) , " +
                  "( ? , 'Type' , 1 ) , " + // TYPE FISSO A 1 PER gpi automation
                  "( ? , 'SerialPort' , ? ) , " +
                  "( ? , 'Gpi_Type' , ? ) , " +
                  "( ? , 'Gpi_Description' , ? ) , " +
                  "( ? , 'Gpi_TimeoutReadStatus' , ? ) ," +
                  "( ? , 'Gpi_MaxInput' , ? ) ," +
                  "( ? , 'Gpi_MaxOutput' , ? ) ," +
                  "( ? , 'Gpi_Device' , '' ) ";

                sql_params = [
                  deviceID, deviceID,
                  deviceID,
                  deviceID, Number(payload.gpi.enabled),
                  deviceID,
                  deviceID, (sanitizeString(payload.gpi.port) + ":" + sanitizeString(payload.gpi.address)),
                  deviceID, sanitizeString(payload.gpi.type),
                  deviceID, gpi_type_label[parseInt(payload.gpi.type)],
                  deviceID, sanitizeString(payload.gpi.timeout_read_status),
                  deviceID, gpi_type_io[parseInt(payload.gpi.type)].i,
                  deviceID, gpi_type_io[parseInt(payload.gpi.type)].o,
                  deviceID
                ];

                // Aggiungo input
                for (let i = 1; i <= parseInt(gpi_type_io[parseInt(payload.gpi.type)].i); i++) {
                  sql_string = sql_string + " , (? , ? , ?) , (? , ? , '') ";
                  sql_params.push(
                    deviceID, ("Gpi_LabelInput" + i.toString() + "_1"), ("IN " + i.toString()),
                    deviceID, ("Gpi_LabelInput" + i.toString() + "_2")
                  );
                }

                // Aggiungo output
                for (let i = 1; i <= parseInt(gpi_type_io[parseInt(payload.gpi.type)].o); i++) {
                  sql_string = sql_string + " , (? , ? , ?) , (? , ? , '') ";
                  sql_params.push(
                    deviceID, ("Gpi_LabelOutput" + i.toString() + "_1"), ("OUT " + i.toString()),
                    deviceID, ("Gpi_LabelOutput" + i.toString() + "_2")
                  );
                }

                break;

              // SWITCH / VIDEOROUTER
              case 'switch':
                sql_string = "INSERT INTO m_device_settings (ID_DEVICE, KEY1, VALUESTRING) VALUES" +
                  "( ? , 'Key' , ? ) , " +
                  "( ? , 'Description' , 'VIDEOROUTER' ) , " +
                  "( ? , 'Enabled' , ? ) , " +
                  "( ? , 'Type' , 0 ) , " + // TYPE FISSO A 0 PER viderouter
                  "( ? , 'SerialPort' , ? ) , " +
                  "( ? , 'VideoRouter_Type' , ? ) , " +
                  "( ? , 'VideoRouter_Description' , ? ) , " +
                  "( ? , 'VideoRouter_TimeoutReadStatus' , ? ) ," +
                  "( ? , 'VideoRouter_MaxInput' , ? ) ," +
                  "( ? , 'VideoRouter_MaxOutput' , ? ) ," +
                  "( ? , 'VideoRouter_MaxPreset' , 0 ) ," +
                  "( ? , 'VideoRouter_WaitAfterWrite' , 0 ) ," +
                  "( ? , 'VideoRouter_BaudRate' , 0 ) ," +
                  "( ? , 'VideoRouter_ExistOnlyAudioFollowVideo' , 1 ) ";

                sql_params = [
                  deviceID, deviceID,
                  deviceID,
                  deviceID, Number(payload.switch.enabled),
                  deviceID,
                  deviceID, (sanitizeString(payload.switch.port) + ":" + sanitizeString(payload.switch.address)),
                  deviceID, sanitizeString(payload.switch.type),
                  deviceID, switch_type_label[parseInt(payload.switch.type)],
                  deviceID, sanitizeString(payload.switch.timeout_read_status),
                  deviceID, switch_type_io[parseInt(payload.switch.type)].i,
                  deviceID, switch_type_io[parseInt(payload.switch.type)].o,
                  deviceID,
                  deviceID,
                  deviceID,
                  deviceID,
                ];

                // Aggiungo input
                for (let i = 1; i <= parseInt(switch_type_io[parseInt(payload.switch.type)].i); i++) {
                  sql_string = sql_string + " , (? , ? , ?) , (? , ? , '') ";
                  sql_params.push(
                    deviceID, ("VideoRouter_LabelInput" + i.toString() + "_1"), ("IN " + i.toString()),
                    deviceID, ("VideoRouter_LabelInput" + i.toString() + "_2")
                  );
                }

                // Aggiungo output
                for (let i = 1; i <= parseInt(switch_type_io[parseInt(payload.switch.type)].o); i++) {
                  sql_string = sql_string + " , (? , ? , ?) , (? , ? , '') ";
                  sql_params.push(
                    deviceID, ("VideoRouter_LabelOutput" + i.toString() + "_1"), ("OUT " + i.toString()),
                    deviceID, ("VideoRouter_LabelOutput" + i.toString() + "_2")
                  );
                }

                break;



            }

            // Type di Device sconosciuto nello switch case.
            if (sql_string === '') {
              return callback();
            }


            // Eseguo la query dei device settings.
            db.query(sql_string, sql_params, (qerr, result) => {

              if (qerr) { console.log(qerr); }

              // Se sono in GPI devo aggiungere gli input\output
              if (device_)

                return callback();

            });

          });


        }, (err) => {

          // Callback.
          /*db.release();*/
          resolve();

        });

      });

    });

  });


  //  });

}

function createDeviceTag(tagData, instancename, id_tag, db) {

  return new Promise((resolve, reject) => {

    db.query("SELECT b.ID FROM m_instances a LEFT JOIN m_device_tags b on b.ID_INSTANCE = a.ID WHERE a.NAME = ? AND b.DESCRIPTION = ?", [instancename, tagData.tag.DESCRIPTION], (qerr, check_exists) => {

      if (qerr || check_exists.length > 0)// return res.status(500).send({ error: 'name' });
        return reject({ error: 'name' });

      // Se siamo in generic, non serve cercare per l'id_device perchè non serve, QuiNDI, faccio tutto in una promise.
      getDevicesFromInstance(instancename, db).then(res_ => {

        db.query("SELECT ID FROM m_instances WHERE NAME = ?", [instancename], (qerr, result_id) => {

          if (qerr || result_id.length === 0) { /*db.release();*/ return res.status(500).send({ status: 0 }); }

          let uuid = uuidv4().toString().toUpperCase();

          console.log(uuid);

          db.query("INSERT INTO m_device_tags (ID_UNIVERSAL, DESCRIPTION, ENABLED, ID_INSTANCE) VALUES (? , ? , ? , ?)",
            [uuid.replace('/-/g', ''), tagData.tag.DESCRIPTION, Number(tagData.tag.ENABLED), result_id[0].ID], (qerr, result_insert) => {

              if (qerr) { /*db.release();*/ /*return res.status(500).send({ status: 0 });*/ return reject(); }

              // tolgo tutti i tag details attuali del tag per riscrivere quelli nuovi
              createTagDetailsRows(tagData, res_, result_insert.insertId, instancename, db).then(ress => {

                // Qua ho finito di inserire i tag details, devo fare l'update del tag stesso.
                // Se tutto ok, abbiamo finito.
                /*db.release();*/


                // devo aggiornare il tag...
                db.query("SELECT ID_THEATER FROM m_instances WHERE DESCRIPTION = ?", [instancename], (qerr, instance_) => {

                  for (let i = 0; i < devicemanager_ws_ports.length; i++) {

                    if (devicemanager_ws_ports[i].theater_id === instance_[0].ID_THEATER) {

                      //console.log('reload config dvm')
                      if (typeof clientWebSocketsDVM[i] !== 'undefined' && clientWebSocketsDVM[i].readyState === WebSocket.OPEN)
                        clientWebSocketsDVM[i].send('RELOADCONFIG\n');

                      break;

                    }

                  }

                  // Creo il tag per il generico solo nominativo...
                  db.query("SELECT b.ID FROM m_instances a LEFT JOIN m_device_tags b on b.ID_INSTANCE = a.ID WHERE a.NAME = 'G00' AND b.DESCRIPTION = ?", [tagData.tag.DESCRIPTION], (qerr, check_exists) => {

                    if (qerr || check_exists.length > 0) //return res.status(200).send({ status: 1 });
                      return resolve();

                    // se non esiste, va creato.
                    db.query("SELECT ID FROM m_instances WHERE NAME = 'G00'", (qerr, instances) => {

                      const generic_id = instances[0].ID;
                      let uuid_generic = uuidv4().toString().toUpperCase();

                      db.query("INSERT INTO m_device_tags (ID_UNIVERSAL, DESCRIPTION, ENABLED, ID_INSTANCE) VALUES (?,?,1,?)", [uuid_generic, tagData.tag.DESCRIPTION, generic_id], (qerr, tag) => {

                        //return res.status(200).send({ status: 1 });
                        return resolve();

                      });

                    });

                  });

                });

                //return res.status(200).send({ status: 1 });

              }).catch(err => {

                /*db.release();*/
                //return res.status(500).send({ status: 0 });
                return reject();

              });

            })

        });

      }).catch(err => {

        /*db.release();*/
        //return res.status(500).send({ status: 0 });
        return reject();

      })

    })

  });

}

function getDevicesFromInstance(instancename, db, detailed = false) {

  return new Promise((resolve, reject) => {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
        return reject();
      }*/

    if (instancename === 'G00') {
      return resolve({}); // ritorno json vuoto, tanto non ci serve.
    } else {

      db.query("SELECT a.* FROM m_devices a LEFT JOIN m_instances b ON b.ID = a.ID_INSTANCE WHERE b.NAME = ?", [instancename], (qerr, result) => {

        if (qerr || result.length === 0) { reject(); }
        var devices_instance = [];

        async.forEachOf(result, (device_, key, callback) => {

          db.query("SELECT VALUESTRING FROM m_device_settings WHERE KEY1 = 'Type' AND ID_DEVICE = ?", [device_.ID], (qerr, result_) => {

            if (qerr || result.length === 0) { return callback(false); }

            if (!detailed) {

              // Non dettagliato, solo per update\insert del tag.
              devices_instance[result_[0].VALUESTRING] = device_.ID; // collego il type del device all'id device del db.
              return callback();

            } else {

              // dettagli per la richiesta di devicemanager per la select dei device disponibili per istanza SE non siamo nella generic.
              let query_description = "";
              let array_type_to_label = []

              switch (Number(result_[0].VALUESTRING)) {

                case 7:
                  query_description = "SELECT c.type FROM m_instances a LEFT JOIN m_theaters b on b.id = a.ID_THEATER LEFT JOIN m_projector c on c.id = b.id_projector WHERE a.NAME = ?"
                  array_type_to_label = projector_type_label;
                  break;

                case 6:
                  query_description = "SELECT c.type FROM m_instances a LEFT JOIN m_theaters b on b.id = a.ID_THEATER LEFT JOIN m_audioprocessor c on c.id = b.id_audioprocessor WHERE a.NAME = ?"
                  array_type_to_label = audioprocessor_type_label;
                  break;

                case 1:
                  query_description = "SELECT c.type FROM m_instances a LEFT JOIN m_theaters b on b.id = a.ID_THEATER LEFT JOIN m_gpi c on c.id = b.id_gpi WHERE a.NAME = ?"
                  array_type_to_label = gpi_type_label;
                  break;

                case 0:
                  query_description = "SELECT c.type FROM m_instances a LEFT JOIN m_theaters b on b.id = a.ID_THEATER LEFT JOIN m_switch c on c.id = b.id_switch WHERE a.NAME = ?"
                  array_type_to_label = switch_type_label;
                  break;

              }

              // Il type del device non è supportato..
              if (query_description === "") { devices_instance.push({ device_id: device_.ID, device_type_label: '', device_type: result_[0].VALUESTRING }); return callback(); }

              db.query(query_description, [instancename], (qerr, inst_res) => {

                if (qerr || inst_res.length === 0) { // Non abbiamo il record di questa istanza per questo device... strano tho...
                  devices_instance.push({ device_id: device_.ID, device_type_label: '', device_type: result_[0].VALUESTRING });
                  return callback();
                }

                devices_instance.push({ device_id: device_.ID, device_type_label: array_type_to_label[parseInt(inst_res[0].type)], device_type: result_[0].VALUESTRING });
                return callback();

              });

            }

          });

        }, (cb) => {

          return resolve(devices_instance);

        })

      })

    }

  });

  //});

}


function createTagDetailsRows(tagData, devices_, id_tag, instancename, db) {

  return new Promise((resolve, reject) => {

    /*pool.getConnection(function(conn_err, db){
      if(conn_err){ // connessione db fallita
        return reject();
      }*/

    async.forEachOf(tagData.details, (detail, key_detail, callback) => {

      async.forEachOf(detail, (row_tag_detail, key_row, callback_inner) => {

        if (row_tag_detail.KEY1 === 'Projector_Value' && row_tag_detail.VALUESTRING.indexOf("$") > 0) {

          // è una macro della tabella macro_projectors.
          let temp = row_tag_detail.VALUESTRING.split("$");
          row_tag_detail.VALUESTRING = temp[temp.length - 1]; // la macro sta alla fine del'array.
        }

        if (row_tag_detail.KEY1 === 'ID_DEVICE') // Salto se è un ID_Device.
          return callback_inner();

        // ..............Inserisco il pezzo del tag detail.
        db.query("INSERT INTO m_device_tag_details (ID_TAG, ID_DETAIL, KEY1, VALUESTRING) VALUES (?,?,?,?)",
          [id_tag, (key_detail + 1), row_tag_detail.KEY1, row_tag_detail.VALUESTRING], (qerr, result_insert) => {
            return callback_inner();
          });

      }, (cb_inn) => {

        // cerco di che device siamo per trovarne l'id di questa istanza
        return new Promise((resolve1, reject1) => {

          if (instancename === 'G00') // skippo la general
            return resolve1("");

          let type_device = "";
          async.forEachOf(detail, (row_tag_detail, key, callback_row) => {

            if (type_device !== "")
              return callback_row();

            // SIAMO NEL GENERIC, DEVO CAPIRE DI CHE DEVICE TYPE SI TRATTA.
            if (row_tag_detail.KEY1.indexOf("Projector_") >= 0)
              type_device = 7;

            if (row_tag_detail.KEY1.indexOf("AudioProcessor_") >= 0)
              type_device = 6;

            if (row_tag_detail.KEY1.indexOf("Gpi_") >= 0)
              type_device = 1;

            if (row_tag_detail.KEY1.indexOf("VideoRouter_") >= 0)
              type_device = 0;

            if (row_tag_detail.KEY1.indexOf("CustomCmd") >= 0)
              type_device = 99;

            return callback_row();

          }, (callback_g00) => {
            return resolve1(type_device);
          });


        }).then(type_device => {

          if (instancename === 'G00' || type_device === "")
            return callback();
          else {

            // Inserisco l'id device nel tag detail
            db.query("INSERT INTO m_device_tag_details (ID_TAG, ID_DETAIL, KEY1, VALUESTRING) VALUES (?,?,?,?)", [id_tag, (key_detail + 1), 'ID_DEVICE', devices_[Number(type_device)]], (qerr, result_id_device) => {
              return callback();
            });

          }

        })

      });

    }, (cb) => {

      /*db.release();*/
      return resolve();

    });

  });

  //  });

}


function sanitizeString(str) {

  if (typeof str === 'undefined' || str === null)
    return "";

  str = str.toString();
  str = str.replace(/[^a-z0-9áéíóúñüàèìòù@% \.,_()-]/gim, "");
  return str.trim();
}

/***/ }),

/***/ 97234:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var Buffer = __webpack_require__(64293)["Buffer"];

Object.defineProperty(exports, "__esModule", ({ value: true }));
// **Github:** https://github.com/fidm/asn1
//
// **License:** MIT
const util_1 = __webpack_require__(31669);
const common_1 = __webpack_require__(42891);
/**
 * ASN.1 classes.
 */
var Class;
(function (Class) {
    Class[Class["UNIVERSAL"] = 0] = "UNIVERSAL";
    Class[Class["APPLICATION"] = 64] = "APPLICATION";
    Class[Class["CONTEXT_SPECIFIC"] = 128] = "CONTEXT_SPECIFIC";
    Class[Class["PRIVATE"] = 192] = "PRIVATE";
})(Class = exports.Class || (exports.Class = {}));
/**
 * ASN.1 types. Not all types are supported by this implementation.
 */
var Tag;
(function (Tag) {
    Tag[Tag["NONE"] = 0] = "NONE";
    Tag[Tag["BOOLEAN"] = 1] = "BOOLEAN";
    Tag[Tag["INTEGER"] = 2] = "INTEGER";
    Tag[Tag["BITSTRING"] = 3] = "BITSTRING";
    Tag[Tag["OCTETSTRING"] = 4] = "OCTETSTRING";
    Tag[Tag["NULL"] = 5] = "NULL";
    Tag[Tag["OID"] = 6] = "OID";
    // ODESC = 7,
    // EXTERNAL = 8,
    // REAL = 9,
    Tag[Tag["ENUMERATED"] = 10] = "ENUMERATED";
    // EMBEDDED = 11,
    Tag[Tag["UTF8"] = 12] = "UTF8";
    // ROID = 13,
    Tag[Tag["SEQUENCE"] = 16] = "SEQUENCE";
    Tag[Tag["SET"] = 17] = "SET";
    Tag[Tag["NUMERICSTRING"] = 18] = "NUMERICSTRING";
    Tag[Tag["PRINTABLESTRING"] = 19] = "PRINTABLESTRING";
    Tag[Tag["T61STRING"] = 20] = "T61STRING";
    Tag[Tag["IA5STRING"] = 22] = "IA5STRING";
    Tag[Tag["UTCTIME"] = 23] = "UTCTIME";
    Tag[Tag["GENERALIZEDTIME"] = 24] = "GENERALIZEDTIME";
    Tag[Tag["GENERALSTRING"] = 27] = "GENERALSTRING";
})(Tag = exports.Tag || (exports.Tag = {}));
/**
 * BitString is the structure to use when you want an ASN.1 BIT STRING type. A
 * bit string is padded up to the nearest byte in memory and the number of
 * valid bits is recorded. Padding bits will be zero.
 */
class BitString {
    constructor(buf, bitLen) {
        this.buf = buf;
        this.bitLen = bitLen;
    }
    /**
     * Returns the value for the given bits offset.
     * @param i bits offet
     */
    at(i) {
        if (i < 0 || i >= this.bitLen || !Number.isInteger(i)) {
            return 0;
        }
        const x = Math.floor(i / 8);
        const y = 7 - i % 8;
        return (this.buf[x] >> y) & 1;
    }
    /**
     * Align buffer
     */
    rightAlign() {
        const shift = 8 - (this.bitLen % 8);
        if (shift === 8 || this.buf.length === 0) {
            return this.buf;
        }
        const buf = Buffer.alloc(this.buf.length);
        buf[0] = this.buf[0] >> shift;
        for (let i = 1; i < this.buf.length; i++) {
            buf[i] = this.buf[i - 1] << (8 - shift);
            buf[i] |= this.buf[i] >> shift;
        }
        return buf;
    }
}
exports.BitString = BitString;
/**
 * Implements parsing of DER-encoded ASN.1 data structures,
 * as defined in ITU-T Rec X.690.
 *
 * See also ``A Layman's Guide to a Subset of ASN.1, BER, and DER,''
 * http://luca.ntop.org/Teaching/Appunti/asn1.html.
 *
 * ASN.1 is a syntax for specifying abstract objects and BER, DER, PER, XER etc
 * are different encoding formats for those objects. Here, we'll be dealing
 * with DER, the Distinguished Encoding Rules. DER is used in X.509 because
 * it's fast to parse and, unlike BER, has a unique encoding for every object.
 * When calculating hashes over objects, it's important that the resulting
 * bytes be the same at both ends and DER removes this margin of error.
 * ASN.1 is very complex and this package doesn't attempt to implement
 * everything by any means.
 *
 * DER Encoding of ASN.1 Types:
 * https://msdn.microsoft.com/en-us/library/windows/desktop/bb540792(v=vs.85).aspx
 */
class ASN1 {
    /**
     * Creates a Tag.BOOLEAN ASN.1 object.
     * @param val boolean value.
     */
    static Bool(val) {
        const asn1 = new ASN1(Class.UNIVERSAL, Tag.BOOLEAN, Buffer.from([val ? 0xff : 0x0]));
        asn1._value = val;
        return asn1;
    }
    /**
     * Parse a Tag.BOOLEAN value from ASN.1 object' value.
     * @param buf the buffer to parse.
     */
    static parseBool(buf) {
        if (!(buf instanceof Buffer) || buf.length !== 1) {
            throw new Error('ASN1 syntax error: invalid boolean');
        }
        switch (buf[0]) {
            case 0:
                return false;
            case 0xff:
                return true;
            default:
                throw new Error('ASN1 syntax error: invalid boolean');
        }
    }
    /**
     * Creates a Tag.INTEGER ASN.1 object.
     * @param val integer value or buffer.
     */
    static Integer(val) {
        if (val instanceof Buffer) {
            const asn = new ASN1(Class.UNIVERSAL, Tag.INTEGER, val);
            asn._value = val.toString('hex');
            return asn;
        }
        if (!Number.isSafeInteger(val)) {
            throw new Error('ASN1 syntax error: invalid integer');
        }
        let buf;
        if (val >= -0x80 && val < 0x80) {
            buf = Buffer.alloc(1);
            buf.writeInt8(val, 0);
        }
        else if (val >= -0x8000 && val < 0x8000) {
            buf = Buffer.alloc(2);
            buf.writeIntBE(val, 0, 2);
        }
        else if (val >= -0x800000 && val < 0x800000) {
            buf = Buffer.alloc(3);
            buf.writeIntBE(val, 0, 3);
        }
        else if (val >= -0x80000000 && val < 0x80000000) {
            buf = Buffer.alloc(4);
            buf.writeIntBE(val, 0, 4);
        }
        else if (val >= -0x8000000000 && val < 0x8000000000) {
            buf = Buffer.alloc(5);
            buf.writeIntBE(val, 0, 5);
        }
        else if (val >= -0x800000000000 && val < 0x800000000000) {
            buf = Buffer.alloc(6);
            buf.writeIntBE(val, 0, 6);
        }
        else {
            throw new Error('ASN1 syntax error: invalid Integer');
        }
        const asn1 = new ASN1(Class.UNIVERSAL, Tag.INTEGER, buf);
        asn1._value = val;
        return asn1;
    }
    /**
     * Parse a Tag.INTEGER value from ASN.1 object' value.
     * @param buf the buffer to parse.
     */
    static parseInteger(buf) {
        if (!(buf instanceof Buffer) || buf.length === 0) {
            throw new Error('ASN1 syntax error: invalid Integer');
        }
        // some INTEGER (BigInt) will be 16 bytes, 32 bytes or others.
        // CertificateSerialNumber ::= INTEGER (>= 16 bytes)
        if (buf.length > 6) {
            return buf.toString('hex');
        }
        return buf.readIntBE(0, buf.length);
    }
    /**
     * Parse a Tag.INTEGER value as a number from ASN.1 object' value.
     * @param buf the buffer to parse.
     */
    static parseIntegerNum(buf) {
        const value = ASN1.parseInteger(buf);
        if (typeof value !== 'number') {
            throw new Error('ASN1 syntax error: invalid Integer number');
        }
        return value;
    }
    /**
     * Parse a Tag.INTEGER value as a hex string(for BigInt) from ASN.1 object' value.
     * @param buf the buffer to parse.
     */
    static parseIntegerStr(buf) {
        const value = ASN1.parseInteger(buf);
        if (typeof value === 'number') {
            return value.toString(16);
        }
        return value;
    }
    /**
     * Creates a Tag.BITSTRING ASN.1 object.
     * @param val BitString object or buffer.
     */
    static BitString(val) {
        if (val instanceof Buffer) {
            val = new BitString(val, val.length * 8);
        }
        const paddingBits = val.buf.length * 8 - val.bitLen;
        const buf = Buffer.alloc(val.buf.length + 1);
        buf.writeInt8(paddingBits, 0);
        val.buf.copy(buf, 1);
        return new ASN1(Class.UNIVERSAL, Tag.BITSTRING, buf);
    }
    /**
     * Parse a Tag.BITSTRING value from ASN.1 object' value.
     * @param buf the buffer to parse.
     */
    static parseBitString(buf) {
        if (!(buf instanceof Buffer) || buf.length === 0) {
            throw new Error('ASN1 syntax error: invalid BitString');
        }
        const paddingBits = buf[0];
        if (paddingBits > 7 ||
            buf.length === 1 && paddingBits > 0 ||
            (buf[buf.length - 1] & ((1 << buf[0]) - 1)) !== 0) {
            throw new Error('ASN1 syntax error: invalid padding bits in BIT STRING');
        }
        return new BitString(buf.slice(1), (buf.length - 1) * 8 - paddingBits);
    }
    /**
     * Creates a Tag.NULL ASN.1 object.
     */
    static Null() {
        const asn1 = new ASN1(Class.UNIVERSAL, Tag.NULL, Buffer.alloc(0));
        asn1._value = null;
        return asn1;
    }
    /**
     * Parse a Tag.NULL value from ASN.1 object' value.
     * @param buf the buffer to parse.
     */
    static parseNull(buf) {
        if (!(buf instanceof Buffer) || buf.length !== 0) {
            throw new Error('ASN1 syntax error: invalid null');
        }
        return null;
    }
    /**
     * Creates an Tag.OID (dot-separated numeric string) ASN.1 object.
     * @param val dot-separated numeric string.
     */
    static OID(val) {
        const values = val.split('.');
        if (values.length === 0) {
            throw new Error('ASN1 syntax error: invalid Object Identifier');
        }
        const bytes = [];
        // first byte is 40 * value1 + value2
        bytes.push(40 * mustParseInt(values[0]) + mustParseInt(values[1]));
        // other bytes are each value in base 128 with 8th bit set except for
        // the last byte for each value
        const valueBytes = [];
        for (let i = 2; i < values.length; ++i) {
            let value = mustParseInt(values[i]);
            valueBytes.length = 0;
            valueBytes.push(value & 0x7f);
            while (value > 0x7f) {
                value = value >>> 7;
                valueBytes.unshift((value & 0x7f) | 0x80); // add value bytes in reverse for big endian
            }
            bytes.push(...valueBytes);
        }
        const asn1 = new ASN1(Class.UNIVERSAL, Tag.OID, Buffer.from(bytes));
        asn1._value = val;
        return asn1;
    }
    /**
     * Parse a Tag.OID value from ASN.1 object' value.
     * @param buf the buffer to parse.
     */
    static parseOID(buf) {
        if (!(buf instanceof Buffer) || buf.length === 0) {
            throw new Error('ASN1 syntax error: invalid OID');
        }
        // first byte is 40 * value1 + value2
        let oid = Math.floor(buf[0] / 40) + '.' + (buf[0] % 40);
        // other bytes are each value in base 128 with 8th bit set except for
        // the last byte for each value
        let high = 0;
        for (let i = 1; i < buf.length; i++) {
            // not the last byte for the value
            if (buf[i] >= 0x80) {
                high += buf[i] & 0x7F;
                high = high << 7;
            }
            else {
                oid += '.' + (high + buf[i]);
                high = 0;
            }
        }
        return oid;
    }
    /**
     * Creates an Tag.UTF8 ASN.1 object.
     * @param val utf8 string.
     */
    static UTF8(val) {
        const asn1 = new ASN1(Class.UNIVERSAL, Tag.UTF8, Buffer.from(val, 'utf8'));
        asn1._value = val;
        return asn1;
    }
    /**
     * Parse a Tag.UTF8 string from ASN.1 object' value.
     * @param buf the buffer to parse.
     */
    static parseUTF8(buf) {
        if (!(buf instanceof Buffer)) {
            throw new Error('parse ASN1 error: invalid Buffer');
        }
        return buf.toString('utf8');
    }
    /**
     * Creates an Tag.NUMERICSTRING ASN.1 object.
     * @param val numeric string.
     */
    static NumericString(val) {
        if (!isNumericString(val)) {
            throw new Error('ASN1 syntax error: invalid NumericString');
        }
        const asn1 = new ASN1(Class.UNIVERSAL, Tag.NUMERICSTRING, Buffer.from(val, 'utf8'));
        asn1._value = val;
        return asn1;
    }
    /**
     * Parse a Tag.UTF8 string from ASN.1 object' value.
     * @param buf the buffer to parse.
     */
    static parseNumericString(buf) {
        if (!(buf instanceof Buffer)) {
            throw new Error('parse ASN1 error: invalid Buffer');
        }
        const str = buf.toString('utf8');
        if (!isNumericString(str)) {
            throw new Error('ASN1 syntax error: invalid NumericString');
        }
        return str;
    }
    /**
     * Creates an Tag.NUMERICSTRING ASN.1 object.
     * @param val printable string.
     */
    static PrintableString(val) {
        // TODO, validate
        const asn1 = new ASN1(Class.UNIVERSAL, Tag.PRINTABLESTRING, Buffer.from(val, 'utf8'));
        asn1._value = val;
        return asn1;
    }
    /**
     * Parse a Tag.PRINTABLESTRING string from ASN.1 object' value.
     * @param buf the buffer to parse.
     */
    static parsePrintableString(buf) {
        if (!(buf instanceof Buffer)) {
            throw new Error('parse ASN1 error: invalid Buffer');
        }
        // TODO, validate
        return buf.toString('utf8');
    }
    /**
     * Creates an Tag.IA5STRING (ASCII string) ASN.1 object.
     * @param val ASCII string.
     */
    static IA5String(val) {
        if (!isIA5String(val)) {
            throw new Error('ASN1 syntax error: invalid IA5String');
        }
        const asn1 = new ASN1(Class.UNIVERSAL, Tag.IA5STRING, Buffer.from(val, 'utf8'));
        asn1._value = val;
        return asn1;
    }
    /**
     * Parse a Tag.IA5STRING string from ASN.1 object' value.
     * @param buf the buffer to parse.
     */
    static parseIA5String(buf) {
        if (!(buf instanceof Buffer)) {
            throw new Error('parse ASN1 error: invalid Buffer');
        }
        const str = buf.toString('utf8');
        if (!isIA5String(str)) {
            throw new Error('ASN1 syntax error: invalid IA5String');
        }
        return str;
    }
    /**
     * Creates an Tag.T61STRING (8-bit clean string) ASN.1 object.
     * @param val 8-bit clean string.
     */
    static T61String(val) {
        // TODO, validate
        const asn1 = new ASN1(Class.UNIVERSAL, Tag.T61STRING, Buffer.from(val, 'utf8'));
        asn1._value = val;
        return asn1;
    }
    /**
     * Parse a Tag.T61STRING string from ASN.1 object' value.
     * @param buf the buffer to parse.
     */
    static parseT61String(buf) {
        if (!(buf instanceof Buffer)) {
            throw new Error('parse ASN1 error: invalid Buffer');
        }
        // TODO, validate
        return buf.toString('utf8');
    }
    /**
     * Creates an Tag.GENERALSTRING (specified in ISO-2022/ECMA-35) ASN.1 object.
     * @param val general string.
     */
    static GeneralString(val) {
        // TODO, validate
        const asn1 = new ASN1(Class.UNIVERSAL, Tag.GENERALSTRING, Buffer.from(val, 'utf8'));
        asn1._value = val;
        return asn1;
    }
    /**
     * Parse a Tag.GENERALSTRING string from ASN.1 object' value.
     * @param buf the buffer to parse.
     */
    static parseGeneralString(buf) {
        if (!(buf instanceof Buffer)) {
            throw new Error('parse ASN1 error: invalid Buffer');
        }
        // TODO, validate
        return buf.toString('utf8');
    }
    /**
     * Creates an Tag.UTCTIME ASN.1 object.
     *
     * Note: GeneralizedTime has 4 digits for the year and is used for X.509.
     * dates past 2049. Converting to a GeneralizedTime hasn't been implemented yet.
     * @param date date value.
     */
    static UTCTime(date) {
        let rval = '';
        // create format YYMMDDhhmmssZ
        const format = [];
        format.push(('' + date.getUTCFullYear()).substr(2));
        format.push('' + (date.getUTCMonth() + 1));
        format.push('' + date.getUTCDate());
        format.push('' + date.getUTCHours());
        format.push('' + date.getUTCMinutes());
        format.push('' + date.getUTCSeconds());
        // ensure 2 digits are used for each format entry
        for (const s of format) {
            if (s.length < 2) {
                rval += '0';
            }
            rval += s;
        }
        rval += 'Z';
        const asn1 = new ASN1(Class.UNIVERSAL, Tag.UTCTIME, Buffer.from(rval, 'utf8'));
        asn1._value = date;
        return asn1;
    }
    /**
     * Parse a Tag.UTCTIME date from ASN.1 object' value.
     * @param buf the buffer to parse.
     */
    static parseUTCTime(buf) {
        if (!(buf instanceof Buffer) || buf.length === 0) {
            throw new Error('ASN1 syntax error: invalid UTC Time');
        }
        const utc = buf.toString('utf8');
        /* The following formats can be used:
    
          YYMMDDhhmmZ
          YYMMDDhhmm+hh'mm'
          YYMMDDhhmm-hh'mm'
          YYMMDDhhmmssZ
          YYMMDDhhmmss+hh'mm'
          YYMMDDhhmmss-hh'mm'
    
          Where:
    
          YY is the least significant two digits of the year
          MM is the month (01 to 12)
          DD is the day (01 to 31)
          hh is the hour (00 to 23)
          mm are the minutes (00 to 59)
          ss are the seconds (00 to 59)
          Z indicates that local time is GMT, + indicates that local time is
          later than GMT, and - indicates that local time is earlier than GMT
          hh' is the absolute value of the offset from GMT in hours
          mm' is the absolute value of the offset from GMT in minutes */
        const date = new Date();
        // if YY >= 50 use 19xx, if YY < 50 use 20xx
        let year = mustParseInt(utc.substr(0, 2));
        year = (year >= 50) ? 1900 + year : 2000 + year;
        const MM = mustParseInt(utc.substr(2, 2)) - 1; // use 0-11 for month
        const DD = mustParseInt(utc.substr(4, 2));
        const hh = mustParseInt(utc.substr(6, 2));
        const mm = mustParseInt(utc.substr(8, 2));
        let ss = 0;
        let end = 0;
        // get character after minutes
        let c = '';
        // not just YYMMDDhhmmZ
        if (utc.length > 11) {
            end = 10;
            // get character after minutes
            c = utc.charAt(end);
            // see if seconds are present
            if (c !== '+' && c !== '-') {
                // get seconds
                ss = mustParseInt(utc.substr(10, 2));
                end += 2;
            }
        }
        // update date
        date.setUTCFullYear(year, MM, DD);
        date.setUTCHours(hh, mm, ss, 0);
        if (end > 0) {
            // get +/- after end of time
            c = utc.charAt(end);
            if (c === '+' || c === '-') {
                // get hours+minutes offset
                const hhoffset = mustParseInt(utc.substr(end + 1, 2));
                const mmoffset = mustParseInt(utc.substr(end + 4, 2));
                // calculate offset in milliseconds
                let offset = hhoffset * 60 + mmoffset;
                offset *= 60000;
                // apply offset
                if (c === '+') {
                    date.setTime(+date - offset);
                }
                else {
                    date.setTime(+date + offset);
                }
            }
        }
        return date;
    }
    /**
     * Creates an Tag.GENERALIZEDTIME ASN.1 object.
     * @param date date value.
     */
    static GeneralizedTime(date) {
        let rval = '';
        // create format YYYYMMDDHHMMSSZ
        const format = [];
        format.push('' + date.getUTCFullYear());
        format.push('' + (date.getUTCMonth() + 1));
        format.push('' + date.getUTCDate());
        format.push('' + date.getUTCHours());
        format.push('' + date.getUTCMinutes());
        format.push('' + date.getUTCSeconds());
        // ensure 2 digits are used for each format entry
        for (const s of format) {
            if (s.length < 2) {
                rval += '0';
            }
            rval += s;
        }
        rval += 'Z';
        const asn1 = new ASN1(Class.UNIVERSAL, Tag.GENERALIZEDTIME, Buffer.from(rval, 'utf8'));
        asn1._value = date;
        return asn1;
    }
    /**
     * Parse a Tag.GENERALIZEDTIME date from ASN.1 object' value.
     * @param buf the buffer to parse.
     */
    static parseGeneralizedTime(buf) {
        if (!(buf instanceof Buffer) || buf.length === 0) {
            throw new Error('ASN1 syntax error: invalid Generalized Time');
        }
        const gentime = buf.toString('utf8');
        /* The following formats can be used:
    
          YYYYMMDDHHMMSS
          YYYYMMDDHHMMSS.fff
          YYYYMMDDHHMMSSZ
          YYYYMMDDHHMMSS.fffZ
          YYYYMMDDHHMMSS+hh'mm'
          YYYYMMDDHHMMSS.fff+hh'mm'
          YYYYMMDDHHMMSS-hh'mm'
          YYYYMMDDHHMMSS.fff-hh'mm'
    
          Where:
    
          YYYY is the year
          MM is the month (01 to 12)
          DD is the day (01 to 31)
          hh is the hour (00 to 23)
          mm are the minutes (00 to 59)
          ss are the seconds (00 to 59)
          .fff is the second fraction, accurate to three decimal places
          Z indicates that local time is GMT, + indicates that local time is
          later than GMT, and - indicates that local time is earlier than GMT
          hh' is the absolute value of the offset from GMT in hours
          mm' is the absolute value of the offset from GMT in minutes */
        const date = new Date();
        const YYYY = mustParseInt(gentime.substr(0, 4));
        const MM = mustParseInt(gentime.substr(4, 2)) - 1; // use 0-11 for month
        const DD = mustParseInt(gentime.substr(6, 2));
        const hh = mustParseInt(gentime.substr(8, 2));
        const mm = mustParseInt(gentime.substr(10, 2));
        const ss = mustParseInt(gentime.substr(12, 2));
        let fff = 0;
        let offset = 0;
        let isUTC = false;
        if (gentime.charAt(gentime.length - 1) === 'Z') {
            isUTC = true;
        }
        const end = gentime.length - 5;
        const c = gentime.charAt(end);
        if (c === '+' || c === '-') {
            // get hours+minutes offset
            const hhoffset = mustParseInt(gentime.substr(end + 1, 2));
            const mmoffset = mustParseInt(gentime.substr(end + 4, 2));
            // calculate offset in milliseconds
            offset = hhoffset * 60 + mmoffset;
            offset *= 60000;
            // apply offset
            if (c === '+') {
                offset *= -1;
            }
            isUTC = true;
        }
        // check for second fraction
        if (gentime.charAt(14) === '.') {
            fff = parseFloat(gentime.substr(14)) * 1000;
        }
        if (isUTC) {
            date.setUTCFullYear(YYYY, MM, DD);
            date.setUTCHours(hh, mm, ss, fff);
            // apply offset
            date.setTime(+date + offset);
        }
        else {
            date.setFullYear(YYYY, MM, DD);
            date.setHours(hh, mm, ss, fff);
        }
        return date;
    }
    /**
     * Parse a Tag.UTCTIME date of Tag.GENERALIZEDTIME date from ASN.1 object' value.
     * @param tag the type.
     * @param buf the buffer to parse.
     */
    static parseTime(tag, buf) {
        switch (tag) {
            case Tag.UTCTIME:
                return ASN1.parseUTCTime(buf);
            case Tag.GENERALIZEDTIME:
                return ASN1.parseGeneralizedTime(buf);
            default:
                throw new Error('Invalid ASN1 time tag');
        }
    }
    /**
     * Creates an Tag.SET ASN.1 object.
     * @param objs an array of ASN.1 objects.
     */
    static Set(objs) {
        const asn1 = new ASN1(Class.UNIVERSAL, Tag.SET, Buffer.concat(objs.map((obj) => obj.toDER())));
        asn1._value = objs;
        return asn1;
    }
    /**
     * Creates an Tag.SEQUENCE ASN.1 object.
     * @param objs an array of ASN.1 objects.
     */
    static Seq(objs) {
        const asn1 = new ASN1(Class.UNIVERSAL, Tag.SEQUENCE, Buffer.concat(objs.map((obj) => obj.toDER())));
        asn1._value = objs;
        return asn1;
    }
    /**
     * Creates an Class.CONTEXT_SPECIFIC ASN.1 object.
     *
     * Note: the tag means nothing with Class.CONTEXT_SPECIFIC
     * @param tag number.
     * @param objs an array of ASN.1 objects or a ASN.1 object.
     * @param isCompound when objs is a array, the isCompound will be set to true.
     */
    static Spec(tag, objs, isCompound = true) {
        const bytes = Array.isArray(objs) ? Buffer.concat(objs.map((obj) => obj.toDER())) : objs.toDER();
        if (Array.isArray(objs)) {
            isCompound = true;
        }
        const asn1 = new ASN1(Class.CONTEXT_SPECIFIC, tag, bytes, isCompound);
        asn1._value = objs;
        return asn1;
    }
    /**
     * Parse a ASN.1 object from a buffer in DER format.
     *
     * @param buf the buffer to parse.
     * @param deepParse deeply parse or not.
     */
    static fromDER(buf, deepParse = false) {
        return ASN1._fromDER(new common_1.BufferVisitor(buf), deepParse);
    }
    /**
     * Parse a ASN.1 object from a buffer in DER format with given class and tag.
     * If class or tag is not match, it will throw a error.
     *
     * @param tagClass expect class to parse.
     * @param tag expect type to parse.
     * @param buf the buffer to parse.
     */
    static parseDER(buf, tagClass, tag) {
        const obj = ASN1._fromDER(new common_1.BufferVisitor(buf), false);
        if (obj.class !== tagClass && obj.tag !== tag) {
            throw new Error(`invalid ASN.1 DER for class ${tagClass} and tag ${tag}`);
        }
        return obj;
    }
    /**
     * Parse a ASN.1 object from a buffer in DER format with given Template object.
     * If template is not match, it will throw a error.
     *
     * @param buf the buffer to parse.
     * @param tpl expect template to parse.
     *
     * @return a Captures object with captured ASN.1 objects
     */
    static parseDERWithTemplate(buf, tpl) {
        const obj = ASN1._fromDER(new common_1.BufferVisitor(buf), true);
        const captures = {};
        const err = obj.validate(tpl, captures);
        if (err != null) {
            err.data = obj;
            throw err;
        }
        return captures;
    }
    static _parseCompound(buf, deepParse) {
        const values = [];
        const len = buf.length;
        const bufv = new common_1.BufferVisitor(buf);
        let readByteLen = 0;
        while (readByteLen < len) {
            const start = bufv.end;
            values.push(ASN1._fromDER(bufv, deepParse));
            readByteLen += bufv.end - start;
        }
        return values;
    }
    // Internal function to parse an asn1 object from a byte buffer in DER format.
    static _fromDER(bufv, deepParse) {
        if (!(bufv.buf instanceof Buffer) || bufv.length === 0) {
            throw new Error('ASN1 syntax error: invalid Generalized Time');
        }
        bufv.mustWalk(1, 'Too few bytes to read ASN.1 tag.');
        const start = bufv.start;
        const b1 = bufv.buf[start];
        const tagClass = b1 & 0xc0;
        const tag = b1 & 0x1f;
        // value storage
        const valueLen = getValueLength(bufv);
        bufv.mustHas(valueLen);
        if (valueLen !== 0 && tag === Tag.NULL) {
            throw new Error('invalid value length or NULL tag.');
        }
        bufv.mustWalk(valueLen);
        const isCompound = ((b1 & 0x20) === 0x20);
        const asn1 = new ASN1(tagClass, tag, bufv.buf.slice(bufv.start, bufv.end), isCompound);
        if (isCompound && deepParse) {
            asn1._value = ASN1._parseCompound(asn1.bytes, deepParse);
        }
        asn1._der = bufv.buf.slice(start, bufv.end);
        return asn1;
    }
    constructor(tagClass, tag, data, isCompound = false) {
        this.class = tagClass;
        this.tag = tag;
        this.bytes = data;
        // CONTEXT_SPECIFIC, SEQUENCE, SET, others...
        this.isCompound = isCompound || tag === Tag.SEQUENCE || tag === Tag.SET;
        this._value = undefined;
        this._der = null;
    }
    /**
     * the well parsed value of this ASN.1 object.
     * It will be boolean, number, string, BitString, Date, array of ASN.1 objects and so on.
     */
    get value() {
        if (this._value === undefined) {
            this._value = this.valueOf();
        }
        return this._value;
    }
    /**
     * the DER format Buffer of this ASN.1 object.
     */
    get DER() {
        if (this._der == null) {
            this._der = this.toDER();
        }
        return this._der;
    }
    /**
     * Expecting it is compound ASN.1 object and returns an array of sub ASN.1 objects.
     * @param msg error message to throw when it is not compound ASN.1 object.
     */
    mustCompound(msg = 'asn1 object value is not compound') {
        if (!this.isCompound || !Array.isArray(this.value)) {
            const err = new Error(msg);
            err.data = this.toJSON();
            throw err;
        }
        return this.value;
    }
    /**
     * Returns true if two ASN.1 objects equally.
     * @param obj another ASN.1 object.
     */
    equals(obj) {
        if (!(obj instanceof ASN1)) {
            return false;
        }
        if (this.class !== obj.class || this.tag !== obj.tag || this.isCompound !== obj.isCompound) {
            return false;
        }
        if (!this.bytes.equals(obj.bytes)) {
            return false;
        }
        return true;
    }
    /**
     * Converts this ASN.1 object to a buffer of bytes in DER format.
     */
    toDER() {
        // build the first byte
        let b1 = this.class | this.tag;
        if (this.isCompound) {
            b1 |= 0x20;
        }
        const valueLenBytes = getValueLengthByte(this.bytes.length);
        const buf = Buffer.allocUnsafe(2 + valueLenBytes + this.bytes.length);
        buf.writeInt8(b1, 0);
        if (valueLenBytes === 0) {
            buf.writeUInt8(this.bytes.length, 1);
            this.bytes.copy(buf, 2);
        }
        else {
            buf.writeUInt8(valueLenBytes | 0x80, 1);
            buf.writeUIntBE(this.bytes.length, 2, valueLenBytes);
            this.bytes.copy(buf, 2 + valueLenBytes);
        }
        return buf;
    }
    /**
     * Parse the value of this ASN.1 object when it is Class.UNIVERSAL.
     * The value will be boolean, number, string, BitString, Date, array of ASN.1 objects and so on.
     */
    valueOf() {
        if (this.isCompound) {
            return ASN1._parseCompound(this.bytes, false);
        }
        if (this.class !== Class.UNIVERSAL) {
            return this.bytes;
        }
        switch (this.tag) {
            case Tag.BOOLEAN:
                return ASN1.parseBool(this.bytes);
            case Tag.INTEGER:
                return ASN1.parseInteger(this.bytes);
            case Tag.BITSTRING:
                return ASN1.parseBitString(this.bytes);
            case Tag.NULL:
                return ASN1.parseNull(this.bytes);
            case Tag.OID:
                return ASN1.parseOID(this.bytes);
            case Tag.UTF8:
                return ASN1.parseUTF8(this.bytes);
            case Tag.NUMERICSTRING:
                return ASN1.parseNumericString(this.bytes);
            case Tag.PRINTABLESTRING:
                return ASN1.parsePrintableString(this.bytes);
            case Tag.T61STRING:
                return ASN1.parseT61String(this.bytes);
            case Tag.IA5STRING:
                return ASN1.parseIA5String(this.bytes);
            case Tag.GENERALSTRING:
                return ASN1.parseGeneralString(this.bytes);
            case Tag.UTCTIME:
                return ASN1.parseUTCTime(this.bytes);
            case Tag.GENERALIZEDTIME:
                return ASN1.parseGeneralizedTime(this.bytes);
            default:
                return this.bytes;
        }
    }
    /**
     * Validates that the given ASN.1 object is at least a super set of the
     * given ASN.1 structure. Only tag classes and types are checked. An
     * optional map may also be provided to capture ASN.1 values while the
     * structure is checked.
     *
     * To capture an ASN.1 object, set an object in the validator's 'capture'
     * parameter to the key to use in the capture map.
     *
     * Objects in the validator may set a field 'optional' to true to indicate
     * that it isn't necessary to pass validation.
     *
     * @param tpl Template object to validate.
     * @param captures Captures object to capture ASN.1 object.
     */
    validate(tpl, captures = {}) {
        if (this.class !== tpl.class) {
            return new Error(`ASN.1 object validate failure for ${tpl.name} : error class ${Class[this.class]}`);
        }
        const tplTags = Array.isArray(tpl.tag) ? tpl.tag : [tpl.tag];
        if (!tplTags.includes(this.tag)) {
            return new Error(`ASN.1 object validate failure for ${tpl.name}: error tag ${Tag[this.tag]}`);
        }
        if (tpl.capture != null) {
            captures[tpl.capture] = this;
        }
        if (Array.isArray(tpl.value)) {
            const values = this.mustCompound(`${tpl.name} need compound ASN1 value`);
            for (let i = 0, j = 0; i < tpl.value.length; i++) {
                if (values[j] != null) {
                    const err = values[j].validate(tpl.value[i], captures);
                    if (err == null) {
                        j++;
                    }
                    else if (tpl.value[i].optional !== true) {
                        return err;
                    }
                }
                else if (tpl.value[i].optional !== true) {
                    return new Error(`ASN.1 object validate failure for ${tpl.value[i].name}: not exists`);
                }
            }
        }
        else if (tpl.value != null) {
            const buf = this.tag === Tag.BITSTRING ? this.bytes.slice(1) : this.bytes;
            return ASN1.fromDER(buf).validate(tpl.value, captures);
        }
        return null;
    }
    /**
     * Return a friendly JSON object for debuging.
     */
    toJSON() {
        let value = this.value;
        if (Array.isArray(value)) {
            value = value.map((val) => val.toJSON());
        }
        return {
            class: Class[this.class],
            tag: this.class === Class.UNIVERSAL ? Tag[this.tag] : this.tag,
            value,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        if (options.depth <= 2) {
            options.depth = 10;
        }
        return `<${this.constructor.name} ${util_1.inspect(this.toJSON(), options)}>`;
    }
}
exports.ASN1 = ASN1;
// Gets the length of a BER-encoded ASN.1 value.
function getValueLength(bufv) {
    bufv.mustWalk(1, 'Too few bytes to read ASN.1 value length.');
    const byte = bufv.buf[bufv.start];
    // see if the length is "short form" or "long form" (bit 8 set)
    if ((byte & 0x80) === 0) {
        // if byte is 0, means asn1 object of indefinite length
        return byte;
    }
    const byteLen = byte & 0x7f;
    bufv.mustWalk(byteLen, 'Too few bytes to read ASN.1 value length.');
    return bufv.buf.readUIntBE(bufv.start, byteLen);
}
// Gets the length of a BER-encoded ASN.1 value length's bytes
function getValueLengthByte(valueLen) {
    if (valueLen <= 127) {
        return 0;
    }
    else if (valueLen <= 0xff) {
        return 1;
    }
    else if (valueLen <= 0xffff) {
        return 2;
    }
    else if (valueLen <= 0xffffff) {
        return 3;
    }
    else if (valueLen <= 0xffffffff) {
        return 4;
    }
    else if (valueLen <= 0xffffffffff) {
        return 5;
    }
    else if (valueLen <= 0xffffffffffff) {
        return 6;
    }
    else {
        throw new Error('invalid value length');
    }
}
function isNumericString(str) {
    for (const s of str) {
        const n = s.charCodeAt(0);
        if (n !== 32 && (n < 48 || n > 57)) { // '0' to '9', and ' '
            return false;
        }
    }
    return true;
}
function isIA5String(str) {
    for (const s of str) {
        if (s.charCodeAt(0) >= 0x80) {
            return false;
        }
    }
    return true;
}
function mustParseInt(str, radix = 10) {
    const val = parseInt(str, radix);
    if (Number.isNaN(val)) {
        throw new Error(`Invalid numeric string "${str}" in radix ${radix}.`);
    }
    return val;
}
//# sourceMappingURL=asn1.js.map

/***/ }),

/***/ 42891:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
// **Github:** https://github.com/fidm/x509
//
// **License:** MIT
/**
 * BufferVisitor is a visit tool to manipulate buffer.
 */
class BufferVisitor {
    constructor(buf, start = 0, end = 0) {
        this.start = start;
        this.end = end > start ? end : start;
        this.buf = buf;
    }
    /**
     * return the underlying buffer length
     */
    get length() {
        return this.buf.length;
    }
    /**
     * Reset visitor' start and end value.
     * @param start
     * @param end
     */
    reset(start = 0, end = 0) {
        this.start = start;
        if (end >= this.start) {
            this.end = end;
        }
        else if (this.end < this.start) {
            this.end = this.start;
        }
        return this;
    }
    /**
     * consume some bytes.
     * @param steps steps to walk
     */
    walk(steps) {
        this.start = this.end;
        this.end += steps;
        return this;
    }
    /**
     * The buffer should have remaining the "steps" of bytes to consume,
     * otherwise it will throw an error with given message.
     * @param steps steps to consume.
     * @param message message to throw.
     */
    mustHas(steps, message = 'Too few bytes to parse.') {
        const requested = this.end + steps;
        if (requested > this.buf.length) {
            const error = new Error(message);
            error.available = this.buf.length;
            error.requested = requested;
            throw error;
        }
        this.walk(0);
        return this;
    }
    /**
     * Check the remaining bytes with bufferVisitor.mustHas method and then walk.
     * @param steps steps to consume.
     * @param message message to throw.
     */
    mustWalk(steps, message) {
        this.mustHas(steps, message);
        this.walk(steps);
        return this;
    }
}
exports.BufferVisitor = BufferVisitor;
//# sourceMappingURL=common.js.map

/***/ }),

/***/ 89258:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
// **Github:** https://github.com/fidm/asn1
//
// **License:** MIT
var common_1 = __webpack_require__(42891);
exports.BufferVisitor = common_1.BufferVisitor;
var pem_1 = __webpack_require__(83486);
exports.PEM = pem_1.PEM;
var asn1_1 = __webpack_require__(97234);
exports.ASN1 = asn1_1.ASN1;
exports.Class = asn1_1.Class;
exports.Tag = asn1_1.Tag;
exports.BitString = asn1_1.BitString;
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 83486:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var Buffer = __webpack_require__(64293)["Buffer"];

Object.defineProperty(exports, "__esModule", ({ value: true }));
// **Github:** https://github.com/fidm/asn1
//
// **License:** MIT
const util_1 = __webpack_require__(31669);
const pemLineLength = 64;
const pemStart = '-----BEGIN ';
const pemEnd = '-----END ';
const pemEndOfLine = '-----';
const procType = 'Proc-Type';
/**
 * Implements the PEM data encoding, which originated in Privacy
 * Enhanced Mail. The most common use of PEM encoding today is in TLS keys and
 * certificates. See RFC 1421.
 *
 * A PEM represents a PEM encoded structure.
 *
 * The encoded form is:
 * ```
 * -----BEGIN Type-----
 * Headers
 * base64-encoded Bytes
 * -----END Type-----
 * ```
 *
 * Headers like:
 * ```
 * Proc-Type: 4,ENCRYPTED
 * DEK-Info: DES-EDE3-CBC,29DE8F99F382D122
 * ```
 */
class PEM {
    /**
     * Parse PEM formatted buffer, returns one or more PEM object.
     * If there is no PEM object, it will throw error.
     * @param data buffer to parse.
     */
    static parse(data) {
        const res = [];
        const lines = data.toString('utf8').split('\n')
            .map((s) => s.trim())
            .filter((s) => s !== '' && !s.startsWith('#'));
        while (lines.length > 0) {
            res.push(parse(lines));
        }
        if (res.length === 0) {
            throw new Error('PEM: no block');
        }
        return res;
    }
    constructor(type, body) {
        this.type = type;
        this.body = body;
        this.headers = Object.create(null);
    }
    /**
     * Return exists Proc-Type header or empty string
     */
    get procType() {
        return this.getHeader(procType);
    }
    /**
     * Return a header or empty string with given key.
     */
    getHeader(key) {
        const val = this.headers[key];
        return val == null ? '' : val;
    }
    /**
     * Set a header with given key/value.
     */
    setHeader(key, val) {
        if (key.includes(':')) {
            throw new Error('pem: cannot encode a header key that contains a colon');
        }
        if (key === '' || val === '') {
            throw new Error('pem: invalid header key or value');
        }
        this.headers[key] = val;
    }
    /**
     * Encode to PEM formatted string.
     */
    toString() {
        let rVal = pemStart + this.type + pemEndOfLine + '\n';
        const headers = Object.keys(this.headers);
        if (headers.length > 0) {
            // The Proc-Type header must be written first. See RFC 1421, section 4.6.1.1
            const type = this.procType;
            if (type !== '') {
                rVal += `${procType}: ${type}\n`;
            }
            // For consistency of output, write other headers sorted by key.
            headers.sort();
            for (const key of headers) {
                if (key !== procType) {
                    rVal += `${key}: ${this.headers[key]}\n`;
                }
            }
            rVal += '\n';
        }
        const body = this.body.toString('base64');
        let offset = 0;
        while (offset < body.length) {
            rVal += body.slice(offset, offset + pemLineLength) + '\n';
            offset += pemLineLength;
        }
        rVal += pemEnd + this.type + pemEndOfLine + '\n';
        return rVal;
    }
    /**
     * Encode to PEM formatted buffer.
     */
    toBuffer() {
        return Buffer.from(this.toString(), 'utf8');
    }
    /**
     * Returns the body.
     */
    valueOf() {
        return this.body;
    }
    /**
     * Return a friendly JSON object for debuging.
     */
    toJSON() {
        return {
            type: this.type,
            body: this.body,
            headers: this.headers,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return `<${this.constructor.name} ${util_1.inspect(this.toJSON(), options)}>`;
    }
}
exports.PEM = PEM;
function parse(lines) {
    let line = lines.shift();
    if (line == null || !line.startsWith(pemStart) || !line.endsWith(pemEndOfLine)) {
        throw new Error('pem: invalid BEGIN line');
    }
    const type = line.slice(pemStart.length, line.length - pemEndOfLine.length);
    if (type === '') {
        throw new Error('pem: invalid type');
    }
    const headers = [];
    line = lines.shift();
    while (line != null && line.includes(': ')) {
        const header = line.split(': ');
        if (header.length !== 2 || header[0] === '' || header[1] === '') {
            throw new Error('pem: invalid Header line');
        }
        headers.push(header);
        line = lines.shift();
    }
    let body = '';
    while (line != null && !line.startsWith(pemEnd)) {
        body += line;
        line = lines.shift();
    }
    if (line == null || line !== `${pemEnd}${type}${pemEndOfLine}`) {
        throw new Error('pem: invalid END line');
    }
    const pem = new PEM(type, Buffer.from(body, 'base64'));
    if (body === '' || pem.body.toString('base64') !== body) {
        throw new Error('pem: invalid base64 body');
    }
    for (const header of headers) {
        pem.setHeader(header[0], header[1]);
    }
    return pem;
}
//# sourceMappingURL=pem.js.map

/***/ }),

/***/ 30200:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var Buffer = __webpack_require__(64293)["Buffer"];

Object.defineProperty(exports, "__esModule", ({ value: true }));
// **Github:** https://github.com/fidm/x509
//
// **License:** MIT
const net_1 = __webpack_require__(11631);
/**
 * Converts IP string into buffer, 4 bytes for IPv4, and 16 bytes for IPv6.
 * It will return null when IP string invalid.
 *
 * ```js
 * console.log(bytesFromIP('::1')) // <Buffer 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01>
 * ```
 * @param ip IP string to convert
 */
function bytesFromIP(ip) {
    switch (net_1.isIP(ip)) {
        case 4:
            return Buffer.from(ip.split('.').map((val) => parseInt(val, 10)));
        case 6:
            const vals = ip.split(':');
            const buf = Buffer.alloc(16);
            let offset = 0;
            if (vals[vals.length - 1] === '') {
                vals[vals.length - 1] = '0';
            }
            for (let i = 0; i < vals.length; i++) {
                if (vals[i] === '') {
                    if (i + 1 < vals.length && vals[i + 1] !== '') {
                        // reset offset for non-zero values
                        offset = 16 - (vals.length - i - 1) * 2;
                    }
                    // skip zero bytes
                    continue;
                }
                buf.writeUInt16BE(parseInt(vals[i], 16), offset);
                offset += 2;
            }
            return buf;
        default:
            return null;
    }
}
exports.bytesFromIP = bytesFromIP;
/**
 * Converts 4-bytes into an IPv4 string representation or 16-bytes into
 * an IPv6 string representation. The bytes must be in network order.
 *
 * ```js
 * console.log(bytesToIP(Buffer.from([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1]))) // '::1'
 * ```
 * @param bytes buffer to convert
 */
function bytesToIP(bytes) {
    switch (bytes.length) {
        case 4:
            return [bytes[0], bytes[1], bytes[2], bytes[3]].join('.');
        case 16:
            const ip = [];
            let zeroAt = -1;
            let zeroLen = 0;
            let maxAt = -1;
            let maxLen = 0;
            for (let i = 0; i < bytes.length; i += 2) {
                const hex = (bytes[i] << 8) | bytes[i + 1];
                if (hex === 0) {
                    zeroLen++;
                    if (zeroAt === -1) {
                        zeroAt = ip.length;
                    }
                    if (zeroLen > maxLen) {
                        maxLen = zeroLen;
                        maxAt = zeroAt;
                    }
                }
                else {
                    zeroAt = -1;
                    zeroLen = 0;
                }
                ip.push(hex.toString(16));
            }
            if (maxLen > 0) {
                let padding = '';
                const rest = ip.slice(maxAt + maxLen);
                ip.length = maxAt;
                if (ip.length === 0) {
                    padding += ':';
                }
                if (rest.length === 0) {
                    padding += ':';
                }
                ip.push(padding, ...rest);
            }
            return ip.join(':');
        default:
            return '';
    }
}
exports.bytesToIP = bytesToIP;
const oids = Object.create(null);
const oidReg = /^[0-9.]+$/;
/**
 * Returns Object Identifier (dot-separated numeric string) that registered by initOID function.
 * It will return empty string if not exists.
 * @param nameOrId OID name or OID
 */
function getOID(nameOrId) {
    if (oidReg.test(nameOrId) && oids[nameOrId] !== '') {
        return nameOrId;
    }
    return oids[nameOrId] == null ? '' : oids[nameOrId];
}
exports.getOID = getOID;
/**
 * Returns Object Identifier name that registered by initOID function.
 * It will return the argument nameOrId if not exists.
 * @param nameOrId OID name or OID
 */
function getOIDName(nameOrId) {
    if (!oidReg.test(nameOrId) && oids[nameOrId] !== '') {
        return nameOrId;
    }
    return oids[nameOrId] == null ? nameOrId : oids[nameOrId];
}
exports.getOIDName = getOIDName;
/**
 * Register OID and name
 * @param oid Object Identifier
 * @param name Object Identifier name
 */
function initOID(oid, name) {
    oids[oid] = name;
    oids[name] = oid;
}
// algorithm OIDs
initOID('1.2.840.113549.1.1.1', 'rsaEncryption');
initOID('1.2.840.113549.1.1.4', 'md5WithRsaEncryption');
initOID('1.2.840.113549.1.1.5', 'sha1WithRsaEncryption');
initOID('1.2.840.113549.1.1.8', 'mgf1');
initOID('1.2.840.113549.1.1.10', 'RSASSA-PSS');
initOID('1.2.840.113549.1.1.11', 'sha256WithRsaEncryption');
initOID('1.2.840.113549.1.1.12', 'sha384WithRsaEncryption');
initOID('1.2.840.113549.1.1.13', 'sha512WithRsaEncryption');
initOID('1.2.840.10045.2.1', 'ecEncryption'); // ECDSA and ECDH Public Key
initOID('1.2.840.10045.4.1', 'ecdsaWithSha1');
initOID('1.2.840.10045.4.3.2', 'ecdsaWithSha256');
initOID('1.2.840.10045.4.3.3', 'ecdsaWithSha384');
initOID('1.2.840.10045.4.3.4', 'ecdsaWithSha512');
initOID('1.2.840.10040.4.3', 'dsaWithSha1');
initOID('2.16.840.1.101.3.4.3.2', 'dsaWithSha256');
initOID('1.3.14.3.2.7', 'desCBC');
initOID('1.3.14.3.2.26', 'sha1');
initOID('2.16.840.1.101.3.4.2.1', 'sha256');
initOID('2.16.840.1.101.3.4.2.2', 'sha384');
initOID('2.16.840.1.101.3.4.2.3', 'sha512');
initOID('1.2.840.113549.2.5', 'md5');
// Algorithm Identifiers for Ed25519, Ed448, X25519 and X448 for use in the Internet X.509 Public Key Infrastructure
// https://tools.ietf.org/html/draft-ietf-curdle-pkix-10
initOID('1.3.101.110', 'X25519');
initOID('1.3.101.111', 'X448');
initOID('1.3.101.112', 'Ed25519');
initOID('1.3.101.113', 'Ed448');
// pkcs#7 content types
initOID('1.2.840.113549.1.7.1', 'data');
initOID('1.2.840.113549.1.7.2', 'signedData');
initOID('1.2.840.113549.1.7.3', 'envelopedData');
initOID('1.2.840.113549.1.7.4', 'signedAndEnvelopedData');
initOID('1.2.840.113549.1.7.5', 'digestedData');
initOID('1.2.840.113549.1.7.6', 'encryptedData');
// pkcs#9 oids
initOID('1.2.840.113549.1.9.1', 'emailAddress');
initOID('1.2.840.113549.1.9.2', 'unstructuredName');
initOID('1.2.840.113549.1.9.3', 'contentType');
initOID('1.2.840.113549.1.9.4', 'messageDigest');
initOID('1.2.840.113549.1.9.5', 'signingTime');
initOID('1.2.840.113549.1.9.6', 'counterSignature');
initOID('1.2.840.113549.1.9.7', 'challengePassword');
initOID('1.2.840.113549.1.9.8', 'unstructuredAddress');
initOID('1.2.840.113549.1.9.14', 'extensionRequest');
initOID('1.2.840.113549.1.9.20', 'friendlyName');
initOID('1.2.840.113549.1.9.21', 'localKeyId');
initOID('1.2.840.113549.1.9.22.1', 'x509Certificate');
// pkcs#12 safe bags
initOID('1.2.840.113549.1.12.10.1.1', 'keyBag');
initOID('1.2.840.113549.1.12.10.1.2', 'pkcs8ShroudedKeyBag');
initOID('1.2.840.113549.1.12.10.1.3', 'certBag');
initOID('1.2.840.113549.1.12.10.1.4', 'crlBag');
initOID('1.2.840.113549.1.12.10.1.5', 'secretBag');
initOID('1.2.840.113549.1.12.10.1.6', 'safeContentsBag');
// password-based-encryption for pkcs#12
initOID('1.2.840.113549.1.5.13', 'pkcs5PBES2');
initOID('1.2.840.113549.1.5.12', 'pkcs5PBKDF2');
// hmac OIDs
initOID('1.2.840.113549.2.7', 'hmacWithSha1');
initOID('1.2.840.113549.2.9', 'hmacWithSha256');
initOID('1.2.840.113549.2.10', 'hmacWithSha384');
initOID('1.2.840.113549.2.11', 'hmacWithSha512');
// symmetric key algorithm oids
initOID('1.2.840.113549.3.7', '3desCBC');
initOID('2.16.840.1.101.3.4.1.2', 'aesCBC128');
initOID('2.16.840.1.101.3.4.1.42', 'aesCBC256');
// certificate issuer/subject OIDs
initOID('2.5.4.3', 'commonName');
initOID('2.5.4.5', 'serialName');
initOID('2.5.4.6', 'countryName');
initOID('2.5.4.7', 'localityName');
initOID('2.5.4.8', 'stateOrProvinceName');
initOID('2.5.4.10', 'organizationName');
initOID('2.5.4.11', 'organizationalUnitName');
initOID('2.5.4.15', 'businessCategory');
// X.509 extension OIDs
initOID('2.16.840.1.113730.1.1', 'nsCertType');
initOID('2.5.29.2', 'keyAttributes'); // obsolete, use .37 or .15
initOID('2.5.29.4', 'keyUsageRestriction'); // obsolete, use .37 or .15
initOID('2.5.29.6', 'subtreesConstraint'); // obsolete, use .30
initOID('2.5.29.9', 'subjectDirectoryAttributes');
initOID('2.5.29.14', 'subjectKeyIdentifier');
initOID('2.5.29.15', 'keyUsage');
initOID('2.5.29.16', 'privateKeyUsagePeriod');
initOID('2.5.29.17', 'subjectAltName');
initOID('2.5.29.18', 'issuerAltName');
initOID('2.5.29.19', 'basicConstraints');
initOID('2.5.29.20', 'cRLNumber');
initOID('2.5.29.21', 'cRLReason');
initOID('2.5.29.22', 'expirationDate');
initOID('2.5.29.23', 'instructionCode');
initOID('2.5.29.24', 'invalidityDate');
initOID('2.5.29.27', 'deltaCRLIndicator');
initOID('2.5.29.28', 'issuingDistributionPoint');
initOID('2.5.29.29', 'certificateIssuer');
initOID('2.5.29.30', 'nameConstraints');
initOID('2.5.29.31', 'cRLDistributionPoints');
initOID('2.5.29.32', 'certificatePolicies');
initOID('2.5.29.33', 'policyMappings');
initOID('2.5.29.35', 'authorityKeyIdentifier');
initOID('2.5.29.36', 'policyConstraints');
initOID('2.5.29.37', 'extKeyUsage');
initOID('2.5.29.46', 'freshestCRL');
initOID('2.5.29.54', 'inhibitAnyPolicy');
// extKeyUsage purposes
initOID('1.3.6.1.4.1.311.60.2.1.2', 'jurisdictionST');
initOID('1.3.6.1.4.1.311.60.2.1.3', 'jurisdictionC');
initOID('1.3.6.1.4.1.11129.2.4.2', 'timestampList');
initOID('1.3.6.1.5.5.7.1.1', 'authorityInfoAccess');
initOID('1.3.6.1.5.5.7.3.1', 'serverAuth');
initOID('1.3.6.1.5.5.7.3.2', 'clientAuth');
initOID('1.3.6.1.5.5.7.3.3', 'codeSigning');
initOID('1.3.6.1.5.5.7.3.4', 'emailProtection');
initOID('1.3.6.1.5.5.7.3.8', 'timeStamping');
initOID('1.3.6.1.5.5.7.48.1', 'authorityInfoAccessOcsp');
initOID('1.3.6.1.5.5.7.48.2', 'authorityInfoAccessIssuers');
//# sourceMappingURL=common.js.map

/***/ }),

/***/ 51712:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
// **Github:** https://github.com/fidm/x509
//
// **License:** MIT
var common_1 = __webpack_require__(30200);
exports.bytesFromIP = common_1.bytesFromIP;
exports.bytesToIP = common_1.bytesToIP;
exports.getOID = common_1.getOID;
exports.getOIDName = common_1.getOIDName;
var pki_1 = __webpack_require__(68117);
exports.PublicKey = pki_1.PublicKey;
exports.PrivateKey = pki_1.PrivateKey;
exports.RSAPublicKey = pki_1.RSAPublicKey;
exports.RSAPrivateKey = pki_1.RSAPrivateKey;
var x509_1 = __webpack_require__(95230);
exports.Certificate = x509_1.Certificate;
exports.DistinguishedName = x509_1.DistinguishedName;
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 68117:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var Buffer = __webpack_require__(64293)["Buffer"];

Object.defineProperty(exports, "__esModule", ({ value: true }));
// **Github:** https://github.com/fidm/x509
//
// **License:** MIT
const util_1 = __webpack_require__(31669);
const crypto_1 = __webpack_require__(76417);
const tweetnacl_1 = __webpack_require__(55842);
const asn1_1 = __webpack_require__(89258);
const common_1 = __webpack_require__(30200);
/**
 * ASN.1 Template for PKCS#8 Public Key.
 */
exports.publicKeyValidator = {
    name: 'PublicKeyInfo',
    class: asn1_1.Class.UNIVERSAL,
    tag: asn1_1.Tag.SEQUENCE,
    capture: 'publicKeyInfo',
    value: [{
            name: 'PublicKeyInfo.AlgorithmIdentifier',
            class: asn1_1.Class.UNIVERSAL,
            tag: asn1_1.Tag.SEQUENCE,
            value: [{
                    name: 'PublicKeyAlgorithmIdentifier.algorithm',
                    class: asn1_1.Class.UNIVERSAL,
                    tag: asn1_1.Tag.OID,
                    capture: 'publicKeyOID',
                }],
        }, {
            name: 'PublicKeyInfo.PublicKey',
            class: asn1_1.Class.UNIVERSAL,
            tag: asn1_1.Tag.BITSTRING,
            capture: 'publicKey',
        }],
};
/**
 * ASN.1 Template for PKCS#8 Private Key. https://tools.ietf.org/html/rfc5208
 */
exports.privateKeyValidator = {
    name: 'PrivateKeyInfo',
    class: asn1_1.Class.UNIVERSAL,
    tag: asn1_1.Tag.SEQUENCE,
    capture: 'privateKeyInfo',
    value: [{
            name: 'PrivateKeyInfo.Version',
            class: asn1_1.Class.UNIVERSAL,
            tag: asn1_1.Tag.INTEGER,
            capture: 'privateKeyVersion',
        }, {
            name: 'PrivateKeyInfo.AlgorithmIdentifier',
            class: asn1_1.Class.UNIVERSAL,
            tag: asn1_1.Tag.SEQUENCE,
            value: [{
                    name: 'PrivateKeyAlgorithmIdentifier.algorithm',
                    class: asn1_1.Class.UNIVERSAL,
                    tag: asn1_1.Tag.OID,
                    capture: 'privateKeyOID',
                }],
        }, {
            name: 'PrivateKeyInfo.PrivateKey',
            class: asn1_1.Class.UNIVERSAL,
            tag: asn1_1.Tag.OCTETSTRING,
            capture: 'privateKey',
        }],
};
// validator for an RSA public key
const rsaPublicKeyValidator = {
    // RSAPublicKey
    name: 'RSAPublicKey',
    class: asn1_1.Class.UNIVERSAL,
    tag: asn1_1.Tag.SEQUENCE,
    value: [{
            // modulus (n)
            name: 'RSAPublicKey.modulus',
            class: asn1_1.Class.UNIVERSAL,
            tag: asn1_1.Tag.INTEGER,
            capture: 'publicKeyModulus',
        }, {
            // publicExponent (e)
            name: 'RSAPublicKey.exponent',
            class: asn1_1.Class.UNIVERSAL,
            tag: asn1_1.Tag.INTEGER,
            capture: 'publicKeyExponent',
        }],
};
const rsaPrivateKeyValidator = {
    // RSAPrivateKey
    name: 'RSAPrivateKey',
    class: asn1_1.Class.UNIVERSAL,
    tag: asn1_1.Tag.SEQUENCE,
    value: [{
            // Version (INTEGER)
            name: 'RSAPrivateKey.version',
            class: asn1_1.Class.UNIVERSAL,
            tag: asn1_1.Tag.INTEGER,
            capture: 'privateKeyVersion',
        }, {
            // modulus (n)
            name: 'RSAPrivateKey.modulus',
            class: asn1_1.Class.UNIVERSAL,
            tag: asn1_1.Tag.INTEGER,
            capture: 'privateKeyModulus',
        }, {
            // publicExponent (e)
            name: 'RSAPrivateKey.publicExponent',
            class: asn1_1.Class.UNIVERSAL,
            tag: asn1_1.Tag.INTEGER,
            capture: 'privateKeyPublicExponent',
        }, {
            // privateExponent (d)
            name: 'RSAPrivateKey.privateExponent',
            class: asn1_1.Class.UNIVERSAL,
            tag: asn1_1.Tag.INTEGER,
            capture: 'privateKeyPrivateExponent',
        }, {
            // prime1 (p)
            name: 'RSAPrivateKey.prime1',
            class: asn1_1.Class.UNIVERSAL,
            tag: asn1_1.Tag.INTEGER,
            capture: 'privateKeyPrime1',
        }, {
            // prime2 (q)
            name: 'RSAPrivateKey.prime2',
            class: asn1_1.Class.UNIVERSAL,
            tag: asn1_1.Tag.INTEGER,
            capture: 'privateKeyPrime2',
        }, {
            // exponent1 (d mod (p-1))
            name: 'RSAPrivateKey.exponent1',
            class: asn1_1.Class.UNIVERSAL,
            tag: asn1_1.Tag.INTEGER,
            capture: 'privateKeyExponent1',
        }, {
            // exponent2 (d mod (q-1))
            name: 'RSAPrivateKey.exponent2',
            class: asn1_1.Class.UNIVERSAL,
            tag: asn1_1.Tag.INTEGER,
            capture: 'privateKeyExponent2',
        }, {
            // coefficient ((inverse of q) mod p)
            name: 'RSAPrivateKey.coefficient',
            class: asn1_1.Class.UNIVERSAL,
            tag: asn1_1.Tag.INTEGER,
            capture: 'privateKeyCoefficient',
        }],
};
const EdDSAPrivateKeyOIDs = [
    // https://tools.ietf.org/html/draft-ietf-curdle-pkix-10
    common_1.getOID('X25519'),
    common_1.getOID('X448'),
    common_1.getOID('Ed25519'),
    common_1.getOID('Ed448'),
];
/**
 * PKCS#8 Public Key
 */
class PublicKey {
    constructor(obj) {
        const captures = {};
        const err = obj.validate(exports.publicKeyValidator, captures);
        if (err != null) {
            throw new Error('Cannot read X.509 public key: ' + err.message);
        }
        this.oid = asn1_1.ASN1.parseOID(captures.publicKeyOID.bytes);
        this.algo = common_1.getOIDName(this.oid);
        this._pkcs8 = obj;
        this._keyRaw = asn1_1.ASN1.parseBitString(captures.publicKey.bytes).buf;
        this._finalKey = this._keyRaw;
        this._finalPEM = '';
    }
    /**
     * Parse an PublicKey for X.509 certificate from PKCS#8 PEM formatted buffer or PKCS#1 RSA PEM formatted buffer.
     * @param pem PEM formatted buffer
     */
    static fromPEM(pem) {
        const msg = asn1_1.PEM.parse(pem)[0];
        if (msg.procType.includes('ENCRYPTED')) {
            throw new Error('Could not convert public key from PEM, PEM is encrypted.');
        }
        const obj = asn1_1.ASN1.fromDER(msg.body, true);
        switch (msg.type) {
            case 'PUBLIC KEY': // PKCS#8
                return new PublicKey(obj);
            case 'RSA PUBLIC KEY': // PKCS#1
                const _pkcs8 = asn1_1.ASN1.Seq([
                    // AlgorithmIdentifier
                    asn1_1.ASN1.Seq([
                        // algorithm
                        asn1_1.ASN1.OID(common_1.getOID('rsaEncryption')),
                        // optional parameters
                        asn1_1.ASN1.Null(),
                    ]),
                    // PublicKey
                    asn1_1.ASN1.BitString(obj.DER),
                ]);
                return new PublicKey(_pkcs8);
            default:
                throw new Error('Could not convert public key from PEM, recommend PKCS#8 PEM');
        }
    }
    /**
     * Registers an external Verifier with object identifier.
     * Built-in verifiers: Ed25519, RSA, others see https://nodejs.org/api/crypto.html#crypto_class_verify
     * ```js
     * PublicKey.addVerifier(getOID('Ed25519'), function (this: PublicKey, data: Buffer, signature: Buffer): boolean {
     *   return ed25519.detached.verify(data, signature, this.keyRaw)
     * })
     * ```
     * @param oid algorithm object identifier
     * @param fn Verifier function
     */
    static addVerifier(oid, fn) {
        oid = common_1.getOID(oid);
        if (oid === '') {
            throw new Error(`Invalid object identifier: ${oid}`);
        }
        if (PublicKey._verifiers[oid] != null) {
            throw new Error(`Verifier ${oid} exists`);
        }
        PublicKey._verifiers[oid] = fn;
    }
    /**
     * underlying key buffer
     */
    get keyRaw() {
        return this._finalKey;
    }
    /**
     * Returns true if the provided data and the given signature matched.
     * ```js
     * certificate.publicKey.verify(data, signature, 'sha256') // => true or false
     * ```
     * @param data data to verify
     * @param signature signature that signed by private key
     * @param hashAlgorithm hash algorithm, such as 'sha256', 'sha1'
     */
    verify(data, signature, hashAlgorithm) {
        const verifier = PublicKey._verifiers[this.oid];
        if (verifier != null) {
            const sum = crypto_1.createHash(hashAlgorithm).update(data).digest();
            return verifier.call(this, sum, signature);
        }
        const verify = crypto_1.createVerify(hashAlgorithm);
        verify.update(data);
        return verify.verify(this.toPEM(), signature);
    }
    /**
     * Returns the digest of the PublicKey with given hash algorithm.
     * ```js
     * certificate.publicKey.getFingerprint('sha1', 'PublicKey') // => Buffer
     * ```
     * @param hashAlgorithm hash algorithm, such as 'sha256', 'sha1'
     * @param type 'PublicKey' or 'PublicKeyInfo'
     */
    getFingerprint(hashAlgorithm, type = 'PublicKey') {
        let bytes;
        switch (type) {
            case 'PublicKeyInfo':
                bytes = this._pkcs8.DER;
                break;
            case 'PublicKey':
                bytes = this._keyRaw;
                break;
            default:
                throw new Error(`Unknown fingerprint type "${type}".`);
        }
        const hasher = crypto_1.createHash(hashAlgorithm);
        hasher.update(bytes);
        return hasher.digest();
    }
    /**
     * Returns an ASN.1 object of this PublicKey
     */
    toASN1() {
        return this._pkcs8;
    }
    /**
     * Returns an DER formatted buffer of this PublicKey
     */
    toDER() {
        return this._pkcs8.DER;
    }
    /**
     * Returns an PEM formatted string of this PublicKey
     */
    toPEM() {
        if (this._finalPEM === '') {
            this._finalPEM = new asn1_1.PEM('PUBLIC KEY', this._pkcs8.DER).toString();
        }
        return this._finalPEM;
    }
    /**
     * Return a friendly JSON object for debuging.
     */
    toJSON() {
        return {
            oid: this.oid,
            algo: this.algo,
            publicKey: this._keyRaw,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return `<${this.constructor.name} ${util_1.inspect(this.toJSON(), options)}>`;
    }
}
PublicKey._verifiers = Object.create(null);
exports.PublicKey = PublicKey;
/**
 * PKCS#8 Private Key
 */
class PrivateKey {
    constructor(obj) {
        // get RSA params
        const captures = Object.create(null);
        const err = obj.validate(exports.privateKeyValidator, captures);
        if (err != null) {
            throw new Error('Cannot read X.509 private key: ' + err.message);
        }
        this.version = asn1_1.ASN1.parseIntegerNum(captures.privateKeyVersion.bytes) + 1;
        this.oid = asn1_1.ASN1.parseOID(captures.privateKeyOID.bytes);
        this.algo = common_1.getOIDName(this.oid);
        this._pkcs8 = obj;
        this._keyRaw = captures.privateKey.bytes;
        this._publicKeyRaw = null;
        this._finalKey = this._keyRaw;
        this._finalPEM = '';
        if (EdDSAPrivateKeyOIDs.includes(this.oid)) {
            this._finalKey = this._keyRaw = asn1_1.ASN1.parseDER(this._keyRaw, asn1_1.Class.UNIVERSAL, asn1_1.Tag.OCTETSTRING).bytes;
            if (this.oid === '1.3.101.112') {
                const keypair = tweetnacl_1.sign.keyPair.fromSeed(this._keyRaw);
                this._publicKeyRaw = Buffer.from(keypair.publicKey);
                this._finalKey = Buffer.from(keypair.secretKey);
            }
            else if (this.version === 2) {
                for (const val of obj.mustCompound()) {
                    if (val.class === asn1_1.Class.CONTEXT_SPECIFIC && val.tag === 1) {
                        this._publicKeyRaw = asn1_1.ASN1.parseBitString(val.bytes).buf;
                        this._finalKey = Buffer.concat([this._keyRaw, this._publicKeyRaw]);
                    }
                }
            }
        }
    }
    /**
     * Parse an PrivateKey for X.509 certificate from PKCS#8 PEM formatted buffer or PKCS#1 RSA PEM formatted buffer.
     * @param pem PEM formatted buffer
     */
    static fromPEM(pem) {
        const msg = asn1_1.PEM.parse(pem)[0];
        if (msg.procType.includes('ENCRYPTED')) {
            throw new Error('Could not convert private key from PEM, PEM is encrypted.');
        }
        let obj = asn1_1.ASN1.fromDER(msg.body, true);
        switch (msg.type) {
            case 'PRIVATE KEY': // PKCS#8
                return new PrivateKey(obj);
            case 'RSA PRIVATE KEY': // PKCS#1
                obj = asn1_1.ASN1.Seq([
                    // Version (INTEGER)
                    obj.value[0],
                    // AlgorithmIdentifier
                    asn1_1.ASN1.Seq([
                        // algorithm
                        asn1_1.ASN1.OID(common_1.getOID('rsaEncryption')),
                        // optional parameters
                        asn1_1.ASN1.Null(),
                    ]),
                    // PrivateKey
                    new asn1_1.ASN1(asn1_1.Class.UNIVERSAL, asn1_1.Tag.OCTETSTRING, obj.DER),
                ]);
                return new PrivateKey(obj);
            default:
                throw new Error('Could not convert private key from PEM, recommend PKCS#8 PEM');
        }
    }
    /**
     * Registers an external Signer with object identifier.
     * Built-in verifiers: Ed25519, RSA, others see https://nodejs.org/api/crypto.html#crypto_class_sign
     * ```js
     * PrivateKey.addSigner(getOID('Ed25519'), function (this: PrivateKey, data: Buffer): Buffer {
     *   const key = this.keyRaw
     *   if (key.length !== 64) {
     *     throw new Error('Invalid signing key.')
     *   }
     *   return Buffer.from(ed25519.detached(data, key))
     * })
     * ```
     * @param oid algorithm object identifier
     * @param fn Verifier function
     */
    static addSigner(oid, fn) {
        oid = common_1.getOID(oid);
        if (oid === '') {
            throw new Error(`Invalid object identifier: ${oid}`);
        }
        if (PrivateKey._signers[oid] != null) {
            throw new Error(`Signer ${oid} exists`);
        }
        PrivateKey._signers[oid] = fn;
    }
    /**
     * underlying key buffer
     */
    get keyRaw() {
        return this._finalKey;
    }
    /**
     * Returns publicKey buffer, it is used for Ed25519/Ed448.
     */
    get publicKeyRaw() {
        return this._publicKeyRaw;
    }
    /**
     * Returns signature for the given data and hash algorithm.
     * @param data
     * @param hashAlgorithm
     */
    sign(data, hashAlgorithm) {
        const signer = PrivateKey._signers[this.oid];
        if (signer != null) {
            const sum = crypto_1.createHash(hashAlgorithm).update(data).digest();
            return signer.call(this, sum);
        }
        const sign = crypto_1.createSign(hashAlgorithm);
        sign.update(data);
        return sign.sign(this.toPEM());
    }
    /**
     * Returns an ASN.1 object of this PrivateKey
     */
    toASN1() {
        return this._pkcs8;
    }
    /**
     * Returns an DER formatted buffer of this PrivateKey
     */
    toDER() {
        return this._pkcs8.DER;
    }
    /**
     * Returns an PEM formatted string of this PrivateKey
     */
    toPEM() {
        if (this._finalPEM === '') {
            this._finalPEM = new asn1_1.PEM('PRIVATE KEY', this._pkcs8.DER).toString();
        }
        return this._finalPEM;
    }
    /**
     * Return a friendly JSON object for debuging.
     */
    toJSON() {
        return {
            version: this.version,
            oid: this.oid,
            algo: this.algo,
            privateKey: this._keyRaw,
            publicKey: this._publicKeyRaw,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return `<${this.constructor.name} ${util_1.inspect(this.toJSON(), options)}>`;
    }
}
PrivateKey._signers = Object.create(null);
exports.PrivateKey = PrivateKey;
/**
 * PKCS#1 RSA Public Key
 */
class RSAPublicKey extends PublicKey {
    static fromPublicKey(publicKey) {
        return new RSAPublicKey(publicKey.toASN1());
    }
    constructor(obj) {
        super(obj);
        if (common_1.getOID(this.oid) !== common_1.getOID('rsaEncryption')) {
            throw new Error(`Invalid RSA public key, unknown OID: ${this.oid}`);
        }
        // get RSA params
        const captures = Object.create(null);
        this._pkcs1 = asn1_1.ASN1.fromDER(this._keyRaw, true);
        const err = this._pkcs1.validate(rsaPublicKeyValidator, captures);
        if (err != null) {
            throw new Error('Cannot read RSA public key: ' + err.message);
        }
        this.modulus = asn1_1.ASN1.parseIntegerStr(captures.publicKeyModulus.bytes);
        this.exponent = asn1_1.ASN1.parseIntegerNum(captures.publicKeyExponent.bytes);
    }
    /**
     * Returns an PKCS#1 ASN.1 object of this RSAPublicKey
     */
    toASN1() {
        return this._pkcs1;
    }
    /**
     * Returns an PKCS#1 DER formatted buffer of this RSAPublicKey
     */
    toDER() {
        return this._keyRaw;
    }
    /**
     * Returns an PKCS#1 PEM formatted string of this RSAPublicKey
     */
    toPEM() {
        if (this._finalPEM === '') {
            this._finalPEM = new asn1_1.PEM('RSA PUBLIC KEY', this._keyRaw).toString();
        }
        return this._finalPEM;
    }
    /**
     * Returns an PKCS#8 PEM formatted string of this RSAPublicKey
     */
    toPublicKeyPEM() {
        return new asn1_1.PEM('PUBLIC KEY', this._pkcs8.DER).toString();
    }
    /**
     * Return a friendly JSON object for debuging.
     */
    toJSON() {
        return {
            oid: this.oid,
            algo: this.algo,
            modulus: trimLeadingZeroByte(this.modulus),
            exponent: this.exponent,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return `<${this.constructor.name} ${util_1.inspect(this.toJSON(), options)}>`;
    }
}
exports.RSAPublicKey = RSAPublicKey;
/**
 * PKCS#1 RSA Private Key
 */
class RSAPrivateKey extends PrivateKey {
    static fromPrivateKey(privateKey) {
        return new RSAPrivateKey(privateKey.toASN1());
    }
    constructor(obj) {
        super(obj);
        if (common_1.getOID(this.oid) !== common_1.getOID('rsaEncryption')) {
            throw new Error(`Invalid RSA private key, unknown OID: ${this.oid}`);
        }
        // get RSA params
        const captures = Object.create(null);
        this._pkcs1 = asn1_1.ASN1.fromDER(this._keyRaw, true);
        const err = this._pkcs1.validate(rsaPrivateKeyValidator, captures);
        if (err != null) {
            throw new Error('Cannot read RSA private key: ' + err.message);
        }
        this.publicExponent = asn1_1.ASN1.parseIntegerNum(captures.privateKeyPublicExponent.bytes);
        this.privateExponent = asn1_1.ASN1.parseIntegerStr(captures.privateKeyPrivateExponent.bytes);
        this.modulus = asn1_1.ASN1.parseIntegerStr(captures.privateKeyModulus.bytes);
        this.prime1 = asn1_1.ASN1.parseIntegerStr(captures.privateKeyPrime1.bytes);
        this.prime2 = asn1_1.ASN1.parseIntegerStr(captures.privateKeyPrime2.bytes);
        this.exponent1 = asn1_1.ASN1.parseIntegerStr(captures.privateKeyExponent1.bytes);
        this.exponent2 = asn1_1.ASN1.parseIntegerStr(captures.privateKeyExponent2.bytes);
        this.coefficient = asn1_1.ASN1.parseIntegerStr(captures.privateKeyCoefficient.bytes);
    }
    /**
     * Returns an PKCS#1 ASN.1 object of this RSAPrivateKey
     */
    toASN1() {
        return this._pkcs1;
    }
    /**
     * Returns an PKCS#1 DER formatted buffer of this RSAPrivateKey
     */
    toDER() {
        return this._keyRaw;
    }
    /**
     * Returns an PKCS#1 PEM formatted string of this RSAPrivateKey
     */
    toPEM() {
        if (this._finalPEM === '') {
            this._finalPEM = new asn1_1.PEM('RSA PRIVATE KEY', this._keyRaw).toString();
        }
        return this._finalPEM;
    }
    /**
     * Returns an PKCS#8 PEM formatted string of this RSAPrivateKey
     */
    toPrivateKeyPEM() {
        return new asn1_1.PEM('PRIVATE KEY', this._pkcs8.DER).toString();
    }
    /**
     * Return a friendly JSON object for debuging.
     */
    toJSON() {
        return {
            version: this.version,
            oid: this.oid,
            algo: this.algo,
            publicExponent: this.publicExponent,
            privateExponent: trimLeadingZeroByte(this.privateExponent),
            modulus: trimLeadingZeroByte(this.modulus),
            prime1: trimLeadingZeroByte(this.prime1),
            prime2: trimLeadingZeroByte(this.prime2),
            exponent1: trimLeadingZeroByte(this.exponent1),
            exponent2: trimLeadingZeroByte(this.exponent2),
            coefficient: trimLeadingZeroByte(this.coefficient),
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return `<${this.constructor.name} ${util_1.inspect(this.toJSON(), options)}>`;
    }
}
exports.RSAPrivateKey = RSAPrivateKey;
// leading 00 byte is signed representation for BigInteger
// https://stackoverflow.com/questions/8515691/getting-1-byte-extra-in-the-modulus-rsa-key-and-sometimes-for-exponents-also
function trimLeadingZeroByte(hex) {
    return (hex.length % 8 !== 0) && hex.startsWith('00') ? hex.slice(2) : hex;
}
PublicKey.addVerifier(common_1.getOID('Ed25519'), function (data, signature) {
    return tweetnacl_1.sign.detached.verify(data, signature, this.keyRaw);
});
PrivateKey.addSigner(common_1.getOID('Ed25519'), function (data) {
    const key = this.keyRaw;
    if (key.length !== 64) {
        throw new Error('Invalid signing key.');
    }
    return Buffer.from(tweetnacl_1.sign.detached(data, key));
});
//# sourceMappingURL=pki.js.map

/***/ }),

/***/ 95230:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var Buffer = __webpack_require__(64293)["Buffer"];

Object.defineProperty(exports, "__esModule", ({ value: true }));
// **Github:** https://github.com/fidm/x509
//
// **License:** MIT
const util_1 = __webpack_require__(31669);
const crypto_1 = __webpack_require__(76417);
const asn1_1 = __webpack_require__(89258);
const common_1 = __webpack_require__(30200);
const pki_1 = __webpack_require__(68117);
// short name OID mappings
const shortNames = Object.create(null);
shortNames.CN = common_1.getOID('commonName');
shortNames.commonName = 'CN';
shortNames.C = common_1.getOID('countryName');
shortNames.countryName = 'C';
shortNames.L = common_1.getOID('localityName');
shortNames.localityName = 'L';
shortNames.ST = common_1.getOID('stateOrProvinceName');
shortNames.stateOrProvinceName = 'ST';
shortNames.O = common_1.getOID('organizationName');
shortNames.organizationName = 'O';
shortNames.OU = common_1.getOID('organizationalUnitName');
shortNames.organizationalUnitName = 'OU';
shortNames.E = common_1.getOID('emailAddress');
shortNames.emailAddress = 'E';
function getShortName(name) {
    return shortNames[name] == null ? '' : shortNames[name];
}
// validator for an X.509v3 certificate
const x509CertificateValidator = {
    name: 'Certificate',
    class: asn1_1.Class.UNIVERSAL,
    tag: asn1_1.Tag.SEQUENCE,
    value: [{
            name: 'Certificate.TBSCertificate',
            class: asn1_1.Class.UNIVERSAL,
            tag: asn1_1.Tag.SEQUENCE,
            capture: 'tbsCertificate',
            value: [{
                    name: 'Certificate.TBSCertificate.version',
                    class: asn1_1.Class.CONTEXT_SPECIFIC,
                    tag: asn1_1.Tag.NONE,
                    optional: true,
                    value: [{
                            name: 'Certificate.TBSCertificate.version.integer',
                            class: asn1_1.Class.UNIVERSAL,
                            tag: asn1_1.Tag.INTEGER,
                            capture: 'certVersion',
                        }],
                }, {
                    name: 'Certificate.TBSCertificate.serialNumber',
                    class: asn1_1.Class.UNIVERSAL,
                    tag: asn1_1.Tag.INTEGER,
                    capture: 'certSerialNumber',
                }, {
                    name: 'Certificate.TBSCertificate.signature',
                    class: asn1_1.Class.UNIVERSAL,
                    tag: asn1_1.Tag.SEQUENCE,
                    value: [{
                            name: 'Certificate.TBSCertificate.signature.algorithm',
                            class: asn1_1.Class.UNIVERSAL,
                            tag: asn1_1.Tag.OID,
                            capture: 'certinfoSignatureOID',
                        }, {
                            name: 'Certificate.TBSCertificate.signature.parameters',
                            class: asn1_1.Class.UNIVERSAL,
                            tag: asn1_1.Tag.OCTETSTRING,
                            optional: true,
                            capture: 'certinfoSignatureParams',
                        }],
                }, {
                    name: 'Certificate.TBSCertificate.issuer',
                    class: asn1_1.Class.UNIVERSAL,
                    tag: asn1_1.Tag.SEQUENCE,
                    capture: 'certIssuer',
                }, {
                    name: 'Certificate.TBSCertificate.validity',
                    class: asn1_1.Class.UNIVERSAL,
                    tag: asn1_1.Tag.SEQUENCE,
                    value: [{
                            name: 'Certificate.TBSCertificate.validity.notBefore',
                            class: asn1_1.Class.UNIVERSAL,
                            tag: [asn1_1.Tag.UTCTIME, asn1_1.Tag.GENERALIZEDTIME],
                            capture: 'certValidityNotBefore',
                        }, {
                            name: 'Certificate.TBSCertificate.validity.notAfter',
                            class: asn1_1.Class.UNIVERSAL,
                            tag: [asn1_1.Tag.UTCTIME, asn1_1.Tag.GENERALIZEDTIME],
                            capture: 'certValidityNotAfter',
                        }],
                }, {
                    // Name (subject) (RDNSequence)
                    name: 'Certificate.TBSCertificate.subject',
                    class: asn1_1.Class.UNIVERSAL,
                    tag: asn1_1.Tag.SEQUENCE,
                    capture: 'certSubject',
                },
                // SubjectPublicKeyInfo
                pki_1.publicKeyValidator,
                {
                    // issuerUniqueID (optional)
                    name: 'Certificate.TBSCertificate.issuerUniqueID',
                    class: asn1_1.Class.CONTEXT_SPECIFIC,
                    tag: asn1_1.Tag.BOOLEAN,
                    optional: true,
                    value: [{
                            name: 'Certificate.TBSCertificate.issuerUniqueID.id',
                            class: asn1_1.Class.UNIVERSAL,
                            tag: asn1_1.Tag.BITSTRING,
                            capture: 'certIssuerUniqueId',
                        }],
                }, {
                    // subjectUniqueID (optional)
                    name: 'Certificate.TBSCertificate.subjectUniqueID',
                    class: asn1_1.Class.CONTEXT_SPECIFIC,
                    tag: asn1_1.Tag.INTEGER,
                    optional: true,
                    value: [{
                            name: 'Certificate.TBSCertificate.subjectUniqueID.id',
                            class: asn1_1.Class.UNIVERSAL,
                            tag: asn1_1.Tag.BITSTRING,
                            capture: 'certSubjectUniqueId',
                        }],
                }, {
                    // Extensions (optional)
                    name: 'Certificate.TBSCertificate.extensions',
                    class: asn1_1.Class.CONTEXT_SPECIFIC,
                    tag: asn1_1.Tag.BITSTRING,
                    capture: 'certExtensions',
                    optional: true,
                }],
        }, {
            // AlgorithmIdentifier (signature algorithm)
            name: 'Certificate.signatureAlgorithm',
            class: asn1_1.Class.UNIVERSAL,
            tag: asn1_1.Tag.SEQUENCE,
            value: [{
                    // algorithm
                    name: 'Certificate.signatureAlgorithm.algorithm',
                    class: asn1_1.Class.UNIVERSAL,
                    tag: asn1_1.Tag.OID,
                    capture: 'certSignatureOID',
                }, {
                    name: 'Certificate.TBSCertificate.signature.parameters',
                    class: asn1_1.Class.UNIVERSAL,
                    tag: asn1_1.Tag.OCTETSTRING,
                    optional: true,
                    capture: 'certSignatureParams',
                }],
        }, {
            name: 'Certificate.signatureValue',
            class: asn1_1.Class.UNIVERSAL,
            tag: asn1_1.Tag.BITSTRING,
            capture: 'certSignature',
        }],
};
/**
 * DistinguishedName for X.509v3 certificate.
 */
class DistinguishedName {
    constructor() {
        this.attributes = [];
        this.uniqueId = null;
    }
    get commonName() {
        return this.getFieldValue('commonName');
    }
    get organizationName() {
        return this.getFieldValue('organizationName');
    }
    get organizationalUnitName() {
        return this.getFieldValue('organizationalUnitName');
    }
    get countryName() {
        return this.getFieldValue('countryName');
    }
    get localityName() {
        return this.getFieldValue('localityName');
    }
    get serialName() {
        return this.getFieldValue('serialName');
    }
    getHash() {
        const hasher = crypto_1.createHash('sha1');
        for (const attr of this.attributes) {
            hasher.update(attr.oid);
            hasher.update(attr.value);
        }
        return hasher.digest();
    }
    getField(key) {
        for (const attr of this.attributes) {
            if (key === attr.oid || key === attr.name || key === attr.shortName) {
                return attr;
            }
        }
        return null;
    }
    addField(attr) {
        fillMissingFields([attr]);
        this.attributes.push(attr);
    }
    setAttrs(attrs) {
        // set new attributes, clear hash
        fillMissingFields(attrs);
        this.attributes = attrs;
    }
    toJSON() {
        const obj = {};
        for (const attr of this.attributes) {
            const key = attr.shortName;
            if (typeof key === 'string' && key !== '') {
                obj[key] = attr.value;
            }
        }
        obj.uniqueId = this.uniqueId;
        obj.attributes = this.attributes;
        return obj;
    }
    getFieldValue(key) {
        const val = this.getField(key);
        if (val != null) {
            return val.value;
        }
        return '';
    }
}
exports.DistinguishedName = DistinguishedName;
/**
 * X.509v3 Certificate.
 */
class Certificate {
    /**
     * Parse one or more X.509 certificates from PEM formatted buffer.
     * If there is no certificate, it will throw error.
     * @param data PEM formatted buffer
     */
    static fromPEMs(data) {
        const certs = [];
        const pems = asn1_1.PEM.parse(data);
        for (const pem of pems) {
            if (pem.type !== 'CERTIFICATE' &&
                pem.type !== 'X509 CERTIFICATE' &&
                pem.type !== 'TRUSTED CERTIFICATE') {
                throw new Error('Could not convert certificate from PEM: invalid type');
            }
            if (pem.procType.includes('ENCRYPTED')) {
                throw new Error('Could not convert certificate from PEM: PEM is encrypted.');
            }
            const obj = asn1_1.ASN1.fromDER(pem.body);
            certs.push(new Certificate(obj));
        }
        if (certs.length === 0) {
            throw new Error('No Certificate');
        }
        return certs;
    }
    /**
     * Parse an X.509 certificate from PEM formatted buffer.
     * @param data PEM formatted buffer
     */
    static fromPEM(data) {
        return Certificate.fromPEMs(data)[0];
    }
    /**
     * Creates an X.509 certificate from an ASN.1 object
     * @param obj an ASN.1 object
     */
    constructor(obj) {
        // validate certificate and capture data
        const captures = Object.create(null);
        const err = obj.validate(x509CertificateValidator, captures);
        if (err != null) {
            throw new Error('Cannot read X.509 certificate: ' + err.message);
        }
        this.raw = obj.DER;
        this.version = captures.certVersion == null ? 0 : (asn1_1.ASN1.parseIntegerNum(captures.certVersion.bytes) + 1);
        this.serialNumber = asn1_1.ASN1.parseIntegerStr(captures.certSerialNumber.bytes);
        this.signatureOID = asn1_1.ASN1.parseOID(captures.certSignatureOID.bytes);
        this.signatureAlgorithm = common_1.getOIDName(this.signatureOID);
        this.infoSignatureOID = asn1_1.ASN1.parseOID(captures.certinfoSignatureOID.bytes);
        this.signature = asn1_1.ASN1.parseBitString(captures.certSignature.bytes).buf;
        this.validFrom = asn1_1.ASN1.parseTime(captures.certValidityNotBefore.tag, captures.certValidityNotBefore.bytes);
        this.validTo = asn1_1.ASN1.parseTime(captures.certValidityNotAfter.tag, captures.certValidityNotAfter.bytes);
        this.issuer = new DistinguishedName();
        this.issuer.setAttrs(RDNAttributesAsArray(captures.certIssuer));
        if (captures.certIssuerUniqueId != null) {
            this.issuer.uniqueId = asn1_1.ASN1.parseBitString(captures.certIssuerUniqueId.bytes);
        }
        this.subject = new DistinguishedName();
        this.subject.setAttrs(RDNAttributesAsArray(captures.certSubject));
        if (captures.certSubjectUniqueId != null) {
            this.subject.uniqueId = asn1_1.ASN1.parseBitString(captures.certSubjectUniqueId.bytes);
        }
        this.extensions = [];
        this.subjectKeyIdentifier = '';
        this.authorityKeyIdentifier = '';
        this.ocspServer = '';
        this.issuingCertificateURL = '';
        this.isCA = false;
        this.maxPathLen = -1;
        this.basicConstraintsValid = false;
        this.keyUsage = 0;
        this.dnsNames = [];
        this.emailAddresses = [];
        this.ipAddresses = [];
        this.uris = [];
        if (captures.certExtensions != null) {
            this.extensions = certificateExtensionsFromAsn1(captures.certExtensions);
            for (const ext of this.extensions) {
                if (typeof ext.subjectKeyIdentifier === 'string') {
                    this.subjectKeyIdentifier = ext.subjectKeyIdentifier;
                }
                if (typeof ext.authorityKeyIdentifier === 'string') {
                    this.authorityKeyIdentifier = ext.authorityKeyIdentifier;
                }
                if (typeof ext.authorityInfoAccessOcsp === 'string') {
                    this.ocspServer = ext.authorityInfoAccessOcsp;
                }
                if (typeof ext.authorityInfoAccessIssuers === 'string') {
                    this.issuingCertificateURL = ext.authorityInfoAccessIssuers;
                }
                if (typeof ext.basicConstraintsValid === 'boolean') {
                    this.isCA = ext.isCA;
                    this.maxPathLen = ext.maxPathLen;
                    this.basicConstraintsValid = ext.basicConstraintsValid;
                }
                if (typeof ext.keyUsage === 'number') {
                    this.keyUsage = ext.keyUsage;
                }
                if (Array.isArray(ext.altNames)) {
                    for (const item of ext.altNames) {
                        if (item.dnsName != null) {
                            this.dnsNames.push(item.dnsName);
                        }
                        if (item.email != null) {
                            this.emailAddresses.push(item.email);
                        }
                        if (item.ip != null) {
                            this.ipAddresses.push(item.ip);
                        }
                        if (item.uri != null) {
                            this.uris.push(item.uri);
                        }
                    }
                }
            }
        }
        this.publicKey = new pki_1.PublicKey(captures.publicKeyInfo);
        this.publicKeyRaw = this.publicKey.toDER();
        this.tbsCertificate = captures.tbsCertificate;
    }
    /**
     * Gets an extension by its name or oid.
     * If extension exists and a key provided, it will return extension[key].
     * ```js
     * certificate.getExtension('keyUsage')
     * certificate.getExtension('2.5.29.15')
     * // => { oid: '2.5.29.15',
     * //      critical: true,
     * //      value: <Buffer 03 02 05 a0>,
     * //      name: 'keyUsage',
     * //      digitalSignature: true,
     * //      nonRepudiation: false,
     * //      keyEncipherment: true,
     * //      dataEncipherment: false,
     * //      keyAgreement: false,
     * //      keyCertSign: false,
     * //      cRLSign: false,
     * //      encipherOnly: false,
     * //      decipherOnly: false }
     * certificate.getExtension('keyUsage', 'keyCertSign') // => false
     * ```
     * @param name extension name or OID
     * @param key key in extension
     */
    getExtension(name, key = '') {
        for (const ext of this.extensions) {
            if (name === ext.oid || name === ext.name) {
                return key === '' ? ext : ext[key];
            }
        }
        return null;
    }
    /**
     * Returns null if a subject certificate is valid, or error if invalid.
     * Note that it does not check validity time, DNS name, ip or others.
     * @param child subject's Certificate
     */
    checkSignature(child) {
        // RFC 5280, 4.2.1.9:
        // "If the basic constraints extension is not present in a version 3
        // certificate, or the extension is present but the cA boolean is not
        // asserted, then the certified public key MUST NOT be used to verify
        // certificate signatures."
        // (not handler entrust broken SPKI, See http://www.entrust.net/knowledge-base/technote.cfm?tn=7869)
        if (this.version === 3 && !this.basicConstraintsValid || (this.basicConstraintsValid && !this.isCA)) {
            return new Error('The parent constraint violation error');
        }
        if (this.getExtension('keyUsage', 'keyCertSign') !== true) {
            return new Error('The parent constraint violation error');
        }
        if (!child.isIssuer(this)) {
            return new Error('The parent certificate did not issue the given child certificate');
        }
        const agl = getHashAgl(child.signatureOID);
        if (agl === '') {
            return new Error('Unknown child signature OID.');
        }
        const res = this.publicKey.verify(child.tbsCertificate.DER, child.signature, agl);
        if (res === false) {
            return new Error('Child signature not matched');
        }
        return null;
    }
    /**
     * Returns true if this certificate's issuer matches the passed
     * certificate's subject. Note that no signature check is performed.
     * @param parent issuer's Certificate
     */
    isIssuer(parent) {
        return this.issuer.getHash().equals(parent.subject.getHash());
    }
    /**
     * Verifies the subjectKeyIdentifier extension value for this certificate
     * against its public key.
     */
    verifySubjectKeyIdentifier() {
        const ski = this.publicKey.getFingerprint('sha1', 'PublicKey');
        return ski.toString('hex') === this.subjectKeyIdentifier;
    }
    /**
     * Return a friendly JSON object for debuging.
     */
    toJSON() {
        const obj = {};
        for (const key of Object.keys(this)) {
            obj[key] = toJSONify(this[key]);
        }
        delete obj.tbsCertificate;
        return obj;
    }
    [util_1.inspect.custom](_depth, options) {
        if (options.depth <= 2) {
            options.depth = 10;
        }
        return `<${this.constructor.name} ${util_1.inspect(this.toJSON(), options)}>`;
    }
}
exports.Certificate = Certificate;
function certificateExtensionsFromAsn1(exts) {
    const res = [];
    for (const val of exts.mustCompound()) {
        for (const ext of val.mustCompound()) {
            res.push(certificateExtensionFromAsn1(ext));
        }
    }
    return res;
}
function certificateExtensionFromAsn1(ext) {
    // an extension has:
    // [0] extnID      OBJECT IDENTIFIER
    // [1] critical    BOOLEAN DEFAULT FALSE
    // [2] extnValue   OCTET STRING
    const e = {};
    e.oid = asn1_1.ASN1.parseOID(ext.value[0].bytes);
    e.critical = false;
    if (ext.value[1].tag === asn1_1.Tag.BOOLEAN) {
        e.critical = asn1_1.ASN1.parseBool(ext.value[1].bytes);
        e.value = ext.value[2].bytes;
    }
    else {
        e.value = ext.value[1].bytes;
    }
    // if the oid is known, get its name
    e.name = common_1.getOIDName(e.oid);
    switch (e.name) {
        // handle key usage
        case 'keyUsage':
            decodeExtKeyUsage(e);
            break;
        case 'basicConstraints':
            decodeExtBasicConstraints(e);
            break;
        case 'extKeyUsage':
            decodeExtExtKeyUsage(e);
            break;
        case 'nsCertType':
            decodeExtNsCertType(e);
            break;
        case 'subjectAltName':
            decodeExtAltName(e);
            break;
        case 'issuerAltName':
            decodeExtAltName(e);
            break;
        case 'subjectKeyIdentifier':
            decodeExtSubjectKeyIdentifier(e);
            break;
        case 'authorityKeyIdentifier':
            decodeExtAuthorityKeyIdentifier(e);
            break;
        case 'authorityInfoAccess':
            decodeExtAuthorityInfoAccess(e);
            break;
    }
    return e;
}
function decodeExtKeyUsage(e) {
    // ev is a BITSTRING
    const ev = asn1_1.ASN1.parseBitString(asn1_1.ASN1.fromDER(e.value).bytes);
    let b2 = 0x00;
    let b3 = 0x00;
    e.keyUsage = 0;
    for (let i = 0; i < 9; i++) {
        if (ev.at(i) !== 0) {
            e.keyUsage |= 1 << i;
        }
    }
    if (ev.buf.length > 0) {
        b2 = ev.buf[0];
        b3 = ev.buf.length > 1 ? ev.buf[1] : 0;
    }
    // set flags
    e.digitalSignature = (b2 & 0x80) === 0x80;
    e.nonRepudiation = (b2 & 0x40) === 0x40;
    e.keyEncipherment = (b2 & 0x20) === 0x20;
    e.dataEncipherment = (b2 & 0x10) === 0x10;
    e.keyAgreement = (b2 & 0x08) === 0x08;
    e.keyCertSign = (b2 & 0x04) === 0x04;
    e.cRLSign = (b2 & 0x02) === 0x02;
    e.encipherOnly = (b2 & 0x01) === 0x01;
    e.decipherOnly = (b3 & 0x80) === 0x80;
}
function decodeExtBasicConstraints(e) {
    // handle basic constraints
    // get value as SEQUENCE
    const ev = asn1_1.ASN1.fromDER(e.value);
    const vals = ev.mustCompound();
    // get cA BOOLEAN flag (defaults to false)
    if (vals.length > 0 && vals[0].tag === asn1_1.Tag.BOOLEAN) {
        e.isCA = asn1_1.ASN1.parseBool(vals[0].bytes);
    }
    else {
        e.isCA = false;
    }
    // get path length constraint
    let value = null;
    if (vals.length > 0 && vals[0].tag === asn1_1.Tag.INTEGER) {
        value = vals[0].bytes;
    }
    else if (vals.length > 1) {
        value = vals[1].bytes;
    }
    if (value !== null) {
        e.maxPathLen = asn1_1.ASN1.parseInteger(value);
    }
    else {
        e.maxPathLen = -1;
    }
    e.basicConstraintsValid = true;
}
function decodeExtExtKeyUsage(e) {
    // handle extKeyUsage
    // value is a SEQUENCE of OIDs
    const ev = asn1_1.ASN1.fromDER(e.value);
    const vals = ev.mustCompound();
    for (const val of vals) {
        e[common_1.getOIDName(asn1_1.ASN1.parseOID(val.bytes))] = true;
    }
}
function decodeExtNsCertType(e) {
    // ev is a BITSTRING
    const ev = asn1_1.ASN1.parseBitString(asn1_1.ASN1.fromDER(e.value).bytes);
    let b2 = 0x00;
    if (ev.buf.length > 0) {
        b2 = ev.buf[0];
    }
    // set flags
    e.client = (b2 & 0x80) === 0x80;
    e.server = (b2 & 0x40) === 0x40;
    e.email = (b2 & 0x20) === 0x20;
    e.objsign = (b2 & 0x10) === 0x10;
    e.reserved = (b2 & 0x08) === 0x08;
    e.sslCA = (b2 & 0x04) === 0x04;
    e.emailCA = (b2 & 0x02) === 0x02;
    e.objCA = (b2 & 0x01) === 0x01;
}
function decodeExtAltName(e) {
    // handle subjectAltName/issuerAltName
    e.altNames = [];
    // ev is a SYNTAX SEQUENCE
    const ev = asn1_1.ASN1.fromDER(e.value);
    const vals = ev.mustCompound();
    for (const gn of vals) {
        // get GeneralName
        const item = {
            tag: gn.tag,
            value: gn.bytes,
        };
        e.altNames.push(item);
        switch (gn.tag) {
            // rfc822Name, emailAddresses
            case 1:
                item.email = gn.bytes.toString();
                break;
            // dNSName
            case 2:
                item.dnsName = gn.bytes.toString();
                break;
            // uniformResourceIdentifier (URI)
            case 6:
                item.uri = gn.bytes.toString();
                break;
            // IPAddress
            case 7:
                // convert to IPv4/IPv6 string representation
                item.ip = common_1.bytesToIP(gn.bytes);
                break;
            // registeredID
            case 8:
                item.oid = asn1_1.ASN1.parseOID(gn.bytes);
                break;
            default:
            // unsupported
        }
    }
}
const subjectKeyIdentifierValidator = {
    name: 'subjectKeyIdentifier',
    class: asn1_1.Class.UNIVERSAL,
    tag: asn1_1.Tag.OCTETSTRING,
    capture: 'subjectKeyIdentifier',
};
function decodeExtSubjectKeyIdentifier(e) {
    const captures = asn1_1.ASN1.parseDERWithTemplate(e.value, subjectKeyIdentifierValidator);
    e.subjectKeyIdentifier = captures.subjectKeyIdentifier.bytes.toString('hex');
}
const authorityKeyIdentifierValidator = {
    name: 'authorityKeyIdentifier',
    class: asn1_1.Class.UNIVERSAL,
    tag: asn1_1.Tag.SEQUENCE,
    value: [{
            name: 'authorityKeyIdentifier.value',
            class: asn1_1.Class.CONTEXT_SPECIFIC,
            tag: asn1_1.Tag.NONE,
            capture: 'authorityKeyIdentifier',
        }],
};
function decodeExtAuthorityKeyIdentifier(e) {
    const captures = asn1_1.ASN1.parseDERWithTemplate(e.value, authorityKeyIdentifierValidator);
    e.authorityKeyIdentifier = captures.authorityKeyIdentifier.bytes.toString('hex');
}
const authorityInfoAccessValidator = {
    name: 'authorityInfoAccess',
    class: asn1_1.Class.UNIVERSAL,
    tag: asn1_1.Tag.SEQUENCE,
    value: [{
            name: 'authorityInfoAccess.authorityInfoAccessOcsp',
            class: asn1_1.Class.UNIVERSAL,
            tag: asn1_1.Tag.SEQUENCE,
            optional: true,
            value: [{
                    name: 'authorityInfoAccess.authorityInfoAccessOcsp.oid',
                    class: asn1_1.Class.UNIVERSAL,
                    tag: asn1_1.Tag.OID,
                }, {
                    name: 'authorityInfoAccess.authorityInfoAccessOcsp.value',
                    class: asn1_1.Class.CONTEXT_SPECIFIC,
                    tag: asn1_1.Tag.OID,
                    capture: 'authorityInfoAccessOcsp',
                }],
        }, {
            name: 'authorityInfoAccess.authorityInfoAccessIssuers',
            class: asn1_1.Class.UNIVERSAL,
            tag: asn1_1.Tag.SEQUENCE,
            optional: true,
            value: [{
                    name: 'authorityInfoAccess.authorityInfoAccessIssuers.oid',
                    class: asn1_1.Class.UNIVERSAL,
                    tag: asn1_1.Tag.OID,
                }, {
                    name: 'authorityInfoAccess.authorityInfoAccessIssuers.value',
                    class: asn1_1.Class.CONTEXT_SPECIFIC,
                    tag: asn1_1.Tag.OID,
                    capture: 'authorityInfoAccessIssuers',
                }],
        }],
};
function decodeExtAuthorityInfoAccess(e) {
    const captures = asn1_1.ASN1.parseDERWithTemplate(e.value, authorityInfoAccessValidator);
    if (captures.authorityInfoAccessOcsp != null) {
        e.authorityInfoAccessOcsp = captures.authorityInfoAccessOcsp.bytes.toString();
    }
    if (captures.authorityInfoAccessIssuers != null) {
        e.authorityInfoAccessIssuers = captures.authorityInfoAccessIssuers.bytes.toString();
    }
}
// Fills in missing fields in attributes.
function fillMissingFields(attrs) {
    for (const attr of attrs) {
        // populate missing name
        if (attr.name == null || attr.name === '') {
            if (attr.oid != null) {
                attr.name = common_1.getOIDName(attr.oid);
            }
            if (attr.name === '' && attr.shortName != null) {
                attr.name = common_1.getOIDName(shortNames[attr.shortName]);
            }
        }
        // populate missing type (OID)
        if (attr.oid == null || attr.oid === '') {
            if (attr.name !== '') {
                attr.oid = common_1.getOID(attr.name);
            }
            else {
                throw new Error('Attribute oid not specified.');
            }
        }
        // populate missing shortname
        if (attr.shortName == null || attr.shortName === '') {
            attr.shortName = shortNames[attr.name] == null ? '' : shortNames[attr.name];
        }
        if (attr.value == null) {
            throw new Error('Attribute value not specified.');
        }
    }
}
// Only support RSA and ECDSA
function getHashAgl(oid) {
    switch (common_1.getOIDName(oid)) {
        case 'sha1WithRsaEncryption':
            return 'sha1';
        case 'md5WithRsaEncryption':
            return 'md5';
        case 'sha256WithRsaEncryption':
            return 'sha256';
        case 'sha384WithRsaEncryption':
            return 'sha384';
        case 'sha512WithRsaEncryption':
            return 'sha512';
        case 'RSASSA-PSS':
            return 'sha256';
        case 'ecdsaWithSha1':
            return 'sha1';
        case 'ecdsaWithSha256':
            return 'sha256';
        case 'ecdsaWithSha384':
            return 'sha384';
        case 'ecdsaWithSha512':
            return 'sha512';
        case 'dsaWithSha1':
            return 'sha1';
        case 'dsaWithSha256':
            return 'sha256';
        default:
            return '';
    }
}
// Converts an RDNSequence of ASN.1 DER-encoded RelativeDistinguishedName
// sets into an array with objects that have type and value properties.
function RDNAttributesAsArray(rdn) {
    const rval = [];
    // each value in 'rdn' in is a SET of RelativeDistinguishedName
    // var set, attr, obj
    for (const set of rdn.mustCompound()) {
        // each value in the SET is an AttributeTypeAndValue sequence
        // containing first a type (an OID) and second a value (defined by the OID)
        for (const attr of set.mustCompound()) {
            const values = attr.mustCompound();
            const obj = {};
            obj.oid = asn1_1.ASN1.parseOID(values[0].bytes);
            obj.value = values[1].value;
            obj.valueTag = values[1].tag;
            obj.name = common_1.getOIDName(obj.oid);
            obj.shortName = getShortName(obj.name);
            rval.push(obj);
        }
    }
    return rval;
}
function toJSONify(val) {
    if (val != null && !(val instanceof Buffer) && typeof val.toJSON === 'function') {
        return val.toJSON();
    }
    return val;
}
//# sourceMappingURL=x509.js.map

/***/ }),

/***/ 55842:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

(function(nacl) {
'use strict';

// Ported in 2014 by Dmitry Chestnykh and Devi Mandiri.
// Public domain.
//
// Implementation derived from TweetNaCl version 20140427.
// See for details: http://tweetnacl.cr.yp.to/

var gf = function(init) {
  var i, r = new Float64Array(16);
  if (init) for (i = 0; i < init.length; i++) r[i] = init[i];
  return r;
};

//  Pluggable, initialized in high-level API below.
var randombytes = function(/* x, n */) { throw new Error('no PRNG'); };

var _0 = new Uint8Array(16);
var _9 = new Uint8Array(32); _9[0] = 9;

var gf0 = gf(),
    gf1 = gf([1]),
    _121665 = gf([0xdb41, 1]),
    D = gf([0x78a3, 0x1359, 0x4dca, 0x75eb, 0xd8ab, 0x4141, 0x0a4d, 0x0070, 0xe898, 0x7779, 0x4079, 0x8cc7, 0xfe73, 0x2b6f, 0x6cee, 0x5203]),
    D2 = gf([0xf159, 0x26b2, 0x9b94, 0xebd6, 0xb156, 0x8283, 0x149a, 0x00e0, 0xd130, 0xeef3, 0x80f2, 0x198e, 0xfce7, 0x56df, 0xd9dc, 0x2406]),
    X = gf([0xd51a, 0x8f25, 0x2d60, 0xc956, 0xa7b2, 0x9525, 0xc760, 0x692c, 0xdc5c, 0xfdd6, 0xe231, 0xc0a4, 0x53fe, 0xcd6e, 0x36d3, 0x2169]),
    Y = gf([0x6658, 0x6666, 0x6666, 0x6666, 0x6666, 0x6666, 0x6666, 0x6666, 0x6666, 0x6666, 0x6666, 0x6666, 0x6666, 0x6666, 0x6666, 0x6666]),
    I = gf([0xa0b0, 0x4a0e, 0x1b27, 0xc4ee, 0xe478, 0xad2f, 0x1806, 0x2f43, 0xd7a7, 0x3dfb, 0x0099, 0x2b4d, 0xdf0b, 0x4fc1, 0x2480, 0x2b83]);

function ts64(x, i, h, l) {
  x[i]   = (h >> 24) & 0xff;
  x[i+1] = (h >> 16) & 0xff;
  x[i+2] = (h >>  8) & 0xff;
  x[i+3] = h & 0xff;
  x[i+4] = (l >> 24)  & 0xff;
  x[i+5] = (l >> 16)  & 0xff;
  x[i+6] = (l >>  8)  & 0xff;
  x[i+7] = l & 0xff;
}

function vn(x, xi, y, yi, n) {
  var i,d = 0;
  for (i = 0; i < n; i++) d |= x[xi+i]^y[yi+i];
  return (1 & ((d - 1) >>> 8)) - 1;
}

function crypto_verify_16(x, xi, y, yi) {
  return vn(x,xi,y,yi,16);
}

function crypto_verify_32(x, xi, y, yi) {
  return vn(x,xi,y,yi,32);
}

function core_salsa20(o, p, k, c) {
  var j0  = c[ 0] & 0xff | (c[ 1] & 0xff)<<8 | (c[ 2] & 0xff)<<16 | (c[ 3] & 0xff)<<24,
      j1  = k[ 0] & 0xff | (k[ 1] & 0xff)<<8 | (k[ 2] & 0xff)<<16 | (k[ 3] & 0xff)<<24,
      j2  = k[ 4] & 0xff | (k[ 5] & 0xff)<<8 | (k[ 6] & 0xff)<<16 | (k[ 7] & 0xff)<<24,
      j3  = k[ 8] & 0xff | (k[ 9] & 0xff)<<8 | (k[10] & 0xff)<<16 | (k[11] & 0xff)<<24,
      j4  = k[12] & 0xff | (k[13] & 0xff)<<8 | (k[14] & 0xff)<<16 | (k[15] & 0xff)<<24,
      j5  = c[ 4] & 0xff | (c[ 5] & 0xff)<<8 | (c[ 6] & 0xff)<<16 | (c[ 7] & 0xff)<<24,
      j6  = p[ 0] & 0xff | (p[ 1] & 0xff)<<8 | (p[ 2] & 0xff)<<16 | (p[ 3] & 0xff)<<24,
      j7  = p[ 4] & 0xff | (p[ 5] & 0xff)<<8 | (p[ 6] & 0xff)<<16 | (p[ 7] & 0xff)<<24,
      j8  = p[ 8] & 0xff | (p[ 9] & 0xff)<<8 | (p[10] & 0xff)<<16 | (p[11] & 0xff)<<24,
      j9  = p[12] & 0xff | (p[13] & 0xff)<<8 | (p[14] & 0xff)<<16 | (p[15] & 0xff)<<24,
      j10 = c[ 8] & 0xff | (c[ 9] & 0xff)<<8 | (c[10] & 0xff)<<16 | (c[11] & 0xff)<<24,
      j11 = k[16] & 0xff | (k[17] & 0xff)<<8 | (k[18] & 0xff)<<16 | (k[19] & 0xff)<<24,
      j12 = k[20] & 0xff | (k[21] & 0xff)<<8 | (k[22] & 0xff)<<16 | (k[23] & 0xff)<<24,
      j13 = k[24] & 0xff | (k[25] & 0xff)<<8 | (k[26] & 0xff)<<16 | (k[27] & 0xff)<<24,
      j14 = k[28] & 0xff | (k[29] & 0xff)<<8 | (k[30] & 0xff)<<16 | (k[31] & 0xff)<<24,
      j15 = c[12] & 0xff | (c[13] & 0xff)<<8 | (c[14] & 0xff)<<16 | (c[15] & 0xff)<<24;

  var x0 = j0, x1 = j1, x2 = j2, x3 = j3, x4 = j4, x5 = j5, x6 = j6, x7 = j7,
      x8 = j8, x9 = j9, x10 = j10, x11 = j11, x12 = j12, x13 = j13, x14 = j14,
      x15 = j15, u;

  for (var i = 0; i < 20; i += 2) {
    u = x0 + x12 | 0;
    x4 ^= u<<7 | u>>>(32-7);
    u = x4 + x0 | 0;
    x8 ^= u<<9 | u>>>(32-9);
    u = x8 + x4 | 0;
    x12 ^= u<<13 | u>>>(32-13);
    u = x12 + x8 | 0;
    x0 ^= u<<18 | u>>>(32-18);

    u = x5 + x1 | 0;
    x9 ^= u<<7 | u>>>(32-7);
    u = x9 + x5 | 0;
    x13 ^= u<<9 | u>>>(32-9);
    u = x13 + x9 | 0;
    x1 ^= u<<13 | u>>>(32-13);
    u = x1 + x13 | 0;
    x5 ^= u<<18 | u>>>(32-18);

    u = x10 + x6 | 0;
    x14 ^= u<<7 | u>>>(32-7);
    u = x14 + x10 | 0;
    x2 ^= u<<9 | u>>>(32-9);
    u = x2 + x14 | 0;
    x6 ^= u<<13 | u>>>(32-13);
    u = x6 + x2 | 0;
    x10 ^= u<<18 | u>>>(32-18);

    u = x15 + x11 | 0;
    x3 ^= u<<7 | u>>>(32-7);
    u = x3 + x15 | 0;
    x7 ^= u<<9 | u>>>(32-9);
    u = x7 + x3 | 0;
    x11 ^= u<<13 | u>>>(32-13);
    u = x11 + x7 | 0;
    x15 ^= u<<18 | u>>>(32-18);

    u = x0 + x3 | 0;
    x1 ^= u<<7 | u>>>(32-7);
    u = x1 + x0 | 0;
    x2 ^= u<<9 | u>>>(32-9);
    u = x2 + x1 | 0;
    x3 ^= u<<13 | u>>>(32-13);
    u = x3 + x2 | 0;
    x0 ^= u<<18 | u>>>(32-18);

    u = x5 + x4 | 0;
    x6 ^= u<<7 | u>>>(32-7);
    u = x6 + x5 | 0;
    x7 ^= u<<9 | u>>>(32-9);
    u = x7 + x6 | 0;
    x4 ^= u<<13 | u>>>(32-13);
    u = x4 + x7 | 0;
    x5 ^= u<<18 | u>>>(32-18);

    u = x10 + x9 | 0;
    x11 ^= u<<7 | u>>>(32-7);
    u = x11 + x10 | 0;
    x8 ^= u<<9 | u>>>(32-9);
    u = x8 + x11 | 0;
    x9 ^= u<<13 | u>>>(32-13);
    u = x9 + x8 | 0;
    x10 ^= u<<18 | u>>>(32-18);

    u = x15 + x14 | 0;
    x12 ^= u<<7 | u>>>(32-7);
    u = x12 + x15 | 0;
    x13 ^= u<<9 | u>>>(32-9);
    u = x13 + x12 | 0;
    x14 ^= u<<13 | u>>>(32-13);
    u = x14 + x13 | 0;
    x15 ^= u<<18 | u>>>(32-18);
  }
   x0 =  x0 +  j0 | 0;
   x1 =  x1 +  j1 | 0;
   x2 =  x2 +  j2 | 0;
   x3 =  x3 +  j3 | 0;
   x4 =  x4 +  j4 | 0;
   x5 =  x5 +  j5 | 0;
   x6 =  x6 +  j6 | 0;
   x7 =  x7 +  j7 | 0;
   x8 =  x8 +  j8 | 0;
   x9 =  x9 +  j9 | 0;
  x10 = x10 + j10 | 0;
  x11 = x11 + j11 | 0;
  x12 = x12 + j12 | 0;
  x13 = x13 + j13 | 0;
  x14 = x14 + j14 | 0;
  x15 = x15 + j15 | 0;

  o[ 0] = x0 >>>  0 & 0xff;
  o[ 1] = x0 >>>  8 & 0xff;
  o[ 2] = x0 >>> 16 & 0xff;
  o[ 3] = x0 >>> 24 & 0xff;

  o[ 4] = x1 >>>  0 & 0xff;
  o[ 5] = x1 >>>  8 & 0xff;
  o[ 6] = x1 >>> 16 & 0xff;
  o[ 7] = x1 >>> 24 & 0xff;

  o[ 8] = x2 >>>  0 & 0xff;
  o[ 9] = x2 >>>  8 & 0xff;
  o[10] = x2 >>> 16 & 0xff;
  o[11] = x2 >>> 24 & 0xff;

  o[12] = x3 >>>  0 & 0xff;
  o[13] = x3 >>>  8 & 0xff;
  o[14] = x3 >>> 16 & 0xff;
  o[15] = x3 >>> 24 & 0xff;

  o[16] = x4 >>>  0 & 0xff;
  o[17] = x4 >>>  8 & 0xff;
  o[18] = x4 >>> 16 & 0xff;
  o[19] = x4 >>> 24 & 0xff;

  o[20] = x5 >>>  0 & 0xff;
  o[21] = x5 >>>  8 & 0xff;
  o[22] = x5 >>> 16 & 0xff;
  o[23] = x5 >>> 24 & 0xff;

  o[24] = x6 >>>  0 & 0xff;
  o[25] = x6 >>>  8 & 0xff;
  o[26] = x6 >>> 16 & 0xff;
  o[27] = x6 >>> 24 & 0xff;

  o[28] = x7 >>>  0 & 0xff;
  o[29] = x7 >>>  8 & 0xff;
  o[30] = x7 >>> 16 & 0xff;
  o[31] = x7 >>> 24 & 0xff;

  o[32] = x8 >>>  0 & 0xff;
  o[33] = x8 >>>  8 & 0xff;
  o[34] = x8 >>> 16 & 0xff;
  o[35] = x8 >>> 24 & 0xff;

  o[36] = x9 >>>  0 & 0xff;
  o[37] = x9 >>>  8 & 0xff;
  o[38] = x9 >>> 16 & 0xff;
  o[39] = x9 >>> 24 & 0xff;

  o[40] = x10 >>>  0 & 0xff;
  o[41] = x10 >>>  8 & 0xff;
  o[42] = x10 >>> 16 & 0xff;
  o[43] = x10 >>> 24 & 0xff;

  o[44] = x11 >>>  0 & 0xff;
  o[45] = x11 >>>  8 & 0xff;
  o[46] = x11 >>> 16 & 0xff;
  o[47] = x11 >>> 24 & 0xff;

  o[48] = x12 >>>  0 & 0xff;
  o[49] = x12 >>>  8 & 0xff;
  o[50] = x12 >>> 16 & 0xff;
  o[51] = x12 >>> 24 & 0xff;

  o[52] = x13 >>>  0 & 0xff;
  o[53] = x13 >>>  8 & 0xff;
  o[54] = x13 >>> 16 & 0xff;
  o[55] = x13 >>> 24 & 0xff;

  o[56] = x14 >>>  0 & 0xff;
  o[57] = x14 >>>  8 & 0xff;
  o[58] = x14 >>> 16 & 0xff;
  o[59] = x14 >>> 24 & 0xff;

  o[60] = x15 >>>  0 & 0xff;
  o[61] = x15 >>>  8 & 0xff;
  o[62] = x15 >>> 16 & 0xff;
  o[63] = x15 >>> 24 & 0xff;
}

function core_hsalsa20(o,p,k,c) {
  var j0  = c[ 0] & 0xff | (c[ 1] & 0xff)<<8 | (c[ 2] & 0xff)<<16 | (c[ 3] & 0xff)<<24,
      j1  = k[ 0] & 0xff | (k[ 1] & 0xff)<<8 | (k[ 2] & 0xff)<<16 | (k[ 3] & 0xff)<<24,
      j2  = k[ 4] & 0xff | (k[ 5] & 0xff)<<8 | (k[ 6] & 0xff)<<16 | (k[ 7] & 0xff)<<24,
      j3  = k[ 8] & 0xff | (k[ 9] & 0xff)<<8 | (k[10] & 0xff)<<16 | (k[11] & 0xff)<<24,
      j4  = k[12] & 0xff | (k[13] & 0xff)<<8 | (k[14] & 0xff)<<16 | (k[15] & 0xff)<<24,
      j5  = c[ 4] & 0xff | (c[ 5] & 0xff)<<8 | (c[ 6] & 0xff)<<16 | (c[ 7] & 0xff)<<24,
      j6  = p[ 0] & 0xff | (p[ 1] & 0xff)<<8 | (p[ 2] & 0xff)<<16 | (p[ 3] & 0xff)<<24,
      j7  = p[ 4] & 0xff | (p[ 5] & 0xff)<<8 | (p[ 6] & 0xff)<<16 | (p[ 7] & 0xff)<<24,
      j8  = p[ 8] & 0xff | (p[ 9] & 0xff)<<8 | (p[10] & 0xff)<<16 | (p[11] & 0xff)<<24,
      j9  = p[12] & 0xff | (p[13] & 0xff)<<8 | (p[14] & 0xff)<<16 | (p[15] & 0xff)<<24,
      j10 = c[ 8] & 0xff | (c[ 9] & 0xff)<<8 | (c[10] & 0xff)<<16 | (c[11] & 0xff)<<24,
      j11 = k[16] & 0xff | (k[17] & 0xff)<<8 | (k[18] & 0xff)<<16 | (k[19] & 0xff)<<24,
      j12 = k[20] & 0xff | (k[21] & 0xff)<<8 | (k[22] & 0xff)<<16 | (k[23] & 0xff)<<24,
      j13 = k[24] & 0xff | (k[25] & 0xff)<<8 | (k[26] & 0xff)<<16 | (k[27] & 0xff)<<24,
      j14 = k[28] & 0xff | (k[29] & 0xff)<<8 | (k[30] & 0xff)<<16 | (k[31] & 0xff)<<24,
      j15 = c[12] & 0xff | (c[13] & 0xff)<<8 | (c[14] & 0xff)<<16 | (c[15] & 0xff)<<24;

  var x0 = j0, x1 = j1, x2 = j2, x3 = j3, x4 = j4, x5 = j5, x6 = j6, x7 = j7,
      x8 = j8, x9 = j9, x10 = j10, x11 = j11, x12 = j12, x13 = j13, x14 = j14,
      x15 = j15, u;

  for (var i = 0; i < 20; i += 2) {
    u = x0 + x12 | 0;
    x4 ^= u<<7 | u>>>(32-7);
    u = x4 + x0 | 0;
    x8 ^= u<<9 | u>>>(32-9);
    u = x8 + x4 | 0;
    x12 ^= u<<13 | u>>>(32-13);
    u = x12 + x8 | 0;
    x0 ^= u<<18 | u>>>(32-18);

    u = x5 + x1 | 0;
    x9 ^= u<<7 | u>>>(32-7);
    u = x9 + x5 | 0;
    x13 ^= u<<9 | u>>>(32-9);
    u = x13 + x9 | 0;
    x1 ^= u<<13 | u>>>(32-13);
    u = x1 + x13 | 0;
    x5 ^= u<<18 | u>>>(32-18);

    u = x10 + x6 | 0;
    x14 ^= u<<7 | u>>>(32-7);
    u = x14 + x10 | 0;
    x2 ^= u<<9 | u>>>(32-9);
    u = x2 + x14 | 0;
    x6 ^= u<<13 | u>>>(32-13);
    u = x6 + x2 | 0;
    x10 ^= u<<18 | u>>>(32-18);

    u = x15 + x11 | 0;
    x3 ^= u<<7 | u>>>(32-7);
    u = x3 + x15 | 0;
    x7 ^= u<<9 | u>>>(32-9);
    u = x7 + x3 | 0;
    x11 ^= u<<13 | u>>>(32-13);
    u = x11 + x7 | 0;
    x15 ^= u<<18 | u>>>(32-18);

    u = x0 + x3 | 0;
    x1 ^= u<<7 | u>>>(32-7);
    u = x1 + x0 | 0;
    x2 ^= u<<9 | u>>>(32-9);
    u = x2 + x1 | 0;
    x3 ^= u<<13 | u>>>(32-13);
    u = x3 + x2 | 0;
    x0 ^= u<<18 | u>>>(32-18);

    u = x5 + x4 | 0;
    x6 ^= u<<7 | u>>>(32-7);
    u = x6 + x5 | 0;
    x7 ^= u<<9 | u>>>(32-9);
    u = x7 + x6 | 0;
    x4 ^= u<<13 | u>>>(32-13);
    u = x4 + x7 | 0;
    x5 ^= u<<18 | u>>>(32-18);

    u = x10 + x9 | 0;
    x11 ^= u<<7 | u>>>(32-7);
    u = x11 + x10 | 0;
    x8 ^= u<<9 | u>>>(32-9);
    u = x8 + x11 | 0;
    x9 ^= u<<13 | u>>>(32-13);
    u = x9 + x8 | 0;
    x10 ^= u<<18 | u>>>(32-18);

    u = x15 + x14 | 0;
    x12 ^= u<<7 | u>>>(32-7);
    u = x12 + x15 | 0;
    x13 ^= u<<9 | u>>>(32-9);
    u = x13 + x12 | 0;
    x14 ^= u<<13 | u>>>(32-13);
    u = x14 + x13 | 0;
    x15 ^= u<<18 | u>>>(32-18);
  }

  o[ 0] = x0 >>>  0 & 0xff;
  o[ 1] = x0 >>>  8 & 0xff;
  o[ 2] = x0 >>> 16 & 0xff;
  o[ 3] = x0 >>> 24 & 0xff;

  o[ 4] = x5 >>>  0 & 0xff;
  o[ 5] = x5 >>>  8 & 0xff;
  o[ 6] = x5 >>> 16 & 0xff;
  o[ 7] = x5 >>> 24 & 0xff;

  o[ 8] = x10 >>>  0 & 0xff;
  o[ 9] = x10 >>>  8 & 0xff;
  o[10] = x10 >>> 16 & 0xff;
  o[11] = x10 >>> 24 & 0xff;

  o[12] = x15 >>>  0 & 0xff;
  o[13] = x15 >>>  8 & 0xff;
  o[14] = x15 >>> 16 & 0xff;
  o[15] = x15 >>> 24 & 0xff;

  o[16] = x6 >>>  0 & 0xff;
  o[17] = x6 >>>  8 & 0xff;
  o[18] = x6 >>> 16 & 0xff;
  o[19] = x6 >>> 24 & 0xff;

  o[20] = x7 >>>  0 & 0xff;
  o[21] = x7 >>>  8 & 0xff;
  o[22] = x7 >>> 16 & 0xff;
  o[23] = x7 >>> 24 & 0xff;

  o[24] = x8 >>>  0 & 0xff;
  o[25] = x8 >>>  8 & 0xff;
  o[26] = x8 >>> 16 & 0xff;
  o[27] = x8 >>> 24 & 0xff;

  o[28] = x9 >>>  0 & 0xff;
  o[29] = x9 >>>  8 & 0xff;
  o[30] = x9 >>> 16 & 0xff;
  o[31] = x9 >>> 24 & 0xff;
}

function crypto_core_salsa20(out,inp,k,c) {
  core_salsa20(out,inp,k,c);
}

function crypto_core_hsalsa20(out,inp,k,c) {
  core_hsalsa20(out,inp,k,c);
}

var sigma = new Uint8Array([101, 120, 112, 97, 110, 100, 32, 51, 50, 45, 98, 121, 116, 101, 32, 107]);
            // "expand 32-byte k"

function crypto_stream_salsa20_xor(c,cpos,m,mpos,b,n,k) {
  var z = new Uint8Array(16), x = new Uint8Array(64);
  var u, i;
  for (i = 0; i < 16; i++) z[i] = 0;
  for (i = 0; i < 8; i++) z[i] = n[i];
  while (b >= 64) {
    crypto_core_salsa20(x,z,k,sigma);
    for (i = 0; i < 64; i++) c[cpos+i] = m[mpos+i] ^ x[i];
    u = 1;
    for (i = 8; i < 16; i++) {
      u = u + (z[i] & 0xff) | 0;
      z[i] = u & 0xff;
      u >>>= 8;
    }
    b -= 64;
    cpos += 64;
    mpos += 64;
  }
  if (b > 0) {
    crypto_core_salsa20(x,z,k,sigma);
    for (i = 0; i < b; i++) c[cpos+i] = m[mpos+i] ^ x[i];
  }
  return 0;
}

function crypto_stream_salsa20(c,cpos,b,n,k) {
  var z = new Uint8Array(16), x = new Uint8Array(64);
  var u, i;
  for (i = 0; i < 16; i++) z[i] = 0;
  for (i = 0; i < 8; i++) z[i] = n[i];
  while (b >= 64) {
    crypto_core_salsa20(x,z,k,sigma);
    for (i = 0; i < 64; i++) c[cpos+i] = x[i];
    u = 1;
    for (i = 8; i < 16; i++) {
      u = u + (z[i] & 0xff) | 0;
      z[i] = u & 0xff;
      u >>>= 8;
    }
    b -= 64;
    cpos += 64;
  }
  if (b > 0) {
    crypto_core_salsa20(x,z,k,sigma);
    for (i = 0; i < b; i++) c[cpos+i] = x[i];
  }
  return 0;
}

function crypto_stream(c,cpos,d,n,k) {
  var s = new Uint8Array(32);
  crypto_core_hsalsa20(s,n,k,sigma);
  var sn = new Uint8Array(8);
  for (var i = 0; i < 8; i++) sn[i] = n[i+16];
  return crypto_stream_salsa20(c,cpos,d,sn,s);
}

function crypto_stream_xor(c,cpos,m,mpos,d,n,k) {
  var s = new Uint8Array(32);
  crypto_core_hsalsa20(s,n,k,sigma);
  var sn = new Uint8Array(8);
  for (var i = 0; i < 8; i++) sn[i] = n[i+16];
  return crypto_stream_salsa20_xor(c,cpos,m,mpos,d,sn,s);
}

/*
* Port of Andrew Moon's Poly1305-donna-16. Public domain.
* https://github.com/floodyberry/poly1305-donna
*/

var poly1305 = function(key) {
  this.buffer = new Uint8Array(16);
  this.r = new Uint16Array(10);
  this.h = new Uint16Array(10);
  this.pad = new Uint16Array(8);
  this.leftover = 0;
  this.fin = 0;

  var t0, t1, t2, t3, t4, t5, t6, t7;

  t0 = key[ 0] & 0xff | (key[ 1] & 0xff) << 8; this.r[0] = ( t0                     ) & 0x1fff;
  t1 = key[ 2] & 0xff | (key[ 3] & 0xff) << 8; this.r[1] = ((t0 >>> 13) | (t1 <<  3)) & 0x1fff;
  t2 = key[ 4] & 0xff | (key[ 5] & 0xff) << 8; this.r[2] = ((t1 >>> 10) | (t2 <<  6)) & 0x1f03;
  t3 = key[ 6] & 0xff | (key[ 7] & 0xff) << 8; this.r[3] = ((t2 >>>  7) | (t3 <<  9)) & 0x1fff;
  t4 = key[ 8] & 0xff | (key[ 9] & 0xff) << 8; this.r[4] = ((t3 >>>  4) | (t4 << 12)) & 0x00ff;
  this.r[5] = ((t4 >>>  1)) & 0x1ffe;
  t5 = key[10] & 0xff | (key[11] & 0xff) << 8; this.r[6] = ((t4 >>> 14) | (t5 <<  2)) & 0x1fff;
  t6 = key[12] & 0xff | (key[13] & 0xff) << 8; this.r[7] = ((t5 >>> 11) | (t6 <<  5)) & 0x1f81;
  t7 = key[14] & 0xff | (key[15] & 0xff) << 8; this.r[8] = ((t6 >>>  8) | (t7 <<  8)) & 0x1fff;
  this.r[9] = ((t7 >>>  5)) & 0x007f;

  this.pad[0] = key[16] & 0xff | (key[17] & 0xff) << 8;
  this.pad[1] = key[18] & 0xff | (key[19] & 0xff) << 8;
  this.pad[2] = key[20] & 0xff | (key[21] & 0xff) << 8;
  this.pad[3] = key[22] & 0xff | (key[23] & 0xff) << 8;
  this.pad[4] = key[24] & 0xff | (key[25] & 0xff) << 8;
  this.pad[5] = key[26] & 0xff | (key[27] & 0xff) << 8;
  this.pad[6] = key[28] & 0xff | (key[29] & 0xff) << 8;
  this.pad[7] = key[30] & 0xff | (key[31] & 0xff) << 8;
};

poly1305.prototype.blocks = function(m, mpos, bytes) {
  var hibit = this.fin ? 0 : (1 << 11);
  var t0, t1, t2, t3, t4, t5, t6, t7, c;
  var d0, d1, d2, d3, d4, d5, d6, d7, d8, d9;

  var h0 = this.h[0],
      h1 = this.h[1],
      h2 = this.h[2],
      h3 = this.h[3],
      h4 = this.h[4],
      h5 = this.h[5],
      h6 = this.h[6],
      h7 = this.h[7],
      h8 = this.h[8],
      h9 = this.h[9];

  var r0 = this.r[0],
      r1 = this.r[1],
      r2 = this.r[2],
      r3 = this.r[3],
      r4 = this.r[4],
      r5 = this.r[5],
      r6 = this.r[6],
      r7 = this.r[7],
      r8 = this.r[8],
      r9 = this.r[9];

  while (bytes >= 16) {
    t0 = m[mpos+ 0] & 0xff | (m[mpos+ 1] & 0xff) << 8; h0 += ( t0                     ) & 0x1fff;
    t1 = m[mpos+ 2] & 0xff | (m[mpos+ 3] & 0xff) << 8; h1 += ((t0 >>> 13) | (t1 <<  3)) & 0x1fff;
    t2 = m[mpos+ 4] & 0xff | (m[mpos+ 5] & 0xff) << 8; h2 += ((t1 >>> 10) | (t2 <<  6)) & 0x1fff;
    t3 = m[mpos+ 6] & 0xff | (m[mpos+ 7] & 0xff) << 8; h3 += ((t2 >>>  7) | (t3 <<  9)) & 0x1fff;
    t4 = m[mpos+ 8] & 0xff | (m[mpos+ 9] & 0xff) << 8; h4 += ((t3 >>>  4) | (t4 << 12)) & 0x1fff;
    h5 += ((t4 >>>  1)) & 0x1fff;
    t5 = m[mpos+10] & 0xff | (m[mpos+11] & 0xff) << 8; h6 += ((t4 >>> 14) | (t5 <<  2)) & 0x1fff;
    t6 = m[mpos+12] & 0xff | (m[mpos+13] & 0xff) << 8; h7 += ((t5 >>> 11) | (t6 <<  5)) & 0x1fff;
    t7 = m[mpos+14] & 0xff | (m[mpos+15] & 0xff) << 8; h8 += ((t6 >>>  8) | (t7 <<  8)) & 0x1fff;
    h9 += ((t7 >>> 5)) | hibit;

    c = 0;

    d0 = c;
    d0 += h0 * r0;
    d0 += h1 * (5 * r9);
    d0 += h2 * (5 * r8);
    d0 += h3 * (5 * r7);
    d0 += h4 * (5 * r6);
    c = (d0 >>> 13); d0 &= 0x1fff;
    d0 += h5 * (5 * r5);
    d0 += h6 * (5 * r4);
    d0 += h7 * (5 * r3);
    d0 += h8 * (5 * r2);
    d0 += h9 * (5 * r1);
    c += (d0 >>> 13); d0 &= 0x1fff;

    d1 = c;
    d1 += h0 * r1;
    d1 += h1 * r0;
    d1 += h2 * (5 * r9);
    d1 += h3 * (5 * r8);
    d1 += h4 * (5 * r7);
    c = (d1 >>> 13); d1 &= 0x1fff;
    d1 += h5 * (5 * r6);
    d1 += h6 * (5 * r5);
    d1 += h7 * (5 * r4);
    d1 += h8 * (5 * r3);
    d1 += h9 * (5 * r2);
    c += (d1 >>> 13); d1 &= 0x1fff;

    d2 = c;
    d2 += h0 * r2;
    d2 += h1 * r1;
    d2 += h2 * r0;
    d2 += h3 * (5 * r9);
    d2 += h4 * (5 * r8);
    c = (d2 >>> 13); d2 &= 0x1fff;
    d2 += h5 * (5 * r7);
    d2 += h6 * (5 * r6);
    d2 += h7 * (5 * r5);
    d2 += h8 * (5 * r4);
    d2 += h9 * (5 * r3);
    c += (d2 >>> 13); d2 &= 0x1fff;

    d3 = c;
    d3 += h0 * r3;
    d3 += h1 * r2;
    d3 += h2 * r1;
    d3 += h3 * r0;
    d3 += h4 * (5 * r9);
    c = (d3 >>> 13); d3 &= 0x1fff;
    d3 += h5 * (5 * r8);
    d3 += h6 * (5 * r7);
    d3 += h7 * (5 * r6);
    d3 += h8 * (5 * r5);
    d3 += h9 * (5 * r4);
    c += (d3 >>> 13); d3 &= 0x1fff;

    d4 = c;
    d4 += h0 * r4;
    d4 += h1 * r3;
    d4 += h2 * r2;
    d4 += h3 * r1;
    d4 += h4 * r0;
    c = (d4 >>> 13); d4 &= 0x1fff;
    d4 += h5 * (5 * r9);
    d4 += h6 * (5 * r8);
    d4 += h7 * (5 * r7);
    d4 += h8 * (5 * r6);
    d4 += h9 * (5 * r5);
    c += (d4 >>> 13); d4 &= 0x1fff;

    d5 = c;
    d5 += h0 * r5;
    d5 += h1 * r4;
    d5 += h2 * r3;
    d5 += h3 * r2;
    d5 += h4 * r1;
    c = (d5 >>> 13); d5 &= 0x1fff;
    d5 += h5 * r0;
    d5 += h6 * (5 * r9);
    d5 += h7 * (5 * r8);
    d5 += h8 * (5 * r7);
    d5 += h9 * (5 * r6);
    c += (d5 >>> 13); d5 &= 0x1fff;

    d6 = c;
    d6 += h0 * r6;
    d6 += h1 * r5;
    d6 += h2 * r4;
    d6 += h3 * r3;
    d6 += h4 * r2;
    c = (d6 >>> 13); d6 &= 0x1fff;
    d6 += h5 * r1;
    d6 += h6 * r0;
    d6 += h7 * (5 * r9);
    d6 += h8 * (5 * r8);
    d6 += h9 * (5 * r7);
    c += (d6 >>> 13); d6 &= 0x1fff;

    d7 = c;
    d7 += h0 * r7;
    d7 += h1 * r6;
    d7 += h2 * r5;
    d7 += h3 * r4;
    d7 += h4 * r3;
    c = (d7 >>> 13); d7 &= 0x1fff;
    d7 += h5 * r2;
    d7 += h6 * r1;
    d7 += h7 * r0;
    d7 += h8 * (5 * r9);
    d7 += h9 * (5 * r8);
    c += (d7 >>> 13); d7 &= 0x1fff;

    d8 = c;
    d8 += h0 * r8;
    d8 += h1 * r7;
    d8 += h2 * r6;
    d8 += h3 * r5;
    d8 += h4 * r4;
    c = (d8 >>> 13); d8 &= 0x1fff;
    d8 += h5 * r3;
    d8 += h6 * r2;
    d8 += h7 * r1;
    d8 += h8 * r0;
    d8 += h9 * (5 * r9);
    c += (d8 >>> 13); d8 &= 0x1fff;

    d9 = c;
    d9 += h0 * r9;
    d9 += h1 * r8;
    d9 += h2 * r7;
    d9 += h3 * r6;
    d9 += h4 * r5;
    c = (d9 >>> 13); d9 &= 0x1fff;
    d9 += h5 * r4;
    d9 += h6 * r3;
    d9 += h7 * r2;
    d9 += h8 * r1;
    d9 += h9 * r0;
    c += (d9 >>> 13); d9 &= 0x1fff;

    c = (((c << 2) + c)) | 0;
    c = (c + d0) | 0;
    d0 = c & 0x1fff;
    c = (c >>> 13);
    d1 += c;

    h0 = d0;
    h1 = d1;
    h2 = d2;
    h3 = d3;
    h4 = d4;
    h5 = d5;
    h6 = d6;
    h7 = d7;
    h8 = d8;
    h9 = d9;

    mpos += 16;
    bytes -= 16;
  }
  this.h[0] = h0;
  this.h[1] = h1;
  this.h[2] = h2;
  this.h[3] = h3;
  this.h[4] = h4;
  this.h[5] = h5;
  this.h[6] = h6;
  this.h[7] = h7;
  this.h[8] = h8;
  this.h[9] = h9;
};

poly1305.prototype.finish = function(mac, macpos) {
  var g = new Uint16Array(10);
  var c, mask, f, i;

  if (this.leftover) {
    i = this.leftover;
    this.buffer[i++] = 1;
    for (; i < 16; i++) this.buffer[i] = 0;
    this.fin = 1;
    this.blocks(this.buffer, 0, 16);
  }

  c = this.h[1] >>> 13;
  this.h[1] &= 0x1fff;
  for (i = 2; i < 10; i++) {
    this.h[i] += c;
    c = this.h[i] >>> 13;
    this.h[i] &= 0x1fff;
  }
  this.h[0] += (c * 5);
  c = this.h[0] >>> 13;
  this.h[0] &= 0x1fff;
  this.h[1] += c;
  c = this.h[1] >>> 13;
  this.h[1] &= 0x1fff;
  this.h[2] += c;

  g[0] = this.h[0] + 5;
  c = g[0] >>> 13;
  g[0] &= 0x1fff;
  for (i = 1; i < 10; i++) {
    g[i] = this.h[i] + c;
    c = g[i] >>> 13;
    g[i] &= 0x1fff;
  }
  g[9] -= (1 << 13);

  mask = (c ^ 1) - 1;
  for (i = 0; i < 10; i++) g[i] &= mask;
  mask = ~mask;
  for (i = 0; i < 10; i++) this.h[i] = (this.h[i] & mask) | g[i];

  this.h[0] = ((this.h[0]       ) | (this.h[1] << 13)                    ) & 0xffff;
  this.h[1] = ((this.h[1] >>>  3) | (this.h[2] << 10)                    ) & 0xffff;
  this.h[2] = ((this.h[2] >>>  6) | (this.h[3] <<  7)                    ) & 0xffff;
  this.h[3] = ((this.h[3] >>>  9) | (this.h[4] <<  4)                    ) & 0xffff;
  this.h[4] = ((this.h[4] >>> 12) | (this.h[5] <<  1) | (this.h[6] << 14)) & 0xffff;
  this.h[5] = ((this.h[6] >>>  2) | (this.h[7] << 11)                    ) & 0xffff;
  this.h[6] = ((this.h[7] >>>  5) | (this.h[8] <<  8)                    ) & 0xffff;
  this.h[7] = ((this.h[8] >>>  8) | (this.h[9] <<  5)                    ) & 0xffff;

  f = this.h[0] + this.pad[0];
  this.h[0] = f & 0xffff;
  for (i = 1; i < 8; i++) {
    f = (((this.h[i] + this.pad[i]) | 0) + (f >>> 16)) | 0;
    this.h[i] = f & 0xffff;
  }

  mac[macpos+ 0] = (this.h[0] >>> 0) & 0xff;
  mac[macpos+ 1] = (this.h[0] >>> 8) & 0xff;
  mac[macpos+ 2] = (this.h[1] >>> 0) & 0xff;
  mac[macpos+ 3] = (this.h[1] >>> 8) & 0xff;
  mac[macpos+ 4] = (this.h[2] >>> 0) & 0xff;
  mac[macpos+ 5] = (this.h[2] >>> 8) & 0xff;
  mac[macpos+ 6] = (this.h[3] >>> 0) & 0xff;
  mac[macpos+ 7] = (this.h[3] >>> 8) & 0xff;
  mac[macpos+ 8] = (this.h[4] >>> 0) & 0xff;
  mac[macpos+ 9] = (this.h[4] >>> 8) & 0xff;
  mac[macpos+10] = (this.h[5] >>> 0) & 0xff;
  mac[macpos+11] = (this.h[5] >>> 8) & 0xff;
  mac[macpos+12] = (this.h[6] >>> 0) & 0xff;
  mac[macpos+13] = (this.h[6] >>> 8) & 0xff;
  mac[macpos+14] = (this.h[7] >>> 0) & 0xff;
  mac[macpos+15] = (this.h[7] >>> 8) & 0xff;
};

poly1305.prototype.update = function(m, mpos, bytes) {
  var i, want;

  if (this.leftover) {
    want = (16 - this.leftover);
    if (want > bytes)
      want = bytes;
    for (i = 0; i < want; i++)
      this.buffer[this.leftover + i] = m[mpos+i];
    bytes -= want;
    mpos += want;
    this.leftover += want;
    if (this.leftover < 16)
      return;
    this.blocks(this.buffer, 0, 16);
    this.leftover = 0;
  }

  if (bytes >= 16) {
    want = bytes - (bytes % 16);
    this.blocks(m, mpos, want);
    mpos += want;
    bytes -= want;
  }

  if (bytes) {
    for (i = 0; i < bytes; i++)
      this.buffer[this.leftover + i] = m[mpos+i];
    this.leftover += bytes;
  }
};

function crypto_onetimeauth(out, outpos, m, mpos, n, k) {
  var s = new poly1305(k);
  s.update(m, mpos, n);
  s.finish(out, outpos);
  return 0;
}

function crypto_onetimeauth_verify(h, hpos, m, mpos, n, k) {
  var x = new Uint8Array(16);
  crypto_onetimeauth(x,0,m,mpos,n,k);
  return crypto_verify_16(h,hpos,x,0);
}

function crypto_secretbox(c,m,d,n,k) {
  var i;
  if (d < 32) return -1;
  crypto_stream_xor(c,0,m,0,d,n,k);
  crypto_onetimeauth(c, 16, c, 32, d - 32, c);
  for (i = 0; i < 16; i++) c[i] = 0;
  return 0;
}

function crypto_secretbox_open(m,c,d,n,k) {
  var i;
  var x = new Uint8Array(32);
  if (d < 32) return -1;
  crypto_stream(x,0,32,n,k);
  if (crypto_onetimeauth_verify(c, 16,c, 32,d - 32,x) !== 0) return -1;
  crypto_stream_xor(m,0,c,0,d,n,k);
  for (i = 0; i < 32; i++) m[i] = 0;
  return 0;
}

function set25519(r, a) {
  var i;
  for (i = 0; i < 16; i++) r[i] = a[i]|0;
}

function car25519(o) {
  var i, v, c = 1;
  for (i = 0; i < 16; i++) {
    v = o[i] + c + 65535;
    c = Math.floor(v / 65536);
    o[i] = v - c * 65536;
  }
  o[0] += c-1 + 37 * (c-1);
}

function sel25519(p, q, b) {
  var t, c = ~(b-1);
  for (var i = 0; i < 16; i++) {
    t = c & (p[i] ^ q[i]);
    p[i] ^= t;
    q[i] ^= t;
  }
}

function pack25519(o, n) {
  var i, j, b;
  var m = gf(), t = gf();
  for (i = 0; i < 16; i++) t[i] = n[i];
  car25519(t);
  car25519(t);
  car25519(t);
  for (j = 0; j < 2; j++) {
    m[0] = t[0] - 0xffed;
    for (i = 1; i < 15; i++) {
      m[i] = t[i] - 0xffff - ((m[i-1]>>16) & 1);
      m[i-1] &= 0xffff;
    }
    m[15] = t[15] - 0x7fff - ((m[14]>>16) & 1);
    b = (m[15]>>16) & 1;
    m[14] &= 0xffff;
    sel25519(t, m, 1-b);
  }
  for (i = 0; i < 16; i++) {
    o[2*i] = t[i] & 0xff;
    o[2*i+1] = t[i]>>8;
  }
}

function neq25519(a, b) {
  var c = new Uint8Array(32), d = new Uint8Array(32);
  pack25519(c, a);
  pack25519(d, b);
  return crypto_verify_32(c, 0, d, 0);
}

function par25519(a) {
  var d = new Uint8Array(32);
  pack25519(d, a);
  return d[0] & 1;
}

function unpack25519(o, n) {
  var i;
  for (i = 0; i < 16; i++) o[i] = n[2*i] + (n[2*i+1] << 8);
  o[15] &= 0x7fff;
}

function A(o, a, b) {
  for (var i = 0; i < 16; i++) o[i] = a[i] + b[i];
}

function Z(o, a, b) {
  for (var i = 0; i < 16; i++) o[i] = a[i] - b[i];
}

function M(o, a, b) {
  var v, c,
     t0 = 0,  t1 = 0,  t2 = 0,  t3 = 0,  t4 = 0,  t5 = 0,  t6 = 0,  t7 = 0,
     t8 = 0,  t9 = 0, t10 = 0, t11 = 0, t12 = 0, t13 = 0, t14 = 0, t15 = 0,
    t16 = 0, t17 = 0, t18 = 0, t19 = 0, t20 = 0, t21 = 0, t22 = 0, t23 = 0,
    t24 = 0, t25 = 0, t26 = 0, t27 = 0, t28 = 0, t29 = 0, t30 = 0,
    b0 = b[0],
    b1 = b[1],
    b2 = b[2],
    b3 = b[3],
    b4 = b[4],
    b5 = b[5],
    b6 = b[6],
    b7 = b[7],
    b8 = b[8],
    b9 = b[9],
    b10 = b[10],
    b11 = b[11],
    b12 = b[12],
    b13 = b[13],
    b14 = b[14],
    b15 = b[15];

  v = a[0];
  t0 += v * b0;
  t1 += v * b1;
  t2 += v * b2;
  t3 += v * b3;
  t4 += v * b4;
  t5 += v * b5;
  t6 += v * b6;
  t7 += v * b7;
  t8 += v * b8;
  t9 += v * b9;
  t10 += v * b10;
  t11 += v * b11;
  t12 += v * b12;
  t13 += v * b13;
  t14 += v * b14;
  t15 += v * b15;
  v = a[1];
  t1 += v * b0;
  t2 += v * b1;
  t3 += v * b2;
  t4 += v * b3;
  t5 += v * b4;
  t6 += v * b5;
  t7 += v * b6;
  t8 += v * b7;
  t9 += v * b8;
  t10 += v * b9;
  t11 += v * b10;
  t12 += v * b11;
  t13 += v * b12;
  t14 += v * b13;
  t15 += v * b14;
  t16 += v * b15;
  v = a[2];
  t2 += v * b0;
  t3 += v * b1;
  t4 += v * b2;
  t5 += v * b3;
  t6 += v * b4;
  t7 += v * b5;
  t8 += v * b6;
  t9 += v * b7;
  t10 += v * b8;
  t11 += v * b9;
  t12 += v * b10;
  t13 += v * b11;
  t14 += v * b12;
  t15 += v * b13;
  t16 += v * b14;
  t17 += v * b15;
  v = a[3];
  t3 += v * b0;
  t4 += v * b1;
  t5 += v * b2;
  t6 += v * b3;
  t7 += v * b4;
  t8 += v * b5;
  t9 += v * b6;
  t10 += v * b7;
  t11 += v * b8;
  t12 += v * b9;
  t13 += v * b10;
  t14 += v * b11;
  t15 += v * b12;
  t16 += v * b13;
  t17 += v * b14;
  t18 += v * b15;
  v = a[4];
  t4 += v * b0;
  t5 += v * b1;
  t6 += v * b2;
  t7 += v * b3;
  t8 += v * b4;
  t9 += v * b5;
  t10 += v * b6;
  t11 += v * b7;
  t12 += v * b8;
  t13 += v * b9;
  t14 += v * b10;
  t15 += v * b11;
  t16 += v * b12;
  t17 += v * b13;
  t18 += v * b14;
  t19 += v * b15;
  v = a[5];
  t5 += v * b0;
  t6 += v * b1;
  t7 += v * b2;
  t8 += v * b3;
  t9 += v * b4;
  t10 += v * b5;
  t11 += v * b6;
  t12 += v * b7;
  t13 += v * b8;
  t14 += v * b9;
  t15 += v * b10;
  t16 += v * b11;
  t17 += v * b12;
  t18 += v * b13;
  t19 += v * b14;
  t20 += v * b15;
  v = a[6];
  t6 += v * b0;
  t7 += v * b1;
  t8 += v * b2;
  t9 += v * b3;
  t10 += v * b4;
  t11 += v * b5;
  t12 += v * b6;
  t13 += v * b7;
  t14 += v * b8;
  t15 += v * b9;
  t16 += v * b10;
  t17 += v * b11;
  t18 += v * b12;
  t19 += v * b13;
  t20 += v * b14;
  t21 += v * b15;
  v = a[7];
  t7 += v * b0;
  t8 += v * b1;
  t9 += v * b2;
  t10 += v * b3;
  t11 += v * b4;
  t12 += v * b5;
  t13 += v * b6;
  t14 += v * b7;
  t15 += v * b8;
  t16 += v * b9;
  t17 += v * b10;
  t18 += v * b11;
  t19 += v * b12;
  t20 += v * b13;
  t21 += v * b14;
  t22 += v * b15;
  v = a[8];
  t8 += v * b0;
  t9 += v * b1;
  t10 += v * b2;
  t11 += v * b3;
  t12 += v * b4;
  t13 += v * b5;
  t14 += v * b6;
  t15 += v * b7;
  t16 += v * b8;
  t17 += v * b9;
  t18 += v * b10;
  t19 += v * b11;
  t20 += v * b12;
  t21 += v * b13;
  t22 += v * b14;
  t23 += v * b15;
  v = a[9];
  t9 += v * b0;
  t10 += v * b1;
  t11 += v * b2;
  t12 += v * b3;
  t13 += v * b4;
  t14 += v * b5;
  t15 += v * b6;
  t16 += v * b7;
  t17 += v * b8;
  t18 += v * b9;
  t19 += v * b10;
  t20 += v * b11;
  t21 += v * b12;
  t22 += v * b13;
  t23 += v * b14;
  t24 += v * b15;
  v = a[10];
  t10 += v * b0;
  t11 += v * b1;
  t12 += v * b2;
  t13 += v * b3;
  t14 += v * b4;
  t15 += v * b5;
  t16 += v * b6;
  t17 += v * b7;
  t18 += v * b8;
  t19 += v * b9;
  t20 += v * b10;
  t21 += v * b11;
  t22 += v * b12;
  t23 += v * b13;
  t24 += v * b14;
  t25 += v * b15;
  v = a[11];
  t11 += v * b0;
  t12 += v * b1;
  t13 += v * b2;
  t14 += v * b3;
  t15 += v * b4;
  t16 += v * b5;
  t17 += v * b6;
  t18 += v * b7;
  t19 += v * b8;
  t20 += v * b9;
  t21 += v * b10;
  t22 += v * b11;
  t23 += v * b12;
  t24 += v * b13;
  t25 += v * b14;
  t26 += v * b15;
  v = a[12];
  t12 += v * b0;
  t13 += v * b1;
  t14 += v * b2;
  t15 += v * b3;
  t16 += v * b4;
  t17 += v * b5;
  t18 += v * b6;
  t19 += v * b7;
  t20 += v * b8;
  t21 += v * b9;
  t22 += v * b10;
  t23 += v * b11;
  t24 += v * b12;
  t25 += v * b13;
  t26 += v * b14;
  t27 += v * b15;
  v = a[13];
  t13 += v * b0;
  t14 += v * b1;
  t15 += v * b2;
  t16 += v * b3;
  t17 += v * b4;
  t18 += v * b5;
  t19 += v * b6;
  t20 += v * b7;
  t21 += v * b8;
  t22 += v * b9;
  t23 += v * b10;
  t24 += v * b11;
  t25 += v * b12;
  t26 += v * b13;
  t27 += v * b14;
  t28 += v * b15;
  v = a[14];
  t14 += v * b0;
  t15 += v * b1;
  t16 += v * b2;
  t17 += v * b3;
  t18 += v * b4;
  t19 += v * b5;
  t20 += v * b6;
  t21 += v * b7;
  t22 += v * b8;
  t23 += v * b9;
  t24 += v * b10;
  t25 += v * b11;
  t26 += v * b12;
  t27 += v * b13;
  t28 += v * b14;
  t29 += v * b15;
  v = a[15];
  t15 += v * b0;
  t16 += v * b1;
  t17 += v * b2;
  t18 += v * b3;
  t19 += v * b4;
  t20 += v * b5;
  t21 += v * b6;
  t22 += v * b7;
  t23 += v * b8;
  t24 += v * b9;
  t25 += v * b10;
  t26 += v * b11;
  t27 += v * b12;
  t28 += v * b13;
  t29 += v * b14;
  t30 += v * b15;

  t0  += 38 * t16;
  t1  += 38 * t17;
  t2  += 38 * t18;
  t3  += 38 * t19;
  t4  += 38 * t20;
  t5  += 38 * t21;
  t6  += 38 * t22;
  t7  += 38 * t23;
  t8  += 38 * t24;
  t9  += 38 * t25;
  t10 += 38 * t26;
  t11 += 38 * t27;
  t12 += 38 * t28;
  t13 += 38 * t29;
  t14 += 38 * t30;
  // t15 left as is

  // first car
  c = 1;
  v =  t0 + c + 65535; c = Math.floor(v / 65536);  t0 = v - c * 65536;
  v =  t1 + c + 65535; c = Math.floor(v / 65536);  t1 = v - c * 65536;
  v =  t2 + c + 65535; c = Math.floor(v / 65536);  t2 = v - c * 65536;
  v =  t3 + c + 65535; c = Math.floor(v / 65536);  t3 = v - c * 65536;
  v =  t4 + c + 65535; c = Math.floor(v / 65536);  t4 = v - c * 65536;
  v =  t5 + c + 65535; c = Math.floor(v / 65536);  t5 = v - c * 65536;
  v =  t6 + c + 65535; c = Math.floor(v / 65536);  t6 = v - c * 65536;
  v =  t7 + c + 65535; c = Math.floor(v / 65536);  t7 = v - c * 65536;
  v =  t8 + c + 65535; c = Math.floor(v / 65536);  t8 = v - c * 65536;
  v =  t9 + c + 65535; c = Math.floor(v / 65536);  t9 = v - c * 65536;
  v = t10 + c + 65535; c = Math.floor(v / 65536); t10 = v - c * 65536;
  v = t11 + c + 65535; c = Math.floor(v / 65536); t11 = v - c * 65536;
  v = t12 + c + 65535; c = Math.floor(v / 65536); t12 = v - c * 65536;
  v = t13 + c + 65535; c = Math.floor(v / 65536); t13 = v - c * 65536;
  v = t14 + c + 65535; c = Math.floor(v / 65536); t14 = v - c * 65536;
  v = t15 + c + 65535; c = Math.floor(v / 65536); t15 = v - c * 65536;
  t0 += c-1 + 37 * (c-1);

  // second car
  c = 1;
  v =  t0 + c + 65535; c = Math.floor(v / 65536);  t0 = v - c * 65536;
  v =  t1 + c + 65535; c = Math.floor(v / 65536);  t1 = v - c * 65536;
  v =  t2 + c + 65535; c = Math.floor(v / 65536);  t2 = v - c * 65536;
  v =  t3 + c + 65535; c = Math.floor(v / 65536);  t3 = v - c * 65536;
  v =  t4 + c + 65535; c = Math.floor(v / 65536);  t4 = v - c * 65536;
  v =  t5 + c + 65535; c = Math.floor(v / 65536);  t5 = v - c * 65536;
  v =  t6 + c + 65535; c = Math.floor(v / 65536);  t6 = v - c * 65536;
  v =  t7 + c + 65535; c = Math.floor(v / 65536);  t7 = v - c * 65536;
  v =  t8 + c + 65535; c = Math.floor(v / 65536);  t8 = v - c * 65536;
  v =  t9 + c + 65535; c = Math.floor(v / 65536);  t9 = v - c * 65536;
  v = t10 + c + 65535; c = Math.floor(v / 65536); t10 = v - c * 65536;
  v = t11 + c + 65535; c = Math.floor(v / 65536); t11 = v - c * 65536;
  v = t12 + c + 65535; c = Math.floor(v / 65536); t12 = v - c * 65536;
  v = t13 + c + 65535; c = Math.floor(v / 65536); t13 = v - c * 65536;
  v = t14 + c + 65535; c = Math.floor(v / 65536); t14 = v - c * 65536;
  v = t15 + c + 65535; c = Math.floor(v / 65536); t15 = v - c * 65536;
  t0 += c-1 + 37 * (c-1);

  o[ 0] = t0;
  o[ 1] = t1;
  o[ 2] = t2;
  o[ 3] = t3;
  o[ 4] = t4;
  o[ 5] = t5;
  o[ 6] = t6;
  o[ 7] = t7;
  o[ 8] = t8;
  o[ 9] = t9;
  o[10] = t10;
  o[11] = t11;
  o[12] = t12;
  o[13] = t13;
  o[14] = t14;
  o[15] = t15;
}

function S(o, a) {
  M(o, a, a);
}

function inv25519(o, i) {
  var c = gf();
  var a;
  for (a = 0; a < 16; a++) c[a] = i[a];
  for (a = 253; a >= 0; a--) {
    S(c, c);
    if(a !== 2 && a !== 4) M(c, c, i);
  }
  for (a = 0; a < 16; a++) o[a] = c[a];
}

function pow2523(o, i) {
  var c = gf();
  var a;
  for (a = 0; a < 16; a++) c[a] = i[a];
  for (a = 250; a >= 0; a--) {
      S(c, c);
      if(a !== 1) M(c, c, i);
  }
  for (a = 0; a < 16; a++) o[a] = c[a];
}

function crypto_scalarmult(q, n, p) {
  var z = new Uint8Array(32);
  var x = new Float64Array(80), r, i;
  var a = gf(), b = gf(), c = gf(),
      d = gf(), e = gf(), f = gf();
  for (i = 0; i < 31; i++) z[i] = n[i];
  z[31]=(n[31]&127)|64;
  z[0]&=248;
  unpack25519(x,p);
  for (i = 0; i < 16; i++) {
    b[i]=x[i];
    d[i]=a[i]=c[i]=0;
  }
  a[0]=d[0]=1;
  for (i=254; i>=0; --i) {
    r=(z[i>>>3]>>>(i&7))&1;
    sel25519(a,b,r);
    sel25519(c,d,r);
    A(e,a,c);
    Z(a,a,c);
    A(c,b,d);
    Z(b,b,d);
    S(d,e);
    S(f,a);
    M(a,c,a);
    M(c,b,e);
    A(e,a,c);
    Z(a,a,c);
    S(b,a);
    Z(c,d,f);
    M(a,c,_121665);
    A(a,a,d);
    M(c,c,a);
    M(a,d,f);
    M(d,b,x);
    S(b,e);
    sel25519(a,b,r);
    sel25519(c,d,r);
  }
  for (i = 0; i < 16; i++) {
    x[i+16]=a[i];
    x[i+32]=c[i];
    x[i+48]=b[i];
    x[i+64]=d[i];
  }
  var x32 = x.subarray(32);
  var x16 = x.subarray(16);
  inv25519(x32,x32);
  M(x16,x16,x32);
  pack25519(q,x16);
  return 0;
}

function crypto_scalarmult_base(q, n) {
  return crypto_scalarmult(q, n, _9);
}

function crypto_box_keypair(y, x) {
  randombytes(x, 32);
  return crypto_scalarmult_base(y, x);
}

function crypto_box_beforenm(k, y, x) {
  var s = new Uint8Array(32);
  crypto_scalarmult(s, x, y);
  return crypto_core_hsalsa20(k, _0, s, sigma);
}

var crypto_box_afternm = crypto_secretbox;
var crypto_box_open_afternm = crypto_secretbox_open;

function crypto_box(c, m, d, n, y, x) {
  var k = new Uint8Array(32);
  crypto_box_beforenm(k, y, x);
  return crypto_box_afternm(c, m, d, n, k);
}

function crypto_box_open(m, c, d, n, y, x) {
  var k = new Uint8Array(32);
  crypto_box_beforenm(k, y, x);
  return crypto_box_open_afternm(m, c, d, n, k);
}

var K = [
  0x428a2f98, 0xd728ae22, 0x71374491, 0x23ef65cd,
  0xb5c0fbcf, 0xec4d3b2f, 0xe9b5dba5, 0x8189dbbc,
  0x3956c25b, 0xf348b538, 0x59f111f1, 0xb605d019,
  0x923f82a4, 0xaf194f9b, 0xab1c5ed5, 0xda6d8118,
  0xd807aa98, 0xa3030242, 0x12835b01, 0x45706fbe,
  0x243185be, 0x4ee4b28c, 0x550c7dc3, 0xd5ffb4e2,
  0x72be5d74, 0xf27b896f, 0x80deb1fe, 0x3b1696b1,
  0x9bdc06a7, 0x25c71235, 0xc19bf174, 0xcf692694,
  0xe49b69c1, 0x9ef14ad2, 0xefbe4786, 0x384f25e3,
  0x0fc19dc6, 0x8b8cd5b5, 0x240ca1cc, 0x77ac9c65,
  0x2de92c6f, 0x592b0275, 0x4a7484aa, 0x6ea6e483,
  0x5cb0a9dc, 0xbd41fbd4, 0x76f988da, 0x831153b5,
  0x983e5152, 0xee66dfab, 0xa831c66d, 0x2db43210,
  0xb00327c8, 0x98fb213f, 0xbf597fc7, 0xbeef0ee4,
  0xc6e00bf3, 0x3da88fc2, 0xd5a79147, 0x930aa725,
  0x06ca6351, 0xe003826f, 0x14292967, 0x0a0e6e70,
  0x27b70a85, 0x46d22ffc, 0x2e1b2138, 0x5c26c926,
  0x4d2c6dfc, 0x5ac42aed, 0x53380d13, 0x9d95b3df,
  0x650a7354, 0x8baf63de, 0x766a0abb, 0x3c77b2a8,
  0x81c2c92e, 0x47edaee6, 0x92722c85, 0x1482353b,
  0xa2bfe8a1, 0x4cf10364, 0xa81a664b, 0xbc423001,
  0xc24b8b70, 0xd0f89791, 0xc76c51a3, 0x0654be30,
  0xd192e819, 0xd6ef5218, 0xd6990624, 0x5565a910,
  0xf40e3585, 0x5771202a, 0x106aa070, 0x32bbd1b8,
  0x19a4c116, 0xb8d2d0c8, 0x1e376c08, 0x5141ab53,
  0x2748774c, 0xdf8eeb99, 0x34b0bcb5, 0xe19b48a8,
  0x391c0cb3, 0xc5c95a63, 0x4ed8aa4a, 0xe3418acb,
  0x5b9cca4f, 0x7763e373, 0x682e6ff3, 0xd6b2b8a3,
  0x748f82ee, 0x5defb2fc, 0x78a5636f, 0x43172f60,
  0x84c87814, 0xa1f0ab72, 0x8cc70208, 0x1a6439ec,
  0x90befffa, 0x23631e28, 0xa4506ceb, 0xde82bde9,
  0xbef9a3f7, 0xb2c67915, 0xc67178f2, 0xe372532b,
  0xca273ece, 0xea26619c, 0xd186b8c7, 0x21c0c207,
  0xeada7dd6, 0xcde0eb1e, 0xf57d4f7f, 0xee6ed178,
  0x06f067aa, 0x72176fba, 0x0a637dc5, 0xa2c898a6,
  0x113f9804, 0xbef90dae, 0x1b710b35, 0x131c471b,
  0x28db77f5, 0x23047d84, 0x32caab7b, 0x40c72493,
  0x3c9ebe0a, 0x15c9bebc, 0x431d67c4, 0x9c100d4c,
  0x4cc5d4be, 0xcb3e42b6, 0x597f299c, 0xfc657e2a,
  0x5fcb6fab, 0x3ad6faec, 0x6c44198c, 0x4a475817
];

function crypto_hashblocks_hl(hh, hl, m, n) {
  var wh = new Int32Array(16), wl = new Int32Array(16),
      bh0, bh1, bh2, bh3, bh4, bh5, bh6, bh7,
      bl0, bl1, bl2, bl3, bl4, bl5, bl6, bl7,
      th, tl, i, j, h, l, a, b, c, d;

  var ah0 = hh[0],
      ah1 = hh[1],
      ah2 = hh[2],
      ah3 = hh[3],
      ah4 = hh[4],
      ah5 = hh[5],
      ah6 = hh[6],
      ah7 = hh[7],

      al0 = hl[0],
      al1 = hl[1],
      al2 = hl[2],
      al3 = hl[3],
      al4 = hl[4],
      al5 = hl[5],
      al6 = hl[6],
      al7 = hl[7];

  var pos = 0;
  while (n >= 128) {
    for (i = 0; i < 16; i++) {
      j = 8 * i + pos;
      wh[i] = (m[j+0] << 24) | (m[j+1] << 16) | (m[j+2] << 8) | m[j+3];
      wl[i] = (m[j+4] << 24) | (m[j+5] << 16) | (m[j+6] << 8) | m[j+7];
    }
    for (i = 0; i < 80; i++) {
      bh0 = ah0;
      bh1 = ah1;
      bh2 = ah2;
      bh3 = ah3;
      bh4 = ah4;
      bh5 = ah5;
      bh6 = ah6;
      bh7 = ah7;

      bl0 = al0;
      bl1 = al1;
      bl2 = al2;
      bl3 = al3;
      bl4 = al4;
      bl5 = al5;
      bl6 = al6;
      bl7 = al7;

      // add
      h = ah7;
      l = al7;

      a = l & 0xffff; b = l >>> 16;
      c = h & 0xffff; d = h >>> 16;

      // Sigma1
      h = ((ah4 >>> 14) | (al4 << (32-14))) ^ ((ah4 >>> 18) | (al4 << (32-18))) ^ ((al4 >>> (41-32)) | (ah4 << (32-(41-32))));
      l = ((al4 >>> 14) | (ah4 << (32-14))) ^ ((al4 >>> 18) | (ah4 << (32-18))) ^ ((ah4 >>> (41-32)) | (al4 << (32-(41-32))));

      a += l & 0xffff; b += l >>> 16;
      c += h & 0xffff; d += h >>> 16;

      // Ch
      h = (ah4 & ah5) ^ (~ah4 & ah6);
      l = (al4 & al5) ^ (~al4 & al6);

      a += l & 0xffff; b += l >>> 16;
      c += h & 0xffff; d += h >>> 16;

      // K
      h = K[i*2];
      l = K[i*2+1];

      a += l & 0xffff; b += l >>> 16;
      c += h & 0xffff; d += h >>> 16;

      // w
      h = wh[i%16];
      l = wl[i%16];

      a += l & 0xffff; b += l >>> 16;
      c += h & 0xffff; d += h >>> 16;

      b += a >>> 16;
      c += b >>> 16;
      d += c >>> 16;

      th = c & 0xffff | d << 16;
      tl = a & 0xffff | b << 16;

      // add
      h = th;
      l = tl;

      a = l & 0xffff; b = l >>> 16;
      c = h & 0xffff; d = h >>> 16;

      // Sigma0
      h = ((ah0 >>> 28) | (al0 << (32-28))) ^ ((al0 >>> (34-32)) | (ah0 << (32-(34-32)))) ^ ((al0 >>> (39-32)) | (ah0 << (32-(39-32))));
      l = ((al0 >>> 28) | (ah0 << (32-28))) ^ ((ah0 >>> (34-32)) | (al0 << (32-(34-32)))) ^ ((ah0 >>> (39-32)) | (al0 << (32-(39-32))));

      a += l & 0xffff; b += l >>> 16;
      c += h & 0xffff; d += h >>> 16;

      // Maj
      h = (ah0 & ah1) ^ (ah0 & ah2) ^ (ah1 & ah2);
      l = (al0 & al1) ^ (al0 & al2) ^ (al1 & al2);

      a += l & 0xffff; b += l >>> 16;
      c += h & 0xffff; d += h >>> 16;

      b += a >>> 16;
      c += b >>> 16;
      d += c >>> 16;

      bh7 = (c & 0xffff) | (d << 16);
      bl7 = (a & 0xffff) | (b << 16);

      // add
      h = bh3;
      l = bl3;

      a = l & 0xffff; b = l >>> 16;
      c = h & 0xffff; d = h >>> 16;

      h = th;
      l = tl;

      a += l & 0xffff; b += l >>> 16;
      c += h & 0xffff; d += h >>> 16;

      b += a >>> 16;
      c += b >>> 16;
      d += c >>> 16;

      bh3 = (c & 0xffff) | (d << 16);
      bl3 = (a & 0xffff) | (b << 16);

      ah1 = bh0;
      ah2 = bh1;
      ah3 = bh2;
      ah4 = bh3;
      ah5 = bh4;
      ah6 = bh5;
      ah7 = bh6;
      ah0 = bh7;

      al1 = bl0;
      al2 = bl1;
      al3 = bl2;
      al4 = bl3;
      al5 = bl4;
      al6 = bl5;
      al7 = bl6;
      al0 = bl7;

      if (i%16 === 15) {
        for (j = 0; j < 16; j++) {
          // add
          h = wh[j];
          l = wl[j];

          a = l & 0xffff; b = l >>> 16;
          c = h & 0xffff; d = h >>> 16;

          h = wh[(j+9)%16];
          l = wl[(j+9)%16];

          a += l & 0xffff; b += l >>> 16;
          c += h & 0xffff; d += h >>> 16;

          // sigma0
          th = wh[(j+1)%16];
          tl = wl[(j+1)%16];
          h = ((th >>> 1) | (tl << (32-1))) ^ ((th >>> 8) | (tl << (32-8))) ^ (th >>> 7);
          l = ((tl >>> 1) | (th << (32-1))) ^ ((tl >>> 8) | (th << (32-8))) ^ ((tl >>> 7) | (th << (32-7)));

          a += l & 0xffff; b += l >>> 16;
          c += h & 0xffff; d += h >>> 16;

          // sigma1
          th = wh[(j+14)%16];
          tl = wl[(j+14)%16];
          h = ((th >>> 19) | (tl << (32-19))) ^ ((tl >>> (61-32)) | (th << (32-(61-32)))) ^ (th >>> 6);
          l = ((tl >>> 19) | (th << (32-19))) ^ ((th >>> (61-32)) | (tl << (32-(61-32)))) ^ ((tl >>> 6) | (th << (32-6)));

          a += l & 0xffff; b += l >>> 16;
          c += h & 0xffff; d += h >>> 16;

          b += a >>> 16;
          c += b >>> 16;
          d += c >>> 16;

          wh[j] = (c & 0xffff) | (d << 16);
          wl[j] = (a & 0xffff) | (b << 16);
        }
      }
    }

    // add
    h = ah0;
    l = al0;

    a = l & 0xffff; b = l >>> 16;
    c = h & 0xffff; d = h >>> 16;

    h = hh[0];
    l = hl[0];

    a += l & 0xffff; b += l >>> 16;
    c += h & 0xffff; d += h >>> 16;

    b += a >>> 16;
    c += b >>> 16;
    d += c >>> 16;

    hh[0] = ah0 = (c & 0xffff) | (d << 16);
    hl[0] = al0 = (a & 0xffff) | (b << 16);

    h = ah1;
    l = al1;

    a = l & 0xffff; b = l >>> 16;
    c = h & 0xffff; d = h >>> 16;

    h = hh[1];
    l = hl[1];

    a += l & 0xffff; b += l >>> 16;
    c += h & 0xffff; d += h >>> 16;

    b += a >>> 16;
    c += b >>> 16;
    d += c >>> 16;

    hh[1] = ah1 = (c & 0xffff) | (d << 16);
    hl[1] = al1 = (a & 0xffff) | (b << 16);

    h = ah2;
    l = al2;

    a = l & 0xffff; b = l >>> 16;
    c = h & 0xffff; d = h >>> 16;

    h = hh[2];
    l = hl[2];

    a += l & 0xffff; b += l >>> 16;
    c += h & 0xffff; d += h >>> 16;

    b += a >>> 16;
    c += b >>> 16;
    d += c >>> 16;

    hh[2] = ah2 = (c & 0xffff) | (d << 16);
    hl[2] = al2 = (a & 0xffff) | (b << 16);

    h = ah3;
    l = al3;

    a = l & 0xffff; b = l >>> 16;
    c = h & 0xffff; d = h >>> 16;

    h = hh[3];
    l = hl[3];

    a += l & 0xffff; b += l >>> 16;
    c += h & 0xffff; d += h >>> 16;

    b += a >>> 16;
    c += b >>> 16;
    d += c >>> 16;

    hh[3] = ah3 = (c & 0xffff) | (d << 16);
    hl[3] = al3 = (a & 0xffff) | (b << 16);

    h = ah4;
    l = al4;

    a = l & 0xffff; b = l >>> 16;
    c = h & 0xffff; d = h >>> 16;

    h = hh[4];
    l = hl[4];

    a += l & 0xffff; b += l >>> 16;
    c += h & 0xffff; d += h >>> 16;

    b += a >>> 16;
    c += b >>> 16;
    d += c >>> 16;

    hh[4] = ah4 = (c & 0xffff) | (d << 16);
    hl[4] = al4 = (a & 0xffff) | (b << 16);

    h = ah5;
    l = al5;

    a = l & 0xffff; b = l >>> 16;
    c = h & 0xffff; d = h >>> 16;

    h = hh[5];
    l = hl[5];

    a += l & 0xffff; b += l >>> 16;
    c += h & 0xffff; d += h >>> 16;

    b += a >>> 16;
    c += b >>> 16;
    d += c >>> 16;

    hh[5] = ah5 = (c & 0xffff) | (d << 16);
    hl[5] = al5 = (a & 0xffff) | (b << 16);

    h = ah6;
    l = al6;

    a = l & 0xffff; b = l >>> 16;
    c = h & 0xffff; d = h >>> 16;

    h = hh[6];
    l = hl[6];

    a += l & 0xffff; b += l >>> 16;
    c += h & 0xffff; d += h >>> 16;

    b += a >>> 16;
    c += b >>> 16;
    d += c >>> 16;

    hh[6] = ah6 = (c & 0xffff) | (d << 16);
    hl[6] = al6 = (a & 0xffff) | (b << 16);

    h = ah7;
    l = al7;

    a = l & 0xffff; b = l >>> 16;
    c = h & 0xffff; d = h >>> 16;

    h = hh[7];
    l = hl[7];

    a += l & 0xffff; b += l >>> 16;
    c += h & 0xffff; d += h >>> 16;

    b += a >>> 16;
    c += b >>> 16;
    d += c >>> 16;

    hh[7] = ah7 = (c & 0xffff) | (d << 16);
    hl[7] = al7 = (a & 0xffff) | (b << 16);

    pos += 128;
    n -= 128;
  }

  return n;
}

function crypto_hash(out, m, n) {
  var hh = new Int32Array(8),
      hl = new Int32Array(8),
      x = new Uint8Array(256),
      i, b = n;

  hh[0] = 0x6a09e667;
  hh[1] = 0xbb67ae85;
  hh[2] = 0x3c6ef372;
  hh[3] = 0xa54ff53a;
  hh[4] = 0x510e527f;
  hh[5] = 0x9b05688c;
  hh[6] = 0x1f83d9ab;
  hh[7] = 0x5be0cd19;

  hl[0] = 0xf3bcc908;
  hl[1] = 0x84caa73b;
  hl[2] = 0xfe94f82b;
  hl[3] = 0x5f1d36f1;
  hl[4] = 0xade682d1;
  hl[5] = 0x2b3e6c1f;
  hl[6] = 0xfb41bd6b;
  hl[7] = 0x137e2179;

  crypto_hashblocks_hl(hh, hl, m, n);
  n %= 128;

  for (i = 0; i < n; i++) x[i] = m[b-n+i];
  x[n] = 128;

  n = 256-128*(n<112?1:0);
  x[n-9] = 0;
  ts64(x, n-8,  (b / 0x20000000) | 0, b << 3);
  crypto_hashblocks_hl(hh, hl, x, n);

  for (i = 0; i < 8; i++) ts64(out, 8*i, hh[i], hl[i]);

  return 0;
}

function add(p, q) {
  var a = gf(), b = gf(), c = gf(),
      d = gf(), e = gf(), f = gf(),
      g = gf(), h = gf(), t = gf();

  Z(a, p[1], p[0]);
  Z(t, q[1], q[0]);
  M(a, a, t);
  A(b, p[0], p[1]);
  A(t, q[0], q[1]);
  M(b, b, t);
  M(c, p[3], q[3]);
  M(c, c, D2);
  M(d, p[2], q[2]);
  A(d, d, d);
  Z(e, b, a);
  Z(f, d, c);
  A(g, d, c);
  A(h, b, a);

  M(p[0], e, f);
  M(p[1], h, g);
  M(p[2], g, f);
  M(p[3], e, h);
}

function cswap(p, q, b) {
  var i;
  for (i = 0; i < 4; i++) {
    sel25519(p[i], q[i], b);
  }
}

function pack(r, p) {
  var tx = gf(), ty = gf(), zi = gf();
  inv25519(zi, p[2]);
  M(tx, p[0], zi);
  M(ty, p[1], zi);
  pack25519(r, ty);
  r[31] ^= par25519(tx) << 7;
}

function scalarmult(p, q, s) {
  var b, i;
  set25519(p[0], gf0);
  set25519(p[1], gf1);
  set25519(p[2], gf1);
  set25519(p[3], gf0);
  for (i = 255; i >= 0; --i) {
    b = (s[(i/8)|0] >> (i&7)) & 1;
    cswap(p, q, b);
    add(q, p);
    add(p, p);
    cswap(p, q, b);
  }
}

function scalarbase(p, s) {
  var q = [gf(), gf(), gf(), gf()];
  set25519(q[0], X);
  set25519(q[1], Y);
  set25519(q[2], gf1);
  M(q[3], X, Y);
  scalarmult(p, q, s);
}

function crypto_sign_keypair(pk, sk, seeded) {
  var d = new Uint8Array(64);
  var p = [gf(), gf(), gf(), gf()];
  var i;

  if (!seeded) randombytes(sk, 32);
  crypto_hash(d, sk, 32);
  d[0] &= 248;
  d[31] &= 127;
  d[31] |= 64;

  scalarbase(p, d);
  pack(pk, p);

  for (i = 0; i < 32; i++) sk[i+32] = pk[i];
  return 0;
}

var L = new Float64Array([0xed, 0xd3, 0xf5, 0x5c, 0x1a, 0x63, 0x12, 0x58, 0xd6, 0x9c, 0xf7, 0xa2, 0xde, 0xf9, 0xde, 0x14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x10]);

function modL(r, x) {
  var carry, i, j, k;
  for (i = 63; i >= 32; --i) {
    carry = 0;
    for (j = i - 32, k = i - 12; j < k; ++j) {
      x[j] += carry - 16 * x[i] * L[j - (i - 32)];
      carry = Math.floor((x[j] + 128) / 256);
      x[j] -= carry * 256;
    }
    x[j] += carry;
    x[i] = 0;
  }
  carry = 0;
  for (j = 0; j < 32; j++) {
    x[j] += carry - (x[31] >> 4) * L[j];
    carry = x[j] >> 8;
    x[j] &= 255;
  }
  for (j = 0; j < 32; j++) x[j] -= carry * L[j];
  for (i = 0; i < 32; i++) {
    x[i+1] += x[i] >> 8;
    r[i] = x[i] & 255;
  }
}

function reduce(r) {
  var x = new Float64Array(64), i;
  for (i = 0; i < 64; i++) x[i] = r[i];
  for (i = 0; i < 64; i++) r[i] = 0;
  modL(r, x);
}

// Note: difference from C - smlen returned, not passed as argument.
function crypto_sign(sm, m, n, sk) {
  var d = new Uint8Array(64), h = new Uint8Array(64), r = new Uint8Array(64);
  var i, j, x = new Float64Array(64);
  var p = [gf(), gf(), gf(), gf()];

  crypto_hash(d, sk, 32);
  d[0] &= 248;
  d[31] &= 127;
  d[31] |= 64;

  var smlen = n + 64;
  for (i = 0; i < n; i++) sm[64 + i] = m[i];
  for (i = 0; i < 32; i++) sm[32 + i] = d[32 + i];

  crypto_hash(r, sm.subarray(32), n+32);
  reduce(r);
  scalarbase(p, r);
  pack(sm, p);

  for (i = 32; i < 64; i++) sm[i] = sk[i];
  crypto_hash(h, sm, n + 64);
  reduce(h);

  for (i = 0; i < 64; i++) x[i] = 0;
  for (i = 0; i < 32; i++) x[i] = r[i];
  for (i = 0; i < 32; i++) {
    for (j = 0; j < 32; j++) {
      x[i+j] += h[i] * d[j];
    }
  }

  modL(sm.subarray(32), x);
  return smlen;
}

function unpackneg(r, p) {
  var t = gf(), chk = gf(), num = gf(),
      den = gf(), den2 = gf(), den4 = gf(),
      den6 = gf();

  set25519(r[2], gf1);
  unpack25519(r[1], p);
  S(num, r[1]);
  M(den, num, D);
  Z(num, num, r[2]);
  A(den, r[2], den);

  S(den2, den);
  S(den4, den2);
  M(den6, den4, den2);
  M(t, den6, num);
  M(t, t, den);

  pow2523(t, t);
  M(t, t, num);
  M(t, t, den);
  M(t, t, den);
  M(r[0], t, den);

  S(chk, r[0]);
  M(chk, chk, den);
  if (neq25519(chk, num)) M(r[0], r[0], I);

  S(chk, r[0]);
  M(chk, chk, den);
  if (neq25519(chk, num)) return -1;

  if (par25519(r[0]) === (p[31]>>7)) Z(r[0], gf0, r[0]);

  M(r[3], r[0], r[1]);
  return 0;
}

function crypto_sign_open(m, sm, n, pk) {
  var i;
  var t = new Uint8Array(32), h = new Uint8Array(64);
  var p = [gf(), gf(), gf(), gf()],
      q = [gf(), gf(), gf(), gf()];

  if (n < 64) return -1;

  if (unpackneg(q, pk)) return -1;

  for (i = 0; i < n; i++) m[i] = sm[i];
  for (i = 0; i < 32; i++) m[i+32] = pk[i];
  crypto_hash(h, m, n);
  reduce(h);
  scalarmult(p, q, h);

  scalarbase(q, sm.subarray(32));
  add(p, q);
  pack(t, p);

  n -= 64;
  if (crypto_verify_32(sm, 0, t, 0)) {
    for (i = 0; i < n; i++) m[i] = 0;
    return -1;
  }

  for (i = 0; i < n; i++) m[i] = sm[i + 64];
  return n;
}

var crypto_secretbox_KEYBYTES = 32,
    crypto_secretbox_NONCEBYTES = 24,
    crypto_secretbox_ZEROBYTES = 32,
    crypto_secretbox_BOXZEROBYTES = 16,
    crypto_scalarmult_BYTES = 32,
    crypto_scalarmult_SCALARBYTES = 32,
    crypto_box_PUBLICKEYBYTES = 32,
    crypto_box_SECRETKEYBYTES = 32,
    crypto_box_BEFORENMBYTES = 32,
    crypto_box_NONCEBYTES = crypto_secretbox_NONCEBYTES,
    crypto_box_ZEROBYTES = crypto_secretbox_ZEROBYTES,
    crypto_box_BOXZEROBYTES = crypto_secretbox_BOXZEROBYTES,
    crypto_sign_BYTES = 64,
    crypto_sign_PUBLICKEYBYTES = 32,
    crypto_sign_SECRETKEYBYTES = 64,
    crypto_sign_SEEDBYTES = 32,
    crypto_hash_BYTES = 64;

nacl.lowlevel = {
  crypto_core_hsalsa20: crypto_core_hsalsa20,
  crypto_stream_xor: crypto_stream_xor,
  crypto_stream: crypto_stream,
  crypto_stream_salsa20_xor: crypto_stream_salsa20_xor,
  crypto_stream_salsa20: crypto_stream_salsa20,
  crypto_onetimeauth: crypto_onetimeauth,
  crypto_onetimeauth_verify: crypto_onetimeauth_verify,
  crypto_verify_16: crypto_verify_16,
  crypto_verify_32: crypto_verify_32,
  crypto_secretbox: crypto_secretbox,
  crypto_secretbox_open: crypto_secretbox_open,
  crypto_scalarmult: crypto_scalarmult,
  crypto_scalarmult_base: crypto_scalarmult_base,
  crypto_box_beforenm: crypto_box_beforenm,
  crypto_box_afternm: crypto_box_afternm,
  crypto_box: crypto_box,
  crypto_box_open: crypto_box_open,
  crypto_box_keypair: crypto_box_keypair,
  crypto_hash: crypto_hash,
  crypto_sign: crypto_sign,
  crypto_sign_keypair: crypto_sign_keypair,
  crypto_sign_open: crypto_sign_open,

  crypto_secretbox_KEYBYTES: crypto_secretbox_KEYBYTES,
  crypto_secretbox_NONCEBYTES: crypto_secretbox_NONCEBYTES,
  crypto_secretbox_ZEROBYTES: crypto_secretbox_ZEROBYTES,
  crypto_secretbox_BOXZEROBYTES: crypto_secretbox_BOXZEROBYTES,
  crypto_scalarmult_BYTES: crypto_scalarmult_BYTES,
  crypto_scalarmult_SCALARBYTES: crypto_scalarmult_SCALARBYTES,
  crypto_box_PUBLICKEYBYTES: crypto_box_PUBLICKEYBYTES,
  crypto_box_SECRETKEYBYTES: crypto_box_SECRETKEYBYTES,
  crypto_box_BEFORENMBYTES: crypto_box_BEFORENMBYTES,
  crypto_box_NONCEBYTES: crypto_box_NONCEBYTES,
  crypto_box_ZEROBYTES: crypto_box_ZEROBYTES,
  crypto_box_BOXZEROBYTES: crypto_box_BOXZEROBYTES,
  crypto_sign_BYTES: crypto_sign_BYTES,
  crypto_sign_PUBLICKEYBYTES: crypto_sign_PUBLICKEYBYTES,
  crypto_sign_SECRETKEYBYTES: crypto_sign_SECRETKEYBYTES,
  crypto_sign_SEEDBYTES: crypto_sign_SEEDBYTES,
  crypto_hash_BYTES: crypto_hash_BYTES,

  gf: gf,
  D: D,
  L: L,
  pack25519: pack25519,
  unpack25519: unpack25519,
  M: M,
  A: A,
  S: S,
  Z: Z,
  pow2523: pow2523,
  add: add,
  set25519: set25519,
  modL: modL,
  scalarmult: scalarmult,
  scalarbase: scalarbase,
};

/* High-level API */

function checkLengths(k, n) {
  if (k.length !== crypto_secretbox_KEYBYTES) throw new Error('bad key size');
  if (n.length !== crypto_secretbox_NONCEBYTES) throw new Error('bad nonce size');
}

function checkBoxLengths(pk, sk) {
  if (pk.length !== crypto_box_PUBLICKEYBYTES) throw new Error('bad public key size');
  if (sk.length !== crypto_box_SECRETKEYBYTES) throw new Error('bad secret key size');
}

function checkArrayTypes() {
  for (var i = 0; i < arguments.length; i++) {
    if (!(arguments[i] instanceof Uint8Array))
      throw new TypeError('unexpected type, use Uint8Array');
  }
}

function cleanup(arr) {
  for (var i = 0; i < arr.length; i++) arr[i] = 0;
}

nacl.randomBytes = function(n) {
  var b = new Uint8Array(n);
  randombytes(b, n);
  return b;
};

nacl.secretbox = function(msg, nonce, key) {
  checkArrayTypes(msg, nonce, key);
  checkLengths(key, nonce);
  var m = new Uint8Array(crypto_secretbox_ZEROBYTES + msg.length);
  var c = new Uint8Array(m.length);
  for (var i = 0; i < msg.length; i++) m[i+crypto_secretbox_ZEROBYTES] = msg[i];
  crypto_secretbox(c, m, m.length, nonce, key);
  return c.subarray(crypto_secretbox_BOXZEROBYTES);
};

nacl.secretbox.open = function(box, nonce, key) {
  checkArrayTypes(box, nonce, key);
  checkLengths(key, nonce);
  var c = new Uint8Array(crypto_secretbox_BOXZEROBYTES + box.length);
  var m = new Uint8Array(c.length);
  for (var i = 0; i < box.length; i++) c[i+crypto_secretbox_BOXZEROBYTES] = box[i];
  if (c.length < 32) return null;
  if (crypto_secretbox_open(m, c, c.length, nonce, key) !== 0) return null;
  return m.subarray(crypto_secretbox_ZEROBYTES);
};

nacl.secretbox.keyLength = crypto_secretbox_KEYBYTES;
nacl.secretbox.nonceLength = crypto_secretbox_NONCEBYTES;
nacl.secretbox.overheadLength = crypto_secretbox_BOXZEROBYTES;

nacl.scalarMult = function(n, p) {
  checkArrayTypes(n, p);
  if (n.length !== crypto_scalarmult_SCALARBYTES) throw new Error('bad n size');
  if (p.length !== crypto_scalarmult_BYTES) throw new Error('bad p size');
  var q = new Uint8Array(crypto_scalarmult_BYTES);
  crypto_scalarmult(q, n, p);
  return q;
};

nacl.scalarMult.base = function(n) {
  checkArrayTypes(n);
  if (n.length !== crypto_scalarmult_SCALARBYTES) throw new Error('bad n size');
  var q = new Uint8Array(crypto_scalarmult_BYTES);
  crypto_scalarmult_base(q, n);
  return q;
};

nacl.scalarMult.scalarLength = crypto_scalarmult_SCALARBYTES;
nacl.scalarMult.groupElementLength = crypto_scalarmult_BYTES;

nacl.box = function(msg, nonce, publicKey, secretKey) {
  var k = nacl.box.before(publicKey, secretKey);
  return nacl.secretbox(msg, nonce, k);
};

nacl.box.before = function(publicKey, secretKey) {
  checkArrayTypes(publicKey, secretKey);
  checkBoxLengths(publicKey, secretKey);
  var k = new Uint8Array(crypto_box_BEFORENMBYTES);
  crypto_box_beforenm(k, publicKey, secretKey);
  return k;
};

nacl.box.after = nacl.secretbox;

nacl.box.open = function(msg, nonce, publicKey, secretKey) {
  var k = nacl.box.before(publicKey, secretKey);
  return nacl.secretbox.open(msg, nonce, k);
};

nacl.box.open.after = nacl.secretbox.open;

nacl.box.keyPair = function() {
  var pk = new Uint8Array(crypto_box_PUBLICKEYBYTES);
  var sk = new Uint8Array(crypto_box_SECRETKEYBYTES);
  crypto_box_keypair(pk, sk);
  return {publicKey: pk, secretKey: sk};
};

nacl.box.keyPair.fromSecretKey = function(secretKey) {
  checkArrayTypes(secretKey);
  if (secretKey.length !== crypto_box_SECRETKEYBYTES)
    throw new Error('bad secret key size');
  var pk = new Uint8Array(crypto_box_PUBLICKEYBYTES);
  crypto_scalarmult_base(pk, secretKey);
  return {publicKey: pk, secretKey: new Uint8Array(secretKey)};
};

nacl.box.publicKeyLength = crypto_box_PUBLICKEYBYTES;
nacl.box.secretKeyLength = crypto_box_SECRETKEYBYTES;
nacl.box.sharedKeyLength = crypto_box_BEFORENMBYTES;
nacl.box.nonceLength = crypto_box_NONCEBYTES;
nacl.box.overheadLength = nacl.secretbox.overheadLength;

nacl.sign = function(msg, secretKey) {
  checkArrayTypes(msg, secretKey);
  if (secretKey.length !== crypto_sign_SECRETKEYBYTES)
    throw new Error('bad secret key size');
  var signedMsg = new Uint8Array(crypto_sign_BYTES+msg.length);
  crypto_sign(signedMsg, msg, msg.length, secretKey);
  return signedMsg;
};

nacl.sign.open = function(signedMsg, publicKey) {
  checkArrayTypes(signedMsg, publicKey);
  if (publicKey.length !== crypto_sign_PUBLICKEYBYTES)
    throw new Error('bad public key size');
  var tmp = new Uint8Array(signedMsg.length);
  var mlen = crypto_sign_open(tmp, signedMsg, signedMsg.length, publicKey);
  if (mlen < 0) return null;
  var m = new Uint8Array(mlen);
  for (var i = 0; i < m.length; i++) m[i] = tmp[i];
  return m;
};

nacl.sign.detached = function(msg, secretKey) {
  var signedMsg = nacl.sign(msg, secretKey);
  var sig = new Uint8Array(crypto_sign_BYTES);
  for (var i = 0; i < sig.length; i++) sig[i] = signedMsg[i];
  return sig;
};

nacl.sign.detached.verify = function(msg, sig, publicKey) {
  checkArrayTypes(msg, sig, publicKey);
  if (sig.length !== crypto_sign_BYTES)
    throw new Error('bad signature size');
  if (publicKey.length !== crypto_sign_PUBLICKEYBYTES)
    throw new Error('bad public key size');
  var sm = new Uint8Array(crypto_sign_BYTES + msg.length);
  var m = new Uint8Array(crypto_sign_BYTES + msg.length);
  var i;
  for (i = 0; i < crypto_sign_BYTES; i++) sm[i] = sig[i];
  for (i = 0; i < msg.length; i++) sm[i+crypto_sign_BYTES] = msg[i];
  return (crypto_sign_open(m, sm, sm.length, publicKey) >= 0);
};

nacl.sign.keyPair = function() {
  var pk = new Uint8Array(crypto_sign_PUBLICKEYBYTES);
  var sk = new Uint8Array(crypto_sign_SECRETKEYBYTES);
  crypto_sign_keypair(pk, sk);
  return {publicKey: pk, secretKey: sk};
};

nacl.sign.keyPair.fromSecretKey = function(secretKey) {
  checkArrayTypes(secretKey);
  if (secretKey.length !== crypto_sign_SECRETKEYBYTES)
    throw new Error('bad secret key size');
  var pk = new Uint8Array(crypto_sign_PUBLICKEYBYTES);
  for (var i = 0; i < pk.length; i++) pk[i] = secretKey[32+i];
  return {publicKey: pk, secretKey: new Uint8Array(secretKey)};
};

nacl.sign.keyPair.fromSeed = function(seed) {
  checkArrayTypes(seed);
  if (seed.length !== crypto_sign_SEEDBYTES)
    throw new Error('bad seed size');
  var pk = new Uint8Array(crypto_sign_PUBLICKEYBYTES);
  var sk = new Uint8Array(crypto_sign_SECRETKEYBYTES);
  for (var i = 0; i < 32; i++) sk[i] = seed[i];
  crypto_sign_keypair(pk, sk, true);
  return {publicKey: pk, secretKey: sk};
};

nacl.sign.publicKeyLength = crypto_sign_PUBLICKEYBYTES;
nacl.sign.secretKeyLength = crypto_sign_SECRETKEYBYTES;
nacl.sign.seedLength = crypto_sign_SEEDBYTES;
nacl.sign.signatureLength = crypto_sign_BYTES;

nacl.hash = function(msg) {
  checkArrayTypes(msg);
  var h = new Uint8Array(crypto_hash_BYTES);
  crypto_hash(h, msg, msg.length);
  return h;
};

nacl.hash.hashLength = crypto_hash_BYTES;

nacl.verify = function(x, y) {
  checkArrayTypes(x, y);
  // Zero length arguments are considered not equal.
  if (x.length === 0 || y.length === 0) return false;
  if (x.length !== y.length) return false;
  return (vn(x, 0, y, 0, x.length) === 0) ? true : false;
};

nacl.setPRNG = function(fn) {
  randombytes = fn;
};

(function() {
  // Initialize PRNG if environment provides CSPRNG.
  // If not, methods calling randombytes will throw.
  var crypto = typeof self !== 'undefined' ? (self.crypto || self.msCrypto) : null;
  if (crypto && crypto.getRandomValues) {
    // Browsers.
    var QUOTA = 65536;
    nacl.setPRNG(function(x, n) {
      var i, v = new Uint8Array(n);
      for (i = 0; i < n; i += QUOTA) {
        crypto.getRandomValues(v.subarray(i, i + Math.min(n - i, QUOTA)));
      }
      for (i = 0; i < n; i++) x[i] = v[i];
      cleanup(v);
    });
  } else if (true) {
    // Node.js.
    crypto = __webpack_require__(76417);
    if (crypto && crypto.randomBytes) {
      nacl.setPRNG(function(x, n) {
        var i, v = crypto.randomBytes(n);
        for (i = 0; i < n; i++) x[i] = v[i];
        cleanup(v);
      });
    }
  }
})();

})( true && module.exports ? module.exports : (self.nacl = self.nacl || {}));


/***/ }),

/***/ 59078:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/*!
 * accepts
 * Copyright(c) 2014 Jonathan Ong
 * Copyright(c) 2015 Douglas Christopher Wilson
 * MIT Licensed
 */



/**
 * Module dependencies.
 * @private
 */

var Negotiator = __webpack_require__(60159)
var mime = __webpack_require__(80983)

/**
 * Module exports.
 * @public
 */

module.exports = Accepts

/**
 * Create a new Accepts object for the given req.
 *
 * @param {object} req
 * @public
 */

function Accepts (req) {
  if (!(this instanceof Accepts)) {
    return new Accepts(req)
  }

  this.headers = req.headers
  this.negotiator = new Negotiator(req)
}

/**
 * Check if the given `type(s)` is acceptable, returning
 * the best match when true, otherwise `undefined`, in which
 * case you should respond with 406 "Not Acceptable".
 *
 * The `type` value may be a single mime type string
 * such as "application/json", the extension name
 * such as "json" or an array `["json", "html", "text/plain"]`. When a list
 * or array is given the _best_ match, if any is returned.
 *
 * Examples:
 *
 *     // Accept: text/html
 *     this.types('html');
 *     // => "html"
 *
 *     // Accept: text/*, application/json
 *     this.types('html');
 *     // => "html"
 *     this.types('text/html');
 *     // => "text/html"
 *     this.types('json', 'text');
 *     // => "json"
 *     this.types('application/json');
 *     // => "application/json"
 *
 *     // Accept: text/*, application/json
 *     this.types('image/png');
 *     this.types('png');
 *     // => undefined
 *
 *     // Accept: text/*;q=.5, application/json
 *     this.types(['html', 'json']);
 *     this.types('html', 'json');
 *     // => "json"
 *
 * @param {String|Array} types...
 * @return {String|Array|Boolean}
 * @public
 */

Accepts.prototype.type =
Accepts.prototype.types = function (types_) {
  var types = types_

  // support flattened arguments
  if (types && !Array.isArray(types)) {
    types = new Array(arguments.length)
    for (var i = 0; i < types.length; i++) {
      types[i] = arguments[i]
    }
  }

  // no types, return all requested types
  if (!types || types.length === 0) {
    return this.negotiator.mediaTypes()
  }

  // no accept header, return first given type
  if (!this.headers.accept) {
    return types[0]
  }

  var mimes = types.map(extToMime)
  var accepts = this.negotiator.mediaTypes(mimes.filter(validMime))
  var first = accepts[0]

  return first
    ? types[mimes.indexOf(first)]
    : false
}

/**
 * Return accepted encodings or best fit based on `encodings`.
 *
 * Given `Accept-Encoding: gzip, deflate`
 * an array sorted by quality is returned:
 *
 *     ['gzip', 'deflate']
 *
 * @param {String|Array} encodings...
 * @return {String|Array}
 * @public
 */

Accepts.prototype.encoding =
Accepts.prototype.encodings = function (encodings_) {
  var encodings = encodings_

  // support flattened arguments
  if (encodings && !Array.isArray(encodings)) {
    encodings = new Array(arguments.length)
    for (var i = 0; i < encodings.length; i++) {
      encodings[i] = arguments[i]
    }
  }

  // no encodings, return all requested encodings
  if (!encodings || encodings.length === 0) {
    return this.negotiator.encodings()
  }

  return this.negotiator.encodings(encodings)[0] || false
}

/**
 * Return accepted charsets or best fit based on `charsets`.
 *
 * Given `Accept-Charset: utf-8, iso-8859-1;q=0.2, utf-7;q=0.5`
 * an array sorted by quality is returned:
 *
 *     ['utf-8', 'utf-7', 'iso-8859-1']
 *
 * @param {String|Array} charsets...
 * @return {String|Array}
 * @public
 */

Accepts.prototype.charset =
Accepts.prototype.charsets = function (charsets_) {
  var charsets = charsets_

  // support flattened arguments
  if (charsets && !Array.isArray(charsets)) {
    charsets = new Array(arguments.length)
    for (var i = 0; i < charsets.length; i++) {
      charsets[i] = arguments[i]
    }
  }

  // no charsets, return all requested charsets
  if (!charsets || charsets.length === 0) {
    return this.negotiator.charsets()
  }

  return this.negotiator.charsets(charsets)[0] || false
}

/**
 * Return accepted languages or best fit based on `langs`.
 *
 * Given `Accept-Language: en;q=0.8, es, pt`
 * an array sorted by quality is returned:
 *
 *     ['es', 'pt', 'en']
 *
 * @param {String|Array} langs...
 * @return {Array|String}
 * @public
 */

Accepts.prototype.lang =
Accepts.prototype.langs =
Accepts.prototype.language =
Accepts.prototype.languages = function (languages_) {
  var languages = languages_

  // support flattened arguments
  if (languages && !Array.isArray(languages)) {
    languages = new Array(arguments.length)
    for (var i = 0; i < languages.length; i++) {
      languages[i] = arguments[i]
    }
  }

  // no languages, return all requested languages
  if (!languages || languages.length === 0) {
    return this.negotiator.languages()
  }

  return this.negotiator.languages(languages)[0] || false
}

/**
 * Convert extnames to mime.
 *
 * @param {String} type
 * @return {String}
 * @private
 */

function extToMime (type) {
  return type.indexOf('/') === -1
    ? mime.lookup(type)
    : type
}

/**
 * Check if mime is valid.
 *
 * @param {String} type
 * @return {String}
 * @private
 */

function validMime (type) {
  return typeof type === 'string'
}


/***/ }),

/***/ 64956:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* provided dependency */ var Buffer = __webpack_require__(64293)["Buffer"];
// Node.js core modules
var crypto = __webpack_require__(76417);


/**
 * The encryption algorithm (cipher) type to be used.
 * @type {String}
 * @const
 * @private
 */
var CIPHER_ALGORITHM = 'aes-256-ctr';


//
// Primary API
//

/**
 * An API to allow for greatly simplified AES-256 encryption and decryption using a passphrase of
 * any length plus a random Initialization Vector.
 * @exports aes256
 * @public
 */
var aes256 = {

  /**
   * Encrypt a clear-text message using AES-256 plus a random Initialization Vector.
   * @param {String} key  A passphrase of any length to used to generate a symmetric session key.
   * @param {String|Buffer} input  The clear-text message or buffer to be encrypted.
   * @returns {String|Buffer} A custom-encrypted version of the input.
   * @public
   * @method
   */
  encrypt: function(key, input) {
    if (typeof key !== 'string' || !key) {
      throw new TypeError('Provided "key" must be a non-empty string');
    }

    var isString = typeof input === 'string';
    var isBuffer = Buffer.isBuffer(input);
    if (!(isString || isBuffer) || (isString && !input) || (isBuffer && !Buffer.byteLength(input))) {
      throw new TypeError('Provided "input" must be a non-empty string or buffer');
    }

    var sha256 = crypto.createHash('sha256');
    sha256.update(key);

    // Initialization Vector
    var iv = crypto.randomBytes(16);
    var cipher = crypto.createCipheriv(CIPHER_ALGORITHM, sha256.digest(), iv);

    var buffer = input;
    if (isString) {
      buffer = Buffer.from(input);
    }

    var ciphertext = cipher.update(buffer);
    var encrypted = Buffer.concat([iv, ciphertext, cipher.final()]);

    if (isString) {
      encrypted = encrypted.toString('base64');
    }

    return encrypted;
  },

  /**
   * Decrypt an encrypted message back to clear-text using AES-256 plus a random Initialization Vector.
   * @param {String} key  A passphrase of any length to used to generate a symmetric session key.
   * @param {String|Buffer} encrypted  The encrypted message to be decrypted.
   * @returns {String|Buffer} The original plain-text message or buffer.
   * @public
   * @method
   */
  decrypt: function(key, encrypted) {
    if (typeof key !== 'string' || !key) {
      throw new TypeError('Provided "key" must be a non-empty string');
    }

    var isString = typeof encrypted === 'string';
    var isBuffer = Buffer.isBuffer(encrypted);
    if (!(isString || isBuffer) || (isString && !encrypted) || (isBuffer && !Buffer.byteLength(encrypted))) {
      throw new TypeError('Provided "encrypted" must be a non-empty string or buffer');
    }

    var sha256 = crypto.createHash('sha256');
    sha256.update(key);

    var input = encrypted;
    if (isString) {
      input = Buffer.from(encrypted, 'base64');

      if (input.length < 17) {
        throw new TypeError('Provided "encrypted" must decrypt to a non-empty string or buffer');
      }
    } else {
      if (Buffer.byteLength(encrypted) < 17) {
        throw new TypeError('Provided "encrypted" must decrypt to a non-empty string or buffer');
      }
    }

    // Initialization Vector
    var iv = input.slice(0, 16);
    var decipher = crypto.createDecipheriv(CIPHER_ALGORITHM, sha256.digest(), iv);

    var ciphertext = input.slice(16);

    var output;
    if (isString) {
      output = decipher.update(ciphertext) + decipher.final();
    } else {
      output = Buffer.concat([decipher.update(ciphertext), decipher.final()]);
    }

    return output;
  }

};




/**
 * Create a symmetric cipher with a given passphrase to then encrypt/decrypt data symmetrically.
 * @param {String} key  A passphrase of any length to used to generate a symmetric session key.
 * @public
 * @constructor
 */
function AesCipher(key) {
  if (typeof key !== 'string' || !key) {
    throw new TypeError('Provided "key" must be a non-empty string');
  }

  /**
   * A passphrase of any length to used to generate a symmetric session key.
   * @member {String} key
   * @readonly
   */
  Object.defineProperty(this, 'key', { value: key });

}

/**
 * Encrypt a clear-text message using AES-256 plus a random Initialization Vector.
 * @param {String} plaintext  The clear-text message to be encrypted.
 * @returns {String} A custom-encrypted version of the input.
 * @public
 * @method
 */
AesCipher.prototype.encrypt = function(plaintext) {
  return aes256.encrypt(this.key, plaintext);
};

/**
 * Decrypt an encrypted message back to clear-text using AES-256 plus a random Initialization Vector.
 * @param {String} encrypted  The encrypted message to be decrypted.
 * @returns {String} The original plain-text message.
 * @public
 * @method
 */
AesCipher.prototype.decrypt = function(encrypted) {
  return aes256.decrypt(this.key, encrypted);
};




//
// API Extension
//


/**
 * Create a symmetric cipher with a given passphrase to then encrypt/decrypt data symmetrically.
 * @param {String} key  A passphrase of any length to used to generate a symmetric session key.
 * @returns {AesCipher}
 * @public
 * @method
 */
aes256.createCipher = function(key) {
  return new AesCipher(key);
};




//
// Export the API
//

module.exports = aes256;


/***/ }),

/***/ 65096:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var console = __webpack_require__(25108);


var compileSchema = __webpack_require__(47153)
  , resolve = __webpack_require__(83610)
  , Cache = __webpack_require__(47531)
  , SchemaObject = __webpack_require__(74022)
  , stableStringify = __webpack_require__(35035)
  , formats = __webpack_require__(1516)
  , rules = __webpack_require__(47753)
  , $dataMetaSchema = __webpack_require__(3978)
  , util = __webpack_require__(42889);

module.exports = Ajv;

Ajv.prototype.validate = validate;
Ajv.prototype.compile = compile;
Ajv.prototype.addSchema = addSchema;
Ajv.prototype.addMetaSchema = addMetaSchema;
Ajv.prototype.validateSchema = validateSchema;
Ajv.prototype.getSchema = getSchema;
Ajv.prototype.removeSchema = removeSchema;
Ajv.prototype.addFormat = addFormat;
Ajv.prototype.errorsText = errorsText;

Ajv.prototype._addSchema = _addSchema;
Ajv.prototype._compile = _compile;

Ajv.prototype.compileAsync = __webpack_require__(42931);
var customKeyword = __webpack_require__(14895);
Ajv.prototype.addKeyword = customKeyword.add;
Ajv.prototype.getKeyword = customKeyword.get;
Ajv.prototype.removeKeyword = customKeyword.remove;
Ajv.prototype.validateKeyword = customKeyword.validate;

var errorClasses = __webpack_require__(87802);
Ajv.ValidationError = errorClasses.Validation;
Ajv.MissingRefError = errorClasses.MissingRef;
Ajv.$dataMetaSchema = $dataMetaSchema;

var META_SCHEMA_ID = 'http://json-schema.org/draft-07/schema';

var META_IGNORE_OPTIONS = [ 'removeAdditional', 'useDefaults', 'coerceTypes', 'strictDefaults' ];
var META_SUPPORT_DATA = ['/properties'];

/**
 * Creates validator instance.
 * Usage: `Ajv(opts)`
 * @param {Object} opts optional options
 * @return {Object} ajv instance
 */
function Ajv(opts) {
  if (!(this instanceof Ajv)) return new Ajv(opts);
  opts = this._opts = util.copy(opts) || {};
  setLogger(this);
  this._schemas = {};
  this._refs = {};
  this._fragments = {};
  this._formats = formats(opts.format);

  this._cache = opts.cache || new Cache;
  this._loadingSchemas = {};
  this._compilations = [];
  this.RULES = rules();
  this._getId = chooseGetId(opts);

  opts.loopRequired = opts.loopRequired || Infinity;
  if (opts.errorDataPath == 'property') opts._errorDataPathProperty = true;
  if (opts.serialize === undefined) opts.serialize = stableStringify;
  this._metaOpts = getMetaSchemaOptions(this);

  if (opts.formats) addInitialFormats(this);
  if (opts.keywords) addInitialKeywords(this);
  addDefaultMetaSchema(this);
  if (typeof opts.meta == 'object') this.addMetaSchema(opts.meta);
  if (opts.nullable) this.addKeyword('nullable', {metaSchema: {type: 'boolean'}});
  addInitialSchemas(this);
}



/**
 * Validate data using schema
 * Schema will be compiled and cached (using serialized JSON as key. [fast-json-stable-stringify](https://github.com/epoberezkin/fast-json-stable-stringify) is used to serialize.
 * @this   Ajv
 * @param  {String|Object} schemaKeyRef key, ref or schema object
 * @param  {Any} data to be validated
 * @return {Boolean} validation result. Errors from the last validation will be available in `ajv.errors` (and also in compiled schema: `schema.errors`).
 */
function validate(schemaKeyRef, data) {
  var v;
  if (typeof schemaKeyRef == 'string') {
    v = this.getSchema(schemaKeyRef);
    if (!v) throw new Error('no schema with key or ref "' + schemaKeyRef + '"');
  } else {
    var schemaObj = this._addSchema(schemaKeyRef);
    v = schemaObj.validate || this._compile(schemaObj);
  }

  var valid = v(data);
  if (v.$async !== true) this.errors = v.errors;
  return valid;
}


/**
 * Create validating function for passed schema.
 * @this   Ajv
 * @param  {Object} schema schema object
 * @param  {Boolean} _meta true if schema is a meta-schema. Used internally to compile meta schemas of custom keywords.
 * @return {Function} validating function
 */
function compile(schema, _meta) {
  var schemaObj = this._addSchema(schema, undefined, _meta);
  return schemaObj.validate || this._compile(schemaObj);
}


/**
 * Adds schema to the instance.
 * @this   Ajv
 * @param {Object|Array} schema schema or array of schemas. If array is passed, `key` and other parameters will be ignored.
 * @param {String} key Optional schema key. Can be passed to `validate` method instead of schema object or id/ref. One schema per instance can have empty `id` and `key`.
 * @param {Boolean} _skipValidation true to skip schema validation. Used internally, option validateSchema should be used instead.
 * @param {Boolean} _meta true if schema is a meta-schema. Used internally, addMetaSchema should be used instead.
 * @return {Ajv} this for method chaining
 */
function addSchema(schema, key, _skipValidation, _meta) {
  if (Array.isArray(schema)){
    for (var i=0; i<schema.length; i++) this.addSchema(schema[i], undefined, _skipValidation, _meta);
    return this;
  }
  var id = this._getId(schema);
  if (id !== undefined && typeof id != 'string')
    throw new Error('schema id must be string');
  key = resolve.normalizeId(key || id);
  checkUnique(this, key);
  this._schemas[key] = this._addSchema(schema, _skipValidation, _meta, true);
  return this;
}


/**
 * Add schema that will be used to validate other schemas
 * options in META_IGNORE_OPTIONS are alway set to false
 * @this   Ajv
 * @param {Object} schema schema object
 * @param {String} key optional schema key
 * @param {Boolean} skipValidation true to skip schema validation, can be used to override validateSchema option for meta-schema
 * @return {Ajv} this for method chaining
 */
function addMetaSchema(schema, key, skipValidation) {
  this.addSchema(schema, key, skipValidation, true);
  return this;
}


/**
 * Validate schema
 * @this   Ajv
 * @param {Object} schema schema to validate
 * @param {Boolean} throwOrLogError pass true to throw (or log) an error if invalid
 * @return {Boolean} true if schema is valid
 */
function validateSchema(schema, throwOrLogError) {
  var $schema = schema.$schema;
  if ($schema !== undefined && typeof $schema != 'string')
    throw new Error('$schema must be a string');
  $schema = $schema || this._opts.defaultMeta || defaultMeta(this);
  if (!$schema) {
    this.logger.warn('meta-schema not available');
    this.errors = null;
    return true;
  }
  var valid = this.validate($schema, schema);
  if (!valid && throwOrLogError) {
    var message = 'schema is invalid: ' + this.errorsText();
    if (this._opts.validateSchema == 'log') this.logger.error(message);
    else throw new Error(message);
  }
  return valid;
}


function defaultMeta(self) {
  var meta = self._opts.meta;
  self._opts.defaultMeta = typeof meta == 'object'
                            ? self._getId(meta) || meta
                            : self.getSchema(META_SCHEMA_ID)
                              ? META_SCHEMA_ID
                              : undefined;
  return self._opts.defaultMeta;
}


/**
 * Get compiled schema from the instance by `key` or `ref`.
 * @this   Ajv
 * @param  {String} keyRef `key` that was passed to `addSchema` or full schema reference (`schema.id` or resolved id).
 * @return {Function} schema validating function (with property `schema`).
 */
function getSchema(keyRef) {
  var schemaObj = _getSchemaObj(this, keyRef);
  switch (typeof schemaObj) {
    case 'object': return schemaObj.validate || this._compile(schemaObj);
    case 'string': return this.getSchema(schemaObj);
    case 'undefined': return _getSchemaFragment(this, keyRef);
  }
}


function _getSchemaFragment(self, ref) {
  var res = resolve.schema.call(self, { schema: {} }, ref);
  if (res) {
    var schema = res.schema
      , root = res.root
      , baseId = res.baseId;
    var v = compileSchema.call(self, schema, root, undefined, baseId);
    self._fragments[ref] = new SchemaObject({
      ref: ref,
      fragment: true,
      schema: schema,
      root: root,
      baseId: baseId,
      validate: v
    });
    return v;
  }
}


function _getSchemaObj(self, keyRef) {
  keyRef = resolve.normalizeId(keyRef);
  return self._schemas[keyRef] || self._refs[keyRef] || self._fragments[keyRef];
}


/**
 * Remove cached schema(s).
 * If no parameter is passed all schemas but meta-schemas are removed.
 * If RegExp is passed all schemas with key/id matching pattern but meta-schemas are removed.
 * Even if schema is referenced by other schemas it still can be removed as other schemas have local references.
 * @this   Ajv
 * @param  {String|Object|RegExp} schemaKeyRef key, ref, pattern to match key/ref or schema object
 * @return {Ajv} this for method chaining
 */
function removeSchema(schemaKeyRef) {
  if (schemaKeyRef instanceof RegExp) {
    _removeAllSchemas(this, this._schemas, schemaKeyRef);
    _removeAllSchemas(this, this._refs, schemaKeyRef);
    return this;
  }
  switch (typeof schemaKeyRef) {
    case 'undefined':
      _removeAllSchemas(this, this._schemas);
      _removeAllSchemas(this, this._refs);
      this._cache.clear();
      return this;
    case 'string':
      var schemaObj = _getSchemaObj(this, schemaKeyRef);
      if (schemaObj) this._cache.del(schemaObj.cacheKey);
      delete this._schemas[schemaKeyRef];
      delete this._refs[schemaKeyRef];
      return this;
    case 'object':
      var serialize = this._opts.serialize;
      var cacheKey = serialize ? serialize(schemaKeyRef) : schemaKeyRef;
      this._cache.del(cacheKey);
      var id = this._getId(schemaKeyRef);
      if (id) {
        id = resolve.normalizeId(id);
        delete this._schemas[id];
        delete this._refs[id];
      }
  }
  return this;
}


function _removeAllSchemas(self, schemas, regex) {
  for (var keyRef in schemas) {
    var schemaObj = schemas[keyRef];
    if (!schemaObj.meta && (!regex || regex.test(keyRef))) {
      self._cache.del(schemaObj.cacheKey);
      delete schemas[keyRef];
    }
  }
}


/* @this   Ajv */
function _addSchema(schema, skipValidation, meta, shouldAddSchema) {
  if (typeof schema != 'object' && typeof schema != 'boolean')
    throw new Error('schema should be object or boolean');
  var serialize = this._opts.serialize;
  var cacheKey = serialize ? serialize(schema) : schema;
  var cached = this._cache.get(cacheKey);
  if (cached) return cached;

  shouldAddSchema = shouldAddSchema || this._opts.addUsedSchema !== false;

  var id = resolve.normalizeId(this._getId(schema));
  if (id && shouldAddSchema) checkUnique(this, id);

  var willValidate = this._opts.validateSchema !== false && !skipValidation;
  var recursiveMeta;
  if (willValidate && !(recursiveMeta = id && id == resolve.normalizeId(schema.$schema)))
    this.validateSchema(schema, true);

  var localRefs = resolve.ids.call(this, schema);

  var schemaObj = new SchemaObject({
    id: id,
    schema: schema,
    localRefs: localRefs,
    cacheKey: cacheKey,
    meta: meta
  });

  if (id[0] != '#' && shouldAddSchema) this._refs[id] = schemaObj;
  this._cache.put(cacheKey, schemaObj);

  if (willValidate && recursiveMeta) this.validateSchema(schema, true);

  return schemaObj;
}


/* @this   Ajv */
function _compile(schemaObj, root) {
  if (schemaObj.compiling) {
    schemaObj.validate = callValidate;
    callValidate.schema = schemaObj.schema;
    callValidate.errors = null;
    callValidate.root = root ? root : callValidate;
    if (schemaObj.schema.$async === true)
      callValidate.$async = true;
    return callValidate;
  }
  schemaObj.compiling = true;

  var currentOpts;
  if (schemaObj.meta) {
    currentOpts = this._opts;
    this._opts = this._metaOpts;
  }

  var v;
  try { v = compileSchema.call(this, schemaObj.schema, root, schemaObj.localRefs); }
  catch(e) {
    delete schemaObj.validate;
    throw e;
  }
  finally {
    schemaObj.compiling = false;
    if (schemaObj.meta) this._opts = currentOpts;
  }

  schemaObj.validate = v;
  schemaObj.refs = v.refs;
  schemaObj.refVal = v.refVal;
  schemaObj.root = v.root;
  return v;


  /* @this   {*} - custom context, see passContext option */
  function callValidate() {
    /* jshint validthis: true */
    var _validate = schemaObj.validate;
    var result = _validate.apply(this, arguments);
    callValidate.errors = _validate.errors;
    return result;
  }
}


function chooseGetId(opts) {
  switch (opts.schemaId) {
    case 'auto': return _get$IdOrId;
    case 'id': return _getId;
    default: return _get$Id;
  }
}

/* @this   Ajv */
function _getId(schema) {
  if (schema.$id) this.logger.warn('schema $id ignored', schema.$id);
  return schema.id;
}

/* @this   Ajv */
function _get$Id(schema) {
  if (schema.id) this.logger.warn('schema id ignored', schema.id);
  return schema.$id;
}


function _get$IdOrId(schema) {
  if (schema.$id && schema.id && schema.$id != schema.id)
    throw new Error('schema $id is different from id');
  return schema.$id || schema.id;
}


/**
 * Convert array of error message objects to string
 * @this   Ajv
 * @param  {Array<Object>} errors optional array of validation errors, if not passed errors from the instance are used.
 * @param  {Object} options optional options with properties `separator` and `dataVar`.
 * @return {String} human readable string with all errors descriptions
 */
function errorsText(errors, options) {
  errors = errors || this.errors;
  if (!errors) return 'No errors';
  options = options || {};
  var separator = options.separator === undefined ? ', ' : options.separator;
  var dataVar = options.dataVar === undefined ? 'data' : options.dataVar;

  var text = '';
  for (var i=0; i<errors.length; i++) {
    var e = errors[i];
    if (e) text += dataVar + e.dataPath + ' ' + e.message + separator;
  }
  return text.slice(0, -separator.length);
}


/**
 * Add custom format
 * @this   Ajv
 * @param {String} name format name
 * @param {String|RegExp|Function} format string is converted to RegExp; function should return boolean (true when valid)
 * @return {Ajv} this for method chaining
 */
function addFormat(name, format) {
  if (typeof format == 'string') format = new RegExp(format);
  this._formats[name] = format;
  return this;
}


function addDefaultMetaSchema(self) {
  var $dataSchema;
  if (self._opts.$data) {
    $dataSchema = __webpack_require__(66835);
    self.addMetaSchema($dataSchema, $dataSchema.$id, true);
  }
  if (self._opts.meta === false) return;
  var metaSchema = __webpack_require__(40038);
  if (self._opts.$data) metaSchema = $dataMetaSchema(metaSchema, META_SUPPORT_DATA);
  self.addMetaSchema(metaSchema, META_SCHEMA_ID, true);
  self._refs['http://json-schema.org/schema'] = META_SCHEMA_ID;
}


function addInitialSchemas(self) {
  var optsSchemas = self._opts.schemas;
  if (!optsSchemas) return;
  if (Array.isArray(optsSchemas)) self.addSchema(optsSchemas);
  else for (var key in optsSchemas) self.addSchema(optsSchemas[key], key);
}


function addInitialFormats(self) {
  for (var name in self._opts.formats) {
    var format = self._opts.formats[name];
    self.addFormat(name, format);
  }
}


function addInitialKeywords(self) {
  for (var name in self._opts.keywords) {
    var keyword = self._opts.keywords[name];
    self.addKeyword(name, keyword);
  }
}


function checkUnique(self, id) {
  if (self._schemas[id] || self._refs[id])
    throw new Error('schema with key or id "' + id + '" already exists');
}


function getMetaSchemaOptions(self) {
  var metaOpts = util.copy(self._opts);
  for (var i=0; i<META_IGNORE_OPTIONS.length; i++)
    delete metaOpts[META_IGNORE_OPTIONS[i]];
  return metaOpts;
}


function setLogger(self) {
  var logger = self._opts.logger;
  if (logger === false) {
    self.logger = {log: noop, warn: noop, error: noop};
  } else {
    if (logger === undefined) logger = console;
    if (!(typeof logger == 'object' && logger.log && logger.warn && logger.error))
      throw new Error('logger must implement log, warn and error methods');
    self.logger = logger;
  }
}


function noop() {}


/***/ }),

/***/ 47531:
/***/ ((module) => {

"use strict";



var Cache = module.exports = function Cache() {
  this._cache = {};
};


Cache.prototype.put = function Cache_put(key, value) {
  this._cache[key] = value;
};


Cache.prototype.get = function Cache_get(key) {
  return this._cache[key];
};


Cache.prototype.del = function Cache_del(key) {
  delete this._cache[key];
};


Cache.prototype.clear = function Cache_clear() {
  this._cache = {};
};


/***/ }),

/***/ 42931:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var MissingRefError = __webpack_require__(87802).MissingRef;

module.exports = compileAsync;


/**
 * Creates validating function for passed schema with asynchronous loading of missing schemas.
 * `loadSchema` option should be a function that accepts schema uri and returns promise that resolves with the schema.
 * @this  Ajv
 * @param {Object}   schema schema object
 * @param {Boolean}  meta optional true to compile meta-schema; this parameter can be skipped
 * @param {Function} callback an optional node-style callback, it is called with 2 parameters: error (or null) and validating function.
 * @return {Promise} promise that resolves with a validating function.
 */
function compileAsync(schema, meta, callback) {
  /* eslint no-shadow: 0 */
  /* global Promise */
  /* jshint validthis: true */
  var self = this;
  if (typeof this._opts.loadSchema != 'function')
    throw new Error('options.loadSchema should be a function');

  if (typeof meta == 'function') {
    callback = meta;
    meta = undefined;
  }

  var p = loadMetaSchemaOf(schema).then(function () {
    var schemaObj = self._addSchema(schema, undefined, meta);
    return schemaObj.validate || _compileAsync(schemaObj);
  });

  if (callback) {
    p.then(
      function(v) { callback(null, v); },
      callback
    );
  }

  return p;


  function loadMetaSchemaOf(sch) {
    var $schema = sch.$schema;
    return $schema && !self.getSchema($schema)
            ? compileAsync.call(self, { $ref: $schema }, true)
            : Promise.resolve();
  }


  function _compileAsync(schemaObj) {
    try { return self._compile(schemaObj); }
    catch(e) {
      if (e instanceof MissingRefError) return loadMissingSchema(e);
      throw e;
    }


    function loadMissingSchema(e) {
      var ref = e.missingSchema;
      if (added(ref)) throw new Error('Schema ' + ref + ' is loaded but ' + e.missingRef + ' cannot be resolved');

      var schemaPromise = self._loadingSchemas[ref];
      if (!schemaPromise) {
        schemaPromise = self._loadingSchemas[ref] = self._opts.loadSchema(ref);
        schemaPromise.then(removePromise, removePromise);
      }

      return schemaPromise.then(function (sch) {
        if (!added(ref)) {
          return loadMetaSchemaOf(sch).then(function () {
            if (!added(ref)) self.addSchema(sch, ref, undefined, meta);
          });
        }
      }).then(function() {
        return _compileAsync(schemaObj);
      });

      function removePromise() {
        delete self._loadingSchemas[ref];
      }

      function added(ref) {
        return self._refs[ref] || self._schemas[ref];
      }
    }
  }
}


/***/ }),

/***/ 87802:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var resolve = __webpack_require__(83610);

module.exports = {
  Validation: errorSubclass(ValidationError),
  MissingRef: errorSubclass(MissingRefError)
};


function ValidationError(errors) {
  this.message = 'validation failed';
  this.errors = errors;
  this.ajv = this.validation = true;
}


MissingRefError.message = function (baseId, ref) {
  return 'can\'t resolve reference ' + ref + ' from id ' + baseId;
};


function MissingRefError(baseId, ref, message) {
  this.message = message || MissingRefError.message(baseId, ref);
  this.missingRef = resolve.url(baseId, ref);
  this.missingSchema = resolve.normalizeId(resolve.fullPath(this.missingRef));
}


function errorSubclass(Subclass) {
  Subclass.prototype = Object.create(Error.prototype);
  Subclass.prototype.constructor = Subclass;
  return Subclass;
}


/***/ }),

/***/ 1516:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var util = __webpack_require__(42889);

var DATE = /^(\d\d\d\d)-(\d\d)-(\d\d)$/;
var DAYS = [0,31,28,31,30,31,30,31,31,30,31,30,31];
var TIME = /^(\d\d):(\d\d):(\d\d)(\.\d+)?(z|[+-]\d\d(?::?\d\d)?)?$/i;
var HOSTNAME = /^(?=.{1,253}\.?$)[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[-0-9a-z]{0,61}[0-9a-z])?)*\.?$/i;
var URI = /^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)(?:\?(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i;
var URIREF = /^(?:[a-z][a-z0-9+\-.]*:)?(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'"()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?(?:\?(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i;
// uri-template: https://tools.ietf.org/html/rfc6570
var URITEMPLATE = /^(?:(?:[^\x00-\x20"'<>%\\^`{|}]|%[0-9a-f]{2})|\{[+#./;?&=,!@|]?(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?(?:,(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?)*\})*$/i;
// For the source: https://gist.github.com/dperini/729294
// For test cases: https://mathiasbynens.be/demo/url-regex
// @todo Delete current URL in favour of the commented out URL rule when this issue is fixed https://github.com/eslint/eslint/issues/7983.
// var URL = /^(?:(?:https?|ftp):\/\/)(?:\S+(?::\S*)?@)?(?:(?!10(?:\.\d{1,3}){3})(?!127(?:\.\d{1,3}){3})(?!169\.254(?:\.\d{1,3}){2})(?!192\.168(?:\.\d{1,3}){2})(?!172\.(?:1[6-9]|2\d|3[0-1])(?:\.\d{1,3}){2})(?:[1-9]\d?|1\d\d|2[01]\d|22[0-3])(?:\.(?:1?\d{1,2}|2[0-4]\d|25[0-5])){2}(?:\.(?:[1-9]\d?|1\d\d|2[0-4]\d|25[0-4]))|(?:(?:[a-z\u{00a1}-\u{ffff}0-9]+-)*[a-z\u{00a1}-\u{ffff}0-9]+)(?:\.(?:[a-z\u{00a1}-\u{ffff}0-9]+-)*[a-z\u{00a1}-\u{ffff}0-9]+)*(?:\.(?:[a-z\u{00a1}-\u{ffff}]{2,})))(?::\d{2,5})?(?:\/[^\s]*)?$/iu;
var URL = /^(?:(?:http[s\u017F]?|ftp):\/\/)(?:(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+(?::(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?@)?(?:(?!10(?:\.[0-9]{1,3}){3})(?!127(?:\.[0-9]{1,3}){3})(?!169\.254(?:\.[0-9]{1,3}){2})(?!192\.168(?:\.[0-9]{1,3}){2})(?!172\.(?:1[6-9]|2[0-9]|3[01])(?:\.[0-9]{1,3}){2})(?:[1-9][0-9]?|1[0-9][0-9]|2[01][0-9]|22[0-3])(?:\.(?:1?[0-9]{1,2}|2[0-4][0-9]|25[0-5])){2}(?:\.(?:[1-9][0-9]?|1[0-9][0-9]|2[0-4][0-9]|25[0-4]))|(?:(?:(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-)*(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)(?:\.(?:(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-)*(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)*(?:\.(?:(?:[a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]){2,})))(?::[0-9]{2,5})?(?:\/(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?$/i;
var UUID = /^(?:urn:uuid:)?[0-9a-f]{8}-(?:[0-9a-f]{4}-){3}[0-9a-f]{12}$/i;
var JSON_POINTER = /^(?:\/(?:[^~/]|~0|~1)*)*$/;
var JSON_POINTER_URI_FRAGMENT = /^#(?:\/(?:[a-z0-9_\-.!$&'()*+,;:=@]|%[0-9a-f]{2}|~0|~1)*)*$/i;
var RELATIVE_JSON_POINTER = /^(?:0|[1-9][0-9]*)(?:#|(?:\/(?:[^~/]|~0|~1)*)*)$/;


module.exports = formats;

function formats(mode) {
  mode = mode == 'full' ? 'full' : 'fast';
  return util.copy(formats[mode]);
}


formats.fast = {
  // date: http://tools.ietf.org/html/rfc3339#section-5.6
  date: /^\d\d\d\d-[0-1]\d-[0-3]\d$/,
  // date-time: http://tools.ietf.org/html/rfc3339#section-5.6
  time: /^(?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)?$/i,
  'date-time': /^\d\d\d\d-[0-1]\d-[0-3]\d[t\s](?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)$/i,
  // uri: https://github.com/mafintosh/is-my-json-valid/blob/master/formats.js
  uri: /^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/)?[^\s]*$/i,
  'uri-reference': /^(?:(?:[a-z][a-z0-9+\-.]*:)?\/?\/)?(?:[^\\\s#][^\s#]*)?(?:#[^\\\s]*)?$/i,
  'uri-template': URITEMPLATE,
  url: URL,
  // email (sources from jsen validator):
  // http://stackoverflow.com/questions/201323/using-a-regular-expression-to-validate-an-email-address#answer-8829363
  // http://www.w3.org/TR/html5/forms.html#valid-e-mail-address (search for 'willful violation')
  email: /^[a-z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?)*$/i,
  hostname: HOSTNAME,
  // optimized https://www.safaribooksonline.com/library/view/regular-expressions-cookbook/9780596802837/ch07s16.html
  ipv4: /^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,
  // optimized http://stackoverflow.com/questions/53497/regular-expression-that-matches-valid-ipv6-addresses
  ipv6: /^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,
  regex: regex,
  // uuid: http://tools.ietf.org/html/rfc4122
  uuid: UUID,
  // JSON-pointer: https://tools.ietf.org/html/rfc6901
  // uri fragment: https://tools.ietf.org/html/rfc3986#appendix-A
  'json-pointer': JSON_POINTER,
  'json-pointer-uri-fragment': JSON_POINTER_URI_FRAGMENT,
  // relative JSON-pointer: http://tools.ietf.org/html/draft-luff-relative-json-pointer-00
  'relative-json-pointer': RELATIVE_JSON_POINTER
};


formats.full = {
  date: date,
  time: time,
  'date-time': date_time,
  uri: uri,
  'uri-reference': URIREF,
  'uri-template': URITEMPLATE,
  url: URL,
  email: /^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$/i,
  hostname: HOSTNAME,
  ipv4: /^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,
  ipv6: /^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,
  regex: regex,
  uuid: UUID,
  'json-pointer': JSON_POINTER,
  'json-pointer-uri-fragment': JSON_POINTER_URI_FRAGMENT,
  'relative-json-pointer': RELATIVE_JSON_POINTER
};


function isLeapYear(year) {
  // https://tools.ietf.org/html/rfc3339#appendix-C
  return year % 4 === 0 && (year % 100 !== 0 || year % 400 === 0);
}


function date(str) {
  // full-date from http://tools.ietf.org/html/rfc3339#section-5.6
  var matches = str.match(DATE);
  if (!matches) return false;

  var year = +matches[1];
  var month = +matches[2];
  var day = +matches[3];

  return month >= 1 && month <= 12 && day >= 1 &&
          day <= (month == 2 && isLeapYear(year) ? 29 : DAYS[month]);
}


function time(str, full) {
  var matches = str.match(TIME);
  if (!matches) return false;

  var hour = matches[1];
  var minute = matches[2];
  var second = matches[3];
  var timeZone = matches[5];
  return ((hour <= 23 && minute <= 59 && second <= 59) ||
          (hour == 23 && minute == 59 && second == 60)) &&
         (!full || timeZone);
}


var DATE_TIME_SEPARATOR = /t|\s/i;
function date_time(str) {
  // http://tools.ietf.org/html/rfc3339#section-5.6
  var dateTime = str.split(DATE_TIME_SEPARATOR);
  return dateTime.length == 2 && date(dateTime[0]) && time(dateTime[1], true);
}


var NOT_URI_FRAGMENT = /\/|:/;
function uri(str) {
  // http://jmrware.com/articles/2009/uri_regexp/URI_regex.html + optional protocol + required "."
  return NOT_URI_FRAGMENT.test(str) && URI.test(str);
}


var Z_ANCHOR = /[^\\]\\Z/;
function regex(str) {
  if (Z_ANCHOR.test(str)) return false;
  try {
    new RegExp(str);
    return true;
  } catch(e) {
    return false;
  }
}


/***/ }),

/***/ 47153:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var resolve = __webpack_require__(83610)
  , util = __webpack_require__(42889)
  , errorClasses = __webpack_require__(87802)
  , stableStringify = __webpack_require__(35035);

var validateGenerator = __webpack_require__(19508);

/**
 * Functions below are used inside compiled validations function
 */

var ucs2length = util.ucs2length;
var equal = __webpack_require__(64063);

// this error is thrown by async schemas to return validation errors via exception
var ValidationError = errorClasses.Validation;

module.exports = compile;


/**
 * Compiles schema to validation function
 * @this   Ajv
 * @param  {Object} schema schema object
 * @param  {Object} root object with information about the root schema for this schema
 * @param  {Object} localRefs the hash of local references inside the schema (created by resolve.id), used for inline resolution
 * @param  {String} baseId base ID for IDs in the schema
 * @return {Function} validation function
 */
function compile(schema, root, localRefs, baseId) {
  /* jshint validthis: true, evil: true */
  /* eslint no-shadow: 0 */
  var self = this
    , opts = this._opts
    , refVal = [ undefined ]
    , refs = {}
    , patterns = []
    , patternsHash = {}
    , defaults = []
    , defaultsHash = {}
    , customRules = [];

  root = root || { schema: schema, refVal: refVal, refs: refs };

  var c = checkCompiling.call(this, schema, root, baseId);
  var compilation = this._compilations[c.index];
  if (c.compiling) return (compilation.callValidate = callValidate);

  var formats = this._formats;
  var RULES = this.RULES;

  try {
    var v = localCompile(schema, root, localRefs, baseId);
    compilation.validate = v;
    var cv = compilation.callValidate;
    if (cv) {
      cv.schema = v.schema;
      cv.errors = null;
      cv.refs = v.refs;
      cv.refVal = v.refVal;
      cv.root = v.root;
      cv.$async = v.$async;
      if (opts.sourceCode) cv.source = v.source;
    }
    return v;
  } finally {
    endCompiling.call(this, schema, root, baseId);
  }

  /* @this   {*} - custom context, see passContext option */
  function callValidate() {
    /* jshint validthis: true */
    var validate = compilation.validate;
    var result = validate.apply(this, arguments);
    callValidate.errors = validate.errors;
    return result;
  }

  function localCompile(_schema, _root, localRefs, baseId) {
    var isRoot = !_root || (_root && _root.schema == _schema);
    if (_root.schema != root.schema)
      return compile.call(self, _schema, _root, localRefs, baseId);

    var $async = _schema.$async === true;

    var sourceCode = validateGenerator({
      isTop: true,
      schema: _schema,
      isRoot: isRoot,
      baseId: baseId,
      root: _root,
      schemaPath: '',
      errSchemaPath: '#',
      errorPath: '""',
      MissingRefError: errorClasses.MissingRef,
      RULES: RULES,
      validate: validateGenerator,
      util: util,
      resolve: resolve,
      resolveRef: resolveRef,
      usePattern: usePattern,
      useDefault: useDefault,
      useCustomRule: useCustomRule,
      opts: opts,
      formats: formats,
      logger: self.logger,
      self: self
    });

    sourceCode = vars(refVal, refValCode) + vars(patterns, patternCode)
                   + vars(defaults, defaultCode) + vars(customRules, customRuleCode)
                   + sourceCode;

    if (opts.processCode) sourceCode = opts.processCode(sourceCode, _schema);
    // console.log('\n\n\n *** \n', JSON.stringify(sourceCode));
    var validate;
    try {
      var makeValidate = new Function(
        'self',
        'RULES',
        'formats',
        'root',
        'refVal',
        'defaults',
        'customRules',
        'equal',
        'ucs2length',
        'ValidationError',
        sourceCode
      );

      validate = makeValidate(
        self,
        RULES,
        formats,
        root,
        refVal,
        defaults,
        customRules,
        equal,
        ucs2length,
        ValidationError
      );

      refVal[0] = validate;
    } catch(e) {
      self.logger.error('Error compiling schema, function code:', sourceCode);
      throw e;
    }

    validate.schema = _schema;
    validate.errors = null;
    validate.refs = refs;
    validate.refVal = refVal;
    validate.root = isRoot ? validate : _root;
    if ($async) validate.$async = true;
    if (opts.sourceCode === true) {
      validate.source = {
        code: sourceCode,
        patterns: patterns,
        defaults: defaults
      };
    }

    return validate;
  }

  function resolveRef(baseId, ref, isRoot) {
    ref = resolve.url(baseId, ref);
    var refIndex = refs[ref];
    var _refVal, refCode;
    if (refIndex !== undefined) {
      _refVal = refVal[refIndex];
      refCode = 'refVal[' + refIndex + ']';
      return resolvedRef(_refVal, refCode);
    }
    if (!isRoot && root.refs) {
      var rootRefId = root.refs[ref];
      if (rootRefId !== undefined) {
        _refVal = root.refVal[rootRefId];
        refCode = addLocalRef(ref, _refVal);
        return resolvedRef(_refVal, refCode);
      }
    }

    refCode = addLocalRef(ref);
    var v = resolve.call(self, localCompile, root, ref);
    if (v === undefined) {
      var localSchema = localRefs && localRefs[ref];
      if (localSchema) {
        v = resolve.inlineRef(localSchema, opts.inlineRefs)
            ? localSchema
            : compile.call(self, localSchema, root, localRefs, baseId);
      }
    }

    if (v === undefined) {
      removeLocalRef(ref);
    } else {
      replaceLocalRef(ref, v);
      return resolvedRef(v, refCode);
    }
  }

  function addLocalRef(ref, v) {
    var refId = refVal.length;
    refVal[refId] = v;
    refs[ref] = refId;
    return 'refVal' + refId;
  }

  function removeLocalRef(ref) {
    delete refs[ref];
  }

  function replaceLocalRef(ref, v) {
    var refId = refs[ref];
    refVal[refId] = v;
  }

  function resolvedRef(refVal, code) {
    return typeof refVal == 'object' || typeof refVal == 'boolean'
            ? { code: code, schema: refVal, inline: true }
            : { code: code, $async: refVal && !!refVal.$async };
  }

  function usePattern(regexStr) {
    var index = patternsHash[regexStr];
    if (index === undefined) {
      index = patternsHash[regexStr] = patterns.length;
      patterns[index] = regexStr;
    }
    return 'pattern' + index;
  }

  function useDefault(value) {
    switch (typeof value) {
      case 'boolean':
      case 'number':
        return '' + value;
      case 'string':
        return util.toQuotedString(value);
      case 'object':
        if (value === null) return 'null';
        var valueStr = stableStringify(value);
        var index = defaultsHash[valueStr];
        if (index === undefined) {
          index = defaultsHash[valueStr] = defaults.length;
          defaults[index] = value;
        }
        return 'default' + index;
    }
  }

  function useCustomRule(rule, schema, parentSchema, it) {
    if (self._opts.validateSchema !== false) {
      var deps = rule.definition.dependencies;
      if (deps && !deps.every(function(keyword) {
        return Object.prototype.hasOwnProperty.call(parentSchema, keyword);
      }))
        throw new Error('parent schema must have all required keywords: ' + deps.join(','));

      var validateSchema = rule.definition.validateSchema;
      if (validateSchema) {
        var valid = validateSchema(schema);
        if (!valid) {
          var message = 'keyword schema is invalid: ' + self.errorsText(validateSchema.errors);
          if (self._opts.validateSchema == 'log') self.logger.error(message);
          else throw new Error(message);
        }
      }
    }

    var compile = rule.definition.compile
      , inline = rule.definition.inline
      , macro = rule.definition.macro;

    var validate;
    if (compile) {
      validate = compile.call(self, schema, parentSchema, it);
    } else if (macro) {
      validate = macro.call(self, schema, parentSchema, it);
      if (opts.validateSchema !== false) self.validateSchema(validate, true);
    } else if (inline) {
      validate = inline.call(self, it, rule.keyword, schema, parentSchema);
    } else {
      validate = rule.definition.validate;
      if (!validate) return;
    }

    if (validate === undefined)
      throw new Error('custom keyword "' + rule.keyword + '"failed to compile');

    var index = customRules.length;
    customRules[index] = validate;

    return {
      code: 'customRule' + index,
      validate: validate
    };
  }
}


/**
 * Checks if the schema is currently compiled
 * @this   Ajv
 * @param  {Object} schema schema to compile
 * @param  {Object} root root object
 * @param  {String} baseId base schema ID
 * @return {Object} object with properties "index" (compilation index) and "compiling" (boolean)
 */
function checkCompiling(schema, root, baseId) {
  /* jshint validthis: true */
  var index = compIndex.call(this, schema, root, baseId);
  if (index >= 0) return { index: index, compiling: true };
  index = this._compilations.length;
  this._compilations[index] = {
    schema: schema,
    root: root,
    baseId: baseId
  };
  return { index: index, compiling: false };
}


/**
 * Removes the schema from the currently compiled list
 * @this   Ajv
 * @param  {Object} schema schema to compile
 * @param  {Object} root root object
 * @param  {String} baseId base schema ID
 */
function endCompiling(schema, root, baseId) {
  /* jshint validthis: true */
  var i = compIndex.call(this, schema, root, baseId);
  if (i >= 0) this._compilations.splice(i, 1);
}


/**
 * Index of schema compilation in the currently compiled list
 * @this   Ajv
 * @param  {Object} schema schema to compile
 * @param  {Object} root root object
 * @param  {String} baseId base schema ID
 * @return {Integer} compilation index
 */
function compIndex(schema, root, baseId) {
  /* jshint validthis: true */
  for (var i=0; i<this._compilations.length; i++) {
    var c = this._compilations[i];
    if (c.schema == schema && c.root == root && c.baseId == baseId) return i;
  }
  return -1;
}


function patternCode(i, patterns) {
  return 'var pattern' + i + ' = new RegExp(' + util.toQuotedString(patterns[i]) + ');';
}


function defaultCode(i) {
  return 'var default' + i + ' = defaults[' + i + '];';
}


function refValCode(i, refVal) {
  return refVal[i] === undefined ? '' : 'var refVal' + i + ' = refVal[' + i + '];';
}


function customRuleCode(i) {
  return 'var customRule' + i + ' = customRules[' + i + '];';
}


function vars(arr, statement) {
  if (!arr.length) return '';
  var code = '';
  for (var i=0; i<arr.length; i++)
    code += statement(i, arr);
  return code;
}


/***/ }),

/***/ 83610:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var URI = __webpack_require__(60540)
  , equal = __webpack_require__(64063)
  , util = __webpack_require__(42889)
  , SchemaObject = __webpack_require__(74022)
  , traverse = __webpack_require__(49461);

module.exports = resolve;

resolve.normalizeId = normalizeId;
resolve.fullPath = getFullPath;
resolve.url = resolveUrl;
resolve.ids = resolveIds;
resolve.inlineRef = inlineRef;
resolve.schema = resolveSchema;

/**
 * [resolve and compile the references ($ref)]
 * @this   Ajv
 * @param  {Function} compile reference to schema compilation funciton (localCompile)
 * @param  {Object} root object with information about the root schema for the current schema
 * @param  {String} ref reference to resolve
 * @return {Object|Function} schema object (if the schema can be inlined) or validation function
 */
function resolve(compile, root, ref) {
  /* jshint validthis: true */
  var refVal = this._refs[ref];
  if (typeof refVal == 'string') {
    if (this._refs[refVal]) refVal = this._refs[refVal];
    else return resolve.call(this, compile, root, refVal);
  }

  refVal = refVal || this._schemas[ref];
  if (refVal instanceof SchemaObject) {
    return inlineRef(refVal.schema, this._opts.inlineRefs)
            ? refVal.schema
            : refVal.validate || this._compile(refVal);
  }

  var res = resolveSchema.call(this, root, ref);
  var schema, v, baseId;
  if (res) {
    schema = res.schema;
    root = res.root;
    baseId = res.baseId;
  }

  if (schema instanceof SchemaObject) {
    v = schema.validate || compile.call(this, schema.schema, root, undefined, baseId);
  } else if (schema !== undefined) {
    v = inlineRef(schema, this._opts.inlineRefs)
        ? schema
        : compile.call(this, schema, root, undefined, baseId);
  }

  return v;
}


/**
 * Resolve schema, its root and baseId
 * @this Ajv
 * @param  {Object} root root object with properties schema, refVal, refs
 * @param  {String} ref  reference to resolve
 * @return {Object} object with properties schema, root, baseId
 */
function resolveSchema(root, ref) {
  /* jshint validthis: true */
  var p = URI.parse(ref)
    , refPath = _getFullPath(p)
    , baseId = getFullPath(this._getId(root.schema));
  if (Object.keys(root.schema).length === 0 || refPath !== baseId) {
    var id = normalizeId(refPath);
    var refVal = this._refs[id];
    if (typeof refVal == 'string') {
      return resolveRecursive.call(this, root, refVal, p);
    } else if (refVal instanceof SchemaObject) {
      if (!refVal.validate) this._compile(refVal);
      root = refVal;
    } else {
      refVal = this._schemas[id];
      if (refVal instanceof SchemaObject) {
        if (!refVal.validate) this._compile(refVal);
        if (id == normalizeId(ref))
          return { schema: refVal, root: root, baseId: baseId };
        root = refVal;
      } else {
        return;
      }
    }
    if (!root.schema) return;
    baseId = getFullPath(this._getId(root.schema));
  }
  return getJsonPointer.call(this, p, baseId, root.schema, root);
}


/* @this Ajv */
function resolveRecursive(root, ref, parsedRef) {
  /* jshint validthis: true */
  var res = resolveSchema.call(this, root, ref);
  if (res) {
    var schema = res.schema;
    var baseId = res.baseId;
    root = res.root;
    var id = this._getId(schema);
    if (id) baseId = resolveUrl(baseId, id);
    return getJsonPointer.call(this, parsedRef, baseId, schema, root);
  }
}


var PREVENT_SCOPE_CHANGE = util.toHash(['properties', 'patternProperties', 'enum', 'dependencies', 'definitions']);
/* @this Ajv */
function getJsonPointer(parsedRef, baseId, schema, root) {
  /* jshint validthis: true */
  parsedRef.fragment = parsedRef.fragment || '';
  if (parsedRef.fragment.slice(0,1) != '/') return;
  var parts = parsedRef.fragment.split('/');

  for (var i = 1; i < parts.length; i++) {
    var part = parts[i];
    if (part) {
      part = util.unescapeFragment(part);
      schema = schema[part];
      if (schema === undefined) break;
      var id;
      if (!PREVENT_SCOPE_CHANGE[part]) {
        id = this._getId(schema);
        if (id) baseId = resolveUrl(baseId, id);
        if (schema.$ref) {
          var $ref = resolveUrl(baseId, schema.$ref);
          var res = resolveSchema.call(this, root, $ref);
          if (res) {
            schema = res.schema;
            root = res.root;
            baseId = res.baseId;
          }
        }
      }
    }
  }
  if (schema !== undefined && schema !== root.schema)
    return { schema: schema, root: root, baseId: baseId };
}


var SIMPLE_INLINED = util.toHash([
  'type', 'format', 'pattern',
  'maxLength', 'minLength',
  'maxProperties', 'minProperties',
  'maxItems', 'minItems',
  'maximum', 'minimum',
  'uniqueItems', 'multipleOf',
  'required', 'enum'
]);
function inlineRef(schema, limit) {
  if (limit === false) return false;
  if (limit === undefined || limit === true) return checkNoRef(schema);
  else if (limit) return countKeys(schema) <= limit;
}


function checkNoRef(schema) {
  var item;
  if (Array.isArray(schema)) {
    for (var i=0; i<schema.length; i++) {
      item = schema[i];
      if (typeof item == 'object' && !checkNoRef(item)) return false;
    }
  } else {
    for (var key in schema) {
      if (key == '$ref') return false;
      item = schema[key];
      if (typeof item == 'object' && !checkNoRef(item)) return false;
    }
  }
  return true;
}


function countKeys(schema) {
  var count = 0, item;
  if (Array.isArray(schema)) {
    for (var i=0; i<schema.length; i++) {
      item = schema[i];
      if (typeof item == 'object') count += countKeys(item);
      if (count == Infinity) return Infinity;
    }
  } else {
    for (var key in schema) {
      if (key == '$ref') return Infinity;
      if (SIMPLE_INLINED[key]) {
        count++;
      } else {
        item = schema[key];
        if (typeof item == 'object') count += countKeys(item) + 1;
        if (count == Infinity) return Infinity;
      }
    }
  }
  return count;
}


function getFullPath(id, normalize) {
  if (normalize !== false) id = normalizeId(id);
  var p = URI.parse(id);
  return _getFullPath(p);
}


function _getFullPath(p) {
  return URI.serialize(p).split('#')[0] + '#';
}


var TRAILING_SLASH_HASH = /#\/?$/;
function normalizeId(id) {
  return id ? id.replace(TRAILING_SLASH_HASH, '') : '';
}


function resolveUrl(baseId, id) {
  id = normalizeId(id);
  return URI.resolve(baseId, id);
}


/* @this Ajv */
function resolveIds(schema) {
  var schemaId = normalizeId(this._getId(schema));
  var baseIds = {'': schemaId};
  var fullPaths = {'': getFullPath(schemaId, false)};
  var localRefs = {};
  var self = this;

  traverse(schema, {allKeys: true}, function(sch, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex) {
    if (jsonPtr === '') return;
    var id = self._getId(sch);
    var baseId = baseIds[parentJsonPtr];
    var fullPath = fullPaths[parentJsonPtr] + '/' + parentKeyword;
    if (keyIndex !== undefined)
      fullPath += '/' + (typeof keyIndex == 'number' ? keyIndex : util.escapeFragment(keyIndex));

    if (typeof id == 'string') {
      id = baseId = normalizeId(baseId ? URI.resolve(baseId, id) : id);

      var refVal = self._refs[id];
      if (typeof refVal == 'string') refVal = self._refs[refVal];
      if (refVal && refVal.schema) {
        if (!equal(sch, refVal.schema))
          throw new Error('id "' + id + '" resolves to more than one schema');
      } else if (id != normalizeId(fullPath)) {
        if (id[0] == '#') {
          if (localRefs[id] && !equal(sch, localRefs[id]))
            throw new Error('id "' + id + '" resolves to more than one schema');
          localRefs[id] = sch;
        } else {
          self._refs[id] = fullPath;
        }
      }
    }
    baseIds[jsonPtr] = baseId;
    fullPaths[jsonPtr] = fullPath;
  });

  return localRefs;
}


/***/ }),

/***/ 47753:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var ruleModules = __webpack_require__(66674)
  , toHash = __webpack_require__(42889).toHash;

module.exports = function rules() {
  var RULES = [
    { type: 'number',
      rules: [ { 'maximum': ['exclusiveMaximum'] },
               { 'minimum': ['exclusiveMinimum'] }, 'multipleOf', 'format'] },
    { type: 'string',
      rules: [ 'maxLength', 'minLength', 'pattern', 'format' ] },
    { type: 'array',
      rules: [ 'maxItems', 'minItems', 'items', 'contains', 'uniqueItems' ] },
    { type: 'object',
      rules: [ 'maxProperties', 'minProperties', 'required', 'dependencies', 'propertyNames',
               { 'properties': ['additionalProperties', 'patternProperties'] } ] },
    { rules: [ '$ref', 'const', 'enum', 'not', 'anyOf', 'oneOf', 'allOf', 'if' ] }
  ];

  var ALL = [ 'type', '$comment' ];
  var KEYWORDS = [
    '$schema', '$id', 'id', '$data', '$async', 'title',
    'description', 'default', 'definitions',
    'examples', 'readOnly', 'writeOnly',
    'contentMediaType', 'contentEncoding',
    'additionalItems', 'then', 'else'
  ];
  var TYPES = [ 'number', 'integer', 'string', 'array', 'object', 'boolean', 'null' ];
  RULES.all = toHash(ALL);
  RULES.types = toHash(TYPES);

  RULES.forEach(function (group) {
    group.rules = group.rules.map(function (keyword) {
      var implKeywords;
      if (typeof keyword == 'object') {
        var key = Object.keys(keyword)[0];
        implKeywords = keyword[key];
        keyword = key;
        implKeywords.forEach(function (k) {
          ALL.push(k);
          RULES.all[k] = true;
        });
      }
      ALL.push(keyword);
      var rule = RULES.all[keyword] = {
        keyword: keyword,
        code: ruleModules[keyword],
        implements: implKeywords
      };
      return rule;
    });

    RULES.all.$comment = {
      keyword: '$comment',
      code: ruleModules.$comment
    };

    if (group.type) RULES.types[group.type] = group;
  });

  RULES.keywords = toHash(ALL.concat(KEYWORDS));
  RULES.custom = {};

  return RULES;
};


/***/ }),

/***/ 74022:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var util = __webpack_require__(42889);

module.exports = SchemaObject;

function SchemaObject(obj) {
  util.copy(obj, this);
}


/***/ }),

/***/ 4442:
/***/ ((module) => {

"use strict";


// https://mathiasbynens.be/notes/javascript-encoding
// https://github.com/bestiejs/punycode.js - punycode.ucs2.decode
module.exports = function ucs2length(str) {
  var length = 0
    , len = str.length
    , pos = 0
    , value;
  while (pos < len) {
    length++;
    value = str.charCodeAt(pos++);
    if (value >= 0xD800 && value <= 0xDBFF && pos < len) {
      // high surrogate, and there is a next character
      value = str.charCodeAt(pos);
      if ((value & 0xFC00) == 0xDC00) pos++; // low surrogate
    }
  }
  return length;
};


/***/ }),

/***/ 42889:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";



module.exports = {
  copy: copy,
  checkDataType: checkDataType,
  checkDataTypes: checkDataTypes,
  coerceToTypes: coerceToTypes,
  toHash: toHash,
  getProperty: getProperty,
  escapeQuotes: escapeQuotes,
  equal: __webpack_require__(64063),
  ucs2length: __webpack_require__(4442),
  varOccurences: varOccurences,
  varReplace: varReplace,
  schemaHasRules: schemaHasRules,
  schemaHasRulesExcept: schemaHasRulesExcept,
  schemaUnknownRules: schemaUnknownRules,
  toQuotedString: toQuotedString,
  getPathExpr: getPathExpr,
  getPath: getPath,
  getData: getData,
  unescapeFragment: unescapeFragment,
  unescapeJsonPointer: unescapeJsonPointer,
  escapeFragment: escapeFragment,
  escapeJsonPointer: escapeJsonPointer
};


function copy(o, to) {
  to = to || {};
  for (var key in o) to[key] = o[key];
  return to;
}


function checkDataType(dataType, data, strictNumbers, negate) {
  var EQUAL = negate ? ' !== ' : ' === '
    , AND = negate ? ' || ' : ' && '
    , OK = negate ? '!' : ''
    , NOT = negate ? '' : '!';
  switch (dataType) {
    case 'null': return data + EQUAL + 'null';
    case 'array': return OK + 'Array.isArray(' + data + ')';
    case 'object': return '(' + OK + data + AND +
                          'typeof ' + data + EQUAL + '"object"' + AND +
                          NOT + 'Array.isArray(' + data + '))';
    case 'integer': return '(typeof ' + data + EQUAL + '"number"' + AND +
                           NOT + '(' + data + ' % 1)' +
                           AND + data + EQUAL + data +
                           (strictNumbers ? (AND + OK + 'isFinite(' + data + ')') : '') + ')';
    case 'number': return '(typeof ' + data + EQUAL + '"' + dataType + '"' +
                          (strictNumbers ? (AND + OK + 'isFinite(' + data + ')') : '') + ')';
    default: return 'typeof ' + data + EQUAL + '"' + dataType + '"';
  }
}


function checkDataTypes(dataTypes, data, strictNumbers) {
  switch (dataTypes.length) {
    case 1: return checkDataType(dataTypes[0], data, strictNumbers, true);
    default:
      var code = '';
      var types = toHash(dataTypes);
      if (types.array && types.object) {
        code = types.null ? '(': '(!' + data + ' || ';
        code += 'typeof ' + data + ' !== "object")';
        delete types.null;
        delete types.array;
        delete types.object;
      }
      if (types.number) delete types.integer;
      for (var t in types)
        code += (code ? ' && ' : '' ) + checkDataType(t, data, strictNumbers, true);

      return code;
  }
}


var COERCE_TO_TYPES = toHash([ 'string', 'number', 'integer', 'boolean', 'null' ]);
function coerceToTypes(optionCoerceTypes, dataTypes) {
  if (Array.isArray(dataTypes)) {
    var types = [];
    for (var i=0; i<dataTypes.length; i++) {
      var t = dataTypes[i];
      if (COERCE_TO_TYPES[t]) types[types.length] = t;
      else if (optionCoerceTypes === 'array' && t === 'array') types[types.length] = t;
    }
    if (types.length) return types;
  } else if (COERCE_TO_TYPES[dataTypes]) {
    return [dataTypes];
  } else if (optionCoerceTypes === 'array' && dataTypes === 'array') {
    return ['array'];
  }
}


function toHash(arr) {
  var hash = {};
  for (var i=0; i<arr.length; i++) hash[arr[i]] = true;
  return hash;
}


var IDENTIFIER = /^[a-z$_][a-z$_0-9]*$/i;
var SINGLE_QUOTE = /'|\\/g;
function getProperty(key) {
  return typeof key == 'number'
          ? '[' + key + ']'
          : IDENTIFIER.test(key)
            ? '.' + key
            : "['" + escapeQuotes(key) + "']";
}


function escapeQuotes(str) {
  return str.replace(SINGLE_QUOTE, '\\$&')
            .replace(/\n/g, '\\n')
            .replace(/\r/g, '\\r')
            .replace(/\f/g, '\\f')
            .replace(/\t/g, '\\t');
}


function varOccurences(str, dataVar) {
  dataVar += '[^0-9]';
  var matches = str.match(new RegExp(dataVar, 'g'));
  return matches ? matches.length : 0;
}


function varReplace(str, dataVar, expr) {
  dataVar += '([^0-9])';
  expr = expr.replace(/\$/g, '$$$$');
  return str.replace(new RegExp(dataVar, 'g'), expr + '$1');
}


function schemaHasRules(schema, rules) {
  if (typeof schema == 'boolean') return !schema;
  for (var key in schema) if (rules[key]) return true;
}


function schemaHasRulesExcept(schema, rules, exceptKeyword) {
  if (typeof schema == 'boolean') return !schema && exceptKeyword != 'not';
  for (var key in schema) if (key != exceptKeyword && rules[key]) return true;
}


function schemaUnknownRules(schema, rules) {
  if (typeof schema == 'boolean') return;
  for (var key in schema) if (!rules[key]) return key;
}


function toQuotedString(str) {
  return '\'' + escapeQuotes(str) + '\'';
}


function getPathExpr(currentPath, expr, jsonPointers, isNumber) {
  var path = jsonPointers // false by default
              ? '\'/\' + ' + expr + (isNumber ? '' : '.replace(/~/g, \'~0\').replace(/\\//g, \'~1\')')
              : (isNumber ? '\'[\' + ' + expr + ' + \']\'' : '\'[\\\'\' + ' + expr + ' + \'\\\']\'');
  return joinPaths(currentPath, path);
}


function getPath(currentPath, prop, jsonPointers) {
  var path = jsonPointers // false by default
              ? toQuotedString('/' + escapeJsonPointer(prop))
              : toQuotedString(getProperty(prop));
  return joinPaths(currentPath, path);
}


var JSON_POINTER = /^\/(?:[^~]|~0|~1)*$/;
var RELATIVE_JSON_POINTER = /^([0-9]+)(#|\/(?:[^~]|~0|~1)*)?$/;
function getData($data, lvl, paths) {
  var up, jsonPointer, data, matches;
  if ($data === '') return 'rootData';
  if ($data[0] == '/') {
    if (!JSON_POINTER.test($data)) throw new Error('Invalid JSON-pointer: ' + $data);
    jsonPointer = $data;
    data = 'rootData';
  } else {
    matches = $data.match(RELATIVE_JSON_POINTER);
    if (!matches) throw new Error('Invalid JSON-pointer: ' + $data);
    up = +matches[1];
    jsonPointer = matches[2];
    if (jsonPointer == '#') {
      if (up >= lvl) throw new Error('Cannot access property/index ' + up + ' levels up, current level is ' + lvl);
      return paths[lvl - up];
    }

    if (up > lvl) throw new Error('Cannot access data ' + up + ' levels up, current level is ' + lvl);
    data = 'data' + ((lvl - up) || '');
    if (!jsonPointer) return data;
  }

  var expr = data;
  var segments = jsonPointer.split('/');
  for (var i=0; i<segments.length; i++) {
    var segment = segments[i];
    if (segment) {
      data += getProperty(unescapeJsonPointer(segment));
      expr += ' && ' + data;
    }
  }
  return expr;
}


function joinPaths (a, b) {
  if (a == '""') return b;
  return (a + ' + ' + b).replace(/([^\\])' \+ '/g, '$1');
}


function unescapeFragment(str) {
  return unescapeJsonPointer(decodeURIComponent(str));
}


function escapeFragment(str) {
  return encodeURIComponent(escapeJsonPointer(str));
}


function escapeJsonPointer(str) {
  return str.replace(/~/g, '~0').replace(/\//g, '~1');
}


function unescapeJsonPointer(str) {
  return str.replace(/~1/g, '/').replace(/~0/g, '~');
}


/***/ }),

/***/ 3978:
/***/ ((module) => {

"use strict";


var KEYWORDS = [
  'multipleOf',
  'maximum',
  'exclusiveMaximum',
  'minimum',
  'exclusiveMinimum',
  'maxLength',
  'minLength',
  'pattern',
  'additionalItems',
  'maxItems',
  'minItems',
  'uniqueItems',
  'maxProperties',
  'minProperties',
  'required',
  'additionalProperties',
  'enum',
  'format',
  'const'
];

module.exports = function (metaSchema, keywordsJsonPointers) {
  for (var i=0; i<keywordsJsonPointers.length; i++) {
    metaSchema = JSON.parse(JSON.stringify(metaSchema));
    var segments = keywordsJsonPointers[i].split('/');
    var keywords = metaSchema;
    var j;
    for (j=1; j<segments.length; j++)
      keywords = keywords[segments[j]];

    for (j=0; j<KEYWORDS.length; j++) {
      var key = KEYWORDS[j];
      var schema = keywords[key];
      if (schema) {
        keywords[key] = {
          anyOf: [
            schema,
            { $ref: 'https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#' }
          ]
        };
      }
    }
  }

  return metaSchema;
};


/***/ }),

/***/ 61128:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var metaSchema = __webpack_require__(40038);

module.exports = {
  $id: 'https://github.com/ajv-validator/ajv/blob/master/lib/definition_schema.js',
  definitions: {
    simpleTypes: metaSchema.definitions.simpleTypes
  },
  type: 'object',
  dependencies: {
    schema: ['validate'],
    $data: ['validate'],
    statements: ['inline'],
    valid: {not: {required: ['macro']}}
  },
  properties: {
    type: metaSchema.properties.type,
    schema: {type: 'boolean'},
    statements: {type: 'boolean'},
    dependencies: {
      type: 'array',
      items: {type: 'string'}
    },
    metaSchema: {type: 'object'},
    modifying: {type: 'boolean'},
    valid: {type: 'boolean'},
    $data: {type: 'boolean'},
    async: {type: 'boolean'},
    errors: {
      anyOf: [
        {type: 'boolean'},
        {const: 'full'}
      ]
    }
  }
};


/***/ }),

/***/ 18210:
/***/ ((module) => {

"use strict";

module.exports = function generate__limit(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $errorKeyword;
  var $data = 'data' + ($dataLvl || '');
  var $isData = it.opts.$data && $schema && $schema.$data,
    $schemaValue;
  if ($isData) {
    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
    $schemaValue = 'schema' + $lvl;
  } else {
    $schemaValue = $schema;
  }
  var $isMax = $keyword == 'maximum',
    $exclusiveKeyword = $isMax ? 'exclusiveMaximum' : 'exclusiveMinimum',
    $schemaExcl = it.schema[$exclusiveKeyword],
    $isDataExcl = it.opts.$data && $schemaExcl && $schemaExcl.$data,
    $op = $isMax ? '<' : '>',
    $notOp = $isMax ? '>' : '<',
    $errorKeyword = undefined;
  if (!($isData || typeof $schema == 'number' || $schema === undefined)) {
    throw new Error($keyword + ' must be number');
  }
  if (!($isDataExcl || $schemaExcl === undefined || typeof $schemaExcl == 'number' || typeof $schemaExcl == 'boolean')) {
    throw new Error($exclusiveKeyword + ' must be number or boolean');
  }
  if ($isDataExcl) {
    var $schemaValueExcl = it.util.getData($schemaExcl.$data, $dataLvl, it.dataPathArr),
      $exclusive = 'exclusive' + $lvl,
      $exclType = 'exclType' + $lvl,
      $exclIsNumber = 'exclIsNumber' + $lvl,
      $opExpr = 'op' + $lvl,
      $opStr = '\' + ' + $opExpr + ' + \'';
    out += ' var schemaExcl' + ($lvl) + ' = ' + ($schemaValueExcl) + '; ';
    $schemaValueExcl = 'schemaExcl' + $lvl;
    out += ' var ' + ($exclusive) + '; var ' + ($exclType) + ' = typeof ' + ($schemaValueExcl) + '; if (' + ($exclType) + ' != \'boolean\' && ' + ($exclType) + ' != \'undefined\' && ' + ($exclType) + ' != \'number\') { ';
    var $errorKeyword = $exclusiveKeyword;
    var $$outStack = $$outStack || [];
    $$outStack.push(out);
    out = ''; /* istanbul ignore else */
    if (it.createErrors !== false) {
      out += ' { keyword: \'' + ($errorKeyword || '_exclusiveLimit') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: {} ';
      if (it.opts.messages !== false) {
        out += ' , message: \'' + ($exclusiveKeyword) + ' should be boolean\' ';
      }
      if (it.opts.verbose) {
        out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
      }
      out += ' } ';
    } else {
      out += ' {} ';
    }
    var __err = out;
    out = $$outStack.pop();
    if (!it.compositeRule && $breakOnError) {
      /* istanbul ignore if */
      if (it.async) {
        out += ' throw new ValidationError([' + (__err) + ']); ';
      } else {
        out += ' validate.errors = [' + (__err) + ']; return false; ';
      }
    } else {
      out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
    }
    out += ' } else if ( ';
    if ($isData) {
      out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'number\') || ';
    }
    out += ' ' + ($exclType) + ' == \'number\' ? ( (' + ($exclusive) + ' = ' + ($schemaValue) + ' === undefined || ' + ($schemaValueExcl) + ' ' + ($op) + '= ' + ($schemaValue) + ') ? ' + ($data) + ' ' + ($notOp) + '= ' + ($schemaValueExcl) + ' : ' + ($data) + ' ' + ($notOp) + ' ' + ($schemaValue) + ' ) : ( (' + ($exclusive) + ' = ' + ($schemaValueExcl) + ' === true) ? ' + ($data) + ' ' + ($notOp) + '= ' + ($schemaValue) + ' : ' + ($data) + ' ' + ($notOp) + ' ' + ($schemaValue) + ' ) || ' + ($data) + ' !== ' + ($data) + ') { var op' + ($lvl) + ' = ' + ($exclusive) + ' ? \'' + ($op) + '\' : \'' + ($op) + '=\'; ';
    if ($schema === undefined) {
      $errorKeyword = $exclusiveKeyword;
      $errSchemaPath = it.errSchemaPath + '/' + $exclusiveKeyword;
      $schemaValue = $schemaValueExcl;
      $isData = $isDataExcl;
    }
  } else {
    var $exclIsNumber = typeof $schemaExcl == 'number',
      $opStr = $op;
    if ($exclIsNumber && $isData) {
      var $opExpr = '\'' + $opStr + '\'';
      out += ' if ( ';
      if ($isData) {
        out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'number\') || ';
      }
      out += ' ( ' + ($schemaValue) + ' === undefined || ' + ($schemaExcl) + ' ' + ($op) + '= ' + ($schemaValue) + ' ? ' + ($data) + ' ' + ($notOp) + '= ' + ($schemaExcl) + ' : ' + ($data) + ' ' + ($notOp) + ' ' + ($schemaValue) + ' ) || ' + ($data) + ' !== ' + ($data) + ') { ';
    } else {
      if ($exclIsNumber && $schema === undefined) {
        $exclusive = true;
        $errorKeyword = $exclusiveKeyword;
        $errSchemaPath = it.errSchemaPath + '/' + $exclusiveKeyword;
        $schemaValue = $schemaExcl;
        $notOp += '=';
      } else {
        if ($exclIsNumber) $schemaValue = Math[$isMax ? 'min' : 'max']($schemaExcl, $schema);
        if ($schemaExcl === ($exclIsNumber ? $schemaValue : true)) {
          $exclusive = true;
          $errorKeyword = $exclusiveKeyword;
          $errSchemaPath = it.errSchemaPath + '/' + $exclusiveKeyword;
          $notOp += '=';
        } else {
          $exclusive = false;
          $opStr += '=';
        }
      }
      var $opExpr = '\'' + $opStr + '\'';
      out += ' if ( ';
      if ($isData) {
        out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'number\') || ';
      }
      out += ' ' + ($data) + ' ' + ($notOp) + ' ' + ($schemaValue) + ' || ' + ($data) + ' !== ' + ($data) + ') { ';
    }
  }
  $errorKeyword = $errorKeyword || $keyword;
  var $$outStack = $$outStack || [];
  $$outStack.push(out);
  out = ''; /* istanbul ignore else */
  if (it.createErrors !== false) {
    out += ' { keyword: \'' + ($errorKeyword || '_limit') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { comparison: ' + ($opExpr) + ', limit: ' + ($schemaValue) + ', exclusive: ' + ($exclusive) + ' } ';
    if (it.opts.messages !== false) {
      out += ' , message: \'should be ' + ($opStr) + ' ';
      if ($isData) {
        out += '\' + ' + ($schemaValue);
      } else {
        out += '' + ($schemaValue) + '\'';
      }
    }
    if (it.opts.verbose) {
      out += ' , schema:  ';
      if ($isData) {
        out += 'validate.schema' + ($schemaPath);
      } else {
        out += '' + ($schema);
      }
      out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
    }
    out += ' } ';
  } else {
    out += ' {} ';
  }
  var __err = out;
  out = $$outStack.pop();
  if (!it.compositeRule && $breakOnError) {
    /* istanbul ignore if */
    if (it.async) {
      out += ' throw new ValidationError([' + (__err) + ']); ';
    } else {
      out += ' validate.errors = [' + (__err) + ']; return false; ';
    }
  } else {
    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
  }
  out += ' } ';
  if ($breakOnError) {
    out += ' else { ';
  }
  return out;
}


/***/ }),

/***/ 33038:
/***/ ((module) => {

"use strict";

module.exports = function generate__limitItems(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $errorKeyword;
  var $data = 'data' + ($dataLvl || '');
  var $isData = it.opts.$data && $schema && $schema.$data,
    $schemaValue;
  if ($isData) {
    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
    $schemaValue = 'schema' + $lvl;
  } else {
    $schemaValue = $schema;
  }
  if (!($isData || typeof $schema == 'number')) {
    throw new Error($keyword + ' must be number');
  }
  var $op = $keyword == 'maxItems' ? '>' : '<';
  out += 'if ( ';
  if ($isData) {
    out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'number\') || ';
  }
  out += ' ' + ($data) + '.length ' + ($op) + ' ' + ($schemaValue) + ') { ';
  var $errorKeyword = $keyword;
  var $$outStack = $$outStack || [];
  $$outStack.push(out);
  out = ''; /* istanbul ignore else */
  if (it.createErrors !== false) {
    out += ' { keyword: \'' + ($errorKeyword || '_limitItems') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { limit: ' + ($schemaValue) + ' } ';
    if (it.opts.messages !== false) {
      out += ' , message: \'should NOT have ';
      if ($keyword == 'maxItems') {
        out += 'more';
      } else {
        out += 'fewer';
      }
      out += ' than ';
      if ($isData) {
        out += '\' + ' + ($schemaValue) + ' + \'';
      } else {
        out += '' + ($schema);
      }
      out += ' items\' ';
    }
    if (it.opts.verbose) {
      out += ' , schema:  ';
      if ($isData) {
        out += 'validate.schema' + ($schemaPath);
      } else {
        out += '' + ($schema);
      }
      out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
    }
    out += ' } ';
  } else {
    out += ' {} ';
  }
  var __err = out;
  out = $$outStack.pop();
  if (!it.compositeRule && $breakOnError) {
    /* istanbul ignore if */
    if (it.async) {
      out += ' throw new ValidationError([' + (__err) + ']); ';
    } else {
      out += ' validate.errors = [' + (__err) + ']; return false; ';
    }
  } else {
    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
  }
  out += '} ';
  if ($breakOnError) {
    out += ' else { ';
  }
  return out;
}


/***/ }),

/***/ 80425:
/***/ ((module) => {

"use strict";

module.exports = function generate__limitLength(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $errorKeyword;
  var $data = 'data' + ($dataLvl || '');
  var $isData = it.opts.$data && $schema && $schema.$data,
    $schemaValue;
  if ($isData) {
    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
    $schemaValue = 'schema' + $lvl;
  } else {
    $schemaValue = $schema;
  }
  if (!($isData || typeof $schema == 'number')) {
    throw new Error($keyword + ' must be number');
  }
  var $op = $keyword == 'maxLength' ? '>' : '<';
  out += 'if ( ';
  if ($isData) {
    out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'number\') || ';
  }
  if (it.opts.unicode === false) {
    out += ' ' + ($data) + '.length ';
  } else {
    out += ' ucs2length(' + ($data) + ') ';
  }
  out += ' ' + ($op) + ' ' + ($schemaValue) + ') { ';
  var $errorKeyword = $keyword;
  var $$outStack = $$outStack || [];
  $$outStack.push(out);
  out = ''; /* istanbul ignore else */
  if (it.createErrors !== false) {
    out += ' { keyword: \'' + ($errorKeyword || '_limitLength') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { limit: ' + ($schemaValue) + ' } ';
    if (it.opts.messages !== false) {
      out += ' , message: \'should NOT be ';
      if ($keyword == 'maxLength') {
        out += 'longer';
      } else {
        out += 'shorter';
      }
      out += ' than ';
      if ($isData) {
        out += '\' + ' + ($schemaValue) + ' + \'';
      } else {
        out += '' + ($schema);
      }
      out += ' characters\' ';
    }
    if (it.opts.verbose) {
      out += ' , schema:  ';
      if ($isData) {
        out += 'validate.schema' + ($schemaPath);
      } else {
        out += '' + ($schema);
      }
      out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
    }
    out += ' } ';
  } else {
    out += ' {} ';
  }
  var __err = out;
  out = $$outStack.pop();
  if (!it.compositeRule && $breakOnError) {
    /* istanbul ignore if */
    if (it.async) {
      out += ' throw new ValidationError([' + (__err) + ']); ';
    } else {
      out += ' validate.errors = [' + (__err) + ']; return false; ';
    }
  } else {
    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
  }
  out += '} ';
  if ($breakOnError) {
    out += ' else { ';
  }
  return out;
}


/***/ }),

/***/ 78204:
/***/ ((module) => {

"use strict";

module.exports = function generate__limitProperties(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $errorKeyword;
  var $data = 'data' + ($dataLvl || '');
  var $isData = it.opts.$data && $schema && $schema.$data,
    $schemaValue;
  if ($isData) {
    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
    $schemaValue = 'schema' + $lvl;
  } else {
    $schemaValue = $schema;
  }
  if (!($isData || typeof $schema == 'number')) {
    throw new Error($keyword + ' must be number');
  }
  var $op = $keyword == 'maxProperties' ? '>' : '<';
  out += 'if ( ';
  if ($isData) {
    out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'number\') || ';
  }
  out += ' Object.keys(' + ($data) + ').length ' + ($op) + ' ' + ($schemaValue) + ') { ';
  var $errorKeyword = $keyword;
  var $$outStack = $$outStack || [];
  $$outStack.push(out);
  out = ''; /* istanbul ignore else */
  if (it.createErrors !== false) {
    out += ' { keyword: \'' + ($errorKeyword || '_limitProperties') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { limit: ' + ($schemaValue) + ' } ';
    if (it.opts.messages !== false) {
      out += ' , message: \'should NOT have ';
      if ($keyword == 'maxProperties') {
        out += 'more';
      } else {
        out += 'fewer';
      }
      out += ' than ';
      if ($isData) {
        out += '\' + ' + ($schemaValue) + ' + \'';
      } else {
        out += '' + ($schema);
      }
      out += ' properties\' ';
    }
    if (it.opts.verbose) {
      out += ' , schema:  ';
      if ($isData) {
        out += 'validate.schema' + ($schemaPath);
      } else {
        out += '' + ($schema);
      }
      out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
    }
    out += ' } ';
  } else {
    out += ' {} ';
  }
  var __err = out;
  out = $$outStack.pop();
  if (!it.compositeRule && $breakOnError) {
    /* istanbul ignore if */
    if (it.async) {
      out += ' throw new ValidationError([' + (__err) + ']); ';
    } else {
      out += ' validate.errors = [' + (__err) + ']; return false; ';
    }
  } else {
    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
  }
  out += '} ';
  if ($breakOnError) {
    out += ' else { ';
  }
  return out;
}


/***/ }),

/***/ 42988:
/***/ ((module) => {

"use strict";

module.exports = function generate_allOf(it, $keyword, $ruleType) {
  var out = ' ';
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $it = it.util.copy(it);
  var $closingBraces = '';
  $it.level++;
  var $nextValid = 'valid' + $it.level;
  var $currentBaseId = $it.baseId,
    $allSchemasEmpty = true;
  var arr1 = $schema;
  if (arr1) {
    var $sch, $i = -1,
      l1 = arr1.length - 1;
    while ($i < l1) {
      $sch = arr1[$i += 1];
      if ((it.opts.strictKeywords ? (typeof $sch == 'object' && Object.keys($sch).length > 0) || $sch === false : it.util.schemaHasRules($sch, it.RULES.all))) {
        $allSchemasEmpty = false;
        $it.schema = $sch;
        $it.schemaPath = $schemaPath + '[' + $i + ']';
        $it.errSchemaPath = $errSchemaPath + '/' + $i;
        out += '  ' + (it.validate($it)) + ' ';
        $it.baseId = $currentBaseId;
        if ($breakOnError) {
          out += ' if (' + ($nextValid) + ') { ';
          $closingBraces += '}';
        }
      }
    }
  }
  if ($breakOnError) {
    if ($allSchemasEmpty) {
      out += ' if (true) { ';
    } else {
      out += ' ' + ($closingBraces.slice(0, -1)) + ' ';
    }
  }
  return out;
}


/***/ }),

/***/ 39996:
/***/ ((module) => {

"use strict";

module.exports = function generate_anyOf(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $valid = 'valid' + $lvl;
  var $errs = 'errs__' + $lvl;
  var $it = it.util.copy(it);
  var $closingBraces = '';
  $it.level++;
  var $nextValid = 'valid' + $it.level;
  var $noEmptySchema = $schema.every(function($sch) {
    return (it.opts.strictKeywords ? (typeof $sch == 'object' && Object.keys($sch).length > 0) || $sch === false : it.util.schemaHasRules($sch, it.RULES.all));
  });
  if ($noEmptySchema) {
    var $currentBaseId = $it.baseId;
    out += ' var ' + ($errs) + ' = errors; var ' + ($valid) + ' = false;  ';
    var $wasComposite = it.compositeRule;
    it.compositeRule = $it.compositeRule = true;
    var arr1 = $schema;
    if (arr1) {
      var $sch, $i = -1,
        l1 = arr1.length - 1;
      while ($i < l1) {
        $sch = arr1[$i += 1];
        $it.schema = $sch;
        $it.schemaPath = $schemaPath + '[' + $i + ']';
        $it.errSchemaPath = $errSchemaPath + '/' + $i;
        out += '  ' + (it.validate($it)) + ' ';
        $it.baseId = $currentBaseId;
        out += ' ' + ($valid) + ' = ' + ($valid) + ' || ' + ($nextValid) + '; if (!' + ($valid) + ') { ';
        $closingBraces += '}';
      }
    }
    it.compositeRule = $it.compositeRule = $wasComposite;
    out += ' ' + ($closingBraces) + ' if (!' + ($valid) + ') {   var err =   '; /* istanbul ignore else */
    if (it.createErrors !== false) {
      out += ' { keyword: \'' + ('anyOf') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: {} ';
      if (it.opts.messages !== false) {
        out += ' , message: \'should match some schema in anyOf\' ';
      }
      if (it.opts.verbose) {
        out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
      }
      out += ' } ';
    } else {
      out += ' {} ';
    }
    out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
    if (!it.compositeRule && $breakOnError) {
      /* istanbul ignore if */
      if (it.async) {
        out += ' throw new ValidationError(vErrors); ';
      } else {
        out += ' validate.errors = vErrors; return false; ';
      }
    }
    out += ' } else {  errors = ' + ($errs) + '; if (vErrors !== null) { if (' + ($errs) + ') vErrors.length = ' + ($errs) + '; else vErrors = null; } ';
    if (it.opts.allErrors) {
      out += ' } ';
    }
  } else {
    if ($breakOnError) {
      out += ' if (true) { ';
    }
  }
  return out;
}


/***/ }),

/***/ 57812:
/***/ ((module) => {

"use strict";

module.exports = function generate_comment(it, $keyword, $ruleType) {
  var out = ' ';
  var $schema = it.schema[$keyword];
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $comment = it.util.toQuotedString($schema);
  if (it.opts.$comment === true) {
    out += ' console.log(' + ($comment) + ');';
  } else if (typeof it.opts.$comment == 'function') {
    out += ' self._opts.$comment(' + ($comment) + ', ' + (it.util.toQuotedString($errSchemaPath)) + ', validate.root.schema);';
  }
  return out;
}


/***/ }),

/***/ 25306:
/***/ ((module) => {

"use strict";

module.exports = function generate_const(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $valid = 'valid' + $lvl;
  var $isData = it.opts.$data && $schema && $schema.$data,
    $schemaValue;
  if ($isData) {
    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
    $schemaValue = 'schema' + $lvl;
  } else {
    $schemaValue = $schema;
  }
  if (!$isData) {
    out += ' var schema' + ($lvl) + ' = validate.schema' + ($schemaPath) + ';';
  }
  out += 'var ' + ($valid) + ' = equal(' + ($data) + ', schema' + ($lvl) + '); if (!' + ($valid) + ') {   ';
  var $$outStack = $$outStack || [];
  $$outStack.push(out);
  out = ''; /* istanbul ignore else */
  if (it.createErrors !== false) {
    out += ' { keyword: \'' + ('const') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { allowedValue: schema' + ($lvl) + ' } ';
    if (it.opts.messages !== false) {
      out += ' , message: \'should be equal to constant\' ';
    }
    if (it.opts.verbose) {
      out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
    }
    out += ' } ';
  } else {
    out += ' {} ';
  }
  var __err = out;
  out = $$outStack.pop();
  if (!it.compositeRule && $breakOnError) {
    /* istanbul ignore if */
    if (it.async) {
      out += ' throw new ValidationError([' + (__err) + ']); ';
    } else {
      out += ' validate.errors = [' + (__err) + ']; return false; ';
    }
  } else {
    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
  }
  out += ' }';
  if ($breakOnError) {
    out += ' else { ';
  }
  return out;
}


/***/ }),

/***/ 2840:
/***/ ((module) => {

"use strict";

module.exports = function generate_contains(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $valid = 'valid' + $lvl;
  var $errs = 'errs__' + $lvl;
  var $it = it.util.copy(it);
  var $closingBraces = '';
  $it.level++;
  var $nextValid = 'valid' + $it.level;
  var $idx = 'i' + $lvl,
    $dataNxt = $it.dataLevel = it.dataLevel + 1,
    $nextData = 'data' + $dataNxt,
    $currentBaseId = it.baseId,
    $nonEmptySchema = (it.opts.strictKeywords ? (typeof $schema == 'object' && Object.keys($schema).length > 0) || $schema === false : it.util.schemaHasRules($schema, it.RULES.all));
  out += 'var ' + ($errs) + ' = errors;var ' + ($valid) + ';';
  if ($nonEmptySchema) {
    var $wasComposite = it.compositeRule;
    it.compositeRule = $it.compositeRule = true;
    $it.schema = $schema;
    $it.schemaPath = $schemaPath;
    $it.errSchemaPath = $errSchemaPath;
    out += ' var ' + ($nextValid) + ' = false; for (var ' + ($idx) + ' = 0; ' + ($idx) + ' < ' + ($data) + '.length; ' + ($idx) + '++) { ';
    $it.errorPath = it.util.getPathExpr(it.errorPath, $idx, it.opts.jsonPointers, true);
    var $passData = $data + '[' + $idx + ']';
    $it.dataPathArr[$dataNxt] = $idx;
    var $code = it.validate($it);
    $it.baseId = $currentBaseId;
    if (it.util.varOccurences($code, $nextData) < 2) {
      out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
    } else {
      out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
    }
    out += ' if (' + ($nextValid) + ') break; }  ';
    it.compositeRule = $it.compositeRule = $wasComposite;
    out += ' ' + ($closingBraces) + ' if (!' + ($nextValid) + ') {';
  } else {
    out += ' if (' + ($data) + '.length == 0) {';
  }
  var $$outStack = $$outStack || [];
  $$outStack.push(out);
  out = ''; /* istanbul ignore else */
  if (it.createErrors !== false) {
    out += ' { keyword: \'' + ('contains') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: {} ';
    if (it.opts.messages !== false) {
      out += ' , message: \'should contain a valid item\' ';
    }
    if (it.opts.verbose) {
      out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
    }
    out += ' } ';
  } else {
    out += ' {} ';
  }
  var __err = out;
  out = $$outStack.pop();
  if (!it.compositeRule && $breakOnError) {
    /* istanbul ignore if */
    if (it.async) {
      out += ' throw new ValidationError([' + (__err) + ']); ';
    } else {
      out += ' validate.errors = [' + (__err) + ']; return false; ';
    }
  } else {
    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
  }
  out += ' } else { ';
  if ($nonEmptySchema) {
    out += '  errors = ' + ($errs) + '; if (vErrors !== null) { if (' + ($errs) + ') vErrors.length = ' + ($errs) + '; else vErrors = null; } ';
  }
  if (it.opts.allErrors) {
    out += ' } ';
  }
  return out;
}


/***/ }),

/***/ 14165:
/***/ ((module) => {

"use strict";

module.exports = function generate_custom(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $errorKeyword;
  var $data = 'data' + ($dataLvl || '');
  var $valid = 'valid' + $lvl;
  var $errs = 'errs__' + $lvl;
  var $isData = it.opts.$data && $schema && $schema.$data,
    $schemaValue;
  if ($isData) {
    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
    $schemaValue = 'schema' + $lvl;
  } else {
    $schemaValue = $schema;
  }
  var $rule = this,
    $definition = 'definition' + $lvl,
    $rDef = $rule.definition,
    $closingBraces = '';
  var $compile, $inline, $macro, $ruleValidate, $validateCode;
  if ($isData && $rDef.$data) {
    $validateCode = 'keywordValidate' + $lvl;
    var $validateSchema = $rDef.validateSchema;
    out += ' var ' + ($definition) + ' = RULES.custom[\'' + ($keyword) + '\'].definition; var ' + ($validateCode) + ' = ' + ($definition) + '.validate;';
  } else {
    $ruleValidate = it.useCustomRule($rule, $schema, it.schema, it);
    if (!$ruleValidate) return;
    $schemaValue = 'validate.schema' + $schemaPath;
    $validateCode = $ruleValidate.code;
    $compile = $rDef.compile;
    $inline = $rDef.inline;
    $macro = $rDef.macro;
  }
  var $ruleErrs = $validateCode + '.errors',
    $i = 'i' + $lvl,
    $ruleErr = 'ruleErr' + $lvl,
    $asyncKeyword = $rDef.async;
  if ($asyncKeyword && !it.async) throw new Error('async keyword in sync schema');
  if (!($inline || $macro)) {
    out += '' + ($ruleErrs) + ' = null;';
  }
  out += 'var ' + ($errs) + ' = errors;var ' + ($valid) + ';';
  if ($isData && $rDef.$data) {
    $closingBraces += '}';
    out += ' if (' + ($schemaValue) + ' === undefined) { ' + ($valid) + ' = true; } else { ';
    if ($validateSchema) {
      $closingBraces += '}';
      out += ' ' + ($valid) + ' = ' + ($definition) + '.validateSchema(' + ($schemaValue) + '); if (' + ($valid) + ') { ';
    }
  }
  if ($inline) {
    if ($rDef.statements) {
      out += ' ' + ($ruleValidate.validate) + ' ';
    } else {
      out += ' ' + ($valid) + ' = ' + ($ruleValidate.validate) + '; ';
    }
  } else if ($macro) {
    var $it = it.util.copy(it);
    var $closingBraces = '';
    $it.level++;
    var $nextValid = 'valid' + $it.level;
    $it.schema = $ruleValidate.validate;
    $it.schemaPath = '';
    var $wasComposite = it.compositeRule;
    it.compositeRule = $it.compositeRule = true;
    var $code = it.validate($it).replace(/validate\.schema/g, $validateCode);
    it.compositeRule = $it.compositeRule = $wasComposite;
    out += ' ' + ($code);
  } else {
    var $$outStack = $$outStack || [];
    $$outStack.push(out);
    out = '';
    out += '  ' + ($validateCode) + '.call( ';
    if (it.opts.passContext) {
      out += 'this';
    } else {
      out += 'self';
    }
    if ($compile || $rDef.schema === false) {
      out += ' , ' + ($data) + ' ';
    } else {
      out += ' , ' + ($schemaValue) + ' , ' + ($data) + ' , validate.schema' + (it.schemaPath) + ' ';
    }
    out += ' , (dataPath || \'\')';
    if (it.errorPath != '""') {
      out += ' + ' + (it.errorPath);
    }
    var $parentData = $dataLvl ? 'data' + (($dataLvl - 1) || '') : 'parentData',
      $parentDataProperty = $dataLvl ? it.dataPathArr[$dataLvl] : 'parentDataProperty';
    out += ' , ' + ($parentData) + ' , ' + ($parentDataProperty) + ' , rootData )  ';
    var def_callRuleValidate = out;
    out = $$outStack.pop();
    if ($rDef.errors === false) {
      out += ' ' + ($valid) + ' = ';
      if ($asyncKeyword) {
        out += 'await ';
      }
      out += '' + (def_callRuleValidate) + '; ';
    } else {
      if ($asyncKeyword) {
        $ruleErrs = 'customErrors' + $lvl;
        out += ' var ' + ($ruleErrs) + ' = null; try { ' + ($valid) + ' = await ' + (def_callRuleValidate) + '; } catch (e) { ' + ($valid) + ' = false; if (e instanceof ValidationError) ' + ($ruleErrs) + ' = e.errors; else throw e; } ';
      } else {
        out += ' ' + ($ruleErrs) + ' = null; ' + ($valid) + ' = ' + (def_callRuleValidate) + '; ';
      }
    }
  }
  if ($rDef.modifying) {
    out += ' if (' + ($parentData) + ') ' + ($data) + ' = ' + ($parentData) + '[' + ($parentDataProperty) + '];';
  }
  out += '' + ($closingBraces);
  if ($rDef.valid) {
    if ($breakOnError) {
      out += ' if (true) { ';
    }
  } else {
    out += ' if ( ';
    if ($rDef.valid === undefined) {
      out += ' !';
      if ($macro) {
        out += '' + ($nextValid);
      } else {
        out += '' + ($valid);
      }
    } else {
      out += ' ' + (!$rDef.valid) + ' ';
    }
    out += ') { ';
    $errorKeyword = $rule.keyword;
    var $$outStack = $$outStack || [];
    $$outStack.push(out);
    out = '';
    var $$outStack = $$outStack || [];
    $$outStack.push(out);
    out = ''; /* istanbul ignore else */
    if (it.createErrors !== false) {
      out += ' { keyword: \'' + ($errorKeyword || 'custom') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { keyword: \'' + ($rule.keyword) + '\' } ';
      if (it.opts.messages !== false) {
        out += ' , message: \'should pass "' + ($rule.keyword) + '" keyword validation\' ';
      }
      if (it.opts.verbose) {
        out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
      }
      out += ' } ';
    } else {
      out += ' {} ';
    }
    var __err = out;
    out = $$outStack.pop();
    if (!it.compositeRule && $breakOnError) {
      /* istanbul ignore if */
      if (it.async) {
        out += ' throw new ValidationError([' + (__err) + ']); ';
      } else {
        out += ' validate.errors = [' + (__err) + ']; return false; ';
      }
    } else {
      out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
    }
    var def_customError = out;
    out = $$outStack.pop();
    if ($inline) {
      if ($rDef.errors) {
        if ($rDef.errors != 'full') {
          out += '  for (var ' + ($i) + '=' + ($errs) + '; ' + ($i) + '<errors; ' + ($i) + '++) { var ' + ($ruleErr) + ' = vErrors[' + ($i) + ']; if (' + ($ruleErr) + '.dataPath === undefined) ' + ($ruleErr) + '.dataPath = (dataPath || \'\') + ' + (it.errorPath) + '; if (' + ($ruleErr) + '.schemaPath === undefined) { ' + ($ruleErr) + '.schemaPath = "' + ($errSchemaPath) + '"; } ';
          if (it.opts.verbose) {
            out += ' ' + ($ruleErr) + '.schema = ' + ($schemaValue) + '; ' + ($ruleErr) + '.data = ' + ($data) + '; ';
          }
          out += ' } ';
        }
      } else {
        if ($rDef.errors === false) {
          out += ' ' + (def_customError) + ' ';
        } else {
          out += ' if (' + ($errs) + ' == errors) { ' + (def_customError) + ' } else {  for (var ' + ($i) + '=' + ($errs) + '; ' + ($i) + '<errors; ' + ($i) + '++) { var ' + ($ruleErr) + ' = vErrors[' + ($i) + ']; if (' + ($ruleErr) + '.dataPath === undefined) ' + ($ruleErr) + '.dataPath = (dataPath || \'\') + ' + (it.errorPath) + '; if (' + ($ruleErr) + '.schemaPath === undefined) { ' + ($ruleErr) + '.schemaPath = "' + ($errSchemaPath) + '"; } ';
          if (it.opts.verbose) {
            out += ' ' + ($ruleErr) + '.schema = ' + ($schemaValue) + '; ' + ($ruleErr) + '.data = ' + ($data) + '; ';
          }
          out += ' } } ';
        }
      }
    } else if ($macro) {
      out += '   var err =   '; /* istanbul ignore else */
      if (it.createErrors !== false) {
        out += ' { keyword: \'' + ($errorKeyword || 'custom') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { keyword: \'' + ($rule.keyword) + '\' } ';
        if (it.opts.messages !== false) {
          out += ' , message: \'should pass "' + ($rule.keyword) + '" keyword validation\' ';
        }
        if (it.opts.verbose) {
          out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
        }
        out += ' } ';
      } else {
        out += ' {} ';
      }
      out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
      if (!it.compositeRule && $breakOnError) {
        /* istanbul ignore if */
        if (it.async) {
          out += ' throw new ValidationError(vErrors); ';
        } else {
          out += ' validate.errors = vErrors; return false; ';
        }
      }
    } else {
      if ($rDef.errors === false) {
        out += ' ' + (def_customError) + ' ';
      } else {
        out += ' if (Array.isArray(' + ($ruleErrs) + ')) { if (vErrors === null) vErrors = ' + ($ruleErrs) + '; else vErrors = vErrors.concat(' + ($ruleErrs) + '); errors = vErrors.length;  for (var ' + ($i) + '=' + ($errs) + '; ' + ($i) + '<errors; ' + ($i) + '++) { var ' + ($ruleErr) + ' = vErrors[' + ($i) + ']; if (' + ($ruleErr) + '.dataPath === undefined) ' + ($ruleErr) + '.dataPath = (dataPath || \'\') + ' + (it.errorPath) + ';  ' + ($ruleErr) + '.schemaPath = "' + ($errSchemaPath) + '";  ';
        if (it.opts.verbose) {
          out += ' ' + ($ruleErr) + '.schema = ' + ($schemaValue) + '; ' + ($ruleErr) + '.data = ' + ($data) + '; ';
        }
        out += ' } } else { ' + (def_customError) + ' } ';
      }
    }
    out += ' } ';
    if ($breakOnError) {
      out += ' else { ';
    }
  }
  return out;
}


/***/ }),

/***/ 66659:
/***/ ((module) => {

"use strict";

module.exports = function generate_dependencies(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $errs = 'errs__' + $lvl;
  var $it = it.util.copy(it);
  var $closingBraces = '';
  $it.level++;
  var $nextValid = 'valid' + $it.level;
  var $schemaDeps = {},
    $propertyDeps = {},
    $ownProperties = it.opts.ownProperties;
  for ($property in $schema) {
    if ($property == '__proto__') continue;
    var $sch = $schema[$property];
    var $deps = Array.isArray($sch) ? $propertyDeps : $schemaDeps;
    $deps[$property] = $sch;
  }
  out += 'var ' + ($errs) + ' = errors;';
  var $currentErrorPath = it.errorPath;
  out += 'var missing' + ($lvl) + ';';
  for (var $property in $propertyDeps) {
    $deps = $propertyDeps[$property];
    if ($deps.length) {
      out += ' if ( ' + ($data) + (it.util.getProperty($property)) + ' !== undefined ';
      if ($ownProperties) {
        out += ' && Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($property)) + '\') ';
      }
      if ($breakOnError) {
        out += ' && ( ';
        var arr1 = $deps;
        if (arr1) {
          var $propertyKey, $i = -1,
            l1 = arr1.length - 1;
          while ($i < l1) {
            $propertyKey = arr1[$i += 1];
            if ($i) {
              out += ' || ';
            }
            var $prop = it.util.getProperty($propertyKey),
              $useData = $data + $prop;
            out += ' ( ( ' + ($useData) + ' === undefined ';
            if ($ownProperties) {
              out += ' || ! Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($propertyKey)) + '\') ';
            }
            out += ') && (missing' + ($lvl) + ' = ' + (it.util.toQuotedString(it.opts.jsonPointers ? $propertyKey : $prop)) + ') ) ';
          }
        }
        out += ')) {  ';
        var $propertyPath = 'missing' + $lvl,
          $missingProperty = '\' + ' + $propertyPath + ' + \'';
        if (it.opts._errorDataPathProperty) {
          it.errorPath = it.opts.jsonPointers ? it.util.getPathExpr($currentErrorPath, $propertyPath, true) : $currentErrorPath + ' + ' + $propertyPath;
        }
        var $$outStack = $$outStack || [];
        $$outStack.push(out);
        out = ''; /* istanbul ignore else */
        if (it.createErrors !== false) {
          out += ' { keyword: \'' + ('dependencies') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { property: \'' + (it.util.escapeQuotes($property)) + '\', missingProperty: \'' + ($missingProperty) + '\', depsCount: ' + ($deps.length) + ', deps: \'' + (it.util.escapeQuotes($deps.length == 1 ? $deps[0] : $deps.join(", "))) + '\' } ';
          if (it.opts.messages !== false) {
            out += ' , message: \'should have ';
            if ($deps.length == 1) {
              out += 'property ' + (it.util.escapeQuotes($deps[0]));
            } else {
              out += 'properties ' + (it.util.escapeQuotes($deps.join(", ")));
            }
            out += ' when property ' + (it.util.escapeQuotes($property)) + ' is present\' ';
          }
          if (it.opts.verbose) {
            out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
          }
          out += ' } ';
        } else {
          out += ' {} ';
        }
        var __err = out;
        out = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) {
          /* istanbul ignore if */
          if (it.async) {
            out += ' throw new ValidationError([' + (__err) + ']); ';
          } else {
            out += ' validate.errors = [' + (__err) + ']; return false; ';
          }
        } else {
          out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
        }
      } else {
        out += ' ) { ';
        var arr2 = $deps;
        if (arr2) {
          var $propertyKey, i2 = -1,
            l2 = arr2.length - 1;
          while (i2 < l2) {
            $propertyKey = arr2[i2 += 1];
            var $prop = it.util.getProperty($propertyKey),
              $missingProperty = it.util.escapeQuotes($propertyKey),
              $useData = $data + $prop;
            if (it.opts._errorDataPathProperty) {
              it.errorPath = it.util.getPath($currentErrorPath, $propertyKey, it.opts.jsonPointers);
            }
            out += ' if ( ' + ($useData) + ' === undefined ';
            if ($ownProperties) {
              out += ' || ! Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($propertyKey)) + '\') ';
            }
            out += ') {  var err =   '; /* istanbul ignore else */
            if (it.createErrors !== false) {
              out += ' { keyword: \'' + ('dependencies') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { property: \'' + (it.util.escapeQuotes($property)) + '\', missingProperty: \'' + ($missingProperty) + '\', depsCount: ' + ($deps.length) + ', deps: \'' + (it.util.escapeQuotes($deps.length == 1 ? $deps[0] : $deps.join(", "))) + '\' } ';
              if (it.opts.messages !== false) {
                out += ' , message: \'should have ';
                if ($deps.length == 1) {
                  out += 'property ' + (it.util.escapeQuotes($deps[0]));
                } else {
                  out += 'properties ' + (it.util.escapeQuotes($deps.join(", ")));
                }
                out += ' when property ' + (it.util.escapeQuotes($property)) + ' is present\' ';
              }
              if (it.opts.verbose) {
                out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
              }
              out += ' } ';
            } else {
              out += ' {} ';
            }
            out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } ';
          }
        }
      }
      out += ' }   ';
      if ($breakOnError) {
        $closingBraces += '}';
        out += ' else { ';
      }
    }
  }
  it.errorPath = $currentErrorPath;
  var $currentBaseId = $it.baseId;
  for (var $property in $schemaDeps) {
    var $sch = $schemaDeps[$property];
    if ((it.opts.strictKeywords ? (typeof $sch == 'object' && Object.keys($sch).length > 0) || $sch === false : it.util.schemaHasRules($sch, it.RULES.all))) {
      out += ' ' + ($nextValid) + ' = true; if ( ' + ($data) + (it.util.getProperty($property)) + ' !== undefined ';
      if ($ownProperties) {
        out += ' && Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($property)) + '\') ';
      }
      out += ') { ';
      $it.schema = $sch;
      $it.schemaPath = $schemaPath + it.util.getProperty($property);
      $it.errSchemaPath = $errSchemaPath + '/' + it.util.escapeFragment($property);
      out += '  ' + (it.validate($it)) + ' ';
      $it.baseId = $currentBaseId;
      out += ' }  ';
      if ($breakOnError) {
        out += ' if (' + ($nextValid) + ') { ';
        $closingBraces += '}';
      }
    }
  }
  if ($breakOnError) {
    out += '   ' + ($closingBraces) + ' if (' + ($errs) + ' == errors) {';
  }
  return out;
}


/***/ }),

/***/ 31740:
/***/ ((module) => {

"use strict";

module.exports = function generate_enum(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $valid = 'valid' + $lvl;
  var $isData = it.opts.$data && $schema && $schema.$data,
    $schemaValue;
  if ($isData) {
    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
    $schemaValue = 'schema' + $lvl;
  } else {
    $schemaValue = $schema;
  }
  var $i = 'i' + $lvl,
    $vSchema = 'schema' + $lvl;
  if (!$isData) {
    out += ' var ' + ($vSchema) + ' = validate.schema' + ($schemaPath) + ';';
  }
  out += 'var ' + ($valid) + ';';
  if ($isData) {
    out += ' if (schema' + ($lvl) + ' === undefined) ' + ($valid) + ' = true; else if (!Array.isArray(schema' + ($lvl) + ')) ' + ($valid) + ' = false; else {';
  }
  out += '' + ($valid) + ' = false;for (var ' + ($i) + '=0; ' + ($i) + '<' + ($vSchema) + '.length; ' + ($i) + '++) if (equal(' + ($data) + ', ' + ($vSchema) + '[' + ($i) + '])) { ' + ($valid) + ' = true; break; }';
  if ($isData) {
    out += '  }  ';
  }
  out += ' if (!' + ($valid) + ') {   ';
  var $$outStack = $$outStack || [];
  $$outStack.push(out);
  out = ''; /* istanbul ignore else */
  if (it.createErrors !== false) {
    out += ' { keyword: \'' + ('enum') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { allowedValues: schema' + ($lvl) + ' } ';
    if (it.opts.messages !== false) {
      out += ' , message: \'should be equal to one of the allowed values\' ';
    }
    if (it.opts.verbose) {
      out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
    }
    out += ' } ';
  } else {
    out += ' {} ';
  }
  var __err = out;
  out = $$outStack.pop();
  if (!it.compositeRule && $breakOnError) {
    /* istanbul ignore if */
    if (it.async) {
      out += ' throw new ValidationError([' + (__err) + ']); ';
    } else {
      out += ' validate.errors = [' + (__err) + ']; return false; ';
    }
  } else {
    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
  }
  out += ' }';
  if ($breakOnError) {
    out += ' else { ';
  }
  return out;
}


/***/ }),

/***/ 39014:
/***/ ((module) => {

"use strict";

module.exports = function generate_format(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  if (it.opts.format === false) {
    if ($breakOnError) {
      out += ' if (true) { ';
    }
    return out;
  }
  var $isData = it.opts.$data && $schema && $schema.$data,
    $schemaValue;
  if ($isData) {
    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
    $schemaValue = 'schema' + $lvl;
  } else {
    $schemaValue = $schema;
  }
  var $unknownFormats = it.opts.unknownFormats,
    $allowUnknown = Array.isArray($unknownFormats);
  if ($isData) {
    var $format = 'format' + $lvl,
      $isObject = 'isObject' + $lvl,
      $formatType = 'formatType' + $lvl;
    out += ' var ' + ($format) + ' = formats[' + ($schemaValue) + ']; var ' + ($isObject) + ' = typeof ' + ($format) + ' == \'object\' && !(' + ($format) + ' instanceof RegExp) && ' + ($format) + '.validate; var ' + ($formatType) + ' = ' + ($isObject) + ' && ' + ($format) + '.type || \'string\'; if (' + ($isObject) + ') { ';
    if (it.async) {
      out += ' var async' + ($lvl) + ' = ' + ($format) + '.async; ';
    }
    out += ' ' + ($format) + ' = ' + ($format) + '.validate; } if (  ';
    if ($isData) {
      out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'string\') || ';
    }
    out += ' (';
    if ($unknownFormats != 'ignore') {
      out += ' (' + ($schemaValue) + ' && !' + ($format) + ' ';
      if ($allowUnknown) {
        out += ' && self._opts.unknownFormats.indexOf(' + ($schemaValue) + ') == -1 ';
      }
      out += ') || ';
    }
    out += ' (' + ($format) + ' && ' + ($formatType) + ' == \'' + ($ruleType) + '\' && !(typeof ' + ($format) + ' == \'function\' ? ';
    if (it.async) {
      out += ' (async' + ($lvl) + ' ? await ' + ($format) + '(' + ($data) + ') : ' + ($format) + '(' + ($data) + ')) ';
    } else {
      out += ' ' + ($format) + '(' + ($data) + ') ';
    }
    out += ' : ' + ($format) + '.test(' + ($data) + '))))) {';
  } else {
    var $format = it.formats[$schema];
    if (!$format) {
      if ($unknownFormats == 'ignore') {
        it.logger.warn('unknown format "' + $schema + '" ignored in schema at path "' + it.errSchemaPath + '"');
        if ($breakOnError) {
          out += ' if (true) { ';
        }
        return out;
      } else if ($allowUnknown && $unknownFormats.indexOf($schema) >= 0) {
        if ($breakOnError) {
          out += ' if (true) { ';
        }
        return out;
      } else {
        throw new Error('unknown format "' + $schema + '" is used in schema at path "' + it.errSchemaPath + '"');
      }
    }
    var $isObject = typeof $format == 'object' && !($format instanceof RegExp) && $format.validate;
    var $formatType = $isObject && $format.type || 'string';
    if ($isObject) {
      var $async = $format.async === true;
      $format = $format.validate;
    }
    if ($formatType != $ruleType) {
      if ($breakOnError) {
        out += ' if (true) { ';
      }
      return out;
    }
    if ($async) {
      if (!it.async) throw new Error('async format in sync schema');
      var $formatRef = 'formats' + it.util.getProperty($schema) + '.validate';
      out += ' if (!(await ' + ($formatRef) + '(' + ($data) + '))) { ';
    } else {
      out += ' if (! ';
      var $formatRef = 'formats' + it.util.getProperty($schema);
      if ($isObject) $formatRef += '.validate';
      if (typeof $format == 'function') {
        out += ' ' + ($formatRef) + '(' + ($data) + ') ';
      } else {
        out += ' ' + ($formatRef) + '.test(' + ($data) + ') ';
      }
      out += ') { ';
    }
  }
  var $$outStack = $$outStack || [];
  $$outStack.push(out);
  out = ''; /* istanbul ignore else */
  if (it.createErrors !== false) {
    out += ' { keyword: \'' + ('format') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { format:  ';
    if ($isData) {
      out += '' + ($schemaValue);
    } else {
      out += '' + (it.util.toQuotedString($schema));
    }
    out += '  } ';
    if (it.opts.messages !== false) {
      out += ' , message: \'should match format "';
      if ($isData) {
        out += '\' + ' + ($schemaValue) + ' + \'';
      } else {
        out += '' + (it.util.escapeQuotes($schema));
      }
      out += '"\' ';
    }
    if (it.opts.verbose) {
      out += ' , schema:  ';
      if ($isData) {
        out += 'validate.schema' + ($schemaPath);
      } else {
        out += '' + (it.util.toQuotedString($schema));
      }
      out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
    }
    out += ' } ';
  } else {
    out += ' {} ';
  }
  var __err = out;
  out = $$outStack.pop();
  if (!it.compositeRule && $breakOnError) {
    /* istanbul ignore if */
    if (it.async) {
      out += ' throw new ValidationError([' + (__err) + ']); ';
    } else {
      out += ' validate.errors = [' + (__err) + ']; return false; ';
    }
  } else {
    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
  }
  out += ' } ';
  if ($breakOnError) {
    out += ' else { ';
  }
  return out;
}


/***/ }),

/***/ 17231:
/***/ ((module) => {

"use strict";

module.exports = function generate_if(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $valid = 'valid' + $lvl;
  var $errs = 'errs__' + $lvl;
  var $it = it.util.copy(it);
  $it.level++;
  var $nextValid = 'valid' + $it.level;
  var $thenSch = it.schema['then'],
    $elseSch = it.schema['else'],
    $thenPresent = $thenSch !== undefined && (it.opts.strictKeywords ? (typeof $thenSch == 'object' && Object.keys($thenSch).length > 0) || $thenSch === false : it.util.schemaHasRules($thenSch, it.RULES.all)),
    $elsePresent = $elseSch !== undefined && (it.opts.strictKeywords ? (typeof $elseSch == 'object' && Object.keys($elseSch).length > 0) || $elseSch === false : it.util.schemaHasRules($elseSch, it.RULES.all)),
    $currentBaseId = $it.baseId;
  if ($thenPresent || $elsePresent) {
    var $ifClause;
    $it.createErrors = false;
    $it.schema = $schema;
    $it.schemaPath = $schemaPath;
    $it.errSchemaPath = $errSchemaPath;
    out += ' var ' + ($errs) + ' = errors; var ' + ($valid) + ' = true;  ';
    var $wasComposite = it.compositeRule;
    it.compositeRule = $it.compositeRule = true;
    out += '  ' + (it.validate($it)) + ' ';
    $it.baseId = $currentBaseId;
    $it.createErrors = true;
    out += '  errors = ' + ($errs) + '; if (vErrors !== null) { if (' + ($errs) + ') vErrors.length = ' + ($errs) + '; else vErrors = null; }  ';
    it.compositeRule = $it.compositeRule = $wasComposite;
    if ($thenPresent) {
      out += ' if (' + ($nextValid) + ') {  ';
      $it.schema = it.schema['then'];
      $it.schemaPath = it.schemaPath + '.then';
      $it.errSchemaPath = it.errSchemaPath + '/then';
      out += '  ' + (it.validate($it)) + ' ';
      $it.baseId = $currentBaseId;
      out += ' ' + ($valid) + ' = ' + ($nextValid) + '; ';
      if ($thenPresent && $elsePresent) {
        $ifClause = 'ifClause' + $lvl;
        out += ' var ' + ($ifClause) + ' = \'then\'; ';
      } else {
        $ifClause = '\'then\'';
      }
      out += ' } ';
      if ($elsePresent) {
        out += ' else { ';
      }
    } else {
      out += ' if (!' + ($nextValid) + ') { ';
    }
    if ($elsePresent) {
      $it.schema = it.schema['else'];
      $it.schemaPath = it.schemaPath + '.else';
      $it.errSchemaPath = it.errSchemaPath + '/else';
      out += '  ' + (it.validate($it)) + ' ';
      $it.baseId = $currentBaseId;
      out += ' ' + ($valid) + ' = ' + ($nextValid) + '; ';
      if ($thenPresent && $elsePresent) {
        $ifClause = 'ifClause' + $lvl;
        out += ' var ' + ($ifClause) + ' = \'else\'; ';
      } else {
        $ifClause = '\'else\'';
      }
      out += ' } ';
    }
    out += ' if (!' + ($valid) + ') {   var err =   '; /* istanbul ignore else */
    if (it.createErrors !== false) {
      out += ' { keyword: \'' + ('if') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { failingKeyword: ' + ($ifClause) + ' } ';
      if (it.opts.messages !== false) {
        out += ' , message: \'should match "\' + ' + ($ifClause) + ' + \'" schema\' ';
      }
      if (it.opts.verbose) {
        out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
      }
      out += ' } ';
    } else {
      out += ' {} ';
    }
    out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
    if (!it.compositeRule && $breakOnError) {
      /* istanbul ignore if */
      if (it.async) {
        out += ' throw new ValidationError(vErrors); ';
      } else {
        out += ' validate.errors = vErrors; return false; ';
      }
    }
    out += ' }   ';
    if ($breakOnError) {
      out += ' else { ';
    }
  } else {
    if ($breakOnError) {
      out += ' if (true) { ';
    }
  }
  return out;
}


/***/ }),

/***/ 66674:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


//all requires must be explicit because browserify won't work with dynamic requires
module.exports = {
  '$ref': __webpack_require__(62392),
  allOf: __webpack_require__(42988),
  anyOf: __webpack_require__(39996),
  '$comment': __webpack_require__(57812),
  const: __webpack_require__(25306),
  contains: __webpack_require__(2840),
  dependencies: __webpack_require__(66659),
  'enum': __webpack_require__(31740),
  format: __webpack_require__(39014),
  'if': __webpack_require__(17231),
  items: __webpack_require__(37482),
  maximum: __webpack_require__(18210),
  minimum: __webpack_require__(18210),
  maxItems: __webpack_require__(33038),
  minItems: __webpack_require__(33038),
  maxLength: __webpack_require__(80425),
  minLength: __webpack_require__(80425),
  maxProperties: __webpack_require__(78204),
  minProperties: __webpack_require__(78204),
  multipleOf: __webpack_require__(43673),
  not: __webpack_require__(28528),
  oneOf: __webpack_require__(59709),
  pattern: __webpack_require__(49614),
  properties: __webpack_require__(81175),
  propertyNames: __webpack_require__(58441),
  required: __webpack_require__(71287),
  uniqueItems: __webpack_require__(3603),
  validate: __webpack_require__(19508)
};


/***/ }),

/***/ 37482:
/***/ ((module) => {

"use strict";

module.exports = function generate_items(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $valid = 'valid' + $lvl;
  var $errs = 'errs__' + $lvl;
  var $it = it.util.copy(it);
  var $closingBraces = '';
  $it.level++;
  var $nextValid = 'valid' + $it.level;
  var $idx = 'i' + $lvl,
    $dataNxt = $it.dataLevel = it.dataLevel + 1,
    $nextData = 'data' + $dataNxt,
    $currentBaseId = it.baseId;
  out += 'var ' + ($errs) + ' = errors;var ' + ($valid) + ';';
  if (Array.isArray($schema)) {
    var $additionalItems = it.schema.additionalItems;
    if ($additionalItems === false) {
      out += ' ' + ($valid) + ' = ' + ($data) + '.length <= ' + ($schema.length) + '; ';
      var $currErrSchemaPath = $errSchemaPath;
      $errSchemaPath = it.errSchemaPath + '/additionalItems';
      out += '  if (!' + ($valid) + ') {   ';
      var $$outStack = $$outStack || [];
      $$outStack.push(out);
      out = ''; /* istanbul ignore else */
      if (it.createErrors !== false) {
        out += ' { keyword: \'' + ('additionalItems') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { limit: ' + ($schema.length) + ' } ';
        if (it.opts.messages !== false) {
          out += ' , message: \'should NOT have more than ' + ($schema.length) + ' items\' ';
        }
        if (it.opts.verbose) {
          out += ' , schema: false , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
        }
        out += ' } ';
      } else {
        out += ' {} ';
      }
      var __err = out;
      out = $$outStack.pop();
      if (!it.compositeRule && $breakOnError) {
        /* istanbul ignore if */
        if (it.async) {
          out += ' throw new ValidationError([' + (__err) + ']); ';
        } else {
          out += ' validate.errors = [' + (__err) + ']; return false; ';
        }
      } else {
        out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
      }
      out += ' } ';
      $errSchemaPath = $currErrSchemaPath;
      if ($breakOnError) {
        $closingBraces += '}';
        out += ' else { ';
      }
    }
    var arr1 = $schema;
    if (arr1) {
      var $sch, $i = -1,
        l1 = arr1.length - 1;
      while ($i < l1) {
        $sch = arr1[$i += 1];
        if ((it.opts.strictKeywords ? (typeof $sch == 'object' && Object.keys($sch).length > 0) || $sch === false : it.util.schemaHasRules($sch, it.RULES.all))) {
          out += ' ' + ($nextValid) + ' = true; if (' + ($data) + '.length > ' + ($i) + ') { ';
          var $passData = $data + '[' + $i + ']';
          $it.schema = $sch;
          $it.schemaPath = $schemaPath + '[' + $i + ']';
          $it.errSchemaPath = $errSchemaPath + '/' + $i;
          $it.errorPath = it.util.getPathExpr(it.errorPath, $i, it.opts.jsonPointers, true);
          $it.dataPathArr[$dataNxt] = $i;
          var $code = it.validate($it);
          $it.baseId = $currentBaseId;
          if (it.util.varOccurences($code, $nextData) < 2) {
            out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
          } else {
            out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
          }
          out += ' }  ';
          if ($breakOnError) {
            out += ' if (' + ($nextValid) + ') { ';
            $closingBraces += '}';
          }
        }
      }
    }
    if (typeof $additionalItems == 'object' && (it.opts.strictKeywords ? (typeof $additionalItems == 'object' && Object.keys($additionalItems).length > 0) || $additionalItems === false : it.util.schemaHasRules($additionalItems, it.RULES.all))) {
      $it.schema = $additionalItems;
      $it.schemaPath = it.schemaPath + '.additionalItems';
      $it.errSchemaPath = it.errSchemaPath + '/additionalItems';
      out += ' ' + ($nextValid) + ' = true; if (' + ($data) + '.length > ' + ($schema.length) + ') {  for (var ' + ($idx) + ' = ' + ($schema.length) + '; ' + ($idx) + ' < ' + ($data) + '.length; ' + ($idx) + '++) { ';
      $it.errorPath = it.util.getPathExpr(it.errorPath, $idx, it.opts.jsonPointers, true);
      var $passData = $data + '[' + $idx + ']';
      $it.dataPathArr[$dataNxt] = $idx;
      var $code = it.validate($it);
      $it.baseId = $currentBaseId;
      if (it.util.varOccurences($code, $nextData) < 2) {
        out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
      } else {
        out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
      }
      if ($breakOnError) {
        out += ' if (!' + ($nextValid) + ') break; ';
      }
      out += ' } }  ';
      if ($breakOnError) {
        out += ' if (' + ($nextValid) + ') { ';
        $closingBraces += '}';
      }
    }
  } else if ((it.opts.strictKeywords ? (typeof $schema == 'object' && Object.keys($schema).length > 0) || $schema === false : it.util.schemaHasRules($schema, it.RULES.all))) {
    $it.schema = $schema;
    $it.schemaPath = $schemaPath;
    $it.errSchemaPath = $errSchemaPath;
    out += '  for (var ' + ($idx) + ' = ' + (0) + '; ' + ($idx) + ' < ' + ($data) + '.length; ' + ($idx) + '++) { ';
    $it.errorPath = it.util.getPathExpr(it.errorPath, $idx, it.opts.jsonPointers, true);
    var $passData = $data + '[' + $idx + ']';
    $it.dataPathArr[$dataNxt] = $idx;
    var $code = it.validate($it);
    $it.baseId = $currentBaseId;
    if (it.util.varOccurences($code, $nextData) < 2) {
      out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
    } else {
      out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
    }
    if ($breakOnError) {
      out += ' if (!' + ($nextValid) + ') break; ';
    }
    out += ' }';
  }
  if ($breakOnError) {
    out += ' ' + ($closingBraces) + ' if (' + ($errs) + ' == errors) {';
  }
  return out;
}


/***/ }),

/***/ 43673:
/***/ ((module) => {

"use strict";

module.exports = function generate_multipleOf(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $isData = it.opts.$data && $schema && $schema.$data,
    $schemaValue;
  if ($isData) {
    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
    $schemaValue = 'schema' + $lvl;
  } else {
    $schemaValue = $schema;
  }
  if (!($isData || typeof $schema == 'number')) {
    throw new Error($keyword + ' must be number');
  }
  out += 'var division' + ($lvl) + ';if (';
  if ($isData) {
    out += ' ' + ($schemaValue) + ' !== undefined && ( typeof ' + ($schemaValue) + ' != \'number\' || ';
  }
  out += ' (division' + ($lvl) + ' = ' + ($data) + ' / ' + ($schemaValue) + ', ';
  if (it.opts.multipleOfPrecision) {
    out += ' Math.abs(Math.round(division' + ($lvl) + ') - division' + ($lvl) + ') > 1e-' + (it.opts.multipleOfPrecision) + ' ';
  } else {
    out += ' division' + ($lvl) + ' !== parseInt(division' + ($lvl) + ') ';
  }
  out += ' ) ';
  if ($isData) {
    out += '  )  ';
  }
  out += ' ) {   ';
  var $$outStack = $$outStack || [];
  $$outStack.push(out);
  out = ''; /* istanbul ignore else */
  if (it.createErrors !== false) {
    out += ' { keyword: \'' + ('multipleOf') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { multipleOf: ' + ($schemaValue) + ' } ';
    if (it.opts.messages !== false) {
      out += ' , message: \'should be multiple of ';
      if ($isData) {
        out += '\' + ' + ($schemaValue);
      } else {
        out += '' + ($schemaValue) + '\'';
      }
    }
    if (it.opts.verbose) {
      out += ' , schema:  ';
      if ($isData) {
        out += 'validate.schema' + ($schemaPath);
      } else {
        out += '' + ($schema);
      }
      out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
    }
    out += ' } ';
  } else {
    out += ' {} ';
  }
  var __err = out;
  out = $$outStack.pop();
  if (!it.compositeRule && $breakOnError) {
    /* istanbul ignore if */
    if (it.async) {
      out += ' throw new ValidationError([' + (__err) + ']); ';
    } else {
      out += ' validate.errors = [' + (__err) + ']; return false; ';
    }
  } else {
    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
  }
  out += '} ';
  if ($breakOnError) {
    out += ' else { ';
  }
  return out;
}


/***/ }),

/***/ 28528:
/***/ ((module) => {

"use strict";

module.exports = function generate_not(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $errs = 'errs__' + $lvl;
  var $it = it.util.copy(it);
  $it.level++;
  var $nextValid = 'valid' + $it.level;
  if ((it.opts.strictKeywords ? (typeof $schema == 'object' && Object.keys($schema).length > 0) || $schema === false : it.util.schemaHasRules($schema, it.RULES.all))) {
    $it.schema = $schema;
    $it.schemaPath = $schemaPath;
    $it.errSchemaPath = $errSchemaPath;
    out += ' var ' + ($errs) + ' = errors;  ';
    var $wasComposite = it.compositeRule;
    it.compositeRule = $it.compositeRule = true;
    $it.createErrors = false;
    var $allErrorsOption;
    if ($it.opts.allErrors) {
      $allErrorsOption = $it.opts.allErrors;
      $it.opts.allErrors = false;
    }
    out += ' ' + (it.validate($it)) + ' ';
    $it.createErrors = true;
    if ($allErrorsOption) $it.opts.allErrors = $allErrorsOption;
    it.compositeRule = $it.compositeRule = $wasComposite;
    out += ' if (' + ($nextValid) + ') {   ';
    var $$outStack = $$outStack || [];
    $$outStack.push(out);
    out = ''; /* istanbul ignore else */
    if (it.createErrors !== false) {
      out += ' { keyword: \'' + ('not') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: {} ';
      if (it.opts.messages !== false) {
        out += ' , message: \'should NOT be valid\' ';
      }
      if (it.opts.verbose) {
        out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
      }
      out += ' } ';
    } else {
      out += ' {} ';
    }
    var __err = out;
    out = $$outStack.pop();
    if (!it.compositeRule && $breakOnError) {
      /* istanbul ignore if */
      if (it.async) {
        out += ' throw new ValidationError([' + (__err) + ']); ';
      } else {
        out += ' validate.errors = [' + (__err) + ']; return false; ';
      }
    } else {
      out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
    }
    out += ' } else {  errors = ' + ($errs) + '; if (vErrors !== null) { if (' + ($errs) + ') vErrors.length = ' + ($errs) + '; else vErrors = null; } ';
    if (it.opts.allErrors) {
      out += ' } ';
    }
  } else {
    out += '  var err =   '; /* istanbul ignore else */
    if (it.createErrors !== false) {
      out += ' { keyword: \'' + ('not') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: {} ';
      if (it.opts.messages !== false) {
        out += ' , message: \'should NOT be valid\' ';
      }
      if (it.opts.verbose) {
        out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
      }
      out += ' } ';
    } else {
      out += ' {} ';
    }
    out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
    if ($breakOnError) {
      out += ' if (false) { ';
    }
  }
  return out;
}


/***/ }),

/***/ 59709:
/***/ ((module) => {

"use strict";

module.exports = function generate_oneOf(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $valid = 'valid' + $lvl;
  var $errs = 'errs__' + $lvl;
  var $it = it.util.copy(it);
  var $closingBraces = '';
  $it.level++;
  var $nextValid = 'valid' + $it.level;
  var $currentBaseId = $it.baseId,
    $prevValid = 'prevValid' + $lvl,
    $passingSchemas = 'passingSchemas' + $lvl;
  out += 'var ' + ($errs) + ' = errors , ' + ($prevValid) + ' = false , ' + ($valid) + ' = false , ' + ($passingSchemas) + ' = null; ';
  var $wasComposite = it.compositeRule;
  it.compositeRule = $it.compositeRule = true;
  var arr1 = $schema;
  if (arr1) {
    var $sch, $i = -1,
      l1 = arr1.length - 1;
    while ($i < l1) {
      $sch = arr1[$i += 1];
      if ((it.opts.strictKeywords ? (typeof $sch == 'object' && Object.keys($sch).length > 0) || $sch === false : it.util.schemaHasRules($sch, it.RULES.all))) {
        $it.schema = $sch;
        $it.schemaPath = $schemaPath + '[' + $i + ']';
        $it.errSchemaPath = $errSchemaPath + '/' + $i;
        out += '  ' + (it.validate($it)) + ' ';
        $it.baseId = $currentBaseId;
      } else {
        out += ' var ' + ($nextValid) + ' = true; ';
      }
      if ($i) {
        out += ' if (' + ($nextValid) + ' && ' + ($prevValid) + ') { ' + ($valid) + ' = false; ' + ($passingSchemas) + ' = [' + ($passingSchemas) + ', ' + ($i) + ']; } else { ';
        $closingBraces += '}';
      }
      out += ' if (' + ($nextValid) + ') { ' + ($valid) + ' = ' + ($prevValid) + ' = true; ' + ($passingSchemas) + ' = ' + ($i) + '; }';
    }
  }
  it.compositeRule = $it.compositeRule = $wasComposite;
  out += '' + ($closingBraces) + 'if (!' + ($valid) + ') {   var err =   '; /* istanbul ignore else */
  if (it.createErrors !== false) {
    out += ' { keyword: \'' + ('oneOf') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { passingSchemas: ' + ($passingSchemas) + ' } ';
    if (it.opts.messages !== false) {
      out += ' , message: \'should match exactly one schema in oneOf\' ';
    }
    if (it.opts.verbose) {
      out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
    }
    out += ' } ';
  } else {
    out += ' {} ';
  }
  out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
  if (!it.compositeRule && $breakOnError) {
    /* istanbul ignore if */
    if (it.async) {
      out += ' throw new ValidationError(vErrors); ';
    } else {
      out += ' validate.errors = vErrors; return false; ';
    }
  }
  out += '} else {  errors = ' + ($errs) + '; if (vErrors !== null) { if (' + ($errs) + ') vErrors.length = ' + ($errs) + '; else vErrors = null; }';
  if (it.opts.allErrors) {
    out += ' } ';
  }
  return out;
}


/***/ }),

/***/ 49614:
/***/ ((module) => {

"use strict";

module.exports = function generate_pattern(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $isData = it.opts.$data && $schema && $schema.$data,
    $schemaValue;
  if ($isData) {
    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
    $schemaValue = 'schema' + $lvl;
  } else {
    $schemaValue = $schema;
  }
  var $regexp = $isData ? '(new RegExp(' + $schemaValue + '))' : it.usePattern($schema);
  out += 'if ( ';
  if ($isData) {
    out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'string\') || ';
  }
  out += ' !' + ($regexp) + '.test(' + ($data) + ') ) {   ';
  var $$outStack = $$outStack || [];
  $$outStack.push(out);
  out = ''; /* istanbul ignore else */
  if (it.createErrors !== false) {
    out += ' { keyword: \'' + ('pattern') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { pattern:  ';
    if ($isData) {
      out += '' + ($schemaValue);
    } else {
      out += '' + (it.util.toQuotedString($schema));
    }
    out += '  } ';
    if (it.opts.messages !== false) {
      out += ' , message: \'should match pattern "';
      if ($isData) {
        out += '\' + ' + ($schemaValue) + ' + \'';
      } else {
        out += '' + (it.util.escapeQuotes($schema));
      }
      out += '"\' ';
    }
    if (it.opts.verbose) {
      out += ' , schema:  ';
      if ($isData) {
        out += 'validate.schema' + ($schemaPath);
      } else {
        out += '' + (it.util.toQuotedString($schema));
      }
      out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
    }
    out += ' } ';
  } else {
    out += ' {} ';
  }
  var __err = out;
  out = $$outStack.pop();
  if (!it.compositeRule && $breakOnError) {
    /* istanbul ignore if */
    if (it.async) {
      out += ' throw new ValidationError([' + (__err) + ']); ';
    } else {
      out += ' validate.errors = [' + (__err) + ']; return false; ';
    }
  } else {
    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
  }
  out += '} ';
  if ($breakOnError) {
    out += ' else { ';
  }
  return out;
}


/***/ }),

/***/ 81175:
/***/ ((module) => {

"use strict";

module.exports = function generate_properties(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $errs = 'errs__' + $lvl;
  var $it = it.util.copy(it);
  var $closingBraces = '';
  $it.level++;
  var $nextValid = 'valid' + $it.level;
  var $key = 'key' + $lvl,
    $idx = 'idx' + $lvl,
    $dataNxt = $it.dataLevel = it.dataLevel + 1,
    $nextData = 'data' + $dataNxt,
    $dataProperties = 'dataProperties' + $lvl;
  var $schemaKeys = Object.keys($schema || {}).filter(notProto),
    $pProperties = it.schema.patternProperties || {},
    $pPropertyKeys = Object.keys($pProperties).filter(notProto),
    $aProperties = it.schema.additionalProperties,
    $someProperties = $schemaKeys.length || $pPropertyKeys.length,
    $noAdditional = $aProperties === false,
    $additionalIsSchema = typeof $aProperties == 'object' && Object.keys($aProperties).length,
    $removeAdditional = it.opts.removeAdditional,
    $checkAdditional = $noAdditional || $additionalIsSchema || $removeAdditional,
    $ownProperties = it.opts.ownProperties,
    $currentBaseId = it.baseId;
  var $required = it.schema.required;
  if ($required && !(it.opts.$data && $required.$data) && $required.length < it.opts.loopRequired) {
    var $requiredHash = it.util.toHash($required);
  }

  function notProto(p) {
    return p !== '__proto__';
  }
  out += 'var ' + ($errs) + ' = errors;var ' + ($nextValid) + ' = true;';
  if ($ownProperties) {
    out += ' var ' + ($dataProperties) + ' = undefined;';
  }
  if ($checkAdditional) {
    if ($ownProperties) {
      out += ' ' + ($dataProperties) + ' = ' + ($dataProperties) + ' || Object.keys(' + ($data) + '); for (var ' + ($idx) + '=0; ' + ($idx) + '<' + ($dataProperties) + '.length; ' + ($idx) + '++) { var ' + ($key) + ' = ' + ($dataProperties) + '[' + ($idx) + ']; ';
    } else {
      out += ' for (var ' + ($key) + ' in ' + ($data) + ') { ';
    }
    if ($someProperties) {
      out += ' var isAdditional' + ($lvl) + ' = !(false ';
      if ($schemaKeys.length) {
        if ($schemaKeys.length > 8) {
          out += ' || validate.schema' + ($schemaPath) + '.hasOwnProperty(' + ($key) + ') ';
        } else {
          var arr1 = $schemaKeys;
          if (arr1) {
            var $propertyKey, i1 = -1,
              l1 = arr1.length - 1;
            while (i1 < l1) {
              $propertyKey = arr1[i1 += 1];
              out += ' || ' + ($key) + ' == ' + (it.util.toQuotedString($propertyKey)) + ' ';
            }
          }
        }
      }
      if ($pPropertyKeys.length) {
        var arr2 = $pPropertyKeys;
        if (arr2) {
          var $pProperty, $i = -1,
            l2 = arr2.length - 1;
          while ($i < l2) {
            $pProperty = arr2[$i += 1];
            out += ' || ' + (it.usePattern($pProperty)) + '.test(' + ($key) + ') ';
          }
        }
      }
      out += ' ); if (isAdditional' + ($lvl) + ') { ';
    }
    if ($removeAdditional == 'all') {
      out += ' delete ' + ($data) + '[' + ($key) + ']; ';
    } else {
      var $currentErrorPath = it.errorPath;
      var $additionalProperty = '\' + ' + $key + ' + \'';
      if (it.opts._errorDataPathProperty) {
        it.errorPath = it.util.getPathExpr(it.errorPath, $key, it.opts.jsonPointers);
      }
      if ($noAdditional) {
        if ($removeAdditional) {
          out += ' delete ' + ($data) + '[' + ($key) + ']; ';
        } else {
          out += ' ' + ($nextValid) + ' = false; ';
          var $currErrSchemaPath = $errSchemaPath;
          $errSchemaPath = it.errSchemaPath + '/additionalProperties';
          var $$outStack = $$outStack || [];
          $$outStack.push(out);
          out = ''; /* istanbul ignore else */
          if (it.createErrors !== false) {
            out += ' { keyword: \'' + ('additionalProperties') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { additionalProperty: \'' + ($additionalProperty) + '\' } ';
            if (it.opts.messages !== false) {
              out += ' , message: \'';
              if (it.opts._errorDataPathProperty) {
                out += 'is an invalid additional property';
              } else {
                out += 'should NOT have additional properties';
              }
              out += '\' ';
            }
            if (it.opts.verbose) {
              out += ' , schema: false , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
            }
            out += ' } ';
          } else {
            out += ' {} ';
          }
          var __err = out;
          out = $$outStack.pop();
          if (!it.compositeRule && $breakOnError) {
            /* istanbul ignore if */
            if (it.async) {
              out += ' throw new ValidationError([' + (__err) + ']); ';
            } else {
              out += ' validate.errors = [' + (__err) + ']; return false; ';
            }
          } else {
            out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
          }
          $errSchemaPath = $currErrSchemaPath;
          if ($breakOnError) {
            out += ' break; ';
          }
        }
      } else if ($additionalIsSchema) {
        if ($removeAdditional == 'failing') {
          out += ' var ' + ($errs) + ' = errors;  ';
          var $wasComposite = it.compositeRule;
          it.compositeRule = $it.compositeRule = true;
          $it.schema = $aProperties;
          $it.schemaPath = it.schemaPath + '.additionalProperties';
          $it.errSchemaPath = it.errSchemaPath + '/additionalProperties';
          $it.errorPath = it.opts._errorDataPathProperty ? it.errorPath : it.util.getPathExpr(it.errorPath, $key, it.opts.jsonPointers);
          var $passData = $data + '[' + $key + ']';
          $it.dataPathArr[$dataNxt] = $key;
          var $code = it.validate($it);
          $it.baseId = $currentBaseId;
          if (it.util.varOccurences($code, $nextData) < 2) {
            out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
          } else {
            out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
          }
          out += ' if (!' + ($nextValid) + ') { errors = ' + ($errs) + '; if (validate.errors !== null) { if (errors) validate.errors.length = errors; else validate.errors = null; } delete ' + ($data) + '[' + ($key) + ']; }  ';
          it.compositeRule = $it.compositeRule = $wasComposite;
        } else {
          $it.schema = $aProperties;
          $it.schemaPath = it.schemaPath + '.additionalProperties';
          $it.errSchemaPath = it.errSchemaPath + '/additionalProperties';
          $it.errorPath = it.opts._errorDataPathProperty ? it.errorPath : it.util.getPathExpr(it.errorPath, $key, it.opts.jsonPointers);
          var $passData = $data + '[' + $key + ']';
          $it.dataPathArr[$dataNxt] = $key;
          var $code = it.validate($it);
          $it.baseId = $currentBaseId;
          if (it.util.varOccurences($code, $nextData) < 2) {
            out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
          } else {
            out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
          }
          if ($breakOnError) {
            out += ' if (!' + ($nextValid) + ') break; ';
          }
        }
      }
      it.errorPath = $currentErrorPath;
    }
    if ($someProperties) {
      out += ' } ';
    }
    out += ' }  ';
    if ($breakOnError) {
      out += ' if (' + ($nextValid) + ') { ';
      $closingBraces += '}';
    }
  }
  var $useDefaults = it.opts.useDefaults && !it.compositeRule;
  if ($schemaKeys.length) {
    var arr3 = $schemaKeys;
    if (arr3) {
      var $propertyKey, i3 = -1,
        l3 = arr3.length - 1;
      while (i3 < l3) {
        $propertyKey = arr3[i3 += 1];
        var $sch = $schema[$propertyKey];
        if ((it.opts.strictKeywords ? (typeof $sch == 'object' && Object.keys($sch).length > 0) || $sch === false : it.util.schemaHasRules($sch, it.RULES.all))) {
          var $prop = it.util.getProperty($propertyKey),
            $passData = $data + $prop,
            $hasDefault = $useDefaults && $sch.default !== undefined;
          $it.schema = $sch;
          $it.schemaPath = $schemaPath + $prop;
          $it.errSchemaPath = $errSchemaPath + '/' + it.util.escapeFragment($propertyKey);
          $it.errorPath = it.util.getPath(it.errorPath, $propertyKey, it.opts.jsonPointers);
          $it.dataPathArr[$dataNxt] = it.util.toQuotedString($propertyKey);
          var $code = it.validate($it);
          $it.baseId = $currentBaseId;
          if (it.util.varOccurences($code, $nextData) < 2) {
            $code = it.util.varReplace($code, $nextData, $passData);
            var $useData = $passData;
          } else {
            var $useData = $nextData;
            out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ';
          }
          if ($hasDefault) {
            out += ' ' + ($code) + ' ';
          } else {
            if ($requiredHash && $requiredHash[$propertyKey]) {
              out += ' if ( ' + ($useData) + ' === undefined ';
              if ($ownProperties) {
                out += ' || ! Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($propertyKey)) + '\') ';
              }
              out += ') { ' + ($nextValid) + ' = false; ';
              var $currentErrorPath = it.errorPath,
                $currErrSchemaPath = $errSchemaPath,
                $missingProperty = it.util.escapeQuotes($propertyKey);
              if (it.opts._errorDataPathProperty) {
                it.errorPath = it.util.getPath($currentErrorPath, $propertyKey, it.opts.jsonPointers);
              }
              $errSchemaPath = it.errSchemaPath + '/required';
              var $$outStack = $$outStack || [];
              $$outStack.push(out);
              out = ''; /* istanbul ignore else */
              if (it.createErrors !== false) {
                out += ' { keyword: \'' + ('required') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { missingProperty: \'' + ($missingProperty) + '\' } ';
                if (it.opts.messages !== false) {
                  out += ' , message: \'';
                  if (it.opts._errorDataPathProperty) {
                    out += 'is a required property';
                  } else {
                    out += 'should have required property \\\'' + ($missingProperty) + '\\\'';
                  }
                  out += '\' ';
                }
                if (it.opts.verbose) {
                  out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                }
                out += ' } ';
              } else {
                out += ' {} ';
              }
              var __err = out;
              out = $$outStack.pop();
              if (!it.compositeRule && $breakOnError) {
                /* istanbul ignore if */
                if (it.async) {
                  out += ' throw new ValidationError([' + (__err) + ']); ';
                } else {
                  out += ' validate.errors = [' + (__err) + ']; return false; ';
                }
              } else {
                out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
              }
              $errSchemaPath = $currErrSchemaPath;
              it.errorPath = $currentErrorPath;
              out += ' } else { ';
            } else {
              if ($breakOnError) {
                out += ' if ( ' + ($useData) + ' === undefined ';
                if ($ownProperties) {
                  out += ' || ! Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($propertyKey)) + '\') ';
                }
                out += ') { ' + ($nextValid) + ' = true; } else { ';
              } else {
                out += ' if (' + ($useData) + ' !== undefined ';
                if ($ownProperties) {
                  out += ' &&   Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($propertyKey)) + '\') ';
                }
                out += ' ) { ';
              }
            }
            out += ' ' + ($code) + ' } ';
          }
        }
        if ($breakOnError) {
          out += ' if (' + ($nextValid) + ') { ';
          $closingBraces += '}';
        }
      }
    }
  }
  if ($pPropertyKeys.length) {
    var arr4 = $pPropertyKeys;
    if (arr4) {
      var $pProperty, i4 = -1,
        l4 = arr4.length - 1;
      while (i4 < l4) {
        $pProperty = arr4[i4 += 1];
        var $sch = $pProperties[$pProperty];
        if ((it.opts.strictKeywords ? (typeof $sch == 'object' && Object.keys($sch).length > 0) || $sch === false : it.util.schemaHasRules($sch, it.RULES.all))) {
          $it.schema = $sch;
          $it.schemaPath = it.schemaPath + '.patternProperties' + it.util.getProperty($pProperty);
          $it.errSchemaPath = it.errSchemaPath + '/patternProperties/' + it.util.escapeFragment($pProperty);
          if ($ownProperties) {
            out += ' ' + ($dataProperties) + ' = ' + ($dataProperties) + ' || Object.keys(' + ($data) + '); for (var ' + ($idx) + '=0; ' + ($idx) + '<' + ($dataProperties) + '.length; ' + ($idx) + '++) { var ' + ($key) + ' = ' + ($dataProperties) + '[' + ($idx) + ']; ';
          } else {
            out += ' for (var ' + ($key) + ' in ' + ($data) + ') { ';
          }
          out += ' if (' + (it.usePattern($pProperty)) + '.test(' + ($key) + ')) { ';
          $it.errorPath = it.util.getPathExpr(it.errorPath, $key, it.opts.jsonPointers);
          var $passData = $data + '[' + $key + ']';
          $it.dataPathArr[$dataNxt] = $key;
          var $code = it.validate($it);
          $it.baseId = $currentBaseId;
          if (it.util.varOccurences($code, $nextData) < 2) {
            out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
          } else {
            out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
          }
          if ($breakOnError) {
            out += ' if (!' + ($nextValid) + ') break; ';
          }
          out += ' } ';
          if ($breakOnError) {
            out += ' else ' + ($nextValid) + ' = true; ';
          }
          out += ' }  ';
          if ($breakOnError) {
            out += ' if (' + ($nextValid) + ') { ';
            $closingBraces += '}';
          }
        }
      }
    }
  }
  if ($breakOnError) {
    out += ' ' + ($closingBraces) + ' if (' + ($errs) + ' == errors) {';
  }
  return out;
}


/***/ }),

/***/ 58441:
/***/ ((module) => {

"use strict";

module.exports = function generate_propertyNames(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $errs = 'errs__' + $lvl;
  var $it = it.util.copy(it);
  var $closingBraces = '';
  $it.level++;
  var $nextValid = 'valid' + $it.level;
  out += 'var ' + ($errs) + ' = errors;';
  if ((it.opts.strictKeywords ? (typeof $schema == 'object' && Object.keys($schema).length > 0) || $schema === false : it.util.schemaHasRules($schema, it.RULES.all))) {
    $it.schema = $schema;
    $it.schemaPath = $schemaPath;
    $it.errSchemaPath = $errSchemaPath;
    var $key = 'key' + $lvl,
      $idx = 'idx' + $lvl,
      $i = 'i' + $lvl,
      $invalidName = '\' + ' + $key + ' + \'',
      $dataNxt = $it.dataLevel = it.dataLevel + 1,
      $nextData = 'data' + $dataNxt,
      $dataProperties = 'dataProperties' + $lvl,
      $ownProperties = it.opts.ownProperties,
      $currentBaseId = it.baseId;
    if ($ownProperties) {
      out += ' var ' + ($dataProperties) + ' = undefined; ';
    }
    if ($ownProperties) {
      out += ' ' + ($dataProperties) + ' = ' + ($dataProperties) + ' || Object.keys(' + ($data) + '); for (var ' + ($idx) + '=0; ' + ($idx) + '<' + ($dataProperties) + '.length; ' + ($idx) + '++) { var ' + ($key) + ' = ' + ($dataProperties) + '[' + ($idx) + ']; ';
    } else {
      out += ' for (var ' + ($key) + ' in ' + ($data) + ') { ';
    }
    out += ' var startErrs' + ($lvl) + ' = errors; ';
    var $passData = $key;
    var $wasComposite = it.compositeRule;
    it.compositeRule = $it.compositeRule = true;
    var $code = it.validate($it);
    $it.baseId = $currentBaseId;
    if (it.util.varOccurences($code, $nextData) < 2) {
      out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
    } else {
      out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
    }
    it.compositeRule = $it.compositeRule = $wasComposite;
    out += ' if (!' + ($nextValid) + ') { for (var ' + ($i) + '=startErrs' + ($lvl) + '; ' + ($i) + '<errors; ' + ($i) + '++) { vErrors[' + ($i) + '].propertyName = ' + ($key) + '; }   var err =   '; /* istanbul ignore else */
    if (it.createErrors !== false) {
      out += ' { keyword: \'' + ('propertyNames') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { propertyName: \'' + ($invalidName) + '\' } ';
      if (it.opts.messages !== false) {
        out += ' , message: \'property name \\\'' + ($invalidName) + '\\\' is invalid\' ';
      }
      if (it.opts.verbose) {
        out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
      }
      out += ' } ';
    } else {
      out += ' {} ';
    }
    out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
    if (!it.compositeRule && $breakOnError) {
      /* istanbul ignore if */
      if (it.async) {
        out += ' throw new ValidationError(vErrors); ';
      } else {
        out += ' validate.errors = vErrors; return false; ';
      }
    }
    if ($breakOnError) {
      out += ' break; ';
    }
    out += ' } }';
  }
  if ($breakOnError) {
    out += ' ' + ($closingBraces) + ' if (' + ($errs) + ' == errors) {';
  }
  return out;
}


/***/ }),

/***/ 62392:
/***/ ((module) => {

"use strict";

module.exports = function generate_ref(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $valid = 'valid' + $lvl;
  var $async, $refCode;
  if ($schema == '#' || $schema == '#/') {
    if (it.isRoot) {
      $async = it.async;
      $refCode = 'validate';
    } else {
      $async = it.root.schema.$async === true;
      $refCode = 'root.refVal[0]';
    }
  } else {
    var $refVal = it.resolveRef(it.baseId, $schema, it.isRoot);
    if ($refVal === undefined) {
      var $message = it.MissingRefError.message(it.baseId, $schema);
      if (it.opts.missingRefs == 'fail') {
        it.logger.error($message);
        var $$outStack = $$outStack || [];
        $$outStack.push(out);
        out = ''; /* istanbul ignore else */
        if (it.createErrors !== false) {
          out += ' { keyword: \'' + ('$ref') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { ref: \'' + (it.util.escapeQuotes($schema)) + '\' } ';
          if (it.opts.messages !== false) {
            out += ' , message: \'can\\\'t resolve reference ' + (it.util.escapeQuotes($schema)) + '\' ';
          }
          if (it.opts.verbose) {
            out += ' , schema: ' + (it.util.toQuotedString($schema)) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
          }
          out += ' } ';
        } else {
          out += ' {} ';
        }
        var __err = out;
        out = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) {
          /* istanbul ignore if */
          if (it.async) {
            out += ' throw new ValidationError([' + (__err) + ']); ';
          } else {
            out += ' validate.errors = [' + (__err) + ']; return false; ';
          }
        } else {
          out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
        }
        if ($breakOnError) {
          out += ' if (false) { ';
        }
      } else if (it.opts.missingRefs == 'ignore') {
        it.logger.warn($message);
        if ($breakOnError) {
          out += ' if (true) { ';
        }
      } else {
        throw new it.MissingRefError(it.baseId, $schema, $message);
      }
    } else if ($refVal.inline) {
      var $it = it.util.copy(it);
      $it.level++;
      var $nextValid = 'valid' + $it.level;
      $it.schema = $refVal.schema;
      $it.schemaPath = '';
      $it.errSchemaPath = $schema;
      var $code = it.validate($it).replace(/validate\.schema/g, $refVal.code);
      out += ' ' + ($code) + ' ';
      if ($breakOnError) {
        out += ' if (' + ($nextValid) + ') { ';
      }
    } else {
      $async = $refVal.$async === true || (it.async && $refVal.$async !== false);
      $refCode = $refVal.code;
    }
  }
  if ($refCode) {
    var $$outStack = $$outStack || [];
    $$outStack.push(out);
    out = '';
    if (it.opts.passContext) {
      out += ' ' + ($refCode) + '.call(this, ';
    } else {
      out += ' ' + ($refCode) + '( ';
    }
    out += ' ' + ($data) + ', (dataPath || \'\')';
    if (it.errorPath != '""') {
      out += ' + ' + (it.errorPath);
    }
    var $parentData = $dataLvl ? 'data' + (($dataLvl - 1) || '') : 'parentData',
      $parentDataProperty = $dataLvl ? it.dataPathArr[$dataLvl] : 'parentDataProperty';
    out += ' , ' + ($parentData) + ' , ' + ($parentDataProperty) + ', rootData)  ';
    var __callValidate = out;
    out = $$outStack.pop();
    if ($async) {
      if (!it.async) throw new Error('async schema referenced by sync schema');
      if ($breakOnError) {
        out += ' var ' + ($valid) + '; ';
      }
      out += ' try { await ' + (__callValidate) + '; ';
      if ($breakOnError) {
        out += ' ' + ($valid) + ' = true; ';
      }
      out += ' } catch (e) { if (!(e instanceof ValidationError)) throw e; if (vErrors === null) vErrors = e.errors; else vErrors = vErrors.concat(e.errors); errors = vErrors.length; ';
      if ($breakOnError) {
        out += ' ' + ($valid) + ' = false; ';
      }
      out += ' } ';
      if ($breakOnError) {
        out += ' if (' + ($valid) + ') { ';
      }
    } else {
      out += ' if (!' + (__callValidate) + ') { if (vErrors === null) vErrors = ' + ($refCode) + '.errors; else vErrors = vErrors.concat(' + ($refCode) + '.errors); errors = vErrors.length; } ';
      if ($breakOnError) {
        out += ' else { ';
      }
    }
  }
  return out;
}


/***/ }),

/***/ 71287:
/***/ ((module) => {

"use strict";

module.exports = function generate_required(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $valid = 'valid' + $lvl;
  var $isData = it.opts.$data && $schema && $schema.$data,
    $schemaValue;
  if ($isData) {
    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
    $schemaValue = 'schema' + $lvl;
  } else {
    $schemaValue = $schema;
  }
  var $vSchema = 'schema' + $lvl;
  if (!$isData) {
    if ($schema.length < it.opts.loopRequired && it.schema.properties && Object.keys(it.schema.properties).length) {
      var $required = [];
      var arr1 = $schema;
      if (arr1) {
        var $property, i1 = -1,
          l1 = arr1.length - 1;
        while (i1 < l1) {
          $property = arr1[i1 += 1];
          var $propertySch = it.schema.properties[$property];
          if (!($propertySch && (it.opts.strictKeywords ? (typeof $propertySch == 'object' && Object.keys($propertySch).length > 0) || $propertySch === false : it.util.schemaHasRules($propertySch, it.RULES.all)))) {
            $required[$required.length] = $property;
          }
        }
      }
    } else {
      var $required = $schema;
    }
  }
  if ($isData || $required.length) {
    var $currentErrorPath = it.errorPath,
      $loopRequired = $isData || $required.length >= it.opts.loopRequired,
      $ownProperties = it.opts.ownProperties;
    if ($breakOnError) {
      out += ' var missing' + ($lvl) + '; ';
      if ($loopRequired) {
        if (!$isData) {
          out += ' var ' + ($vSchema) + ' = validate.schema' + ($schemaPath) + '; ';
        }
        var $i = 'i' + $lvl,
          $propertyPath = 'schema' + $lvl + '[' + $i + ']',
          $missingProperty = '\' + ' + $propertyPath + ' + \'';
        if (it.opts._errorDataPathProperty) {
          it.errorPath = it.util.getPathExpr($currentErrorPath, $propertyPath, it.opts.jsonPointers);
        }
        out += ' var ' + ($valid) + ' = true; ';
        if ($isData) {
          out += ' if (schema' + ($lvl) + ' === undefined) ' + ($valid) + ' = true; else if (!Array.isArray(schema' + ($lvl) + ')) ' + ($valid) + ' = false; else {';
        }
        out += ' for (var ' + ($i) + ' = 0; ' + ($i) + ' < ' + ($vSchema) + '.length; ' + ($i) + '++) { ' + ($valid) + ' = ' + ($data) + '[' + ($vSchema) + '[' + ($i) + ']] !== undefined ';
        if ($ownProperties) {
          out += ' &&   Object.prototype.hasOwnProperty.call(' + ($data) + ', ' + ($vSchema) + '[' + ($i) + ']) ';
        }
        out += '; if (!' + ($valid) + ') break; } ';
        if ($isData) {
          out += '  }  ';
        }
        out += '  if (!' + ($valid) + ') {   ';
        var $$outStack = $$outStack || [];
        $$outStack.push(out);
        out = ''; /* istanbul ignore else */
        if (it.createErrors !== false) {
          out += ' { keyword: \'' + ('required') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { missingProperty: \'' + ($missingProperty) + '\' } ';
          if (it.opts.messages !== false) {
            out += ' , message: \'';
            if (it.opts._errorDataPathProperty) {
              out += 'is a required property';
            } else {
              out += 'should have required property \\\'' + ($missingProperty) + '\\\'';
            }
            out += '\' ';
          }
          if (it.opts.verbose) {
            out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
          }
          out += ' } ';
        } else {
          out += ' {} ';
        }
        var __err = out;
        out = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) {
          /* istanbul ignore if */
          if (it.async) {
            out += ' throw new ValidationError([' + (__err) + ']); ';
          } else {
            out += ' validate.errors = [' + (__err) + ']; return false; ';
          }
        } else {
          out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
        }
        out += ' } else { ';
      } else {
        out += ' if ( ';
        var arr2 = $required;
        if (arr2) {
          var $propertyKey, $i = -1,
            l2 = arr2.length - 1;
          while ($i < l2) {
            $propertyKey = arr2[$i += 1];
            if ($i) {
              out += ' || ';
            }
            var $prop = it.util.getProperty($propertyKey),
              $useData = $data + $prop;
            out += ' ( ( ' + ($useData) + ' === undefined ';
            if ($ownProperties) {
              out += ' || ! Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($propertyKey)) + '\') ';
            }
            out += ') && (missing' + ($lvl) + ' = ' + (it.util.toQuotedString(it.opts.jsonPointers ? $propertyKey : $prop)) + ') ) ';
          }
        }
        out += ') {  ';
        var $propertyPath = 'missing' + $lvl,
          $missingProperty = '\' + ' + $propertyPath + ' + \'';
        if (it.opts._errorDataPathProperty) {
          it.errorPath = it.opts.jsonPointers ? it.util.getPathExpr($currentErrorPath, $propertyPath, true) : $currentErrorPath + ' + ' + $propertyPath;
        }
        var $$outStack = $$outStack || [];
        $$outStack.push(out);
        out = ''; /* istanbul ignore else */
        if (it.createErrors !== false) {
          out += ' { keyword: \'' + ('required') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { missingProperty: \'' + ($missingProperty) + '\' } ';
          if (it.opts.messages !== false) {
            out += ' , message: \'';
            if (it.opts._errorDataPathProperty) {
              out += 'is a required property';
            } else {
              out += 'should have required property \\\'' + ($missingProperty) + '\\\'';
            }
            out += '\' ';
          }
          if (it.opts.verbose) {
            out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
          }
          out += ' } ';
        } else {
          out += ' {} ';
        }
        var __err = out;
        out = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) {
          /* istanbul ignore if */
          if (it.async) {
            out += ' throw new ValidationError([' + (__err) + ']); ';
          } else {
            out += ' validate.errors = [' + (__err) + ']; return false; ';
          }
        } else {
          out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
        }
        out += ' } else { ';
      }
    } else {
      if ($loopRequired) {
        if (!$isData) {
          out += ' var ' + ($vSchema) + ' = validate.schema' + ($schemaPath) + '; ';
        }
        var $i = 'i' + $lvl,
          $propertyPath = 'schema' + $lvl + '[' + $i + ']',
          $missingProperty = '\' + ' + $propertyPath + ' + \'';
        if (it.opts._errorDataPathProperty) {
          it.errorPath = it.util.getPathExpr($currentErrorPath, $propertyPath, it.opts.jsonPointers);
        }
        if ($isData) {
          out += ' if (' + ($vSchema) + ' && !Array.isArray(' + ($vSchema) + ')) {  var err =   '; /* istanbul ignore else */
          if (it.createErrors !== false) {
            out += ' { keyword: \'' + ('required') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { missingProperty: \'' + ($missingProperty) + '\' } ';
            if (it.opts.messages !== false) {
              out += ' , message: \'';
              if (it.opts._errorDataPathProperty) {
                out += 'is a required property';
              } else {
                out += 'should have required property \\\'' + ($missingProperty) + '\\\'';
              }
              out += '\' ';
            }
            if (it.opts.verbose) {
              out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
            }
            out += ' } ';
          } else {
            out += ' {} ';
          }
          out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } else if (' + ($vSchema) + ' !== undefined) { ';
        }
        out += ' for (var ' + ($i) + ' = 0; ' + ($i) + ' < ' + ($vSchema) + '.length; ' + ($i) + '++) { if (' + ($data) + '[' + ($vSchema) + '[' + ($i) + ']] === undefined ';
        if ($ownProperties) {
          out += ' || ! Object.prototype.hasOwnProperty.call(' + ($data) + ', ' + ($vSchema) + '[' + ($i) + ']) ';
        }
        out += ') {  var err =   '; /* istanbul ignore else */
        if (it.createErrors !== false) {
          out += ' { keyword: \'' + ('required') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { missingProperty: \'' + ($missingProperty) + '\' } ';
          if (it.opts.messages !== false) {
            out += ' , message: \'';
            if (it.opts._errorDataPathProperty) {
              out += 'is a required property';
            } else {
              out += 'should have required property \\\'' + ($missingProperty) + '\\\'';
            }
            out += '\' ';
          }
          if (it.opts.verbose) {
            out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
          }
          out += ' } ';
        } else {
          out += ' {} ';
        }
        out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } } ';
        if ($isData) {
          out += '  }  ';
        }
      } else {
        var arr3 = $required;
        if (arr3) {
          var $propertyKey, i3 = -1,
            l3 = arr3.length - 1;
          while (i3 < l3) {
            $propertyKey = arr3[i3 += 1];
            var $prop = it.util.getProperty($propertyKey),
              $missingProperty = it.util.escapeQuotes($propertyKey),
              $useData = $data + $prop;
            if (it.opts._errorDataPathProperty) {
              it.errorPath = it.util.getPath($currentErrorPath, $propertyKey, it.opts.jsonPointers);
            }
            out += ' if ( ' + ($useData) + ' === undefined ';
            if ($ownProperties) {
              out += ' || ! Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($propertyKey)) + '\') ';
            }
            out += ') {  var err =   '; /* istanbul ignore else */
            if (it.createErrors !== false) {
              out += ' { keyword: \'' + ('required') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { missingProperty: \'' + ($missingProperty) + '\' } ';
              if (it.opts.messages !== false) {
                out += ' , message: \'';
                if (it.opts._errorDataPathProperty) {
                  out += 'is a required property';
                } else {
                  out += 'should have required property \\\'' + ($missingProperty) + '\\\'';
                }
                out += '\' ';
              }
              if (it.opts.verbose) {
                out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
              }
              out += ' } ';
            } else {
              out += ' {} ';
            }
            out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } ';
          }
        }
      }
    }
    it.errorPath = $currentErrorPath;
  } else if ($breakOnError) {
    out += ' if (true) {';
  }
  return out;
}


/***/ }),

/***/ 3603:
/***/ ((module) => {

"use strict";

module.exports = function generate_uniqueItems(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $valid = 'valid' + $lvl;
  var $isData = it.opts.$data && $schema && $schema.$data,
    $schemaValue;
  if ($isData) {
    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
    $schemaValue = 'schema' + $lvl;
  } else {
    $schemaValue = $schema;
  }
  if (($schema || $isData) && it.opts.uniqueItems !== false) {
    if ($isData) {
      out += ' var ' + ($valid) + '; if (' + ($schemaValue) + ' === false || ' + ($schemaValue) + ' === undefined) ' + ($valid) + ' = true; else if (typeof ' + ($schemaValue) + ' != \'boolean\') ' + ($valid) + ' = false; else { ';
    }
    out += ' var i = ' + ($data) + '.length , ' + ($valid) + ' = true , j; if (i > 1) { ';
    var $itemType = it.schema.items && it.schema.items.type,
      $typeIsArray = Array.isArray($itemType);
    if (!$itemType || $itemType == 'object' || $itemType == 'array' || ($typeIsArray && ($itemType.indexOf('object') >= 0 || $itemType.indexOf('array') >= 0))) {
      out += ' outer: for (;i--;) { for (j = i; j--;) { if (equal(' + ($data) + '[i], ' + ($data) + '[j])) { ' + ($valid) + ' = false; break outer; } } } ';
    } else {
      out += ' var itemIndices = {}, item; for (;i--;) { var item = ' + ($data) + '[i]; ';
      var $method = 'checkDataType' + ($typeIsArray ? 's' : '');
      out += ' if (' + (it.util[$method]($itemType, 'item', it.opts.strictNumbers, true)) + ') continue; ';
      if ($typeIsArray) {
        out += ' if (typeof item == \'string\') item = \'"\' + item; ';
      }
      out += ' if (typeof itemIndices[item] == \'number\') { ' + ($valid) + ' = false; j = itemIndices[item]; break; } itemIndices[item] = i; } ';
    }
    out += ' } ';
    if ($isData) {
      out += '  }  ';
    }
    out += ' if (!' + ($valid) + ') {   ';
    var $$outStack = $$outStack || [];
    $$outStack.push(out);
    out = ''; /* istanbul ignore else */
    if (it.createErrors !== false) {
      out += ' { keyword: \'' + ('uniqueItems') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { i: i, j: j } ';
      if (it.opts.messages !== false) {
        out += ' , message: \'should NOT have duplicate items (items ## \' + j + \' and \' + i + \' are identical)\' ';
      }
      if (it.opts.verbose) {
        out += ' , schema:  ';
        if ($isData) {
          out += 'validate.schema' + ($schemaPath);
        } else {
          out += '' + ($schema);
        }
        out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
      }
      out += ' } ';
    } else {
      out += ' {} ';
    }
    var __err = out;
    out = $$outStack.pop();
    if (!it.compositeRule && $breakOnError) {
      /* istanbul ignore if */
      if (it.async) {
        out += ' throw new ValidationError([' + (__err) + ']); ';
      } else {
        out += ' validate.errors = [' + (__err) + ']; return false; ';
      }
    } else {
      out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
    }
    out += ' } ';
    if ($breakOnError) {
      out += ' else { ';
    }
  } else {
    if ($breakOnError) {
      out += ' if (true) { ';
    }
  }
  return out;
}


/***/ }),

/***/ 19508:
/***/ ((module) => {

"use strict";

module.exports = function generate_validate(it, $keyword, $ruleType) {
  var out = '';
  var $async = it.schema.$async === true,
    $refKeywords = it.util.schemaHasRulesExcept(it.schema, it.RULES.all, '$ref'),
    $id = it.self._getId(it.schema);
  if (it.opts.strictKeywords) {
    var $unknownKwd = it.util.schemaUnknownRules(it.schema, it.RULES.keywords);
    if ($unknownKwd) {
      var $keywordsMsg = 'unknown keyword: ' + $unknownKwd;
      if (it.opts.strictKeywords === 'log') it.logger.warn($keywordsMsg);
      else throw new Error($keywordsMsg);
    }
  }
  if (it.isTop) {
    out += ' var validate = ';
    if ($async) {
      it.async = true;
      out += 'async ';
    }
    out += 'function(data, dataPath, parentData, parentDataProperty, rootData) { \'use strict\'; ';
    if ($id && (it.opts.sourceCode || it.opts.processCode)) {
      out += ' ' + ('/\*# sourceURL=' + $id + ' */') + ' ';
    }
  }
  if (typeof it.schema == 'boolean' || !($refKeywords || it.schema.$ref)) {
    var $keyword = 'false schema';
    var $lvl = it.level;
    var $dataLvl = it.dataLevel;
    var $schema = it.schema[$keyword];
    var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
    var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
    var $breakOnError = !it.opts.allErrors;
    var $errorKeyword;
    var $data = 'data' + ($dataLvl || '');
    var $valid = 'valid' + $lvl;
    if (it.schema === false) {
      if (it.isTop) {
        $breakOnError = true;
      } else {
        out += ' var ' + ($valid) + ' = false; ';
      }
      var $$outStack = $$outStack || [];
      $$outStack.push(out);
      out = ''; /* istanbul ignore else */
      if (it.createErrors !== false) {
        out += ' { keyword: \'' + ($errorKeyword || 'false schema') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: {} ';
        if (it.opts.messages !== false) {
          out += ' , message: \'boolean schema is false\' ';
        }
        if (it.opts.verbose) {
          out += ' , schema: false , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
        }
        out += ' } ';
      } else {
        out += ' {} ';
      }
      var __err = out;
      out = $$outStack.pop();
      if (!it.compositeRule && $breakOnError) {
        /* istanbul ignore if */
        if (it.async) {
          out += ' throw new ValidationError([' + (__err) + ']); ';
        } else {
          out += ' validate.errors = [' + (__err) + ']; return false; ';
        }
      } else {
        out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
      }
    } else {
      if (it.isTop) {
        if ($async) {
          out += ' return data; ';
        } else {
          out += ' validate.errors = null; return true; ';
        }
      } else {
        out += ' var ' + ($valid) + ' = true; ';
      }
    }
    if (it.isTop) {
      out += ' }; return validate; ';
    }
    return out;
  }
  if (it.isTop) {
    var $top = it.isTop,
      $lvl = it.level = 0,
      $dataLvl = it.dataLevel = 0,
      $data = 'data';
    it.rootId = it.resolve.fullPath(it.self._getId(it.root.schema));
    it.baseId = it.baseId || it.rootId;
    delete it.isTop;
    it.dataPathArr = [""];
    if (it.schema.default !== undefined && it.opts.useDefaults && it.opts.strictDefaults) {
      var $defaultMsg = 'default is ignored in the schema root';
      if (it.opts.strictDefaults === 'log') it.logger.warn($defaultMsg);
      else throw new Error($defaultMsg);
    }
    out += ' var vErrors = null; ';
    out += ' var errors = 0;     ';
    out += ' if (rootData === undefined) rootData = data; ';
  } else {
    var $lvl = it.level,
      $dataLvl = it.dataLevel,
      $data = 'data' + ($dataLvl || '');
    if ($id) it.baseId = it.resolve.url(it.baseId, $id);
    if ($async && !it.async) throw new Error('async schema in sync schema');
    out += ' var errs_' + ($lvl) + ' = errors;';
  }
  var $valid = 'valid' + $lvl,
    $breakOnError = !it.opts.allErrors,
    $closingBraces1 = '',
    $closingBraces2 = '';
  var $errorKeyword;
  var $typeSchema = it.schema.type,
    $typeIsArray = Array.isArray($typeSchema);
  if ($typeSchema && it.opts.nullable && it.schema.nullable === true) {
    if ($typeIsArray) {
      if ($typeSchema.indexOf('null') == -1) $typeSchema = $typeSchema.concat('null');
    } else if ($typeSchema != 'null') {
      $typeSchema = [$typeSchema, 'null'];
      $typeIsArray = true;
    }
  }
  if ($typeIsArray && $typeSchema.length == 1) {
    $typeSchema = $typeSchema[0];
    $typeIsArray = false;
  }
  if (it.schema.$ref && $refKeywords) {
    if (it.opts.extendRefs == 'fail') {
      throw new Error('$ref: validation keywords used in schema at path "' + it.errSchemaPath + '" (see option extendRefs)');
    } else if (it.opts.extendRefs !== true) {
      $refKeywords = false;
      it.logger.warn('$ref: keywords ignored in schema at path "' + it.errSchemaPath + '"');
    }
  }
  if (it.schema.$comment && it.opts.$comment) {
    out += ' ' + (it.RULES.all.$comment.code(it, '$comment'));
  }
  if ($typeSchema) {
    if (it.opts.coerceTypes) {
      var $coerceToTypes = it.util.coerceToTypes(it.opts.coerceTypes, $typeSchema);
    }
    var $rulesGroup = it.RULES.types[$typeSchema];
    if ($coerceToTypes || $typeIsArray || $rulesGroup === true || ($rulesGroup && !$shouldUseGroup($rulesGroup))) {
      var $schemaPath = it.schemaPath + '.type',
        $errSchemaPath = it.errSchemaPath + '/type';
      var $schemaPath = it.schemaPath + '.type',
        $errSchemaPath = it.errSchemaPath + '/type',
        $method = $typeIsArray ? 'checkDataTypes' : 'checkDataType';
      out += ' if (' + (it.util[$method]($typeSchema, $data, it.opts.strictNumbers, true)) + ') { ';
      if ($coerceToTypes) {
        var $dataType = 'dataType' + $lvl,
          $coerced = 'coerced' + $lvl;
        out += ' var ' + ($dataType) + ' = typeof ' + ($data) + '; var ' + ($coerced) + ' = undefined; ';
        if (it.opts.coerceTypes == 'array') {
          out += ' if (' + ($dataType) + ' == \'object\' && Array.isArray(' + ($data) + ') && ' + ($data) + '.length == 1) { ' + ($data) + ' = ' + ($data) + '[0]; ' + ($dataType) + ' = typeof ' + ($data) + '; if (' + (it.util.checkDataType(it.schema.type, $data, it.opts.strictNumbers)) + ') ' + ($coerced) + ' = ' + ($data) + '; } ';
        }
        out += ' if (' + ($coerced) + ' !== undefined) ; ';
        var arr1 = $coerceToTypes;
        if (arr1) {
          var $type, $i = -1,
            l1 = arr1.length - 1;
          while ($i < l1) {
            $type = arr1[$i += 1];
            if ($type == 'string') {
              out += ' else if (' + ($dataType) + ' == \'number\' || ' + ($dataType) + ' == \'boolean\') ' + ($coerced) + ' = \'\' + ' + ($data) + '; else if (' + ($data) + ' === null) ' + ($coerced) + ' = \'\'; ';
            } else if ($type == 'number' || $type == 'integer') {
              out += ' else if (' + ($dataType) + ' == \'boolean\' || ' + ($data) + ' === null || (' + ($dataType) + ' == \'string\' && ' + ($data) + ' && ' + ($data) + ' == +' + ($data) + ' ';
              if ($type == 'integer') {
                out += ' && !(' + ($data) + ' % 1)';
              }
              out += ')) ' + ($coerced) + ' = +' + ($data) + '; ';
            } else if ($type == 'boolean') {
              out += ' else if (' + ($data) + ' === \'false\' || ' + ($data) + ' === 0 || ' + ($data) + ' === null) ' + ($coerced) + ' = false; else if (' + ($data) + ' === \'true\' || ' + ($data) + ' === 1) ' + ($coerced) + ' = true; ';
            } else if ($type == 'null') {
              out += ' else if (' + ($data) + ' === \'\' || ' + ($data) + ' === 0 || ' + ($data) + ' === false) ' + ($coerced) + ' = null; ';
            } else if (it.opts.coerceTypes == 'array' && $type == 'array') {
              out += ' else if (' + ($dataType) + ' == \'string\' || ' + ($dataType) + ' == \'number\' || ' + ($dataType) + ' == \'boolean\' || ' + ($data) + ' == null) ' + ($coerced) + ' = [' + ($data) + ']; ';
            }
          }
        }
        out += ' else {   ';
        var $$outStack = $$outStack || [];
        $$outStack.push(out);
        out = ''; /* istanbul ignore else */
        if (it.createErrors !== false) {
          out += ' { keyword: \'' + ($errorKeyword || 'type') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { type: \'';
          if ($typeIsArray) {
            out += '' + ($typeSchema.join(","));
          } else {
            out += '' + ($typeSchema);
          }
          out += '\' } ';
          if (it.opts.messages !== false) {
            out += ' , message: \'should be ';
            if ($typeIsArray) {
              out += '' + ($typeSchema.join(","));
            } else {
              out += '' + ($typeSchema);
            }
            out += '\' ';
          }
          if (it.opts.verbose) {
            out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
          }
          out += ' } ';
        } else {
          out += ' {} ';
        }
        var __err = out;
        out = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) {
          /* istanbul ignore if */
          if (it.async) {
            out += ' throw new ValidationError([' + (__err) + ']); ';
          } else {
            out += ' validate.errors = [' + (__err) + ']; return false; ';
          }
        } else {
          out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
        }
        out += ' } if (' + ($coerced) + ' !== undefined) {  ';
        var $parentData = $dataLvl ? 'data' + (($dataLvl - 1) || '') : 'parentData',
          $parentDataProperty = $dataLvl ? it.dataPathArr[$dataLvl] : 'parentDataProperty';
        out += ' ' + ($data) + ' = ' + ($coerced) + '; ';
        if (!$dataLvl) {
          out += 'if (' + ($parentData) + ' !== undefined)';
        }
        out += ' ' + ($parentData) + '[' + ($parentDataProperty) + '] = ' + ($coerced) + '; } ';
      } else {
        var $$outStack = $$outStack || [];
        $$outStack.push(out);
        out = ''; /* istanbul ignore else */
        if (it.createErrors !== false) {
          out += ' { keyword: \'' + ($errorKeyword || 'type') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { type: \'';
          if ($typeIsArray) {
            out += '' + ($typeSchema.join(","));
          } else {
            out += '' + ($typeSchema);
          }
          out += '\' } ';
          if (it.opts.messages !== false) {
            out += ' , message: \'should be ';
            if ($typeIsArray) {
              out += '' + ($typeSchema.join(","));
            } else {
              out += '' + ($typeSchema);
            }
            out += '\' ';
          }
          if (it.opts.verbose) {
            out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
          }
          out += ' } ';
        } else {
          out += ' {} ';
        }
        var __err = out;
        out = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) {
          /* istanbul ignore if */
          if (it.async) {
            out += ' throw new ValidationError([' + (__err) + ']); ';
          } else {
            out += ' validate.errors = [' + (__err) + ']; return false; ';
          }
        } else {
          out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
        }
      }
      out += ' } ';
    }
  }
  if (it.schema.$ref && !$refKeywords) {
    out += ' ' + (it.RULES.all.$ref.code(it, '$ref')) + ' ';
    if ($breakOnError) {
      out += ' } if (errors === ';
      if ($top) {
        out += '0';
      } else {
        out += 'errs_' + ($lvl);
      }
      out += ') { ';
      $closingBraces2 += '}';
    }
  } else {
    var arr2 = it.RULES;
    if (arr2) {
      var $rulesGroup, i2 = -1,
        l2 = arr2.length - 1;
      while (i2 < l2) {
        $rulesGroup = arr2[i2 += 1];
        if ($shouldUseGroup($rulesGroup)) {
          if ($rulesGroup.type) {
            out += ' if (' + (it.util.checkDataType($rulesGroup.type, $data, it.opts.strictNumbers)) + ') { ';
          }
          if (it.opts.useDefaults) {
            if ($rulesGroup.type == 'object' && it.schema.properties) {
              var $schema = it.schema.properties,
                $schemaKeys = Object.keys($schema);
              var arr3 = $schemaKeys;
              if (arr3) {
                var $propertyKey, i3 = -1,
                  l3 = arr3.length - 1;
                while (i3 < l3) {
                  $propertyKey = arr3[i3 += 1];
                  var $sch = $schema[$propertyKey];
                  if ($sch.default !== undefined) {
                    var $passData = $data + it.util.getProperty($propertyKey);
                    if (it.compositeRule) {
                      if (it.opts.strictDefaults) {
                        var $defaultMsg = 'default is ignored for: ' + $passData;
                        if (it.opts.strictDefaults === 'log') it.logger.warn($defaultMsg);
                        else throw new Error($defaultMsg);
                      }
                    } else {
                      out += ' if (' + ($passData) + ' === undefined ';
                      if (it.opts.useDefaults == 'empty') {
                        out += ' || ' + ($passData) + ' === null || ' + ($passData) + ' === \'\' ';
                      }
                      out += ' ) ' + ($passData) + ' = ';
                      if (it.opts.useDefaults == 'shared') {
                        out += ' ' + (it.useDefault($sch.default)) + ' ';
                      } else {
                        out += ' ' + (JSON.stringify($sch.default)) + ' ';
                      }
                      out += '; ';
                    }
                  }
                }
              }
            } else if ($rulesGroup.type == 'array' && Array.isArray(it.schema.items)) {
              var arr4 = it.schema.items;
              if (arr4) {
                var $sch, $i = -1,
                  l4 = arr4.length - 1;
                while ($i < l4) {
                  $sch = arr4[$i += 1];
                  if ($sch.default !== undefined) {
                    var $passData = $data + '[' + $i + ']';
                    if (it.compositeRule) {
                      if (it.opts.strictDefaults) {
                        var $defaultMsg = 'default is ignored for: ' + $passData;
                        if (it.opts.strictDefaults === 'log') it.logger.warn($defaultMsg);
                        else throw new Error($defaultMsg);
                      }
                    } else {
                      out += ' if (' + ($passData) + ' === undefined ';
                      if (it.opts.useDefaults == 'empty') {
                        out += ' || ' + ($passData) + ' === null || ' + ($passData) + ' === \'\' ';
                      }
                      out += ' ) ' + ($passData) + ' = ';
                      if (it.opts.useDefaults == 'shared') {
                        out += ' ' + (it.useDefault($sch.default)) + ' ';
                      } else {
                        out += ' ' + (JSON.stringify($sch.default)) + ' ';
                      }
                      out += '; ';
                    }
                  }
                }
              }
            }
          }
          var arr5 = $rulesGroup.rules;
          if (arr5) {
            var $rule, i5 = -1,
              l5 = arr5.length - 1;
            while (i5 < l5) {
              $rule = arr5[i5 += 1];
              if ($shouldUseRule($rule)) {
                var $code = $rule.code(it, $rule.keyword, $rulesGroup.type);
                if ($code) {
                  out += ' ' + ($code) + ' ';
                  if ($breakOnError) {
                    $closingBraces1 += '}';
                  }
                }
              }
            }
          }
          if ($breakOnError) {
            out += ' ' + ($closingBraces1) + ' ';
            $closingBraces1 = '';
          }
          if ($rulesGroup.type) {
            out += ' } ';
            if ($typeSchema && $typeSchema === $rulesGroup.type && !$coerceToTypes) {
              out += ' else { ';
              var $schemaPath = it.schemaPath + '.type',
                $errSchemaPath = it.errSchemaPath + '/type';
              var $$outStack = $$outStack || [];
              $$outStack.push(out);
              out = ''; /* istanbul ignore else */
              if (it.createErrors !== false) {
                out += ' { keyword: \'' + ($errorKeyword || 'type') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { type: \'';
                if ($typeIsArray) {
                  out += '' + ($typeSchema.join(","));
                } else {
                  out += '' + ($typeSchema);
                }
                out += '\' } ';
                if (it.opts.messages !== false) {
                  out += ' , message: \'should be ';
                  if ($typeIsArray) {
                    out += '' + ($typeSchema.join(","));
                  } else {
                    out += '' + ($typeSchema);
                  }
                  out += '\' ';
                }
                if (it.opts.verbose) {
                  out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                }
                out += ' } ';
              } else {
                out += ' {} ';
              }
              var __err = out;
              out = $$outStack.pop();
              if (!it.compositeRule && $breakOnError) {
                /* istanbul ignore if */
                if (it.async) {
                  out += ' throw new ValidationError([' + (__err) + ']); ';
                } else {
                  out += ' validate.errors = [' + (__err) + ']; return false; ';
                }
              } else {
                out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
              }
              out += ' } ';
            }
          }
          if ($breakOnError) {
            out += ' if (errors === ';
            if ($top) {
              out += '0';
            } else {
              out += 'errs_' + ($lvl);
            }
            out += ') { ';
            $closingBraces2 += '}';
          }
        }
      }
    }
  }
  if ($breakOnError) {
    out += ' ' + ($closingBraces2) + ' ';
  }
  if ($top) {
    if ($async) {
      out += ' if (errors === 0) return data;           ';
      out += ' else throw new ValidationError(vErrors); ';
    } else {
      out += ' validate.errors = vErrors; ';
      out += ' return errors === 0;       ';
    }
    out += ' }; return validate;';
  } else {
    out += ' var ' + ($valid) + ' = errors === errs_' + ($lvl) + ';';
  }

  function $shouldUseGroup($rulesGroup) {
    var rules = $rulesGroup.rules;
    for (var i = 0; i < rules.length; i++)
      if ($shouldUseRule(rules[i])) return true;
  }

  function $shouldUseRule($rule) {
    return it.schema[$rule.keyword] !== undefined || ($rule.implements && $ruleImplementsSomeKeyword($rule));
  }

  function $ruleImplementsSomeKeyword($rule) {
    var impl = $rule.implements;
    for (var i = 0; i < impl.length; i++)
      if (it.schema[impl[i]] !== undefined) return true;
  }
  return out;
}


/***/ }),

/***/ 14895:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var IDENTIFIER = /^[a-z_$][a-z0-9_$-]*$/i;
var customRuleCode = __webpack_require__(14165);
var definitionSchema = __webpack_require__(61128);

module.exports = {
  add: addKeyword,
  get: getKeyword,
  remove: removeKeyword,
  validate: validateKeyword
};


/**
 * Define custom keyword
 * @this  Ajv
 * @param {String} keyword custom keyword, should be unique (including different from all standard, custom and macro keywords).
 * @param {Object} definition keyword definition object with properties `type` (type(s) which the keyword applies to), `validate` or `compile`.
 * @return {Ajv} this for method chaining
 */
function addKeyword(keyword, definition) {
  /* jshint validthis: true */
  /* eslint no-shadow: 0 */
  var RULES = this.RULES;
  if (RULES.keywords[keyword])
    throw new Error('Keyword ' + keyword + ' is already defined');

  if (!IDENTIFIER.test(keyword))
    throw new Error('Keyword ' + keyword + ' is not a valid identifier');

  if (definition) {
    this.validateKeyword(definition, true);

    var dataType = definition.type;
    if (Array.isArray(dataType)) {
      for (var i=0; i<dataType.length; i++)
        _addRule(keyword, dataType[i], definition);
    } else {
      _addRule(keyword, dataType, definition);
    }

    var metaSchema = definition.metaSchema;
    if (metaSchema) {
      if (definition.$data && this._opts.$data) {
        metaSchema = {
          anyOf: [
            metaSchema,
            { '$ref': 'https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#' }
          ]
        };
      }
      definition.validateSchema = this.compile(metaSchema, true);
    }
  }

  RULES.keywords[keyword] = RULES.all[keyword] = true;


  function _addRule(keyword, dataType, definition) {
    var ruleGroup;
    for (var i=0; i<RULES.length; i++) {
      var rg = RULES[i];
      if (rg.type == dataType) {
        ruleGroup = rg;
        break;
      }
    }

    if (!ruleGroup) {
      ruleGroup = { type: dataType, rules: [] };
      RULES.push(ruleGroup);
    }

    var rule = {
      keyword: keyword,
      definition: definition,
      custom: true,
      code: customRuleCode,
      implements: definition.implements
    };
    ruleGroup.rules.push(rule);
    RULES.custom[keyword] = rule;
  }

  return this;
}


/**
 * Get keyword
 * @this  Ajv
 * @param {String} keyword pre-defined or custom keyword.
 * @return {Object|Boolean} custom keyword definition, `true` if it is a predefined keyword, `false` otherwise.
 */
function getKeyword(keyword) {
  /* jshint validthis: true */
  var rule = this.RULES.custom[keyword];
  return rule ? rule.definition : this.RULES.keywords[keyword] || false;
}


/**
 * Remove keyword
 * @this  Ajv
 * @param {String} keyword pre-defined or custom keyword.
 * @return {Ajv} this for method chaining
 */
function removeKeyword(keyword) {
  /* jshint validthis: true */
  var RULES = this.RULES;
  delete RULES.keywords[keyword];
  delete RULES.all[keyword];
  delete RULES.custom[keyword];
  for (var i=0; i<RULES.length; i++) {
    var rules = RULES[i].rules;
    for (var j=0; j<rules.length; j++) {
      if (rules[j].keyword == keyword) {
        rules.splice(j, 1);
        break;
      }
    }
  }
  return this;
}


/**
 * Validate keyword definition
 * @this  Ajv
 * @param {Object} definition keyword definition object.
 * @param {Boolean} throwError true to throw exception if definition is invalid
 * @return {boolean} validation result
 */
function validateKeyword(definition, throwError) {
  validateKeyword.errors = null;
  var v = this._validateKeyword = this._validateKeyword
                                  || this.compile(definitionSchema, true);

  if (v(definition)) return true;
  validateKeyword.errors = v.errors;
  if (throwError)
    throw new Error('custom keyword definition is invalid: '  + this.errorsText(v.errors));
  else
    return false;
}


/***/ }),

/***/ 66835:
/***/ ((module) => {

"use strict";
module.exports = JSON.parse('{"$schema":"http://json-schema.org/draft-07/schema#","$id":"https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#","description":"Meta-schema for $data reference (JSON Schema extension proposal)","type":"object","required":["$data"],"properties":{"$data":{"type":"string","anyOf":[{"format":"relative-json-pointer"},{"format":"json-pointer"}]}},"additionalProperties":false}');

/***/ }),

/***/ 81030:
/***/ ((module) => {

"use strict";
module.exports = JSON.parse('{"$schema":"http://json-schema.org/draft-06/schema#","$id":"http://json-schema.org/draft-06/schema#","title":"Core schema meta-schema","definitions":{"schemaArray":{"type":"array","minItems":1,"items":{"$ref":"#"}},"nonNegativeInteger":{"type":"integer","minimum":0},"nonNegativeIntegerDefault0":{"allOf":[{"$ref":"#/definitions/nonNegativeInteger"},{"default":0}]},"simpleTypes":{"enum":["array","boolean","integer","null","number","object","string"]},"stringArray":{"type":"array","items":{"type":"string"},"uniqueItems":true,"default":[]}},"type":["object","boolean"],"properties":{"$id":{"type":"string","format":"uri-reference"},"$schema":{"type":"string","format":"uri"},"$ref":{"type":"string","format":"uri-reference"},"title":{"type":"string"},"description":{"type":"string"},"default":{},"examples":{"type":"array","items":{}},"multipleOf":{"type":"number","exclusiveMinimum":0},"maximum":{"type":"number"},"exclusiveMaximum":{"type":"number"},"minimum":{"type":"number"},"exclusiveMinimum":{"type":"number"},"maxLength":{"$ref":"#/definitions/nonNegativeInteger"},"minLength":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"pattern":{"type":"string","format":"regex"},"additionalItems":{"$ref":"#"},"items":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/schemaArray"}],"default":{}},"maxItems":{"$ref":"#/definitions/nonNegativeInteger"},"minItems":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"uniqueItems":{"type":"boolean","default":false},"contains":{"$ref":"#"},"maxProperties":{"$ref":"#/definitions/nonNegativeInteger"},"minProperties":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"required":{"$ref":"#/definitions/stringArray"},"additionalProperties":{"$ref":"#"},"definitions":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"properties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"patternProperties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"dependencies":{"type":"object","additionalProperties":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/stringArray"}]}},"propertyNames":{"$ref":"#"},"const":{},"enum":{"type":"array","minItems":1,"uniqueItems":true},"type":{"anyOf":[{"$ref":"#/definitions/simpleTypes"},{"type":"array","items":{"$ref":"#/definitions/simpleTypes"},"minItems":1,"uniqueItems":true}]},"format":{"type":"string"},"allOf":{"$ref":"#/definitions/schemaArray"},"anyOf":{"$ref":"#/definitions/schemaArray"},"oneOf":{"$ref":"#/definitions/schemaArray"},"not":{"$ref":"#"}},"default":{}}');

/***/ }),

/***/ 40038:
/***/ ((module) => {

"use strict";
module.exports = JSON.parse('{"$schema":"http://json-schema.org/draft-07/schema#","$id":"http://json-schema.org/draft-07/schema#","title":"Core schema meta-schema","definitions":{"schemaArray":{"type":"array","minItems":1,"items":{"$ref":"#"}},"nonNegativeInteger":{"type":"integer","minimum":0},"nonNegativeIntegerDefault0":{"allOf":[{"$ref":"#/definitions/nonNegativeInteger"},{"default":0}]},"simpleTypes":{"enum":["array","boolean","integer","null","number","object","string"]},"stringArray":{"type":"array","items":{"type":"string"},"uniqueItems":true,"default":[]}},"type":["object","boolean"],"properties":{"$id":{"type":"string","format":"uri-reference"},"$schema":{"type":"string","format":"uri"},"$ref":{"type":"string","format":"uri-reference"},"$comment":{"type":"string"},"title":{"type":"string"},"description":{"type":"string"},"default":true,"readOnly":{"type":"boolean","default":false},"examples":{"type":"array","items":true},"multipleOf":{"type":"number","exclusiveMinimum":0},"maximum":{"type":"number"},"exclusiveMaximum":{"type":"number"},"minimum":{"type":"number"},"exclusiveMinimum":{"type":"number"},"maxLength":{"$ref":"#/definitions/nonNegativeInteger"},"minLength":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"pattern":{"type":"string","format":"regex"},"additionalItems":{"$ref":"#"},"items":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/schemaArray"}],"default":true},"maxItems":{"$ref":"#/definitions/nonNegativeInteger"},"minItems":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"uniqueItems":{"type":"boolean","default":false},"contains":{"$ref":"#"},"maxProperties":{"$ref":"#/definitions/nonNegativeInteger"},"minProperties":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"required":{"$ref":"#/definitions/stringArray"},"additionalProperties":{"$ref":"#"},"definitions":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"properties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"patternProperties":{"type":"object","additionalProperties":{"$ref":"#"},"propertyNames":{"format":"regex"},"default":{}},"dependencies":{"type":"object","additionalProperties":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/stringArray"}]}},"propertyNames":{"$ref":"#"},"const":true,"enum":{"type":"array","items":true,"minItems":1,"uniqueItems":true},"type":{"anyOf":[{"$ref":"#/definitions/simpleTypes"},{"type":"array","items":{"$ref":"#/definitions/simpleTypes"},"minItems":1,"uniqueItems":true}]},"format":{"type":"string"},"contentMediaType":{"type":"string"},"contentEncoding":{"type":"string"},"if":{"$ref":"#"},"then":{"$ref":"#"},"else":{"$ref":"#"},"allOf":{"$ref":"#/definitions/schemaArray"},"anyOf":{"$ref":"#/definitions/schemaArray"},"oneOf":{"$ref":"#/definitions/schemaArray"},"not":{"$ref":"#"}},"default":true}');

/***/ }),

/***/ 54126:
/***/ ((__unused_webpack_module, exports) => {

// ANSI color code outputs for strings

var ANSI_CODES = {
  "off": 0,
  "bold": 1,
  "italic": 3,
  "underline": 4,
  "blink": 5,
  "inverse": 7,
  "hidden": 8,
  "black": 30,
  "red": 31,
  "green": 32,
  "yellow": 33,
  "blue": 34,
  "magenta": 35,
  "cyan": 36,
  "white": 37,
  "black_bg": 40,
  "red_bg": 41,
  "green_bg": 42,
  "yellow_bg": 43,
  "blue_bg": 44,
  "magenta_bg": 45,
  "cyan_bg": 46,
  "white_bg": 47
};

exports.t = function(str, color) {
  if(!color) return str;

  var color_attrs = color.split("+");
  var ansi_str = "";
  for(var i=0, attr; attr = color_attrs[i]; i++) {
    ansi_str += "\033[" + ANSI_CODES[attr] + "m";
  }
  ansi_str += str + "\033[" + ANSI_CODES["off"] + "m";
  return ansi_str;
};

/***/ }),

/***/ 72521:
/***/ ((module) => {

"use strict";


/**
 * Expose `arrayFlatten`.
 */
module.exports = arrayFlatten

/**
 * Recursive flatten function with depth.
 *
 * @param  {Array}  array
 * @param  {Array}  result
 * @param  {Number} depth
 * @return {Array}
 */
function flattenWithDepth (array, result, depth) {
  for (var i = 0; i < array.length; i++) {
    var value = array[i]

    if (depth > 0 && Array.isArray(value)) {
      flattenWithDepth(value, result, depth - 1)
    } else {
      result.push(value)
    }
  }

  return result
}

/**
 * Recursive flatten function. Omitting depth is slightly faster.
 *
 * @param  {Array} array
 * @param  {Array} result
 * @return {Array}
 */
function flattenForever (array, result) {
  for (var i = 0; i < array.length; i++) {
    var value = array[i]

    if (Array.isArray(value)) {
      flattenForever(value, result)
    } else {
      result.push(value)
    }
  }

  return result
}

/**
 * Flatten an array, with the ability to define a depth.
 *
 * @param  {Array}  array
 * @param  {Number} depth
 * @return {Array}
 */
function arrayFlatten (array, depth) {
  if (depth == null) {
    return flattenForever(array, [])
  }

  return flattenWithDepth(array, [], depth)
}


/***/ }),

/***/ 83407:
/***/ ((module) => {

// Copyright 2011 Mark Cavage <mcavage@gmail.com> All rights reserved.


module.exports = {

  newInvalidAsn1Error: function (msg) {
    var e = new Error();
    e.name = 'InvalidAsn1Error';
    e.message = msg || '';
    return e;
  }

};


/***/ }),

/***/ 20279:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Copyright 2011 Mark Cavage <mcavage@gmail.com> All rights reserved.

var errors = __webpack_require__(83407);
var types = __webpack_require__(34478);

var Reader = __webpack_require__(24578);
var Writer = __webpack_require__(3609);


// --- Exports

module.exports = {

  Reader: Reader,

  Writer: Writer

};

for (var t in types) {
  if (types.hasOwnProperty(t))
    module.exports[t] = types[t];
}
for (var e in errors) {
  if (errors.hasOwnProperty(e))
    module.exports[e] = errors[e];
}


/***/ }),

/***/ 24578:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Copyright 2011 Mark Cavage <mcavage@gmail.com> All rights reserved.

var assert = __webpack_require__(42357);
var Buffer = __webpack_require__(2399).Buffer;

var ASN1 = __webpack_require__(34478);
var errors = __webpack_require__(83407);


// --- Globals

var newInvalidAsn1Error = errors.newInvalidAsn1Error;



// --- API

function Reader(data) {
  if (!data || !Buffer.isBuffer(data))
    throw new TypeError('data must be a node Buffer');

  this._buf = data;
  this._size = data.length;

  // These hold the "current" state
  this._len = 0;
  this._offset = 0;
}

Object.defineProperty(Reader.prototype, 'length', {
  enumerable: true,
  get: function () { return (this._len); }
});

Object.defineProperty(Reader.prototype, 'offset', {
  enumerable: true,
  get: function () { return (this._offset); }
});

Object.defineProperty(Reader.prototype, 'remain', {
  get: function () { return (this._size - this._offset); }
});

Object.defineProperty(Reader.prototype, 'buffer', {
  get: function () { return (this._buf.slice(this._offset)); }
});


/**
 * Reads a single byte and advances offset; you can pass in `true` to make this
 * a "peek" operation (i.e., get the byte, but don't advance the offset).
 *
 * @param {Boolean} peek true means don't move offset.
 * @return {Number} the next byte, null if not enough data.
 */
Reader.prototype.readByte = function (peek) {
  if (this._size - this._offset < 1)
    return null;

  var b = this._buf[this._offset] & 0xff;

  if (!peek)
    this._offset += 1;

  return b;
};


Reader.prototype.peek = function () {
  return this.readByte(true);
};


/**
 * Reads a (potentially) variable length off the BER buffer.  This call is
 * not really meant to be called directly, as callers have to manipulate
 * the internal buffer afterwards.
 *
 * As a result of this call, you can call `Reader.length`, until the
 * next thing called that does a readLength.
 *
 * @return {Number} the amount of offset to advance the buffer.
 * @throws {InvalidAsn1Error} on bad ASN.1
 */
Reader.prototype.readLength = function (offset) {
  if (offset === undefined)
    offset = this._offset;

  if (offset >= this._size)
    return null;

  var lenB = this._buf[offset++] & 0xff;
  if (lenB === null)
    return null;

  if ((lenB & 0x80) === 0x80) {
    lenB &= 0x7f;

    if (lenB === 0)
      throw newInvalidAsn1Error('Indefinite length not supported');

    if (lenB > 4)
      throw newInvalidAsn1Error('encoding too long');

    if (this._size - offset < lenB)
      return null;

    this._len = 0;
    for (var i = 0; i < lenB; i++)
      this._len = (this._len << 8) + (this._buf[offset++] & 0xff);

  } else {
    // Wasn't a variable length
    this._len = lenB;
  }

  return offset;
};


/**
 * Parses the next sequence in this BER buffer.
 *
 * To get the length of the sequence, call `Reader.length`.
 *
 * @return {Number} the sequence's tag.
 */
Reader.prototype.readSequence = function (tag) {
  var seq = this.peek();
  if (seq === null)
    return null;
  if (tag !== undefined && tag !== seq)
    throw newInvalidAsn1Error('Expected 0x' + tag.toString(16) +
                              ': got 0x' + seq.toString(16));

  var o = this.readLength(this._offset + 1); // stored in `length`
  if (o === null)
    return null;

  this._offset = o;
  return seq;
};


Reader.prototype.readInt = function () {
  return this._readTag(ASN1.Integer);
};


Reader.prototype.readBoolean = function () {
  return (this._readTag(ASN1.Boolean) === 0 ? false : true);
};


Reader.prototype.readEnumeration = function () {
  return this._readTag(ASN1.Enumeration);
};


Reader.prototype.readString = function (tag, retbuf) {
  if (!tag)
    tag = ASN1.OctetString;

  var b = this.peek();
  if (b === null)
    return null;

  if (b !== tag)
    throw newInvalidAsn1Error('Expected 0x' + tag.toString(16) +
                              ': got 0x' + b.toString(16));

  var o = this.readLength(this._offset + 1); // stored in `length`

  if (o === null)
    return null;

  if (this.length > this._size - o)
    return null;

  this._offset = o;

  if (this.length === 0)
    return retbuf ? Buffer.alloc(0) : '';

  var str = this._buf.slice(this._offset, this._offset + this.length);
  this._offset += this.length;

  return retbuf ? str : str.toString('utf8');
};

Reader.prototype.readOID = function (tag) {
  if (!tag)
    tag = ASN1.OID;

  var b = this.readString(tag, true);
  if (b === null)
    return null;

  var values = [];
  var value = 0;

  for (var i = 0; i < b.length; i++) {
    var byte = b[i] & 0xff;

    value <<= 7;
    value += byte & 0x7f;
    if ((byte & 0x80) === 0) {
      values.push(value);
      value = 0;
    }
  }

  value = values.shift();
  values.unshift(value % 40);
  values.unshift((value / 40) >> 0);

  return values.join('.');
};


Reader.prototype._readTag = function (tag) {
  assert.ok(tag !== undefined);

  var b = this.peek();

  if (b === null)
    return null;

  if (b !== tag)
    throw newInvalidAsn1Error('Expected 0x' + tag.toString(16) +
                              ': got 0x' + b.toString(16));

  var o = this.readLength(this._offset + 1); // stored in `length`
  if (o === null)
    return null;

  if (this.length > 4)
    throw newInvalidAsn1Error('Integer too long: ' + this.length);

  if (this.length > this._size - o)
    return null;
  this._offset = o;

  var fb = this._buf[this._offset];
  var value = 0;

  for (var i = 0; i < this.length; i++) {
    value <<= 8;
    value |= (this._buf[this._offset++] & 0xff);
  }

  if ((fb & 0x80) === 0x80 && i !== 4)
    value -= (1 << (i * 8));

  return value >> 0;
};



// --- Exported API

module.exports = Reader;


/***/ }),

/***/ 34478:
/***/ ((module) => {

// Copyright 2011 Mark Cavage <mcavage@gmail.com> All rights reserved.


module.exports = {
  EOC: 0,
  Boolean: 1,
  Integer: 2,
  BitString: 3,
  OctetString: 4,
  Null: 5,
  OID: 6,
  ObjectDescriptor: 7,
  External: 8,
  Real: 9, // float
  Enumeration: 10,
  PDV: 11,
  Utf8String: 12,
  RelativeOID: 13,
  Sequence: 16,
  Set: 17,
  NumericString: 18,
  PrintableString: 19,
  T61String: 20,
  VideotexString: 21,
  IA5String: 22,
  UTCTime: 23,
  GeneralizedTime: 24,
  GraphicString: 25,
  VisibleString: 26,
  GeneralString: 28,
  UniversalString: 29,
  CharacterString: 30,
  BMPString: 31,
  Constructor: 32,
  Context: 128
};


/***/ }),

/***/ 3609:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Copyright 2011 Mark Cavage <mcavage@gmail.com> All rights reserved.

var assert = __webpack_require__(42357);
var Buffer = __webpack_require__(2399).Buffer;
var ASN1 = __webpack_require__(34478);
var errors = __webpack_require__(83407);


// --- Globals

var newInvalidAsn1Error = errors.newInvalidAsn1Error;

var DEFAULT_OPTS = {
  size: 1024,
  growthFactor: 8
};


// --- Helpers

function merge(from, to) {
  assert.ok(from);
  assert.equal(typeof (from), 'object');
  assert.ok(to);
  assert.equal(typeof (to), 'object');

  var keys = Object.getOwnPropertyNames(from);
  keys.forEach(function (key) {
    if (to[key])
      return;

    var value = Object.getOwnPropertyDescriptor(from, key);
    Object.defineProperty(to, key, value);
  });

  return to;
}



// --- API

function Writer(options) {
  options = merge(DEFAULT_OPTS, options || {});

  this._buf = Buffer.alloc(options.size || 1024);
  this._size = this._buf.length;
  this._offset = 0;
  this._options = options;

  // A list of offsets in the buffer where we need to insert
  // sequence tag/len pairs.
  this._seq = [];
}

Object.defineProperty(Writer.prototype, 'buffer', {
  get: function () {
    if (this._seq.length)
      throw newInvalidAsn1Error(this._seq.length + ' unended sequence(s)');

    return (this._buf.slice(0, this._offset));
  }
});

Writer.prototype.writeByte = function (b) {
  if (typeof (b) !== 'number')
    throw new TypeError('argument must be a Number');

  this._ensure(1);
  this._buf[this._offset++] = b;
};


Writer.prototype.writeInt = function (i, tag) {
  if (typeof (i) !== 'number')
    throw new TypeError('argument must be a Number');
  if (typeof (tag) !== 'number')
    tag = ASN1.Integer;

  var sz = 4;

  while ((((i & 0xff800000) === 0) || ((i & 0xff800000) === 0xff800000 >> 0)) &&
        (sz > 1)) {
    sz--;
    i <<= 8;
  }

  if (sz > 4)
    throw newInvalidAsn1Error('BER ints cannot be > 0xffffffff');

  this._ensure(2 + sz);
  this._buf[this._offset++] = tag;
  this._buf[this._offset++] = sz;

  while (sz-- > 0) {
    this._buf[this._offset++] = ((i & 0xff000000) >>> 24);
    i <<= 8;
  }

};


Writer.prototype.writeNull = function () {
  this.writeByte(ASN1.Null);
  this.writeByte(0x00);
};


Writer.prototype.writeEnumeration = function (i, tag) {
  if (typeof (i) !== 'number')
    throw new TypeError('argument must be a Number');
  if (typeof (tag) !== 'number')
    tag = ASN1.Enumeration;

  return this.writeInt(i, tag);
};


Writer.prototype.writeBoolean = function (b, tag) {
  if (typeof (b) !== 'boolean')
    throw new TypeError('argument must be a Boolean');
  if (typeof (tag) !== 'number')
    tag = ASN1.Boolean;

  this._ensure(3);
  this._buf[this._offset++] = tag;
  this._buf[this._offset++] = 0x01;
  this._buf[this._offset++] = b ? 0xff : 0x00;
};


Writer.prototype.writeString = function (s, tag) {
  if (typeof (s) !== 'string')
    throw new TypeError('argument must be a string (was: ' + typeof (s) + ')');
  if (typeof (tag) !== 'number')
    tag = ASN1.OctetString;

  var len = Buffer.byteLength(s);
  this.writeByte(tag);
  this.writeLength(len);
  if (len) {
    this._ensure(len);
    this._buf.write(s, this._offset);
    this._offset += len;
  }
};


Writer.prototype.writeBuffer = function (buf, tag) {
  if (typeof (tag) !== 'number')
    throw new TypeError('tag must be a number');
  if (!Buffer.isBuffer(buf))
    throw new TypeError('argument must be a buffer');

  this.writeByte(tag);
  this.writeLength(buf.length);
  this._ensure(buf.length);
  buf.copy(this._buf, this._offset, 0, buf.length);
  this._offset += buf.length;
};


Writer.prototype.writeStringArray = function (strings) {
  if ((!strings instanceof Array))
    throw new TypeError('argument must be an Array[String]');

  var self = this;
  strings.forEach(function (s) {
    self.writeString(s);
  });
};

// This is really to solve DER cases, but whatever for now
Writer.prototype.writeOID = function (s, tag) {
  if (typeof (s) !== 'string')
    throw new TypeError('argument must be a string');
  if (typeof (tag) !== 'number')
    tag = ASN1.OID;

  if (!/^([0-9]+\.){3,}[0-9]+$/.test(s))
    throw new Error('argument is not a valid OID string');

  function encodeOctet(bytes, octet) {
    if (octet < 128) {
        bytes.push(octet);
    } else if (octet < 16384) {
        bytes.push((octet >>> 7) | 0x80);
        bytes.push(octet & 0x7F);
    } else if (octet < 2097152) {
      bytes.push((octet >>> 14) | 0x80);
      bytes.push(((octet >>> 7) | 0x80) & 0xFF);
      bytes.push(octet & 0x7F);
    } else if (octet < 268435456) {
      bytes.push((octet >>> 21) | 0x80);
      bytes.push(((octet >>> 14) | 0x80) & 0xFF);
      bytes.push(((octet >>> 7) | 0x80) & 0xFF);
      bytes.push(octet & 0x7F);
    } else {
      bytes.push(((octet >>> 28) | 0x80) & 0xFF);
      bytes.push(((octet >>> 21) | 0x80) & 0xFF);
      bytes.push(((octet >>> 14) | 0x80) & 0xFF);
      bytes.push(((octet >>> 7) | 0x80) & 0xFF);
      bytes.push(octet & 0x7F);
    }
  }

  var tmp = s.split('.');
  var bytes = [];
  bytes.push(parseInt(tmp[0], 10) * 40 + parseInt(tmp[1], 10));
  tmp.slice(2).forEach(function (b) {
    encodeOctet(bytes, parseInt(b, 10));
  });

  var self = this;
  this._ensure(2 + bytes.length);
  this.writeByte(tag);
  this.writeLength(bytes.length);
  bytes.forEach(function (b) {
    self.writeByte(b);
  });
};


Writer.prototype.writeLength = function (len) {
  if (typeof (len) !== 'number')
    throw new TypeError('argument must be a Number');

  this._ensure(4);

  if (len <= 0x7f) {
    this._buf[this._offset++] = len;
  } else if (len <= 0xff) {
    this._buf[this._offset++] = 0x81;
    this._buf[this._offset++] = len;
  } else if (len <= 0xffff) {
    this._buf[this._offset++] = 0x82;
    this._buf[this._offset++] = len >> 8;
    this._buf[this._offset++] = len;
  } else if (len <= 0xffffff) {
    this._buf[this._offset++] = 0x83;
    this._buf[this._offset++] = len >> 16;
    this._buf[this._offset++] = len >> 8;
    this._buf[this._offset++] = len;
  } else {
    throw newInvalidAsn1Error('Length too long (> 4 bytes)');
  }
};

Writer.prototype.startSequence = function (tag) {
  if (typeof (tag) !== 'number')
    tag = ASN1.Sequence | ASN1.Constructor;

  this.writeByte(tag);
  this._seq.push(this._offset);
  this._ensure(3);
  this._offset += 3;
};


Writer.prototype.endSequence = function () {
  var seq = this._seq.pop();
  var start = seq + 3;
  var len = this._offset - start;

  if (len <= 0x7f) {
    this._shift(start, len, -2);
    this._buf[seq] = len;
  } else if (len <= 0xff) {
    this._shift(start, len, -1);
    this._buf[seq] = 0x81;
    this._buf[seq + 1] = len;
  } else if (len <= 0xffff) {
    this._buf[seq] = 0x82;
    this._buf[seq + 1] = len >> 8;
    this._buf[seq + 2] = len;
  } else if (len <= 0xffffff) {
    this._shift(start, len, 1);
    this._buf[seq] = 0x83;
    this._buf[seq + 1] = len >> 16;
    this._buf[seq + 2] = len >> 8;
    this._buf[seq + 3] = len;
  } else {
    throw newInvalidAsn1Error('Sequence too long');
  }
};


Writer.prototype._shift = function (start, len, shift) {
  assert.ok(start !== undefined);
  assert.ok(len !== undefined);
  assert.ok(shift);

  this._buf.copy(this._buf, start + shift, start, start + len);
  this._offset += shift;
};

Writer.prototype._ensure = function (len) {
  assert.ok(len);

  if (this._size - this._offset < len) {
    var sz = this._size * this._options.growthFactor;
    if (sz - this._offset < len)
      sz += len;

    var buf = Buffer.alloc(sz);

    this._buf.copy(buf, 0, 0, this._offset);
    this._buf = buf;
    this._size = sz;
  }
};



// --- Exported API

module.exports = Writer;


/***/ }),

/***/ 90476:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Copyright 2011 Mark Cavage <mcavage@gmail.com> All rights reserved.

// If you have no idea what ASN.1 or BER is, see this:
// ftp://ftp.rsa.com/pub/pkcs/ascii/layman.asc

var Ber = __webpack_require__(20279);



// --- Exported API

module.exports = {

  Ber: Ber,

  BerReader: Ber.Reader,

  BerWriter: Ber.Writer

};


/***/ }),

/***/ 6144:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* provided dependency */ var Buffer = __webpack_require__(64293)["Buffer"];
/* provided dependency */ var process = __webpack_require__(34155);
// Copyright (c) 2012, Mark Cavage. All rights reserved.
// Copyright 2015 Joyent, Inc.

var assert = __webpack_require__(42357);
var Stream = __webpack_require__(92413).Stream;
var util = __webpack_require__(31669);


///--- Globals

/* JSSTYLED */
var UUID_REGEXP = /^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/;


///--- Internal

function _capitalize(str) {
    return (str.charAt(0).toUpperCase() + str.slice(1));
}

function _toss(name, expected, oper, arg, actual) {
    throw new assert.AssertionError({
        message: util.format('%s (%s) is required', name, expected),
        actual: (actual === undefined) ? typeof (arg) : actual(arg),
        expected: expected,
        operator: oper || '===',
        stackStartFunction: _toss.caller
    });
}

function _getClass(arg) {
    return (Object.prototype.toString.call(arg).slice(8, -1));
}

function noop() {
    // Why even bother with asserts?
}


///--- Exports

var types = {
    bool: {
        check: function (arg) { return typeof (arg) === 'boolean'; }
    },
    func: {
        check: function (arg) { return typeof (arg) === 'function'; }
    },
    string: {
        check: function (arg) { return typeof (arg) === 'string'; }
    },
    object: {
        check: function (arg) {
            return typeof (arg) === 'object' && arg !== null;
        }
    },
    number: {
        check: function (arg) {
            return typeof (arg) === 'number' && !isNaN(arg);
        }
    },
    finite: {
        check: function (arg) {
            return typeof (arg) === 'number' && !isNaN(arg) && isFinite(arg);
        }
    },
    buffer: {
        check: function (arg) { return Buffer.isBuffer(arg); },
        operator: 'Buffer.isBuffer'
    },
    array: {
        check: function (arg) { return Array.isArray(arg); },
        operator: 'Array.isArray'
    },
    stream: {
        check: function (arg) { return arg instanceof Stream; },
        operator: 'instanceof',
        actual: _getClass
    },
    date: {
        check: function (arg) { return arg instanceof Date; },
        operator: 'instanceof',
        actual: _getClass
    },
    regexp: {
        check: function (arg) { return arg instanceof RegExp; },
        operator: 'instanceof',
        actual: _getClass
    },
    uuid: {
        check: function (arg) {
            return typeof (arg) === 'string' && UUID_REGEXP.test(arg);
        },
        operator: 'isUUID'
    }
};

function _setExports(ndebug) {
    var keys = Object.keys(types);
    var out;

    /* re-export standard assert */
    if (process.env.NODE_NDEBUG) {
        out = noop;
    } else {
        out = function (arg, msg) {
            if (!arg) {
                _toss(msg, 'true', arg);
            }
        };
    }

    /* standard checks */
    keys.forEach(function (k) {
        if (ndebug) {
            out[k] = noop;
            return;
        }
        var type = types[k];
        out[k] = function (arg, msg) {
            if (!type.check(arg)) {
                _toss(msg, k, type.operator, arg, type.actual);
            }
        };
    });

    /* optional checks */
    keys.forEach(function (k) {
        var name = 'optional' + _capitalize(k);
        if (ndebug) {
            out[name] = noop;
            return;
        }
        var type = types[k];
        out[name] = function (arg, msg) {
            if (arg === undefined || arg === null) {
                return;
            }
            if (!type.check(arg)) {
                _toss(msg, k, type.operator, arg, type.actual);
            }
        };
    });

    /* arrayOf checks */
    keys.forEach(function (k) {
        var name = 'arrayOf' + _capitalize(k);
        if (ndebug) {
            out[name] = noop;
            return;
        }
        var type = types[k];
        var expected = '[' + k + ']';
        out[name] = function (arg, msg) {
            if (!Array.isArray(arg)) {
                _toss(msg, expected, type.operator, arg, type.actual);
            }
            var i;
            for (i = 0; i < arg.length; i++) {
                if (!type.check(arg[i])) {
                    _toss(msg, expected, type.operator, arg, type.actual);
                }
            }
        };
    });

    /* optionalArrayOf checks */
    keys.forEach(function (k) {
        var name = 'optionalArrayOf' + _capitalize(k);
        if (ndebug) {
            out[name] = noop;
            return;
        }
        var type = types[k];
        var expected = '[' + k + ']';
        out[name] = function (arg, msg) {
            if (arg === undefined || arg === null) {
                return;
            }
            if (!Array.isArray(arg)) {
                _toss(msg, expected, type.operator, arg, type.actual);
            }
            var i;
            for (i = 0; i < arg.length; i++) {
                if (!type.check(arg[i])) {
                    _toss(msg, expected, type.operator, arg, type.actual);
                }
            }
        };
    });

    /* re-export built-in assertions */
    Object.keys(assert).forEach(function (k) {
        if (k === 'AssertionError') {
            out[k] = assert[k];
            return;
        }
        if (ndebug) {
            out[k] = noop;
            return;
        }
        out[k] = assert[k];
    });

    /* export ourselves (for unit tests _only_) */
    out._setExports = _setExports;

    return out;
}

module.exports = _setExports(process.env.NODE_NDEBUG);


/***/ }),

/***/ 10950:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* provided dependency */ var process = __webpack_require__(34155);
module.exports = function (arr, iterator, callback) {
  callback = callback || function () {};
  if (!Array.isArray(arr) || !arr.length) {
      return callback();
  }
  var completed = 0;
  var iterate = function () {
    iterator(arr[completed], function (err) {
      if (err) {
        callback(err);
        callback = function () {};
      }
      else {
        ++completed;
        if (completed >= arr.length) { callback(); }
        else { nextTick(iterate); }
      }
    });
  };
  iterate();
};

function nextTick (cb) {
  if (typeof setImmediate === 'function') {
    setImmediate(cb);
  } else {
    process.nextTick(cb);
  }
}

/***/ }),

/***/ 57664:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "apply": () => (/* binding */ apply),
/* harmony export */   "applyEach": () => (/* binding */ applyEach$1),
/* harmony export */   "applyEachSeries": () => (/* binding */ applyEachSeries),
/* harmony export */   "asyncify": () => (/* binding */ asyncify),
/* harmony export */   "auto": () => (/* binding */ auto),
/* harmony export */   "autoInject": () => (/* binding */ autoInject),
/* harmony export */   "cargo": () => (/* binding */ cargo),
/* harmony export */   "cargoQueue": () => (/* binding */ cargo$1),
/* harmony export */   "compose": () => (/* binding */ compose),
/* harmony export */   "concat": () => (/* binding */ concat$1),
/* harmony export */   "concatLimit": () => (/* binding */ concatLimit$1),
/* harmony export */   "concatSeries": () => (/* binding */ concatSeries$1),
/* harmony export */   "constant": () => (/* binding */ constant),
/* harmony export */   "detect": () => (/* binding */ detect$1),
/* harmony export */   "detectLimit": () => (/* binding */ detectLimit$1),
/* harmony export */   "detectSeries": () => (/* binding */ detectSeries$1),
/* harmony export */   "dir": () => (/* binding */ dir),
/* harmony export */   "doUntil": () => (/* binding */ doUntil),
/* harmony export */   "doWhilst": () => (/* binding */ doWhilst$1),
/* harmony export */   "each": () => (/* binding */ each),
/* harmony export */   "eachLimit": () => (/* binding */ eachLimit$2),
/* harmony export */   "eachOf": () => (/* binding */ eachOf$1),
/* harmony export */   "eachOfLimit": () => (/* binding */ eachOfLimit$2),
/* harmony export */   "eachOfSeries": () => (/* binding */ eachOfSeries$1),
/* harmony export */   "eachSeries": () => (/* binding */ eachSeries$1),
/* harmony export */   "ensureAsync": () => (/* binding */ ensureAsync),
/* harmony export */   "every": () => (/* binding */ every$1),
/* harmony export */   "everyLimit": () => (/* binding */ everyLimit$1),
/* harmony export */   "everySeries": () => (/* binding */ everySeries$1),
/* harmony export */   "filter": () => (/* binding */ filter$1),
/* harmony export */   "filterLimit": () => (/* binding */ filterLimit$1),
/* harmony export */   "filterSeries": () => (/* binding */ filterSeries$1),
/* harmony export */   "forever": () => (/* binding */ forever$1),
/* harmony export */   "groupBy": () => (/* binding */ groupBy),
/* harmony export */   "groupByLimit": () => (/* binding */ groupByLimit$1),
/* harmony export */   "groupBySeries": () => (/* binding */ groupBySeries),
/* harmony export */   "log": () => (/* binding */ log),
/* harmony export */   "map": () => (/* binding */ map$1),
/* harmony export */   "mapLimit": () => (/* binding */ mapLimit$1),
/* harmony export */   "mapSeries": () => (/* binding */ mapSeries$1),
/* harmony export */   "mapValues": () => (/* binding */ mapValues),
/* harmony export */   "mapValuesLimit": () => (/* binding */ mapValuesLimit$1),
/* harmony export */   "mapValuesSeries": () => (/* binding */ mapValuesSeries),
/* harmony export */   "memoize": () => (/* binding */ memoize),
/* harmony export */   "nextTick": () => (/* binding */ nextTick),
/* harmony export */   "parallel": () => (/* binding */ parallel),
/* harmony export */   "parallelLimit": () => (/* binding */ parallelLimit),
/* harmony export */   "priorityQueue": () => (/* binding */ priorityQueue),
/* harmony export */   "queue": () => (/* binding */ queue$1),
/* harmony export */   "race": () => (/* binding */ race$1),
/* harmony export */   "reduce": () => (/* binding */ reduce$1),
/* harmony export */   "reduceRight": () => (/* binding */ reduceRight),
/* harmony export */   "reflect": () => (/* binding */ reflect),
/* harmony export */   "reflectAll": () => (/* binding */ reflectAll),
/* harmony export */   "reject": () => (/* binding */ reject$2),
/* harmony export */   "rejectLimit": () => (/* binding */ rejectLimit$1),
/* harmony export */   "rejectSeries": () => (/* binding */ rejectSeries$1),
/* harmony export */   "retry": () => (/* binding */ retry),
/* harmony export */   "retryable": () => (/* binding */ retryable),
/* harmony export */   "seq": () => (/* binding */ seq),
/* harmony export */   "series": () => (/* binding */ series),
/* harmony export */   "setImmediate": () => (/* binding */ setImmediate$1),
/* harmony export */   "some": () => (/* binding */ some$1),
/* harmony export */   "someLimit": () => (/* binding */ someLimit$1),
/* harmony export */   "someSeries": () => (/* binding */ someSeries$1),
/* harmony export */   "sortBy": () => (/* binding */ sortBy$1),
/* harmony export */   "timeout": () => (/* binding */ timeout),
/* harmony export */   "times": () => (/* binding */ times),
/* harmony export */   "timesLimit": () => (/* binding */ timesLimit),
/* harmony export */   "timesSeries": () => (/* binding */ timesSeries),
/* harmony export */   "transform": () => (/* binding */ transform),
/* harmony export */   "tryEach": () => (/* binding */ tryEach$1),
/* harmony export */   "unmemoize": () => (/* binding */ unmemoize),
/* harmony export */   "until": () => (/* binding */ until),
/* harmony export */   "waterfall": () => (/* binding */ waterfall$1),
/* harmony export */   "whilst": () => (/* binding */ whilst$1),
/* harmony export */   "all": () => (/* binding */ every$1),
/* harmony export */   "allLimit": () => (/* binding */ everyLimit$1),
/* harmony export */   "allSeries": () => (/* binding */ everySeries$1),
/* harmony export */   "any": () => (/* binding */ some$1),
/* harmony export */   "anyLimit": () => (/* binding */ someLimit$1),
/* harmony export */   "anySeries": () => (/* binding */ someSeries$1),
/* harmony export */   "find": () => (/* binding */ detect$1),
/* harmony export */   "findLimit": () => (/* binding */ detectLimit$1),
/* harmony export */   "findSeries": () => (/* binding */ detectSeries$1),
/* harmony export */   "flatMap": () => (/* binding */ concat$1),
/* harmony export */   "flatMapLimit": () => (/* binding */ concatLimit$1),
/* harmony export */   "flatMapSeries": () => (/* binding */ concatSeries$1),
/* harmony export */   "forEach": () => (/* binding */ each),
/* harmony export */   "forEachSeries": () => (/* binding */ eachSeries$1),
/* harmony export */   "forEachLimit": () => (/* binding */ eachLimit$2),
/* harmony export */   "forEachOf": () => (/* binding */ eachOf$1),
/* harmony export */   "forEachOfSeries": () => (/* binding */ eachOfSeries$1),
/* harmony export */   "forEachOfLimit": () => (/* binding */ eachOfLimit$2),
/* harmony export */   "inject": () => (/* binding */ reduce$1),
/* harmony export */   "foldl": () => (/* binding */ reduce$1),
/* harmony export */   "foldr": () => (/* binding */ reduceRight),
/* harmony export */   "select": () => (/* binding */ filter$1),
/* harmony export */   "selectLimit": () => (/* binding */ filterLimit$1),
/* harmony export */   "selectSeries": () => (/* binding */ filterSeries$1),
/* harmony export */   "wrapSync": () => (/* binding */ asyncify),
/* harmony export */   "during": () => (/* binding */ whilst$1),
/* harmony export */   "doDuring": () => (/* binding */ doWhilst$1)
/* harmony export */ });
/* provided dependency */ var process = __webpack_require__(34155);
/* provided dependency */ var console = __webpack_require__(25108);
/**
 * Creates a continuation function with some arguments already applied.
 *
 * Useful as a shorthand when combined with other control flow functions. Any
 * arguments passed to the returned function are added to the arguments
 * originally passed to apply.
 *
 * @name apply
 * @static
 * @memberOf module:Utils
 * @method
 * @category Util
 * @param {Function} fn - The function you want to eventually apply all
 * arguments to. Invokes with (arguments...).
 * @param {...*} arguments... - Any number of arguments to automatically apply
 * when the continuation is called.
 * @returns {Function} the partially-applied function
 * @example
 *
 * // using apply
 * async.parallel([
 *     async.apply(fs.writeFile, 'testfile1', 'test1'),
 *     async.apply(fs.writeFile, 'testfile2', 'test2')
 * ]);
 *
 *
 * // the same process without using apply
 * async.parallel([
 *     function(callback) {
 *         fs.writeFile('testfile1', 'test1', callback);
 *     },
 *     function(callback) {
 *         fs.writeFile('testfile2', 'test2', callback);
 *     }
 * ]);
 *
 * // It's possible to pass any number of additional arguments when calling the
 * // continuation:
 *
 * node> var fn = async.apply(sys.puts, 'one');
 * node> fn('two', 'three');
 * one
 * two
 * three
 */
function apply(fn, ...args) {
    return (...callArgs) => fn(...args,...callArgs);
}

function initialParams (fn) {
    return function (...args/*, callback*/) {
        var callback = args.pop();
        return fn.call(this, args, callback);
    };
}

/* istanbul ignore file */

var hasSetImmediate = typeof setImmediate === 'function' && setImmediate;
var hasNextTick = typeof process === 'object' && typeof process.nextTick === 'function';

function fallback(fn) {
    setTimeout(fn, 0);
}

function wrap(defer) {
    return (fn, ...args) => defer(() => fn(...args));
}

var _defer;

if (hasSetImmediate) {
    _defer = setImmediate;
} else if (hasNextTick) {
    _defer = process.nextTick;
} else {
    _defer = fallback;
}

var setImmediate$1 = wrap(_defer);

/**
 * Take a sync function and make it async, passing its return value to a
 * callback. This is useful for plugging sync functions into a waterfall,
 * series, or other async functions. Any arguments passed to the generated
 * function will be passed to the wrapped function (except for the final
 * callback argument). Errors thrown will be passed to the callback.
 *
 * If the function passed to `asyncify` returns a Promise, that promises's
 * resolved/rejected state will be used to call the callback, rather than simply
 * the synchronous return value.
 *
 * This also means you can asyncify ES2017 `async` functions.
 *
 * @name asyncify
 * @static
 * @memberOf module:Utils
 * @method
 * @alias wrapSync
 * @category Util
 * @param {Function} func - The synchronous function, or Promise-returning
 * function to convert to an {@link AsyncFunction}.
 * @returns {AsyncFunction} An asynchronous wrapper of the `func`. To be
 * invoked with `(args..., callback)`.
 * @example
 *
 * // passing a regular synchronous function
 * async.waterfall([
 *     async.apply(fs.readFile, filename, "utf8"),
 *     async.asyncify(JSON.parse),
 *     function (data, next) {
 *         // data is the result of parsing the text.
 *         // If there was a parsing error, it would have been caught.
 *     }
 * ], callback);
 *
 * // passing a function returning a promise
 * async.waterfall([
 *     async.apply(fs.readFile, filename, "utf8"),
 *     async.asyncify(function (contents) {
 *         return db.model.create(contents);
 *     }),
 *     function (model, next) {
 *         // `model` is the instantiated model object.
 *         // If there was an error, this function would be skipped.
 *     }
 * ], callback);
 *
 * // es2017 example, though `asyncify` is not needed if your JS environment
 * // supports async functions out of the box
 * var q = async.queue(async.asyncify(async function(file) {
 *     var intermediateStep = await processFile(file);
 *     return await somePromise(intermediateStep)
 * }));
 *
 * q.push(files);
 */
function asyncify(func) {
    if (isAsync(func)) {
        return function (...args/*, callback*/) {
            const callback = args.pop();
            const promise = func.apply(this, args);
            return handlePromise(promise, callback)
        }
    }

    return initialParams(function (args, callback) {
        var result;
        try {
            result = func.apply(this, args);
        } catch (e) {
            return callback(e);
        }
        // if result is Promise object
        if (result && typeof result.then === 'function') {
            return handlePromise(result, callback)
        } else {
            callback(null, result);
        }
    });
}

function handlePromise(promise, callback) {
    return promise.then(value => {
        invokeCallback(callback, null, value);
    }, err => {
        invokeCallback(callback, err && err.message ? err : new Error(err));
    });
}

function invokeCallback(callback, error, value) {
    try {
        callback(error, value);
    } catch (err) {
        setImmediate$1(e => { throw e }, err);
    }
}

function isAsync(fn) {
    return fn[Symbol.toStringTag] === 'AsyncFunction';
}

function isAsyncGenerator(fn) {
    return fn[Symbol.toStringTag] === 'AsyncGenerator';
}

function isAsyncIterable(obj) {
    return typeof obj[Symbol.asyncIterator] === 'function';
}

function wrapAsync(asyncFn) {
    if (typeof asyncFn !== 'function') throw new Error('expected a function')
    return isAsync(asyncFn) ? asyncify(asyncFn) : asyncFn;
}

// conditionally promisify a function.
// only return a promise if a callback is omitted
function awaitify (asyncFn, arity = asyncFn.length) {
    if (!arity) throw new Error('arity is undefined')
    function awaitable (...args) {
        if (typeof args[arity - 1] === 'function') {
            return asyncFn.apply(this, args)
        }

        return new Promise((resolve, reject) => {
            args[arity - 1] = (err, ...cbArgs) => {
                if (err) return reject(err)
                resolve(cbArgs.length > 1 ? cbArgs : cbArgs[0]);
            };
            asyncFn.apply(this, args);
        })
    }

    return awaitable
}

function applyEach (eachfn) {
    return function applyEach(fns, ...callArgs) {
        const go = awaitify(function (callback) {
            var that = this;
            return eachfn(fns, (fn, cb) => {
                wrapAsync(fn).apply(that, callArgs.concat(cb));
            }, callback);
        });
        return go;
    };
}

function _asyncMap(eachfn, arr, iteratee, callback) {
    arr = arr || [];
    var results = [];
    var counter = 0;
    var _iteratee = wrapAsync(iteratee);

    return eachfn(arr, (value, _, iterCb) => {
        var index = counter++;
        _iteratee(value, (err, v) => {
            results[index] = v;
            iterCb(err);
        });
    }, err => {
        callback(err, results);
    });
}

function isArrayLike(value) {
    return value &&
        typeof value.length === 'number' &&
        value.length >= 0 &&
        value.length % 1 === 0;
}

// A temporary value used to identify if the loop should be broken.
// See #1064, #1293
const breakLoop = {};

function once(fn) {
    function wrapper (...args) {
        if (fn === null) return;
        var callFn = fn;
        fn = null;
        callFn.apply(this, args);
    }
    Object.assign(wrapper, fn);
    return wrapper
}

function getIterator (coll) {
    return coll[Symbol.iterator] && coll[Symbol.iterator]();
}

function createArrayIterator(coll) {
    var i = -1;
    var len = coll.length;
    return function next() {
        return ++i < len ? {value: coll[i], key: i} : null;
    }
}

function createES2015Iterator(iterator) {
    var i = -1;
    return function next() {
        var item = iterator.next();
        if (item.done)
            return null;
        i++;
        return {value: item.value, key: i};
    }
}

function createObjectIterator(obj) {
    var okeys = obj ? Object.keys(obj) : [];
    var i = -1;
    var len = okeys.length;
    return function next() {
        var key = okeys[++i];
        return i < len ? {value: obj[key], key} : null;
    };
}

function createIterator(coll) {
    if (isArrayLike(coll)) {
        return createArrayIterator(coll);
    }

    var iterator = getIterator(coll);
    return iterator ? createES2015Iterator(iterator) : createObjectIterator(coll);
}

function onlyOnce(fn) {
    return function (...args) {
        if (fn === null) throw new Error("Callback was already called.");
        var callFn = fn;
        fn = null;
        callFn.apply(this, args);
    };
}

// for async generators
function asyncEachOfLimit(generator, limit, iteratee, callback) {
    let done = false;
    let canceled = false;
    let awaiting = false;
    let running = 0;
    let idx = 0;

    function replenish() {
        //console.log('replenish')
        if (running >= limit || awaiting || done) return
        //console.log('replenish awaiting')
        awaiting = true;
        generator.next().then(({value, done: iterDone}) => {
            //console.log('got value', value)
            if (canceled || done) return
            awaiting = false;
            if (iterDone) {
                done = true;
                if (running <= 0) {
                    //console.log('done nextCb')
                    callback(null);
                }
                return;
            }
            running++;
            iteratee(value, idx, iterateeCallback);
            idx++;
            replenish();
        }).catch(handleError);
    }

    function iterateeCallback(err, result) {
        //console.log('iterateeCallback')
        running -= 1;
        if (canceled) return
        if (err) return handleError(err)

        if (err === false) {
            done = true;
            canceled = true;
            return
        }

        if (result === breakLoop || (done && running <= 0)) {
            done = true;
            //console.log('done iterCb')
            return callback(null);
        }
        replenish();
    }

    function handleError(err) {
        if (canceled) return
        awaiting = false;
        done = true;
        callback(err);
    }

    replenish();
}

var eachOfLimit = (limit) => {
    return (obj, iteratee, callback) => {
        callback = once(callback);
        if (limit <= 0) {
            throw new RangeError('concurrency limit cannot be less than 1')
        }
        if (!obj) {
            return callback(null);
        }
        if (isAsyncGenerator(obj)) {
            return asyncEachOfLimit(obj, limit, iteratee, callback)
        }
        if (isAsyncIterable(obj)) {
            return asyncEachOfLimit(obj[Symbol.asyncIterator](), limit, iteratee, callback)
        }
        var nextElem = createIterator(obj);
        var done = false;
        var canceled = false;
        var running = 0;
        var looping = false;

        function iterateeCallback(err, value) {
            if (canceled) return
            running -= 1;
            if (err) {
                done = true;
                callback(err);
            }
            else if (err === false) {
                done = true;
                canceled = true;
            }
            else if (value === breakLoop || (done && running <= 0)) {
                done = true;
                return callback(null);
            }
            else if (!looping) {
                replenish();
            }
        }

        function replenish () {
            looping = true;
            while (running < limit && !done) {
                var elem = nextElem();
                if (elem === null) {
                    done = true;
                    if (running <= 0) {
                        callback(null);
                    }
                    return;
                }
                running += 1;
                iteratee(elem.value, elem.key, onlyOnce(iterateeCallback));
            }
            looping = false;
        }

        replenish();
    };
};

/**
 * The same as [`eachOf`]{@link module:Collections.eachOf} but runs a maximum of `limit` async operations at a
 * time.
 *
 * @name eachOfLimit
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.eachOf]{@link module:Collections.eachOf}
 * @alias forEachOfLimit
 * @category Collection
 * @param {Array|Iterable|AsyncIterable|Object} coll - A collection to iterate over.
 * @param {number} limit - The maximum number of async operations at a time.
 * @param {AsyncFunction} iteratee - An async function to apply to each
 * item in `coll`. The `key` is the item's key, or index in the case of an
 * array.
 * Invoked with (item, key, callback).
 * @param {Function} [callback] - A callback which is called when all
 * `iteratee` functions have finished, or an error occurs. Invoked with (err).
 * @returns {Promise} a promise, if a callback is omitted
 */
function eachOfLimit$1(coll, limit, iteratee, callback) {
    return eachOfLimit(limit)(coll, wrapAsync(iteratee), callback);
}

var eachOfLimit$2 = awaitify(eachOfLimit$1, 4);

// eachOf implementation optimized for array-likes
function eachOfArrayLike(coll, iteratee, callback) {
    callback = once(callback);
    var index = 0,
        completed = 0,
        {length} = coll,
        canceled = false;
    if (length === 0) {
        callback(null);
    }

    function iteratorCallback(err, value) {
        if (err === false) {
            canceled = true;
        }
        if (canceled === true) return
        if (err) {
            callback(err);
        } else if ((++completed === length) || value === breakLoop) {
            callback(null);
        }
    }

    for (; index < length; index++) {
        iteratee(coll[index], index, onlyOnce(iteratorCallback));
    }
}

// a generic version of eachOf which can handle array, object, and iterator cases.
function eachOfGeneric (coll, iteratee, callback) {
    return eachOfLimit$2(coll, Infinity, iteratee, callback);
}

/**
 * Like [`each`]{@link module:Collections.each}, except that it passes the key (or index) as the second argument
 * to the iteratee.
 *
 * @name eachOf
 * @static
 * @memberOf module:Collections
 * @method
 * @alias forEachOf
 * @category Collection
 * @see [async.each]{@link module:Collections.each}
 * @param {Array|Iterable|AsyncIterable|Object} coll - A collection to iterate over.
 * @param {AsyncFunction} iteratee - A function to apply to each
 * item in `coll`.
 * The `key` is the item's key, or index in the case of an array.
 * Invoked with (item, key, callback).
 * @param {Function} [callback] - A callback which is called when all
 * `iteratee` functions have finished, or an error occurs. Invoked with (err).
 * @returns {Promise} a promise, if a callback is omitted
 * @example
 *
 * var obj = {dev: "/dev.json", test: "/test.json", prod: "/prod.json"};
 * var configs = {};
 *
 * async.forEachOf(obj, function (value, key, callback) {
 *     fs.readFile(__dirname + value, "utf8", function (err, data) {
 *         if (err) return callback(err);
 *         try {
 *             configs[key] = JSON.parse(data);
 *         } catch (e) {
 *             return callback(e);
 *         }
 *         callback();
 *     });
 * }, function (err) {
 *     if (err) console.error(err.message);
 *     // configs is now a map of JSON data
 *     doSomethingWith(configs);
 * });
 */
function eachOf(coll, iteratee, callback) {
    var eachOfImplementation = isArrayLike(coll) ? eachOfArrayLike : eachOfGeneric;
    return eachOfImplementation(coll, wrapAsync(iteratee), callback);
}

var eachOf$1 = awaitify(eachOf, 3);

/**
 * Produces a new collection of values by mapping each value in `coll` through
 * the `iteratee` function. The `iteratee` is called with an item from `coll`
 * and a callback for when it has finished processing. Each of these callback
 * takes 2 arguments: an `error`, and the transformed item from `coll`. If
 * `iteratee` passes an error to its callback, the main `callback` (for the
 * `map` function) is immediately called with the error.
 *
 * Note, that since this function applies the `iteratee` to each item in
 * parallel, there is no guarantee that the `iteratee` functions will complete
 * in order. However, the results array will be in the same order as the
 * original `coll`.
 *
 * If `map` is passed an Object, the results will be an Array.  The results
 * will roughly be in the order of the original Objects' keys (but this can
 * vary across JavaScript engines).
 *
 * @name map
 * @static
 * @memberOf module:Collections
 * @method
 * @category Collection
 * @param {Array|Iterable|AsyncIterable|Object} coll - A collection to iterate over.
 * @param {AsyncFunction} iteratee - An async function to apply to each item in
 * `coll`.
 * The iteratee should complete with the transformed item.
 * Invoked with (item, callback).
 * @param {Function} [callback] - A callback which is called when all `iteratee`
 * functions have finished, or an error occurs. Results is an Array of the
 * transformed items from the `coll`. Invoked with (err, results).
 * @returns {Promise} a promise, if no callback is passed
 * @example
 *
 * async.map(['file1','file2','file3'], fs.stat, function(err, results) {
 *     // results is now an array of stats for each file
 * });
 */
function map (coll, iteratee, callback) {
    return _asyncMap(eachOf$1, coll, iteratee, callback)
}
var map$1 = awaitify(map, 3);

/**
 * Applies the provided arguments to each function in the array, calling
 * `callback` after all functions have completed. If you only provide the first
 * argument, `fns`, then it will return a function which lets you pass in the
 * arguments as if it were a single function call. If more arguments are
 * provided, `callback` is required while `args` is still optional. The results
 * for each of the applied async functions are passed to the final callback
 * as an array.
 *
 * @name applyEach
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @category Control Flow
 * @param {Array|Iterable|AsyncIterable|Object} fns - A collection of {@link AsyncFunction}s
 * to all call with the same arguments
 * @param {...*} [args] - any number of separate arguments to pass to the
 * function.
 * @param {Function} [callback] - the final argument should be the callback,
 * called when all functions have completed processing.
 * @returns {AsyncFunction} - Returns a function that takes no args other than
 * an optional callback, that is the result of applying the `args` to each
 * of the functions.
 * @example
 *
 * const appliedFn = async.applyEach([enableSearch, updateSchema], 'bucket')
 *
 * appliedFn((err, results) => {
 *     // results[0] is the results for `enableSearch`
 *     // results[1] is the results for `updateSchema`
 * });
 *
 * // partial application example:
 * async.each(
 *     buckets,
 *     async (bucket) => async.applyEach([enableSearch, updateSchema], bucket)(),
 *     callback
 * );
 */
var applyEach$1 = applyEach(map$1);

/**
 * The same as [`eachOf`]{@link module:Collections.eachOf} but runs only a single async operation at a time.
 *
 * @name eachOfSeries
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.eachOf]{@link module:Collections.eachOf}
 * @alias forEachOfSeries
 * @category Collection
 * @param {Array|Iterable|AsyncIterable|Object} coll - A collection to iterate over.
 * @param {AsyncFunction} iteratee - An async function to apply to each item in
 * `coll`.
 * Invoked with (item, key, callback).
 * @param {Function} [callback] - A callback which is called when all `iteratee`
 * functions have finished, or an error occurs. Invoked with (err).
 * @returns {Promise} a promise, if a callback is omitted
 */
function eachOfSeries(coll, iteratee, callback) {
    return eachOfLimit$2(coll, 1, iteratee, callback)
}
var eachOfSeries$1 = awaitify(eachOfSeries, 3);

/**
 * The same as [`map`]{@link module:Collections.map} but runs only a single async operation at a time.
 *
 * @name mapSeries
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.map]{@link module:Collections.map}
 * @category Collection
 * @param {Array|Iterable|AsyncIterable|Object} coll - A collection to iterate over.
 * @param {AsyncFunction} iteratee - An async function to apply to each item in
 * `coll`.
 * The iteratee should complete with the transformed item.
 * Invoked with (item, callback).
 * @param {Function} [callback] - A callback which is called when all `iteratee`
 * functions have finished, or an error occurs. Results is an array of the
 * transformed items from the `coll`. Invoked with (err, results).
 * @returns {Promise} a promise, if no callback is passed
 */
function mapSeries (coll, iteratee, callback) {
    return _asyncMap(eachOfSeries$1, coll, iteratee, callback)
}
var mapSeries$1 = awaitify(mapSeries, 3);

/**
 * The same as [`applyEach`]{@link module:ControlFlow.applyEach} but runs only a single async operation at a time.
 *
 * @name applyEachSeries
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @see [async.applyEach]{@link module:ControlFlow.applyEach}
 * @category Control Flow
 * @param {Array|Iterable|AsyncIterable|Object} fns - A collection of {@link AsyncFunction}s to all
 * call with the same arguments
 * @param {...*} [args] - any number of separate arguments to pass to the
 * function.
 * @param {Function} [callback] - the final argument should be the callback,
 * called when all functions have completed processing.
 * @returns {AsyncFunction} - A function, that when called, is the result of
 * appling the `args` to the list of functions.  It takes no args, other than
 * a callback.
 */
var applyEachSeries = applyEach(mapSeries$1);

const PROMISE_SYMBOL = Symbol('promiseCallback');

function promiseCallback () {
    let resolve, reject;
    function callback (err, ...args) {
        if (err) return reject(err)
        resolve(args.length > 1 ? args : args[0]);
    }

    callback[PROMISE_SYMBOL] = new Promise((res, rej) => {
        resolve = res,
        reject = rej;
    });

    return callback
}

/**
 * Determines the best order for running the {@link AsyncFunction}s in `tasks`, based on
 * their requirements. Each function can optionally depend on other functions
 * being completed first, and each function is run as soon as its requirements
 * are satisfied.
 *
 * If any of the {@link AsyncFunction}s pass an error to their callback, the `auto` sequence
 * will stop. Further tasks will not execute (so any other functions depending
 * on it will not run), and the main `callback` is immediately called with the
 * error.
 *
 * {@link AsyncFunction}s also receive an object containing the results of functions which
 * have completed so far as the first argument, if they have dependencies. If a
 * task function has no dependencies, it will only be passed a callback.
 *
 * @name auto
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @category Control Flow
 * @param {Object} tasks - An object. Each of its properties is either a
 * function or an array of requirements, with the {@link AsyncFunction} itself the last item
 * in the array. The object's key of a property serves as the name of the task
 * defined by that property, i.e. can be used when specifying requirements for
 * other tasks. The function receives one or two arguments:
 * * a `results` object, containing the results of the previously executed
 *   functions, only passed if the task has any dependencies,
 * * a `callback(err, result)` function, which must be called when finished,
 *   passing an `error` (which can be `null`) and the result of the function's
 *   execution.
 * @param {number} [concurrency=Infinity] - An optional `integer` for
 * determining the maximum number of tasks that can be run in parallel. By
 * default, as many as possible.
 * @param {Function} [callback] - An optional callback which is called when all
 * the tasks have been completed. It receives the `err` argument if any `tasks`
 * pass an error to their callback. Results are always returned; however, if an
 * error occurs, no further `tasks` will be performed, and the results object
 * will only contain partial results. Invoked with (err, results).
 * @returns {Promise} a promise, if a callback is not passed
 * @example
 *
 * async.auto({
 *     // this function will just be passed a callback
 *     readData: async.apply(fs.readFile, 'data.txt', 'utf-8'),
 *     showData: ['readData', function(results, cb) {
 *         // results.readData is the file's contents
 *         // ...
 *     }]
 * }, callback);
 *
 * async.auto({
 *     get_data: function(callback) {
 *         console.log('in get_data');
 *         // async code to get some data
 *         callback(null, 'data', 'converted to array');
 *     },
 *     make_folder: function(callback) {
 *         console.log('in make_folder');
 *         // async code to create a directory to store a file in
 *         // this is run at the same time as getting the data
 *         callback(null, 'folder');
 *     },
 *     write_file: ['get_data', 'make_folder', function(results, callback) {
 *         console.log('in write_file', JSON.stringify(results));
 *         // once there is some data and the directory exists,
 *         // write the data to a file in the directory
 *         callback(null, 'filename');
 *     }],
 *     email_link: ['write_file', function(results, callback) {
 *         console.log('in email_link', JSON.stringify(results));
 *         // once the file is written let's email a link to it...
 *         // results.write_file contains the filename returned by write_file.
 *         callback(null, {'file':results.write_file, 'email':'user@example.com'});
 *     }]
 * }, function(err, results) {
 *     console.log('err = ', err);
 *     console.log('results = ', results);
 * });
 */
function auto(tasks, concurrency, callback) {
    if (typeof concurrency !== 'number') {
        // concurrency is optional, shift the args.
        callback = concurrency;
        concurrency = null;
    }
    callback = once(callback || promiseCallback());
    var numTasks = Object.keys(tasks).length;
    if (!numTasks) {
        return callback(null);
    }
    if (!concurrency) {
        concurrency = numTasks;
    }

    var results = {};
    var runningTasks = 0;
    var canceled = false;
    var hasError = false;

    var listeners = Object.create(null);

    var readyTasks = [];

    // for cycle detection:
    var readyToCheck = []; // tasks that have been identified as reachable
    // without the possibility of returning to an ancestor task
    var uncheckedDependencies = {};

    Object.keys(tasks).forEach(key => {
        var task = tasks[key];
        if (!Array.isArray(task)) {
            // no dependencies
            enqueueTask(key, [task]);
            readyToCheck.push(key);
            return;
        }

        var dependencies = task.slice(0, task.length - 1);
        var remainingDependencies = dependencies.length;
        if (remainingDependencies === 0) {
            enqueueTask(key, task);
            readyToCheck.push(key);
            return;
        }
        uncheckedDependencies[key] = remainingDependencies;

        dependencies.forEach(dependencyName => {
            if (!tasks[dependencyName]) {
                throw new Error('async.auto task `' + key +
                    '` has a non-existent dependency `' +
                    dependencyName + '` in ' +
                    dependencies.join(', '));
            }
            addListener(dependencyName, () => {
                remainingDependencies--;
                if (remainingDependencies === 0) {
                    enqueueTask(key, task);
                }
            });
        });
    });

    checkForDeadlocks();
    processQueue();

    function enqueueTask(key, task) {
        readyTasks.push(() => runTask(key, task));
    }

    function processQueue() {
        if (canceled) return
        if (readyTasks.length === 0 && runningTasks === 0) {
            return callback(null, results);
        }
        while(readyTasks.length && runningTasks < concurrency) {
            var run = readyTasks.shift();
            run();
        }

    }

    function addListener(taskName, fn) {
        var taskListeners = listeners[taskName];
        if (!taskListeners) {
            taskListeners = listeners[taskName] = [];
        }

        taskListeners.push(fn);
    }

    function taskComplete(taskName) {
        var taskListeners = listeners[taskName] || [];
        taskListeners.forEach(fn => fn());
        processQueue();
    }


    function runTask(key, task) {
        if (hasError) return;

        var taskCallback = onlyOnce((err, ...result) => {
            runningTasks--;
            if (err === false) {
                canceled = true;
                return
            }
            if (result.length < 2) {
                [result] = result;
            }
            if (err) {
                var safeResults = {};
                Object.keys(results).forEach(rkey => {
                    safeResults[rkey] = results[rkey];
                });
                safeResults[key] = result;
                hasError = true;
                listeners = Object.create(null);
                if (canceled) return
                callback(err, safeResults);
            } else {
                results[key] = result;
                taskComplete(key);
            }
        });

        runningTasks++;
        var taskFn = wrapAsync(task[task.length - 1]);
        if (task.length > 1) {
            taskFn(results, taskCallback);
        } else {
            taskFn(taskCallback);
        }
    }

    function checkForDeadlocks() {
        // Kahn's algorithm
        // https://en.wikipedia.org/wiki/Topological_sorting#Kahn.27s_algorithm
        // http://connalle.blogspot.com/2013/10/topological-sortingkahn-algorithm.html
        var currentTask;
        var counter = 0;
        while (readyToCheck.length) {
            currentTask = readyToCheck.pop();
            counter++;
            getDependents(currentTask).forEach(dependent => {
                if (--uncheckedDependencies[dependent] === 0) {
                    readyToCheck.push(dependent);
                }
            });
        }

        if (counter !== numTasks) {
            throw new Error(
                'async.auto cannot execute tasks due to a recursive dependency'
            );
        }
    }

    function getDependents(taskName) {
        var result = [];
        Object.keys(tasks).forEach(key => {
            const task = tasks[key];
            if (Array.isArray(task) && task.indexOf(taskName) >= 0) {
                result.push(key);
            }
        });
        return result;
    }

    return callback[PROMISE_SYMBOL]
}

var FN_ARGS = /^(?:async\s+)?(?:function)?\s*\w*\s*\(\s*([^)]+)\s*\)(?:\s*{)/;
var ARROW_FN_ARGS = /^(?:async\s+)?\(?\s*([^)=]+)\s*\)?(?:\s*=>)/;
var FN_ARG_SPLIT = /,/;
var FN_ARG = /(=.+)?(\s*)$/;
var STRIP_COMMENTS = /((\/\/.*$)|(\/\*[\s\S]*?\*\/))/mg;

function parseParams(func) {
    const src = func.toString().replace(STRIP_COMMENTS, '');
    let match = src.match(FN_ARGS);
    if (!match) {
        match = src.match(ARROW_FN_ARGS);
    }
    if (!match) throw new Error('could not parse args in autoInject\nSource:\n' + src)
    let [, args] = match;
    return args
        .replace(/\s/g, '')
        .split(FN_ARG_SPLIT)
        .map((arg) => arg.replace(FN_ARG, '').trim());
}

/**
 * A dependency-injected version of the [async.auto]{@link module:ControlFlow.auto} function. Dependent
 * tasks are specified as parameters to the function, after the usual callback
 * parameter, with the parameter names matching the names of the tasks it
 * depends on. This can provide even more readable task graphs which can be
 * easier to maintain.
 *
 * If a final callback is specified, the task results are similarly injected,
 * specified as named parameters after the initial error parameter.
 *
 * The autoInject function is purely syntactic sugar and its semantics are
 * otherwise equivalent to [async.auto]{@link module:ControlFlow.auto}.
 *
 * @name autoInject
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @see [async.auto]{@link module:ControlFlow.auto}
 * @category Control Flow
 * @param {Object} tasks - An object, each of whose properties is an {@link AsyncFunction} of
 * the form 'func([dependencies...], callback). The object's key of a property
 * serves as the name of the task defined by that property, i.e. can be used
 * when specifying requirements for other tasks.
 * * The `callback` parameter is a `callback(err, result)` which must be called
 *   when finished, passing an `error` (which can be `null`) and the result of
 *   the function's execution. The remaining parameters name other tasks on
 *   which the task is dependent, and the results from those tasks are the
 *   arguments of those parameters.
 * @param {Function} [callback] - An optional callback which is called when all
 * the tasks have been completed. It receives the `err` argument if any `tasks`
 * pass an error to their callback, and a `results` object with any completed
 * task results, similar to `auto`.
 * @returns {Promise} a promise, if no callback is passed
 * @example
 *
 * //  The example from `auto` can be rewritten as follows:
 * async.autoInject({
 *     get_data: function(callback) {
 *         // async code to get some data
 *         callback(null, 'data', 'converted to array');
 *     },
 *     make_folder: function(callback) {
 *         // async code to create a directory to store a file in
 *         // this is run at the same time as getting the data
 *         callback(null, 'folder');
 *     },
 *     write_file: function(get_data, make_folder, callback) {
 *         // once there is some data and the directory exists,
 *         // write the data to a file in the directory
 *         callback(null, 'filename');
 *     },
 *     email_link: function(write_file, callback) {
 *         // once the file is written let's email a link to it...
 *         // write_file contains the filename returned by write_file.
 *         callback(null, {'file':write_file, 'email':'user@example.com'});
 *     }
 * }, function(err, results) {
 *     console.log('err = ', err);
 *     console.log('email_link = ', results.email_link);
 * });
 *
 * // If you are using a JS minifier that mangles parameter names, `autoInject`
 * // will not work with plain functions, since the parameter names will be
 * // collapsed to a single letter identifier.  To work around this, you can
 * // explicitly specify the names of the parameters your task function needs
 * // in an array, similar to Angular.js dependency injection.
 *
 * // This still has an advantage over plain `auto`, since the results a task
 * // depends on are still spread into arguments.
 * async.autoInject({
 *     //...
 *     write_file: ['get_data', 'make_folder', function(get_data, make_folder, callback) {
 *         callback(null, 'filename');
 *     }],
 *     email_link: ['write_file', function(write_file, callback) {
 *         callback(null, {'file':write_file, 'email':'user@example.com'});
 *     }]
 *     //...
 * }, function(err, results) {
 *     console.log('err = ', err);
 *     console.log('email_link = ', results.email_link);
 * });
 */
function autoInject(tasks, callback) {
    var newTasks = {};

    Object.keys(tasks).forEach(key => {
        var taskFn = tasks[key];
        var params;
        var fnIsAsync = isAsync(taskFn);
        var hasNoDeps =
            (!fnIsAsync && taskFn.length === 1) ||
            (fnIsAsync && taskFn.length === 0);

        if (Array.isArray(taskFn)) {
            params = [...taskFn];
            taskFn = params.pop();

            newTasks[key] = params.concat(params.length > 0 ? newTask : taskFn);
        } else if (hasNoDeps) {
            // no dependencies, use the function as-is
            newTasks[key] = taskFn;
        } else {
            params = parseParams(taskFn);
            if ((taskFn.length === 0 && !fnIsAsync) && params.length === 0) {
                throw new Error("autoInject task functions require explicit parameters.");
            }

            // remove callback param
            if (!fnIsAsync) params.pop();

            newTasks[key] = params.concat(newTask);
        }

        function newTask(results, taskCb) {
            var newArgs = params.map(name => results[name]);
            newArgs.push(taskCb);
            wrapAsync(taskFn)(...newArgs);
        }
    });

    return auto(newTasks, callback);
}

// Simple doubly linked list (https://en.wikipedia.org/wiki/Doubly_linked_list) implementation
// used for queues. This implementation assumes that the node provided by the user can be modified
// to adjust the next and last properties. We implement only the minimal functionality
// for queue support.
class DLL {
    constructor() {
        this.head = this.tail = null;
        this.length = 0;
    }

    removeLink(node) {
        if (node.prev) node.prev.next = node.next;
        else this.head = node.next;
        if (node.next) node.next.prev = node.prev;
        else this.tail = node.prev;

        node.prev = node.next = null;
        this.length -= 1;
        return node;
    }

    empty () {
        while(this.head) this.shift();
        return this;
    }

    insertAfter(node, newNode) {
        newNode.prev = node;
        newNode.next = node.next;
        if (node.next) node.next.prev = newNode;
        else this.tail = newNode;
        node.next = newNode;
        this.length += 1;
    }

    insertBefore(node, newNode) {
        newNode.prev = node.prev;
        newNode.next = node;
        if (node.prev) node.prev.next = newNode;
        else this.head = newNode;
        node.prev = newNode;
        this.length += 1;
    }

    unshift(node) {
        if (this.head) this.insertBefore(this.head, node);
        else setInitial(this, node);
    }

    push(node) {
        if (this.tail) this.insertAfter(this.tail, node);
        else setInitial(this, node);
    }

    shift() {
        return this.head && this.removeLink(this.head);
    }

    pop() {
        return this.tail && this.removeLink(this.tail);
    }

    toArray() {
        return [...this]
    }

    *[Symbol.iterator] () {
        var cur = this.head;
        while (cur) {
            yield cur.data;
            cur = cur.next;
        }
    }

    remove (testFn) {
        var curr = this.head;
        while(curr) {
            var {next} = curr;
            if (testFn(curr)) {
                this.removeLink(curr);
            }
            curr = next;
        }
        return this;
    }
}

function setInitial(dll, node) {
    dll.length = 1;
    dll.head = dll.tail = node;
}

function queue(worker, concurrency, payload) {
    if (concurrency == null) {
        concurrency = 1;
    }
    else if(concurrency === 0) {
        throw new RangeError('Concurrency must not be zero');
    }

    var _worker = wrapAsync(worker);
    var numRunning = 0;
    var workersList = [];
    const events = {
        error: [],
        drain: [],
        saturated: [],
        unsaturated: [],
        empty: []
    };

    function on (event, handler) {
        events[event].push(handler);
    }

    function once (event, handler) {
        const handleAndRemove = (...args) => {
            off(event, handleAndRemove);
            handler(...args);
        };
        events[event].push(handleAndRemove);
    }

    function off (event, handler) {
        if (!event) return Object.keys(events).forEach(ev => events[ev] = [])
        if (!handler) return events[event] = []
        events[event] = events[event].filter(ev => ev !== handler);
    }

    function trigger (event, ...args) {
        events[event].forEach(handler => handler(...args));
    }

    var processingScheduled = false;
    function _insert(data, insertAtFront, rejectOnError, callback) {
        if (callback != null && typeof callback !== 'function') {
            throw new Error('task callback must be a function');
        }
        q.started = true;

        var res, rej;
        function promiseCallback (err, ...args) {
            // we don't care about the error, let the global error handler
            // deal with it
            if (err) return rejectOnError ? rej(err) : res()
            if (args.length <= 1) return res(args[0])
            res(args);
        }

        var item = {
            data,
            callback: rejectOnError ?
                promiseCallback :
                (callback || promiseCallback)
        };

        if (insertAtFront) {
            q._tasks.unshift(item);
        } else {
            q._tasks.push(item);
        }

        if (!processingScheduled) {
            processingScheduled = true;
            setImmediate$1(() => {
                processingScheduled = false;
                q.process();
            });
        }

        if (rejectOnError || !callback) {
            return new Promise((resolve, reject) => {
                res = resolve;
                rej = reject;
            })
        }
    }

    function _createCB(tasks) {
        return function (err, ...args) {
            numRunning -= 1;

            for (var i = 0, l = tasks.length; i < l; i++) {
                var task = tasks[i];

                var index = workersList.indexOf(task);
                if (index === 0) {
                    workersList.shift();
                } else if (index > 0) {
                    workersList.splice(index, 1);
                }

                task.callback(err, ...args);

                if (err != null) {
                    trigger('error', err, task.data);
                }
            }

            if (numRunning <= (q.concurrency - q.buffer) ) {
                trigger('unsaturated');
            }

            if (q.idle()) {
                trigger('drain');
            }
            q.process();
        };
    }

    function _maybeDrain(data) {
        if (data.length === 0 && q.idle()) {
            // call drain immediately if there are no tasks
            setImmediate$1(() => trigger('drain'));
            return true
        }
        return false
    }

    const eventMethod = (name) => (handler) => {
        if (!handler) {
            return new Promise((resolve, reject) => {
                once(name, (err, data) => {
                    if (err) return reject(err)
                    resolve(data);
                });
            })
        }
        off(name);
        on(name, handler);

    };

    var isProcessing = false;
    var q = {
        _tasks: new DLL(),
        *[Symbol.iterator] () {
            yield* q._tasks[Symbol.iterator]();
        },
        concurrency,
        payload,
        buffer: concurrency / 4,
        started: false,
        paused: false,
        push (data, callback) {
            if (Array.isArray(data)) {
                if (_maybeDrain(data)) return
                return data.map(datum => _insert(datum, false, false, callback))
            }
            return _insert(data, false, false, callback);
        },
        pushAsync (data, callback) {
            if (Array.isArray(data)) {
                if (_maybeDrain(data)) return
                return data.map(datum => _insert(datum, false, true, callback))
            }
            return _insert(data, false, true, callback);
        },
        kill () {
            off();
            q._tasks.empty();
        },
        unshift (data, callback) {
            if (Array.isArray(data)) {
                if (_maybeDrain(data)) return
                return data.map(datum => _insert(datum, true, false, callback))
            }
            return _insert(data, true, false, callback);
        },
        unshiftAsync (data, callback) {
            if (Array.isArray(data)) {
                if (_maybeDrain(data)) return
                return data.map(datum => _insert(datum, true, true, callback))
            }
            return _insert(data, true, true, callback);
        },
        remove (testFn) {
            q._tasks.remove(testFn);
        },
        process () {
            // Avoid trying to start too many processing operations. This can occur
            // when callbacks resolve synchronously (#1267).
            if (isProcessing) {
                return;
            }
            isProcessing = true;
            while(!q.paused && numRunning < q.concurrency && q._tasks.length){
                var tasks = [], data = [];
                var l = q._tasks.length;
                if (q.payload) l = Math.min(l, q.payload);
                for (var i = 0; i < l; i++) {
                    var node = q._tasks.shift();
                    tasks.push(node);
                    workersList.push(node);
                    data.push(node.data);
                }

                numRunning += 1;

                if (q._tasks.length === 0) {
                    trigger('empty');
                }

                if (numRunning === q.concurrency) {
                    trigger('saturated');
                }

                var cb = onlyOnce(_createCB(tasks));
                _worker(data, cb);
            }
            isProcessing = false;
        },
        length () {
            return q._tasks.length;
        },
        running () {
            return numRunning;
        },
        workersList () {
            return workersList;
        },
        idle() {
            return q._tasks.length + numRunning === 0;
        },
        pause () {
            q.paused = true;
        },
        resume () {
            if (q.paused === false) { return; }
            q.paused = false;
            setImmediate$1(q.process);
        }
    };
    // define these as fixed properties, so people get useful errors when updating
    Object.defineProperties(q, {
        saturated: {
            writable: false,
            value: eventMethod('saturated')
        },
        unsaturated: {
            writable: false,
            value: eventMethod('unsaturated')
        },
        empty: {
            writable: false,
            value: eventMethod('empty')
        },
        drain: {
            writable: false,
            value: eventMethod('drain')
        },
        error: {
            writable: false,
            value: eventMethod('error')
        },
    });
    return q;
}

/**
 * Creates a `cargo` object with the specified payload. Tasks added to the
 * cargo will be processed altogether (up to the `payload` limit). If the
 * `worker` is in progress, the task is queued until it becomes available. Once
 * the `worker` has completed some tasks, each callback of those tasks is
 * called. Check out [these](https://camo.githubusercontent.com/6bbd36f4cf5b35a0f11a96dcd2e97711ffc2fb37/68747470733a2f2f662e636c6f75642e6769746875622e636f6d2f6173736574732f313637363837312f36383130382f62626330636662302d356632392d313165322d393734662d3333393763363464633835382e676966) [animations](https://camo.githubusercontent.com/f4810e00e1c5f5f8addbe3e9f49064fd5d102699/68747470733a2f2f662e636c6f75642e6769746875622e636f6d2f6173736574732f313637363837312f36383130312f38346339323036362d356632392d313165322d383134662d3964336430323431336266642e676966)
 * for how `cargo` and `queue` work.
 *
 * While [`queue`]{@link module:ControlFlow.queue} passes only one task to one of a group of workers
 * at a time, cargo passes an array of tasks to a single worker, repeating
 * when the worker is finished.
 *
 * @name cargo
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @see [async.queue]{@link module:ControlFlow.queue}
 * @category Control Flow
 * @param {AsyncFunction} worker - An asynchronous function for processing an array
 * of queued tasks. Invoked with `(tasks, callback)`.
 * @param {number} [payload=Infinity] - An optional `integer` for determining
 * how many tasks should be processed per round; if omitted, the default is
 * unlimited.
 * @returns {module:ControlFlow.QueueObject} A cargo object to manage the tasks. Callbacks can
 * attached as certain properties to listen for specific events during the
 * lifecycle of the cargo and inner queue.
 * @example
 *
 * // create a cargo object with payload 2
 * var cargo = async.cargo(function(tasks, callback) {
 *     for (var i=0; i<tasks.length; i++) {
 *         console.log('hello ' + tasks[i].name);
 *     }
 *     callback();
 * }, 2);
 *
 * // add some items
 * cargo.push({name: 'foo'}, function(err) {
 *     console.log('finished processing foo');
 * });
 * cargo.push({name: 'bar'}, function(err) {
 *     console.log('finished processing bar');
 * });
 * await cargo.push({name: 'baz'});
 * console.log('finished processing baz');
 */
function cargo(worker, payload) {
    return queue(worker, 1, payload);
}

/**
 * Creates a `cargoQueue` object with the specified payload. Tasks added to the
 * cargoQueue will be processed together (up to the `payload` limit) in `concurrency` parallel workers.
 * If the all `workers` are in progress, the task is queued until one becomes available. Once
 * a `worker` has completed some tasks, each callback of those tasks is
 * called. Check out [these](https://camo.githubusercontent.com/6bbd36f4cf5b35a0f11a96dcd2e97711ffc2fb37/68747470733a2f2f662e636c6f75642e6769746875622e636f6d2f6173736574732f313637363837312f36383130382f62626330636662302d356632392d313165322d393734662d3333393763363464633835382e676966) [animations](https://camo.githubusercontent.com/f4810e00e1c5f5f8addbe3e9f49064fd5d102699/68747470733a2f2f662e636c6f75642e6769746875622e636f6d2f6173736574732f313637363837312f36383130312f38346339323036362d356632392d313165322d383134662d3964336430323431336266642e676966)
 * for how `cargo` and `queue` work.
 *
 * While [`queue`]{@link module:ControlFlow.queue} passes only one task to one of a group of workers
 * at a time, and [`cargo`]{@link module:ControlFlow.cargo} passes an array of tasks to a single worker,
 * the cargoQueue passes an array of tasks to multiple parallel workers.
 *
 * @name cargoQueue
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @see [async.queue]{@link module:ControlFlow.queue}
 * @see [async.cargo]{@link module:ControlFLow.cargo}
 * @category Control Flow
 * @param {AsyncFunction} worker - An asynchronous function for processing an array
 * of queued tasks. Invoked with `(tasks, callback)`.
 * @param {number} [concurrency=1] - An `integer` for determining how many
 * `worker` functions should be run in parallel.  If omitted, the concurrency
 * defaults to `1`.  If the concurrency is `0`, an error is thrown.
 * @param {number} [payload=Infinity] - An optional `integer` for determining
 * how many tasks should be processed per round; if omitted, the default is
 * unlimited.
 * @returns {module:ControlFlow.QueueObject} A cargoQueue object to manage the tasks. Callbacks can
 * attached as certain properties to listen for specific events during the
 * lifecycle of the cargoQueue and inner queue.
 * @example
 *
 * // create a cargoQueue object with payload 2 and concurrency 2
 * var cargoQueue = async.cargoQueue(function(tasks, callback) {
 *     for (var i=0; i<tasks.length; i++) {
 *         console.log('hello ' + tasks[i].name);
 *     }
 *     callback();
 * }, 2, 2);
 *
 * // add some items
 * cargoQueue.push({name: 'foo'}, function(err) {
 *     console.log('finished processing foo');
 * });
 * cargoQueue.push({name: 'bar'}, function(err) {
 *     console.log('finished processing bar');
 * });
 * cargoQueue.push({name: 'baz'}, function(err) {
 *     console.log('finished processing baz');
 * });
 * cargoQueue.push({name: 'boo'}, function(err) {
 *     console.log('finished processing boo');
 * });
 */
function cargo$1(worker, concurrency, payload) {
    return queue(worker, concurrency, payload);
}

/**
 * Reduces `coll` into a single value using an async `iteratee` to return each
 * successive step. `memo` is the initial state of the reduction. This function
 * only operates in series.
 *
 * For performance reasons, it may make sense to split a call to this function
 * into a parallel map, and then use the normal `Array.prototype.reduce` on the
 * results. This function is for situations where each step in the reduction
 * needs to be async; if you can get the data before reducing it, then it's
 * probably a good idea to do so.
 *
 * @name reduce
 * @static
 * @memberOf module:Collections
 * @method
 * @alias inject
 * @alias foldl
 * @category Collection
 * @param {Array|Iterable|AsyncIterable|Object} coll - A collection to iterate over.
 * @param {*} memo - The initial state of the reduction.
 * @param {AsyncFunction} iteratee - A function applied to each item in the
 * array to produce the next step in the reduction.
 * The `iteratee` should complete with the next state of the reduction.
 * If the iteratee complete with an error, the reduction is stopped and the
 * main `callback` is immediately called with the error.
 * Invoked with (memo, item, callback).
 * @param {Function} [callback] - A callback which is called after all the
 * `iteratee` functions have finished. Result is the reduced value. Invoked with
 * (err, result).
 * @returns {Promise} a promise, if no callback is passed
 * @example
 *
 * async.reduce([1,2,3], 0, function(memo, item, callback) {
 *     // pointless async:
 *     process.nextTick(function() {
 *         callback(null, memo + item)
 *     });
 * }, function(err, result) {
 *     // result is now equal to the last value of memo, which is 6
 * });
 */
function reduce(coll, memo, iteratee, callback) {
    callback = once(callback);
    var _iteratee = wrapAsync(iteratee);
    return eachOfSeries$1(coll, (x, i, iterCb) => {
        _iteratee(memo, x, (err, v) => {
            memo = v;
            iterCb(err);
        });
    }, err => callback(err, memo));
}
var reduce$1 = awaitify(reduce, 4);

/**
 * Version of the compose function that is more natural to read. Each function
 * consumes the return value of the previous function. It is the equivalent of
 * [compose]{@link module:ControlFlow.compose} with the arguments reversed.
 *
 * Each function is executed with the `this` binding of the composed function.
 *
 * @name seq
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @see [async.compose]{@link module:ControlFlow.compose}
 * @category Control Flow
 * @param {...AsyncFunction} functions - the asynchronous functions to compose
 * @returns {Function} a function that composes the `functions` in order
 * @example
 *
 * // Requires lodash (or underscore), express3 and dresende's orm2.
 * // Part of an app, that fetches cats of the logged user.
 * // This example uses `seq` function to avoid overnesting and error
 * // handling clutter.
 * app.get('/cats', function(request, response) {
 *     var User = request.models.User;
 *     async.seq(
 *         _.bind(User.get, User),  // 'User.get' has signature (id, callback(err, data))
 *         function(user, fn) {
 *             user.getCats(fn);      // 'getCats' has signature (callback(err, data))
 *         }
 *     )(req.session.user_id, function (err, cats) {
 *         if (err) {
 *             console.error(err);
 *             response.json({ status: 'error', message: err.message });
 *         } else {
 *             response.json({ status: 'ok', message: 'Cats found', data: cats });
 *         }
 *     });
 * });
 */
function seq(...functions) {
    var _functions = functions.map(wrapAsync);
    return function (...args) {
        var that = this;

        var cb = args[args.length - 1];
        if (typeof cb == 'function') {
            args.pop();
        } else {
            cb = promiseCallback();
        }

        reduce$1(_functions, args, (newargs, fn, iterCb) => {
            fn.apply(that, newargs.concat((err, ...nextargs) => {
                iterCb(err, nextargs);
            }));
        },
        (err, results) => cb(err, ...results));

        return cb[PROMISE_SYMBOL]
    };
}

/**
 * Creates a function which is a composition of the passed asynchronous
 * functions. Each function consumes the return value of the function that
 * follows. Composing functions `f()`, `g()`, and `h()` would produce the result
 * of `f(g(h()))`, only this version uses callbacks to obtain the return values.
 *
 * If the last argument to the composed function is not a function, a promise
 * is returned when you call it.
 *
 * Each function is executed with the `this` binding of the composed function.
 *
 * @name compose
 * @static
 * @memberOf module:ControlFlow
 * @method
 * @category Control Flow
 * @param {...AsyncFunction} functions - the asynchronous functions to compose
 * @returns {Function} an asynchronous function that is the composed
 * asynchronous `functions`
 * @example
 *
 * function add1(n, callback) {
 *     setTimeout(function () {
 *         callback(null, n + 1);
 *     }, 10);
 * }
 *
 * function mul3(n, callback) {
 *     setTimeout(function () {
 *         callback(null, n * 3);
 *     }, 10);
 * }
 *
 * var add1mul3 = async.compose(mul3, add1);
 * add1mul3(4, function (err, result) {
 *     // result now equals 15
 * });
 */
function compose(...args) {
    return seq(...args.reverse());
}

/**
 * The same as [`map`]{@link module:Collections.map} but runs a maximum of `limit` async operations at a time.
 *
 * @name mapLimit
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.map]{@link module:Collections.map}
 * @category Collection
 * @param {Array|Iterable|AsyncIterable|Object} coll - A collection to iterate over.
 * @param {number} limit - The maximum number of async operations at a time.
 * @param {AsyncFunction} iteratee - An async function to apply to each item in
 * `coll`.
 * The iteratee should complete with the transformed item.
 * Invoked with (item, callback).
 * @param {Function} [callback] - A callback which is called when all `iteratee`
 * functions have finished, or an error occurs. Results is an array of the
 * transformed items from the `coll`. Invoked with (err, results).
 * @returns {Promise} a promise, if no callback is passed
 */
function mapLimit (coll, limit, iteratee, callback) {
    return _asyncMap(eachOfLimit(limit), coll, iteratee, callback)
}
var mapLimit$1 = awaitify(mapLimit, 4);

/**
 * The same as [`concat`]{@link module:Collections.concat} but runs a maximum of `limit` async operations at a time.
 *
 * @name concatLimit
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.concat]{@link module:Collections.concat}
 * @category Collection
 * @alias flatMapLimit
 * @param {Array|Iterable|AsyncIterable|Object} coll - A collection to iterate over.
 * @param {number} limit - The maximum number of async operations at a time.
 * @param {AsyncFunction} iteratee - A function to apply to each item in `coll`,
 * which should use an array as its result. Invoked with (item, callback).
 * @param {Function} [callback] - A callback which is called after all the
 * `iteratee` functions have finished, or an error occurs. Results is an array
 * containing the concatenated results of the `iteratee` function. Invoked with
 * (err, results).
 * @returns A Promise, if no callback is passed
 */
function concatLimit(coll, limit, iteratee, callback) {
    var _iteratee = wrapAsync(iteratee);
    return mapLimit$1(coll, limit, (val, iterCb) => {
        _iteratee(val, (err, ...args) => {
            if (err) return iterCb(err);
            return iterCb(err, args);
        });
    }, (err, mapResults) => {
        var result = [];
        for (var i = 0; i < mapResults.length; i++) {
            if (mapResults[i]) {
                result = result.concat(...mapResults[i]);
            }
        }

        return callback(err, result);
    });
}
var concatLimit$1 = awaitify(concatLimit, 4);

/**
 * Applies `iteratee` to each item in `coll`, concatenating the results. Returns
 * the concatenated list. The `iteratee`s are called in parallel, and the
 * results are concatenated as they return. The results array will be returned in
 * the original order of `coll` passed to the `iteratee` function.
 *
 * @name concat
 * @static
 * @memberOf module:Collections
 * @method
 * @category Collection
 * @alias flatMap
 * @param {Array|Iterable|AsyncIterable|Object} coll - A collection to iterate over.
 * @param {AsyncFunction} iteratee - A function to apply to each item in `coll`,
 * which should use an array as its result. Invoked with (item, callback).
 * @param {Function} [callback] - A callback which is called after all the
 * `iteratee` functions have finished, or an error occurs. Results is an array
 * containing the concatenated results of the `iteratee` function. Invoked with
 * (err, results).
 * @returns A Promise, if no callback is passed
 * @example
 *
 * async.concat(['dir1','dir2','dir3'], fs.readdir, function(err, files) {
 *     // files is now a list of filenames that exist in the 3 directories
 * });
 */
function concat(coll, iteratee, callback) {
    return concatLimit$1(coll, Infinity, iteratee, callback)
}
var concat$1 = awaitify(concat, 3);

/**
 * The same as [`concat`]{@link module:Collections.concat} but runs only a single async operation at a time.
 *
 * @name concatSeries
 * @static
 * @memberOf module:Collections
 * @method
 * @see [async.concat]{@link module:Collections.concat}
 * @category Collection
 * @alias flatMapSeries
 * @param {Array|Iterable|AsyncIterable|Object} coll - A collection to iterate over.
 * @param {AsyncFunction} iteratee - A function to apply to each item in `coll`.
 * The iteratee should complete with an array an array of results.
 * Invoked with (item, callback).
 * @param {Function} [callback] - A callback which is called after all the
 * `iteratee` functions have finished, or an error occurs. Results is an array
 * containing the concatenated results of the `iteratee` function. Invoked with
 * (err, results).
 * @returns A Promise, if no callback is passed
 */
function concatSeries(coll, iteratee, callback) {
    return concatLimit$1(coll, 1, iteratee, callback)
}
var concatSeries$1 = awaitify(concatSeries, 3);

/**
 * Returns a function that when called, calls-back with the values provided.
 * Useful as the first function in a [`waterfall`]{@link module:ControlFlow.waterfall}, or for plugging values in to
 * [`auto`]{@link module:ControlFlow.auto}.
 *
 * @name constant
 * @static
 * @memberOf module:Utils
 * @method
 * @category Util
 * @param {...*} arguments... - Any number of arguments to automatically invoke
 * callback with.
 * @returns {AsyncFunction} Returns a function that when invoked, automatically
 * invokes the callback with the previous given arguments.
 * @example
 *
 * async.waterfall([
 *     async.constant(42),
 *     function (value, next) {
 *         // value === 42
 *     },
 *     //...
 * ], callback);
 *
 * async.waterfall([
 *     async.constant(filename, "utf8"),
 *     fs.readFile,
 *     function (fileData, next) {
 *         //...
 *     }
 *     //...
 * ], callback);
 *
 * async.auto({
 *     hostname: async.constant("https://server.net/"),
 *     port: findFreePort,
 *     launchServer: ["hostname", "port", function (options, cb) {
 *         startServer(options, cb);
 *     }],
 *     //...
 * }, callback);
 */
function constant(...args) {
    return function (...ignoredArgs/*, callback*/) {
        var callback = ignoredArgs.pop();
        return callback(null, ...args);
    };
}

function _createTester(check, getResult) {
    return (eachfn, arr, _iteratee, cb) => {
        var testPassed = false;
        var testResult;
        const iteratee = wrapAsync(_iteratee);
        eachfn(arr, (value, _, callback) => {
            iteratee