/*
Stimulsoft.Reports.JS
Version: 2023.3.2
Build date: 2023.08.12
License: https://www.stimulsoft.com/en/licensing/reports
*/
export namespace Stimulsoft.System {
    class Activator {
        static createInstance(type: Type): any;
    }
}
export namespace Stimulsoft.System {
    class Attribute {
    }
}
export namespace Stimulsoft.ExternalLibrary.Blockly {
    let blocklyToolbox: string;
    let blocklyToolboxCurrentValue: string;
    let blocklyWorkspace: string;
    let blocklyBlocks: string;
}
export namespace Stimulsoft.System.Globalization {
    enum UnicodeCategory {
        UppercaseLetter = 0,
        LowercaseLetter = 1,
        TitlecaseLetter = 2,
        ModifierLetter = 3,
        OtherLetter = 4,
        NonSpacingMark = 5,
        SpacingCombiningMark = 6,
        EnclosingMark = 7,
        DecimalDigitNumber = 8,
        LetterNumber = 9,
        OtherNumber = 10,
        SpaceSeparator = 11,
        LineSeparator = 12,
        ParagraphSeparator = 13,
        Control = 14,
        Format = 15,
        Surrogate = 16,
        PrivateUse = 17,
        ConnectorPunctuation = 18,
        DashPunctuation = 19,
        OpenPunctuation = 20,
        ClosePunctuation = 21,
        InitialQuotePunctuation = 22,
        FinalQuotePunctuation = 23,
        OtherPunctuation = 24,
        MathSymbol = 25,
        CurrencySymbol = 26,
        ModifierSymbol = 27,
        OtherSymbol = 28,
        OtherNotAssigned = 29
    }
}
export namespace Stimulsoft.System {
    class Char {
        static isUpper(char: string, index?: number): boolean;
        static isLower(char: string, index?: number): boolean;
        static isLetter(char: string, index?: number): boolean;
        static isDigit(char: string | number, index?: number): boolean;
        static isLetterOrDigit(char: string, index?: number): boolean;
        static toLower(char: string): string;
        static toUpper(char: string): string;
        static isWhitespace(char: string, index?: number, allowNbsp?: boolean): boolean;
        private static checkLetter;
        static getUnicodeCategory(char: string, index?: number): number;
        static isControl(char: string, index?: number): boolean;
    }
}
export namespace Stimulsoft.System {
    class Chars {
        static getUnicodeCategory(char: number): number;
        private static _table_0;
        private static _table_9fc0;
        private static _table_d780;
        private static _table_fa40;
    }
}
export namespace Stimulsoft.System {
    class Convert {
        static changeType(value: any, type: Type): any;
        static changeType2(value: any, typeCode: TypeCode): any;
        static toDateTime(value: any): DateTime;
        static toString(value: any): string;
        static toFont(value: string): Stimulsoft.System.Drawing.Font;
        static toBoolean(value: any): boolean;
        static toNumber(value: any): number;
        static toDouble(value: any): number;
        static toInt32(value: any, radix?: number): number;
        static toInt64(value: any): number;
        static toUInt64(value: any): number;
        static toUInt32(value: any): number;
        private static bytesToBase64String;
        static toBase64String(input: string | number[] | Uint8Array): string;
        private static base64StringToBytes;
        static fromBase64String(input: string): number[];
        static fromBase64StringText(input: string): string;
        static fromUTF16LE<T extends string | number[] | Uint8Array>(input: T): T;
        static isUTF16LE(input: string | number[] | Uint8Array): boolean;
        static stripBom<T extends string | number[]>(data: T): T;
    }
}
declare let __require__: any;
export namespace Stimulsoft.System {
    class NodeJs {
        private static isInitialize;
        static initialize(onResult?: Function): void;
        private static convertAsync;
        static platform(): any;
        static sendAsync(method: string, url: string, body?: string, headers?: {
            key: string;
            value: string;
        }[], timeout?: number): StiPromise<{
            status: number;
            responseText: string;
            statusText: string;
        }>;
        static callRemoteApi(command: any, timeout: number): StiPromise<string>;
        static stripBom(data: any): any;
        static getFile(filePath: string, binary?: boolean, contentType?: string, headers?: {
            key: string;
            value: string;
        }[]): any;
        static getFileHttp(filePath: string, binary?: boolean, contentType?: string, headers?: {
            key: string;
            value: string;
        }[]): any;
        static send(method: string, url: string, body: string, headers?: {
            key: string;
            value: string;
        }[]): {
            status: number;
            responseText: string;
            statusText: string;
        };
        static saveAs(data: any, fileName: string, type?: string): any;
        static saveFile(filePath: string, fileData: string | number[]): void;
        static getFilesNames(filesPath: string): string[];
        static getSep(): string;
        private static fromBase64String;
        private static fromBase64StringText;
        private static toBase64String;
        private static fromUnicodeString;
        private static _isNodeJs;
        static isNodeJs(): boolean;
        static isBuffer(data: any): boolean;
        static isStandaloneVersion: boolean;
        static useWebKit: boolean;
        get consoleLog(): boolean;
        set consoleLog(value: boolean);
        private static fillInfo;
        static localizationPath: string;
        private static getLocalizationInfo;
        private static getSetting;
        private static setSetting;
    }
}
export namespace Stimulsoft.System.Globalization {
    class TextInfo {
        listSeparator: string;
        toTitleCase(str: string): string;
        constructor(listSeparator?: string);
    }
}
export namespace Stimulsoft.System.Globalization {
    import IFormatProvider = Stimulsoft.System.IFormatProvider;
    import Type = Stimulsoft.System.Type;
    class NumberFormatInfo implements IFormatProvider {
        numberDecimalSeparator: string;
        numberDecimalDigits: number;
        numberGroupSeparator: string;
        numberGroupSizes: number[];
        numberNegativePattern: number;
        currencyDecimalDigits: number;
        currencyDecimalSeparator: string;
        currencyGroupSeparator: string;
        currencyGroupSizes: number[];
        currencyNegativePattern: number;
        currencyPositivePattern: number;
        currencySymbol: string;
        percentDecimalDigits: number;
        percentDecimalSeparator: string;
        percentGroupSeparator: string;
        percentGroupSizes: number[];
        percentNegativePattern: number;
        percentPositivePattern: number;
        percentSymbol: string;
        perMilleSymbol: string;
        positiveInfinitySymbol: string;
        positiveSign: string;
        NaNSymbol: string;
        negativeInfinitySymbol: string;
        negativeSign: string;
        getFormat(formatType: Type): any;
        constructor(numberDecimalSeparator?: string, numberDecimalDigits?: number, numberGroupSeparator?: string, numberGroupSizes?: number[], numberNegativePattern?: number, currencyDecimalDigits?: number, currencyDecimalSeparator?: string, currencyGroupSeparator?: string, currencyGroupSizes?: number[], currencyNegativePattern?: number, currencyPositivePattern?: number, currencySymbol?: string, percentDecimalDigits?: number, percentDecimalSeparator?: string, percentGroupSeparator?: string, percentGroupSizes?: number[], percentNegativePattern?: number, percentPositivePattern?: number, percentSymbol?: string, perMilleSymbol?: string, positiveInfinitySymbol?: string, positiveSign?: string, NaNSymbol?: string, negativeInfinitySymbol?: string, negativeSign?: string);
    }
}
export namespace Stimulsoft.System.Globalization {
    class DateTimeFormatInfo {
        shortDatePattern: string;
        dateSeparator: string;
        longDatePattern: string;
        dayNames: string[];
        monthNames: string[];
        shortestDayNames: string[];
        abbreviatedMonthNames: string[];
        monthGenitiveNames: string[];
        timeSeparator: string;
        AMDesignator: string;
        PMDesignator: string;
        fullDateTimePattern: string;
        shortTimePattern: string;
        longTimePattern: string;
        yearMonthPattern: string;
        calendarWeekRule: Stimulsoft.System.Globalization.CalendarWeekRule;
        firstDayOfWeek: Stimulsoft.System.DayOfWeek;
        constructor(shortDatePattern: string, dateSeparator: string, longDatePattern: string, dayNames: string[], monthNames: string[], shortestDayNames: string[], abbreviatedMonthNames: string[], monthGenitiveNames: string[], timeSeparator: string, AMDesignator: string, PMDesignator: string, fullDateTimePattern: string, shortTimePattern: string, longTimePattern: string, yearMonthPattern: string, calendarWeekRule: Stimulsoft.System.Globalization.CalendarWeekRule, firstDayOfWeek: Stimulsoft.System.DayOfWeek);
    }
}
export namespace Stimulsoft.System.Globalization {
    class CultureInfo {
        numberFormat: NumberFormatInfo;
        dateTimeFormat: DateTimeFormatInfo;
        name: string;
        readonly displayName: string;
        textInfo: TextInfo;
        regionInfo: RegionInfo;
        private static _cultures;
        private static _currentCulture;
        static get currentCulture(): CultureInfo;
        static set currentCulture(val: CultureInfo);
        static get cultures(): {
            [key: string]: CultureInfo;
        };
        static get InvariantCulture(): CultureInfo;
        static getCultureInfo(name: string): CultureInfo;
        constructor(name: string, numberFormat?: NumberFormatInfo, dateTimeFormat?: DateTimeFormatInfo, textInfo?: TextInfo, displayName?: string);
    }
}
export namespace Stimulsoft.System {
    class DateTime {
        private static ticksPerMillisecond;
        private static ticksPerSecond;
        private static ticksPerMinute;
        private static ticksPerHour;
        private static ticksPerDay;
        private static millisPerSecond;
        private static millisPerMinute;
        private static millisPerHour;
        private static millisPerDay;
        private static daysPerYear;
        private static daysPer4Years;
        private static daysPer100Years;
        private static daysPer400Years;
        private static daysTo1601;
        private static daysTo1899;
        private static daysTo10000;
        private static minTicks;
        private static maxTicks;
        private static maxMillis;
        private static fileTimeOffset;
        private static doubleDateOffset;
        private static oADateMinAsTicks;
        private static oADateMinAsDouble;
        private static oADateMaxAsDouble;
        private static datePartYear;
        private static datePartDayOfYear;
        private static datePartMonth;
        private static DatePartDay;
        private static daysToMonth365;
        private static daysToMonth366;
        static minValue: DateTime;
        static maxValue: DateTime;
        static getNetTypeName(): string;
        dateTimeOffset: string;
        private innerDate;
        get year(): number;
        get month(): number;
        get monthName(): string;
        get monthGenitiveName(): string;
        get monthShortName(): string;
        get day(): number;
        get dayOfWeek(): DayOfWeek;
        get dayName(): string;
        get dayShortName(): string;
        get hour(): number;
        get minute(): number;
        get second(): number;
        get millisecond(): number;
        get ticks(): number;
        get dayOfYear(): number;
        firstDayOfWeek(): DateTime;
        lastDayOfWeek(): DateTime;
        firstDayOfMonth(): DateTime;
        lastDayOfMonth(): DateTime;
        firstDayOfQuarter(): DateTime;
        lastDayOfQuarter(): DateTime;
        firstDayOfFirthQuarter(): DateTime;
        lastDayOfFirthQuarter(): DateTime;
        firstDayOfSecondQuarter(): DateTime;
        lastDayOfSecondQuarter(): DateTime;
        firstDayOfThirdQuarter(): DateTime;
        lastDayOfThirdQuarter(): DateTime;
        firstDayOfFourthQuarter(): DateTime;
        lastDayOfFourthQuarter(): DateTime;
        firstDayOfYear(): DateTime;
        lastDayOfYear(): DateTime;
        toShortDateString(): string;
        toShortTimeString(): string;
        static get now(): DateTime;
        static get today(): DateTime;
        static isLeapYear(year: number): boolean;
        static daysInMonth(year: number, month: number): number;
        static compare(t1: DateTime, t2: DateTime): number;
        private static doubleDateToTicks;
        static ticksNetToTicksJs(ticks: number): number;
        static dateToNetTicks(date: Date): number;
        negate(): DateTime;
        addYears(value: number): DateTime;
        addMonths(value: number): DateTime;
        addDays(value: number): DateTime;
        addHours(value: number): DateTime;
        addMinutes(value: number): DateTime;
        addSeconds(value: number): DateTime;
        addMilliseconds(value: number): DateTime;
        addTicks(value: number): DateTime;
        compareTo(value: DateTime): number;
        subtract(value: DateTime): TimeSpan;
        get date(): Date;
        toString(format?: string): string;
        static oaDateToTicks0(oaDate: number): number;
        static ticksToOADate0(ticks: number): number;
        toOADate(): number;
        toOADate2(round: boolean): number;
        toNetJsonString(): string;
        getHashCode(): number;
        static tryParseExact(d: string, format: string[]): {
            result: DateTime;
            successfully: boolean;
        };
        static fromNetJsonString(jsonDate: string): DateTime;
        static fromOADate(oadate: number): DateTime;
        static fromString(d?: string, logError?: boolean): DateTime;
        static fromString2(format: string, value: string, logError?: boolean): DateTime;
        static isISO8601String(d: string): boolean;
        get timeOfDay(): TimeSpan;
        get date2(): DateTime;
        constructor(param1: Date | number, month?: number, day?: number, hour?: number, minute?: number, second?: number, millisecond?: number);
    }
}
export namespace Stimulsoft.System {
    class DateTimeOffset extends DateTime {
        static getNetTypeName(): string;
        static fromString(d?: string, logError?: boolean): DateTimeOffset;
        constructor(param1: Date | number, month?: number, day?: number, hour?: number, minute?: number, second?: number, millisecond?: number);
    }
}
export namespace Stimulsoft.System {
    enum DayOfWeek {
        Sunday = 0,
        Monday = 1,
        Tuesday = 2,
        Wednesday = 3,
        Thursday = 4,
        Friday = 5,
        Saturday = 6
    }
}
export namespace Stimulsoft.ExternalLibrary {
    type Input = Stimulsoft.ExternalLibrary.dayjs.ConfigType;
    type Dayjs = Stimulsoft.ExternalLibrary.dayjs.Dayjs;
    type OptionType = Stimulsoft.ExternalLibrary.dayjs.OptionType;
    function dayjs(date?: Input): Dayjs;
    function dayjs(date?: Input, format?: OptionType, strict?: boolean): Dayjs;
    function dayjs(date?: Input, format?: OptionType, locale?: string, strict?: boolean): Dayjs;
}
export namespace Stimulsoft.ExternalLibrary.dayjs {
    interface ConfigTypeMap {
        default: string | number | Date | Dayjs | null | undefined;
    }
    type ConfigType = ConfigTypeMap[keyof ConfigTypeMap];
    interface FormatObject {
        locale?: string;
        format?: string;
        utc?: boolean;
    }
    type OptionType = FormatObject | string | string[];
    type UnitTypeShort = 'd' | 'M' | 'y' | 'h' | 'm' | 's' | 'ms';
    type UnitTypeLong = 'millisecond' | 'second' | 'minute' | 'hour' | 'day' | 'month' | 'year' | 'date';
    type UnitTypeLongPlural = 'milliseconds' | 'seconds' | 'minutes' | 'hours' | 'days' | 'months' | 'years' | 'dates';
    type UnitType = UnitTypeLong | UnitTypeLongPlural | UnitTypeShort;
    type OpUnitType = UnitType | "week" | "weeks" | 'w';
    type QUnitType = UnitType | "quarter" | "quarters" | 'Q';
    type ManipulateType = Omit<OpUnitType, 'date' | 'dates'>;
    interface ILocale {
        name: string;
        weekdays?: string[];
        months?: string[];
        weekStart?: number;
        weekdaysShort?: string[];
        monthsShort?: string[];
        weekdaysMin?: string[];
        ordinal?: (n: number) => number | string;
        formats: Partial<{
            LT: string;
            LTS: string;
            L: string;
            LL: string;
            LLL: string;
            LLLL: string;
        }>;
        relativeTime?: Partial<{
            future: string;
            past: string;
            s: string;
            m: string;
            mm: string;
            h: string;
            hh: string;
            d: string;
            dd: string;
            M: string;
            MM: string;
            y: string;
            yy: string;
        }>;
        meridiem: {
            AM: string;
            PM: string;
        };
    }
    class Dayjs {
        constructor(config?: ConfigType);
        clone(): Dayjs;
        isValid(): boolean;
        year(): number;
        year(value: number): Dayjs;
        month(): number;
        month(value: number): Dayjs;
        date(): number;
        date(value: number): Dayjs;
        day(): number;
        day(value: number): Dayjs;
        hour(): number;
        hour(value: number): Dayjs;
        minute(): number;
        minute(value: number): Dayjs;
        second(): number;
        second(value: number): Dayjs;
        millisecond(): number;
        millisecond(value: number): Dayjs;
        set(unit: UnitType, value: number): Dayjs;
        get(unit: UnitType): number;
        add(value: number, unit?: ManipulateType): Dayjs;
        subtract(value: number, unit?: ManipulateType): Dayjs;
        startOf(unit: OpUnitType): Dayjs;
        endOf(unit: OpUnitType): Dayjs;
        format(template?: string): string;
        diff(date?: ConfigType, unit?: QUnitType | OpUnitType, float?: boolean): number;
        valueOf(): number;
        unix(): number;
        daysInMonth(): number;
        toDate(): Date;
        toJSON(): string;
        toISOString(): string;
        toString(): string;
        utcOffset(): number;
        isBefore(date: ConfigType, unit?: OpUnitType): boolean;
        isSame(date: ConfigType, unit?: OpUnitType): boolean;
        isAfter(date: ConfigType, unit?: OpUnitType): boolean;
        locale(): string;
        locale(preset: string | ILocale, object?: Partial<ILocale>): Dayjs;
    }
    interface Dayjs {
        quarter(): number;
        quarter(quarter: number): Dayjs;
        add(value: number, unit: QUnitType): Dayjs;
        subtract(value: number, unit: QUnitType): Dayjs;
        startOf(unit: QUnitType): Dayjs;
        endOf(unit: QUnitType): Dayjs;
        isSame(date: ConfigType, unit?: QUnitType): boolean;
        isBefore(date: ConfigType, unit?: QUnitType): boolean;
        isAfter(date: ConfigType, unit?: QUnitType): boolean;
    }
    type PluginFunc<T = unknown> = (option: T, c: typeof Dayjs, d: typeof dayjs) => void;
    function extend<T = unknown>(plugin: PluginFunc<T>, option?: T): Dayjs;
    function locale(preset?: string | ILocale, object?: Partial<ILocale>, isLocal?: boolean): string;
    function isDayjs(d: any): d is Dayjs;
    function unix(t: number): Dayjs;
    const Ls: {
        [key: string]: ILocale;
    };
}
export namespace Stimulsoft.System {
    class Enum {
        static getName(enumType: any, value: number): string;
        static parse(enumType: any, value: string | number, upperFirstChar?: boolean): number;
        private static upperFirstChar;
        static getNames(enumType: any): string[];
        static getValues(enumType: any): number[];
        name: string;
        value: number;
        toString(): string;
        compareTo(value: Enum): number;
        constructor(name: string, value?: number);
    }
}
export namespace Stimulsoft.System {
    class Environment {
        static get newLine(): string;
    }
}
export namespace Stimulsoft.System {
    class Event {
        private eventList;
        get isNull(): boolean;
        get isNotNull(): boolean;
        add(funct: Function, _this: any): void;
        call(...args: any[]): void;
    }
}
export namespace Stimulsoft.System {
    class EventArgs {
        static empty: EventArgs;
    }
}
export namespace Stimulsoft.System {
    import IAsIs = Stimulsoft.System.IAsIs;
    const compactBase64: (value: string) => string;
    const decompressLiteral: (value: any) => any;
    function applyMixins(dest: any, mixins: any[]): any;
    function enumerable(value: boolean): (target: any, propertyKey: string, descriptor: PropertyDescriptor) => void;
    function enumType(type: any): (target: any, propertyKey: string, descriptor: PropertyDescriptor) => void;
    function promiseCancellable(target: any, name: string, descriptor: PropertyDescriptor): any;
    class StiObject implements IAsIs {
        value: any;
        is<T>(type: (new (...args: any[]) => T) | Interface<T>): this is T;
        is2<T>(type: (new (...args: any[]) => T) | Interface<T>): boolean;
        as<T>(type: (new (...args: any[]) => T) | Interface<T>): T;
        memberwiseClone(isBase?: boolean): any;
        equals(...args: any[]): boolean;
        getHashCode(...args: any[]): number;
        static compareTo(a: any, b: any): number;
        compareTo(object: any): number;
        toBoolean(): boolean;
        toNumber(float?: boolean): number;
        toString(): string;
        getType(): Stimulsoft.System.Type;
        getTypeName(): string;
        getNetTypeName(): string;
        static referenceEquals(objA: any, objB: any): boolean;
        static addEvent(element: any, eventName: string, fn: Function): void;
        static equals(objA: any, objB: any): boolean;
        static isNullOrUndefined: (obj: any) => boolean;
        static disableAllEnumerable(prototype: any, obj: any): void;
        static keys(obj: any): string[];
        static getOwnPropertyNames(obj: any): string[];
        static saveAs(data: any, fileName: string, type?: string): void;
        private static isObject;
        static mergeDeep(target: any, ...sources: any[]): any;
        static init(): void;
        constructor(value: any);
    }
    class StiNumber extends StiObject implements IAsIs {
        value: number;
        getHashCode(...args: any[]): number;
        is(type: any): boolean;
        as(type: any): any;
        memberwiseClone(isBase?: boolean): any;
        compareTo(value: any): number;
        toShort(): number;
        toStringFormat(formatString: string): string;
        getType(): Stimulsoft.System.Type;
        getTypeName(): string;
        getNetTypeName(): string;
        private static _numberRegexp;
        static tryParse(value: string): {
            result: number;
            successfully: boolean;
        };
        static getValueOrDefault(value: number): number;
    }
    class StiString extends StiObject implements IAsIs {
        value: string;
        is(type: any): boolean;
        as(type: any): any;
        memberwiseClone(isBase?: boolean): any;
        replaceAll(searchValue: string, replaceValue: string, startIndex?: number, count?: number): string;
        contains(str: string): boolean;
        compareTo(strB: string): number;
        isBase64String(): boolean;
        remove(startIndex: number, count?: number): string;
        insert(startIndex: number, value: string, removeLength?: number): string;
        padLeft(totalWidth: number, paddingChar?: string): string;
        padRight(totalWidth: number, paddingChar?: string): string;
        startsWith(value: string, ignoreCase?: boolean): boolean;
        endsWith(value: string, ignoreCase?: boolean): boolean;
        trimStart(char?: string): string;
        trimEnd(char?: string): string;
        getHashCode(...args: any[]): number;
        toBytesArray(): number[];
        toUnicodeString(): string;
        fromUnicodeString(): string;
        indexOfAny(values: string[]): number;
        regexIndexOf(regex: RegExp, startpos: number): number;
        regexLastIndexOf(regex: RegExp, startpos: number): number;
        split(...separators: string[]): string[];
        toLowerFirst(): string;
        getType(): Stimulsoft.System.Type;
        getTypeName(): string;
        getNetTypeName(): string;
        toString(): string;
        static isNullOrEmpty(value: string): boolean;
        static isNullOrWhiteSpace(value: string): boolean;
        static repeat(value: string, n: number): string;
        static fill(value: string, count: number): string;
        static format(str: string, ...values: any[]): string;
        private static _formatRegexp;
        static format1(str: string, values: any[]): string;
        static parseFormatString(formatString: string, values: any[]): string;
        static customFormat(arg: any, format: string): string;
        static indexOfAny(str: string, searchChars: string[]): number;
        static join(separator: string, value: string[]): string;
        static fromBytesArray(bytes: number[]): string;
    }
    class StiBoolean extends StiObject implements IAsIs {
        is(type: any): boolean;
        as(type: any): any;
        memberwiseClone(isBase?: boolean): any;
        getHashCode(...args: any[]): number;
        getType(): Stimulsoft.System.Type;
        getTypeName(): string;
        getNetTypeName(): string;
        compareTo(object: boolean): number;
        toNumber(float?: boolean): number;
        toString(): string;
    }
    class StiArray extends StiObject {
        getHashCode(): number;
        getType(): Stimulsoft.System.Type;
        getTypeName(): string;
        getNetTypeName(): string;
        get countItems(): number;
        contains(item: any): boolean;
        remove<T>(item: T): void;
        removeAt(index: number): void;
        insert(index: number, item: any): void;
        clear(): void;
        clone(): any;
        addRange(items: any[]): void;
        removeRange(index: number, count: number): void;
        copyTo(array: any[], index?: number): void;
        getKeys(): string[];
        getByIndex(index: number, keys?: string[]): any;
        setByIndex(index: number, item: any): void;
        removeByIndex(index: number): any;
        sort2(comparer: Stimulsoft.System.Collections.IComparer<any>): any[];
        getLength(dimension: number): number;
        toArray(): any[];
        toNumber(float?: boolean): number;
        peek(): any;
        toList<T>(): Stimulsoft.System.Collections.List<T>;
        static create<T>(t: Stimulsoft.System.Type, count: number, isStructure?: boolean): T[];
        static create2<T>(t: Stimulsoft.System.Type, count1: number, count2: number, isStructure?: boolean): T[][];
        static create3<T>(t: Stimulsoft.System.Type, count1: number, count2: number, count3: number, isStructure?: boolean): T[][][];
        static create1<T>(t: Stimulsoft.System.Type, ...values: any[]): T[];
        static numberSortFunction: () => any;
        static copy: (sourceArray: any[], startIndex: number, destinationArray: any[], count: number) => void;
        static copy2: (sourceArray: any[], sourceIndex: number, destinationArray: any[], destinationIndex: number, count: number) => void;
        static copy3: (sourceArray: any[], destinationArray: any[]) => void;
        static reverse: (array: any[]) => any[];
        static sort: (array: any[]) => any[];
        static sort3(keys: number[], items: any[]): void;
        static clear: (array: any[], index: number, length: number) => any[];
        static distinct<T>(array: T[]): T[];
        static isArray<T>(data: any): data is Array<T>;
        constructor(value: any);
    }
}
interface Object {
    //StiObject;
    stimulsoft(): Stimulsoft.System.StiObject;
}
interface String {
    //StiString;
    stimulsoft(): Stimulsoft.System.StiString;
}
interface Number {
    //StiNumber;
    stimulsoft(): Stimulsoft.System.StiNumber;
}
interface Boolean {
    //StiBoolean;
    stimulsoft(): Stimulsoft.System.StiBoolean;
}
interface Array<T> {
    //StiArray;
    stimulsoft(): Stimulsoft.System.StiArray;
}
export namespace Stimulsoft.System {
    class EventHandler {
        static _this: any;
        private static handler;
        private args;
        create(script: string, _this: any): Function;
        private static fixName;
        static create(script: string, _this: any): Function;
        constructor(args: string);
    }
}
export namespace Stimulsoft.System {
    class Exception extends Error {
        innerException?: Exception;
        constructor(message?: string, innerException?: Exception);
    }
}
export namespace Stimulsoft.ExternalLibrary.Fontkit {
    function create(buffer: number[]): {};
}
export namespace Stimulsoft.System {
    class Guid {
        private id;
        static newGuid(): Guid;
        static newGuidString(): string;
        private static s4;
        toString(): string;
        static get empty(): Guid;
        static compareTo(value: Guid): number;
        constructor(id: string);
    }
}
export namespace Stimulsoft.System {
    class Interface<T> {
        typeName: string;
        type: T;
        constructor(typeName: string);
    }
}
export namespace Stimulsoft.System {
    let IAsIs: Interface<IAsIs>;
    interface IAsIs {
        is<T>(type: (new (...args: any[]) => T) | Interface<T>): this is T;
        is2<T>(type: (new (...args: any[]) => T) | Interface<T>): boolean;
        as<T>(type: (new (...args: any[]) => T) | Interface<T>): T;
    }
}
export namespace Stimulsoft.System {
    let ICloneable: Interface<ICloneable>;
    interface ICloneable {
        clone(): any;
    }
}
export namespace Stimulsoft.System {
    let IComparable: Interface<IComparable>;
    interface IComparable {
        compareTo(obj: any): number;
    }
}
export namespace Stimulsoft.System {
    let IFormatProvider: Interface<IFormatProvider>;
    interface IFormatProvider {
        getFormat(formatType: Type): any;
    }
}
export namespace Stimulsoft.System {
    class JSON2 {
        static decode(text: string): any;
        static encode(value: any): string;
        static stiPopulateObject(json: any, object: any): void;
    }
}
export namespace Stimulsoft.System {
    enum MidpointRounding {
        ToEven = 1000,
        AwayFromZero = 1001,
        ToZero = 1002,
        ToNegativeInfinity = 1003,
        ToPositiveInfinity = 1004
    }
}
interface ObjectConstructor {
    saveAs(data: any, fileName: string, type?: string): any;
}
export namespace Stimulsoft.System {
}
export namespace Stimulsoft.Report {
    import Type = Stimulsoft.System.Type;
    class Range {
        static isRangeType(type: Type): boolean;
        static isNumericRangeType(type: Type): boolean;
        get rangeName(): string;
        get rangeType(): Stimulsoft.System.Type;
        get fromObject(): any;
        set fromObject(value: any);
        get toObject(): any;
        set toObject(value: any);
        parse(from: string, to: string): void;
        equals(obj: any): boolean;
        get fromStrLoc(): string;
        get toStrLoc(): string;
        toString(): string;
        getHashCode(): number;
        constructor();
    }
    class CharRange extends Range {
        from: string;
        to: string;
        get rangeName(): string;
        get rangeType(): Stimulsoft.System.Type;
        get fromObject(): any;
        set fromObject(value: any);
        get toObject(): any;
        set toObject(value: any);
        contains(value: string): boolean;
        constructor(from?: string, to?: string);
    }
    class DateTimeRange extends Range {
        from: Stimulsoft.System.NullableDateTime;
        to: Stimulsoft.System.NullableDateTime;
        get rangeName(): string;
        get rangeType(): Stimulsoft.System.Type;
        get fromObject(): any;
        set fromObject(value: any);
        get toObject(): any;
        set toObject(value: any);
        get fromDate(): Stimulsoft.System.DateTime;
        get toDate(): Stimulsoft.System.DateTime;
        contains(value: Stimulsoft.System.DateTime): boolean;
        toString(): string;
        constructor(from?: Stimulsoft.System.DateTime, to?: Stimulsoft.System.DateTime);
    }
    class TimeSpanRange extends Range {
        from: Stimulsoft.System.NullableTimeSpan;
        to: Stimulsoft.System.NullableTimeSpan;
        get rangeName(): string;
        get rangeType(): Stimulsoft.System.Type;
        get fromObject(): any;
        set fromObject(value: any);
        get toObject(): any;
        set toObject(value: any);
        get fromTime(): Stimulsoft.System.TimeSpan;
        get toTime(): Stimulsoft.System.TimeSpan;
        contains(value: Stimulsoft.System.TimeSpan): boolean;
        toString(): string;
        constructor(from?: Stimulsoft.System.TimeSpan, to?: Stimulsoft.System.TimeSpan);
    }
    class DecimalRange extends Range {
        from: number;
        to: number;
        get rangeName(): string;
        get rangeType(): Stimulsoft.System.Type;
        get fromObject(): any;
        set fromObject(value: any);
        get toObject(): any;
        set toObject(value: any);
        contains(value: number): boolean;
        constructor(from?: number, to?: number);
    }
    class FloatRange extends Range {
        from: number;
        to: number;
        get rangeName(): string;
        get rangeType(): Stimulsoft.System.Type;
        get fromObject(): any;
        set fromObject(value: any);
        get toObject(): any;
        set toObject(value: any);
        contains(value: number): boolean;
        constructor(from?: number, to?: number);
    }
    class DoubleRange extends Range {
        from: number;
        to: number;
        get rangeName(): string;
        get rangeType(): Stimulsoft.System.Type;
        get fromObject(): any;
        set fromObject(value: any);
        get toObject(): any;
        set toObject(value: any);
        contains(value: number): boolean;
        constructor(from?: number, to?: number);
    }
    class ByteRange extends Range {
        from: number;
        to: number;
        get rangeName(): string;
        get rangeType(): Stimulsoft.System.Type;
        get fromObject(): any;
        set fromObject(value: any);
        get toObject(): any;
        set toObject(value: any);
        contains(value: number): boolean;
        constructor(from?: number, to?: number);
    }
    class ShortRange extends Range {
        from: number;
        to: number;
        get rangeName(): string;
        get rangeType(): Stimulsoft.System.Type;
        get fromObject(): any;
        set fromObject(value: any);
        get toObject(): any;
        set toObject(value: any);
        contains(value: number): boolean;
        constructor(from?: number, to?: number);
    }
    class IntRange extends Range {
        from: number;
        to: number;
        get rangeName(): string;
        get rangeType(): Stimulsoft.System.Type;
        get fromObject(): any;
        set fromObject(value: any);
        get toObject(): any;
        set toObject(value: any);
        contains(value: number): boolean;
        constructor(from?: number, to?: number);
    }
    class LongRange extends Range {
        from: number;
        to: number;
        get rangeName(): string;
        get rangeType(): Stimulsoft.System.Type;
        get fromObject(): any;
        set fromObject(value: any);
        get toObject(): any;
        set toObject(value: any);
        contains(value: number): boolean;
        constructor(from?: number, to?: number);
    }
    class GuidRange extends Range {
        from: Stimulsoft.System.Guid;
        to: Stimulsoft.System.Guid;
        get rangeName(): string;
        get rangeType(): Stimulsoft.System.Type;
        get fromObject(): any;
        set fromObject(value: any);
        get toObject(): any;
        set toObject(value: any);
        contains(value: Stimulsoft.System.Guid): boolean;
        constructor(from?: Stimulsoft.System.Guid, to?: Stimulsoft.System.Guid);
    }
    class StringRange extends Range {
        from: string;
        to: string;
        get rangeName(): string;
        get rangeType(): Stimulsoft.System.Type;
        get fromObject(): any;
        set fromObject(value: any);
        get toObject(): any;
        set toObject(value: any);
        contains(value: string): boolean;
        constructor(from?: string, to?: string);
    }
}
export namespace Stimulsoft.System {
    import CultureInfo = Stimulsoft.System.Globalization.CultureInfo;
    class ResourceManager {
        private resource;
        getString(name: string, culture: CultureInfo): string;
    }
}
export namespace Stimulsoft.System {
    class StiError {
        static consoleErrorLog: boolean;
        static consoleWarningLog: boolean;
        static consoleMessageLog: boolean;
        private static lastErrorMessage;
        static errorMessageForm: any;
        static showError(e: any, showForm?: boolean, infoForm?: boolean): void;
    }
}
export namespace Stimulsoft.System {
    import MidpointRounding = Stimulsoft.System.MidpointRounding;
    class StiMath {
        private static roundToInt;
        static round2(value: number, precision?: number, mode?: MidpointRounding): number;
        static trunc(x: number): number;
        static sign(x: number): number;
        static log10(value: number): number;
    }
}
export namespace Stimulsoft.System {
    enum StiNavigatorType {
        Unknown = 0,
        Edge = 1,
        MSIE = 2,
        Chrome = 3,
        Safari = 4,
        Mozilla = 5,
        Opera = 6
    }
    class StiNavigator {
        private static _type;
        static get type(): StiNavigatorType;
        static get isIE(): boolean;
    }
}
type NumberFormatInfo = Stimulsoft.System.Globalization.NumberFormatInfo;
export namespace Stimulsoft.System.Internals {
    function formatNumber(value: number, format: string, info?: NumberFormatInfo): string;
    namespace formatNumber {
        export function decimalFormat(value: number, precision?: number, info?: NumberFormatInfo): string;
        export function hexadecimalFormat(value: number, precision?: number, isUpper?: boolean): string;
        export function fixedPointFormat(value: number, precision?: number, info?: NumberFormatInfo): string;
        export function currencyFormat(value: number, precision?: number, info?: NumberFormatInfo): string;
        export function placeCurrencyValue(value: string, isPositive: boolean, negativeSign: string, currencySymbol: string, patternNumber: number): string;
        export function numericFormat(value: number, precision?: number, info?: NumberFormatInfo): string;
        export function exponentialFormat(value: number, precision?: number, isUpper?: boolean, info?: NumberFormatInfo, minExpDigits?: number): string;
        export function roundTripFormat(value: number, info?: NumberFormatInfo): string;
        export function generalFormat(value: number, precision?: number, isUpper?: boolean, info?: NumberFormatInfo): string;
        export function percentFormat(value: number, precision?: number, info?: NumberFormatInfo): string;
        const SpecifierToken = 1;
        const TextToken = 2;
        type CustomFormatElement = {
            type: (typeof SpecifierToken | typeof TextToken);
            token: string;
        };
        type CustomFormat = {
            tokens: CustomFormatElement[];
            useGroupSeparators: boolean;
            numbersBeforeDot: number;
            numbersAfterDot: number;
            effectiveNumbersBeforeDot: number;
            effectiveNumbersAfterDot: number;
            dotIndex: number;
            scaling: number;
            expIndex: number;
        };
        export function parseCustomFormatString(format: string): {
            tokens: CustomFormatElement[];
            useGroupSeparators: boolean;
            numbersBeforeDot: number;
            numbersAfterDot: number;
            effectiveNumbersBeforeDot: number;
            effectiveNumbersAfterDot: number;
            dotIndex: number;
            scaling: number;
            expIndex: number;
        };
        export function normalizeForFormat(value: number, format: CustomFormat, info?: NumberFormatInfo): string[];
        export function customFormat(numberParts: string[], format: CustomFormat, info?: NumberFormatInfo): string;
        export function trimTrailingZeros(value: string, decimalSeparator: string): string;
        export function splitToGroups(intPart: string, groupSeparator?: string, groupSizes?: number[]): string;
        export function splitToGroupsArray(intPart: string, groupSizes?: number[]): string[];
        export function getFixedPointNumberParts(value: number, precision: number, negativeSign?: string): string[];
        export function seemsToBeZero(intPart: string, fraction: string): boolean;
        export {};
    }
}
export namespace Stimulsoft.System {
    class StiPromise<T> {
        private _this;
        returnValue: T;
        private _tryFunctions;
        private _finallyFunction;
        private _timeout;
        private _startTime;
        private _callTry;
        private _callCatch;
        private _callFinaly;
        private _callTimeout;
        private _catchArgument;
        private _finalyArgument;
        private timeoutHanderId;
        private assignFunction;
        private _catchFunctions;
        try(tryFunction: Function, _this?: any): StiPromise<T>;
        catch(catchFunction: Function, _this?: any): StiPromise<T>;
        finally(finallyFunction: Function, _this?: any): StiPromise<T>;
        this(_this: any): StiPromise<T>;
        timeout(timeout: number): StiPromise<T>;
        callTry(returnValue?: T): StiPromise<T>;
        callCatch(catchArgument?: any): void;
        private callFinally;
        callTimeout(): void;
        private nextPromises;
        abort(previusPromise?: StiPromise<any>): StiPromise<T>;
        private abortFunction;
        onAbort(abortFunction: Function): void;
        private behindFunction;
        onBehindFunction(behindFunction: Function): void;
        promise(): Promise<T>;
        static lock(lockObject: any): Promise<void>;
        static unlock(lockObject: any): void;
        constructor();
    }
}
export namespace Stimulsoft.System {
    enum StringComparison {
        CurrentCulture = 0,
        CurrentCultureIgnoreCase = 1,
        InvariantCulture = 2,
        InvariantCultureIgnoreCase = 3,
        Ordinal = 4,
        OrdinalIgnoreCase = 5
    }
}
export namespace Stimulsoft.System {
    class SwitchSymbolFormatter {
        private numberSymbol;
        private isValid;
        formatValue(format: string, source: any): string;
        constructor(numberSymbol?: string);
    }
}
export namespace Stimulsoft.System {
    class TimeSpan {
        static ticksPerMillisecond: number;
        private static millisecondsPerTick;
        static ticksPerSecond: number;
        private static secondsPerTick;
        static ticksPerMinute: number;
        private static minutesPerTick;
        static ticksPerHour: number;
        private static hoursPerTick;
        static ticksPerDay: number;
        private static daysPerTick;
        private static millisPerSecond;
        private static millisPerMinute;
        private static millisPerHour;
        private static millisPerDay;
        static maxSeconds: number;
        static minSeconds: number;
        static maxMilliSeconds: number;
        static minMilliSeconds: number;
        static ticksPerTenthSecond: number;
        static get zero(): TimeSpan;
        static getNetTypeName(): string;
        private static _minValue;
        static get minValue(): TimeSpan;
        private static _maxValue;
        static get maxValue(): TimeSpan;
        private _minus;
        ticks: number;
        get days(): number;
        get hours(): number;
        get milliseconds(): number;
        get minutes(): number;
        get seconds(): number;
        get totalDays(): number;
        get totalHours(): number;
        get totalMilliseconds(): number;
        get totalMinutes(): number;
        get totalSeconds(): number;
        static fromString(value: string, format?: string): TimeSpan;
        private static interval;
        static fromTicks(value: number): TimeSpan;
        static fromSeconds(value: number): TimeSpan;
        static fromMilliseconds(value: number): TimeSpan;
        add(value: number): TimeSpan;
        add2(value: TimeSpan): TimeSpan;
        toString(format?: string): string;
        negate(): TimeSpan;
        private static timeToTicks;
        static create(days?: number, hours?: number, minutes?: number, seconds?: number, milliseconds?: number): TimeSpan;
        constructor(param1?: number, minutes?: number, seconds?: number, milliseconds?: number);
    }
}
export namespace Stimulsoft.System {
    enum TypeCode {
        Empty = 0,
        Object = 1,
        DBNull = 2,
        Boolean = 3,
        Char = 4,
        SByte = 5,
        Byte = 6,
        Int16 = 7,
        UInt16 = 8,
        Int32 = 9,
        UInt32 = 10,
        Int64 = 11,
        UInt64 = 12,
        Single = 13,
        Double = 14,
        Decimal = 15,
        DateTime = 16,
        String = 18
    }
}
export namespace Stimulsoft.System {
    import TypeCode = Stimulsoft.System.TypeCode;
    class TypeHelper {
        private static types;
        static getTypes(): Stimulsoft.System.Type[];
        static isValueType(type: Type): boolean;
    }
    class Type {
        apply(thisArg: any, argArray?: any): any;
        call(thisArg: any, ...argArray: any[]): any;
        bind(thisArg: any, ...argArray: any[]): any;
        prototype: any;
        length: number;
        arguments: any;
        caller: Function;
        name: string;
        [Symbol.hasInstance]: any;
        static getType(value: any): Type;
        static getTypeName(value: any): string;
        static getTypeCode(value: any): TypeCode;
        static isNumericType(type: Type): boolean;
        static isIntegerType(type: Type): boolean;
        static isDateType(type: Type): boolean;
        static isArrayType(type: Type): boolean;
        static getHashCode(type: any): number;
    }
    type KeyObjectType = {
        [key: string]: {};
    };
    class Byte {
    }
    class ByteArray {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class Decimal {
    }
    class Double {
    }
    class Float {
    }
    class Int {
    }
    class Int16 {
    }
    class Int32 {
    }
    class Int64 {
    }
    class Short {
    }
    class Long {
    }
    class SByte {
    }
    class Single extends Number {
    }
    class UInt {
    }
    class UInt16 {
    }
    class UInt32 {
    }
    class UInt64 {
    }
    class UShort {
    }
    class ULong {
    }
    class Nullable {
    }
    class NullableBoolean extends Nullable {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class NullableByte extends Nullable {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class NullableChar extends Nullable {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class NullableDateTime extends Nullable {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class NullableDateTimeOffset extends Nullable {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class NullableTimeSpan extends Nullable {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class NullableDecimal extends Nullable {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class NullableDouble extends Nullable {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class NullableFloat extends Nullable {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class NullableGuid extends Nullable {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class NullableInt extends Nullable {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class NullableInt16 extends Nullable {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class NullableInt32 extends Nullable {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class NullableInt64 extends Nullable {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class NullableShort extends Nullable {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class NullableLong extends Nullable {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class NullableSByte extends Nullable {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class NullableSingle extends Nullable {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class NullableUInt extends Nullable {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class NullableUInt16 extends Nullable {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class NullableUInt32 extends Nullable {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class NullableUInt64 extends Nullable {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class NullableUShort extends Nullable {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class NullableULong extends Nullable {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class StimulsoftByteRange extends Stimulsoft.Report.ByteRange {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class StimulsoftCharRange extends Stimulsoft.Report.CharRange {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class StimulsoftDateTimeRange extends Stimulsoft.Report.DateTimeRange {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class StimulsoftDecimalRange extends Stimulsoft.Report.DecimalRange {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class StimulsoftDoubleRange extends Stimulsoft.Report.DoubleRange {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class StimulsoftFloatRange extends Stimulsoft.Report.FloatRange {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class StimulsoftGuidRange extends Stimulsoft.Report.GuidRange {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class StimulsoftIntRange extends Stimulsoft.Report.IntRange {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class StimulsoftLongRange extends Stimulsoft.Report.LongRange {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class StimulsoftShortRange extends Stimulsoft.Report.ShortRange {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class StimulsoftStringRange extends Stimulsoft.Report.StringRange {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class StimulsoftTimeSpanRange extends Stimulsoft.Report.TimeSpanRange {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class StimulsoftList {
        static isListType(type: Type): boolean;
    }
    class StimulsoftBoolList extends StimulsoftList {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class StimulsoftByteList extends StimulsoftList {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class StimulsoftCharList extends StimulsoftList {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class StimulsoftDateTimeList extends StimulsoftList {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class StimulsoftDecimalList extends StimulsoftList {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class StimulsoftDoubleList extends StimulsoftList {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class StimulsoftFloatList extends StimulsoftList {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class StimulsoftGuidList extends StimulsoftList {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class StimulsoftIntList extends StimulsoftList {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class StimulsoftLongList extends StimulsoftList {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class StimulsoftShortList extends StimulsoftList {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class StimulsoftStringList extends StimulsoftList {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
    class StimulsoftTimeSpanList extends StimulsoftList {
        static getTypeName(): string;
        static getNetTypeName(): string;
    }
}
export namespace Stimulsoft.ExternalLibrary.XXH {
    function h32(value: string, seed: number): number;
}
export namespace Stimulsoft.ExternalLibrary.xmldoc {
    class XmlDocument {
        constructor(xmlString: string);
    }
}
export namespace Stimulsoft.System.Collections {
    class CollectionBase<T> implements ICollection<T> {
        list: T[];
        toList(): List<T>;
        toCast<C>(): C[];
        get count(): number;
        get length(): number;
        clear(): void;
        add(value: T): void;
        addRange(data: T[] | CollectionBase<T>): void;
        remove(item: T): void;
        removeAt(index: number): void;
        indexOf(item: T): number;
        getByIndex(index: number): T;
        setByIndex(index: number, value: T): void;
        insert(index: number, value: T): void;
        contains(item: T | any): boolean;
    }
}
export namespace Stimulsoft.System.Collections {
    class Hashtable<K = any, V = any> {
        private ignoreCase;
        private data;
        get keys(): LinqHelper<K>;
        get values(): LinqHelper<V>;
        [Symbol.iterator](): Iterator<{
            key: K;
            value: V;
        }>;
        constructor(options?: {
            ignoreCase: boolean;
        });
        protected getActualKey(key: K): string | K;
        protected getRawValueByKey(key: K): {
            key: K;
            value: V;
        };
        get(key: K): V;
        set(key: K, value: V): void;
        add(key: K, value: V): void;
        contains(key: K): boolean;
        containsKey(key: K): boolean;
        containsValue(value: V): boolean;
        remove(key: K): void;
        clear(): void;
        copyTo(array: V[], arrayIndex: number): void;
        get count(): number;
        clone(): Hashtable<K, V>;
    }
}
export namespace Stimulsoft.System.Collections {
    class Dictionary<K, V> extends Hashtable<K, V> {
        get pairs(): Iterable<{
            key: K;
            value: V;
        }>;
        tryGetValue(key: K, out: {
            ref: V;
        }): boolean;
    }
}
export namespace Stimulsoft.System.Collections {
    class DictionaryEntry {
        key: any;
        value: any;
    }
}
export namespace Stimulsoft.System.Collections {
    abstract class Enumerable<T> {
        protected get source(): Iterable<T>;
        where(predicate: (value: T, index: number) => boolean, __this?: any): LinqHelper<T>;
        cast<S>(): LinqHelper<S>;
        toList(): Stimulsoft.System.Collections.List<T>;
        get list(): Stimulsoft.System.Collections.List<T>;
        toArray(): T[];
        toDictionary<K, V>(keySelector: (item: T) => K, elementSelector: (item: T) => V): Stimulsoft.System.Collections.Dictionary<K, V>;
        toLookup<K>(keySelector: (value: T) => K, __this?: any): Stimulsoft.System.Collections.Hashtable;
        static repeat<T>(element: T, count: number): LinqHelper<T>;
        select<S>(selector: (value: T) => S, __this?: any): LinqHelper<S>;
        selectMany<S>(selector: (value: T) => List<S>, __this?: any): LinqHelper<S>;
        selectMany2<C, V>(collectionSelector: (value: T) => List<C>, resultSelector: (value1: T, value2: C) => V, __this?: any): LinqHelper<V>;
        concat(second: Iterable<T>): LinqHelper<T>;
        aggregate(func: (av: T, e: T) => T): T;
        aggregate2(seed: T, func: (av: T, e: T) => T): T;
        count2(selector?: (value: T) => boolean, __this?: any): number;
        max<S>(selector?: (value: T) => S): S;
        min<S>(selector?: (value: T) => S): S;
        sum(selector?: (value: T) => number): number;
        average(selector?: (value: T) => number): number;
        all(predicate?: (value: T) => boolean, __this?: any): boolean;
        any(predicate?: (value: T) => boolean, __this?: any): boolean;
        contains(item: T): boolean;
        skip(count: number): LinqHelper<T>;
        take(count: number): LinqHelper<T>;
        sequenceEqual(second: Iterable<T>): boolean;
        first(selector?: (value: T) => boolean, __this?: any): T;
        firstOrDefault(predicate?: (value: T) => boolean): T;
        lastOrDefault(): T;
        distinct(): LinqHelper<T>;
        except(second: Iterable<T>): LinqHelper<T>;
        union(second: Iterable<T>): LinqHelper<T>;
        orderBy<K>(keySelector: (value: T) => K, comparer?: IComparer<K>): LinqHelper<T>;
        orderByDescending<K>(keySelector: (value: T) => K, comparer?: IComparer<K>): LinqHelper<T>;
        groupBy<K>(keySelector: (value: T) => K, comparer?: IEqualityComparer<K>, __this?: any): Stimulsoft.System.Collections.List<Grouping<K, T>>;
        join2<U, K, V>(inner: Iterable<U>, outerKeySelector: (value: T) => K, innerKeySelector: (value: U) => K, resultSelector: (value1: T, value2: U) => V, __this?: any): LinqHelper<V>;
        groupJoin<U, K, V>(inner: Iterable<U>, outerKeySelector: (value: T) => K, innerKeySelector: (value: U) => K, resultSelector: (value1: T, value2: List<U>) => V, __this?: any): LinqHelper<V>;
        defaultIfEmpty(): LinqHelper<T>;
        zip<S, R>(second: Iterable<S>, resultSelector: (first: T, second: S) => R): LinqHelper<R>;
        fullOuterJoin<K, V, Z>(inner: Iterable<V>, outerKeySelector: (value: T) => K, innerKeySelector: (value: V) => K, resultSelector: (value1: T, value2: V) => Z, __this?: any): LinqHelper<Z>;
    }
    class LinqHelper<T> extends Enumerable<T> {
        private _source;
        constructor(source: Iterable<T>);
        protected get source(): Iterable<T>;
        copyTo(array: T[], index: number): void;
        [Symbol.iterator](): Generator<T, void, undefined>;
    }
}
export namespace Stimulsoft.System.Collections {
    import DateTime = Stimulsoft.System.DateTime;
    class List<T> extends Array<T> {
        constructor(items?: T[] | number);
        static create<T>(t: Stimulsoft.System.Type, ...values: any[]): List<T>;
        get countItems(): number;
        addRange(items: List<T> | T[]): void;
        removeRange(index: number, count: number): void;
        getRange(index: number, count: number): List<T>;
        add(item: T): void;
        insert(index: number, item: T): void;
        getKeys(): string[];
        getByIndex(index: number, keys?: string[]): T;
        setByIndex(index: number, item: T, keys?: string[]): void;
        removeByIndex(index: number): List<T>;
        copyTo(array: any[], index?: number): void;
        clear(): void;
        peek(): T;
        remove(item: T): void;
        removeAt(index: number): void;
        exists(predicate: (value: T) => boolean): boolean;
        fullOuterJoin<K, V, Z>(inner: List<V>, outerKeySelector: (value: T) => K, innerKeySelector: (value: V) => K, resultSelector: (value1: T, value2: V) => Z, __this?: any): List<Z>;
        toList(): List<T>;
        findIndex2(match: (value: T) => boolean): number;
        findLastIndex2(match: (value: T) => boolean): number;
        zip<S, R>(second: List<S>, resultSelector: (first: T, second: S) => R): List<R>;
        static repeat<T>(element: T, count: number): List<T>;
        
        whereAsync(predicate: (value: T, index: number) => Promise<boolean>, __this?: any): Promise<List<T>>;
        join2<U, K, V>(inner: List<U>, outerKeySelector: (value: T) => K, innerKeySelector: (value: U) => K, resultSelector: (value1: T, value2: U) => V, __this?: any): List<V>;
        groupJoin<U, K, V>(inner: List<U>, outerKeySelector: (value: T) => K, innerKeySelector: (value: U) => K, resultSelector: (value1: T, value2: List<U>) => V, __this?: any): List<V>;
        
        selectAsync<S>(selector: (value: T) => Promise<S>, __this?: any): Promise<List<S>>;
        
        selectMany2<C, V>(collectionSelector: (value: T) => List<C>, resultSelector: (value1: T, value2: C) => V, __this?: any): List<V>;
        
        orderByDescending<K>(keySelector: (value: T) => K, comparer?: IComparer<K>): List<T>;
        groupBy<K>(keySelector: (value: T) => K, __this?: any): List<Grouping<K, T>>;
        groupBy2<K>(keySelector: (value: T) => K, comparer?: IEqualityComparer<K>, __this?: any): List<Grouping<K, T>>;
        cast<S>(): List<S>;
        toDictionary<K, V>(keySelector: (item: T) => K, elementSelector: (item: T) => V): Dictionary<K, V>;
        toLookup<K>(keySelector: (value: T) => K, __this?: any): Hashtable;
        
        aggregate(func: (av: T, e: T) => T): T;
        aggregate2(seed: T, func: (av: T, e: T) => T): T;
        count2(selector?: (value: T) => boolean, __this?: any): number;
        max<S>(selector?: (value: T) => S): S;
        min<S>(selector?: (value: T) => S): S;
        sum(selector?: (value: T) => number): number;
        average(selector?: (value: T) => number): number;
        all(predicate?: (value: T) => boolean, __this?: any): boolean;
        any(predicate?: (value: T) => boolean, __this?: any): boolean;
        contains(item: T): boolean;
        
        take(count: number): List<T>;
        defaultIfEmpty(): List<T>;
        distinct(): List<T>;
        except(second: List<T>): List<T>;
        union(second: List<T>): List<T>;
        sequenceEqual(second: List<T>): boolean;
        first(selector?: (value: T) => boolean, __this?: any): T;
        firstOrDefault(predicate?: (value: T) => boolean): T;
        lastOrDefault(): T;
        whereEqualsTo(values1: any, values2: any): List<any[]>;
        whereArrayItemEqualsTo(itemIndex: number, value: any): List<any[]>;
        whereArrayItemStringEqualsTo(itemIndex: number, value: string): List<any[]>;
        whereFirstOrDefaultArrayItemStringEqualsTo(itemIndex: number, value: string): any[];
        static toString2(value: any): string;
        getArrayItem(itemIndex: number): List<any[]>;
        tryCastValueOrFirstDefaultToNullableNumber(): List<number | null>;
        tryCastToNullableNumber(): List<number | null>;
        tryCastToNumber(): List<number | null>;
        tryCastToBool(): List<boolean | null>;
        tryCastToDateTime(): List<DateTime>;
        tryCastToNullableDateTime(): List<DateTime | null>;
        tryCastToTimeSpan(): List<TimeSpan>;
        tryCastToNullableTimeSpan(): List<TimeSpan | null>;
        tryCastToString(): List<string>;
        firstOrDefaultAsNullableNumber(): number | null;
        firstOrDefaultAsNumber(): number;
        static getValueOrFirstOrDefault(value: any): any;
        static add2(a: any, b: any): List<any>;
        static sub(a: any, b: any): List<any>;
        static mult(a: any, b: any): List<any>;
        static bitwiseAnd(a: any, b: any): List<any>;
        static bitwiseXOr(a: any, b: any): List<any>;
        static bitwiseOr(a: any, b: any): List<any>;
        static div(a: any, b: any): List<any>;
    }
}
export namespace Stimulsoft.System.Collections {
    class Grouping<K, V> extends List<V> {
        key: K;
    }
}
export namespace Stimulsoft.System.Collections {
    let ICollection: ICollection<any>;
    interface ICollection<T> {
        list: T[];
        clear(): void;
        removeAt(index: number): void;
        count: number;
        length: number;
        getByIndex(index: number): T;
        toCast<C>(): C[];
    }
}
export namespace Stimulsoft.System.Collections {
    let IComparer: IComparer<any>;
    interface IComparer<T> {
        compare(x: T, y: T): number;
    }
}
export namespace Stimulsoft.System.Collections {
    let IEnumerator: Interface<IEnumerator>;
    interface IEnumerator {
        current: any;
        moveNext(): boolean;
        reset(): void;
    }
}
export namespace Stimulsoft.System.Collections {
    let IEqualityComparer: IEqualityComparer<any>;
    interface IEqualityComparer<T> {
        equals(x: T, y: T): boolean;
        getHashCode(obj: T): number;
    }
}
export namespace Stimulsoft.System.Collections {
    class Queue<T> {
        dequeue(): T;
        enqueue(item: T): void;
        get count(): number;
        clear(): void;
    }
}
export namespace Stimulsoft.System.Collections {
    class Stack<T> {
        pop(): T;
        push(item: T): void;
        clear(): void;
    }
}
export namespace Stimulsoft.System.Crypt {
    class AES {
        private key;
        private data;
        private blockSize;
        private iv;
        private prevBlock;
        private SBOX;
        private INV_SBOX;
        private SUB_MIX_0;
        private SUB_MIX_1;
        private SUB_MIX_2;
        private SUB_MIX_3;
        private INV_SUB_MIX_0;
        private INV_SUB_MIX_1;
        private INV_SUB_MIX_2;
        private INV_SUB_MIX_3;
        private RCON;
        private nRounds;
        private invKeySchedule;
        private keySchedule;
        private doReset;
        private process;
        private processBlock;
        private xorBlock;
        private pkcs7pad;
        private pkcs7Unpad;
        private encryptBlock;
        private decryptBlock;
        private doCryptBlock;
        static encrypt(text: string, key: string): string;
        private encrypt;
        static decrypt(text: string, key: string): string;
        private decrypt;
        constructor();
    }
}
export namespace Stimulsoft.System.Crypt {
    class BigInteger {
        private static BI_RM;
        private static BI_RC;
        private static canary;
        private static j_lm;
        private static dbits;
        private static lowprimes;
        private static lplim;
        static staticConstructor(): void;
        private static fromInt;
        static ZERO: BigInteger;
        static ONE: BigInteger;
        get DV(): number;
        get DB(): number;
        get DM(): number;
        private BI_FP;
        private get FV();
        private get F1();
        private get F2();
        t: number;
        s: number;
        am(i: number, x: number, w: BigInteger, j: number, c: number, n: number): number;
        static int2char(n: any): string;
        private int2char;
        private intAt;
        copyTo(r: BigInteger): void;
        private fromInt;
        static fromString(s: any, b?: number): BigInteger;
        fromString(s: any, b?: number): void;
        clamp(): void;
        toString(radix: number): string;
        private negate;
        abs(): BigInteger;
        compareTo(a: BigInteger): number;
        private nbits;
        bitLength(): number;
        dlShiftTo(n: number, r: BigInteger): void;
        drShiftTo(n: number, r: BigInteger): void;
        private lShiftTo;
        private rShiftTo;
        subTo(a: BigInteger, r: BigInteger): void;
        multiplyTo(a: BigInteger, r: BigInteger): void;
        squareTo(r: BigInteger): void;
        divRemTo(m: BigInteger, q: BigInteger, r: BigInteger): void;
        mod(a: BigInteger): BigInteger;
        invDigit(): number;
        private isEven;
        private exp;
        modPowInt(e: number, m: BigInteger): BigInteger;
        private clone;
        private intValue;
        private byteValue;
        private shortValue;
        private chunkSize;
        private signum;
        private toRadix;
        private fromRadix;
        static fromNumber(a: number, b: number, c: SecureRandom): BigInteger;
        fromNumber(a: number, b: number, c: SecureRandom): void;
        private fromNumber2;
        toByteArray(): number[];
        private bitwiseTo;
        private op_or;
        private shiftLeft;
        private shiftRight;
        private lbit;
        private getLowestSetBit;
        private testBit;
        private addTo;
        private add;
        subtract(a: BigInteger): BigInteger;
        multiply(a: BigInteger): BigInteger;
        square(): BigInteger;
        divide(a: any): BigInteger;
        private remainder;
        private multiply2;
        addOffset2(n: number, w: number): void;
        multiplyLowerTo(a: BigInteger, n: number, r: BigInteger): void;
        multiplyUpperTo(a: BigInteger, n: number, r: BigInteger): void;
        private modPow;
        gcd(a: BigInteger): BigInteger;
        private modInt;
        modInverse(m: BigInteger): BigInteger;
        isProbablePrime(t: any): boolean;
        private millerRabin;
    }
}
export namespace Stimulsoft.System.Crypt {
    class CRC32 {
        private static _crcTable;
        private static get crcTable();
        static calculate(data: number[], text1?: string, text2?: string): number;
    }
}
export namespace Stimulsoft.System.Crypt {
    class RSAKey {
        private n;
        private e;
        private d;
        private p;
        private q;
        private dmp1;
        private dmq1;
        private coeff;
        verifyString(message: string, signature: string): boolean;
        private base64toHex;
        private parseBigInt;
        private pkcs1pad2;
        private pkcs1unpad2;
        setPublic(N: string, E: string): void;
        setPrivate(N: string, E: string, D: string): void;
        setPrivateEx(N: string, E: string, D: string, P: string, Q: string, DP: string, DQ: string, C: string): void;
        generate(B: number, E: string): void;
        doPublic(x: BigInteger): BigInteger;
        private doPrivate;
        encrypt(text: string): string;
        decrypt(ctext: string): string;
        constructor();
    }
}
export namespace Stimulsoft.System.Crypt {
    class SHA1 {
        private blockLength;
        private state;
        private K;
        static signature: string;
        static hex(data: string): string;
        hex(data: string): string;
        private getMD;
        private rotl;
        private round;
        private paddingData;
        private toHex;
        private fromBigEndian32;
        private toBigEndian32;
        private unpack;
        private pack;
    }
}
export namespace Stimulsoft.System.Crypt {
    class SHA2 {
        private static HASH_224;
        private static HASH_256;
        private static HASH_384;
        private static HASH_512;
        private static HASH_512_224;
        private static HASH_512_256;
        private static ROUNDS_256;
        private static ROUNDS_512;
        private static HEX_DIGITS;
        private rotate;
        private sigma;
        private sum;
        private aggregate;
        private conglomerate;
        private compress;
        private hash;
        SHA2_224(sData: string): string;
        SHA2_256(sData: string | number[]): string | number[];
        SHA2_384(sData: string | number[]): string | number[];
        SHA2_512(sData: string | number[]): string | number[];
        SHA2_512_224(sData: string): string;
        SHA2_512_256(sData: string): string;
        static SHA256(sData: number[]): number[];
    }
}
export namespace Stimulsoft.System.Crypt {
    class SecureRandom {
        private state;
        private pool;
        private position;
        private seedInteger;
        private seedTime;
        private getByte;
        nextBytes(ba: number[], count?: number): void;
        createNextBytes(count: number): number[];
        constructor();
    }
}
export namespace Stimulsoft.ExternalLibrary.aesjs.ModeOfOperation {
    class cbc {
        encrypt(data: number[]): Uint8Array | number[];
        decrypt(data: number[]): Uint8Array | number[];
        constructor(key: number[], iv: number[]);
    }
    class ecb {
        encrypt(data: number[]): Uint8Array | number[];
        decrypt(data: number[]): Uint8Array | number[];
        constructor(key: number[]);
    }
}
export namespace Stimulsoft.ExternalLibrary.aesjs.padding.pkcs7 {
    class pad extends Array {
        constructor(forEncrypt: number[]);
    }
}
export namespace Stimulsoft.System.Data {
    class DataStorage {
        values: any[];
        private _column;
        static createStorage(column: DataColumn, type: Type): DataStorage;
        getValue(recordNo: number): any;
        setValue(recordNo: number, value: any): void;
        setStorage(): void;
        constructor(column: DataColumn);
    }
}
export namespace Stimulsoft.System.Data {
    class BooleanStorage extends DataStorage {
        setValue(recordNo: number, value: any): void;
    }
}
export namespace Stimulsoft.System.Data {
    class ByteArrayStorage extends DataStorage {
    }
}
export namespace Stimulsoft.System.Data {
    class CharStorage extends DataStorage {
        setValue(recordNo: number, value: any): void;
    }
}
export namespace Stimulsoft.System.Data {
    class DBNull {
        static value: DBNull;
    }
}
export namespace Stimulsoft.System.Data {
    class DataColumn {
        clone(): DataColumn;
        private _caption;
        get caption(): string;
        set caption(value: string);
        storage: DataStorage;
        columnName: string;
        dataType: Type;
        table: DataTable;
        getRecord(record: number): any;
        setRecord(record: number, value: any): void;
        setTable(table: DataTable): void;
        delete(): void;
        private insureStorage;
        changeType(dataType: Type): void;
        constructor(columnName: string, dataType?: Type, caption?: string);
    }
}
export namespace Stimulsoft.System.Data {
    import CollectionBase = Stimulsoft.System.Collections.CollectionBase;
    class DataColumnCollection extends CollectionBase<DataColumn> {
        table: DataTable;
        private baseAdd;
        private baseRemove;
        add(column: DataColumn): void;
        contains(columnName: string): boolean;
        remove(column: DataColumn): void;
        removeByName(name: string): void;
        hashNames: Map<string, DataColumn>;
        getByName(name: string): DataColumn;
        getIndexByName(name: string): number;
        constructor(table: DataTable);
    }
}
export namespace Stimulsoft.System.Data {
    class DataKey {
        columns: DataColumn[];
        get table(): DataTable;
        get columnsReference(): any[];
        getKeyValues(record: number): any[];
        getRows(values: any[], valueColumns: DataColumn[]): any[];
        toArray(): any[];
        constructor(columns: DataColumn[], copyColumns: boolean);
    }
}
export namespace Stimulsoft.System.Data {
    class DataRelation {
        childKey: DataKey;
        parentKey: DataKey;
        dataSet: DataSet;
        relationName: string;
        get parentTable(): DataTable;
        get childTable(): DataTable;
        get parentColumns(): any[];
        get childColumns(): any[];
        private create;
        setDataSet(dataSet: DataSet): void;
        static getChildRows(parentKey: DataKey, childKey: DataKey, parentRow: DataRow): any[];
        static getParentRows(parentKey: DataKey, childKey: DataKey, childRow: DataRow): any[];
        constructor(relationName: string, parentColumns: DataColumn[], childColumns: DataColumn[]);
    }
}
export namespace Stimulsoft.System.Data {
    import CollectionBase = Stimulsoft.System.Collections.CollectionBase;
    class DataRelationCollection extends CollectionBase<DataRelation> {
        addCore(relation: DataRelation): void;
        add(relation: DataRelation): void;
        addRange(relations: any[]): void;
        internalIndexOf(name: string): number;
        contains(name: string): boolean;
        getByName(name: string): DataRelation;
        getDataSet(): DataSet;
    }
}
export namespace Stimulsoft.System.Data {
    import List = Stimulsoft.System.Collections.List;
    class DataRow {
        _recordIndex: number;
        get recordIndex(): number;
        static create(table: DataTable): DataRow;
        columns: DataColumnCollection;
        table: DataTable;
        private getColumnIndex;
        gett(column: any): any;
        sett(column: any, value: any): void;
        get itemArray(): any[];
        getValue(column: any): any;
        setValue(column: any, value: any): void;
        getValueByIndex(columnIndex: number): any;
        setValueByIndex(columnIndex: number, value: any): void;
        getDataColumn(columnName: string): DataColumn;
        getChildRows(relationName: string): any[];
        getParentRow(relationName: string): DataRow;
        getParentRows(relationName: string): any[];
        getKeyValues(key: DataKey): any[];
        static copyToDataTable(source: List<DataRow>): DataTable;
    }
}
export namespace Stimulsoft.System.Data {
    import CollectionBase = Stimulsoft.System.Collections.CollectionBase;
    class DataRowCollection extends CollectionBase<DataRow> {
        table: DataTable;
        add(row: DataRow): number;
        remove(row: DataRow): void;
        addArray(row: DataRow): number;
        removeArray(row: DataRow): void;
        copyTo(array: any[], startIndex: number): void;
        private replaceValues;
        private quickSort;
        sort(...parameters: any[]): any;
        gett(rowIndex: number, columnIndex: number): any;
        constructor(table: DataTable);
    }
}
export namespace Stimulsoft.System.Text {
    class XMLConvert {
        static encodeName(name: string): string;
        static decodeName(name: string): string;
        private static fromHex;
        private static toHex;
    }
}
export namespace Stimulsoft.System.Xml {
    import List = Stimulsoft.System.Collections.List;
    class XmlNode {
        nodeName: string;
        nodeType: XmlNodeType;
        childNodes: List<XmlNode>;
        localName: string;
        textContent: string;
        get firstChild(): XmlNode;
        attributes: XmlAttrCollection;
        parentNode: XmlNode;
        setParentNode(node: XmlNode): void;
        getAttribute(name?: string): string;
        item(index: number): XmlNode;
        getNodeByName(name?: string): XmlNode;
        getNodesByName(name?: string): XmlNode[];
    }
}
export namespace Stimulsoft.System.Xml {
    class XmlAttr {
        name: string;
        value: string;
    }
}
export namespace Stimulsoft.System.Xml {
    enum XmlNodeType {
        ATTRIBUTE_NODE = 0,
        ELEMENT_NODE = 1,
        TEXT_NODE = 2,
        DOCUMENT_NODE = 3
    }
}
export namespace Stimulsoft.System.Xml {
    class XmlConverter {
        static toXml(xmlString: string, decodeTagNames?: boolean): XmlNode;
        static toXml2(xmlString: string, decodeTagNames?: boolean): XmlNode;
        private static toXmlNode2;
        private static toXmlNode;
        static getXmlDocumentFromString(xmlString: string): any;
        static getAttributesArray(xmlDocument: any): any[];
        static getNodeType2(xmlDocument: any): number;
        static getNodeType(xmlDocument: any): number;
        static getNodeName(xmlDocument: any): string;
        static getNodeLocalName2(xmlDocument: {
            name: string;
        }): string;
        static getNodeLocalName(xmlDocument: any): string;
        static getText(str: string): string;
        static getChildNodesArray(xmlDocument: any): any[];
    }
}
export namespace Stimulsoft.System.Data {
    enum JsonRelationDirection {
        ChildToParent = 0,
        ParentToChild = 1
    }
    class DataSet {
        private dataNode;
        private schemaNode;
        private isRetrieveColumns;
        private structureFromSchema;
        dataSetName: string;
        tables: DataTableCollection;
        relations: DataRelationCollection;
        enforceConstraints: boolean;
        private complexTypeNodes;
        private _tryParseDateTime;
        get tryParseDateTime(): boolean;
        set tryParseDateTime(value: boolean);
        static tryParseDateTime: boolean;
        dispose(): void;
        private correctJsonString;
        private correctJson;
        readJsonFile(filePath: string, jsonRelationDirection?: JsonRelationDirection): void;
        readJson(param: string | number[] | Uint8Array | any, jsonRelationDirection?: JsonRelationDirection): void;
        private fillCollection;
        private processObject2;
        private processObject;
        private processTable;
        private processArray;
        readXmlAsJson(param: string | number[] | Uint8Array | any, relationDirection: JsonRelationDirection): void;
        private static convertXmlToJsObject;
        readXmlFile(filePath: string): void;
        readXml(param: string | number[] | Uint8Array | any): void;
        readXmlSchemaFile(filePath: string): void;
        readXmlSchema(param: string | number[] | any): void;
        private fillDataSet;
        private parseSchema;
        private parseAdoNetSchema;
        private extractKey;
        private extractReference;
        private extractRelationsFromAdoNetRelationships;
        private parseUnknownSchema;
        private extractTableFromElementNode;
        private extractColumnsFromComplexTypeNode;
        private extractColumnFromElementNode;
        private inferSchemaFromData;
        private inferTableFromNode;
        private inferColumnsFromNode;
        private inferColumnFromNode;
        private fillTable;
        private fillRow;
        private addNodeValueToRowIntoColumn;
        private linkTables;
        private getStorageTypeOrDefault;
        private findTable;
        private findColumns;
        writeXml(writeSchema?: boolean): string;
        private writeXsd;
        private getTypeFromStorageType;
        constructor(dataSetName?: string);
    }
}
export namespace Stimulsoft.System.Data {
    class DataSetRelationCollection extends DataRelationCollection {
        private dataSet;
        addCore(relation: DataRelation): void;
        getDataSet(): DataSet;
        constructor(dataSet: DataSet);
    }
}
export namespace Stimulsoft.System.Data {
    import List = Stimulsoft.System.Collections.List;
    class DataTable {
        private needCleanCache;
        private _index;
        get index(): any[];
        columns: DataColumnCollection;
        rows: DataRowCollection;
        tableName: string;
        dataSet: DataSet;
        defaultView: DataView;
        private _childRelations;
        get childRelations(): DataRelationCollection;
        set childRelations(value: DataRelationCollection);
        private _parentRelations;
        get parentRelations(): DataRelationCollection;
        set parentRelations(value: DataRelationCollection);
        setDataSet(dataSet: DataSet): void;
        addRow(row: DataRow): number;
        removeRow(row: DataRow): void;
        addNewRow(): DataRow;
        extendedProperties: any;
        newRow(): DataRow;
        clone(): DataTable;
        copy(): DataTable;
        toList(): List<DataColumn>;
        loadDataRow(values: any[], acceptChanges?: boolean): DataRow;
        constructor(tableName?: string);
    }
}
export namespace Stimulsoft.System.Data {
    import CollectionBase = Stimulsoft.System.Collections.CollectionBase;
    class DataTableCollection extends CollectionBase<DataTable> {
        add(table: DataTable): void;
        remove(table: DataTable): void;
        private baseAdd;
        private baseRemove;
        dataSet: DataSet;
        getByName(name: string): DataTable;
        private checkTableName;
        constructor(dataSet: DataSet);
    }
}
export namespace Stimulsoft.System.Data {
    class DataTableRelationCollection extends DataRelationCollection {
        private table;
        private parentCollection;
        private addCache;
        addCore(relation: DataRelation): void;
        getDataSet(): DataSet;
        constructor(table: DataTable, parentCollection: boolean);
    }
}
export namespace Stimulsoft.System.Data {
    class DataView {
        clone(): DataView;
        rowFilter: string;
        sort: string;
        table: DataTable;
        private ands;
        toTable(throw1?: boolean): DataTable;
        private filter;
        private parseConditions;
        private parse;
        constructor(table: DataTable);
    }
}
export namespace Stimulsoft.System.Data {
    class DateTimeStorage extends DataStorage {
        setValue(recordNo: number, value: any): void;
    }
}
export namespace Stimulsoft.System.Data {
    enum DbType {
        AnsiString = 0,
        Binary = 1,
        Byte = 2,
        Boolean = 3,
        Currency = 4,
        Date = 5,
        DateTime = 6,
        Decimal = 7,
        Double = 8,
        Guid = 9,
        Int16 = 10,
        Int32 = 11,
        Int64 = 12,
        Object = 13,
        SByte = 14,
        Single = 15,
        String = 16,
        Time = 17,
        UInt16 = 18,
        UInt32 = 19,
        UInt64 = 20,
        VarNumeric = 21,
        AnsiStringFixedLength = 22,
        StringFixedLength = 23,
        Xml = 25,
        DateTime2 = 26,
        DateTimeOffset = 27
    }
}
export namespace Stimulsoft.System.Data {
    class NumberStorage extends DataStorage {
        setValue(recordNo: number, value: any): void;
    }
}
export namespace Stimulsoft.System.Data {
    class ObjectStorage extends DataStorage {
    }
}
export namespace Stimulsoft.System.Data {
    enum StorageType {
        ObjectType = 1,
        BooleanType = 3,
        CharType = 4,
        SByteType = 5,
        ByteType = 6,
        Number16Type = 7,
        Unumber16Type = 8,
        NumberType = 9,
        Number32Type = 9,
        Unumber32Type = 10,
        Number64Type = 11,
        Unumber64Type = 12,
        SingleType = 13,
        DoubleType = 14,
        DecimalType = 15,
        DateTimeType = 16,
        TimeSpanType = 17,
        StringType = 18,
        GuidType = 19,
        ByteArrayType = 20,
        IntType = 30,
        Int16Type = 31,
        Int32Type = 32,
        Int64Type = 33,
        UInt16Type = 34,
        UInt32Type = 35,
        UInt64Type = 36
    }
}
export namespace Stimulsoft.System.Data {
    class StringStorage extends DataStorage {
        setValue(recordNo: number, value: any): void;
    }
}
export namespace Stimulsoft.System.Data {
    class TimeSpanStorage extends DataStorage {
        setValue(recordNo: number, value: any): void;
    }
}
export namespace Stimulsoft.System.Drawing {
    import IAsIs = Stimulsoft.System.IAsIs;
    class Brush implements IAsIs {
        implements(): any[];
        is<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): this is T;
        is2<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): boolean;
        as<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): T;
    }
}
export namespace Stimulsoft.System.Drawing {
    class Brushes {
        static get aliceBlue(): Brush;
        static get antiqueWhite(): Brush;
        static get aqua(): Brush;
        static get aquamarine(): Brush;
        static get azure(): Brush;
        static get beige(): Brush;
        static get bisque(): Brush;
        static get black(): Brush;
        static get blanchedAlmond(): Brush;
        static get blue(): Brush;
        static get blueViolet(): Brush;
        static get brown(): Brush;
        static get burlyWood(): Brush;
        static get cadetBlue(): Brush;
        static get chartreuse(): Brush;
        static get chocolate(): Brush;
        static get coral(): Brush;
        static get cornflowerBlue(): Brush;
        static get cornsilk(): Brush;
        static get crimson(): Brush;
        static get cyan(): Brush;
        static get darkBlue(): Brush;
        static get darkCyan(): Brush;
        static get darkGoldenrod(): Brush;
        static get darkGray(): Brush;
        static get darkGreen(): Brush;
        static get darkKhaki(): Brush;
        static get darkMagenta(): Brush;
        static get darkOliveGreen(): Brush;
        static get darkOrange(): Brush;
        static get darkOrchid(): Brush;
        static get darkRed(): Brush;
        static get darkSalmon(): Brush;
        static get darkSeaGreen(): Brush;
        static get darkSlateBlue(): Brush;
        static get darkSlateGray(): Brush;
        static get darkTurquoise(): Brush;
        static get darkViolet(): Brush;
        static get deepPink(): Brush;
        static get deepSkyBlue(): Brush;
        static get dimGray(): Brush;
        static get dodgerBlue(): Brush;
        static get firebrick(): Brush;
        static get floralWhite(): Brush;
        static get forestGreen(): Brush;
        static get fuchsia(): Brush;
        static get gainsboro(): Brush;
        static get ghostWhite(): Brush;
        static get gold(): Brush;
        static get goldenrod(): Brush;
        static get gray(): Brush;
        static get green(): Brush;
        static get greenYellow(): Brush;
        static get honeydew(): Brush;
        static get hotPink(): Brush;
        static get indianRed(): Brush;
        static get indigo(): Brush;
        static get ivory(): Brush;
        static get khaki(): Brush;
        static get lavender(): Brush;
        static get lavenderBlush(): Brush;
        static get lawnGreen(): Brush;
        static get lemonChiffon(): Brush;
        static get lightBlue(): Brush;
        static get lightCoral(): Brush;
        static get lightCyan(): Brush;
        static get lightGoldenrodYellow(): Brush;
        static get lightGray(): Brush;
        static get lightGreen(): Brush;
        static get lightPink(): Brush;
        static get lightSalmon(): Brush;
        static get lightSeaGreen(): Brush;
        static get lightSkyBlue(): Brush;
        static get lightSlateGray(): Brush;
        static get lightSteelBlue(): Brush;
        static get lightYellow(): Brush;
        static get lime(): Brush;
        static get limeGreen(): Brush;
        static get linen(): Brush;
        static get magenta(): Brush;
        static get maroon(): Brush;
        static get mediumAquamarine(): Brush;
        static get mediumBlue(): Brush;
        static get mediumOrchid(): Brush;
        static get mediumPurple(): Brush;
        static get mediumSeaGreen(): Brush;
        static get mediumSlateBlue(): Brush;
        static get mediumSpringGreen(): Brush;
        static get mediumTurquoise(): Brush;
        static get mediumVioletRed(): Brush;
        static get midnightBlue(): Brush;
        static get mintCream(): Brush;
        static get mistyRose(): Brush;
        static get moccasin(): Brush;
        static get navajoWhite(): Brush;
        static get navy(): Brush;
        static get oldLace(): Brush;
        static get olive(): Brush;
        static get oliveDrab(): Brush;
        static get orange(): Brush;
        static get orangeRed(): Brush;
        static get orchid(): Brush;
        static get paleGoldenrod(): Brush;
        static get paleGreen(): Brush;
        static get paleTurquoise(): Brush;
        static get paleVioletRed(): Brush;
        static get papayaWhip(): Brush;
        static get peachPuff(): Brush;
        static get peru(): Brush;
        static get pink(): Brush;
        static get plum(): Brush;
        static get powderBlue(): Brush;
        static get purple(): Brush;
        static get red(): Brush;
        static get rosyBrown(): Brush;
        static get royalBlue(): Brush;
        static get saddleBrown(): Brush;
        static get salmon(): Brush;
        static get sandyBrown(): Brush;
        static get seaGreen(): Brush;
        static get seaShell(): Brush;
        static get sienna(): Brush;
        static get silver(): Brush;
        static get skyBlue(): Brush;
        static get slateBlue(): Brush;
        static get slateGray(): Brush;
        static get snow(): Brush;
        static get springGreen(): Brush;
        static get steelBlue(): Brush;
        static get tan(): Brush;
        static get teal(): Brush;
        static get thistle(): Brush;
        static get tomato(): Brush;
        static get turquoise(): Brush;
        static get violet(): Brush;
        static get wheat(): Brush;
        static get white(): Brush;
        static get whiteSmoke(): Brush;
        static get yellow(): Brush;
        static get yellowGreen(): Brush;
    }
}
export namespace Stimulsoft.System.Drawing {
    class Color {
        private static colorCache;
        static aliceBlue: Color;
        static antiqueWhite: Color;
        static aqua: Color;
        static aquamarine: Color;
        static azure: Color;
        static beige: Color;
        static bisque: Color;
        static black: Color;
        static blanchedAlmond: Color;
        static blue: Color;
        static blueViolet: Color;
        static brown: Color;
        static burlyWood: Color;
        static cadetBlue: Color;
        static chartreuse: Color;
        static chocolate: Color;
        static coral: Color;
        static cornflowerBlue: Color;
        static cornsilk: Color;
        static crimson: Color;
        static cyan: Color;
        static darkBlue: Color;
        static darkCyan: Color;
        static darkGoldenrod: Color;
        static darkGray: Color;
        static darkGreen: Color;
        static darkKhaki: Color;
        static darkMagenta: Color;
        static darkOliveGreen: Color;
        static darkOrange: Color;
        static darkOrchid: Color;
        static darkRed: Color;
        static darkSalmon: Color;
        static darkSeaGreen: Color;
        static darkSlateBlue: Color;
        static darkSlateGray: Color;
        static darkTurquoise: Color;
        static darkViolet: Color;
        static deepPink: Color;
        static deepSkyBlue: Color;
        static dimGray: Color;
        static dodgerBlue: Color;
        static firebrick: Color;
        static floralWhite: Color;
        static forestGreen: Color;
        static fuchsia: Color;
        static gainsboro: Color;
        static ghostWhite: Color;
        static gold: Color;
        static goldenrod: Color;
        static gray: Color;
        static green: Color;
        static greenYellow: Color;
        static honeydew: Color;
        static hotPink: Color;
        static indianRed: Color;
        static indigo: Color;
        static ivory: Color;
        static khaki: Color;
        static lavender: Color;
        static lavenderBlush: Color;
        static lawnGreen: Color;
        static lemonChiffon: Color;
        static lightBlue: Color;
        static lightCoral: Color;
        static lightCyan: Color;
        static lightGoldenrodYellow: Color;
        static lightGray: Color;
        static lightGreen: Color;
        static lightPink: Color;
        static lightSalmon: Color;
        static lightSeaGreen: Color;
        static lightSkyBlue: Color;
        static lightSlateGray: Color;
        static lightSteelBlue: Color;
        static lightYellow: Color;
        static lime: Color;
        static limeGreen: Color;
        static linen: Color;
        static magenta: Color;
        static maroon: Color;
        static mediumAquamarine: Color;
        static mediumBlue: Color;
        static mediumOrchid: Color;
        static mediumPurple: Color;
        static mediumSeaGreen: Color;
        static mediumSlateBlue: Color;
        static mediumSpringGreen: Color;
        static mediumTurquoise: Color;
        static mediumVioletRed: Color;
        static midnightBlue: Color;
        static mintCream: Color;
        static mistyRose: Color;
        static moccasin: Color;
        static navajoWhite: Color;
        static navy: Color;
        static oldLace: Color;
        static olive: Color;
        static oliveDrab: Color;
        static orange: Color;
        static orangeRed: Color;
        static orchid: Color;
        static paleGoldenrod: Color;
        static paleGreen: Color;
        static paleTurquoise: Color;
        static paleVioletRed: Color;
        static papayaWhip: Color;
        static peachPuff: Color;
        static peru: Color;
        static pink: Color;
        static plum: Color;
        static powderBlue: Color;
        static purple: Color;
        static red: Color;
        static rosyBrown: Color;
        static royalBlue: Color;
        static saddleBrown: Color;
        static salmon: Color;
        static sandyBrown: Color;
        static seaGreen: Color;
        static seaShell: Color;
        static sienna: Color;
        static silver: Color;
        static skyBlue: Color;
        static slateBlue: Color;
        static slateGray: Color;
        static snow: Color;
        static springGreen: Color;
        static steelBlue: Color;
        static tan: Color;
        static teal: Color;
        static thistle: Color;
        static tomato: Color;
        static turquoise: Color;
        static violet: Color;
        static wheat: Color;
        static white: Color;
        static whiteSmoke: Color;
        static yellow: Color;
        static yellowGreen: Color;
        static transparent: Color;
        static empty: Color;
        static fromName(name: string): Color;
        readonly a: number;
        readonly r: number;
        readonly g: number;
        readonly b: number;
        readonly name: string;
        private constructor();
        private static customName;
        get isNamedColor(): boolean;
        equals(color: Color): boolean;
        toString(): string;
        static fromArgb(alpha: number, red: number, green: number, blue: number): Color;
        static fromArgb2(red: number, green: number, blue: number): Color;
        static fromArgb3(alpha: number, color: Color): Color;
        changeAlpha(alpha: number): Color;
        toArgb(): number;
        getHashCode(): number;
        is(type: any): this is Color;
        is2(type: any): boolean;
        as(type: any): this;
        getType(): typeof Color;
        over(other: Color): Color;
    }
    interface Color {
        ss: Color;
        stimulsoft: () => Color;
    }
}
export namespace Stimulsoft.System.Drawing {
    class ColorTranslator {
        private static colorCache;
        static toHtml(color: Color): string;
        static toHtml2(color: Color, useNamedColor: boolean): string;
        static fromHtml(text: string): Color;
    }
}
export namespace Stimulsoft.System.Drawing {
    enum ContentAlignment {
        TopLeft = 1,
        TopCenter = 2,
        TopRight = 4,
        MiddleLeft = 16,
        MiddleCenter = 32,
        MiddleRight = 64,
        BottomLeft = 256,
        BottomCenter = 512,
        BottomRight = 1024
    }
}
export namespace Stimulsoft.System.Drawing {
    class Font implements ICloneable {
        clone(cloneProperties?: boolean, cloneComponents?: boolean): any;
        fontFamily: FontFamily;
        get name(): string;
        size: number;
        get sizeInPoints(): number;
        style: FontStyle;
        unit: GraphicsUnit;
        get bold(): boolean;
        get italic(): boolean;
        get strikeout(): boolean;
        get underline(): boolean;
        private _toString;
        toString(): string;
        private _height;
        getHeight(): number;
        private hashCode;
        getHashCode(): number;
        constructor(family?: string, emSize?: number, style?: FontStyle, unit?: GraphicsUnit);
    }
}
export namespace Stimulsoft.System.Drawing {
    class FontFamily {
        private static _families;
        static get families(): FontFamily[];
        name: string;
        isStyleAvailable(style: FontStyle): boolean;
        static cleanFamilies(): void;
        constructor(name: string);
    }
}
export namespace Stimulsoft.System.Drawing {
    class FontResources {
        static getSize(font: Font, text: string): Size;
        private static _standardFontWidths;
        static get standardFontWidths(): any[];
        private static _standardFontInfo;
        static get standardFontInfo(): any[];
        private static family_Helvetica;
        private static family_Courier;
        private static family_Times_Roman;
        private static fontName;
    }
}
export namespace Stimulsoft.System.Drawing {
    enum FontStyle {
        Regular = 0,
        Bold = 1,
        Italic = 2,
        Strikeout = 4,
        Underline = 8
    }
}
export namespace Stimulsoft.System.Drawing.Drawing2D {
    import Point = Stimulsoft.System.Drawing.Point;
    class Matrix {
        private a;
        private c;
        private b;
        private d;
        private tx;
        private ty;
        get elements(): number[];
        constructor(...arg: any[]);
        private setValues;
        private reset;
        clone(): Matrix;
        toString(): string;
        translate(x: number, y: number): Matrix;
        scale(scaleX: number, scaleY: number): Matrix;
        rotate(angle: number): Matrix;
        isIdentity(): boolean;
        transformPoints(points: Point[]): void;
        multiply(matrix2: Matrix): this;
        multiplyAppend(mx: Matrix): this;
        multiplyPrepend(mx: Matrix): this;
    }
}
export namespace Stimulsoft.System.Drawing {
    import Hashtable = Stimulsoft.System.Collections.Hashtable;
    type CustomFontType = {
        font: any;
        data: any;
        filePath: string;
        autoLoad?: boolean;
        used?: boolean;
    };
    export class Graphics {
        private context;
        static measureBearingScale: number;
        drawImage(image: Image, point: Point): void;
        drawRectangle(pen: Pen, rect: Rectangle): void;
        fillRectangle(brush: Brush, x: number, y: number, width: number, height: number): void;
        drawLine(pen: Pen, x1: number, y1: number, x2: number, y2: number): void;
        drawString(text: string, font: Font, brush: Brush, x: number, y: number): void;
        translateTransform(dx: number, dy: number): void;
        static customFonts: Hashtable<string, Hashtable<FontStyle, CustomFontType>>;
        static getCustomFont(fontName: string, fontStyle: FontStyle): any;
        static clearAutoLoadFonts(): void;
        static addCustomFont(font: any, fontName?: string, binFont?: any, filePath?: string, fontStyle?: FontStyle, store?: boolean): void;
        static addCustomFontFile(filePath: string, fontName?: string, fontStyle?: FontStyle, store?: boolean): void;
        static addCustomFontFileAsync(callback: () => {}, filePath: string, fontName?: string, fontStyle?: FontStyle, store?: boolean): void;
        static addCustomFontBytes(data: any, fontName?: string, fontStyle?: FontStyle, store?: boolean): void;
        private static getFontMimeType;
        static getCustomFontsCss(base64Data?: boolean): string;
        static getCustomFontName(fontName: string, fontStyle: FontStyle): string;
        static allowStyle(fontName: string, fontStyle: FontStyle): boolean;
        private static measureDiv;
        private static measureHash;
        static measureString(text: string, font: Font, width?: number, useCache?: boolean, multiple?: number, angle?: number, replaceTags?: boolean): Size;
        private static isWordWrapSymbol;
        static measureChars(chars: number[], count: number, font: Font): Size;
        private static rotate;
        static clearCache(): void;
        constructor(context: CanvasRenderingContext2D);
    }
    export {};
}
export namespace Stimulsoft.System.Drawing {
    enum GraphicsUnit {
        Pixel = 2,
        Point = 3
    }
}
export namespace Stimulsoft.System.Drawing.Imaging {
    type ImageInfo = {
        width: number;
        height: number;
        horizontalResolution: number;
        verticalResolution: number;
    };
    export class ImageFormat {
        private static _tiff;
        static get Tiff(): ImageFormat;
        private static _png;
        static get Png(): ImageFormat;
        private static _gif;
        static get Gif(): ImageFormat;
        private static _jpeg;
        static get Jpeg(): ImageFormat;
        private static getBytes;
        private static getJpegInfo;
        private static _bmp;
        static get Bmp(): ImageFormat;
        private static _svg;
        static get Svg(): ImageFormat;
        static getImageFormat(dataBytes: number[]): ImageFormat;
        private header;
        private guid;
        private checkHeader;
        getInfo(data: {
            bytes: number[];
            base64: string;
            svg: string;
        }): ImageInfo;
        get mimeType(): string;
        toString(): string;
        constructor(guid: string);
    }
    export {};
}
export namespace Stimulsoft.System.Drawing {
    import Hashtable = Stimulsoft.System.Collections.Hashtable;
    import ImageFormat = Stimulsoft.System.Drawing.Imaging.ImageFormat;
    class Image {
        data: any;
        imageFormat: ImageFormat;
        imageData: any;
        private _width;
        get width(): number;
        private _height;
        get height(): number;
        private _horizontalResolution;
        get horizontalResolution(): number;
        private _verticalResolution;
        get verticalResolution(): number;
        private fillImageInfo;
        get base64(): string;
        set base64(value: string);
        get bytes(): number[];
        set bytes(value: number[]);
        get svg(): string;
        set svg(value: string);
        static fromFile(path: string): Image;
        static fromBytes(bytes: number[]): Image;
        static fromBase64(base64: string): Image;
        private setData;
        convertAsync(imageFormat: ImageFormat, flate?: boolean, rect?: Rectangle, reconvert?: boolean, hashTable?: Hashtable): Promise<Image>;
        tryConvertSync(imageFormat: ImageFormat): boolean;
        private getHash;
        dispose(): void;
        clone(): Image;
        aspectRatio: boolean;
        multipleFactor: number;
        margins: {
            left: number;
            right: number;
            top: number;
            bottom: number;
            isEmpty: boolean;
        };
        horAlignment: number;
        vertAlignment: number;
        imageRotation: number;
        stretch: boolean;
        zoom: number;
        url: string;
    }
}
export namespace Stimulsoft.System.Drawing {
    enum Orientation {
        Horizontal = 0,
        Vertical = 1
    }
}
export namespace Stimulsoft.System.Drawing {
    import LineCap = Stimulsoft.System.Drawing.Drawing2D.LineCap;
    import DashStyle = Stimulsoft.System.Drawing.Drawing2D.DashStyle;
    class Pen {
        brush: Brush;
        color: Color;
        endCap: LineCap;
        startCap: LineCap;
        width: number;
        dashStyle: DashStyle;
        lineJoin: string;
        constructor(color: Color, width?: number);
    }
}
export namespace Stimulsoft.System.Drawing {
    class Point {
        x: number;
        y: number;
        get isEmpty(): boolean;
        static get empty(): Point;
        toString(): string;
        equals(point: Point): boolean;
        static convertFromXml(text: string): Point;
        constructor(x?: number, y?: number);
    }
}
export namespace Stimulsoft.System.Drawing {
    class Rectangle {
        static fromLTRB(left: number, top: number, right: number, bottom: number): Rectangle;
        static get empty(): Rectangle;
        static union(a: Rectangle, b: Rectangle): Rectangle;
        static convertFromXml(text: string): Rectangle;
        clone(): Rectangle;
        inflate(width: number, height: number): Rectangle;
        normalize(): Rectangle;
        multiply(multipleFactor: number): Rectangle;
        offset(x: number, y: number): Rectangle;
        offsetRect(offsettingRectangle: Rectangle): Rectangle;
        intersectsWith(rect: Rectangle): boolean;
        alignToGrid(gridSize: number, aligningToGrid: boolean): Rectangle;
        fitToRectangle(rectangle: Rectangle): Rectangle;
        get isEmpty(): boolean;
        get isEmptyF(): boolean;
        contains(x: number, y: number): boolean;
        x: number;
        y: number;
        width: number;
        height: number;
        get left(): number;
        set left(value: number);
        get top(): number;
        set top(value: number);
        get right(): number;
        set right(value: number);
        get bottom(): number;
        set bottom(value: number);
        get location(): Point;
        set location(value: Point);
        get size(): Size;
        set size(value: Size);
        toString(): string;
        constructor(x?: number, y?: number, width?: number, height?: number);
    }
}
export namespace Stimulsoft.System.Drawing {
    class Size {
        static get empty(): Size;
        width: number;
        height: number;
        get isEmpty(): boolean;
        isDefault(): boolean;
        swap(): Size;
        round(digits?: number): Size;
        static convertFromXml(text: string): Size;
        constructor(width: number, height: number);
    }
}
export namespace Stimulsoft.System.Drawing {
    class SolidBrush extends Brush {
        color: Color;
        constructor(color: Color);
    }
}
export namespace Stimulsoft.System.Drawing {
    enum StringAlignment {
        Near = 0,
        Center = 1,
        Far = 2
    }
}
export namespace Stimulsoft.System.Drawing {
    import HotkeyPrefix = Stimulsoft.System.Drawing.Text.HotkeyPrefix;
    class StringFormat {
        alignment: StringAlignment;
        formatFlags: StringFormatFlags;
        hotkeyPrefix: HotkeyPrefix;
        lineAlignment: StringAlignment;
        trimming: StringTrimming;
    }
}
export namespace Stimulsoft.System.Drawing {
    enum StringFormatFlags {
        None = 0,
        DirectionRightToLeft = 1,
        DirectionVertical = 2,
        FitBlackBox = 4,
        DisplayFormatControl = 32,
        NoFontFallback = 1024,
        MeasureTrailingSpaces = 2048,
        NoWrap = 4096,
        LineLimit = 8192,
        NoClip = 16384
    }
}
export namespace Stimulsoft.System.Drawing {
    enum StringTrimming {
        None = 0,
        Character = 1,
        Word = 2,
        EllipsisCharacter = 3,
        EllipsisWord = 4,
        EllipsisPath = 5
    }
}
export namespace Stimulsoft.System.Drawing.Drawing2D {
    enum DashStyle {
        Solid = 0,
        Dash = 1,
        Dot = 2,
        DashDot = 3,
        DashDotDot = 4,
        Custom = 5
    }
}
export namespace Stimulsoft.System.Drawing.Drawing2D {
    enum HatchStyle {
        Min = 0,
        Horizontal = 0,
        Vertical = 1,
        ForwardDiagonal = 2,
        BackwardDiagonal = 3,
        Max = 4,
        Cross = 4,
        LargeGrid = 4,
        DiagonalCross = 5,
        Percent05 = 6,
        Percent10 = 7,
        Percent20 = 8,
        Percent25 = 9,
        Percent30 = 10,
        Percent40 = 11,
        Percent50 = 12,
        Percent60 = 13,
        Percent70 = 14,
        Percent75 = 15,
        Percent80 = 16,
        Percent90 = 17,
        LightDownwardDiagonal = 18,
        LightUpwardDiagonal = 19,
        DarkDownwardDiagonal = 20,
        DarkUpwardDiagonal = 21,
        WideDownwardDiagonal = 22,
        WideUpwardDiagonal = 23,
        LightVertical = 24,
        LightHorizontal = 25,
        NarrowVertical = 26,
        NarrowHorizontal = 27,
        DarkVertical = 28,
        DarkHorizontal = 29,
        DashedDownwardDiagonal = 30,
        DashedUpwardDiagonal = 31,
        DashedHorizontal = 32,
        DashedVertical = 33,
        SmallConfetti = 34,
        LargeConfetti = 35,
        ZigZag = 36,
        Wave = 37,
        DiagonalBrick = 38,
        HorizontalBrick = 39,
        Weave = 40,
        Plaid = 41,
        Divot = 42,
        DottedGrid = 43,
        DottedDiamond = 44,
        Shingle = 45,
        Trellis = 46,
        Sphere = 47,
        SmallGrid = 48,
        SmallCheckerBoard = 49,
        LargeCheckerBoard = 50,
        OutlinedDiamond = 51,
        SolidDiamond = 52
    }
}
export namespace Stimulsoft.System.Drawing.Drawing2D {
    enum LineCap {
        AnchorMask = 240,
        ArrowAnchor = 20,
        Custom = 255,
        DiamondAnchor = 19,
        Flat = 0,
        NoAnchor = 16,
        Round = 2,
        RoundAnchor = 18,
        Square = 1,
        SquareAnchor = 17,
        Triangle = 3
    }
}
export namespace Stimulsoft.System.Drawing.Imaging {
    enum EncoderValue {
        ColorTypeCMYK = 0,
        ColorTypeYCCK = 1,
        CompressionLZW = 2,
        CompressionCCITT3 = 3,
        CompressionCCITT4 = 4,
        CompressionRle = 5,
        CompressionNone = 6,
        ScanMethodInterlaced = 7,
        ScanMethodNonInterlaced = 8,
        VersionGif87 = 9,
        VersionGif89 = 10,
        RenderProgressive = 11,
        RenderNonProgressive = 12,
        TransformRotate90 = 13,
        TransformRotate180 = 14,
        TransformRotate270 = 15,
        TransformFlipHorizontal = 16,
        TransformFlipVertical = 17,
        MultiFrame = 18,
        LastFrame = 19,
        Flush = 20,
        FrameDimensionTime = 21,
        FrameDimensionResolution = 22,
        FrameDimensionPage = 23
    }
}
export namespace Stimulsoft.System.Drawing.Imaging {
    class ImageCodecInfo {
        clsid: Guid;
        codecName: string;
        filenameExtension: string;
        formatDescription: string;
        formatID: Guid;
        mimeType: string;
        version: number;
        static getImageDecoders(): ImageCodecInfo[];
        static getImageEncoders(): ImageCodecInfo[];
    }
}
export namespace Stimulsoft.System.Drawing.Printing {
    enum PaperKind {
        A2 = 66,
        A3 = 8,
        A3Extra = 63,
        A3ExtraTransverse = 68,
        A3Rotated = 76,
        A3Transverse = 67,
        A4 = 9,
        A4Extra = 53,
        A4Plus = 60,
        A4Rotated = 77,
        A4Small = 10,
        A4Transverse = 55,
        A5 = 11,
        A5Extra = 64,
        A5Rotated = 78,
        A5Transverse = 61,
        A6 = 70,
        A6Rotated = 83,
        APlus = 57,
        B4 = 12,
        B4Envelope = 33,
        B4JisRotated = 79,
        B5 = 13,
        B5Envelope = 34,
        B5Extra = 65,
        B5JisRotated = 80,
        B5Transverse = 62,
        B6Envelope = 35,
        B6Jis = 88,
        B6JisRotated = 89,
        BPlus = 58,
        C3Envelope = 29,
        C4Envelope = 30,
        C5Envelope = 28,
        C65Envelope = 32,
        C6Envelope = 31,
        CSheet = 24,
        Custom = 0,
        DLEnvelope = 27,
        DSheet = 25,
        ESheet = 26,
        Executive = 7,
        Folio = 14,
        GermanLegalFanfold = 41,
        GermanStandardFanfold = 40,
        InviteEnvelope = 47,
        IsoB4 = 42,
        ItalyEnvelope = 36,
        JapaneseDoublePostcard = 69,
        JapaneseDoublePostcardRotated = 82,
        JapaneseEnvelopeChouNumber3 = 73,
        JapaneseEnvelopeChouNumber3Rotated = 86,
        JapaneseEnvelopeChouNumber4 = 74,
        JapaneseEnvelopeChouNumber4Rotated = 87,
        JapaneseEnvelopeKakuNumber2 = 71,
        JapaneseEnvelopeKakuNumber2Rotated = 84,
        JapaneseEnvelopeKakuNumber3 = 72,
        JapaneseEnvelopeKakuNumber3Rotated = 85,
        JapaneseEnvelopeYouNumber4 = 91,
        JapaneseEnvelopeYouNumber4Rotated = 92,
        JapanesePostcard = 43,
        JapanesePostcardRotated = 81,
        Ledger = 4,
        Legal = 5,
        LegalExtra = 51,
        Letter = 1,
        LetterExtra = 50,
        LetterExtraTransverse = 56,
        LetterPlus = 59,
        LetterRotated = 75,
        LetterSmall = 2,
        LetterTransverse = 54,
        MonarchEnvelope = 37,
        Note = 18,
        Number10Envelope = 20,
        Number11Envelope = 21,
        Number12Envelope = 22,
        Number14Envelope = 23,
        Number9Envelope = 19,
        PersonalEnvelope = 38,
        Prc16K = 93,
        Prc16KRotated = 106,
        Prc32K = 94,
        Prc32KBig = 95,
        Prc32KBigRotated = 108,
        Prc32KRotated = 107,
        PrcEnvelopeNumber1 = 96,
        PrcEnvelopeNumber10 = 105,
        PrcEnvelopeNumber10Rotated = 118,
        PrcEnvelopeNumber1Rotated = 109,
        PrcEnvelopeNumber2 = 97,
        PrcEnvelopeNumber2Rotated = 110,
        PrcEnvelopeNumber3 = 98,
        PrcEnvelopeNumber3Rotated = 111,
        PrcEnvelopeNumber4 = 99,
        PrcEnvelopeNumber4Rotated = 112,
        PrcEnvelopeNumber5 = 100,
        PrcEnvelopeNumber5Rotated = 113,
        PrcEnvelopeNumber6 = 101,
        PrcEnvelopeNumber6Rotated = 114,
        PrcEnvelopeNumber7 = 102,
        PrcEnvelopeNumber7Rotated = 115,
        PrcEnvelopeNumber8 = 103,
        PrcEnvelopeNumber8Rotated = 116,
        PrcEnvelopeNumber9 = 104,
        PrcEnvelopeNumber9Rotated = 117,
        Quarto = 15,
        Standard10x11 = 45,
        Standard10x14 = 16,
        Standard11x17 = 17,
        Standard12x11 = 90,
        Standard15x11 = 46,
        Standard9x11 = 44,
        Statement = 6,
        Tabloid = 3,
        TabloidExtra = 52,
        USStandardFanfold = 39
    }
}
export namespace Stimulsoft.System.Drawing.Printing {
    class PaperSize {
        private createdByDefaultConstructor;
        private _kind;
        get kind(): number;
        private _name;
        get name(): string;
        set name(value: string);
        private _width;
        get width(): number;
        set width(value: number);
        private _height;
        get height(): number;
        set height(value: number);
        constructor(kind?: number, name?: string, width?: number, height?: number);
    }
}
export namespace Stimulsoft.System.Drawing.Printing {
    enum PrinterUnit {
        Display = 0,
        ThousandthsOfAnInch = 1,
        HundredthsOfAMillimeter = 2,
        TenthsOfAMillimeter = 3
    }
}
export namespace Stimulsoft.System.Drawing.Printing {
    class PrinterUnitConvert {
        static convert(value: number, fromUnit: PrinterUnit, toUnit: PrinterUnit): number;
        private static unitsPerDisplay;
    }
}
export namespace Stimulsoft.System.Drawing.Printing.PrinterSettings {
    import CollectionBase = Stimulsoft.System.Collections.CollectionBase;
    class PaperSizeCollection extends CollectionBase<PaperSize> {
    }
}
export namespace Stimulsoft.System.Drawing.Printing.PrinterSettings {
    class PrinterSettings {
        get paperSizes(): PaperSizeCollection;
    }
}
export namespace Stimulsoft.System.Drawing.Text {
    enum HotkeyPrefix {
        Hide = 0,
        None = 1,
        Show = 2
    }
}
export namespace Stimulsoft.System.Globalization {
    class Calendar {
        static getWeekOfYear(time: DateTime, rule?: CalendarWeekRule, firstDayOfWeek?: DayOfWeek): number;
        private static getFirstDayWeekOfYear;
        private static getWeekOfYearFullDays;
        static getDaysInYear(year: number): number;
        static getWeekOfMonth(time: DateTime, rule?: CalendarWeekRule, firstDayOfWeek?: DayOfWeek): number;
    }
}
export namespace Stimulsoft.System.Globalization {
    enum CalendarWeekRule {
        FirstDay = 0,
        FirstFullWeek = 1,
        FirstFourDayWeek = 2
    }
}
export namespace Stimulsoft.System.Globalization {
    class RegionInfo {
        name: string;
        nativeName: string;
        threeLetterISORegionName: string;
        threeLetterWindowsRegionName: string;
        twoLetterISORegionName: string;
    }
}
export namespace Stimulsoft.System.IO {
    enum SeekOrigin {
        Begin = 0,
        Current = 1,
        End = 2
    }
}
export namespace Stimulsoft.System.IO {
    class File {
        static getFile(filePath: string, binary?: boolean, contentType?: string, headers?: {
            key: string;
            value: string;
        }[], disableCache?: boolean, withCredentials?: boolean): any;
        static getFileAsync(callback: Function, filePath: string, binary?: boolean, contentType?: string, disableCache?: boolean, withCredentials?: boolean): void;
        static saveFile(filePath: string, fileData: string | number[]): void;
        static getFilesNames(filePath: string): string[];
    }
}
export namespace Stimulsoft.System.IO {
    import StiPromise = Stimulsoft.System.StiPromise;
    class Http {
        private static addNoCacheHeaders;
        static disableCache: boolean;
        static withCredentials: boolean;
        static getFile(filePath: string, binary?: boolean, contentType?: string, headers?: {
            key: string;
            value: string;
        }[], disableCache?: boolean, withCredentials?: boolean): any;
        static getFileAsync(callback: Function, filePath: string, binary?: boolean, contentType?: string, disableCache?: boolean, withCredentials?: boolean): void;
        static getUrlParameters(): {
            name: string;
            value: string;
        }[];
        static send(method: string, url: string, body?: string, headers?: {
            key: string;
            value: string;
        }[], disableCache?: boolean, withCredentials?: boolean): {
            status: number;
            responseText: string;
            statusText: string;
        };
        static sendAsync(method: string, url: string, body?: string, headers?: {
            key: string;
            value: string;
        }[], timeout?: number, disableCache?: boolean, withCredentials?: boolean): StiPromise<{
            status: number;
            responseText: string;
            statusText: string;
        }>;
    }
}
export namespace Stimulsoft.System.IO {
    class MemoryStream {
        private static memStreamMaxLength;
        private _origin;
        private _buffer;
        private _position;
        get position(): number;
        get length(): number;
        get canSeek(): boolean;
        get canWrite(): boolean;
        setLength(length: number): void;
        toArray(): number[];
        toString(): string;
        writeTo(stream: MemoryStream): void;
        writeByte(byte: number): void;
        write(array: number[], offset?: number, length?: number): void;
        writeBytes(array: Uint8Array, offset?: number, length?: number): void;
        writeLine1(inputString?: string, ...values: any[]): void;
        writeLine(inputString?: string): void;
        writeString(inputString: string, newLine?: boolean): void;
        read(array: number[], offset?: number, length?: number): number;
        seek(offset: number, origin: SeekOrigin): number;
        flush(): void;
        close(): void;
        copyTo(stream: MemoryStream): void;
        constructor(array?: number[]);
    }
}
export namespace Stimulsoft.System.IO {
    class Path {
        static combine(path1: string, path2: string): string;
        static getFileNameWithoutExtension(path: string): string;
        static getExtension(path: string): string;
        static getSep(): string;
    }
}
export namespace Stimulsoft.System.IO {
    import Encoding = Stimulsoft.System.Text.Encoding;
    class StreamReader {
        private stream;
        private encoding;
        constructor(stream: MemoryStream, encoding?: Encoding);
        read(): string;
        readLine(): string;
        private readLineInternal;
    }
}
export namespace Stimulsoft.System.Text {
    class Encoding {
        private static CodePageDefault;
        private static CodePageNoOEM;
        private static CodePageNoMac;
        private static CodePageNoThread;
        private static CodePageNoSymbol;
        private static CodePageUnicode;
        private static CodePageBigEndian;
        private static CodePageWindows1250;
        private static CodePageWindows1251;
        private static CodePageWindows1252;
        private static CodePageWindows1256;
        private static CodePageMacGB2312;
        private static CodePageGB2312;
        private static CodePageMacKorean;
        private static CodePageDLLKorean;
        private static ISO2022JP;
        private static ISO2022JPESC;
        private static ISO2022JPSISO;
        private static ISOKorean;
        private static ISOSimplifiedCN;
        private static EUCJP;
        private static ChineseHZ;
        private static DuplicateEUCCN;
        private static EUCCN;
        private static EUCKR;
        private static CodePageASCII;
        private static CodePageISO_8859_1;
        private static ISCIIAssemese;
        private static ISCIIBengali;
        private static ISCIIDevanagari;
        private static ISCIIGujarathi;
        private static ISCIIKannada;
        private static ISCIIMalayalam;
        private static ISCIIOriya;
        private static ISCIIPanjabi;
        private static ISCIITamil;
        private static ISCIITelugu;
        private static GB18030;
        private static ISO_8859_8I;
        private static ISO_8859_8_Visual;
        private static ENC50229;
        private static CodePageUTF7;
        private static CodePageUTF8;
        private static CodePageUTF32;
        private static CodePageUTF32BE;
        static ASCII: Encoding;
        static BigEndianUnicode: Encoding;
        static Default: Encoding;
        static Unicode: Encoding;
        static UTF32: Encoding;
        static UTF7: Encoding;
        static UTF8: Encoding;
        static Windows1250: Encoding;
        static Windows1251: Encoding;
        static Windows1252: Encoding;
        static Windows1256: Encoding;
        static ISO_8859_1: Encoding;
        private static _windows_1250;
        private static _windows_1251;
        private static _windows_1252;
        private static _windows_1256;
        private static charToCodepageList;
        webName: string;
        encodingName: string;
        codepage: number;
        getBytes(str: string): number[];
        getString(bytes: number[] | Uint8Array): string;
        static getEncoding(codepage: number): Encoding;
        static getSupportedEncodings(): {
            key: string;
            name: string;
        }[];
        private static fromCodePageToUnicode;
        private static fromUnicodeToCodePage;
        private static fillCodepage;
        constructor(name: string, codepage: number, webName?: string);
    }
}
export namespace Stimulsoft.System.Text {
    class StringBuilder {
        private isNew;
        private partArray;
        private appendSingle;
        appendThese(items: any[]): StringBuilder;
        append(...items: any[]): StringBuilder;
        appendCount(item: any, count?: number): StringBuilder;
        appendLine(...items: any[]): StringBuilder;
        appendLines(items: any[]): StringBuilder;
        appendFormat(str: string, ...values: any[]): StringBuilder;
        insert(index: number, value: string, count?: number): StringBuilder;
        remove(startIndex: number, length: number): StringBuilder;
        get isEmpty(): boolean;
        get length(): number;
        set length(value: number);
        private latest;
        toString(): string;
        join(delimiter: string): string;
        clear(): void;
        dispose(): void;
        charAt(index: number): string;
        charCodeAt(index: number): number;
        setByIndex(index: number, value: string): void;
        private formatError;
        replace(searchValue: string, replaceValue: string): StringBuilder;
        constructor(value?: string);
    }
}
export namespace Stimulsoft.System.IO {
    import StringBuilder = Stimulsoft.System.Text.StringBuilder;
    class TextWriter {
        private sb;
        write(value: any): void;
        writeLine(value?: any): void;
        close(): void;
        flush(): void;
        getStringBuilder(): StringBuilder;
    }
}
export namespace Stimulsoft.System.IO {
    import Encoding = Stimulsoft.System.Text.Encoding;
    import TextWriter = Stimulsoft.System.IO.TextWriter;
    import MemoryStream = Stimulsoft.System.IO.MemoryStream;
    class StreamWriter extends TextWriter {
        private stream;
        private encoding;
        private cn;
        writeLine(value: string): void;
        write(value: string): void;
        close(): void;
        flush(): void;
        constructor(stream: MemoryStream, encoding?: Encoding);
    }
}
export namespace Stimulsoft.System.Text {
    import Color = Stimulsoft.System.Drawing.Color;
    class StiReportObjectStringConverter {
        static convertStringToColorArray(str: string): Color[];
        static convertStringToColor(str: string): Color;
        static convertStringToFont(str: string): Stimulsoft.System.Drawing.Font;
        private static getByName;
    }
}
export namespace Stimulsoft.System.Text {
    import Font = Stimulsoft.System.Drawing.Font;
    class TextUtils {
        static splitString(inputString: string, removeControl: boolean): string[];
        static trimEndWhiteSpace(inputString: string): string;
        static trimEndWhiteSpace2(inputString: string, removeControl: boolean): string;
        private static isWordWrapSymbol;
        static getWordWrapTextLines(st: string, font: Font, needWidthAlign: boolean, textW: number): string[];
    }
}
export namespace Stimulsoft.System.Xml {
    enum Formatting {
        None = 0,
        Indented = 1
    }
}
export namespace Stimulsoft.System.Xml {
    import CollectionBase = Stimulsoft.System.Collections.CollectionBase;
    class XmlAttrCollection extends CollectionBase<XmlAttr> {
        getNamedItem(name: string): XmlAttr;
    }
}
export namespace Stimulsoft.System.Xml {
    class XmlCharType {
        static fWhitespace: number;
        static fLetter: number;
        static fNCStartName: number;
        static fNCName: number;
        static fCharData: number;
        static fPublicId: number;
        static fText: number;
        static fAttrValue: number;
        private static charPropertiesSize;
        static get instance(): XmlCharType;
        private static s_CharProperties;
        charProperties: number[];
        private static initInstance;
        private static setProperties;
        private static s_Whitespace;
        private static s_Letter;
        private static s_NCStartName;
        private static s_NCName;
        private static s_CharData;
        private static s_PublicID;
        private static s_Text;
        private static s_AttrValue;
        constructor(charProperties: any[]);
    }
}
export namespace Stimulsoft.System.Xml {
    class XmlReservedNs {
        static NsCollationBase: string;
        static NsCollCodePoint: string;
        static NsDataType: string;
        static NsDataTypeAlias: string;
        static NsDataTypeOld: string;
        static NsExsltCommon: string;
        static NsExsltDates: string;
        static NsExsltMath: string;
        static NsExsltRegExps: string;
        static NsExsltSets: string;
        static NsExsltStrings: string;
        static NsMsxsl: string;
        static NsWdXsl: string;
        static NsXdr: string;
        static NsXdrAlias: string;
        static NsXml: string;
        static NsXmlNs: string;
        static NsXQueryDataType: string;
        static NsXQueryFunc: string;
        static NsXs: string;
        static NsXsd: string;
        static NsXsi: string;
        static NsXslDebug: string;
        static NsXslt: string;
        static NsXsltInternal: string;
    }
}
export namespace Stimulsoft.System.Xml {
    enum XmlSpace {
        Default = 1,
        None = 0,
        Preserve = 2
    }
}
export namespace Stimulsoft.System.Xml {
    import TextWriter = Stimulsoft.System.IO.TextWriter;
    class XmlTextEncoder {
        private textWriter;
        private inAttribute;
        quoteChar: string;
        private attrValue;
        private cacheAttrValue;
        private xmlCharType;
        private surHighStart;
        private surHighEnd;
        private surLowStart;
        private surLowEnd;
        startAttribute(cacheAttrValue: boolean): void;
        endAttribute(): void;
        get attributeValue(): string;
        private writeSurrogateChar;
        write(text: string): void;
        writeRawWithSurrogateChecking(text: string): void;
        private writeStringFragment;
        private writeCharEntityImpl;
        private writeEntityRefImpl;
        constructor(textWriter: TextWriter);
    }
}
export namespace Stimulsoft.System.Xml {
    import Encoding = Stimulsoft.System.Text.Encoding;
    import TextWriter = Stimulsoft.System.IO.TextWriter;
    import MemoryStream = Stimulsoft.System.IO.MemoryStream;
    class XmlTextWriter {
        private static stateTableDefault;
        private static stateTableDocument;
        textWriter: TextWriter;
        private xmlEncoder;
        private encoding;
        formatting: Formatting;
        private indented;
        indentation: number;
        private indentChar;
        private stack;
        private top;
        private stateTable;
        private currentState;
        private lastToken;
        private quoteChar;
        private curQuoteChar;
        private namespaces;
        private specialAttr;
        private prefixForXmlNs;
        private _flush;
        private nsStack;
        private nsTop;
        private nsHashtable;
        private useNsHashtable;
        private xmlCharType;
        private namespaceStackInitialSize;
        private maxNamespacesWalkCount;
        writeStartDocument(standalone?: boolean): void;
        writeEndDocument(): void;
        writeDocType(name: string, pubid: string, sysid: string, subset: string): void;
        writeStartElement(localName: string): void;
        private writeStartElement3;
        writeEndElement(): void;
        writeFullEndElement(): void;
        writeStartAttribute(prefix: string, localName: string, ns: string): void;
        writeEndAttribute(): void;
        writeString(text: string): void;
        writeRaw(data: string): void;
        close(): void;
        flush(): void;
        writeName(name: string): void;
        writeQualifiedName(localName: string, ns: string): void;
        private startDocument;
        private autoComplete;
        private autoCompleteAll;
        private internalWriteEndElement;
        private writeEndStartTag;
        private writeEndAttributeQuote;
        private indent;
        private pushNamespace;
        private addNamespace;
        private addToNamespaceHashtable;
        private popNamespaces;
        private generatePrefix;
        private internalWriteProcessingInstruction;
        private lookupNamespace;
        private lookupNamespaceInCurrentScope;
        private findPrefix;
        private internalWriteName;
        private validateName;
        private handleSpecialAttribute;
        private verifyPrefixXml;
        private pushStack;
        private flushEncoders;
        writeAttributeString(localName: string, value: string): void;
        writeElementString(localName: string, value: string): void;
        writeElementString2(localName: string, ns: string, value: string): void;
        writeElementString3(prefix: string, localName: string, ns: string, value: string): void;
        constructor_(encoding: Encoding, w?: MemoryStream): void;
        constructor(encoding: Encoding, w?: MemoryStream);
    }
}
export namespace Stimulsoft.Base {
    enum StiAnimationType {
        Opacity = 0,
        Scale = 1,
        Translation = 2,
        Rotation = 3,
        Column = 4,
        Points = 5,
        PieSegment = 6
    }
    enum StiTokenType {
        None = 0,
        Dot = 1,
        Comma = 2,
        Colon = 3,
        SemiColon = 4,
        Shl = 5,
        Shr = 6,
        Assign = 7,
        Equal = 8,
        NotEqual = 9,
        LeftEqual = 10,
        Left = 11,
        RightEqual = 12,
        Right = 13,
        Or = 14,
        And = 15,
        Not = 16,
        DoubleOr = 17,
        DoubleAnd = 18,
        Copyright = 19,
        Question = 20,
        Plus = 21,
        Minus = 22,
        Mult = 23,
        Div = 24,
        Splash = 25,
        Percent = 26,
        Ampersand = 27,
        Sharp = 28,
        Dollar = 29,
        Euro = 30,
        DoublePlus = 31,
        DoubleMinus = 32,
        LPar = 33,
        RPar = 34,
        LBrace = 35,
        RBrace = 36,
        LBracket = 37,
        RBracket = 38,
        Value = 39,
        Ident = 40,
        Unknown = 41,
        EOF = 42
    }
    enum StiLevel {
        Basic = 0,
        Standard = 1,
        Professional = 2
    }
    enum StiAutoBool {
        Auto = 0,
        True = 1,
        False = 2
    }
    enum StiRelationDirection {
        ParentToChild = 1,
        ChildToParent = 0
    }
    enum StiGisDataType {
        Wkt = 0,
        GeoJSON = 1
    }
    enum StiSummaryColumnType {
        Sum = 0,
        Min = 1,
        Max = 2,
        Count = 3,
        Average = 4
    }
}
export namespace Stimulsoft.Base {
    let IStiApp: System.Interface<IStiApp>;
    interface IStiApp extends IStiAppCell {
        getDictionary(): IStiAppDictionary;
    }
}
export namespace Stimulsoft.Base {
    let IStiAppAlias: System.Interface<IStiAppAlias>;
    interface IStiAppAlias {
        getAlias(): string;
    }
}
export namespace Stimulsoft.Base {
    let IStiAppCalcDataColumn: System.Interface<IStiAppCalcDataColumn>;
    interface IStiAppCalcDataColumn extends IStiAppDataColumn {
    }
}
export namespace Stimulsoft.Base {
    import IAsIs = Stimulsoft.System.IAsIs;
    let IStiAppCell: System.Interface<IStiAppCell>;
    interface IStiAppCell extends IAsIs {
        getKey(): string;
        setKey(key: string): void;
    }
}
export namespace Stimulsoft.Base {
    let IStiAppComponent: System.Interface<IStiAppComponent>;
    interface IStiAppComponent extends IStiAppCell {
        getName(): string;
        getApp(): IStiApp;
    }
}
export namespace Stimulsoft.Base {
    let IStiAppConnection: System.Interface<IStiAppConnection>;
    interface IStiAppConnection extends IStiAppCell {
        getName(): string;
    }
}
export namespace Stimulsoft.Base {
    let IStiAppDataCell: System.Interface<IStiAppDataCell>;
    interface IStiAppDataCell extends IStiAppCell {
        getName(): string;
    }
}
export namespace Stimulsoft.Base {
    import Type = Stimulsoft.System.Type;
    let IStiAppDataColumn: System.Interface<IStiAppDataColumn>;
    interface IStiAppDataColumn extends IStiAppDataCell {
        getNameInSource(): string;
        getDataType(): Type;
    }
}
export namespace Stimulsoft.Base {
    import List = Stimulsoft.System.Collections.List;
    let IStiAppDataRelation: System.Interface<IStiAppDataRelation>;
    interface IStiAppDataRelation extends IStiAppCell {
        getName(): string;
        getDictionary(): IStiAppDictionary;
        getParentDataSource(): IStiAppDataSource;
        getChildDataSource(): IStiAppDataSource;
        fetchParentColumns(): List<string>;
        fetchChildColumns(): List<string>;
        getActiveState(): boolean;
    }
}
export namespace Stimulsoft.Base {
    import DataTable = Stimulsoft.System.Data.DataTable;
    import List = Stimulsoft.System.Collections.List;
    let IStiAppDataSource: System.Interface<IStiAppDataSource>;
    interface IStiAppDataSource extends IStiAppCell {
        getNameInSource(): string;
        getName(): string;
        getDataTable2(allowConnectToData: boolean): Promise<DataTable>;
        getDictionary(): IStiAppDictionary;
        fetchColumns(): List<IStiAppDataColumn>;
        getConnection(): IStiAppConnection;
        fetchParentRelations(activePreferred: boolean): List<IStiAppDataRelation>;
        fetchChildRelations(activePreferred: boolean): List<IStiAppDataRelation>;
        fetchColumnValues(names: List<string>): List<any[]>;
        fetchColumnValuesAsync(names: List<string>): Promise<List<any[]>>;
    }
}
export namespace Stimulsoft.Base {
    import List = Stimulsoft.System.Collections.List;
    let IStiAppDictionary: System.Interface<IStiAppDictionary>;
    interface IStiAppDictionary {
        fetchDataSources(): List<IStiAppDataSource>;
        fetchDataRelations(): List<IStiAppDataRelation>;
        fetchVariables(): List<IStiAppVariable>;
        getDataSourceByName(name: string): IStiAppDataSource;
        getColumnByName(name: string): IStiAppDataColumn;
        getVariableByName(name: string): IStiAppVariable;
        getVariableValueByName(name: string): any;
        isSystemVariable(name: string): boolean;
        isReadOnlyVariable(name: string): boolean;
        getSystemVariableValue(name: string): any;
        getApp(): IStiApp;
        openConnections(connections: List<IStiAppConnection>): List<IStiAppConnection>;
        closeConnections(connections: List<IStiAppConnection>): void;
    }
}
export namespace Stimulsoft.Base {
    let IStiAppExpressionCollection: System.Interface<IStiAppExpressionCollection>;
    interface IStiAppExpressionCollection {
        expressions: StiAppExpressionCollection;
    }
}
export namespace Stimulsoft.Base {
    import List = Stimulsoft.System.Collections.List;
    let IStiAppFunction: System.Interface<IStiAppFunction>;
    interface IStiAppFunction extends IStiAppCell {
        getName(): string;
        invoke(arguments: List<any>): any;
    }
}
export namespace Stimulsoft.Base {
    import Type = Stimulsoft.System.Type;
    let IStiAppVariable: System.Interface<IStiAppVariable>;
    interface IStiAppVariable extends IStiAppDataCell {
        getValue(): any;
        getCellType(): Type;
    }
}
export namespace Stimulsoft.Base {
    import Font = Stimulsoft.System.Drawing.Font;
    let IStiGetFonts: System.Interface<IStiGetFonts>;
    interface IStiGetFonts {
        getFonts(): Font[];
    }
}
export namespace Stimulsoft.Base {
    import List = Stimulsoft.System.Collections.List;
    let IStiReport: System.Interface<IStiReport>;
    interface IStiReport extends IStiApp {
        fetchPages(): List<IStiReportPage>;
    }
}
export namespace Stimulsoft.Base {
    let IStiReportComponent: System.Interface<IStiReportComponent>;
    interface IStiReportComponent extends IStiAppComponent {
        getReport(): IStiReport;
    }
}
export namespace Stimulsoft.Base {
    let IStiReportPage: System.Interface<IStiReportPage>;
    interface IStiReportPage extends IStiReportComponent {
        parseExpression(text: string, allowReturnNull: boolean): string;
    }
}
export namespace Stimulsoft.Base {
    class StiActivator {
        static createObject(_type: Stimulsoft.System.Type): any;
        static createObject2(typeString: string): any;
    }
}
export namespace Stimulsoft.Base {
    class StiAlignValue {
        static alignToMaxGrid(value: number, gridSize: number, aligningToGrid: boolean): number;
        static alignToMinGrid(value: number, gridSize: number, aligningToGrid: boolean): number;
        static alignToGrid(value: number, gridSize: number, aligningToGrid: boolean): number;
    }
}
export namespace Stimulsoft.Base.JsonReportObject {
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import StiJson = Stimulsoft.Base.StiJson;
    let IStiJsonReportObject: System.Interface<IStiJsonReportObject>;
    interface IStiJsonReportObject {
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): any;
    }
}
export namespace Stimulsoft.Base {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    class StiAppExpression implements ICloneable, IStiJsonReportObject {
        private static ImplementsStiAppExpression;
        implements(): any[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        loadFromXml(xmlNode: XmlNode): void;
        private upperFirstChar;
        private lowerFirstChar;
        clone(): StiAppExpression;
        name: string;
        expression: string;
        get isEmpty(): boolean;
        constructor(name: string, expression: string);
    }
}
export namespace Stimulsoft.Base {
    import CollectionBase = Stimulsoft.System.Collections.CollectionBase;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    class StiAppExpressionCollection extends CollectionBase<StiAppExpression> implements ICloneable, IStiJsonReportObject {
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        loadFromXml(xmlNode: XmlNode): void;
        add2(name: string, expression: string): void;
        addRange2(props: StiAppExpressionCollection): void;
        contains2(name: string): boolean;
        remove2(name: string): void;
        getByName(name: string): StiAppExpression;
        setByName(name: string, value: StiAppExpression): void;
        clone(): StiAppExpressionCollection;
    }
}
export namespace Stimulsoft.Base {
    class StiAppExpressionHelper {
        static isExpressionSpecified(component: any, propName: string): boolean;
        static getExpression(component: any, propName: string): StiAppExpression;
        static getExpressionValue(component: any, propName: string): string;
        static setExpression(component: any, propName: string, expression: string): void;
        static removeExpression(component: any, propName: string): void;
    }
}
export namespace Stimulsoft.Base {
    import Hashtable = Stimulsoft.System.Collections.Hashtable;
    class StiAppFunctions {
        static functionsToCompile: Hashtable<any, any>;
        static functionsToCompileLower: Hashtable<any, any>;
        static functions: Hashtable<any, any>;
        static functionsLower: Hashtable<any, any>;
        static getFunctions(isCompile: boolean, isCaseSensitive: boolean): IStiAppFunction[];
        static getFunctions2(functionName: string, isCompile: boolean, isCaseSensitive: boolean): IStiAppFunction[];
    }
}
export namespace Stimulsoft.Base {
    class StiAppKey {
        static getOrGeneratedKey(component: IStiReportComponent): string;
        static getOrGeneratedKey2(app: IStiApp): string;
        static getOrGeneratedKey3(dictionary: IStiAppDictionary): string;
        static getOrGeneratedKey4(dataSource: IStiAppDataSource): string;
    }
}
export namespace Stimulsoft.Base {
    class StiEncryption {
        private static randomSeed;
        private static rand_m;
        private static rand_a;
        private static rand_c;
        static encrypt(src: number[], key: number[]): number[];
        static encrypt2(src: number[], password: string): number[];
        static encryptS(src: string, password: string): string;
        static decrypt(src: number[], key: number[]): number[];
        static decrypt2(src: number[], password: string): number[];
        static decryptS(src: string, password: string): string;
        static generateRandomKey(): number[];
        private static encryptAdv;
        private static decryptAdv;
        private static cryptXor;
        private static cryptShift;
        private static shiftLeft;
        private static shiftRight;
        private static cryptRandom;
        private static getMixArray;
        private static setRandomSeed;
        private static getRandom;
        private static getKeyFromPassword;
    }
}
export namespace Stimulsoft.Base {
    import Point = Stimulsoft.System.Drawing.Point;
    import List = Stimulsoft.System.Collections.List;
    import DateTime = Stimulsoft.System.DateTime;
    class StiJson {
        static prettyPrint: boolean;
        static dateToJsonDate(date: DateTime): string;
        static jsonDateFormatToDate(jsonDate: string): DateTime;
        name: string;
        value: any;
        private isProperty;
        private isArray;
        properties(): List<StiJson>;
        removeProperty(propertyName: string): void;
        addPropertyNumber(propertyName: string, value: number, defaultValue?: number): void;
        addPropertyNumberNoDefaultValue(propertyName: string, value: number): void;
        addPropertyJObject(propertyName: string, value: StiJson): void;
        addPropertyJObjectArray(propertyName: string, values: StiJson[]): void;
        addPropertyPoint(propertyName: string, point: Point): void;
        addPropertyIdent(propertyName: string, value: string): void;
        addPropertyBool(propertyName: string, value: boolean, defaultValue?: boolean, ignoreDefaultValues?: boolean): void;
        addPropertyDateTime(propertyName: string, value: DateTime): void;
        addPropertyEnum(propertyName: string, enumType: any, value: any, defaultValue?: any): void;
        addPropertyString(propertyName: string, value: string, defaultValue?: string): void;
        addPropertyStringNullOrEmpty(propertyName: string, value: string): void;
        get count(): number;
        serialize(indent?: number): string;
        deserialize(text: any): void;
        private deserializeFromObject;
        toString(): string;
        constructor(name?: string, value?: any, isProperty?: boolean);
    }
}
export namespace Stimulsoft.Base {
    import StiJson = Stimulsoft.Base.StiJson;
    class StiCID {
        private static key;
        private static undefined;
        private static prefix;
        private machineAddress;
        private machineName;
        private machineUserName;
        private machineGuid;
        saveToString(): string;
        saveToJsonObject(): StiJson;
        loadFromString(value: string): void;
        loadFromJsonObject(jObject: StiJson): void;
        static getDefault(): string;
        private static getDeveloperCID;
        private static getCurrentMachineName;
        private static getCurrentMachineGuid;
        private static getCurrentMachineAddress;
        private static getCurrentMachineUserName;
        static isCID(cid: string): boolean;
        constructor(machineName: string, machineAddress?: string, machineUserName?: string, machineGuid?: string);
    }
}
export namespace Stimulsoft.Base.Localization {
    class StiLocalization {
        static languages: any;
        static setLocalization(localizationXml: string, onlyThis?: boolean): void;
        private static _cultureName;
        static get cultureName(): string;
        static set cultureName(value: string);
        static addLocalizationFile(filePath: string, load?: boolean, language?: string): string;
        static setLocalizationFile(filePath: string, onlyThis?: boolean): void;
        static getJsonStringLocalization(): string;
        static loadLocalization(localizationXml: any, extension?: boolean): string;
        static loadLocalizationFile(filePath: string): string;
        private static loadLocalizationXmlInternal;
        static get(category: string, key: string): string;
    }
}
export namespace Stimulsoft.Base {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    class StiChartNotSupportedException {
        static message: string;
        static getTextJson(chartJson: StiJson): StiJson;
        static getTextXml(chartXml: XmlNode, message?: string): XmlNode;
        get message(): string;
    }
}
export namespace Stimulsoft.Base.Drawing {
    import Color = Stimulsoft.System.Drawing.Color;
    class StiColor {
        static get(color: string): Color;
        static get2(...colors: string[]): Color[];
    }
}
export namespace Stimulsoft.Base {
    class StiConvert {
        static changeType(value: any, conversionType: Stimulsoft.System.Type, convertNulls?: boolean): any;
    }
}
export namespace Stimulsoft.Base {
    class StiDashboardNotSupportedException {
        get message(): string;
    }
}
export namespace Stimulsoft.Base {
    class StiExportNotSupportedException {
        get message(): string;
    }
}
export namespace Stimulsoft.Base {
    import FontFamily = Stimulsoft.System.Drawing.FontFamily;
    import FontStyle = Stimulsoft.System.Drawing.FontStyle;
    class StiFontCollection {
        static addOpentypeFont(font: any, fontName?: string, binFont?: any, filePath?: string, fontStyle?: FontStyle, store?: boolean): void;
        static addFont(font: any, fontName?: string, binFont?: any, filePath?: string, fontStyle?: FontStyle, store?: boolean): void;
        static addOpentypeFontFile(filePath: string, fontName?: string, fontStyle?: FontStyle, store?: boolean): void;
        static addFontFile(filePath: string, fontName?: string, fontStyle?: FontStyle, store?: boolean): void;
        static addOpentypeFontFileAsync(callback: () => {}, filePath: string, fontName?: string, fontStyle?: FontStyle, store?: boolean): void;
        static addFontFileAsync(callback: () => {}, filePath: string, fontName?: string, fontStyle?: FontStyle, store?: boolean): void;
        static addFontBytes(data: any, fontName?: string, fontStyle?: FontStyle, store?: boolean): void;
        static setOpentypeFontsFolder(folderPatch: string): void;
        static setFontsFolder(folderPatch: string): void;
        static getFontFamilies(): FontFamily[];
        static getBinFont(fontName: string, fontStyle?: FontStyle): any;
        static getBinFonts(): string[];
        static isCustomFont(fontName: string): boolean;
    }
}
export namespace Stimulsoft.Base {
    class StiGisToDataSetConverter {
    }
}
export namespace Stimulsoft.Base {
    class StiGuidUtils {
        static newGuid(): string;
    }
}
export namespace Stimulsoft.Base {
    class StiJsonChecker {
        static isValidJson(strInput: string): boolean;
    }
}
export namespace Stimulsoft.Base {
    class StiKeyHelper {
        static generateKey(): string;
        static isKey(key: string): boolean;
        static isCorrectKey(key: string): boolean;
        static isEmptyKey(key: string): boolean;
        static isEmptyKey2(key1: string, key2: string): boolean;
        static selectKey(key1: string, key2: string): string;
        static isEqualKeys(key1: string, key2: string): boolean;
        static getOrGeneratedKey(key: string): string;
        static getOrGeneratedKey2(key1: string, key2: string): string;
    }
}
export namespace Stimulsoft.Base {
    class StiKeyObject {
        key: string;
        isStored: string;
        constructor();
    }
}
export namespace Stimulsoft.Base {
    import List = Stimulsoft.System.Collections.List;
    class StiLexer {
        private _text;
        get text(): string;
        set text(value: string);
        baseText: string;
        private positions;
        positionInText: number;
        savePosToken(): void;
        getPosition(positionInText: number): StiPosition;
        skip(): void;
        waitLparen2(): boolean;
        waitComma2(): boolean;
        waitAssign2(): boolean;
        waitRparen2(): boolean;
        waitLbrace2(): boolean;
        waitSemicolon2(): boolean;
        waitRbrace2(): boolean;
        scanNumber(): StiToken;
        scanIdent(): StiToken;
        scanString(): StiToken;
        scanChar(): StiToken;
        ungetToken(): void;
        getToken(): StiToken;
        reset(): void;
        static replaceWithPrefix(textValue: string, prefix: string, oldValue: string, newValue: string): string;
        replaceWithPrefix(prefix: string, oldValue: string, newValue: string): void;
        replaceWithNotEqualPrefix(prefix: StiTokenType, oldValue: string, newValue: string): void;
        static identExists(str: string, name: string, caseSensitive: boolean): boolean;
        static getAllTokens(str: string): List<StiToken>;
        constructor(textValue: string);
    }
}
export namespace Stimulsoft.Base {
    class StiMD5Helper {
        static MD5(string: any, convertToUtf8?: boolean): any[];
    }
}
export namespace Stimulsoft.Base {
    class StiObjectConverter {
        static convertToNumber(value: any): number;
    }
}
export namespace Stimulsoft.Base {
    class StiPosition {
        line: number;
        column: number;
        constructor(line: number, column: number);
    }
}
export namespace Stimulsoft.Base {
    import ICloneable = Stimulsoft.System.ICloneable;
    class StiRepositoryItems implements ICloneable {
        implements(): any[];
        clone(): any;
        private items;
        private valueBoolFalse;
        private valueBoolTrue;
        setNumber(key: string, value: number, defaultValue: number): void;
        getNumber(key: string, defaultValue: number): number;
        setBool(key: string, value: boolean, defaultValue: boolean): void;
        getBool(key: string, defaultValue: boolean): boolean;
        set(key: string, value: any, defaultValue: any): void;
        get(key: string, defaultValue: any): any;
        isPresent(key: string): boolean;
    }
}
export namespace Stimulsoft.Base {
    class StiScale {
        static xx(value: number): number;
        static yy(value: number): number;
        static factor: number;
    }
}
export namespace Stimulsoft.Base {
    class StiSettings {
        static get(name: string, def: string): string;
        static set(name: string, value: string): void;
    }
}
export namespace Stimulsoft.Base {
    class StiToken {
        index: number;
        length: number;
        type: StiTokenType;
        data: string;
        toString(): string;
        constructor(type: StiTokenType, index?: number, length?: number, obj?: any);
    }
}
export namespace Stimulsoft.Base {
    class StiTypeFinder {
        private static findTypes;
        private static getCorrectTypeName;
        static getStiType(typeName: string): Stimulsoft.System.Type;
        private static addTypeFF;
        private static getTypeFF;
        static findType(exType: Stimulsoft.System.Type, typeForFinding: Stimulsoft.System.Type): boolean;
    }
}
export namespace Stimulsoft.Base {
    class StiTypeWrapper {
        private _type;
        get type(): Stimulsoft.System.Type;
        toString(): string;
        static toString(type: Stimulsoft.System.Type): string;
        private static _simpleTypes;
        static get simpleTypes(): Stimulsoft.System.Type[];
        private static _simpleBaseTypes;
        static get simpleBaseTypes(): Stimulsoft.System.Type[];
        static getTypeWrappers(): StiTypeWrapper[];
        constructor(type: Stimulsoft.System.Type);
    }
}
export namespace Stimulsoft.Base {
    class StiUrl {
        static combine(uriParts: string[]): string;
    }
}
export namespace Stimulsoft {
    class StiVersion {
        static version: string;
        static creationDate: string;
        static created: System.DateTime;
        static versionInfo: string;
        static platform(): string;
    }
}
export namespace Stimulsoft.Base {
    import DateTime = Stimulsoft.System.DateTime;
    class StringExt {
        static tryParseDateTime(value: string, refDateTime: {
            ref: DateTime;
        }): boolean;
        private static tryParseUsingDate;
        private static tryParseJsonDateTime;
        private static tryParseJsonDateTimeInNewDate;
    }
}
export namespace Stimulsoft.Base.Blocks {
    interface IStiBlocklyValueEventArgs {
    }
}
export namespace Stimulsoft.Base.Blocks {
    import EventArgs = Stimulsoft.System.EventArgs;
    import IStiReport = Stimulsoft.Base.IStiReport;
    interface IStiBlocksParser {
        evaluate(report: IStiReport, sender: any, xml: string, args: EventArgs): any;
        evaluateAsync(report: IStiReport, sender: any, xml: string, args: EventArgs): any;
    }
}
export namespace Stimulsoft.Base.Blocks {
    class StiBlocksConst {
        static identXml: string;
    }
}
export namespace Stimulsoft.Base.Blocks {
    import IStiBlocksParser = Stimulsoft.Base.Blocks.IStiBlocksParser;
    class StiBlocksCreator {
        static getBlockParse(): IStiBlocksParser;
    }
}
export namespace Stimulsoft.Base.Dashboard {
    import Color = Stimulsoft.System.Drawing.Color;
    class Font {
        Name: string;
        Size: number;
        Color: Color;
        SelectedColor: Color;
        IsBold: boolean;
        getGdiFont(zoom?: number, fontSize?: number, baseFont?: Stimulsoft.System.Drawing.Font): Stimulsoft.System.Drawing.Font;
        getCachedGdiFont(): Stimulsoft.System.Drawing.Font;
        private cachedFont;
        constructor(name: string, size: number, color: Color, isBold?: boolean);
    }
    export class StiElementConsts {
        static TitleFont: Font;
        static ForegroundColor: Color;
        static BackgroundColor: Color;
        static TreeView: {
            ItemHeight: number;
        };
        static ComboBox: {
            ItemHeight: number;
        };
        static ListBox: {
            ItemHeight: number;
            CheckBoxWidth: number;
        };
        static Table: {
            Font: Font;
            BorderColor: Color;
            Height: number;
            getHeight: (font: Stimulsoft.System.Drawing.Font, scale?: number) => number;
            Header: {
                BackgroundColor: Color;
            };
        };
    }
    export {};
}
export namespace Stimulsoft.Base {
    enum StiDataFormatType {
        Xml = 0,
        Json = 1
    }
    enum StiRetrieveColumnsMode {
        KeyInfo = 0,
        SchemaOnly = 1,
        FillSchema = 2
    }
    enum StiConnectionIdent {
        Db2DataSource = 1,
        InformixDataSource = 2,
        MsAccessDataSource = 3,
        MsSqlDataSource = 4,
        MySqlDataSource = 5,
        OdbcDataSource = 6,
        OleDbDataSource = 7,
        FirebirdDataSource = 8,
        PostgreSqlDataSource = 9,
        OracleDataSource = 10,
        SqlCeDataSource = 11,
        SqLiteDataSource = 12,
        SybaseDataSource = 13,
        TeradataDataSource = 14,
        VistaDbDataSource = 15,
        UniversalDevartDataSource = 16,
        ODataDataSource = 17,
        CsvDataSource = 18,
        DBaseDataSource = 19,
        DynamicsNavDataSource = 20,
        ExcelDataSource = 21,
        JsonDataSource = 22,
        GisDataSource = 23,
        XmlDataSource = 24,
        DropboxCloudStorage = 25,
        GoogleDriveCloudStorage = 26,
        OneDriveCloudStorage = 27,
        SharePointCloudStorage = 28,
        DataWorldDataSource = 29,
        QuickBooksDataSource = 30,
        Unspecified = 31
    }
    enum StiConnectionOrder {
        MsSqlDataSource = 10,
        MySqlDataSource = 20,
        OdbcDataSource = 30,
        OleDbDataSource = 40,
        OracleDataSource = 50,
        GisDataSource = 55,
        MsAccessDataSource = 60,
        PostgreSqlDataSource = 70,
        FirebirdDataSource = 80,
        SqlCeDataSource = 90,
        SqLiteDataSource = 100,
        Db2DataSource = 110,
        InformixDataSource = 120,
        SybaseDataSource = 130,
        TeradataDataSource = 140,
        VistaDbDataSource = 150,
        UniversalDevartDataSource = 160,
        ODataDataSource = 170,
        ExcelDataSource = 180,
        JsonDataSource = 190,
        XmlDataSource = 200,
        CsvDataSource = 210,
        DBaseDataSource = 220,
        DynamicsNavDataSource = 230,
        DropboxCloudStorage = 240,
        GoogleDriveCloudStorage = 250,
        OneDriveCloudStorage = 260,
        SharePointCloudStorage = 270,
        DataWorldDataSource = 330,
        QuickBooksDataSource = 340,
        Unspecified = 0
    }
    enum StiFileType {
        Unknown = 1,
        ReportSnapshot = 2,
        Pdf = 3,
        Xps = 4,
        PowerPoint = 5,
        Html = 6,
        Text = 7,
        RichText = 8,
        Word = 9,
        OpenDocumentWriter = 10,
        Excel = 11,
        OpenDocumentCalc = 12,
        Data = 13,
        Image = 14,
        Xml = 15,
        Xsd = 16,
        Csv = 17,
        Dbf = 18,
        Sylk = 19,
        Dif = 20,
        Json = 21,
        Gis = 22
    }
}
export namespace Stimulsoft.Base {
    import IStiAppDataSource = Stimulsoft.Base.IStiAppDataSource;
    import DataTable = Stimulsoft.System.Data.DataTable;
    let IStiBIDataCache: System.Interface<IStiBIDataCache>;
    interface IStiBIDataCache {
        exists(dataSource: IStiAppDataSource): boolean;
        exists2(tableKey: string): boolean;
        remove(tableKey: string): void;
        clean(appKey: string): void;
        cleanAll(): void;
        getTableCount(): number;
        getRowCount(tableKey: string): number;
        getSchema(tableKey: string): DataTable;
        getData(tableKey: string): DataTable;
        runQuery(query: string): DataTable;
        add(appKey: string, tableKey: string, dataTable: DataTable): void;
        getTableName(appKey: string, tableKey: string): string;
    }
}
export namespace Stimulsoft.Base {
    import DataTable = Stimulsoft.System.Data.DataTable;
    class StiBIDataCacheHelper {
        private static checkInitialization;
        static exists(tableKey: string): boolean;
        static remove(tableKey: string): void;
        static clean(appKey: string): void;
        static cleanAll(): void;
        static getTableCount(): number;
        static getRowCount(tableKey: string): number;
        static runQuery(query: string): DataTable;
        static get(tableKey: string, loadData?: boolean): DataTable;
        static add(app: IStiApp, tableKey: string, dataTable: DataTable): void;
        static add2(appKey: string, tableKey: string, dataTable: DataTable): void;
        static getTableName(appKey: string, tableKey: string): string;
    }
}
export namespace Stimulsoft.Base {
    class StiBIDataCacheOptions {
        static enabled: boolean;
        static cache: IStiBIDataCache;
    }
}
export namespace Stimulsoft.Base.Data.StiDbType {
    enum Db2 {
        Invalid = 0,
        SmallInt = 1,
        Integer = 2,
        BigInt = 3,
        Real = 4,
        Double = 5,
        Float = 6,
        Decimal = 7,
        Numeric = 8,
        Date = 9,
        Time = 10,
        Timestamp = 11,
        Char = 12,
        VarChar = 13,
        LongVarChar = 14,
        Binary = 15,
        VarBinary = 16,
        LongVarBinary = 17,
        Graphic = 18,
        VarGraphic = 19,
        LongVarGraphic = 20,
        Clob = 21,
        Blob = 22,
        DbClob = 23,
        Datalink = 24,
        RowId = 25,
        Xml = 26,
        Real370 = 27,
        DecimalFloat = 28,
        DynArray = 29,
        BigSerial = 30,
        BinaryXml = 31,
        TimeStampWithTimeZone = 32,
        Cursor = 33,
        Serial = 34,
        Int8 = 35,
        Serial8 = 36,
        Money = 37,
        DateTime = 38,
        Text = 39,
        Byte = 40,
        SmallFloat = 1002,
        Null = 1003,
        NChar = 1006,
        NVarChar = 1007,
        Boolean = 1015,
        Other = 1016
    }
    enum DevartMySql {
        BigInt = 1,
        Binary = 2,
        Bit = 3,
        Blob = 4,
        Char = 5,
        Date = 6,
        DateTime = 7,
        Decimal = 8,
        Double = 9,
        Float = 10,
        Int = 11,
        SmallInt = 12,
        Text = 13,
        Time = 14,
        TimeStamp = 15,
        TinyInt = 16,
        VarBinary = 17,
        VarChar = 18,
        Year = 19,
        Guid = 20,
        Geometry = 21
    }
    enum DevartOracle {
        Array = 1,
        BFile = 2,
        Blob = 3,
        Boolean = 4,
        Char = 5,
        Clob = 6,
        Cursor = 7,
        Date = 8,
        Double = 9,
        Float = 10,
        Integer = 11,
        IntervalDS = 12,
        IntervalYM = 13,
        Long = 14,
        LongRaw = 15,
        NChar = 16,
        NClob = 17,
        NVarChar = 18,
        Number = 19,
        Object = 20,
        Ref = 21,
        Raw = 22,
        RowId = 23,
        Table = 24,
        TimeStamp = 25,
        TimeStampLTZ = 26,
        TimeStampTZ = 27,
        VarChar = 28,
        Xml = 29,
        AnyData = 30,
        Byte = 31,
        Int16 = 32,
        Int64 = 33
    }
    enum DevartPostgreSql {
        Row = 1,
        Array = 2,
        LargeObject = 3,
        Boolean = 16,
        ByteA = 17,
        BigInt = 20,
        SmallInt = 21,
        Int = 23,
        Text = 25,
        Json = 114,
        Xml = 142,
        Point = 600,
        LSeg = 601,
        Path = 602,
        Box = 603,
        Polygon = 604,
        Line = 628,
        CIdr = 650,
        Real = 700,
        Double = 701,
        Circle = 718,
        Money = 790,
        MacAddr = 829,
        Inet = 869,
        Char = 1042,
        VarChar = 1043,
        Date = 1082,
        Time = 1083,
        TimeStamp = 1114,
        TimeStampTZ = 1184,
        Interval = 1186,
        TimeTZ = 1266,
        Bit = 1560,
        VarBit = 1562,
        Numeric = 1700,
        Uuid = 2950,
        IntRange = 3904,
        NumericRange = 3906,
        TimeStampRange = 3908,
        TimeStampTZRange = 3910,
        DateRange = 3912,
        BigIntRange = 3926
    }
    enum Firebird {
        Array = 0,
        BigInt = 1,
        Binary = 2,
        Boolean = 3,
        Char = 4,
        Date = 5,
        Decimal = 6,
        Double = 7,
        Float = 8,
        Guid = 9,
        Integer = 10,
        Numeric = 11,
        SmallInt = 12,
        Text = 13,
        Time = 14,
        TimeStamp = 15,
        VarChar = 16
    }
    enum Informix {
        Char = 0,
        SmallInt = 1,
        Integer = 2,
        Float = 3,
        SmallFloat = 4,
        Real = 4,
        Decimal = 5,
        Serial = 6,
        Date = 7,
        Money = 8,
        Null = 9,
        DateTime = 10,
        Byte = 11,
        Text = 12,
        VarChar = 13,
        NChar = 15,
        NVarChar = 16,
        Int8 = 17,
        Serial8 = 18,
        Other = 99,
        LVarChar = 101,
        LongVarChar = 101,
        Blob = 110,
        Clob = 111,
        Boolean = 126,
        Invalid = 200,
        BigInt = 203,
        Double = 205,
        Numeric = 208,
        Time = 210,
        Timestamp = 211,
        Binary = 215,
        VarBinary = 216,
        LongVarBinary = 217,
        BigSerial = 230
    }
    enum MySql {
        Decimal = 0,
        Byte = 1,
        Int16 = 2,
        Int32 = 3,
        Float = 4,
        Double = 5,
        Timestamp = 7,
        Int64 = 8,
        Int24 = 9,
        Date = 10,
        Time = 11,
        DateTime = 12,
        Year = 13,
        Newdate = 14,
        VarString = 15,
        Bit = 16,
        NewDecimal = 246,
        Enum = 247,
        Set = 248,
        TinyBlob = 249,
        MediumBlob = 250,
        LongBlob = 251,
        Blob = 252,
        VarChar = 253,
        String = 254,
        Geometry = 255,
        UByte = 501,
        UInt16 = 502,
        UInt32 = 503,
        UInt64 = 508,
        UInt24 = 509,
        Binary = 600,
        VarBinary = 601,
        TinyText = 749,
        MediumText = 750,
        LongText = 751,
        Text = 752,
        Guid = 800
    }
    enum MsSql {
        BigInt = 0,
        Binary = 1,
        Bit = 2,
        Char = 3,
        DateTime = 4,
        Decimal = 5,
        Float = 6,
        Image = 7,
        Int = 8,
        Money = 9,
        NChar = 10,
        NText = 11,
        NVarChar = 12,
        Real = 13,
        UniqueIdentifier = 14,
        SmallDateTime = 15,
        SmallInt = 16,
        SmallMoney = 17,
        Text = 18,
        Timestamp = 19,
        TinyInt = 20,
        VarBinary = 21,
        VarChar = 22,
        Variant = 23,
        Xml = 25,
        Udt = 29,
        Structured = 30,
        Date = 31,
        Time = 32,
        DateTime2 = 33,
        DateTimeOffset = 34
    }
    enum Odbc {
        BigInt = 1,
        Binary = 2,
        Bit = 3,
        Char = 4,
        DateTime = 5,
        Decimal = 6,
        Numeric = 7,
        Double = 8,
        Image = 9,
        Int = 10,
        NChar = 11,
        NText = 12,
        NVarChar = 13,
        Real = 14,
        UniqueIdentifier = 15,
        SmallDateTime = 16,
        SmallInt = 17,
        Text = 18,
        Timestamp = 19,
        TinyInt = 20,
        VarBinary = 21,
        VarChar = 22,
        Date = 23,
        Time = 24
    }
    enum OleDb {
        Empty = 0,
        SmallInt = 2,
        Integer = 3,
        Single = 4,
        Double = 5,
        Currency = 6,
        Date = 7,
        BSTR = 8,
        IDispatch = 9,
        Error = 10,
        Boolean = 11,
        Variant = 12,
        IUnknown = 13,
        Decimal = 14,
        TinyInt = 16,
        UnsignedTinyInt = 17,
        UnsignedSmallInt = 18,
        UnsignedInt = 19,
        BigInt = 20,
        UnsignedBigInt = 21,
        Filetime = 64,
        Guid = 72,
        Binary = 128,
        Char = 129,
        WChar = 130,
        Numeric = 131,
        DBDate = 133,
        DBTime = 134,
        DBTimeStamp = 135,
        PropVariant = 138,
        VarNumeric = 139,
        VarChar = 200,
        LongVarChar = 201,
        VarWChar = 202,
        LongVarWChar = 203,
        VarBinary = 204,
        LongVarBinary = 205
    }
    enum Oracle {
        BFile = 101,
        Blob = 102,
        Byte = 103,
        Char = 104,
        Clob = 105,
        Date = 106,
        Decimal = 107,
        Double = 108,
        Long = 109,
        LongRaw = 110,
        Int16 = 111,
        Int32 = 112,
        Int64 = 113,
        IntervalDS = 114,
        IntervalYM = 115,
        NClob = 116,
        NChar = 117,
        NVarchar2 = 119,
        Raw = 120,
        RefCursor = 121,
        Single = 122,
        TimeStamp = 123,
        TimeStampLTZ = 124,
        TimeStampTZ = 125,
        Varchar2 = 126,
        XmlType = 127,
        BinaryDouble = 132,
        BinaryFloat = 133
    }
    enum OracleClient {
        BFile = 1,
        Blob = 2,
        Char = 3,
        Clob = 4,
        Cursor = 5,
        DateTime = 6,
        IntervalDayToSecond = 7,
        IntervalYearToMonth = 8,
        LongRaw = 9,
        LongVarChar = 10,
        NChar = 11,
        NClob = 12,
        Number = 13,
        NVarChar = 14,
        Raw = 15,
        RowId = 16,
        Timestamp = 18,
        TimestampLocal = 19,
        TimestampWithTZ = 20,
        VarChar = 22,
        Byte = 23,
        UInt16 = 24,
        UInt32 = 25,
        SByte = 26,
        Int16 = 27,
        Int32 = 28,
        Float = 29,
        Double = 30
    }
    enum PostgreSql {
        Array = -2147483648,
        Bigint = 1,
        Boolean = 2,
        Box = 3,
        Bytea = 4,
        Circle = 5,
        Char = 6,
        Date = 7,
        Double = 8,
        Integer = 9,
        Line = 10,
        LSeg = 11,
        Money = 12,
        Numeric = 13,
        Path = 14,
        Point = 15,
        Polygon = 16,
        Real = 17,
        Smallint = 18,
        Text = 19,
        Time = 20,
        Timestamp = 21,
        Varchar = 22,
        Refcursor = 23,
        Inet = 24,
        Bit = 25,
        TimestampTZ = 26,
        Uuid = 27,
        Xml = 28,
        Oidvector = 29,
        Interval = 30,
        TimeTZ = 31,
        Name = 32,
        Abstime = 33,
        MacAddr = 34,
        Json = 35,
        Jsonb = 36,
        Hstore = 37
    }
    enum SqlCe {
        BigInt = 0,
        Binary = 1,
        Bit = 2,
        Char = 3,
        DateTime = 4,
        Decimal = 5,
        Float = 6,
        Image = 7,
        Int = 8,
        Money = 9,
        NChar = 10,
        NText = 11,
        NVarChar = 12,
        Real = 13,
        UniqueIdentifier = 14,
        SmallDateTime = 15,
        SmallInt = 16,
        SmallMoney = 17,
        Text = 18,
        Timestamp = 19,
        TinyInt = 20,
        VarBinary = 21,
        VarChar = 22,
        Variant = 23,
        Xml = 25,
        Udt = 29,
        Structured = 30,
        Date = 31,
        Time = 32,
        DateTime2 = 33,
        DateTimeOffset = 34
    }
    enum SqLite {
        Uninitialized = 0,
        Int64 = 1,
        Double = 2,
        Text = 3,
        Blob = 4,
        Null = 5,
        DateTime = 10,
        None = 11
    }
    enum Sybase {
        UnsignedBigInt = -208,
        UnsignedInt = -207,
        UnsignedSmallInt = -206,
        NVarChar = -205,
        NChar = -204,
        TimeStamp = -203,
        SmallDateTime = -202,
        SmallMoney = -201,
        Money = -200,
        Unitext = -10,
        UniVarChar = -9,
        UniChar = -8,
        Bit = -7,
        TinyInt = -6,
        BigInt = -5,
        Image = -4,
        VarBinary = -3,
        Binary = -2,
        Text = -1,
        Unsupported = 0,
        Char = 1,
        Numeric = 2,
        Decimal = 3,
        Integer = 4,
        SmallInt = 5,
        Real = 7,
        Double = 8,
        VarChar = 12,
        Date = 91,
        Time = 92,
        BigDateTime = 93,
        DateTime = 93
    }
    enum Teradata {
        BigInt = 90,
        Blob = 100,
        Byte = 110,
        ByteInt = 120,
        Char = 130,
        Clob = 140,
        Date = 150,
        Decimal = 160,
        Double = 170,
        Graphic = 180,
        Integer = 190,
        IntervalDay = 200,
        IntervalDayToHour = 210,
        IntervalDayToMinute = 220,
        IntervalDayToSecond = 230,
        IntervalHour = 240,
        IntervalHourToMinute = 250,
        IntervalHourToSecond = 260,
        IntervalMinute = 270,
        IntervalMinuteToSecond = 280,
        IntervalSecond = 290,
        IntervalYear = 300,
        IntervalYearToMonth = 310,
        IntervalMonth = 320,
        SmallInt = 330,
        Time = 340,
        TimeWithZone = 350,
        Timestamp = 360,
        TimestampWithZone = 370,
        VarByte = 380,
        VarChar = 390,
        VarGraphic = 400,
        PeriodDate = 410,
        PeriodTime = 420,
        PeriodTimeWithTimeZone = 430,
        PeriodTimestamp = 440,
        PeriodTimestampWithTimeZone = 450,
        Number = 460,
        Xml = 480,
        Json = 500,
        AnyType = 65535
    }
    enum Universal {
        Array = 0,
        BigInt = 1,
        Binary = 2,
        Bit = 3,
        Blob = 4,
        Boolean = 5,
        Byte = 6,
        Char = 7,
        Clob = 8,
        Currency = 9,
        Cursor = 10,
        Date = 11,
        DateTime = 12,
        Decimal = 13,
        Double = 14,
        Guid = 15,
        Int = 16,
        IntervalDS = 17,
        IntervalYM = 18,
        NChar = 19,
        NClob = 20,
        NVarChar = 21,
        Object = 22,
        Single = 23,
        SmallInt = 24,
        TinyInt = 25,
        Time = 26,
        TimeStamp = 27,
        VarChar = 28,
        Xml = 29,
        TimeStampTZ = 30,
        DateTime2 = 31
    }
    enum VistaDb {
        Uninitialized = -1,
        Char = 1,
        NChar = 2,
        VarChar = 3,
        NVarChar = 4,
        Text = 5,
        NText = 6,
        TinyInt = 8,
        SmallInt = 9,
        Int = 10,
        BigInt = 11,
        Real = 12,
        Float = 13,
        Decimal = 14,
        Money = 15,
        SmallMoney = 16,
        Bit = 17,
        DateTime = 19,
        Image = 20,
        UniqueIdentifier = 22,
        SmallDateTime = 23,
        Timestamp = 24,
        Binary = 25,
        VarBinary = 26,
        Time = 27,
        Date = 28,
        DateTime2 = 29,
        DateTimeOffset = 30,
        Unknown = 31
    }
    enum Pdo {
        String = 0
    }
}
export namespace Stimulsoft.ExternalLibrary.XLSX {
    interface IProperties {
        LastAuthor?: string;
        Author?: string;
        CreatedDate?: Date;
        ModifiedDate?: Date;
        Application?: string;
        AppVersion?: string;
        Company?: string;
        DocSecurity?: string;
        Manager?: string;
        HyperlinksChanged?: boolean;
        SharedDoc?: boolean;
        LinksUpToDate?: boolean;
        ScaleCrop?: boolean;
        Worksheets?: number;
        SheetNames?: string[];
    }
    interface IParsingOptions {
        cellFormula?: boolean;
        cellHTML?: boolean;
        cellNF?: boolean;
        cellStyles?: boolean;
        cellDates?: boolean;
        sheetStubs?: boolean;
        sheetRows?: number;
        bookDeps?: boolean;
        bookFiles?: boolean;
        bookProps?: boolean;
        bookSheets?: boolean;
        bookVBA?: boolean;
        password?: string;
        type?: string;
    }
    interface IWorkBook {
        Sheets: {
            [sheet: string]: IWorkSheet;
        };
        SheetNames: string[];
        Props: IProperties;
    }
    interface IWorkSheet {
        [cell: string]: IWorkSheetCell;
    }
    interface IWorkSheetCell {
        t: string;
        v: string;
        r?: string;
        h?: string;
        w?: string;
        f?: string;
        c?: string;
        z?: string;
        l?: string;
        s?: string;
    }
    interface IUtils {
        sheet_to_json<T>(worksheet: IWorkSheet): T[];
        sheet_to_csv(worksheet: IWorkSheet): any;
        sheet_to_formulae(worksheet: IWorkSheet): any;
    }
    let utils: IUtils;
    function readFile(filename: string, opts?: IParsingOptions): IWorkBook;
    function read(data: any, opts?: IParsingOptions): IWorkBook;
}
export namespace Stimulsoft.Base.Data.Connectors {
    class StiConnectionStringHelper {
        static getConnectionStringKey(connectionString: string, key: string, separators?: string[]): string;
        static getConnectionStringKey2(connectionString: string): string;
        static setConnectionStringKey(connectionString: string, key: string, value: string): string;
        static removeConnectionStringKey(connectionString: string, key: string): string;
    }
}
export namespace Stimulsoft.Base {
    class StiDataConnector {
        static advancedRetrievalModeOfDatabaseSchema: boolean;
        static getSchemaColumnsMode: boolean;
        connectionIdent: StiConnectionIdent;
        connectionOrder: StiConnectionOrder;
        name: string;
        nuGetPackages: string[];
        nuGetVersion: string;
        isAvailable: boolean;
        resetSettings(): void;
        getFamilyConnectors(): StiDataConnector[];
    }
}
export namespace Stimulsoft.Base {
    class StiDataLoaderHelperData {
        name: string;
        array: any;
        toList(): StiDataLoaderHelperData[];
        constructor(name: string, array: any);
    }
    class StiDataLoaderHelper {
        static loadMultiple(path: string, fileExt: string, binary: boolean, headers: {
            key: string;
            value: string;
        }[], withCredentials?: boolean): StiDataLoaderHelperData[];
        static loadSingle(path: string, binary: boolean, headers: {
            key: string;
            value: string;
        }[], withCredentials?: boolean): StiDataLoaderHelperData;
    }
}
export namespace Stimulsoft.Base {
    class StiDataOptions {
        static readonly SampleConnectionString: {
            dataWorld: string;
            oData: string;
            quickBooks: string;
            graphQL: string;
            azureSql: string;
            cosmosSql: string;
            bigQuery: string;
            firebase: string;
            mongoDb: string;
            db2: string;
            firebird: string;
            informix: string;
            msAccess: string;
            mySql: string;
            odbc: string;
            oleDb: string;
            oracle: string;
            postgreSql: string;
            sqlCe: string;
            msSql: string;
            sqLite: string;
            sybase: string;
            sybaseAds: string;
            teradata: string;
            vistaDb: string;
            googleAnalytics: string;
            azureTableStorage: string;
            azureBlobStorage: string;
            cDataConnectCloud: string;
        };
    }
}
export namespace Stimulsoft.Base {
    class StiFileUrlHelper {
        static get(path: string): number[];
    }
}
export namespace Stimulsoft.Base {
    import DataSet = Stimulsoft.System.Data.DataSet;
    class StiFileDataConnector extends StiDataConnector {
        fileType: StiFileType;
        retrieveSchema(options: StiFileDataOptions): StiDataSchema;
        testConnection(options: StiFileDataOptions): StiTestConnectionResult;
        getDataSet(options: StiFileDataOptions): DataSet;
        static get(ident: StiConnectionIdent): StiFileDataConnector;
    }
}
export namespace Stimulsoft.Base {
    import DataSet = Stimulsoft.System.Data.DataSet;
    class StiCsvConnector extends StiFileDataConnector {
        connectionIdent: StiConnectionIdent;
        connectionOrder: StiConnectionOrder;
        name: string;
        isAvailable: boolean;
        fileType: StiFileType;
        getDataSet(options: StiFileDataOptions): DataSet;
        private getDataSetFromPath;
        static get(): StiCsvConnector;
    }
}
export namespace Stimulsoft.Base {
    import DataSet = Stimulsoft.System.Data.DataSet;
    class StiDBaseConnector extends StiFileDataConnector {
        connectionIdent: StiConnectionIdent;
        connectionOrder: StiConnectionOrder;
        name: string;
        isAvailable: boolean;
        fileType: StiFileType;
        getDataSet(options: StiFileDataOptions): DataSet;
        static get(): StiDBaseConnector;
    }
}
export namespace Stimulsoft.Base {
    import DataSet = Stimulsoft.System.Data.DataSet;
    class StiExcelConnector extends StiFileDataConnector {
        connectionIdent: StiConnectionIdent;
        connectionOrder: StiConnectionOrder;
        name: string;
        isAvailable: boolean;
        fileType: StiFileType;
        getDataSet(options: StiFileDataOptions): DataSet;
        static get(): StiExcelConnector;
    }
}
export namespace Stimulsoft.Base {
    import DataSet = Stimulsoft.System.Data.DataSet;
    class StiGisConnector extends StiFileDataConnector {
        connectionIdent: StiConnectionIdent;
        connectionOrder: StiConnectionOrder;
        name: string;
        isAvailable: boolean;
        fileType: StiFileType;
        getDataSet(options: StiFileDataOptions): DataSet;
        static get(): StiGisConnector;
    }
}
export namespace Stimulsoft.Base {
    import DataSet = Stimulsoft.System.Data.DataSet;
    class StiJsonConnector extends StiFileDataConnector {
        connectionIdent: StiConnectionIdent;
        connectionOrder: StiConnectionOrder;
        name: string;
        isAvailable: boolean;
        fileType: StiFileType;
        getDataSet(options: StiFileDataOptions): DataSet;
        static get(): StiJsonConnector;
    }
}
export namespace Stimulsoft.Base {
    import DataSet = Stimulsoft.System.Data.DataSet;
    class StiXmlConnector extends StiFileDataConnector {
        connectionIdent: StiConnectionIdent;
        connectionOrder: StiConnectionOrder;
        name: string;
        isAvailable: boolean;
        fileType: StiFileType;
        getDataSet(options: StiFileDataOptions): DataSet;
        static get(): StiXmlConnector;
    }
}
export namespace Stimulsoft.Base {
    import DataTable = Stimulsoft.System.Data.DataTable;
    import DataSet = Stimulsoft.System.Data.DataSet;
    class StiCsvHelper {
        static codePageCodes: number[];
        static codePageNames: string[];
        static getTable(path: string, codePage?: number, separator?: string, maxDataRows?: number): DataTable;
        static getDataSet(data: number[], tableName: string, codePage: number, separator: string, maxDataRows?: number): DataSet;
        static getTable2(data: number[], codePage?: number, separator?: string, loadData?: boolean, maxDataRows?: number): DataTable;
        private static splitToColumns;
    }
}
export namespace Stimulsoft.Base {
    class StiDataNameValidator {
        static correct(str: string): string;
    }
}
export namespace Stimulsoft.Base {
    import DataSet = Stimulsoft.System.Data.DataSet;
    class StiExcelHelper {
        static getDataSetFromExcelDocument(content: number[], firstRowIsHeader: boolean): DataSet;
        private static getNumber;
        private static getType;
        private static getTicksForTimeSpan;
        private static isTimeSpan;
        private static getTimeSpan;
    }
}
export namespace Stimulsoft.Base {
    class StiFileItemTable {
        static defaultCsvTableName: string;
        static defaultDBaseTableName: string;
    }
}
export namespace Stimulsoft.Base {
    import DataSet = Stimulsoft.System.Data.DataSet;
    class StiFileDataOptions {
        content: number[] | Uint8Array | string;
        dataSet: DataSet;
        constructor(content: number[] | string | Uint8Array);
    }
}
export namespace Stimulsoft.Base {
    class StiCsvOptions extends StiFileDataOptions {
        maxDataRows: number;
        path: string;
        tableName: string;
        codePage: number;
        separator: string;
        constructor(content: number[], tableName: string, codePage?: number, separator?: string);
    }
}
export namespace Stimulsoft.Base {
    class StiDBaseOptions extends StiFileDataOptions {
        maxDataRows: number;
        path: string;
        tableName: string;
        codePage: number;
        constructor(content: number[], tableName: string, codePage?: number);
    }
}
export namespace Stimulsoft.Base {
    class StiExcelOptions extends StiFileDataOptions {
        firstRowIsHeader: boolean;
        constructor(content: number[], firstRowIsHeader?: boolean);
    }
}
export namespace Stimulsoft.Base {
    class StiGisOptions extends StiFileDataOptions {
        separator: string;
        constructor(content: number[] | string, separator: string);
    }
}
export namespace Stimulsoft.Base {
    class StiJsonOptions extends StiFileDataOptions {
        relationDirection: StiRelationDirection;
        constructor(content: number[] | string, relationDirection?: StiRelationDirection);
    }
}
export namespace Stimulsoft.Base {
    class StiXmlOptions extends StiFileDataOptions {
        schema: number[] | string;
        isAdoNet: boolean;
        relationDirection: StiRelationDirection;
        constructor(schema: number[] | string, content: number[] | string, isAdoNet: boolean, relationDirection: StiRelationDirection);
    }
}
export namespace Stimulsoft.Base {
    import DataTable = Stimulsoft.System.Data.DataTable;
    class StiDataWorldConnector extends StiDataConnector {
        getColumns(collectionName: string): StiDataColumnSchema[];
        getDataTable(collectionName: string, query: string): DataTable;
        getSampleConnectionString(): string;
        retrieveSchema(allowException?: boolean): StiDataSchema;
        testConnection(): StiTestConnectionResult;
        static get(connectionString: string): StiDataWorldConnector;
        connectionString: string;
        constructor(connectionString: string);
    }
}
export namespace Stimulsoft.Base {
    import List = Stimulsoft.System.Collections.List;
    import DataTable = Stimulsoft.System.Data.DataTable;
    class StiDataWorldHelper {
        urlBase: string;
        private getDefaultWebClient;
        getTableNames(): List<string>;
        getColumns(collectionName: string): List<StiDataColumnSchema>;
        getDataTable(collectionName: string, query: string): DataTable;
        testConnection(): StiTestConnectionResult;
        retrieveSchema(): StiDataSchema;
        private getConnectionStringKey;
        private getConnectionStringKey1;
        connectionString: string;
        get owner(): string;
        get token(): string;
        get database(): string;
        constructor(connectionString: string);
    }
}
export namespace Stimulsoft.Base {
    class StiObjectSchema {
        name: string;
    }
}
export namespace Stimulsoft.Base {
    import List = Stimulsoft.System.Collections.List;
    import DataSet = Stimulsoft.System.Data.DataSet;
    class StiDataSchema extends StiObjectSchema {
        tables: List<StiDataTableSchema>;
        views: List<StiDataTableSchema>;
        storedProcedures: List<StiDataTableSchema>;
        queries: List<StiDataTableSchema>;
        relations: List<StiDataRelationSchema>;
        connectionIdent: StiConnectionIdent;
        isEmpty(): boolean;
        getDataSet(): DataSet;
        sort(): StiDataSchema;
        constructor(ident?: StiConnectionIdent);
    }
}
export namespace Stimulsoft.Base {
    import List = Stimulsoft.System.Collections.List;
    import DataTable = Stimulsoft.System.Data.DataTable;
    import Type = Stimulsoft.System.Type;
    class StiODataHelper {
        connectionString: string;
        get address(): string;
        get userName(): string;
        get password(): string;
        get addressBearer(): string;
        get clientId(): string;
        headers: {
            key: string;
            value: string;
        }[];
        private getConnectionStringKey;
        private getConnectionStringKey1;
        private bearerAccessToken;
        retrieveSchema(): StiDataSchema;
        fillDataTable(table: DataTable, query: string): void;
        testConnection(): StiTestConnectionResult;
        getColumns(collectionName: string): List<StiDataColumnSchema>;
        static getNetType(dbType: string): Type;
        static getBearerAccessToken(url: string, userName: string, password: string, clientId: string): string;
        private getDefaultWebClient;
        constructor(connectionString: string);
    }
}
export namespace Stimulsoft.Base {
    import DataTable = Stimulsoft.System.Data.DataTable;
    class StiQuickBooksConnector {
        private stimulsoftClientId;
        private stimulsoftClientSecret;
        private oauth2Url;
        private bearerUrl;
        private baseUrl;
        private stimulsoftRedirectUrl;
        private responseType;
        private scope;
        private state;
        connectionString: string;
        connectionIdent: StiConnectionIdent;
        connectionOrder: StiConnectionOrder;
        name: string;
        isAvailable: boolean;
        get useApp(): boolean;
        set useApp(value: boolean);
        get clientId(): string;
        set clientId(value: string);
        get clientIdPrivate(): string;
        set clientIdPrivate(value: string);
        get clientSecret(): string;
        set clientSecret(value: string);
        get clientSecretPrivate(): string;
        set clientSecretPrivate(value: string);
        get redirectURL(): string;
        set redirectURL(value: string);
        get redirectURLPrivate(): string;
        set redirectURLPrivate(value: string);
        get authorizationCode(): string;
        set authorizationCode(value: string);
        get realmId(): string;
        set realmId(value: string);
        get accessToken(): string;
        set accessToken(value: string);
        get refreshToken(): string;
        set refreshToken(value: string);
        connectionTimeout: number;
        fillAuthorizationCode(): void;
        private getDefaultWebClient;
        private getAuthorizationUrl;
        fillTokens(): void;
        refreshAccessToken(): void;
        private getTableNames;
        private getColumns;
        retrieveSchema(allowException?: boolean): StiDataSchema;
        getDataTable(collectionName: string, query: string): DataTable;
        fillDataTable(table: DataTable, query: string): void;
        private executeQuery;
        private removeUnsupportedColumns;
        private correctRefColumns;
        getSampleConnectionString(): string;
        static Get(connectionString?: string): StiQuickBooksConnector;
        constructor(connectionString?: string);
    }
}
export namespace Stimulsoft.Base {
    class StiTestConnectionResult {
        success: boolean;
        notice: string;
        static makeWrong(notice: string): StiTestConnectionResult;
        static makeWrong2(exception: string): StiTestConnectionResult;
        static makeWrong3(): StiTestConnectionResult;
        static makeFine(): StiTestConnectionResult;
    }
}
export namespace Stimulsoft.Base {
    class StiDataColumnSchema extends StiObjectSchema {
        type: Stimulsoft.System.Type;
        constructor(name: string, type: Stimulsoft.System.Type);
    }
}
export namespace Stimulsoft.Base {
    class StiDataParameterSchema extends StiObjectSchema {
        type: Stimulsoft.System.Type;
        value: any;
        constructor(name?: string, type?: Stimulsoft.System.Type);
    }
}
export namespace Stimulsoft.Base {
    class StiDataRelationSchema {
        name: string;
        parentSourceName: string;
        childSourceName: string;
        parentColumns: string[];
        childColumns: string[];
        constructor(name: string, parentSourceName: string, childSourceName: string, parentColumns: string[], childColumns: string[]);
    }
}
export namespace Stimulsoft.Base {
    class StiDataTableSchema extends StiObjectSchema {
        columns: StiDataColumnSchema[];
        parameters: StiDataParameterSchema[];
        query: string;
        static newTableOrView(name: string): StiDataTableSchema;
        static newTable(name: string): StiDataTableSchema;
        static newView(name: string): StiDataTableSchema;
        static newProcedure(name: string): StiDataTableSchema;
        constructor(name?: string, query?: string);
    }
}
export namespace Stimulsoft.Base.Design {
    let IStiDefault: System.Interface<IStiDefault>;
    interface IStiDefault {
        isDefault(): boolean;
    }
}
export namespace Stimulsoft.Base.Drawing {
    enum StiCheckState {
        Unchecked = 1,
        Checked = 2,
        Indeterminate = 3
    }
    enum StiAction {
        None = 0,
        Move = 1,
        Select = 2,
        SizeLeft = 3,
        SizeRight = 4,
        SizeTop = 5,
        SizeBottom = 6,
        SizeLeftTop = 7,
        SizeLeftBottom = 8,
        SizeRightTop = 9,
        SizeRightBottom = 10,
        ResizeColumns = 11,
        ResizeRows = 12,
        SelectColumn = 13,
        SelectRow = 14
    }
    enum StiBorderSides {
        None = 0,
        All = 15,
        Top = 1,
        Left = 2,
        Right = 4,
        Bottom = 8
    }
    enum StiPenStyle {
        Solid = 0,
        Dash = 1,
        DashDot = 2,
        DashDotDot = 3,
        Dot = 4,
        Double = 5,
        None = 6
    }
    enum StiRotationMode {
        LeftTop = 0,
        LeftCenter = 1,
        LeftBottom = 2,
        CenterTop = 3,
        CenterCenter = 4,
        CenterBottom = 5,
        RightTop = 6,
        RightCenter = 7,
        RightBottom = 8
    }
    enum StiShadowSides {
        Top = 1,
        Right = 2,
        Edge = 4,
        Bottom = 8,
        Left = 16,
        All = 31
    }
    enum StiVertAlignment {
        Top = 0,
        Center = 1,
        Bottom = 2
    }
    enum StiTextHorAlignment {
        Left = 0,
        Center = 1,
        Right = 2,
        Width = 3
    }
    enum StiHorAlignment {
        Left = 1,
        Center = 2,
        Right = 3
    }
    enum StiTextDockMode {
        Top = 0,
        Bottom = 1,
        Left = 2,
        Right = 3
    }
    enum StiBrushIdent {
        Empty = 1,
        Solid = 2,
        Gradient = 3,
        Glare = 4,
        Glass = 5,
        Hatch = 6,
        Default = 7,
        Style = 8
    }
    enum StiBorderIdent {
        Border = 1,
        AdvancedBorder = 2
    }
    enum StiCapStyle {
        None = 0,
        Arrow = 1,
        Open = 2,
        Stealth = 3,
        Diamond = 4,
        Square = 5,
        Oval = 6
    }
    enum StiTableColumnVisibility {
        True = 0,
        TrueAndHidden = 1,
        False = 2,
        Expression = 3
    }
    enum StiCardsColumnVisibility {
        True = 0,
        False = 1,
        Expression = 2
    }
    enum StiButtonShapeType {
        Rectangle = 0,
        Circle = 1
    }
}
export namespace Stimulsoft.Base.Drawing {
    let PointD: typeof System.Drawing.Point;
}
export namespace Stimulsoft.Base.Drawing {
    let RectangleD: typeof System.Drawing.Rectangle;
}
export namespace Stimulsoft.Base.Drawing {
    let SizeD: typeof System.Drawing.Size;
}
export namespace Stimulsoft.Base.Drawing {
    import Point = Stimulsoft.System.Drawing.Point;
    import Rectangle = Stimulsoft.System.Drawing.Rectangle;
    class StiActionUtils {
        static pointInEdge(x: number, y: number, point: Point, size: number): boolean;
        static pointInRect(x: number, y: number, rect: Rectangle): boolean;
    }
}
export namespace Stimulsoft.Base.Drawing {
    import IAsIs = Stimulsoft.System.IAsIs;
    import ICloneable = Stimulsoft.System.ICloneable;
    import Color = Stimulsoft.System.Drawing.Color;
    import Brush = Stimulsoft.System.Drawing.Brush;
    import Rectangle = Stimulsoft.System.Drawing.Rectangle;
    class StiBrush implements ICloneable, IAsIs {
        implements(): any[];
        is<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): this is T;
        is2<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): boolean;
        as<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): T;
        clone(): StiBrush;
        memberwiseClone(): StiBrush;
        equals(obj: any): boolean;
        static convertToBrush(text: string): StiBrush;
        static loadFromXml(text: string): StiBrush;
        static light(baseBrush: StiBrush, value: number): StiBrush;
        static dark(baseBrush: StiBrush, value: number): StiBrush;
        static getBrush(brush: StiBrush, rect: Rectangle): Brush;
        static toColor(brush: StiBrush): Color;
        static isEmpty(brush: StiBrush): boolean;
        static isTransparent(brush: StiBrush): boolean;
    }
}
export namespace Stimulsoft.Base.Drawing {
    import Color = Stimulsoft.System.Drawing.Color;
    class StiSolidBrush extends StiBrush {
        memberwiseClone(): StiBrush;
        color: Color;
        constructor(color?: Color);
    }
}
export namespace Stimulsoft.Base.Drawing {
    import IAsIs = Stimulsoft.System.IAsIs;
    import Rectangle = Stimulsoft.System.Drawing.Rectangle;
    import Color = Stimulsoft.System.Drawing.Color;
    import ICloneable = Stimulsoft.System.ICloneable;
    import Graphics = Stimulsoft.System.Drawing.Graphics;
    class StiBorder implements ICloneable, IAsIs {
        implements(): any[];
        is<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): this is T;
        is2<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): boolean;
        as<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): T;
        private bits;
        clone(): StiBorder;
        equals(obj: StiBorder | any): boolean;
        getSizeOffset(): number;
        getHashCode(): number;
        private defaultHashCode;
        getSizeIncludingSide(): number;
        draw(g: Graphics, rect: Rectangle, zoom: number, emptyColor?: Color, drawBorderFormatting?: boolean, drawBorderSides?: boolean): void;
        drawBorderShadow(g: Graphics, rect: Rectangle, zoom: number): void;
        get isTopBorderSidePresent(): boolean;
        get isBottomBorderSidePresent(): boolean;
        get isLeftBorderSidePresent(): boolean;
        get isRightBorderSidePresent(): boolean;
        get isAllBorderSidesPresent(): boolean;
        private get isDefaultShadowBrush();
        get side(): StiBorderSides;
        set side(value: StiBorderSides);
        get color(): Color;
        set color(value: Color);
        get size(): number;
        set size(value: number);
        get style(): StiPenStyle;
        set style(value: StiPenStyle);
        private _shadowBrush;
        get shadowBrush(): StiBrush;
        set shadowBrush(value: StiBrush);
        get shadowSize(): number;
        set shadowSize(value: number);
        get dropShadow(): boolean;
        set dropShadow(value: boolean);
        get topmost(): boolean;
        set topmost(value: boolean);
        isDefault(): boolean;
        static loadFromXml(text: string): StiBorder;
        constructor(side?: StiBorderSides, color?: Color, size?: number, style?: StiPenStyle, dropShadow?: boolean, shadowSize?: number, shadowBrush?: StiBrush, topmost?: boolean);
    }
}
export namespace Stimulsoft.Base.Drawing {
    import Color = Stimulsoft.System.Drawing.Color;
    class StiAdvancedBorder extends StiBorder {
        clone(): StiAdvancedBorder;
        equals(obj: StiAdvancedBorder | any): boolean;
        getHashCode(): number;
        private _leftSide;
        get leftSide(): StiBorderSide;
        private _rightSide;
        get rightSide(): StiBorderSide;
        private _topSide;
        get topSide(): StiBorderSide;
        private _bottomSide;
        get bottomSide(): StiBorderSide;
        get isTopBorderSidePresent(): boolean;
        get isBottomBorderSidePresent(): boolean;
        get isLeftBorderSidePresent(): boolean;
        get isRightBorderSidePresent(): boolean;
        get isAllBorderSidesPresent(): boolean;
        get side(): StiBorderSides;
        set side(value: StiBorderSides);
        get color(): Color;
        set color(value: Color);
        get size(): number;
        set size(value: number);
        get style(): StiPenStyle;
        set style(value: StiPenStyle);
        isDefault(): boolean;
        constructor(topSide?: StiBorderSide, bottomSide?: StiBorderSide, leftSide?: StiBorderSide, rightSide?: StiBorderSide, dropShadow?: boolean, shadowSize?: number, shadowBrush?: StiBrush, topmost?: boolean);
    }
}
export namespace Stimulsoft.Report.Helpers {
    enum StiFontIconSet {
        Rating = 0,
        Quarter = 1,
        Square = 2,
        Star = 3,
        Latin = 4
    }
    enum StiFontIconGroup {
        WebApplicationIcons = 0,
        AccessibilityIcons = 1,
        HandIcons = 2,
        TransportationIcons = 3,
        GenderIcons = 4,
        FileTypeIcons = 5,
        SpinnerIcons = 6,
        FormControlIcons = 7,
        PaymentIcons = 8,
        ChartIcons = 9,
        CurrencyIcons = 10,
        TextEditorIcons = 11,
        DirectionalIcons = 12,
        VideoPlayerIcons = 13,
        BrandIcons = 14,
        MedicalIcons = 15,
        OtherIcons = 16
    }
    enum StiFontIcons {
        Latin5 = 0,
        Latin4 = 1,
        Latin3 = 2,
        Latin2 = 3,
        Latin1 = 4,
        QuarterFull = 5,
        QuarterThreeFourth = 6,
        QuarterHalf = 7,
        QuarterQuarter = 8,
        QuarterNone = 9,
        Rating4 = 10,
        Rating3 = 11,
        Rating2 = 12,
        Rating1 = 13,
        Rating0 = 14,
        Square0 = 15,
        Square1 = 16,
        Square2 = 17,
        Square3 = 18,
        Square4 = 19,
        StarFull = 20,
        StarThreeFourth = 21,
        StarHalf = 22,
        StarQuarter = 23,
        StarNone = 24,
        ArrowDown = 25,
        ArrowRight = 26,
        ArrowRightDown = 27,
        ArrowRightUp = 28,
        ArrowUp = 29,
        Check = 30,
        Circle = 31,
        CircleCheck = 32,
        CircleCross = 33,
        CircleExclamation = 34,
        Cross = 35,
        Rhomb = 36,
        Exclamation = 37,
        Flag = 38,
        Minus = 39,
        Triangle = 40,
        TriangleDown = 41,
        TriangleUp = 42,
        Home = 43,
        Cart = 44,
        Phone = 45,
        Mobile = 46,
        Mug = 47,
        Airplane = 48,
        Man = 49,
        Woman = 50,
        UserTie = 51,
        Truck = 52,
        Earth = 53,
        ManWoman = 54,
        Appleinc = 55,
        Windows8 = 56,
        Glass = 57,
        Music = 58,
        Search = 59,
        EnvelopeO = 60,
        Heart = 61,
        Star = 62,
        StarO = 63,
        User = 64,
        Film = 65,
        ThLarge = 66,
        Th = 67,
        ThList = 68,
        Times = 69,
        SearchPlus = 70,
        SearchMinus = 71,
        PowerOff = 72,
        Signal = 73,
        Cog = 74,
        TrashO = 75,
        FileO = 76,
        ClockO = 77,
        Road = 78,
        Download = 79,
        ArrowCircleODown = 80,
        ArrowCircleOUp = 81,
        Inbox = 82,
        PlayCircleO = 83,
        Repeat = 84,
        Refresh = 85,
        ListAlt = 86,
        Lock = 87,
        FAFlag = 88,
        Headphones = 89,
        VolumeOff = 90,
        VolumeDown = 91,
        VolumeUp = 92,
        Qrcode = 93,
        Barcode = 94,
        Tag = 95,
        Tags = 96,
        Book = 97,
        Bookmark = 98,
        Print = 99,
        Camera = 100,
        Font = 101,
        Bold = 102,
        Italic = 103,
        TextHeight = 104,
        TextWidth = 105,
        AlignLeft = 106,
        AlignCenter = 107,
        AlignRight = 108,
        AlignJustify = 109,
        List = 110,
        Outdent = 111,
        Indent = 112,
        VideoCamera = 113,
        PictureO = 114,
        Pencil = 115,
        MapMarker = 116,
        Adjust = 117,
        Tint = 118,
        PencilSquareO = 119,
        ShareSquareO = 120,
        CheckSquareO = 121,
        Arrows = 122,
        StepBackward = 123,
        FastBackward = 124,
        Backward = 125,
        Play = 126,
        Pause = 127,
        Stop = 128,
        Forward = 129,
        FastForward = 130,
        StepForward = 131,
        Eject = 132,
        ChevronLeft = 133,
        ChevronRight = 134,
        PlusCircle = 135,
        MinusCircle = 136,
        TimesCircle = 137,
        CheckCircle = 138,
        QuestionCircle = 139,
        InfoCircle = 140,
        Crosshairs = 141,
        TimesCircleO = 142,
        CheckCircleO = 143,
        Ban = 144,
        FAArrowLeft = 145,
        FAArrowRight = 146,
        FAArrowUp = 147,
        FAArrowDown = 148,
        Share = 149,
        Expand = 150,
        Compress = 151,
        FAPlus = 152,
        FAMinus = 153,
        Asterisk = 154,
        ExclamationCircle = 155,
        Gift = 156,
        Leaf = 157,
        Fire = 158,
        Eye = 159,
        EyeSlash = 160,
        ExclamationTriangle = 161,
        Plane = 162,
        Calendar = 163,
        Random = 164,
        Comment = 165,
        Magnet = 166,
        ChevronUp = 167,
        ChevronDown = 168,
        Retweet = 169,
        ShoppingCart = 170,
        Folder = 171,
        FolderOpen = 172,
        ArrowsV = 173,
        ArrowsH = 174,
        BarChart = 175,
        TwitterSquare = 176,
        FacebookSquare = 177,
        CameraRetro = 178,
        Key = 179,
        Cogs = 180,
        Comments = 181,
        ThumbsOUp = 182,
        ThumbsODown = 183,
        HeartO = 184,
        SignOut = 185,
        LinkedinSquare = 186,
        ThumbTack = 187,
        ExternalLink = 188,
        SignIn = 189,
        Trophy = 190,
        GithubSquare = 191,
        Upload = 192,
        LemonO = 193,
        SquareO = 194,
        BookmarkO = 195,
        PhoneSquare = 196,
        Twitter = 197,
        Facebook = 198,
        Github = 199,
        Unlock = 200,
        CreditCard = 201,
        Rss = 202,
        HddO = 203,
        Bullhorn = 204,
        Bell = 205,
        Certificate = 206,
        HandORight = 207,
        HandOLeft = 208,
        HandOUp = 209,
        HandODown = 210,
        ArrowCircleLeft = 211,
        ArrowCircleRight = 212,
        ArrowCircleUp = 213,
        ArrowCircleDown = 214,
        Globe = 215,
        Wrench = 216,
        Tasks = 217,
        Filter = 218,
        Briefcase = 219,
        ArrowsAlt = 220,
        Users = 221,
        Link = 222,
        Cloud = 223,
        Flask = 224,
        Scissors = 225,
        FilesO = 226,
        Paperclip = 227,
        FloppyO = 228,
        Square = 229,
        Bars = 230,
        ListUl = 231,
        ListOl = 232,
        Strikethrough = 233,
        Underline = 234,
        Table = 235,
        Magic = 236,
        Pinterest = 237,
        PinterestSquare = 238,
        GooglePlusSquare = 239,
        GooglePlus = 240,
        Money = 241,
        CaretDown = 242,
        CaretUp = 243,
        CaretLeft = 244,
        CaretRight = 245,
        Columns = 246,
        Sort = 247,
        SortDesc = 248,
        SortAsc = 249,
        Envelope = 250,
        Linkedin = 251,
        Undo = 252,
        Gavel = 253,
        Tachometer = 254,
        CommentO = 255,
        CommentsO = 256,
        Bolt = 257,
        Sitemap = 258,
        Umbrella = 259,
        Clipboard = 260,
        LightbulbO = 261,
        Exchange = 262,
        CloudDownload = 263,
        CloudUpload = 264,
        UserMd = 265,
        Stethoscope = 266,
        Suitcase = 267,
        BellO = 268,
        Coffee = 269,
        Cutlery = 270,
        FileTextO = 271,
        BuildingO = 272,
        HospitalO = 273,
        Ambulance = 274,
        Medkit = 275,
        FighterJet = 276,
        Beer = 277,
        HSquare = 278,
        PlusSquare = 279,
        AngleDoubleLeft = 280,
        AngleDoubleRight = 281,
        AngleDoubleUp = 282,
        AngleDoubleDown = 283,
        AngleLeft = 284,
        AngleRight = 285,
        AngleUp = 286,
        AngleDown = 287,
        Desktop = 288,
        Laptop = 289,
        Tablet = 290,
        CircleO = 291,
        QuoteLeft = 292,
        QuoteRight = 293,
        Spinner = 294,
        Reply = 295,
        GithubAlt = 296,
        FolderO = 297,
        FolderOpenO = 298,
        SmileO = 299,
        FrownO = 300,
        MehO = 301,
        Gamepad = 302,
        KeyboardO = 303,
        FlagO = 304,
        FlagCheckered = 305,
        Terminal = 306,
        Code = 307,
        ReplyAll = 308,
        StarHalfO = 309,
        LocationArrow = 310,
        Crop = 311,
        CodeFork = 312,
        ChainBroken = 313,
        Question = 314,
        Info = 315,
        Superscript = 316,
        Subscript = 317,
        Eraser = 318,
        PuzzlePiece = 319,
        Microphone = 320,
        MicrophoneSlash = 321,
        Shield = 322,
        CalendarO = 323,
        FireExtinguisher = 324,
        Rocket = 325,
        Maxcdn = 326,
        ChevronCircleLeft = 327,
        ChevronCircleRight = 328,
        ChevronCircleUp = 329,
        ChevronCircleDown = 330,
        Html5 = 331,
        Css3 = 332,
        Anchor = 333,
        UnlockAlt = 334,
        Bullseye = 335,
        EllipsisH = 336,
        EllipsisV = 337,
        RssSquare = 338,
        PlayCircle = 339,
        Ticket = 340,
        MinusSquare = 341,
        InusSquareO = 342,
        LevelUp = 343,
        LevelDown = 344,
        CheckSquare = 345,
        PencilSquare = 346,
        ExternalLinkSquare = 347,
        ShareSquare = 348,
        Compass = 349,
        CaretSquareODown = 350,
        CaretSquareOUp = 351,
        CaretSquareORight = 352,
        Eur = 353,
        Gbp = 354,
        Usd = 355,
        Inr = 356,
        Jpy = 357,
        Rub = 358,
        Krw = 359,
        Btc = 360,
        File = 361,
        FileText = 362,
        SortAlphaAsc = 363,
        SortAlphaDesc = 364,
        SortAmountAsc = 365,
        SortAmountDesc = 366,
        SortNumericAsc = 367,
        SortNumericDesc = 368,
        ThumbsUp = 369,
        ThumbsDown = 370,
        YoutubeSquare = 371,
        Youtube = 372,
        Xing = 373,
        XingSquare = 374,
        YoutubePlay = 375,
        Dropbox = 376,
        StackOverflow = 377,
        Instagram = 378,
        Flickr = 379,
        Adn = 380,
        Bitbucket = 381,
        BitbucketSquare = 382,
        Tumblr = 383,
        TumblrSquare = 384,
        LongArrowDown = 385,
        LongArrowUp = 386,
        LongArrowLeft = 387,
        LongArrowRight = 388,
        Apple = 389,
        Windows = 390,
        Android = 391,
        Linux = 392,
        Dribbble = 393,
        Skype = 394,
        Foursquare = 395,
        Trello = 396,
        Female = 397,
        Male = 398,
        Gratipay = 399,
        SunO = 400,
        MoonO = 401,
        Archive = 402,
        Bug = 403,
        Vk = 404,
        Weibo = 405,
        Renren = 406,
        Pagelines = 407,
        StackExchange = 408,
        ArrowCircleORight = 409,
        ArrowCircleOLeft = 410,
        CaretSquareOLeft = 411,
        DotCircleO = 412,
        Wheelchair = 413,
        VimeoSquare = 414,
        Try = 415,
        PlusSquareO = 416,
        SpaceShuttle = 417,
        Slack = 418,
        EnvelopeSquare = 419,
        Wordpress = 420,
        Openid = 421,
        University = 422,
        GraduationCap = 423,
        Yahoo = 424,
        Google = 425,
        Reddit = 426,
        RedditSquare = 427,
        StumbleuponCircle = 428,
        Stumbleupon = 429,
        Delicious = 430,
        Digg = 431,
        PiedPiper = 432,
        PiedPiperAlt = 433,
        Drupal = 434,
        Joomla = 435,
        Language = 436,
        Fax = 437,
        Building = 438,
        Child = 439,
        Paw = 440,
        Spoon = 441,
        Cube = 442,
        Cubes = 443,
        Behance = 444,
        BehanceSquare = 445,
        Steam = 446,
        SteamSquare = 447,
        Recycle = 448,
        Car = 449,
        Taxi = 450,
        Tree = 451,
        Spotify = 452,
        Deviantart = 453,
        Soundcloud = 454,
        Database = 455,
        FilePdfO = 456,
        FileWordO = 457,
        FileExcelO = 458,
        FilePowerpointO = 459,
        FileImageO = 460,
        FileArchiveO = 461,
        FileAudioO = 462,
        FileVideoO = 463,
        FileCodeO = 464,
        Vine = 465,
        Codepen = 466,
        Jsfiddle = 467,
        LifeRing = 468,
        CircleONotch = 469,
        Rebel = 470,
        Empire = 471,
        GitSquare = 472,
        Git = 473,
        HackerNews = 474,
        TencentWeibo = 475,
        Qq = 476,
        Weixin = 477,
        PaperPlane = 478,
        PaperPlaneO = 479,
        History = 480,
        CircleThin = 481,
        Header = 482,
        Paragraph = 483,
        Sliders = 484,
        ShareAlt = 485,
        ShareAltSquare = 486,
        Bomb = 487,
        FutbolO = 488,
        Tty = 489,
        Binoculars = 490,
        Plug = 491,
        Slideshare = 492,
        Twitch = 493,
        Yelp = 494,
        NewspaperO = 495,
        Wifi = 496,
        Calculator = 497,
        Paypal = 498,
        GoogleWallet = 499,
        CcVisa = 500,
        CcMastercard = 501,
        CcDiscover = 502,
        CcAmex = 503,
        CcPaypal = 504,
        CcStripe = 505,
        BellSlash = 506,
        BellSlashO = 507,
        Trash = 508,
        Copyright = 509,
        At = 510,
        Eyedropper = 511,
        PaintBrush = 512,
        BirthdayCake = 513,
        AreaChart = 514,
        PieChart = 515,
        LineChart = 516,
        Lastfm = 517,
        LastfmSquare = 518,
        ToggleOff = 519,
        ToggleOn = 520,
        Bicycle = 521,
        Bus = 522,
        Ioxhost = 523,
        Angellist = 524,
        Cc = 525,
        Ils = 526,
        Meanpath = 527,
        Buysellads = 528,
        Connectdevelop = 529,
        Dashcube = 530,
        Forumbee = 531,
        Leanpub = 532,
        Sellsy = 533,
        Shirtsinbulk = 534,
        Simplybuilt = 535,
        Skyatlas = 536,
        CartPlus = 537,
        CartArrowDown = 538,
        Diamond = 539,
        Ship = 540,
        UserSecret = 541,
        Motorcycle = 542,
        StreetView = 543,
        Heartbeat = 544,
        Venus = 545,
        Mars = 546,
        Mercury = 547,
        Transgender = 548,
        TransgenderAlt = 549,
        VenusDouble = 550,
        MarsDouble = 551,
        VenusMars = 552,
        MarsStroke = 553,
        MarsStrokeV = 554,
        MarsStrokeH = 555,
        Neuter = 556,
        Genderless = 557,
        FacebookOfficial = 558,
        PinterestP = 559,
        Whatsapp = 560,
        Server = 561,
        UserPlus = 562,
        UserTimes = 563,
        Bed = 564,
        Viacoin = 565,
        Train = 566,
        Subway = 567,
        Medium = 568,
        YCombinator = 569,
        OptinMonster = 570,
        Opencart = 571,
        Expeditedssl = 572,
        BatteryFull = 573,
        BatteryThreeQuarters = 574,
        BatteryHalf = 575,
        BatteryQuarter = 576,
        BatteryEmpty = 577,
        MousePointer = 578,
        ICursor = 579,
        ObjectGroup = 580,
        ObjectUngroup = 581,
        StickyNote = 582,
        StickyNoteO = 583,
        CcJcb = 584,
        CcDinersClub = 585,
        Clone = 586,
        BalanceScale = 587,
        HourglassO = 588,
        HourglassStart = 589,
        HourglassHalf = 590,
        HourglassEnd = 591,
        Hourglass = 592,
        HandRockO = 593,
        HandPaperO = 594,
        HandScissorsO = 595,
        HandLizardO = 596,
        HandSpockO = 597,
        HandPointerO = 598,
        HandPeaceO = 599,
        Trademark = 600,
        Registered = 601,
        CreativeCommons = 602,
        Gg = 603,
        GgCircle = 604,
        Tripadvisor = 605,
        Odnoklassniki = 606,
        OdnoklassnikiSquare = 607,
        GetPocket = 608,
        WikipediaW = 609,
        Safari = 610,
        Chrome = 611,
        Firefox = 612,
        Opera = 613,
        InternetExplorer = 614,
        Television = 615,
        Contao = 616,
        Px500 = 617,
        Amazon = 618,
        CalendarPlusO = 619,
        CalendarMinusO = 620,
        CalendarTimesO = 621,
        CalendarCheckO = 622,
        Industry = 623,
        MapPin = 624,
        MapSigns = 625,
        MapO = 626,
        Map = 627,
        Commenting = 628,
        CommentingO = 629,
        Houzz = 630,
        Vimeo = 631,
        BlackTie = 632,
        Fonticons = 633
    }
}
export namespace Stimulsoft.Base.Drawing {
    import Image = Stimulsoft.System.Drawing.Image;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import Font = Stimulsoft.System.Drawing.Font;
    import ContentAlignment = Stimulsoft.System.Drawing.ContentAlignment;
    import Color = Stimulsoft.System.Drawing.Color;
    import IStiDefault = Stimulsoft.Base.Design.IStiDefault;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import ICloneable = Stimulsoft.System.ICloneable;
    import StiFontIcons = Stimulsoft.Report.Helpers.StiFontIcons;
    class StiAdvancedWatermark implements ICloneable, IStiJsonReportObject, IStiDefault {
        private static defaultWeaveMajorColor;
        private static defaultWeaveMinorColor;
        private static defaultTextColor;
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        loadFromXml(xmlNode: XmlNode): void;
        clone(): any;
        isDefault(): boolean;
        private cachedImage;
        get isVisible(): boolean;
        textEnabled: boolean;
        text: string;
        textFont: Font;
        private shouldSerializeTextFont;
        textColor: Color;
        private shouldSerializeTextColor;
        textAngle: number;
        imageEnabled: boolean;
        get image(): Image;
        set image(value: Image);
        private imageBytes_;
        get imageBytes(): number[];
        set imageBytes(value: number[]);
        imageMultipleFactor: number;
        private _imageTransparency;
        get imageTransparency(): number;
        set imageTransparency(value: number);
        imageAlignment: ContentAlignment;
        imageTiling: boolean;
        imageStretch: boolean;
        imageAspectRatio: boolean;
        weaveEnabled: boolean;
        weaveMajorIcon: StiFontIcons;
        private weaveMajorSize_;
        get weaveMajorSize(): number;
        set weaveMajorSize(value: number);
        weaveMajorColor: Color;
        private shouldSerializeWeaveMajorColor;
        weaveMinorIcon: StiFontIcons;
        private weaveMinorSize_;
        get weaveMinorSize(): number;
        set weaveMinorSize(value: number);
        weaveMinorColor: Color;
        private shouldSerializeWeaveMinorColor;
        private weaveAngle_;
        get weaveAngle(): number;
        set weaveAngle(value: number);
        private weaveDistance_;
        get weaveDistance(): number;
        set weaveDistance(value: number);
        private getCachedImage;
        private putCachedImage;
        private disposeCachedImage;
        private existImage;
        private takeImage;
        private takeGdiImage;
        putImage(image: Image): void;
        putImage2(image: number[]): void;
        resetImage(): void;
        constructor(textEnabled?: boolean, text?: string, textColor?: Color, textAngle?: number, textFont?: Font, imageEnabled?: boolean, imageBytes?: number[], imageMultipleFactor?: number, imageTransparency?: number, imageAlignment?: ContentAlignment, imageTiling?: boolean, imageStretch?: boolean, imageAspectRatio?: boolean, weaveEnabled?: boolean, weaveMajorIcon?: StiFontIcons, weaveMajorSize?: number, weaveMajorColor?: Color, weaveMinorIcon?: StiFontIcons, weaveMinorSize?: number, weaveMinorColor?: Color, weaveAngle?: number, weaveDistance?: number);
    }
}
export namespace Stimulsoft.Base.Drawing {
    import Rectangle = Stimulsoft.System.Drawing.Rectangle;
    class StiAlignHelper {
        static alignToGrid(value: number, gridSize: number, aligningToGrid: boolean): number;
        static alignToGrid2(rect: Rectangle, gridSize: number, aligningToGrid: boolean): Rectangle;
    }
}
export namespace Stimulsoft.Base.Drawing {
    import ICloneable = Stimulsoft.System.ICloneable;
    import Color = Stimulsoft.System.Drawing.Color;
    class StiBorderSide implements ICloneable {
        implements(): any[];
        clone(): StiBorderSide;
        equals(obj: StiBorderSide | any): boolean;
        getHashCode(): number;
        getSizeOffset(): number;
        side: StiBorderSides;
        private _color;
        get color(): Color;
        set color(value: Color);
        private _size;
        get size(): number;
        set size(value: number);
        private _style;
        get style(): StiPenStyle;
        set style(value: StiPenStyle);
        isDefault(): boolean;
        constructor(color?: Color, size?: number, style?: StiPenStyle);
    }
}
export namespace Stimulsoft.Base.Drawing {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import Color = Stimulsoft.System.Drawing.Color;
    import ICloneable = Stimulsoft.System.ICloneable;
    class StiCap implements ICloneable {
        implements(): any[];
        clone(): StiCap;
        width: number;
        style: StiCapStyle;
        height: number;
        fill: boolean;
        color: Color;
        loadFromXml(xmlNode: XmlNode): void;
        constructor(width?: number, style?: StiCapStyle, height?: number, fill?: boolean, color?: Color);
    }
}
export namespace Stimulsoft.Base.Drawing {
    import Color = Stimulsoft.System.Drawing.Color;
    class StiColorUtils {
        static changeLightness(color: Color, correctionFactor: number): Color;
        static changeDarkness(color: Color, percDarker: number): Color;
        static light(baseColor: Color, value: number): Color;
        static mixingColors(color1: Color, color2: Color, alpha: number): Color;
        static dark(baseColor: Color, value: number): Color;
    }
}
export namespace Stimulsoft.Base.Drawing {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IStiDefault = Stimulsoft.Base.Design.IStiDefault;
    class StiCornerRadius implements ICloneable, IStiDefault, IStiJsonReportObject {
        clone(): any;
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        loadFromXml(xmlNode: XmlNode): void;
        isDefault(): boolean;
        equals(obj: any): boolean;
        toString(): string;
        static tryParse(str: string): StiCornerRadius;
        getUniqueCode(): number;
        private topLeft_;
        get topLeft(): number;
        set topLeft(value: number);
        private topRight_;
        get topRight(): number;
        set topRight(value: number);
        private bottomRight_;
        get bottomRight(): number;
        set bottomRight(value: number);
        private bottomLeft_;
        get bottomLeft(): number;
        set bottomLeft(value: number);
        get isEmpty(): boolean;
        constructor(topLeft?: number, topRight?: number, bottomRight?: number, bottomLeft?: number);
    }
}
export namespace Stimulsoft.Base.Drawing {
    class StiCornerRadiusHelper {
        static flipVertical(cornerRadius: StiCornerRadius): StiCornerRadius;
        static flipHorizontal(cornerRadius: StiCornerRadius): StiCornerRadius;
        static rotation90(cornerRadius: StiCornerRadius): StiCornerRadius;
    }
}
export namespace Stimulsoft.Base.Drawing {
    class StiDefaultBrush extends StiBrush {
        equals(obj: any): boolean;
        getHashCode(): number;
        ident: StiBrushIdent;
    }
}
export namespace Stimulsoft.Base.Drawing {
    import Graphics = Stimulsoft.System.Drawing.Graphics;
    import Brush = Stimulsoft.System.Drawing.Brush;
    import Rectangle = Stimulsoft.System.Drawing.Rectangle;
    class StiDrawing {
        static fillRectangle(g: Graphics, brush: Brush, arg: number | Rectangle, y?: number, width?: number, height?: number): void;
    }
}
export namespace Stimulsoft.Base.Drawing {
    class StiEmptyBrush extends StiBrush {
        equals(obj: any): boolean;
        private defaultHashCode;
        getHashCode(): number;
    }
}
export namespace Stimulsoft.Base.Drawing {
    import Font = Stimulsoft.System.Drawing.Font;
    import FontStyle = Stimulsoft.System.Drawing.FontStyle;
    class StiFontUtils {
        static correctStyle(fontName: string, style: FontStyle): FontStyle;
        static changeFontName(font: Font, newFontName: string): Font;
        static changeFontSize(font: Font, newFontSize: number): Font;
        static changeFontStyle(font: Font, style: FontStyle): Font;
        static changeFontStyle2(fontName: string, fontSize: number, style: FontStyle): Font;
        static changeFontStyleBold(font: Font, bold: boolean): Font;
        static changeFontStyleItalic(font: Font, italic: boolean): Font;
        static changeFontStyleUnderline(font: Font, underline: boolean): Font;
        static changeFontStyleStrikeout(font: Font, strikeout: boolean): Font;
    }
}
export namespace Stimulsoft.Base.Drawing {
    import Color = Stimulsoft.System.Drawing.Color;
    class StiGlareBrush extends StiBrush {
        memberwiseClone(): StiBrush;
        private _startColor;
        get startColor(): Color;
        set startColor(value: Color);
        private _endColor;
        get endColor(): Color;
        set endColor(value: Color);
        private _angle;
        get angle(): number;
        set angle(value: number);
        private _focus;
        get focus(): number;
        set focus(value: number);
        private _scale;
        get scale(): number;
        set scale(value: number);
        equals(obj: any): boolean;
        private defaultHashCode;
        getHashCode(): number;
        constructor(startColor?: Color, endColor?: Color, angle?: number, focus?: number, scale?: number);
    }
}
export namespace Stimulsoft.Base.Drawing {
    import Color = Stimulsoft.System.Drawing.Color;
    import Rectangle = Stimulsoft.System.Drawing.Rectangle;
    class StiGlassBrush extends StiBrush {
        memberwiseClone(): StiBrush;
        private _color;
        get color(): Color;
        set color(value: Color);
        private _drawHatch;
        get drawHatch(): boolean;
        set drawHatch(value: boolean);
        private _blend;
        get blend(): number;
        set blend(value: number);
        equals(obj: any): boolean;
        private defaultHashCode;
        getHashCode(): number;
        getTopColor(): Color;
        getTopColorLight(): Color;
        getBottomColor(): Color;
        getBottomColorLight(): Color;
        getTopRectangle(rect: Rectangle): Rectangle;
        getBottomRectangle(rect: Rectangle): Rectangle;
        constructor(color?: Color, drawHatch?: boolean, blend?: number);
    }
}
export namespace Stimulsoft.Base.Drawing {
    import Color = Stimulsoft.System.Drawing.Color;
    class StiGradientBrush extends StiBrush {
        memberwiseClone(): StiBrush;
        private _startColor;
        get startColor(): Color;
        set startColor(value: Color);
        private _endColor;
        get endColor(): Color;
        set endColor(value: Color);
        private _angle;
        get angle(): number;
        set angle(value: number);
        equals(obj: any): boolean;
        private defaultHashCode;
        getHashCode(): number;
        constructor(startColor?: Color, endColor?: Color, angle?: number);
    }
}
export namespace Stimulsoft.Base.Drawing {
    import Color = Stimulsoft.System.Drawing.Color;
    import HatchStyle = Stimulsoft.System.Drawing.Drawing2D.HatchStyle;
    class StiHatchBrush extends StiBrush {
        memberwiseClone(): StiBrush;
        private _backColor;
        get backColor(): Color;
        set backColor(value: Color);
        private _foreColor;
        get foreColor(): Color;
        set foreColor(value: Color);
        private _style;
        get style(): HatchStyle;
        set style(value: HatchStyle);
        equals(obj: any): boolean;
        private defaultHashCode;
        getHashCode(): number;
        constructor(style?: HatchStyle, foreColor?: Color, backColor?: Color);
    }
}
export namespace Stimulsoft.Base.Drawing {
    import ImageCodecInfo = Stimulsoft.System.Drawing.Imaging.ImageCodecInfo;
    class StiImageCodecInfo {
        static getImageCodec(mimeType: string): ImageCodecInfo;
    }
}
export namespace Stimulsoft.Base.Drawing {
    import Image = Stimulsoft.System.Drawing.Image;
    class StiImageConverter {
        static imageToString(image: Image): string;
        static imageToBytes(image: Image, allowNulls?: boolean): number[];
        static bytesToImage(bytes: number[], width?: number, height?: number, stretch?: boolean, aspectRatio?: boolean): Image;
        static stringToImage(str: string): Image;
        static stringToByteArray(str: string): number[];
    }
}
export namespace Stimulsoft.Base.Drawing {
    import Image = Stimulsoft.System.Drawing.Image;
    class StiImageFromURL {
        static loadBitmap(url: string): Image;
    }
}
export namespace Stimulsoft.Base.Drawing {
    import DashStyle = Stimulsoft.System.Drawing.Drawing2D.DashStyle;
    class StiPenUtils {
        static getPenStyle(penStyle: StiPenStyle): DashStyle;
    }
}
export namespace Stimulsoft.Base.Drawing {
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import ICloneable = Stimulsoft.System.ICloneable;
    import Color = Stimulsoft.System.Drawing.Color;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    class StiSimpleBorder implements ICloneable, IStiJsonReportObject {
        clone(): any;
        getBorder(): StiBorder;
        getSizeOffset(): number;
        getSize(): number;
        getSizeIncludingSide(): number;
        get isTopBorderSidePresent(): boolean;
        get isBottomBorderSidePresent(): boolean;
        get isLeftBorderSidePresent(): boolean;
        get isRightBorderSidePresent(): boolean;
        get isAllBorderSidesPresent(): boolean;
        side: StiBorderSides;
        color: Color;
        private shouldSerializeColor;
        size: number;
        style: StiPenStyle;
        isDefault(): boolean;
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        loadFromXml(xmlNode: XmlNode): void;
        constructor(side?: StiBorderSides, color?: Color, size?: number, style?: StiPenStyle);
    }
}
export namespace Stimulsoft.Base.Drawing {
    import Point = Stimulsoft.System.Drawing.Point;
    import ICloneable = Stimulsoft.System.ICloneable;
    import Color = Stimulsoft.System.Drawing.Color;
    class StiSimpleShadow implements ICloneable {
        clone(): any;
        static loadFromXml(text: string): StiSimpleShadow;
        color: Color;
        private shouldSerializeColor;
        private location_;
        get location(): Point;
        set location(value: Point);
        private shouldSerializeLocation;
        private size_;
        get size(): number;
        set size(value: number);
        visible: boolean;
        isDefault(): boolean;
        constructor(color?: Color, location?: Point, size?: number, visible?: boolean);
    }
}
export namespace Stimulsoft.Base.Drawing {
    class StiStyleBrush extends StiBrush {
        equals(obj: any): boolean;
        getHashCode(): number;
        ident: StiBrushIdent;
    }
}
export namespace Stimulsoft.Base.Drawing {
    import Point = Stimulsoft.System.Drawing.Point;
    import Rectangle = Stimulsoft.System.Drawing.Rectangle;
    import StringFormat = Stimulsoft.System.Drawing.StringFormat;
    import List = Stimulsoft.System.Collections.List;
    import Size = Stimulsoft.System.Drawing.Size;
    import Graphics = Stimulsoft.System.Drawing.Graphics;
    import Font = Stimulsoft.System.Drawing.Font;
    import StringAlignment = Stimulsoft.System.Drawing.StringAlignment;
    class Range {
        text: string;
        pos: Point;
        size: Size;
        isStart: boolean;
        isEnd: boolean;
        newLineForm: boolean;
        constructor(text: string, size: Size, newLineForm: boolean);
    }
    class StiTextDrawing {
        static measureString(g: Graphics, text: string, font: Font, width?: number, textOptions?: StiTextOptions, ha?: StiTextHorAlignment, va?: StiVertAlignment, antialiasing?: boolean, allowHtmlTags?: boolean): Size;
        private static correctFontSize;
        static splitTextWordwrap(text: string, g: Graphics, font: Font, rect: Rectangle, textOptions: StiTextOptions, ha: StiTextHorAlignment, typographic: boolean): List<LineInfo>;
        static splitTextWordwrap2(text: string, g: Graphics, font: Font, rect: Rectangle, sf: StringFormat, horAlignWidth?: boolean): List<LineInfo>;
        static splitTextWordwrapWidth(text: string, g: Graphics, font: Font, rect: Rectangle): List<string>;
        private static getAdditionalSpaceSize;
        private static makeLineInfo;
        static splitString(inputString: string, removeControl: boolean): List<string>;
        static getStringFormat(textOptions: StiTextOptions, ha: StiTextHorAlignment, va: StiVertAlignment, zoom: number): StringFormat;
        static getAlignment(alignment: StiTextHorAlignment): StringAlignment;
        static getAlignment2(alignment: StiVertAlignment): StringAlignment;
        static getStringFormat2(textOptions: StiTextOptions, ha: StiTextHorAlignment, va: StiVertAlignment, antialiasing: boolean, zoom: number): StringFormat;
        static measureTrailingSpaces: boolean;
    }
}
export namespace Stimulsoft.Base.Drawing {
    import StringFormat = Stimulsoft.System.Drawing.StringFormat;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StringTrimming = Stimulsoft.System.Drawing.StringTrimming;
    import HotkeyPrefix = Stimulsoft.System.Drawing.Text.HotkeyPrefix;
    import StiJson = Stimulsoft.Base.StiJson;
    import ICloneable = Stimulsoft.System.ICloneable;
    class StiTextOptions implements ICloneable, IStiJsonReportObject {
        implements(): any[];
        saveToJsonObject(): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        static loadFromXml(str: string): StiTextOptions;
        loadFromXml(xmlNode: XmlNode): void;
        clone(): StiTextOptions;
        private bits;
        getStringFormat(antialiasing?: boolean, zoom?: number): StringFormat;
        get rightToLeft(): boolean;
        set rightToLeft(value: boolean);
        get lineLimit(): boolean;
        set lineLimit(value: boolean);
        wordWrap: boolean;
        get angle(): number;
        set angle(value: number);
        get firstTabOffset(): number;
        set firstTabOffset(value: number);
        get distanceBetweenTabs(): number;
        set distanceBetweenTabs(value: number);
        get hotkeyPrefix(): HotkeyPrefix;
        set hotkeyPrefix(value: HotkeyPrefix);
        get trimming(): StringTrimming;
        set trimming(value: StringTrimming);
        isDefault(): boolean;
        getHashCode(): number;
        constructor(rightToLeft?: boolean, lineLimit?: boolean, wordWrap?: boolean, angle?: number, hotkeyPrefix?: HotkeyPrefix, trimming?: StringTrimming, firstTabOffset?: number, distanceBetweenTabs?: number);
    }
}
export namespace Stimulsoft.Base.Drawing {
    import List = Stimulsoft.System.Collections.List;
    import Rectangle = Stimulsoft.System.Drawing.Rectangle;
    import Color = Stimulsoft.System.Drawing.Color;
    import StringBuilder = Stimulsoft.System.Text.StringBuilder;
    import Graphics = Stimulsoft.System.Drawing.Graphics;
    import Font = Stimulsoft.System.Drawing.Font;
    import Size = Stimulsoft.System.Drawing.Size;
    import StringTrimming = Stimulsoft.System.Drawing.StringTrimming;
    import Hashtable = Stimulsoft.System.Collections.Hashtable;
    class StiTextRenderer {
        private static precisionDigits;
        private static defaultParagraphLineHeight;
        static precisionModeFactor: number;
        static precisionModeEnabled: boolean;
        static correctionEnabled: boolean;
        static maxFontSize: number;
        static compatibility2009: boolean;
        static optimizeBottomMargin: boolean;
        private static hashFonts;
        private static getTabsWidth;
        static getFontIndex(fontName: string, fontSize: number, bold: boolean, italic: boolean, underlined: boolean, strikeout: boolean, superOrSubscript: boolean, tempFontList: List<StiFontState>): number;
        private static getFontIndex2;
        private static htmlNameToColor;
        static interpreteFontSizeInHtmlTagsAsInHtml: boolean;
        private static _htmlEscapeSequence;
        private static get htmlEscapeSequence();
        private static convertStringToTag;
        static parseHtmlToStates(inputHtml: string, baseState: StiHtmlState, storeStack?: boolean): StiHtmlState[];
        private static getMarginSize;
        static prepareStateText(stateText: StringBuilder): StringBuilder;
        static stateToHtml(state: StiHtmlState, state2: StiHtmlState, text: string, lineInfoIndent: number): string;
        private static getIndentString;
        private static bulletBlack;
        private static bulletWhite;
        private static insertMarker;
        private static stackToString;
        private static listLevelsToString;
        private static parseHtmlTag;
        private static pushPopStack;
        private static correctFontName;
        private static parseTagIntoPairs;
        private static parseMarkerTypeAttribute;
        private static parseStyleAttributes;
        private static parseStyleAttribute;
        private static stringToListLevels;
        private static stringToStack;
        private static parseFontSize;
        private static parseSizeToEm;
        static parseColor(colorAttribute: string, inheritColor: Color): Color;
        static measureString(maxWidth: number, font: Font, text: string, angle?: number, allowHtmlTags?: boolean): Size;
        static getTextLinesAndWidths(g: Graphics, REFtext: any, font: Font, bounds: Rectangle, lineSpacing: number, wordWrap: boolean, rightToLeft: boolean, scale: number, angle: number, trimming: StringTrimming, allowHtmlTags: boolean, REFtextLines: any, REFlinesInfo: any): string[];
        static drawTextForOutput(g: Graphics, text: string, font: Font, bounds: Rectangle, foreColor: Color, backColor: Color, lineSpacing: number, horAlign: StiTextHorAlignment, vertAlign: StiVertAlignment, wordWrap: boolean, rightToLeft: boolean, scale: number, angle: number, trimming: StringTrimming, lineLimit: boolean, allowHtmlTags: boolean, outRunsList: List<RunInfo>, outFontsList: List<StiFontState>, textOptions: StiTextOptions): void;
        static measureText(g: Graphics, text: string, font: Font, bounds: Rectangle, lineSpacing: number, wordWrap: boolean, rightToLeft: boolean, scale: number, angle: number, trimming: StringTrimming, lineLimit: boolean, allowHtmlTags: boolean, textOptions: StiTextOptions): Size;
        private static drawTextBase;
        private static drawTextBase2;
        static StiForceWidthAlignTag: string;
        private static getFontWidth;
        private static getFontWidth2;
        private static isWordWrapSymbol2;
        private static isNotWordWrapSymbol;
        private static isNotWordWrapSymbol2;
        private static isCJKWordWrap;
        private static isCJKSymbol;
        private static arabics;
        private static romans;
        private static subs;
        private static toRoman;
        static toABC(value: number): string;
    }
    class StiFontState {
        fontName: string;
        fontBase: Font;
        fontScaled: Font;
        superOrSubscriptIndex: number;
        parentFontIndex: number;
        hFont: number;
        hFontScaled: number;
        hScriptCache: number;
        hScriptCacheScaled: number;
        lineHeight: number;
        ascend: number;
        descend: number;
        elipsisWidth: number;
        emValue: number;
        private _fontNameReal;
        get fontNameReal(): string;
    }
    class LineInfo {
        begin: number;
        length: number;
        needWidthAlign: boolean;
        get end(): number;
        set end(value: number);
        width: number;
        widths: number[];
        justifyOffset: number;
        text: string;
        indexOfMaxFont: number;
        lineHeight: number;
        textAlignment: StiTextHorAlignment;
        indent: number;
    }
    class RunInfo {
        text: string;
        xPos: number;
        yPos: number;
        widths: number[];
        glyphWidths: number[];
        textColor: Color;
        backColor: Color;
        fontIndex: number;
        glyphIndexList: number[];
        scaleList: number[];
        href: string;
    }
    enum StiHtmlTag {
        None = 0,
        B = 1,
        I = 2,
        U = 3,
        S = 4,
        Sup = 5,
        Sub = 6,
        Font = 7,
        FontName = 8,
        FontSize = 9,
        FontColor = 10,
        Backcolor = 11,
        LetterSpacing = 12,
        WordSpacing = 13,
        LineHeight = 14,
        TextAlign = 15,
        P = 16,
        Br = 17,
        OrderedList = 18,
        UnorderedList = 19,
        ListItem = 20,
        A = 21,
        Unknown = 22
    }
    enum StiHtmlTag2State {
        Start = 0,
        End = 1,
        Empty = 2
    }
    class StiHtmlTag2 {
        tag: StiHtmlTag;
        tagName: string;
        attributes: List<TagPair>;
        state: StiHtmlTag2State;
        get isStart(): boolean;
        get isEnd(): boolean;
        get isEmpty(): boolean;
        isStartTag(tag: StiHtmlTag): boolean;
        isEndTag(tag: StiHtmlTag): boolean;
        getAttribute(name: string): string;
        equals(tag2: StiHtmlTag2): boolean;
        toString(): string;
        constructor(tag?: StiHtmlTag, state?: StiHtmlTag2State);
    }
    class StiHtmlTagsState {
        clone(): StiHtmlTagsState;
        getStyleAttribute(name: string): string;
        bold: boolean;
        italic: boolean;
        underline: boolean;
        strikeout: boolean;
        fontSize: number;
        fontName: string;
        fontColor: Color;
        backColor: Color;
        subsript: boolean;
        superscript: boolean;
        letterSpacing: number;
        wordSpacing: number;
        lineHeight: number;
        textAlign: StiTextHorAlignment;
        isColorChanged: boolean;
        isBackcolorChanged: boolean;
        tag: StiHtmlTag2;
        indent: number;
        htmlStyle: string;
        href: string;
        hrefTarget: string;
        styleAttributes: Hashtable;
        constructor(bold: any, italic?: boolean, underline?: boolean, strikeout?: boolean, fontSize?: number, fontName?: string, fontColor?: Color, backColor?: Color, superscript?: boolean, subscript?: boolean, letterSpacing?: number, wordSpacing?: number, lineHeight?: number, textAlign?: StiTextHorAlignment);
    }
    class StiHtmlState {
        clone(): StiHtmlState;
        ts: StiHtmlTagsState;
        text: StringBuilder;
        fontIndex: number;
        posBegin: number;
        tagsStack: StiHtmlTagsState[];
        listLevels: number[];
        toString(): string;
        constructor(ts: any, posBegin?: number);
    }
    class TagPair {
        key: string;
        keyBase: string;
        value: string;
    }
}
export namespace Stimulsoft.Base {
    enum StiPlanIdent {
        OnlineTrial = 100,
        OnlineStandard = 101,
        ServerTrial = 200,
        ServerTeam5 = 201,
        ServerTeam10 = 202,
        ServerTeam25 = 203,
        ServerTeam50 = 204,
        ServerBusiness = 205,
        ServerEnterprise = 206,
        ServerWorldWide = 207,
        Test = 300
    }
    enum StiPlanFeatureIdent {
        Cycles = 1
    }
}
export namespace Stimulsoft.Base.Helpers {
    import DateTime = Stimulsoft.System.DateTime;
    import TimeSpan = Stimulsoft.System.TimeSpan;
    enum DateTimeFormat {
        USA_DATE = 0,
        UK_DATE = 1
    }
    class ParsedDateTime {
        readonly indexOfDate: number;
        readonly lengthOfDate: number;
        readonly indexOfTime: number;
        readonly lengthOfTime: number;
        readonly dateTime: DateTime;
        readonly isDateFound: boolean;
        readonly isTimeFound: boolean;
        readonly utcOffset: TimeSpan;
        readonly isUtcOffsetFound: boolean;
        utcDateTime: DateTime;
        constructor(indexOfDate: number, lengthOfDate: number, indexOfTime: number, lengthOfTime: number, dateTime: DateTime, utcOffset?: TimeSpan);
    }
    class DateTimeRoutines {
        private static _defaultDate;
        static get defaultDate(): DateTime;
        static set defaultDate(value: DateTime);
        static defaultDateIsNow: boolean;
        static tryParseDateTime(str: string, defaultFormat: DateTimeFormat, refDateTime: {
            ref: DateTime;
        }): boolean;
        static tryParseDateTime2(str: string, defaultFormat: DateTimeFormat, refParsedDateTime: {
            ref: ParsedDateTime;
        }): boolean;
        static tryParseDateOrTime2(str: string, defaultFormat: DateTimeFormat, refParsedDateTime: {
            ref: ParsedDateTime;
        }): boolean;
        static tryParseTime2(str: string, defaultFormat: DateTimeFormat, refParsedTime: {
            ref: ParsedDateTime;
        }, parsedDate: ParsedDateTime): boolean;
        static tryParseDate2(str: string, defaultFormat: DateTimeFormat, refParsedDate: {
            ref: ParsedDateTime;
        }): boolean;
        private static tryParseDateInternal;
        private static convertToDate;
    }
}
export namespace Stimulsoft.Base.Helpers {
    import Size = Stimulsoft.System.Drawing.Size;
    import List = Stimulsoft.System.Collections.List;
    class StiBingMapHelper {
        static _bingKey: string;
        static bingMapKey: string;
        static bingKeysUrl: string;
        private static defaultBingKey;
        private static Script;
        static get BingKey(): string;
        static getImage(size: Size, map: {
            mapImage: string;
        }, pushPins?: List<string>): Promise<string>;
        private static base64ArrayBuffer;
        private static getBingUrl;
        static getScript(mapData: {
            [key: string]: string;
        }): string;
        private static getCacheKey;
    }
}
export namespace Stimulsoft.Base.Helpers {
    class StiComponentProgressHelper {
        progressDelta: number;
        timerInterval: number;
        private static lockCompletedProgressHandler;
        static currentValue: number;
        static add(comp: IStiAppComponent): void;
    }
}
export namespace Stimulsoft.Base.Helpers {
    import List = Stimulsoft.System.Collections.List;
    class StiOnlineMapRepaintHelper {
        timerInterval: number;
        browserLifetime: number;
        static init(): void;
        static fetchAllComponents(report: IStiReport): List<IStiAppComponent>;
        static clean(reportKey: string): void;
    }
}
export namespace Stimulsoft.Base {
    class StiPacker {
        private static encryptedId;
        static allowPacking: boolean;
        static pack(bytes: number[]): number[];
        static unpack<B extends boolean>(bytes: number[], returnString: B): B extends true ? string : number[];
        static unpack2(bytes: number[]): string;
        static unpackAndDecrypt<B extends boolean>(str: string, returnString: B): B extends true ? string : number[];
        static packAndEncryptToString(data: number[] | string): string;
        static packToString(bytes: number[]): string;
        static unpackFromString(str: string): number[];
        static packToBytes(str: string, allowPacking?: boolean): number[];
        static unpackToString(bytes: number[]): string;
        private static addZipSignature;
        static isPacked(bytes: number[]): boolean;
        private static isPacked2;
    }
}
export namespace Stimulsoft.Base.Helpers {
    class StiValueComparer {
        static equalValues(value1: any, value2: any): boolean;
        static compareArrays(a: any[], b: any[]): boolean;
    }
}
export namespace Stimulsoft.Base.Helpers {
    import Guid = Stimulsoft.System.Guid;
    import DateTime = Stimulsoft.System.DateTime;
    import TimeSpan = Stimulsoft.System.TimeSpan;
    class StiValueHelper {
        static isZero(value: any): boolean;
        static equalDecimal(value1: any, value2: any): boolean;
        static tryToString(value: any): string;
        static tryToNumber(value: any): number;
        static tryToBool(value: any): boolean;
        static tryToDateTime(value: any): DateTime;
        static tryToTimeSpan(value: any): TimeSpan;
        static tryToNullableNumber(value: any): number | null;
        static tryToNullableDateTime(value: any): DateTime | null;
        static tryToNullableTimeSpan(value: any): TimeSpan | null;
        static tryToGuid(value: any): Guid;
        static parseNumber(value: string): number;
        private static normalizeFloatingPointValue;
    }
}
export namespace Stimulsoft.Base {
    enum StiJsonSaveMode {
        Report = 0,
        Document = 1
    }
}
export namespace Stimulsoft.Base.StiJsonReportObjectHelper {
    import StiSimpleShadow = Stimulsoft.Base.Drawing.StiSimpleShadow;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiBorderSide = Stimulsoft.Base.Drawing.StiBorderSide;
    import StiCap = Stimulsoft.Base.Drawing.StiCap;
    import StiJson = Stimulsoft.Base.StiJson;
    import StiBorder = Stimulsoft.Base.Drawing.StiBorder;
    import Rectangle = Stimulsoft.System.Drawing.Rectangle;
    import Font = Stimulsoft.System.Drawing.Font;
    import FontStyle = Stimulsoft.System.Drawing.FontStyle;
    import GraphicsUnit = Stimulsoft.System.Drawing.GraphicsUnit;
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    import Color = Stimulsoft.System.Drawing.Color;
    import Size = Stimulsoft.System.Drawing.Size;
    import Point = Stimulsoft.System.Drawing.Point;
    import StiSimpleBorder = Stimulsoft.Base.Drawing.StiSimpleBorder;
    class Serialize {
        static fontArial8(font: Font): string;
        static fonSegoeUI20(font: Font): string;
        static font(font: Font, defaultFamily?: string, defaultEmSize?: number, defaultStyle?: FontStyle, defaultUnit?: GraphicsUnit): string;
        static rectangleD(rect: Rectangle): string;
        static sizeD(size: Size): string;
        static jColor(color: Color, defColor?: Color): string;
        static colorArray(array: Color[]): StiJson;
        static stringArray(array: string[]): StiJson;
        static boolArray(array: boolean[]): StiJson;
        static numberArray(array: number[]): StiJson;
        static objectArray(list: IStiJsonReportObject[], mode: StiJsonSaveMode): StiJson;
        static size(size: Size): StiJson;
        static point(pos: Point): StiJson;
        static jCap(cap: StiCap): string;
        static jBrush(brush: StiBrush, defaultBrush?: StiBrush): string;
        static jBorderSide(side: StiBorderSide): string;
        static jBorder(border: StiBorder): string;
        static jBorder2(border: StiSimpleBorder): string;
        static jShadow(shadow: StiSimpleShadow): string;
    }
    class Deserialize {
        static stringArray(jObject: StiJson): string[];
        static numberArray(jObject: StiJson): number[];
        static boolArray(jObject: StiJson): boolean[];
        static font(text: string, defaultFont: Font): Font;
        static jBorderSide(text: string): StiBorderSide;
        static jCap(text: string): StiCap;
        static border(text: string): StiBorder;
        static simpleBorder(text: string): StiSimpleBorder;
        static simpleSahdow(text: string): StiSimpleShadow;
        static color(value: string): Color;
        static brush(text: string): StiBrush;
        static colorArray(jObject: StiJson): Color[];
        static size(jObject: StiJson): Size;
        static rectangleD(text: string): Rectangle;
        static sizeD(text: string): Size;
        static point(jObject: StiJson): Point;
    }
}
export namespace Stimulsoft.Base {
    import DataSet = Stimulsoft.System.Data.DataSet;
    import JsonRelationDirection = Stimulsoft.System.Data.JsonRelationDirection;
    class StiJsonToDataSetConverter {
        static getDataSet(param: string | number[] | any, jsonRelationDirection?: JsonRelationDirection): DataSet;
        static getDataSetFromXml(param: any, relationDirection?: StiRelationDirection): DataSet;
    }
}
export namespace Stimulsoft.Base.Licenses {
    enum StiProductIdent {
        Ultimate = 1,
        Net = 2,
        Wpf = 3,
        Web = 4,
        Silverlight = 5,
        Js = 6,
        Java = 7,
        Php = 8,
        NetCore = 9,
        Uwp = 10,
        Flex = 11,
        BIDesigner = 12,
        DbsJs = 13,
        DbsWin = 14,
        DbsWeb = 15,
        BIDesktop = 16,
        BIServer = 17,
        BICloud = 18,
        CloudReports = 20,
        CloudDashboards = 21,
        Angular = 22,
        DbsAngular = 23,
        DbsPhp = 24,
        FormsWin = 25,
        FormsWeb = 26,
        FormsJs = 27,
        FormsPhp = 28
    }
    enum StiActivationType {
        Server = 1,
        Developer = 2
    }
}
export namespace Stimulsoft.Base.Licenses {
    class StiCryptHelper {
        private static encryptionKey;
        static decrypt(str: string, password?: string): string;
        static encrypt(str: string, password?: string): string;
        static recrypt(str: string, oldPassword: string, newPassword: string): string;
    }
}
export namespace Stimulsoft.Base.Licenses {
    class StiRsaPublicKey {
        static getKey(): any;
    }
}
export namespace Stimulsoft.Base.Licenses {
    class StiLicenseObject {
        encryptKey: string;
        loadFromString(str: string): void;
        saveToString(): string;
        loadFromBytes(bytes: number[]): void;
        decryptFromBytes(bytes: number[]): void;
        decryptFromString(str: string): void;
    }
}
export namespace Stimulsoft.Base.Licenses {
    import List = Stimulsoft.System.Collections.List;
    import DateTime = Stimulsoft.System.DateTime;
    class StiLicenseKey extends StiLicenseObject {
        activationDate: DateTime;
        signature: string;
        owner: string;
        userName: string;
        startDate: DateTime;
        endDate: DateTime;
        seviceId: string;
        planId: StiPlanIdent;
        products: List<StiLicenseProduct>;
        productName: string;
        productLogo: number[];
        productFavIcon: number[];
        productDescription: string;
        productUrl: string;
        clone(): StiLicenseKey;
        static get1(bytes: number[]): StiLicenseKey;
        static get2(str: string): StiLicenseKey;
        constructor();
    }
}
export namespace Stimulsoft.Base {
    class StiLicense {
        static licenseKey: any;
        static _key: string;
        static get key(): string;
        static set key(value: string);
        static get Key(): string;
        static set Key(value: string);
        static setNewLicenseKey(value: string, throwException?: boolean): void;
        private static isValidLicenseKey;
        static loadFromFile(file: string): void;
        static loadFromString(licenseKey: string): void;
    }
}
export namespace Stimulsoft.Base.Licenses {
    class StiLicenseActivationResponse extends StiLicenseObject {
        encryptKey: string;
        licenseKey: StiLicenseKey;
        exception: string;
        resultSuccess: boolean;
        resultNotice: StiNotice;
    }
}
export namespace Stimulsoft.Base.Licenses {
    class StiLicenseKeyContainer extends StiKeyObject {
        checkSum: string;
        license: number[];
    }
}
export namespace Stimulsoft.Base.Licenses {
    import StiProductIdent = Stimulsoft.Base.Licenses.StiProductIdent;
    class StiLicenseKeyValidator {
        private static indexValidator;
        static isValidOn(ident: StiProductIdent): boolean;
        static isValidOnDbsJS(): boolean;
        static isValidOnAnyDbs(): boolean;
        static isValidOnJS(): boolean;
        static isValidOnAnyReports(): boolean;
        static isValidOnAnyPlatform(): boolean;
        static isValidOnBI(): boolean;
        private static isJSPlatform;
        private static isAnyDbsPlatform;
        private static isAnyReportsPlatform;
        private static isDbsJSPlatform;
        private static isBIPlatform;
        private static getLicenseKey;
    }
}
export namespace Stimulsoft.Base.Licenses {
    import DateTime = Stimulsoft.System.DateTime;
    class StiLicenseProduct {
        expirationDate: DateTime;
        ident: StiProductIdent;
    }
}
export namespace Stimulsoft.Base.Map {
    import List = Stimulsoft.System.Collections.List;
    let IStiMapKeyHelper: System.Interface<IStiMapKeyHelper>;
    interface IStiMapKeyHelper {
        getMapIdents(key: string): List<string>;
        getIsoAlpha2FromName(country: string, mapId: string, lang: string): string;
        getIsoAlpha3FromName(country: string, mapId: string, lang: string): string;
        getNameFromIsoAlpha2(alpha3: string, mapId: string, lang: string): string;
        getNameFromIsoAlpha3(alpha3: string, mapId: string, lang: string): string;
        normalizeName(name: string, mapId: string, lang: string, report: IStiReport): string;
    }
}
export namespace Stimulsoft.Base.Meta {
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import StiJson = Stimulsoft.Base.StiJson;
    class StiMeta<T = any> {
        jsName: string;
        getValue: (mode?: StiJsonSaveMode) => T | StiJson;
        checkValue: (mode?: StiJsonSaveMode) => boolean;
        setValue: (property: StiJson) => void;
        setValueXml: (node: XmlNode) => void;
        filterSaveMode: StiJsonSaveMode;
        originalName: string[];
        saveToJsonObject(jObject: StiJson, obj: any, mode?: StiJsonSaveMode): void;
        loadFromJsonObject(property: StiJson, obj: IStiJsonReportObject): void;
        loadFromXml(node: XmlNode, obj: IStiJsonReportObject): void;
        get(getValue: (mode?: StiJsonSaveMode) => T | StiJson): StiMeta<T>;
        check(checkValue: (mode?: StiJsonSaveMode) => boolean): StiMeta<T>;
        set(setValue: (property: StiJson) => void): StiMeta<T>;
        setXml(setValueXml: (value: XmlNode) => void): StiMeta<T>;
        constructor(originalName: string | string[], jsName?: string, getValue?: (mode?: StiJsonSaveMode) => T | StiJson, checkValue?: (mode?: StiJsonSaveMode) => boolean, setValue?: (property: StiJson) => void, setValueXml?: (node: XmlNode) => void, filterSaveMode?: StiJsonSaveMode);
    }
}
export namespace Stimulsoft.Base.Meta {
    import StiJson = Stimulsoft.Base.StiJson;
    class StiBoolMeta extends StiMeta<boolean> {
        defaultValue: boolean;
        ignoreDefaultValues: boolean;
        saveToJsonObject(jObject: StiJson, obj: any): void;
        constructor(originalName: string | string[], jsName?: string, defaultValue?: boolean, ignoreDefaultValues?: boolean);
    }
}
export namespace Stimulsoft.Base.Meta {
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    import StiJson = Stimulsoft.Base.StiJson;
    class StiBrushMeta extends StiMeta<StiBrush> {
        defaultValue: StiBrush;
        saveToJsonObject(jObject: StiJson, obj: any): void;
        constructor(originalName: string | string[], jsName?: string, defaultValue?: StiBrush);
    }
}
export namespace Stimulsoft.Base.Meta {
    import Color = Stimulsoft.System.Drawing.Color;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import StiJson = Stimulsoft.Base.StiJson;
    class StiColorMeta extends StiMeta<Color> {
        defaultValue: Color;
        saveToJsonObject(jObject: StiJson, obj: any, mode?: StiJsonSaveMode): void;
        constructor(originalName: string, jsName?: string, defaultValue?: Color, filterSaveMode?: StiJsonSaveMode);
    }
}
export namespace Stimulsoft.Base.Meta {
    import StiJson = Stimulsoft.Base.StiJson;
    class StiEnumMeta extends StiMeta {
        enumType: any;
        defaultValue: any;
        saveToJsonObject(jObject: StiJson, obj: any): void;
        constructor(originalName: string | string[], jsName: string, enumType: any, defaultValue?: any);
    }
}
export namespace Stimulsoft.Base.Meta {
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import StiJson = Stimulsoft.Base.StiJson;
    class StiEventMeta extends StiMeta {
        eventType: any;
        saveToJsonObject(jObject: StiJson, obj: any, mode: StiJsonSaveMode): void;
        constructor(originalName: string, eventType: any);
    }
}
export namespace Stimulsoft.Base.Meta {
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import StiJson = Stimulsoft.Base.StiJson;
    class StiExpressionMeta extends StiMeta {
        saveToJsonObject(jObject: StiJson, obj: any, mode: StiJsonSaveMode): void;
        constructor(originalName: string | string[], jsName?: string);
    }
}
export namespace Stimulsoft.Base.Meta {
    import GraphicsUnit = Stimulsoft.System.Drawing.GraphicsUnit;
    import FontStyle = Stimulsoft.System.Drawing.FontStyle;
    import StiJson = Stimulsoft.Base.StiJson;
    import Font = Stimulsoft.System.Drawing.Font;
    class StiFontMeta extends StiMeta<Font> {
        defaultFamily: string;
        defaultEmSize: number;
        defaultStyle: FontStyle;
        defaultUnit: GraphicsUnit;
        saveToJsonObject(jObject: StiJson, obj: any): void;
        constructor(originalName: string | string[], jsName?: string, defaultFamily?: string, defaultEmSize?: number, defaultStyle?: FontStyle, defaultUnit?: GraphicsUnit);
    }
}
export namespace Stimulsoft.Base.Meta {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import StiJson = Stimulsoft.Base.StiJson;
    class StiMetaHelper {
        static saveToJsonObject(mode: StiJsonSaveMode, obj: {
            meta(): StiMeta[];
        }, jObject?: StiJson): StiJson;
        static loadFromJsonObject(jObject: StiJson, obj: any): void;
        static loadFromXml(xmlNode: XmlNode, obj: any): void;
    }
}
export namespace Stimulsoft.Base.Meta {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import StiJson = Stimulsoft.Base.StiJson;
    class StiNumberMeta extends StiMeta<number> {
        defaultValue: number;
        saveToJsonObject(jObject: StiJson, obj: any): void;
        constructor(originalName: string | string[], jsName?: string, defaultValue?: number);
    }
}
export namespace Stimulsoft.Base.Meta {
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    class StiObjectMeta extends StiMeta<IStiJsonReportObject> {
        constructor(originalName: string | string[], jsName?: string);
    }
}
export namespace Stimulsoft.Base.Meta {
    import StiJson = Stimulsoft.Base.StiJson;
    class StiRemoveMeta extends StiMeta {
        saveToJsonObject(jObject: StiJson, obj?: any): void;
        constructor(originalName: string | string[]);
    }
}
export namespace Stimulsoft.Base.Meta {
    import Size = Stimulsoft.System.Drawing.Size;
    import StiJson = Stimulsoft.Base.StiJson;
    class StiSizeMeta extends StiMeta<Size> {
        defaultValue: Size;
        saveToJsonObject(jObject: StiJson, obj: any): void;
        constructor(originalName: string, jsName?: string, defaultValue?: Size);
    }
}
export namespace Stimulsoft.Base.Meta {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import StiJson = Stimulsoft.Base.StiJson;
    class StiStringMeta extends StiMeta<string> {
        defaulString: string;
        saveToJsonObject(jObject: StiJson, obj: any): void;
        constructor(originalName: string | string[], jsName?: string, defaulString?: string);
    }
}
export namespace Stimulsoft.Base.Meta {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import StiJson = Stimulsoft.Base.StiJson;
    class StiStringNullOrEmptyMeta extends StiMeta<string> {
        saveToJsonObject(jObject: StiJson, obj: any, mode?: StiJsonSaveMode): void;
        constructor(originalName: string | string[], jsName?: string, filterSaveMode?: StiJsonSaveMode);
    }
}
export namespace Stimulsoft.Base.Meters {
    let IStiArgumentMeter: System.Interface<IStiArgumentMeter>;
    interface IStiArgumentMeter {
    }
}
export namespace Stimulsoft.Base.Meters {
    import Color = Stimulsoft.System.Drawing.Color;
    let IStiBubbleColumn: System.Interface<IStiBubbleColumn>;
    interface IStiBubbleColumn {
        allowCustomColors: boolean;
        positiveColor: Color;
        negativeColor: Color;
    }
}
export namespace Stimulsoft.Base.Meters {
    import StiCardsColumnVisibility = Stimulsoft.Base.Drawing.StiCardsColumnVisibility;
    let IStiCardsColumn: System.Interface<IStiCardsColumn>;
    interface IStiCardsColumn {
        visibility: StiCardsColumnVisibility;
        visibilityExpression: string;
        height: number;
        wrapLine: boolean;
    }
}
export namespace Stimulsoft.Base.Meters {
    let IStiColorMapMeter: System.Interface<IStiColorMapMeter>;
    interface IStiColorMapMeter {
    }
}
export namespace Stimulsoft.Base.Meters {
    import Color = Stimulsoft.System.Drawing.Color;
    let IStiColorScaleColumn: System.Interface<IStiColorScaleColumn>;
    interface IStiColorScaleColumn {
        minimumColor: Color;
        maximumColor: Color;
    }
}
export namespace Stimulsoft.Base.Meters {
    import Color = Stimulsoft.System.Drawing.Color;
    let IStiDataBarsColumn: System.Interface<IStiDataBarsColumn>;
    interface IStiDataBarsColumn {
        width: number;
        positiveColor: Color;
        negativeColor: Color;
        overlappedColor: Color;
        fillColor: Color;
        minimum: string;
        maximum: string;
    }
}
export namespace Stimulsoft.Base.Meters {
    let IStiDimensionCardsColumn: System.Interface<IStiDimensionCardsColumn>;
    interface IStiDimensionCardsColumn {
    }
}
export namespace Stimulsoft.Base.Meters {
    let IStiDimensionColumn: System.Interface<IStiDimensionColumn>;
    interface IStiDimensionColumn {
        showHyperlink: boolean;
        hyperlinkPattern: string;
    }
}
export namespace Stimulsoft.Base.Meters {
    let IStiDimensionMeter: System.Interface<IStiDimensionMeter>;
    interface IStiDimensionMeter extends IStiMeter {
    }
}
export namespace Stimulsoft.Base.Meters {
    let IStiGroupMapMeter: System.Interface<IStiGroupMapMeter>;
    interface IStiGroupMapMeter {
    }
}
export namespace Stimulsoft.Base.Meters {
    let IStiIndicatorColumn: System.Interface<IStiIndicatorColumn>;
    interface IStiIndicatorColumn {
    }
}
export namespace Stimulsoft.Base.Meters {
    let IStiKeyMapMeter: System.Interface<IStiKeyMapMeter>;
    interface IStiKeyMapMeter {
    }
}
export namespace Stimulsoft.Base.Meters {
    let IStiLocalizedMeter: System.Interface<IStiLocalizedMeter>;
    interface IStiLocalizedMeter {
        localizedName: string;
    }
}
export namespace Stimulsoft.Base.Meters {
    let IStiMaxGaugeMeter: System.Interface<IStiMaxGaugeMeter>;
    interface IStiMaxGaugeMeter extends IStiMeter {
    }
}
export namespace Stimulsoft.Base.Meters {
    let IStiMeasureCardsColumn: System.Interface<IStiDimensionCardsColumn>;
    interface IStiMeasureCardsColumn {
    }
}
export namespace Stimulsoft.Base.Meters {
    let IStiMeasureColumn: System.Interface<IStiMeasureColumn>;
    interface IStiMeasureColumn {
    }
}
export namespace Stimulsoft.Base.Meters {
    let IStiMeasureMeter: System.Interface<IStiMeasureMeter>;
    interface IStiMeasureMeter extends IStiMeter {
    }
}
export namespace Stimulsoft.Base.Meters {
    import ICloneable = Stimulsoft.System.ICloneable;
    import IAsIs = Stimulsoft.System.IAsIs;
    let IStiMeter: System.Interface<IStiMeter>;
    interface IStiMeter extends IAsIs, ICloneable {
        getUniqueCode(): number;
        key: string;
        expression: string;
        label: string;
    }
}
export namespace Stimulsoft.Base.Meters {
    let IStiMinGaugeMeter: System.Interface<IStiMinGaugeMeter>;
    interface IStiMinGaugeMeter extends IStiMeter {
    }
}
export namespace Stimulsoft.Base.Meters {
    let IStiNameMapMeter: System.Interface<IStiNameMapMeter>;
    interface IStiNameMapMeter {
    }
}
export namespace Stimulsoft.Base.Meters {
    let IStiPivotColumn: System.Interface<IStiPivotColumn>;
    interface IStiPivotColumn {
        showTotal: boolean;
        totalLabel: string;
        strSortDirection: string;
        expandExpression: string;
    }
}
export namespace Stimulsoft.Base.Meters {
    let IStiPivotRow: System.Interface<IStiPivotRow>;
    interface IStiPivotRow {
        showTotal: boolean;
        totalLabel: string;
        strSortDirection: string;
        expandExpression: string;
    }
}
export namespace Stimulsoft.Base.Meters {
    let IStiPivotSummary: System.Interface<IStiPivotSummary>;
    interface IStiPivotSummary {
        hideZeros: boolean;
    }
}
export namespace Stimulsoft.Base.Meters {
    let IStiSeriesMeter: System.Interface<IStiSeriesMeter>;
    interface IStiSeriesMeter {
    }
}
export namespace Stimulsoft.Base.Meters {
    import Color = Stimulsoft.System.Drawing.Color;
    let IStiSparklinesColumn: System.Interface<IStiSparklinesColumn>;
    interface IStiSparklinesColumn {
        allowCustomColors: boolean;
        showHighLowPoints: boolean;
        showFirstLastPoints: boolean;
        positiveColor: Color;
        negativeColor: Color;
    }
}
export namespace Stimulsoft.Base.Meters {
    import StiHorAlignment = Stimulsoft.Base.Drawing.StiHorAlignment;
    import StiTableColumnVisibility = Stimulsoft.Base.Drawing.StiTableColumnVisibility;
    let IStiTableColumn: System.Interface<IStiTableColumn>;
    interface IStiTableColumn {
        visible: boolean;
        showTotalSummary: boolean;
        summaryType: StiSummaryColumnType;
        visibility: StiTableColumnVisibility;
        visibilityExpression: string;
        summaryAlignment: StiHorAlignment;
        headerAlignment: StiHorAlignment;
    }
}
export namespace Stimulsoft.Base.Meters {
    let IStiTargetMeter: System.Interface<IStiTargetMeter>;
    interface IStiTargetMeter {
    }
}
export namespace Stimulsoft.Base.Meters {
    let IStiValueMapMeter: System.Interface<IStiValueMapMeter>;
    interface IStiValueMapMeter {
    }
}
export namespace Stimulsoft.Base.Meters {
    let IStiValueMeter: System.Interface<IStiValueMeter>;
    interface IStiValueMeter {
    }
}
export namespace Stimulsoft.Base {
    enum StiNoticeIdent {
        ActivationMaxActivationsReached = 1,
        ActivationExpiriedBeforeFirstRelease = 2,
        ActivationLicenseIsNotCorrect = 3,
        ActivationLockedAccount = 4,
        ActivationServerVersionNotAllowed = 5,
        ActivationServerIsNotAvailableNow = 6,
        ActivationSomeTroublesOccurred = 7,
        ActivationUserNameOrPasswordIsWrong = 8,
        ActivationWrongAccountType = 9,
        AuthAccountCantBeUsedNow = 10,
        AuthAccountIsNotActivated = 11,
        AuthCantChangeSystemRole = 12,
        AuthCantChangeRoleBecauseLastAdministratorUser = 13,
        AuthCantChangeRoleBecauseLastSupervisorUser = 14,
        AuthCantDeleteHimselfUser = 15,
        AuthCantDeleteLastAdministratorUser = 16,
        AuthCantDeleteLastSupervisorUser = 17,
        AuthCantDeleteSystemRole = 18,
        AuthCantDisableUserBecauseLastAdministratorUser = 19,
        AuthCantDisableUserBecauseLastSupervisorUser = 20,
        AuthOAuthIdNotSpecified = 21,
        AuthPasswordIsTooShort = 22,
        AuthPasswordIsNotSpecified = 23,
        AuthPasswordIsNotCorrect = 24,
        AuthRequestsLimitIsExceeded = 25,
        AuthRoleCantBeDeletedBecauseUsedByUsers = 26,
        AuthRoleNameAlreadyExists = 27,
        AuthRoleNameIsSystemRole = 28,
        AuthUserHasLoggedOut = 29,
        AuthUserNameAlreadyExists = 30,
        AuthUserNameIsNotSpecified = 31,
        AuthUserNameOrPasswordIsNotCorrect = 32,
        AuthUserNameShouldLookLikeAnEmailAddress = 33,
        AuthWorkspaceNameAlreadyInUse = 34,
        CommandTimeOut = 35,
        CustomMessage = 36,
        ExecutionError = 37,
        IsNotAuthorized = 38,
        IsNotDeleted = 39,
        IsNotCorrect = 40,
        IsNotEqual = 41,
        IsNotFound = 42,
        IsNotRecognized = 43,
        IsNotSpecified = 44,
        ItemCantBeDeletedBecauseItemIsAttachedToOtherItems = 45,
        ItemCantBeMovedToSpecifiedPlace = 46,
        ItemDoesNotSupport = 47,
        KeyAndToKeyIsEqual = 48,
        NotificationFailed = 49,
        NotificationFileUploading = 50,
        NotificationFilesUploadingComplete = 51,
        NotificationItemDelete = 52,
        NotificationItemDeleteComplete = 53,
        NotificationItemRestore = 54,
        NotificationItemRestoreComplete = 55,
        NotificationItemTransfer = 56,
        NotificationItemTransferComplete = 57,
        NotificationItemWaitingProcessing = 58,
        NotificationOperationAborted = 59,
        NotificationRecycleBinCleaning = 60,
        NotificationRecycleBinCleaningComplete = 61,
        NotificationRecycleBinWaitingProcessing = 62,
        NotificationReportCompiling = 63,
        NotificationReportDataProcessing = 64,
        NotificationReportExporting = 65,
        NotificationReportExportingComplete = 66,
        NotificationReportRendering = 67,
        NotificationReportRenderingComplete = 68,
        NotificationReportSaving = 69,
        NotificationReportWaitingProcessing = 70,
        NotificationSchedulerRunning = 71,
        NotificationSchedulerRunningComplete = 72,
        NotificationSchedulerWaitingProcessing = 73,
        NotificationTransferring = 74,
        NotificationTransferringComplete = 75,
        NotificationTitleFilesUploading = 76,
        NotificationTitleItemRefreshing = 77,
        NotificationTitleItemTransferring = 78,
        NotificationTitleReportExporting = 79,
        NotificationTitleReportRendering = 80,
        NotificationTitleSchedulerRunning = 81,
        QuotaMaximumComputingCyclesCountExceeded = 82,
        QuotaMaximumFileSizeExceeded = 83,
        QuotaMaximumItemsCountExceeded = 84,
        QuotaMaximumReportPagesCountExceeded = 85,
        QuotaMaximumUsersCountExceeded = 86,
        QuotaMaximumWorkspacesCountExceeded = 87,
        AccessDenied = 88,
        OutOfRange = 89,
        ParsingCommandException = 90,
        SchedulerCantRunItSelf = 91,
        SessionTimeOut = 92,
        SnapshotAlreadyProcessed = 93,
        SpecifiedItemIsNot = 94,
        WithSpecifiedKeyIsNotFound = 95,
        VersionCopyFromItem = 96,
        VersionCreatedFromFile = 97,
        VersionCreatedFromItem = 98,
        VersionNewItemCreation = 99,
        VersionLoadedFromFile = 100
    }
}
export namespace Stimulsoft.Base {
    class StiNotice {
        ident: StiNoticeIdent;
        arguments: string[];
        customMessage: string;
    }
}
export namespace Stimulsoft.Base.Services {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IAsIs = Stimulsoft.System.IAsIs;
    import StiRepositoryItems = Stimulsoft.Base.StiRepositoryItems;
    import ICloneable = Stimulsoft.System.ICloneable;
    class StiService implements ICloneable, IAsIs {
        clone(cloneProperties?: boolean, cloneComponents?: boolean, base?: boolean): any;
        memberwiseClone(base?: boolean): StiService;
        implements(): any[];
        is<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): this is T;
        is2<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): boolean;
        as<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): T;
        protected _hash: StiMeta[];
        meta(): StiMeta[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        loadFromXml(xmlNode: XmlNode): void;
        isPropertyPresent(key: any): boolean;
        private _properties;
        get properties(): StiRepositoryItems;
        set properties(value: StiRepositoryItems);
        protected isPropertiesInitializedProtected(): boolean;
        get serviceCategory(): string;
        get serviceName(): string;
        get serviceInfo(): string;
        get serviceType(): Stimulsoft.System.Type;
        get serviceEnabled(): boolean;
        set serviceEnabled(value: boolean);
    }
}
export namespace Stimulsoft.Base.SignatureFonts {
    enum StiSignatureStyle {
        Style1 = 0,
        Style2 = 1,
        Style3 = 2
    }
}
export namespace Stimulsoft.Base {
    import StiSignatureStyle = Stimulsoft.Base.SignatureFonts.StiSignatureStyle;
    class StiSignatureFontsHelper {
        static getFontName(style: StiSignatureStyle): string;
    }
}
export namespace Stimulsoft.ExternalLibrary.JSZip {
    interface JSZip {
        file(path: string): JSZipObject;
        file(path: RegExp): JSZipObject[];
        file(path: string, data: any, options?: JSZipFileOptions): JSZip;
        folder(name: string): JSZip;
        folder(name: RegExp): JSZipObject[];
        filter(predicate: (relativePath: string, file: JSZipObject) => boolean): JSZipObject[];
        remove(path: string): JSZip;
        generate(options?: JSZipGeneratorOptions): any;
        load(data: any, options: JSZipLoadOptions): JSZip;
    }
    interface JSZipObject {
        name: string;
        dir: boolean;
        date: Date;
        comment: string;
        options: JSZipObjectOptions;
        asText(): string;
        asBinary(): string;
        asArrayBuffer(): ArrayBuffer;
        asUint8Array(): Uint8Array;
    }
    interface JSZipFileOptions {
        base64?: boolean;
        binary?: boolean;
        date?: Date;
        compression?: string;
        comment?: string;
        optimizedBinaryString?: boolean;
        createFolders?: boolean;
    }
    interface JSZipObjectOptions {
        base64: boolean;
        binary: boolean;
        dir: boolean;
        date: Date;
        compression: string;
    }
    interface JSZipGeneratorOptions {
        base64?: boolean;
        compression?: string;
        type?: string;
        comment?: string;
    }
    interface JSZipLoadOptions {
        base64?: boolean;
        checkCRC32?: boolean;
        optimizedBinaryString?: boolean;
        createFolders?: boolean;
    }
    interface JSZipSupport {
        arraybuffer: boolean;
        uint8array: boolean;
        blob: boolean;
        nodebuffer: boolean;
    }
    interface DEFLATE {
        compress(input: string | number[] | Uint8Array, compressionOptions: {
            level: number;
        }): Uint8Array;
        uncompress(input: string | number[] | Uint8Array): Uint8Array;
    }
    let prototype: JSZip;
    let support: JSZipSupport;
    let compressions: {
        DEFLATE: DEFLATE;
    };
}
export namespace Stimulsoft.ExternalLibrary {
    function JSZip(data?: any, options?: Stimulsoft.ExternalLibrary.JSZip.JSZipLoadOptions): Stimulsoft.ExternalLibrary.JSZip.JSZip;
}
export namespace Stimulsoft.Base {
    class StiGZipHelper {
        private static DefaultLevel;
        private static DefaultMethod;
        private static ID1;
        private static ID2;
        private static _crcTable;
        static get crcTable(): number[];
        static crc32(data: number[]): number;
        private static putByte;
        private static putShort;
        private static putLong;
        private static putString;
        private static readByte;
        private static readShort;
        private static readLong;
        private static readString;
        private static readBytes;
        static pack(data2: string | number[] | Uint8Array, name?: string): string | number[];
        static unpack<B extends boolean>(data: string | number[] | Uint8Array, returnString: B): B extends true ? string : number[];
    }
}
export namespace Stimulsoft.Base.Zip {
    import DateTime = Stimulsoft.System.DateTime;
    import MemoryStream = Stimulsoft.System.IO.MemoryStream;
    class StiZipWriter20 {
        static convertToArray(useUnicode: boolean, str: string): number[];
        static getDosTime(dt: DateTime): number;
        private _mainStream;
        private zip;
        begin(stream: MemoryStream, leaveOpen: boolean): void;
        addFile(fileName: string, dataStream: MemoryStream, closeDataStream?: boolean): void;
        end(): void;
        constructor();
    }
}
export namespace Stimulsoft.Data.Helpers {
    import DateTime = Stimulsoft.System.DateTime;
    class StiDateTimeCorrector {
        static correct(dateTime: DateTime): DateTime;
    }
}
export namespace Stimulsoft.Data.Comparers {
    class StiObjectComparer {
        equals(x: any, y: any): boolean;
        getHashCode(x: any): number;
        static readonly default: StiObjectComparer;
        static compare(x: any, y: any): number;
        private static defaultCompare;
        private static dateTimeCompare;
        private static arrayCompare;
    }
}
export namespace Stimulsoft.Data.Comparers {
    import IComparer = Stimulsoft.System.Collections.IComparer;
    class StiArrayComparer implements IComparer<any[]> {
        compare(x: any[], y: any[]): number;
    }
}
export namespace Stimulsoft.Data.Comparers {
    import IEqualityComparer = Stimulsoft.System.Collections.IEqualityComparer;
    class StiArrayEqualityComparer implements IEqualityComparer<any[]> {
        equals(x: any[], y: any[]): boolean;
        getHashCode(x: any[]): number;
    }
}
export namespace Stimulsoft.Data.Comparers {
    import StiDataActionRule = Stimulsoft.Data.Engine.StiDataActionRule;
    import IComparer = Stimulsoft.System.Collections.IComparer;
    class StiDataActionComparer implements IComparer<StiDataActionRule> {
        compare(x: StiDataActionRule, y: StiDataActionRule): number;
    }
}
export namespace Stimulsoft.Data.Comparers {
    import IComparer = Stimulsoft.System.Collections.IComparer;
    import DataRow = Stimulsoft.System.Data.DataRow;
    class StiDataRowComparer implements IComparer<DataRow> {
        compare(x: DataRow, y: DataRow): number;
    }
}
export namespace Stimulsoft.Data.Engine {
    enum StiDataJoinType {
        Inner = 1,
        Left = 2,
        Right = 3,
        Cross = 4,
        Full = 5
    }
    enum StiDataSortDirection {
        Ascending = 1,
        Descending = 2,
        None = 3
    }
    enum StiDataFilterCondition {
        EqualTo = 0,
        NotEqualTo = 1,
        GreaterThan = 2,
        GreaterThanOrEqualTo = 3,
        LessThan = 4,
        LessThanOrEqualTo = 5,
        Between = 6,
        NotBetween = 7,
        Containing = 8,
        NotContaining = 9,
        BeginningWith = 10,
        EndingWith = 11,
        IsNull = 12,
        IsNotNull = 13,
        IsBlank = 14,
        IsNotBlank = 15,
        IsBlankOrNull = 16,
        IsFalse = 17,
        PairEqualTo = 18,
        MapEqualTo = 19
    }
    enum StiDataFilterOperation {
        AND = 0,
        OR = 1
    }
    enum StiDataActionType {
        Limit = 0,
        Replace = 1,
        RunningTotal = 2,
        Percentage = 3
    }
    enum StiDataFilterConditionGroupType {
        Equal = 0,
        NotEqual = 1,
        Custom = 2,
        Empty = 3
    }
    enum StiDataRequestOption {
        None = 0,
        AllowOpenConnections = 1,
        AllowDataSort = 2,
        DisallowTransform = 4,
        All = 3
    }
    enum StiDataTopNMode {
        None = 0,
        Top = 1,
        Bottom = 2
    }
    enum StiDataFormatKind {
        General = 0,
        Boolean = 1,
        Currency = 2,
        Date = 3,
        Number = 4,
        Percentage = 5,
        Time = 6
    }
    enum StiDataJoinEngine {
        V1 = 0,
        V2 = 1,
        V3 = 2,
        V4 = 3,
        V5 = 4
    }
    enum StiTableFiltersGroupsType {
        None = 0,
        Simple = 1,
        Complex = 2
    }
    enum StiDataActionPriority {
        BeforeTransformation = 0,
        AfterGroupingData = 1,
        AfterSortingData = 2
    }
}
export namespace Stimulsoft.Data.Engine {
    let IStiAllowSortByVariation: System.Interface<IStiAllowSortByVariation>;
    let ImplementsIStiAllowSortByVariation: any[];
    interface IStiAllowSortByVariation {
    }
}
export namespace Stimulsoft.Data.Engine {
    let IStiCrossFiltering: System.Interface<IStiCrossFiltering>;
    let ImplementsIStiCrossFiltering: any[];
    interface IStiCrossFiltering {
        crossFiltering: boolean;
    }
}
export namespace Stimulsoft.Data.Engine {
    import List = Stimulsoft.System.Collections.List;
    let IStiDataFilters: System.Interface<IStiDataFilters>;
    let ImplementsIStiDataFilters: any[];
    interface IStiDataFilters {
        dataFilters: List<StiDataFilterRule>;
    }
}
export namespace Stimulsoft.Data.Engine {
    let IStiDataFormat: System.Interface<IStiDataFormat>;
    interface IStiDataFormat {
        getDataFormat(): StiDataFormatKind;
    }
}
export namespace Stimulsoft.Data.Engine {
    let IStiDataTopN: System.Interface<IStiDataTopN>;
    let ImplementsIStiDataTopN: any[];
    interface IStiDataTopN {
        topN: StiDataTopN;
    }
}
export namespace Stimulsoft.Data.Engine {
    let IStiDataTransformationElement: System.Interface<IStiDataTransformationElement>;
    let ImplementsIStiDataTransformationElement: any[];
    interface IStiDataTransformationElement {
        dataTransformation: any;
        isDefaultDataTransformation(): boolean;
    }
}
export namespace Stimulsoft.Data.Engine {
    import List = Stimulsoft.System.Collections.List;
    let IStiDrillDownElement: System.Interface<IStiDrillDownElement>;
    let ImplementsIStiDrillDownElement: any[];
    interface IStiDrillDownElement {
        drillDownFilters: List<StiDataFilterRule>;
        drillDownFiltersList: List<List<StiDataFilterRule>>;
        drillDownCurrentLevel: number;
        drillDownLevelCount: number;
    }
}
export namespace Stimulsoft.Data.Engine {
    import List = Stimulsoft.System.Collections.List;
    let IStiRetrieval: System.Interface<IStiRetrieval>;
    let ImplementsIStiRetrieval: any[];
    interface IStiRetrieval {
        retrieveUsedDataNames(group: string): List<string>;
    }
}
export namespace Stimulsoft.Data.Engine {
    import List = Stimulsoft.System.Collections.List;
    import IStiRetrieval = Stimulsoft.Data.Engine.IStiRetrieval;
    import IStiAppDictionary = Stimulsoft.Base.IStiAppDictionary;
    import IStiAppDataSource = Stimulsoft.Base.IStiAppDataSource;
    let IStiQueryObject: System.Interface<IStiQueryObject>;
    let ImplementsIStiQueryObject: any[];
    interface IStiQueryObject extends IStiRetrieval {
        getDictionary(): IStiAppDictionary;
        getDataSources(dataNames: List<string>): List<IStiAppDataSource>;
    }
}
export namespace Stimulsoft.Data.Engine {
    let IStiSkipNormalizeDate: System.Interface<IStiSkipNormalizeDate>;
    interface IStiSkipNormalizeDate {
    }
}
export namespace Stimulsoft.Data.Engine {
    import List = Stimulsoft.System.Collections.List;
    let IStiTransformActions: System.Interface<IStiTransformActions>;
    let ImplementsIStiTransformActions: any[];
    interface IStiTransformActions {
        transformActions: List<StiDataActionRule>;
    }
}
export namespace Stimulsoft.Data.Engine {
    import List = Stimulsoft.System.Collections.List;
    let IStiTransformFilters: System.Interface<IStiTransformFilters>;
    let ImplementsIStiTransformFilters: any[];
    interface IStiTransformFilters {
        transformFilters: List<StiDataFilterRule>;
    }
}
export namespace Stimulsoft.Data.Engine {
    import List = Stimulsoft.System.Collections.List;
    let IStiTransformSorts: System.Interface<IStiTransformSorts>;
    let ImplementsIStiTransformSorts: any[];
    interface IStiTransformSorts {
        transformSorts: List<StiDataSortRule>;
    }
}
export namespace Stimulsoft.Data.Engine {
    import IAsIs = Stimulsoft.System.IAsIs;
    import List = Stimulsoft.System.Collections.List;
    let IStiUserFilters: System.Interface<IStiUserFilters>;
    let ImplementsIStiUserFilters: any[];
    interface IStiUserFilters extends IAsIs {
        userFilters: List<StiDataFilterRule>;
    }
}
export namespace Stimulsoft.Data.Engine {
    import List = Stimulsoft.System.Collections.List;
    let IStiUserSorts: System.Interface<IStiUserSorts>;
    let ImplementsIStiUserSorts: any[];
    interface IStiUserSorts {
        userSorts: List<StiDataSortRule>;
    }
}
export namespace Stimulsoft.Data.Expressions.NCalc.Domain {
    abstract class LogicalExpressionVisitor {
        abstract visit1(expression: LogicalExpression): any;
        abstract visit2(expression: TernaryExpression): any;
        abstract visit3(expression: BinaryExpression): any;
        abstract visit4(expression: UnaryExpression): any;
        abstract visit5(expression: ValueExpression): any;
        abstract visit6(expression: Functionn): any;
        abstract visit7(expression: Identifier): any;
    }
}
export namespace Stimulsoft.Data.Helpers {
    import IStiReport = Stimulsoft.Base.IStiReport;
    import LogicalExpression = Stimulsoft.Data.Expressions.NCalc.Domain.LogicalExpression;
    import List = Stimulsoft.System.Collections.List;
    class StiExpressionHelper {
        private static expressionToArguments;
        static newExpression(expression: string): Stimulsoft.Data.Expressions.NCalc.Expression;
        static prepareExpression(expression: string): string;
        static escapeExpression(expression: string): string;
        static replaceFunction(expression: string, newFunction: string): string;
        static removeFunction(expression: string): string;
        static isPercentOfGrandTotal(expression: string): boolean;
        static isAggregationFunctionPresent(expression: string): boolean;
        static isFunctionPresent(expression: string): boolean;
        static getFunction(expression: string): string;
        static getArguments(expression: string): List<string>;
        static compile(expression: string): LogicalExpression;
        static getFirstArgumentFromExpression(expression: string): string;
        static parseReportExpression(report: IStiReport, text: string, withBraces: boolean, allowReturnNull?: boolean): string;
        static fetchBlocksFromExpression(inputExpression: string): List<string>;
        static replaceExpressionBlocksByValues(inputExpression: string, values: List<string>): string;
        static isTimeExpression(str: string): boolean;
    }
}
export namespace Stimulsoft.Data.Extensions {
    import DataTable = Stimulsoft.System.Data.DataTable;
    import DataRelation = Stimulsoft.System.Data.DataRelation;
    import IStiMeter = Stimulsoft.Base.Meters.IStiMeter;
    import List = Stimulsoft.System.Collections.List;
    class DataTableExt {
        static nullTable: DataTable;
        static getUniqueName(table: DataTable, meter: IStiMeter): string;
        static getUniqueName2(table: DataTable, meter: IStiMeter, baseName: string): string;
        static getUniqueName3(table: DataTable, baseName: string): string;
        static parentRelationList(table: DataTable): List<DataRelation>;
        static childRelationList(table: DataTable): List<DataRelation>;
    }
}
export namespace Stimulsoft.Data.Extensions {
    import DataTable = Stimulsoft.System.Data.DataTable;
    import StiDataTable = Stimulsoft.Data.Engine.StiDataTable;
    class StiDataTableExt {
        static toNetTable(table: StiDataTable, onlyColumns?: boolean, convertsArray?: boolean): DataTable;
    }
}
export namespace Stimulsoft.Data.Engine {
    import IStiReport = Stimulsoft.Base.IStiReport;
    import DataTable = Stimulsoft.System.Data.DataTable;
    import List = Stimulsoft.System.Collections.List;
    class StiDataActionOperator {
        private static lockObject;
        private static netCache;
        private static meterCache;
        static apply(inTable: DataTable, actions: List<StiDataActionRule>, report: IStiReport, hash: number): DataTable;
        static applyAfterTransformation(inTable: StiDataTable, actions: List<StiDataActionRule>, priority: StiDataActionPriority, report: IStiReport, hash: number): StiDataTable;
        static cleanCache(appKey: string): void;
        private static getCacheKey;
        private static getCacheKey2;
        private static getFromCache;
        private static getFromCache2;
        private static addToCache;
        private static addToCache2;
    }
}
export namespace Stimulsoft.Data.Engine {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import ICloneable = Stimulsoft.System.ICloneable;
    import StiJson = Stimulsoft.Base.StiJson;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    abstract class StiDataRule implements ICloneable {
        clone(): any;
        protected _hash: StiMeta[];
        meta(): StiMeta[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(j: StiJson): void;
        loadFromXml(xn: XmlNode): void;
        abstract getUniqueCode(): number;
    }
}
export namespace Stimulsoft.Data.Engine {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import StiDataActionPriority = Stimulsoft.Data.Engine.StiDataActionPriority;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiJson = Stimulsoft.Base.StiJson;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    class StiDataActionRule extends StiDataRule implements IStiJsonReportObject {
        meta(): StiMeta[];
        type: StiDataActionType;
        key: string;
        path: string;
        startIndex: number;
        rowsCount: number;
        initialValue: string;
        valueFrom: string;
        valueTo: string;
        matchCase: boolean;
        matchWholeWord: boolean;
        priority: StiDataActionPriority;
        static loadFromJson(json: StiJson): StiDataActionRule;
        static loadFromXml(xmlNode: XmlNode): StiDataActionRule;
        getUniqueCode(): number;
        static create1(key: string, path: string): StiDataActionRule;
        static create2(key: string, path: string, startIndex: number, rowsCount: number, priority?: StiDataActionPriority): StiDataActionRule;
        static create3(key: string, path: string, valueFrom: string, valueTo: string, matchCase: boolean, matchWholeWord: boolean): StiDataActionRule;
        static create4(key: string, path: string, initialValue: string): StiDataActionRule;
        constructor(key?: string, path?: string, type?: StiDataActionType, startIndex?: number, rowsCount?: number, priority?: StiDataActionPriority, valueFrom?: string, valueTo?: string, matchCase?: boolean, matchWholeWord?: boolean, initialValue?: string);
    }
}
export namespace Stimulsoft.Data.Engine {
    import IStiReport = Stimulsoft.Base.IStiReport;
    import List = Stimulsoft.System.Collections.List;
    import DataTable = Stimulsoft.System.Data.DataTable;
    class StiDataActionRuleHelper {
        static toList(...rules: StiDataActionRule[]): List<StiDataActionRule>;
        static validate(rules: List<StiDataActionRule>, columnKeys: List<string>): List<StiDataActionRule>;
        private static getColumnIndex;
        static applyActions(table: DataTable, actions: List<StiDataActionRule>, columnKeys: List<string>, columnNames: List<string>, report: IStiReport): void;
        private static applyLimitAction;
        private static applyReplaceAction;
        private static applyRunningTotalAction;
        private static applyPercentageAction;
    }
}
export namespace Stimulsoft.Data.Engine {
    import List = Stimulsoft.System.Collections.List;
    import IStiMeter = Stimulsoft.Base.Meters.IStiMeter;
    class StiDataAnalyzer {
        static analyze(query: IStiQueryObject, group: string, meters: List<IStiMeter>, option?: StiDataRequestOption, userSorts?: List<StiDataSortRule>, userFilters?: List<StiDataFilterRule>, dataFilters?: List<StiDataFilterRule>, dataActions?: List<StiDataActionRule>, transformSorts?: List<StiDataSortRule>, transformFilters?: List<StiDataFilterRule>, transformActions?: List<StiDataActionRule>, drillDownFilters?: List<StiDataFilterRule>): Promise<StiDataTable>;
        private static unionFilters;
        private static unionNames;
        private static getUniqueCode;
        private static getUniqueCode2;
    }
}
export namespace Stimulsoft.Data.Engine {
    class StiDataColumnRuleHelper {
        static isGoodColumnName(columnName: string): boolean;
        static getGoodColumnName(columnName: string): string;
        private static keywords;
    }
}
export namespace Stimulsoft.Data.Engine {
    import IStiAppConnection = Stimulsoft.Base.IStiAppConnection;
    import List = Stimulsoft.System.Collections.List;
    class StiDataConnections {
        private static connections;
        static isConnectionActive(connection: IStiAppConnection): boolean;
        static registerConnection(connection: IStiAppConnection, items: List<object>): void;
        static unRegisterConnections(connections: List<IStiAppConnection>): List<object>;
        static unRegisterConnection(connection: IStiAppConnection): List<object>;
    }
}
export namespace Stimulsoft.Data.Extensions {
    import List = Stimulsoft.System.Collections.List;
    import DateTime = Stimulsoft.System.DateTime;
    class ListExt extends List<any> {
        static compare(a: any, b: any): any;
        private static compareValues;
        static isList(value: any): boolean;
        static isBoolList(value: any): boolean;
        static toList(value: any): List<any>;
        static toStringList(value: any): List<string>;
        static toNumberList(value: any): List<number>;
        static toBoolList(value: any): List<boolean>;
        static toNullableDateTimeList(value: any): List<DateTime | null>;
        static toArray(value: any): any[];
        static toStringArray(value: any): string[];
        static toNumberArray(value: any): number[];
        static add(a: any, b: any): List<any>;
    }
}
export namespace Stimulsoft.Data.Exceptions {
    abstract class StiDataException {
        message: string;
        constructor(message?: string);
    }
}
export namespace Stimulsoft.Data.Exceptions {
    class StiArgumentNotFoundException extends StiDataException {
        private _functionName;
        get functionName(): string;
        private _argumentName;
        get argumentName(): string;
        constructor(functionName: string, argumentName: string);
    }
}
export namespace Stimulsoft.Data.Exceptions {
    class StiArgumentCountException extends StiDataException {
        private _functionName;
        get functionName(): string;
        constructor(functionName: string);
    }
}
export namespace Stimulsoft.Data.Exceptions {
    class StiFunctionNotFoundException extends StiDataException {
        private _name;
        get name(): string;
        constructor(name: string);
    }
}
export namespace Stimulsoft.Data.Types {
    class SimpleValue {
        private _value;
        get value(): any;
        constructor(value: any);
    }
}
export namespace Stimulsoft.Data.Options {
    import MidpointRounding = Stimulsoft.System.MidpointRounding;
    class StiDataOptions {
        static allowNulls: boolean;
        static roundType: MidpointRounding;
    }
}
export namespace Stimulsoft.Data.Types {
    import DateTime = Stimulsoft.System.DateTime;
    class DateTimeValue {
        value: DateTime;
        constructor(value: any);
    }
}
export namespace Stimulsoft.Data.Functions {
    import DateTime = Stimulsoft.System.DateTime;
    class StiMonthToStrHelper {
        private static months;
        private static defaultUpperCaseList;
        private static cultureIndexes;
        static monthName(dateTime: DateTime): string;
        static monthName2(dateTime: DateTime, localized: boolean): string;
        static monthName3(dateTime: DateTime, culture: string): string;
        static monthName4(dateTime: DateTime, culture: string, upperCase: boolean): string;
        static monthName5(month: StiMonth, culture: string): string;
        static addCulture(monthNames: string[], cultureNames: string[], defaultUpperCase: boolean): void;
        static month2(value: number): StiMonth;
        static month(str: string): StiMonth | null;
        static initialize(): void;
    }
}
export namespace Stimulsoft.Data.Types {
    import StiMonth = Stimulsoft.Data.Functions.StiMonth;
    class StiFiscalMonth {
        month: StiMonth;
        startMonth: StiMonth;
        get actualMonthIndex(): number;
        toString(): string;
        getHashCode(): number;
        stiFiscalMonth(month: StiMonth, startMonth: StiMonth): void;
        constructor(month: StiMonth, startMonth: StiMonth);
    }
}
export namespace Stimulsoft.Data.Functions {
    import StiFiscalMonth = Stimulsoft.Data.Types.StiFiscalMonth;
    import Type = Stimulsoft.System.Type;
    import IStiAppFunction = Stimulsoft.Base.IStiAppFunction;
    import DayOfWeek = Stimulsoft.System.DayOfWeek;
    import IStiAppDataSource = Stimulsoft.Base.IStiAppDataSource;
    import List = Stimulsoft.System.Collections.List;
    import DateTime = Stimulsoft.System.DateTime;
    import TimeSpan = Stimulsoft.System.TimeSpan;
    class Funcs {
        static count(value: any): number;
        static countIf(value: any, condition: any): number;
        static distinct(value: any): any;
        static distinctCount(value: any): number;
        static distinctCountIf(value: any, condition: any): number;
        static first(value: any): any;
        static last(value: any): any;
        static all(value: any): any;
        static isAggregationFunction(functionn: string): boolean;
        static avg(value: any): number;
        static avgNulls(value: any): number;
        static avgDate(value: any): DateTime | null;
        static avgTime(value: any): TimeSpan | null;
        private static getTimeSpan;
        static max(value: any): number;
        static maxNulls(value: number): number;
        static maxD(value: any): number;
        static maxI(value: any): number;
        static maxDate(value: any): DateTime | null;
        static maxTime(value: any): TimeSpan | null;
        static maxStr(value: any): string;
        static median(value: any): number;
        static min(value: any): number;
        static minNulls(value: any): number;
        static minDate(value: any): DateTime | null;
        static minTime(value: any): TimeSpan | null;
        static minMaxDateString(value: any): string;
        static minStr(value: any): string;
        static mode(value: any): number;
        static sum(value: any): number;
        static sumNulls(value: any): number;
        static sumD(value: any): number;
        static sumI(value: any): number;
        static sumTime(value: any): TimeSpan;
        static sumDistinct(value: any): number;
        static sumIf(value: any, condition: any): number;
        static sumDIf(value: any, condition: any): number;
        static sumIIf(value: any, condition: any): number;
        static sumTimeIf(value: any, condition: any): TimeSpan;
        static sumDistinctIf(value: any, condition: any): number;
        private static getCondition;
        private static getConditions;
        static stDev(value: any): number;
        static stDevP(value: any): number;
        static dayOfWeekIdent(dateTime: DateTime | null): DayOfWeek | null;
        static dayOfWeekIdentObject(value: any): any;
        static dayOfWeekIndex(dateTime: DateTime | null): number;
        static dayOfWeekIndexObject(value: any): any;
        static dayOfWeek(date: DateTime | null): string;
        static dayOfWeekObject(value: any): any;
        static dayOfWeek2(date: DateTime | null, localized: boolean): string;
        static dayOfWeekObject2(value: any, localized: boolean): any;
        static dayOfWeek3(date: DateTime | null, culture: string): string;
        static dayOfWeekObject3(value: any, culture: string): any;
        static dayOfWeek4(date: DateTime | null, culture: string, upperCase: boolean): string;
        static dayOfWeekObject4(value: any, culture: string, upperCase: boolean): any;
        static daysInMonth(year: number, month: number): number;
        static daysInMonthObject(value1: any, value2: any): any;
        static daysInMonth2(date: DateTime | null): number;
        static daysInMonthObject2(value: any): any;
        static daysInYear(year: number): number;
        static daysInYear2(date: DateTime | null): number;
        static daysInYearObject(value: any): any;
        static monthIdent(dateTime: DateTime | null): StiMonth | null;
        static monthIdentObject(value: any): any;
        static fiscalMonthIdent(dateTime: DateTime, startMonth: any): StiFiscalMonth;
        static fiscalMonthIdentObject(value: any, startMonth: any): any;
        private static objectToMonthIdent;
        static month(dateTime: DateTime | null): number;
        static monthObject(value: any): any;
        static monthName(date: DateTime | null): string;
        static monthNameObject(value: any): any;
        static monthName2(date: DateTime | null, localized: boolean): string;
        static monthNameObject2(value: any, localized: boolean): any;
        static monthName3(date: DateTime | null, culture: string): string;
        static monthNameObject3(value: any, culture: string): any;
        static monthName4(date: DateTime | null, culture: string, upperCase: boolean): string;
        static monthNameObject4(value: any, culture: string, upperCase: boolean): any;
        static addMonthsObject(date: any, months: number): any;
        static addYears(date: DateTime, years: number): DateTime;
        static addYearsObject(date: any, years: number): any;
        static day(dateTime: DateTime | null): number;
        static dayObject(value: any): any;
        static dateDiff(date1: DateTime | null, date2: DateTime | null): TimeSpan | null;
        static dateDiffObject(value1: any, value2: any): any;
        static dateTime(value: any): any;
        static dayOfYear(dateTime: DateTime | null): number;
        static dayOfYearObject(value: any): any;
        static financialQuarter(dateTime: DateTime | null): StiQuarter | null;
        static financialQuarterObject(value: any): any;
        static financialQuarterIndex(dateTime: DateTime | null): number;
        static financialQuarterIndexObject(value: any): any;
        static hour(dateTime: DateTime | null): number;
        static hourObject(value: any): any;
        static makeDate(year: number, month?: number, day?: number): DateTime;
        static makeDateObject(year: any, month?: any, day?: any): any;
        static makeDateTime(year: number, month?: number, day?: number, hour?: number, minute?: number, second?: number): DateTime;
        static makeDateTimeObject(year: any, month?: any, day?: any, hour?: any, minute?: any, second?: any): any;
        static makeTime(hour: number, minute?: number, second?: number): DateTime;
        static makeTimeObject(hour: any, minute?: any, second?: any): any;
        static minute(dateTime: DateTime | null): number;
        static minuteObject(value: any): any;
        static now(): DateTime;
        static quarterName(dateTime: DateTime | null, localized?: boolean): string;
        static quarterNameObject(value: any, localized?: boolean): any;
        static quarter(dateTime: DateTime | null): StiQuarter | null;
        static quarterObject(value: any): any;
        static quarterIndex(dateTime: DateTime | null): number;
        static quarterIndexObject(value: any): any;
        static second(dateTime: DateTime | null): number;
        static secondObject(value: any): any;
        static time(value: any): any;
        static year(dateTime: DateTime | null): number;
        static yearObject(value: any): any;
        static yearMonth(dateTime: DateTime | null): string;
        static yearMonthObject(value: any): any;
        static getDateDimensionFunctions(): List<string>;
        static image(value: any, width?: number, height?: number): any;
        static isValidUrl(hyperlink: string): boolean;
        static localize(func: string): string;
        static abs(value: number): number;
        static absObject(value: any): any;
        static acos(value: number): number;
        static acosObject(value: any): any;
        static asin(value: number): number;
        static asinObject(value: any): any;
        static atan(value: number): any;
        static atanObject(value: any): any;
        static ceiling(value: number): number;
        static ceilingObject(value: any): any;
        static cos(value: number): number;
        static cosObject(value: any): any;
        static div(value1: number, value2: number, zeroResult?: number | null): number | null;
        static divObject(value1: any, value2: any, zeroResult?: any): number;
        static exp(value: number): number;
        static expObject(value: any): any;
        static floor(value: number): number;
        static floorObject(value: any): any;
        static log(value: number): number;
        static logObject(value: any): any;
        static round(value: number, decimals?: number): number;
        static roundObject(value: any, decimals?: number): any;
        static sign(value: number): number;
        static signObject(value: any): any;
        static sin(value: number): number;
        static sinObject(value: any): any;
        static sqrt(value: number): number;
        static sqrtObject(value: any): any;
        static tan(value: number): number;
        static tanObject(value: any): any;
        static truncate(value: number): number;
        static truncateObject(value: any): any;
        static isMeasureFunction(expression: string): boolean;
        static getMeasureFunctions(): List<string>;
        static getAggregateMeasureFunctions(): List<string>;
        static getCommonMeasureFunctions(): List<string>;
        static calculate(functionn: string, values: List<object>): any;
        private static iso2Cache;
        static getMapIdents(key: string): List<string>;
        static getIso2ConvertedValues(name: string): List<string>;
        static iso2(name: string, mapId: string, lang: string): string;
        static iso2Object(value: any, mapId: string, lang: string): any;
        static iso2ToName(alpha2: string, mapId: string, lang: string): string;
        static iso2ToNameObject(value: any, mapId: string, lang: string): any;
        static iso3(name: string, mapId: string, lang: string): string;
        static iso3Object(value: any, mapId: string, lang: string): any;
        static iso3ToName(alpha3: string, mapId: string, lang: string): string;
        static iso3ToNameObject(value: any, mapId: string, lang: string): any;
        static normalizeName(alpha3: string, mapId: string, lang: string): string;
        static normalizeNameObject(value: any, mapId: string, lang: string): any;
        private static toProperCaseCache;
        private static toLowerCaseCache;
        private static toUpperCaseCache;
        private static toDataNameCache;
        static format(format: string, value: any): string;
        static formatObject(format: string, value: any): any;
        static insert(str: string, startIndex: number, subStr: string): string;
        static insertObject(value: any, startIndex: number, subStr: string): any;
        static isDataEqual(dataSource: IStiAppDataSource, dataColumnName: string, searchColumnName: string): boolean;
        static left(str: string, length?: number): string;
        static leftObject(value: any, length?: number): any;
        static length2(str: string): number;
        static lengthObject(value: any): any;
        static remove(str: string, startIndex: number, count: number): string;
        static removeObject(value: any, startIndex: number, count: number): any;
        static replace(str: string, oldValue: string, newValue: string): string;
        static replaceObject(value: any, oldValue: string, newValue: string): any;
        static right(str: string, length?: number): string;
        static rightObject(value: any, length?: number): any;
        static toDataName(name: string): string;
        static toExpression(name: string): string;
        static toExpression2(sourceName: string, columnName: string): string;
        static toLowerCase(str: string): string;
        static toLowerCaseObject(value: any): any;
        static toProperCase(str: string): string;
        static toProperCaseObject(value: any): any;
        static toString(value: any): string;
        static toStringObject(value: any): any;
        static toUpperCase(str: string): string;
        static toUpperCaseObject(value: any): any;
        static trim(str: string): string;
        static trimObject(value: any): any;
        static trimStart(str: string): string;
        static trimStartObject(value: any): any;
        static trimEnd(str: string): string;
        static trimEndObject(value: any): any;
        static substring(str: string, startIndex: number, length?: number): string;
        static substringObject(value: any, startIndex: number, length?: number): any;
        static getSystemVariable(variable: StiSystemVariableObject, line: number): any;
        static existsCustomFunction(funcName: string): boolean;
        static getCustomFunctions(funcName: string): List<IStiAppFunction>;
        static getCustomFunction(funcName: string, argumentTypes: List<Type>): IStiAppFunction;
        static invokeCustomFunction(funcName: string, argumentss: List<any>): any;
        static skipNulls(values: List<any>): List<any>;
        static optionalSkipNulls(values: List<object>): List<object>;
        private static arabics;
        private static romans;
        private static subs;
        private static abc;
        private static abcRu;
        static toRoman(value: number): string;
        static toABC(value: number): string;
        static toABCNumeric(value: number): string;
        static toABCRu(value: number): string;
        static toArabic(value: string | number, useEasternDigits: boolean): string;
    }
}
export namespace Stimulsoft.Data.Functions {
    import Enum = Stimulsoft.System.Enum;
    enum StiQuarter {
        Q1 = 1,
        Q2 = 2,
        Q3 = 3,
        Q4 = 4
    }
    class StiMonth extends Enum {
        static January: StiMonth;
        static February: StiMonth;
        static March: StiMonth;
        static April: StiMonth;
        static May: StiMonth;
        static June: StiMonth;
        static July: StiMonth;
        static August: StiMonth;
        static September: StiMonth;
        static October: StiMonth;
        static November: StiMonth;
        static December: StiMonth;
        static 1: StiMonth;
        static 2: StiMonth;
        static 3: StiMonth;
        static 4: StiMonth;
        static 5: StiMonth;
        static 6: StiMonth;
        static 7: StiMonth;
        static 8: StiMonth;
        static 9: StiMonth;
        static 10: StiMonth;
        static 11: StiMonth;
        static 12: StiMonth;
    }
    class StiDayOfWeek extends Enum {
        static Sunday: StiDayOfWeek;
        static Monday: StiDayOfWeek;
        static Tuesday: StiDayOfWeek;
        static Wednesday: StiDayOfWeek;
        static Thursday: StiDayOfWeek;
        static Friday: StiDayOfWeek;
        static Saturday: StiDayOfWeek;
        static 0: StiDayOfWeek;
        static 1: StiDayOfWeek;
        static 2: StiDayOfWeek;
        static 3: StiDayOfWeek;
        static 4: StiDayOfWeek;
        static 5: StiDayOfWeek;
        static 6: StiDayOfWeek;
    }
    class StiSystemVariableObject {
        static Line: StiSystemVariableObject;
        static LineABC: StiSystemVariableObject;
        static LineRoman: StiSystemVariableObject;
        private value;
        constructor(value: string);
    }
}
export namespace Stimulsoft.Data.Parsers {
    import FunctionArgs = Stimulsoft.Data.Expressions.NCalc.FunctionArgs;
    import IStiDimensionMeter = Stimulsoft.Base.Meters.IStiDimensionMeter;
    import IStiAppDictionary = Stimulsoft.Base.IStiAppDictionary;
    import DataTable = Stimulsoft.System.Data.DataTable;
    import List = Stimulsoft.System.Collections.List;
    import IStiMeter = Stimulsoft.Base.Meters.IStiMeter;
    abstract class StiDataParser {
        protected runFunction(funcName: string, args: FunctionArgs): any;
        protected getVariableValue(name: string): any;
        protected isVariable(name: string): boolean;
        protected isSystemVariable(name: string): any;
        protected getSystemVariableValue(name: string): any;
        private static getObjectFromArg;
        private static evaluateArgs;
        private static getObjectFromArg0;
        private static getObjectFromArg1;
        private static getObjectFromArg2;
        private static getDataColumnFromArg0;
        protected getDataColumnIndex(columnName: string): number;
        private dataEqual;
        protected getDimensionIndex(dimension: IStiDimensionMeter): number;
        dictionary: IStiAppDictionary;
        table: DataTable;
        meters: List<IStiMeter>;
        isGrandTotal: boolean;
        private nameToIndex;
        private nameToValue;
        private nameToVariable;
        constructor(dictionary: IStiAppDictionary, table: DataTable, meters: List<IStiMeter>);
    }
}
export namespace Stimulsoft.Data.Parsers {
    import List = Stimulsoft.System.Collections.List;
    import IStiMeter = Stimulsoft.Base.Meters.IStiMeter;
    import IStiAppDictionary = Stimulsoft.Base.IStiAppDictionary;
    import DataTable = Stimulsoft.System.Data.DataTable;
    import Grouping = Stimulsoft.System.Collections.Grouping;
    class StiMeasureDataParser extends StiDataParser {
        calculate(): List<any[]>;
        calculateMeter(meter: IStiMeter, keys?: any[], rows?: List<object[]>): any;
        private calculateDimension;
        private calculateMeasureFunction;
        private calculateMeasureExpression;
        private getMeasureColumn;
        private getExpression;
        private getDataRowValue;
        private grandRows;
        private currentRows;
        private queryToExpression;
        private expressionToPair;
        constructor(dictionary: IStiAppDictionary, table: DataTable, meters: List<IStiMeter>, grandRows: List<Grouping<any[], any[]>>);
    }
}
export namespace Stimulsoft.Data.Parsers {
    import List = Stimulsoft.System.Collections.List;
    import IStiAppDictionary = Stimulsoft.Base.IStiAppDictionary;
    import DataTable = Stimulsoft.System.Data.DataTable;
    import IStiDimensionMeter = Stimulsoft.Base.Meters.IStiDimensionMeter;
    import IStiMeter = Stimulsoft.Base.Meters.IStiMeter;
    class StiDimensionDataParser extends StiDataParser {
        calculate(row: any[], meters: List<IStiMeter>): any[];
        private static normalizeDates;
        private static getMeter;
        private static normalizeDate;
        private calculateDimension;
        private getDimensionGroupColumn;
        private calculateDimensionExpression;
        private calculateDimensionGroup;
        private normalizeEnum;
        private getExpression;
        protected dimensions: List<IStiDimensionMeter>;
        private currentRow;
        private queryToExpression;
        private expressionToColumn;
        constructor(dictionary: IStiAppDictionary, table: DataTable, meters: List<IStiMeter>);
    }
}
export namespace Stimulsoft.Data.Engine {
    import IStiAppDictionary = Stimulsoft.Base.IStiAppDictionary;
    import IStiMeter = Stimulsoft.Base.Meters.IStiMeter;
    import List = Stimulsoft.System.Collections.List;
    class StiDataCreator {
        static create(dict: IStiAppDictionary, meters: List<IStiMeter>): StiDataTable;
        private static convert;
        private static getData;
    }
}
export namespace Stimulsoft.Data.Engine {
    import IStiAppDataColumn = Stimulsoft.Base.IStiAppDataColumn;
    class StiDataExpressionHelper {
        static getDataColumnFromExpression(query: IStiQueryObject, expression: string): IStiAppDataColumn;
        static isDateDataColumnInExpression(query: IStiQueryObject, expression: string): boolean;
        static isNumericDataColumnInExpression(query: IStiQueryObject, expression: string): boolean;
    }
}
export namespace Stimulsoft.Data.Engine {
    import IComparer = Stimulsoft.System.Collections.IComparer;
    class StiDataFilterComparer implements IComparer<any> {
        convertStrings: boolean;
        compare(x: any, y: any): number;
        constructor(convertStrings?: boolean);
    }
}
export namespace Stimulsoft.Data.Engine {
    class StiDataFilterHelper {
        static convertStringToCondition(condition: string): StiDataFilterCondition;
        static convertConditionToString(condition: StiDataFilterCondition): string;
    }
}
export namespace Stimulsoft.Data.Engine {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import List = Stimulsoft.System.Collections.List;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiJson = Stimulsoft.Base.StiJson;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    class StiDataFilterRule extends StiDataRule implements IStiJsonReportObject {
        meta(): StiMeta[];
        static loadFromJson(json: StiJson): StiDataFilterRule;
        static loadFromXml(xmlNode: XmlNode): StiDataFilterRule;
        toString(): string;
        getUniqueCode(): number;
        toList(): List<StiDataFilterRule>;
        getStringRepresentation(): string;
        private getValue;
        key: string;
        elementKey: string;
        path: string;
        path2: string;
        condition: StiDataFilterCondition;
        operation: StiDataFilterOperation;
        value: string;
        value2: string;
        isEnabled: boolean;
        isExpression: boolean;
        constructor(key?: string, path?: string, condition?: StiDataFilterCondition, value?: string, value2?: string, isEnabled?: boolean, isExpression?: boolean, path2?: string, operation?: StiDataFilterOperation);
    }
}
export namespace Stimulsoft.Data.Exceptions {
    class StiTypeNotRecognizedException extends StiDataException {
        constructor(type: any);
    }
}
export namespace Stimulsoft.Data.Engine {
    import IStiApp = Stimulsoft.Base.IStiApp;
    import IStiReport = Stimulsoft.Base.IStiReport;
    import List = Stimulsoft.System.Collections.List;
    import IStiAppDataColumn = Stimulsoft.Base.IStiAppDataColumn;
    import Type = Stimulsoft.System.Type;
    import StiDataFilerRule = Stimulsoft.Data.Engine.StiDataFilterRule;
    class StiDataFilterRuleHelper {
        private static currentCulture;
        static toList(...rules: StiDataFilterRule[]): List<StiDataFilterRule>;
        static validate(rules: List<StiDataFilerRule>, columnKeys: List<string>): List<StiDataFilterRule>;
        static getDataTableFilterQuery(rules: List<StiDataFilterRule>, columns: List<IStiAppDataColumn>, report: IStiReport): string;
        static getTableFiltersGroupsType(rules: List<StiDataFilterRule>): StiTableFiltersGroupsType;
        static getDataTableFilterQuery2(rules: List<StiDataFilterRule>, columnNames: List<string>, columnTypes: List<Type>, report: IStiReport): string;
        private static getFullPath;
        private static getFilterGroupQuery;
        private static parseExpression;
        private static getColumnIndex3;
        private static getCleanedPath;
        private static getColumnName;
        private static getColumnType;
        private static getValue;
        private static getColumnIndex;
        private static getColumnIndex2;
        private static getCondition;
        private static getQueryValue;
        private static getFilterOperation;
        static getFilterRulesHash(app: IStiApp, rules: List<StiDataFilterRule>): number;
        private static getFilterRulesHash2;
        private static getFilterRuleHash3;
    }
}
export namespace Stimulsoft.Data.Engine {
    import IStiReport = Stimulsoft.Base.IStiReport;
    import List = Stimulsoft.System.Collections.List;
    import DataTable = Stimulsoft.System.Data.DataTable;
    class StiDataFiltrator {
        private static lockObject;
        private static meterCache;
        private static netCache;
        static filter(inTable: DataTable, filters: List<StiDataFilterRule>, report: IStiReport, hash: number): DataTable;
        static filter2(inTable: StiDataTable, filters: List<StiDataFilterRule>, report: IStiReport, hash: number): StiDataTable;
        private static filterMapIdents;
        private static simplify;
        static cleanCache(appKey: string): void;
        private static getCacheKey;
        private static getCacheKey2;
        private static getFromCache;
        private static getFromCache2;
        private static addToCache;
        private static addToCache2;
    }
}
export namespace Stimulsoft.Data.Engine {
    import IStiAppDictionary = Stimulsoft.Base.IStiAppDictionary;
    import DataTable = Stimulsoft.System.Data.DataTable;
    import List = Stimulsoft.System.Collections.List;
    import IStiMeter = Stimulsoft.Base.Meters.IStiMeter;
    class StiDataGrouper {
        static group(dictionary: IStiAppDictionary, joinedTable: DataTable, meters: List<IStiMeter>): StiDataTable;
    }
}
export namespace Stimulsoft.Data.Engine {
    class StiDataIndicatorValue {
        private static cache;
        static getFromCache(key: string): number;
        static existsInCache(key: string): boolean;
        static addToCache(key: string, value: number): void;
        static cleanCache(): void;
    }
}
export namespace Stimulsoft.Data.Engine {
    import IStiMeter = Stimulsoft.Base.Meters.IStiMeter;
    import List = Stimulsoft.System.Collections.List;
    import DataTable = Stimulsoft.System.Data.DataTable;
    import IStiApp = Stimulsoft.Base.IStiApp;
    class StiDataJoiner {
        private static cache;
        static joinEngine: StiDataJoinEngine;
        static join(tables: List<DataTable>, links: List<StiDataLink>, meters: List<IStiMeter>, app: IStiApp): DataTable;
        private static copyColumns;
        private static mergeInSequence;
        private static findLink;
        private static getCacheKey;
        private static getFromCache;
        private static addToCache;
        static cleanCache(appKey: string): void;
    }
}
export namespace Stimulsoft.Data.Engine {
    import List = Stimulsoft.System.Collections.List;
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiJson = Stimulsoft.Base.StiJson;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    class StiDataLink implements IStiJsonReportObject {
        protected _hash: StiMeta[];
        meta(): StiMeta[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(j: StiJson): void;
        loadFromXml(xn: XmlNode): void;
        parentTable: string;
        childTable: string;
        parentColumns: List<string>;
        childColumns: List<string>;
        get parentKeys(): List<string>;
        get childKeys(): List<string>;
        key: string;
        active: boolean;
        static loadFromJson(json: StiJson): StiDataLink;
        static loadFromXml(xmlNode: XmlNode): StiDataLink;
        toString(): string;
        private nullStr;
        private nullStr2;
        constructor(parentTable?: string, childTable?: string, parentColumns?: List<string>, childColumns?: List<string>, active?: boolean, key?: string);
    }
}
export namespace Stimulsoft.Data.Engine {
    import List = Stimulsoft.System.Collections.List;
    import IStiAppDictionary = Stimulsoft.Base.IStiAppDictionary;
    class StiDataLinkHelper {
        static getLinks(dictionary: IStiAppDictionary): List<StiDataLink>;
    }
}
export namespace Stimulsoft.Data.Engine {
    import IStiApp = Stimulsoft.Base.IStiApp;
    import IStiAppDataSource = Stimulsoft.Base.IStiAppDataSource;
    import DataTable = Stimulsoft.System.Data.DataTable;
    import List = Stimulsoft.System.Collections.List;
    class StiDataPicker {
        private static lockObject;
        private static cache;
        static fetch(query: IStiQueryObject, group: string, option?: StiDataRequestOption, filterNames?: List<string>, links?: List<StiDataLink>): Promise<List<DataTable>>;
        private static getRelationLevel;
        static retrieveUsedDataSources(query: IStiQueryObject, group: string, filterNames: List<string>): List<IStiAppDataSource>;
        static fetch2(app: IStiApp, dataSourceName: string, option?: StiDataRequestOption): Promise<DataTable>;
        static fetch3(app: IStiApp, dataSource: IStiAppDataSource, option?: StiDataRequestOption): Promise<DataTable>;
        static isAllBICached(query: IStiQueryObject, group: string, option?: StiDataRequestOption): boolean;
        static getDataTable(app: IStiApp, dataSource: IStiAppDataSource, option?: StiDataRequestOption): Promise<DataTable>;
        static getDataTable2(option: StiDataRequestOption, dataSource: IStiAppDataSource): Promise<DataTable>;
        static processCalculatedColumns(dataTable: DataTable, dataSource: IStiAppDataSource): DataTable;
        static processCalculatedColumnsAsync(dataTable: DataTable, dataSource: IStiAppDataSource): Promise<DataTable>;
        static addTableNameToColumnNames(table: DataTable, dataSource: IStiAppDataSource): void;
        static getFromCache(dataSource: IStiAppDataSource): DataTable;
        static existsInCache(dataSource: IStiAppDataSource): boolean;
        static addToCache(dataSource: IStiAppDataSource, dataTable: {
            ref: DataTable;
        }): void;
        private static getCacheKey;
        static cleanCache(appKey: string): void;
    }
}
export namespace Stimulsoft.Data.Engine {
    import IStiMeter = Stimulsoft.Base.Meters.IStiMeter;
    import List = Stimulsoft.System.Collections.List;
    import DataRow = Stimulsoft.System.Data.DataRow;
    import DataTable = Stimulsoft.System.Data.DataTable;
    class StiDataRowJoiner {
        join(type: StiDataJoinType, link: StiDataLink, meters: List<IStiMeter>): List<DataRow>;
        private leftJoinRows;
        private innerJoinRows;
        private leftJoinRowsV1V4;
        private leftJoinRowsV5;
        private leftJoinRowsV2V3;
        private calculateIndexes;
        private isNumericType;
        private crossJoinRows;
        private fullJoinRows;
        private getHashCode;
        private getHashCode2;
        private splitRows;
        private getFieldIndex;
        private getFieldIndex2;
        private getFieldIndexes;
        private getItem;
        private resultTable;
        private table1;
        private table2;
        private resultColumnIndexes;
        private column1Indexes;
        private column2Indexes;
        constructor(resultTable: DataTable, table1: DataTable, table2: DataTable);
    }
}
export namespace Stimulsoft.Data.Engine {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiJson = Stimulsoft.Base.StiJson;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    class StiDataSortRule extends StiDataRule implements IStiJsonReportObject {
        meta(): StiMeta[];
        static loadFromJson(json: StiJson): StiDataSortRule;
        static loadFromXml(xmlNode: XmlNode): StiDataSortRule;
        toString(): string;
        getUniqueCode(): number;
        key: string;
        direction: StiDataSortDirection;
        constructor(key?: string, direction?: StiDataSortDirection);
    }
}
export namespace Stimulsoft.Data.Engine {
    import List = Stimulsoft.System.Collections.List;
    import IStiAppDataColumn = Stimulsoft.Base.IStiAppDataColumn;
    class StiDataSortRuleHelper {
        static toList(...rules: StiDataSortRule[]): List<StiDataSortRule>;
        static validate(rules: List<StiDataSortRule>, columnKeys: List<string>): List<StiDataSortRule>;
        static getDataTableSortQuery(rules: List<StiDataSortRule>, columns: List<IStiAppDataColumn>): string;
        static getDataTableSortQuery2(rules: List<StiDataSortRule>, columnKeys: List<string>, columnNames: List<string>): string;
        static getSortDirection(rules: List<StiDataSortRule>, columnKey: string): StiDataSortDirection;
        static setSortDirection(rules: List<StiDataSortRule>, columnKeys: List<string>, columnKey: string, direction: StiDataSortDirection): List<StiDataSortRule>;
    }
}
export namespace Stimulsoft.Data.Engine {
    import List = Stimulsoft.System.Collections.List;
    class StiDataSortVariation {
        static ident: string;
        static isVariationSort(sort: List<StiDataSortRule>): boolean;
        static createVariationSort(direction: StiDataSortDirection): List<StiDataSortRule>;
    }
}
export namespace Stimulsoft.Data.Engine {
    import IStiApp = Stimulsoft.Base.IStiApp;
    import List = Stimulsoft.System.Collections.List;
    class StiDataSorter {
        private static lockObject;
        private static hashCache;
        static sort(inTable: StiDataTable, sorts: List<StiDataSortRule>, app: IStiApp, hash: number, option?: StiDataRequestOption): StiDataTable;
        private static getFixedDataSortRules;
        static cleanCache(appKey: string): void;
        private static getCacheKey;
        private static getFromCache;
        private static addToCache;
    }
}
export namespace Stimulsoft.Data.Engine {
    import IStiAppDataSource = Stimulsoft.Base.IStiAppDataSource;
    import List = Stimulsoft.System.Collections.List;
    class StiDataSourceChainFinder {
        static find(dataSources: List<IStiAppDataSource>): List<IStiAppDataSource>;
        private static find3;
        static findInParent(dataSource1: IStiAppDataSource, dataSource2: IStiAppDataSource, dataPath?: List<string>): List<IStiAppDataSource>;
        static findInChild(dataSource1: IStiAppDataSource, dataSource2: IStiAppDataSource, dataPath?: List<string>): List<IStiAppDataSource>;
        static findInBoth(dataSource1: IStiAppDataSource, dataSource2: IStiAppDataSource): List<IStiAppDataSource>;
        private static getDataPoint;
        private static getActiveRelations;
    }
}
export namespace Stimulsoft.Data.Engine {
    import List = Stimulsoft.System.Collections.List;
    import IStiAppDataSource = Stimulsoft.Base.IStiAppDataSource;
    class StiDataSourcePicker {
        static fetch(query: IStiQueryObject, group: string, dataNames: List<string>, dataSources: List<IStiAppDataSource>): List<IStiAppDataSource>;
    }
}
export namespace Stimulsoft.Data.Engine {
    import List = Stimulsoft.System.Collections.List;
    import IStiMeter = Stimulsoft.Base.Meters.IStiMeter;
    class StiDataTable {
        static nullTable: StiDataTable;
        meters: List<IStiMeter>;
        rows: List<any[]>;
        get isNull(): boolean;
        get isEmpty(): boolean;
        constructor(meters?: List<IStiMeter>, rows?: List<any[]>);
    }
}
export namespace Stimulsoft.Data.Engine {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiJson = Stimulsoft.Base.StiJson;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    class StiDataTopN implements IStiJsonReportObject, ICloneable {
        protected _hash: StiMeta[];
        meta(): StiMeta[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(j: StiJson): void;
        loadFromXml(xn: XmlNode): void;
        static createFromJsonObject(jObject: StiJson): StiDataTopN;
        static createFromXml(xmlNode: XmlNode): StiDataTopN;
        clone(): StiDataTopN;
        mode: StiDataTopNMode;
        count: number;
        showOthers: boolean;
        othersText: string;
        measureField: string;
        isDefault(): boolean;
        toString(): string;
        getUniqueCode(): number;
        constructor(mode?: StiDataTopNMode, count?: number, showOthers?: boolean, othersText?: string, measureField?: string);
    }
}
export namespace Stimulsoft.Data.Engine {
    class StiErrorStack {
        private static keyToError;
        static setOk(key: string): void;
        static setError(key: string, error: string): void;
        static getError(key: string): string;
        static isFail(key: string): boolean;
    }
}
export namespace Stimulsoft.Data.Exceptions {
    class StiBingException extends StiDataException {
        constructor(message: string);
    }
}
export namespace Stimulsoft.Data.Exceptions {
    class StiColumnNotFoundException extends StiDataException {
        private _name;
        get name(): string;
        constructor(name: string);
    }
}
export namespace Stimulsoft.Data.Exceptions {
    class StiSystemVariableNotRecognizedException extends StiDataException {
        constructor(name: string);
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    import List = Stimulsoft.System.Collections.List;
    class ANTLRStringStream implements ICharStream {
        private static ImplementsANTLRStringStream;
        implements(): any[];
        protected data: string[];
        protected n: number;
        protected p: number;
        protected markDepth: number;
        protected markers: List<CharStreamState>;
        protected lastMarker: number;
        name: string;
        constructor(input?: string, data?: string[], numberOfActualCharsInArray?: number, sourceName?: string);
        get index(): number;
        line: number;
        charPositionInLine: number;
        reset(): void;
        consume(): void;
        la(i: number): number;
        lt(i: number): number;
        get count(): number;
        mark(): number;
        rewind(m?: number): void;
        release(marker: number): void;
        seek(index: number): void;
        substring(start: number, length: number): string;
        get sourceName(): string;
        toString(): string;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    class ANTLRReaderStream extends ANTLRStringStream {
        readBufferSize: number;
        initialBufferSize: number;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    class ANTLRInputStream extends ANTLRReaderStream {
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    class ParserRuleReturnScope<TToken> implements IRuleReturnScope<TToken> {
        private static ImplementsParserRuleReturnScope;
        implements(): any[];
        start: TToken;
        stop: TToken;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    class AstParserRuleReturnScope<TTree, TToken> extends ParserRuleReturnScope<TToken> implements IAstRuleReturnScope<TTree>, IAstRuleReturnScope<any> {
        private static ImplementsAstParserRuleReturnScope;
        implements(): any[];
        tree: TTree;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    import List = Stimulsoft.System.Collections.List;
    class BaseRecognizer {
        memoRuleFailed: number;
        memoRuleUnknown: number;
        static initialFollowStackSize: number;
        defaultTokenChannel: number;
        hidden: number;
        nextTokenRuleName: string;
        state: RecognizerSharedState;
        constructor(state?: RecognizerSharedState);
        setState(value: RecognizerSharedState): void;
        protected initDFAs(): void;
        reset(): void;
        match(input: IIntStream, ttype: number, follow: BitSet): any;
        matchAny(input: IIntStream): void;
        mismatchIsUnwantedToken(input: IIntStream, ttype: number): boolean;
        mismatchIsMissingToken(input: IIntStream, follow: BitSet): boolean;
        reportError(e: RecognitionException): void;
        displayRecognitionError(tokenNames: string[], e: RecognitionException): void;
        getErrorMessage(e: RecognitionException, tokenNames: string[]): string;
        get numberOfSyntaxErrors(): number;
        getErrorHeader(e: RecognitionException): string;
        getTokenErrorDisplay(t: IToken): string;
        emitErrorMessage(msg: string): void;
        recover(input: IIntStream, re: RecognitionException): void;
        beginResync(): void;
        endResync(): void;
        protected computeErrorRecoverySet(): BitSet;
        protected computeContextSensitiveRuleFOLLOW(): BitSet;
        protected combineFollows(exact: boolean): BitSet;
        protected recoverFromMismatchedToken(input: IIntStream, ttype: number, follow: BitSet): any;
        recoverFromMismatchedSet(input: IIntStream, e: RecognitionException, follow: BitSet): any;
        protected getCurrentInputSymbol(input: IIntStream): any;
        protected getMissingSymbol(input: IIntStream, e: RecognitionException, expectedTokenType: number, follow: BitSet): any;
        consumeUntil(input: IIntStream, tokenType: number): void;
        consumeUntil2(input: IIntStream, set: BitSet): void;
        protected pushFollow(fset: BitSet): void;
        protected popFollow(): void;
        get backtrackingLevel(): number;
        set backtrackingLevel(value: number);
        get failed(): boolean;
        tokenNames: string[];
        grammarFileName: string;
        get sourceName(): string;
        toStrings(tokens: List<IToken>): List<string>;
        getRuleMemoization(ruleIndex: number, ruleStartIndex: number): number;
        alreadyParsedRule(input: IIntStream, ruleIndex: number): boolean;
        memoize(input: IIntStream, ruleIndex: number, ruleStartIndex: number): void;
        getRuleMemoizationCacheSize(): number;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    class BitSet {
        private static BITS;
        private static LOG_BITS;
        private static MOD_MASK;
        _bits: number[];
        static create(bits: number[]): BitSet;
        constructor(nbits?: number);
        static of(el: number): BitSet;
        static of2(a: number, b: number): BitSet;
        static of3(a: number, b: number, c: number): BitSet;
        static of4(a: number, b?: number, c?: number, d?: number): BitSet;
        or(a: BitSet): BitSet;
        add(el: number): void;
        growToInclude(bit: number): void;
        orInPlace(a: BitSet): void;
        private setSize;
        private static bitMask;
        clone(): any;
        size(): number;
        getHashCode(): number;
        equals(other: any): boolean;
        member(el: number): boolean;
        remove(el: number): void;
        isNil(): boolean;
        private static numWordsToHold;
        numBits(): number;
        lengthInLongWords(): number;
        toArray(): number[];
        private static wordNumber;
        toString(tokenNames?: string[]): string;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    import List = Stimulsoft.System.Collections.List;
    class BufferedTokenStream implements ITokenStream, ITokenStreamInformation {
        private static ImplementsBufferedTokenStream;
        implements(): any[];
        private _tokenSource;
        _tokens: List<IToken>;
        private _lastMarker;
        protected _p: number;
        constructor(tokenSource?: ITokenSource);
        get tokenSource(): ITokenSource;
        set tokenSource(value: ITokenSource);
        get index(): number;
        range: number;
        get count(): number;
        get sourceName(): string;
        get lastToken(): IToken;
        get lastRealToken(): IToken;
        maxLookBehind: number;
        mark(): number;
        release(marker: number): void;
        rewind(marker?: number): void;
        reset(): void;
        seek(index: number): void;
        consume(): void;
        protected sync(i: number): void;
        protected fetch(n: number): void;
        get(i: number): IToken;
        la(i: number): number;
        protected lb(k: number): IToken;
        lt(k: number): IToken;
        protected setup(): void;
        getTokens(start: number, stop: number, types: BitSet): List<IToken>;
        toString(): string;
        toString2(start: number, stop: number): string;
        fill(): void;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    class CharStreamConstants {
        static endOfFile: number;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    class CharStreamState {
        p: number;
        line: number;
        charPositionInLine: number;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    class ClassicToken implements IToken {
        private static ImplementsClassicToken;
        implements(): any[];
        index: number;
        constructor(type: number, text: string, channel: number);
        text: string;
        type: number;
        line: number;
        charPositionInLine: number;
        channel: number;
        startIndex: number;
        stopIndex: number;
        get tokenIndex(): number;
        set tokenIndex(value: number);
        inputStream: ICharStream;
        toString(): string;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    class CommonToken implements IToken {
        private static ImplementsCommonToken;
        implements(): any[];
        input: ICharStream;
        _text: string;
        index: number;
        start: number;
        stop: number;
        constructor();
        static create1(type: number): CommonToken;
        static create2(input: ICharStream, type: number, channel: number, start: number, stop: number): CommonToken;
        static create3(type: number, text: string): CommonToken;
        static create4(oldToken: IToken): CommonToken;
        get text(): string;
        set text(value: string);
        type: number;
        line: number;
        charPositionInLine: number;
        channel: number;
        get startIndex(): number;
        set startIndex(value: number);
        get stopIndex(): number;
        set stopIndex(value: number);
        get tokenIndex(): number;
        set tokenIndex(value: number);
        get inputStream(): ICharStream;
        set inputStream(value: ICharStream);
        toString(): string;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    class CommonTokenStream extends BufferedTokenStream {
        channel: number;
        constructor(tokenSource?: ITokenSource, channel?: number);
        consume(): void;
        lb(k: number): IToken;
        lt(k: number): IToken;
        skipOffTokenChannels(i: number): number;
        protected skipOffTokenChannelsReverse(i: number): number;
        reset(): void;
        setup(): void;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    class DFA {
        protected eot: number[];
        protected eof: number[];
        protected min: string[];
        protected max: string[];
        protected accept: number[];
        protected special: number[];
        protected transition: number[][];
        protected decisionNumber: number;
        protected recognizer: BaseRecognizer;
        debug: boolean;
        constructor();
        description: string;
        predict(input: IIntStream): number;
        private dfaDebugMessage;
        private dfaDebugInvalidSymbol;
        protected noViableAlt(s: number, input: IIntStream): void;
        error(nvae: NoViableAltException): void;
        static specialStateTransitionDefault(dfa: DFA, s: number, input: IIntStream): number;
        static unpackEncodedString(encodedString: string): number[];
        static unpackEncodedStringToUnsignedChars(encodedString: string): string[];
        protected debugRecognitionException(ex: RecognitionException): void;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    import List = Stimulsoft.System.Collections.List;
    class BaseTree implements ITree {
        private static ImplementsBaseTree;
        implements(): any[];
        constructor(node?: ITree);
        children: List<ITree>;
        get childCount(): number;
        parent: ITree;
        childIndex: number;
        get isNil(): boolean;
        protected _tokenStartIndex: number;
        get tokenStartIndex(): number;
        set tokenStartIndex(value: number);
        protected _tokenStopIndex: number;
        get tokenStopIndex(): number;
        set tokenStopIndex(value: number);
        protected _type: number;
        get type(): number;
        set type(value: number);
        protected _text: string;
        get text(): string;
        set text(value: string);
        line: number;
        charPositionInLine: number;
        getChild(i: number): ITree;
        getFirstChildWithType(type: number): ITree;
        addChild(t: ITree): void;
        addChildren(kids: List<ITree>): void;
        setChild(i: number, t: ITree): void;
        insertChild(i: number, t: ITree): void;
        deleteChild(i: number): any;
        replaceChildren(startChildIndex: number, stopChildIndex: number, t: any): void;
        createChildrenList(): List<ITree>;
        freshenParentAndChildIndexes(offset?: number): void;
        freshenParentAndChildIndexesDeeply(offset?: number): void;
        sanityCheckParentAndChildIndexes(parent?: ITree, i?: number): void;
        hasAncestor(ttype: number): boolean;
        getAncestor(ttype: number): ITree;
        getAncestors(): List<ITree>;
        toStringTree(): string;
        toString(): string;
        dupNode(): ITree;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    class CommonTree extends BaseTree {
        private _token;
        protected startIndex: number;
        protected stopIndex: number;
        parent: CommonTree;
        childIndex: number;
        constructor(node?: CommonTree | IToken);
        get isNil(): boolean;
        get text(): string;
        token: IToken;
        get tokenStartIndex(): number;
        set tokenStartIndex(value: number);
        get tokenStopIndex(): number;
        set tokenStopIndex(value: number);
        get type(): number;
        dupNode(): ITree;
        setUnknownTokenBoundaries(): void;
        toString(): string;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    let ITreeNodeStream: System.Interface<ITreeNodeStream>;
    interface ITreeNodeStream extends IIntStream {
        get(i: number): ITreeNodeStream;
        lt(k: number): any;
        treeSource: any;
        tokenStream: ITokenStream;
        treeAdaptor: ITreeAdaptor;
        uniqueNavigationNodes: boolean;
        toString(start: any, stop: any): string;
        replaceChildren(parent: any, startChildIndex: number, stopChildIndex: number, t: any): any;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    import Exception = Stimulsoft.System.Exception;
    import ITreeNodeStream = Stimulsoft.Data.Expressions.Antlr.Runtime.Tree.ITreeNodeStream;
    class RecognitionException extends Exception {
        private _k;
        private _c;
        constructor(message?: string, input?: IIntStream, k?: number, innerException?: Exception);
        get unexpectedType(): number;
        approximateLineInfo: boolean;
        input: IIntStream;
        get lookahead(): number;
        token: IToken;
        node: any;
        get character(): string;
        set character(value: string);
        index: number;
        line: number;
        charPositionInLine: number;
        protected extractInformationFromTreeNodeStream(input: ITreeNodeStream): void;
        protected extractInformationFromTreeNodeStream2(input: ITreeNodeStream, k: number): void;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    import Exception = Stimulsoft.System.Exception;
    class EarlyExitException extends RecognitionException {
        constructor(message?: string, decisionNumber?: number, input?: IIntStream, innerException?: Exception);
        decisionNumber: number;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    import Exception = Stimulsoft.System.Exception;
    class FailedPredicateException extends RecognitionException {
        constructor(message?: string, input?: IIntStream, ruleName?: string, predicateText?: string, innerException?: Exception);
        ruleName: string;
        predicateText: string;
        toString(): string;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    import Attribute = Stimulsoft.System.Attribute;
    class GrammarRuleAttribute extends Attribute {
        constructor(name: string);
        name: string;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    let IAstRuleReturnScope: IAstRuleReturnScope<any>;
    interface IAstRuleReturnScope<TAstLabel> {
        tree: TAstLabel;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    let ICharStream: System.Interface<ICharStream>;
    interface ICharStream extends IIntStream {
        substring(start: number, length: number): string;
        lt(i: number): number;
        line: number;
        charPositionInLine: number;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    let IIntStream: System.Interface<IIntStream>;
    interface IIntStream {
        consume(): any;
        la(i: number): number;
        mark(): number;
        index: number;
        rewind(marker?: number): any;
        release(marker: number): any;
        seek(index: number): any;
        count: number;
        sourceName: string;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    let IRuleReturnScope: IRuleReturnScope<any>;
    interface IRuleReturnScope<TLabel> {
        start: TLabel;
        stop: TLabel;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    let ITemplateRuleReturnScope: ITemplateRuleReturnScope<any>;
    interface ITemplateRuleReturnScope<TTemplate> {
        template: TTemplate;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    let IToken: System.Interface<IToken>;
    interface IToken {
        text: string;
        type: number;
        line: number;
        charPositionInLine: number;
        channel: number;
        startIndex: number;
        stopIndex: number;
        tokenIndex: number;
        inputStream: ICharStream;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    let ITokenSource: System.Interface<ITokenSource>;
    interface ITokenSource {
        nextToken(): IToken;
        sourceName: string;
        tokenNames: string[];
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    let ITokenStream: System.Interface<ITokenStream>;
    interface ITokenStream extends IIntStream {
        lt(k: number): IToken;
        range: number;
        get(i: number): IToken;
        tokenSource: ITokenSource;
        toString(start: number, stop: number): string;
        toString(start: IToken, stop: IToken): string;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    let ITokenStreamInformation: System.Interface<ITokenStreamInformation>;
    interface ITokenStreamInformation {
        lastToken: IToken;
        lastRealToken: IToken;
        maxLookBehind: number;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    import List = Stimulsoft.System.Collections.List;
    import Dictionary = Stimulsoft.System.Collections.Dictionary;
    class LegacyCommonTokenStream implements ITokenStream {
        private static ImplementsLegacyCommonTokenStream;
        implements(): any[];
        _tokenSource: ITokenSource;
        protected tokens: List<IToken>;
        protected channelOverrideMap: Dictionary<number, number>;
        protected discardSet: List<number>;
        protected channel: number;
        protected discardOffChannelTokens: boolean;
        protected lastMarker: number;
        protected p: number;
        constructor(tokenSource?: ITokenSource, channel?: number);
        get index(): number;
        range: number;
        setTokenSource(tokenSource: ITokenSource): void;
        fillBuffer(): void;
        consume(): void;
        protected skipOffTokenChannels(i: number): number;
        protected skipOffTokenChannelsReverse(i: number): number;
        setTokenTypeChannel(ttype: number, channel: number): void;
        discardTokenType(ttype: number): void;
        setDiscardOffChannelTokens(discardOffChannelTokens: boolean): void;
        getTokens(): List<IToken>;
        getTokens2(start: number, stop: number, types?: BitSet): List<IToken>;
        lt(k: number): IToken;
        protected lb(k: number): IToken;
        get(i: number): IToken;
        la(i: number): number;
        mark(): number;
        release(marker: number): void;
        get count(): number;
        rewind(marker?: number): void;
        reset(): void;
        seek(index: number): void;
        tokenSource: ITokenSource;
        get sourceName(): string;
        toString(): string;
        toString2(start: number, stop: number): string;
        toString3(start: IToken, stop: IToken): string;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    class Lexer extends BaseRecognizer implements ITokenSource {
        private static ImplementsLexer;
        implements(): any[];
        protected input: ICharStream;
        constructor(input?: ICharStream, state?: RecognizerSharedState);
        get text(): string;
        set text(value: string);
        get line(): number;
        set line(value: number);
        get charPositionInLine(): number;
        set charPositionInLine(value: number);
        reset(): void;
        nextToken(): IToken;
        getEndOfFileToken(): IToken;
        skip(): void;
        mTokens(): void;
        get charStream(): ICharStream;
        set charStream(value: ICharStream);
        get sourceName(): string;
        emit2(token: IToken): void;
        emit(): IToken;
        match3(s: string): void;
        matchAny(): void;
        match2(c: number): void;
        matchRange(a: number, b: number): void;
        get charIndex(): number;
        reportError(e: RecognitionException): void;
        getErrorMessage(e: RecognitionException, tokenNames: string[]): string;
        getCharErrorDisplay(c: number): string;
        recover2(re: RecognitionException): void;
        protected parseNextToken(): void;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    import Exception = Stimulsoft.System.Exception;
    class MismatchedSetException extends RecognitionException {
        constructor(message?: string, expecting?: BitSet, input?: IIntStream, innerException?: Exception);
        expecting: BitSet;
        toString(): string;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    import Exception = Stimulsoft.System.Exception;
    class MismatchedNotSetException extends MismatchedSetException {
        constructor(message?: string, expecting?: BitSet, input?: IIntStream, innerException?: Exception);
        toString(): string;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    import Exception = Stimulsoft.System.Exception;
    class MismatchedRangeException extends RecognitionException {
        constructor(message?: string, a?: number, b?: number, input?: IIntStream, innerException?: Exception);
        a: number;
        b: number;
        toString(): string;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    import List = Stimulsoft.System.Collections.List;
    import Exception = Stimulsoft.System.Exception;
    class MismatchedTokenException extends RecognitionException {
        constructor(message?: string, expecting?: number, input?: IIntStream, tokenNames?: List<string>, innerException?: Exception);
        expecting: number;
        tokenNames: List<string>;
        toString(): string;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    import Exception = Stimulsoft.System.Exception;
    import ITreeNodeStream = Stimulsoft.Data.Expressions.Antlr.Runtime.Tree.ITreeNodeStream;
    class MismatchedTreeNodeException extends RecognitionException {
        constructor(message?: string, expecting?: number, input?: ITreeNodeStream, innerException?: Exception);
        expecting: number;
        toString(): string;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    import List = Stimulsoft.System.Collections.List;
    import Exception = Stimulsoft.System.Exception;
    class MissingTokenException extends MismatchedTokenException {
        private _inserted;
        constructor(message?: string, expecting?: number, input?: IIntStream, inserted?: any, tokenNames?: List<string>, innerException?: Exception);
        get missingType(): number;
        toString(): string;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    import Exception = Stimulsoft.System.Exception;
    class NoViableAltException extends RecognitionException {
        constructor(message: string, grammarDecisionDescription: string, decisionNumber: number, stateNumber: number, input: IIntStream, k?: number, innerException?: Exception);
        decisionNumber: number;
        grammarDecisionDescription: string;
        stateNumber: number;
        toString(): string;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    class Parser extends BaseRecognizer {
        input: ITokenStream;
        constructor(input: ITokenStream, state?: RecognizerSharedState);
        reset(): void;
        protected getCurrentInputSymbol(input: IIntStream): any;
        protected getMissingSymbol(input: IIntStream, e: RecognitionException, expectedTokenType: number, follow: BitSet): any;
        get tokenStream(): ITokenStream;
        set tokenStream(value: ITokenStream);
        get sourceName(): string;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    import Dictionary = Stimulsoft.System.Collections.Dictionary;
    class RecognizerSharedState {
        following: BitSet[];
        _fsp: number;
        errorRecovery: boolean;
        lastErrorIndex: number;
        failed: boolean;
        syntaxErrors: number;
        backtracking: number;
        ruleMemo: Array<Dictionary<number, number>>;
        token: IToken;
        tokenStartCharIndex: number;
        tokenStartLine: number;
        tokenStartCharPositionInLine: number;
        channel: number;
        type: number;
        text: string;
        constructor();
        static recognizerSharedState(state: RecognizerSharedState): RecognizerSharedState;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    class TemplateParserRuleReturnScope<TTemplate, TToken> extends ParserRuleReturnScope<TToken> implements ITemplateRuleReturnScope<TTemplate>, ITemplateRuleReturnScope<any> {
        private static ImplementsTemplateParserRuleReturnScope;
        implements(): any[];
        template: TTemplate;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    class TokenChannels {
        static default: number;
        static hidden: number;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    import Type = Stimulsoft.System.Type;
    import Dictionary = Stimulsoft.System.Collections.Dictionary;
    import List = Stimulsoft.System.Collections.List;
    class TokenRewriteStream extends CommonTokenStream {
        DEFAULT_PROGRAM_NAME: string;
        PROGRAM_INIT_SIZE: number;
        MIN_TOKEN_INDEX: number;
        protected programs: Dictionary<string, List<RewriteOperation>>;
        protected lastRewriteTokenIndexes: Dictionary<string, number>;
        protected init(): void;
        constructor(tokenSource?: ITokenSource, channel?: number);
        rollback(programName: string, instructionIndex: number): void;
        deleteProgram(programName?: string): void;
        unsertAfter(programName: string, index: number, text: string): void;
        insertBefore(programName: string, index: number, text: string): void;
        replace(programName: string, from: number, to: number, text: any): void;
        replace2(programName: string, from: IToken, to: IToken, text: any): void;
        delete(programName: string, from: IToken, to: IToken): void;
        protected getLastRewriteTokenIndex(programName: string): number;
        protected setLastRewriteTokenIndex(programName: string, i: number): void;
        protected getProgram(name: string): List<RewriteOperation>;
        private initializeProgram;
        toOriginalString(): string;
        toOriginalString2(start: number, end: number): string;
        toString(): string;
        toString3(programName: string, start: number, end: number): string;
        protected reduceToSingleOperationPerIndex(rewrites: List<RewriteOperation>): Dictionary<number, RewriteOperation>;
        protected catOpText(a: string, b: string): string;
        protected getKindOfOps(rewrites: List<RewriteOperation>, kind: Type, before?: number): List<RewriteOperation>;
        toDebugString(start?: number, end?: number): string;
    }
    class RewriteOperation {
        instructionIndex: number;
        index: number;
        text: string;
        protected stream: TokenRewriteStream;
        constructor(stream: TokenRewriteStream, index: number, text?: string);
        execute(buf: string): number;
        toString(): string;
    }
    class InsertBeforeOp extends RewriteOperation {
        constructor(stream: TokenRewriteStream, index: number, text: string);
        execute(buf: string): number;
    }
    class ReplaceOp extends RewriteOperation {
        lastIndex: number;
        constructor(stream: TokenRewriteStream, from: number, to: number, text: string);
        execute(buf: string): number;
        toString(): string;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    class TokenTypes {
        static endOfFile: number;
        static invalid: number;
        static endOfRule: number;
        static down: number;
        static up: number;
        static min: number;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    class Tokens {
        static skip: IToken;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Misc {
    import List = Stimulsoft.System.Collections.List;
    class ListStack<T> extends List<T> {
        peek(depth?: number): T;
        tryPeek(ref: {
            item: T;
        }): boolean;
        tryPeek2(depth: number, ref: {
            item: T;
        }): boolean;
        pop(): T;
        tryPop(ref: {
            item: T;
        }): boolean;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Misc {
    import List = Stimulsoft.System.Collections.List;
    class FastQueue<T> {
        _data: List<T>;
        _p: number;
        get count(): number;
        range: number;
        get(i: number): T;
        dequeue(): T;
        enqueue(o: T): void;
        peek(): T;
        clear(): void;
        toString(): string;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Misc {
    class LookaheadStream<T> extends FastQueue<T> {
        private _currentElementIndex;
        private _previousElement;
        _eof: T;
        _lastMarker: number;
        _markDepth: number;
        get endOfFile(): T;
        set endOfFile(value: T);
        get previousElement(): T;
        reset(): void;
        nextElement(): T;
        isEndOfFile(o: T): boolean;
        dequeue(): T;
        consume(): void;
        syncAhead(need: number): void;
        fill(n: number): void;
        get count(): number;
        lt(k: number): T;
        get index(): number;
        mark(): number;
        release(marker: number): void;
        rewind2(marker: number): void;
        rewind(): void;
        seek(index: number): void;
        lb(k: number): T;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    import LookaheadStream = Stimulsoft.Data.Expressions.Antlr.Runtime.Misc.LookaheadStream;
    class UnbufferedTokenStream extends LookaheadStream<IToken> implements ITokenStream, ITokenStreamInformation {
        private static ImplementsUnbufferedTokenStream;
        implements(): any[];
        tokenSource: ITokenSource;
        protected tokenIndex: number;
        protected channel: number;
        private _realTokens;
        constructor(tokenSource: ITokenSource);
        get sourceName(): string;
        get lastToken(): IToken;
        get lastRealToken(): IToken;
        maxLookBehind: number;
        mark(): number;
        release(marker: number): void;
        clear(): void;
        consume(): void;
        extElement(): IToken;
        isEndOfFile(o: IToken): boolean;
        get(i: number): IToken;
        la(i: number): number;
        toString2(start: IToken | number, stop: IToken | number): string;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime {
    import List = Stimulsoft.System.Collections.List;
    import Exception = Stimulsoft.System.Exception;
    class UnwantedTokenException extends MismatchedTokenException {
        constructor(message?: string, expecting?: number, input?: IIntStream, tokenNames?: List<string>, innerException?: Exception);
        get unexpectedToken(): IToken;
        toString(): string;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Misc {
    class Action {
    }
    class Func<TResult> extends Function {
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Misc {
    class RegexOptionsHelper {
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    import ITree = Stimulsoft.Data.Expressions.Antlr.Runtime.Tree.ITree;
    class AntlrRuntime_BaseTreeDebugView {
        private _tree;
        constructor(tree: BaseTree);
        get children(): ITree[];
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    class TreeRuleReturnScope<TTree> implements IRuleReturnScope<TTree> {
        private static ImplementsTreeRuleReturnScope;
        implements(): any[];
        private _start;
        start: TTree;
        stop: TTree;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    class AstTreeRuleReturnScope<TOutputTree, TInputTree> extends TreeRuleReturnScope<TInputTree> implements IAstRuleReturnScope<TOutputTree>, IAstRuleReturnScope<any> {
        private static ImplementsAstTreeRuleReturnScope;
        implements(): any[];
        tree: TOutputTree;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    import Dictionary = Stimulsoft.System.Collections.Dictionary;
    class BaseTreeAdaptor implements ITreeAdaptor {
        private static ImplementsBaseTreeAdaptor;
        implements(): any[];
        protected treeToUniqueIDMap: Dictionary<any, number>;
        protected uniqueNodeID: number;
        nil(): any;
        errorNode(input: ITokenStream, start: IToken, stop: IToken, e: RecognitionException): any;
        isNil(tree: any): boolean;
        dupNode(type?: number, treeNode?: any, text?: string): any;
        dupTree(t: any, parent?: any): any;
        addChild(t: any, child: any): void;
        becomeRoot(newRoot: any, oldRoot: any): any;
        rulePostProcessing(root: any): any;
        becomeRoot2(newRoot: IToken, oldRoot: any): any;
        create5(tokenType: number, fromToken: IToken): any;
        create2(tokenType: number, fromToken: IToken, text: string): any;
        create3(fromToken: IToken, text: string): any;
        create4(tokenType: number, text: string): any;
        getType(t: number): number;
        setType(t: any, type: number): void;
        getText(t: any): string;
        setText(t: any, text: string): void;
        getChild(t: any, i: number): any;
        setChild(t: any, i: number, child: any): void;
        deleteChild(t: any, i: number): any;
        getChildCount(t: any): number;
        getUniqueID(node: any): number;
        createToken2(tokenType: number, text: string): IToken;
        createToken(fromToken: IToken): IToken;
        create(payload: IToken): any;
        dupNode2(treeNode: any): any;
        getToken(t: any): IToken;
        setTokenBoundaries(t: any, startToken: IToken, stopToken: IToken): void;
        getTokenStartIndex(t: any): number;
        getTokenStopIndex(t: any): number;
        getParent(t: any): any;
        setParent(t: any, parent: any): any;
        getChildIndex(t: any): number;
        setChildIndex(t: any, index: number): void;
        replaceChildren(parent: any, startChildIndex: number, stopChildIndex: number, t: any): void;
        getTree(t: any): ITree;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    import List = Stimulsoft.System.Collections.List;
    import Stack = Stimulsoft.System.Collections.Stack;
    class BufferedTreeNodeStream implements ITreeNodeStream, ITokenStreamInformation {
        private static ImplementsBufferedTreeNodeStream;
        implements(): any[];
        DEFAULT_INITIAL_BUFFER_SIZE: number;
        INITIAL_CALL_STACK_SIZE: number;
        down: any;
        up: any;
        eof: any;
        nodes: List<any>;
        protected root: any;
        protected tokens: ITokenStream;
        adaptor: ITreeAdaptor;
        uniqueNavigationNodes: boolean;
        protected p: number;
        protected lastMarker: number;
        protected calls: Stack<number>;
        constructor(adaptor?: ITreeAdaptor, tree?: any, initialBufferSize?: number);
        get count(): number;
        get treeSource(): any;
        get sourceName(): string;
        get tokenStream(): ITokenStream;
        set tokenStream(value: ITokenStream);
        get treeAdaptor(): ITreeAdaptor;
        set treeAdaptor(value: ITreeAdaptor);
        get lastToken(): IToken;
        get lastRealToken(): IToken;
        maxLookBehind: number;
        fillBuffer(): void;
        fillBuffer2(t: any): void;
        protected getNodeIndex(node: any): number;
        protected addNavigationNode(ttype: number): void;
        get(i: number): any;
        lt(k: number): any;
        getCurrentSymbol(): any;
        protected lb(k: number): any;
        consume(): void;
        la(i: number): number;
        mark(): number;
        release(marker: number): void;
        get index(): number;
        rewind2(marker: number): void;
        rewind(): void;
        seek(index: number): void;
        push(index: number): void;
        pop(): number;
        reset(): void;
        iterator(): List<any>;
        replaceChildren(parent: any, startChildIndex: number, stopChildIndex: number, t: any): void;
        toTokenTypeString(): string;
        toTokenString(start: number, stop: number): string;
        toString(start: any, stop: any): string;
    }
    class StreamIterator extends List<any> {
        _outer: BufferedTreeNodeStream;
        _index: number;
        constructor(outer: BufferedTreeNodeStream);
        get current(): any;
        dispose(): void;
        moveNext(): boolean;
        reset(): void;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    class CommonErrorNode extends CommonTree {
        input: IIntStream;
        start: IToken;
        stop: IToken;
        trappedException: RecognitionException;
        constructor(input: ITokenStream, start: IToken, stop: IToken, e: RecognitionException);
        get isNil(): boolean;
        get text(): string;
        get type(): number;
        toString(): string;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    class CommonTreeAdaptor extends BaseTreeAdaptor {
        create(payload: IToken): CommonTree;
        createToken2(tokenType: number, text: string): IToken;
        createToken(fromToken: IToken): IToken;
        getToken(t: any): IToken;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    import LookaheadStream = Stimulsoft.Data.Expressions.Antlr.Runtime.Misc.LookaheadStream;
    class CommonTreeNodeStream extends LookaheadStream<any> implements ITreeNodeStream, IPositionTrackingStream {
        private static ImplementsCommonTreeNodeStream;
        implements(): any[];
        DEFAULT_INITIAL_BUFFER_SIZE: number;
        INITIAL_CALL_STACK_SIZE: number;
        private _root;
        protected tokens: ITokenStream;
        private _adaptor;
        private _it;
        private _calls;
        private _hasNilRoot;
        private _level;
        private _previousLocationElement;
        constructor(adaptor: ITreeAdaptor, tree: any);
        get sourceName(): string;
        get tokenStream(): ITokenStream;
        set tokenStream(value: ITokenStream);
        get treeAdaptor(): ITreeAdaptor;
        set treeAdaptor(value: ITreeAdaptor);
        get treeSource(): any;
        uniqueNavigationNodes: boolean;
        reset(): void;
        nextElement(): any;
        dequeue(): any;
        isEndOfFile(o: any): boolean;
        la(i: number): number;
        push(index: number): void;
        pop(): number;
        getKnownPositionElement(allowApproximateLocation: boolean): any;
        hasPositionInformation(node: any): boolean;
        replaceChildren(parent: any, startChildIndex: number, stopChildIndex: number, t: any): void;
        toString1(start: any, stop: any): string;
        toTokenTypeString(): string;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    import Dictionary = Stimulsoft.System.Collections.Dictionary;
    import List = Stimulsoft.System.Collections.List;
    class DotTreeGenerator {
        headerLines: string[];
        footer: string;
        nodeFormat: string;
        edgeFormat: string;
        nodeToNumberMap: Dictionary<any, number>;
        nodeNumber: number;
        toDot2(tree: any, adaptor: ITreeAdaptor): string;
        toDot(tree: ITree): string;
        protected defineNodes(tree: any, adaptor: ITreeAdaptor): List<string>;
        defineEdges(tree: any, adaptor: ITreeAdaptor): List<string>;
        protected getNodeText(adaptor: ITreeAdaptor, t: any): string;
        protected getNodeNumber(t: any): number;
        protected fixString(text: string): string;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    let IPositionTrackingStream: System.Interface<IPositionTrackingStream>;
    interface IPositionTrackingStream {
        getKnownPositionElement(allowApproximateLocation: boolean): any;
        hasPositionInformation(element: any): boolean;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    import List = Stimulsoft.System.Collections.List;
    let ITree: System.Interface<ITree>;
    interface ITree {
        getChild(i: number): ITree;
        childCount: number;
        parent: ITree;
        hasAncestor(ttype: number): boolean;
        getAncestor(ttype: number): ITree;
        getAncestors(): List<ITree>;
        childIndex: number;
        freshenParentAndChildIndexes(): any;
        addChild(t: ITree): any;
        setChild(i: number, t: ITree): any;
        deleteChild(i: number): any;
        replaceChildren(startChildIndex: number, stopChildIndex: number, t: any): any;
        isNil: boolean;
        tokenStartIndex: number;
        tokenStopIndex: number;
        dupNode(): ITree;
        type: number;
        text: string;
        line: number;
        charPositionInLine: number;
        toStringTree(): string;
        toString(): string;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    let ITreeAdaptor: System.Interface<ITreeAdaptor>;
    interface ITreeAdaptor {
        create(payload: IToken): any;
        create2(tokenType: number, fromToken: IToken, text: string): any;
        create3(fromToken: IToken, text: string): any;
        create4(tokenType: number, text: string): any;
        dupNode2(treeNode: any): any;
        dupNode(type?: number, treeNode?: any, text?: string): any;
        dupTree(tree: any): any;
        nil(): any;
        errorNode(input: ITokenStream, start: IToken, stop: IToken, e: RecognitionException): any;
        isNil(tree: any): boolean;
        addChild(t: any, child: any): any;
        becomeRoot(newRoot: IToken | any, oldRoot: any): any;
        rulePostProcessing(root: any): any;
        getUniqueID(node: any): number;
        getType(t: any): number;
        setType(t: any, type: number): any;
        getText(t: any): string;
        setText(t: any, text: string): any;
        getToken(t: any): IToken;
        setTokenBoundaries(t: any, startToken: IToken, stopToken: IToken): any;
        getTokenStartIndex(t: any): number;
        getTokenStopIndex(t: any): number;
        getChild(t: any, i: number): any;
        setChild(t: any, i: number, child: any): any;
        deleteChild(t: any, i: number): any;
        getChildCount(t: any): number;
        getParent(t: any): any;
        setParent(t: any, parent: any): any;
        getChildIndex(t: any): number;
        setChildIndex(t: any, index: number): any;
        replaceChildren(parent: any, startChildIndex: number, stopChildIndex: number, t: any): any;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    let ITreeVisitorAction: System.Interface<ITreeVisitorAction>;
    interface ITreeVisitorAction {
        pre(t: any): any;
        post(t: any): any;
    }
    class TreeVisitorAction implements ITreeVisitorAction {
        private static ImplementsTreeVisitorAction;
        implements(): any[];
        pre(t: any): any;
        post(t: any): any;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    import List = Stimulsoft.System.Collections.List;
    class ParseTree extends BaseTree {
        payload: any;
        hiddenTokens: List<IToken>;
        constructor(label: any);
        get text(): string;
        _tokenStartIndex: number;
        _tokenStopIndex: number;
        _type: number;
        dupNode(): ITree;
        toString(): string;
        toStringWithHiddenTokens(): string;
        toInputString(): string;
        protected toStringLeaves(buf: string): void;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    import Exception = Stimulsoft.System.Exception;
    class RewriteCardinalityException extends Exception {
        private _elementDescription;
        constructor(message?: string, elementDescription?: string, innerException?: Exception);
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    import Exception = Stimulsoft.System.Exception;
    class RewriteEarlyExitException extends RewriteCardinalityException {
        constructor(message?: string, elementDescription?: string, innerException?: Exception);
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    import Exception = Stimulsoft.System.Exception;
    class RewriteEmptyStreamException extends RewriteCardinalityException {
        constructor(message?: string, elementDescription?: string, innerException?: Exception);
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    import List = Stimulsoft.System.Collections.List;
    class RewriteRuleElementStream {
        protected cursor: number;
        protected singleElement: any;
        protected elements: List<any>;
        protected dirty: boolean;
        protected elementDescription: string;
        protected adaptor: ITreeAdaptor;
        constructor(adaptor: ITreeAdaptor, elementDescription: string, oneElement?: any, elements?: List<any>);
        reset(): void;
        add(el: any): void;
        nextTree(): any;
        nextCore(): any;
        protected dup(el: any): any;
        protected toTree(el: any): any;
        get hasNext(): boolean;
        get count(): number;
        get description(): string;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    import List = Stimulsoft.System.Collections.List;
    class RewriteRuleNodeStream extends RewriteRuleElementStream {
        constructor(adaptor: ITreeAdaptor, elementDescription: string, oneElement?: any, elements?: List<any>);
        nextNode(): any;
        protected toTree(el: any): any;
        protected dup(el: any): any;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    import List = Stimulsoft.System.Collections.List;
    class RewriteRuleSubtreeStream extends RewriteRuleElementStream {
        constructor(adaptor: ITreeAdaptor, elementDescription: string, oneElement?: any, elements?: List<any>);
        nextNode(): any;
        protected dup(el: any): any;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    import List = Stimulsoft.System.Collections.List;
    class RewriteRuleTokenStream extends RewriteRuleElementStream {
        constructor(adaptor: ITreeAdaptor, elementDescription: string, oneElement?: any, elements?: List<any>);
        nextNode(): any;
        nextToken(): IToken;
        toTree(el: any): any;
        protected dup(el: any): any;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    class TemplateTreeRuleReturnScope<TTemplate, TTree> extends TreeRuleReturnScope<TTree> implements ITemplateRuleReturnScope<TTemplate>, ITemplateRuleReturnScope<any> {
        private static ImplementsTemplateTreeRuleReturnScope;
        implements(): any[];
        template: TTemplate;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    class TreeParser extends BaseRecognizer {
        DOWN: number;
        UP: number;
        static dotdot: string;
        static doubleEtc: string;
        protected input: ITreeNodeStream;
        constructor(input: ITreeNodeStream, state?: RecognizerSharedState);
        reset(): void;
        setTreeNodeStream(input: ITreeNodeStream): void;
        getTreeNodeStream(): ITreeNodeStream;
        get sourceName(): string;
        protected getCurrentInputSymbol(input: IIntStream): any;
        protected getMissingSymbol(input: IIntStream, e: RecognitionException, expectedTokenType: number, follow: BitSet): any;
        matchAny(ignore: IIntStream): void;
        protected recoverFromMismatchedToken(input: IIntStream, ttype: number, follow: BitSet): any;
        getErrorHeader(e: RecognitionException): string;
        getErrorMessage(e: RecognitionException, tokenNames: string[]): string;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    import Action = Stimulsoft.Data.Expressions.Antlr.Runtime.Misc.Action;
    class TreeFilter extends TreeParser {
        protected originalTokenStream: ITokenStream;
        protected originalAdaptor: ITreeAdaptor;
        constructor(input: ITreeNodeStream, state?: RecognizerSharedState);
        applyOnce(t: any, whichRule: Action): void;
        downup(t: any): void;
        protected topdown(): void;
        protected bottomup(): void;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    import List = Stimulsoft.System.Collections.List;
    import Queue = Stimulsoft.System.Collections.Queue;
    class TreeIterator extends List<any> {
        protected adaptor: ITreeAdaptor;
        protected root: any;
        protected tree: any;
        protected firstTime: boolean;
        private reachedEof;
        up: any;
        down: any;
        eof: any;
        protected nodes: Queue<any>;
        constructor(adaptor: ITreeAdaptor, tree: any);
        current: any;
        dispose(): void;
        moveNext(): boolean;
        reset(): void;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    class TreePatternLexer {
        static begin: number;
        static end: number;
        static id: number;
        static arg: number;
        static percent: number;
        static colon: number;
        static dot: number;
        protected pattern: string;
        protected p: number;
        protected c: number;
        protected n: number;
        sval: string;
        error: boolean;
        constructor(pattern: string);
        nextToken(): number;
        consume(): void;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    class TreePatternParser {
        protected tokenizer: TreePatternLexer;
        protected ttype: number;
        protected wizard: TreeWizard;
        protected adaptor: ITreeAdaptor;
        constructor(tokenizer: TreePatternLexer, wizard: TreeWizard, adaptor: ITreeAdaptor);
        pattern(): any;
        parseTree(): any;
        parseNode(): any;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    class TreeRewriter extends TreeParser {
        protected showTransformations: boolean;
        protected originalTokenStream: ITokenStream;
        protected originalAdaptor: ITreeAdaptor;
        constructor(input: ITreeNodeStream, state: RecognizerSharedState);
        applyOnce(t: any, whichRule: Misc.Func<IAstRuleReturnScope<any>>): any;
        applyRepeatedly(t: any, whichRule: Misc.Func<IAstRuleReturnScope<any>>): any;
        downup(t: any, showTransformations?: boolean): any;
        protected topdown(): IAstRuleReturnScope<any>;
        protected bottomup(): IAstRuleReturnScope<any>;
        protected reportTransformation(oldTree: any, newTree: any): void;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    class TreeVisitor {
        protected adaptor: ITreeAdaptor;
        constructor(adaptor?: ITreeAdaptor);
        visit(t: any, action: ITreeVisitorAction): any;
    }
}
export namespace Stimulsoft.Data.Expressions.Antlr.Runtime.Tree {
    import Dictionary = Stimulsoft.System.Collections.Dictionary;
    import List = Stimulsoft.System.Collections.List;
    import Action = Stimulsoft.Data.Expressions.Antlr.Runtime.Misc.Action;
    class TreeWizard {
        protected adaptor: ITreeAdaptor;
        protected tokenNameToTypeMap: Dictionary<string, number>;
        computeTokenTypes(tokenNames: string[]): Dictionary<string, number>;
        getTokenType(tokenName: string): number;
        index(t: any): Dictionary<number, List<any>>;
        protected indexCore(t: any, m: Dictionary<number, List<any>>): void;
        find(t: any, ttype: number): List<any>;
        find2(t: any, pattern: string): List<any>;
        findFirst(t: any, ttype: number): any;
        findFirst2(t: any, pattern: string): any;
        visit(t: any, ttype: number, visitor: IContextVisitor): void;
        visit2(t: any, ttype: number, action: Action): void;
        protected visitCore(t: any, parent: any, childIndex: number, ttype: number, visitor: IContextVisitor): void;
        visit3(t: any, pattern: string, visitor: IContextVisitor): void;
        parse(t: any, pattern: string, labels: Dictionary<string, any>): boolean;
        parse2(t: any, pattern: string): boolean;
        parseCore(t1: any, tpattern: TreePattern, labels: Dictionary<string, any>): boolean;
        create(pattern: string): any;
        static equals(t1: any, t2: any, adaptor: ITreeAdaptor): boolean;
        protected static equalsCore(t1: any, t2: any, adaptor: ITreeAdaptor): boolean;
    }
    let IContextVisitor: System.Interface<IContextVisitor>;
    interface IContextVisitor {
        visit(t: any, parent: any, childIndex: number, labels: Dictionary<string, any>): any;
    }
    class Visitor implements IContextVisitor {
        private static ImplementsVisitor;
        implements(): any[];
        visit2(t: any, parent: any, childIndex: number, labels: Dictionary<string, any>): void;
        visit(t: any): void;
    }
    class ActionVisitor extends Visitor {
        _action: Action;
        constructor(action: Action);
        visit(t: any): void;
    }
    class TreePattern extends CommonTree {
        label: string;
        hasTextArg: boolean;
        constructor(payload: IToken);
        toString(): string;
    }
    class WildcardTreePattern extends TreePattern {
        constructor(payload: IToken);
    }
    class TreePatternTreeAdaptor extends CommonTreeAdaptor {
        create(payload: IToken): any;
    }
    class FindTreeWizardVisitor extends Visitor {
        _nodes: List<any>;
        constructor(nodes: List<any>);
        visit(t: any): void;
    }
    class FindTreeWizardContextVisitor implements IContextVisitor {
        private static ImplementsFindTreeWizardContextVisitor;
        implements(): any[];
        _outer: TreeWizard;
        _tpattern: TreePattern;
        _subtrees: List<any>;
        constructor(outer: TreeWizard, tpattern: TreePattern, subtrees: List<any>);
        visit(t: any, parent: any, childIndex: number, labels: Dictionary<string, any>): void;
    }
    class VisitTreeWizardContextVisitor implements IContextVisitor {
        private static ImplementsVisitTreeWizardContextVisitor;
        implements(): any[];
        _outer: TreeWizard;
        _visitor: IContextVisitor;
        _labels: Dictionary<string, any>;
        _tpattern: TreePattern;
        constructor(outer: TreeWizard, visitor: IContextVisitor, labels: Dictionary<string, any>, tpattern: TreePattern);
        visit(t: any, parent: any, childIndex: number, unusedlabels: Dictionary<string, any>): void;
    }
}
export namespace Stimulsoft.Data.Expressions.NCalc {
    import Exception = Stimulsoft.System.Exception;
    class EvaluationException extends Exception {
        constructor(message: string, innerException?: Exception);
    }
}
export namespace Stimulsoft.Data.Expressions.NCalc {
    enum EvaluateOptions {
        None = 1,
        IgnoreCase = 2,
        NoCache = 4,
        IterateParameters = 8,
        RoundAwayFromZero = 16
    }
}
export namespace Stimulsoft.Data.Expressions.NCalc.Domain {
    class LogicalExpression {
        static bs: string;
        private static extractString;
        and(operand: LogicalExpression | any): BinaryExpression;
        dividedBy(operand: LogicalExpression | any): BinaryExpression;
        equalsTo(operand: LogicalExpression | any): BinaryExpression;
        greaterThan(operand: LogicalExpression | any): BinaryExpression;
        greaterOrEqualThan(operand: LogicalExpression | any): BinaryExpression;
        lesserThan(operand: LogicalExpression | any): BinaryExpression;
        lesserOrEqualThan(operand: LogicalExpression | any): BinaryExpression;
        minus(operand: LogicalExpression | any): BinaryExpression;
        modulo(operand: LogicalExpression | any): BinaryExpression;
        notEqual(operand: LogicalExpression | any): BinaryExpression;
        or(operand: LogicalExpression | any): BinaryExpression;
        plus(operand: LogicalExpression | any): BinaryExpression;
        mult(operand: LogicalExpression | any): BinaryExpression;
        bitwiseOr(operand: LogicalExpression | any): BinaryExpression;
        bitwiseAnd(operand: LogicalExpression | any): BinaryExpression;
        bitwiseXOr(operand: LogicalExpression | any): BinaryExpression;
        leftShift(operand: LogicalExpression | any): BinaryExpression;
        rightShift(operand: LogicalExpression | any): BinaryExpression;
        toString(): string;
        accept(visitor: LogicalExpressionVisitor): void;
    }
}
export namespace Stimulsoft.Data.Expressions.NCalc.Domain {
    import LogicalExpressionVisitor = Stimulsoft.Data.Expressions.NCalc.Domain.LogicalExpressionVisitor;
    import Dictionary = Stimulsoft.System.Collections.Dictionary;
    class EvaluationVisitor extends LogicalExpressionVisitor {
        private _options;
        private get ignoreCase();
        constructor(options: EvaluateOptions);
        result: any;
        evaluate(expression: LogicalExpression): any;
        visit1(expression: LogicalExpression): void;
        private static commonTypes;
        private static getMostPreciseType;
        compareUsingMostPreciseType(a: any, b: any): any;
        visit2(expression: TernaryExpression): void;
        private static isReal;
        visit3(expression: BinaryExpression): void;
        visit4(expression: UnaryExpression): void;
        visit5(expression: ValueExpression): void;
        visit6(functionn: Functionn): void;
        private checkCase;
        evaluateFunction: (name: string, args: FunctionArgs) => void;
        private onEvaluateFunction;
        visit7(parameter: Identifier): void;
        evaluateParameter: (...args: any[]) => void;
        private onEvaluateParameter;
        parameters: Dictionary<string, any>;
    }
}
export namespace Stimulsoft.Data.Expressions.NCalc {
    import BaseRecognizer = Stimulsoft.Data.Expressions.Antlr.Runtime.BaseRecognizer;
    import DFA = Stimulsoft.Data.Expressions.Antlr.Runtime.DFA;
    import NoViableAltException = Stimulsoft.Data.Expressions.Antlr.Runtime.NoViableAltException;
    import RecognizerSharedState = Stimulsoft.Data.Expressions.Antlr.Runtime.RecognizerSharedState;
    import Lexer = Stimulsoft.Data.Expressions.Antlr.Runtime.Lexer;
    import ICharStream = Stimulsoft.Data.Expressions.Antlr.Runtime.ICharStream;
    export class NCalcLexer extends Lexer {
        EOF: number;
        DATETIME: number;
        DIGIT: number;
        E: number;
        EscapeSequence: number;
        FALSE: number;
        FLOAT: number;
        HexDigit: number;
        ID: number;
        INTEGER: number;
        LETTER: number;
        NAME: number;
        STRING: number;
        TRUE: number;
        UnicodeEscape: number;
        WS: number;
        T__19: number;
        T__20: number;
        T__21: number;
        T__22: number;
        T__23: number;
        T__24: number;
        T__25: number;
        T__26: number;
        T__27: number;
        T__28: number;
        T__29: number;
        T__30: number;
        T__31: number;
        T__32: number;
        T__33: number;
        T__34: number;
        T__35: number;
        T__36: number;
        T__37: number;
        T__38: number;
        T__39: number;
        T__40: number;
        T__41: number;
        T__42: number;
        T__43: number;
        T__44: number;
        T__45: number;
        T__46: number;
        T__47: number;
        T__48: number;
        constructor(input?: ICharStream, state?: RecognizerSharedState);
        mT__19(): void;
        mT__20(): void;
        mT__21(): void;
        mT__22(): void;
        mT__23(): void;
        mT__24(): void;
        mT__25(): void;
        mT__26(): void;
        mT__27(): void;
        mT__28(): void;
        mT__29(): void;
        mT__30(): void;
        mT__31(): void;
        mT__32(): void;
        mT__33(): void;
        enterRule_T__34(): void;
        leaveRule_T__34(): void;
        mT__34(): void;
        mT__35(): void;
        mT__36(): void;
        mT__37(): void;
        mT__38(): void;
        mT__39(): void;
        mT__40(): void;
        mT__41(): void;
        mT__42(): void;
        mT__43(): void;
        mT__44(): void;
        enterRule_T__45(): void;
        leaveRule_T__45(): void;
        mT__45(): void;
        mT__46(): void;
        mT__47(): void;
        mT__48(): void;
        mTRUE(): void;
        mFALSE(): void;
        mID(): void;
        mINTEGER(): void;
        mFLOAT(): void;
        mSTRING(): void;
        mDATETIME(): void;
        mNAME(): void;
        mE(): void;
        mLETTER(): void;
        mDIGIT(): void;
        mEscapeSequence(): void;
        mHexDigit(): void;
        mUnicodeEscape(): void;
        mWS(): void;
        mTokens(): void;
        dfa7: DFA7;
        dfa14: DFA14;
        initDFAs(): void;
    }
    class DFA7 extends DFA {
        static DFA7_eotS: string;
        static DFA7_eofS: string;
        static DFA7_minS: string;
        static DFA7_maxS: string;
        static DFA7_acceptS: string;
        static DFA7_specialS: string;
        private static DFA7_transitionS;
        private static DFA7_eot;
        private static DFA7_eof;
        private static DFA7_min;
        private static DFA7_max;
        private static DFA7_accept;
        private static DFA7_special;
        private static DFA7_transition;
        static initialize(): void;
        constructor(recognizer: BaseRecognizer);
        description: string;
        error(nvae: NoViableAltException): void;
    }
    class DFA14 extends DFA {
        static DFA14_eotS: string;
        static DFA14_eofS: string;
        static DFA14_minS: string;
        static DFA14_maxS: string;
        static DFA14_acceptS: string;
        static DFA14_specialS: string;
        private static DFA14_transitionS;
        private static DFA14_eot;
        private static DFA14_eof;
        private static DFA14_min;
        private static DFA14_max;
        private static DFA14_accept;
        private static DFA14_special;
        private static DFA14_transition;
        static initialize(): void;
        constructor(recognizer: BaseRecognizer);
        description: string;
        error(nvae: NoViableAltException): void;
    }
    export {};
}
export namespace Stimulsoft.Data.Expressions.NCalc {
    import LogicalExpression = Stimulsoft.Data.Expressions.NCalc.Domain.LogicalExpression;
    import Dictionary = Stimulsoft.System.Collections.Dictionary;
    import List = Stimulsoft.System.Collections.List;
    class ReaderWriterLock {
        releaseReaderLock(): void;
        releaseWriterLock(): void;
        acquireReaderLock(t: number): void;
        acquireWriterLock(t: number): void;
    }
    class WeakReference {
        constructor(t: LogicalExpression);
        isAlive: boolean;
    }
    class Expression {
        static Timeout: {
            Infinite: number;
        };
        options: EvaluateOptions;
        protected originalExpression: string;
        constructor();
        static create1(expression: string, options?: EvaluateOptions): Expression;
        static create2(expression: LogicalExpression, options?: EvaluateOptions): Expression;
        private static _cacheEnabled;
        private static _compiledExpressions;
        private static rwl;
        static get cacheEnabled(): boolean;
        static set cacheEnabled(value: boolean);
        private static cleanCache;
        static compile(expression: string, nocache: boolean): LogicalExpression;
        hasErrors(): boolean;
        error: string;
        parsedExpression: LogicalExpression;
        protected parameterEnumerators: Dictionary<string, List<any>>;
        protected parametersBackup: Dictionary<string, any>;
        evaluate(): any;
        evaluateFunction: any;
        evaluateParameter: any;
        parameters: Dictionary<string, any>;
    }
}
export namespace Stimulsoft.Data.Expressions.NCalc {
    import List = Stimulsoft.System.Collections.List;
    import EventArgs = Stimulsoft.System.EventArgs;
    class FunctionArgs extends EventArgs {
        private _result;
        get result(): any;
        set result(value: any);
        hasResult: boolean;
        parameters: List<Expression>;
        evaluateParameters(): any[];
    }
}
export namespace Stimulsoft.Data.Expressions.NCalc.Domain {
    class Functionn extends LogicalExpression {
        constructor(identifier: Identifier, expressions: LogicalExpression[]);
        identifier: Identifier;
        expressions: LogicalExpression[];
        accept(visitor: LogicalExpressionVisitor): void;
    }
}
export namespace Stimulsoft.Data.Expressions.NCalc.Domain {
    class UnaryExpression extends LogicalExpression {
        constructor(type: UnaryExpressionType, expression: LogicalExpression);
        expression: LogicalExpression;
        type: UnaryExpressionType;
        accept(visitor: LogicalExpressionVisitor): void;
    }
    enum UnaryExpressionType {
        Not = 0,
        Negate = 1,
        BitwiseNot = 2
    }
}
export namespace Stimulsoft.Data.Expressions.NCalc.Domain {
    class BinaryExpression extends LogicalExpression {
        constructor(type: BinaryExpressionType, leftExpression: LogicalExpression, rightExpression: LogicalExpression);
        leftExpression: LogicalExpression;
        rightExpression: LogicalExpression;
        type: BinaryExpressionType;
        accept(visitor: LogicalExpressionVisitor): void;
    }
    enum BinaryExpressionType {
        And = 0,
        Or = 1,
        NotEqual = 2,
        LesserOrEqual = 3,
        GreaterOrEqual = 4,
        Lesser = 5,
        Greater = 6,
        Equal = 7,
        Minus = 8,
        Plus = 9,
        Modulo = 10,
        Div = 11,
        Times = 12,
        BitwiseOr = 13,
        BitwiseAnd = 14,
        BitwiseXOr = 15,
        LeftShift = 16,
        RightShift = 17,
        Unknown = 18
    }
}
export namespace Stimulsoft.Data.Expressions.NCalc.Domain {
    class TernaryExpression extends LogicalExpression {
        constructor(leftExpression: LogicalExpression, middleExpression: LogicalExpression, rightExpression: LogicalExpression);
        leftExpression: LogicalExpression;
        middleExpression: LogicalExpression;
        rightExpression: LogicalExpression;
        accept(visitor: LogicalExpressionVisitor): void;
    }
}
export namespace Stimulsoft.Data.Expressions.NCalc.Domain {
    class ValueExpression extends LogicalExpression {
        constructor(value: any, type?: ValueType);
        value: any;
        type: ValueType;
        accept(visitor: LogicalExpressionVisitor): void;
    }
    enum ValueType {
        Integer = 0,
        String = 1,
        DateTime = 2,
        Float = 3,
        Boolean = 4
    }
}
export namespace Stimulsoft.Data.Expressions.NCalc.Domain {
    class Identifier extends LogicalExpression {
        constructor(name: string);
        name: string;
        accept(visitor: LogicalExpressionVisitor): void;
    }
}
export namespace Stimulsoft.Data.Expressions.NCalc {
    import ValueExpression = Stimulsoft.Data.Expressions.NCalc.Domain.ValueExpression;
    import Identifier = Stimulsoft.Data.Expressions.NCalc.Domain.Identifier;
    import RecognitionException = Stimulsoft.Data.Expressions.Antlr.Runtime.RecognitionException;
    import RecognizerSharedState = Stimulsoft.Data.Expressions.Antlr.Runtime.RecognizerSharedState;
    import Parser = Stimulsoft.Data.Expressions.Antlr.Runtime.Parser;
    import ITokenStream = Stimulsoft.Data.Expressions.Antlr.Runtime.ITokenStream;
    import List = Stimulsoft.System.Collections.List;
    import AstParserRuleReturnScope = Stimulsoft.Data.Expressions.Antlr.Runtime.AstParserRuleReturnScope;
    import IToken = Stimulsoft.Data.Expressions.Antlr.Runtime.IToken;
    import LogicalExpression = Stimulsoft.Data.Expressions.NCalc.Domain.LogicalExpression;
    import ITreeAdaptor = Stimulsoft.Data.Expressions.Antlr.Runtime.Tree.ITreeAdaptor;
    export class NCalcParser extends Parser {
        tokenNames: string[];
        EOF: number;
        DATETIME: number;
        DIGIT: number;
        E: number;
        EscapeSequence: number;
        FALSE: number;
        FLOAT: number;
        HexDigit: number;
        ID: number;
        INTEGER: number;
        LETTER: number;
        NAME: number;
        STRING: number;
        TRUE: number;
        UnicodeEscape: number;
        WS: number;
        T__19: number;
        T__20: number;
        T__21: number;
        T__22: number;
        T__23: number;
        T__24: number;
        T__25: number;
        T__26: number;
        T__27: number;
        T__28: number;
        T__29: number;
        T__30: number;
        T__31: number;
        T__32: number;
        T__33: number;
        T__34: number;
        T__35: number;
        T__36: number;
        T__37: number;
        T__38: number;
        T__39: number;
        T__40: number;
        T__41: number;
        T__42: number;
        T__43: number;
        T__44: number;
        T__45: number;
        T__46: number;
        T__47: number;
        T__48: number;
        constructor(input: ITokenStream, state?: RecognizerSharedState);
        createTreeAdaptor(adaptor: {
            ref: ITreeAdaptor;
        }): void;
        adaptor: ITreeAdaptor;
        grammarFileName: string;
        private bs;
        private extractString;
        errors: List<string>;
        displayRecognitionError(tokenNames: string[], e: RecognitionException): void;
        onCreated(): void;
        enterRule(ruleName: string, ruleIndex: number): void;
        leaveRule(ruleName: string, ruleIndex: number): void;
        traceIn(ruleName: string, ruleIndex: number): void;
        enterRule_ncalcExpression(): void;
        leaveRule_ncalcExpression(): void;
        ncalcExpression(): ncalcExpression_return;
        enterRule_logicalExpression(): void;
        leaveRule_logicalExpression(): void;
        private logicalExpression;
        enterRule_conditionalExpression(): void;
        leaveRule_conditionalExpression(): void;
        private conditionalExpression;
        enterRule_booleanAndExpression(): void;
        leaveRule_booleanAndExpression(): void;
        booleanAndExpression(): booleanAndExpression_return;
        enterRule_bitwiseOrExpression(): void;
        leaveRule_bitwiseOrExpression(): void;
        bitwiseOrExpression(): bitwiseOrExpression_return;
        enterRule_bitwiseXOrExpression(): void;
        leaveRule_bitwiseXOrExpression(): void;
        bitwiseXOrExpression(): bitwiseXOrExpression_return;
        enterRule_bitwiseAndExpression(): void;
        leaveRule_bitwiseAndExpression(): void;
        bitwiseAndExpression(): bitwiseAndExpression_return;
        enterRule_equalityExpression(): void;
        leaveRule_equalityExpression(): void;
        equalityExpression(): equalityExpression_return;
        enterRule_relationalExpression(): void;
        leaveRule_relationalExpression(): void;
        relationalExpression(): relationalExpression_return;
        enterRule_shiftExpression(): void;
        leaveRule_shiftExpression(): void;
        shiftExpression(): shiftExpression_return;
        enterRule_additiveExpression(): void;
        leaveRule_additiveExpression(): void;
        additiveExpression(): additiveExpression_return;
        enterRule_multiplicativeExpression(): void;
        leaveRule_multiplicativeExpression(): void;
        multiplicativeExpression(): multiplicativeExpression_return;
        enterRule_unaryExpression(): void;
        leaveRule_unaryExpression(): void;
        unaryExpression(): unaryExpression_return;
        enterRule_primaryExpression(): void;
        leaveRule_primaryExpression(): void;
        primaryExpression(): primaryExpression_return;
        enterRule_value(): void;
        leaveRule_value(): void;
        value(): value_return;
        enterRule_identifier(): void;
        leaveRule_identifier(): void;
        identifier(): identifier_return;
        enterRule_expressionList(): void;
        leaveRule_expressionList(): void;
        expressionList(): expressionList_return;
        enterRule_arguments(): void;
        leaveRule_arguments(): void;
        arguments(): arguments_return;
    }
    class ncalcExpression_return extends AstParserRuleReturnScope<any, IToken> {
        value: LogicalExpression;
        constructor(grammar: NCalcParser);
        onCreated(grammar: NCalcParser): void;
    }
    class booleanAndExpression_return extends AstParserRuleReturnScope<any, IToken> {
        value: LogicalExpression;
        constructor(grammar: NCalcParser);
        onCreated(grammar: any): void;
    }
    class bitwiseOrExpression_return extends AstParserRuleReturnScope<any, IToken> {
        value: LogicalExpression;
        constructor(grammar: NCalcParser);
        onCreated(grammar: NCalcParser): void;
    }
    class bitwiseXOrExpression_return extends AstParserRuleReturnScope<any, IToken> {
        value: LogicalExpression;
        constructor(grammar: NCalcParser);
        onCreated(grammar: NCalcParser): void;
    }
    class bitwiseAndExpression_return extends AstParserRuleReturnScope<any, IToken> {
        value: LogicalExpression;
        constructor(grammar: NCalcParser);
        onCreated(grammar: NCalcParser): void;
    }
    class equalityExpression_return extends AstParserRuleReturnScope<any, IToken> {
        value: LogicalExpression;
        constructor(grammar: NCalcParser);
        onCreated(grammar: NCalcParser): void;
    }
    class relationalExpression_return extends AstParserRuleReturnScope<any, IToken> {
        value: LogicalExpression;
        constructor(grammar: NCalcParser);
        onCreated(grammar: NCalcParser): void;
    }
    class shiftExpression_return extends AstParserRuleReturnScope<any, IToken> {
        value: LogicalExpression;
        constructor(grammar: NCalcParser);
        onCreated(grammar: NCalcParser): void;
    }
    class additiveExpression_return extends AstParserRuleReturnScope<any, IToken> {
        value: LogicalExpression;
        constructor(grammar: NCalcParser);
        onCreated(grammar: NCalcParser): void;
    }
    class multiplicativeExpression_return extends AstParserRuleReturnScope<any, IToken> {
        value: LogicalExpression;
        constructor(grammar: NCalcParser);
        onCreated(grammar: NCalcParser): void;
    }
    class unaryExpression_return extends AstParserRuleReturnScope<any, IToken> {
        value: LogicalExpression;
        constructor(grammar: NCalcParser);
        onCreated(grammar: NCalcParser): void;
    }
    class primaryExpression_return extends AstParserRuleReturnScope<any, IToken> {
        value: LogicalExpression;
        constructor(grammar: NCalcParser);
        onCreated(grammar: NCalcParser): void;
    }
    class value_return extends AstParserRuleReturnScope<any, IToken> {
        value: ValueExpression;
        constructor(grammar: NCalcParser);
        onCreated(grammar: NCalcParser): void;
    }
    class identifier_return extends AstParserRuleReturnScope<any, IToken> {
        value: Identifier;
        constructor(grammar: NCalcParser);
        onCreated(grammar: NCalcParser): void;
    }
    class expressionList_return extends AstParserRuleReturnScope<any, IToken> {
        value: List<LogicalExpression>;
        constructor(grammar: NCalcParser);
        onCreated(grammar: NCalcParser): void;
    }
    class arguments_return extends AstParserRuleReturnScope<any, IToken> {
        value: List<LogicalExpression>;
        constructor(grammar: NCalcParser);
        onCreated(grammar: NCalcParser): void;
    }
    export {};
}
export namespace Stimulsoft.Data.Expressions.NCalc {
    class Numbers {
        private static convertIfString;
        static add(a: any, b: any): any;
        static soustract(a: any, b: any): any;
        static multiply(a: any, b: any): any;
        static divide(a: any, b: any): any;
        static modulo(a: any, b: any): any;
        static max(a: any, b: any): any;
        static min(a: any, b: any): any;
    }
}
export namespace Stimulsoft.Data.Expressions.NCalc {
    import EventArgs = Stimulsoft.System.EventArgs;
    class ParameterArgs extends EventArgs {
        private _result;
        get result(): any;
        set result(value: any);
        hasResult: boolean;
    }
}
export namespace Stimulsoft.Data.Expressions.NCalc.Domain {
    class SerializationVisitor extends LogicalExpressionVisitor {
        private _numberFormatInfo;
        constructor();
        result: string;
        visit1(expression: LogicalExpression): void;
        visit2(expression: TernaryExpression): void;
        visit3(expression: BinaryExpression): void;
        visit4(expression: UnaryExpression): void;
        visit5(expression: ValueExpression): void;
        visit6(functionn: Functionn): void;
        visit7(parameter: Identifier): void;
        encapsulateNoValue(expression: LogicalExpression): void;
    }
}
export namespace Stimulsoft.Data.Helpers {
    class StiHumanReadableHelper {
        static getSize(size: number): string;
        static getHumanReadableName(name: string): string;
    }
}
export namespace Stimulsoft.Data.Helpers {
    class StiMoneyNameHelper {
        static isMoneyName(name: string): boolean;
    }
}
export namespace Stimulsoft.Data.Extensions {
    import DataColumn = Stimulsoft.System.Data.DataColumn;
    class DataColumnExt {
        static isNumericType(column: DataColumn): boolean;
        static isDateType(column: DataColumn): boolean;
        static isIntegerType(column: DataColumn): boolean;
        static isMoneyName(column: DataColumn): boolean;
        static getHumanReadableName(column: DataColumn): string;
    }
}
export namespace Stimulsoft.Data.Extensions {
    class DataTimeExt {
    }
}
export namespace Stimulsoft.Data.Extensions {
    class EnumerableRowCollectionExt {
    }
}
export namespace Stimulsoft.Data.Extensions {
}
export namespace Stimulsoft.Data.Helpers {
    import IStiMeter = Stimulsoft.Base.Meters.IStiMeter;
    class StiLabelHelper {
        private static cache;
        static getLabel(meter: IStiMeter): string;
    }
}
export namespace Stimulsoft.Data.Extensions {
    import List = Stimulsoft.System.Collections.List;
    import DataTable = Stimulsoft.System.Data.DataTable;
    import IStiMeter = Stimulsoft.Base.Meters.IStiMeter;
    class ListTableExt {
        static toNetTable(source: List<any[]>, meters: List<IStiMeter>, onlyColumns?: boolean, convertsArray?: boolean): DataTable;
        private static loadDataRow;
        private static findType;
        private static findTypeInRows;
    }
}
export namespace Stimulsoft.Data.Extensions {
    import List = Stimulsoft.System.Collections.List;
    import IStiMeter = Stimulsoft.Base.Meters.IStiMeter;
    import IStiDimensionMeter = Stimulsoft.Base.Meters.IStiDimensionMeter;
    class StiMeterExt {
        static indexOf(meters: List<IStiMeter>, meter: IStiMeter): number;
        static getDimensions(meters: List<IStiMeter>): List<IStiDimensionMeter>;
    }
}
export namespace Stimulsoft.Data.Extensions {
    class TOuterExt {
    }
}
export namespace Stimulsoft.Data.Functions {
    import DateTime = Stimulsoft.System.DateTime;
    class StiDayOfWeekToStrHelper {
        private static days;
        private static defaultUpperCaseList;
        private static cultureIndexes;
        static dayOfWeek(date: DateTime): string;
        static dayOfWeek2(date: DateTime, localized: boolean): string;
        static dayOfWeek3(dayOfWeek: StiDayOfWeek, culture: string): string;
        static dayOfWeek4(dateTime: DateTime, culture: string, upperCase: boolean): string;
        static dayOfWeek5(str: string): StiDayOfWeek | null;
        static dayOfWeek6(dateTime: DateTime, culture: string): string;
        static addCulture(monthNames: string[], cultureNames: string[], defaultUpperCase: boolean): void;
        static initialize(): void;
    }
}
export namespace Stimulsoft.Data.Functions {
    class StiExtValueConverter {
        static isEligable(value: any, culture: string): boolean;
        static convert(value: any, culture: string): string;
    }
}
export namespace Stimulsoft.Data.Helpers {
    import DataTable = Stimulsoft.System.Data.DataTable;
    import Type = Stimulsoft.System.Type;
    import StiDataTable = Stimulsoft.Data.Engine.StiDataTable;
    class StiDataTableConverter {
        static toNetTable(dataTable: StiDataTable, types?: Type[]): DataTable;
        private static getDataType;
    }
}
export namespace Stimulsoft.Data.Helpers {
    import List = Stimulsoft.System.Collections.List;
    import IStiMeter = Stimulsoft.Base.Meters.IStiMeter;
    class StiUsedDataHelper {
        static getMany(...meters: IStiMeter[]): List<string>;
        static getMany2(meters: List<IStiMeter>): List<string>;
        static getSingle(meter: IStiMeter): List<string>;
        static getSingle2(expression: string): List<string>;
    }
}
export namespace Stimulsoft.Data.Parsers {
    class StiFunctionColumnPair {
        private _function;
        get function(): string;
        set function(value: string);
        private _columnName;
        get columnName(): string;
        set columnName(value: string);
    }
}
export namespace Stimulsoft.Report {
    enum StiParserType {
        ReportParser = 0,
        DataParser = 1
    }
    enum StiNestedFactor {
        High = 0,
        Normal = 1,
        Low = 2
    }
    enum StiOrientation {
        Horizontal = 0,
        Vertical = 1
    }
    enum StiResizeReportOptions {
        ProcessAllPages = 1,
        RebuildReport = 2,
        RescaleContent = 4,
        PageOrientationChanged = 8,
        ShowProgressOnRebuildReport = 16,
        AllowPageMarginsRescaling = 32
    }
    enum StiCalculationMode {
        Compilation = 0,
        Interpretation = 1
    }
    enum StiReportLanguageType {
        CSharp = 0,
        VB = 1,
        JS = 2
    }
    enum StiReportUnitType {
        Centimeters = 0,
        HundredthsOfInch = 1,
        Inches = 2,
        Millimeters = 3
    }
    enum StiGridMode {
        Lines = 0,
        Dots = 1
    }
    enum StiReportPass {
        None = 0,
        First = 1,
        Second = 2
    }
    enum StiNumberOfPass {
        SinglePass = 0,
        DoublePass = 1
    }
    enum StiExportFormat {
        None = 0,
        Pdf = 1,
        Xps = 2,
        HtmlTable = 3,
        HtmlSpan = 4,
        HtmlDiv = 5,
        Rtf = 6,
        RtfTable = 7,
        RtfFrame = 8,
        RtfWinWord = 9,
        RtfTabbedText = 10,
        Text = 11,
        Excel = 12,
        ExcelXml = 13,
        Excel2007 = 14,
        Word2007 = 15,
        Xml = 16,
        Csv = 17,
        Dif = 18,
        Sylk = 19,
        Image = 20,
        ImageGif = 21,
        ImageBmp = 22,
        ImagePng = 23,
        ImageTiff = 24,
        ImageJpeg = 25,
        ImagePcx = 26,
        ImageEmf = 27,
        ImageSvg = 28,
        ImageSvgz = 29,
        Mht = 30,
        Dbf = 31,
        Html = 32,
        Ods = 33,
        Odt = 34,
        Ppt2007 = 35,
        Html5 = 36,
        Data = 37,
        Json = 38,
        Document = 1000
    }
    enum StiReportCacheMode {
        Off = 0,
        On = 1,
        Auto = 2
    }
    enum StiReportResourceType {
        Bitmap = 0,
        Metafile = 1,
        Report = 2
    }
    enum StiRangeType {
        All = 1,
        CurrentPage = 2,
        Pages = 3
    }
    enum StiHtmlType {
        Html = 1,
        Html5 = 2,
        Mht = 3
    }
    enum ImageFormat {
        Bmp = 0,
        Emf = 1,
        Exif = 2,
        Gif = 3,
        Guid = 4,
        Icon = 5,
        Jpeg = 6,
        MemoryBmp = 7,
        Png = 8,
        Tiff = 9,
        Wmf = 10
    }
    enum StiArabicDigitsType {
        Standard = 0,
        Eastern = 1
    }
    enum StiBrushType {
        Solid = 0,
        Glare = 1,
        Gradient0 = 2,
        Gradient90 = 3,
        Gradient180 = 4,
        Gradient270 = 5,
        Gradient45 = 6
    }
    enum StiComponentId {
        StiComponent = 0,
        StiBarCode = 1,
        StiButtonControl = 2,
        StiChart = 3,
        StiSparkline = 4,
        StiChartCommon = 5,
        StiCheckBox = 6,
        StiCheckBoxControl = 7,
        StiCheckedListBoxControl = 8,
        StiChildBand = 9,
        StiClone = 10,
        StiColumnFooterBand = 11,
        StiColumnHeaderBand = 12,
        StiComboBoxControl = 13,
        StiContainer = 14,
        StiContourText = 15,
        StiCrossColumn = 16,
        StiCrossColumnTotal = 17,
        StiCrossDataBand = 18,
        StiCrossFooterBand = 19,
        StiCrossGroupFooterBand = 20,
        StiCrossGroupHeaderBand = 21,
        StiCrossHeaderBand = 22,
        StiCrossRow = 23,
        StiCrossRowTotal = 24,
        StiCrossSummary = 25,
        StiCrossTab = 26,
        StiCrossTitle = 27,
        StiDashboardPage = 28,
        StiDataBand = 29,
        StiDateTimePickerControl = 30,
        StiEmptyBand = 31,
        StiFooterBand = 32,
        StiForm = 33,
        StiGridControl = 34,
        StiGroupBoxControl = 35,
        StiGroupFooterBand = 36,
        StiGroupHeaderBand = 37,
        StiHeaderBand = 38,
        StiHierarchicalBand = 39,
        StiHorizontalLinePrimitive = 40,
        StiImage = 41,
        StiLabelControl = 42,
        StiListBoxControl = 43,
        StiListViewControl = 44,
        StiLookUpBoxControl = 45,
        StiNumericUpDownControl = 46,
        StiOverlayBand = 47,
        StiPage = 48,
        StiPageFooterBand = 49,
        StiPageHeaderBand = 50,
        StiPanel = 51,
        StiPanelControl = 52,
        StiPictureBoxControl = 53,
        StiRadioButtonControl = 54,
        StiRectanglePrimitive = 55,
        StiReportControl = 56,
        StiReportSummaryBand = 57,
        StiReportTitleBand = 58,
        StiRichText = 59,
        StiRichTextBoxControl = 60,
        StiRoundedRectanglePrimitive = 61,
        StiShape = 62,
        StiSubReport = 63,
        StiSystemText = 64,
        StiTable = 65,
        StiTableCell = 66,
        StiText = 67,
        StiTextBoxControl = 68,
        StiTextInCells = 69,
        StiTreeViewControl = 70,
        StiVerticalLinePrimitive = 71,
        StiWinControl = 72,
        StiUndefinedComponent = 73,
        StiZipCode = 74,
        StiElectronicSignature = 75,
        StiPdfDigitalSignature = 76,
        StiTableCellCheckBox = 77,
        StiTableCellImage = 78,
        StiTableCellRichText = 79,
        StiDataColumn = 80,
        StiCalcDataColumn = 81,
        StiBusinessObject = 82,
        StiDataSource = 83,
        StiDataStoreSource = 84,
        StiFileDataSource = 85,
        StiDataRelation = 86,
        StiVariable = 87,
        StiResource = 88,
        StiReport = 89,
        StiStyle = 90,
        StiCrossTabStyle = 91,
        StiChartStyle = 92,
        StiMapStyle = 93,
        StiTableStyle = 94,
        StiGaugeStyle = 95,
        StiIndicatorStyle = 96,
        StiDialogStyle = 97,
        StiWatermarkStyle = 98,
        StiDataParameter = 99,
        StiCrossField = 100,
        StiCrossTotal = 101,
        StiCrossCell = 102,
        StiCrossHeader = 103,
        StiCrossSummaryHeader = 104,
        StiStartPointPrimitive = 105,
        StiEndPointPrimitive = 106,
        StiEvent = 107,
        StiTableOfContents = 108,
        StiChartElement = 109,
        StiGaugeElement = 110,
        StiImageElement = 111,
        StiIndicatorElement = 112,
        StiRegionMapElement = 113,
        StiOnlineMapElement = 114,
        StiTableElement = 115,
        StiPivotTableElement = 116,
        StiProgressElement = 117,
        StiTextElement = 118,
        StiPanelElement = 119,
        StiShapeElement = 120,
        StiTreeViewElement = 121,
        StiTreeViewBoxElement = 122,
        StiListBoxElement = 123,
        StiComboBoxElement = 124,
        StiDatePickerElement = 125,
        StiDateRangeElement = 126,
        StiButtonElement = 127,
        StiCardsElement = 128,
        StiNumberBoxElement = 129,
        StiDashboard = 130,
        Sti3dOptions = 131,
        StiSeries = 132,
        StiBubbleSeries = 133,
        StiClusteredColumnSeries = 134,
        StiClusteredColumnSeries3D = 135,
        StiParetoSeries = 136,
        StiLineSeries = 137,
        StiLineSeries3D = 138,
        StiSteppedLineSeries = 139,
        StiSplineSeries = 140,
        StiAreaSeries = 141,
        StiBoxAndWhiskerSeries = 142,
        StiSteppedAreaSeries = 143,
        StiSplineAreaSeries = 144,
        StiRibbonSeries = 145,
        StiStackedColumnSeries = 146,
        StiStackedColumnSeries3D = 147,
        StiStackedLineSeries = 148,
        StiStackedSplineSeries = 149,
        StiStackedAreaSeries = 150,
        StiStackedSplineAreaSeries = 151,
        StiFullStackedColumnSeries = 152,
        StiFullStackedColumnSeries3D = 153,
        StiFullStackedLineSeries = 154,
        StiFullStackedAreaSeries = 155,
        StiFullStackedSplineSeries = 156,
        StiFullStackedSplineAreaSeries = 157,
        StiClusteredBarSeries = 158,
        StiStackedBarSeries = 159,
        StiTreemapSeries = 160,
        StiSunburstSeries = 161,
        StiWaterfallSeries = 162,
        StiPictorialSeries = 163,
        StiPictorialStackedSeries = 164,
        StiHistogramSeries = 165,
        StiFullStackedBarSeries = 166,
        StiPieSeries = 167,
        StiPie3dSeries = 168,
        StiDoughnutSeries = 169,
        StiGanttSeries = 170,
        StiScatterSeries = 171,
        StiScatterLineSeries = 172,
        StiScatterSplineSeries = 173,
        StiRadarAreaSeries = 174,
        StiRadarLineSeries = 175,
        StiRadarPointSeries = 176,
        StiRangeSeries = 177,
        StiSteppedRangeSeries = 178,
        StiFunnelSeries = 179,
        StiFunnelWeightedSlicesSeries = 180,
        StiRangeBarSeries = 181,
        StiSplineRangeSeries = 182,
        StiCandlestickSeries = 183,
        StiStockSeries = 184,
        StiChartTitle = 185,
        StiLineMarker = 186,
        StiMarker = 187,
        StiChartTable = 188,
        StiSeriesTopN = 189,
        StiSeriesInteraction = 190,
        StiTrendLine = 191,
        StiSeriesLabels = 192,
        StiNoneLabels = 193,
        StiInsideEndAxisLabels = 194,
        StiInsideBaseAxisLabels = 195,
        StiCenterTreemapLabels = 196,
        StiCenterAxisLabels = 197,
        StiOutsideEndAxisLabels = 198,
        StiOutsideBaseAxisLabels = 199,
        StiOutsideAxisLabels = 200,
        StiLeftAxisLabels = 201,
        StiValueAxisLabels = 202,
        StiRightAxisLabels = 203,
        StiCenterFunnelLabels = 204,
        StiCenterPictorialStackedLabelsCoreXF = 205,
        StiCenterPieLabels = 206,
        StiCenterPie3dLabels = 207,
        StiOutsidePieLabels = 208,
        StiTwoColumnsPieLabels = 209,
        StiOutsideLeftFunnelLabels = 210,
        StiOutsideLeftPictorialStackedLabels = 211,
        StiOutsideRightFunnelLabels = 212,
        StiOutsideRightPictorialStackedLabels = 213,
        StiLegend = 214,
        StiClusteredColumnArea = 215,
        StiClusteredColumnArea3D = 216,
        StiPieArea = 217,
        StiPie3dArea = 218,
        StiTreemapArea = 219,
        StiSunburstArea = 220,
        StiWaterfallArea = 221,
        StiHistorgamArea = 222,
        StiFunnelArea = 223,
        StiFunnelWeightedSlicesArea = 224,
        StiPictorialArea = 225,
        StiPictorialStackedArea = 226,
        StiRadarAreaArea = 227,
        StiRadarLineArea = 228,
        StiRadarPointArea = 229,
        StiRibbonArea = 230,
        StiStackedColumnArea = 231,
        StiGridLines = 232,
        StiInterlacing = 233,
        StiXAxis = 234,
        StiXAxis3D = 235,
        StiXTopAxis = 236,
        StiYAxis = 237,
        StiYAxis3D = 238,
        StiZAxis3D = 239,
        StiYRightAxis = 240,
        StiRadarGridLines = 241,
        StiXRadarAxis = 242,
        StiYRadarAxis = 243,
        StiDialogInfoItem = 244,
        StiStringDialogInfoItem = 245,
        StiGuidDialogInfoItem = 246,
        StiCharDialogInfoItem = 247,
        StiBoolDialogInfoItem = 248,
        StiImageDialogInfoItem = 249,
        StiDateTimeDialogInfoItem = 250,
        StiTimeSpanDialogInfoItem = 251,
        StiDoubleDialogInfoItem = 252,
        StiDecimalDialogInfoItem = 253,
        StiLongDialogInfoItem = 254,
        StiExpressionDialogInfoItem = 255,
        StiStringRangeDialogInfoItem = 256,
        StiGuidRangeDialogInfoItem = 257,
        StiByteArrayRangeDialogInfoItem = 258,
        StiCharRangeDialogInfoItem = 259,
        StiDateTimeRangeDialogInfoItem = 260,
        StiTimeSpanRangeDialogInfoItem = 261,
        StiDoubleRangeDialogInfoItem = 262,
        StiDecimalRangeDialogInfoItem = 263,
        StiLongRangeDialogInfoItem = 264,
        StiExpressionRangeDialogInfoItem = 265,
        OracleConnectionStringBuilder = 266,
        StiStrips = 267,
        StiConstantLines = 268,
        StiShapeTypeService = 269,
        StiDiagonalDownLineShapeType = 270,
        StiRoundedRectangleShapeType = 271,
        StiTriangleShapeType = 272,
        StiComplexArrowShapeType = 273,
        StiBentArrowShapeType = 274,
        StiChevronShapeType = 275,
        StiEqualShapeType = 276,
        StiFlowchartCollateShapeType = 277,
        StiFlowchartOffPageConnectorShapeType = 278,
        StiArrowShapeType = 279,
        StiOctagonShapeType = 280,
        StiAustraliaPost4StateBarCodeType = 281,
        StiCode11BarCodeType = 282,
        StiCode128aBarCodeType = 283,
        StiCode128bBarCodeType = 284,
        StiCode128cBarCodeType = 285,
        StiCode128AutoBarCodeType = 286,
        StiCode39BarCodeType = 287,
        StiCode39ExtBarCodeType = 288,
        StiCode93BarCodeType = 289,
        StiCode93ExtBarCodeType = 290,
        StiCodabarBarCodeType = 291,
        StiEAN128aBarCodeType = 292,
        StiEAN128bBarCodeType = 293,
        StiEAN128cBarCodeType = 294,
        StiEAN128AutoBarCodeType = 295,
        StiGS1_128BarCodeType = 296,
        StiGS1DataMatrixBarCodeType = 297,
        StiGS1QRCodeBarCodeType = 298,
        StiEAN13BarCodeType = 299,
        StiEAN8BarCodeType = 300,
        StiFIMBarCodeType = 301,
        StiIsbn10BarCodeType = 302,
        StiIsbn13BarCodeType = 303,
        StiITF14BarCodeType = 304,
        StiJan13BarCodeType = 305,
        StiJan8BarCodeType = 306,
        StiMsiBarCodeType = 307,
        StiPdf417BarCodeType = 308,
        StiPharmacodeBarCodeType = 309,
        StiPlesseyBarCodeType = 310,
        StiPostnetBarCodeType = 311,
        StiQRCodeBarCodeType = 312,
        StiRoyalMail4StateBarCodeType = 313,
        StiDutchKIXBarCodeType = 314,
        StiSSCC18BarCodeType = 315,
        StiUpcABarCodeType = 316,
        StiUpcEBarCodeType = 317,
        StiUpcSup2BarCodeType = 318,
        StiUpcSup5BarCodeType = 319,
        StiInterleaved2of5BarCodeType = 320,
        StiStandard2of5BarCodeType = 321,
        StiDataMatrixBarCodeType = 322,
        StiMaxicodeBarCodeType = 323,
        StiAztecBarCodeType = 324,
        StiIntelligentMail4StateBarCodeType = 325,
        StiDatabase = 326,
        StiFileDatabase = 327,
        StiCsvDatabase = 328,
        StiDBaseDatabase = 329,
        StiExcelDatabase = 330,
        StiJsonDatabase = 331,
        StiXmlDatabase = 332,
        StiSqlDatabase = 333,
        StiGauge = 334,
        StiMap = 335,
        StiFullStackedColumnArea = 336,
        StiClusteredBarArea = 337,
        StiStackedBarArea = 338,
        StiFullStackedBarArea = 339,
        StiDoughnutArea = 340,
        StiLineArea = 341,
        StiParetoArea = 342,
        StiBoxAndWhiskerArea = 343,
        StiSteppedLineArea = 344,
        StiStackedLineArea = 345,
        StiFullStackedLineArea = 346,
        StiSplineArea = 347,
        StiStackedSplineArea = 348,
        StiFullStackedSplineArea = 349,
        StiAreaArea = 350,
        StiSteppedAreaArea = 351,
        StiStackedAreaArea = 352,
        StiFullStackedAreaArea = 353,
        StiSplineAreaArea = 354,
        StiStackedSplineAreaArea = 355,
        StiFullStackedSplineAreaArea = 356,
        StiGanttArea = 357,
        StiScatterArea = 358,
        StiBubbleArea = 359,
        StiRangeArea = 360,
        StiSteppedRangeArea = 361,
        StiRangeBarArea = 362,
        StiSplineRangeArea = 363,
        StiCandlestickArea = 364,
        StiStockArea = 365,
        StiInsideEndPieLabels = 366,
        StiTrendLineNone = 367,
        StiTrendLineLinear = 368,
        StiTrendLineExponential = 369,
        StiTrendLineLogarithmic = 370,
        StiDB2Database = 371,
        StiDotConnectUniversalDatabase = 372,
        StiFirebirdDatabase = 373,
        StiInformixDatabase = 374,
        StiMongoDbDatabase = 375,
        StiAzureTableStorageDatabase = 376,
        StiMySqlDatabase = 377,
        StiMSAccessDatabase = 378,
        StiOdbcDatabase = 379,
        StiOleDbDatabase = 380,
        StiOracleDatabase = 381,
        StiPostgreSQLDatabase = 382,
        StiSQLiteDatabase = 383,
        StiSqlCeDatabase = 384,
        StiSybaseDatabase = 385,
        StiTeradataDatabase = 386,
        StiVistaDBDatabase = 387,
        StiODataDatabase = 388,
        StiGraphQLDatabase = 389,
        StiDataTableSource = 390,
        StiDataViewSource = 391,
        StiUndefinedDataSource = 392,
        StiCsvSource = 393,
        StiDBaseSource = 394,
        StiBusinessObjectSource = 395,
        StiCrossTabDataSource = 396,
        StiEnumerableSource = 397,
        StiUserSource = 398,
        StiVirtualSource = 399,
        StiDataTransformation = 400,
        StiOracleODPSource = 401,
        StiFirebirdSource = 402,
        StiInformixSource = 403,
        StiMongoDbSource = 404,
        StiCDataConnectCloudSource = 405,
        StiAzureTableStorageSource = 406,
        StiAzureBlobStorageSource = 407,
        StiMSAccessSource = 408,
        StiMySqlSource = 409,
        StiDataWorldSource = 410,
        StiQuickBooksSource = 411,
        StiOdbcSource = 412,
        StiOleDbSource = 413,
        StiOracleSource = 414,
        StiPostgreSQLSource = 415,
        StiSqlCeSource = 416,
        StiSQLiteSource = 417,
        StiSqlSource = 418,
        StiNoSqlSource = 419,
        StiSybaseSource = 420,
        StiTeradataSource = 421,
        StiVistaDBSource = 422,
        StiDB2Source = 423,
        StiGraphQLSource = 424,
        StiDiagonalUpLineShapeType = 425,
        StiHorizontalLineShapeType = 426,
        StiLeftAndRightLineShapeType = 427,
        StiOvalShapeType = 428,
        StiRectangleShapeType = 429,
        StiTopAndBottomLineShapeType = 430,
        StiVerticalLineShapeType = 431,
        StiDivisionShapeType = 432,
        StiFlowchartCardShapeType = 433,
        StiFlowchartDecisionShapeType = 434,
        StiFlowchartManualInputShapeType = 435,
        StiFlowchartSortShapeType = 436,
        StiFrameShapeType = 437,
        StiMinusShapeType = 438,
        StiMultiplyShapeType = 439,
        StiParallelogramShapeType = 440,
        StiPlusShapeType = 441,
        StiRegularPentagonShapeType = 442,
        StiTrapezoidShapeType = 443,
        StiSnipSameSideCornerRectangleShapeType = 444,
        StiSnipDiagonalSideCornerRectangleShapeType = 445,
        StiFlowchartPreparationShapeType = 446,
        StiRadialScale = 447,
        StiLinearScale = 448,
        StiLinearBar = 449,
        StiRadialBar = 450,
        StiNeedle = 451,
        StiRadialMarker = 452,
        StiScaleRangeList = 453,
        StiRadialRange = 454,
        StiStateIndicator = 455,
        StiStateIndicatorFilter = 456,
        StiRadialRangeList = 457,
        StiLinearRangeList = 458,
        StiLinearRange = 459,
        StiLinearTickMarkMajor = 460,
        StiLinearTickMarkMinor = 461,
        StiLinearTickMarkCustomValue = 462,
        StiLinearTickLabelMajor = 463,
        StiLinearTickLabelMinor = 464,
        StiLinearTickLabelCustom = 465,
        StiLinearTickLabelCustomValue = 466,
        StiRadialTickMarkMajor = 467,
        StiRadialTickMarkMinor = 468,
        StiRadialTickMarkCustom = 469,
        StiRadialTickMarkCustomValue = 470,
        StiRadialTickLabelMajor = 471,
        StiRadialTickLabelMinor = 472,
        StiRadialTickLabelCustom = 473,
        StiRadialTickLabelCustomValue = 474,
        StiLinearMarker = 475,
        StiLinearTickMarkCustom = 476,
        StiLinearIndicatorRangeInfo = 477,
        StiRadialIndicatorRangeInfo = 478,
        StiBlueDashboardControlStyle = 479,
        StiBlueDashboardIndicatorStyle = 480,
        StiBlueDashboardPageStyle = 481,
        StiBlueDashboardPivotStyle = 482,
        StiBlueDashboardProgressStyle = 483,
        StiBlueDashboardTableStyle = 484,
        StiBlueDashboardCardsStyle = 485,
        StiOrangeDashboardControlStyle = 486,
        StiOrangeDashboardIndicatorStyle = 487,
        StiOrangeDashboardPageStyle = 488,
        StiOrangeDashboardPivotStyle = 489,
        StiOrangeDashboardProgressStyle = 490,
        StiOrangeDashboardTableStyle = 491,
        StiOrangeDashboardCardsStyle = 492,
        StiGreenDashboardControlStyle = 493,
        StiGreenDashboardIndicatorStyle = 494,
        StiGreenDashboardPageStyle = 495,
        StiGreenDashboardProgressStyle = 496,
        StiGreenDashboardPivotStyle = 497,
        StiGreenDashboardTableStyle = 498,
        StiGreenDashboardCardsStyle = 499,
        StiTurquoiseDashboardControlStyle = 500,
        StiTurquoiseDashboardIndicatorStyle = 501,
        StiTurquoiseDashboardPageStyle = 502,
        StiTurquoiseDashboardProgressStyle = 503,
        StiTurquoiseDashboardPivotStyle = 504,
        StiTurquoiseDashboardTableStyle = 505,
        StiTurquoiseDashboardCardsStyle = 506,
        StiSlateGrayDashboardControlStyle = 507,
        StiSlateGrayDashboardIndicatorStyle = 508,
        StiSlateGrayDashboardPageStyle = 509,
        StiSlateGrayDashboardProgressStyle = 510,
        StiSlateGrayDashboardPivotStyle = 511,
        StiSlateGrayDashboardTableStyle = 512,
        StiSlateGrayDashboardCardsStyle = 513,
        StiDarkBlueDashboardControlStyle = 514,
        StiDarkBlueDashboardIndicatorStyle = 515,
        StiDarkBlueDashboardPageStyle = 516,
        StiDarkBlueDashboardProgressStyle = 517,
        StiDarkBlueDashboardPivotStyle = 518,
        StiDarkBlueDashboardTableStyle = 519,
        StiDarkBlueDashboardCardsStyle = 520,
        StiYellowDashboardPageStyle = 521,
        StiDarkGrayDashboardControlStyle = 522,
        StiDarkGrayDashboardIndicatorStyle = 523,
        StiDarkGrayDashboardPageStyle = 524,
        StiDarkGrayDashboardProgressStyle = 525,
        StiDarkGrayDashboardPivotStyle = 526,
        StiDarkGrayDashboardTableStyle = 527,
        StiDarkGrayDashboardCardsStyle = 528,
        StiDarkTurquoiseDashboardControlStyle = 529,
        StiDarkTurquoiseDashboardIndicatorStyle = 530,
        StiDarkTurquoiseDashboardPageStyle = 531,
        StiDarkTurquoiseDashboardProgressStyle = 532,
        StiDarkTurquoiseDashboardPivotStyle = 533,
        StiDarkTurquoiseDashboardTableStyle = 534,
        StiDarkTurquoiseDashboardCardsStyle = 535,
        StiSilverDashboardControlStyle = 536,
        StiSilverDashboardIndicatorStyle = 537,
        StiSilverDashboardPageStyle = 538,
        StiSilverDashboardPivotStyle = 539,
        StiSilverDashboardProgressStyle = 540,
        StiSilverDashboardTableStyle = 541,
        StiSilverDashboardCardsStyle = 542,
        StiAliceBlueDashboardControlStyle = 543,
        StiAliceBlueDashboardIndicatorStyle = 544,
        StiAliceBlueDashboardPageStyle = 545,
        StiAliceBlueDashboardPivotStyle = 546,
        StiAliceBlueDashboardProgressStyle = 547,
        StiAliceBlueDashboardTableStyle = 548,
        StiAliceBlueDashboardCardsStyle = 549,
        StiDarkGreenDashboardControlStyle = 550,
        StiDarkGreenDashboardIndicatorStyle = 551,
        StiDarkGreenDashboardPageStyle = 552,
        StiDarkGreenDashboardProgressStyle = 553,
        StiDarkGreenDashboardPivotStyle = 554,
        StiDarkGreenDashboardTableStyle = 555,
        StiDarkGreenDashboardCardsStyle = 556,
        StiSiennaDashboardControlStyle = 557,
        StiSiennaDashboardIndicatorStyle = 558,
        StiSiennaDashboardPageStyle = 559,
        StiSiennaDashboardPivotStyle = 560,
        StiSiennaDashboardProgressStyle = 561,
        StiSiennaDashboardTableStyle = 562,
        StiSiennaDashboardCardsStyle = 563,
        StiCustomDashboardControlStyle = 564,
        StiCustomDashboardPivotStyle = 565,
        StiCustomDashboardIndicatorStyle = 566,
        StiCustomDashboardProgressStyle = 567,
        StiCustomDashboardTableStyle = 568,
        StiCustomDashboardCardsStyle = 569,
        StiDataWorldDatabase = 570,
        StiQuickBooksDatabase = 571,
        StiCosmosDbDatabase = 572,
        StiSybaseAdsDatabase = 573,
        StiBigQueryDatabase = 574,
        StiGoogleAnalyticsDatabase = 575,
        StiAzureBlobStorageDatabase = 576,
        StiCDataConnectCloudDatabase = 577,
        StiFirebaseDatabase = 578,
        StiGoogleSheetsDatabase = 579,
        StiGisDatabase = 580,
        StiCosmosDbSource = 581,
        StiSybaseAdsSource = 582
    }
    enum StiRenderedWith {
        Unknown = 0,
        Net = 1,
        Wpf = 2,
        Silverlight = 3,
        WinRT = 4,
        Flex = 5,
        Java = 6,
        JS = 7
    }
    enum StiRankOrder {
        Asc = 0,
        Desc = 1
    }
    enum StiXmlType {
        AdoNetXml = 0,
        Xml = 1
    }
    enum StiStyleElements {
        Font = 1,
        Border = 2,
        Brush = 4,
        TextBrush = 8,
        TextOptions = 16,
        HorAlignment = 32,
        VertAlignment = 64,
        All = 127
    }
    enum StiDateRangeKind {
        CurrentMonth = 0,
        CurrentQuarter = 1,
        CurrentWeek = 2,
        CurrentYear = 3,
        NextMonth = 4,
        NextQuarter = 5,
        NextWeek = 6,
        NextYear = 7,
        PreviousMonth = 8,
        PreviousQuarter = 9,
        PreviousWeek = 10,
        PreviousYear = 11,
        FirstQuarter = 12,
        SecondQuarter = 13,
        ThirdQuarter = 14,
        FourthQuarter = 15,
        MonthToDate = 16,
        QuarterToDate = 17,
        WeekToDate = 18,
        YearToDate = 19,
        Today = 20,
        Tomorrow = 21,
        Yesterday = 22,
        Last7Days = 23,
        Last14Days = 24,
        Last30Days = 25
    }
    enum StiDashboardViewerSettings {
        None = 0,
        ShowToolBar = 1,
        ShowRefreshButton = 2,
        ShowOpenButton = 4,
        ShowFullScreenButton = 8,
        ShowMenuButton = 16,
        ShowEditButton = 32,
        ShowReportSnapshots = 64,
        ShowExports = 128,
        ShowResetAllFilters = 256,
        ShowParametersButton = 512,
        All = 1023
    }
    enum StiElementMeterAction {
        None = 0,
        Rename = 1,
        Delete = 2,
        ClearAll = 3
    }
    enum StiDataMode {
        UsingDataFields = 0,
        ManuallyEnteringData = 1
    }
    enum StiDesignerStartScreen {
        Welcome = 0,
        BlankReport = 1,
        BlankDashboard = 2,
        NotAssigned = 3
    }
    enum StiHtmlPreviewMode {
        Div = 0,
        Table = 1
    }
}
export namespace Stimulsoft.Report.Dictionary {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import CollectionBase = Stimulsoft.System.Collections.CollectionBase;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IComparer = Stimulsoft.System.Collections.IComparer;
    import Hashtable = Stimulsoft.System.Collections.Hashtable;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiJson = Stimulsoft.Base.StiJson;
    class StiBusinessObjectsCollection extends CollectionBase<StiBusinessObject> implements IStiJsonReportObject, ICloneable, IComparer<any> {
        implements(): any[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        loadFromXml(xmlNode: XmlNode): void;
        private directionFactor;
        compare(x: any, y: any): number;
        protected onSet(index: number, oldValue: any, newValue: any): void;
        protected onInsert(index: number, value: any): void;
        remove(source: StiBusinessObject): void;
        _cachedBusinessObjects: Hashtable;
        get cachedBusinessObjects(): Hashtable;
        getByName(name: string): StiBusinessObject;
        setByName(name: string, value: StiBusinessObject): void;
        clone(): any;
        sort(order?: StiSortOrder, sortColumns?: boolean): void;
        connect(): void;
        disconnect(): void;
        dictionary: StiDictionary;
        parentBusinessObject: StiBusinessObject;
        constructor(dictionary: StiDictionary, parentBusinessObject: StiBusinessObject);
    }
}
export namespace Stimulsoft.Report.Dictionary {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IAsIs = Stimulsoft.System.IAsIs;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import StiBusinessObjectsCollection = Stimulsoft.Report.Dictionary.StiBusinessObjectsCollection;
    import StiDataBand = Stimulsoft.Report.Components.StiDataBand;
    import Hashtable = Stimulsoft.System.Collections.Hashtable;
    import IEnumerator = Stimulsoft.System.Collections.IEnumerator;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiJson = Stimulsoft.Base.StiJson;
    import ICloneable = Stimulsoft.System.ICloneable;
    class StiBusinessObject implements ICloneable, IStiStateSaveRestore, IStiEnumerator, IStiInherited, IStiJsonReportObject, IAsIs {
        implements(): any[];
        is<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): this is T;
        is2<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): boolean;
        as<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): T;
        protected _hash: StiMeta[];
        meta(): StiMeta[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        loadFromXml(xmlNode: XmlNode): void;
        private _states;
        protected get states(): StiStatesManager;
        saveState(stateName: string): void;
        restoreState(stateName: string): void;
        clearAllStates(): void;
        inherited: boolean;
        protected positionValue: number;
        get position(): number;
        set position(value: number);
        countFiltered: number;
        get count(): number;
        protected isBofValue: boolean;
        get isBof(): boolean;
        set isBof(value: boolean);
        protected isEofValue: boolean;
        get isEof(): boolean;
        set isEof(value: boolean);
        isEmpty: boolean;
        private enumeratorReset;
        firstAsync(): Promise<void>;
        first(): void;
        prior(): void;
        nextAsync(): Promise<void>;
        next(): void;
        last(): void;
        clone(): StiBusinessObject;
        currentObject: any;
        get current(): any;
        private get report();
        businessObjects: StiBusinessObjectsCollection;
        columns: StiDataColumnsCollection;
        guid: string;
        category: string;
        name: string;
        alias: string;
        private _businessObjectValue;
        get businessObjectValue(): any;
        set businessObjectValue(value: any);
        private _dictionary;
        get dictionary(): StiDictionary;
        set dictionary(value: StiDictionary);
        parentBusinessObject: StiBusinessObject;
        ownerBand: StiDataBand;
        key: string;
        static fieldsIgnoreList: Hashtable<any, any>;
        getLevel(): number;
        private checkEnumerator;
        setPrevValue(): void;
        setNextValue(): void;
        restoreCurrentValue(): void;
        getTopParentBusinessObject(): StiBusinessObject;
        createEnumerator(): void;
        private sortData;
        private sortDataByGroups;
        filterData(): void;
        private destroyEnumerator;
        setDetails(): void;
        private updateChilds;
        private getBusinessObjectDataFromParent;
        getColumnIndex(columnName: string): number;
        getBusinessObjectData(isColumnsRetrieve?: boolean): any;
        getFullName(): string;
        getCorrectFullName(): string;
        toString(): string;
        connect(): void;
        disconnect(): void;
        private isEnumeratorCreated;
        private specPrevValue;
        private specNextValue;
        private specNextValueRead;
        private specMoveNextResult;
        private specStoredCurrentValue;
        enumerator: IEnumerator;
        protected rowToLevel: Hashtable;
        specSetPrevValue: boolean;
        specSetNextValue: boolean;
        specFilterData: boolean;
        specSortGroup: boolean;
        specTotalsCalculation: boolean;
        previousResetException: boolean;
        getByName(name: string): any;
        constructor(category?: string, name?: string, alias?: string, guid?: string, key?: string);
    }
}
export namespace Stimulsoft.Report.Events {
    import EventHandler = Stimulsoft.System.EventHandler;
    import EventArgs = Stimulsoft.System.EventArgs;
    let StiValueEventHandler: EventHandler;
    class StiValueEventArgs extends EventArgs {
        value: any;
        displayValue: string;
        constructor(value?: any);
    }
}
export namespace Stimulsoft.Report.Dictionary {
    import Type = Stimulsoft.System.Type;
    import StiBusinessObjectsCollection = Stimulsoft.Report.Dictionary.StiBusinessObjectsCollection;
    class StiBusinessObjectHelper {
        static getElementType(arrayType: Type): Type;
        private static getElement;
        static getAlias(valueProp: string): string;
        static isAllowUseProperty(valueProp: string): boolean;
        private static getType;
        private static getDataColumn;
        private static getDataColumn2;
        private static getColumnsFromObject;
        private static getColumnsFromClass;
        static getColumnsFromData(data: any, includeChildDataSources?: boolean): StiDataColumnsCollection;
        static isDataColumn(type: Type): boolean;
        static getBusinessObjectFromGuid(report: StiReport, guid: string): StiBusinessObject;
        static getBusinessObjectsFromReport(data: StiBusinessObjectsCollection | StiReport): StiBusinessObject[];
    }
}
export namespace Stimulsoft.Report.Events {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import ICloneable = Stimulsoft.System.ICloneable;
    import StiJson = Stimulsoft.Base.StiJson;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    class StiEvent implements ICloneable {
        private static ImplementsStiEvent;
        implements(): any[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        loadFromXml(xmlNode: XmlNode): void;
        clone(): any;
        protected get propertyName(): string;
        private _script;
        get script(): string;
        set script(value: string);
        private parent;
        set(parent: Stimulsoft.Report.Components.StiComponent, value: string): void;
        constructor(script?: string | Stimulsoft.Report.Components.StiComponent);
    }
}
export namespace Stimulsoft.Report.Events {
    class StiGetCollapsedEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Events {
    class StiEndRenderEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Events {
    class StiRenderingEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Events {
    class StiBeginRenderEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Helpers {
    import EventArgs = Stimulsoft.System.EventArgs;
    import StiEvent = Stimulsoft.Report.Events.StiEvent;
    class StiBlocklyHelper {
        static invokeBlockly(report: StiReport, sender: any, stiEvent: StiEvent, e?: EventArgs): void;
        static invokeBlocklyAsync(report: StiReport, sender: any, stiEvent: StiEvent, e?: EventArgs): Promise<void>;
    }
}
export namespace Stimulsoft.Report.Expressions {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IAsIs = Stimulsoft.System.IAsIs;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiJson = Stimulsoft.Base.StiJson;
    class StiExpression implements ICloneable, IStiJsonReportObject, IAsIs {
        implements(): any[];
        is<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): this is T;
        is2<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): boolean;
        as<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): T;
        protected _hash: StiMeta[];
        meta(): StiMeta[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        loadFromXml(xmlNode: XmlNode): void;
        private val;
        get value(): string;
        set value(value: string);
        protected getValueProp(): string;
        protected setValueProp(value: string): void;
        parentComponent: any;
        fullConvert: boolean;
        get applyFormat(): boolean;
        genAddEvent: boolean;
        toString(): string;
        clone(): any;
        constructor(value?: string);
    }
}
export namespace Stimulsoft.Report.Components {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import CollectionBase = Stimulsoft.System.Collections.CollectionBase;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiJson = Stimulsoft.Base.StiJson;
    class StiConditionsCollection extends CollectionBase<StiBaseCondition> implements ICloneable, IStiJsonReportObject {
        implements(): any[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        private isBorderSides;
        private convertIconSetItemFromString;
        loadFromXml(xmlNode: XmlNode): void;
        clone(): StiConditionsCollection;
        addRange(conditions: StiConditionsCollection, addOnlyNotEqual?: boolean): void;
    }
}
export namespace Stimulsoft.Report {
    import StiService = Stimulsoft.Base.Services.StiService;
    class StiBase extends StiService implements IStiName {
        memberwiseClone(baseClone?: boolean): StiBase;
        private _name;
        get name(): string;
        set name(value: string);
        getName(): string;
        setName(value: string): void;
        implements(): any[];
        get localizedName(): string;
        get localizedCategory(): string;
    }
}
export namespace Stimulsoft.Report.Events {
    class StiGetToolTipEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Events {
    class StiGetHyperlinkEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Events {
    class StiGetTagEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Events {
    class StiGetBookmarkEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Events {
    class StiBeforePrintEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Events {
    class StiAfterPrintEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Events {
    class StiGetDrillDownReportEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Events {
    class StiClickEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Events {
    class StiDoubleClickEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Events {
    class StiMouseEnterEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Events {
    class StiMouseLeaveEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Events {
    class StiGetPointerEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Components {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import StiGetPointerEvent = Stimulsoft.Report.Events.StiGetPointerEvent;
    import Font = Stimulsoft.System.Drawing.Font;
    import IStiGetFonts = Stimulsoft.Base.IStiGetFonts;
    import StiPaintEventArgs = Stimulsoft.Report.Events.StiPaintEventArgs;
    import StiGetDrillDownReportEventArgs = Stimulsoft.Report.Events.StiGetDrillDownReportEventArgs;
    import StiGetToolTipEvent = Stimulsoft.Report.Events.StiGetToolTipEvent;
    import StiGetHyperlinkEvent = Stimulsoft.Report.Events.StiGetHyperlinkEvent;
    import StiGetTagEvent = Stimulsoft.Report.Events.StiGetTagEvent;
    import StiGetBookmarkEvent = Stimulsoft.Report.Events.StiGetBookmarkEvent;
    import StiBeforePrintEvent = Stimulsoft.Report.Events.StiBeforePrintEvent;
    import StiAfterPrintEvent = Stimulsoft.Report.Events.StiAfterPrintEvent;
    import StiGetDrillDownReportEvent = Stimulsoft.Report.Events.StiGetDrillDownReportEvent;
    import StiClickEvent = Stimulsoft.Report.Events.StiClickEvent;
    import StiDoubleClickEvent = Stimulsoft.Report.Events.StiDoubleClickEvent;
    import StiMouseEnterEvent = Stimulsoft.Report.Events.StiMouseEnterEvent;
    import StiMouseLeaveEvent = Stimulsoft.Report.Events.StiMouseLeaveEvent;
    import EventArgs = Stimulsoft.System.EventArgs;
    import StiValueEventArgs = Stimulsoft.Report.Events.StiValueEventArgs;
    import StiBase = Stimulsoft.Report.StiBase;
    import StiUnit = Stimulsoft.Report.Units.StiUnit;
    import StiConditionsCollection = Stimulsoft.Report.Components.StiConditionsCollection;
    import Hashtable = Stimulsoft.System.Collections.Hashtable;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    import SizeD = Stimulsoft.System.Drawing.Size;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import PointD = Stimulsoft.System.Drawing.Point;
    import StiBaseStyle = Stimulsoft.Report.Styles.StiBaseStyle;
    import IStiReportComponent = Stimulsoft.Base.IStiReportComponent;
    import IStiApp = Stimulsoft.Base.IStiApp;
    import IStiReport = Stimulsoft.Base.IStiReport;
    import IStiAppExpressionCollection = Stimulsoft.Base.IStiAppExpressionCollection;
    import StiAppExpressionCollection = Stimulsoft.Base.StiAppExpressionCollection;
    class StiComponent extends StiBase implements IStiComponentGuid, IStiCanGrow, IStiCanShrink, IStiUnitConvert, IStiShift, IStiGrowToHeight, IStiAnchor, IStiConditions, IStiPrintOn, IStiInherited, IStiStateSaveRestore, IStiJsonReportObject, IStiReportComponent, IStiComponent, IStiGetFonts, IStiAppExpressionCollection {
        private static ImplementsStiComponent;
        implements(): any[];
        meta(): StiMeta[];
        protected loadRectangleDFromXml(text: string): RectangleD;
        get componentId(): StiComponentId;
        infographicsDisplayRectangle: RectangleD;
        private _isSelected;
        get isSelected(): boolean;
        set isSelected(value: boolean);
        select(): void;
        invert(): void;
        reset(): void;
        getApp(): IStiApp;
        getKey(): string;
        setKey(key: string): void;
        getReport(): IStiReport;
        saveState(stateName: string): void;
        restoreState(stateName: string): void;
        private _states;
        get states(): StiStatesManager;
        getStates(): StiStatesManager;
        clearAllStates(): void;
        get shift(): boolean;
        set shift(value: boolean);
        getShift(): boolean;
        private _shiftMode;
        get shiftMode(): StiShiftMode;
        set shiftMode(value: StiShiftMode);
        guid: string;
        newGuid(): void;
        printOn: StiPrintOnType;
        clone(cloneProperties?: boolean, cloneComponents?: boolean, base?: boolean): any;
        memberwiseClone(base?: boolean): StiComponent;
        convert(oldUnit: StiUnit, newUnit: StiUnit, isReportSnapshot?: boolean): void;
        private _canShrink;
        get canShrink(): boolean;
        set canShrink(value: boolean);
        getCanShrink(): boolean;
        private _canGrow;
        get canGrow(): boolean;
        set canGrow(value: boolean);
        getCanGrow(): boolean;
        setCanGrow(value: boolean): void;
        private _growToHeight;
        get growToHeight(): boolean;
        set growToHeight(value: boolean);
        getGrowToHeight(): boolean;
        private _anchor;
        get anchor(): StiAnchorMode;
        set anchor(value: StiAnchorMode);
        private _conditions;
        get conditions(): StiConditionsCollection;
        set conditions(value: StiConditionsCollection);
        getConditions(): StiConditionsCollection;
        setConditions(value: StiConditionsCollection): void;
        private static propertyInherited;
        get inherited(): boolean;
        set inherited(value: boolean);
        getActualSize(): SizeD;
        get report(): StiReport;
        set report(value: StiReport);
        private _interaction;
        get interaction(): StiInteraction;
        set interaction(value: StiInteraction);
        getFonts(): Font[];
        expressions: StiAppExpressionCollection;
        private shouldSerializeExpressions;
        doPointer(createNewGuid?: boolean): void;
        private doGetPointer;
        doBookmark(): boolean;
        private doGetBookmark;
        get printable(): boolean;
        set printable(value: boolean);
        isRendered: boolean;
        private static propertyRenderedCount;
        get renderedCount(): number;
        set renderedCount(value: number);
        allowPrintOn(): boolean;
        get isEnabled(): boolean;
        getIsEnabled(): Promise<boolean>;
        prepare(): void;
        unPrepare(): void;
        setReportVariables(): void;
        internalRenderAsync(): Promise<StiComponent>;
        internalRender(): StiComponent;
        renderAsync(): Promise<StiComponent>;
        render(): StiComponent;
        paint(g: Stimulsoft.System.Drawing.Graphics): void;
        get dockStyle(): StiDockStyle;
        set dockStyle(value: StiDockStyle);
        getDockStyle(): StiDockStyle;
        get isAutomaticDock(): boolean;
        getDockRegion(parent: StiComponent, useColumns?: boolean): RectangleD;
        dockToContainer(): void;
        dockToContainer2(rect: RectangleD): RectangleD;
        private checkWidth;
        private checkHeight;
        private disableCheckWidthHeight;
        private static propertyMinSize;
        get minSize(): SizeD;
        set minSize(value: SizeD);
        getMinSize(): SizeD;
        setMinSize(value: SizeD): void;
        private static propertyMaxSize;
        get maxSize(): SizeD;
        set maxSize(value: SizeD);
        getMaxSize(): SizeD;
        setMaxSize(value: SizeD): void;
        private _left;
        get left(): number;
        set left(value: number);
        getLeft(): number;
        setLeft(value: number): void;
        private _top;
        get top(): number;
        set top(value: number);
        getTop(): number;
        setTop(value: number): void;
        private _width;
        get width(): number;
        set width(value: number);
        getWidth(): number;
        setWidth(value: number): void;
        private _height;
        get height(): number;
        set height(value: number);
        getHeight(): number;
        setHeight(value: number): void;
        get right(): number;
        get bottom(): number;
        getBottom(): number;
        get clientRectangle(): RectangleD;
        set clientRectangle(value: RectangleD);
        protected setClientRectangle(value: RectangleD): void;
        get displayRectangle(): RectangleD;
        set displayRectangle(value: RectangleD);
        getDisplayRectangle(): RectangleD;
        setDisplayRectangle(value: RectangleD): void;
        setDirectDisplayRectangle(rect: RectangleD): void;
        get selectRectangle(): RectangleD;
        set selectRectangle(value: RectangleD);
        defaultClientRectangle: RectangleD;
        parentBookmark: StiBookmark;
        currentBookmark: StiBookmark;
        parentPointer: StiBookmark;
        currentPointer: StiBookmark;
        invokeEvents(): void;
        get isGetToolTipHandlerEmpty(): boolean;
        private static eventGetToolTip;
        protected onGetToolTip(): void;
        invokeGetToolTip(sender: any, e: StiValueEventArgs): void;
        get getToolTipEvent(): StiGetToolTipEvent;
        set getToolTipEvent(value: StiGetToolTipEvent);
        get isGetHyperlinkHandlerEmpty(): boolean;
        private static eventGetHyperlink;
        protected onGetHyperlink(e: StiValueEventArgs): void;
        invokeGetHyperlink(sender: any, e: StiValueEventArgs): void;
        get getHyperlinkEvent(): StiGetHyperlinkEvent;
        set getHyperlinkEvent(value: StiGetHyperlinkEvent);
        get isGetTagHandlerEmpty(): boolean;
        private static eventGetTag;
        protected onGetTag(e: StiValueEventArgs): void;
        invokeGetTag(sender: any, e: StiValueEventArgs): void;
        copyGetTagEventTo(otherComp: StiComponent): void;
        get getTagEvent(): StiGetTagEvent;
        set getTagEvent(value: StiGetTagEvent);
        get isGetPointerHandlerEmpty(): boolean;
        private static eventGetPointer;
        protected onGetPointer(e: StiValueEventArgs): void;
        invokeGetPointer(sender: any, e: StiValueEventArgs): void;
        get getPointerEvent(): StiGetPointerEvent;
        set getPointerEvent(value: StiGetPointerEvent);
        get isGetBookmarkHandlerEmpty(): boolean;
        private static eventGetBookmark;
        protected onGetBookmark(): void;
        invokeGetBookmark(sender: any, e: EventArgs): void;
        copyGetBookmarkEventTo(otherComp: StiComponent): void;
        get getBookmarkEvent(): StiGetBookmarkEvent;
        set getBookmarkEvent(value: StiGetBookmarkEvent);
        private static eventBeforePrint;
        protected onBeforePrint(e: EventArgs): void;
        invokeBeforePrint(sender: StiComponent, e: EventArgs): void;
        applyConditions(sender: StiComponent, conditions: any[], e: EventArgs): void;
        get beforePrintEvent(): StiBeforePrintEvent;
        set beforePrintEvent(value: StiBeforePrintEvent);
        private static eventAfterPrint;
        protected onAfterPrint(e: EventArgs): void;
        invokeAfterPrint(sender: any, e: EventArgs): void;
        get afterPrintEvent(): StiAfterPrintEvent;
        set afterPrintEvent(value: StiAfterPrintEvent);
        private static eventGetDrillDownReport;
        protected onGetDrillDownReport(e: StiGetDrillDownReportEventArgs): void;
        invokeGetDrillDownReport(sender: any, e: StiGetDrillDownReportEventArgs): void;
        get getDrillDownReportEvent(): StiGetDrillDownReportEvent;
        set getDrillDownReportEvent(value: StiGetDrillDownReportEvent);
        get isClickHandlerEmpty(): boolean;
        private static eventClick;
        onClick: Function;
        invokeClick(sender: any, e: EventArgs): void;
        copyClickEventTo(otherComp: StiComponent): void;
        get clickEvent(): StiClickEvent;
        set clickEvent(value: StiClickEvent);
        get isDoubleClickHandlerEmpty(): boolean;
        private static eventDoubleClick;
        onDoubleClick: Function;
        invokeDoubleClick(sender: any, e: EventArgs): void;
        copyDoubleClickEventTo(otherComp: StiComponent): void;
        get doubleClickEvent(): StiDoubleClickEvent;
        set doubleClickEvent(value: StiDoubleClickEvent);
        get isMouseEnterHandlerEmpty(): boolean;
        private static eventMouseEnter;
        onMouseEnter: Function;
        invokeMouseEnter(sender: any, e: EventArgs): void;
        copyMouseEnterEventTo(otherComp: StiComponent): void;
        get mouseEnterEvent(): StiMouseEnterEvent;
        set mouseEnterEvent(value: StiMouseEnterEvent);
        get isMouseLeaveHandlerEmpty(): boolean;
        private static eventMouseLeave;
        onMouseLeave: Function;
        invokeMouseLeave(sender: any, e: EventArgs): void;
        copyMouseLeaveEventTo(otherComp: StiComponent): void;
        get mouseLeaveEvent(): StiMouseLeaveEvent;
        set mouseLeaveEvent(value: StiMouseLeaveEvent);
        private static eventPainting;
        protected onPainting(e: StiPaintEventArgs): void;
        invokePainting(sender: StiComponent, e: StiPaintEventArgs): void;
        private static eventPainted;
        protected onPainted(e: StiPaintEventArgs): void;
        invokePainted(sender: StiComponent, e: StiPaintEventArgs): void;
        pointerValue: any;
        get pointer(): string;
        set pointer(value: string);
        get bookmarkValue(): any;
        set bookmarkValue(value: any);
        get bookmark(): string;
        set bookmark(value: string);
        get toolTipValue(): any;
        set toolTipValue(value: any);
        get toolTip(): string;
        set toolTip(value: string);
        get hyperlinkValue(): any;
        set hyperlinkValue(value: any);
        get hyperlink(): string;
        set hyperlink(value: string);
        get tagValue(): any;
        set tagValue(value: any);
        get tag(): string;
        set tag(value: string);
        alias: string;
        private _events;
        protected get events(): Hashtable;
        protected static propertyRestrictions: string;
        get restrictions(): StiRestrictions;
        set restrictions(value: StiRestrictions);
        getRestrictions(): StiRestrictions;
        setRestrictions(value: StiRestrictions): void;
        get ignoreNamingRule(): boolean;
        set ignoreNamingRule(value: boolean);
        setName(value: string): void;
        protected static propertyPlaceOnToolbox: string;
        get placeOnToolbox(): boolean;
        set placeOnToolbox(value: boolean);
        get toolboxPosition(): number;
        get isPrinting(): boolean;
        get isExporting(): boolean;
        get isDesigning(): boolean;
        allowDelete(): boolean;
        get priority(): number;
        get componentType(): StiComponentType;
        protected static propertyDockable: string;
        get dockable(): boolean;
        set dockable(value: boolean);
        get highlightState(): StiHighlightState;
        set highlightState(value: StiHighlightState);
        componentPlacement: string;
        private _drillDownParameters;
        get drillDownParameters(): any[];
        set drillDownParameters(value: any[]);
        protected static propertyComponentStyle: string;
        get componentStyle(): string;
        set componentStyle(value: string);
        getComponentStyle(): string;
        setComponentStyle(value: string): void;
        protected static propertyLocked: string;
        get locked(): boolean;
        set locked(value: boolean);
        protected static propertyLinked: string;
        get linked(): boolean;
        set linked(value: boolean);
        getLinked(): boolean;
        setLinked(value: boolean): void;
        get enabled(): boolean;
        set enabled(value: boolean);
        private static propertyUseParentStyles;
        get useParentStyles(): boolean;
        set useParentStyles(value: boolean);
        getUseParentStyles(): boolean;
        setUseParentStyles(value: boolean): void;
        private _page;
        get page(): StiPage;
        set page(value: StiPage);
        private _parent;
        get parent(): StiContainer;
        set parent(value: StiContainer);
        isExportAsImage(format: StiExportFormat): boolean;
        private lockOnResize;
        private invokeOnResizeComponent;
        onResizeComponent(oldSize: SizeD, newSize: SizeD): void;
        clearContents(): void;
        toString(): string;
        get isCross(): boolean;
        canContainIn(component: StiComponent): boolean;
        componentToPage(value: PointD | RectangleD): any;
        pageToComponent(value: PointD | RectangleD): any;
        static isParentSelect(component: StiComponent): boolean;
        static doOffsetRect(component: StiComponent, rect: RectangleD, offsetRect: RectangleD): RectangleD;
        getPaintRectangle(convertToHInches?: boolean, convertByZoom?: boolean, docking?: boolean): RectangleD;
        setPaintRectangle(rect: RectangleD): void;
        getDisplayRectangle2(): RectangleD;
        getDataBand(): StiDataBand;
        getGroupHeaderBand(): StiGroupHeaderBand;
        getContainer(): StiContainer;
        checkForParentComponent(comp: StiComponent): boolean;
        getComponentStyle2(): StiBaseStyle;
        private bits;
        constructor(rect?: RectangleD, isSuper?: boolean);
        protected construct(rect?: RectangleD): void;
    }
}
export namespace Stimulsoft.Report.Components {
    import Graphics = Stimulsoft.System.Drawing.Graphics;
    import Font = Stimulsoft.System.Drawing.Font;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    import StiTextOptions = Stimulsoft.Base.Drawing.StiTextOptions;
    class StiComponentDivider {
        static breakText(g: Graphics, rect: RectangleD, REFtext: any, font: Font, textOptions: StiTextOptions, textQuality: StiTextQuality, allowHtmlTags: boolean, textComp: StiText): string;
        static breakContainer(maxAllowedHeight: number, renderedContainer: StiContainer): StiContainer;
        static breakContainerV2(maxAllowedHeight: number, renderedContainer: StiContainer): StiContainer;
        private static getDivideLine;
        private static searchDivideLine;
    }
}
export namespace Stimulsoft.Report.Components {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import Font = Stimulsoft.System.Drawing.Font;
    import IStiGetFonts = Stimulsoft.Base.IStiGetFonts;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import Hashtable = Stimulsoft.System.Collections.Hashtable;
    import StiUnit = Stimulsoft.Report.Units.StiUnit;
    import StiBorder = Stimulsoft.Base.Drawing.StiBorder;
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    import Rectangle = Stimulsoft.System.Drawing.Rectangle;
    import SizeD = Stimulsoft.System.Drawing.Size;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import Point = Stimulsoft.System.Drawing.Point;
    class StiContainer extends StiComponent implements IStiBorder, IStiBrush, IStiBreakable, IStiIgnoryStyle, IStiJsonReportObject, IStiGetFonts {
        private static ImplementsStiContainer;
        implements(): any[];
        meta(): StiMeta[];
        parseContainerFromXml(xmlNode: XmlNode): void;
        loadFromXml(xmlNode: XmlNode): void;
        get componentId(): StiComponentId;
        protected static propertyCanBreak: string;
        get canBreak(): boolean;
        set canBreak(value: boolean);
        break(dividedComponent: StiComponent, devideFactor: number, REFdivideLine: any): boolean;
        clone(cloneProperties?: boolean, cloneComponents?: boolean): any;
        convert(oldUnit: StiUnit, newUnit: StiUnit, isReportSnapshot?: boolean, convertComponents?: boolean): void;
        border: StiBorder;
        private _brush;
        get brush(): StiBrush;
        set brush(value: StiBrush);
        getActualSize(isFirstPass?: boolean, REFneedSecondPass?: any): SizeD;
        getFonts(): Font[];
        private _containerInfo;
        get containerInfo(): StiContainerInfo;
        get priority(): number;
        get toolboxPosition(): number;
        get toolboxCategory(): StiToolboxCategory;
        get componentType(): StiComponentType;
        parentComponentIsBand: boolean;
        parentComponentIsCrossBand: boolean;
        collapsedValue: any;
        collapsingIndex: number;
        collapsingTreePath: string;
        get hasSelected(): boolean;
        defaultClientRectangle: Rectangle;
        private _components;
        get components(): StiComponentsCollection;
        set components(value: StiComponentsCollection);
        protected static propertyBlocked: string;
        get blocked(): boolean;
        set blocked(value: boolean);
        setParentStylesToChilds(style?: Stimulsoft.Report.Styles.StiBaseStyle): void;
        offsetLocation(offsetX: number, offsetY: number): void;
        changePosition(delta: Rectangle): void;
        normalize(): void;
        sortByPriority(): void;
        bringToFront(): void;
        sendToBack(): void;
        moveForward(): void;
        moveBackward(): void;
        alignTo(aligning: StiAligning): void;
        private getContainerInRectPrivate;
        getContainerInRect(rect: Rectangle, component: StiComponent): StiContainer;
        private getSizesTable;
        private getNodeSize;
        private getContainerInRect2Private;
        getContainerInRect2(rect: Rectangle, component: StiComponent, hash: Hashtable): StiContainer;
        private getIncorrect2;
        correct2(onlySelect: boolean): void;
        getIncorrect(onlySelect?: boolean): StiComponentsCollection;
        correct(onlySelect?: boolean): void;
        checkLargeHeight(needFullCalculation?: boolean): void;
        resetSelection(): void;
        getSelectedComponents(): StiComponentsCollection;
        getSelectedComponents2(REFcomps: any): void;
        getSelectedRectangle(): Rectangle;
        makeHorizontalSpacingEqual(): void;
        makeVerticalSpacingEqual(): void;
        makeSameSize(size: SizeD): void;
        makeSameWidth(width: number): void;
        makeSameHeight(height: number): void;
        setCenterHorizontally(): void;
        setCenterVertically(): void;
        selectAll(): void;
        containerToPage(value: Point | Rectangle): any;
        private containerToPageRectangle;
        private containerToPagePoint;
        pageToContainer(value: Point | Rectangle): any;
        getComponents(): StiComponentsCollection;
        getComponents2(REFcomps: any): void;
        getComponentsList(): StiComponent[];
        moveComponentsToPage(): void;
        constructor(rect?: Rectangle, isSuper?: boolean);
        protected construct(rect?: Rectangle): void;
    }
}
export namespace Stimulsoft.Report.Components {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import Color = Stimulsoft.System.Drawing.Color;
    class StiBand extends StiContainer implements IStiResetPageNumber, IStiJsonReportObject, IStiCanGrow, IStiConditions {
        private static ImplementsStiBand;
        implements(): any[];
        meta(): StiMeta[];
        canContainIn(component: StiComponent): boolean;
        get componentType(): StiComponentType;
        protected getComponentType(): StiComponentType;
        clone(cloneProperties: boolean, cloneComponents: boolean): StiBand;
        private _resetPageNumber;
        get resetPageNumber(): boolean;
        set resetPageNumber(value: boolean);
        private _bandInfo;
        get bandInfo(): StiBandInfo;
        getDockStyle(): StiDockStyle;
        setDockStyle(value: StiDockStyle): void;
        get isAutomaticDock(): boolean;
        get printable(): boolean;
        set printable(value: boolean);
        get minHeight(): number;
        set minHeight(value: number);
        getMinHeight(): number;
        setMinHeight(value: number): void;
        get maxHeight(): number;
        set maxHeight(value: number);
        getMaxHeight(): number;
        setMaxHeight(value: number): void;
        defaultClientRectangle: RectangleD;
        getDisplayRectangle(): RectangleD;
        setDisplayRectangle(value: RectangleD): void;
        setDirectDisplayRectangle(rect: RectangleD): void;
        get selectRectangle(): RectangleD;
        set selectRectangle(value: RectangleD);
        get nestedLevel(): number;
        rectangleMoveComponent: RectangleD;
        get headerStartColor(): Color;
        get headerEndColor(): Color;
        getHeaderText(): string;
        get headerSize(): number;
        get footerSize(): number;
        constructor(rect?: RectangleD);
    }
}
export namespace Stimulsoft.Report.Components {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiDynamicBand extends StiBand implements IStiPageBreak, IStiBreakable, IStiPrintAtBottom, IStiJsonReportObject {
        private _implementsStiDynamicBand;
        implements(): any[];
        meta(): StiMeta[];
        private _printAtBottom;
        get printAtBottom(): boolean;
        set printAtBottom(value: boolean);
        break(dividedComponent: StiComponent, devideFactor: number, divLine: number): boolean;
        newPageBefore: boolean;
        newPageAfter: boolean;
        newColumnBefore: boolean;
        newColumnAfter: boolean;
        skipFirst: boolean;
        private _breakIfLessThan;
        get breakIfLessThan(): number;
        set breakIfLessThan(value: number);
        constructor(rect?: RectangleD);
    }
}
export namespace Stimulsoft.Report.Components {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import StiGetCollapsedEvent = Stimulsoft.Report.Events.StiGetCollapsedEvent;
    import StiEndRenderEvent = Stimulsoft.Report.Events.StiEndRenderEvent;
    import StiRenderingEvent = Stimulsoft.Report.Events.StiRenderingEvent;
    import StiBeginRenderEvent = Stimulsoft.Report.Events.StiBeginRenderEvent;
    import StiValueEventArgs = Stimulsoft.Report.Events.StiValueEventArgs;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiBusinessObject = Stimulsoft.Report.Dictionary.StiBusinessObject;
    import StiUnit = Stimulsoft.Report.Units.StiUnit;
    import StiDataSource = Stimulsoft.Report.Dictionary.StiDataSource;
    import StiDataRelation = Stimulsoft.Report.Dictionary.StiDataRelation;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import Color = Stimulsoft.System.Drawing.Color;
    class StiDataBand extends StiDynamicBand implements IStiDataSource, Stimulsoft.Report.Dictionary.IStiEnumerator, IStiMasterComponent, IStiDataRelation, IStiOddEvenStyles, IStiSort, IStiFilter, IStiPrintOnAllPages, IStiPrintIfDetailEmpty, IStiKeepDetailsTogether, IStiResetPageNumber, IStiRenderMaster, IStiBusinessObject, IStiJsonReportObject {
        private static ImplementsStiDataBand;
        implements(): any[];
        jsonMasterComponentTemp: string;
        meta(): StiMeta[];
        static loadXmlSort(xmlNode: XmlNode): string[];
        saveState(stateName: string): void;
        restoreState(stateName: string): void;
        masterComponent: StiComponent;
        convert(oldUnit: StiUnit, newUnit: StiUnit, isReportSnapshot?: boolean): void;
        get keepDetailsTogether(): boolean;
        set keepDetailsTogether(value: boolean);
        keepDetails: StiKeepDetails;
        private _sort;
        get sort(): string[];
        set sort(value: string[]);
        clone(cloneProperties: boolean, cloneComponents: boolean): StiBand;
        private _printOnAllPages;
        get printOnAllPages(): boolean;
        set printOnAllPages(value: boolean);
        printIfDetailEmpty: boolean;
        get isDataSourceEmpty(): boolean;
        private _dataSource;
        get dataSource(): StiDataSource;
        private _dataSourceName;
        get dataSourceName(): string;
        set dataSourceName(value: string);
        get isBusinessObjectEmpty(): boolean;
        get businessObject(): StiBusinessObject;
        private _businessObjectGuid;
        get businessObjectGuid(): string;
        set businessObjectGuid(value: string);
        firstAsync(): Promise<void>;
        first(): void;
        prior(): void;
        nextAsync(): Promise<void>;
        next(): void;
        last(): void;
        isEofValue: boolean;
        get isEof(): boolean;
        set isEof(value: boolean);
        isBofValue: boolean;
        get isBof(): boolean;
        set isBof(value: boolean);
        get isEmpty(): boolean;
        positionValue: number;
        get position(): number;
        set position(value: number);
        get count(): number;
        allowReconnectOnEachRowForDetails: boolean;
        get dataRelation(): StiDataRelation;
        dataRelationName: string;
        filterMode: StiFilterMode;
        filterEngine: StiFilterEngine;
        filterMethodHandler: Function;
        filters: StiFiltersCollection;
        get filter(): string;
        set filter(value: string);
        filterOn: boolean;
        static propertyEvenStyle: string;
        get evenStyle(): string;
        set evenStyle(value: string);
        static propertyOddStyle: string;
        get oddStyle(): string;
        set oddStyle(value: string);
        get headerStartColor(): Color;
        get headerEndColor(): Color;
        getHeaderText(): string;
        doBookmark(): boolean;
        doPointer(createNewGuid?: boolean): void;
        invokeGroupRendering(): void;
        private _dataBandInfo;
        get dataBandInfo(): StiDataBandInfo;
        renderAsync(): Promise<StiComponent>;
        render(): StiComponent;
        renderMasterAsync(): Promise<void>;
        renderMaster(): void;
        get toolboxPosition(): number;
        get toolboxCategory(): StiToolboxCategory;
        get priority(): number;
        protected getComponentType(): StiComponentType;
        private static eventBeginRender;
        onBeginRender: Function;
        invokeBeginRender(): void;
        get beginRenderEvent(): StiBeginRenderEvent;
        set beginRenderEvent(value: StiBeginRenderEvent);
        private static eventRendering;
        onRendering: Function;
        invokeRendering(): void;
        get renderingEvent(): StiRenderingEvent;
        set renderingEvent(value: StiRenderingEvent);
        private static eventEndRender;
        onEndRender: Function;
        invokeEndRender(): void;
        get endRenderEvent(): StiEndRenderEvent;
        set endRenderEvent(value: StiEndRenderEvent);
        private static eventGetCollapsed;
        onGetCollapsed: Function;
        invokeGetCollapsed(e: StiValueEventArgs): void;
        get getCollapsedEvent(): StiGetCollapsedEvent;
        set getCollapsedEvent(value: StiGetCollapsedEvent);
        private _collapsed;
        get collapsed(): string;
        set collapsed(value: string);
        private _rightToLeft;
        get rightToLeft(): boolean;
        set rightToLeft(value: boolean);
        getRightToLeft(): boolean;
        setRightToLeft(value: boolean): void;
        getColumnWidth(): number;
        columnGaps: number;
        columnWidth: number;
        columns: number;
        minRowsInColumn: number;
        gapAfterLastColumn: boolean;
        private _columnDirection;
        get columnDirection(): StiColumnDirection;
        set columnDirection(value: StiColumnDirection);
        lineThrough: number;
        line: number;
        selectedLine: number;
        resetDataSource: boolean;
        multipleInitialization: boolean;
        calcInvisible: boolean;
        private _countData;
        get countData(): number;
        set countData(value: number);
        limitRows: string;
        createNew(): StiComponent;
        constructor(rect?: RectangleD);
    }
}
export namespace Stimulsoft.Report.Events {
    class StiFillParametersEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Events {
    import EventHandler = Stimulsoft.System.EventHandler;
    import EventArgs = Stimulsoft.System.EventArgs;
    let StiGetSubReportEventHandler: EventHandler;
    class StiGetSubReportEventArgs extends EventArgs {
        report: StiReport;
        subReportName: string;
        constructor(subReportName: string);
    }
}
export namespace Stimulsoft.Report.Helpers {
    import StiResource = Stimulsoft.Report.Dictionary.StiResource;
    import Image = Stimulsoft.System.Drawing.Image;
    class StiHyperlinkProcessor {
        static getBytes(report: StiReport, hyperlink: string): number[];
        static getImage(report: StiReport, hyperlink: string): Image;
        static getString(report: StiReport, hyperlink: string): string;
        static getResource(report: StiReport, resourceName: string): StiResource;
        private static getVariable;
        static getServerNameFromHyperlink(hyperlink: string): string;
        static getResourceNameFromHyperlink(hyperlink: string): string;
        static getVariableNameFromHyperlink(hyperlink: string): string;
        static getDataColumnNameFromHyperlink(hyperlink: string): string;
        static getRealDataColumnFromHyperlink(report: StiReport, hyperlink: string): string;
        static getFileNameFromHyperlink(hyperlink: string): string;
        static isServerHyperlink(hyperlink: string): boolean;
        static isResourceHyperlink(hyperlink: string): boolean;
        static isVariableHyperlink(hyperlink: string): boolean;
        static isDataColumnHyperlink(hyperlink: string): boolean;
        static isFileHyperlink(hyperlink: string): boolean;
        static createResourceName(name: string): string;
        static createVariableName(name: string): string;
        static createFileName(path: string): string;
        static hyperlinkToString(hyperlink: string): string;
        static serverIdent: string;
        static resourceIdent: string;
        static variableIdent: string;
        static dataColumnIdent: string;
        static fileIdent: string;
    }
}
export namespace Stimulsoft.Report.Components {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiFillParametersEventArgs = Stimulsoft.Report.Events.StiFillParametersEventArgs;
    import StiFillParametersEvent = Stimulsoft.Report.Events.StiFillParametersEvent;
    import StiUnit = Stimulsoft.Report.Units.StiUnit;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiSubReport extends StiContainer implements IStiJsonReportObject {
        meta(): StiMeta[];
        get componentType(): StiComponentType;
        clone(): StiSubReport;
        convert(oldUnit: StiUnit, newUnit: StiUnit, isReportSnapshot?: boolean): void;
        get width(): number;
        set width(value: number);
        setClientRectangle(value: RectangleD): void;
        private updateSubReportPageWidth;
        getExternalSubReport(): StiReport;
        protected getSubReportFromUrl(url: string): StiReport;
        protected getSubReportFromFile(url: string): StiReport;
        private static eventFillParameters;
        protected onFillParameters(e: StiFillParametersEventArgs): void;
        invokeFillParameters(sender: StiComponent, e: StiFillParametersEventArgs): void;
        get fillParametersEvent(): StiFillParametersEvent;
        set fillParametersEvent(value: StiFillParametersEvent);
        get useExternalReport(): boolean;
        keepSubReportTogether: boolean;
        get subReportPage(): StiPage;
        set subReportPage(value: StiPage);
        subReportPageGuid: string;
        subReportUrl: string;
        parameters: StiParametersCollection;
        static getSubReportForPage(page: StiPage): StiSubReport;
    }
}
export namespace Stimulsoft.Report.Components {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import CollectionBase = Stimulsoft.System.Collections.CollectionBase;
    import StiComponent = Stimulsoft.Report.Components.StiComponent;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiJson = Stimulsoft.Base.StiJson;
    class StiComponentsCollection extends CollectionBase<StiComponent> implements ICloneable, IStiJsonReportObject {
        implements(): any[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        loadFromXml(xmlNode: XmlNode): void;
        clone(): StiComponentsCollection;
        memberwiseClone(): StiComponentsCollection;
        private addCore;
        add(component: StiComponent): void;
        indexOf(param: string | StiComponent | any): number;
        insertRange(index: number, components: StiComponentsCollection): void;
        insert(index: number, component: StiComponent): void;
        remove(component: StiComponent, clearParent?: boolean): void;
        getByName(name: string): StiComponent;
        setByName(name: string, component: StiComponent): void;
        sortByPriority(): void;
        sortByTopPosition(): void;
        sortByBottomPosition(): void;
        sortByLeftPosition(): void;
        sortByRightPosition(): void;
        sortBandsByTopPosition(): void;
        sortBandsByLeftPosition(): void;
        getComponentByName(componentName: string, container: StiContainer): StiComponent;
        getComponentByGuid(guid: string, container: StiContainer): StiComponent;
        getPageByAlias(alias: string): StiPage;
        setParent(parent: StiContainer): void;
        private parent;
        constructor(parent?: StiContainer);
    }
}
export namespace Stimulsoft.Report.Components {
    let IStiComponentsOwnerRenderer: System.Interface<IStiComponentsOwnerRenderer>;
    interface IStiComponentsOwnerRenderer {
    }
}
export namespace Stimulsoft.Report.Components {
    class StiContainerHelper {
        static notCheckSizeMark: string;
        static checkSize(component: StiComponent): void;
        private static componentPlacedOnBand;
        static checkContainerGrowToHeight(component: StiComponent, force: boolean): void;
    }
}
export namespace Stimulsoft.Report.Components {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import EventArgs = Stimulsoft.System.EventArgs;
    import StiEndRenderEvent = Stimulsoft.Report.Events.StiEndRenderEvent;
    import StiRenderingEvent = Stimulsoft.Report.Events.StiRenderingEvent;
    import StiBeginRenderEvent = Stimulsoft.Report.Events.StiBeginRenderEvent;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import Color = Stimulsoft.System.Drawing.Color;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiEmptyBand extends StiBand implements IStiOddEvenStyles, IStiJsonReportObject {
        implements(): any[];
        meta(): StiMeta[];
        getHeaderText(): string;
        get headerStartColor(): Color;
        get headerEndColor(): Color;
        get toolboxPosition(): number;
        get toolboxCategory(): StiToolboxCategory;
        get priority(): number;
        get evenStyle(): string;
        set evenStyle(value: string);
        get oddStyle(): string;
        set oddStyle(value: string);
        private static eventBeginRender;
        protected onBeginRender(e: EventArgs): void;
        invokeBeginRender(): void;
        get beginRenderEvent(): StiBeginRenderEvent;
        set beginRenderEvent(value: StiBeginRenderEvent);
        private static eventRendering;
        protected onRendering(e: EventArgs): void;
        invokeRendering(): void;
        get renderingEvent(): StiRenderingEvent;
        set renderingEvent(value: StiRenderingEvent);
        private static eventEndRender;
        protected onEndRender(e: EventArgs): void;
        invokeEndRender(): void;
        get endRenderEvent(): StiEndRenderEvent;
        set endRenderEvent(value: StiEndRenderEvent);
        createNew(): StiComponent;
        sizeMode: StiEmptySizeMode;
        constructor(rect?: RectangleD);
    }
}
export namespace Stimulsoft.Report.Components {
    import Font = Stimulsoft.System.Drawing.Font;
    let IStiFont: System.Interface<IStiFont>;
    let ImplementsIStiFont: any[];
    interface IStiFont {
        font: Font;
    }
}
export namespace Stimulsoft.Report.Components {
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    let IStiBrush: System.Interface<IStiBrush>;
    interface IStiBrush {
        brush: StiBrush;
    }
}
export namespace Stimulsoft.Report.Components {
    import StiBorder = Stimulsoft.Base.Drawing.StiBorder;
    let IStiBorder: System.Interface<IStiBorder>;
    interface IStiBorder {
        border: StiBorder;
    }
}
export namespace Stimulsoft.Report.Engine {
    import Type = Stimulsoft.System.Type;
    class StiBuilder {
        private static typeToBuilder;
        static getBuilder(componentType: Type): StiBuilder;
        setReportVariables(masterComp: Stimulsoft.Report.Components.StiComponent): void;
        prepare(masterComp: Stimulsoft.Report.Components.StiComponent): void;
        unPrepare(masterComp: Stimulsoft.Report.Components.StiComponent): void;
        internalRenderAsync(masterComp: Stimulsoft.Report.Components.StiComponent): Promise<Stimulsoft.Report.Components.StiComponent>;
        internalRender(masterComp: Stimulsoft.Report.Components.StiComponent): Stimulsoft.Report.Components.StiComponent;
        renderAsync(masterComp: Stimulsoft.Report.Components.StiComponent): Promise<Stimulsoft.Report.Components.StiComponent>;
        render(masterComp: Stimulsoft.Report.Components.StiComponent): Stimulsoft.Report.Components.StiComponent;
    }
}
export namespace Stimulsoft.Report.Components {
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    let IStiTextBrush: System.Interface<IStiTextBrush>;
    interface IStiTextBrush {
        textBrush: StiBrush;
    }
}
export namespace Stimulsoft.Report.Components {
    class StiComponentHelper {
        static fillComponentPlacement(component: StiComponent): void;
    }
}
export namespace Stimulsoft.Report.Styles.Conditions {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import ICloneable = Stimulsoft.System.ICloneable;
    import CollectionBase = Stimulsoft.System.Collections.CollectionBase;
    import StiStyleConditionElement = Stimulsoft.Report.Styles.Conditions.Elements.StiStyleConditionElement;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiJson = Stimulsoft.Base.StiJson;
    class StiStyleConditionsCollection extends CollectionBase<StiStyleCondition> implements ICloneable, IStiJsonReportObject {
        implements(): any[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        loadFromXml(xmlNode: XmlNode): void;
        clone(): StiStyleConditionsCollection;
        add(param: StiStyleCondition | StiStyleConditionElement[] | any): void;
        addRange(conditions: StiStyleCondition[] | StiStyleConditionsCollection | any): void;
    }
}
export namespace Stimulsoft.Report.Chart {
    import IStiBaseStyle = Stimulsoft.Report.Styles.IStiBaseStyle;
    import StiElementStyleIdent = Stimulsoft.Report.Dashboard.StiElementStyleIdent;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    let IStiChartStyle: System.Interface<IStiChartStyle>;
    interface IStiChartStyle extends IStiBaseStyle, ICloneable, IStiJsonReportObject {
        styleIdent: StiElementStyleIdent;
        core: IStiStyleCoreXF;
        dashboardName: string;
        serviceEnabled: boolean;
        allowDashboard: boolean;
    }
}
export namespace Stimulsoft.Report.Chart {
    import IStiGetFonts = Stimulsoft.Base.IStiGetFonts;
    import StiPage = Stimulsoft.Report.Components.StiPage;
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    import IStiComponent = Stimulsoft.Report.Components.IStiComponent;
    import StiBorder = Stimulsoft.Base.Drawing.StiBorder;
    import StiFiltersCollection = Stimulsoft.Report.Components.StiFiltersCollection;
    import StiFilterMode = Stimulsoft.Report.Components.StiFilterMode;
    import StiDataSource = Stimulsoft.Report.Dictionary.StiDataSource;
    import StiDataRelation = Stimulsoft.Report.Dictionary.StiDataRelation;
    import StiBusinessObject = Stimulsoft.Report.Dictionary.StiBusinessObject;
    import IStiCanGrow = Stimulsoft.Report.Components.IStiCanGrow;
    import IStiCanShrink = Stimulsoft.Report.Components.IStiCanShrink;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiImageRotation = Stimulsoft.Report.Components.StiImageRotation;
    import StiAnimation = Stimulsoft.Base.Context.Animation.StiAnimation;
    import List = Stimulsoft.System.Collections.List;
    let IStiChart: System.Interface<IStiChart>;
    interface IStiChart extends IStiComponent, IStiName, IStiCanGrow, IStiCanShrink, IStiGetFonts {
        seriesLabelsConditions: IStiChartConditionsCollection;
        series: IStiSeriesCollection;
        area: IStiArea;
        style: IStiChartStyle;
        seriesLabels: IStiSeriesLabels;
        legend: IStiLegend;
        title: IStiChartTitle;
        table: IStiChartTable;
        strips: IStiStripsCollection;
        constantLines: IStiConstantLinesCollection;
        horSpacing: number;
        vertSpacing: number;
        isDesigning: boolean;
        isAnimation: boolean;
        isAnimationChangingValues: boolean;
        brush: StiBrush;
        core: IStiChartCoreXF;
        allowApplyStyle: boolean;
        masterComponent: IStiComponent;
        jsonMasterComponentTemp: string;
        dataSourceName: string;
        chartInfo: IStiChartInfo;
        processAtEnd: boolean;
        convertToHInches(value: number): number;
        saveState(stateName: string): any;
        restoreState(stateName: string): any;
        customStyleName: string;
        name: string;
        border: StiBorder;
        filters: StiFiltersCollection;
        filterMode: StiFilterMode;
        filterOn: boolean;
        dataSource: StiDataSource;
        dataRelation: StiDataRelation;
        countData: number;
        businessObject: StiBusinessObject;
        canGrow: boolean;
        canShrink: boolean;
        rotation: StiImageRotation;
        editorType: StiChartEditorType;
        page: StiPage;
        previousAnimations: List<StiAnimation>;
        sortAnimation: boolean;
        loadFromXml(xmlNode: XmlNode): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiCustomStyle: System.Interface<IStiCustomStyle>;
    interface IStiCustomStyle extends IStiChartStyle {
        customCore: IStiCustomStyleCoreXF;
    }
}
export namespace Stimulsoft.Report.Styles {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiJson = Stimulsoft.Base.StiJson;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import ICloneable = Stimulsoft.System.ICloneable;
    import StiComponent = Stimulsoft.Report.Components.StiComponent;
    import StiStyleConditionsCollection = Stimulsoft.Report.Styles.Conditions.StiStyleConditionsCollection;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiComponentsCollection = Stimulsoft.Report.Components.StiComponentsCollection;
    import StiService = Stimulsoft.Base.Services.StiService;
    class StiBaseStyle extends StiService implements IStiBaseStyle, ICloneable, IStiJsonReportObject {
        implements(): any[];
        meta(): StiMeta[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        loadFromXml(xmlNode: XmlNode): void;
        clone(): any;
        equals(obj: any, allowEqualName?: boolean, allowEqualDescription?: boolean): boolean;
        static getStyle(component: StiComponent, styleElements?: StiStyleElements | StiBaseStyle, componentStyle?: StiBaseStyle): StiBaseStyle;
        getStyleFromComponent(component: StiComponent, styleElements: StiStyleElements): void;
        setStyleToComponent(component: StiComponent): void;
        getStyleFromComponents(comps: StiComponentsCollection, styleElements: StiStyleElements): void;
        toString(): string;
        private _collectionName;
        get collectionName(): string;
        set collectionName(value: string);
        private _conditions;
        get conditions(): StiStyleConditionsCollection;
        set conditions(value: StiStyleConditionsCollection);
        private _description;
        get description(): string;
        set description(value: string);
        private _name;
        get name(): string;
        set name(value: string);
        get dashboardName(): string;
        report: StiReport;
        constructor(name?: string, description?: string, report?: StiReport);
    }
}
export namespace Stimulsoft.Report.Events {
    import EventHandler = Stimulsoft.System.EventHandler;
    import EventArgs = Stimulsoft.System.EventArgs;
    let StiGetExcelValueEventHandler: EventHandler;
    class StiGetExcelValueEventArgs extends EventArgs {
        value: string;
        storeToPrinted: boolean;
    }
}
export namespace Stimulsoft.Report.Components.TextFormats {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiService = Stimulsoft.Base.Services.StiService;
    import StiJson = Stimulsoft.Base.StiJson;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    class StiFormatService extends StiService implements IStiJsonReportObject {
        implements(): any[];
        meta(): StiMeta[];
        static createFromJsonObject(jObject: StiJson): StiFormatService;
        static loadFormatFromXml(xmlNode: XmlNode, report?: StiReport): StiFormatService;
        static loadFromJsonObjectInternal(jObject: StiJson): StiFormatService;
        get position(): number;
        get sample(): any;
        get nativeFormatString(): string;
        get isFormatStringFromVariable(): boolean;
        stringFormat: string;
        format(arg: any): string;
        format2(format: string, arg: any): string;
        createNew(): StiFormatService;
    }
}
export namespace Stimulsoft.Report.Components.TextFormats {
    class StiCustomFormatService extends StiFormatService {
        get sample(): any;
        format2(format: string, arg: any): string;
        createNew(): StiFormatService;
        constructor(stringFormat?: string);
    }
}
export namespace Stimulsoft.Report.Components.TextFormats {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    class StiTimeFormatService extends StiFormatService {
        meta(): StiMeta[];
        get sample(): any;
        format(arg: any): string;
        format2(stringFormat: string, arg: any): string;
        createNew(): StiFormatService;
        constructor(stringFormat?: string);
    }
}
export namespace Stimulsoft.Report.Components.TextFormats {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    class StiDateFormatService extends StiFormatService implements IStiJsonReportObject {
        meta(): StiMeta[];
        get sample(): any;
        format(arg: any): string;
        format2(stringFormat: string, arg: any): string;
        private static formatQuarter;
        nullDisplay: string;
        createNew(): StiFormatService;
        constructor(stringFormat?: string, nullDisplay?: string);
    }
}
export namespace Stimulsoft.Report.Components {
    enum StiTextFormatState {
        None = 0,
        DecimalDigits = 1,
        DecimalSeparator = 2,
        GroupSeparator = 4,
        GroupSize = 8,
        PositivePattern = 16,
        NegativePattern = 32,
        CurrencySymbol = 64,
        PercentageSymbol = 128,
        Abbreviation = 256,
        NegativeInRed = 512
    }
    enum StiIconSet {
        None = 0,
        Full = 1,
        ArrowsColored3 = 2,
        ArrowsColored4 = 3,
        ArrowsColored5 = 4,
        ArrowsGray3 = 5,
        ArrowsGray4 = 6,
        ArrowsGray5 = 7,
        Flags3 = 8,
        Latin4 = 9,
        Quarters5 = 10,
        QuartersGreen5 = 11,
        QuartersRed5 = 12,
        Ratings3 = 13,
        Ratings4 = 14,
        Ratings5 = 15,
        RedToBlack4 = 16,
        Signs3 = 17,
        Squares5 = 18,
        Stars3 = 19,
        Stars5 = 20,
        SymbolsCircled3 = 21,
        SymbolsUncircled3 = 22,
        TrafficLights4 = 23,
        TrafficLightsRimmed3 = 24,
        TrafficLightsUnrimmed3 = 25,
        Triangles3 = 26
    }
    enum StiIcon {
        None = 0,
        ArrowRightDownGray = 1,
        ArrowRightUpGray = 2,
        ArrowDownGray = 3,
        ArrowRightGray = 4,
        ArrowUpGray = 5,
        ArrowUpGreen = 6,
        ArrowDownRed = 7,
        ArrowRightYellow = 8,
        ArrowRightDownYellow = 9,
        ArrowRightUpYellow = 10,
        CheckGreen = 11,
        CircleBlack = 12,
        CircleGreen = 13,
        CircleCheckGreen = 14,
        CircleRed = 15,
        CircleCrossRed = 16,
        CircleYellow = 17,
        CircleExclamationYellow = 18,
        CrossRed = 19,
        ExclamationYellow = 20,
        FlagGreen = 21,
        FlagRed = 22,
        FlagYellow = 23,
        FromRedToBlackGray = 24,
        FromRedToBlackPink = 25,
        FromRedToBlackRed = 26,
        Latin1 = 27,
        Latin2 = 28,
        Latin3 = 29,
        Latin4 = 30,
        LightsGreen = 31,
        LightsRed = 32,
        LightsYellow = 33,
        MinusYellow = 34,
        QuarterFull = 35,
        QuarterFullGreen = 36,
        QuarterFullRed = 37,
        QuarterHalf = 38,
        QuarterHalfGreen = 39,
        QuarterHalfRed = 40,
        QuarterNone = 41,
        QuarterNoneGreen = 42,
        QuarterNoneRed = 43,
        QuarterQuarter = 44,
        QuarterQuarterGreen = 45,
        QuarterQuarterRed = 46,
        QuarterThreeFourth = 47,
        QuarterThreeFourthGreen = 48,
        QuarterThreeFourthRed = 49,
        Rating0 = 50,
        Rating1 = 51,
        Rating2 = 52,
        Rating3 = 53,
        Rating4 = 54,
        RhombRed = 55,
        Square0 = 56,
        Square1 = 57,
        Square2 = 58,
        Square3 = 59,
        Square4 = 60,
        StarFull = 61,
        StarHalf = 62,
        StarNone = 63,
        StarQuarter = 64,
        StarThreeFourth = 65,
        TriangleGreen = 66,
        TriangleRed = 67,
        TriangleYellow = 68
    }
    enum StiIconSetOperation {
        MoreThan = 0,
        MoreThanOrEqual = 1
    }
    enum StiIconSetValueType {
        Value = 0,
        Percent = 1
    }
    enum StiProcessAt {
        None = 0,
        EndOfReport = 1,
        EndOfPage = 2
    }
    enum StiMinimumType {
        Auto = 0,
        Value = 1,
        Percent = 2,
        Minimum = 3
    }
    enum StiMidType {
        Auto = 0,
        Value = 1,
        Percent = 2
    }
    enum StiMaximumType {
        Auto = 0,
        Value = 1,
        Percent = 2,
        Maximum = 3
    }
    enum StiDrillDownMode {
        SinglePage = 0,
        MultiPage = 1
    }
    enum StiConditionBorderSides {
        None = 0,
        All = 15,
        Top = 1,
        Left = 2,
        Right = 4,
        Bottom = 8,
        NotAssigned = 16
    }
    enum StiConditionPermissions {
        None = 0,
        Font = 1,
        FontSize = 2,
        FontStyleBold = 4,
        FontStyleItalic = 8,
        FontStyleUnderline = 16,
        FontStyleStrikeout = 32,
        TextColor = 64,
        BackColor = 128,
        Borders = 256,
        All = 511
    }
    enum StiQuickInfoType {
        None = 0,
        ShowComponentsNames = 1,
        ShowAliases = 2,
        ShowFieldsOnly = 3,
        ShowFields = 4,
        ShowEvents = 5,
        ShowContent = 6
    }
    enum StiAngle {
        Angle0 = 0,
        Angle90 = 90,
        Angle180 = 180,
        Angle270 = 270
    }
    enum StiDockStyle {
        Left = 0,
        Right = 1,
        Top = 2,
        Bottom = 3,
        None = 4,
        Fill = 5
    }
    enum StiFilterCondition {
        EqualTo = 0,
        NotEqualTo = 1,
        GreaterThan = 2,
        GreaterThanOrEqualTo = 3,
        LessThan = 4,
        LessThanOrEqualTo = 5,
        Between = 6,
        NotBetween = 7,
        Containing = 8,
        NotContaining = 9,
        BeginningWith = 10,
        EndingWith = 11,
        IsNull = 12,
        IsNotNull = 13
    }
    enum StiFilterItem {
        Argument = 0,
        Value = 1,
        ValueEnd = 2,
        Expression = 3,
        ValueOpen = 4,
        ValueClose = 5,
        ValueLow = 6,
        ValueHigh = 7
    }
    enum StiFilterDataType {
        String = 0,
        Numeric = 1,
        DateTime = 2,
        Boolean = 3,
        Expression = 4
    }
    enum StiFilterMode {
        And = 0,
        Or = 1
    }
    enum StiFilterEngine {
        ReportEngine = 0,
        SQLQuery = 1
    }
    enum StiKeepDetails {
        None = 0,
        KeepFirstRowTogether = 1,
        KeepFirstDetailTogether = 2,
        KeepDetailsTogether = 3
    }
    enum StiPrintOnType {
        AllPages = 0,
        ExceptFirstPage = 1,
        ExceptLastPage = 2,
        ExceptFirstAndLastPage = 3,
        OnlyFirstPage = 4,
        OnlyLastPage = 8,
        OnlyFirstAndLastPage = 12
    }
    enum StiPrintOnEvenOddPagesType {
        Ignore = 0,
        PrintOnEvenPages = 1,
        PrintOnOddPages = 2
    }
    enum StiShiftMode {
        None = 0,
        IncreasingSize = 1,
        DecreasingSize = 2,
        OnlyInWidthOfComponent = 4
    }
    enum StiAnchorMode {
        Top = 1,
        Bottom = 2,
        Left = 4,
        Right = 8
    }
    enum StiProcessingDuplicatesType {
        None = 0,
        Merge = 1,
        Hide = 2,
        RemoveText = 3,
        BasedOnTagMerge = 4,
        BasedOnTagHide = 5,
        BasedOnTagRemoveText = 6,
        GlobalMerge = 7,
        GlobalHide = 8,
        GlobalRemoveText = 9,
        BasedOnValueRemoveText = 10,
        BasedOnValueAndTagMerge = 11,
        BasedOnValueAndTagHide = 12,
        GlobalBasedOnValueRemoveText = 13,
        GlobalBasedOnValueAndTagMerge = 14,
        GlobalBasedOnValueAndTagHide = 15
    }
    enum StiImageProcessingDuplicatesType {
        None = 0,
        Merge = 1,
        Hide = 2,
        RemoveImage = 3,
        GlobalMerge = 4,
        GlobalHide = 5,
        GlobalRemoveImage = 6
    }
    enum StiCheckStyle {
        Cross = 0,
        Check = 1,
        CrossRectangle = 2,
        CheckRectangle = 3,
        CrossCircle = 4,
        DotCircle = 5,
        DotRectangle = 6,
        NoneCircle = 7,
        NoneRectangle = 8,
        None = 9
    }
    enum StiToolboxCategory {
        Bands = 0,
        Cross = 1,
        Components = 2,
        Shapes = 3,
        Controls = 4,
        Dashboards = 5
    }
    enum StiComponentToolboxPosition {
        Component = 0,
        ReportTitleBand = 1,
        ReportSummaryBand = 2,
        PageHeaderBand = 3,
        PageFooterBand = 4,
        GroupHeaderBand = 5,
        GroupFooterBand = 6,
        HeaderBand = 7,
        FooterBand = 8,
        ColumnHeaderBand = 9,
        ColumnFooterBand = 10,
        DataBand = 11,
        HierarchicalBand = 13,
        ChildBand = 14,
        EmptyBand = 15,
        OverlayBand = 16,
        CrossGroupHeaderBand = 21,
        CrossGroupFooterBand = 22,
        CrossHeaderBand = 23,
        CrossFooterBand = 24,
        CrossDataBand = 25,
        Text = 101,
        TextInCells = 102,
        SystemText = 103,
        ContourText = 104,
        RichText = 105,
        Image = 106,
        ElectronicSignature = 107,
        PdfDigitalSignature = 108,
        BarCode = 109,
        Shape = 110,
        Line = 111,
        Container = 112,
        Panel = 113,
        Clone = 114,
        CheckBox = 115,
        SubReport = 116,
        WinControl = 117,
        ZipCode = 118,
        TableOfContents = 119,
        HorizontalLinePrimitive = 150,
        VerticalLinePrimitive = 151,
        RectanglePrimitive = 152,
        RoundedRectanglePrimitive = 153,
        Chart = 200,
        Table = 201,
        CrossTab = 202,
        Map = 210,
        Sparkline = 225,
        Gauge = 220,
        TableElement = 301,
        ChartElement = 302,
        ComboBoxElement = 400,
        GaugeElement = 303,
        PivotTableElement = 304,
        IndicatorElement = 305,
        ProgressElement = 306,
        RegionMapElement = 307,
        ListBoxElement = 308,
        OnlineMapElement = 309,
        ImageElement = 310,
        TextElement = 311,
        PanelElement = 312,
        ShapeElement = 313,
        TreeViewElement = 314,
        TreeViewBoxElement = 315,
        DatePickerElement = 316,
        CardsElement = 317,
        NumberBoxElement = 318,
        ButtonElement = 319,
        UserCode = 1000
    }
    enum StiComponentPriority {
        Component = 0,
        CrossTab = 1500,
        SubReportsV1 = 1500,
        SubReportsV2 = 0,
        Container = 0,
        Panel = 0,
        ReportTitleBandBefore = -400,
        ReportTitleBandAfterV1 = -200,
        ReportTitleBandAfterV2 = 200,
        ReportSummaryBand = 500,
        PageHeaderBandBefore = -200,
        PageHeaderBandAfter = -400,
        PageFooterBandBottom = -300,
        PageFooterBandTop = 1000,
        GroupHeaderBand = 300,
        GroupFooterBand = 300,
        HeaderBand = 300,
        FooterBand = 300,
        ColumnHeaderBand = 300,
        ColumnFooterBand = 300,
        DataBand = 300,
        Table = 300,
        ChildBand = 300,
        EmptyBand = 300,
        TableOfContents = 300,
        OverlayBand = 700,
        Primitive = 1500,
        CrossGroupHeaderBand = 300,
        CrossGroupFooterBand = 300,
        CrossHeaderBand = 300,
        CrossFooterBand = 300,
        CrossDataBand = 300
    }
    enum StiComponentType {
        Simple = 0,
        Master = 1,
        Detail = 2,
        Static = 3
    }
    enum StiRestrictions {
        None = 0,
        AllowMove = 1,
        AllowResize = 2,
        AllowSelect = 4,
        AllowChange = 8,
        AllowDelete = 16,
        All = 31
    }
    enum StiHighlightState {
        Hide = 0,
        Show = 1,
        Active = 2
    }
    enum StiAligning {
        Left = 0,
        Center = 1,
        Right = 2,
        Top = 3,
        Middle = 4,
        Bottom = 5
    }
    enum StiColumnDirection {
        DownThenAcross = 0,
        AcrossThenDown = 1
    }
    enum StiEmptySizeMode {
        IncreaseLastRow = 0,
        DecreaseLastRow = 1,
        AlignFooterToBottom = 2,
        AlignFooterToTop = 3
    }
    enum StiGroupSortDirection {
        Ascending = 0,
        Descending = 1,
        None = 2
    }
    enum StiGroupSummaryType {
        Avg = 0,
        AvgDate = 1,
        AvgTime = 2,
        Count = 3,
        CountDistinct = 4,
        MaxDate = 5,
        MaxTime = 6,
        Max = 7,
        MinDate = 8,
        MinTime = 9,
        Min = 10,
        Median = 11,
        Mode = 12,
        Sum = 13,
        SumTime = 14
    }
    enum StiPageOrientation {
        Portrait = 0,
        Landscape = 1
    }
    enum StiTextQuality {
        Standard = 0,
        Typographic = 1,
        Wysiwyg = 2
    }
    enum StiSystemTextType {
        Totals = 0,
        SystemVariables = 1,
        Expression = 2,
        DataColumn = 3,
        None = 4
    }
    enum StiBrushType {
        Solid = 0,
        Gradient = 1
    }
    enum StiColorScaleType {
        Color2 = 0,
        Color3 = 1
    }
    enum StiDataBarDirection {
        Default = 0,
        LeftToRight = 1,
        RighToLeft = 2
    }
    enum StiInteractionSortDirection {
        Ascending = 0,
        Descending = 1,
        None = 2
    }
    enum StiImageRotation {
        None = 0,
        Rotate90CW = 1,
        Rotate90CCW = 2,
        Rotate180 = 3,
        FlipHorizontal = 4,
        FlipVertical = 5
    }
    enum StiDashboardViewMode {
        Desktop = 0,
        Mobile = 1
    }
    enum StiSurfaceViewMode {
        Desktop = 0,
        Mobile = 1
    }
    enum StiSparklineType {
        Line = 0,
        Area = 1,
        Column = 2,
        WinLoss = 3
    }
    enum StiSignatureMode {
        Type = 0,
        Draw = 1
    }
}
export namespace Stimulsoft.Report.Components.TextFormats {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import NumberFormatInfo = Stimulsoft.System.Globalization.NumberFormatInfo;
    import StiTextFormatState = Stimulsoft.Report.Components.StiTextFormatState;
    class StiNumberFormatService extends StiFormatService implements IStiJsonReportObject {
        meta(): StiMeta[];
        clone(): any;
        private bits;
        get nullDisplay(): string;
        set nullDisplay(value: string);
        get negativePattern(): number;
        set negativePattern(value: number);
        get decimalSeparator(): string;
        set decimalSeparator(value: string);
        get decimalDigits(): number;
        set decimalDigits(value: number);
        get groupSeparator(): string;
        set groupSeparator(value: string);
        get groupSize(): number;
        set groupSize(value: number);
        get useGroupSeparator(): boolean;
        set useGroupSeparator(value: boolean);
        get useLocalSetting(): boolean;
        set useLocalSetting(value: boolean);
        private _totalNumberCapacity;
        get totalNumberCapacity(): number;
        set totalNumberCapacity(value: number);
        get sample(): any;
        get nativeFormatString(): string;
        equals(obj: any): boolean;
        get state(): StiTextFormatState;
        set state(value: StiTextFormatState);
        fillLocalSetting(format: NumberFormatInfo): void;
        format(arg: any): string;
        format2(stringFormat: string, arg: any): string;
        createNew(): StiFormatService;
        constructor(negativePattern?: number, decimalPlaces?: number, decimalSeparator?: string, decimalDigits?: number, groupSeparator?: string, groupSize?: number, useGroupSeparator?: boolean, useLocalSetting?: boolean, nullDisplay?: string, state?: StiTextFormatState);
    }
}
export namespace Stimulsoft.Report.Components.TextFormats {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    class StiCurrencyFormatService extends StiNumberFormatService implements IStiJsonReportObject {
        meta(): StiMeta[];
        positivePattern: number;
        symbol: string;
        get nativeFormatString(): string;
        get sample(): any;
        equals(obj: any): boolean;
        format(arg: any): string;
        format2(stringFormat: string, arg: any): string;
        private formatAsCurrency;
        createNew(): StiFormatService;
        constructor(positivePattern?: number, negativePattern?: number, decimalPlaces?: number, decimalSeparator?: string, decimalDigits?: number, groupSeparator?: string, groupSize?: number, symbol?: string, useGroupSeparator?: boolean, useLocalSetting?: boolean, nullDisplay?: string, state?: StiTextFormatState);
    }
}
export namespace Stimulsoft.Report.Components.TextFormats {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    class StiPercentageFormatService extends StiCurrencyFormatService {
        meta(): StiMeta[];
        format(arg: any): string;
        format2(stringFormat: string, arg: any): string;
        createNew(): StiFormatService;
        constructor(positivePattern?: number, negativePattern?: number, decimalPlaces?: number, decimalSeparator?: string, decimalDigits?: number, groupSeparator?: string, groupSize?: number, symbol?: string, useGroupSeparator?: boolean, useLocalSetting?: boolean, nullDisplay?: string, state?: StiTextFormatState);
    }
}
export namespace Stimulsoft.Report.Components.TextFormats {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    class StiGeneralFormatService extends StiFormatService {
        meta(): StiMeta[];
        get sample(): string;
        equals(obj: any): boolean;
        static default: StiGeneralFormatService;
        createNew(): StiFormatService;
        constructor();
    }
}
export namespace Stimulsoft.Report.Events {
    class StiGetValueEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Events {
    import EventHandler = Stimulsoft.System.EventHandler;
    import EventArgs = Stimulsoft.System.EventArgs;
    let StiGetValueEventHandler: EventHandler;
    class StiGetValueEventArgs extends EventArgs {
        value: string;
        storeToPrinted: boolean;
    }
}
export namespace Stimulsoft.Report.Components {
    let IStiEditable: System.Interface<IStiEditable>;
    interface IStiEditable {
        editable: boolean;
        saveState(): string;
        restoreState(value: string): any;
    }
}
export namespace Stimulsoft.Report.Components {
    import StiPenStyle = Stimulsoft.Base.Drawing.StiPenStyle;
    let IStiText: System.Interface<IStiText>;
    interface IStiText {
        text: string;
        textValue: string;
        setText(getValue: any): any;
        linesOfUnderline: StiPenStyle;
        hideZeros: boolean;
        processingDuplicates: StiProcessingDuplicatesType;
        onlyText: boolean;
        maxNumberOfLines: number;
        getTextInternal(): string;
        setTextInternal(value: string): any;
    }
}
export namespace Stimulsoft.Report.Components {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiGetValueEvent = Stimulsoft.Report.Events.StiGetValueEvent;
    import IStiEditable = Stimulsoft.Report.Components.IStiEditable;
    import StiPenStyle = Stimulsoft.Base.Drawing.StiPenStyle;
    import StiGetValueEventArgs = Stimulsoft.Report.Events.StiGetValueEventArgs;
    import StiValueEventArgs = Stimulsoft.Report.Events.StiValueEventArgs;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiSimpleText extends StiComponent implements IStiText, IStiEditable, IStiJsonReportObject {
        private static ImplementsStiSimpleText;
        implements(): any[];
        meta(): StiMeta[];
        protected static propertyGlobalizedName: string;
        get globalizedName(): string;
        set globalizedName(value: string);
        clone(cloneProperties?: boolean, cloneComponents?: boolean, base?: boolean): StiSimpleText;
        memberwiseClone(base?: boolean): StiSimpleText;
        getTextWithoutZero(text: string): string;
        setText(getValue?: any, value?: string): void;
        private setTextTo;
        linesOfUnderline: StiPenStyle;
        get linesOfUnderlining(): boolean;
        set linesOfUnderlining(value: boolean);
        hideZeros: boolean;
        get mergeDuplicates(): boolean;
        set mergeDuplicates(value: boolean);
        private static propertyProcessingDuplicates;
        get processingDuplicates(): StiProcessingDuplicatesType;
        set processingDuplicates(value: StiProcessingDuplicatesType);
        private static propertyMaxNumberOfLines;
        get maxNumberOfLines(): number;
        set maxNumberOfLines(value: number);
        processText(text: string): string;
        private static propertyOnlyText;
        get onlyText(): boolean;
        set onlyText(value: boolean);
        editable: boolean;
        saveState(): string;
        restoreState(value: string): void;
        get processAtEnd(): boolean;
        set processAtEnd(value: boolean);
        protected static propertyProcessAt: string;
        get processAt(): StiProcessAt;
        set processAt(value: StiProcessAt);
        invokeRenderTo(textBox: StiSimpleText): void;
        text: string;
        getTextInternal(): string;
        setTextInternal(value: string): void;
        private _textValue;
        get textValue(): string;
        set textValue(value: string);
        private static eventGetValue;
        protected onGetValue(e: StiGetValueEventArgs): void;
        invokeGetValue(sender: StiComponent, e: StiGetValueEventArgs): void;
        private checkForCustomFormatColor;
        checkDuplicates(sender: StiComponent, e: StiGetValueEventArgs): void;
        get getValueEvent(): StiGetValueEvent;
        set getValueEvent(value: StiGetValueEvent);
        private static eventTextProcess;
        protected onTextProcess(e: StiValueEventArgs): void;
        invokeTextProcess(sender: StiComponent, e: StiValueEventArgs): void;
        private applyConditionsAssignExpression;
        _totalValueHelp: string;
        get totalValueHelp(): string;
        set totalValueHelp(value: string);
        constructor(rect?: RectangleD, isSuper?: boolean);
        protected construct(rect?: RectangleD): void;
    }
}
export namespace Stimulsoft.Report.Events {
    class StiGetExcelValueEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Components {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import StiComponent = Stimulsoft.Report.Components.StiComponent;
    import IStiGetFonts = Stimulsoft.Base.IStiGetFonts;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import Image = Stimulsoft.System.Drawing.Image;
    import StiGetExcelValueEvent = Stimulsoft.Report.Events.StiGetExcelValueEvent;
    import IStiEditable = Stimulsoft.Report.Components.IStiEditable;
    import Font = Stimulsoft.System.Drawing.Font;
    import StiTextHorAlignment = Stimulsoft.Base.Drawing.StiTextHorAlignment;
    import StiVertAlignment = Stimulsoft.Base.Drawing.StiVertAlignment;
    import StiBorder = Stimulsoft.Base.Drawing.StiBorder;
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    import StiTextOptions = Stimulsoft.Base.Drawing.StiTextOptions;
    import StringTrimming = Stimulsoft.System.Drawing.StringTrimming;
    import StiFormatService = Stimulsoft.Report.Components.TextFormats.StiFormatService;
    import StiGetExcelValueEventArgs = Stimulsoft.Report.Events.StiGetExcelValueEventArgs;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    import SizeD = Stimulsoft.System.Drawing.Size;
    class StiText extends StiSimpleText implements IStiTextOptions, IStiAutoWidth, IStiTextHorAlignment, IStiVertAlignment, IStiBorder, IStiFont, IStiBrush, IStiTextBrush, IStiTextFormat, IStiBreakable, IStiGlobalizationProvider, IStiExportImageExtended, IStiExportImage, IStiEditable, IStiJsonReportObject, IStiGetFonts {
        private static ImplementsStiText;
        implements(): any[];
        meta(): StiMeta[];
        get componentId(): StiComponentId;
        indicator: StiIndicator;
        getImage(REFzoom: any, format?: StiExportFormat): Image;
        isExportAsImage(format: StiExportFormat): boolean;
        setString(propertyName: string, value: string): void;
        protected globalizationSetString(propertyName: string, value: string): void;
        getString(propertyName: string): string;
        protected globalizationGetString(propertyName: string): string;
        getAllStrings(): string[];
        protected globalizationGetAllStrings(): string[];
        private static propertyCanBreak;
        get canBreak(): boolean;
        set canBreak(value: boolean);
        break(dividedComponent: StiComponent, devideFactor: number, REFdivideLine: any): boolean;
        private static propertyAutoWidth;
        get autoWidth(): boolean;
        set autoWidth(value: boolean);
        protected static propertyRenderTo: string;
        get renderTo(): string;
        set renderTo(value: string);
        invokeRenderTo(textFrom: StiSimpleText): void;
        private getVisibleTextForRenderTo;
        private _horAlignment;
        get horAlignment(): StiTextHorAlignment;
        set horAlignment(value: StiTextHorAlignment);
        private _vertAlignment;
        get vertAlignment(): StiVertAlignment;
        set vertAlignment(value: StiVertAlignment);
        static defaultFont: Font;
        private _font;
        get font(): Font;
        set font(value: Font);
        border: StiBorder;
        brush: StiBrush;
        textBrush: StiBrush;
        private _textFormat;
        get textFormat(): StiFormatService;
        set textFormat(value: StiFormatService);
        format: string;
        textOptions: StiTextOptions;
        clone(cloneProperties?: boolean, cloneComponents?: boolean, base?: boolean): StiText;
        memberwiseClone(base?: boolean): StiText;
        getFonts(): Font[];
        convertTextMargins(rect: RectangleD, convert: boolean): RectangleD;
        convertTextBorders(rect: RectangleD, convert: boolean): RectangleD;
        getTextForPaint(): string;
        getActualSize(): SizeD;
        private rotateSize;
        prepare(): void;
        excelDataValue: string;
        get excelValue(): string;
        set excelValue(value: string);
        invokeEvents(): void;
        private static eventGetExcelValue;
        protected onGetExcelValue(e: StiGetExcelValueEventArgs): void;
        invokeGetExcelValue(sender: StiComponent, e: StiGetExcelValueEventArgs): void;
        get getExcelValueEvent(): StiGetExcelValueEvent;
        set getExcelValueEvent(value: StiGetExcelValueEvent);
        protected static propertyNullValue: string;
        get nullValue(): string;
        set nullValue(value: string);
        protected static propertyType: string;
        get type(): StiSystemTextType;
        set type(value: StiSystemTextType);
        get wordWrap(): boolean;
        set wordWrap(value: boolean);
        get rightToLeft(): boolean;
        set rightToLeft(value: boolean);
        get trimming(): StringTrimming;
        set trimming(value: StringTrimming);
        get angle(): number;
        set angle(value: number);
        private static propertyLineSpacing;
        get lineSpacing(): number;
        set lineSpacing(value: number);
        private static propertyExportAsImage;
        get exportAsImage(): boolean;
        set exportAsImage(value: boolean);
        private static propertyTextQuality;
        get textQuality(): StiTextQuality;
        set textQuality(value: StiTextQuality);
        private static propertyAllowHtmlTags;
        get allowHtmlTags(): boolean;
        set allowHtmlTags(value: boolean);
        margins: StiMargins;
        private static propertyShrinkFontToFit;
        get shrinkFontToFit(): boolean;
        set shrinkFontToFit(value: boolean);
        private static propertyShrinkFontToFitMinimumSize;
        get shrinkFontToFitMinimumSize(): number;
        set shrinkFontToFitMinimumSize(value: number);
        createNew(): StiComponent;
        checkAllowHtmlTags(): boolean;
        getActualFont(text: string, minFontSize?: number): Font;
        constructor(rect?: RectangleD, isSuper?: boolean);
        protected construct(rect?: RectangleD): void;
    }
}
export namespace Stimulsoft.Report.Components {
    import StiTextHorAlignment = Stimulsoft.Base.Drawing.StiTextHorAlignment;
    let IStiTextHorAlignment: System.Interface<IStiTextHorAlignment>;
    let ImplementsIStiTextHorAlignment: any[];
    interface IStiTextHorAlignment {
        horAlignment: StiTextHorAlignment;
    }
}
export namespace Stimulsoft.Report.Components {
    import StiVertAlignment = Stimulsoft.Base.Drawing.StiVertAlignment;
    let IStiVertAlignment: System.Interface<IStiVertAlignment>;
    let ImplementsIStiVertAlignment: any[];
    interface IStiVertAlignment {
        vertAlignment: StiVertAlignment;
    }
}
export namespace Stimulsoft.Report.Components {
    let IStiCrossTabField: System.Interface<IStiCrossTabField>;
    interface IStiCrossTabField {
    }
}
export namespace Stimulsoft.Report.CrossTab {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import StiConditionPermissions = Stimulsoft.Report.Components.StiConditionPermissions;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiText = Stimulsoft.Report.Components.StiText;
    import StiRestrictions = Stimulsoft.Report.Components.StiRestrictions;
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    import IStiBorder = Stimulsoft.Report.Components.IStiBorder;
    import IStiBrush = Stimulsoft.Report.Components.IStiBrush;
    import IStiFont = Stimulsoft.Report.Components.IStiFont;
    import IStiTextBrush = Stimulsoft.Report.Components.IStiTextBrush;
    import IStiTextHorAlignment = Stimulsoft.Report.Components.IStiTextHorAlignment;
    import IStiVertAlignment = Stimulsoft.Report.Components.IStiVertAlignment;
    import StiTextHorAlignment = Stimulsoft.Base.Drawing.StiTextHorAlignment;
    import IStiCrossTabField = Stimulsoft.Report.Components.IStiCrossTabField;
    class StiCrossField extends StiText implements IStiTextHorAlignment, IStiVertAlignment, IStiBorder, IStiFont, IStiBrush, IStiTextBrush, IStiCrossTabField, IStiJsonReportObject {
        private static ImplementsStiCrossField;
        implements(): any[];
        meta(): StiMeta[];
        loadFromXml(xmlNode: XmlNode): void;
        protected get defaultHorAlignment(): StiTextHorAlignment;
        get locked(): boolean;
        set locked(value: boolean);
        get linked(): boolean;
        set linked(value: boolean);
        protected onProcessCell(e: StiProcessCellEventArgs): void;
        invokeProcessCell(e: StiProcessCellEventArgs): void;
        processCellEvent: StiProcessCellEvent;
        get helpUrl(): string;
        toString(): string;
        get localizedCategory(): string;
        getRestrictions(): StiRestrictions;
        setRestrictions(value: StiRestrictions): void;
        getTextBoxFromField(): StiText;
        get cellText(): string;
        mergeHeaders: boolean;
        originalValue: any;
        disabledByCondition: boolean;
        conditionBrush: StiBrush;
        conditionTextBrush: StiBrush;
        conditionPermissions: StiConditionPermissions;
        constructor();
    }
}
export namespace Stimulsoft.Report.Dictionary.Design {
    import Type = Stimulsoft.System.Type;
    class StiDataColumnConverter {
        static convertTypeToString(type: Type): string;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import List = Stimulsoft.System.Collections.List;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import ICloneable = Stimulsoft.System.ICloneable;
    import StiJson = Stimulsoft.Base.StiJson;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import IStiAppDataColumn = Stimulsoft.Base.IStiAppDataColumn;
    import Type = Stimulsoft.System.Type;
    import IStiAppAlias = Stimulsoft.Base.IStiAppAlias;
    class StiDataColumn implements IStiJsonReportObject, ICloneable, IStiName, IStiAppDataColumn, IStiAppAlias, IStiInherited {
        implements(): any[];
        is<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): this is T;
        is2<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): boolean;
        as<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): T;
        protected _hash: StiMeta[];
        meta(): StiMeta[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        loadFromXml(xmlNode: XmlNode): void;
        clone(): StiDataColumn;
        memberwiseClone(): StiDataColumn;
        getNameInSource(): string;
        getDataType(): Type;
        getName(): string;
        getAlias(): string;
        getKey(): string;
        setKey(key: string): void;
        private _name;
        get name(): string;
        set name(value: string);
        get inherited(): boolean;
        set inherited(value: boolean);
        dataColumnsCollection: StiDataColumnsCollection;
        dataSource: StiDataSource;
        businessObject: StiBusinessObject;
        index: number;
        nameInSource: string;
        alias: string;
        type: Stimulsoft.System.Type;
        key: string;
        getColumnPath(): string;
        toString(): string;
        static getDataColumnFromColumnName(dictionary: StiDictionary, column: string, allowRelationName?: boolean): StiDataColumn;
        static getRelationName(dictionary: StiDictionary, dataSource: StiDataSource, relationName: string): string;
        static getDataFromBusinessObject(dictionary: StiDictionary, column: string): any;
        static getBusinessObjectFromDataColumn(dictionary: StiDictionary, column: string): StiBusinessObject;
        static getDataFromDataColumn(dictionary: StiDictionary, column: string, useRelationName?: boolean): any;
        static getDataSourceFromDataColumn(dictionary: StiDictionary, column: string): StiDataSource;
        static getColumnNameFromDataColumn(dictionary: StiDictionary, column: string): string;
        static getDataListFromDataColumn(dictionary: StiDictionary, column: string, maxRows?: number, firstPositionInDataSource?: boolean): any[];
        static getDatasFromDataColumn(dictionary: StiDictionary, column: string, maxRows?: number, firstPositionInDataSource?: boolean, useRelationName?: boolean): any[];
        static getDatasFromDataSourceWithExpression(data: any, expression: string, maxRows?: number, firstPositionInDataSource?: boolean): List<string>;
        constructor(nameInSource?: string, name?: string, alias?: string, type?: Stimulsoft.System.Type, key?: string);
    }
}
export namespace Stimulsoft.Report.Components {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import StiDataSource = Stimulsoft.Report.Dictionary.StiDataSource;
    import StiBorder = Stimulsoft.Base.Drawing.StiBorder;
    import StiDataRelation = Stimulsoft.Report.Dictionary.StiDataRelation;
    import Rectangle = Stimulsoft.System.Drawing.Rectangle;
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    import StiComponentId = Stimulsoft.Report.StiComponentId;
    import StiComponent = Stimulsoft.Report.Components.StiComponent;
    import Color = Stimulsoft.System.Drawing.Color;
    import Image = Stimulsoft.System.Drawing.Image;
    import List = Stimulsoft.System.Collections.List;
    class StiSparkline extends StiComponent implements IStiExportImageExtended, IStiDataRelation, IStiBorder, IStiBrush {
        private static implementsStiSparkline;
        implements(): any[];
        meta(): StiMeta[];
        get componentId(): StiComponentId;
        get dataRelation(): StiDataRelation;
        dataRelationName: string;
        getImage(REFzoom: any): Image;
        getImage2(): Image;
        isExportAsImage(format: StiExportFormat): boolean;
        clone(cloneProperties: boolean): StiSparkline;
        brush: StiBrush;
        border: StiBorder;
        get priority(): number;
        get localizedCategory(): string;
        defaultClientRectangle: Rectangle;
        get componentType(): StiComponentType;
        get toolboxPosition(): number;
        toolboxCategory: () => StiToolboxCategory;
        get localizedName(): string;
        helpUrl: () => string;
        createNew: () => StiSparkline;
        fetchValues(): List<any>;
        getDataSource(): StiDataSource;
        private _valueDataColumn;
        get valueDataColumn(): string;
        set valueDataColumn(value: string);
        _values: number[];
        get values(): number[];
        set values(value: number[]);
        get valuesContainer(): string;
        set valuesContainer(value: string);
        type: StiSparklineType;
        showHighLowPoints: boolean;
        showFirstLastPoints: boolean;
        positiveColor: Color;
        negativeColor: Color;
        protected construct(rect?: Rectangle): void;
    }
}
export namespace Stimulsoft.Report.Engine {
    import StiComponent = Stimulsoft.Report.Components.StiComponent;
    class StiComponentBuilder extends StiBuilder {
        setReportVariables(masterComp: StiComponent): void;
        prepare(masterComp: StiComponent): void;
        unPrepare(masterComp: StiComponent): void;
        internalRenderAsync(masterComp: StiComponent): Promise<StiComponent>;
        internalRender(masterComp: StiComponent): StiComponent;
        renderAsync(masterComp: StiComponent): Promise<StiComponent>;
        render(masterComp: StiComponent): StiComponent;
    }
}
export namespace Stimulsoft.Report.Components {
    let IStiPrintIfEmpty: System.Interface<IStiPrintIfEmpty>;
    interface IStiPrintIfEmpty {
        printIfEmpty: boolean;
    }
}
export namespace Stimulsoft.Report.Components {
    import StiDataRelation = Stimulsoft.Report.Dictionary.StiDataRelation;
    let IStiDataRelation: System.Interface<IStiDataRelation>;
    interface IStiDataRelation {
        dataRelation: StiDataRelation;
        dataRelationName: string;
    }
}
export namespace Stimulsoft.Report.Components {
    let IStiSort: System.Interface<IStiSort>;
    interface IStiSort {
        sort: string[];
    }
}
export namespace Stimulsoft.Report.Components {
    let IStiCrossTab: System.Interface<IStiCrossTab>;
    interface IStiCrossTab {
    }
}
export namespace Stimulsoft.Report.Components {
    let IStiFilter: System.Interface<IStiFilter>;
    interface IStiFilter {
        filterMethodHandler: Function;
        filterMode: StiFilterMode;
        filters: StiFiltersCollection;
        filterOn: boolean;
    }
}
export namespace Stimulsoft.Report.Components {
    import StiDataSource = Stimulsoft.Report.Dictionary.StiDataSource;
    let IStiDataSource: System.Interface<IStiDataSource>;
    interface IStiDataSource {
        dataSource: StiDataSource;
        dataSourceName: string;
        isDataSourceEmpty: boolean;
        first(): any;
        prior(): any;
        next(): any;
        last(): any;
        position: number;
        count: number;
        isEof: boolean;
        isBof: boolean;
        isEmpty: boolean;
    }
}
export namespace Stimulsoft.Report.Components {
    import StiBusinessObject = Stimulsoft.Report.Dictionary.StiBusinessObject;
    let IStiBusinessObject: System.Interface<IStiBusinessObject>;
    interface IStiBusinessObject {
        businessObject: StiBusinessObject;
        businessObjectGuid: string;
        isBusinessObjectEmpty: boolean;
        first(): any;
        prior(): any;
        next(): any;
        last(): any;
        position: number;
        count: number;
        isEof: boolean;
        isBof: boolean;
        isEmpty: boolean;
    }
}
export namespace Stimulsoft.Report.Events {
    import EventHandler = Stimulsoft.System.EventHandler;
    import EventArgs = Stimulsoft.System.EventArgs;
    let StiFillParametersEventHandler: EventHandler;
    class StiFillParametersEventArgs extends EventArgs {
        private val;
        get value(): Array<{
            key: string;
            value: any;
        }>;
        set value(value: Array<{
            key: string;
            value: any;
        }>);
        constructor(value?: Array<{
            key: string;
            value: any;
        }>);
    }
}
export namespace Stimulsoft.Report.Components {
    let IStiResetPageNumber: System.Interface<IStiResetPageNumber>;
    interface IStiResetPageNumber {
        resetPageNumber: boolean;
    }
}
export namespace Stimulsoft.Report.Events {
    class StiGetExcelSheetEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Events {
    class StiColumnEndRenderEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Events {
    class StiColumnBeginRenderEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Components {
    import PaperKind = Stimulsoft.System.Drawing.Printing.PaperKind;
    import PaperSize = Stimulsoft.System.Drawing.Printing.PaperSize;
    import SizeD = Stimulsoft.System.Drawing.Size;
    class StiPageHelper {
        static getPaperSizeFromPaperKind(paperKind: PaperKind): PaperSize;
        static getPaperSize(page: StiPage, paperSize: PaperSize): SizeD;
    }
}
export namespace Stimulsoft.Report.Components {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiJson = Stimulsoft.Base.StiJson;
    class StiMargins implements IStiJsonReportObject {
        implements(): any[];
        saveToJsonObject(mode: StiJsonSaveMode, defLeft?: number, defRight?: number, defTop?: number, defBotttom?: number): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        static loadFromText(text: string): StiMargins;
        static loadFromXml(xmlNode: XmlNode): StiMargins;
        clone(): any;
        equals(obj: any): boolean;
        left: number;
        right: number;
        top: number;
        bottom: number;
        get isEmpty(): boolean;
        static get empty(): StiMargins;
        static create(all?: number): StiMargins;
        constructor(left?: number, right?: number, top?: number, bottom?: number);
    }
}
export namespace Stimulsoft.Report.Engine {
    import ICloneable = Stimulsoft.System.ICloneable;
    class StiComponentInfo implements ICloneable {
        implements(): any[];
        clone(): StiComponentInfo;
    }
}
export namespace Stimulsoft.Report.Components {
    import StiComponentInfo = Stimulsoft.Report.Engine.StiComponentInfo;
    class StiPageInfo extends StiComponentInfo {
        overlays: StiComponentsCollection;
        indexOfStartRenderedPages: number;
        masterDataBand: StiDataBand;
        isReportTitlesRendered: boolean;
        renderedCount: number;
        positionFromTop: number;
        positionFromBottom: number;
    }
}
export namespace Stimulsoft.Report.Units {
    import IAsIs = Stimulsoft.System.IAsIs;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiJson = Stimulsoft.Base.StiJson;
    import Rectangle = Stimulsoft.System.Drawing.Rectangle;
    import Size = Stimulsoft.System.Drawing.Size;
    class StiUnit implements IAsIs {
        is<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): this is T;
        is2<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): boolean;
        as<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): T;
        static saveToJsonObject(unit: StiUnit): StiJson;
        static loadFromJsonObject(jObject: StiJson): StiUnit;
        static loadFromXml(xmlNode: XmlNode): StiUnit;
        static getUnitFromReportUnit(reportUnit: StiReportUnitType): StiUnit;
        private static _centimeters;
        static get Centimeters(): StiCentimetersUnit;
        private static _hundredthsOfInch;
        static get HundredthsOfInch(): StiHundredthsOfInchUnit;
        private static _inches;
        static get Inches(): StiInchesUnit;
        private static _millimeters;
        static get Millimeters(): StiMillimetersUnit;
        get rulerStep(): number;
        get factor(): number;
        get shortName(): string;
        get name(): string;
        convertToHInches(value: number): number;
        convertFromHInches(value: number): number;
        convertRectangleToHInches(rect: Rectangle): Rectangle;
        convertRectangleFromHInches(rect: Rectangle): Rectangle;
        convertSizeToHInches(size: Size): Size;
        convertSizeFromHInches(size: Size): Size;
    }
}
export namespace Stimulsoft.Report.Components {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import ContentAlignment = Stimulsoft.System.Drawing.ContentAlignment;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    import Font = Stimulsoft.System.Drawing.Font;
    import StiJson = Stimulsoft.Base.StiJson;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import Image = Stimulsoft.System.Drawing.Image;
    class StiWatermark implements ICloneable, IStiJsonReportObject {
        implements(): any[];
        protected _hash: StiMeta[];
        meta(): StiMeta[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        loadFromXml(xmlNode: XmlNode): void;
        clone(): StiWatermark;
        font: Font;
        textBrush: StiBrush;
        text: string;
        angle: number;
        enabled: boolean;
        showImageBehind: boolean;
        showBehind: boolean;
        rightToLeft: boolean;
        imageMultipleFactor: number;
        private _imageTransparency;
        get imageTransparency(): number;
        set imageTransparency(value: number);
        private _image;
        get image(): Image;
        set image(value: Image);
        private _imageHyperlink;
        get imageHyperlink(): string;
        set imageHyperlink(value: string);
        private cachedImage;
        getImage(report: StiReport): Image;
        imageAlignment: ContentAlignment;
        imageTiling: boolean;
        imageStretch: boolean;
        aspectRatio: boolean;
        enabledExpression: string;
        private getTransparentedImage;
        private disposeCachedImage;
        constructor(textBrush?: StiBrush, text?: string, angle?: number, font?: Font, showBehind?: boolean, enabled?: boolean, aspectRatio?: boolean, rightToLeft?: boolean);
    }
}
export namespace Stimulsoft.Report.Components {
    let IStiBreakable: System.Interface<IStiBreakable>;
    interface IStiBreakable {
        canBreak: boolean;
        break(dividedComponent: StiComponent, devideFactor: number, REFdivideLine: any): boolean;
    }
}
export namespace Stimulsoft.Report.Components {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import IStiBreakable = Stimulsoft.Report.Components.IStiBreakable;
    class StiPanel extends StiContainer implements IStiBreakable, IStiJsonReportObject {
        private static ImplementsStiPanel;
        implements(): any[];
        meta(): StiMeta[];
        rightToLeft: boolean;
        columnGaps: number;
        columnWidth: number;
        columns: number;
        getColumnWidth(): number;
    }
}
export namespace Stimulsoft.Report.Events {
    import EventHandler = Stimulsoft.System.EventHandler;
    import EventArgs = Stimulsoft.System.EventArgs;
    let StiGetExcelSheetEventHandler: EventHandler;
    class StiGetExcelSheetEventArgs extends EventArgs {
        value: string;
    }
}
export namespace Stimulsoft.Report.Components {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiGetExcelSheetEventArgs = Stimulsoft.Report.Events.StiGetExcelSheetEventArgs;
    import StiBeginRenderEvent = Stimulsoft.Report.Events.StiBeginRenderEvent;
    import StiRenderingEvent = Stimulsoft.Report.Events.StiRenderingEvent;
    import StiEndRenderEvent = Stimulsoft.Report.Events.StiEndRenderEvent;
    import StiColumnBeginRenderEvent = Stimulsoft.Report.Events.StiColumnBeginRenderEvent;
    import StiColumnEndRenderEvent = Stimulsoft.Report.Events.StiColumnEndRenderEvent;
    import StiGetExcelSheetEvent = Stimulsoft.Report.Events.StiGetExcelSheetEvent;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiUnit = Stimulsoft.Report.Units.StiUnit;
    import StiShiftMode = Stimulsoft.Report.Components.StiShiftMode;
    import StiMargins = Stimulsoft.Report.Components.StiMargins;
    import StiPageInfo = Stimulsoft.Report.Components.StiPageInfo;
    import StiPageOrientation = Stimulsoft.Report.Components.StiPageOrientation;
    import StiWatermark = Stimulsoft.Report.Components.StiWatermark;
    import PaperKind = Stimulsoft.System.Drawing.Printing.PaperKind;
    import IStiResetPageNumber = Stimulsoft.Report.Components.IStiResetPageNumber;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    import StiComponent = Stimulsoft.Report.Components.StiComponent;
    import IStiReportPage = Stimulsoft.Base.IStiReportPage;
    class StiPage extends StiPanel implements IStiResetPageNumber, IStiReportPage, IStiJsonReportObject {
        private static ImplementsStiPage;
        implements(): any[];
        meta(): StiMeta[];
        loadFromXml(xmlNode: XmlNode): void;
        get componentId(): StiComponentId;
        resetPageNumber: boolean;
        convertToHInches(unit: StiUnit, value: number): number;
        convertFromHInchesRect(unit: StiUnit, rect: RectangleD): RectangleD;
        convertFromHInches(unit: StiUnit, value: number): number;
        convert(oldUnit: StiUnit, newUnit: StiUnit, isReportSnapshot?: boolean): void;
        clone(cloneProperties?: boolean, cloneComponents?: boolean): any;
        parseExpression(text: string, allowReturnNull?: boolean): string;
        private _pageInfo;
        get pageInfo(): StiPageInfo;
        get isAutomaticDock(): boolean;
        get left(): number;
        set left(value: number);
        get top(): number;
        set top(value: number);
        getWidth(): number;
        setWidth(value: number): void;
        getHeight(): number;
        setHeight(value: number): void;
        get right(): number;
        get bottom(): number;
        get clientRectangle(): RectangleD;
        set clientRectangle(value: RectangleD);
        getDisplayRectangle(): RectangleD;
        get shiftMode(): StiShiftMode;
        set shiftMode(value: StiShiftMode);
        get printable(): boolean;
        set printable(value: boolean);
        get page(): StiPage;
        set page(value: StiPage);
        get parent(): StiContainer;
        set parent(value: StiContainer);
        invokeEvents(): void;
        private static eventBeginRender;
        protected onBeginRender(): void;
        invokeBeginRender(): void;
        get beginRenderEvent(): StiBeginRenderEvent;
        set beginRenderEvent(value: StiBeginRenderEvent);
        private static eventRendering;
        protected onRendering(): void;
        invokeRendering(): void;
        get renderingEvent(): StiRenderingEvent;
        set renderingEvent(value: StiRenderingEvent);
        private static eventEndRender;
        protected onEndRender(): void;
        invokeEndRender(): void;
        get endRenderEvent(): StiEndRenderEvent;
        set endRenderEvent(value: StiEndRenderEvent);
        private static eventColumnBeginRender;
        protected onColumnBeginRender(): void;
        invokeColumnBeginRender(sender?: any): void;
        get columnBeginRenderEvent(): StiColumnBeginRenderEvent;
        set columnBeginRenderEvent(value: StiColumnBeginRenderEvent);
        private static eventColumnEndRender;
        protected onColumnEndRender(): void;
        invokeColumnEndRender(sender?: any): void;
        get columnEndRenderEvent(): StiColumnEndRenderEvent;
        set columnEndRenderEvent(value: StiColumnEndRenderEvent);
        private static eventGetExcelSheet;
        protected onGetExcelSheet(e: StiGetExcelSheetEventArgs): void;
        invokeGetExcelSheet(sender: StiComponent, e: StiGetExcelSheetEventArgs): void;
        get getExcelSheetEvent(): StiGetExcelSheetEvent;
        set getExcelSheetEvent(value: StiGetExcelSheetEvent);
        excelSheetValue: string;
        excelSheet: string;
        get zoom(): number;
        get gridSize(): number;
        printOnPreviousPage: boolean;
        printHeadersFootersFromPreviousPage: boolean;
        private _paperSize;
        get paperSize(): PaperKind;
        set paperSize(value: PaperKind);
        paperSourceOfFirstPage: string;
        paperSourceOfOtherPages: string;
        private _watermarkStyle;
        get watermarkStyle(): string;
        set watermarkStyle(value: string);
        private _numberOfCopies;
        get numberOfCopies(): number;
        set numberOfCopies(value: number);
        unlimitedBreakable: boolean;
        largeHeight: boolean;
        private _largeHeightFactor;
        get largeHeightFactor(): number;
        set largeHeightFactor(value: number);
        private _largeHeightAutoFactor;
        get largeHeightAutoFactor(): number;
        set largeHeightAutoFactor(value: number);
        currentWidthSegment: number;
        currentHeightSegment: number;
        stopBeforePrint: number;
        private _skip;
        get skip(): boolean;
        set skip(value: boolean);
        stretchToPrintArea: boolean;
        private _titleBeforeHeader;
        get titleBeforeHeader(): boolean;
        set titleBeforeHeader(value: boolean);
        unlimitedHeight: boolean;
        unlimitedWidth: boolean;
        offsetRectangle: RectangleD;
        private _orientation;
        get orientation(): StiPageOrientation;
        set orientation(value: StiPageOrientation);
        get locked(): boolean;
        set locked(value: boolean);
        get linked(): boolean;
        set linked(value: boolean);
        private _pageWidth;
        get pageWidth(): number;
        set pageWidth(value: number);
        private _pageHeight;
        get pageHeight(): number;
        set pageHeight(value: number);
        private _segmentPerWidth;
        get segmentPerWidth(): number;
        set segmentPerWidth(value: number);
        private _segmentPerHeight;
        get segmentPerHeight(): number;
        set segmentPerHeight(value: number);
        private _watermark;
        get watermark(): StiWatermark;
        set watermark(value: StiWatermark);
        margins: StiMargins;
        mirrorMargins: boolean;
        icon: number[];
        private _report;
        get report(): StiReport;
        set report(value: StiReport);
        get unit(): StiUnit;
        reportUnit: StiUnit;
        drillDownActivated: boolean;
        get isDashboard(): boolean;
        get isPage(): boolean;
        private _cacheGuid;
        get cacheGuid(): string;
        set cacheGuid(value: string);
        newCacheGuid(): void;
        prepare(): void;
        private getIsPageTotalDataBand;
        clearPage(): void;
        private removeNewPageContainers;
        private getComponentsCount2;
        getComponentsCount(): number;
        resizePage(factorX: number, factorY: number, allowPageMarginsRescaling?: boolean): void;
        toString(): string;
        constructor(report?: StiReport, isSuper?: boolean);
        protected construct(report?: StiReport | any): void;
    }
}
export namespace Stimulsoft.Report.Components {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import Color = Stimulsoft.System.Drawing.Color;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiChildBand extends StiDynamicBand implements IStiKeepChildTogether, IStiJsonReportObject {
        implements(): any[];
        meta(): StiMeta[];
        keepChildTogether: boolean;
        get headerStartColor(): Color;
        get headerEndColor(): Color;
        protected getComponentType(): StiComponentType;
        get toolboxPosition(): number;
        get toolboxCategory(): StiToolboxCategory;
        get priority(): number;
        printIfParentDisabled: boolean;
        createNew(): StiComponent;
        getMaster(): StiBand;
        constructor(rect?: RectangleD);
    }
}
export namespace Stimulsoft.Report.Components {
    let IStiRenderMaster: System.Interface<IStiRenderMaster>;
    interface IStiRenderMaster {
        renderMasterAsync(): Promise<void>;
        renderMaster(): void;
    }
}
export namespace Stimulsoft.Report.Engine {
    import StiBand = Stimulsoft.Report.Components.StiBand;
    import StiDataBand = Stimulsoft.Report.Components.StiDataBand;
    import StiSubReport = Stimulsoft.Report.Components.StiSubReport;
    import StiContainer = Stimulsoft.Report.Components.StiContainer;
    class StiSubReportsHelper {
        static getMasterDataBand(parent: StiContainer): StiDataBand;
        static getParentBand(parent: StiContainer): StiBand;
        static renderSubReportAsync(containerOfSubReport: StiContainer, subReport: StiSubReport): Promise<void>;
        static renderSubReport(containerOfSubReport: StiContainer, subReport: StiSubReport): void;
        private static correctComponentRecursive;
        static specialSubReportHeight: number;
        private static renderInternalSubReportAsync;
        private static renderInternalSubReport;
        static renderExternalSubReportsWithoutHelpOfUnlimitedHeightPagesOldMode: boolean;
        private static renderExternalSubReportAsync;
        private static renderExternalSubReport;
        static renderDataBandsInContainerAsync(containerOfDataBands: StiContainer, container: StiContainer, skipStaticBands?: boolean): Promise<void>;
        static renderDataBandsInContainer(containerOfDataBands: StiContainer, container: StiContainer, skipStaticBands?: boolean): void;
    }
}
export namespace Stimulsoft.Report.Styles {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import Color = Stimulsoft.System.Drawing.Color;
    import StiComponent = Stimulsoft.Report.Components.StiComponent;
    class StiCrossTabStyle extends StiBaseStyle implements IStiJsonReportObject {
        meta(): StiMeta[];
        backColor: Color;
        get color(): Color;
        set color(value: Color);
        cellBackColor: Color;
        alternatingCellBackColor: Color;
        alternatingCellForeColor: Color;
        selectedCellBackColor: Color;
        selectedCellForeColor: Color;
        columnHeaderBackColor: Color;
        columnHeaderForeColor: Color;
        rowHeaderBackColor: Color;
        rowHeaderForeColor: Color;
        hotColumnHeaderBackColor: Color;
        hotRowHeaderBackColor: Color;
        cellForeColor: Color;
        lineColor: Color;
        _totalCellColumnBackColor: any;
        get totalCellColumnBackColor(): Color;
        set totalCellColumnBackColor(value: Color);
        _totalCellColumnForeColor: any;
        get totalCellColumnForeColor(): Color;
        set totalCellColumnForeColor(value: Color);
        _totalCellRowBackColor: any;
        get totalCellRowBackColor(): Color;
        set totalCellRowBackColor(value: Color);
        _totalCellRowForeColor: any;
        get totalCellRowForeColor(): Color;
        set totalCellRowForeColor(value: Color);
        getStyleFromComponent(component: StiComponent, styleElements: StiStyleElements): void;
        setStyleToComponent(component: StiComponent): void;
    }
}
export namespace Stimulsoft.Report.CrossTab.Core {
    enum StiSortDirection {
        Asc = 0,
        Desc = 1,
        None = 2
    }
    enum StiSummaryType {
        None = 0,
        Sum = 1,
        Average = 2,
        Min = 3,
        Max = 4,
        Count = 5,
        CountDistinct = 6,
        Image = 7
    }
    enum StiSummaryValues {
        AllValues = 0,
        SkipZerosAndNulls = 1,
        SkipNulls = 2
    }
    enum StiSortType {
        ByValue = 0,
        ByDisplayValue = 1
    }
    enum StiFieldType {
        Column = 0,
        Row = 1,
        Cell = 2
    }
    enum StiSummaryDirection {
        LeftToRight = 0,
        UpToDown = 1
    }
    enum StiEnumeratorType {
        None = 0,
        Arabic = 1,
        Roman = 2,
        ABC = 3
    }
    enum StiEnumeratorSeparator {
        Dot = 0,
        Dash = 1,
        Colon = 2,
        RoundBrackets = 3,
        SquareBrackets = 4
    }
    enum StiCellType {
        HeaderCol = 0,
        HeaderColMain = 1,
        HeaderColTotal = 2,
        HeaderColTotalMain = 3,
        HeaderColSummary = 4,
        HeaderColSummaryTotal = 5,
        HeaderRow = 6,
        HeaderRowMain = 7,
        HeaderRowTotal = 8,
        HeaderRowTotalMain = 9,
        HeaderRowSummary = 10,
        HeaderRowSummaryTotal = 11,
        Cell = 12,
        CellTotal = 13,
        LeftTopLine = 14,
        LeftTopLineMain = 15,
        RightTopLine = 16,
        RightTopLineMain = 17,
        CornerCol = 18,
        CornerColMain = 19,
        CornerRow = 20,
        CornerRowMain = 21
    }
}
export namespace Stimulsoft.Report.Components {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiJson = Stimulsoft.Base.StiJson;
    import ICloneable = Stimulsoft.System.ICloneable;
    class StiFilter implements ICloneable, IStiJsonReportObject {
        implements(): any[];
        protected _hash: StiMeta[];
        meta(): StiMeta[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        loadFromXml(xmlNode: XmlNode): void;
        clone(): StiFilter;
        condition: StiFilterCondition;
        dataType: StiFilterDataType;
        column: string;
        item: StiFilterItem;
        private valueObj1;
        get value1(): string;
        set value1(value: string);
        private valueObj2;
        get value2(): string;
        set value2(value: string);
        expression: string;
        constructor(item?: StiFilterItem, column?: string, condition?: StiFilterCondition, value1?: string, value2?: string, dataType?: StiFilterDataType, expression?: string);
    }
}
export namespace Stimulsoft.Report.CrossTab {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiDataRelation = Stimulsoft.Report.Dictionary.StiDataRelation;
    import StiComponentType = Stimulsoft.Report.Components.StiComponentType;
    import Color = Stimulsoft.System.Drawing.Color;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    import StiBusinessObject = Stimulsoft.Report.Dictionary.StiBusinessObject;
    import StiDataSource = Stimulsoft.Report.Dictionary.StiDataSource;
    import StiUnit = Stimulsoft.Report.Units.StiUnit;
    import StiSummaryDirection = Stimulsoft.Report.CrossTab.Core.StiSummaryDirection;
    import StiFilterMode = Stimulsoft.Report.Components.StiFilterMode;
    import StiFilterEngine = Stimulsoft.Report.Components.StiFilterEngine;
    import StiComponent = Stimulsoft.Report.Components.StiComponent;
    import StiContainer = Stimulsoft.Report.Components.StiContainer;
    import IStiDataSource = Stimulsoft.Report.Components.IStiDataSource;
    import IStiFilter = Stimulsoft.Report.Components.IStiFilter;
    import IStiCrossTab = Stimulsoft.Report.Components.IStiCrossTab;
    import IStiSort = Stimulsoft.Report.Components.IStiSort;
    import IStiDataRelation = Stimulsoft.Report.Components.IStiDataRelation;
    import IStiPrintIfEmpty = Stimulsoft.Report.Components.IStiPrintIfEmpty;
    import IStiBusinessObject = Stimulsoft.Report.Components.IStiBusinessObject;
    class StiCrossTab extends StiContainer implements IStiDataSource, IStiFilter, IStiCrossTab, IStiSort, IStiDataRelation, IStiPrintIfEmpty, IStiBusinessObject, IStiJsonReportObject {
        private static ImplementsStiCrossTab;
        implements(): any[];
        meta(): StiMeta[];
        get componentId(): StiComponentId;
        get helpUrl(): string;
        convert(oldUnit: StiUnit, newUnit: StiUnit, isReportSnapshot?: boolean): void;
        printIfEmpty: boolean;
        get dataRelation(): StiDataRelation;
        dataRelationName: string;
        get dataSource(): StiDataSource;
        private _dataSourceName;
        get dataSourceName(): string;
        set dataSourceName(value: string);
        get isDataSourceEmpty(): boolean;
        get isBusinessObjectEmpty(): boolean;
        get businessObject(): StiBusinessObject;
        private _businessObjectGuid;
        get businessObjectGuid(): string;
        set businessObjectGuid(value: string);
        private _sort;
        get sort(): string[];
        set sort(value: string[]);
        get canBreak(): boolean;
        set canBreak(value: boolean);
        first(): void;
        prior(): void;
        next(): void;
        last(): void;
        get isEof(): boolean;
        set isEof(value: boolean);
        get isBof(): boolean;
        set isBof(value: boolean);
        get isEmpty(): boolean;
        get position(): number;
        set position(value: number);
        get count(): number;
        clone(): StiCrossTab;
        packService(): void;
        crossTabInfo: StiCrossTabInfo;
        filterEngine: StiFilterEngine;
        filterMode: StiFilterMode;
        filterMethodHandler: Function;
        private _filters;
        get filters(): Stimulsoft.Report.Components.StiFiltersCollection;
        set filters(value: Stimulsoft.Report.Components.StiFiltersCollection);
        get filter(): string;
        set filter(value: string);
        filterOn: boolean;
        canContainIn(component: StiComponent): boolean;
        get localizedCategory(): string;
        get priority(): number;
        defaultClientRectangle: RectangleD;
        get componentType(): StiComponentType;
        get localizedName(): string;
        private _crossTabStyleIndex;
        get crossTabStyleIndex(): number;
        set crossTabStyleIndex(value: number);
        crossTabStyleColor: any;
        get crossTabStyle(): string;
        set crossTabStyle(value: string);
        setComponentStyle(value: string): void;
        updateStyles(): void;
        getCellColor(): Color;
        applyFieldStyle(field: StiCrossField): void;
        horAlignment: StiCrossHorAlignment;
        printTitleOnAllPages: boolean;
        summaryDirection: StiSummaryDirection;
        keepCrossTabTogether: boolean;
        emptyValue: string;
        wrap: boolean;
        wrapGap: number;
        private _rightToLeft;
        get rightToLeft(): boolean;
        set rightToLeft(value: boolean);
        createNew(): StiComponent;
        constructor(rect?: RectangleD);
    }
}
export namespace Stimulsoft.Report.Events {
    class StiGetSummaryExpressionEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Events {
    class StiGetGroupConditionEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Components {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import StiGetSummaryExpressionEvent = Stimulsoft.Report.Events.StiGetSummaryExpressionEvent;
    import StiGetGroupConditionEvent = Stimulsoft.Report.Events.StiGetGroupConditionEvent;
    import StiGetCollapsedEvent = Stimulsoft.Report.Events.StiGetCollapsedEvent;
    import StiBeginRenderEvent = Stimulsoft.Report.Events.StiBeginRenderEvent;
    import StiRenderingEvent = Stimulsoft.Report.Events.StiRenderingEvent;
    import StiEndRenderEvent = Stimulsoft.Report.Events.StiEndRenderEvent;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import Color = Stimulsoft.System.Drawing.Color;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    import StiValueEventArgs = Stimulsoft.Report.Events.StiValueEventArgs;
    class StiGroupHeaderBand extends StiDynamicBand implements IStiGroup, IStiPrintOnAllPages, IStiKeepGroupTogether, IStiJsonReportObject {
        implements(): any[];
        meta(): StiMeta[];
        clone(cloneProperties: boolean, cloneComponents: boolean): StiGroupHeaderBand;
        keepGroupHeaderTogether: boolean;
        keepGroupTogether: boolean;
        private _startNewPage;
        get startNewPage(): boolean;
        set startNewPage(value: boolean);
        get startNewPageIfLessThan(): number;
        set startNewPageIfLessThan(value: number);
        saveState(stateName: string): void;
        restoreState(stateName: string): void;
        get headerStartColor(): Color;
        get headerEndColor(): Color;
        sortDirection: StiGroupSortDirection;
        summarySortDirection: StiGroupSortDirection;
        summaryType: StiGroupSummaryType;
        private _printOnAllPages;
        get printOnAllPages(): boolean;
        set printOnAllPages(value: boolean);
        private _groupHeaderBandInfo;
        get groupHeaderBandInfo(): StiGroupHeaderBandInfo;
        get toolboxPosition(): number;
        get toolboxCategory(): StiToolboxCategory;
        protected getComponentType(): StiComponentType;
        get priority(): number;
        getDataBand(): StiDataBand;
        line: number;
        private static eventGetSummaryExpression;
        protected onGetSummaryExpression(e: StiValueEventArgs): void;
        invokeGetSummaryExpression(e: StiValueEventArgs): void;
        get getSummaryExpressionEvent(): StiGetSummaryExpressionEvent;
        set getSummaryExpressionEvent(value: StiGetSummaryExpressionEvent);
        private static eventGetValue;
        protected onGetValue(e: StiValueEventArgs): void;
        invokeGetValue(e: StiValueEventArgs): void;
        get getValueEvent(): StiGetGroupConditionEvent;
        set getValueEvent(value: StiGetGroupConditionEvent);
        private static eventGetCollapsed;
        protected onGetCollapsed(e: StiValueEventArgs): void;
        invokeGetCollapsed(e: StiValueEventArgs): void;
        get getCollapsedEvent(): StiGetCollapsedEvent;
        set getCollapsedEvent(value: StiGetCollapsedEvent);
        private static eventBeginRender;
        protected onBeginRender(): void;
        invokeBeginRender(): void;
        get beginRenderEvent(): StiBeginRenderEvent;
        set beginRenderEvent(value: StiBeginRenderEvent);
        private static eventRendering;
        protected onRendering(): void;
        invokeRendering(): void;
        get renderingEvent(): StiRenderingEvent;
        set renderingEvent(value: StiRenderingEvent);
        private static eventEndRender;
        protected onEndRender(): void;
        invokeEndRender(): void;
        get endRenderEvent(): StiEndRenderEvent;
        set endRenderEvent(value: StiEndRenderEvent);
        private _condition;
        get condition(): string;
        set condition(value: string);
        private _summaryExpression;
        get summaryExpression(): string;
        set summaryExpression(value: string);
        private _collapsed;
        get collapsed(): string;
        set collapsed(value: string);
        getHeaderText(): string;
        createNew(): StiComponent;
        getCurrentConditionValue(): any;
        constructor(rect?: RectangleD);
    }
}
export namespace Stimulsoft.Report.Engine {
    import StiComponent = Stimulsoft.Report.Components.StiComponent;
    import StiContainer = Stimulsoft.Report.Components.StiContainer;
    class StiContainerBuilder extends StiComponentBuilder {
        static getRenderContainer(comp: StiComponent, type?: Stimulsoft.System.Type): StiContainer;
        internalRenderAsync(masterComp: StiComponent): Promise<StiComponent>;
        internalRender(masterComp: StiComponent): StiComponent;
    }
}
export namespace Stimulsoft.Report.Engine {
    import StiBand = Stimulsoft.Report.Components.StiBand;
    import StiComponent = Stimulsoft.Report.Components.StiComponent;
    import StiComponentsCollection = Stimulsoft.Report.Components.StiComponentsCollection;
    class StiBandBuilder extends StiContainerBuilder {
        static getChildBands(masterBand: StiBand): StiComponentsCollection;
        static getSubReports(masterBand: StiBand): StiComponentsCollection;
        prepare(masterComp: StiComponent): void;
    }
}
export namespace Stimulsoft.Report.Engine {
    import StiGroupHeaderBand = Stimulsoft.Report.Components.StiGroupHeaderBand;
    import StiDataBand = Stimulsoft.Report.Components.StiDataBand;
    import StiComponent = Stimulsoft.Report.Components.StiComponent;
    class StiGroupHeaderBandBuilder extends StiBandBuilder {
        static getMaster(masterGroupHeaderBand: StiGroupHeaderBand): StiDataBand;
        static getCurrentConditionValue(masterGroupHeaderBand: StiGroupHeaderBand): any;
        static getCurrentSummaryExpressionValue(masterGroupHeaderBand: StiGroupHeaderBand): any;
        setReportVariables(masterComp: StiComponent): void;
        prepare(masterComp: StiComponent): void;
    }
}
export namespace Stimulsoft.Report.Components {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import Color = Stimulsoft.System.Drawing.Color;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiHierarchicalBand extends StiDataBand implements IStiJsonReportObject {
        implements(): any[];
        meta(): StiMeta[];
        get toolboxPosition(): number;
        get toolboxCategory(): StiToolboxCategory;
        get headerStartColor(): Color;
        get headerEndColor(): Color;
        keyDataColumn: string;
        masterKeyDataColumn: string;
        parentValue: string;
        indent: number;
        headers: string;
        footers: string;
        private _hierarchicalBandInfo;
        get hierarchicalBandInfo(): StiHierarchicalBandInfo;
        createNew(): StiComponent;
        constructor(rect?: RectangleD);
    }
}
export namespace Stimulsoft.Report.Dictionary {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiAppCell = Stimulsoft.Base.IStiAppCell;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import DataRow = Stimulsoft.System.Data.DataRow;
    import StiDataBand = Stimulsoft.Report.Components.StiDataBand;
    import StiComponent = Stimulsoft.Report.Components.StiComponent;
    import DataTable = Stimulsoft.System.Data.DataTable;
    import Type = Stimulsoft.System.Type;
    import ICloneable = Stimulsoft.System.ICloneable;
    import List = Stimulsoft.System.Collections.List;
    import IEnumerator = Stimulsoft.System.Collections.IEnumerator;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import Hashtable = Stimulsoft.System.Collections.Hashtable;
    import StiJson = Stimulsoft.Base.StiJson;
    import StiDataCollection = Stimulsoft.Report.Dictionary.StiDataCollection;
    import StiComponentsCollection = Stimulsoft.Report.Components.StiComponentsCollection;
    import StiPromise = Stimulsoft.System.StiPromise;
    import IStiAppDictionary = Stimulsoft.Base.IStiAppDictionary;
    import IStiAppDataSource = Stimulsoft.Base.IStiAppDataSource;
    import IStiAppDataColumn = Stimulsoft.Base.IStiAppDataColumn;
    import IStiAppConnection = Stimulsoft.Base.IStiAppConnection;
    import IStiAppDataRelation = Stimulsoft.Base.IStiAppDataRelation;
    class StiDataSource implements ICloneable, IStiAppCell, IStiAppDataSource, IStiStateSaveRestore, IStiEnumerator, IStiName, IStiAlias, IStiInherited, IStiJsonReportObject {
        implements(): any[];
        is<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): this is T;
        is2<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): boolean;
        as<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): T;
        protected _hash: StiMeta[];
        meta(): StiMeta[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        loadFromXml(xmlNode: XmlNode): void;
        getNameInSource(): string;
        getName(): string;
        getDataTable2(allowConnectToData: boolean): Promise<DataTable>;
        private connectSqlSource;
        getDictionary(): IStiAppDictionary;
        fetchColumns(): List<IStiAppDataColumn>;
        getConnection(): IStiAppConnection;
        fetchParentRelations(activePreferred: boolean): List<IStiAppDataRelation>;
        fetchChildRelations(activePreferred: boolean): List<IStiAppDataRelation>;
        fetchColumnValues(names: List<string>): List<any[]>;
        fetchColumnValuesAsync(names: List<string>): Promise<List<any[]>>;
        getKey(): string;
        setKey(key: string): void;
        inherited: boolean;
        get current(): any;
        moveNext(): boolean;
        reset(): void;
        getEnumerator(): IEnumerator;
        private _name;
        get name(): string;
        set name(value: string);
        protected positionValue: number;
        get position(): number;
        set position(value: number);
        get realCount(): number;
        get count(): number;
        protected isBofValue: boolean;
        get isBof(): boolean;
        set isBof(value: boolean);
        protected isEofValue: boolean;
        get isEof(): boolean;
        set isEof(value: boolean);
        get isEmpty(): boolean;
        firstAsync(): Promise<void>;
        first(): void;
        prior(): void;
        nextAsync(): Promise<void>;
        next(): void;
        last(): void;
        clone(): StiDataSource;
        memberwiseClone(): StiDataSource;
        private _states;
        protected get states(): StiStatesManager;
        saveState(stateName: string): void;
        restoreState(stateName: string): void;
        clearAllStates(): void;
        private nameOfDataBandWhichInitDataSource;
        isInited: boolean;
        initForSubreport: boolean;
        xmlRefAttrValue: string;
        private relationNameStored;
        private resFilterMethod;
        private resSortColumns;
        private isEqualSort;
        setDataAsync(dataBand: StiDataBand, relationName: string, filterMethod: any, sortColumns: string[], reinit: boolean, component: StiComponent, allowReconnectOnEachRow?: boolean): Promise<void>;
        setData(dataBand: StiDataBand, relationName: string, filterMethod: any, sortColumns: string[], reinit: boolean, component: StiComponent, allowReconnectOnEachRow?: boolean): void;
        private filtersEqual;
        getConditions(dataBand: StiDataBand): any[][][];
        setDetailsAsync(relationName: string): Promise<void>;
        setDetails(relationName: string): void;
        setFilter(filterMethod: any): void;
        setSort(conditions: any[][][], sortColumns: string[], component: StiComponent, databand: StiDataBand, groupHeaders: StiComponentsCollection): void;
        resetDetailsRows(): void;
        resetData(): void;
        getDataRow(index: number): DataRow;
        getParentData(relation: string): StiDataRow;
        getParentRelations(): Stimulsoft.Report.Dictionary.StiDataRelationsCollection;
        getChildRelations(): Stimulsoft.Report.Dictionary.StiDataRelationsCollection;
        getParentDataSource(relationName: string, allowRelationName?: boolean): StiDataSource;
        getChildDataSource(relationName: string): StiDataSource;
        parseSqlQuery(baseSqlCommand: string, dataSource: StiSqlSource): string;
        protected invokeConnecting(): void;
        protected invokeDisconnecting(): void;
        connectAsync(datas: StiDataCollection, loadData: boolean): StiPromise<void>;
        connect(datas: StiDataCollection, loadData: boolean): void;
        protected getDataAdapterType(): Type;
        fillColumns(): void;
        getDataAdapter(): StiDataAdapterService;
        parameters: StiDataParametersCollection;
        getDataTable(table?: DataTable): DataTable;
        getByName(columnName: string): any;
        GetData(columnName: string, index?: number): any;
        getData(columnName: string, index?: number): any;
        getDataAsync(columnName: string, index?: number): Promise<any>;
        getColumnIndex(columnName: string): number;
        rows: StiRowsCollection;
        columnsIndexs: Hashtable;
        calcColumns: Hashtable;
        detailRows: DataRow[];
        rowToLevel: Hashtable;
        synchronizeColumns(): void;
        checkColumnsIndexs(): void;
        toString(): string;
        getLevel(): number;
        getCategoryName(): string;
        createNew(): StiDataSource;
        private _isCloud;
        get isCloud(): boolean;
        dictionary: StiDictionary;
        private _dataTable;
        get dataTable(): Stimulsoft.System.Data.DataTable;
        set dataTable(value: Stimulsoft.System.Data.DataTable);
        get isConnected(): boolean;
        private _columns;
        get columns(): StiDataColumnsCollection;
        set columns(value: StiDataColumnsCollection);
        connectionOrder: number;
        disconnect(): void;
        connectOnStart: boolean;
        getByColumnName(columnName: string): any;
        alias: string;
        key: string;
        parentRelationList(activePreferred?: boolean): List<StiDataRelation>;
        childRelationList(activePreferred?: boolean): List<StiDataRelation>;
        constructor(name: string, alias: string, key?: string);
    }
}
export namespace Stimulsoft.Report.Func {
    import StiBusinessObject = Stimulsoft.Report.Dictionary.StiBusinessObject;
    import StiDataSource = Stimulsoft.Report.Dictionary.StiDataSource;
    import CultureInfo = Stimulsoft.System.Globalization.CultureInfo;
    import ResourceManager = Stimulsoft.System.ResourceManager;
    import DateTime = Stimulsoft.System.DateTime;
    enum Gender {
        Masculine = 0,
        Feminine = 1,
        Neutral = 2
    }
    class BaseCurrency {
        get gender(): Gender;
        get centsGender(): Gender;
    }
    class Currency extends BaseCurrency {
        get dollars(): string[];
        get cents(): string[];
        get dollarOne(): string;
        get dollarTwo(): string;
        get dollarFive(): string;
        get centOne(): string;
        get centTwo(): string;
        get centFive(): string;
    }
    class NumToWordHelper {
        static maxValue: number;
        private static addWord;
        static addWords(integerString: string, decimalString: string, mainCurrency: string, centCurrency: string, postCurrency: string): string;
        static determinateCurrencies(culture: CultureInfo, currencyISO: string, integerPart: number, decimalPart: number, REFmainCurrency: any, REFcentCurrency: any): void;
    }
    function NumToWordException(message: string, num: number): string;
    class Resource {
        private static resourceMan;
        private static resourceCulture;
        static get resourceManager(): ResourceManager;
        static get culture(): CultureInfo;
        static set culture(value: CultureInfo);
        static get eurBigSeparator(): string;
        static get eurCentGender(): string;
        static get eurCentPlural(): string;
        static get EURCentSingle(): string;
        static get EURGender(): string;
        static get EURPlural(): string;
        static get EURSingle(): string;
        static get GBPBigSeparator(): string;
        static get GBPCentGender(): string;
        static get GBPCentPlural(): string;
        static get GBPCentSingle(): string;
        static get GBPGender(): string;
        static get GBPPlural(): string;
        static get GBPSingle(): string;
        static get TooLongError(): string;
    }
    class Convert {
        static toRoman(value: number): string;
        static toABC(value: number): string;
        static toABCNumeric(value: number): string;
        static toABCRu(value: number): string;
        static toArabic(value: number | string, useEasternDigits: boolean): string;
    }
    class EngineHelper {
        static joinColumnContent(source: StiBusinessObject | StiDataSource, columnName: string, delimiter: string, distinct?: boolean): string;
        static toQueryString<T>(list: T[], quotationMark: string, dateTimeFormat: string, needEscape?: boolean): string;
        static getRealPageNumber(sender: object): number;
    }
    class MonthToStr {
        private static months;
        private static defaultUpperCaseList;
        private static cultureIndexes;
        static monthName(dateTime: DateTime, cultureOrIsLocalized?: string | boolean, upperCase?: boolean): string;
        static addCulture(monthsNames: string[], cultureNames: string[], defaultUpperCase: boolean): void;
        static MonthToStr(): void;
    }
    class DayOfWeekToStr {
        private static days;
        private static defaultUpperCaseList;
        private static cultureIndexes;
        static dayOfWeek(date: DateTime, cultureOrLocalized?: string | boolean, upperCase?: boolean): string;
        static addCulture(monthsNames: string[], cultureNames: string[], defaultUpperCase: boolean): void;
        static DayOfWeekToStr(): void;
    }
}
export namespace Stimulsoft.Report {
    let IStiAlias: System.Interface<IStiName>;
    interface IStiAlias {
        alias: string;
    }
}
export namespace Stimulsoft.Report {
    let IStiIgnoryStyle: System.Interface<IStiIgnoryStyle>;
    interface IStiIgnoryStyle {
    }
}
export namespace Stimulsoft.Report {
    let IStiInherited: System.Interface<IStiInherited>;
    interface IStiInherited {
        inherited: boolean;
    }
}
export namespace Stimulsoft.Report {
    let IStiName: System.Interface<IStiName>;
    interface IStiName {
        name: string;
    }
}
export namespace Stimulsoft.Report {
    let IStiStateSaveRestore: System.Interface<IStiStateSaveRestore>;
    interface IStiStateSaveRestore {
        saveState(stateName: string): any;
        restoreState(stateName: string): any;
        clearAllStates(): any;
    }
}
export namespace Stimulsoft.Report {
    class StiCells {
        clear(): void;
        private getRow;
        private rows;
        gett(x: number, y: number): number;
        distX: number;
        distY: number;
        setCell(x: number, y: number, value: number): void;
        private report;
        constructor(report: StiReport);
    }
}
export namespace Stimulsoft.Report.Components {
    class StiBaseCondition extends StiFilter {
        implements(): any[];
        tag: any;
        constructor(item?: StiFilterItem, column?: string, condition?: StiFilterCondition, value1?: string, value2?: string, dataType?: StiFilterDataType, expression?: string);
    }
}
export namespace Stimulsoft.Report {
    import StiConditionsCollection = Stimulsoft.Report.Components.StiConditionsCollection;
    import Hashtable = Stimulsoft.System.Collections.Hashtable;
    import StiComponentsCollection = Stimulsoft.Report.Components.StiComponentsCollection;
    class StiConditionsHelper {
        static getConditions(comps: StiComponentsCollection, REFglobalConditions?: any): StiConditionsCollection;
        static setConditions(comps: StiComponentsCollection, conditions: StiConditionsCollection, globalConditions: Hashtable): void;
        private static setConditionAllComponents;
    }
}
export namespace Stimulsoft.Report {
    class StiDpiHelper {
        private static LOGPIXELSX;
        private static LOGPIXELSY;
        private static _deviceCapsDpi;
        private static _graphicsDpi;
        private static _graphicsRichTextDpi;
        static get deviceCapsDpi(): number;
        static get graphicsDpi(): number;
        static get graphicsRichTextDpi(): number;
        private static getDpi;
        private static getRegistryValue;
        static get deviceCapsScale(): number;
        static get graphicsScale(): number;
        static get graphicsRichTextScale(): number;
        static get needDeviceCapsScale(): boolean;
        static get needGraphicsScale(): boolean;
        static get needGraphicsRichTextScale(): boolean;
    }
}
export namespace Stimulsoft.Report {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    class StiEditableItem {
        pageIndex: number;
        position: number;
        componentName: string;
        textValue: string;
        constructor(pageIndex: number, position: number, componentName: string, textValue: string);
    }
    class StiEditableItemsContainer {
        loadFromXml(xmlNode: XmlNode): void;
        saveToXml(): string;
        items: StiEditableItem[];
    }
}
export namespace Stimulsoft.Report {
    import Image = Stimulsoft.System.Drawing.Image;
    class StiFileImageCache {
        static getImageCacheName(report: StiReport, cacheImageGuid: string): string;
        static saveImage(report: StiReport, image: Image, path: string): void;
        static loadImage(report: StiReport, path: string): Image;
        static exist(report: StiReport, cacheGuid: string): boolean;
        static clear(report: StiReport): void;
        static remove(report: StiReport, path: string): void;
    }
}
export namespace Stimulsoft.Report {
    import Image = Stimulsoft.System.Drawing.Image;
    class StiImageCache {
        imageStore: Image[];
        imagePackedStore: number[][];
        imageMaskStore: number[][];
        imageIndex: number[];
        imageFormatStore: ImageFormat[];
        private imageHashTable;
        private _useImageComparer;
        private _useImageCompression;
        private _useImageTransparency;
        private _imageSaveFormat;
        private _imageQuality;
        private static crcSeed;
        private static crcTable;
        clear(): void;
        addImageIntRaw(image: Image, imageFormat: Stimulsoft.System.Drawing.Imaging.ImageFormat): number;
        addImageInt(image: Image, imageFormat?: ImageFormat): number;
        constructor(useImageComparer: boolean, useImageCompression?: boolean, imageFormat?: ImageFormat, imageQuality?: number, useImageTransparency?: boolean);
    }
}
export namespace Stimulsoft.Report.Dictionary {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import CollectionBase = Stimulsoft.System.Collections.CollectionBase;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiJson = Stimulsoft.Base.StiJson;
    class StiDatabaseCollection extends CollectionBase<StiDatabase> implements ICloneable, IStiJsonReportObject {
        implements(): any[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        loadFromXml(xmlNode: XmlNode): void;
        indexOf(data: StiDatabase | string): number;
        remove(param: StiDatabase | string | any): void;
        getByName(name: string): StiDatabase;
        setByName(name: string, value: StiDatabase): void;
        clone(): StiDatabaseCollection;
        memberwiseClone(): StiDatabaseCollection;
        private dictionary;
        constructor(dictionary: StiDictionary);
    }
}
export namespace Stimulsoft.Report.Dictionary {
    enum StiVariableInitBy {
        Value = 0,
        Expression = 1
    }
    enum StiVariableSortField {
        Key = 0,
        Label = 1
    }
    enum StiVariableSortDirection {
        None = 0,
        Asc = 1,
        Desc = 2
    }
    enum StiDateTimeType {
        Date = 0,
        DateAndTime = 1,
        Time = 2
    }
    enum StiItemsInitializationType {
        Items = 0,
        Columns = 1
    }
    enum StiTypeMode {
        Value = 0,
        NullableValue = 1,
        List = 2,
        Range = 3
    }
    enum StiSortOrder {
        Asc = 0,
        Desc = 1
    }
    enum StiAutoSynchronizeMode {
        None = 0,
        IfDictionaryEmpty = 1,
        Always = 2
    }
    enum StiRestrictionTypes {
        None = 0,
        DenyEdit = 1,
        DenyDelete = 2,
        DenyMove = 4,
        DenyShow = 8
    }
    enum StiDataType {
        BusinessObject = 0,
        DataSource = 1,
        DataRelation = 2,
        DataColumn = 3,
        Database = 4,
        Resource = 5,
        Variable = 6,
        Total = 7
    }
    enum StiTotalEvent {
        Never = 0,
        OnEachRecord = 1,
        OnGroupChanged = 2,
        OnPageChanged = 3,
        OnColumnChanged = 4,
        OnEachNewBand = 5,
        OnExpressionChanged = 6
    }
    enum StiResourceType {
        Image = 0,
        Csv = 1,
        Dbf = 2,
        Json = 3,
        Xml = 4,
        Xsd = 5,
        Excel = 6,
        Rtf = 7,
        Txt = 8,
        Report = 9,
        ReportSnapshot = 10,
        FontTtc = 11,
        FontTtf = 12,
        FontOtf = 13,
        FontEot = 14,
        FontWoff = 15,
        Pdf = 16,
        Word = 17,
        Map = 18,
        Gis = 19
    }
    enum StiPropertiesProcessingType {
        All = 0,
        Browsable = 1
    }
    enum StiFieldsProcessingType {
        All = 0,
        Browsable = 1
    }
    enum StiConnectionOrder {
        None = 0,
        Standard = 1,
        Sql = 2
    }
    enum StiSqlSourceType {
        Table = 0,
        StoredProcedure = 1
    }
    enum StiColumnsSynchronizationMode {
        KeepAbsentColumns = 0,
        RemoveAbsentColumns = 1
    }
    enum StiSelectionMode {
        FromVariable = 0,
        Nothing = 1,
        First = 2
    }
}
export namespace Stimulsoft.Report.Dictionary {
    import Type = Stimulsoft.System.Type;
    import StiService = Stimulsoft.Base.Services.StiService;
    import StiPromise = Stimulsoft.System.StiPromise;
    class StiDataAdapterService extends StiService {
        get serviceCategory(): string;
        get serviceType(): Type;
        isObjectAdapter: boolean;
        get name(): string;
        getDatabaseSpecificName(name: string): string;
        getDataCategoryName(data: StiData): string;
        static getDataAdapter(dataSource: StiDataSource): StiDataAdapterService;
        static getDataAdapter2(data: StiData): StiDataAdapterService;
        create(dictionary: StiDictionary, addToDictionary?: boolean): StiDataSource;
        getDataSourceType(): Type;
        getDataTypes(): Type[];
        isAdapterDataType(type: Type): boolean;
        getColumnsFromDataAsync(data: StiData, dataSource: StiDataSource, connectionString: string): StiPromise<StiDataColumnsCollection>;
        getColumnsFromData(data: StiData, dataSource: StiDataSource, connectionString: string): StiDataColumnsCollection;
        getParametersFromDataAsync(data: StiData, dataSource: StiDataSource, connectionString: string): StiPromise<StiDataParametersCollection>;
        setDataSourceNames(data: StiData, dataSource: StiDataSource): void;
        connectDataSourceToDataAsync(dictionary: StiDictionary, dataSource: StiDataSource, loadData: boolean): StiPromise<void>;
        connectDataSourceToData(dictionary: StiDictionary, dataSource: StiDataSource, loadData: boolean): void;
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    class StiDataStoreSource extends StiDataSource implements IStiJsonReportObject {
        meta(): StiMeta[];
        getCategoryName(): string;
        get dataName(): string;
        set dataName(value: string);
        nameInSource: string;
        constructor(nameInSource?: string, name?: string, alias?: string, key?: string);
    }
}
export namespace Stimulsoft.Report.Dictionary {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import Type = Stimulsoft.System.Type;
    class StiDataTableSource extends StiDataStoreSource implements IStiJsonReportObject {
        meta(): StiMeta[];
        getCategoryName(): string;
        getDataAdapterType(): Type;
        get componentId(): StiComponentId;
        createNew(): StiDataSource;
        constructor(nameInSource?: string, name?: string, alias?: string, key?: string);
    }
}
export namespace Stimulsoft.Report.Dictionary {
    class StiUndefinedDataSource extends StiDataTableSource {
        createNew(): StiDataSource;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import CollectionBase = Stimulsoft.System.Collections.CollectionBase;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IComparer = Stimulsoft.System.Collections.IComparer;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiJson = Stimulsoft.Base.StiJson;
    import StiPromise = Stimulsoft.System.StiPromise;
    import List = Stimulsoft.System.Collections.List;
    class StiDataSourcesCollection extends CollectionBase<StiDataSource> implements IStiJsonReportObject, ICloneable, IComparer<any> {
        implements(): any[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        loadFromXml(xmlNode: XmlNode): void;
        private dictionary;
        private directionFactor;
        compare(x: any, y: any): number;
        cachedDataSources: {
            [name: string]: StiDataSource;
        };
        fetchAllDataTransformations(): List<StiDataTransformation>;
        fetchAllVirtualDataSources(): List<StiVirtualSource>;
        add(dataSource: StiDataSource): void;
        contains(dataSource: StiDataSource | string): boolean;
        remove(dataSource: StiDataSource): void;
        getByName(name: string): StiDataSource;
        getByXmlRef(xmlRef: string): StiDataSource;
        setByName(name: string, value: StiDataSource): void;
        clone(): any;
        sort(order?: StiSortOrder, sortColumns?: boolean): void;
        clearParametersExpression(): void;
        connectAsync(loadData: boolean, datas?: StiDataCollection): StiPromise<void>;
        connect(loadData: boolean, datas?: StiDataCollection): void;
        disconnect(): void;
        constructor(dictionary: StiDictionary);
    }
}
export namespace Stimulsoft.Report.Dictionary {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import CollectionBase = Stimulsoft.System.Collections.CollectionBase;
    import Hashtable = Stimulsoft.System.Collections.Hashtable;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiJson = Stimulsoft.Base.StiJson;
    import ICloneable = Stimulsoft.System.ICloneable;
    class StiDataRelationsCollection extends CollectionBase<StiDataRelation> implements ICloneable, IStiJsonReportObject {
        implements(): any[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        loadFromXml(xmlNode: XmlNode): void;
        clone(): StiDataRelationsCollection;
        private dictionary;
        cachedDataRelations: Hashtable;
        add(relation: StiDataRelation): void;
        contains(relation: StiDataRelation | string): boolean;
        remove(relation: StiDataRelation): void;
        setByIndex(index: number, value: StiDataRelation): void;
        getByName(name: string): StiDataRelation;
        setByName(name: string, value: StiDataRelation): void;
        constructor(dictionary: StiDictionary);
    }
}
export namespace Stimulsoft.Report.Dictionary {
    import List = Stimulsoft.System.Collections.List;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import CollectionBase = Stimulsoft.System.Collections.CollectionBase;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IComparer = Stimulsoft.System.Collections.IComparer;
    import StiJson = Stimulsoft.Base.StiJson;
    class StiVariablesCollection extends CollectionBase<StiVariable> implements IComparer<StiVariable>, ICloneable {
        implements(): any[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson, report: StiReport): void;
        loadFromXml(xmlNode: XmlNode, report: StiReport): void;
        private directionFactor;
        compare(x: StiVariable, y: StiVariable): number;
        sort(order?: StiSortOrder): void;
        add(variable: StiVariable): void;
        addRange(variables: StiVariablesCollection): void;
        contains(name: string): boolean;
        containsCategory(name: string): boolean;
        indexOf(data: string | StiVariable): number;
        remove(data: string | StiVariable): void;
        getByName(name: string): StiVariable;
        setByName(name: string, value: StiVariable): void;
        clone(): any;
        moveCategoryTo(fromCategory: string, toCategory: string): void;
        getFirstCategoryIndex(category: string): number;
        getLastCategoryIndex(category: string): number;
        renameCategory(oldName: string, newName: string): void;
        getAllVariablesOfCategory(category: string): List<StiVariable>;
        removeCategory(category: string): void;
        getVariablesCount(category: string): number;
    }
}
export namespace Stimulsoft.Report {
    class StiInheritedReportComparer {
        static compare(report: StiReport, masterReport: StiReport): void;
        private static compareComponents;
        private static getPositionForComponent;
        private static setParent;
        private static compareVariables;
        private static compareDataSources;
        private static compareRelations;
        private static compareDatabases;
        private static compareBusinessObjects;
        private static compareEvents;
    }
}
export namespace Stimulsoft.Report {
    import Type = Stimulsoft.System.Type;
    class StiLogService {
        private static _logEnabled;
        static get logEnabled(): boolean;
        static set logEnabled(value: boolean);
        static logString: string;
        static write(type: Type, e: any): void;
        static write1(message: string): void;
    }
}
export namespace Stimulsoft.Report {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiJson = Stimulsoft.Base.StiJson;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import ICloneable = Stimulsoft.System.ICloneable;
    class StiMetaTag implements ICloneable, IStiJsonReportObject {
        private static implementsStiMetaTag;
        implements(): any[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        loadFromXml(xmlNode: XmlNode): void;
        clone(): any;
        name: string;
        tag: string;
        constructor(name: string, tag: string);
    }
}
export namespace Stimulsoft.Report.Dictionary {
    import StiJson = Stimulsoft.Base.StiJson;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import ICloneable = Stimulsoft.System.ICloneable;
    import CollectionBase = Stimulsoft.System.Collections.CollectionBase;
    class StiMetaTagCollection extends CollectionBase<StiMetaTag> implements ICloneable, IStiJsonReportObject {
        private static implementsStiMetaTagCollection;
        implements(): any[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        loadFromXml(xmlNode: XmlNode): void;
        add2(name: string, tag: string): void;
        add(metaTag: StiMetaTag): void;
        addRange(metaTags: StiMetaTag[]): void;
        addRange2(metaTags: StiMetaTagCollection): void;
        contains(metaTag: StiMetaTag): boolean;
        indexOf(metaTag: StiMetaTag): number;
        insert(index: number, metaTag: StiMetaTag): void;
        remove(metaTag: StiMetaTag): void;
        getByIndex(index: number): StiMetaTag;
        setByIndex(index: number, value: StiMetaTag): void;
        getByName(name: string): StiMetaTag;
        setByName(name: string, value: StiMetaTag): void;
        clone(): any;
    }
}
export namespace Stimulsoft.Report.Events {
    class StiDisconnectedEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Events {
    class StiDisconnectingEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Events {
    class StiConnectedEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Events {
    class StiConnectingEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    import StiDataConnector = Stimulsoft.Base.StiDataConnector;
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiAppCell = Stimulsoft.Base.IStiAppCell;
    import ICloneable = Stimulsoft.System.ICloneable;
    import StiDisconnectedEvent = Stimulsoft.Report.Events.StiDisconnectedEvent;
    import StiDisconnectingEvent = Stimulsoft.Report.Events.StiDisconnectingEvent;
    import StiConnectedEvent = Stimulsoft.Report.Events.StiConnectedEvent;
    import StiConnectingEvent = Stimulsoft.Report.Events.StiConnectingEvent;
    import EventArgs = Stimulsoft.System.EventArgs;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import StiService = Stimulsoft.Base.Services.StiService;
    import Type = Stimulsoft.System.Type;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiJson = Stimulsoft.Base.StiJson;
    import StiPromise = Stimulsoft.System.StiPromise;
    import IStiAppConnection = Stimulsoft.Base.IStiAppConnection;
    enum Order {
        Name = 100,
        Alias = 200,
        ConnectionString = 300,
        FirstRowIsHeader = 350,
        PathSchema = 400,
        PathData = 500,
        XmlType = 600,
        PromptUserNameAndPassword = 700,
        SaveDataInReportResources = 800
    }
    class StiDatabase extends StiService implements IStiInherited, IStiAppConnection, IStiJsonReportObject, IStiName, IStiAlias, ICloneable, IStiAppCell {
        implements(): any[];
        meta(): StiMeta[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        loadFromXml(xmlNode: XmlNode): void;
        inherited: boolean;
        getName(): string;
        getKey(): string;
        setKey(key: string): void;
        get serviceCategory(): string;
        get serviceType(): Type;
        protected onConnecting(e: EventArgs): void;
        invokeConnecting(): void;
        connectingEvent: StiConnectingEvent;
        protected onConnected(e: EventArgs): void;
        invokeConnected(): void;
        connectedEvent: StiConnectedEvent;
        protected onDisconnecting(e: EventArgs): void;
        invokeDisconnecting(): void;
        disconnectingEvent: StiDisconnectingEvent;
        protected onDisconnected(e: EventArgs): void;
        invokeDisconnected(): void;
        disconnectedEvent: StiDisconnectedEvent;
        get serviceName(): string;
        set serviceName(value: string);
        name: string;
        alias: string;
        key: string;
        get connectionType(): StiConnectionType;
        applyDatabaseInformation(information: StiDatabaseInformation, report: StiReport, informationAll?: StiDatabaseInformation): void;
        getDatabaseInformationAsync(report: StiReport): StiPromise<StiDatabaseInformation>;
        getDatabaseInformation(report: StiReport): StiDatabaseInformation;
        getDataAdapterType(): Type;
        getDataAdapter(): StiDataAdapterService;
        toString(): string;
        regData(dictionary: StiDictionary, loadData: boolean): void;
        regDataAsync(dictionary: StiDictionary, loadData: boolean): StiPromise<void>;
        createNew(): StiDatabase;
        createConnector(connectionString?: string): StiDataConnector;
        getDatasourceType(): Type;
        constructor(name?: string, alias?: string, key?: string);
    }
}
export namespace Stimulsoft.Report.Dictionary {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import ICloneable = Stimulsoft.System.ICloneable;
    import StiRelationDirection = Stimulsoft.Base.StiRelationDirection;
    import DataSet = Stimulsoft.System.Data.DataSet;
    import Image = Stimulsoft.System.Drawing.Image;
    import StiJson = Stimulsoft.Base.StiJson;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import IStiAppCell = Stimulsoft.Base.IStiAppCell;
    class StiResource implements IStiName, IStiAlias, ICloneable, IStiAppCell, IStiInherited, IStiJsonReportObject {
        implements(): any[];
        is<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): this is T;
        is2<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): boolean;
        as<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): T;
        clone(): StiResource;
        getKey(): string;
        setKey(key: string): void;
        protected _hash: StiMeta[];
        meta(): StiMeta[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        loadFromXml(xmlNode: XmlNode): void;
        get componentId(): StiComponentId;
        get propName(): string;
        inherited: boolean;
        private _name;
        get name(): string;
        set name(value: string);
        alias: string;
        availableInTheViewer: boolean;
        private _content;
        get content(): number[] | string;
        set content(value: number[] | string);
        private _packAndEncryptContent;
        get packAndEncryptContent(): string;
        set packAndEncryptContent(value: string);
        key: string;
        type: StiResourceType;
        dataSet: DataSet;
        relationDirection: StiRelationDirection;
        getResourceAsImage(): Image;
        toString(): string;
        getContentType(): string;
        getFileExt(): string;
        createFileDatabase(): StiFileDatabase;
        static isTextResourceType(type: StiResourceType): boolean;
        constructor(name?: string, alias?: string, inherited?: boolean, type?: StiResourceType, content?: number[], availableInTheViewer?: boolean);
    }
}
export namespace Stimulsoft.Report.Dictionary {
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiJson = Stimulsoft.Base.StiJson;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import List = Stimulsoft.System.Collections.List;
    class StiDialogInfo implements IStiJsonReportObject {
        jsonLoadedBindingVariableName: string;
        xmlLoadedBindingVariable: XmlNode;
        report: StiReport;
        protected _hash: StiMeta[];
        meta(): StiMeta[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson, report?: StiReport): void;
        loadFromXml(xmlNode: XmlNode, report?: StiReport): void;
        dateTimeType: StiDateTimeType;
        sortDirection: StiVariableSortDirection;
        sortField: StiVariableSortField;
        itemsInitializationType: StiItemsInitializationType;
        keysColumn: string;
        valuesColumn: string;
        checkedColumn: string;
        bindingVariable: StiVariable;
        bindingValuesColumn: string;
        mask: string;
        allowUserValues: boolean;
        bindingValue: boolean;
        keys: string[];
        values: string[];
        checkedStates: boolean[];
        valuesBindingList: List<any>[];
        isDefault(): boolean;
        static convert(value: any): string;
        getDialogInfoItems(type: Stimulsoft.System.Type): List<StiDialogInfoItem>;
        orderBy(items: List<StiDialogInfoItem>): List<StiDialogInfoItem>;
        setDialogInfoItems(items: StiDialogInfoItem[], type: Stimulsoft.System.Type): void;
        constructor();
    }
    class StiDialogInfoItem {
        get componentId(): StiComponentId;
        get propName(): string;
        keyObject: any;
        keyObjectTo: any;
        valueBinding: List<object>;
        value: string;
        checked: boolean;
        toString(dateTimeType: StiDateTimeType): string;
    }
    class StiRangeDialogInfoItem extends StiDialogInfoItem {
    }
    class StiStringDialogInfoItem extends StiDialogInfoItem {
        get componentId(): StiComponentId;
        get key(): string;
        set key(value: string);
    }
    class StiGuidDialogInfoItem extends StiDialogInfoItem {
        get componentId(): StiComponentId;
        get key(): Stimulsoft.System.Guid;
        set key(value: Stimulsoft.System.Guid);
        constructor();
    }
    class StiCharDialogInfoItem extends StiDialogInfoItem {
        get componentId(): StiComponentId;
        get key(): Stimulsoft.System.Char;
        set key(value: Stimulsoft.System.Char);
        constructor();
    }
    class StiBoolDialogInfoItem extends StiDialogInfoItem {
        get componentId(): StiComponentId;
        get key(): boolean;
        set key(value: boolean);
        constructor();
    }
    class StiImageDialogInfoItem extends StiDialogInfoItem {
        get componentId(): StiComponentId;
        get key(): Stimulsoft.System.Drawing.Image;
        set key(value: Stimulsoft.System.Drawing.Image);
        constructor();
    }
    class StiDateTimeDialogInfoItem extends StiDialogInfoItem {
        get componentId(): StiComponentId;
        get key(): Stimulsoft.System.DateTime;
        set key(value: Stimulsoft.System.DateTime);
        constructor();
    }
    class StiTimeSpanDialogInfoItem extends StiDialogInfoItem {
        get componentId(): StiComponentId;
        get key(): Stimulsoft.System.TimeSpan;
        set key(value: Stimulsoft.System.TimeSpan);
        constructor();
    }
    class StiDoubleDialogInfoItem extends StiDialogInfoItem {
        get componentId(): StiComponentId;
        get key(): Stimulsoft.System.Double;
        set key(value: Stimulsoft.System.Double);
        constructor();
    }
    class StiDecimalDialogInfoItem extends StiDialogInfoItem {
        get componentId(): StiComponentId;
        get key(): Stimulsoft.System.Decimal;
        set key(value: Stimulsoft.System.Decimal);
        constructor();
    }
    class StiLongDialogInfoItem extends StiDialogInfoItem {
        get componentId(): StiComponentId;
        get key(): Stimulsoft.System.Long;
        set key(value: Stimulsoft.System.Long);
        constructor();
    }
    class StiExpressionDialogInfoItem extends StiDialogInfoItem {
        get componentId(): StiComponentId;
        get key(): string;
        set key(value: string);
        constructor();
    }
    class StiStringRangeDialogInfoItem extends StiRangeDialogInfoItem {
        get componentId(): StiComponentId;
        get from(): string;
        set from(value: string);
        get to(): string;
        set to(value: string);
        constructor();
    }
    class StiGuidRangeDialogInfoItem extends StiRangeDialogInfoItem {
        get componentId(): StiComponentId;
        get from(): Stimulsoft.System.Guid;
        set from(value: Stimulsoft.System.Guid);
        get to(): Stimulsoft.System.Guid;
        set to(value: Stimulsoft.System.Guid);
        constructor();
    }
    class StiByteArrayRangeDialogInfoItem extends StiRangeDialogInfoItem {
        get componentId(): StiComponentId;
        get from(): number[];
        set form(value: number[]);
        get to(): number[];
        set to(value: number[]);
    }
    class StiCharRangeDialogInfoItem extends StiRangeDialogInfoItem {
        get componentId(): StiComponentId;
        get from(): Stimulsoft.System.Char;
        set from(value: Stimulsoft.System.Char);
        get to(): Stimulsoft.System.Char;
        set to(value: Stimulsoft.System.Char);
        constructor();
    }
    class StiDateTimeRangeDialogInfoItem extends StiRangeDialogInfoItem {
        get componentId(): StiComponentId;
        get from(): Stimulsoft.System.DateTime;
        set from(value: Stimulsoft.System.DateTime);
        get to(): Stimulsoft.System.DateTime;
        set to(value: Stimulsoft.System.DateTime);
        constructor();
    }
    class StiTimeSpanRangeDialogInfoItem extends StiRangeDialogInfoItem {
        get componentId(): StiComponentId;
        get from(): Stimulsoft.System.TimeSpan;
        set from(value: Stimulsoft.System.TimeSpan);
        get to(): Stimulsoft.System.TimeSpan;
        set to(value: Stimulsoft.System.TimeSpan);
        constructor();
    }
    class StiDoubleRangeDialogInfoItem extends StiRangeDialogInfoItem {
        get componentId(): StiComponentId;
        get from(): Stimulsoft.System.Double;
        set from(value: Stimulsoft.System.Double);
        get to(): Stimulsoft.System.Double;
        set to(value: Stimulsoft.System.Double);
        constructor();
    }
    class StiDecimalRangeDialogInfoItem extends StiRangeDialogInfoItem {
        get componentId(): StiComponentId;
        get from(): Stimulsoft.System.Decimal;
        set from(value: Stimulsoft.System.Decimal);
        get to(): Stimulsoft.System.Decimal;
        set to(value: Stimulsoft.System.Decimal);
        constructor();
    }
    class StiLongRangeDialogInfoItem extends StiRangeDialogInfoItem {
        get componentId(): StiComponentId;
        get from(): Stimulsoft.System.Long;
        set from(value: Stimulsoft.System.Long);
        get to(): Stimulsoft.System.Long;
        set to(value: Stimulsoft.System.Long);
        constructor();
    }
    class StiExpressionRangeDialogInfoItem extends StiRangeDialogInfoItem {
        get componentId(): StiComponentId;
        get from(): string;
        set from(value: string);
        get to(): string;
        set to(value: string);
        constructor();
    }
}
export namespace Stimulsoft.Report {
    import Range = Stimulsoft.Report.Range;
    import CultureInfo = Stimulsoft.System.Globalization.CultureInfo;
    class RangeConverter {
        get getPropertiesSupported(): boolean;
        static rangeToString(range: Range): string;
        static stringToRange(str: string): Range;
        convertTo(context: any, culture: CultureInfo, value: any, destinationType: Stimulsoft.System.Type): any;
        canConvertFrom(context: any, sourceType: Stimulsoft.System.Type): boolean;
        canConvertTo(context: any, destinationType: Stimulsoft.System.Type): boolean;
        convertFrom(context: any, culture: CultureInfo, value: any): any;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    import DateTimeOffset = Stimulsoft.System.DateTimeOffset;
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IStiAppCell = Stimulsoft.Base.IStiAppCell;
    import DateTime = Stimulsoft.System.DateTime;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import IStiName = Stimulsoft.Report.IStiName;
    import StiExpression = Stimulsoft.Report.Expressions.StiExpression;
    import Type = Stimulsoft.System.Type;
    import StiJson = Stimulsoft.Base.StiJson;
    import StiDialogInfo = Stimulsoft.Report.Dictionary.StiDialogInfo;
    import IStiAppVariable = Stimulsoft.Base.IStiAppVariable;
    import IStiAppAlias = Stimulsoft.Base.IStiAppAlias;
    class StiVariable extends StiExpression implements IStiName, IStiAlias, IStiInherited, ICloneable, IStiAppCell, IStiAppVariable, IStiAppAlias {
        implements(): any[];
        private report;
        private convertTypeToJsonString;
        private convertJsonStringToType;
        meta(): StiMeta[];
        loadFromJsonObject(jObject: StiJson, report?: StiReport): void;
        static loadFromXml(xmlNode: XmlNode, report: StiReport): StiVariable;
        static convertFromStringToDialogInfo(str: string, report: StiReport): StiDialogInfo;
        private static parseStringArray;
        private static parseBoolArray;
        getValue(): any;
        getCellType(): Type;
        getName(): string;
        getKey(): string;
        setKey(key: string): void;
        getAlias(): string;
        inherited: boolean;
        private _name;
        get name(): string;
        set name(value: string);
        get applyFormat(): boolean;
        dialogInfo: StiDialogInfo;
        alias: string;
        type: Type;
        private _readOnly;
        get readOnly(): boolean;
        set readOnly(value: boolean);
        requestFromUser: boolean;
        allowUseAsSqlParameter: boolean;
        allowNullableString: boolean;
        category: string;
        description: string;
        get isCategory(): boolean;
        get valueObject(): any;
        set valueObject(value: any);
        get initByExpressionFrom(): string;
        set initByExpressionFrom(value: string);
        get initByExpressionTo(): string;
        set initByExpressionTo(value: string);
        getValueProp(): string;
        setValueProp(value: string): void;
        get function(): boolean;
        set function(value: boolean);
        initBy: StiVariableInitBy;
        selection: StiSelectionMode;
        key: string;
        private getRangeValues;
        static getValue(str: string, type: Type): any;
        private setValue;
        getNativeValue(): string;
        static getDateTimeFromValue(value: string): DateTime;
        static getDateTimeOffsetFromValue(value: string): DateTimeOffset;
        static getValueFromDateTime(value: Stimulsoft.System.DateTime): string;
        static getValueFromDateTimeOffset(value: Stimulsoft.System.DateTimeOffset): string;
        eval(report: StiReport): any;
        toString(): string;
        constructor(category?: string, name?: string, alias?: string, description?: string, typeT?: Type, value?: any, readOnly?: boolean, initBy?: StiVariableInitBy, requestFromUser?: boolean, dialogInfo?: StiDialogInfo, key?: string, allowUseAsSqlParameter?: boolean, selection?: StiSelectionMode, allowNullableString?: boolean);
    }
}
export namespace Stimulsoft.Report {
    import StiReport = Stimulsoft.Report.StiReport;
    import StiComponent = Stimulsoft.Report.Components.StiComponent;
    import StiDataRelation = Stimulsoft.Report.Dictionary.StiDataRelation;
    import StiDataSource = Stimulsoft.Report.Dictionary.StiDataSource;
    enum StiNamingRule {
        Simple = 0,
        Advanced = 1
    }
    class StiNameCreation {
        static get namingRule(): StiNamingRule;
        static set namingRule(value: StiNamingRule);
        private static removeSpacesFromName;
        static createSimpleName(report: StiReport, baseName: string): string;
        static createName(report: StiReport, baseName: string, addOne?: boolean, removeIncorrectSymbols?: boolean, forceAdvancedNamingRule?: boolean): string;
        static createResourceName(report: StiReport, baseName: string): string;
        static createConnectionName(report: StiReport, baseName: string): string;
        static createDataSourcesName(report: StiReport, baseName: string): string;
        static createRelationName(report: StiReport, dataRelation: StiDataRelation, baseName: string): string;
        static isRelationExists(report: StiReport, dataRelation: StiDataRelation, name: string): boolean;
        static isTableDataSourcesExists(report: StiReport, name: string): boolean;
        static isResourceNameExists(report: StiReport, name: string): boolean;
        static isConnectionNameExists(report: StiReport, name: string): boolean;
        static createColumnName(dataSource: StiDataSource, baseName: string): string;
        static isColumnNameExists(dataSource: StiDataSource, name: string): boolean;
        static isValidName(report: StiReport, name: string): boolean;
        static exists(checkedObject: any, report: StiReport, name: string): boolean;
        static checkName(checkedObject: any, report: StiReport, name: string, messageBoxCaption: string, isValid?: boolean): boolean;
        private static getObjectWithName;
        static generateName1(report: StiReport, localizedName: string, name: string): string;
        static generateName2(report: StiReport, localizedName: string, type: Stimulsoft.System.Type): string;
        static generateName(component: StiComponent): string;
        static generateName4(relation: StiDataRelation): string;
        static generateName5(dataSource: StiDataSource): string;
    }
}
export namespace Stimulsoft.Report.CodeDom {
    class StiCodeGenerator {
        private static keywordsHashtable;
        private static keywords;
        private static reservedWordsHashtable;
        private static reservedWords;
        static isReservedWordExist(value: string): boolean;
        static isKeywordExist(value: string): boolean;
        quoteSnippetString(value: string): string;
        static init(): void;
    }
}
export namespace Stimulsoft.Report {
    class StiNameValidator {
        private static cache;
        static correctName(str: string, checkKeywords?: boolean, report?: StiReport): string;
        private static checkKeyword;
        static correctBusinessObjectName(str: string): string;
    }
}
export namespace Stimulsoft.Report {
    import CultureInfo = Stimulsoft.System.Globalization.CultureInfo;
    let IStiGlobalizationManager: System.Interface<IStiGlobalizationManager>;
    interface IStiGlobalizationManager {
        culture: CultureInfo;
        getString(name: string): string;
        getObject(name: string): any;
    }
}
export namespace Stimulsoft.Report {
    import CultureInfo = Stimulsoft.System.Globalization.CultureInfo;
    class StiNullGlobalizationManager implements IStiGlobalizationManager {
        culture: CultureInfo;
        getString(name: string): string;
        getObject(name: string): any;
        constructor();
    }
}
export namespace Stimulsoft.Report {
    class StiNullValuesHelper {
        static isNull(report: StiReport, dataColumn: string): boolean;
    }
}
export namespace Stimulsoft.Report.Components.Gauge {
    import IAsIs = Stimulsoft.System.IAsIs;
    import CollectionBase = Stimulsoft.System.Collections.CollectionBase;
    let IStiScaleBase: System.Interface<IStiScaleBase>;
    interface IStiScaleBase extends IAsIs {
        prepare(gauge: IStiGauge): any;
        items: CollectionBase<IStiGaugeElement>;
        majorInterval: number;
        minorInterval: number;
        minimum: number;
        maximum: number;
        calculateMinMaxScaleHelper(): any;
        calculateWidthScaleHelper(): any;
    }
}
export namespace Stimulsoft.Report.Components.Gauge {
    let IStiRangeBase: System.Interface<IStiRangeBase>;
    interface IStiRangeBase {
    }
}
export namespace Stimulsoft.Report.Components.Gauge {
    import IAsIs = Stimulsoft.System.IAsIs;
    let IStiGaugeElement: System.Interface<IStiGaugeElement>;
    interface IStiGaugeElement extends IAsIs {
    }
}
export namespace Stimulsoft.Report.Components.Gauge {
    let IStiCustomValueBase: System.Interface<IStiCustomValueBase>;
    interface IStiCustomValueBase {
    }
}
export namespace Stimulsoft.Report.Dictionary {
    class StiDataStoreAdapterService extends StiDataAdapterService {
        setDataSourceNames(data: StiData, dataSource: StiDataSource): void;
        create(dictionary: StiDictionary, addToDictionary?: boolean): StiDataSource;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    import StiFileDataOptions = Stimulsoft.Base.StiFileDataOptions;
    import StiFileDataConnector = Stimulsoft.Base.StiFileDataConnector;
    import StiDataSchema = Stimulsoft.Base.StiDataSchema;
    import DataSet = Stimulsoft.System.Data.DataSet;
    import StiPromise = Stimulsoft.System.StiPromise;
    class StiDataLeader {
        private static fetchAll;
        static regData(database: StiDatabase, dictionary: StiDictionary, loadData: boolean): void;
        static regDataAsync(database: StiDatabase, dictionary: StiDictionary, loadData: boolean): StiPromise<void>;
        private static regDataAfter;
        private static regDataAfterAsync;
        static existsInCache(database: StiDatabase, dictionary: StiDictionary): boolean;
        static retrieveSchema(connector: StiFileDataConnector, options: StiFileDataOptions): StiDataSchema;
        static getDataSet(connector: StiFileDataConnector, options: StiFileDataOptions): DataSet;
        static getColumnsFromData(adapter: StiDataAdapterService, data: StiData, dataSource: StiDataSource): StiDataColumnsCollection;
        static getColumnsFromDataAsync(adapter: StiDataAdapterService, data: StiData, dataSource: StiDataSource): StiPromise<StiDataColumnsCollection>;
        static connectDataSourceToData(adapter: StiDataAdapterService, dictionary: StiDictionary, dataSource: StiDataSource, loadData: boolean): void;
        static connectDataSourceToDataAsync(adapter: StiDataAdapterService, dictionary: StiDictionary, dataSource: StiDataSource, loadData: boolean): StiPromise<void>;
        static retrieveDataAsync(dataSource: StiSqlSource, schemaOnly?: boolean): StiPromise<void>;
        static connect(dataSource: StiDataSource, datas: StiDataCollection, loadData?: boolean): void;
        static connectAsync(dataSource: StiDataSource, datas: StiDataCollection, loadData?: boolean): StiPromise<void>;
        static connectAsync2(dataSource: StiDataSource, datas: StiDataCollection, loadData?: boolean): Promise<void>;
        static disconnect(dataSource: StiDataSource): void;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    import Hashtable = Stimulsoft.System.Collections.Hashtable;
    import StiDataSchema = Stimulsoft.Base.StiDataSchema;
    import DataTable = Stimulsoft.System.Data.DataTable;
    import StiPromise = Stimulsoft.System.StiPromise;
    type StiSqlAdapterResultType = {
        columns: string[];
        rows: {}[];
        types: string[];
    };
    class StiSqlAdapterService extends StiDataStoreAdapterService {
        parameters: Hashtable<string, {
            name: string;
            value: string | number;
        }>;
        get url(): string;
        get serviceName(): string;
        get name(): string;
        getDatabaseSpecificName(name: string): string;
        getDataCategoryName(data: StiData): string;
        getColumnsFromDataAsync(data: StiData, dataSource: StiDataSource, connectionString: string): StiPromise<StiDataColumnsCollection>;
        getParametersFromDataAsync(data: StiData, dataSource: StiDataSource, connectionString: string): StiPromise<StiDataParametersCollection>;
        getDataSourceType(): Stimulsoft.System.Type;
        applyParametersToSqlSourse(dictionary: StiDictionary, sqlSource: StiSqlSource): void;
        connectDataSourceToDataAsync(dictionary: StiDictionary, dataSource: StiDataSource, loadData: boolean): StiPromise<void>;
        static getStringCommand(command: any): string;
        static encodeCommand(command: any): string;
        static decodeCommandResult(value: string): any;
        static callRemoteDataAdaptersApi(command: any, timeout: number): StiPromise<string>;
        callRemoteApi(command: any, timeout: number): StiPromise<string>;
        private static callTurn;
        process(report: StiReport, command: any): StiPromise<any>;
        testConnectionAsync(report: StiReport, connectionString: string): StiPromise<string>;
        testConnectionAsync2(report: StiReport, connectionString: string): Promise<string>;
        createConnectionInDataStore(dictionary: StiDictionary, database: StiSqlDatabase): void;
        retrieveSchemaAsync(report: StiReport, dataSource: StiSqlSource, connectionString: string, queryString?: string): StiPromise<StiDataSchema>;
        getNetType(dbType: string): Stimulsoft.System.Type;
        retrieveDataAsync(report: StiReport, dataSource: StiSqlSource, connectionString: string, queryString: string): StiPromise<DataTable>;
        constructor();
    }
}
export namespace Stimulsoft.Report.Dictionary {
    import StiDataSchema = Stimulsoft.Base.StiDataSchema;
    import StiPromise = Stimulsoft.System.StiPromise;
    class StiMySqlAdapterService extends StiSqlAdapterService {
        get name(): string;
        getDatabaseSpecificName(name: string): string;
        getDataSourceType(): Stimulsoft.System.Type;
        retrieveSchemaAsync(report: StiReport, dataSource: StiSqlSource, connectionString: string, queryString?: string): StiPromise<StiDataSchema>;
        getNetType(dbType: string): Stimulsoft.System.Type;
    }
}
export namespace Stimulsoft.Report.Components {
    import IAsIs = Stimulsoft.System.IAsIs;
    import StiFormatService = Stimulsoft.Report.Components.TextFormats.StiFormatService;
    let IStiTextFormat: System.Interface<IStiTextFormat>;
    let ImplementsIStiTextFormat: any[];
    interface IStiTextFormat extends IAsIs {
        textFormat: StiFormatService;
    }
}
export namespace Stimulsoft.Report.Styles {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiTextFormat = Stimulsoft.Report.Components.IStiTextFormat;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiBorder = Stimulsoft.Base.Drawing.StiBorder;
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    import Font = Stimulsoft.System.Drawing.Font;
    import StiTextHorAlignment = Stimulsoft.Base.Drawing.StiTextHorAlignment;
    import StiVertAlignment = Stimulsoft.Base.Drawing.StiVertAlignment;
    import StiComponent = Stimulsoft.Report.Components.StiComponent;
    import Image = Stimulsoft.System.Drawing.Image;
    class StiStyle extends StiBaseStyle implements IStiJsonReportObject, IStiTextFormat {
        private static ImplementsStiStyle;
        implements(): any[];
        meta(): StiMeta[];
        clone(): any;
        private _horAlignment;
        get horAlignment(): StiTextHorAlignment;
        set horAlignment(value: StiTextHorAlignment);
        private _vertAlignment;
        get vertAlignment(): StiVertAlignment;
        set vertAlignment(value: StiVertAlignment);
        private _font;
        get font(): Font;
        set font(value: Font);
        private _border;
        get border(): StiBorder;
        set border(value: StiBorder);
        private _brush;
        get brush(): StiBrush;
        set brush(value: StiBrush);
        private _textBrush;
        get textBrush(): StiBrush;
        set textBrush(value: StiBrush);
        textFormat: Stimulsoft.Report.Components.TextFormats.StiFormatService;
        private _allowUseHorAlignment;
        get allowUseHorAlignment(): boolean;
        set allowUseHorAlignment(value: boolean);
        private _allowUseVertAlignment;
        get allowUseVertAlignment(): boolean;
        set allowUseVertAlignment(value: boolean);
        private _allowUseImage;
        get allowUseImage(): boolean;
        set allowUseImage(value: boolean);
        private _allowUseFont;
        get allowUseFont(): boolean;
        set allowUseFont(value: boolean);
        get allowUseBorder(): boolean;
        set allowUseBorder(value: boolean);
        private _allowUseBorderFormatting;
        get allowUseBorderFormatting(): boolean;
        set allowUseBorderFormatting(value: boolean);
        private _allowUseBorderSides;
        get allowUseBorderSides(): boolean;
        set allowUseBorderSides(value: boolean);
        private _allowUseBorderSidesFromLocation;
        get allowUseBorderSidesFromLocation(): boolean;
        set allowUseBorderSidesFromLocation(value: boolean);
        private _allowUseBrush;
        get allowUseBrush(): boolean;
        set allowUseBrush(value: boolean);
        private _allowUseTextBrush;
        get allowUseTextBrush(): boolean;
        set allowUseTextBrush(value: boolean);
        allowUseNegativeTextBrush: boolean;
        allowUseTextFormat: boolean;
        private _allowUseTextOptions;
        get allowUseTextOptions(): boolean;
        set allowUseTextOptions(value: boolean);
        getStyleFromComponent(component: StiComponent, styleElements: StiStyleElements, componentStyle?: StiBaseStyle): void;
        setStyleToComponent(component: StiComponent): void;
        private _image;
        get image(): Image;
        set image(value: Image);
        private _lineSpacing;
        get lineSpacing(): number;
        set lineSpacing(value: number);
        negativeTextBrush: StiBrush;
    }
}
export namespace Stimulsoft.Report.Components.Gauge {
    let IStiIndicatorRangeInfo: System.Interface<IStiIndicatorRangeInfo>;
    interface IStiIndicatorRangeInfo {
    }
}
export namespace Stimulsoft.Report.Export {
    import StiComponent = Stimulsoft.Report.Components.StiComponent;
    import Image = Stimulsoft.System.Drawing.Image;
    class StiExportUtils {
        static convertDigitsToArabic(inputString: string, digitsType: StiArabicDigitsType): string;
        private static reportVersion;
        static getReportVersion(report?: StiReport): string;
        static saveComponentToString(component: StiComponent, imageFormat?: ImageFormat, imageQuality?: number, imageResolution?: number): string;
        static trimEndWhiteSpace(inputString: string): string;
        static trimEndWhiteSpace2(inputString: string, removeControl: boolean): string;
        static splitString(inputString: string, removeControl: boolean): string[];
        static stringToUrl(input: string): string;
        private static wrongUrlSymbols;
        static additionalData: string;
        private static additionalData2;
        private static cachedAdditionalData2;
        static getAdditionalData2(opacity: number): Image;
        private static positivePatterns;
        private static negativePatterns;
        static getPositivePattern(patternIndex: number): string;
        static getNegativePattern(patternIndex: number): string;
        static makePdfDeflateStream(data: any): Stimulsoft.System.IO.MemoryStream;
        static toHex(num: number): string;
    }
}
export namespace Stimulsoft.Report.Export {
    enum StiTiffCompressionScheme {
        Default = 20,
        LZW = 2,
        CCITT3 = 3,
        CCITT4 = 4,
        Rle = 5,
        None = 6
    }
    enum StiHtmlExportMode {
        Span = 1,
        Div = 2,
        Table = 3,
        FromReport = 4
    }
    enum StiHtmlExportQuality {
        High = 1,
        Low = 2
    }
    enum StiUserAccessPrivileges {
        None = 0,
        PrintDocument = 1,
        ModifyContents = 2,
        CopyTextAndGraphics = 4,
        AddOrModifyTextAnnotations = 8,
        All = 15
    }
    enum StiPdfEncryptionKeyLength {
        Bit40 = 1,
        Bit128 = 2,
        Bit128_r4 = 3,
        Bit256_r5 = 4,
        Bit256_r6 = 5
    }
    enum StiPdfImageCompressionMethod {
        Jpeg = 1,
        Flate = 2,
        Indexed = 3
    }
    enum StiPdfAutoPrintMode {
        None = 1,
        Dialog = 2,
        Silent = 3
    }
    enum StiTxtBorderType {
        Simple = 1,
        UnicodeSingle = 2,
        UnicodeDouble = 3
    }
    enum StiPcxPaletteType {
        Monochrome = 1,
        Color = 2
    }
    enum StiMonochromeDitheringType {
        None = 1,
        FloydSteinberg = 2,
        Ordered = 3
    }
    enum StiImageType {
        Bmp = 1,
        Gif = 2,
        Jpeg = 3,
        Pcx = 4,
        Png = 5,
        Tiff = 6,
        Emf = 7,
        Svg = 8,
        Svgz = 9
    }
    enum StiHtmlType {
        Html = 1,
        Html5 = 2,
        Mht = 3
    }
    enum StiHtmlChartType {
        Image = 1,
        Vector = 2,
        AnimatedVector = 3
    }
    enum StiExcelType {
        ExcelBinary = 1,
        ExcelXml = 2,
        Excel2007 = 3
    }
    enum StiDataType {
        Csv = 1,
        Dbf = 2,
        Dif = 3,
        Sylk = 4,
        Xml = 5,
        Json = 6
    }
    enum StiExportPosition {
        Pdf = 0,
        Xps = 1,
        Ppt2007 = 2,
        Html = 10,
        Html5 = 11,
        Mht = 12,
        Txt = 20,
        Rtf = 21,
        Word2007 = 22,
        Odt = 23,
        Excel = 30,
        ExcelXml = 31,
        Excel2007 = 32,
        Ods = 33,
        Data = 40,
        Dbf = 41,
        Xml = 42,
        Dif = 43,
        Sylk = 44,
        Image = 50,
        Bmp = 50,
        Gif = 51,
        Jpeg = 52,
        Pcx = 53,
        Png = 54,
        Tiff = 55,
        Emf = 60,
        Svg = 61,
        Svgz = 62
    }
    enum StiHtmlExportBookmarksMode {
        BookmarksOnly = 1,
        ReportOnly = 2,
        All = 3
    }
    enum StiDbfCodePages {
        Default = 0,
        USDOS = 437,
        MazoviaDOS = 620,
        GreekDOS = 737,
        InternationalDOS = 850,
        EasternEuropeanDOS = 852,
        IcelandicDOS = 861,
        NordicDOS = 865,
        RussianDOS = 866,
        KamenickyDOS = 895,
        TurkishDOS = 857,
        EasternEuropeanWindows = 1250,
        RussianWindows = 1251,
        WindowsANSI = 1252,
        GreekWindows = 1253,
        TurkishWindows = 1254,
        StandardMacintosh = 10000,
        GreekMacintosh = 10006,
        RussianMacintosh = 10007,
        EasternEuropeanMacintosh = 10029
    }
    enum StiExportDataType {
        String = 0,
        Int = 1,
        Long = 2,
        Float = 3,
        Double = 4,
        Date = 5,
        Bool = 6
    }
    enum StiImageFormat {
        Color = 1,
        Grayscale = 2,
        Monochrome = 3
    }
    enum StiRtfExportMode {
        Table = 4,
        Frame = 1,
        WinWord = 2,
        TabbedText = 3
    }
    enum StiDataExportMode {
        Data = 1,
        Headers = 2,
        DataAndHeaders = 3,
        Footers = 4,
        HeadersFooters = 6,
        DataAndHeadersFooters = 7,
        AllBands = 15
    }
    enum StiWord2007RestrictEditing {
        No = 1,
        ExceptEditableFields = 2,
        Yes = 3
    }
    enum StiExcel2007RestrictEditing {
        No = 1,
        ExceptEditableFields = 2,
        Yes = 3
    }
    enum StiPdfAllowEditable {
        No = 1,
        Yes = 2
    }
    enum StiImageResolutionMode {
        Exactly = 1,
        NoMoreThan = 2,
        Auto = 3
    }
    enum StiPdfComplianceMode {
        None = 0,
        A1 = 1,
        A2 = 2,
        A3 = 3
    }
    enum StiExcelSheetViewMode {
        Normal = 1,
        PageLayout = 2,
        PageBreakPreview = 3
    }
    enum StiPdfZUGFeRDComplianceMode {
        None = 0,
        V1 = 1,
        V2 = 2,
        V2_1 = 3
    }
}
export namespace Stimulsoft.Report.Events {
    class StiReportCacheProcessingEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Events {
    class StiPrintedEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Events {
    class StiPrintingEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Events {
    class StiExportedEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Events {
    import EventHandler = Stimulsoft.System.EventHandler;
    import EventArgs = Stimulsoft.System.EventArgs;
    let StiExportEventHandler: EventHandler;
    class StiExportEventArgs extends EventArgs {
        exportFormat: StiExportFormat;
        constructor(format: StiExportFormat);
    }
}
export namespace Stimulsoft.Report.Events {
    class StiRefreshingEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Styles {
    enum StiStyleConditionType {
        ComponentType = 1,
        Placement = 2,
        PlacementNestedLevel = 4,
        ComponentName = 8,
        Location = 16
    }
    enum StiStyleComponentPlacement {
        None = 0,
        ReportTitle = 1,
        ReportSummary = 2,
        PageHeader = 4,
        PageFooter = 8,
        GroupHeader = 16,
        GroupFooter = 32,
        Header = 64,
        Footer = 128,
        ColumnHeader = 256,
        ColumnFooter = 512,
        Data = 1024,
        DataEvenStyle = 2048,
        DataOddStyle = 4096,
        Table = 8192,
        Hierarchical = 16384,
        Child = 32768,
        Empty = 65536,
        Overlay = 131072,
        Panel = 262144,
        Page = 524288,
        AllExeptStyles = 1042431
    }
    enum StiStyleComponentType {
        Text = 1,
        Primitive = 2,
        Image = 4,
        CrossTab = 8,
        Chart = 16,
        CheckBox = 32
    }
    enum StiStyleLocation {
        None = 0,
        TopLeft = 1,
        TopCenter = 2,
        TopRight = 4,
        MiddleLeft = 8,
        MiddleCenter = 16,
        MiddleRight = 32,
        BottomLeft = 64,
        BottomCenter = 128,
        BottomRight = 256,
        Left = 512,
        Right = 1024,
        Top = 2048,
        Bottom = 4096,
        CenterHorizontal = 8192,
        CenterVertical = 16384
    }
    enum StiStyleConditionOperation {
        EqualTo = 0,
        NotEqualTo = 1,
        GreaterThan = 2,
        GreaterThanOrEqualTo = 3,
        LessThan = 4,
        LessThanOrEqualTo = 5,
        Containing = 6,
        NotContaining = 7,
        BeginningWith = 8,
        EndingWith = 9
    }
    enum StiHeatmapFillMode {
        Lightness = 0,
        Darkness = 1
    }
}
export namespace Stimulsoft.Report.Events {
    class StiExportingEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report {
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    import StiSimpleBorder = Stimulsoft.Base.Drawing.StiSimpleBorder;
    import StiCornerRadius = Stimulsoft.Base.Drawing.StiCornerRadius;
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import StiBaseStyle = Stimulsoft.Report.Styles.StiBaseStyle;
    import Color = Stimulsoft.System.Drawing.Color;
    class StiCardsStyle extends StiBaseStyle {
        meta(): StiMeta[];
        private static defaultSeriesColors;
        backColor: Color;
        foreColor: Color;
        lineColor: Color;
        seriesColors: Color[];
        toolTipBrush: StiBrush;
        toolTipTextBrush: StiBrush;
        toolTipCornerRadius: StiCornerRadius;
        toolTipBorder: StiSimpleBorder;
        constructor(name?: string, description?: string, report?: StiReport);
    }
}
export namespace Stimulsoft.Report.Styles {
    import IStiGaugeStyle = Stimulsoft.Report.Gauge.IStiGaugeStyle;
    import IStiCustomStyle = Stimulsoft.Report.Chart.IStiCustomStyle;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import CollectionBase = Stimulsoft.System.Collections.CollectionBase;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiJson = Stimulsoft.Base.StiJson;
    class StiStylesCollection extends CollectionBase<StiBaseStyle> implements IStiJsonReportObject {
        implements(): any[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        loadFromXml(xmlNode: XmlNode): void;
        load(param: string | number[] | XmlNode | any): void;
        loadFile(filePath: string): void;
        saveToJsonString(): string;
        add(style: StiBaseStyle): void;
        clear(): void;
        addRange(styles: StiBaseStyle[] | StiStylesCollection | any): void;
        contains(style: StiBaseStyle | string | any): boolean;
        insert(index: number, style: StiBaseStyle): void;
        remove(style: StiBaseStyle): void;
        setByIndex(index: number, style: StiBaseStyle): void;
        getByName(name: string): StiBaseStyle;
        setByName(name: string, value: StiBaseStyle): void;
        private updateHash;
        getCustomChartStyle(customStyleName: string): IStiCustomStyle;
        getCustomGaugeStyle(customStyleName: string): IStiGaugeStyle;
        private report;
        private hash;
        private needUpdateHash;
        private lastCount;
        constructor(report?: StiReport);
    }
}
export namespace Stimulsoft.Report.Components.Table {
    enum StiTableStyleIdent {
        Style21 = 0,
        Style24 = 1,
        Style25 = 2,
        Style26 = 3,
        Style27 = 4
    }
    enum StiTableStyle {
        StyleNone = 0,
        Style11 = 11,
        Style12 = 12,
        Style13 = 13,
        Style14 = 14,
        Style15 = 15,
        Style16 = 16,
        Style17 = 17,
        Style18 = 18,
        Style19 = 19,
        Style31 = 31,
        Style32 = 32,
        Style33 = 33,
        Style34 = 34,
        Style35 = 35,
        Style36 = 36,
        Style37 = 37,
        Style38 = 38,
        Style39 = 39,
        Style41 = 41,
        Style42 = 42,
        Style43 = 43,
        Style44 = 44,
        Style45 = 45,
        Style46 = 46,
        Style47 = 47,
        Style48 = 48,
        Style49 = 49,
        Style51 = 51,
        Style52 = 52,
        Style53 = 53,
        Style54 = 54,
        Style55 = 55,
        Style56 = 56,
        Style57 = 57,
        Style58 = 58,
        Style59 = 59
    }
    enum StiTablceCellType {
        Text = 0,
        Image = 1,
        CheckBox = 2,
        RichText = 3
    }
    enum StiTableAutoWidth {
        None = 0,
        Page = 1,
        Table = 2
    }
    enum StiTableAutoWidthType {
        None = 0,
        LastColumns = 1,
        FullTable = 2
    }
}
export namespace Stimulsoft.Report.Components.Table {
    let IStiTableCell: System.Interface<IStiTableCell>;
    interface IStiTableCell {
        joinCells: number[];
        parentJoin: number;
        join: boolean;
        id: number;
        joinWidth: number;
        joinHeight: number;
        merged: boolean;
        changeTopPosition: boolean;
        changeLeftPosition: boolean;
        changeRightPosition: boolean;
        cellType: StiTablceCellType;
        cellDockStyle: StiDockStyle;
        column: number;
        fixedWidth: boolean;
        tableTag: any;
        parentJoinCell: StiComponent;
        getJoinComponentByGuid(id: number): StiComponent;
        getJoinComponentByIndex(index: number): StiComponent;
        containsGuid(id: number): boolean;
        setJoinSize(): any;
        getRealHeightAfterInsertRows(): number;
        getRealHeight(): number;
        getRealTop(): number;
        getRealWidth(): number;
        getRealLeft(): number;
    }
}
export namespace Stimulsoft.Report.Events {
    import EventHandler = Stimulsoft.System.EventHandler;
    import EventArgs = Stimulsoft.System.EventArgs;
    import Image = Stimulsoft.System.Drawing.Image;
    let StiGetImageDataEventHandler: EventHandler;
    class StiGetImageDataEventArgs extends EventArgs {
        value: Image;
        constructor(image?: Image);
    }
}
export namespace Stimulsoft.Report.Helpers {
    import StiPage = Stimulsoft.Report.Components.StiPage;
    class StiExpressionHelper {
        static parseText(page: StiPage, text: string, allowReturnNull?: boolean): string;
        static parseBool(page: StiPage, text: string): boolean;
    }
}
export namespace Stimulsoft.Report.Events {
    class StiGetImageDataEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Events {
    class StiGetImageURLEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Import {
    export class BitConverter {
        static toInt16(value: number[], startIndex: number): number;
        static toUInt16(value: number[], startIndex: number): number;
        static toInt32(value: number[], startIndex: number): number;
        static toUInt32(value: number[], startIndex: number): number;
        static toUInt64(value: number[], startIndex: number): number;
        static toChar(value: number[], startIndex: number): string;
    }
    class DirEntry {
        name: string;
        type: number;
        dIDLeft: number;
        dIDRight: number;
        dIDRoot: number;
        sIDFirstSector: number;
        size: number;
    }
    export class OleContainer {
        data: number[];
        dir: DirEntry[];
        private bigSectorSize;
        private shortSectorSize;
        private minimumStreamSize;
        private bSAT;
        private sSAT;
        private headerSize;
        private sIDFree;
        private sIDEoC;
        private sIDSAT;
        private sIDMSAT;
        private getUInt16;
        private getUInt32;
        private getBigSectorOffset;
        private getShortSectorOffset;
        private getBSatChain;
        private getSSatChain;
        private getBigStreamData;
        private getShortStreamData;
        getStreamData(streamNumber: number): number[];
        clear(): void;
        constructor(inData: number[]);
    }
    export class ObjectHeader {
        private getString;
        private signature;
        private headerSize;
        private objectType;
        private nameLen;
        private classLen;
        private nameOffset;
        private classOffset;
        private objectSizeWidth;
        private objectSizeHeight;
        private oleVersion;
        private format;
        private oleInfoLen;
        name: string;
        class: string;
        oleInfo: string;
        headerLen: number;
        constructor(data: number[]);
    }
    export class OleUnit {
        static oleContainerIdentifier: number;
        static oleLinkIdentifier: number;
        static olePresHeaderLength: number;
        static isOleContainer(data: number[]): boolean;
        static isOleHeader(data: number[]): boolean;
        static checkForOlePres(data: number[]): boolean;
    }
    export {};
}
export namespace Stimulsoft.Report.Components {
    import Image = Stimulsoft.System.Drawing.Image;
    class StiImageHelper {
        static getImageFromObject(imageObject: any, width?: number, height?: number, stretch?: boolean, aspectRatio?: boolean): Image;
        static getImageBytesFromObject(imageObject: any): number[];
        private static getImageName;
        static isXml(data: number[]): boolean;
        static isSvg(data: number[]): boolean;
        static isIcon(data: number[]): boolean;
        static isWmf(data: number[]): boolean;
        static isEmf(data: number[]): boolean;
        static isBmp(data: number[]): boolean;
        static isJpeg(data: number[]): boolean;
        static isGif(data: number[]): boolean;
        static isPng(data: number[]): boolean;
        static isTiff(data: number[]): boolean;
        static isImage(data: any): boolean;
        static isImage2(data: number[]): boolean;
        static isImage3(str: string): boolean;
    }
}
export namespace Stimulsoft.Report.Components {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import Image = Stimulsoft.System.Drawing.Image;
    import StiBorder = Stimulsoft.Base.Drawing.StiBorder;
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    import StiHorAlignment = Stimulsoft.Base.Drawing.StiHorAlignment;
    import StiVertAlignment = Stimulsoft.Base.Drawing.StiVertAlignment;
    import SizeD = Stimulsoft.System.Drawing.Size;
    class StiView extends StiComponent implements IStiHorAlignment, IStiVertAlignment, IStiBorder, IStiExportImage, IStiExportImageExtended, IStiBrush, IStiJsonReportObject {
        private static ImplementsStiView;
        implements(): any[];
        meta(): StiMeta[];
        clone(cloneProperties: boolean): StiView;
        private _horAlignment;
        get horAlignment(): StiHorAlignment;
        set horAlignment(value: StiHorAlignment);
        private _vertAlignment;
        get vertAlignment(): StiVertAlignment;
        set vertAlignment(value: StiVertAlignment);
        getImage(REFzoom: any, format?: StiExportFormat): Image;
        isExportAsImage(format: StiExportFormat): boolean;
        private _border;
        get border(): StiBorder;
        set border(value: StiBorder);
        private _brush;
        get brush(): StiBrush;
        set brush(value: StiBrush);
        getActualSize(): SizeD;
        getRealSize(): SizeD;
        private _smoothing;
        get smoothing(): boolean;
        set smoothing(value: boolean);
        isCachedImage: boolean;
        private _objectToDraw;
        get objectToDraw(): any;
        set objectToDraw(value: any);
        private _imageToDraw;
        get imageToDraw(): Image;
        set imageToDraw(value: Image);
        private _stretch;
        get stretch(): boolean;
        set stretch(value: boolean);
        private _multipleFactor;
        get multipleFactor(): number;
        set multipleFactor(value: number);
        private _aspectRatio;
        get aspectRatio(): boolean;
        set aspectRatio(value: boolean);
        getImageFromSource(): Image;
    }
}
export namespace Stimulsoft.Report.Helpers {
    enum StiImageType {
        GdiImage = 0,
        SvgObject = 1
    }
}
export namespace Stimulsoft.Report.Components {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import Color = Stimulsoft.System.Drawing.Color;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiGetImageDataEventArgs = Stimulsoft.Report.Events.StiGetImageDataEventArgs;
    import StiValueEventArgs = Stimulsoft.Report.Events.StiValueEventArgs;
    import StiGetImageDataEvent = Stimulsoft.Report.Events.StiGetImageDataEvent;
    import StiGetImageURLEvent = Stimulsoft.Report.Events.StiGetImageURLEvent;
    import Image = Stimulsoft.System.Drawing.Image;
    import IStiBreakable = Stimulsoft.Report.Components.IStiBreakable;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    import StiFontIcons = Stimulsoft.Report.Helpers.StiFontIcons;
    class StiImage extends StiView implements IStiBreakable, IStiJsonReportObject {
        private static ImplementsStiImage;
        implements(): any[];
        meta(): StiMeta[];
        memberwiseClone(base?: boolean): StiImage;
        getImage(REFzoom: any, format?: StiExportFormat): Image;
        isExportAsImage(format: StiExportFormat): boolean;
        protected getImageFromFile(): Image;
        protected getImageFromUrl(): Image;
        protected getImageFromDataColumn(): Image;
        protected getImageFromIcon(): Image;
        getImageFromSource(): Image;
        private static propertyCanBreak;
        get canBreak(): boolean;
        set canBreak(value: boolean);
        break(dividedComponent: StiComponent, devideFactor: number, REFdivideLine: any): boolean;
        private _imageURLValue;
        get imageURLValue(): any;
        set imageURLValue(value: any);
        invokeEvents(): void;
        private static eventGetImageURL;
        protected onGetImageURL(e: StiValueEventArgs): void;
        invokeGetImageURL(sender: any, e: StiValueEventArgs): void;
        get getImageURLEvent(): StiGetImageURLEvent;
        set getImageURLEvent(value: StiGetImageURLEvent);
        private static eventGetImageData;
        protected onGetImageData(e: StiGetImageDataEventArgs): void;
        invokeGetImageData(sender: any, e: StiGetImageDataEventArgs): void;
        defaultClientRectangle: RectangleD;
        get getImageDataEvent(): StiGetImageDataEvent;
        set getImageDataEvent(value: StiGetImageDataEvent);
        private static propertyProcessingDuplicates;
        get processingDuplicates(): StiImageProcessingDuplicatesType;
        set processingDuplicates(value: StiImageProcessingDuplicatesType);
        private _imageRotation;
        get imageRotation(): StiImageRotation;
        set imageRotation(value: StiImageRotation);
        private _image;
        get image(): Image;
        set image(value: Image);
        margins: StiMargins;
        private _file;
        get file(): string;
        set file(value: string);
        private _dataColumn;
        get dataColumn(): string;
        set dataColumn(value: string);
        private _imageURL;
        get imageURL(): string;
        set imageURL(value: string);
        private _imageData;
        get imageData(): string;
        set imageData(value: string);
        icon: StiFontIcons;
        iconColor: Color;
        convertImageMargins(rect: RectangleD, convert: boolean): RectangleD;
    }
}
export namespace Stimulsoft.Report.Components.Table {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    class StiTableCellImage extends StiImage implements IStiTableCell, IStiTableComponent, IStiJsonReportObject {
        private static ImplementsStiTableCellImage;
        implements(): any[];
        meta(): StiMeta[];
        private loadJoinCellsFromXml;
        get componentId(): StiComponentId;
        clone(cloneProperties: boolean): StiTableCellImage;
        get locked(): boolean;
        get linked(): boolean;
        get canGrow(): boolean;
        set canGrow(value: boolean);
        cellDockStyle: StiDockStyle;
        parentJoinCell: StiComponent;
        _joinCells: number[];
        get joinCells(): number[];
        set joinCells(value: number[]);
        _parentJoin: number;
        get parentJoin(): number;
        set parentJoin(value: number);
        _join: boolean;
        get join(): boolean;
        set join(value: boolean);
        id: number;
        joinWidth: number;
        joinHeight: number;
        get merged(): boolean;
        get changeTopPosition(): boolean;
        get changeLeftPosition(): boolean;
        get changeRightPosition(): boolean;
        tableTag: any;
        private _cellType;
        get cellType(): StiTablceCellType;
        set cellType(value: StiTablceCellType);
        fixedWidth: boolean;
        column: number;
        getJoinComponentByGuid(id: number): StiComponent;
        getJoinComponentByIndex(index: number): StiComponent;
        containsGuid(id: number): boolean;
        private createJoin;
        private deleteJoin;
        private getNewClientRectangle;
        setJoinSize(): void;
        getRealHeightAfterInsertRows(): number;
        getRealHeight(): number;
        getRealTop(): number;
        getRealWidth(): number;
        getRealLeft(): number;
        createNew(): StiComponent;
    }
}
export namespace Stimulsoft.Report.Components.Table {
    class StiColumnSize {
        private _widths;
        private _fixedColumns;
        private _minWidths;
        setFixedColumn(indexCol: number, width: number): void;
        add(indexCol: number, width: number): void;
        addLastNotFixed(width: number): void;
        subtract(indexCol: number, width: number, checkMin?: boolean): void;
        setWidth(indexCol: number, width: number): void;
        setMinWidths(indexCol: number, minWidth: number): void;
        getFixed(index: number): boolean;
        get length(): number;
        getCountNotFixedColumn(): number;
        getCountNotFixedColumnAndWidth(): number;
        getCountNotFixedColumnAndNotMinSize(): number;
        getWidth(indexCol: number): number;
        normalize(): void;
        constructor(size: number);
    }
}
export namespace Stimulsoft.Report.Components.Table {
    import IStiTableCell = Stimulsoft.Report.Components.Table.IStiTableCell;
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiUnit = Stimulsoft.Report.Units.StiUnit;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    import SizeD = Stimulsoft.System.Drawing.Size;
    import Color = Stimulsoft.System.Drawing.Color;
    class StiTable extends StiDataBand implements IStiTableComponent, IStiJsonReportObject {
        private static ImplementsStiTable;
        implements(): any[];
        meta(): StiMeta[];
        get componentId(): StiComponentId;
        clone(cloneProperties: boolean, cloneComponents: boolean): StiTable;
        convert(oldUnit: StiUnit, newUnit: StiUnit, isReportSnapshot?: boolean): void;
        get canGrow(): boolean;
        set canGrow(value: boolean);
        get localizedName(): string;
        get localizedCategory(): string;
        isConverted: boolean;
        dockableTable: boolean;
        autoWidth: StiTableAutoWidth;
        autoWidthType: StiTableAutoWidthType;
        private _rowCount;
        get rowCount(): number;
        set rowCount(value: number);
        private _columnCount;
        get columnCount(): number;
        set columnCount(value: number);
        private _footerRowsCount;
        get footerRowsCount(): number;
        set footerRowsCount(value: number);
        private _headerRowsCount;
        get headerRowsCount(): number;
        set headerRowsCount(value: number);
        get defaultHeightCell(): number;
        headerPrintOn: StiPrintOnType;
        headerCanGrow: boolean;
        headerCanShrink: boolean;
        headerCanBreak: boolean;
        headerPrintAtBottom: boolean;
        headerPrintIfEmpty: boolean;
        headerPrintOnAllPages: boolean;
        headerPrintOnEvenOddPages: StiPrintOnEvenOddPagesType;
        footerPrintOn: StiPrintOnType;
        footerCanGrow: boolean;
        footerCanShrink: boolean;
        footerCanBreak: boolean;
        footerPrintAtBottom: boolean;
        footerPrintIfEmpty: boolean;
        footerPrintOnAllPages: boolean;
        footerPrintOnEvenOddPages: StiPrintOnEvenOddPagesType;
        numberID: number;
        columns: number;
        columnWidth: number;
        columnGaps: number;
        minRowsInColumn: number;
        get minHeight(): number;
        set minHeight(value: number);
        get maxHeight(): number;
        set maxHeight(value: number);
        get minSize(): SizeD;
        set minSize(value: SizeD);
        get rightToLeft(): boolean;
        set rightToLeft(value: boolean);
        get width(): number;
        set width(value: number);
        get height(): number;
        set height(value: number);
        defaultClientRectangle: RectangleD;
        get dockable(): boolean;
        set dockable(value: boolean);
        get headerStartColor(): Color;
        get headerEndColor(): Color;
        changeGrowToHeightAtCell(cell: StiComponent): void;
        private _tableStyleFX;
        get tableStyleFX(): StiTableStyleFX;
        set tableStyleFX(value: StiTableStyleFX);
        private applyCustomStyle;
        refreshTableStyle(): void;
        applyStyleNone(): void;
        private changeRowCount;
        private changeColumnCount;
        createJoin(REFsumWidth: any, REFsumHeight: any, REFjoinWidth: any, REFjoinHeight: any): number[];
        private getCountSelectedCells;
        private getCountJoinSelectedCells;
        private findLeftSelectedElement;
        private findRightSelectedElement;
        changeTableCellContentInImage(cell: StiTableCell | StiTableCellCheckBox | StiTableCellRichText): void;
        changeTableCellContentInText(cell: StiTableCellImage | StiTableCellCheckBox | StiTableCellRichText): void;
        changeTableCellContentInCheckBox(cell: StiTableCellImage | StiTableCell | StiTableCellRichText): void;
        changeTableCellContentInRichText(cell: StiTableCell | StiTableCellImage | StiTableCellCheckBox): void;
        getColumnForCell(cell: IStiTableCell): number;
        private setCellID;
        createCell(): void;
        private setStyleForCell;
        private addNewRows;
        private deleteLastRows;
        private addTableNewColumns;
        private deleteTableColumns;
        insertColumnToLeft(numberColumn: number): void;
        insertColumnToRight(numberColumn: number): void;
        insertRowAbove(numberRow: number): void;
        insertRowBelow(numberRow: number): void;
        deleteRows(firstRow: number, lastRow: number): StiComponent[];
        deleteColumns(firstColumn: number, lastColumn: number): StiComponent[];
        distributeRows(): void;
        distributeColumns(): void;
        autoSizeCells(): void;
        private resizeWidthCellsAfterChanges;
        private resizeHeightCellsAfterChanges;
        private resizeWidthCell;
        private resizeHeightCell;
        startRenderTableBand(REFnewTableComponents: any): StiDataBand;
        private startRenderTable;
        private reverseCells;
        private setFilter;
        private setInteraction;
        private getParentJoin;
        private isEqualRows;
        createNew(): StiComponent;
        constructor(rect?: RectangleD);
    }
}
export namespace Stimulsoft.Report.Components {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import List = Stimulsoft.System.Collections.List;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import Color = Stimulsoft.System.Drawing.Color;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiTableOfContents extends StiDataBand implements IStiJsonReportObject {
        implements(): any[];
        meta(): StiMeta[];
        get componentId(): StiComponentId;
        clone(cloneProperties: boolean): StiBand;
        get priority(): number;
        defaultClientRectangle: RectangleD;
        get toolboxPosition(): number;
        get localizedName(): string;
        helpUrl: () => string;
        get countData(): number;
        set countData(value: number);
        get canBreak(): boolean;
        set canBreak(value: boolean);
        get canGrow(): boolean;
        set canGrow(value: boolean);
        get canShrink(): boolean;
        set canShrink(value: boolean);
        get headerStartColor(): Color;
        get headerEndColor(): Color;
        getHeaderText(): string;
        createNew: () => StiTableOfContents;
        getStylesList(): List<Stimulsoft.Report.Styles.StiStyle>;
        wordWrap: boolean;
        get isFirstInReport(): boolean;
        styles: Styles.StiStylesCollection;
        indent: number;
        reportPointer: string;
        margins: StiMargins;
        shouldSerializeMargins(): boolean;
        constructor(rect?: RectangleD);
    }
}
export namespace Stimulsoft.Report.Components {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiJson = Stimulsoft.Base.StiJson;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    class StiBookmark {
        protected _hash: StiMeta[];
        meta(): StiMeta[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        loadFromXml(xmlNode: XmlNode): void;
        add(name: string): void;
        private _bookmarks;
        get bookmarks(): StiBookmarksCollection;
        set bookmarks(value: StiBookmarksCollection);
        text: string;
        bookmarkText: string;
        parentComponent: any;
        componentGuid: string;
        isManualBookmark: boolean;
        pageIndex: number;
        constructor(text?: string, parentComponent?: any);
    }
}
export namespace Stimulsoft.Report.Components {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiGetFonts = Stimulsoft.Base.IStiGetFonts;
    import Size = Stimulsoft.System.Drawing.Size;
    import ContentAlignment = Stimulsoft.System.Drawing.ContentAlignment;
    import Color = Stimulsoft.System.Drawing.Color;
    import Font = Stimulsoft.System.Drawing.Font;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    class StiCondition extends StiBaseCondition implements IStiJsonReportObject, IStiGetFonts {
        implements(): any[];
        meta(): StiMeta[];
        clone(): StiCondition;
        getFonts(): Font[];
        enabled: boolean;
        textColor: Color;
        backColor: Color;
        font: Font;
        canAssignExpression: boolean;
        breakIfTrue: boolean;
        assignExpression: string;
        style: string;
        private _borderSides;
        get borderSides(): StiConditionBorderSides;
        set borderSides(value: StiConditionBorderSides);
        permissions: StiConditionPermissions;
        icon: number[];
        iconAlignment: ContentAlignment;
        iconSize: Size;
        equals(obj: any): boolean;
        constructor(item?: StiFilterItem, column?: string, condition?: StiFilterCondition, value1?: string, value2?: string, dataType?: StiFilterDataType, expression?: string, textColor?: Color, backColor?: Color, font?: Font, enabled?: boolean, canAssignExpression?: boolean, assignExpression?: string, style?: string, borderSides?: StiConditionBorderSides, permissions?: StiConditionPermissions, icon?: number[], iconAlignment?: ContentAlignment, iconSize?: Size);
    }
}
export namespace Stimulsoft.Report.Components {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import Color = Stimulsoft.System.Drawing.Color;
    import Font = Stimulsoft.System.Drawing.Font;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    class StiMultiCondition extends StiCondition implements IStiFilter, IStiJsonReportObject {
        implements(): any[];
        meta(): StiMeta[];
        loadfromXmlDoc(xmlDoc: XmlNode): void;
        clone(): StiMultiCondition;
        filterMode: StiFilterMode;
        filters: StiFiltersCollection;
        get filterMethodHandler(): Function;
        set filterMethodHandler(value: Function);
        get filterOn(): boolean;
        equals(obj: any): boolean;
        constructor(textColor?: Color, backColor?: Color, font?: Font, enabled?: boolean, filterMode?: StiFilterMode, filters?: StiFilter[], canAssignExpression?: boolean, assignExpression?: string, style?: string, borderSides?: StiConditionBorderSides);
    }
}
export namespace Stimulsoft.Report.Dictionary {
    let IStiEnumerator: System.Interface<IStiEnumerator>;
    interface IStiEnumerator {
        firstAsync(): any;
        first(): any;
        prior(): any;
        nextAsync(): any;
        next(): any;
        last(): any;
        position: number;
        count: number;
        isEof: boolean;
        isBof: boolean;
        isEmpty: boolean;
    }
}
export namespace Stimulsoft.Report.Components {
    class StiDataHelper {
        static setDataAsync(component: StiComponent, reinit: boolean, masterComponent?: StiComponent, allowReconnectOnEachRow?: boolean): Promise<void>;
        static setData(component: StiComponent, reinit: boolean, masterComponent?: StiComponent, allowReconnectOnEachRow?: boolean): void;
        static needGroupSort(band: StiDataBand): boolean;
        static getFilterEventHandler(component: StiComponent, dataSource: any): any;
        static getFilterExpression(filter: StiFilter, fullColumnName: string, report: StiReport): string;
    }
}
export namespace Stimulsoft.Report.Components {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import CollectionBase = Stimulsoft.System.Collections.CollectionBase;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiJson = Stimulsoft.Base.StiJson;
    class StiPagesCollection extends CollectionBase<StiPage> implements IStiStateSaveRestore, IStiJsonReportObject {
        implements(): any[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        loadFromXml(xmlNode: XmlNode): void;
        add(page: StiPage): void;
        addV2Internal(page: StiPage): void;
        remove(page: StiPage): any;
        remove(startIndex: number, endCount: number): any;
        getPageWithoutCache(pageIndex: number): StiPage;
        getByName(name: string): StiPage;
        setByName(name: string, page: StiPage): void;
        getComponentByName(componentName: string): StiComponent;
        getComponentByGuid(guid: string): StiComponent;
        private static setParent;
        saveState(stateName: string): void;
        restoreState(stateName: string): void;
        clearAllStates(): void;
        canUseCacheMode: boolean;
        report: StiReport;
        cacheMode: boolean;
        get containsDashboards(): boolean;
        private quickCachedPages;
        notCachedPages: StiPage[];
        isNotSavedPage(page: StiPage): boolean;
        markPageAsNotSaved(page: StiPage): void;
        getPage(page: StiPage): StiPage;
        savePage(page: StiPage): void;
        constructor(report: StiReport, originalPages?: StiPagesCollection);
    }
}
export namespace Stimulsoft.Report.Components {
    let IStiConditions: System.Interface<IStiConditions>;
    interface IStiConditions {
        conditions: StiConditionsCollection;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    import Hashtable = Stimulsoft.System.Collections.Hashtable;
    import Type = Stimulsoft.System.Type;
    class StiFunctions {
        static removeFunction(functionName: string): void;
        static getFunctionsList(functionName: string): StiFunction[];
        static getFunctionsGrouppedInCategories(): Hashtable;
        static getFunctions(categoryOrIsCompile: string | boolean): StiFunction[];
        static getFunctionsEx(report: StiReport, functionName: string, isCompile: boolean): StiFunction[];
        static getCategories(): string[];
        static getAssebliesOfFunctions(): string[];
        static addFunction(category: string, groupFunctionName: string, functionName: string, description: string, typeOfFunction: string, returnType: Type, returnDescription?: string, argumentTypes?: Type[], argumentNames?: string[], argumentDescriptions?: string[], jsFunction?: Function): StiFunction;
        static StiFunctions(): void;
    }
}
export namespace Stimulsoft.Report.Engine {
    enum StiTokenType {
        Empty = 0,
        Delimiter = 1,
        Variable = 2,
        SystemVariable = 3,
        DataSourceField = 4,
        BusinessObjectField = 5,
        Number = 6,
        Function = 7,
        Method = 8,
        Property = 9,
        Component = 10,
        Cast = 11,
        String = 12,
        Char = 13,
        RefVariable = 14,
        New = 15,
        CastAs = 16,
        Dot = 17,
        Comma = 18,
        Colon = 19,
        SemiColon = 20,
        Shl = 21,
        Shr = 22,
        Assign = 23,
        Equal = 24,
        NotEqual = 25,
        LeftEqual = 26,
        Left = 27,
        RightEqual = 28,
        Right = 29,
        Not = 30,
        Or = 31,
        And = 32,
        Xor = 33,
        DoubleOr = 34,
        DoubleAnd = 35,
        Question = 36,
        DoubleQuestion = 37,
        Plus = 38,
        Minus = 39,
        Mult = 40,
        Div = 41,
        Percent = 42,
        LParenthesis = 43,
        RParenthesis = 44,
        LBracket = 45,
        RBracket = 46,
        Identifier = 47,
        Unknown = 48
    }
    enum StiAsmCommandType {
        PushValue = 2000,
        PushVariable = 2001,
        PushSystemVariable = 2002,
        PushDataSourceField = 2003,
        PushBusinessObjectField = 2004,
        PushFunction = 2005,
        PushMethod = 2006,
        PushProperty = 2007,
        PushComponent = 2008,
        PushArrayElement = 2009,
        CopyToVariable = 2010,
        Add = 2020,
        Sub = 2021,
        Mult = 2022,
        Div = 2023,
        Mod = 2024,
        Power = 2025,
        Neg = 2026,
        Cast = 2027,
        Not = 2028,
        CompareLeft = 2029,
        CompareLeftEqual = 2030,
        CompareRight = 2031,
        CompareRightEqual = 2032,
        CompareEqual = 2033,
        CompareNotEqual = 2034,
        Shl = 2035,
        Shr = 2036,
        And = 2037,
        And2 = 2038,
        Or = 2039,
        Or2 = 2040,
        Xor = 2041,
        Jump = 2042,
        JumpTrue = 2043,
        JumpFalse = 2044,
        JumpNotNull = 2045
    }
    enum StiSystemVariableType {
        Column = 0,
        Line = 1,
        LineThrough = 2,
        LineABC = 3,
        LineRoman = 4,
        GroupLine = 5,
        PageNumber = 6,
        PageNumberThrough = 7,
        PageNofM = 8,
        PageNofMThrough = 9,
        TotalPageCount = 10,
        TotalPageCountThrough = 11,
        IsFirstPage = 12,
        IsFirstPageThrough = 13,
        IsLastPage = 14,
        IsLastPageThrough = 15,
        PageCopyNumber = 16,
        ReportAlias = 17,
        ReportAuthor = 18,
        ReportChanged = 19,
        ReportCreated = 20,
        ReportDescription = 21,
        ReportName = 22,
        Time = 23,
        Today = 24,
        ConditionValue = 25,
        ConditionValue2 = 26,
        Index = 27,
        ConditionTag = 28,
        Sender = 29,
        DateTimeNow = 30,
        DateTimeToday = 31
    }
    enum StiPropertyType {
        Year = 0,
        Month = 1,
        Day = 2,
        Hour = 3,
        Minute = 4,
        Second = 5,
        Date = 6,
        DayOfWeek = 7,
        Length = 8,
        From = 9,
        To = 10,
        FromDate = 11,
        ToDate = 12,
        FromTime = 13,
        ToTime = 14,
        SelectedLine = 15,
        Name = 16,
        TagValue = 17,
        Days = 18,
        Hours = 19,
        Milliseconds = 20,
        Minutes = 21,
        Seconds = 22,
        Ticks = 23,
        TotalDays = 24,
        TotalHours = 25,
        TotalMinutes = 26,
        TotalSeconds = 27,
        TotalMilliseconds = 28,
        Count = 29,
        BusinessObjectValue = 30,
        Position = 31,
        Line = 32,
        Rows = 33,
        Text = 34,
        Enabled = 35,
        Skip = 36,
        Alias = 37,
        Page = 38,
        Pages = 39,
        CrossColumnValue = 40,
        CrossRowValue = 41
    }
    enum StiFunctionType {
        NameSpace = 0,
        Count = 1,
        CountDistinct = 2,
        Avg = 3,
        AvgD = 4,
        AvgDate = 5,
        AvgI = 6,
        AvgTime = 7,
        Max = 8,
        MaxD = 9,
        MaxDate = 10,
        MaxI = 11,
        MaxStr = 12,
        MaxTime = 13,
        Median = 14,
        MedianD = 15,
        MedianI = 16,
        Min = 17,
        MinD = 18,
        MinDate = 19,
        MinI = 20,
        MinStr = 21,
        MinTime = 22,
        Mode = 23,
        ModeD = 24,
        ModeI = 25,
        Sum = 26,
        SumD = 27,
        SumDistinct = 28,
        SumI = 29,
        SumTime = 30,
        StDev = 31,
        StDevP = 32,
        First = 33,
        Last = 34,
        rCount = 35,
        rCountDistinct = 36,
        rAvg = 37,
        rAvgD = 38,
        rAvgDate = 39,
        rAvgI = 40,
        rAvgTime = 41,
        rMax = 42,
        rMaxD = 43,
        rMaxDate = 44,
        rMaxI = 45,
        rMaxStr = 46,
        rMaxTime = 47,
        rMedian = 48,
        rMedianD = 49,
        rMedianI = 50,
        rMin = 51,
        rMinD = 52,
        rMinDate = 53,
        rMinI = 54,
        rMinStr = 55,
        rMinTime = 56,
        rMode = 57,
        rModeD = 58,
        rModeI = 59,
        rSum = 60,
        rSumD = 61,
        rSumDistinct = 62,
        rSumI = 63,
        rSumTime = 64,
        rStDev = 65,
        rStDevP = 66,
        rFirst = 67,
        rLast = 68,
        iCount = 69,
        iCountDistinct = 70,
        iAvg = 71,
        iAvgD = 72,
        iAvgDate = 73,
        iAvgI = 74,
        iAvgTime = 75,
        iMax = 76,
        iMaxD = 77,
        iMaxDate = 78,
        iMaxI = 79,
        iMaxStr = 80,
        iMaxTime = 81,
        iMedian = 82,
        iMedianD = 83,
        iMedianI = 84,
        iMin = 85,
        iMinD = 86,
        iMinDate = 87,
        iMinI = 88,
        iMinStr = 89,
        iMinTime = 90,
        iMode = 91,
        iModeD = 92,
        iModeI = 93,
        iSum = 94,
        iSumD = 95,
        iSumDistinct = 96,
        iSumI = 97,
        iSumTime = 98,
        iStDev = 99,
        iStDevP = 100,
        iFirst = 101,
        iLast = 102,
        riCount = 103,
        riCountDistinct = 104,
        riAvg = 105,
        riAvgD = 106,
        riAvgDate = 107,
        riAvgI = 108,
        riAvgTime = 109,
        riMax = 110,
        riMaxD = 111,
        riMaxDate = 112,
        riMaxI = 113,
        riMaxStr = 114,
        riMaxTime = 115,
        riMedian = 116,
        riMedianD = 117,
        riMedianI = 118,
        riMin = 119,
        riMinD = 120,
        riMinDate = 121,
        riMinI = 122,
        riMinStr = 123,
        riMinTime = 124,
        riMode = 125,
        riModeD = 126,
        riModeI = 127,
        riSum = 128,
        riSumD = 129,
        riSumDistinct = 130,
        riSumI = 131,
        riSumTime = 132,
        riStDev = 133,
        riStDevP = 134,
        riFirst = 135,
        riLast = 136,
        cCount = 137,
        cCountDistinct = 138,
        cAvg = 139,
        cAvgD = 140,
        cAvgDate = 141,
        cAvgI = 142,
        cAvgTime = 143,
        cMax = 144,
        cMaxD = 145,
        cMaxDate = 146,
        cMaxI = 147,
        cMaxStr = 148,
        cMaxTime = 149,
        cMedian = 150,
        cMedianD = 151,
        cMedianI = 152,
        cMin = 153,
        cMinD = 154,
        cMinDate = 155,
        cMinI = 156,
        cMinStr = 157,
        cMinTime = 158,
        cMode = 159,
        cModeD = 160,
        cModeI = 161,
        cSum = 162,
        cSumD = 163,
        cSumDistinct = 164,
        cSumI = 165,
        cSumTime = 166,
        cStDev = 167,
        cStDevP = 168,
        cFirst = 169,
        cLast = 170,
        crCount = 171,
        crCountDistinct = 172,
        crAvg = 173,
        crAvgD = 174,
        crAvgDate = 175,
        crAvgI = 176,
        crAvgTime = 177,
        crMax = 178,
        crMaxD = 179,
        crMaxDate = 180,
        crMaxI = 181,
        crMaxStr = 182,
        crMaxTime = 183,
        crMedian = 184,
        crMedianD = 185,
        crMedianI = 186,
        crMin = 187,
        crMinD = 188,
        crMinDate = 189,
        crMinI = 190,
        crMinStr = 191,
        crMinTime = 192,
        crMode = 193,
        crModeD = 194,
        crModeI = 195,
        crSum = 196,
        crSumD = 197,
        crSumDistinct = 198,
        crSumI = 199,
        crSumTime = 200,
        crStDev = 201,
        crStDevP = 202,
        crFirst = 203,
        crLast = 204,
        ciCount = 205,
        ciCountDistinct = 206,
        ciAvg = 207,
        ciAvgD = 208,
        ciAvgDate = 209,
        ciAvgI = 210,
        ciAvgTime = 211,
        ciMax = 212,
        ciMaxD = 213,
        ciMaxDate = 214,
        ciMaxI = 215,
        ciMaxStr = 216,
        ciMaxTime = 217,
        ciMedian = 218,
        ciMedianD = 219,
        ciMedianI = 220,
        ciMin = 221,
        ciMinD = 222,
        ciMinDate = 223,
        ciMinI = 224,
        ciMinStr = 225,
        ciMinTime = 226,
        ciMode = 227,
        ciModeD = 228,
        ciModeI = 229,
        ciSum = 230,
        ciSumD = 231,
        ciSumDistinct = 232,
        ciSumI = 233,
        ciSumTime = 234,
        ciStDev = 235,
        ciStDevP = 236,
        ciFirst = 237,
        ciLast = 238,
        criCount = 239,
        criCountDistinct = 240,
        criAvg = 241,
        criAvgD = 242,
        criAvgDate = 243,
        criAvgI = 244,
        criAvgTime = 245,
        criMax = 246,
        criMaxD = 247,
        criMaxDate = 248,
        criMaxI = 249,
        criMaxStr = 250,
        criMaxTime = 251,
        criMedian = 252,
        criMedianD = 253,
        criMedianI = 254,
        criMin = 255,
        criMinD = 256,
        criMinDate = 257,
        criMinI = 258,
        criMinStr = 259,
        criMinTime = 260,
        criMode = 261,
        criModeD = 262,
        criModeI = 263,
        criSum = 264,
        criSumD = 265,
        criSumDistinct = 266,
        criSumI = 267,
        criSumTime = 268,
        criStDev = 269,
        criStDevP = 270,
        criFirst = 271,
        criLast = 272,
        pCount = 273,
        pCountDistinct = 274,
        pAvg = 275,
        pAvgD = 276,
        pAvgDate = 277,
        pAvgI = 278,
        pAvgTime = 279,
        pMax = 280,
        pMaxD = 281,
        pMaxDate = 282,
        pMaxI = 283,
        pMaxStr = 284,
        pMaxTime = 285,
        pMedian = 286,
        pMedianD = 287,
        pMedianI = 288,
        pMin = 289,
        pMinD = 290,
        pMinDate = 291,
        pMinI = 292,
        pMinStr = 293,
        pMinTime = 294,
        pMode = 295,
        pModeD = 296,
        pModeI = 297,
        pSum = 298,
        pSumD = 299,
        pSumDistinct = 300,
        pSumI = 301,
        pSumTime = 302,
        pStDev = 303,
        pStDevP = 304,
        pFirst = 305,
        pLast = 306,
        prCount = 307,
        prCountDistinct = 308,
        prAvg = 309,
        prAvgD = 310,
        prAvgDate = 311,
        prAvgI = 312,
        prAvgTime = 313,
        prMax = 314,
        prMaxD = 315,
        prMaxDate = 316,
        prMaxI = 317,
        prMaxStr = 318,
        prMaxTime = 319,
        prMedian = 320,
        prMedianD = 321,
        prMedianI = 322,
        prMin = 323,
        prMinD = 324,
        prMinDate = 325,
        prMinI = 326,
        prMinStr = 327,
        prMinTime = 328,
        prMode = 329,
        prModeD = 330,
        prModeI = 331,
        prSum = 332,
        prSumD = 333,
        prSumDistinct = 334,
        prSumI = 335,
        prSumTime = 336,
        prStDev = 337,
        prStDevP = 338,
        prFirst = 339,
        prLast = 340,
        piCount = 341,
        piCountDistinct = 342,
        piAvg = 343,
        piAvgD = 344,
        piAvgDate = 345,
        piAvgI = 346,
        piAvgTime = 347,
        piMax = 348,
        piMaxD = 349,
        piMaxDate = 350,
        piMaxI = 351,
        piMaxStr = 352,
        piMaxTime = 353,
        piMedian = 354,
        piMedianD = 355,
        piMedianI = 356,
        piMin = 357,
        piMinD = 358,
        piMinDate = 359,
        piMinI = 360,
        piMinStr = 361,
        piMinTime = 362,
        piMode = 363,
        piModeD = 364,
        piModeI = 365,
        piSum = 366,
        piSumD = 367,
        piSumDistinct = 368,
        piSumI = 369,
        piSumTime = 370,
        piStDev = 371,
        piStDevP = 372,
        piFirst = 373,
        piLast = 374,
        priCount = 375,
        priCountDistinct = 376,
        priAvg = 377,
        priAvgD = 378,
        priAvgDate = 379,
        priAvgI = 380,
        priAvgTime = 381,
        priMax = 382,
        priMaxD = 383,
        priMaxDate = 384,
        priMaxI = 385,
        priMaxStr = 386,
        priMaxTime = 387,
        priMedian = 388,
        priMedianD = 389,
        priMedianI = 390,
        priMin = 391,
        priMinD = 392,
        priMinDate = 393,
        priMinI = 394,
        priMinStr = 395,
        priMinTime = 396,
        priMode = 397,
        priModeD = 398,
        priModeI = 399,
        priSum = 400,
        priSumD = 401,
        priSumDistinct = 402,
        priSumI = 403,
        priSumTime = 404,
        priStDev = 405,
        priStDevP = 406,
        priFirst = 407,
        priLast = 408,
        CountAllLevels = 409,
        CountAllLevelsOnlyChilds = 410,
        CountOnlyChilds = 411,
        CountDistinctAllLevels = 412,
        CountDistinctAllLevelsOnlyChilds = 413,
        CountDistinctOnlyChilds = 414,
        SumAllLevels = 415,
        SumAllLevelsOnlyChilds = 416,
        SumOnlyChilds = 417,
        SumTimeAllLevels = 418,
        SumTimeAllLevelsOnlyChilds = 419,
        SumTimeOnlyChilds = 420,
        AvgAllLevels = 421,
        AvgAllLevelsOnlyChilds = 422,
        AvgOnlyChilds = 423,
        AvgDateAllLevels = 424,
        AvgDateAllLevelsOnlyChilds = 425,
        AvgDateOnlyChilds = 426,
        AvgTimeAllLevels = 427,
        AvgTimeAllLevelsOnlyChilds = 428,
        AvgTimeOnlyChilds = 429,
        MaxAllLevels = 430,
        MaxAllLevelsOnlyChilds = 431,
        MaxOnlyChilds = 432,
        MinAllLevels = 433,
        MinAllLevelsOnlyChilds = 434,
        MinOnlyChilds = 435,
        MedianAllLevels = 436,
        MedianAllLevelsOnlyChilds = 437,
        MedianOnlyChilds = 438,
        ModeAllLevels = 439,
        ModeAllLevelsOnlyChilds = 440,
        ModeOnlyChilds = 441,
        FirstAllLevels = 442,
        FirstAllLevelsOnlyChilds = 443,
        FirstOnlyChilds = 444,
        LastAllLevels = 445,
        LastAllLevelsOnlyChilds = 446,
        LastOnlyChilds = 447,
        MinDateAllLevels = 448,
        MinDateAllLevelsOnlyChilds = 449,
        MinDateOnlyChilds = 450,
        MinTimeAllLevels = 451,
        MinTimeAllLevelsOnlyChilds = 452,
        MinTimeOnlyChilds = 453,
        MinStrAllLevels = 454,
        MinStrAllLevelsOnlyChilds = 455,
        MinStrOnlyChilds = 456,
        MaxDateAllLevels = 457,
        MaxDateAllLevelsOnlyChilds = 458,
        MaxDateOnlyChilds = 459,
        MaxTimeAllLevels = 460,
        MaxTimeAllLevelsOnlyChilds = 461,
        MaxTimeOnlyChilds = 462,
        MaxStrAllLevels = 463,
        MaxStrAllLevelsOnlyChilds = 464,
        MaxStrOnlyChilds = 465,
        Rank = 466,
        Abs = 467,
        Acos = 468,
        Asin = 469,
        Atan = 470,
        Ceiling = 471,
        Cos = 472,
        Div = 473,
        Exp = 474,
        Floor = 475,
        Log = 476,
        Maximum = 477,
        Minimum = 478,
        Round = 479,
        Sign = 480,
        Sin = 481,
        Sqrt = 482,
        Tan = 483,
        Truncate = 484,
        DateDiff = 485,
        DateSerial = 486,
        Day = 487,
        DayOfWeek = 488,
        DayOfYear = 489,
        DaysInMonth = 490,
        DaysInYear = 491,
        Hour = 492,
        Minute = 493,
        Month = 494,
        Second = 495,
        TimeSerial = 496,
        Year = 497,
        MonthName = 498,
        WeekOfYear = 499,
        WeekOfMonth = 500,
        FromOADate = 501,
        ToOADate = 502,
        ToJapaneseDateString = 503,
        DateToStr = 504,
        DateToStrPl = 505,
        DateToStrRu = 506,
        DateToStrUa = 507,
        DateToStrPt = 508,
        DateToStrPtBr = 509,
        Insert = 510,
        Length = 511,
        Remove = 512,
        Replace = 513,
        Roman = 514,
        Substring = 515,
        ToCurrencyWords = 516,
        ToCurrencyWordsAr = 517,
        ToCurrencyWordsEnGb = 518,
        ToCurrencyWordsEnIn = 519,
        ToCurrencyWordsEs = 520,
        ToCurrencyWordsFr = 521,
        ToCurrencyWordsNl = 522,
        ToCurrencyWordsPl = 523,
        ToCurrencyWordsPt = 524,
        ToCurrencyWordsPtBr = 525,
        ToCurrencyWordsRu = 526,
        ToCurrencyWordsThai = 527,
        ToCurrencyWordsTr = 528,
        ToCurrencyWordsUa = 529,
        ToCurrencyWordsZh = 530,
        ToLowerCase = 531,
        ToProperCase = 532,
        ToUpperCase = 533,
        ToWords = 534,
        ToWordsAr = 535,
        ToWordsEs = 536,
        ToWordsEnIn = 537,
        ToWordsFa = 538,
        ToWordsPl = 539,
        ToWordsPt = 540,
        ToWordsRu = 541,
        ToWordsTr = 542,
        ToWordsUa = 543,
        Trim = 544,
        TryParseDateTime = 545,
        TryParseDecimal = 546,
        TryParseDouble = 547,
        TryParseLong = 548,
        Arabic = 549,
        Persian = 550,
        ToOrdinal = 551,
        Left = 552,
        Mid = 553,
        Right = 554,
        StrToDateTime = 555,
        StrToNullableDateTime = 556,
        IsNull = 557,
        Next = 558,
        NextIsNull = 559,
        Previous = 560,
        PreviousIsNull = 561,
        VLookup = 562,
        VLookupStr = 563,
        GetCrossTabColumnValue = 564,
        GetCrossTabRowValue = 565,
        IIF = 566,
        Choose = 567,
        Switch = 568,
        Rand = 569,
        ToString = 570,
        Format = 571,
        SystemConvertToBoolean = 572,
        SystemConvertToByte = 573,
        SystemConvertToChar = 574,
        SystemConvertToDateTime = 575,
        SystemConvertToDecimal = 576,
        SystemConvertToDouble = 577,
        SystemConvertToInt16 = 578,
        SystemConvertToInt32 = 579,
        SystemConvertToInt64 = 580,
        SystemConvertToSByte = 581,
        SystemConvertToSingle = 582,
        SystemConvertToString = 583,
        SystemConvertToUInt16 = 584,
        SystemConvertToUInt32 = 585,
        SystemConvertToUInt64 = 586,
        MathRound = 587,
        MathPow = 588,
        AddAnchor = 589,
        GetAnchorPageNumber = 590,
        GetAnchorPageNumberThrough = 591,
        ConvertRtf = 592,
        GetLabel = 593,
        GetParam = 594,
        Parse_Int = 595,
        Parse_Double = 596,
        Parse_Decimal = 597,
        Parse_DateTime = 598,
        Parse_TimeSpan = 599,
        ParseLong = 600,
        ParseDouble = 601,
        ParseDecimal = 602,
        ParseDateTime = 603,
        StringIsNullOrEmpty = 604,
        StringIsNullOrWhiteSpace = 605,
        EngineHelperJoinColumnContent = 606,
        EngineHelperToQueryString = 607,
        EngineHelperGetRealPageNumber = 608,
        m_Substring = 1000,
        m_ToString = 1001,
        m_ToLower = 1002,
        m_ToUpper = 1003,
        m_IndexOf = 1004,
        m_StartsWith = 1005,
        m_EndsWith = 1006,
        m_Replace = 1007,
        m_PadLeft = 1008,
        m_PadRight = 1009,
        m_TrimStart = 1010,
        m_TrimEnd = 1011,
        m_Parse = 1012,
        m_Contains = 1013,
        m_GetData = 1014,
        m_ToQueryString = 1015,
        m_AddYears = 1016,
        m_AddMonths = 1017,
        m_AddDays = 1018,
        m_AddHours = 1019,
        m_AddMinutes = 1020,
        m_AddSeconds = 1021,
        m_AddMilliseconds = 1022,
        m_ToShortDateString = 1023,
        m_ToShortTimeString = 1024,
        m_ToLongDateString = 1025,
        m_ToLongTimeString = 1026,
        m_GetCurrentConditionValue = 1027,
        m_Add = 1028,
        m_Subtract = 1029,
        m_MethodNameSpace = 1030,
        op_Add = 2020,
        op_Sub = 2021,
        op_Mult = 2022,
        op_Div = 2023,
        op_Mod = 2024,
        op_Power = 2025,
        op_Neg = 2026,
        op_Cast = 2027,
        op_Not = 2028,
        op_CompareLeft = 2029,
        op_CompareLeftEqual = 2030,
        op_CompareRight = 2031,
        op_CompareRightEqual = 2032,
        op_CompareEqual = 2033,
        op_CompareNotEqual = 2034,
        op_Shl = 2035,
        op_Shr = 2036,
        op_And = 2037,
        op_And2 = 2038,
        op_Or = 2039,
        op_Or2 = 2040,
        op_Xor = 2041,
        UserFunction = 3000
    }
    enum StiMethodType {
        Substring = 1000,
        ToString = 1001,
        ToLower = 1002,
        ToUpper = 1003,
        IndexOf = 1004,
        StartsWith = 1005,
        EndsWith = 1006,
        Replace = 1007,
        PadLeft = 1008,
        PadRight = 1009,
        TrimStart = 1010,
        TrimEnd = 1011,
        Parse = 1012,
        Contains = 1013,
        GetData = 1014,
        ToQueryString = 1015,
        AddYears = 1016,
        AddMonths = 1017,
        AddDays = 1018,
        AddHours = 1019,
        AddMinutes = 1020,
        AddSeconds = 1021,
        AddMilliseconds = 1022,
        ToShortDateString = 1023,
        ToShortTimeString = 1024,
        ToLongDateString = 1025,
        ToLongTimeString = 1026,
        GetCurrentConditionValue = 1027,
        Add = 1028,
        Subtract = 1029,
        MethodNameSpace = 1030
    }
    enum StiParameterNumber {
        Param1 = 1,
        Param2 = 2,
        Param3 = 4,
        Param4 = 8
    }
}
export namespace Stimulsoft.Report.Engine.StiParser {
    import Hashtable = Stimulsoft.System.Collections.Hashtable;
    import Type = Stimulsoft.System.Type;
    class StiParserMethodInfo {
        name: StiFunctionType;
        number: number;
        arguments: Type[];
        returnType: Type;
        constructor(name: StiFunctionType, numberr: number, argumentss: Type[], returnType?: Type);
    }
    class StiParser_Properties {
        protected get_category(par: any): number;
        protected report: StiReport;
        protected syntaxCaseSensitive: boolean;
        protected expressionPosition: number;
        private static _typesList;
        static get typesList(): Hashtable;
        private static _systemVariablesList;
        static get systemVariablesList(): Hashtable;
        private static _propertiesList;
        static get propertiesList(): Hashtable;
        private static _functionsList;
        static get functionsList(): Hashtable;
        private static _methodsList;
        static get methodsList(): Hashtable;
        private static _parametersList;
        static get parametersList(): Hashtable;
        private _componentsList;
        get componentsList(): Hashtable;
        private static _methodsHash;
        static get methodsHash(): Map<StiFunctionType, StiParserMethodInfo[]>;
        get constantsList(): Hashtable;
        private static _constantsList;
        private static _constantsList_low;
        static check_constantsList(): void;
        protected static namespaceObj: any;
        private static _namespacesList;
        static get namespacesList(): Hashtable;
        private static _keywordsList;
        static get keywordsList(): Hashtable;
        private lockUserFunctionsList;
        private _userFunctionsList;
        get userFunctionsList(): Hashtable;
    }
}
export namespace Stimulsoft.Report.Engine.StiParser {
    import Type = Stimulsoft.System.Type;
    enum ParserErrorCode {
        SyntaxError = 0,
        IntegralConstantIsTooLarge = 1,
        ExpressionIsEmpty = 2,
        DivisionByZero = 3,
        UnexpectedEndOfExpression = 4,
        NameDoesNotExistInCurrentContext = 5,
        UnprocessedLexemesRemain = 6,
        LeftParenthesisExpected = 7,
        RightParenthesisExpected = 8,
        FieldMethodOrPropertyNotFound = 9,
        OperatorCannotBeAppliedToOperands = 10,
        FunctionNotFound = 11,
        NoOverloadForMethodTakesNArguments = 12,
        FunctionHasInvalidArgument = 13,
        FunctionNotYetImplemented = 14,
        MethodHasInvalidArgument = 15,
        ItemDoesNotContainDefinition = 16,
        NoMatchingOverloadedMethod = 17,
        TheTypeOrNamespaceNotExistInTheNamespace = 18
    }
    class StiParserException {
        message: string;
        baseMessage: string;
        position: number;
        length: number;
        toString(): string;
        constructor(message: string);
    }
    class StiParser_Check extends StiParser_Properties {
        private static errorsList;
        protected throwError(code: ParserErrorCode, token?: StiToken, message1?: string, message2?: string, message3?: string, message4?: string): void;
        checkTypes(asmList: StiAsmCommand[]): void;
        private getMethodResultType;
        private getPropertyType;
        private getArrayElementType;
        protected get_systemVariable(name: any): any;
        static isImplicitlyCastableTo(from: Type, to: Type, valueFrom: object): boolean;
        protected getTypeName(value: any): string;
        report: StiReport;
        protected checkParserMethodInfo(type: StiFunctionType, args: any[]): number;
        getParserMethodInfo(type: StiFunctionType, args: Type[], argValues?: object[]): StiParserMethodInfo;
    }
}
export namespace Stimulsoft.Report.Engine.StiParser {
    import Hashtable = Stimulsoft.System.Collections.Hashtable;
    import StiComponent = Stimulsoft.Report.Components.StiComponent;
    class StiParser_Lexer extends StiParser_Check {
        protected position: number;
        protected useAliases: boolean;
        protected inputExpression: string;
        protected hashAliases: Hashtable;
        protected tokenPos: number;
        protected tokensList: StiToken[];
        protected component: StiComponent;
        protected runtimeConstants: Hashtable;
        protected runtimeConstantsHash: Hashtable;
        private getNextLexem;
        private static isWhiteSpace;
        private buildAliases;
        private buildBusinessObject;
        private static isValidName;
        private static getCorrectedAlias;
        private static replaceBackslash;
        private scanNumber;
        private postProcessTokensList;
        protected createRuntimeConstantsHash(): void;
        private getDataRelationByName;
        private getDataColumnByName;
        private preProcessNamespaces;
        protected makeTokensList(): void;
    }
}
export namespace Stimulsoft.Report.Engine.StiParser {
    class StiParser_AsmOperations extends StiParser_Lexer {
        protected op_Add(par1: any, par2: any): any;
        protected op_Sub(par1: any, par2: any): any;
        protected op_Mult(par1: any, par2: any): any;
        protected op_Div(par1: any, par2: any): any;
        protected op_Mod(par1: any, par2: any): any;
        protected op_Pow(par1: any, par2: any): any;
        protected op_Neg(par1: any): any;
        protected op_Not(par1: any): any;
        protected op_Cast(par1: any, par2: any): any;
        private toIntegerCheckChar;
        protected op_CompareLeft(par1: any, par2: any): any;
        protected op_CompareLeftEqual(par1: any, par2: any): any;
        protected op_CompareRight(par1: any, par2: any): any;
        protected op_CompareRightEqual(par1: any, par2: any): any;
        protected op_CompareEqual(par1: any, par2: any): any;
        protected op_CompareNotEqual(par1: any, par2: any): any;
        protected op_Shl(par1: any, par2: any): any;
        protected op_Shr(par1: any, par2: any): any;
        protected op_And(par1: any, par2: any): any;
        protected op_Or(par1: any, par2: any): any;
        protected op_Xor(par1: any, par2: any): any;
        protected op_And2(par1: any, par2: any): any;
        protected op_Or2(par1: any, par2: any): any;
    }
}
export namespace Stimulsoft.Report.Engine.StiParser {
    class StiParser_AsmProperties extends StiParser_AsmOperations {
        protected call_property(name: any, argsList: any[]): any;
    }
}
export namespace Stimulsoft.Report.Engine.StiParser {
    class StiParser_AsmMethods extends StiParser_AsmProperties {
        protected call_method(name: any, argsList: any[]): any;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    import DateTime = Stimulsoft.System.DateTime;
    import TimeSpan = Stimulsoft.System.TimeSpan;
    import CalendarWeekRule = Stimulsoft.System.Globalization.CalendarWeekRule;
    import DayOfWeek = Stimulsoft.System.DayOfWeek;
    class StiFunctionsDateTime {
        private static isCreated;
        static create(): void;
        static dateDiff(date1: DateTime, date2: DateTime): TimeSpan;
        static year(date: DateTime): number;
        static month(date: DateTime): number;
        static monthIdent(value: DateTime): any;
        static hour(date: DateTime): number;
        static minute(date: DateTime): number;
        static second(date: DateTime): number;
        static day(date: DateTime): number;
        static dayOfWeek(date: DateTime, loc?: boolean | string, upperCase?: boolean): string;
        static monthName(date: DateTime, loc?: boolean | string, upperCase?: boolean): string;
        static dayOfYear(date: DateTime): number;
        static dateSerial(year: number, month: number, day: number): DateTime;
        static timeSerial(hours: number, minutes: number, seconds: number): TimeSpan;
        static daysInMonth(yearOrDate: number | DateTime, month: number): number;
        static daysInYear(yearOrDate: number | DateTime): number;
        static weekOfYear(date: DateTime, firstDayOfWeek?: DayOfWeek, calendarWeekRule?: CalendarWeekRule): number;
        static weekOfMonth(date: DateTime, firstDayOfWeek?: DayOfWeek, calendarWeekRule?: CalendarWeekRule): number;
        static toJapaneseDateString(date: DateTime, format?: string): string;
        private static japaneseEras;
        private static japaneseErasName;
    }
}
export namespace Stimulsoft.Report.Engine.StiParser {
    class StiParser_AsmFunctions extends StiParser_AsmMethods {
        protected call_func(name: any, argsList: any[]): any;
    }
}
export namespace Stimulsoft.Report.Engine.StiParser {
    class StiParser_Parser extends StiParser_AsmFunctions {
        protected currentToken: StiToken;
        protected asmList: StiAsmCommand[];
        protected eval_exp(): void;
        private eval_exp0;
        private eval_exp01;
        private eval_exp1;
        private eval_exp10;
        private eval_exp11;
        private eval_exp12;
        private eval_exp14;
        private eval_exp15;
        private eval_exp16;
        private eval_exp17;
        private eval_exp18;
        private eval_exp2;
        private eval_exp3;
        private eval_exp4;
        private eval_exp5;
        private eval_exp6;
        private eval_exp62;
        private eval_exp7;
        private atom;
        private get_args_count;
        private get_args;
        private get_token;
    }
}
export namespace Stimulsoft.Report.Engine {
    import Hashtable = Stimulsoft.System.Collections.Hashtable;
    import StiParser = Stimulsoft.Report.Engine.StiParser.StiParser;
    class StiParserParameters {
        storeToPrint: boolean;
        executeIfStoreToPrint: boolean;
        returnAsmList: boolean;
        checkSyntaxMode: boolean;
        syntaxCaseSensitive: boolean;
        parser: StiParser;
        conversionStore: Hashtable;
        globalizedNameExt: string;
        ignoreGlobalizedName: boolean;
        constants: Hashtable;
        useAliases: boolean;
    }
}
export namespace Stimulsoft.Report.Engine.StiParser {
    import StiParserParameters = Stimulsoft.Report.Engine.StiParserParameters;
    import StiComponent = Stimulsoft.Report.Components.StiComponent;
    import Hashtable = Stimulsoft.System.Collections.Hashtable;
    import StiText = Stimulsoft.Report.Components.StiText;
    import StiVariable = Stimulsoft.Report.Dictionary.StiVariable;
    class StiParserData {
        data: any;
        asmList: StiAsmCommand[];
        asmList2: StiAsmCommand[];
        conditionAsmList: StiAsmCommand[];
        parser: StiParser;
        constructor(data: any, asmList: StiAsmCommand[], parser: StiParser, conditionAsmList?: StiAsmCommand[]);
    }
    class StiFilterParserData {
        component: StiComponent;
        expression: string;
        equals(obj: any): boolean;
        constructor(component: StiComponent, expression: string);
    }
    class StiToken {
        type: StiTokenType;
        value: string;
        valueObject: any;
        position: number;
        length: number;
        constructor(type?: StiTokenType, position?: number, length?: number);
        toString(): string;
    }
    class StiAsmCommand {
        type: StiAsmCommandType;
        parameter1: any;
        parameter2: any;
        position: number;
        length: number;
        constructor(type: StiAsmCommandType, parameter1?: any, parameter2?: any);
        toString(): string;
    }
    class StiParserGetDataFieldValueEventArgs {
        dataSourceName: string;
        dataColumnName: string;
        processed: boolean;
        value: any;
        asmCommand: StiAsmCommand;
        constructor(dataSourceName: string, dataColumnName: string);
    }
    class StiParser extends StiParser_Parser {
        private sender;
        executeAsm(objectAsmList: any): any;
        private getVariableValue;
        private call_arrayElement;
        protected get_systemVariable(name: any): any;
        static parseTextValue2(inputExpression: string, component: StiComponent, sender?: any, parameters?: StiParserParameters): any;
        static parseTextValue(inputExpression: string, component: StiComponent, sender?: any, REFstoreToPrint?: any, executeIfStoreToPrint?: boolean, returnAsmList?: boolean, parser?: StiParser, constants?: Hashtable): any;
        private parseToAsm;
        private static checkForStoreToPrint;
        static checkExpression(inputExpression: string, component: StiComponent, useAliases?: boolean): StiParserException;
        static checkForDataBandsUsedInPageTotals(stiText: StiText, report?: StiReport): void;
        static prepareReportVariables(report: StiReport): void;
        static prepareVariableValue(varr: StiVariable, report: StiReport, textBox?: StiText, fillItems?: boolean): any;
        private static getExpressionValue;
    }
}
export namespace Stimulsoft.Report.CrossTab {
    import IStiGlobalizationProvider = Stimulsoft.Report.IStiGlobalizationProvider;
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    class StiCrossCell extends StiCrossField implements IStiJsonReportObject, IStiGlobalizationProvider {
        meta(): StiMeta[];
        paint(g: Stimulsoft.System.Drawing.Graphics): void;
        setString(propertyName: string, value: string): void;
        protected globalizationSetString(propertyName: string, value: string): void;
        getString(propertyName: string): string;
        protected globalizationGetString(propertyName: string): string;
        getAllStrings(): string[];
        protected globalizationGetAllStrings(): string[];
        protected onGetCrossValue(e: StiGetCrossValueEventArgs): void;
        invokeGetCrossValue(e: StiGetCrossValueEventArgs): void;
        getCrossValueEvent: StiGetCrossValueEvent;
        private val;
        get value(): string;
        set value(value: string);
        getValue(): string;
        setValue(value: string): void;
    }
}
export namespace Stimulsoft.Report.CrossTab {
    import IStiGlobalizationProvider = Stimulsoft.Report.IStiGlobalizationProvider;
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import StiDataTopN = Stimulsoft.Data.Engine.StiDataTopN;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiSortType = Stimulsoft.Report.CrossTab.Core.StiSortType;
    import StiSortDirection = Stimulsoft.Report.CrossTab.Core.StiSortDirection;
    class StiCrossHeader extends StiCrossCell implements IStiJsonReportObject, IStiGlobalizationProvider {
        meta(): StiMeta[];
        protected onGetDisplayCrossValue(e: StiGetCrossValueEventArgs): void;
        invokeGetDisplayCrossValue(e: StiGetCrossValueEventArgs): void;
        getDisplayCrossValueEvent: StiGetDisplayCrossValueEvent;
        setString(propertyName: string, value: string): void;
        protected globalizationSetString(propertyName: string, value: string): void;
        getString(propertyName: string): string;
        protected globalizationGetString(propertyName: string): string;
        getAllStrings(): string[];
        protected globalizationGetAllStrings(): string[];
        setValue(value: string): void;
        displayValue: string;
        get total(): StiCrossTotal;
        set total(value: StiCrossTotal);
        get isTotalVisible(): boolean;
        headerLevel: number;
        headerValue: string;
        totalGuid: string;
        showTotal: boolean;
        sortDirection: StiSortDirection;
        sortType: StiSortType;
        printOnAllPages: boolean;
        topN: StiDataTopN;
        expandExpression: string;
        isExpanded: boolean;
        constructor();
    }
}
export namespace Stimulsoft.Report.Events {
    class StiGetDataUrlEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Components {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiGetFonts = Stimulsoft.Base.IStiGetFonts;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiGetDataUrlEventArgs = Stimulsoft.Report.Events.StiGetDataUrlEventArgs;
    import StiGetDataUrlEvent = Stimulsoft.Report.Events.StiGetDataUrlEvent;
    import IStiEditable = Stimulsoft.Report.Components.IStiEditable;
    import StiBorder = Stimulsoft.Base.Drawing.StiBorder;
    import Font = Stimulsoft.System.Drawing.Font;
    import Color = Stimulsoft.System.Drawing.Color;
    class StiRichText extends StiSimpleText implements IStiEditable, IStiBorder, IStiGlobalizationProvider, IStiBackColor, IStiJsonReportObject, IStiGetFonts {
        private static implementsStiRichText;
        implements(): any[];
        static notSupportedText: string;
        meta(): StiMeta[];
        protected static propertyCanBreak: string;
        get canBreak(): boolean;
        set canBreak(value: boolean);
        clone(cloneProperties: boolean): StiRichText;
        private static eventGetDataUrl;
        protected onGetDataUrl(e: StiGetDataUrlEventArgs): void;
        invokeGetDataUrl(sender: StiComponent, e: StiGetDataUrlEventArgs): void;
        get getDataUrlEvent(): StiGetDataUrlEvent;
        set getDataUrlEvent(value: StiGetDataUrlEvent);
        setString(propertyName: string, value: string): void;
        getString(propertyName: string): string;
        getAllStrings(): string[];
        border: StiBorder;
        getFonts(): Font[];
        margins: StiMargins;
        defaultFont: Font;
        defaultColor: Color;
        wordWrap: boolean;
        detectUrls: boolean;
        backColor: Color;
        dataColumn: string;
        wysiwyg: boolean;
        rightToLeft: boolean;
        dataUrl: string;
    }
}
export namespace Stimulsoft.Report.Components {
    let IStiEnumAngle: System.Interface<IStiEnumAngle>;
    interface IStiEnumAngle {
        angle: StiAngle;
    }
}
export namespace Stimulsoft.Report.Components {
    import StiHorAlignment = Stimulsoft.Base.Drawing.StiHorAlignment;
    let IStiHorAlignment: System.Interface<IStiHorAlignment>;
    let ImplementsIStiHorAlignment: any[];
    interface IStiHorAlignment {
        horAlignment: StiHorAlignment;
    }
}
export namespace Stimulsoft.Report.Components {
    import Color = Stimulsoft.System.Drawing.Color;
    let IStiForeColor: System.Interface<IStiForeColor>;
    let ImplementsIStiForeColor: any[];
    interface IStiForeColor {
        foreColor: Color;
    }
}
export namespace Stimulsoft.Report.Components {
    import Color = Stimulsoft.System.Drawing.Color;
    let IStiBackColor: System.Interface<IStiBackColor>;
    let ImplementsIStiBackColor: any[];
    interface IStiBackColor {
        backColor: Color;
    }
}
export namespace Stimulsoft.Report.Components {
    import IAsIs = Stimulsoft.System.IAsIs;
    import Image = Stimulsoft.System.Drawing.Image;
    let IStiExportImage: System.Interface<IStiExportImage>;
    interface IStiExportImage extends IAsIs {
        getImage(REFzoom: any, format?: StiExportFormat): Image;
    }
}
export namespace Stimulsoft.Report.Components {
    let IStiExportImageExtended: System.Interface<IStiExportImageExtended>;
    interface IStiExportImageExtended extends IStiExportImage {
        isExportAsImage(format: StiExportFormat): boolean;
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiGetFonts = Stimulsoft.Base.IStiGetFonts;
    import StiComponent = Stimulsoft.Report.Components.StiComponent;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import Color = Stimulsoft.System.Drawing.Color;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    import StiVertAlignment = Stimulsoft.Base.Drawing.StiVertAlignment;
    import StiHorAlignment = Stimulsoft.Base.Drawing.StiHorAlignment;
    import Font = Stimulsoft.System.Drawing.Font;
    import StiValueEventArgs = Stimulsoft.Report.Events.StiValueEventArgs;
    import StiAngle = Stimulsoft.Report.Components.StiAngle;
    import StiBorder = Stimulsoft.Base.Drawing.StiBorder;
    import IStiBackColor = Stimulsoft.Report.Components.IStiBackColor;
    import IStiForeColor = Stimulsoft.Report.Components.IStiForeColor;
    import IStiExportImage = Stimulsoft.Report.Components.IStiExportImage;
    import IStiExportImageExtended = Stimulsoft.Report.Components.IStiExportImageExtended;
    import IStiHorAlignment = Stimulsoft.Report.Components.IStiHorAlignment;
    import IStiVertAlignment = Stimulsoft.Report.Components.IStiVertAlignment;
    import IStiBorder = Stimulsoft.Report.Components.IStiBorder;
    import IStiEnumAngle = Stimulsoft.Report.Components.IStiEnumAngle;
    import Image = Stimulsoft.System.Drawing.Image;
    class StiBarCode extends StiComponent implements IStiBarCode, IStiBackColor, IStiForeColor, IStiExportImage, IStiExportImageExtended, IStiVertAlignment, IStiHorAlignment, IStiEnumAngle, IStiBorder, IStiJsonReportObject, IStiGetFonts {
        private static implementsStiBarCode;
        implements(): any[];
        meta(): StiMeta[];
        get componentId(): StiComponentId;
        clone(cloneProperties: boolean): any;
        get helpUrl(): string;
        get localizedCategory(): string;
        get localizedName(): string;
        isExportAsImage(format: StiExportFormat): boolean;
        getImage(REFzoom: any, format?: StiExportFormat): Image;
        angle: StiAngle;
        border: StiBorder;
        foreColor: Color;
        backColor: Color;
        autoScale: boolean;
        showLabelText: boolean;
        showQuietZones: boolean;
        barCodeType: StiBarCodeTypeService;
        getBarCodeString(): string;
        private _font;
        get font(): Font;
        set font(value: Font);
        private _horAlignment;
        get horAlignment(): StiHorAlignment;
        set horAlignment(value: StiHorAlignment);
        private _vertAlignment;
        get vertAlignment(): StiVertAlignment;
        set vertAlignment(value: StiVertAlignment);
        codeValue: string;
        code: string;
        getFonts(): Font[];
        invokeEvents(): void;
        private static eventGetBarCode;
        onGetBarCode(e: StiValueEventArgs): void;
        invokeGetBarCode(sender: StiComponent, e: StiValueEventArgs): void;
        get getBarCodeEvent(): Stimulsoft.Report.Events.StiGetBarCodeEvent;
        set getBarCodeEvent(value: Stimulsoft.Report.Events.StiGetBarCodeEvent);
        createNew(): StiComponent;
        defaultClientRectangle: RectangleD;
        constructor(rect?: RectangleD);
    }
}
export namespace Stimulsoft.Report.Events {
    class StiGetCheckedEvent extends StiEvent {
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Components {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiGetExcelValueEventArgs = Stimulsoft.Report.Events.StiGetExcelValueEventArgs;
    import StiGetExcelValueEvent = Stimulsoft.Report.Events.StiGetExcelValueEvent;
    import StiGetCheckedEvent = Stimulsoft.Report.Events.StiGetCheckedEvent;
    import IStiEditable = Stimulsoft.Report.Components.IStiEditable;
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    import StiBorder = Stimulsoft.Base.Drawing.StiBorder;
    import Color = Stimulsoft.System.Drawing.Color;
    import StiValueEventArgs = Stimulsoft.Report.Events.StiValueEventArgs;
    class StiCheckBox extends StiComponent implements IStiBorder, IStiTextBrush, IStiBrush, IStiBreakable, IStiEditable, IStiJsonReportObject {
        implements(): any[];
        meta(): StiMeta[];
        brush: StiBrush;
        border: StiBorder;
        textBrush: StiBrush;
        editable: boolean;
        saveState(): string;
        restoreState(value: string): void;
        clone(cloneProperties: boolean): StiCheckBox;
        private _canBreak;
        get canBreak(): boolean;
        set canBreak(value: boolean);
        break(dividedComponent: StiComponent, devideFactor: number, REFdivideLine: any): boolean;
        invokeEvents(): void;
        private static eventGetChecked;
        protected onGetChecked(e: StiValueEventArgs): void;
        invokeGetChecked(sender: StiComponent, e: StiValueEventArgs): void;
        get getCheckedEvent(): StiGetCheckedEvent;
        set getCheckedEvent(value: StiGetCheckedEvent);
        private static eventGetExcelValue;
        protected onGetExcelValue(e: StiGetExcelValueEventArgs): void;
        invokeGetExcelValue(sender: StiComponent, e: StiGetExcelValueEventArgs): void;
        get getExcelValueEvent(): StiGetExcelValueEvent;
        set getExcelValueEvent(value: StiGetExcelValueEvent);
        checkedValue: any;
        contourColor: Color;
        size: number;
        private _checkStyle;
        get checkStyle(): StiCheckStyle;
        set checkStyle(value: StiCheckStyle);
        values: string;
        checkStyleForTrue: StiCheckStyle;
        checkStyleForFalse: StiCheckStyle;
        checked: string;
        excelDataValue: string;
        excelValue: string;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    import Hashtable = Stimulsoft.System.Collections.Hashtable;
    import StiComponent = Stimulsoft.Report.Components.StiComponent;
    import List = Stimulsoft.System.Collections.List;
    class StiDataSourceHelper {
        static getDatabaseFromDataSource(dataSource: StiDataSource): StiDatabase;
        static getDatabaseFromDataSource2(dataSource: StiDataSource): StiDatabase;
        static getDataSourcesFromDatabase(report: StiReport, database: StiDatabase): List<StiDataSource>;
        static getUsedDataSourcesNamesList(report: StiReport): string[];
        static getUsedDataSourcesNames(report: StiReport): Hashtable;
        static checkExpression(expression: string, component: StiComponent, datasourcesNames: Hashtable): void;
        private static addDataSourceName;
        private static addDataSourceColumn;
        private static addRelation;
        private static addSort;
        static getDataSourcesUsedInRequestFromUsersVariables(report: StiReport): Hashtable;
    }
}
export namespace Stimulsoft.Report.Engine {
    import Hashtable = Stimulsoft.System.Collections.Hashtable;
    import StiPage = Stimulsoft.Report.Components.StiPage;
    class StiRenderProvider {
        static renderAsync(report: StiReport, state: StiRenderState): Promise<void>;
        static render(report: StiReport, state: StiRenderState): void;
        private static StiRenderProvider_AddAnchor_Rendering;
        static connectToDataAsync(report: StiReport, isConnectToDataV2?: boolean): Promise<void>;
        static connectToData(report: StiReport, isConnectToDataV2?: boolean): void;
        private static disconnectFromData;
        private static isDialogsOnStartExist;
        private static renderFormsOnStart;
        private static renderFormsOnEnd;
        private static checkDialogsInPreview;
        static clearPagesWhichLessThenFromPageAndGreaterThenToPage(report: StiReport, state: StiRenderState): void;
        private static initCacheMode;
        private static removeAllPagesLessThenFromPageAndGreaterThenToPage;
        private static finishAllPagesInNotCachedPagesArray;
        static processPageToCache(report: StiReport, page: StiPage, final: boolean): void;
        static isFirstPage(report: StiReport, page: StiPage): boolean;
        static isLastPage(report: StiReport, page: StiPage): boolean;
        private static renderFirstPassAsync;
        private static renderFirstPass;
        static clearPagesForFirstPass(report: StiReport): void;
        private static getNumberOfPass;
        private static madeCollate;
        private static madeMirrorMargins;
        private static initReport;
        private static clearTotals;
        static prepareSubReportsAndDrillDownPages(report: StiReport): Hashtable;
        private static renderReportAsync;
        private static renderReport;
        static renderTable(report: StiReport): void;
        private static finishProgressForm;
    }
}
export namespace Stimulsoft.Report.Engine {
    class StiRenderState {
        latestProgressValue: number;
        private _fromPage;
        get fromPage(): number;
        private _toPage;
        get toPage(): number;
        showProgress: boolean;
        isSubReportMode: boolean;
        private _destroyPagesWhichNotInRange;
        get destroyPagesWhichNotInRange(): boolean;
        private _renderOnlyPagesFromRange;
        get renderOnlyPagesFromRange(): boolean;
        constructor(fromPage?: number, toPage?: number, showProgress?: boolean, destroyPagesWhichNotInRange?: boolean, renderOnlyPagesFromRange?: boolean);
    }
}
export namespace Stimulsoft.Report.Engine {
    import StiBookmark = Stimulsoft.Report.Components.StiBookmark;
    class StiBookmarksHelper {
        static getBookmark(bookmark: StiBookmark, name: string): StiBookmark;
        static prepareBookmark(bookmark: StiBookmark): void;
        static createBookmark(text: string, componentGuid?: string): StiBookmark;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    class StiBusinessObjectData {
        category: string;
        name: string;
        alias: string;
        businessObjectValue: any;
        constructor(category: string, name: string, alias: string, value: any);
    }
}
export namespace Stimulsoft.Report.Export {
    import IAsIs = Stimulsoft.System.IAsIs;
    class StiExportSettings implements IAsIs {
        is<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): this is T;
        is2<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): boolean;
        as<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): T;
        getExportFormat(): StiExportFormat;
        toParameters(): any;
        protected _returnType: any;
        get returnType(): any;
        set returnType(value: any);
    }
}
export namespace Stimulsoft.Report.Export {
    class StiPageRangeExportSettings extends StiExportSettings {
        pageRange: StiPagesRange;
        toParameters(): any;
    }
}
export namespace Stimulsoft.Report.Export {
    import StiTiffCompressionScheme = Stimulsoft.Report.Export.StiTiffCompressionScheme;
    import StiPageRangeExportSettings = Stimulsoft.Report.Export.StiPageRangeExportSettings;
    import StiExportFormat = Stimulsoft.Report.StiExportFormat;
    import StiImageFormat = Stimulsoft.Report.Export.StiImageFormat;
    import StiMonochromeDitheringType = Stimulsoft.Report.Export.StiMonochromeDitheringType;
    import StiImageType = Stimulsoft.Report.Export.StiImageType;
    class StiImageExportSettings extends StiPageRangeExportSettings {
        getExportFormat(): StiExportFormat;
        imageType: StiImageType;
        imageZoom: number;
        imageResolution: number;
        cutEdges: boolean;
        imageFormat: StiImageFormat;
        multipleFiles: boolean;
        ditheringType: StiMonochromeDitheringType;
        tiffCompressionScheme: StiTiffCompressionScheme;
        protected _returnType: any;
        get returnType(): any;
        set returnType(value: any);
        constructor(imageType?: StiImageType);
        toParameters(): any;
    }
}
export namespace Stimulsoft.Report.Export {
    import MemoryStream = Stimulsoft.System.IO.MemoryStream;
    import StiPage = Stimulsoft.Report.Components.StiPage;
    import StiPagesCollection = Stimulsoft.Report.Components.StiPagesCollection;
    abstract class StiExportService implements IStiExportService {
        get exportFormat(): StiExportFormat;
        isStopped: boolean;
        multipleFiles: boolean;
        renderedPagesCount: number;
        currentPassNumber: number;
        maximumPassNumber: number;
        exportServiceId: string;
        invokeExporting(page: StiPage, pages: StiPagesCollection, currentPass: number, maximumPass: number): void;
        invokeExporting2(value: number, maximum: number, currentPass: number, maximumPass: number): void;
        abstract exportTo(report: StiReport, stream: MemoryStream, settings: StiExportSettings): any;
        exportToAsync(onExport: Function, report: StiReport, stream: MemoryStream, settings: StiExportSettings): void;
        exportTo2(report: StiReport, stream: MemoryStream, settings: StiExportSettings): Promise<void>;
    }
}
export namespace Stimulsoft.Report.Export {
    import MemoryStream = Stimulsoft.System.IO.MemoryStream;
    class StiImageExportService extends StiExportService {
        get defaultExtension(): string;
        get exportFormat(): StiExportFormat;
        get groupCategory(): string;
        exportNameInMenu: string;
        position: StiExportPosition;
        getFilter(): string;
        exportTo(report: StiReport, stream: MemoryStream, settings: StiExportSettings): void;
        imageSettings: StiImageExportSettings;
        report: StiReport;
        private fileName;
        private sendEMail;
        exportImage(report: StiReport, refString: {
            ref: string;
        }, settings: StiImageExportSettings): void;
        private getSettings;
        private exportImage1;
        constructor();
    }
}
export namespace Stimulsoft.Report.Chart {
    class StiExportAssembly {
        static get isAssemblyLoaded(): boolean;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import List = Stimulsoft.System.Collections.List;
    import DataTable = Stimulsoft.System.Data.DataTable;
    import Type = Stimulsoft.System.Type;
    import IStiQueryObject = Stimulsoft.Data.Engine.IStiQueryObject;
    import IStiAppDataSource = Stimulsoft.Base.IStiAppDataSource;
    import StiDataRequestOption = Stimulsoft.Data.Engine.StiDataRequestOption;
    import StiDataSortRule = Stimulsoft.Data.Engine.StiDataSortRule;
    import StiDataFilterRule = Stimulsoft.Data.Engine.StiDataFilterRule;
    import StiDataActionRule = Stimulsoft.Data.Engine.StiDataActionRule;
    import IStiMeter = Stimulsoft.Base.Meters.IStiMeter;
    class StiDataTransformation extends StiDataStoreSource implements IStiQueryObject, IStiJsonReportObject {
        private static ImplementsStiDataTransformation;
        implements(): any[];
        meta(): StiMeta[];
        retrieveUsedDataNames(group: string): List<string>;
        getDataSources(dataNames: List<string>): List<IStiAppDataSource>;
        getKey(): string;
        isDataSource: true;
        getDataTable2(allowConnectToData: boolean): Promise<DataTable>;
        getDataAdapterType(): Type;
        sorts: List<StiDataSortRule>;
        filters: List<StiDataFilterRule>;
        actions: List<StiDataActionRule>;
        clone(): StiDataTransformation;
        retrieveDataTable(option: StiDataRequestOption): Promise<DataTable>;
        connectToData(option?: StiDataRequestOption): Promise<void>;
        getMeters(group?: string): List<IStiMeter>;
        getMeter(column: StiDataTransformationColumn): IStiMeter;
        get componentId(): StiComponentId;
        createNew(): StiDataSource;
        constructor(nameInSource?: string, name?: string, key?: string);
    }
}
export namespace Stimulsoft.Report.Dictionary {
    import Type = Stimulsoft.System.Type;
    import StiPromise = Stimulsoft.System.StiPromise;
    import StiFileDataOptions = Stimulsoft.Base.StiFileDataOptions;
    import StiFileDataConnector = Stimulsoft.Base.StiFileDataConnector;
    import StiDataSchema = Stimulsoft.Base.StiDataSchema;
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import DataSet = Stimulsoft.System.Data.DataSet;
    class StiFileDatabase extends StiDatabase implements IStiJsonReportObject {
        meta(): StiMeta[];
        dataSchema: StiDataSchema;
        pathData: string;
        getDatabaseInformation(report: StiReport): StiDatabaseInformation;
        getDatabaseInformationAsync(report: StiReport): StiPromise<StiDatabaseInformation>;
        createDataSources(dictionary: StiDictionary): void;
        private createDataTableSource;
        static parsePath(path: string, report: StiReport): string;
        protected regDataSetInDataStore(dictionary: StiDictionary, dataSet: DataSet): void;
        regData(dictionary: StiDictionary, loadData: boolean): void;
        regDataAsync(dictionary: StiDictionary, loadData: boolean): StiPromise<void>;
        createFileConnector(): StiFileDataConnector;
        protected getConnectorOptions(report: StiReport, isShema: boolean): StiFileDataOptions;
        protected getConnectorOptionsAsync(report: StiReport, isShema: boolean): Promise<StiFileDataOptions>;
        getDatasourceType(): Type;
        constructor(name?: string, pathData?: string, key?: string);
    }
}
export namespace Stimulsoft.Report.Helpers {
    import IStiApp = Stimulsoft.Base.IStiApp;
    class StiDataResourceHelper {
        static saveSnapshotAsync(app: IStiApp): Promise<void>;
        private static getRelationInformation;
        private static saveRelationSnapshot;
        private static replaceDatabase;
        private static databaseFromRecource;
        private static getListResourceSnapshot;
        private static dataSetToResourceXml;
        private static getNewResourceName;
    }
}
export namespace Stimulsoft.Report.Components {
    import StiUnit = Stimulsoft.Report.Units.StiUnit;
    let IStiUnitConvert: System.Interface<IStiUnitConvert>;
    interface IStiUnitConvert {
        convert(oldUnit: StiUnit, newUnit: StiUnit): any;
    }
}
export namespace Stimulsoft.Report.Dashboard.Export {
    import IAsIs = Stimulsoft.System.IAsIs;
    import StiPageOrientation = Stimulsoft.Report.Components.StiPageOrientation;
    import PaperKind = Stimulsoft.System.Drawing.Printing.PaperKind;
    let IStiDashboardExportSettings: System.Interface<IStiDashboardExportSettings>;
    interface IStiDashboardExportSettings extends IAsIs {
        renderBorders: boolean;
        renderSingleElement: boolean;
        renderSinglePage: boolean;
        orientation: StiPageOrientation;
        paperSize: PaperKind;
        openAfterExport: boolean;
    }
}
export namespace Stimulsoft.Report.Dashboard.Export {
    import StiImageType = Stimulsoft.Report.Export.StiImageType;
    let IStiImageDashboardExportSettings: System.Interface<IStiImageDashboardExportSettings>;
    interface IStiImageDashboardExportSettings extends IStiDashboardExportSettings {
        imageType: StiImageType;
        scale: number;
    }
}
export namespace Stimulsoft.Report.Dashboard {
    import MemoryStream = Stimulsoft.System.IO.MemoryStream;
    import StiExportSettings = Stimulsoft.Report.Export.StiExportSettings;
    class StiDashboardExport {
        static export(report: StiReport, stream: MemoryStream, settings: StiExportSettings): Promise<void>;
    }
}
export namespace Stimulsoft.Report {
    import IStiDesignerBase = Stimulsoft.Report.Design.IStiDesignerBase;
    import Image = Stimulsoft.System.Drawing.Image;
    import StiRefreshingEvent = Stimulsoft.Report.Events.StiRefreshingEvent;
    import StiMetaTagCollection = Stimulsoft.Report.Dictionary.StiMetaTagCollection;
    import IStiGetFonts = Stimulsoft.Base.IStiGetFonts;
    import Font = Stimulsoft.System.Drawing.Font;
    import IStiAppCell = Stimulsoft.Base.IStiAppCell;
    import IStiApp = Stimulsoft.Base.IStiApp;
    import StiExportSettings = Stimulsoft.Report.Export.StiExportSettings;
    import StiExportService = Stimulsoft.Report.Export.StiExportService;
    import StiExportEventArgs = Stimulsoft.Report.Events.StiExportEventArgs;
    import StiPrintedEvent = Stimulsoft.Report.Events.StiPrintedEvent;
    import StiPrintingEvent = Stimulsoft.Report.Events.StiPrintingEvent;
    import StiExportedEvent = Stimulsoft.Report.Events.StiExportedEvent;
    import StiEndRenderEvent = Stimulsoft.Report.Events.StiEndRenderEvent;
    import StiRenderingEvent = Stimulsoft.Report.Events.StiRenderingEvent;
    import StiBeginRenderEvent = Stimulsoft.Report.Events.StiBeginRenderEvent;
    import StiExportingEvent = Stimulsoft.Report.Events.StiExportingEvent;
    import StiReportCacheProcessingEvent = Stimulsoft.Report.Events.StiReportCacheProcessingEvent;
    import EventArgs = Stimulsoft.System.EventArgs;
    import StiGetSubReportEventArgs = Stimulsoft.Report.Events.StiGetSubReportEventArgs;
    import StiHtmlExportMode = Stimulsoft.Report.Export.StiHtmlExportMode;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiDialogInfo = Stimulsoft.Report.Dictionary.StiDialogInfo;
    import StiDataCollection = Stimulsoft.Report.Dictionary.StiDataCollection;
    import StiDataSourcesCollection = Stimulsoft.Report.Dictionary.StiDataSourcesCollection;
    import StiUnit = Stimulsoft.Report.Units.StiUnit;
    import StiPagesCollection = Stimulsoft.Report.Components.StiPagesCollection;
    import IStiUnitConvert = Stimulsoft.Report.Components.IStiUnitConvert;
    import StiEngine = Stimulsoft.Report.Engine.StiEngine;
    import Hashtable = Stimulsoft.System.Collections.Hashtable;
    import StiBookmark = Stimulsoft.Report.Components.StiBookmark;
    import StiStylesCollection = Stimulsoft.Report.Styles.StiStylesCollection;
    import StiAggregateFunctionService = Stimulsoft.Report.Dictionary.StiAggregateFunctionService;
    import Type = Stimulsoft.System.Type;
    import DateTime = Stimulsoft.System.DateTime;
    import StiBusinessObjectData = Stimulsoft.Report.Dictionary.StiBusinessObjectData;
    import StiPage = Stimulsoft.Report.Components.StiPage;
    import StiComponentsCollection = Stimulsoft.Report.Components.StiComponentsCollection;
    import StiComponent = Stimulsoft.Report.Components.StiComponent;
    import IStiMasterComponent = Stimulsoft.Report.Components.IStiMasterComponent;
    import IStiReport = Stimulsoft.Base.IStiReport;
    import List = Stimulsoft.System.Collections.List;
    import IStiReportPage = Stimulsoft.Base.IStiReportPage;
    import IStiAppDictionary = Stimulsoft.Base.IStiAppDictionary;
    import JsonRelationDirection = Stimulsoft.System.Data.JsonRelationDirection;
    import StiClone = Stimulsoft.Report.Components.StiClone;
    export type PrepareVariablesObject = {
        name: string;
        value: any | string[];
        type: string;
    };
    export type PrepareVariablesArgs = {
        event: string;
        sender: string;
        preventDefault: boolean;
        report: StiReport;
        variables: PrepareVariablesObject[];
        success?: boolean;
        notice?: string;
    };
    export type PrepareVariablesContinuationCallback = (args: PrepareVariablesObject[] | PrepareVariablesArgs) => void;
    export type CommonBeginProcessDataArgs = {
        event: "BeginProcessData";
        preventDefault: boolean;
        headers: {
            key: string;
            value: string;
        }[];
        withCredentials?: boolean;
        database: string;
        connection: string;
        report: StiReport;
        sender?: string;
    };
    export type BeginGetDataArgs = {
        command: "GetData";
        pathData: string;
    };
    export type BeginGetSchemaArgs = {
        command: "GetSchema";
        pathSchema: string;
    };
    export type BeginExecuteQueryArgs = {
        command: "ExecuteQuery";
        connectionString: string;
        queryString?: string;
        dataSource?: string;
    };
    export type BeginTestConnectionArgs = {
        command: "TestConnection";
        connectionString: string;
    };
    export type BeginProcessDataArgs = CommonBeginProcessDataArgs & (BeginGetDataArgs | BeginGetSchemaArgs | BeginExecuteQueryArgs | BeginTestConnectionArgs);
    export type EndGetDataArgs = {
        event: "EndProcessData";
        command: "GetData";
        database: string;
        connection: string;
        dataSet: Stimulsoft.System.Data.DataSet;
        report: StiReport;
        sender?: string;
    };
    export type EndSqlProcessDataArgs = {
        event: "EndProcessData";
        command: "TestConnection" | "ExecuteQuery";
        database: string;
        connection: string;
        report: StiReport;
        sender?: string;
        result: any;
    };
    export type EndProcessDataArgs = EndGetDataArgs | EndSqlProcessDataArgs;
    type Buffer = Uint8Array;
    let Buffer: any;
    export class StiJsonLoaderHelper {
        masterComponents: IStiMasterComponent[];
        clones: StiClone[];
        dialogInfo: StiDialogInfo[];
        barcodeTypes: Stimulsoft.Report.BarCodes.StiBarCodeTypeService[];
        textFormatTypes: string[];
        refNames: string[];
        clean(): void;
    }
    export class StiReport implements IStiUnitConvert, IStiReport, IStiApp, IStiAppCell, IStiGetFonts {
        implements(): any[];
        is<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): this is T;
        is2<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): boolean;
        as<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): T;
        jsonLoaderHelper: StiJsonLoaderHelper;
        private storedCulture;
        private static assignSignature;
        private saveToJsonInternal;
        saveSnapshot(): Promise<string>;
        private loadFromJsonInternal;
        private loadFromXmlInternal;
        static isPackedFile(content: number[] | Uint8Array): boolean;
        static isEncryptedFile(bytes: number[] | Uint8Array): boolean;
        private static isEncryptedFile2;
        load(param: string | number[] | XmlNode | any): void;
        loadFile(filePath: string): void;
        loadPacked(param: string | number[] | any): void;
        loadPackedFile(filePath: string): void;
        loadEncryptedReport(param: string | number[] | any, key: string): void;
        loadEncryptedReportFile(filePath: string, key: string): void;
        private loadFontsFromResources;
        loadDocument(param: string | number[] | any): void;
        loadDocumentFile(filePath: string): void;
        loadPackedDocument(param: string | number[] | any): void;
        loadPackedDocumentFile(filePath: string): void;
        loadEncryptedDocument(param: string | number[] | any, key: string): void;
        loadEncryptedDocumentFile(filePath: string, key: string): void;
        saveEncryptedReportToByteArray(key: string): number[];
        saveEncryptedReportToString(key: string): string;
        saveEncryptedReportFile(path: string, key: string): void;
        savePackedFile(path: string): void;
        savePackedToString(): string;
        savePackedToByteArray(): number[];
        saveToJsonString(): string;
        saveFile(path: string): void;
        saveDocumentToJsonString(): string;
        saveDocumentFile(path: string): void;
        saveEncryptedDocumentToByteArray(key: string): number[];
        saveEncryptedDocumentToString(key: string): string;
        saveEncryptedDocumentFile(path: string, key: string): void;
        savePackedDocumentFile(path: string): void;
        savePackedDocumentToString(): string;
        savePackedDocumentToByteArray(): number[];
        saveEditableFieldsFile(path: string): StiReport;
        saveEditableFields(): string;
        loadEditableFieldsFile(path: string): StiReport;
        loadEditableFields(param: string | XmlNode): StiReport;
        private clear;
        getDictionary(): IStiAppDictionary;
        getKey(): string;
        setKey(key: string): void;
        fetchPages(): List<IStiReportPage>;
        getFonts(): Font[];
        private _pageNumber;
        get pageNumber(): number;
        set pageNumber(value: number);
        get pageNumberThrough(): number;
        _totalPageCountValue: number;
        get totalPageCount(): number;
        set totalPageCount(value: number);
        get totalPageCountThrough(): number;
        get pageNofM(): string;
        get pageNofMThrough(): string;
        pageNofMLocalizationString: string;
        line: number;
        groupLine: number;
        get lineRoman(): string;
        get lineABC(): string;
        column: number;
        lineThrough: number;
        get date(): DateTime;
        get today(): DateTime;
        get time(): DateTime;
        cacheAllData: boolean;
        retrieveOnlyUsedData: boolean;
        private _reportCacheMode;
        get reportCacheMode(): StiReportCacheMode;
        set reportCacheMode(value: StiReportCacheMode);
        htmlPreviewMode: StiHtmlPreviewMode;
        convertNulls: boolean;
        get isFirstPage(): boolean;
        get isLastPage(): boolean;
        get isFirstPageThrough(): boolean;
        get isLastPageThrough(): boolean;
        get isFirstPass(): boolean;
        get isSecondPass(): boolean;
        currentPage: number;
        currentPrintPage: number;
        pageCopyNumber: number;
        private _businessObjectsStore;
        get businessObjectsStore(): StiBusinessObjectData[];
        private fieldNames;
        variables: Hashtable;
        getVariable(name: string, onlyVariable?: boolean): any;
        setVariable(name: string, value: any, onlyVariable?: boolean): void;
        private _aggregateFunctions;
        get aggregateFunctions(): StiAggregateFunctionService[];
        set aggregateFunctions(value: StiAggregateFunctionService[]);
        private _dictionary;
        get dictionary(): Stimulsoft.Report.Dictionary.StiDictionary;
        set dictionary(value: Stimulsoft.Report.Dictionary.StiDictionary);
        get dataSources(): StiDataSourcesCollection;
        get dataStore(): StiDataCollection;
        regData(name: string, alias: string, data: any, jsonRelationDirection?: JsonRelationDirection): void;
        regBusinessObject2(category: string, name: string, alias: string, value: any): void;
        regBusinessObject(businessObjects: StiBusinessObjectData[]): void;
        private storeBusinessObjectWithCheckExistingData;
        private _script;
        get script(): string;
        set script(value: string);
        scriptNew(): void;
        private prepareVariablesFromURL;
        private static getPrepareVariablesArgs;
        private static setPrepareVariablesArgs;
        events: Hashtable<any, any>;
        onPrepareVariables: null | ((args: PrepareVariablesArgs, callback: PrepareVariablesContinuationCallback) => void);
        invokePrepareVariablesAsync(): Promise<unknown>;
        onBeginProcessData: (args: BeginProcessDataArgs, callback: (args: any) => void) => void;
        invokeBeginProcessData(args: any, callback: (args: BeginProcessDataArgs) => void): void;
        onEndProcessData: (args: EndProcessDataArgs) => void;
        invokeEndProcessData(args: Partial<EndProcessDataArgs>): void;
        invokeRefreshPreview(): void;
        invokeRefreshViewer(): void;
        invokeClick(sender: any, e: EventArgs): void;
        invokeDoubleClick(sender: any, e: EventArgs): void;
        invokeGotoComp(e: StiGotoCompEventArgs): void;
        invokePaint(sender: any, e: EventArgs): void;
        onBeginRender: () => void;
        private static eventBeginRender;
        invokeBeginRender(): void;
        invokeBeginRenderAsync(): Promise<void>;
        private beginRenderEventScript;
        get beginRenderEvent(): StiBeginRenderEvent;
        set beginRenderEvent(value: StiBeginRenderEvent);
        onRendering: () => void;
        private static eventRendering;
        invokeRendering(): void;
        private renderingEventScript;
        get renderingEvent(): StiRenderingEvent;
        set renderingEvent(value: StiRenderingEvent);
        onEndRender: () => void;
        private static eventEndRender;
        invokeEndRender(): void;
        private endRenderEventScript;
        get endRenderEvent(): StiEndRenderEvent;
        set endRenderEvent(value: StiEndRenderEvent);
        invokeStatusChanged(): void;
        onExporting: (args: StiExportEventArgs) => void;
        exportingEvent: StiExportingEvent;
        invokeExporting(exportFormat: StiExportFormat): void;
        onExported: (args: StiExportEventArgs) => void;
        exportedEvent: StiExportedEvent;
        invokeExported(exportFormat: StiExportFormat): void;
        onPrinting: (args: StiPrintingEvent) => void;
        printingEvent: StiPrintingEvent;
        invokePrinting(): void;
        protected onPrinted(e: EventArgs): void;
        printedEvent: StiPrintedEvent;
        invokePrinted(): void;
        protected onRefreshing(e: EventArgs): void;
        refreshingEvent: StiRefreshingEvent;
        invokeRefreshing(): void;
        onGetSubReport: (args: StiGetSubReportEventArgs) => void;
        invokeGetSubReport(args: StiGetSubReportEventArgs): void;
        invokeReportCacheProcessing(): void;
        reportCacheProcessingEvent: StiReportCacheProcessingEvent;
        get unit(): StiUnit;
        set unit(value: StiUnit);
        convert(oldUnit: StiUnit, newUnit: StiUnit, isReportSnapshot?: boolean): void;
        static changeType(value: any, conversionType: Type, convertNulls?: boolean): any;
        applyStyleCollection(collectionName: string): void;
        applyStyles(): void;
        updateInheritedReport(masterReport?: StiReport): void;
        private _masterReport;
        get masterReport(): string;
        set masterReport(value: string);
        setInheritedMode(inherited: boolean): void;
        getCurrentPage(): StiPage;
        static getReportVersion(): string;
        private updateReportVersion;
        writeToReportRenderingMessages(str: string): void;
        getComponentByName(componentName: string): StiComponent;
        getComponentByGuid(guid: string): StiComponent;
        toString2(obj: any): string;
        checkExcelValue(sender: any, value: any): any;
        toString3(sender: any, obj: any, allowExcelCheck?: boolean): string;
        private generateReportGuid;
        addAnchor(value: any, component?: any): void;
        getAnchorPageNumber(value: any): number;
        getAnchorPageNumberThrough(value: any): number;
        private getAnchor;
        getComponents(): StiComponentsCollection;
        getRenderedComponents(): StiComponentsCollection;
        getComponentsCount(): number;
        renameStyle(oldStylename: string, newStyleName: string): void;
        localizeReport(cultureName: string): void;
        getParsedCulture(): string;
        private anchors;
        subReportsMasterReport: StiReport;
        subReportsResetPageNumber: boolean;
        subReportsPrintOnPreviousPage: boolean;
        indexName: number;
        containsTables: boolean;
        cachedTotals: Hashtable;
        cachedTotalsLocked: boolean;
        preparedExportImages: Hashtable<StiComponent, Image>;
        modifiedVariables: Hashtable;
        metaTags: StiMetaTagCollection;
        reportVersion: string;
        engine: StiEngine;
        private _reportRenderingMessages;
        get reportRenderingMessages(): string[];
        set reportRenderingMessages(value: string[]);
        interactionCollapsingStates: any;
        subReports: StiReportsCollection;
        key: string;
        reportGuid: string;
        imageCache: Hashtable;
        parentReport: StiReport;
        globalizationManager: IStiGlobalizationManager;
        pages: StiPagesCollection;
        private _renderedPages;
        get renderedPages(): StiPagesCollection;
        set renderedPages(value: StiPagesCollection);
        private _info;
        get info(): Stimulsoft.Report.Design.StiDesignerInfo;
        set info(value: Stimulsoft.Report.Design.StiDesignerInfo);
        designer: IStiDesignerBase;
        private pointerValue;
        get pointer(): StiBookmark;
        set pointer(value: StiBookmark);
        bookmarkValue: StiBookmark;
        get bookmark(): StiBookmark;
        set bookmark(value: StiBookmark);
        private _manualBookmark;
        get manualBookmark(): StiBookmark;
        set manualBookmark(value: StiBookmark);
        private _totals;
        get totals(): Hashtable;
        set totals(value: Hashtable);
        private _cells;
        get cells(): StiCells;
        password: string;
        private _dataBandsUsedInPageTotals;
        get dataBandsUsedInPageTotals(): string[];
        set dataBandsUsedInPageTotals(value: string[]);
        private _listOfUsedData;
        get listOfUsedData(): string[];
        set listOfUsedData(value: string[]);
        renderedWith: StiRenderedWith;
        reportPass: StiReportPass;
        isRendered: boolean;
        isRendering: boolean;
        private _isModified;
        get isModified(): boolean;
        set isModified(value: boolean);
        isStopped: boolean;
        isExporting: boolean;
        isSerializing: boolean;
        isPageDesigner: boolean;
        private isPrintingValue;
        get isPrinting(): boolean;
        set isPrinting(value: boolean);
        get containsDashboard(): boolean;
        get containsOnlyDashboard(): boolean;
        get isDesigning(): boolean;
        isPreviewDialogs: boolean;
        isReportRenderingAfterSubmit: boolean;
        isDocument: boolean;
        isInteractionRendering: boolean;
        private _reportName;
        get reportName(): string;
        set reportName(value: string);
        reportAlias: string;
        reportAuthor: string;
        reportDescription: string;
        reportImage: string;
        reportIcon: string;
        reportCreated: DateTime;
        reportChanged: DateTime;
        styles: StiStylesCollection;
        private _numberOfPass;
        get numberOfPass(): StiNumberOfPass;
        set numberOfPass(value: StiNumberOfPass);
        private _calculationMode;
        get calculationMode(): StiCalculationMode;
        private _reportUnit;
        get reportUnit(): StiReportUnitType;
        set reportUnit(value: StiReportUnitType);
        private _stopBeforePage;
        get stopBeforePage(): number;
        set stopBeforePage(value: number);
        previewSettings: number;
        dashboardViewerSettings: StiDashboardViewerSettings;
        previewToolBarOptions: StiPreviewToolBarOptions;
        private _collate;
        get collate(): number;
        set collate(value: number);
        globalizationStrings: StiGlobalizationContainerCollection;
        autoLocalizeReportOnRun: boolean;
        scriptLanguage: StiReportLanguageType;
        parametersOrientation: StiOrientation;
        private _parameterWidth;
        get parameterWidth(): number;
        set parameterWidth(value: number);
        requestParameters: boolean;
        cacheTotals: boolean;
        culture: string;
        private _refreshTime;
        get refreshTime(): number;
        set refreshTime(value: number);
        private _scrollTime;
        get scrollTime(): number;
        set scrollTime(value: number);
        compiledReport: StiReport;
        resetAggregateFunctions(): void;
        resetRenderedState(): this;
        getLabel(variableName: string): string;
        getParam(paramName: string): any;
        licenseKey: string;
        constructor();
        renderAsync(onRender?: Function, fromPage?: number, toPage?: number): void;
        renderAsync2(fromPage?: number, toPage?: number): Promise<void>;
        render(showProgress?: boolean, fromPage?: number, toPage?: number): void;
        processAutoLocalizeReportOnRun(): void;
        private renderReportAsync;
        private renderReport;
        print(pagesRange?: StiPagesRange, exportMode?: StiHtmlExportMode): void;
        printToPdf(pagesRange?: StiPagesRange, element?: HTMLElement): void;
        reportFile: string;
        reportFilePath: string;
        exportDocumentAsync(onExport: Function, exportFormat: StiExportFormat, exportService?: StiExportService, settings?: StiExportSettings): void;
        exportDocumentAsync2(exportFormat: StiExportFormat, exportService?: StiExportService, settings?: StiExportSettings): Promise<string | number[] | Buffer>;
        exportDocument(exportFormat: StiExportFormat, exportService?: StiExportService, settings?: StiExportSettings, onExport?: Function): string | number[] | Buffer;
        static createNewReport(): StiReport;
        static createNewDashboard(): StiReport;
    }
    export {};
}
export namespace StiOptions {
    import StiParserType = Stimulsoft.Report.StiParserType;
    import IStiGaugeStyle = Stimulsoft.Report.Gauge.IStiGaugeStyle;
    import StiColumnsSynchronizationMode = Stimulsoft.Report.Dictionary.StiColumnsSynchronizationMode;
    import StiWord2007RestrictEditing = Stimulsoft.Report.Export.StiWord2007RestrictEditing;
    import Font = Stimulsoft.System.Drawing.Font;
    import Color = Stimulsoft.System.Drawing.Color;
    import PaperSizeCollection = Stimulsoft.System.Drawing.Printing.PrinterSettings.PaperSizeCollection;
    import StiTextQuality = Stimulsoft.Report.Components.StiTextQuality;
    import StiNamingRule = Stimulsoft.Report.StiNamingRule;
    import StiAutoSynchronizeMode = Stimulsoft.Report.Dictionary.StiAutoSynchronizeMode;
    import StiPropertiesProcessingType = Stimulsoft.Report.Dictionary.StiPropertiesProcessingType;
    import StiFieldsProcessingType = Stimulsoft.Report.Dictionary.StiFieldsProcessingType;
    import StiExcel2007RestrictEditing = Stimulsoft.Report.Export.StiExcel2007RestrictEditing;
    import StiTextHorAlignment = Stimulsoft.Base.Drawing.StiTextHorAlignment;
    import StiVertAlignment = Stimulsoft.Base.Drawing.StiVertAlignment;
    import StiArabicDigitsType = Stimulsoft.Report.StiArabicDigitsType;
    import StiPdfAutoPrintMode = Stimulsoft.Report.Export.StiPdfAutoPrintMode;
    import IStiIndicatorRangeInfo = Stimulsoft.Report.Components.Gauge.IStiIndicatorRangeInfo;
    import IStiCustomValueBase = Stimulsoft.Report.Components.Gauge.IStiCustomValueBase;
    import IStiGaugeElement = Stimulsoft.Report.Components.Gauge.IStiGaugeElement;
    import IStiRangeBase = Stimulsoft.Report.Components.Gauge.IStiRangeBase;
    import IStiScaleBase = Stimulsoft.Report.Components.Gauge.IStiScaleBase;
    import Hashtable = Stimulsoft.System.Collections.Hashtable;
    import List = Stimulsoft.System.Collections.List;
    class CrossTab2 {
        styleColors: Color[];
    }
    class Designer {
        static useComponentPlacementOptimization: boolean;
        static autoCorrectDataSourceName: boolean;
        static autoCorrectDataRelationName: boolean;
        static autoCorrectDataColumnName: boolean;
        static autoCorrectComponentName: boolean;
        static autoCorrectReportName: boolean;
        static autoLargeHeight: boolean;
        static sortDictionaryByAliases: boolean;
        static runWizardAfterLoad: boolean;
        static runSpecificWizardAfterLoad: string;
        static startScreen: Stimulsoft.Report.StiDesignerStartScreen;
        static Editors: {
            allowConnectToDataInGallery: boolean;
        };
        private static _styles;
        static get styles(): Stimulsoft.Report.Styles.StiStylesCollection;
        static CrossTab: CrossTab2;
    }
    class Image {
        absolutePathOfImages: string;
        useImageCloning: boolean;
    }
    class Watemark {
        allowExpression: boolean;
    }
    class CrossTab {
        defaultWidth: number;
        defaultHeight: number;
    }
    class Globalization {
        allowUseText: boolean;
        allowUseTag: boolean;
        allowUseToolTip: boolean;
        allowUseHyperlink: boolean;
        allowUseVariableAlias: boolean;
        allowUseValue: boolean;
        allowUseDisplayValue: boolean;
    }
    class Map {
        showZoomPanel: boolean;
    }
    class Viewer {
        static Map: Map;
    }
    class ImageCache {
        enabled: boolean;
    }
    class Engine {
        static Image: Image;
        static Watermark: Watemark;
        static printIfDetailEmptyDefaultValue: boolean;
        static baseReportType: typeof Stimulsoft.Report.StiReport;
        static fullTrust: boolean;
        static allowUseResetMethodInBusinessObject: boolean;
        static allowResetValuesAtComponent: boolean;
        static defaultTextQualityMode: StiTextQuality;
        static forceGenerationLocalizedName: boolean;
        static useAdvancedPrintOnEngine: boolean;
        static forceGenerationNonLocalizedName: boolean;
        static forceNewPageForExtraColumns: boolean;
        static useRoundForToCurrencyWordsFunctions: boolean;
        static forceNewPageInSubReports: boolean;
        static useTemplateForPagePrintEvents: boolean;
        static namingRule: StiNamingRule;
        static useCheckSizeForContinuedContainers: boolean;
        static emulateData: boolean;
        static allowCacheForGetActualSize: boolean;
        static allowBreakContainerOptimization: boolean;
        static removeBottomBorderOfSplitContainer: boolean;
        static checkDockToContainerIfComponentDisabled: boolean;
        static usePrintOnAllPagesPropertyOfHeadersInSubreports: boolean;
        static useParentStylesOldMode: boolean;
        static useCollateOldMode: boolean;
        static dpiAware: boolean;
        static dockPageFooterToBottom: boolean;
        static defaultValueOfAllowApplyStyleProperty: boolean;
        static allowFixPieChartMarkerAlignment: boolean;
        static applyStylesInAutoSeries: boolean;
        static allowInvokeProcessChartEventForTemplateOfChart: boolean;
        static allowInteractionInChartWithComponents: boolean;
        static dontSaveDataSourceBeforeChartRendering: boolean;
        static wordWrapAxisLabelsForPlacementAutoRotation: boolean;
        static measureTrailingSpaces: boolean;
        static renderExternalSubReportsWithHelpOfUnlimitedHeightPages: boolean;
        static escapeQueryParameters: boolean;
        static optimizeDetailDataFiltering: boolean;
        static CrossTab: CrossTab;
        static printIfDetailEmptyNesting: boolean;
        static printIfDetailEmptyForDetails: boolean;
        static allowForceCanBreakForCrossTabPrintOnAllPages: boolean;
        static Globalization: Globalization;
        static ImageCache: ImageCache;
        static reportResources: any;
        static filterDataInDataSourceBeforeSorting: boolean;
        static allowConvertingInFormatting: boolean;
        static negativeColor: Color;
        static barcodeQRCodeAllowUnicodeBOM: boolean;
        static retrieveSchemaNamePostgreSql: string;
        static hideExceptions: boolean;
        static fixPageNumberInEvents: boolean;
        static dashboardTextElementExpressionParser: StiParserType;
        static useSyncRenderMode: boolean;
        static loadDataOnce: boolean;
        static useNewHtmlEngine: boolean;
        static htmlAllowListItemSecondLineIndent: boolean;
    }
    class Print {
        static customPaperSizes: PaperSizeCollection;
        static allowUsePaperSizesFromPrinterSettings: boolean;
    }
    class BusinessObjects {
        static allowUseDataColumn: boolean;
        static allowUseFields: boolean;
        static allowUseProperties: boolean;
        static propertiesProcessingType: StiPropertiesProcessingType;
        static fieldsProcessingType: StiFieldsProcessingType;
        columnsSynchronizationMode: StiColumnsSynchronizationMode;
    }
    class Dictionary {
        static BusinessObjects: BusinessObjects;
        static showOnlyAliasForDatabase: boolean;
        static showOnlyAliasForData: boolean;
        static showOnlyAliasForDataColumn: boolean;
        static showOnlyAliasForDataRelation: boolean;
        static hideRelationExceptions: boolean;
        static autoSynchronize: StiAutoSynchronizeMode;
        static useAdvancedDataSearch: boolean;
        static showOnlyAliasForComponents: boolean;
        static showOnlyAliasForDataSource: boolean;
        static allowRestConnections: boolean;
        static allowConnectToFirstTableForEmptyDataSource: boolean;
        static useNullableDateTime: boolean;
        static useNullableTimeSpan: boolean;
        static columnsSynchronizationMode: StiColumnsSynchronizationMode;
        static showOnlyAliasForResource: boolean;
    }
    class Dashboards {
        private _dashboardStyles;
        get dashboardStyles(): List<Stimulsoft.Report.Dashboard.Styles.StiDashboardStyle>;
        private _controlStyles;
        get controlStyles(): List<Stimulsoft.Report.Dashboard.Styles.StiControlElementStyle>;
        private _indicatorStyles;
        get indicatorStyles(): List<Stimulsoft.Report.Dashboard.Styles.StiIndicatorElementStyle>;
        private _pivotStyles;
        get pivotStyles(): List<Stimulsoft.Report.Dashboard.Styles.StiPivotElementStyle>;
        private _progressStyles;
        get progressStyles(): List<Stimulsoft.Report.Dashboard.Styles.StiProgressElementStyle>;
        private _tableStyles;
        get tableStyles(): List<Stimulsoft.Report.Dashboard.Styles.StiTableElementStyle>;
        private _cardsStyles;
        get cardsStyles(): List<Stimulsoft.Report.Dashboard.Styles.StiCardsElementStyle>;
    }
    class Services {
        private static _components;
        static get components(): List<Stimulsoft.System.Type>;
        private static _aggregateFunctions;
        static get aggregateFunctions(): List<Stimulsoft.Report.Dictionary.StiAggregateFunctionService>;
        private static _databases;
        static get databases(): List<Stimulsoft.Report.Dictionary.StiDatabase>;
        private static _dataAdapters;
        static get dataAdapters(): List<Stimulsoft.Report.Dictionary.StiDataAdapterService>;
        static set dataAdapters(value: List<Stimulsoft.Report.Dictionary.StiDataAdapterService>);
        private static _dataSource;
        static get dataSource(): List<Stimulsoft.Report.Dictionary.StiDataSource>;
        private static _formats;
        static get formats(): List<Stimulsoft.Report.Components.TextFormats.StiFormatService>;
        private static _styles;
        static get styles(): List<Stimulsoft.Report.Styles.StiBaseStyle>;
        private static _chartAreas;
        static get chartAreas(): List<Stimulsoft.Report.Chart.IStiArea>;
        private static _chartSeries;
        static get chartSeries(): List<Stimulsoft.Report.Chart.IStiSeries>;
        private static _chartTrendLines;
        static get chartTrendLines(): List<Stimulsoft.Report.Chart.IStiTrendLine>;
        private static _chartSerieLabels;
        static get chartSerieLabels(): List<Stimulsoft.Report.Chart.IStiSeriesLabels>;
        private static _chartStyles;
        static get chartStyles(): List<Stimulsoft.Report.Chart.IStiChartStyle>;
        private static _shapes;
        static get shapes(): List<Stimulsoft.Report.Components.StiShapeTypeService>;
        private static _barCodes;
        static get barCodes(): List<Stimulsoft.Report.BarCodes.StiBarCodeTypeService>;
        private static _indicatorRanges;
        static get indicatorRanges(): List<IStiIndicatorRangeInfo>;
        private static _customValues;
        static get customValues(): List<IStiCustomValueBase>;
        private static _gaugeElements;
        static get gaugeElements(): List<IStiGaugeElement>;
        private static _ranges;
        static get ranges(): List<IStiRangeBase>;
        private static _gaugeScales;
        static get gaugeScales(): List<IStiScaleBase>;
        private static _gaugeStyles;
        static get gaugeStyles(): List<IStiGaugeStyle>;
        private static _mapStyles;
        static get mapStyles(): List<Stimulsoft.Report.Maps.StiMapStyleFX>;
        private static _tableStyles;
        static get tableStyles(): List<Stimulsoft.Report.Components.Table.StiTableStyleFX>;
        static Dashboards: Dashboards;
    }
    class ExportWord {
        divideSegmentPages: boolean;
        allowImageComparer: boolean;
        removeEmptySpaceAtBottom: boolean;
        spaceBetweenCharacters: number;
        lineHeightExactly: boolean;
        lineHeightExactlyForPHFMode: boolean;
        forceLineHeight: boolean;
        rightMarginCorrection: number;
        bottomMarginCorrection: number;
        renderRichTextAsImage: boolean;
        renderHtmlTagsAsImage: boolean;
        allowCorrectFontSize11Problem: boolean;
        normalStyleDefaultFontSize: number;
        lineSpacing: number;
        divideBigCells: boolean;
        restrictEditing: StiWord2007RestrictEditing;
    }
    class ExportWriter {
        removeEmptySpaceAtBottom: boolean;
        allowImageComparer: boolean;
        divideSegmentPages: boolean;
    }
    class ExportCalc {
        removeEmptySpaceAtBottom: boolean;
        allowImageComparer: boolean;
        divideSegmentPages: boolean;
        divideBigCells: boolean;
        maximumSheetHeight: number;
    }
    class ExportHtml {
        convertDigitsToArabic: boolean;
        arabicDigitsType: Stimulsoft.Report.StiArabicDigitsType;
        allowImageComparer: boolean;
        forceWysiwygWordwrap: boolean;
        replaceSpecialCharacters: boolean;
        preserveWhiteSpaces: boolean;
        useImageResolution: boolean;
        useWordWrapBreakWordMode: boolean;
        useStrictTableCellSize: boolean;
        useStrictTableCellSizeV2: boolean;
        forceIE6Compatibility: boolean;
        allowStrippedImages: boolean;
        removeEmptySpaceAtBottom: boolean;
        useExtendedStyle: boolean;
        printLayoutOptimization: boolean;
        useComponentStyleName: boolean;
        exportComponentsFromPageMargins: boolean;
        disableJavascriptInHyperlinks: boolean;
        openLinksTarget: string;
        embeddedCustomFontsData: boolean;
    }
    class ExportExcel {
        AllowExportDateTime: boolean;
        ColumnsRightToLeft: boolean;
        ShowGridLines: boolean;
        MaximumSheetHeight: number;
        RemoveEmptySpaceAtBottom: boolean;
        DivideBigCells: boolean;
        UseImageResolution: boolean;
        TrimTrailingSpaces: boolean;
        AllowExportFootersInDataOnlyMode: boolean;
        AllowImageComparer: boolean;
        AllowFreezePanes: boolean;
        RenderHtmlTagsAsImage: boolean;
        RestrictEditing: StiExcel2007RestrictEditing;
        FitToOnePageWide: boolean;
    }
    class ExportPowerPoint {
        AllowImageComparer: boolean;
        StoreImagesAsPng: boolean;
    }
    class ExportPdf {
        divideSegmentPages: boolean;
        convertDigitsToArabic: boolean;
        arabicDigitsType: StiArabicDigitsType;
        reduceFontFileSize: boolean;
        useEditableFieldName: boolean;
        useEditableFieldAlias: boolean;
        useEditableFieldTag: boolean;
        allowImageComparer: boolean;
        allowImageTransparency: boolean;
        allowInheritedPageResources: boolean;
        allowExtGState: boolean;
        creatorString: string;
        keywordsString: string;
        defaultCoordinatesPrecision: number;
        defaultAutoPrintMode: StiPdfAutoPrintMode;
        useProperCaseFontNamesFromHtml: boolean;
    }
    class ExportText {
        useFullTextBoxWidth: boolean;
        useFullVerticalBorder: boolean;
        useFullHorizontalBorder: boolean;
        checkBoxTextForTrue: string;
        checkBoxTextForFalse: string;
        trimTrailingSpaces: boolean;
        removeLastNewLineMarker: boolean;
    }
    class ExportXps {
        allowImageComparer: boolean;
        allowImageTransparency: boolean;
        reduceFontFileSize: boolean;
    }
    class CheckBoxReplacementForExcelValue_ {
        Font: Font;
        HorAlignment: StiTextHorAlignment;
        VertAlignment: StiVertAlignment;
    }
    class Export {
        static Word: ExportWord;
        static OpenDocumentWriter: ExportWriter;
        static OpenDocumentCalc: ExportCalc;
        static Html: ExportHtml;
        static Excel: ExportExcel;
        static PowerPoint: ExportPowerPoint;
        static Pdf: ExportPdf;
        static Text: ExportText;
        static Xps: ExportXps;
        static CheckBoxReplacementForExcelValue: CheckBoxReplacementForExcelValue_;
        static optimizeDataOnlyMode: boolean;
        static checkBoxTextForTrue: string;
        static checkBoxTextForFalse: string;
        static useAlternativeFontNames: boolean;
        private static _alternativeFontNames;
        static get alternativeFontNames(): Hashtable;
        static set alternativeFontNames(value: Hashtable);
    }
    class WebServer {
        static url: string;
        static timeout: number;
        static encryptData: boolean;
        static passQueryParametersToReport: boolean;
        static checkDataAdaptersVersion: boolean;
    }
}
export namespace Stimulsoft.Report {
    class StiOptionsFontHelperAttribute {
        index: number;
        constructor(index: number);
    }
}
export namespace Stimulsoft.Report {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiJson = Stimulsoft.Base.StiJson;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import StiHorAlignment = Stimulsoft.Base.Drawing.StiHorAlignment;
    class StiPreviewToolBarOptions {
        protected _hash: StiMeta[];
        meta(): StiMeta[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        loadFromXml(xmlNode: XmlNode): void;
        isDefault(): boolean;
        isDefaultDashboardToolbar(): boolean;
        isDefaultReportToolbar(): boolean;
        dashboardToolbarHorAlignment: StiHorAlignment;
        dashboardToolbarReverse: boolean;
        reportToolbarHorAlignment: StiHorAlignment;
        reportToolbarReverse: boolean;
    }
}
export namespace Stimulsoft.Report {
    import CollectionBase = Stimulsoft.System.Collections.CollectionBase;
    class StiReportsCollection extends CollectionBase<StiReport> {
        add(report: StiReport, resetPageNumber?: boolean, printOnPreviousPage?: boolean): void;
        private owner;
        constructor(owner: StiReport);
    }
}
export namespace Stimulsoft.Report {
    import PaperKind = Stimulsoft.System.Drawing.Printing.PaperKind;
    import StiPageOrientation = Stimulsoft.Report.Components.StiPageOrientation;
    import StiMargins = Stimulsoft.Report.Components.StiMargins;
    import StiResizeReportOptions = Stimulsoft.Report.StiResizeReportOptions;
    class StiResizeReportHelper {
        private static setPageParameters;
        static resizeReportAsync(report: StiReport, orientation: StiPageOrientation, paperSize: PaperKind, margins: StiMargins, pageWidth: number, pageHeight: number, options: StiResizeReportOptions, indexOfRenderedPage?: number): Promise<void>;
    }
}
export namespace Stimulsoft.Report {
    import StiSimpleText = Stimulsoft.Report.Components.StiSimpleText;
    import Hashtable = Stimulsoft.System.Collections.Hashtable;
    import StiPage = Stimulsoft.Report.Components.StiPage;
    class StiRuntimeVariables {
        clone(): StiRuntimeVariables;
        page: StiPage;
        textBox: StiSimpleText;
        line: number;
        column: number;
        lineThrough: number;
        dataSourcesPosition: Hashtable;
        private _pageIndex;
        get pageIndex(): number;
        set pageIndex(value: number);
        private _currentPrintPage;
        get currentPrintPage(): number;
        set currentPrintPage(value: number);
        setVariables(report: StiReport): void;
        constructor(report: StiReport);
    }
}
export namespace Stimulsoft.Report {
    class StiStatesManager {
        private static ValueBoolFalse;
        private static ValueBoolTrue;
        private states;
        push(stateName: string, obj: any, property: string, value: any): void;
        pushBool(stateName: string, obj: any, property: string, value: boolean): void;
        pushInt(stateName: string, obj: any, property: string, value: number): void;
        pushInt64(stateName: string, obj: any, property: string, value: number): void;
        pushFloat(stateName: string, obj: any, property: string, value: number): void;
        pushDouble(stateName: string, obj: any, property: string, value: number): void;
        pushDecimal(stateName: string, obj: any, property: string, value: number): void;
        pushRange(stateName: string, obj: any, property: string, value: Range): void;
        pop(stateName: string, obj: any, property: string): any;
        popBool(stateName: string, obj: any, property: string): boolean;
        popInt(stateName: string, obj: any, property: string): number;
        popInt64(stateName: string, obj: any, property: string): number;
        popDouble(stateName: string, obj: any, property: string): number;
        popFloat(stateName: string, obj: any, property: string): number;
        popDecimal(stateName: string, obj: any, property: string): number;
        popRange(stateName: string, obj: any, property: string): Range;
        isExist(stateName: string, obj: any): boolean;
        clearState(stateName: string): void;
        clear(): void;
    }
}
export namespace Stimulsoft.Report {
    class StiSystemVariableLocHelper {
        static getPageNofM(report: StiReport): string;
        static getPageNofMThrough(report: StiReport): string;
        static getPageNofMIdent(report: StiReport): string;
        private static getIdent;
        private static locs;
    }
}
export namespace Stimulsoft.Report {
    import Hashtable = Stimulsoft.System.Collections.Hashtable;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    import StiText = Stimulsoft.Report.Components.StiText;
    import Font = Stimulsoft.System.Drawing.Font;
    class StiFitTextInfo {
        hashText: Hashtable;
        hashComponent: Hashtable;
        private hashFontString;
        getFontString(font: Font): string;
        getFontSizeObject(textBox: StiText, rect: RectangleD, text: string, REFfontSize: {
            ref: number;
        }, REFhashSt: {
            ref: string;
        }): any;
        clear(): void;
    }
    class StiViewerFitTextHelper {
        private static hashes;
        private static _enabled;
        static get enabled(): boolean;
        static set enabled(value: boolean);
        static addReport(report: StiReport): void;
        static removeReport(report: StiReport): void;
        static clearReportInfo(report: StiReport): void;
        static getReportInfo(report: StiReport): StiFitTextInfo;
        static clear(): void;
    }
}
export namespace Stimulsoft.Report.Components {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IAsIs = Stimulsoft.System.IAsIs;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import StiJson = Stimulsoft.Base.StiJson;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiInteractionSortDirection = Stimulsoft.Report.Components.StiInteractionSortDirection;
    import StiDrillDownMode = Stimulsoft.Report.Components.StiDrillDownMode;
    class StiInteraction implements ICloneable, IStiJsonReportObject, IAsIs {
        implements(): any[];
        is<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): this is T;
        is2<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): boolean;
        as<T>(type: (new (...args: any[]) => T) | Stimulsoft.System.Interface<T>): T;
        protected _hash: StiMeta[];
        meta(): StiMeta[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): void;
        loadFromXml(xmlNode: XmlNode): void;
        static loadInteractionFromJsonObject(jObject: StiJson): StiInteraction;
        static loadInteractionFromXml(xmlNode: XmlNode): Stimulsoft.Report.Components.StiInteraction;
        getReport(): any;
        clone(): StiInteraction;
        isDefault(): boolean;
        sortingEnabled: boolean;
        sortingColumn: string;
        sortingIndex: number;
        sortingDirection: StiInteractionSortDirection;
        drillDownEnabled: boolean;
        drillDownReport: string;
        drillDownMode: StiDrillDownMode;
        private _drillDownParameter1;
        get drillDownParameter1(): StiDrillDownParameter;
        set drillDownParameter1(value: StiDrillDownParameter);
        private _drillDownParameter2;
        get drillDownParameter2(): StiDrillDownParameter;
        set drillDownParameter2(value: StiDrillDownParameter);
        private _drillDownParameter3;
        get drillDownParameter3(): StiDrillDownParameter;
        set drillDownParameter3(value: StiDrillDownParameter);
        private _drillDownParameter4;
        get drillDownParameter4(): StiDrillDownParameter;
        set drillDownParameter4(value: StiDrillDownParameter);
        private _drillDownParameter5;
        get drillDownParameter5(): StiDrillDownParameter;
        set drillDownParameter5(value: StiDrillDownParameter);
        private _drillDownParameter6;
        get drillDownParameter6(): StiDrillDownParameter;
        set drillDownParameter6(value: StiDrillDownParameter);
        private _drillDownParameter7;
        get drillDownParameter7(): StiDrillDownParameter;
        set drillDownParameter7(value: StiDrillDownParameter);
        private _drillDownParameter8;
        get drillDownParameter8(): StiDrillDownParameter;
        set drillDownParameter8(value: StiDrillDownParameter);
        private _drillDownParameter9;
        get drillDownParameter9(): StiDrillDownParameter;
        set drillDownParameter9(value: StiDrillDownParameter);
        private _drillDownParameter10;
        get drillDownParameter10(): StiDrillDownParameter;
        set drillDownParameter10(value: StiDrillDownParameter);
        get drillDownPage(): StiPage;
        set drillDownPage(value: StiPage);
        drillDownPageGuid: string;
        get bookmark(): string;
        set bookmark(value: string);
        get hyperlink(): string;
        set hyperlink(value: string);
        get tag(): string;
        set tag(value: string);
        get toolTip(): string;
        set toolTip(value: string);
        getSortDataBandName(): string;
        getSortColumns(): string[];
        getSortColumnsString(): string;
        parentComponent: StiComponent;
        constructor();
    }
}
export namespace Stimulsoft.Report.Components {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    class StiBandInteraction extends StiInteraction implements IStiJsonReportObject {
        meta(): StiMeta[];
        isDefault(): boolean;
        collapsingEnabled: boolean;
        selectionEnabled: boolean;
        collapseGroupFooter: boolean;
        get collapsed(): string;
        set collapsed(value: string);
        selectedLine: number;
    }
}
export namespace Stimulsoft.Report.Components {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import Color = Stimulsoft.System.Drawing.Color;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiGroupFooterBand extends StiDynamicBand implements IStiKeepGroupFooterTogether, IStiJsonReportObject {
        implements(): any[];
        meta(): StiMeta[];
        clone(cloneProperties: boolean, cloneComponents: boolean): StiGroupFooterBand;
        keepGroupFooterTogether: boolean;
        private _groupFooterBandInfo;
        get groupFooterBandInfo(): StiGroupFooterBandInfo;
        get line(): number;
        get headerStartColor(): Color;
        get headerEndColor(): Color;
        get toolboxPosition(): number;
        get toolboxCategory(): StiToolboxCategory;
        protected getComponentType(): StiComponentType;
        get priority(): number;
        createNew(): StiComponent;
        constructor(rect?: RectangleD);
    }
}
export namespace Stimulsoft.Report.Components {
    let IStiPageBreak: System.Interface<IStiPageBreak>;
    interface IStiPageBreak {
        newColumnBefore: boolean;
        newColumnAfter: boolean;
        newPageBefore: boolean;
        newPageAfter: boolean;
        breakIfLessThan: number;
        skipFirst: boolean;
    }
}
export namespace Stimulsoft.Report.Components {
    import IAsIs = Stimulsoft.System.IAsIs;
    let IStiMasterComponent: System.Interface<IStiMasterComponent>;
    interface IStiMasterComponent extends IAsIs {
        masterComponent: StiComponent;
    }
}
export namespace Stimulsoft.Report.Components {
    let IStiPrintOnAllPages: System.Interface<IStiPrintOnAllPages>;
    interface IStiPrintOnAllPages {
        printOnAllPages: boolean;
    }
}
export namespace Stimulsoft.Report.Components {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import Color = Stimulsoft.System.Drawing.Color;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiHeaderBand extends StiDynamicBand implements IStiPrintIfEmpty, IStiPrintOnAllPages, IStiPrintOnEvenOddPages, IStiKeepHeaderTogether, IStiJsonReportObject {
        implements(): any[];
        meta(): StiMeta[];
        clone(cloneProperties: boolean, cloneComponents: boolean): StiHeaderBand;
        keepHeaderTogether: boolean;
        private _startNewPage;
        get startNewPage(): boolean;
        set startNewPage(value: boolean);
        get startNewPageIfLessThan(): number;
        set startNewPageIfLessThan(value: number);
        private _printIfEmpty;
        get printIfEmpty(): boolean;
        set printIfEmpty(value: boolean);
        private _printOnAllPages;
        get printOnAllPages(): boolean;
        set printOnAllPages(value: boolean);
        private _printOnEvenOddPages;
        get printOnEvenOddPages(): StiPrintOnEvenOddPagesType;
        set printOnEvenOddPages(value: StiPrintOnEvenOddPagesType);
        private _headerBandInfo;
        get headerBandInfo(): StiHeaderBandInfo;
        get headerStartColor(): Color;
        get headerEndColor(): Color;
        get toolboxPosition(): number;
        get toolboxCategory(): StiToolboxCategory;
        get priority(): number;
        protected getComponentType(): StiComponentType;
        createNew(): StiComponent;
        constructor(rect?: RectangleD);
    }
}
export namespace Stimulsoft.Report.Components {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import EventArgs = Stimulsoft.System.EventArgs;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import Color = Stimulsoft.System.Drawing.Color;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiFooterBand extends StiDynamicBand implements IStiPrintOnAllPages, IStiPrintIfEmpty, IStiKeepFooterTogether, IStiPrintOnEvenOddPages, IStiJsonReportObject {
        implements(): any[];
        meta(): StiMeta[];
        keepFooterTogether: boolean;
        clone(cloneProperties: boolean, cloneComponents: boolean): StiFooterBand;
        private _startNewPage;
        get startNewPage(): boolean;
        set startNewPage(value: boolean);
        get startNewPageIfLessThan(): number;
        set startNewPageIfLessThan(value: number);
        printIfEmpty: boolean;
        printOnEvenOddPages: StiPrintOnEvenOddPagesType;
        private _printOnAllPages;
        get printOnAllPages(): boolean;
        set printOnAllPages(value: boolean);
        private _footerBandInfo;
        get footerBandInfo(): StiFooterBandInfo;
        get headerStartColor(): Color;
        get headerEndColor(): Color;
        get toolboxPosition(): number;
        get toolboxCategory(): StiToolboxCategory;
        get priority(): number;
        protected getComponentType(): StiComponentType;
        private static eventMoveFooterToBottom;
        protected onMoveFooterToBottom(e: EventArgs): void;
        invokeMoveFooterToBottom(): void;
        createNew(): StiComponent;
        constructor(rect?: RectangleD);
    }
}
export namespace Stimulsoft.Report.Engine {
    import StiDataBand = Stimulsoft.Report.Components.StiDataBand;
    import StiGroupHeaderBand = Stimulsoft.Report.Components.StiGroupHeaderBand;
    import StiComponent = Stimulsoft.Report.Components.StiComponent;
    import StiFooterBand = Stimulsoft.Report.Components.StiFooterBand;
    import StiBand = Stimulsoft.Report.Components.StiBand;
    import StiComponentsCollection = Stimulsoft.Report.Components.StiComponentsCollection;
    import StiContainer = Stimulsoft.Report.Components.StiContainer;
    class StiDataBandBuilder extends StiBandBuilder {
        getGroupHeaders(masterDataBand: StiDataBand): StiComponentsCollection;
        getGroupFooters(masterDataBand: StiDataBand): StiComponentsCollection;
        groupsComparison(masterDataBand: StiDataBand): void;
        findHeaders(masterDataBand: StiDataBand): void;
        findHierarchicalHeaders(masterDataBand: StiDataBand): void;
        findFooters(masterDataBand: StiDataBand): void;
        findHierarchicalFooters(masterDataBand: StiDataBand): void;
        findEmptyBands(masterDataBand: StiDataBand): void;
        findGroupHeaders(masterDataBand: StiDataBand): void;
        findGroupFooters(masterDataBand: StiDataBand): void;
        findDetailDataBands(masterDataBand: StiDataBand): void;
        private isParentOrCurrentBO;
        findSubReports(masterDataBand: StiDataBand): void;
        findDetails(masterDataBand: StiDataBand): void;
        resetHeaders(masterDataBand: StiDataBand): void;
        resetHierarchicalHeaders(masterDataBand: StiDataBand): void;
        resetFooters(masterDataBand: StiDataBand): void;
        resetHierarchicalFooters(masterDataBand: StiDataBand): void;
        resetEmptyBands(masterDataBand: StiDataBand): void;
        resetGroupHeaders(masterDataBand: StiDataBand): void;
        resetGroupFooters(masterDataBand: StiDataBand): void;
        resetDetailDataBands(masterDataBand: StiDataBand): void;
        resetDetails(masterDataBand: StiDataBand): void;
        addKeepLevelAtLatestDataBandAsync(masterDataBand: StiDataBand): Promise<void>;
        addKeepLevelAtLatestDataBand(masterDataBand: StiDataBand): void;
        addKeepLevelAsync(masterDataBand: StiDataBand): Promise<void>;
        addKeepLevel(masterDataBand: StiDataBand): void;
        removeKeepLevelAsync(masterDataBand: StiDataBand): Promise<void>;
        removeKeepLevel(masterDataBand: StiDataBand): void;
        removeKeepGroupHeadersAsync(masterDataBand: StiDataBand): Promise<void>;
        removeKeepGroupHeaders(masterDataBand: StiDataBand): void;
        removeKeepHeadersAsync(masterDataBand: StiDataBand, keepHeaders: boolean[]): Promise<void>;
        removeKeepHeaders(masterDataBand: StiDataBand, keepHeaders: boolean[]): void;
        allowKeepDetails(masterDataBand: StiDataBand): boolean;
        addKeepDetailsAsync(masterDataBand: StiDataBand): Promise<void>;
        addKeepDetails(masterDataBand: StiDataBand): void;
        removeKeepDetailsAsync(masterDataBand: StiDataBand): Promise<void>;
        removeKeepDetails(masterDataBand: StiDataBand): void;
        removeKeepDetailsRowAsync(masterDataBand: StiDataBand): Promise<void>;
        removeKeepDetailsRow(masterDataBand: StiDataBand): void;
        startBands(masterDataBand: StiDataBand, bands: StiComponentsCollection): void;
        startBand(masterDataBand: StiDataBand, band: StiBand): void;
        endBands(masterDataBand: StiDataBand): void;
        getGroupHeaderResult(masterDataBand: StiDataBand, groupHeaderBand: StiGroupHeaderBand): boolean;
        getGroupFooterResult(masterDataBand: StiDataBand, groupHeaderBand: StiGroupHeaderBand): boolean;
        linkGroupHeadersAndGroupFooters(masterDataBand: StiDataBand): void;
        resetLinkGroupHeadersAndGroupFooters(masterDataBand: StiDataBand): void;
        static prepareGroupResults(masterDataBand: StiDataBand): void;
        renderGroupHeadersAsync(masterDataBand: StiDataBand): Promise<void>;
        renderGroupHeaders(masterDataBand: StiDataBand): void;
        renderGroupFootersAsync(masterDataBand: StiDataBand): Promise<void>;
        renderGroupFooters(masterDataBand: StiDataBand): void;
        static setDetailsAsync(masterDataBand: StiDataBand): Promise<void>;
        static setDetails(masterDataBand: StiDataBand): void;
        renderDetailDataBandsAsync(masterDataBand: StiDataBand): Promise<void>;
        renderDetailDataBands(masterDataBand: StiDataBand): void;
        private getParentDataBand;
        private isAllow;
        allowDetailDataBands(masterDataBand: StiDataBand): boolean;
        isDenyDetailsOnFirstPage(masterDataBand: StiDataBand): boolean;
        static isDetailDataSourcesEmpty(masterDataBand: StiDataBand): boolean;
        static isPrintIfDetailEmpty(masterDataBand: StiDataBand): boolean;
        renderHeadersAsync(masterDataBand: StiDataBand, keepHeaders: boolean[]): Promise<void>;
        renderHeaders(masterDataBand: StiDataBand, keepHeaders: boolean[]): void;
        renderHierarchicalHeadersAsync(masterDataBand: StiDataBand, allowIndent: boolean, level: number): Promise<void>;
        renderHierarchicalHeaders(masterDataBand: StiDataBand, allowIndent: boolean, level: number): void;
        addFooterMarkerAsync(masterDataBand: StiDataBand, footerMaster: StiFooterBand): Promise<void>;
        addFooterMarker(masterDataBand: StiDataBand, footerMaster: StiFooterBand): void;
        renderMarkerFootersOnAllPagesAsync(masterDataBand: StiDataBand): Promise<void>;
        renderMarkerFootersOnAllPages(masterDataBand: StiDataBand): void;
        renderFootersOnLastPageAsync(masterDataBand: StiDataBand): Promise<void>;
        renderFootersOnLastPage(masterDataBand: StiDataBand): void;
        renderFootersOnAllPagesAsync(masterDataBand: StiDataBand): Promise<void>;
        renderFootersOnAllPages(masterDataBand: StiDataBand): void;
        renderHierarchicalFootersAsync(masterDataBand: StiDataBand, allowIndent: boolean, level: number): Promise<void>;
        renderHierarchicalFooters(masterDataBand: StiDataBand, allowIndent: boolean, level: number): void;
        renderReportTitlesAsync(masterDataBand: StiDataBand): Promise<void>;
        renderReportTitles(masterDataBand: StiDataBand): void;
        renderReportSummariesAsync(masterDataBand: StiDataBand): Promise<void>;
        renderReportSummaries(masterDataBand: StiDataBand): void;
        checkKeepReportSummaryTogether(masterDataBand: StiDataBand): boolean;
        block(masterDataBand: StiDataBand): void;
        unBlock(masterDataBand: StiDataBand): void;
        checkHierarchicalHeadersAsync(masterDataBand: StiDataBand): Promise<void>;
        checkHierarchicalHeaders(masterDataBand: StiDataBand): void;
        checkHierarchicalFootersAsync(masterDataBand: StiDataBand): Promise<void>;
        checkHierarchicalFooters(masterDataBand: StiDataBand): void;
        renderBandAsync(masterDataBand: StiDataBand, band: StiBand, ignorePageBreaks?: boolean, allowRenderingEvents?: boolean): Promise<void>;
        renderBand(masterDataBand: StiDataBand, band: StiBand, ignorePageBreaks?: boolean, allowRenderingEvents?: boolean): void;
        renderColumnsAsync(masterDataBand: StiDataBand): Promise<void>;
        renderColumns(masterDataBand: StiDataBand): void;
        registerEmptyBands(masterDataBand: StiDataBand): void;
        static isCollapsed(masterDataBand: StiContainer, isRendering: boolean): boolean;
        setReportVariables(masterComp: StiComponent): void;
        prepare(masterComp: StiComponent): void;
        unPrepare(masterComp: StiComponent): void;
        private static invokeCollapsedEvent;
        renderAsync(masterComp: StiComponent): Promise<StiComponent>;
        render(masterComp: StiComponent): StiComponent;
        renderMasterAsync(masterDataBand: StiDataBand): Promise<void>;
        renderMaster(masterDataBand: StiDataBand): void;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    class StiAggregateFunctionService {
        get serviceName(): string;
        init(): void;
        reset(): void;
        calcItem(value: any): void;
        getValue(): any;
        setValue(value: any): void;
        isFirstInit: boolean;
        get recureParam(): boolean;
        runningTotal: boolean;
        constructor(runningTotal?: boolean);
    }
}
export namespace Stimulsoft.Report.Dictionary {
    class StiSumFunctionService extends StiAggregateFunctionService {
        private summary;
        get serviceName(): string;
        init(): void;
        calcItem(value: any): void;
        getValue(): any;
        setValue(value: any): void;
        get recureParam(): boolean;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    class StiSumTimeFunctionService extends StiAggregateFunctionService {
        private sumValue;
        get serviceName(): string;
        init(): void;
        calcItem(value: any): void;
        getValue(): any;
        setValue(value: any): void;
        get recureParam(): boolean;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    class StiAvgFunctionService extends StiAggregateFunctionService {
        private summary;
        private count;
        get serviceName(): string;
        init(): void;
        calcItem(value: any): void;
        getValue(): any;
        setValue(value: any): void;
        get recureParam(): boolean;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    class StiAvgDateFunctionService extends StiAggregateFunctionService {
        private avgValue;
        private count;
        get serviceName(): string;
        init(): void;
        calcItem(value: any): void;
        getValue(): any;
        setValue(value: any): void;
        get recureParam(): boolean;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    class StiAvgTimeFunctionService extends StiAggregateFunctionService {
        private avgValue;
        private count;
        get serviceName(): string;
        init(): void;
        calcItem(value: any): void;
        getValue(): any;
        setValue(value: any): void;
        get recureParam(): boolean;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    class StiMaxFunctionService extends StiAggregateFunctionService {
        private maximum;
        get serviceName(): string;
        init(): void;
        calcItem(value: any): void;
        getValue(): any;
        setValue(value: any): void;
        get recureParam(): boolean;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    class StiMinFunctionService extends StiAggregateFunctionService {
        private minimum;
        get serviceName(): string;
        init(): void;
        calcItem(value: any): void;
        getValue(): any;
        setValue(value: any): void;
        get recureParam(): boolean;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    class StiMedianFunctionService extends StiAggregateFunctionService {
        private values;
        get serviceName(): string;
        init(): void;
        calcItem(value: any): void;
        getValue(): any;
        setValue(value: any): void;
        get recureParam(): boolean;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    class StiModeFunctionService extends StiAggregateFunctionService {
        private values;
        get serviceName(): string;
        init(): void;
        calcItem(value: any): void;
        getValue(): any;
        setValue(value: any): void;
        get recureParam(): boolean;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    class StiFirstFunctionService extends StiAggregateFunctionService {
        private value;
        private first;
        get serviceName(): string;
        init(): void;
        calcItem(value: any): void;
        getValue(): any;
        setValue(value: any): void;
        get recureParam(): boolean;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    class StiLastFunctionService extends StiAggregateFunctionService {
        private value;
        get serviceName(): string;
        init(): void;
        calcItem(value: any): void;
        getValue(): any;
        setValue(value: any): void;
        get recureParam(): boolean;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    class StiCountFunctionService extends StiAggregateFunctionService {
        private counter;
        get serviceName(): string;
        init(): void;
        calcItem(value: any): void;
        getValue(): any;
        setValue(value: any): void;
        get recureParam(): boolean;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    class StiCountDistinctFunctionService extends StiAggregateFunctionService {
        private counter;
        private values;
        get serviceName(): string;
        init(): void;
        calcItem(value: any): void;
        getValue(): any;
        setValue(value: any): void;
        get recureParam(): boolean;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    class StiMinDateFunctionService extends StiAggregateFunctionService {
        private valueProcessed;
        private minimum;
        get serviceName(): string;
        init(): void;
        calcItem(value: any): void;
        getValue(): any;
        setValue(value: any): void;
        get recureParam(): boolean;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    class StiMinTimeFunctionService extends StiAggregateFunctionService {
        private valueProcessed;
        private minimum;
        get serviceName(): string;
        init(): void;
        calcItem(value: any): void;
        getValue(): any;
        setValue(value: any): void;
        get recureParam(): boolean;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    class StiMinStrFunctionService extends StiAggregateFunctionService {
        private values;
        static ascComparison(str1: string, str2: string): number;
        get serviceName(): string;
        init(): void;
        calcItem(value: any): void;
        getValue(): any;
        setValue(value: any): void;
        get recureParam(): boolean;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    class StiMaxDateFunctionService extends StiAggregateFunctionService {
        private valueProcessed;
        private maximum;
        get serviceName(): string;
        init(): void;
        calcItem(value: any): void;
        getValue(): any;
        setValue(value: any): void;
        get recureParam(): boolean;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    class StiMaxTimeFunctionService extends StiAggregateFunctionService {
        private valueProcessed;
        private maximum;
        get serviceName(): string;
        init(): void;
        calcItem(value: any): void;
        getValue(): any;
        setValue(value: any): void;
        get recureParam(): boolean;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    class StiMaxStrFunctionService extends StiAggregateFunctionService {
        private values;
        static ascComparison(str1: string, str2: string): number;
        get serviceName(): string;
        init(): void;
        calcItem(value: any): void;
        getValue(): any;
        setValue(value: any): void;
        get recureParam(): boolean;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    class StiSumDistinctFunctionService extends StiAggregateFunctionService {
        private summary;
        private values;
        get serviceName(): string;
        init(): void;
        calcItem(value: any, valueToSum?: any): void;
        getValue(): any;
        setValue(value: any): void;
        get recureParam(): boolean;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    class StiSumNullableFunctionService extends StiAggregateFunctionService {
        private summary;
        private hasValues;
        get serviceName(): string;
        init(): void;
        calcItem(value: any): void;
        getValue(): any;
        setValue(value: any): void;
        get recureParam(): boolean;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    import StiRankOrder = Stimulsoft.Report.StiRankOrder;
    class StiRankFunctionService extends StiAggregateFunctionService {
        private hash;
        private sortOrder;
        private dense;
        get serviceName(): string;
        init(): void;
        calcItem(value: any): void;
        getValue(): any;
        setValue(value: any): void;
        get recureParam(): boolean;
        constructor(runningTotal: boolean, dense?: boolean, sortOrder?: StiRankOrder);
    }
}
export namespace Stimulsoft.Report.Dictionary {
    import Type = Stimulsoft.System.Type;
    class StiStDevFunctionService extends StiAggregateFunctionService {
        get serviceName(): string;
        private values;
        init(): void;
        calcItem(value: any): void;
        getValue(): any;
        setValue(value: any): void;
        getResultType(): Type;
        get recureParam(): boolean;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    import Type = Stimulsoft.System.Type;
    class StiStDevPFunctionService extends StiAggregateFunctionService {
        get serviceName(): string;
        private values;
        init(): void;
        calcItem(value: any): void;
        getValue(): any;
        setValue(value: any): void;
        getResultType(): Type;
        get recureParam(): boolean;
    }
}
export namespace Stimulsoft.Report.Dictionary {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiPromise = Stimulsoft.System.StiPromise;
    class StiSqlSource extends StiDataTableSource implements IStiJsonReportObject {
        meta(): StiMeta[];
        clone(): StiSqlSource;
        allowExpressions: boolean;
        type: StiSqlSourceType;
        commandTimeout: number;
        reconnectOnEachRow: boolean;
        private _sqlCommand;
        get sqlCommand(): string;
        set sqlCommand(v: string);
        getDataAdapterType(): Stimulsoft.System.Type;
        getParameterTypesEnum(): any;
        updateParametersAsync(): Promise<void>;
        updateParameters(): void;
        retrieveDataAsync(schemaOnly?: boolean): StiPromise<void>;
        getFinalSqlCommand(): string;
        get componentId(): StiComponentId;
        createNew(): StiDataSource;
        constructor(nameInSource?: string, name?: string, alias?: string, sqlCommand?: string, connectOnStart?: boolean, reconnectOnEachRow?: boolean, commandTimeout?: number, key?: string);
    }
}
export namespace Stimulsoft.Report {
    import StiFilterCondition = Stimulsoft.Report.Components.StiFilterCondition;
    import TimeSpan = Stimulsoft.System.TimeSpan;
    import DateTime = Stimulsoft.System.DateTime;
    class Totals {
        static getMethod(report: StiReport, name: string): any;
        private static calculate;
        private static calculate1;
        private static calcItem;
        private static calculateByCondition;
        private static compareValue;
        private static calculateNullable;
        private static calculateRunning;
        static sum(data: any, report: StiReport, name: string): number;
        static sumNullable(data: any, report: StiReport, name: string): number;
        static sumDistinct(data: any, report: StiReport, name: string, name2?: string): number;
        static cSum(data: any, report: StiReport, name: string): number;
        static cSumRunning(data: any, report: StiReport, name: string): number;
        static sumAllLevels(data: any, report: StiReport, name: string): number;
        static sumAllLevelsByCondition(data: any, report: StiReport, name: string, filterCondition: StiFilterCondition, value1: number, value2: number): number;
        static sumAllLevelsOnlyChilds(data: any, report: StiReport, name: string): number;
        static sumOnlyChilds(data: any, report: StiReport, name: string): number;
        static sumTime(data: any, report: StiReport, name: string): TimeSpan;
        static cSumTime(data: any, report: StiReport, name: string): TimeSpan;
        static sumTimeAllLevels(data: any, report: StiReport, name: string): TimeSpan;
        static sumTimeAllLevelsOnlyChilds(data: any, report: StiReport, name: string): TimeSpan;
        static sumTimeOnlyChilds(data: any, report: StiReport, name: string): TimeSpan;
        static avg(data: any, report: StiReport, name: string): number;
        static cAvg(data: any, report: StiReport, name: string): number;
        static cAvgRunning(data: any, report: StiReport, name: string): number;
        static avgAllLevels(data: any, report: StiReport, name: string): number;
        static avgAllLevelsOnlyChilds(data: any, report: StiReport, name: string): number;
        static avgOnlyChilds(data: any, report: StiReport, name: string): number;
        static avgDate(data: any, report: StiReport, name: string): DateTime;
        static cAvgDate(data: any, report: StiReport, name: string): DateTime;
        static avgDateAllLevels(data: any, report: StiReport, name: string): DateTime;
        static avgDateAllLevelsOnlyChilds(data: any, report: StiReport, name: string): DateTime;
        static avgDateOnlyChilds(data: any, report: StiReport, name: string): DateTime;
        static avgTime(data: any, report: StiReport, name: string): TimeSpan;
        static cAvgTime(data: any, report: StiReport, name: string): TimeSpan;
        static avgTimeAllLevels(data: any, report: StiReport, name: string): TimeSpan;
        static avgTimeAllLevelsOnlyChilds(data: any, report: StiReport, name: string): TimeSpan;
        static avgTimeOnlyChilds(data: any, report: StiReport, name: string): TimeSpan;
        static max(data: any, report: StiReport, name: string): number;
        static cMax(data: any, report: StiReport, name: string): number;
        static cMaxRunning(data: any, report: StiReport, name: string): number;
        static maxAllLevels(data: any, report: StiReport, name: string): number;
        static maxAllLevelsOnlyChilds(data: any, report: StiReport, name: string): number;
        static maxOnlyChilds(data: any, report: StiReport, name: string): number;
        static min(data: any, report: StiReport, name: string): number;
        static cMin(data: any, report: StiReport, name: string): number;
        static cMinRunning(data: any, report: StiReport, name: string): number;
        static minAllLevels(data: any, report: StiReport, name: string): number;
        static minAllLevelsOnlyChilds(data: any, report: StiReport, name: string): number;
        static minOnlyChilds(data: any, report: StiReport, name: string): number;
        static median(data: any, report: StiReport, name: string): number;
        static cMedian(data: any, report: StiReport, name: string): number;
        static cMedianRunning(data: any, report: StiReport, name: string): number;
        static medianAllLevels(data: any, report: StiReport, name: string): number;
        static medianAllLevelsOnlyChilds(data: any, report: StiReport, name: string): number;
        static medianOnlyChilds(data: any, report: StiReport, name: string): number;
        static mode(data: any, report: StiReport, name: string): number;
        static cMode(data: any, report: StiReport, name: string): number;
        static cModeRunning(data: any, report: StiReport, name: string): number;
        static modeAllLevels(data: any, report: StiReport, name: string): number;
        static modeAllLevelsOnlyChilds(data: any, report: StiReport, name: string): number;
        static modeOnlyChilds(data: any, report: StiReport, name: string): number;
        static first(data: any, report: StiReport, name: string): any;
        static cFirst(data: any, report: StiReport, name: string): any;
        static cFirstRunning(data: any, report: StiReport, name: string): any;
        static firstAllLevels(data: any, report: StiReport, name: string): any;
        static firstAllLevelsOnlyChilds(data: any, report: StiReport, name: string): any;
        static firstOnlyChilds(data: any, report: StiReport, name: string): any;
        static last(data: any, report: StiReport, name: string): any;
        static cLast(data: any, report: StiReport, name: string): any;
        static cLastRunning(data: any, report: StiReport, name: string): any;
        static lastAllLevels(data: any, report: StiReport, name: string): any;
        static lastAllLevelsOnlyChilds(data: any, report: StiReport, name: string): any;
        static lastOnlyChilds(data: any, report: StiReport, name: string): any;
        static count(data: any, report?: StiReport, name?: string): number;
        static cCount(data: any, report?: StiReport, name?: string): number;
        static cCountRunning(data: any, report?: StiReport, name?: string): number;
        static countAllLevels(data: any): number;
        static countAllLevelsOnlyChilds(data: any): number;
        static countOnlyChilds(data: any): number;
        static countDistinct(data: any, report: StiReport, name: string): number;
        static cCountDistinct(data: any, report: StiReport, name: string): number;
        static cCountDistinctRunning(data: any, report: StiReport, name: string): number;
        static countDistinctAllLevels(data: any, report: StiReport, name: string): number;
        static countDistinctAllLevelsOnlyChilds(data: any, report: StiReport, name: string): number;
        static countDistinctOnlyChilds(data: any, report: StiReport, name: string): number;
        static minDate(data: any, report: StiReport, name: string): DateTime;
        static cMinDate(data: any, report: StiReport, name: string): DateTime;
        static minDateAllLevels(data: any, report: StiReport, name: string): DateTime;
        static minDateAllLevelsOnlyChilds(data: any, report: StiReport, name: string): DateTime;
        static minDateOnlyChilds(data: any, report: StiReport, name: string): DateTime;
        static minTime(data: any, report: StiReport, name: string): TimeSpan;
        static cMinTime(data: any, report: StiReport, name: string): TimeSpan;
        static minTimeAllLevels(data: any, report: StiReport, name: string): TimeSpan;
        static minTimeAllLevelsOnlyChilds(data: any, report: StiReport, name: string): TimeSpan;
        static minTimeOnlyChilds(data: any, report: StiReport, name: string): TimeSpan;
        static minStr(data: any, report: StiReport, name: string): string;
        static cMinStr(data: any, report: StiReport, name: string): string;
        static minStrAllLevels(data: any, report: StiReport, name: string): string;
        static minStrAllLevelsOnlyChilds(data: any, report: StiReport, name: string): string;
        static minStrOnlyChilds(data: any, report: StiReport, name: string): string;
        static maxDate(data: any, report: StiReport, name: string): DateTime;
        static cMaxDate(data: any, report: StiReport, name: string): DateTime;
        static maxDateAllLevels(data: any, report: StiReport, name: string): DateTime;
        static maxDateAllLevelsOnlyChilds(data: any, report: StiReport, name: string): DateTime;
        static maxDateOnlyChilds(data: any, report: StiReport, name: string): DateTime;
        static maxTime(data: any, report: StiReport, name: string): TimeSpan;
        static cMaxTime(data: any, report: StiReport, name: string): TimeSpan;
        static maxTimeAllLevels(data: any, report: StiReport, name: string): TimeSpan;
        static maxTimeAllLevelsOnlyChilds(data: any, report: StiReport, name: string): TimeSpan;
        static maxTimeOnlyChilds(data: any, report: StiReport, name: string): TimeSpan;
        static maxStr(data: any, report: StiReport, name: string): string;
        static cMaxStr(data: any, report: StiReport, name: string): string;
        static maxStrAllLevels(data: any, report: StiReport, name: string): string;
        static maxStrAllLevelsOnlyChilds(data: any, report: StiReport, name: string): string;
        static maxStrOnlyChilds(data: any, report: StiReport, name: string): string;
        static stDev(data: any, report: StiReport, name: string): number;
        static cStDev(data: any, report: StiReport, name: string): number;
        static cStDevRunning(data: any, report: StiReport, name: string): number;
        static stDevP(data: any, report: StiReport, name: string): number;
        static cStDevP(data: any, report: StiReport, name: string): number;
        static cStDevPRunning(data: any, report: StiReport, name: string): number;
        static rank(data: any, report: StiReport, name: string, dense?: boolean, sortOrder?: StiRankOrder): number;
        private static saveState;
        private static restoreState;
        private static storeCachedValue;
        private static getCachedValue;
    }
}
export namespace Stimulsoft.Report.BarCodes {
    enum CodeSet {
        None = 0,
        A = 1,
        B = 2,
        C = 3
    }
    enum ControlCodes {
        FNC1 = 129,
        FNC2 = 130,
        FNC3 = 131,
        FNC4 = 132,
        CodeA = 133,
        CodeB = 134,
        CodeC = 135,
        Shift = 136
    }
    enum BarcodeCommands {
        FNC1 = 102,
        FNC2 = 97,
        FNC3 = 96,
        FNC4A = 101,
        FNC4B = 100,
        CodeA = 101,
        CodeB = 100,
        CodeC = 99,
        Shift = 98,
        StartA = 103,
        StartB = 104,
        StartC = 105,
        Stop = 106
    }
    enum StiCheckSum {
        Yes = 0,
        No = 1
    }
    enum StiPlesseyCheckSum {
        None = 0,
        Modulo10 = 1,
        Modulo11 = 2
    }
    enum StiDataMatrixSize {
        Automatic = -1,
        s10x10 = 0,
        s12x12 = 1,
        s8x18 = 2,
        s14x14 = 3,
        s8x32 = 4,
        s16x16 = 5,
        s12x26 = 6,
        s18x18 = 7,
        s20x20 = 8,
        s12x36 = 9,
        s22x22 = 10,
        s16x36 = 11,
        s24x24 = 12,
        s26x26 = 13,
        s16x48 = 14,
        s32x32 = 15,
        s36x36 = 16,
        s40x40 = 17,
        s44x44 = 18,
        s48x48 = 19,
        s52x52 = 20,
        s64x64 = 21,
        s72x72 = 22,
        s80x80 = 23,
        s88x88 = 24,
        s96x96 = 25,
        s104x104 = 26,
        s120x120 = 27,
        s132x132 = 28,
        s144x144 = 29
    }
    enum StiDataMatrixEncodingType {
        Ascii = 0,
        C40 = 1,
        Text = 2,
        X12 = 3,
        Edifact = 4,
        Binary = 5
    }
    enum StiPdf417EncodingMode {
        Text = 0,
        Numeric = 1,
        Byte = 2
    }
    enum StiPdf417ErrorsCorrectionLevel {
        Automatic = -1,
        Level0 = 0,
        Level1 = 1,
        Level2 = 2,
        Level3 = 3,
        Level4 = 4,
        Level5 = 5,
        Level6 = 6,
        Level7 = 7,
        Level8 = 8
    }
    enum StiEanSupplementType {
        None = 0,
        TwoDigit = 1,
        FiveDigit = 2
    }
    enum StiCode11CheckSum {
        None = 0,
        OneDigit = 1,
        TwoDigits = 2,
        Auto = 3
    }
    enum StiQRCodeSize {
        Automatic = 0,
        v1 = 1,
        v2 = 2,
        v3 = 3,
        v4 = 4,
        v5 = 5,
        v6 = 6,
        v7 = 7,
        v8 = 8,
        v9 = 9,
        v10 = 10,
        v11 = 11,
        v12 = 12,
        v13 = 13,
        v14 = 14,
        v15 = 15,
        v16 = 16,
        v17 = 17,
        v18 = 18,
        v19 = 19,
        v20 = 20,
        v21 = 21,
        v22 = 22,
        v23 = 23,
        v24 = 24,
        v25 = 25,
        v26 = 26,
        v27 = 27,
        v28 = 28,
        v29 = 29,
        v30 = 30,
        v31 = 31,
        v32 = 32,
        v33 = 33,
        v34 = 34,
        v35 = 35,
        v36 = 36,
        v37 = 37,
        v38 = 38,
        v39 = 39,
        v40 = 40
    }
    enum StiQRCodeErrorCorrectionLevel {
        Level1 = 0,
        Level2 = 1,
        Level3 = 2,
        Level4 = 3
    }
    enum StiQRCodeECIMode {
        Cp437 = 2,
        ISO_8859_1 = 3,
        ISO_8859_2 = 4,
        ISO_8859_3 = 5,
        ISO_8859_4 = 6,
        ISO_8859_5 = 7,
        ISO_8859_6 = 8,
        ISO_8859_7 = 9,
        ISO_8859_8 = 10,
        ISO_8859_9 = 11,
        ISO_8859_11 = 13,
        ISO_8859_13 = 15,
        ISO_8859_15 = 17,
        Shift_JIS = 20,
        Windows_1250 = 21,
        Windows_1251 = 22,
        Windows_1252 = 23,
        Windows_1256 = 24,
        UTF_8 = 26
    }
    enum StiMaxicodeMode {
        Mode2 = 2,
        Mode3 = 3,
        Mode4 = 4,
        Mode5 = 5,
        Mode6 = 6
    }
    enum StiAztecSize {
        Automatic = 0,
        Compact1 = -1,
        Compact2 = -2,
        Compact3 = -3,
        Compact4 = -4,
        v1 = 1,
        v2 = 2,
        v3 = 3,
        v4 = 4,
        v5 = 5,
        v6 = 6,
        v7 = 7,
        v8 = 8,
        v9 = 9,
        v10 = 10,
        v11 = 11,
        v12 = 12,
        v13 = 13,
        v14 = 14,
        v15 = 15,
        v16 = 16,
        v17 = 17,
        v18 = 18,
        v19 = 19,
        v20 = 20,
        v21 = 21,
        v22 = 22,
        v23 = 23,
        v24 = 24,
        v25 = 25,
        v26 = 26,
        v27 = 27,
        v28 = 28,
        v29 = 29,
        v30 = 30,
        v31 = 31,
        v32 = 32
    }
    enum StiQRCodeBodyShapeType {
        Square = 0,
        RoundedSquare = 1,
        Dot = 2,
        Circle = 3,
        Diamond = 4,
        Star = 5,
        ZebraHorizontal = 6,
        ZebraVertical = 7,
        ZebraCross1 = 8,
        ZebraCross2 = 9,
        Circular = 10,
        DockedDiamonds = 11
    }
    enum StiQRCodeEyeFrameShapeType {
        Square = 0,
        Dots = 1,
        Circle = 2,
        Round = 3,
        Round1 = 4,
        Round3 = 5
    }
    enum StiQRCodeEyeBallShapeType {
        Square = 0,
        Dots = 1,
        Circle = 2,
        Round = 3,
        Round1 = 4,
        Round3 = 5,
        Star = 6,
        ZebraHorizontal = 7,
        ZebraVertical = 8
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import IStiBackColor = Stimulsoft.Report.Components.IStiBackColor;
    import IStiForeColor = Stimulsoft.Report.Components.IStiForeColor;
    let IStiBarCode: System.Interface<IStiBarCode>;
    interface IStiBarCode extends IStiBackColor, IStiForeColor {
        getBarCodeString(): string;
        autoScale: boolean;
        showLabelText: boolean;
        barCodeType: StiBarCodeTypeService;
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import List = Stimulsoft.System.Collections.List;
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import StringFormat = Stimulsoft.System.Drawing.StringFormat;
    import SizeD = Stimulsoft.System.Drawing.Size;
    import PointD = Stimulsoft.System.Drawing.Point;
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    import StiJson = Stimulsoft.Base.StiJson;
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import StiService = Stimulsoft.Base.Services.StiService;
    import StringAlignment = Stimulsoft.System.Drawing.StringAlignment;
    import Font = Stimulsoft.System.Drawing.Font;
    import Color = Stimulsoft.System.Drawing.Color;
    import Image = Stimulsoft.System.Drawing.Image;
    import IStiBarCodePainter = Stimulsoft.Report.Painters.IStiBarCodePainter;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    interface DrawBaseLinesDelegate {
        (cobtext: any, brush: StiBrush, barCode: StiBarCodeTypeService): any;
    }
    enum BarcodeCommandCode {
        Fnc1 = 65457,
        Fnc2 = 65458,
        Fnc3 = 65459,
        Fnc4 = 65460
    }
    class StiBarCodeTypeService extends StiService {
        getNetTypeName(): string;
        static loadFromJsonObjectInternal(jObject: StiJson): StiBarCodeTypeService;
        static loadFromXmlInternal(xmlNode: XmlNode): StiBarCodeTypeService;
        meta(): StiMeta[];
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(j: StiJson): void;
        loadFromXml(xn: XmlNode): void;
        get componentId(): StiComponentId;
        visiblePropertiesCount: number;
        private _visibleProperties;
        get visibleProperties(): boolean[];
        set visibleProperties(value: boolean[]);
        get defaultCodeValue(): string;
        customPainter: IStiBarCodePainter;
        private _mainWidth;
        get mainWidth(): number;
        private _mainHeight;
        get mainHeight(): number;
        barCodeData: StiBarCodeData;
        get module(): number;
        set module(value: number);
        get height(): number;
        set height(value: number);
        protected get textAlignment(): StringAlignment;
        protected textSpacing: boolean;
        protected preserveAspectRatio: boolean;
        protected rectWindow: RectangleD;
        get labelFontHeight(): number;
        protected defaultLabelFontHeight: number;
        protected checkCodeSymbols(inputCode: string, tolerantSymbols: string): string;
        getCode(barCode: IStiBarCode): string;
        getCombinedCode(): string;
        static unpackTilde(input: number[], processTilde: boolean): number[];
        static unpackTildeString(input: string, processTilde: boolean): string;
        protected getSymbolWidth(symbol: string): number;
        protected isSymbolLong(symbol: string): boolean;
        protected isSymbolSpace(symbol: string): boolean;
        protected isSymbolPostDescend(symbol: string): boolean;
        protected getSymbolsStringWidth(symbolsString: string): number;
        protected drawBars(context: any, sym: string, foreBrush: StiBrush): void;
        protected drawBarCode(context: any, rect: RectangleD, barCode: StiBarCode): void;
        protected drawBarCode1(context: any, rect: RectangleD, barCode: StiBarCode, drawMethod: DrawBaseLinesDelegate): void;
        protected calculateSizeFull(spaceLeft: number, spaceRight: number, spaceTop: number, spaceBottom: number, lineHeightShort: number, lineHeightLong: number, TextPosition: number, TextHeight: number, mainHeight: number, lineHeightForCut: number, wideToNarrowRatio: number, zoom: number, code: string, textString: string, barsArray: string, rect: RectangleD, barCode: StiBarCode): void;
        protected calculateSize2(spaceLeft: number, spaceRight: number, spaceTop: number, spaceBottom: number, lineHeightShort: number, lineHeightLong: number, textPosition: number, textHeight: number, mainHeight: number, wideToNarrowRatio: number, zoom: number, barsArray: string, rect: RectangleD, barCode: StiBarCode): void;
        protected draw2DBarCode(context: any, rect: RectangleD, barCode: StiBarCode, zoom: number): void;
        protected drawMaxicode(context: any, rect: RectangleD, barCode: StiBarCode, zoom: number): void;
        protected drawBarCodeError(context: any, rect: RectangleD, barCode: StiBarCode): void;
        protected drawBarCodeError2(context: any, rect: RectangleD, barCode: StiBarCode, message: string): void;
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        protected translateRect(context: any, rect: RectangleD, barCode: StiBarCode): void;
        protected rollbackTransform(context: any): void;
        protected baseDrawString(context: any, st: string, font: Font, brush: StiBrush, x: number, y: number): void;
        protected baseTransform(context: any, x: number, y: number, angle: number, dx: number, dy: number): void;
        protected baseRollbackTransform(context: any): void;
        baseFillRectangle(context: any, brush: StiBrush, x: number, y: number, width: number, height: number): void;
        protected baseFillRectangle2D(context: any, brush: StiBrush, x: number, y: number, width: number, height: number): void;
        protected baseFillPolygon(context: any, brush: StiBrush, points: PointD[]): void;
        protected baseFillPolygons(context: any, brush: StiBrush, points: List<List<PointD>>): void;
        protected baseFillEllipse(context: any, brush: StiBrush, x: number, y: number, width: number, height: number): void;
        protected baseDrawRectangle(context: any, penColor: Color, penSize: number, x: number, y: number, width: number, height: number): void;
        protected baseDrawImage(context: any, image: Image, report: StiReport, x: number, y: number, width: number, height: number): void;
        protected baseDrawString2(context: any, st: string, font: Font, brush: StiBrush, rect: RectangleD, sf: StringFormat): void;
        protected baseMeasureString3(context: any, st: string, font: Font): SizeD;
        createNew(): StiBarCodeTypeService;
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StringAlignment = Stimulsoft.System.Drawing.StringAlignment;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiAustraliaPost4StateBarCodeType extends StiBarCodeTypeService implements IStiJsonReportObject {
        meta(): StiMeta[];
        get componentId(): StiComponentId;
        get serviceName(): string;
        protected australiaPost4StateSymbolsC: string;
        protected australiaPost4StateSymbolsN: string;
        private australiaPost4StateStartCode;
        private australiaPost4StateStopCode;
        get defaultCodeValue(): string;
        private _module;
        get module(): number;
        set module(value: number);
        private _height;
        get height(): number;
        set height(value: number);
        get labelFontHeight(): number;
        protected preserveAspectRatio: boolean;
        get visibleProperties(): boolean[];
        protected australiaPost4StateSpaceLeft: number;
        protected australiaPost4StateSpaceRight: number;
        protected australiaPost4StateSpaceTop: number;
        protected australiaPost4StateSpaceBottom: number;
        protected australiaPost4StateLineHeightLong: number;
        protected australiaPost4StateLineHeightShort: number;
        protected australiaPost4StateTextPosition: number;
        protected australiaPost4StateTextHeight: number;
        protected australiaPost4StateMainHeight: number;
        protected australiaPost4StateLineHeightForCut: number;
        protected get textAlignment(): StringAlignment;
        private mult;
        private gen;
        private rSInitialise;
        private rSEncode;
        private charTo4State;
        private stateToBar;
        private makeBarsArray;
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    import StiAztecSize = Stimulsoft.Report.BarCodes.StiAztecSize;
    class BitArray {
        private bits;
        size: number;
        get aizeInBytes(): number;
        get(i: number): boolean;
        set(i: number, value: boolean): void;
        constructor();
        private ensureCapacity;
        appendBit(bit: boolean): void;
        appendBits(value: number, numBits: number): void;
        appendBitArray(other: BitArray): void;
        private makeArray;
    }
    export class HighLevelEncoder {
        static MODE_UPPER: number;
        static MODE_LOWER: number;
        static MODE_DIGIT: number;
        static MODE_MIXED: number;
        static MODE_PUNCT: number;
        static readonly LATCH_TABLE: number[][];
        static readonly CHAR_MAP: number[][];
        static readonly SHIFT_TABLE: number[][];
        private readonly text;
        private readonly eci;
        static staticConstructor(): void;
        constructor(text: number[], eci: number);
        encode(): BitArray;
        private updateStateListForChar;
        private updateStateForChar;
        private static updateStateListForPair;
        private static updateStateForPair;
        private static simplifyStates;
    }
    export class StiAztecBarCodeType extends StiBarCodeTypeService implements IStiJsonReportObject {
        meta(): StiMeta[];
        get componentId(): StiComponentId;
        get serviceName(): string;
        get defaultCodeValue(): string;
        private _module;
        get module(): number;
        set module(value: number);
        private _height;
        get height(): number;
        set height(value: number);
        private _errorCorrectionLevel;
        get errorCorrectionLevel(): number;
        set errorCorrectionLevel(value: number);
        matrixSize: StiAztecSize;
        private _codePage;
        get codePage(): number;
        set codePage(value: number);
        get labelFontHeight(): number;
        get visibleProperties(): boolean[];
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, errorCorrectionLevel?: number, matrixSize?: StiAztecSize, codePage?: number);
    }
    export {};
}
export namespace Stimulsoft.Report.BarCodes {
    class StiBarCodeData {
        spaceLeft: number;
        spaceRight: number;
        spaceTop: number;
        spaceBottom: number;
        lineHeightShort: number;
        lineHeightLong: number;
        lineWidth: number;
        textPosition: number;
        textHeight: number;
        mainHeight: number;
        mainWidth: number;
        wideToNarrowRatio: number;
        code: string;
        textString: string;
        barsArray: string;
        fullZoomY: number;
        spaceBeforeAdd: number;
        spaceTextTop: number;
        textPositionTop: number;
        textPositionBottom: number;
        eanBarsArray: EanBarInfo[];
        offsetY: number;
        matrixGrid: number[];
        matrixWidth: number;
        matrixHeight: number;
        matrixRatioY: number;
    }
}
export namespace Stimulsoft.Report.BarCodes.StiBarcodeUtils {
    export class GaloisFieldPolynomial {
        private field;
        private coefficients;
        constructor(field: GaloisField, coefficients: number[]);
        get getCoefficients(): number[];
        get getDegree(): number;
        get isZero(): boolean;
        getCoefficient(degree: number): number;
        addOrSubtract(other: GaloisFieldPolynomial): GaloisFieldPolynomial;
        multiply(other: GaloisFieldPolynomial): GaloisFieldPolynomial;
        multiplyByMonomial(degree: number, coefficient: number): GaloisFieldPolynomial;
        divide(other: GaloisFieldPolynomial): GaloisFieldPolynomial[];
    }
    export class GaloisField {
        static Aztec_Data_12: GaloisField;
        static Aztec_Data_10: GaloisField;
        static Aztec_Data_8: GaloisField;
        static Aztec_Data_6: GaloisField;
        static Aztec_Param: GaloisField;
        static QRCode_256: GaloisField;
        static Maxicode_64: GaloisField;
        static DataMatrix_256: GaloisField;
        private expTable;
        private logTable;
        private zero;
        private one;
        private size;
        private generatorBase;
        constructor(primitive: number, size: number, genBase: number);
        get getZero(): GaloisFieldPolynomial;
        get getOne(): GaloisFieldPolynomial;
        get getGeneratorBase(): number;
        buildMonomial(degree: number, coefficient: number): GaloisFieldPolynomial;
        static addOrSubtract(a: number, b: number): number;
        exp(a: number): number;
        inverse(a: number): number;
        multiply(a: number, b: number): number;
    }
    export class ReedSolomonEncoder {
        private field;
        private cachedGenerators;
        constructor(field: GaloisField);
        private buildGenerator;
        encode(toEncode: number[], ecBytes: number): void;
    }
    export class BitMatrix {
        width: number;
        height: number;
        private rowSize;
        private bits;
        constructor(width: number, height?: number);
        get(x: number, y: number): boolean;
        set(x: number, y: number, value: boolean): void;
    }
    class Node<T> {
        data: T;
        next: Node<T> | null;
        prev: Node<T> | null;
        constructor(data: T);
    }
    export class LinkedList<T> {
        private head;
        addLast(data: T): Node<T>;
        addFirst(data: T): Node<T>;
        removeNode(node: Node<T>): void;
        remove(data: T): void;
        search(data: T): Node<T> | null;
        list(): T[];
        size(): number;
    }
    export {};
}
export namespace Stimulsoft.Report.BarCodes {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiCodabarBarCodeType extends StiBarCodeTypeService implements IStiJsonReportObject {
        meta(): StiMeta[];
        get componentId(): StiComponentId;
        get serviceName(): string;
        private codabarSymbols;
        private codabarTable;
        get defaultCodeValue(): string;
        private _module;
        get module(): number;
        set module(value: number);
        private _height;
        get height(): number;
        set height(value: number);
        private _ratio;
        get ratio(): number;
        set ratio(value: number);
        get labelFontHeight(): number;
        get visibleProperties(): boolean[];
        codabarSpaceLeft: number;
        codabarSpaceRight: number;
        codabarSpaceTop: number;
        codabarSpaceBottom: number;
        codabarLineHeightShort: number;
        codabarLineHeightLong: number;
        codabarTextPosition: number;
        codabarTextHeight: number;
        codabarMainHeight: number;
        codabarLineHeightForCut: number;
        codeToBar(inputCode: string): string;
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number, ratio?: number);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiCode11BarCodeType extends StiBarCodeTypeService implements IStiJsonReportObject {
        meta(): StiMeta[];
        get componentId(): StiComponentId;
        get serviceName(): string;
        code11Symbols: string;
        code11StartStopSymbolIndex: number;
        code11Table: string[];
        code11SpaceLeft: number;
        code11SpaceRight: number;
        code11SpaceTop: number;
        code11SpaceBottom: number;
        code11LineHeightShort: number;
        code11LineHeightLong: number;
        code11TextPosition: number;
        code11TextHeight: number;
        code11MainHeight: number;
        code11LineHeightForCut: number;
        defaultCode11Module: number;
        get defaultCodeValue(): string;
        private _module;
        get module(): number;
        set module(value: number);
        private _height;
        get height(): number;
        set height(value: number);
        checksum: StiCode11CheckSum;
        get labelFontHeight(): number;
        get visibleProperties(): boolean[];
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number, checksum?: StiCode11CheckSum);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    class StiCode128BarCodeType extends StiBarCodeTypeService implements IStiJsonReportObject {
        meta(): StiMeta[];
        protected code128Table: string[];
        private _module;
        get module(): number;
        set module(value: number);
        private _height;
        get height(): number;
        set height(value: number);
        get labelFontHeight(): number;
        get visibleProperties(): boolean[];
        protected code128SpaceLeft: number;
        protected code128SpaceRight: number;
        protected code128SpaceTop: number;
        protected code128SpaceBottom: number;
        protected code128LineHeightShort: number;
        protected code128LineHeightLong: number;
        protected code128TextPosition: number;
        protected code128TextHeight: number;
        protected code128MainHeight: number;
        protected code128LineHeightForCut: number;
        protected defaultCodeSetAB: CodeSet;
        protected codeToBar(inputCode: string): string;
        protected encodeAuto(inputText: string, encodeAsEan: boolean): string;
        private isDigit;
        private getSet;
        constructor(module?: number, height?: number);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiCode128AutoBarCodeType extends StiCode128BarCodeType {
        get componentId(): StiComponentId;
        get serviceName(): string;
        get defaultCodeValue(): string;
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiCode128aBarCodeType extends StiCode128BarCodeType {
        get componentId(): StiComponentId;
        get serviceName(): string;
        get defaultCodeValue(): string;
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiCode128bBarCodeType extends StiCode128BarCodeType {
        get componentId(): StiComponentId;
        get serviceName(): string;
        get defaultCodeValue(): string;
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiCode128cBarCodeType extends StiCode128BarCodeType {
        get componentId(): StiComponentId;
        get serviceName(): string;
        get defaultCodeValue(): string;
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiCode39BarCodeType extends StiBarCodeTypeService implements IStiJsonReportObject {
        meta(): StiMeta[];
        get componentId(): StiComponentId;
        get serviceName(): string;
        code39Symbols: string;
        code39StartStopSymbolIndex: number;
        code39Table: string[];
        get defaultCodeValue(): string;
        checkSum: StiCheckSum;
        private _module;
        get module(): number;
        set module(value: number);
        private _height;
        get height(): number;
        set height(value: number);
        private _ratio;
        get ratio(): number;
        set ratio(value: number);
        get labelFontHeight(): number;
        get visibleProperties(): boolean[];
        code39SpaceLeft: number;
        code39SpaceRight: number;
        code39SpaceTop: number;
        code39SpaceBottom: number;
        code39LineHeightShort: number;
        code39LineHeightLong: number;
        code39TextPosition: number;
        code39TextHeight: number;
        code39MainHeight: number;
        code39LineHeightForCut: number;
        codeToBar(inputCode: string): string;
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number, ratio?: number, checkSum?: StiCheckSum);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiCode39ExtBarCodeType extends StiCode39BarCodeType {
        get componentId(): StiComponentId;
        get serviceName(): string;
        get defaultCodeValue(): string;
        protected code39ExtTable: string[];
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number, ratio?: number, checkSum?: StiCheckSum);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiCode93BarCodeType extends StiBarCodeTypeService implements IStiJsonReportObject {
        meta(): StiMeta[];
        get componentId(): StiComponentId;
        get serviceName(): string;
        private code93Symbols;
        code93Table: string[];
        get defaultCodeValue(): string;
        private _module;
        get module(): number;
        set module(value: number);
        private _height;
        get height(): number;
        set height(value: number);
        private _ratio;
        get ratio(): number;
        set ratio(value: number);
        get labelFontHeight(): number;
        get visibleProperties(): boolean[];
        code93SpaceLeft: number;
        code93SpaceRight: number;
        code93SpaceTop: number;
        code93SpaceBottom: number;
        code93LineHeightShort: number;
        code93LineHeightLong: number;
        code93TextPosition: number;
        code93TextHeight: number;
        code93MainHeight: number;
        code93LineHeightForCut: number;
        codeToBar(inputCode: string): string;
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number, ratio?: number);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiCode93ExtBarCodeType extends StiCode93BarCodeType {
        get componentId(): StiComponentId;
        get serviceName(): string;
        get defaultCodeValue(): string;
        private code93ExtSymbols;
        private code93ExtTable;
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number, ratio?: number);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiDataMatrix {
        get matrix(): number[];
        get width(): number;
        get height(): number;
        get errorMessage(): string;
        private gridWidth;
        private gridHeight;
        private grid;
        private _errorMessage;
        private ecc200List;
        private _processTilde;
        private dataMatrixPlacementbit;
        private dataMatrixPlacementBlock;
        private dataMatrixPlacementCornerA;
        private dataMatrixPlacementCornerB;
        private dataMatrixPlacementCornerC;
        private dataMatrixPlacementCornerD;
        private dataMatrixPlacement;
        private makeEcc200Blocks;
        private dataMatrixEncode;
        private encodeB;
        private encodeA;
        private encodeE;
        private encodeCTX;
        private static isDigit;
        private static convertStringToBytes;
        private makeGrid;
        constructor(message: string, globalEncoding: StiDataMatrixEncodingType, useRectangularSymbols: boolean, matrixSize: StiDataMatrixSize, processTilde: boolean);
    }
    class StiDataMatrixBarCodeType extends StiBarCodeTypeService implements IStiJsonReportObject {
        meta(): StiMeta[];
        get componentId(): StiComponentId;
        get serviceName(): string;
        get defaultCodeValue(): string;
        private _module;
        get module(): number;
        set module(value: number);
        private _height;
        get height(): number;
        set height(value: number);
        encodingType: StiDataMatrixEncodingType;
        matrixSize: StiDataMatrixSize;
        useRectangularSymbols: boolean;
        processTilde: boolean;
        get labelFontHeight(): number;
        get visibleProperties(): boolean[];
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, encodingType?: StiDataMatrixEncodingType, useRectangularSymbols?: boolean, matrixSize?: StiDataMatrixSize, processTilde?: boolean);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    import StringAlignment = Stimulsoft.System.Drawing.StringAlignment;
    class StiDutchKIXBarCodeType extends StiBarCodeTypeService implements IStiJsonReportObject {
        meta(): StiMeta[];
        get componentId(): StiComponentId;
        get serviceName(): string;
        dutchKIXSymbols: string;
        private dutchKIXCodes;
        get defaultCodeValue(): string;
        private _module;
        get module(): number;
        set module(value: number);
        private _height;
        get height(): number;
        set height(value: number);
        get labelFontHeight(): number;
        protected preserveAspectRatio: boolean;
        get visibleProperties(): boolean[];
        dutchKIXSpaceLeft: number;
        dutchKIXSpaceRight: number;
        dutchKIXSpaceTop: number;
        dutchKIXSpaceBottom: number;
        dutchKIXLineHeightLong: number;
        dutchKIXLineHeightShort: number;
        dutchKIXTextPosition: number;
        dutchKIXTextHeight: number;
        dutchKIXMainHeight: number;
        dutchKIXLineHeightForCut: number;
        get textAlignment(): StringAlignment;
        private charTo4State;
        private stateToBar;
        private makeBarsArray;
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiEAN128AutoBarCodeType extends StiCode128BarCodeType {
        get componentId(): StiComponentId;
        get serviceName(): string;
        get defaultCodeValue(): string;
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiEAN128aBarCodeType extends StiCode128BarCodeType {
        get componentId(): StiComponentId;
        get serviceName(): string;
        get defaultCodeValue(): string;
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiEAN128bBarCodeType extends StiCode128BarCodeType {
        get componentId(): StiComponentId;
        get serviceName(): string;
        get defaultCodeValue(): string;
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiEAN128cBarCodeType extends StiCode128BarCodeType {
        get componentId(): StiComponentId;
        get serviceName(): string;
        get defaultCodeValue(): string;
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class EanBarInfo {
        symbolType: Ean13Symbol;
        symbolText: string;
        textAtTop: boolean;
        makeLonger: boolean;
        constructor(symbolType: Ean13Symbol, symbolText: string, textAtTop: boolean, makeLonger?: boolean);
    }
    enum Ean13Symbol {
        ComboA0 = 0,
        ComboA1 = 1,
        ComboA2 = 2,
        ComboA3 = 3,
        ComboA4 = 4,
        ComboA5 = 5,
        ComboA6 = 6,
        ComboA7 = 7,
        ComboA8 = 8,
        ComboA9 = 9,
        ComboB0 = 10,
        ComboB1 = 11,
        ComboB2 = 12,
        ComboB3 = 13,
        ComboB4 = 14,
        ComboB5 = 15,
        ComboB6 = 16,
        ComboB7 = 17,
        ComboB8 = 18,
        ComboB9 = 19,
        ComboC0 = 20,
        ComboC1 = 21,
        ComboC2 = 22,
        ComboC3 = 23,
        ComboC4 = 24,
        ComboC5 = 25,
        ComboC6 = 26,
        ComboC7 = 27,
        ComboC8 = 28,
        ComboC9 = 29,
        GuardLeft = 30,
        GuardCenter = 31,
        GuardRight = 32,
        GuardSpecial = 33,
        GuardAddLeft = 34,
        GuardAddDelineator = 35,
        SpaceLeft = 36,
        SpaceRight = 37,
        SpaceBeforeAdd = 38
    }
    class StiEAN13BarCodeType extends StiBarCodeTypeService implements IStiJsonReportObject {
        meta(): StiMeta[];
        get componentId(): StiComponentId;
        get serviceName(): string;
        get defaultCodeValue(): string;
        get visibleProperties(): boolean[];
        private _module;
        get module(): number;
        set module(value: number);
        private _height;
        get height(): number;
        set height(value: number);
        supplementType: StiEanSupplementType;
        supplementCode: string;
        showQuietZoneIndicator: boolean;
        get labelFontHeight(): number;
        protected get eanSpaceLeft(): number;
        protected get eanSpaceRight(): number;
        protected get eanSpaceTop(): number;
        protected get eanSpaceBottom(): number;
        protected get eanSpaceBeforeAdd(): number;
        protected get eanSpaceTextTop(): number;
        protected get eanLineHeightShort(): number;
        protected get eanLineHeightLong(): number;
        protected get eanTextPositionTop(): number;
        protected get eanTextPositionBottom(): number;
        protected get eanTextHeight(): number;
        protected get eanMainHeight(): number;
        protected get eanLineHeightForCut(): number;
        protected get eanWideToNarrowRatio(): number;
        protected symComboSet: string[];
        protected symParitySetAdd2: string[];
        protected symParitySetAdd5: string[];
        protected ean13SymData: string[];
        protected calculateSizeEan(offsetY: number, zoom: number, barsArray: EanBarInfo[], rect: RectangleD, barCode: StiBarCode): void;
        protected drawEanBars(context: any, barsArray: EanBarInfo[], barCode: StiBarCode): void;
        protected makeEan13Bars(REFcode: any, isLast: boolean): EanBarInfo[];
        protected makeEanAdd2Bars(code: string, baseArray: EanBarInfo[], isLast: boolean): EanBarInfo[];
        protected makeEanAdd5Bars(code: string, baseArray: EanBarInfo[], isLast: boolean): EanBarInfo[];
        protected makeLonger(symString: string): string;
        protected getSymbolWidth(symbol: string): number;
        protected isSymbolSpace(symbol: string): boolean;
        draw(context: number, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number, supplementType?: StiEanSupplementType, supplementCodeValue?: string, showQuietZoneIndicator?: boolean);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiEAN8BarCodeType extends StiEAN13BarCodeType {
        get componentId(): StiComponentId;
        get serviceName(): string;
        get defaultCodeValue(): string;
        get eanSpaceLeft(): number;
        get eanSpaceRight(): number;
        get eanLineHeightShort(): number;
        get eanMainHeight(): number;
        makeEan8Bars(code: string, isLast: boolean): EanBarInfo[];
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number, supplementType?: StiEanSupplementType, supplementCodeValue?: string, showQuietZoneIndicator?: boolean);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiFIMBarCodeType extends StiBarCodeTypeService implements IStiJsonReportObject {
        meta(): StiMeta[];
        get componentId(): StiComponentId;
        get serviceName(): string;
        fIMSymbols: string;
        fIMTable: string[];
        defaultFIMModule: number;
        get defaultCodeValue(): string;
        get visibleProperties(): boolean[];
        private _module;
        get module(): number;
        set module(value: number);
        private _height;
        get height(): number;
        set height(value: number);
        addClearZone: boolean;
        get labelFontHeight(): number;
        protected preserveAspectRatio: boolean;
        get fIMSpaceLeft(): number;
        get fIMSpaceRight(): number;
        fIMSpaceTop: number;
        fIMSpaceBottom: number;
        fIMLineHeightShort: number;
        fIMLineHeightLong: number;
        fIMTextPosition: number;
        fIMTextHeight: number;
        fIMMainHeight: number;
        fIMLineHeightForCut: number;
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number, addClearZone?: boolean);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import StringBuilder = Stimulsoft.System.Text.StringBuilder;
    class StiGS1ApplicationIdentifierItem {
        AICode: string;
        AILength: number;
        NumericMin: number;
        NumericMax: number;
        CharacterMin: number;
        CharacterMax: number;
        NeedFNC1: boolean;
        DataTitle: string;
        DataContent: string;
        constructor(AICode: string, AILength: number, NumericMin: number, NumericMax: number, CharacterMin: number, CharacterMax: number, NeedFNC1: boolean, DataTitle: string, DataContent: string);
    }
    export class StiGS1ApplicationIdentifiers {
        static GS1ApplicationIdentifiers: StiGS1ApplicationIdentifierItem[];
        private static AICodeToItem;
        static getApplicationIdentifierItemByCode(code: string): StiGS1ApplicationIdentifierItem;
        static parseCode(code: string, outputCode: StringBuilder, outputText: StringBuilder, fnc1: string, addLeadingFnc1: boolean): string;
    }
    export {};
}
export namespace Stimulsoft.Report.BarCodes {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiGS1DataMatrixBarCodeType extends Stimulsoft.Report.BarCodes.StiDataMatrixBarCodeType implements IStiJsonReportObject {
        meta(): StiMeta[];
        get componentId(): StiComponentId;
        get serviceName(): string;
        get defaultCodeValue(): string;
        encodingType: StiDataMatrixEncodingType;
        get visibleProperties(): boolean[];
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, encodingType?: StiDataMatrixEncodingType, useRectangularSymbols?: boolean, matrixSize?: StiDataMatrixSize, processTilde?: boolean);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import Rectangle = Stimulsoft.System.Drawing.Rectangle;
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    import StiQRCodeEyeBallShapeType = Stimulsoft.Report.BarCodes.StiQRCodeEyeBallShapeType;
    import StiQRCodeBodyShapeType = Stimulsoft.Report.BarCodes.StiQRCodeBodyShapeType;
    import StiQRCodeEyeFrameShapeType = Stimulsoft.Report.BarCodes.StiQRCodeEyeFrameShapeType;
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import Image = Stimulsoft.System.Drawing.Image;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiQRCodeBarCodeType extends StiBarCodeTypeService implements IStiJsonReportObject {
        meta(): StiMeta[];
        get componentId(): StiComponentId;
        get serviceName(): string;
        get defaultCodeValue(): string;
        private _module;
        get module(): number;
        set module(value: number);
        private _height;
        get height(): number;
        set height(value: number);
        errorCorrectionLevel: StiQRCodeErrorCorrectionLevel;
        matrixSize: StiQRCodeSize;
        image: Image;
        imageMultipleFactor: number;
        bodyShape: StiQRCodeBodyShapeType;
        eyeFrameShape: StiQRCodeEyeFrameShapeType;
        eyeBallShape: StiQRCodeEyeBallShapeType;
        bodyBrush: StiBrush;
        eyeFrameBrush: StiBrush;
        eyeBallBrush: StiBrush;
        processTilde: boolean;
        get labelFontHeight(): number;
        get visibleProperties(): boolean[];
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        drawQRCode(context: any, rect: Rectangle, barCode: StiBarCode, zoom: number, bodyShape: StiQRCodeBodyShapeType, eyeFrameShape: StiQRCodeEyeFrameShapeType, eyeBallShape: StiQRCodeEyeBallShapeType): void;
        private addArcPoints;
        private drawBodyShapes;
        private drawBodyShapeCircleZebraHorizontal;
        private drawBodyShapeCircleZebraVertical;
        private drawBodyShapeCircleZebraCross1;
        private drawBodyShapeCircleZebraCross2;
        private drawEyeFrames;
        private drawEyeFrameSquare;
        private drawEyeFrameDots;
        private drawEyeFrameCircle;
        private drawEyeFrameRound;
        private drawEyeFrameRound1;
        private drawEyeFrameRound3;
        private drawEyeBalls;
        private drawEyeBallSquare;
        private drawEyeBallDots;
        private drawEyeBallCircle;
        private drawEyeBallRound;
        private drawEyeBallRound1;
        private drawEyeBallRound3;
        private drawEyeBallStar;
        private drawEyeBallCircleZebraHorizontal;
        private drawEyeBallCircleZebraVertical;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, errorCorrectionLevel?: StiQRCodeErrorCorrectionLevel, matrixSize?: StiQRCodeSize, image?: Image, imageMultipleFactor?: number, processTilde?: boolean, bodyShape?: StiQRCodeBodyShapeType, eyeFrameShape?: StiQRCodeEyeFrameShapeType, eyeBallShape?: StiQRCodeEyeBallShapeType, bodyBrush?: StiBrush, eyeFrameBrush?: StiBrush, eyeBallBrush?: StiBrush);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    import StiQRCodeEyeBallShapeType = Stimulsoft.Report.BarCodes.StiQRCodeEyeBallShapeType;
    import StiQRCodeBodyShapeType = Stimulsoft.Report.BarCodes.StiQRCodeBodyShapeType;
    import StiQRCodeEyeFrameShapeType = Stimulsoft.Report.BarCodes.StiQRCodeEyeFrameShapeType;
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import Image = Stimulsoft.System.Drawing.Image;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiGS1QRCodeBarCodeType extends StiQRCodeBarCodeType implements IStiJsonReportObject {
        meta(): StiMeta[];
        get componentId(): StiComponentId;
        get serviceName(): string;
        get defaultCodeValue(): string;
        get visibleProperties(): boolean[];
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, errorCorrectionLevel?: StiQRCodeErrorCorrectionLevel, matrixSize?: StiQRCodeSize, image?: Image, imageMultipleFactor?: number, processTilde?: boolean, bodyShape?: StiQRCodeBodyShapeType, eyeFrameShape?: StiQRCodeEyeFrameShapeType, eyeBallShape?: StiQRCodeEyeBallShapeType, bodyBrush?: StiBrush, eyeFrameBrush?: StiBrush, eyeBallBrush?: StiBrush);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiGS1_128BarCodeType extends StiCode128BarCodeType {
        get componentId(): StiComponentId;
        get serviceName(): string;
        get defaultCodeValue(): string;
        protected textSpacing: boolean;
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiITF14BarCodeType extends StiBarCodeTypeService implements IStiJsonReportObject {
        meta(): StiMeta[];
        get componentId(): StiComponentId;
        get serviceName(): string;
        get defaultCodeValue(): string;
        private _module;
        get module(): number;
        set module(value: number);
        private _height;
        get height(): number;
        set height(value: number);
        private _ratio;
        get ratio(): number;
        set ratio(value: number);
        printVerticalBars: boolean;
        get labelFontHeight(): number;
        get visibleProperties(): boolean[];
        protected symTableSet: string[];
        private itf14BearerBarWidth;
        private itf14SpaceLeft;
        private itf14SpaceRight;
        private itf14SpaceTop;
        private itf14SpaceBottom;
        private itf14LineHeightShort;
        private itf14LineHeightLong;
        private itf14TextHeight;
        private itf14MainHeight;
        private itf14TextPosition;
        private itf14LineHeightForCut;
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number, ratio?: number, printVerticalBars?: boolean);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    import StringAlignment = Stimulsoft.System.Drawing.StringAlignment;
    class IntelligentMail4State {
        private static table2Of13Size;
        private static table5Of13Size;
        private static entries2Of13;
        private static entries5Of13;
        private static table2Of13;
        private static table5Of13;
        private static codewordArray;
        private static barTopCharIndexArray;
        private static barBottomCharIndexArray;
        private static barTopCharShiftArray;
        private static barBottomCharShiftArray;
        static encode(source: string, refBars: {
            bars: string;
        }): string;
        private static mathAdd;
        private static mathDivide;
        private static mathFcs;
        private static mathMultiply;
        private static mathReverse;
        private static initializeNof13Table;
        static staticConstructor(): void;
    }
    class StiIntelligentMail4StateBarCodeType extends StiBarCodeTypeService implements IStiJsonReportObject {
        meta(): StiMeta[];
        get componentId(): StiComponentId;
        get serviceName(): string;
        protected intelligentMail4StateSpaceLeft: number;
        protected intelligentMail4StateSpaceRight: number;
        protected intelligentMail4StateSpaceTop: number;
        protected intelligentMail4StateSpaceBottom: number;
        protected intelligentMail4StateLineHeightLong: number;
        protected intelligentMail4StateLineHeightShort: number;
        protected intelligentMail4StateTextPosition: number;
        protected intelligentMail4StateTextHeight: number;
        protected intelligentMail4StateMainHeight: number;
        protected intelligentMail4StateLineHeightForCut: number;
        protected intelligentMail4StateWideToNarrowRatio: number;
        protected get textAlignment(): StringAlignment;
        get defaultCodeValue(): string;
        private _module;
        get module(): number;
        set module(value: number);
        private _height;
        get height(): number;
        set height(value: number);
        get labelFontHeight(): number;
        protected textSpacing: boolean;
        protected preserveAspectRatio: boolean;
        get visibleProperties(): boolean[];
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiInterleaved2of5BarCodeType extends StiBarCodeTypeService implements IStiJsonReportObject {
        meta(): StiMeta[];
        get componentId(): StiComponentId;
        get serviceName(): string;
        get defaultCodeValue(): string;
        private _module;
        get module(): number;
        set module(value: number);
        private _height;
        get height(): number;
        set height(value: number);
        private _ratio;
        get ratio(): number;
        set ratio(value: number);
        get labelFontHeight(): number;
        get visibleProperties(): boolean[];
        protected symTableSet: string[];
        private interleaved2of5SpaceLeft;
        private interleaved2of5SpaceRight;
        private interleaved2of5SpaceTop;
        private interleaved2of5SpaceBottom;
        private interleaved2of5LineHeightShort;
        private interleaved2of5LineHeightLong;
        private interleaved2of5TextHeight;
        private interleaved2of5MainHeight;
        private interleaved2of5TextPosition;
        private interleaved2of5LineHeightForCut;
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        StiInterleaved2of5BarCodeType(module?: number, height?: number, ratio?: number): void;
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiIsbn13BarCodeType extends StiEAN13BarCodeType {
        get componentId(): StiComponentId;
        get serviceName(): string;
        get defaultCodeValue(): string;
        isbnOffsetY: number;
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number, supplementType?: StiEanSupplementType, supplementCodeValue?: string, showQuietZoneIndicator?: boolean);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiIsbn10BarCodeType extends StiIsbn13BarCodeType {
        get componentId(): StiComponentId;
        get visibleProperties(): boolean[];
        get serviceName(): string;
        get defaultCodeValue(): string;
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number, supplementType?: StiEanSupplementType, supplementCodeValue?: string, showQuietZoneIndicator?: boolean);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiJan13BarCodeType extends StiEAN13BarCodeType {
        get componentId(): StiComponentId;
        get serviceName(): string;
        get defaultCodeValue(): string;
        get visibleProperties(): boolean[];
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number, supplementType?: StiEanSupplementType, supplementCodeValue?: string, showQuietZoneIndicator?: boolean);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiJan8BarCodeType extends StiEAN8BarCodeType {
        get componentId(): StiComponentId;
        get serviceName(): string;
        get defaultCodeValue(): string;
        get visibleProperties(): boolean[];
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number, supplementType?: StiEanSupplementType, supplementCodeValue?: string, showQuietZoneIndicator?: boolean);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    import StiMaxicodeMode = Stimulsoft.Report.BarCodes.StiMaxicodeMode;
    class StiMaxicodeBarCodeType extends StiBarCodeTypeService implements IStiJsonReportObject {
        meta(): StiMeta[];
        get componentId(): StiComponentId;
        get serviceName(): string;
        get defaultCodeValue(): string;
        get module(): number;
        set module(value: number);
        get height(): number;
        set innerHeight(value: number);
        mode: StiMaxicodeMode;
        processTilde: boolean;
        structuredAppendPosition: number;
        structuredAppendTotal: number;
        get labelFontHeight(): number;
        get visibleProperties(): boolean[];
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(mode?: StiMaxicodeMode, structuredAppendPosition?: number, structuredAppendTotal?: number, processTilde?: boolean);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiPlesseyBarCodeType extends StiBarCodeTypeService implements IStiJsonReportObject {
        meta(): StiMeta[];
        get componentId(): StiComponentId;
        get serviceName(): string;
        plesseySymbols: string;
        private plesseyTable;
        private plesseyStartCode;
        private plesseyStopCode;
        get defaultCodeValue(): string;
        private _module;
        get module(): number;
        set module(value: number);
        private _height;
        get height(): number;
        set height(value: number);
        private _checkSum1;
        get checkSum1(): StiPlesseyCheckSum;
        set checkSum1(value: StiPlesseyCheckSum);
        private _checkSum2;
        get checkSum2(): StiPlesseyCheckSum;
        set checkSum2(value: StiPlesseyCheckSum);
        get labelFontHeight(): number;
        get visibleProperties(): boolean[];
        plesseySpaceLeft: number;
        plesseySpaceRight: number;
        plesseySpaceTop: number;
        plesseySpaceBottom: number;
        plesseyLineHeightShort: number;
        plesseyLineHeightLong: number;
        plesseyTextPosition: number;
        plesseyTextHeight: number;
        plesseyMainHeight: number;
        plesseyLineHeightForCut: number;
        private codeToBar;
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number, checkSum1?: StiPlesseyCheckSum, checkSum2?: StiPlesseyCheckSum);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiMsiBarCodeType extends StiPlesseyBarCodeType {
        get componentId(): StiComponentId;
        get serviceName(): string;
        get defaultCodeValue(): string;
        get visibleProperties(): boolean[];
        private msiTable;
        private msiStartCode;
        private msiStopCode;
        protected codeToBarMsi(inputCode: string): string;
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number, checkSum1?: StiPlesseyCheckSum, checkSum2?: StiPlesseyCheckSum);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiPdf417BarCodeType extends StiBarCodeTypeService implements IStiJsonReportObject {
        meta(): StiMeta[];
        get componentId(): StiComponentId;
        get serviceName(): string;
        get defaultCodeValue(): string;
        private _module;
        get module(): number;
        set module(value: number);
        private _height;
        get height(): number;
        set height(value: number);
        encodingMode: StiPdf417EncodingMode;
        errorsCorrectionLevel: StiPdf417ErrorsCorrectionLevel;
        private _dataColumns;
        get dataColumns(): number;
        set dataColumns(value: number);
        private _dataRows;
        get dataRows(): number;
        set dataRows(value: number);
        autoDataColumns: boolean;
        autoDataRows: boolean;
        private _aspectRatio;
        get aspectRatio(): number;
        set aspectRatio(value: number);
        private _ratioY;
        get ratioY(): number;
        set ratioY(value: number);
        get labelFontHeight(): number;
        get visibleProperties(): boolean[];
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, encodingMode?: StiPdf417EncodingMode, errorsCorrectionLevel?: StiPdf417ErrorsCorrectionLevel, dataColumns?: number, dataRows?: number, autoDataColumns?: boolean, autoDataRows?: boolean, aspectRatio?: number, ratioY?: number);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiPharmacodeBarCodeType extends StiBarCodeTypeService implements IStiJsonReportObject {
        meta(): StiMeta[];
        get componentId(): StiComponentId;
        get serviceName(): string;
        pharmacodeSymbols: string;
        defaultPharmacodeModule: number;
        get defaultCodeValue(): string;
        private _module;
        get module(): number;
        set module(value: number);
        private _height;
        get height(): number;
        set height(value: number);
        get labelFontHeight(): number;
        get visibleProperties(): boolean[];
        pharmacodeSpaceLeft: number;
        pharmacodeSpaceRight: number;
        pharmacodeSpaceTop: number;
        pharmacodeSpaceBottom: number;
        pharmacodeLineHeightShort: number;
        pharmacodeLineHeightLong: number;
        pharmacodeTextPosition: number;
        pharmacodeTextHeight: number;
        pharmacodeMainHeight: number;
        pharmacodeLineHeightForCut: number;
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiPostnetBarCodeType extends StiBarCodeTypeService implements IStiJsonReportObject {
        meta(): StiMeta[];
        get componentId(): StiComponentId;
        get serviceName(): string;
        postnetSymbols: string;
        private postnetTable;
        private postnetStartCode;
        private postnetStopCode;
        get defaultCodeValue(): string;
        private _module;
        get module(): number;
        set module(value: number);
        private _space;
        get space(): number;
        set space(value: number);
        private _height;
        get height(): number;
        set height(value: number);
        get labelFontHeight(): number;
        protected preserveAspectRatio: boolean;
        get visibleProperties(): boolean[];
        postnetSpaceLeft: number;
        postnetSpaceRight: number;
        postnetSpaceTop: number;
        postnetSpaceBottom: number;
        postnetLineHeightLong: number;
        postnetLineHeightShort: number;
        postnetTextPosition: number;
        postnetTextHeight: number;
        postnetMainHeight: number;
        postnetLineHeightForCut: number;
        private codeToBar;
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number, space?: number);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StringAlignment = Stimulsoft.System.Drawing.StringAlignment;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiRoyalMail4StateBarCodeType extends StiBarCodeTypeService implements IStiJsonReportObject {
        meta(): StiMeta[];
        get componentId(): StiComponentId;
        get serviceName(): string;
        royalMail4StateSymbols: string;
        private royalMail4StateStartCode;
        private royalMail4StateStopCode;
        private royalMail4StateCodes;
        get defaultCodeValue(): string;
        private _module;
        get module(): number;
        set module(value: number);
        private _height;
        get height(): number;
        set height(value: number);
        checkSum: StiCheckSum;
        get labelFontHeight(): number;
        protected preserveAspectRatio: boolean;
        get visibleProperties(): boolean[];
        royalMail4StateSpaceLeft: number;
        royalMail4StateSpaceRight: number;
        royalMail4StateSpaceTop: number;
        royalMail4StateSpaceBottom: number;
        royalMail4StateLineHeightLong: number;
        royalMail4StateLineHeightShort: number;
        royalMail4StateTextPosition: number;
        royalMail4StateTextHeight: number;
        royalMail4StateMainHeight: number;
        royalMail4StateLineHeightForCut: number;
        get textAlignment(): StringAlignment;
        private charTo4State;
        private stateToBar;
        private makeBarsArray;
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number, checkSum?: StiCheckSum);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import Rectangle = Stimulsoft.System.Drawing.Rectangle;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    class StiSSCC18BarCodeType extends StiCode128cBarCodeType implements IStiJsonReportObject {
        meta(): StiMeta[];
        get componentId(): StiComponentId;
        get serviceName(): string;
        get defaultCodeValue(): string;
        companyPrefix: string;
        serialNumber: string;
        extensionDigit: string;
        protected textSpacing: boolean;
        get visibleProperties(): boolean[];
        getCombinedCode(): string;
        private getCheckDigit;
        private checkContens;
        draw(context: any, barCode: StiBarCode, rect: Rectangle, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import StiMeta = Stimulsoft.Base.Meta.StiMeta;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiStandard2of5BarCodeType extends StiBarCodeTypeService implements IStiJsonReportObject {
        meta(): StiMeta[];
        get componentId(): StiComponentId;
        get serviceName(): string;
        get defaultCodeValue(): string;
        private _module;
        get module(): number;
        set module(value: number);
        private _height;
        get height(): number;
        set height(value: number);
        private _ratio;
        get ratio(): number;
        set ratio(value: number);
        get labelFontHeight(): number;
        get visibleProperties(): boolean[];
        protected symTableSet: string[];
        private standard2of5SpaceLeft;
        private standard2of5SpaceRight;
        private standard2of5SpaceTop;
        private standard2of5SpaceBottom;
        private standard2of5LineHeightShort;
        private standard2of5LineHeightLong;
        private standard2of5TextHeight;
        private standard2of5MainHeight;
        private standard2of5TextPosition;
        private standard2of5LineHeightForCut;
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number, ratio?: number);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiUpcABarCodeType extends StiEAN13BarCodeType {
        get componentId(): StiComponentId;
        get serviceName(): string;
        get eanSpaceLeft(): number;
        get eanSpaceRight(): number;
        get defaultCodeValue(): string;
        get visibleProperties(): boolean[];
        showQuietZoneIndicator: boolean;
        makeUpcABars(code: string, isLast: boolean): EanBarInfo[];
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number, supplementType?: StiEanSupplementType, supplementCodeValue?: string, showQuietZoneIndicator?: boolean);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    class StiUpcEBarCodeType extends StiEAN13BarCodeType {
        get componentId(): StiComponentId;
        get serviceName(): string;
        protected symParitySet: string[];
        protected get eanSpaceLeft(): number;
        protected get eanSpaceRight(): number;
        get defaultCodeValue(): string;
        get visibleProperties(): boolean[];
        showQuietZoneIndicator: boolean;
        protected makeUpcEBars(code: string, isLast: boolean): EanBarInfo[];
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number, supplementType?: StiEanSupplementType, supplementCodeValue?: string, showQuietZoneIndicator?: boolean);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiUpcSup2BarCodeType extends StiEAN13BarCodeType {
        get componentId(): StiComponentId;
        get serviceName(): string;
        get defaultCodeValue(): string;
        get visibleProperties(): boolean[];
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number, supplementType?: StiEanSupplementType, supplementCodeValue?: string, showQuietZoneIndicator?: boolean);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    class StiUpcSup5BarCodeType extends StiEAN13BarCodeType {
        get componentId(): StiComponentId;
        get serviceName(): string;
        get defaultCodeValue(): string;
        get visibleProperties(): boolean[];
        draw(context: any, barCode: StiBarCode, rect: RectangleD, zoom: number): void;
        createNew(): StiBarCodeTypeService;
        constructor(module?: number, height?: number, supplementType?: StiEanSupplementType, supplementCodeValue?: string, showQuietZoneIndicator?: boolean);
    }
}
export namespace Stimulsoft.Report.BarCodes {
    class ArrayHelper {
        static copy(sourceArray: any[], sourceIndex: number, destinationArray: any[], destinationIndex: number, length: number): void;
    }
}
export namespace Stimulsoft.Report.BarCodes {
    class BitVector {
        private sizeInBits;
        private array;
        constructor();
        at(index: number): number;
        size(): number;
        sizeInBytes(): number;
        appendBit(bit: number): void;
        appendBits(value: number, numBits: number): void;
        appendBitVector(bits: BitVector): void;
        xor(other: BitVector): void;
        toString(): string;
        getArray(): number[];
        private appendByte;
    }
}
export namespace Stimulsoft.Report.BarCodes {
    class BlockPair {
        private dataBytes;
        private errorCorrectionBytes;
        constructor(data: ByteArray, errorCorrection: ByteArray);
        getDataBytes(): ByteArray;
        getErrorCorrectionBytes(): ByteArray;
    }
}
export namespace Stimulsoft.Report.BarCodes {
    class ByteArray {
        private static INITIAL_SIZE;
        private _bytes;
        private _size;
        constructor(size?: number, byteArray?: number[]);
        at(index: number): number;
        set(index: number, value: number): void;
        size(): number;
        isEmpty(): boolean;
        appendByte(value: number): void;
        reserve(capacity: number): void;
        set1(source: number[], offset: number, count: number): void;
    }
}
export namespace Stimulsoft.Report.BarCodes {
    class ByteMatrix {
        private _bytes;
        private _width;
        private _height;
        getValueString(): string;
        constructor(width: number, height: number);
        getHeight(): number;
        getWidth(): number;
        get(x: number, y: number): number;
        getArray(): number[][];
        set(x: number, y: number, value: number): void;
        set2(x: number, y: number, value: number): void;
        clear(value: number): void;
    }
}
export namespace Stimulsoft.Report.BarCodes {
    import Hashtable = Stimulsoft.System.Collections.Hashtable;
    class CharacterSetECI {
        private static lockNAME_TO_ECI;
        private static _name_to_eci;
        static get NAME_TO_ECI(): Hashtable;
        static set NAME_TO_ECI(value: Hashtable);
        private static Initialize;
        private _encodingName;
        private _value;
        private _codepage;
        constructor(value: number, encodingName: string, codepage: number);
        getEncodingName(): string;
        getValue(): number;
        getCodepage(): number;
        private static addCharacterSet;
        static getCharacterSetECIByName(name: string): CharacterSetECI;
        static getCharacterSetECIByCodepage(codepage: number): CharacterSetECI;
        static getEncodingByNumber(number: number, defaultEncoding: string): string;
    }
}
export namespace Stimulsoft.Report.BarCodes {
    class ErrorCorrectionLevel {
        static L: ErrorCorrectionLevel;
        static M: ErrorCorrectionLevel;
        static Q: ErrorCorrectionLevel;
        static H: ErrorCorrectionLevel;
        private _ordinal;
        private _bits;
        private _name;
        constructor(ordinal: number, bits: number, name: string);
        ordinal(): number;
        getBits(): number;
        getName(): string;
        toString(): string;
        static forBits(bits: number): ErrorCorrectionLevel;
    }
}
export namespace Stimulsoft.Report.BarCodes {
    class FormatInformation {
        private FORMAT_INFO_MASK_QR;
        private static FORMAT_INFO_DECODE_LOOKUP;
        private static BITS_SET_IN_HALF_BYTE;
        private errorCorrectionLevel;
        private dataMask;
        constructor(formatInfo: number);
        static numBitsDiffering(a: number, b: number): number;
        static decodeFormatInformation(maskedFormatInfo1: number, maskedFormatInfo2: number): FormatInformation;
        private static doDecodeFormatInformation;
        getErrorCorrectionLevel(): ErrorCorrectionLevel;
        getDataMask(): number;
        equals(o: any): boolean;
    }
}
export namespace Stimulsoft.Report.BarCodes {
    class GF256 {
        static QR_CODE_FIELD: GF256;
        static DATA_MATRIX_FIELD: GF256;
        private _expTable;
        private _logTable;
        private _zero;
        private _one;
        constructor(primitive: number);
        getZero(): GF256Poly;
        getOne(): GF256Poly;
        buildMonomial(degree: number, coefficient: number): GF256Poly;
        static addOrSubtract(a: number, b: number): number;
        exp(a: number): number;
        log(a: number): number;
        inverse(a: number): number;
        multiply(a: number, b: number): number;
    }
}
export namespace Stimulsoft.Report.BarCodes {
    class GF256Poly {
        _field: GF256;
        _coefficients: number[];
        constructor(field: GF256, coefficients: number[]);
        getCoefficients(): number[];
        getDegree(): number;
        isZero(): boolean;
        getCoefficient(degree: number): number;
        evaluateAt(a: number): number;
        addOrSubtract(other: GF256Poly): GF256Poly;
        multiply(other: GF256Poly): GF256Poly;
        multiply1(scalar: number): GF256Poly;
        multiplyByMonomial(degree: number, coefficient: number): GF256Poly;
        divide(other: GF256Poly): GF256Poly[];
    }
}
export namespace Stimulsoft.Report.BarCodes {
    class MaskUtil {
        static applyMaskPenaltyRule1(matrix: ByteMatrix): number;
        static applyMaskPenaltyRule2(matrix: ByteMatrix): number;
        static applyMaskPenaltyRule3(matrix: ByteMatrix): number;
        static applyMaskPenaltyRule4(matrix: ByteMatrix): number;
        static getDataMaskBit(maskPattern: number, x: number, y: number): boolean;
        private static ApplyMaskPenaltyRule1Internal;
    }
}
export namespace Stimulsoft.Report.BarCodes {
    class MatrixUtil {
        private static POSITION_DETECTION_PATTERN;
        private static HORIZONTAL_SEPARATION_PATTERN;
        private static VERTICAL_SEPARATION_PATTERN;
        private static POSITION_ADJUSTMENT_PATTERN;
        private static POSITION_ADJUSTMENT_PATTERN_COORDINATE_TABLE;
        private static TYPE_INFO_COORDINATES;
        private static VERSION_INFO_POLY;
        private static TYPE_INFO_POLY;
        private static TYPE_INFO_MASK_PATTERN;
        static ClearMatrix(matrix: ByteMatrix): void;
        static BuildMatrix(dataBits: BitVector, ecLevel: ErrorCorrectionLevel, version: number, maskPattern: number, matrix: ByteMatrix): void;
        static EmbedBasicPatterns(version: number, matrix: ByteMatrix): void;
        static EmbedTypeInfo(ecLevel: ErrorCorrectionLevel, maskPattern: number, matrix: ByteMatrix): void;
        static MaybeEmbedVersionInfo(version: number, matrix: ByteMatrix): void;
        static EmbedDataBits(dataBits: BitVector, maskPattern: number, matrix: ByteMatrix): void;
        static EmbedDataBits2(dataBits: BitVector, matrices: ByteMatrix[]): void;
        static FindMSBSet(value: number): number;
        static CalculateBCHCode(value: number, poly: number): number;
        static MakeTypeInfoBits(ecLevel: ErrorCorrectionLevel, maskPattern: number, bits: BitVector): void;
        static MakeVersionInfoBits(version: number, bits: BitVector): void;
        private static IsEmpty;
        private static IsValidValue;
        private static EmbedTimingPatterns;
        private static EmbedDarkDotAtLeftBottomCorner;
        private static EmbedHorizontalSeparationPattern;
        private static EmbedVerticalSeparationPattern;
        private static EmbedPositionAdjustmentPattern;
        private static EmbedPositionDetectionPattern;
        private static EmbedPositionDetectionPatternsAndSeparators;
        private static MaybeEmbedPositionAdjustmentPatterns;
    }
}
export namespace Stimulsoft.Report.BarCodes {
    class Mode {
        static TERMINATOR: Mode;
        static NUMERIC: Mode;
        static ALPHANUMERIC: Mode;
        static STRUCTURED_APPEND: Mode;
        static BYTE: Mode;
        static ECI: Mode;
        static KANJI: Mode;
        static FNC1_FIRST_POSITION: Mode;
        static FNC1_SECOND_POSITION: Mode;
        private characterCountBitsForVersions;
        private bits;
        private name;
        constructor(characterCountBitsForVersions: number[], bits: number, name: string);
        static ForBits(bits: number): Mode;
        GetCharacterCountBits(version: Version): number;
        GetBits(): number;
        GetName(): string;
        ToString(): string;
    }
}
export namespace Stimulsoft.Report.BarCodes {
    class QREncoder {
        private static ALPHANUMERIC_TABLE;
        private static defaultECIByteModeEncoding;
        private static BYTE_MODE_UTF8;
        private static QUESTION_MARK_CHAR;
        private static CalculateMaskPenalty;
        static Encode(content: string, ecLevel: ErrorCorrectionLevel, qrCode: StiQRCode, startVersion: StiQRCodeSize, processTilde: boolean, gs1?: boolean): void;
        private static GetEncodingCodepage;
        private static TryEncodeByte;
        private static GetAlphanumericCode;
        static ChooseMode1(content: string, encoding: number, gs1: boolean): Mode;
        private static ChooseMaskPattern;
        private static ChooseMaskPattern2;
        private static InitQRCode;
        private static TerminateBits;
        private static GetNumDataBytesAndNumECBytesForBlockID;
        private static InterleaveWithECBytes;
        private static GenerateECBytes;
        private static AppendModeInfo;
        private static AppendLengthInfo;
        private static AppendBytes;
        private static AppendNumericBytes;
        private static AppendAlphanumericBytes;
        private static Append8BitBytes;
        private static AppendKanjiBytes;
        private static AppendECI;
    }
}
export namespace Stimulsoft.Report.BarCodes {
    class ReedSolomonEncoder {
        private field;
        private cachedGenerators;
        constructor(field: GF256);
        private BuildGenerator;
        Encode(toEncode: number[], ecBytes: number): void;
    }
}
export namespace Stimulsoft.Report.BarCodes {
    class StiQRCode {
        static NUM_MASK_PATTERNS: number;
        private _mode;
        private _ecLevel;
        private _version;
        private _matrixWidth;
        private _maskPattern;
        private _numTotalBytes;
        private _numDataBytes;
        private _numECBytes;
        private _numRSBlocks;
        private _matrix;
        GetMode(): Mode;
        GetECLevel(): ErrorCorrectionLevel;
        GetVersion(): number;
        GetMatrixWidth(): number;
        GetMaskPattern(): number;
        GetNumTotalBytes(): number;
        GetNumDataBytes(): number;
        GetNumECBytes(): number;
        GetNumRSBlocks(): number;
        GetMatrix(): ByteMatrix;
        At(x: number, y: number): number;
        IsValid(): boolean;
        SetMode(value: Mode): void;
        SetECLevel(value: ErrorCorrectionLevel): void;
        SetVersion(value: number): void;
        SetMatrixWidth(value: number): void;
        SetMaskPattern(value: number): void;
        SetNumTotalBytes(value: number): void;
        SetNumDataBytes(value: number): void;
        SetNumECBytes(value: number): void;
        SetNumRSBlocks(value: number): void;
        SetMatrix(value: ByteMatrix): void;
        static IsValidMaskPattern(maskPattern: number): boolean;
        constructor();
    }
}
export namespace Stimulsoft.Report.BarCodes {
    class ECB {
        private _count;
        private _dataCodewords;
        constructor(count: number, dataCodewords: number);
        getCount(): number;
        getDataCodewords(): number;
    }
    class ECBlocks {
        private ecCodewordsPerBlock;
        private ecBlocks;
        constructor(ecCodewordsPerBlock: number, ecBlocks1: ECB, ecBlocks2?: ECB);
        getECCodewordsPerBlock(): number;
        getNumBlocks(): number;
        getTotalECCodewords(): number;
        getECBlocks(): ECB[];
    }
    class Version {
        private static VERSION_DECODE_INFO;
        private static BuildVersions;
        private static VERSIONS;
        private _versionNumber;
        private _alignmentPatternCenters;
        private _ecBlocks;
        private _totalCodewords;
        constructor(versionNumber: number, alignmentPatternCenters: number[], ecBlocks1: ECBlocks, ecBlocks2: ECBlocks, ecBlocks3: ECBlocks, ecBlocks4: ECBlocks);
        getVersionNumber(): number;
        getAlignmentPatternCenters(): number[];
        getTotalCodewords(): number;
        getDimensionForVersion(): number;
        getECBlocksForLevel(ecLevel: ErrorCorrectionLevel): ECBlocks;
        static getProvisionalVersionForDimension(dimension: number): Version;
        static getVersionForNumber(versionNumber: number): Version;
        static decodeVersionInformation(versionBits: number): Version;
        toString(): string;
    }
}
export namespace Stimulsoft.Report.Chart {
    enum StiColumnShape3D {
        Box = 0,
        Pyramid = 1,
        PartialPyramid = 2
    }
    enum StiPie3dLightingStyle {
        No = 0,
        Solid = 1,
        Gradient = 2
    }
    class StiTrendLinePropertyOrder {
        lineColor: number;
        lineStyle: number;
        lineWidth: number;
        showShadow: number;
    }
    class StiSeriesLabelsPropertyOrder {
        allowApplyStyle: number;
        angle: number;
        antialiasing: number;
        autoRotate: number;
        conditions: number;
        drawBorder: number;
        borderColor: number;
        brush: number;
        font: number;
        format: number;
        labelColor: number;
        legendValueType: number;
        lineColor: number;
        lineColorNegative: number;
        lineLength: number;
        markerAlignment: number;
        markerSize: number;
        markerVisible: number;
        preventIntersection: number;
        showInPercent: number;
        showNulls: number;
        showValue: number;
        showZeros: number;
        step: number;
        textAfter: number;
        textBefore: number;
        useSeriesColor: number;
        valueType: number;
        valueTypeSeparator: number;
        visible: number;
        width: number;
        wordWrap: number;
    }
    class StiSeriesPropertyOrder {
        allowSeries: number;
        allowSeriesElements: number;
        drillDownEnabled: number;
        drillDownPage: number;
        drillDownReport: number;
        hyperlinkDataColumn: number;
        tagDataColumn: number;
        toolTipDataColumn: number;
        weightDataColumn: number;
        hyperlink: number;
        tag: number;
        toolTip: number;
        weight: number;
        listOfHyperlinks: number;
        listOfTags: number;
        listOfToolTips: number;
        listOfWeights: number;
        valueValueDataColumn: number;
        valueValue: number;
        valueListOfValues: number;
        valueValueDataColumnEnd: number;
        valueValueEnd: number;
        valueListOfValuesEnd: number;
        valueValueDataColumnOpen: number;
        valueValueOpen: number;
        valueListOfValuesOpen: number;
        valueValueDataColumnClose: number;
        valueValueClose: number;
        valueListOfValuesClose: number;
        valueValueDataColumnHigh: number;
        valueValueHigh: number;
        valueListOfValuesHigh: number;
        valueValueDataColumnLow: number;
        valueValueLow: number;
        valueListOfValuesLow: number;
        argumentArgumentDataColumn: number;
        argumentArgument: number;
        argumentListOfArguments: number;
        weightWeightDataColumn: number;
        weightWeight: number;
        weightListOfWeights: number;
        appearanceAllowApplyBorderColor: number;
        appearanceAllowApplyBrush: number;
        appearanceAllowApplyBrushNegative: number;
        appearanceAllowApplyColorNegative: number;
        appearanceDiameter: number;
        appearanceBorderColor: number;
        appearanceBrush: number;
        appearanceBrushNegative: number;
        appearanceLighting: number;
        appearanceShowShadow: number;
        appearanceTopmostLine: number;
        appearanceFunnelSliceMode: number;
        dataConditions: number;
        dataFilters: number;
        dataFilterMode: number;
        dataTopN: number;
        dataFormat: number;
        dataSortBy: number;
        dataSortDirection: number;
        dataAutoSeriesKeyDataColumn: number;
        dataAutoSeriesColorDataColumn: number;
        dataAutoSeriesTitleDataColumn: number;
    }
    enum StiChartTitleDock {
        Top = 0,
        Right = 90,
        Bottom = 180,
        Left = 270
    }
    enum StiLegendDirection {
        LeftToRight = 0,
        RightToLeft = 1,
        TopToBottom = 2,
        BottomToTop = 3
    }
    enum StiDirection {
        LeftToRight = 0,
        RightToLeft = 1,
        TopToBottom = 2,
        BottomToTop = 3
    }
    enum StiLegendHorAlignment {
        LeftOutside = 0,
        Left = 1,
        Center = 2,
        Right = 3,
        RightOutside = 4
    }
    enum StiLegendVertAlignment {
        TopOutside = 0,
        Top = 1,
        Center = 2,
        Bottom = 3,
        BottomOutside = 4
    }
    enum StiMarkerAlignment {
        Left = 0,
        Center = 1,
        Right = 2
    }
    enum StiChartAreaPosition {
        ClusteredColumn = 0,
        StackedColumn = 1,
        FullStackedColumn = 2,
        Pareto = 3,
        Waterfall = 4,
        Histogram = 5,
        ClusteredBar = 10,
        StackedBar = 11,
        FullStackedBar = 12,
        Pie = 20,
        Doughnut = 21,
        Line = 30,
        SteppedLine = 31,
        StackedLine = 32,
        FullStackedLine = 33,
        Spline = 40,
        StackedSpline = 41,
        FullStackedSpline = 42,
        Area = 50,
        SteppedArea = 51,
        StackedArea = 52,
        FullStackedArea = 53,
        SplineArea = 60,
        StackedSplineArea = 61,
        FullStackedSplineArea = 62,
        Gantt = 70,
        Scatter = 80,
        Bubble = 81,
        RadarPoint = 82,
        RadarLine = 83,
        RadarArea = 84,
        Range = 90,
        SteppedRange = 91,
        RangeBar = 92,
        SplineRange = 93,
        Funnel = 100,
        Candlestick = 110,
        Stock = 120,
        BoxAndWhisker = 121,
        Treemap = 130,
        Pictorial = 131,
        PictorialStacked = 132,
        Sunburst = 140,
        Pie3d = 200,
        ClusteredColumn3d = 201,
        StackedColumn3d = 202,
        FullStackedColumn3d = 202,
        Line3d = 205
    }
    enum StiChartSeriesOrientation {
        Horizontal = 0,
        Vertical = 1
    }
    enum StiArrowStyle {
        None = 0,
        Triangle = 1,
        Lines = 2,
        Circle = 3,
        Arc = 4,
        ArcAndCircle = 5
    }
    enum StiLabelsPlacement {
        None = 0,
        OneLine = 1,
        TwoLines = 2,
        AutoRotation = 3
    }
    enum StiXAxisDock {
        Top = 0,
        Bottom = 1
    }
    enum StiYAxisDock {
        Left = 0,
        Right = 1
    }
    enum StiTitlePosition {
        Inside = 0,
        Outside = 1
    }
    enum StiSeriesLabelsPosition {
        None = 0,
        InsideEndAxis = 1,
        InsideBaseAxis = 2,
        CenterAxis = 3,
        OutsideEndAxis = 4,
        OutsideBaseAxis = 5,
        OutsideAxis = 6,
        Left = 7,
        Value = 8,
        Right = 9,
        InsideEndPie = 10,
        CenterPie = 11,
        OutsidePie = 12,
        TwoColumnsPie = 13,
        CenterFunnel = 14,
        OutsideRightFunnel = 15,
        OutsideLeftFunnel = 16,
        CenterTreemap = 17,
        CenterPie3d = 18,
        CenterPictorialStacked = 19,
        OutsideRightPictorialStacked = 20,
        OutsideLeftPictorialStacked = 21
    }
    enum StiSeriesLabelsType {
        Axis = 1,
        Pie = 2,
        Doughnut = 4,
        Radar = 8,
        Funnel = 10,
        Treemap = 12,
        Pie3d = 13,
        PictorialStacked = 14,
        All = 15
    }
    enum StiSeriesLabelsValueType {
        Value = 0,
        SeriesTitle = 1,
        Argument = 2,
        Tag = 3,
        Weight = 4,
        ValueArgument = 5,
        ArgumentValue = 6,
        SeriesTitleValue = 7,
        SeriesTitleArgument = 8
    }
    enum StiMarkerType {
        Rectangle = 0,
        Triangle = 1,
        Circle = 2,
        HalfCircle = 3,
        Star5 = 4,
        Star6 = 5,
        Star7 = 6,
        Star8 = 7,
        Hexagon = 8
    }
    enum StiSeriesSortType {
        Value = 0,
        Argument = 1,
        None = 2
    }
    enum StiSeriesSortDirection {
        Ascending = 0,
        Descending = 1
    }
    enum StiSeriesXAxis {
        BottomXAxis = 0,
        TopXAxis = 1
    }
    enum StiSeriesYAxis {
        LeftYAxis = 0,
        RightYAxis = 1
    }
    enum StiShowSeriesLabels {
        None = 0,
        FromChart = 1,
        FromSeries = 2
    }
    enum StiShowYAxis {
        Left = 0,
        Center = 1,
        Both = 2
    }
    enum StiShowXAxis {
        Bottom = 0,
        Center = 1,
        Both = 2
    }
    enum StiRadarStyle {
        Polygon = 0,
        Circle = 1
    }
    enum StiTimeDateStep {
        None = 0,
        Second = 1,
        Minute = 2,
        Hour = 3,
        Day = 4,
        Month = 5,
        Year = 6
    }
    enum StiTopNMode {
        None = 0,
        Top = 1,
        Bottom = 2
    }
    enum StiChartStyleId {
        StiStyle01 = 0,
        StiStyle02 = 1,
        StiStyle03 = 2,
        StiStyle04 = 3,
        StiStyle05 = 4,
        StiStyle06 = 5,
        StiStyle07 = 6,
        StiStyle08 = 7,
        StiStyle09 = 8,
        StiStyle10 = 9,
        StiStyle11 = 10,
        StiStyle12 = 11,
        StiStyle13 = 12,
        StiStyle14 = 13,
        StiStyle15 = 14,
        StiStyle16 = 15,
        StiStyle17 = 16,
        StiStyle18 = 17,
        StiStyle19 = 18,
        StiStyle20 = 19,
        StiStyle21 = 20,
        StiStyle22 = 21,
        StiStyle23 = 22,
        StiStyle24 = 23,
        StiStyle25 = 24,
        StiStyle26 = 25,
        StiStyle27 = 26,
        StiStyle28 = 27,
        StiStyle29 = 28,
        StiStyle30 = 29,
        StiStyle31 = 30,
        StiStyle32 = 31,
        StiStyle33 = 32,
        StiStyle34 = 33,
        StiStyle35 = 34
    }
    enum StiStrips_StiOrientation {
        Horizontal = 0,
        Vertical = 1,
        HorizontalRight = 2
    }
    enum StiConstantLines_StiOrientation {
        Horizontal = 0,
        Vertical = 1,
        HorizontalRight = 2
    }
    enum StiConstantLines_StiTextPosition {
        LeftTop = 0,
        LeftBottom = 1,
        CenterTop = 2,
        CenterBottom = 3,
        RightTop = 4,
        RightBottom = 5
    }
    enum StiTrendLine_StiTextPosition {
        LeftTop = 0,
        LeftBottom = 1,
        RightTop = 2,
        RightBottom = 3
    }
    enum StiExtendedStyleBool {
        FromStyle = 0,
        True = 1,
        False = 2
    }
    enum StiChartConditionalField {
        Value = 0,
        Argument = 1,
        Series = 2
    }
    enum StiShowEmptyCellsAs {
        Gap = 0,
        ConnectPointsWithLine = 1
    }
    enum StiChartEditorType {
        Simple = 0,
        Advanced = 1
    }
    enum StiSeriesAnimationType {
        None = 0,
        Column = 1,
        Line = 2,
        Bar = 3,
        Range = 4
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiRectangle3D: System.Interface<IStiRectangle3D>;
    interface IStiRectangle3D {
        x: number;
        y: number;
        z: number;
        length: number;
        height: number;
        width: number;
    }
}
export namespace Stimulsoft.Report.Chart {
    import PointF = Stimulsoft.System.Drawing.Point;
    let IStiRender3D: System.Interface<IStiRender3D>;
    interface IStiRender3D {
        width: number;
        height: number;
        halfWidth: number;
        halfHeight: number;
        globalRotationX: number;
        globalRotationY: number;
        globalScale: number;
        contextScale: number;
        contextTranslate: PointF;
    }
}
export namespace Stimulsoft.Report.Chart {
    class StiChartAssembly {
        static get isAssemblyLoaded(): boolean;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiApplyStyle: System.Interface<IStiApplyStyle>;
    interface IStiApplyStyle {
        applyStyle(style: IStiChartStyle): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    import Color = Stimulsoft.System.Drawing.Color;
    let IStiApplyStyleSeries: System.Interface<IStiApplyStyleSeries>;
    interface IStiApplyStyleSeries {
        applyStyle(style: IStiChartStyle, color: Color): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiContext = Stimulsoft.Base.Context.StiContext;
    let IStiCellGeom: System.Interface<IStiCellGeom>;
    interface IStiCellGeom {
        drawGeom(context: StiContext): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiContext = Stimulsoft.Base.Context.StiContext;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    let IStiChartCoreXF: System.Interface<IStiChartCoreXF>;
    interface IStiChartCoreXF extends IStiApplyStyle {
        applyStyle(style: IStiChartStyle): any;
        render(context: StiContext, rect: RectangleD, useMargins: boolean): IStiCellGeom;
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiText = Stimulsoft.Report.Components.StiText;
    let IStiChartInfo: System.Interface<IStiChartInfo>;
    interface IStiChartInfo {
        interactiveComps: StiText[];
        storedForProcessAtEndChart: IStiChart;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiSeriesElement: System.Interface<IStiSeriesElement>;
    interface IStiSeriesElement {
        elementIndex: string;
    }
}
export namespace Stimulsoft.Report.Chart {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiPage = Stimulsoft.Report.Components.StiPage;
    let IStiSeriesInteraction: System.Interface<IStiSeriesInteraction>;
    interface IStiSeriesInteraction extends ICloneable, IStiJsonReportObject {
        drillDownEnabled: boolean;
        allowSeries: boolean;
        allowSeriesElements: boolean;
        loadFromXml(xmlNode: XmlNode): any;
        drillDownPageGuid: string;
        drillDownPage: StiPage;
    }
}
export namespace Stimulsoft.Report.Chart {
    let ISti3dOptions: System.Interface<ISti3dOptions>;
    interface ISti3dOptions {
        opacity: number;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiPie3dOptions: System.Interface<IStiPie3dOptions>;
    interface IStiPie3dOptions extends ISti3dOptions {
        lighting: StiPie3dLightingStyle;
        height: number;
        distance: number;
    }
}
export namespace Stimulsoft.Report.Chart {
    import IAsIs = Stimulsoft.System.IAsIs;
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    import Color = Stimulsoft.System.Drawing.Color;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    let IStiArea: System.Interface<IStiArea>;
    interface IStiArea extends ICloneable, IStiJsonReportObject, IAsIs {
        core: IStiAreaCoreXF;
        chart: IStiChart;
        allowApplyStyle: boolean;
        colorEach: boolean;
        showShadow: boolean;
        borderColor: Color;
        borderThickness: number;
        brush: StiBrush;
        isDefaultSeriesTypeFullStackedColumnSeries: boolean;
        isDefaultSeriesTypeFullStackedBarSeries: boolean;
        getDefaultSeriesType(): Stimulsoft.System.Type;
        getSeriesTypes(): Stimulsoft.System.Type[];
        getDefaultSeriesLabelsType(): Stimulsoft.System.Type;
        getSeriesLabelsTypes(): Stimulsoft.System.Type[];
    }
}
export namespace Stimulsoft.Report.Chart {
    import IAsIs = Stimulsoft.System.IAsIs;
    import StiContext = Stimulsoft.Base.Context.StiContext;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    let IStiAreaCoreXF: System.Interface<IStiAreaCoreXF>;
    interface IStiAreaCoreXF extends IStiApplyStyle, IAsIs {
        isAcceptableSeries(seriesType: Stimulsoft.System.Type): boolean;
        isAcceptableSeriesLabels(seriesLabelsType: Stimulsoft.System.Type): boolean;
        render(context: StiContext, rect: RectangleD): IStiCellGeom;
        checkInLabelsTypes(typeForCheck: Stimulsoft.System.Type): boolean;
        seriesOrientation: StiChartSeriesOrientation;
        getSeries(): IStiSeries[];
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiAxisArea: System.Interface<IStiAxisArea>;
    interface IStiAxisArea extends IStiArea {
        axisCore: IStiAxisAreaCoreXF;
        interlacingHor: IStiInterlacingHor;
        interlacingVert: IStiInterlacingVert;
        gridLinesHor: IStiGridLinesHor;
        gridLinesHorRight: IStiGridLinesHor;
        gridLinesVert: IStiGridLinesVert;
        yAxis: IStiYAxis;
        yRightAxis: IStiYAxis;
        xAxis: IStiXAxis;
        xTopAxis: IStiXAxis;
        reverseHor: boolean;
        reverseVert: boolean;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiAxisAreaCoreXF: System.Interface<IStiAxisAreaCoreXF>;
    interface IStiAxisAreaCoreXF extends IStiAreaCoreXF {
        switchOff(): any;
        getDividerX(): number;
        getDividerTopX(): number;
        getDividerY(): number;
        getDividerRightY(): number;
        valuesCount: number;
        scrollRangeX: number;
        scrollRangeY: number;
        scrollDpiX: number;
        scrollDpiY: number;
        getArgumentLabel(line: IStiStripLineXF, series: IStiSeries): string;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiRoundValuesArea: System.Interface<IStiRoundValuesArea>;
    interface IStiRoundValuesArea {
        roundValues: boolean;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiBoxAndWhiskerArea: System.Interface<IStiBoxAndWhiskerArea>;
    interface IStiBoxAndWhiskerArea extends IStiAxisArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiBubbleArea: System.Interface<IStiBubbleArea>;
    interface IStiBubbleArea extends IStiScatterArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiCandlestickArea: System.Interface<IStiCandlestickArea>;
    interface IStiCandlestickArea extends IStiClusteredColumnArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiClusteredBarArea: System.Interface<IStiClusteredBarArea>;
    interface IStiClusteredBarArea extends IStiClusteredColumnArea, IStiRoundValuesArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiAreaArea: System.Interface<IStiAreaArea>;
    interface IStiAreaArea extends IStiClusteredColumnArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiClusteredColumnArea: System.Interface<IStiClusteredColumnArea>;
    interface IStiClusteredColumnArea extends IStiAxisArea, IStiRoundValuesArea {
        sideBySide: boolean;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiLineArea: System.Interface<IStiLineArea>;
    interface IStiLineArea extends IStiClusteredColumnArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiParetoArea: System.Interface<IStiParetoArea>;
    interface IStiParetoArea extends IStiClusteredColumnArea, IStiRoundValuesArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiSplineArea: System.Interface<IStiSplineArea>;
    interface IStiSplineArea extends IStiClusteredColumnArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiSplineAreaArea: System.Interface<IStiSplineAreaArea>;
    interface IStiSplineAreaArea extends IStiClusteredColumnArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiSteppedAreaArea: System.Interface<IStiSteppedAreaArea>;
    interface IStiSteppedAreaArea extends IStiClusteredColumnArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiSteppedLineArea: System.Interface<IStiSteppedLineArea>;
    interface IStiSteppedLineArea extends IStiClusteredColumnArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiWaterfallArea: System.Interface<IStiWaterfallArea>;
    interface IStiWaterfallArea extends IStiAxisArea, IStiRoundValuesArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiDoughnutArea: System.Interface<IStiDoughnutArea>;
    interface IStiDoughnutArea extends IStiPieArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiFullStackedBarArea: System.Interface<IStiFullStackedBarArea>;
    interface IStiFullStackedBarArea extends IStiStackedBarArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiFullStackedAreaArea: System.Interface<IStiFullStackedAreaArea>;
    interface IStiFullStackedAreaArea extends IStiFullStackedColumnArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiFullStackedColumnArea: System.Interface<IStiFullStackedColumnArea>;
    interface IStiFullStackedColumnArea extends IStiStackedColumnArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiFullStackedLineArea: System.Interface<IStiFullStackedLineArea>;
    interface IStiFullStackedLineArea extends IStiFullStackedColumnArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiFullStackedSplineArea: System.Interface<IStiFullStackedSplineArea>;
    interface IStiFullStackedSplineArea extends IStiFullStackedColumnArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiFullStackedSplineAreaArea: System.Interface<IStiFullStackedSplineAreaArea>;
    interface IStiFullStackedSplineAreaArea extends IStiFullStackedColumnArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiFunnelArea: System.Interface<IStiFunnelArea>;
    interface IStiFunnelArea extends IStiArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiGanttArea: System.Interface<IStiGanttArea>;
    interface IStiGanttArea extends IStiClusteredBarArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiPictorialArea: System.Interface<IStiPictorialArea>;
    interface IStiPictorialArea extends IStiArea, IStiRoundValuesArea {
        actual: boolean;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiPieArea: System.Interface<IStiPieArea>;
    interface IStiPieArea extends IStiArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiRadarArea: System.Interface<IStiRadarArea>;
    interface IStiRadarArea extends IStiArea {
        radarStyle: StiRadarStyle;
        xAxis: IStiXRadarAxis;
        yAxis: IStiYRadarAxis;
        interlacingHor: IStiInterlacingHor;
        interlacingVert: IStiInterlacingVert;
        gridLinesHor: IStiRadarGridLinesHor;
        gridLinesVert: IStiRadarGridLinesVert;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiRadarAreaArea: System.Interface<IStiRadarAreaArea>;
    interface IStiRadarAreaArea extends IStiRadarArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiRadarLineArea: System.Interface<IStiRadarLineArea>;
    interface IStiRadarLineArea extends IStiRadarArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiRadarPointArea: System.Interface<IStiRadarPointArea>;
    interface IStiRadarPointArea extends IStiRadarArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiRangeArea: System.Interface<IStiRangeArea>;
    interface IStiRangeArea extends IStiClusteredColumnArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiRangeBarArea: System.Interface<IStiRangeBarArea>;
    interface IStiRangeBarArea extends IStiClusteredColumnArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiSplineRangeArea: System.Interface<IStiSplineRangeArea>;
    interface IStiSplineRangeArea extends IStiClusteredColumnArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiSteppedRangeArea: System.Interface<IStiSteppedRangeArea>;
    interface IStiSteppedRangeArea extends IStiClusteredColumnArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiScatterArea: System.Interface<IStiScatterArea>;
    interface IStiScatterArea extends IStiClusteredColumnArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiStackedBarArea: System.Interface<IStiStackedBarArea>;
    interface IStiStackedBarArea extends IStiClusteredBarArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiRibbonArea: System.Interface<IStiRibbonArea>;
    interface IStiRibbonArea extends IStiAxisArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiStackedAreaArea: System.Interface<IStiStackedAreaArea>;
    interface IStiStackedAreaArea extends IStiStackedColumnArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiStackedColumnArea: System.Interface<IStiStackedColumnArea>;
    interface IStiStackedColumnArea extends IStiAxisArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiStackedLineArea: System.Interface<IStiStackedLineArea>;
    interface IStiStackedLineArea extends IStiStackedColumnArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiStackedSplineArea: System.Interface<IStiStackedSplineArea>;
    interface IStiStackedSplineArea extends IStiStackedColumnArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiStackedSplineAreaArea: System.Interface<IStiStackedSplineAreaArea>;
    interface IStiStackedSplineAreaArea extends IStiStackedColumnArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiStockArea: System.Interface<IStiStockArea>;
    interface IStiStockArea extends IStiClusteredColumnArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiSunburstArea: System.Interface<IStiSunburstArea>;
    interface IStiSunburstArea extends IStiArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiTreemapArea: System.Interface<IStiTreemapArea>;
    interface IStiTreemapArea extends IStiArea {
    }
}
export namespace Stimulsoft.Report.Chart {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiPenStyle = Stimulsoft.Base.Drawing.StiPenStyle;
    import Color = Stimulsoft.System.Drawing.Color;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import IAsIs = Stimulsoft.System.IAsIs;
    let IStiAxis: System.Interface<IStiAxis>;
    interface IStiAxis extends ICloneable, IStiJsonReportObject, IAsIs {
        logarithmicScale: boolean;
        core: IStiAxisCoreXF;
        allowApplyStyle: boolean;
        startFromZero: boolean;
        step: number;
        interaction: IStiAxisInteraction;
        labels: IStiAxisLabels;
        range: IStiAxisRange;
        title: IStiAxisTitle;
        ticks: IStiAxisTicks;
        arrowStyle: StiArrowStyle;
        lineStyle: StiPenStyle;
        lineColor: Color;
        lineWidth: number;
        visible: boolean;
        area: IStiAxisArea;
        info: IStiAxisInfoXF;
        loadFromXml(xmlNode: XmlNode): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiContext = Stimulsoft.Base.Context.StiContext;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    import StiFontGeom = Stimulsoft.Base.Context.StiFontGeom;
    import StiStringFormatGeom = Stimulsoft.Base.Context.StiStringFormatGeom;
    let IStiAxisCoreXF: System.Interface<IStiAxisCoreXF>;
    interface IStiAxisCoreXF extends IStiApplyStyle {
        arrowHeight: number;
        arrowWidth: number;
        ticksMaxLength: number;
        renderView(context: StiContext, rect: RectangleD): IStiCellGeom;
        render(context: StiContext, rect: RectangleD): IStiCellGeom;
        applyStyle(style: IStiChartStyle): any;
        getStartFromZero(): boolean;
        calculateStripPositions(topPosition: number, bottomPosition: number): any;
        getFontGeom(context: StiContext): StiFontGeom;
        getStringFormatGeom(context: StiContext, wordWrap: boolean): StiStringFormatGeom;
    }
}
export namespace Stimulsoft.Report.Chart {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    let IStiAxisDateTimeStep: System.Interface<IStiAxisDateTimeStep>;
    interface IStiAxisDateTimeStep extends ICloneable, IStiJsonReportObject {
        step: StiTimeDateStep;
        numberOfValues: number;
        interpolation: boolean;
        loadFromXml(xmlNode: XmlNode): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    import ICloneable = Stimulsoft.System.ICloneable;
    let IStiAxisInfoXF: System.Interface<IStiAxisInfoXF>;
    interface IStiAxisInfoXF extends ICloneable {
        minimum: number;
        maximum: number;
        stripLines: IStiStripLinesXF;
        stripPositions: number[];
        dpi: number;
        ticksCollection: IStiStripPositionXF[];
        labelsCollection: IStiStripPositionXF[];
        step: number;
        range: number;
        clone(): IStiAxisInfoXF;
    }
}
export namespace Stimulsoft.Report.Chart {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    let IStiAxisInteraction: System.Interface<IStiAxisInteraction>;
    interface IStiAxisInteraction extends ICloneable, IStiJsonReportObject {
        showScrollBar: boolean;
        rangeScrollEnabled: boolean;
        loadFromXml(xmlNode: XmlNode): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiFormatService = Stimulsoft.Report.Components.TextFormats.StiFormatService;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiHorAlignment = Stimulsoft.Base.Drawing.StiHorAlignment;
    import Font = Stimulsoft.System.Drawing.Font;
    import Color = Stimulsoft.System.Drawing.Color;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    let IStiAxisLabels: System.Interface<IStiAxisLabels>;
    interface IStiAxisLabels extends ICloneable, IStiJsonReportObject {
        core: IStiAxisLabelsCoreXF;
        allowApplyStyle: boolean;
        format: string;
        angle: number;
        width: number;
        textBefore: string;
        textAfter: string;
        font: Font;
        antialiasing: boolean;
        placement: StiLabelsPlacement;
        color: Color;
        textAlignment: StiHorAlignment;
        step: number;
        calculatedStep: number;
        wordWrap: boolean;
        formatService: StiFormatService;
        loadFromXml(xmlNode: XmlNode): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiAxisLabelsCoreXF: System.Interface<IStiAxisLabelsCoreXF>;
    interface IStiAxisLabelsCoreXF extends IStiApplyStyle {
        applyStyle(style: IStiChartStyle): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    let IStiAxisRange: System.Interface<IStiAxisRange>;
    interface IStiAxisRange extends ICloneable, IStiJsonReportObject {
        minimum: number;
        maximum: number;
        auto: boolean;
        loadFromXml(xmlNode: XmlNode): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    let IStiAxisTicks: System.Interface<IStiAxisTicks>;
    interface IStiAxisTicks extends ICloneable, IStiJsonReportObject {
        lengthUnderLabels: number;
        length: number;
        minorLength: number;
        minorCount: number;
        step: number;
        minorVisible: boolean;
        visible: boolean;
        loadFromXml(xmlNode: XmlNode): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StringAlignment = Stimulsoft.System.Drawing.StringAlignment;
    import Font = Stimulsoft.System.Drawing.Font;
    import Color = Stimulsoft.System.Drawing.Color;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    let IStiAxisTitle: System.Interface<IStiAxisTitle>;
    interface IStiAxisTitle extends ICloneable, IStiJsonReportObject {
        core: IStiAxisTitleCoreXF;
        allowApplyStyle: boolean;
        font: Font;
        text: string;
        color: Color;
        antialiasing: boolean;
        alignment: StringAlignment;
        direction: StiDirection;
        position: StiTitlePosition;
        loadFromXml(xmlNode: XmlNode): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiAxisTitleCoreXF: System.Interface<IStiAxisTitleCoreXF>;
    interface IStiAxisTitleCoreXF extends IStiApplyStyle {
        applyStyle(style: IStiChartStyle): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    let IStiXAxis: System.Interface<IStiXAxis>;
    interface IStiXAxis extends IStiAxis {
        showEdgeValues: boolean;
        showXAxis: StiShowXAxis;
        dateTimeStep: IStiAxisDateTimeStep;
        loadFromXml(xmlNode: XmlNode): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiXBottomAxis: System.Interface<IStiXBottomAxis>;
    interface IStiXBottomAxis extends IStiXAxis {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiXTopAxis: System.Interface<IStiXTopAxis>;
    interface IStiXTopAxis extends IStiXAxis {
    }
}
export namespace Stimulsoft.Report.Chart {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    let IStiYAxis: System.Interface<IStiYAxis>;
    interface IStiYAxis extends IStiAxis {
        showYAxis: StiShowYAxis;
        loadFromXml(xmlNode: XmlNode): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiYLeftAxis: System.Interface<IStiYLeftAxis>;
    interface IStiYLeftAxis extends IStiYAxis {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiYRightAxis: System.Interface<IStiYRightAxis>;
    interface IStiYRightAxis extends IStiYAxis {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiStripLineXF: System.Interface<IStiStripLineXF>;
    interface IStiStripLineXF {
        valueObject: any;
        value: number;
    }
}
export namespace Stimulsoft.Report.Chart {
    import ICollection = Stimulsoft.System.Collections.ICollection;
    let IStiStripLinesXF: System.Interface<IStiStripLinesXF>;
    interface IStiStripLinesXF extends ICollection<IStiStripLineXF> {
        add2(valueObject: any, value: number): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiStripPositionXF: System.Interface<IStiStripPositionXF>;
    interface IStiStripPositionXF {
        stripLine: IStiStripLineXF;
        position: number;
    }
}
export namespace Stimulsoft.Report.Chart {
    import StringAlignment = Stimulsoft.System.Drawing.StringAlignment;
    import Font = Stimulsoft.System.Drawing.Font;
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    let IStiChartTitle: System.Interface<IStiChartTitle>;
    interface IStiChartTitle extends ICloneable, IStiJsonReportObject {
        core: IStiChartTitleCoreXF;
        allowApplyStyle: boolean;
        font: Font;
        text: string;
        brush: StiBrush;
        antialiasing: boolean;
        alignment: StringAlignment;
        dock: StiChartTitleDock;
        spacing: number;
        visible: boolean;
        chart: IStiChart;
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiContext = Stimulsoft.Base.Context.StiContext;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    let IStiChartTitleCoreXF: System.Interface<IStiChartTitleCoreXF>;
    interface IStiChartTitleCoreXF extends IStiApplyStyle {
        render(context: StiContext, chartTitle: IStiChartTitle, rect: RectangleD): IStiCellGeom;
    }
}
export namespace Stimulsoft.Report.Chart {
    import Color = Stimulsoft.System.Drawing.Color;
    let IStiChartCondition: System.Interface<IStiChartCondition>;
    interface IStiChartCondition extends IStiChartFilter {
        color: Color;
    }
}
export namespace Stimulsoft.Report.Chart {
    import ICollection = Stimulsoft.System.Collections.ICollection;
    let IStiChartConditionsCollection: System.Interface<IStiChartConditionsCollection>;
    interface IStiChartConditionsCollection extends ICollection<IStiChartCondition> {
        add(condition: IStiChartCondition): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiPenStyle = Stimulsoft.Base.Drawing.StiPenStyle;
    import Font = Stimulsoft.System.Drawing.Font;
    import Color = Stimulsoft.System.Drawing.Color;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    let IStiConstantLines: System.Interface<IStiConstantLines>;
    interface IStiConstantLines extends ICloneable, IStiJsonReportObject {
        core: IStiConstantLinesCoreXF;
        allowApplyStyle: boolean;
        antialiasing: boolean;
        position: StiConstantLines_StiTextPosition;
        font: Font;
        text: string;
        titleVisible: boolean;
        orientation: StiConstantLines_StiOrientation;
        lineWidth: number;
        lineStyle: StiPenStyle;
        lineColor: Color;
        showInLegend: boolean;
        showBehind: boolean;
        axisValue: string;
        visible: boolean;
        chart: IStiChart;
    }
}
export namespace Stimulsoft.Report.Chart {
    import ICollection = Stimulsoft.System.Collections.ICollection;
    let IStiConstantLinesCollection: System.Interface<IStiConstantLinesCollection>;
    interface IStiConstantLinesCollection extends ICollection<IStiConstantLines>, IStiApplyStyle {
        add(value: IStiConstantLines): any;
        insert(index: number, value: IStiConstantLines): any;
        getByIndex(index: number): IStiConstantLines;
        applyStyle(style: IStiChartStyle): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiContext = Stimulsoft.Base.Context.StiContext;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    let IStiConstantLinesCoreXF: System.Interface<IStiConstantLinesCoreXF>;
    interface IStiConstantLinesCoreXF extends IStiApplyStyle {
        render(context: StiContext, geom: IStiCellGeom, rect: RectangleD): any;
        applyStyle(style: IStiChartStyle): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiJsonSaveMode = Stimulsoft.Base.StiJsonSaveMode;
    import StiJson = Stimulsoft.Base.StiJson;
    import StiFilterCondition = Stimulsoft.Report.Components.StiFilterCondition;
    import StiFilterDataType = Stimulsoft.Report.Components.StiFilterDataType;
    import StiFilterItem = Stimulsoft.Report.Components.StiFilterItem;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import ICloneable = Stimulsoft.System.ICloneable;
    let IStiChartFilter: System.Interface<IStiChartFilter>;
    interface IStiChartFilter extends IStiJsonReportObject, ICloneable {
        clone(): any;
        condition: StiFilterCondition;
        dataType: StiFilterDataType;
        item: StiFilterItem;
        value: string;
        saveToJsonObject(mode: StiJsonSaveMode): StiJson;
        loadFromJsonObject(jObject: StiJson): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    import ICollection = Stimulsoft.System.Collections.ICollection;
    let IStiChartFiltersCollection: System.Interface<IStiChartFiltersCollection>;
    interface IStiChartFiltersCollection extends ICollection<IStiChartFilter> {
        add(value: IStiChartFilter): any;
        getByIndex(index: number): IStiChartFilter;
        insert(index: number, value: IStiChartFilter): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiPenStyle = Stimulsoft.Base.Drawing.StiPenStyle;
    import Color = Stimulsoft.System.Drawing.Color;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    let IStiGridLines: System.Interface<IStiGridLines>;
    interface IStiGridLines extends ICloneable, IStiJsonReportObject {
        core: IStiGridLinesCoreXF;
        allowApplyStyle: boolean;
        color: Color;
        minorColor: Color;
        style: StiPenStyle;
        minorStyle: StiPenStyle;
        visible: boolean;
        minorVisible: boolean;
        minorCount: number;
        area: IStiArea;
        loadFromXml(xmlNode: XmlNode): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiGridLinesCoreXF: System.Interface<IStiGridLinesCoreXF>;
    interface IStiGridLinesCoreXF extends IStiApplyStyle {
        applyStyle(style: IStiChartStyle): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiGridLinesHor: System.Interface<IStiGridLinesHor>;
    interface IStiGridLinesHor extends IStiGridLines {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiGridLinesVert: System.Interface<IStiGridLinesVert>;
    interface IStiGridLinesVert extends IStiGridLines {
    }
}
export namespace Stimulsoft.Report.Chart {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiPenStyle = Stimulsoft.Base.Drawing.StiPenStyle;
    import Color = Stimulsoft.System.Drawing.Color;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    let IStiRadarGridLines: System.Interface<IStiRadarGridLines>;
    interface IStiRadarGridLines extends ICloneable, IStiJsonReportObject {
        core: IStiRadarGridLinesCoreXF;
        allowApplyStyle: boolean;
        color: Color;
        style: StiPenStyle;
        visible: boolean;
        area: IStiArea;
        loadFromXml(xmlNode: XmlNode): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiRadarGridLinesCoreXF: System.Interface<IStiRadarGridLinesCoreXF>;
    interface IStiRadarGridLinesCoreXF extends IStiApplyStyle {
        applyStyle(style: IStiChartStyle): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiRadarGridLinesHor: System.Interface<IStiRadarGridLinesHor>;
    interface IStiRadarGridLinesHor extends IStiRadarGridLines {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiRadarGridLinesVert: System.Interface<IStiRadarGridLinesVert>;
    interface IStiRadarGridLinesVert extends IStiRadarGridLines {
    }
}
export namespace Stimulsoft.Report.Chart {
    import IAsIs = Stimulsoft.System.IAsIs;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    let IStiInterlacing: System.Interface<IStiInterlacing>;
    interface IStiInterlacing extends ICloneable, IStiJsonReportObject, IAsIs {
        core: IStiInterlacingCoreXF;
        allowApplyStyle: boolean;
        interlacedBrush: StiBrush;
        visible: boolean;
        area: IStiArea;
        loadFromXml(xmlNode: XmlNode): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiInterlacingCoreXF: System.Interface<IStiInterlacingCoreXF>;
    interface IStiInterlacingCoreXF extends IStiApplyStyle {
        applyStyle(style: IStiChartStyle): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiInterlacingHor: System.Interface<IStiInterlacingHor>;
    interface IStiInterlacingHor extends IStiInterlacing {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiInterlacingVert: System.Interface<IStiInterlacingVert>;
    interface IStiInterlacingVert extends IStiInterlacing {
    }
}
export namespace Stimulsoft.Report.Chart {
    import SizeD = Stimulsoft.System.Drawing.Size;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import ICloneable = Stimulsoft.System.ICloneable;
    import Font = Stimulsoft.System.Drawing.Font;
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    import Color = Stimulsoft.System.Drawing.Color;
    let IStiLegend: System.Interface<IStiLegend>;
    interface IStiLegend extends ICloneable, IStiJsonReportObject {
        core: IStiLegendCoreXF;
        allowApplyStyle: boolean;
        chart: IStiChart;
        hideSeriesWithEmptyTitle: boolean;
        showShadow: boolean;
        borderColor: Color;
        brush: StiBrush;
        titleColor: Color;
        labelsColor: Color;
        direction: StiLegendDirection;
        horAlignment: StiLegendHorAlignment;
        vertAlignment: StiLegendVertAlignment;
        titleFont: Font;
        font: Font;
        visible: boolean;
        markerVisible: boolean;
        markerBorder: boolean;
        markerSize: SizeD;
        markerAlignment: StiMarkerAlignment;
        columns: number;
        horSpacing: number;
        vertSpacing: number;
        size: SizeD;
        title: string;
        columnWidth: number;
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiContext = Stimulsoft.Base.Context.StiContext;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    let IStiLegendCoreXF: System.Interface<IStiLegendCoreXF>;
    interface IStiLegendCoreXF extends IStiApplyStyle {
        render(context: StiContext, rect: RectangleD): IStiCellGeom;
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiContext = Stimulsoft.Base.Context.StiContext;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    let IStiLegendMarker: System.Interface<IStiLegendMarker>;
    interface IStiLegendMarker {
        draw(context: StiContext, series: IStiSeries, rect: RectangleD, colorIndex: number, colorCount: number, index: number): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiLineMarker: System.Interface<IStiLineMarker>;
    interface IStiLineMarker extends IStiMarker {
        step: number;
    }
}
export namespace Stimulsoft.Report.Chart {
    import IAsIs = Stimulsoft.System.IAsIs;
    import StiFontIcons = Stimulsoft.Report.Helpers.StiFontIcons;
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    import Color = Stimulsoft.System.Drawing.Color;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    let IStiMarker: System.Interface<IStiMarker>;
    interface IStiMarker extends IStiFontIconsSeries, ICloneable, IStiJsonReportObject, IAsIs {
        core: IStiMarkerCoreXF;
        showInLegend: boolean;
        visible: boolean;
        brush: StiBrush;
        borderColor: Color;
        size: number;
        angle: number;
        type: StiMarkerType;
        icon: StiFontIcons;
        loadFromXml(xmlNode: XmlNode): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiContext = Stimulsoft.Base.Context.StiContext;
    import PointD = Stimulsoft.System.Drawing.Point;
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    import StiPenGeom = Stimulsoft.Base.Context.StiPenGeom;
    import StiInteractionDataGeom = Stimulsoft.Base.Context.StiInteractionDataGeom;
    let IStiMarkerCoreXF: System.Interface<IStiMarkerCoreXF>;
    interface IStiMarkerCoreXF {
        draw(context: StiContext, marker: IStiMarker, position: PointD, zoom: number, showShadow: boolean, isMouseOver: boolean, isTooltipMode: boolean, isAnimation: boolean, toolTip: string, tag: any, interaction: StiInteractionDataGeom): any;
        drawLine(context: StiContext, x1: number, y1: number, x2: number, y2: number, scale: number, brushMarker: StiBrush, penMarker: StiPenGeom, markerType: StiMarkerType, markerStep: number, markerSize: number, angle: number): any;
        drawLines(context: StiContext, points: PointD[], scale: number, brushMarker: any, penMarker: StiPenGeom, markerType: StiMarkerType, markerStep: number, markerSize: number, angle: number): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    let IStiRadarAxis: System.Interface<IStiRadarAxis>;
    interface IStiRadarAxis extends ICloneable, IStiJsonReportObject {
        core: IStiRadarAxisCoreXF;
        allowApplyStyle: boolean;
        area: IStiRadarArea;
        visible: boolean;
        range: IStiAxisRange;
        loadFromXml(xmlNode: XmlNode): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiRadarAxisCoreXF: System.Interface<IStiRadarAxisCoreXF>;
    interface IStiRadarAxisCoreXF extends IStiApplyStyle {
        applyStyle(style: IStiChartStyle): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    import XmlNode = Stimulsoft.System.Xml.XmlNode;
    import Font = Stimulsoft.System.Drawing.Font;
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    import Color = Stimulsoft.System.Drawing.Color;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    let IStiRadarAxisLabels: System.Interface<IStiRadarAxisLabels>;
    interface IStiRadarAxisLabels extends ICloneable, IStiJsonReportObject {
        core: IStiRadarAxisLabelsCoreXF;
        rotationLabels: boolean;
        allowApplyStyle: boolean;
        drawBorder: boolean;
        textBefore: string;
        textAfter: string;
        format: string;
        font: Font;
        antialiasing: boolean;
        color: Color;
        borderColor: Color;
        brush: StiBrush;
        width: number;
        wordWrap: boolean;
        loadFromXml(xmlNode: XmlNode): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiRadarAxisLabelsCoreXF: System.Interface<IStiRadarAxisLabelsCoreXF>;
    interface IStiRadarAxisLabelsCoreXF extends IStiApplyStyle {
        applyStyle(style: IStiChartStyle): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiXRadarAxis: System.Interface<IStiXRadarAxis>;
    interface IStiXRadarAxis extends IStiRadarAxis {
        xCore: IStiXRadarAxisCoreXF;
        labels: IStiRadarAxisLabels;
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiContext = Stimulsoft.Base.Context.StiContext;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    import PointD = Stimulsoft.System.Drawing.Point;
    let IStiXRadarAxisCoreXF: System.Interface<IStiXRadarAxisCoreXF>;
    interface IStiXRadarAxisCoreXF {
        renderLabel(context: StiContext, series: IStiSeries, point: PointD, argument: any, angle: number, colorIndex: number, colorCount: number): IStiCellGeom;
        getLabelRect(context: StiContext, point: PointD, text: string, angle: number): RectangleD;
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiPenStyle = Stimulsoft.Base.Drawing.StiPenStyle;
    import Color = Stimulsoft.System.Drawing.Color;
    let IStiYRadarAxis: System.Interface<IStiYRadarAxis>;
    interface IStiYRadarAxis extends IStiRadarAxis {
        yCore: IStiYRadarAxisCoreXF;
        labels: IStiAxisLabels;
        ticks: IStiAxisTicks;
        lineStyle: StiPenStyle;
        lineColor: Color;
        lineWidth: number;
        info: IStiAxisInfoXF;
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiContext = Stimulsoft.Base.Context.StiContext;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    import StiFontGeom = Stimulsoft.Base.Context.StiFontGeom;
    import StiStringFormatGeom = Stimulsoft.Base.Context.StiStringFormatGeom;
    let IStiYRadarAxisCoreXF: System.Interface<IStiYRadarAxisCoreXF>;
    interface IStiYRadarAxisCoreXF {
        render(context: StiContext, rect: RectangleD): IStiCellGeom;
        ticksMaxLength: number;
        getFontGeom(context: StiContext): StiFontGeom;
        getStringFormatGeom(context: StiContext): StiStringFormatGeom;
        calculateStripPositions(topPosition: number, bottomPosition: number): any;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiAllowApplyBorderColor: System.Interface<IStiAllowApplyBorderColor>;
    interface IStiAllowApplyBorderColor {
        allowApplyBorderColor: boolean;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiAllowApplyBrush: System.Interface<IStiAllowApplyBrush>;
    interface IStiAllowApplyBrush {
        allowApplyBrush: boolean;
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    let IStiAllowApplyBrushNegative: System.Interface<IStiAllowApplyBrushNegative>;
    interface IStiAllowApplyBrushNegative {
        allowApplyBrushNegative: boolean;
        brushNegative: StiBrush;
    }
}
export namespace Stimulsoft.Report.Chart {
    import Color = Stimulsoft.System.Drawing.Color;
    let IStiAllowApplyColorNegative: System.Interface<IStiAllowApplyColorNegative>;
    interface IStiAllowApplyColorNegative {
        allowApplyColorNegative: boolean;
        lineColorNegative: Color;
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiFontIcons = Stimulsoft.Report.Helpers.StiFontIcons;
    let IStiFontIconsSeries: System.Interface<IStiFontIconsSeries>;
    interface IStiFontIconsSeries {
        icon: StiFontIcons;
    }
}
export namespace Stimulsoft.Report.Chart {
    import IAsIs = Stimulsoft.System.IAsIs;
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    import Color = Stimulsoft.System.Drawing.Color;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    import StiFilterMode = Stimulsoft.Report.Components.StiFilterMode;
    import IStiTrendLinesCollection = Stimulsoft.Report.Chart.IStiTrendLinesCollection;
    let IStiSeries: System.Interface<IStiSeries>;
    interface IStiSeries extends ICloneable, IStiJsonReportObject, IAsIs {
        core: IStiSeriesCoreXF;
        allowApplyStyle: boolean;
        format: string;
        coreTitle: string;
        titleValue: string;
        sortBy: StiSeriesSortType;
        sortDirection: StiSeriesSortDirection;
        showInLegend: boolean;
        showSeriesLabels: StiShowSeriesLabels;
        showShadow: boolean;
        filters: IStiChartFiltersCollection;
        topN: IStiSeriesTopN;
        conditions: IStiChartConditionsCollection;
        yAxis: StiSeriesYAxis;
        seriesLabels: IStiSeriesLabels;
        chart: IStiChart;
        valuesStart: number[];
        values: number[];
        arguments: any[];
        originalArguments: any[];
        toolTips: string[];
        tags: any[];
        hyperlinks: string[];
        interaction: IStiSeriesInteraction;
        argumentDataColumn: string;
        argument: string;
        title: string;
        filterMode: StiFilterMode;
        trendLines: IStiTrendLinesCollection;
        trendLine: IStiTrendLine;
        isTotalLabel: boolean;
        drillDownEnabled: boolean;
        isDashboard: boolean;
        legendColor: Color;
        value: string;
        valueDataColumn: string;
        listOfValues: string;
        listOfArguments: string;
        processSeriesColors(pointIndex: number, seriesColor: Color): Color;
        processSeriesBrushes(pointIndex: number, seriesBrush: StiBrush): StiBrush;
        processSeriesMarkerType(pointIndex: number, markerType: StiMarkerType): StiMarkerType;
        processSeriesMarkerAngle(pointIndex: number, markerAngle: number): number;
        processSeriesMarkerVisible(pointIndex: number): boolean;
        getDefaultAreaType(): Stimulsoft.System.Type;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiSeriesBorderThickness: System.Interface<IStiSeriesBorderThickness>;
    interface IStiSeriesBorderThickness {
        borderThickness: number;
    }
}
export namespace Stimulsoft.Report.Chart {
    import ICollection = Stimulsoft.System.Collections.ICollection;
    import List = Stimulsoft.System.Collections.List;
    let IStiSeriesCollection: System.Interface<IStiSeriesCollection>;
    interface IStiSeriesCollection extends ICollection<IStiSeries>, IStiApplyStyle {
        add(value: IStiSeries): any;
        getByIndex(index: number): IStiSeries;
        insert(index: number, value: IStiSeries): any;
        indexOf(value: IStiSeries): number;
        toList(): List<IStiSeries>;
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiContext = Stimulsoft.Base.Context.StiContext;
    import RectangleD = Stimulsoft.System.Drawing.Rectangle;
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    import Color = Stimulsoft.System.Drawing.Color;
    let IStiSeriesCoreXF: System.Interface<IStiSeriesCoreXF>;
    interface IStiSeriesCoreXF {
        renderSeries(context: StiContext, rect: RectangleD, geom: IStiCellGeom, seriesArray: IStiSeries[]): any;
        getSeriesBrush(colorIndex: number, colorCount: number): StiBrush;
        getSeriesBorderColor(colorIndex: number, colorCount: number): Color;
        getSeriesLabels(): IStiAxisSeriesLabels;
        isDateTimeValues: boolean;
        applyStyle(style: IStiChartStyle, color: Color): any;
        getTag(tagIndex: number): string;
        interaction: IStiSeriesInteraction;
        seriesColors: Color[];
        isDateTimeArguments: boolean;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiShowNullsSeries: System.Interface<IStiShowNullsSeries>;
    interface IStiShowNullsSeries {
        showNulls: boolean;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiShowZerosSeries: System.Interface<IStiShowZerosSeries>;
    interface IStiShowZerosSeries {
        showZeros: boolean;
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    let IStiBoxAndWhiskerSeries: System.Interface<IStiBoxAndWhiskerSeries>;
    interface IStiBoxAndWhiskerSeries extends IStiSeries, IStiAllowApplyBrush, IStiSeriesBorderThickness {
        brush: StiBrush;
        showMeanMarkers: boolean;
        showInnerPoints: boolean;
    }
}
export namespace Stimulsoft.Report.Chart {
    import Color = Stimulsoft.System.Drawing.Color;
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    let IStiBubbleSeries: System.Interface<IStiBubbleSeries>;
    interface IStiBubbleSeries extends IStiScatterSeries, IStiSeriesBorderThickness {
        weights: number[];
        borderColor: Color;
        brush: StiBrush;
        bubbleScale: number;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiClusteredBarSeries: System.Interface<IStiClusteredBarSeries>;
    interface IStiClusteredBarSeries extends IStiClusteredColumnSeries {
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    let IStiAreaSeries: System.Interface<IStiAreaSeries>;
    interface IStiAreaSeries extends IStiLineSeries, IStiAllowApplyBrushNegative {
        topmostLine: boolean;
        brush: StiBrush;
        brushNegative: StiBrush;
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiPenStyle = Stimulsoft.Base.Drawing.StiPenStyle;
    import Color = Stimulsoft.System.Drawing.Color;
    let IStiBaseLineSeries: System.Interface<IStiBaseLineSeries>;
    interface IStiBaseLineSeries extends IStiSeries, IStiAllowApplyColorNegative, IStiShowNullsSeries, IStiShowZerosSeries {
        marker: IStiMarker;
        lineMarker: IStiLineMarker;
        lineColor: Color;
        lineStyle: StiPenStyle;
        lighting: boolean;
        lineWidth: number;
        labelsOffset: number;
        lineColorNegative: Color;
        showNullsAs: StiShowEmptyCellsAs;
        showZerosAs: StiShowEmptyCellsAs;
    }
}
export namespace Stimulsoft.Report.Chart {
    import IStiCornerRadius = Stimulsoft.Report.Components.IStiCornerRadius;
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    import Color = Stimulsoft.System.Drawing.Color;
    let IStiClusteredColumnSeries: System.Interface<IStiClusteredColumnSeries>;
    interface IStiClusteredColumnSeries extends IStiSeries, IStiFontIconsSeries, IStiAllowApplyBrushNegative, IStiSeriesBorderThickness, IStiCornerRadius, IStiShowZerosSeries {
        width: number;
        borderColor: Color;
        brush: StiBrush;
        brushNegative: StiBrush;
        showZeros: boolean;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiHistogramSeries: System.Interface<IStiHistogramSeries>;
    interface IStiHistogramSeries extends IStiClusteredColumnSeries {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiLineSeries: System.Interface<IStiLineSeries>;
    interface IStiLineSeries extends IStiBaseLineSeries {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiParetoSeries: System.Interface<IStiParetoSeries>;
    interface IStiParetoSeries extends IStiClusteredColumnSeries, IStiBaseLineSeries {
        allowApplyLineColor: boolean;
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    let IStiSplineAreaSeries: System.Interface<IStiSplineAreaSeries>;
    interface IStiSplineAreaSeries extends IStiSplineSeries, IStiAllowApplyBrushNegative {
        topmostLine: boolean;
        brush: StiBrush;
        brushNegative: StiBrush;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiSplineSeries: System.Interface<IStiSplineSeries>;
    interface IStiSplineSeries extends IStiBaseLineSeries, IStiAllowApplyColorNegative {
        tension: number;
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    let IStiSteppedAreaSeries: System.Interface<IStiSteppedAreaSeries>;
    interface IStiSteppedAreaSeries extends IStiSteppedLineSeries, IStiAllowApplyBrushNegative {
        topmostLine: boolean;
        brush: StiBrush;
        brushNegative: StiBrush;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiSteppedLineSeries: System.Interface<IStiSteppedLineSeries>;
    interface IStiSteppedLineSeries extends IStiBaseLineSeries, IStiAllowApplyColorNegative {
        pointAtCenter: boolean;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiWaterfallSeries: System.Interface<IStiWaterfallSeries>;
    interface IStiWaterfallSeries extends IStiClusteredColumnSeries {
        connectorLine: IStiWaterfallConnectorLine;
        total: IStiWaterfallTotal;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiDoughnutSeries: System.Interface<IStiDoughnutSeries>;
    interface IStiDoughnutSeries extends IStiPieSeries {
        width: number;
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    import Color = Stimulsoft.System.Drawing.Color;
    let IStiCandlestickSeries: System.Interface<IStiCandlestickSeries>;
    interface IStiCandlestickSeries extends IStiSeries, IStiFinancialSeries {
        borderColor: Color;
        borderColorNegative: Color;
        borderWidth: number;
        brush: StiBrush;
        brushNegative: StiBrush;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiFinancialSeries: System.Interface<IStiFinancialSeries>;
    interface IStiFinancialSeries {
        valuesOpen: number[];
        valuesClose: number[];
        valuesHigh: number[];
        valuesLow: number[];
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiPenStyle = Stimulsoft.Base.Drawing.StiPenStyle;
    import Color = Stimulsoft.System.Drawing.Color;
    let IStiStockSeries: System.Interface<IStiStockSeries>;
    interface IStiStockSeries extends IStiSeries, IStiFinancialSeries, IStiAllowApplyColorNegative {
        lineColor: Color;
        lineStyle: StiPenStyle;
        lineWidth: number;
        lineColorNegative: Color;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiFullStackedBarSeries: System.Interface<IStiFullStackedBarSeries>;
    interface IStiFullStackedBarSeries extends IStiStackedBarSeries {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiFullStackedAreaSeries: System.Interface<IStiFullStackedAreaSeries>;
    interface IStiFullStackedAreaSeries extends IStiStackedAreaSeries {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiFullStackedColumnSeries: System.Interface<IStiFullStackedColumnSeries>;
    interface IStiFullStackedColumnSeries extends IStiStackedColumnSeries {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiFullStackedLineSeries: System.Interface<IStiFullStackedLineSeries>;
    interface IStiFullStackedLineSeries extends IStiStackedLineSeries {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiFullStackedSplineAreaSeries: System.Interface<IStiFullStackedSplineAreaSeries>;
    interface IStiFullStackedSplineAreaSeries extends IStiStackedSplineAreaSeries {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiFullStackedSplineSeries: System.Interface<IStiFullStackedSplineSeries>;
    interface IStiFullStackedSplineSeries extends IStiStackedSplineSeries {
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    import Color = Stimulsoft.System.Drawing.Color;
    let IStiFunnelSeries: System.Interface<IStiFunnelSeries>;
    interface IStiFunnelSeries extends IStiSeries, IStiFontIconsSeries, IStiSeriesBorderThickness, IStiShowZerosSeries {
        showZeros: boolean;
        allowApplyBrush: boolean;
        allowApplyBorderColor: boolean;
        borderColor: Color;
        brush: StiBrush;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiFunnelWeightedSlicesSeries: System.Interface<IStiFunnelWeightedSlicesSeries>;
    interface IStiFunnelWeightedSlicesSeries extends IStiFunnelSeries {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiGanttSeries: System.Interface<IStiGanttSeries>;
    interface IStiGanttSeries extends IStiClusteredBarSeries, IStiRangeSeries {
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    let IStiPictorialSeries: System.Interface<IStiPictorialSeries>;
    interface IStiPictorialSeries extends IStiSeries, IStiFontIconsSeries {
        brush: StiBrush;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiPictorialStackedSeries: System.Interface<IStiPictorialStackedSeries>;
    interface IStiPictorialStackedSeries extends IStiSeries, IStiFontIconsSeries {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiPie3dSeries: System.Interface<IStiPie3dSeries>;
    interface IStiPie3dSeries extends IStiPieSeries {
        options3D: IStiPie3dOptions;
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    import Color = Stimulsoft.System.Drawing.Color;
    let IStiPieSeries: System.Interface<IStiPieSeries>;
    interface IStiPieSeries extends IStiSeries, IStiFontIconsSeries, IStiAllowApplyBorderColor, IStiSeriesBorderThickness, IStiAllowApplyBrush, IStiShowZerosSeries {
        startAngle: number;
        borderColor: Color;
        brush: StiBrush;
        lighting: boolean;
        diameter: number;
        distance: number;
        cutPieListValues: number[];
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    let IStiRadarAreaSeries: System.Interface<IStiRadarAreaSeries>;
    interface IStiRadarAreaSeries extends IStiRadarLineSeries {
        brush: StiBrush;
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiPenStyle = Stimulsoft.Base.Drawing.StiPenStyle;
    import Color = Stimulsoft.System.Drawing.Color;
    let IStiRadarLineSeries: System.Interface<IStiRadarLineSeries>;
    interface IStiRadarLineSeries extends IStiRadarSeries {
        lineColor: Color;
        lineStyle: StiPenStyle;
        lighting: boolean;
        lineWidth: number;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiRadarPointSeries: System.Interface<IStiRadarPointSeries>;
    interface IStiRadarPointSeries extends IStiRadarSeries {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiRadarSeries: System.Interface<IStiRadarSeries>;
    interface IStiRadarSeries extends IStiSeries, IStiShowNullsSeries {
        marker: IStiMarker;
        showNulls: boolean;
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    let IStiLineRangeSeries: System.Interface<IStiLineRangeSeries>;
    interface IStiLineRangeSeries extends IStiLineSeries, IStiRangeSeries, IStiAllowApplyBrushNegative {
        brush: StiBrush;
        brushNegative: StiBrush;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiRangeBarSeries: System.Interface<IStiRangeBarSeries>;
    interface IStiRangeBarSeries extends IStiClusteredColumnSeries, IStiRangeSeries {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiRangeSeries: System.Interface<IStiRangeSeries>;
    interface IStiRangeSeries {
        valuesEnd: number[];
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    let IStiSplineRangeSeries: System.Interface<IStiSplineRangeSeries>;
    interface IStiSplineRangeSeries extends IStiSplineSeries, IStiRangeSeries {
        brush: StiBrush;
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    let IStiSteppedRangeSeries: System.Interface<IStiSteppedRangeSeries>;
    interface IStiSteppedRangeSeries extends IStiSteppedLineSeries, IStiRangeSeries, IStiAllowApplyBrushNegative {
        brush: StiBrush;
        brushNegative: StiBrush;
        allowApplyBrushNegative: boolean;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiScatterLineSeries: System.Interface<IStiScatterLineSeries>;
    interface IStiScatterLineSeries extends IStiScatterSeries {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiScatterSeries: System.Interface<IStiScatterSeries>;
    interface IStiScatterSeries extends IStiBaseLineSeries {
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiScatterSplineSeries: System.Interface<IStiScatterSplineSeries>;
    interface IStiScatterSplineSeries extends IStiScatterLineSeries {
        tension: number;
    }
}
export namespace Stimulsoft.Report.Chart {
    import IStiCornerRadius = Stimulsoft.Report.Components.IStiCornerRadius;
    import Color = Stimulsoft.System.Drawing.Color;
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    let IStiStackedBarSeries: System.Interface<IStiStackedBarSeries>;
    interface IStiStackedBarSeries extends IStiSeries, IStiFontIconsSeries, IStiSeriesBorderThickness, IStiAllowApplyBrushNegative, IStiShowZerosSeries, IStiCornerRadius {
        width: number;
        borderColor: Color;
        brush: StiBrush;
        showZeros: boolean;
        brushNegative: StiBrush;
        allowApplyBrushNegative: boolean;
    }
}
export namespace Stimulsoft.Report.Chart {
    import Color = Stimulsoft.System.Drawing.Color;
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    import IStiCornerRadius = Stimulsoft.Report.Components.IStiCornerRadius;
    let IStiRibbonSeries: System.Interface<IStiRibbonSeries>;
    interface IStiRibbonSeries extends IStiSeries, IStiSeriesBorderThickness, IStiCornerRadius {
        width: number;
        borderColor: Color;
        brush: StiBrush;
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    let IStiStackedAreaSeries: System.Interface<IStiStackedAreaSeries>;
    interface IStiStackedAreaSeries extends IStiStackedLineSeries, IStiAllowApplyBrushNegative {
        brush: StiBrush;
        brushNegative: StiBrush;
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiPenStyle = Stimulsoft.Base.Drawing.StiPenStyle;
    import Color = Stimulsoft.System.Drawing.Color;
    let IStiStackedBaseLineSeries: System.Interface<IStiStackedBaseLineSeries>;
    interface IStiStackedBaseLineSeries extends IStiSeries, IStiShowNullsSeries {
        marker: IStiMarker;
        lineMarker: IStiLineMarker;
        lighting: boolean;
        lineColor: Color;
        lineWidth: number;
        lineStyle: StiPenStyle;
        showNulls: boolean;
    }
}
export namespace Stimulsoft.Report.Chart {
    import IStiCornerRadius = Stimulsoft.Report.Components.IStiCornerRadius;
    import Color = Stimulsoft.System.Drawing.Color;
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    let IStiStackedColumnSeries: System.Interface<IStiStackedColumnSeries>;
    interface IStiStackedColumnSeries extends IStiSeries, IStiFontIconsSeries, IStiSeriesBorderThickness, IStiAllowApplyBrushNegative, IStiShowZerosSeries, IStiCornerRadius {
        width: number;
        borderColor: Color;
        brush: StiBrush;
        showZeros: boolean;
        brushNegative: StiBrush;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiStackedLineSeries: System.Interface<IStiStackedLineSeries>;
    interface IStiStackedLineSeries extends IStiStackedBaseLineSeries {
    }
}
export namespace Stimulsoft.Report.Chart {
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    let IStiStackedSplineAreaSeries: System.Interface<IStiStackedSplineAreaSeries>;
    interface IStiStackedSplineAreaSeries extends IStiStackedSplineSeries, IStiAllowApplyBrushNegative {
        brush: StiBrush;
        brushNegative: StiBrush;
    }
}
export namespace Stimulsoft.Report.Chart {
    import Color = Stimulsoft.System.Drawing.Color;
    let IStiStackedSplineSeries: System.Interface<IStiStackedSplineSeries>;
    interface IStiStackedSplineSeries extends IStiStackedBaseLineSeries, IStiAllowApplyColorNegative {
        tension: number;
        lineColorNegative: Color;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiSunburstSeries: System.Interface<IStiSunburstSeries>;
    interface IStiSunburstSeries extends IStiSeries, IStiSeriesBorderThickness {
    }
}
export namespace Stimulsoft.Report.Chart {
    import IStiCornerRadius = Stimulsoft.Report.Components.IStiCornerRadius;
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    import Color = Stimulsoft.System.Drawing.Color;
    let IStiTreemapSeries: System.Interface<IStiTreemapSeries>;
    interface IStiTreemapSeries extends IStiSeries, IStiSeriesBorderThickness, IStiFontIconsSeries, IStiCornerRadius {
        borderColor: Color;
        brush: StiBrush;
    }
}
export namespace Stimulsoft.Report.Chart {
    let IStiNoneLabels: System.Interface<IStiNoneLabels>;
    interface IStiNoneLabels extends IStiSeriesLabels {
    }
}
export namespace Stimulsoft.Report.Chart {
    import IAsIs = Stimulsoft.System.IAsIs;
    import SizeD = Stimulsoft.System.Drawing.Size;
    import Font = Stimulsoft.System.Drawing.Font;
    import StiBrush = Stimulsoft.Base.Drawing.StiBrush;
    import Color = Stimulsoft.System.Drawing.Color;
    import StiFormatService = Stimulsoft.Report.Components.TextFormats.StiFormatService;
    import ICloneable = Stimulsoft.System.ICloneable;
    import IStiJsonReportObject = Stimulsoft.Base.JsonReportObject.IStiJsonReportObject;
    let IStiSeriesLabels: System.Interface<IStiSeriesLabels>;
    interface IStiSeriesLabels extends ICloneable, IStiJsonReportObject, IAsIs {
        allowApplyStyle: boolean;
        showZeros: boolean;
        showNulls: boolean;
        markerVisible: boolean;
        step: number;
        valueTypeSeparator: string;
        textBefore: string;
        textAfter: string;
        angle: number;
        format: string;
        antialiasing: boolean;
        visible: boolean;
        drawBorder: boolean;
        useSeriesColor: boolean;
        markerAlignment: StiMarkerAlignment;
        valu